// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/cloudsetup/logging/v1/complete_deployment.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of the completed deployment.
type CompleteDeploymentEvent_State int32

const (
	// The zero value. It is applied when `state` is unset. Do not use.
	CompleteDeploymentEvent_STATE_UNSPECIFIED CompleteDeploymentEvent_State = 0
	// Indicates that a Deployment value was present when the config deployment
	// finished and the State was anything other than FAILED.
	CompleteDeploymentEvent_SUCCEEDED CompleteDeploymentEvent_State = 1
	// Indicates that the Operation result was an error or the Deployment
	// `state` was FAILED.
	CompleteDeploymentEvent_FAILED CompleteDeploymentEvent_State = 2
)

// Enum value maps for CompleteDeploymentEvent_State.
var (
	CompleteDeploymentEvent_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
	}
	CompleteDeploymentEvent_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
	}
)

func (x CompleteDeploymentEvent_State) Enum() *CompleteDeploymentEvent_State {
	p := new(CompleteDeploymentEvent_State)
	*p = x
	return p
}

func (x CompleteDeploymentEvent_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompleteDeploymentEvent_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_enumTypes[0].Descriptor()
}

func (CompleteDeploymentEvent_State) Type() protoreflect.EnumType {
	return &file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_enumTypes[0]
}

func (x CompleteDeploymentEvent_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompleteDeploymentEvent_State.Descriptor instead.
func (CompleteDeploymentEvent_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescGZIP(), []int{0, 0}
}

// JSON payload for the Cloud Logging event:
// `organizations/[organizationId]/logs/cloudsetup.googleapis.com%2Fcomplete_deployment`.
// This event gets emitted upon completion of a config deployment as part of the
// Cloud Setup Checklist.
//
// The deployment can fail even if it returns a
// `config.googleapis.com/Deployment`. The state of that message will be
// `FAILED`. Hence, if there is a `value` present, the `state` can still be,
// `FAILED`. The message for the error or failure will be on the `error` or the
// `value` if the Operation results in an error or if the `state` of the
// Deployment is `FAILED`, respectively.
type CompleteDeploymentEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Result:
	//	*CompleteDeploymentEvent_Value
	//	*CompleteDeploymentEvent_Error
	Result isCompleteDeploymentEvent_Result `protobuf_oneof:"result"`
	// The `state` of this deployment completion event.
	State CompleteDeploymentEvent_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.cloudsetup.logging.v1.CompleteDeploymentEvent_State" json:"state,omitempty"`
	// Flag to indicate if deployment is preview only.
	PreviewOnly bool `protobuf:"varint,4,opt,name=preview_only,json=previewOnly,proto3" json:"preview_only,omitempty"`
}

func (x *CompleteDeploymentEvent) Reset() {
	*x = CompleteDeploymentEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompleteDeploymentEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteDeploymentEvent) ProtoMessage() {}

func (x *CompleteDeploymentEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteDeploymentEvent.ProtoReflect.Descriptor instead.
func (*CompleteDeploymentEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescGZIP(), []int{0}
}

func (m *CompleteDeploymentEvent) GetResult() isCompleteDeploymentEvent_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *CompleteDeploymentEvent) GetValue() *CompleteDeploymentResult {
	if x, ok := x.GetResult().(*CompleteDeploymentEvent_Value); ok {
		return x.Value
	}
	return nil
}

func (x *CompleteDeploymentEvent) GetError() *status.Status {
	if x, ok := x.GetResult().(*CompleteDeploymentEvent_Error); ok {
		return x.Error
	}
	return nil
}

func (x *CompleteDeploymentEvent) GetState() CompleteDeploymentEvent_State {
	if x != nil {
		return x.State
	}
	return CompleteDeploymentEvent_STATE_UNSPECIFIED
}

func (x *CompleteDeploymentEvent) GetPreviewOnly() bool {
	if x != nil {
		return x.PreviewOnly
	}
	return false
}

type isCompleteDeploymentEvent_Result interface {
	isCompleteDeploymentEvent_Result()
}

type CompleteDeploymentEvent_Value struct {
	// Result of the Deployment recorded upon completion.
	Value *CompleteDeploymentResult `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

type CompleteDeploymentEvent_Error struct {
	// Result of the Deployment if the `Operation` results in an error.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3,oneof"`
}

func (*CompleteDeploymentEvent_Value) isCompleteDeploymentEvent_Result() {}

func (*CompleteDeploymentEvent_Error) isCompleteDeploymentEvent_Result() {}

// This message is used when the CompleteDeploymentEvent has a value.
type CompleteDeploymentResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is the Deployment that completed.
	// Format is projects/{project}/locations/{location}/deployments/{name}.
	Deployment string `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// This is the Preview that completed.
	// Format is projects/{project}/locations/{location}/previews/{preview}
	Preview string `protobuf:"bytes,3,opt,name=preview,proto3" json:"preview,omitempty"`
	// The message that is returned when a deployment completes. This **can** be
	// an error message if the `Deployment` `state` is `FAILED`.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *CompleteDeploymentResult) Reset() {
	*x = CompleteDeploymentResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompleteDeploymentResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteDeploymentResult) ProtoMessage() {}

func (x *CompleteDeploymentResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteDeploymentResult.ProtoReflect.Descriptor instead.
func (*CompleteDeploymentResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescGZIP(), []int{1}
}

func (x *CompleteDeploymentResult) GetDeployment() string {
	if x != nil {
		return x.Deployment
	}
	return ""
}

func (x *CompleteDeploymentResult) GetPreview() string {
	if x != nil {
		return x.Preview
	}
	return ""
}

func (x *CompleteDeploymentResult) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_google_cloud_cloudsetup_logging_v1_complete_deployment_proto protoreflect.FileDescriptor

var file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x73, 0x65, 0x74, 0x75, 0x70, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x73, 0x65, 0x74, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdc, 0x02, 0x0a, 0x17, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x54, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x65, 0x74, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48,
	0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x57, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x65, 0x74, 0x75, 0x70, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4f, 0x6e, 0x6c, 0x79,
	0x22, 0x39, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xb9, 0x01, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x45, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x07, 0x70, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x07,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x42, 0x81, 0x02, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x65, 0x74, 0x75,
	0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x17, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x65, 0x74, 0x75, 0x70, 0x2f,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x65, 0x74, 0x75, 0x70, 0x2e, 0x4c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x65, 0x74, 0x75,
	0x70, 0x5c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x65, 0x74, 0x75, 0x70, 0x3a, 0x3a, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescOnce sync.Once
	file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescData = file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDesc
)

func file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescGZIP() []byte {
	file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescOnce.Do(func() {
		file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescData)
	})
	return file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDescData
}

var file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_goTypes = []interface{}{
	(CompleteDeploymentEvent_State)(0), // 0: google.cloud.cloudsetup.logging.v1.CompleteDeploymentEvent.State
	(*CompleteDeploymentEvent)(nil),    // 1: google.cloud.cloudsetup.logging.v1.CompleteDeploymentEvent
	(*CompleteDeploymentResult)(nil),   // 2: google.cloud.cloudsetup.logging.v1.CompleteDeploymentResult
	(*status.Status)(nil),              // 3: google.rpc.Status
}
var file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_depIdxs = []int32{
	2, // 0: google.cloud.cloudsetup.logging.v1.CompleteDeploymentEvent.value:type_name -> google.cloud.cloudsetup.logging.v1.CompleteDeploymentResult
	3, // 1: google.cloud.cloudsetup.logging.v1.CompleteDeploymentEvent.error:type_name -> google.rpc.Status
	0, // 2: google.cloud.cloudsetup.logging.v1.CompleteDeploymentEvent.state:type_name -> google.cloud.cloudsetup.logging.v1.CompleteDeploymentEvent.State
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_init() }
func file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_init() {
	if File_google_cloud_cloudsetup_logging_v1_complete_deployment_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompleteDeploymentEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompleteDeploymentResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*CompleteDeploymentEvent_Value)(nil),
		(*CompleteDeploymentEvent_Error)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_goTypes,
		DependencyIndexes: file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_depIdxs,
		EnumInfos:         file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_enumTypes,
		MessageInfos:      file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_msgTypes,
	}.Build()
	File_google_cloud_cloudsetup_logging_v1_complete_deployment_proto = out.File
	file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_rawDesc = nil
	file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_goTypes = nil
	file_google_cloud_cloudsetup_logging_v1_complete_deployment_proto_depIdxs = nil
}
