--
--  Copyright (C) 2022-2023, AdaCore
--
--  SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
--

pragma Ada_2022;
pragma Style_Checks ("M131");

--  This package contains data from index-gb18030.txt file
--
--  # Identifier: 715f084846f5c6fc9dd31046d0a4d604bd2d88bfe3a22833cea048415e413c70
--  # Date: 2018-01-06
--
--  see the Encoding Standard
--
--  https://encoding.spec.whatwg.org/

with Interfaces;

private package VSS.Strings.Converters.Decoders.GB18030.Indices is

   --  This table provides mapping from the internal pointer value to the code
   --  point of the Unicode character. All code points is in 16bit range, so
   --  Interfaces.Unsigned_16 type is used to make the table smaller.

   Table : constant
     array (Interfaces.Unsigned_32 range 0 .. 23939)
       of Interfaces.Unsigned_16 :=
         [0     => 16#4E02#,   --  丂 (<CJK Ideograph>)
          1     => 16#4E04#,   --  丄 (<CJK Ideograph>)
          2     => 16#4E05#,   --  丅 (<CJK Ideograph>)
          3     => 16#4E06#,   --  丆 (<CJK Ideograph>)
          4     => 16#4E0F#,   --  丏 (<CJK Ideograph>)
          5     => 16#4E12#,   --  丒 (<CJK Ideograph>)
          6     => 16#4E17#,   --  丗 (<CJK Ideograph>)
          7     => 16#4E1F#,   --  丟 (<CJK Ideograph>)
          8     => 16#4E20#,   --  丠 (<CJK Ideograph>)
          9     => 16#4E21#,   --  両 (<CJK Ideograph>)
          10    => 16#4E23#,   --  丣 (<CJK Ideograph>)
          11    => 16#4E26#,   --  並 (<CJK Ideograph>)
          12    => 16#4E29#,   --  丩 (<CJK Ideograph>)
          13    => 16#4E2E#,   --  丮 (<CJK Ideograph>)
          14    => 16#4E2F#,   --  丯 (<CJK Ideograph>)
          15    => 16#4E31#,   --  丱 (<CJK Ideograph>)
          16    => 16#4E33#,   --  丳 (<CJK Ideograph>)
          17    => 16#4E35#,   --  丵 (<CJK Ideograph>)
          18    => 16#4E37#,   --  丷 (<CJK Ideograph>)
          19    => 16#4E3C#,   --  丼 (<CJK Ideograph>)
          20    => 16#4E40#,   --  乀 (<CJK Ideograph>)
          21    => 16#4E41#,   --  乁 (<CJK Ideograph>)
          22    => 16#4E42#,   --  乂 (<CJK Ideograph>)
          23    => 16#4E44#,   --  乄 (<CJK Ideograph>)
          24    => 16#4E46#,   --  乆 (<CJK Ideograph>)
          25    => 16#4E4A#,   --  乊 (<CJK Ideograph>)
          26    => 16#4E51#,   --  乑 (<CJK Ideograph>)
          27    => 16#4E55#,   --  乕 (<CJK Ideograph>)
          28    => 16#4E57#,   --  乗 (<CJK Ideograph>)
          29    => 16#4E5A#,   --  乚 (<CJK Ideograph>)
          30    => 16#4E5B#,   --  乛 (<CJK Ideograph>)
          31    => 16#4E62#,   --  乢 (<CJK Ideograph>)
          32    => 16#4E63#,   --  乣 (<CJK Ideograph>)
          33    => 16#4E64#,   --  乤 (<CJK Ideograph>)
          34    => 16#4E65#,   --  乥 (<CJK Ideograph>)
          35    => 16#4E67#,   --  乧 (<CJK Ideograph>)
          36    => 16#4E68#,   --  乨 (<CJK Ideograph>)
          37    => 16#4E6A#,   --  乪 (<CJK Ideograph>)
          38    => 16#4E6B#,   --  乫 (<CJK Ideograph>)
          39    => 16#4E6C#,   --  乬 (<CJK Ideograph>)
          40    => 16#4E6D#,   --  乭 (<CJK Ideograph>)
          41    => 16#4E6E#,   --  乮 (<CJK Ideograph>)
          42    => 16#4E6F#,   --  乯 (<CJK Ideograph>)
          43    => 16#4E72#,   --  乲 (<CJK Ideograph>)
          44    => 16#4E74#,   --  乴 (<CJK Ideograph>)
          45    => 16#4E75#,   --  乵 (<CJK Ideograph>)
          46    => 16#4E76#,   --  乶 (<CJK Ideograph>)
          47    => 16#4E77#,   --  乷 (<CJK Ideograph>)
          48    => 16#4E78#,   --  乸 (<CJK Ideograph>)
          49    => 16#4E79#,   --  乹 (<CJK Ideograph>)
          50    => 16#4E7A#,   --  乺 (<CJK Ideograph>)
          51    => 16#4E7B#,   --  乻 (<CJK Ideograph>)
          52    => 16#4E7C#,   --  乼 (<CJK Ideograph>)
          53    => 16#4E7D#,   --  乽 (<CJK Ideograph>)
          54    => 16#4E7F#,   --  乿 (<CJK Ideograph>)
          55    => 16#4E80#,   --  亀 (<CJK Ideograph>)
          56    => 16#4E81#,   --  亁 (<CJK Ideograph>)
          57    => 16#4E82#,   --  亂 (<CJK Ideograph>)
          58    => 16#4E83#,   --  亃 (<CJK Ideograph>)
          59    => 16#4E84#,   --  亄 (<CJK Ideograph>)
          60    => 16#4E85#,   --  亅 (<CJK Ideograph>)
          61    => 16#4E87#,   --  亇 (<CJK Ideograph>)
          62    => 16#4E8A#,   --  亊 (<CJK Ideograph>)
          63    => 16#4E90#,   --  亐 (<CJK Ideograph>)
          64    => 16#4E96#,   --  亖 (<CJK Ideograph>)
          65    => 16#4E97#,   --  亗 (<CJK Ideograph>)
          66    => 16#4E99#,   --  亙 (<CJK Ideograph>)
          67    => 16#4E9C#,   --  亜 (<CJK Ideograph>)
          68    => 16#4E9D#,   --  亝 (<CJK Ideograph>)
          69    => 16#4E9E#,   --  亞 (<CJK Ideograph>)
          70    => 16#4EA3#,   --  亣 (<CJK Ideograph>)
          71    => 16#4EAA#,   --  亪 (<CJK Ideograph>)
          72    => 16#4EAF#,   --  亯 (<CJK Ideograph>)
          73    => 16#4EB0#,   --  亰 (<CJK Ideograph>)
          74    => 16#4EB1#,   --  亱 (<CJK Ideograph>)
          75    => 16#4EB4#,   --  亴 (<CJK Ideograph>)
          76    => 16#4EB6#,   --  亶 (<CJK Ideograph>)
          77    => 16#4EB7#,   --  亷 (<CJK Ideograph>)
          78    => 16#4EB8#,   --  亸 (<CJK Ideograph>)
          79    => 16#4EB9#,   --  亹 (<CJK Ideograph>)
          80    => 16#4EBC#,   --  亼 (<CJK Ideograph>)
          81    => 16#4EBD#,   --  亽 (<CJK Ideograph>)
          82    => 16#4EBE#,   --  亾 (<CJK Ideograph>)
          83    => 16#4EC8#,   --  仈 (<CJK Ideograph>)
          84    => 16#4ECC#,   --  仌 (<CJK Ideograph>)
          85    => 16#4ECF#,   --  仏 (<CJK Ideograph>)
          86    => 16#4ED0#,   --  仐 (<CJK Ideograph>)
          87    => 16#4ED2#,   --  仒 (<CJK Ideograph>)
          88    => 16#4EDA#,   --  仚 (<CJK Ideograph>)
          89    => 16#4EDB#,   --  仛 (<CJK Ideograph>)
          90    => 16#4EDC#,   --  仜 (<CJK Ideograph>)
          91    => 16#4EE0#,   --  仠 (<CJK Ideograph>)
          92    => 16#4EE2#,   --  仢 (<CJK Ideograph>)
          93    => 16#4EE6#,   --  仦 (<CJK Ideograph>)
          94    => 16#4EE7#,   --  仧 (<CJK Ideograph>)
          95    => 16#4EE9#,   --  仩 (<CJK Ideograph>)
          96    => 16#4EED#,   --  仭 (<CJK Ideograph>)
          97    => 16#4EEE#,   --  仮 (<CJK Ideograph>)
          98    => 16#4EEF#,   --  仯 (<CJK Ideograph>)
          99    => 16#4EF1#,   --  仱 (<CJK Ideograph>)
          100   => 16#4EF4#,   --  仴 (<CJK Ideograph>)
          101   => 16#4EF8#,   --  仸 (<CJK Ideograph>)
          102   => 16#4EF9#,   --  仹 (<CJK Ideograph>)
          103   => 16#4EFA#,   --  仺 (<CJK Ideograph>)
          104   => 16#4EFC#,   --  仼 (<CJK Ideograph>)
          105   => 16#4EFE#,   --  仾 (<CJK Ideograph>)
          106   => 16#4F00#,   --  伀 (<CJK Ideograph>)
          107   => 16#4F02#,   --  伂 (<CJK Ideograph>)
          108   => 16#4F03#,   --  伃 (<CJK Ideograph>)
          109   => 16#4F04#,   --  伄 (<CJK Ideograph>)
          110   => 16#4F05#,   --  伅 (<CJK Ideograph>)
          111   => 16#4F06#,   --  伆 (<CJK Ideograph>)
          112   => 16#4F07#,   --  伇 (<CJK Ideograph>)
          113   => 16#4F08#,   --  伈 (<CJK Ideograph>)
          114   => 16#4F0B#,   --  伋 (<CJK Ideograph>)
          115   => 16#4F0C#,   --  伌 (<CJK Ideograph>)
          116   => 16#4F12#,   --  伒 (<CJK Ideograph>)
          117   => 16#4F13#,   --  伓 (<CJK Ideograph>)
          118   => 16#4F14#,   --  伔 (<CJK Ideograph>)
          119   => 16#4F15#,   --  伕 (<CJK Ideograph>)
          120   => 16#4F16#,   --  伖 (<CJK Ideograph>)
          121   => 16#4F1C#,   --  伜 (<CJK Ideograph>)
          122   => 16#4F1D#,   --  伝 (<CJK Ideograph>)
          123   => 16#4F21#,   --  伡 (<CJK Ideograph>)
          124   => 16#4F23#,   --  伣 (<CJK Ideograph>)
          125   => 16#4F28#,   --  伨 (<CJK Ideograph>)
          126   => 16#4F29#,   --  伩 (<CJK Ideograph>)
          127   => 16#4F2C#,   --  伬 (<CJK Ideograph>)
          128   => 16#4F2D#,   --  伭 (<CJK Ideograph>)
          129   => 16#4F2E#,   --  伮 (<CJK Ideograph>)
          130   => 16#4F31#,   --  伱 (<CJK Ideograph>)
          131   => 16#4F33#,   --  伳 (<CJK Ideograph>)
          132   => 16#4F35#,   --  伵 (<CJK Ideograph>)
          133   => 16#4F37#,   --  伷 (<CJK Ideograph>)
          134   => 16#4F39#,   --  伹 (<CJK Ideograph>)
          135   => 16#4F3B#,   --  伻 (<CJK Ideograph>)
          136   => 16#4F3E#,   --  伾 (<CJK Ideograph>)
          137   => 16#4F3F#,   --  伿 (<CJK Ideograph>)
          138   => 16#4F40#,   --  佀 (<CJK Ideograph>)
          139   => 16#4F41#,   --  佁 (<CJK Ideograph>)
          140   => 16#4F42#,   --  佂 (<CJK Ideograph>)
          141   => 16#4F44#,   --  佄 (<CJK Ideograph>)
          142   => 16#4F45#,   --  佅 (<CJK Ideograph>)
          143   => 16#4F47#,   --  佇 (<CJK Ideograph>)
          144   => 16#4F48#,   --  佈 (<CJK Ideograph>)
          145   => 16#4F49#,   --  佉 (<CJK Ideograph>)
          146   => 16#4F4A#,   --  佊 (<CJK Ideograph>)
          147   => 16#4F4B#,   --  佋 (<CJK Ideograph>)
          148   => 16#4F4C#,   --  佌 (<CJK Ideograph>)
          149   => 16#4F52#,   --  佒 (<CJK Ideograph>)
          150   => 16#4F54#,   --  佔 (<CJK Ideograph>)
          151   => 16#4F56#,   --  佖 (<CJK Ideograph>)
          152   => 16#4F61#,   --  佡 (<CJK Ideograph>)
          153   => 16#4F62#,   --  佢 (<CJK Ideograph>)
          154   => 16#4F66#,   --  佦 (<CJK Ideograph>)
          155   => 16#4F68#,   --  佨 (<CJK Ideograph>)
          156   => 16#4F6A#,   --  佪 (<CJK Ideograph>)
          157   => 16#4F6B#,   --  佫 (<CJK Ideograph>)
          158   => 16#4F6D#,   --  佭 (<CJK Ideograph>)
          159   => 16#4F6E#,   --  佮 (<CJK Ideograph>)
          160   => 16#4F71#,   --  佱 (<CJK Ideograph>)
          161   => 16#4F72#,   --  佲 (<CJK Ideograph>)
          162   => 16#4F75#,   --  併 (<CJK Ideograph>)
          163   => 16#4F77#,   --  佷 (<CJK Ideograph>)
          164   => 16#4F78#,   --  佸 (<CJK Ideograph>)
          165   => 16#4F79#,   --  佹 (<CJK Ideograph>)
          166   => 16#4F7A#,   --  佺 (<CJK Ideograph>)
          167   => 16#4F7D#,   --  佽 (<CJK Ideograph>)
          168   => 16#4F80#,   --  侀 (<CJK Ideograph>)
          169   => 16#4F81#,   --  侁 (<CJK Ideograph>)
          170   => 16#4F82#,   --  侂 (<CJK Ideograph>)
          171   => 16#4F85#,   --  侅 (<CJK Ideograph>)
          172   => 16#4F86#,   --  來 (<CJK Ideograph>)
          173   => 16#4F87#,   --  侇 (<CJK Ideograph>)
          174   => 16#4F8A#,   --  侊 (<CJK Ideograph>)
          175   => 16#4F8C#,   --  侌 (<CJK Ideograph>)
          176   => 16#4F8E#,   --  侎 (<CJK Ideograph>)
          177   => 16#4F90#,   --  侐 (<CJK Ideograph>)
          178   => 16#4F92#,   --  侒 (<CJK Ideograph>)
          179   => 16#4F93#,   --  侓 (<CJK Ideograph>)
          180   => 16#4F95#,   --  侕 (<CJK Ideograph>)
          181   => 16#4F96#,   --  侖 (<CJK Ideograph>)
          182   => 16#4F98#,   --  侘 (<CJK Ideograph>)
          183   => 16#4F99#,   --  侙 (<CJK Ideograph>)
          184   => 16#4F9A#,   --  侚 (<CJK Ideograph>)
          185   => 16#4F9C#,   --  侜 (<CJK Ideograph>)
          186   => 16#4F9E#,   --  侞 (<CJK Ideograph>)
          187   => 16#4F9F#,   --  侟 (<CJK Ideograph>)
          188   => 16#4FA1#,   --  価 (<CJK Ideograph>)
          189   => 16#4FA2#,   --  侢 (<CJK Ideograph>)
          190   => 16#4FA4#,   --  侤 (<CJK Ideograph>)
          191   => 16#4FAB#,   --  侫 (<CJK Ideograph>)
          192   => 16#4FAD#,   --  侭 (<CJK Ideograph>)
          193   => 16#4FB0#,   --  侰 (<CJK Ideograph>)
          194   => 16#4FB1#,   --  侱 (<CJK Ideograph>)
          195   => 16#4FB2#,   --  侲 (<CJK Ideograph>)
          196   => 16#4FB3#,   --  侳 (<CJK Ideograph>)
          197   => 16#4FB4#,   --  侴 (<CJK Ideograph>)
          198   => 16#4FB6#,   --  侶 (<CJK Ideograph>)
          199   => 16#4FB7#,   --  侷 (<CJK Ideograph>)
          200   => 16#4FB8#,   --  侸 (<CJK Ideograph>)
          201   => 16#4FB9#,   --  侹 (<CJK Ideograph>)
          202   => 16#4FBA#,   --  侺 (<CJK Ideograph>)
          203   => 16#4FBB#,   --  侻 (<CJK Ideograph>)
          204   => 16#4FBC#,   --  侼 (<CJK Ideograph>)
          205   => 16#4FBD#,   --  侽 (<CJK Ideograph>)
          206   => 16#4FBE#,   --  侾 (<CJK Ideograph>)
          207   => 16#4FC0#,   --  俀 (<CJK Ideograph>)
          208   => 16#4FC1#,   --  俁 (<CJK Ideograph>)
          209   => 16#4FC2#,   --  係 (<CJK Ideograph>)
          210   => 16#4FC6#,   --  俆 (<CJK Ideograph>)
          211   => 16#4FC7#,   --  俇 (<CJK Ideograph>)
          212   => 16#4FC8#,   --  俈 (<CJK Ideograph>)
          213   => 16#4FC9#,   --  俉 (<CJK Ideograph>)
          214   => 16#4FCB#,   --  俋 (<CJK Ideograph>)
          215   => 16#4FCC#,   --  俌 (<CJK Ideograph>)
          216   => 16#4FCD#,   --  俍 (<CJK Ideograph>)
          217   => 16#4FD2#,   --  俒 (<CJK Ideograph>)
          218   => 16#4FD3#,   --  俓 (<CJK Ideograph>)
          219   => 16#4FD4#,   --  俔 (<CJK Ideograph>)
          220   => 16#4FD5#,   --  俕 (<CJK Ideograph>)
          221   => 16#4FD6#,   --  俖 (<CJK Ideograph>)
          222   => 16#4FD9#,   --  俙 (<CJK Ideograph>)
          223   => 16#4FDB#,   --  俛 (<CJK Ideograph>)
          224   => 16#4FE0#,   --  俠 (<CJK Ideograph>)
          225   => 16#4FE2#,   --  俢 (<CJK Ideograph>)
          226   => 16#4FE4#,   --  俤 (<CJK Ideograph>)
          227   => 16#4FE5#,   --  俥 (<CJK Ideograph>)
          228   => 16#4FE7#,   --  俧 (<CJK Ideograph>)
          229   => 16#4FEB#,   --  俫 (<CJK Ideograph>)
          230   => 16#4FEC#,   --  俬 (<CJK Ideograph>)
          231   => 16#4FF0#,   --  俰 (<CJK Ideograph>)
          232   => 16#4FF2#,   --  俲 (<CJK Ideograph>)
          233   => 16#4FF4#,   --  俴 (<CJK Ideograph>)
          234   => 16#4FF5#,   --  俵 (<CJK Ideograph>)
          235   => 16#4FF6#,   --  俶 (<CJK Ideograph>)
          236   => 16#4FF7#,   --  俷 (<CJK Ideograph>)
          237   => 16#4FF9#,   --  俹 (<CJK Ideograph>)
          238   => 16#4FFB#,   --  俻 (<CJK Ideograph>)
          239   => 16#4FFC#,   --  俼 (<CJK Ideograph>)
          240   => 16#4FFD#,   --  俽 (<CJK Ideograph>)
          241   => 16#4FFF#,   --  俿 (<CJK Ideograph>)
          242   => 16#5000#,   --  倀 (<CJK Ideograph>)
          243   => 16#5001#,   --  倁 (<CJK Ideograph>)
          244   => 16#5002#,   --  倂 (<CJK Ideograph>)
          245   => 16#5003#,   --  倃 (<CJK Ideograph>)
          246   => 16#5004#,   --  倄 (<CJK Ideograph>)
          247   => 16#5005#,   --  倅 (<CJK Ideograph>)
          248   => 16#5006#,   --  倆 (<CJK Ideograph>)
          249   => 16#5007#,   --  倇 (<CJK Ideograph>)
          250   => 16#5008#,   --  倈 (<CJK Ideograph>)
          251   => 16#5009#,   --  倉 (<CJK Ideograph>)
          252   => 16#500A#,   --  倊 (<CJK Ideograph>)
          253   => 16#500B#,   --  個 (<CJK Ideograph>)
          254   => 16#500E#,   --  倎 (<CJK Ideograph>)
          255   => 16#5010#,   --  倐 (<CJK Ideograph>)
          256   => 16#5011#,   --  們 (<CJK Ideograph>)
          257   => 16#5013#,   --  倓 (<CJK Ideograph>)
          258   => 16#5015#,   --  倕 (<CJK Ideograph>)
          259   => 16#5016#,   --  倖 (<CJK Ideograph>)
          260   => 16#5017#,   --  倗 (<CJK Ideograph>)
          261   => 16#501B#,   --  倛 (<CJK Ideograph>)
          262   => 16#501D#,   --  倝 (<CJK Ideograph>)
          263   => 16#501E#,   --  倞 (<CJK Ideograph>)
          264   => 16#5020#,   --  倠 (<CJK Ideograph>)
          265   => 16#5022#,   --  倢 (<CJK Ideograph>)
          266   => 16#5023#,   --  倣 (<CJK Ideograph>)
          267   => 16#5024#,   --  値 (<CJK Ideograph>)
          268   => 16#5027#,   --  倧 (<CJK Ideograph>)
          269   => 16#502B#,   --  倫 (<CJK Ideograph>)
          270   => 16#502F#,   --  倯 (<CJK Ideograph>)
          271   => 16#5030#,   --  倰 (<CJK Ideograph>)
          272   => 16#5031#,   --  倱 (<CJK Ideograph>)
          273   => 16#5032#,   --  倲 (<CJK Ideograph>)
          274   => 16#5033#,   --  倳 (<CJK Ideograph>)
          275   => 16#5034#,   --  倴 (<CJK Ideograph>)
          276   => 16#5035#,   --  倵 (<CJK Ideograph>)
          277   => 16#5036#,   --  倶 (<CJK Ideograph>)
          278   => 16#5037#,   --  倷 (<CJK Ideograph>)
          279   => 16#5038#,   --  倸 (<CJK Ideograph>)
          280   => 16#5039#,   --  倹 (<CJK Ideograph>)
          281   => 16#503B#,   --  倻 (<CJK Ideograph>)
          282   => 16#503D#,   --  倽 (<CJK Ideograph>)
          283   => 16#503F#,   --  倿 (<CJK Ideograph>)
          284   => 16#5040#,   --  偀 (<CJK Ideograph>)
          285   => 16#5041#,   --  偁 (<CJK Ideograph>)
          286   => 16#5042#,   --  偂 (<CJK Ideograph>)
          287   => 16#5044#,   --  偄 (<CJK Ideograph>)
          288   => 16#5045#,   --  偅 (<CJK Ideograph>)
          289   => 16#5046#,   --  偆 (<CJK Ideograph>)
          290   => 16#5049#,   --  偉 (<CJK Ideograph>)
          291   => 16#504A#,   --  偊 (<CJK Ideograph>)
          292   => 16#504B#,   --  偋 (<CJK Ideograph>)
          293   => 16#504D#,   --  偍 (<CJK Ideograph>)
          294   => 16#5050#,   --  偐 (<CJK Ideograph>)
          295   => 16#5051#,   --  偑 (<CJK Ideograph>)
          296   => 16#5052#,   --  偒 (<CJK Ideograph>)
          297   => 16#5053#,   --  偓 (<CJK Ideograph>)
          298   => 16#5054#,   --  偔 (<CJK Ideograph>)
          299   => 16#5056#,   --  偖 (<CJK Ideograph>)
          300   => 16#5057#,   --  偗 (<CJK Ideograph>)
          301   => 16#5058#,   --  偘 (<CJK Ideograph>)
          302   => 16#5059#,   --  偙 (<CJK Ideograph>)
          303   => 16#505B#,   --  偛 (<CJK Ideograph>)
          304   => 16#505D#,   --  偝 (<CJK Ideograph>)
          305   => 16#505E#,   --  偞 (<CJK Ideograph>)
          306   => 16#505F#,   --  偟 (<CJK Ideograph>)
          307   => 16#5060#,   --  偠 (<CJK Ideograph>)
          308   => 16#5061#,   --  偡 (<CJK Ideograph>)
          309   => 16#5062#,   --  偢 (<CJK Ideograph>)
          310   => 16#5063#,   --  偣 (<CJK Ideograph>)
          311   => 16#5064#,   --  偤 (<CJK Ideograph>)
          312   => 16#5066#,   --  偦 (<CJK Ideograph>)
          313   => 16#5067#,   --  偧 (<CJK Ideograph>)
          314   => 16#5068#,   --  偨 (<CJK Ideograph>)
          315   => 16#5069#,   --  偩 (<CJK Ideograph>)
          316   => 16#506A#,   --  偪 (<CJK Ideograph>)
          317   => 16#506B#,   --  偫 (<CJK Ideograph>)
          318   => 16#506D#,   --  偭 (<CJK Ideograph>)
          319   => 16#506E#,   --  偮 (<CJK Ideograph>)
          320   => 16#506F#,   --  偯 (<CJK Ideograph>)
          321   => 16#5070#,   --  偰 (<CJK Ideograph>)
          322   => 16#5071#,   --  偱 (<CJK Ideograph>)
          323   => 16#5072#,   --  偲 (<CJK Ideograph>)
          324   => 16#5073#,   --  偳 (<CJK Ideograph>)
          325   => 16#5074#,   --  側 (<CJK Ideograph>)
          326   => 16#5075#,   --  偵 (<CJK Ideograph>)
          327   => 16#5078#,   --  偸 (<CJK Ideograph>)
          328   => 16#5079#,   --  偹 (<CJK Ideograph>)
          329   => 16#507A#,   --  偺 (<CJK Ideograph>)
          330   => 16#507C#,   --  偼 (<CJK Ideograph>)
          331   => 16#507D#,   --  偽 (<CJK Ideograph>)
          332   => 16#5081#,   --  傁 (<CJK Ideograph>)
          333   => 16#5082#,   --  傂 (<CJK Ideograph>)
          334   => 16#5083#,   --  傃 (<CJK Ideograph>)
          335   => 16#5084#,   --  傄 (<CJK Ideograph>)
          336   => 16#5086#,   --  傆 (<CJK Ideograph>)
          337   => 16#5087#,   --  傇 (<CJK Ideograph>)
          338   => 16#5089#,   --  傉 (<CJK Ideograph>)
          339   => 16#508A#,   --  傊 (<CJK Ideograph>)
          340   => 16#508B#,   --  傋 (<CJK Ideograph>)
          341   => 16#508C#,   --  傌 (<CJK Ideograph>)
          342   => 16#508E#,   --  傎 (<CJK Ideograph>)
          343   => 16#508F#,   --  傏 (<CJK Ideograph>)
          344   => 16#5090#,   --  傐 (<CJK Ideograph>)
          345   => 16#5091#,   --  傑 (<CJK Ideograph>)
          346   => 16#5092#,   --  傒 (<CJK Ideograph>)
          347   => 16#5093#,   --  傓 (<CJK Ideograph>)
          348   => 16#5094#,   --  傔 (<CJK Ideograph>)
          349   => 16#5095#,   --  傕 (<CJK Ideograph>)
          350   => 16#5096#,   --  傖 (<CJK Ideograph>)
          351   => 16#5097#,   --  傗 (<CJK Ideograph>)
          352   => 16#5098#,   --  傘 (<CJK Ideograph>)
          353   => 16#5099#,   --  備 (<CJK Ideograph>)
          354   => 16#509A#,   --  傚 (<CJK Ideograph>)
          355   => 16#509B#,   --  傛 (<CJK Ideograph>)
          356   => 16#509C#,   --  傜 (<CJK Ideograph>)
          357   => 16#509D#,   --  傝 (<CJK Ideograph>)
          358   => 16#509E#,   --  傞 (<CJK Ideograph>)
          359   => 16#509F#,   --  傟 (<CJK Ideograph>)
          360   => 16#50A0#,   --  傠 (<CJK Ideograph>)
          361   => 16#50A1#,   --  傡 (<CJK Ideograph>)
          362   => 16#50A2#,   --  傢 (<CJK Ideograph>)
          363   => 16#50A4#,   --  傤 (<CJK Ideograph>)
          364   => 16#50A6#,   --  傦 (<CJK Ideograph>)
          365   => 16#50AA#,   --  傪 (<CJK Ideograph>)
          366   => 16#50AB#,   --  傫 (<CJK Ideograph>)
          367   => 16#50AD#,   --  傭 (<CJK Ideograph>)
          368   => 16#50AE#,   --  傮 (<CJK Ideograph>)
          369   => 16#50AF#,   --  傯 (<CJK Ideograph>)
          370   => 16#50B0#,   --  傰 (<CJK Ideograph>)
          371   => 16#50B1#,   --  傱 (<CJK Ideograph>)
          372   => 16#50B3#,   --  傳 (<CJK Ideograph>)
          373   => 16#50B4#,   --  傴 (<CJK Ideograph>)
          374   => 16#50B5#,   --  債 (<CJK Ideograph>)
          375   => 16#50B6#,   --  傶 (<CJK Ideograph>)
          376   => 16#50B7#,   --  傷 (<CJK Ideograph>)
          377   => 16#50B8#,   --  傸 (<CJK Ideograph>)
          378   => 16#50B9#,   --  傹 (<CJK Ideograph>)
          379   => 16#50BC#,   --  傼 (<CJK Ideograph>)
          380   => 16#50BD#,   --  傽 (<CJK Ideograph>)
          381   => 16#50BE#,   --  傾 (<CJK Ideograph>)
          382   => 16#50BF#,   --  傿 (<CJK Ideograph>)
          383   => 16#50C0#,   --  僀 (<CJK Ideograph>)
          384   => 16#50C1#,   --  僁 (<CJK Ideograph>)
          385   => 16#50C2#,   --  僂 (<CJK Ideograph>)
          386   => 16#50C3#,   --  僃 (<CJK Ideograph>)
          387   => 16#50C4#,   --  僄 (<CJK Ideograph>)
          388   => 16#50C5#,   --  僅 (<CJK Ideograph>)
          389   => 16#50C6#,   --  僆 (<CJK Ideograph>)
          390   => 16#50C7#,   --  僇 (<CJK Ideograph>)
          391   => 16#50C8#,   --  僈 (<CJK Ideograph>)
          392   => 16#50C9#,   --  僉 (<CJK Ideograph>)
          393   => 16#50CA#,   --  僊 (<CJK Ideograph>)
          394   => 16#50CB#,   --  僋 (<CJK Ideograph>)
          395   => 16#50CC#,   --  僌 (<CJK Ideograph>)
          396   => 16#50CD#,   --  働 (<CJK Ideograph>)
          397   => 16#50CE#,   --  僎 (<CJK Ideograph>)
          398   => 16#50D0#,   --  僐 (<CJK Ideograph>)
          399   => 16#50D1#,   --  僑 (<CJK Ideograph>)
          400   => 16#50D2#,   --  僒 (<CJK Ideograph>)
          401   => 16#50D3#,   --  僓 (<CJK Ideograph>)
          402   => 16#50D4#,   --  僔 (<CJK Ideograph>)
          403   => 16#50D5#,   --  僕 (<CJK Ideograph>)
          404   => 16#50D7#,   --  僗 (<CJK Ideograph>)
          405   => 16#50D8#,   --  僘 (<CJK Ideograph>)
          406   => 16#50D9#,   --  僙 (<CJK Ideograph>)
          407   => 16#50DB#,   --  僛 (<CJK Ideograph>)
          408   => 16#50DC#,   --  僜 (<CJK Ideograph>)
          409   => 16#50DD#,   --  僝 (<CJK Ideograph>)
          410   => 16#50DE#,   --  僞 (<CJK Ideograph>)
          411   => 16#50DF#,   --  僟 (<CJK Ideograph>)
          412   => 16#50E0#,   --  僠 (<CJK Ideograph>)
          413   => 16#50E1#,   --  僡 (<CJK Ideograph>)
          414   => 16#50E2#,   --  僢 (<CJK Ideograph>)
          415   => 16#50E3#,   --  僣 (<CJK Ideograph>)
          416   => 16#50E4#,   --  僤 (<CJK Ideograph>)
          417   => 16#50E5#,   --  僥 (<CJK Ideograph>)
          418   => 16#50E8#,   --  僨 (<CJK Ideograph>)
          419   => 16#50E9#,   --  僩 (<CJK Ideograph>)
          420   => 16#50EA#,   --  僪 (<CJK Ideograph>)
          421   => 16#50EB#,   --  僫 (<CJK Ideograph>)
          422   => 16#50EF#,   --  僯 (<CJK Ideograph>)
          423   => 16#50F0#,   --  僰 (<CJK Ideograph>)
          424   => 16#50F1#,   --  僱 (<CJK Ideograph>)
          425   => 16#50F2#,   --  僲 (<CJK Ideograph>)
          426   => 16#50F4#,   --  僴 (<CJK Ideograph>)
          427   => 16#50F6#,   --  僶 (<CJK Ideograph>)
          428   => 16#50F7#,   --  僷 (<CJK Ideograph>)
          429   => 16#50F8#,   --  僸 (<CJK Ideograph>)
          430   => 16#50F9#,   --  價 (<CJK Ideograph>)
          431   => 16#50FA#,   --  僺 (<CJK Ideograph>)
          432   => 16#50FC#,   --  僼 (<CJK Ideograph>)
          433   => 16#50FD#,   --  僽 (<CJK Ideograph>)
          434   => 16#50FE#,   --  僾 (<CJK Ideograph>)
          435   => 16#50FF#,   --  僿 (<CJK Ideograph>)
          436   => 16#5100#,   --  儀 (<CJK Ideograph>)
          437   => 16#5101#,   --  儁 (<CJK Ideograph>)
          438   => 16#5102#,   --  儂 (<CJK Ideograph>)
          439   => 16#5103#,   --  儃 (<CJK Ideograph>)
          440   => 16#5104#,   --  億 (<CJK Ideograph>)
          441   => 16#5105#,   --  儅 (<CJK Ideograph>)
          442   => 16#5108#,   --  儈 (<CJK Ideograph>)
          443   => 16#5109#,   --  儉 (<CJK Ideograph>)
          444   => 16#510A#,   --  儊 (<CJK Ideograph>)
          445   => 16#510C#,   --  儌 (<CJK Ideograph>)
          446   => 16#510D#,   --  儍 (<CJK Ideograph>)
          447   => 16#510E#,   --  儎 (<CJK Ideograph>)
          448   => 16#510F#,   --  儏 (<CJK Ideograph>)
          449   => 16#5110#,   --  儐 (<CJK Ideograph>)
          450   => 16#5111#,   --  儑 (<CJK Ideograph>)
          451   => 16#5113#,   --  儓 (<CJK Ideograph>)
          452   => 16#5114#,   --  儔 (<CJK Ideograph>)
          453   => 16#5115#,   --  儕 (<CJK Ideograph>)
          454   => 16#5116#,   --  儖 (<CJK Ideograph>)
          455   => 16#5117#,   --  儗 (<CJK Ideograph>)
          456   => 16#5118#,   --  儘 (<CJK Ideograph>)
          457   => 16#5119#,   --  儙 (<CJK Ideograph>)
          458   => 16#511A#,   --  儚 (<CJK Ideograph>)
          459   => 16#511B#,   --  儛 (<CJK Ideograph>)
          460   => 16#511C#,   --  儜 (<CJK Ideograph>)
          461   => 16#511D#,   --  儝 (<CJK Ideograph>)
          462   => 16#511E#,   --  儞 (<CJK Ideograph>)
          463   => 16#511F#,   --  償 (<CJK Ideograph>)
          464   => 16#5120#,   --  儠 (<CJK Ideograph>)
          465   => 16#5122#,   --  儢 (<CJK Ideograph>)
          466   => 16#5123#,   --  儣 (<CJK Ideograph>)
          467   => 16#5124#,   --  儤 (<CJK Ideograph>)
          468   => 16#5125#,   --  儥 (<CJK Ideograph>)
          469   => 16#5126#,   --  儦 (<CJK Ideograph>)
          470   => 16#5127#,   --  儧 (<CJK Ideograph>)
          471   => 16#5128#,   --  儨 (<CJK Ideograph>)
          472   => 16#5129#,   --  儩 (<CJK Ideograph>)
          473   => 16#512A#,   --  優 (<CJK Ideograph>)
          474   => 16#512B#,   --  儫 (<CJK Ideograph>)
          475   => 16#512C#,   --  儬 (<CJK Ideograph>)
          476   => 16#512D#,   --  儭 (<CJK Ideograph>)
          477   => 16#512E#,   --  儮 (<CJK Ideograph>)
          478   => 16#512F#,   --  儯 (<CJK Ideograph>)
          479   => 16#5130#,   --  儰 (<CJK Ideograph>)
          480   => 16#5131#,   --  儱 (<CJK Ideograph>)
          481   => 16#5132#,   --  儲 (<CJK Ideograph>)
          482   => 16#5133#,   --  儳 (<CJK Ideograph>)
          483   => 16#5134#,   --  儴 (<CJK Ideograph>)
          484   => 16#5135#,   --  儵 (<CJK Ideograph>)
          485   => 16#5136#,   --  儶 (<CJK Ideograph>)
          486   => 16#5137#,   --  儷 (<CJK Ideograph>)
          487   => 16#5138#,   --  儸 (<CJK Ideograph>)
          488   => 16#5139#,   --  儹 (<CJK Ideograph>)
          489   => 16#513A#,   --  儺 (<CJK Ideograph>)
          490   => 16#513B#,   --  儻 (<CJK Ideograph>)
          491   => 16#513C#,   --  儼 (<CJK Ideograph>)
          492   => 16#513D#,   --  儽 (<CJK Ideograph>)
          493   => 16#513E#,   --  儾 (<CJK Ideograph>)
          494   => 16#5142#,   --  兂 (<CJK Ideograph>)
          495   => 16#5147#,   --  兇 (<CJK Ideograph>)
          496   => 16#514A#,   --  兊 (<CJK Ideograph>)
          497   => 16#514C#,   --  兌 (<CJK Ideograph>)
          498   => 16#514E#,   --  兎 (<CJK Ideograph>)
          499   => 16#514F#,   --  兏 (<CJK Ideograph>)
          500   => 16#5150#,   --  児 (<CJK Ideograph>)
          501   => 16#5152#,   --  兒 (<CJK Ideograph>)
          502   => 16#5153#,   --  兓 (<CJK Ideograph>)
          503   => 16#5157#,   --  兗 (<CJK Ideograph>)
          504   => 16#5158#,   --  兘 (<CJK Ideograph>)
          505   => 16#5159#,   --  兙 (<CJK Ideograph>)
          506   => 16#515B#,   --  兛 (<CJK Ideograph>)
          507   => 16#515D#,   --  兝 (<CJK Ideograph>)
          508   => 16#515E#,   --  兞 (<CJK Ideograph>)
          509   => 16#515F#,   --  兟 (<CJK Ideograph>)
          510   => 16#5160#,   --  兠 (<CJK Ideograph>)
          511   => 16#5161#,   --  兡 (<CJK Ideograph>)
          512   => 16#5163#,   --  兣 (<CJK Ideograph>)
          513   => 16#5164#,   --  兤 (<CJK Ideograph>)
          514   => 16#5166#,   --  兦 (<CJK Ideograph>)
          515   => 16#5167#,   --  內 (<CJK Ideograph>)
          516   => 16#5169#,   --  兩 (<CJK Ideograph>)
          517   => 16#516A#,   --  兪 (<CJK Ideograph>)
          518   => 16#516F#,   --  兯 (<CJK Ideograph>)
          519   => 16#5172#,   --  兲 (<CJK Ideograph>)
          520   => 16#517A#,   --  兺 (<CJK Ideograph>)
          521   => 16#517E#,   --  兾 (<CJK Ideograph>)
          522   => 16#517F#,   --  兿 (<CJK Ideograph>)
          523   => 16#5183#,   --  冃 (<CJK Ideograph>)
          524   => 16#5184#,   --  冄 (<CJK Ideograph>)
          525   => 16#5186#,   --  円 (<CJK Ideograph>)
          526   => 16#5187#,   --  冇 (<CJK Ideograph>)
          527   => 16#518A#,   --  冊 (<CJK Ideograph>)
          528   => 16#518B#,   --  冋 (<CJK Ideograph>)
          529   => 16#518E#,   --  冎 (<CJK Ideograph>)
          530   => 16#518F#,   --  冏 (<CJK Ideograph>)
          531   => 16#5190#,   --  冐 (<CJK Ideograph>)
          532   => 16#5191#,   --  冑 (<CJK Ideograph>)
          533   => 16#5193#,   --  冓 (<CJK Ideograph>)
          534   => 16#5194#,   --  冔 (<CJK Ideograph>)
          535   => 16#5198#,   --  冘 (<CJK Ideograph>)
          536   => 16#519A#,   --  冚 (<CJK Ideograph>)
          537   => 16#519D#,   --  冝 (<CJK Ideograph>)
          538   => 16#519E#,   --  冞 (<CJK Ideograph>)
          539   => 16#519F#,   --  冟 (<CJK Ideograph>)
          540   => 16#51A1#,   --  冡 (<CJK Ideograph>)
          541   => 16#51A3#,   --  冣 (<CJK Ideograph>)
          542   => 16#51A6#,   --  冦 (<CJK Ideograph>)
          543   => 16#51A7#,   --  冧 (<CJK Ideograph>)
          544   => 16#51A8#,   --  冨 (<CJK Ideograph>)
          545   => 16#51A9#,   --  冩 (<CJK Ideograph>)
          546   => 16#51AA#,   --  冪 (<CJK Ideograph>)
          547   => 16#51AD#,   --  冭 (<CJK Ideograph>)
          548   => 16#51AE#,   --  冮 (<CJK Ideograph>)
          549   => 16#51B4#,   --  冴 (<CJK Ideograph>)
          550   => 16#51B8#,   --  冸 (<CJK Ideograph>)
          551   => 16#51B9#,   --  冹 (<CJK Ideograph>)
          552   => 16#51BA#,   --  冺 (<CJK Ideograph>)
          553   => 16#51BE#,   --  冾 (<CJK Ideograph>)
          554   => 16#51BF#,   --  冿 (<CJK Ideograph>)
          555   => 16#51C1#,   --  凁 (<CJK Ideograph>)
          556   => 16#51C2#,   --  凂 (<CJK Ideograph>)
          557   => 16#51C3#,   --  凃 (<CJK Ideograph>)
          558   => 16#51C5#,   --  凅 (<CJK Ideograph>)
          559   => 16#51C8#,   --  凈 (<CJK Ideograph>)
          560   => 16#51CA#,   --  凊 (<CJK Ideograph>)
          561   => 16#51CD#,   --  凍 (<CJK Ideograph>)
          562   => 16#51CE#,   --  凎 (<CJK Ideograph>)
          563   => 16#51D0#,   --  凐 (<CJK Ideograph>)
          564   => 16#51D2#,   --  凒 (<CJK Ideograph>)
          565   => 16#51D3#,   --  凓 (<CJK Ideograph>)
          566   => 16#51D4#,   --  凔 (<CJK Ideograph>)
          567   => 16#51D5#,   --  凕 (<CJK Ideograph>)
          568   => 16#51D6#,   --  凖 (<CJK Ideograph>)
          569   => 16#51D7#,   --  凗 (<CJK Ideograph>)
          570   => 16#51D8#,   --  凘 (<CJK Ideograph>)
          571   => 16#51D9#,   --  凙 (<CJK Ideograph>)
          572   => 16#51DA#,   --  凚 (<CJK Ideograph>)
          573   => 16#51DC#,   --  凜 (<CJK Ideograph>)
          574   => 16#51DE#,   --  凞 (<CJK Ideograph>)
          575   => 16#51DF#,   --  凟 (<CJK Ideograph>)
          576   => 16#51E2#,   --  凢 (<CJK Ideograph>)
          577   => 16#51E3#,   --  凣 (<CJK Ideograph>)
          578   => 16#51E5#,   --  凥 (<CJK Ideograph>)
          579   => 16#51E6#,   --  処 (<CJK Ideograph>)
          580   => 16#51E7#,   --  凧 (<CJK Ideograph>)
          581   => 16#51E8#,   --  凨 (<CJK Ideograph>)
          582   => 16#51E9#,   --  凩 (<CJK Ideograph>)
          583   => 16#51EA#,   --  凪 (<CJK Ideograph>)
          584   => 16#51EC#,   --  凬 (<CJK Ideograph>)
          585   => 16#51EE#,   --  凮 (<CJK Ideograph>)
          586   => 16#51F1#,   --  凱 (<CJK Ideograph>)
          587   => 16#51F2#,   --  凲 (<CJK Ideograph>)
          588   => 16#51F4#,   --  凴 (<CJK Ideograph>)
          589   => 16#51F7#,   --  凷 (<CJK Ideograph>)
          590   => 16#51FE#,   --  凾 (<CJK Ideograph>)
          591   => 16#5204#,   --  刄 (<CJK Ideograph>)
          592   => 16#5205#,   --  刅 (<CJK Ideograph>)
          593   => 16#5209#,   --  刉 (<CJK Ideograph>)
          594   => 16#520B#,   --  刋 (<CJK Ideograph>)
          595   => 16#520C#,   --  刌 (<CJK Ideograph>)
          596   => 16#520F#,   --  刏 (<CJK Ideograph>)
          597   => 16#5210#,   --  刐 (<CJK Ideograph>)
          598   => 16#5213#,   --  刓 (<CJK Ideograph>)
          599   => 16#5214#,   --  刔 (<CJK Ideograph>)
          600   => 16#5215#,   --  刕 (<CJK Ideograph>)
          601   => 16#521C#,   --  刜 (<CJK Ideograph>)
          602   => 16#521E#,   --  刞 (<CJK Ideograph>)
          603   => 16#521F#,   --  刟 (<CJK Ideograph>)
          604   => 16#5221#,   --  刡 (<CJK Ideograph>)
          605   => 16#5222#,   --  刢 (<CJK Ideograph>)
          606   => 16#5223#,   --  刣 (<CJK Ideograph>)
          607   => 16#5225#,   --  別 (<CJK Ideograph>)
          608   => 16#5226#,   --  刦 (<CJK Ideograph>)
          609   => 16#5227#,   --  刧 (<CJK Ideograph>)
          610   => 16#522A#,   --  刪 (<CJK Ideograph>)
          611   => 16#522C#,   --  刬 (<CJK Ideograph>)
          612   => 16#522F#,   --  刯 (<CJK Ideograph>)
          613   => 16#5231#,   --  刱 (<CJK Ideograph>)
          614   => 16#5232#,   --  刲 (<CJK Ideograph>)
          615   => 16#5234#,   --  刴 (<CJK Ideograph>)
          616   => 16#5235#,   --  刵 (<CJK Ideograph>)
          617   => 16#523C#,   --  刼 (<CJK Ideograph>)
          618   => 16#523E#,   --  刾 (<CJK Ideograph>)
          619   => 16#5244#,   --  剄 (<CJK Ideograph>)
          620   => 16#5245#,   --  剅 (<CJK Ideograph>)
          621   => 16#5246#,   --  剆 (<CJK Ideograph>)
          622   => 16#5247#,   --  則 (<CJK Ideograph>)
          623   => 16#5248#,   --  剈 (<CJK Ideograph>)
          624   => 16#5249#,   --  剉 (<CJK Ideograph>)
          625   => 16#524B#,   --  剋 (<CJK Ideograph>)
          626   => 16#524E#,   --  剎 (<CJK Ideograph>)
          627   => 16#524F#,   --  剏 (<CJK Ideograph>)
          628   => 16#5252#,   --  剒 (<CJK Ideograph>)
          629   => 16#5253#,   --  剓 (<CJK Ideograph>)
          630   => 16#5255#,   --  剕 (<CJK Ideograph>)
          631   => 16#5257#,   --  剗 (<CJK Ideograph>)
          632   => 16#5258#,   --  剘 (<CJK Ideograph>)
          633   => 16#5259#,   --  剙 (<CJK Ideograph>)
          634   => 16#525A#,   --  剚 (<CJK Ideograph>)
          635   => 16#525B#,   --  剛 (<CJK Ideograph>)
          636   => 16#525D#,   --  剝 (<CJK Ideograph>)
          637   => 16#525F#,   --  剟 (<CJK Ideograph>)
          638   => 16#5260#,   --  剠 (<CJK Ideograph>)
          639   => 16#5262#,   --  剢 (<CJK Ideograph>)
          640   => 16#5263#,   --  剣 (<CJK Ideograph>)
          641   => 16#5264#,   --  剤 (<CJK Ideograph>)
          642   => 16#5266#,   --  剦 (<CJK Ideograph>)
          643   => 16#5268#,   --  剨 (<CJK Ideograph>)
          644   => 16#526B#,   --  剫 (<CJK Ideograph>)
          645   => 16#526C#,   --  剬 (<CJK Ideograph>)
          646   => 16#526D#,   --  剭 (<CJK Ideograph>)
          647   => 16#526E#,   --  剮 (<CJK Ideograph>)
          648   => 16#5270#,   --  剰 (<CJK Ideograph>)
          649   => 16#5271#,   --  剱 (<CJK Ideograph>)
          650   => 16#5273#,   --  剳 (<CJK Ideograph>)
          651   => 16#5274#,   --  剴 (<CJK Ideograph>)
          652   => 16#5275#,   --  創 (<CJK Ideograph>)
          653   => 16#5276#,   --  剶 (<CJK Ideograph>)
          654   => 16#5277#,   --  剷 (<CJK Ideograph>)
          655   => 16#5278#,   --  剸 (<CJK Ideograph>)
          656   => 16#5279#,   --  剹 (<CJK Ideograph>)
          657   => 16#527A#,   --  剺 (<CJK Ideograph>)
          658   => 16#527B#,   --  剻 (<CJK Ideograph>)
          659   => 16#527C#,   --  剼 (<CJK Ideograph>)
          660   => 16#527E#,   --  剾 (<CJK Ideograph>)
          661   => 16#5280#,   --  劀 (<CJK Ideograph>)
          662   => 16#5283#,   --  劃 (<CJK Ideograph>)
          663   => 16#5284#,   --  劄 (<CJK Ideograph>)
          664   => 16#5285#,   --  劅 (<CJK Ideograph>)
          665   => 16#5286#,   --  劆 (<CJK Ideograph>)
          666   => 16#5287#,   --  劇 (<CJK Ideograph>)
          667   => 16#5289#,   --  劉 (<CJK Ideograph>)
          668   => 16#528A#,   --  劊 (<CJK Ideograph>)
          669   => 16#528B#,   --  劋 (<CJK Ideograph>)
          670   => 16#528C#,   --  劌 (<CJK Ideograph>)
          671   => 16#528D#,   --  劍 (<CJK Ideograph>)
          672   => 16#528E#,   --  劎 (<CJK Ideograph>)
          673   => 16#528F#,   --  劏 (<CJK Ideograph>)
          674   => 16#5291#,   --  劑 (<CJK Ideograph>)
          675   => 16#5292#,   --  劒 (<CJK Ideograph>)
          676   => 16#5294#,   --  劔 (<CJK Ideograph>)
          677   => 16#5295#,   --  劕 (<CJK Ideograph>)
          678   => 16#5296#,   --  劖 (<CJK Ideograph>)
          679   => 16#5297#,   --  劗 (<CJK Ideograph>)
          680   => 16#5298#,   --  劘 (<CJK Ideograph>)
          681   => 16#5299#,   --  劙 (<CJK Ideograph>)
          682   => 16#529A#,   --  劚 (<CJK Ideograph>)
          683   => 16#529C#,   --  劜 (<CJK Ideograph>)
          684   => 16#52A4#,   --  劤 (<CJK Ideograph>)
          685   => 16#52A5#,   --  劥 (<CJK Ideograph>)
          686   => 16#52A6#,   --  劦 (<CJK Ideograph>)
          687   => 16#52A7#,   --  劧 (<CJK Ideograph>)
          688   => 16#52AE#,   --  劮 (<CJK Ideograph>)
          689   => 16#52AF#,   --  劯 (<CJK Ideograph>)
          690   => 16#52B0#,   --  劰 (<CJK Ideograph>)
          691   => 16#52B4#,   --  労 (<CJK Ideograph>)
          692   => 16#52B5#,   --  劵 (<CJK Ideograph>)
          693   => 16#52B6#,   --  劶 (<CJK Ideograph>)
          694   => 16#52B7#,   --  劷 (<CJK Ideograph>)
          695   => 16#52B8#,   --  劸 (<CJK Ideograph>)
          696   => 16#52B9#,   --  効 (<CJK Ideograph>)
          697   => 16#52BA#,   --  劺 (<CJK Ideograph>)
          698   => 16#52BB#,   --  劻 (<CJK Ideograph>)
          699   => 16#52BC#,   --  劼 (<CJK Ideograph>)
          700   => 16#52BD#,   --  劽 (<CJK Ideograph>)
          701   => 16#52C0#,   --  勀 (<CJK Ideograph>)
          702   => 16#52C1#,   --  勁 (<CJK Ideograph>)
          703   => 16#52C2#,   --  勂 (<CJK Ideograph>)
          704   => 16#52C4#,   --  勄 (<CJK Ideograph>)
          705   => 16#52C5#,   --  勅 (<CJK Ideograph>)
          706   => 16#52C6#,   --  勆 (<CJK Ideograph>)
          707   => 16#52C8#,   --  勈 (<CJK Ideograph>)
          708   => 16#52CA#,   --  勊 (<CJK Ideograph>)
          709   => 16#52CC#,   --  勌 (<CJK Ideograph>)
          710   => 16#52CD#,   --  勍 (<CJK Ideograph>)
          711   => 16#52CE#,   --  勎 (<CJK Ideograph>)
          712   => 16#52CF#,   --  勏 (<CJK Ideograph>)
          713   => 16#52D1#,   --  勑 (<CJK Ideograph>)
          714   => 16#52D3#,   --  勓 (<CJK Ideograph>)
          715   => 16#52D4#,   --  勔 (<CJK Ideograph>)
          716   => 16#52D5#,   --  動 (<CJK Ideograph>)
          717   => 16#52D7#,   --  勗 (<CJK Ideograph>)
          718   => 16#52D9#,   --  務 (<CJK Ideograph>)
          719   => 16#52DA#,   --  勚 (<CJK Ideograph>)
          720   => 16#52DB#,   --  勛 (<CJK Ideograph>)
          721   => 16#52DC#,   --  勜 (<CJK Ideograph>)
          722   => 16#52DD#,   --  勝 (<CJK Ideograph>)
          723   => 16#52DE#,   --  勞 (<CJK Ideograph>)
          724   => 16#52E0#,   --  勠 (<CJK Ideograph>)
          725   => 16#52E1#,   --  勡 (<CJK Ideograph>)
          726   => 16#52E2#,   --  勢 (<CJK Ideograph>)
          727   => 16#52E3#,   --  勣 (<CJK Ideograph>)
          728   => 16#52E5#,   --  勥 (<CJK Ideograph>)
          729   => 16#52E6#,   --  勦 (<CJK Ideograph>)
          730   => 16#52E7#,   --  勧 (<CJK Ideograph>)
          731   => 16#52E8#,   --  勨 (<CJK Ideograph>)
          732   => 16#52E9#,   --  勩 (<CJK Ideograph>)
          733   => 16#52EA#,   --  勪 (<CJK Ideograph>)
          734   => 16#52EB#,   --  勫 (<CJK Ideograph>)
          735   => 16#52EC#,   --  勬 (<CJK Ideograph>)
          736   => 16#52ED#,   --  勭 (<CJK Ideograph>)
          737   => 16#52EE#,   --  勮 (<CJK Ideograph>)
          738   => 16#52EF#,   --  勯 (<CJK Ideograph>)
          739   => 16#52F1#,   --  勱 (<CJK Ideograph>)
          740   => 16#52F2#,   --  勲 (<CJK Ideograph>)
          741   => 16#52F3#,   --  勳 (<CJK Ideograph>)
          742   => 16#52F4#,   --  勴 (<CJK Ideograph>)
          743   => 16#52F5#,   --  勵 (<CJK Ideograph>)
          744   => 16#52F6#,   --  勶 (<CJK Ideograph>)
          745   => 16#52F7#,   --  勷 (<CJK Ideograph>)
          746   => 16#52F8#,   --  勸 (<CJK Ideograph>)
          747   => 16#52FB#,   --  勻 (<CJK Ideograph>)
          748   => 16#52FC#,   --  勼 (<CJK Ideograph>)
          749   => 16#52FD#,   --  勽 (<CJK Ideograph>)
          750   => 16#5301#,   --  匁 (<CJK Ideograph>)
          751   => 16#5302#,   --  匂 (<CJK Ideograph>)
          752   => 16#5303#,   --  匃 (<CJK Ideograph>)
          753   => 16#5304#,   --  匄 (<CJK Ideograph>)
          754   => 16#5307#,   --  匇 (<CJK Ideograph>)
          755   => 16#5309#,   --  匉 (<CJK Ideograph>)
          756   => 16#530A#,   --  匊 (<CJK Ideograph>)
          757   => 16#530B#,   --  匋 (<CJK Ideograph>)
          758   => 16#530C#,   --  匌 (<CJK Ideograph>)
          759   => 16#530E#,   --  匎 (<CJK Ideograph>)
          760   => 16#5311#,   --  匑 (<CJK Ideograph>)
          761   => 16#5312#,   --  匒 (<CJK Ideograph>)
          762   => 16#5313#,   --  匓 (<CJK Ideograph>)
          763   => 16#5314#,   --  匔 (<CJK Ideograph>)
          764   => 16#5318#,   --  匘 (<CJK Ideograph>)
          765   => 16#531B#,   --  匛 (<CJK Ideograph>)
          766   => 16#531C#,   --  匜 (<CJK Ideograph>)
          767   => 16#531E#,   --  匞 (<CJK Ideograph>)
          768   => 16#531F#,   --  匟 (<CJK Ideograph>)
          769   => 16#5322#,   --  匢 (<CJK Ideograph>)
          770   => 16#5324#,   --  匤 (<CJK Ideograph>)
          771   => 16#5325#,   --  匥 (<CJK Ideograph>)
          772   => 16#5327#,   --  匧 (<CJK Ideograph>)
          773   => 16#5328#,   --  匨 (<CJK Ideograph>)
          774   => 16#5329#,   --  匩 (<CJK Ideograph>)
          775   => 16#532B#,   --  匫 (<CJK Ideograph>)
          776   => 16#532C#,   --  匬 (<CJK Ideograph>)
          777   => 16#532D#,   --  匭 (<CJK Ideograph>)
          778   => 16#532F#,   --  匯 (<CJK Ideograph>)
          779   => 16#5330#,   --  匰 (<CJK Ideograph>)
          780   => 16#5331#,   --  匱 (<CJK Ideograph>)
          781   => 16#5332#,   --  匲 (<CJK Ideograph>)
          782   => 16#5333#,   --  匳 (<CJK Ideograph>)
          783   => 16#5334#,   --  匴 (<CJK Ideograph>)
          784   => 16#5335#,   --  匵 (<CJK Ideograph>)
          785   => 16#5336#,   --  匶 (<CJK Ideograph>)
          786   => 16#5337#,   --  匷 (<CJK Ideograph>)
          787   => 16#5338#,   --  匸 (<CJK Ideograph>)
          788   => 16#533C#,   --  匼 (<CJK Ideograph>)
          789   => 16#533D#,   --  匽 (<CJK Ideograph>)
          790   => 16#5340#,   --  區 (<CJK Ideograph>)
          791   => 16#5342#,   --  卂 (<CJK Ideograph>)
          792   => 16#5344#,   --  卄 (<CJK Ideograph>)
          793   => 16#5346#,   --  卆 (<CJK Ideograph>)
          794   => 16#534B#,   --  卋 (<CJK Ideograph>)
          795   => 16#534C#,   --  卌 (<CJK Ideograph>)
          796   => 16#534D#,   --  卍 (<CJK Ideograph>)
          797   => 16#5350#,   --  卐 (<CJK Ideograph>)
          798   => 16#5354#,   --  協 (<CJK Ideograph>)
          799   => 16#5358#,   --  単 (<CJK Ideograph>)
          800   => 16#5359#,   --  卙 (<CJK Ideograph>)
          801   => 16#535B#,   --  卛 (<CJK Ideograph>)
          802   => 16#535D#,   --  卝 (<CJK Ideograph>)
          803   => 16#5365#,   --  卥 (<CJK Ideograph>)
          804   => 16#5368#,   --  卨 (<CJK Ideograph>)
          805   => 16#536A#,   --  卪 (<CJK Ideograph>)
          806   => 16#536C#,   --  卬 (<CJK Ideograph>)
          807   => 16#536D#,   --  卭 (<CJK Ideograph>)
          808   => 16#5372#,   --  卲 (<CJK Ideograph>)
          809   => 16#5376#,   --  卶 (<CJK Ideograph>)
          810   => 16#5379#,   --  卹 (<CJK Ideograph>)
          811   => 16#537B#,   --  卻 (<CJK Ideograph>)
          812   => 16#537C#,   --  卼 (<CJK Ideograph>)
          813   => 16#537D#,   --  卽 (<CJK Ideograph>)
          814   => 16#537E#,   --  卾 (<CJK Ideograph>)
          815   => 16#5380#,   --  厀 (<CJK Ideograph>)
          816   => 16#5381#,   --  厁 (<CJK Ideograph>)
          817   => 16#5383#,   --  厃 (<CJK Ideograph>)
          818   => 16#5387#,   --  厇 (<CJK Ideograph>)
          819   => 16#5388#,   --  厈 (<CJK Ideograph>)
          820   => 16#538A#,   --  厊 (<CJK Ideograph>)
          821   => 16#538E#,   --  厎 (<CJK Ideograph>)
          822   => 16#538F#,   --  厏 (<CJK Ideograph>)
          823   => 16#5390#,   --  厐 (<CJK Ideograph>)
          824   => 16#5391#,   --  厑 (<CJK Ideograph>)
          825   => 16#5392#,   --  厒 (<CJK Ideograph>)
          826   => 16#5393#,   --  厓 (<CJK Ideograph>)
          827   => 16#5394#,   --  厔 (<CJK Ideograph>)
          828   => 16#5396#,   --  厖 (<CJK Ideograph>)
          829   => 16#5397#,   --  厗 (<CJK Ideograph>)
          830   => 16#5399#,   --  厙 (<CJK Ideograph>)
          831   => 16#539B#,   --  厛 (<CJK Ideograph>)
          832   => 16#539C#,   --  厜 (<CJK Ideograph>)
          833   => 16#539E#,   --  厞 (<CJK Ideograph>)
          834   => 16#53A0#,   --  厠 (<CJK Ideograph>)
          835   => 16#53A1#,   --  厡 (<CJK Ideograph>)
          836   => 16#53A4#,   --  厤 (<CJK Ideograph>)
          837   => 16#53A7#,   --  厧 (<CJK Ideograph>)
          838   => 16#53AA#,   --  厪 (<CJK Ideograph>)
          839   => 16#53AB#,   --  厫 (<CJK Ideograph>)
          840   => 16#53AC#,   --  厬 (<CJK Ideograph>)
          841   => 16#53AD#,   --  厭 (<CJK Ideograph>)
          842   => 16#53AF#,   --  厯 (<CJK Ideograph>)
          843   => 16#53B0#,   --  厰 (<CJK Ideograph>)
          844   => 16#53B1#,   --  厱 (<CJK Ideograph>)
          845   => 16#53B2#,   --  厲 (<CJK Ideograph>)
          846   => 16#53B3#,   --  厳 (<CJK Ideograph>)
          847   => 16#53B4#,   --  厴 (<CJK Ideograph>)
          848   => 16#53B5#,   --  厵 (<CJK Ideograph>)
          849   => 16#53B7#,   --  厷 (<CJK Ideograph>)
          850   => 16#53B8#,   --  厸 (<CJK Ideograph>)
          851   => 16#53B9#,   --  厹 (<CJK Ideograph>)
          852   => 16#53BA#,   --  厺 (<CJK Ideograph>)
          853   => 16#53BC#,   --  厼 (<CJK Ideograph>)
          854   => 16#53BD#,   --  厽 (<CJK Ideograph>)
          855   => 16#53BE#,   --  厾 (<CJK Ideograph>)
          856   => 16#53C0#,   --  叀 (<CJK Ideograph>)
          857   => 16#53C3#,   --  參 (<CJK Ideograph>)
          858   => 16#53C4#,   --  叄 (<CJK Ideograph>)
          859   => 16#53C5#,   --  叅 (<CJK Ideograph>)
          860   => 16#53C6#,   --  叆 (<CJK Ideograph>)
          861   => 16#53C7#,   --  叇 (<CJK Ideograph>)
          862   => 16#53CE#,   --  収 (<CJK Ideograph>)
          863   => 16#53CF#,   --  叏 (<CJK Ideograph>)
          864   => 16#53D0#,   --  叐 (<CJK Ideograph>)
          865   => 16#53D2#,   --  叒 (<CJK Ideograph>)
          866   => 16#53D3#,   --  叓 (<CJK Ideograph>)
          867   => 16#53D5#,   --  叕 (<CJK Ideograph>)
          868   => 16#53DA#,   --  叚 (<CJK Ideograph>)
          869   => 16#53DC#,   --  叜 (<CJK Ideograph>)
          870   => 16#53DD#,   --  叝 (<CJK Ideograph>)
          871   => 16#53DE#,   --  叞 (<CJK Ideograph>)
          872   => 16#53E1#,   --  叡 (<CJK Ideograph>)
          873   => 16#53E2#,   --  叢 (<CJK Ideograph>)
          874   => 16#53E7#,   --  叧 (<CJK Ideograph>)
          875   => 16#53F4#,   --  叴 (<CJK Ideograph>)
          876   => 16#53FA#,   --  叺 (<CJK Ideograph>)
          877   => 16#53FE#,   --  叾 (<CJK Ideograph>)
          878   => 16#53FF#,   --  叿 (<CJK Ideograph>)
          879   => 16#5400#,   --  吀 (<CJK Ideograph>)
          880   => 16#5402#,   --  吂 (<CJK Ideograph>)
          881   => 16#5405#,   --  吅 (<CJK Ideograph>)
          882   => 16#5407#,   --  吇 (<CJK Ideograph>)
          883   => 16#540B#,   --  吋 (<CJK Ideograph>)
          884   => 16#5414#,   --  吔 (<CJK Ideograph>)
          885   => 16#5418#,   --  吘 (<CJK Ideograph>)
          886   => 16#5419#,   --  吙 (<CJK Ideograph>)
          887   => 16#541A#,   --  吚 (<CJK Ideograph>)
          888   => 16#541C#,   --  吜 (<CJK Ideograph>)
          889   => 16#5422#,   --  吢 (<CJK Ideograph>)
          890   => 16#5424#,   --  吤 (<CJK Ideograph>)
          891   => 16#5425#,   --  吥 (<CJK Ideograph>)
          892   => 16#542A#,   --  吪 (<CJK Ideograph>)
          893   => 16#5430#,   --  吰 (<CJK Ideograph>)
          894   => 16#5433#,   --  吳 (<CJK Ideograph>)
          895   => 16#5436#,   --  吶 (<CJK Ideograph>)
          896   => 16#5437#,   --  吷 (<CJK Ideograph>)
          897   => 16#543A#,   --  吺 (<CJK Ideograph>)
          898   => 16#543D#,   --  吽 (<CJK Ideograph>)
          899   => 16#543F#,   --  吿 (<CJK Ideograph>)
          900   => 16#5441#,   --  呁 (<CJK Ideograph>)
          901   => 16#5442#,   --  呂 (<CJK Ideograph>)
          902   => 16#5444#,   --  呄 (<CJK Ideograph>)
          903   => 16#5445#,   --  呅 (<CJK Ideograph>)
          904   => 16#5447#,   --  呇 (<CJK Ideograph>)
          905   => 16#5449#,   --  呉 (<CJK Ideograph>)
          906   => 16#544C#,   --  呌 (<CJK Ideograph>)
          907   => 16#544D#,   --  呍 (<CJK Ideograph>)
          908   => 16#544E#,   --  呎 (<CJK Ideograph>)
          909   => 16#544F#,   --  呏 (<CJK Ideograph>)
          910   => 16#5451#,   --  呑 (<CJK Ideograph>)
          911   => 16#545A#,   --  呚 (<CJK Ideograph>)
          912   => 16#545D#,   --  呝 (<CJK Ideograph>)
          913   => 16#545E#,   --  呞 (<CJK Ideograph>)
          914   => 16#545F#,   --  呟 (<CJK Ideograph>)
          915   => 16#5460#,   --  呠 (<CJK Ideograph>)
          916   => 16#5461#,   --  呡 (<CJK Ideograph>)
          917   => 16#5463#,   --  呣 (<CJK Ideograph>)
          918   => 16#5465#,   --  呥 (<CJK Ideograph>)
          919   => 16#5467#,   --  呧 (<CJK Ideograph>)
          920   => 16#5469#,   --  呩 (<CJK Ideograph>)
          921   => 16#546A#,   --  呪 (<CJK Ideograph>)
          922   => 16#546B#,   --  呫 (<CJK Ideograph>)
          923   => 16#546C#,   --  呬 (<CJK Ideograph>)
          924   => 16#546D#,   --  呭 (<CJK Ideograph>)
          925   => 16#546E#,   --  呮 (<CJK Ideograph>)
          926   => 16#546F#,   --  呯 (<CJK Ideograph>)
          927   => 16#5470#,   --  呰 (<CJK Ideograph>)
          928   => 16#5474#,   --  呴 (<CJK Ideograph>)
          929   => 16#5479#,   --  呹 (<CJK Ideograph>)
          930   => 16#547A#,   --  呺 (<CJK Ideograph>)
          931   => 16#547E#,   --  呾 (<CJK Ideograph>)
          932   => 16#547F#,   --  呿 (<CJK Ideograph>)
          933   => 16#5481#,   --  咁 (<CJK Ideograph>)
          934   => 16#5483#,   --  咃 (<CJK Ideograph>)
          935   => 16#5485#,   --  咅 (<CJK Ideograph>)
          936   => 16#5487#,   --  咇 (<CJK Ideograph>)
          937   => 16#5488#,   --  咈 (<CJK Ideograph>)
          938   => 16#5489#,   --  咉 (<CJK Ideograph>)
          939   => 16#548A#,   --  咊 (<CJK Ideograph>)
          940   => 16#548D#,   --  咍 (<CJK Ideograph>)
          941   => 16#5491#,   --  咑 (<CJK Ideograph>)
          942   => 16#5493#,   --  咓 (<CJK Ideograph>)
          943   => 16#5497#,   --  咗 (<CJK Ideograph>)
          944   => 16#5498#,   --  咘 (<CJK Ideograph>)
          945   => 16#549C#,   --  咜 (<CJK Ideograph>)
          946   => 16#549E#,   --  咞 (<CJK Ideograph>)
          947   => 16#549F#,   --  咟 (<CJK Ideograph>)
          948   => 16#54A0#,   --  咠 (<CJK Ideograph>)
          949   => 16#54A1#,   --  咡 (<CJK Ideograph>)
          950   => 16#54A2#,   --  咢 (<CJK Ideograph>)
          951   => 16#54A5#,   --  咥 (<CJK Ideograph>)
          952   => 16#54AE#,   --  咮 (<CJK Ideograph>)
          953   => 16#54B0#,   --  咰 (<CJK Ideograph>)
          954   => 16#54B2#,   --  咲 (<CJK Ideograph>)
          955   => 16#54B5#,   --  咵 (<CJK Ideograph>)
          956   => 16#54B6#,   --  咶 (<CJK Ideograph>)
          957   => 16#54B7#,   --  咷 (<CJK Ideograph>)
          958   => 16#54B9#,   --  咹 (<CJK Ideograph>)
          959   => 16#54BA#,   --  咺 (<CJK Ideograph>)
          960   => 16#54BC#,   --  咼 (<CJK Ideograph>)
          961   => 16#54BE#,   --  咾 (<CJK Ideograph>)
          962   => 16#54C3#,   --  哃 (<CJK Ideograph>)
          963   => 16#54C5#,   --  哅 (<CJK Ideograph>)
          964   => 16#54CA#,   --  哊 (<CJK Ideograph>)
          965   => 16#54CB#,   --  哋 (<CJK Ideograph>)
          966   => 16#54D6#,   --  哖 (<CJK Ideograph>)
          967   => 16#54D8#,   --  哘 (<CJK Ideograph>)
          968   => 16#54DB#,   --  哛 (<CJK Ideograph>)
          969   => 16#54E0#,   --  哠 (<CJK Ideograph>)
          970   => 16#54E1#,   --  員 (<CJK Ideograph>)
          971   => 16#54E2#,   --  哢 (<CJK Ideograph>)
          972   => 16#54E3#,   --  哣 (<CJK Ideograph>)
          973   => 16#54E4#,   --  哤 (<CJK Ideograph>)
          974   => 16#54EB#,   --  哫 (<CJK Ideograph>)
          975   => 16#54EC#,   --  哬 (<CJK Ideograph>)
          976   => 16#54EF#,   --  哯 (<CJK Ideograph>)
          977   => 16#54F0#,   --  哰 (<CJK Ideograph>)
          978   => 16#54F1#,   --  哱 (<CJK Ideograph>)
          979   => 16#54F4#,   --  哴 (<CJK Ideograph>)
          980   => 16#54F5#,   --  哵 (<CJK Ideograph>)
          981   => 16#54F6#,   --  哶 (<CJK Ideograph>)
          982   => 16#54F7#,   --  哷 (<CJK Ideograph>)
          983   => 16#54F8#,   --  哸 (<CJK Ideograph>)
          984   => 16#54F9#,   --  哹 (<CJK Ideograph>)
          985   => 16#54FB#,   --  哻 (<CJK Ideograph>)
          986   => 16#54FE#,   --  哾 (<CJK Ideograph>)
          987   => 16#5500#,   --  唀 (<CJK Ideograph>)
          988   => 16#5502#,   --  唂 (<CJK Ideograph>)
          989   => 16#5503#,   --  唃 (<CJK Ideograph>)
          990   => 16#5504#,   --  唄 (<CJK Ideograph>)
          991   => 16#5505#,   --  唅 (<CJK Ideograph>)
          992   => 16#5508#,   --  唈 (<CJK Ideograph>)
          993   => 16#550A#,   --  唊 (<CJK Ideograph>)
          994   => 16#550B#,   --  唋 (<CJK Ideograph>)
          995   => 16#550C#,   --  唌 (<CJK Ideograph>)
          996   => 16#550D#,   --  唍 (<CJK Ideograph>)
          997   => 16#550E#,   --  唎 (<CJK Ideograph>)
          998   => 16#5512#,   --  唒 (<CJK Ideograph>)
          999   => 16#5513#,   --  唓 (<CJK Ideograph>)
          1000  => 16#5515#,   --  唕 (<CJK Ideograph>)
          1001  => 16#5516#,   --  唖 (<CJK Ideograph>)
          1002  => 16#5517#,   --  唗 (<CJK Ideograph>)
          1003  => 16#5518#,   --  唘 (<CJK Ideograph>)
          1004  => 16#5519#,   --  唙 (<CJK Ideograph>)
          1005  => 16#551A#,   --  唚 (<CJK Ideograph>)
          1006  => 16#551C#,   --  唜 (<CJK Ideograph>)
          1007  => 16#551D#,   --  唝 (<CJK Ideograph>)
          1008  => 16#551E#,   --  唞 (<CJK Ideograph>)
          1009  => 16#551F#,   --  唟 (<CJK Ideograph>)
          1010  => 16#5521#,   --  唡 (<CJK Ideograph>)
          1011  => 16#5525#,   --  唥 (<CJK Ideograph>)
          1012  => 16#5526#,   --  唦 (<CJK Ideograph>)
          1013  => 16#5528#,   --  唨 (<CJK Ideograph>)
          1014  => 16#5529#,   --  唩 (<CJK Ideograph>)
          1015  => 16#552B#,   --  唫 (<CJK Ideograph>)
          1016  => 16#552D#,   --  唭 (<CJK Ideograph>)
          1017  => 16#5532#,   --  唲 (<CJK Ideograph>)
          1018  => 16#5534#,   --  唴 (<CJK Ideograph>)
          1019  => 16#5535#,   --  唵 (<CJK Ideograph>)
          1020  => 16#5536#,   --  唶 (<CJK Ideograph>)
          1021  => 16#5538#,   --  唸 (<CJK Ideograph>)
          1022  => 16#5539#,   --  唹 (<CJK Ideograph>)
          1023  => 16#553A#,   --  唺 (<CJK Ideograph>)
          1024  => 16#553B#,   --  唻 (<CJK Ideograph>)
          1025  => 16#553D#,   --  唽 (<CJK Ideograph>)
          1026  => 16#5540#,   --  啀 (<CJK Ideograph>)
          1027  => 16#5542#,   --  啂 (<CJK Ideograph>)
          1028  => 16#5545#,   --  啅 (<CJK Ideograph>)
          1029  => 16#5547#,   --  啇 (<CJK Ideograph>)
          1030  => 16#5548#,   --  啈 (<CJK Ideograph>)
          1031  => 16#554B#,   --  啋 (<CJK Ideograph>)
          1032  => 16#554C#,   --  啌 (<CJK Ideograph>)
          1033  => 16#554D#,   --  啍 (<CJK Ideograph>)
          1034  => 16#554E#,   --  啎 (<CJK Ideograph>)
          1035  => 16#554F#,   --  問 (<CJK Ideograph>)
          1036  => 16#5551#,   --  啑 (<CJK Ideograph>)
          1037  => 16#5552#,   --  啒 (<CJK Ideograph>)
          1038  => 16#5553#,   --  啓 (<CJK Ideograph>)
          1039  => 16#5554#,   --  啔 (<CJK Ideograph>)
          1040  => 16#5557#,   --  啗 (<CJK Ideograph>)
          1041  => 16#5558#,   --  啘 (<CJK Ideograph>)
          1042  => 16#5559#,   --  啙 (<CJK Ideograph>)
          1043  => 16#555A#,   --  啚 (<CJK Ideograph>)
          1044  => 16#555B#,   --  啛 (<CJK Ideograph>)
          1045  => 16#555D#,   --  啝 (<CJK Ideograph>)
          1046  => 16#555E#,   --  啞 (<CJK Ideograph>)
          1047  => 16#555F#,   --  啟 (<CJK Ideograph>)
          1048  => 16#5560#,   --  啠 (<CJK Ideograph>)
          1049  => 16#5562#,   --  啢 (<CJK Ideograph>)
          1050  => 16#5563#,   --  啣 (<CJK Ideograph>)
          1051  => 16#5568#,   --  啨 (<CJK Ideograph>)
          1052  => 16#5569#,   --  啩 (<CJK Ideograph>)
          1053  => 16#556B#,   --  啫 (<CJK Ideograph>)
          1054  => 16#556F#,   --  啯 (<CJK Ideograph>)
          1055  => 16#5570#,   --  啰 (<CJK Ideograph>)
          1056  => 16#5571#,   --  啱 (<CJK Ideograph>)
          1057  => 16#5572#,   --  啲 (<CJK Ideograph>)
          1058  => 16#5573#,   --  啳 (<CJK Ideograph>)
          1059  => 16#5574#,   --  啴 (<CJK Ideograph>)
          1060  => 16#5579#,   --  啹 (<CJK Ideograph>)
          1061  => 16#557A#,   --  啺 (<CJK Ideograph>)
          1062  => 16#557D#,   --  啽 (<CJK Ideograph>)
          1063  => 16#557F#,   --  啿 (<CJK Ideograph>)
          1064  => 16#5585#,   --  喅 (<CJK Ideograph>)
          1065  => 16#5586#,   --  喆 (<CJK Ideograph>)
          1066  => 16#558C#,   --  喌 (<CJK Ideograph>)
          1067  => 16#558D#,   --  喍 (<CJK Ideograph>)
          1068  => 16#558E#,   --  喎 (<CJK Ideograph>)
          1069  => 16#5590#,   --  喐 (<CJK Ideograph>)
          1070  => 16#5592#,   --  喒 (<CJK Ideograph>)
          1071  => 16#5593#,   --  喓 (<CJK Ideograph>)
          1072  => 16#5595#,   --  喕 (<CJK Ideograph>)
          1073  => 16#5596#,   --  喖 (<CJK Ideograph>)
          1074  => 16#5597#,   --  喗 (<CJK Ideograph>)
          1075  => 16#559A#,   --  喚 (<CJK Ideograph>)
          1076  => 16#559B#,   --  喛 (<CJK Ideograph>)
          1077  => 16#559E#,   --  喞 (<CJK Ideograph>)
          1078  => 16#55A0#,   --  喠 (<CJK Ideograph>)
          1079  => 16#55A1#,   --  喡 (<CJK Ideograph>)
          1080  => 16#55A2#,   --  喢 (<CJK Ideograph>)
          1081  => 16#55A3#,   --  喣 (<CJK Ideograph>)
          1082  => 16#55A4#,   --  喤 (<CJK Ideograph>)
          1083  => 16#55A5#,   --  喥 (<CJK Ideograph>)
          1084  => 16#55A6#,   --  喦 (<CJK Ideograph>)
          1085  => 16#55A8#,   --  喨 (<CJK Ideograph>)
          1086  => 16#55A9#,   --  喩 (<CJK Ideograph>)
          1087  => 16#55AA#,   --  喪 (<CJK Ideograph>)
          1088  => 16#55AB#,   --  喫 (<CJK Ideograph>)
          1089  => 16#55AC#,   --  喬 (<CJK Ideograph>)
          1090  => 16#55AD#,   --  喭 (<CJK Ideograph>)
          1091  => 16#55AE#,   --  單 (<CJK Ideograph>)
          1092  => 16#55AF#,   --  喯 (<CJK Ideograph>)
          1093  => 16#55B0#,   --  喰 (<CJK Ideograph>)
          1094  => 16#55B2#,   --  喲 (<CJK Ideograph>)
          1095  => 16#55B4#,   --  喴 (<CJK Ideograph>)
          1096  => 16#55B6#,   --  営 (<CJK Ideograph>)
          1097  => 16#55B8#,   --  喸 (<CJK Ideograph>)
          1098  => 16#55BA#,   --  喺 (<CJK Ideograph>)
          1099  => 16#55BC#,   --  喼 (<CJK Ideograph>)
          1100  => 16#55BF#,   --  喿 (<CJK Ideograph>)
          1101  => 16#55C0#,   --  嗀 (<CJK Ideograph>)
          1102  => 16#55C1#,   --  嗁 (<CJK Ideograph>)
          1103  => 16#55C2#,   --  嗂 (<CJK Ideograph>)
          1104  => 16#55C3#,   --  嗃 (<CJK Ideograph>)
          1105  => 16#55C6#,   --  嗆 (<CJK Ideograph>)
          1106  => 16#55C7#,   --  嗇 (<CJK Ideograph>)
          1107  => 16#55C8#,   --  嗈 (<CJK Ideograph>)
          1108  => 16#55CA#,   --  嗊 (<CJK Ideograph>)
          1109  => 16#55CB#,   --  嗋 (<CJK Ideograph>)
          1110  => 16#55CE#,   --  嗎 (<CJK Ideograph>)
          1111  => 16#55CF#,   --  嗏 (<CJK Ideograph>)
          1112  => 16#55D0#,   --  嗐 (<CJK Ideograph>)
          1113  => 16#55D5#,   --  嗕 (<CJK Ideograph>)
          1114  => 16#55D7#,   --  嗗 (<CJK Ideograph>)
          1115  => 16#55D8#,   --  嗘 (<CJK Ideograph>)
          1116  => 16#55D9#,   --  嗙 (<CJK Ideograph>)
          1117  => 16#55DA#,   --  嗚 (<CJK Ideograph>)
          1118  => 16#55DB#,   --  嗛 (<CJK Ideograph>)
          1119  => 16#55DE#,   --  嗞 (<CJK Ideograph>)
          1120  => 16#55E0#,   --  嗠 (<CJK Ideograph>)
          1121  => 16#55E2#,   --  嗢 (<CJK Ideograph>)
          1122  => 16#55E7#,   --  嗧 (<CJK Ideograph>)
          1123  => 16#55E9#,   --  嗩 (<CJK Ideograph>)
          1124  => 16#55ED#,   --  嗭 (<CJK Ideograph>)
          1125  => 16#55EE#,   --  嗮 (<CJK Ideograph>)
          1126  => 16#55F0#,   --  嗰 (<CJK Ideograph>)
          1127  => 16#55F1#,   --  嗱 (<CJK Ideograph>)
          1128  => 16#55F4#,   --  嗴 (<CJK Ideograph>)
          1129  => 16#55F6#,   --  嗶 (<CJK Ideograph>)
          1130  => 16#55F8#,   --  嗸 (<CJK Ideograph>)
          1131  => 16#55F9#,   --  嗹 (<CJK Ideograph>)
          1132  => 16#55FA#,   --  嗺 (<CJK Ideograph>)
          1133  => 16#55FB#,   --  嗻 (<CJK Ideograph>)
          1134  => 16#55FC#,   --  嗼 (<CJK Ideograph>)
          1135  => 16#55FF#,   --  嗿 (<CJK Ideograph>)
          1136  => 16#5602#,   --  嘂 (<CJK Ideograph>)
          1137  => 16#5603#,   --  嘃 (<CJK Ideograph>)
          1138  => 16#5604#,   --  嘄 (<CJK Ideograph>)
          1139  => 16#5605#,   --  嘅 (<CJK Ideograph>)
          1140  => 16#5606#,   --  嘆 (<CJK Ideograph>)
          1141  => 16#5607#,   --  嘇 (<CJK Ideograph>)
          1142  => 16#560A#,   --  嘊 (<CJK Ideograph>)
          1143  => 16#560B#,   --  嘋 (<CJK Ideograph>)
          1144  => 16#560D#,   --  嘍 (<CJK Ideograph>)
          1145  => 16#5610#,   --  嘐 (<CJK Ideograph>)
          1146  => 16#5611#,   --  嘑 (<CJK Ideograph>)
          1147  => 16#5612#,   --  嘒 (<CJK Ideograph>)
          1148  => 16#5613#,   --  嘓 (<CJK Ideograph>)
          1149  => 16#5614#,   --  嘔 (<CJK Ideograph>)
          1150  => 16#5615#,   --  嘕 (<CJK Ideograph>)
          1151  => 16#5616#,   --  嘖 (<CJK Ideograph>)
          1152  => 16#5617#,   --  嘗 (<CJK Ideograph>)
          1153  => 16#5619#,   --  嘙 (<CJK Ideograph>)
          1154  => 16#561A#,   --  嘚 (<CJK Ideograph>)
          1155  => 16#561C#,   --  嘜 (<CJK Ideograph>)
          1156  => 16#561D#,   --  嘝 (<CJK Ideograph>)
          1157  => 16#5620#,   --  嘠 (<CJK Ideograph>)
          1158  => 16#5621#,   --  嘡 (<CJK Ideograph>)
          1159  => 16#5622#,   --  嘢 (<CJK Ideograph>)
          1160  => 16#5625#,   --  嘥 (<CJK Ideograph>)
          1161  => 16#5626#,   --  嘦 (<CJK Ideograph>)
          1162  => 16#5628#,   --  嘨 (<CJK Ideograph>)
          1163  => 16#5629#,   --  嘩 (<CJK Ideograph>)
          1164  => 16#562A#,   --  嘪 (<CJK Ideograph>)
          1165  => 16#562B#,   --  嘫 (<CJK Ideograph>)
          1166  => 16#562E#,   --  嘮 (<CJK Ideograph>)
          1167  => 16#562F#,   --  嘯 (<CJK Ideograph>)
          1168  => 16#5630#,   --  嘰 (<CJK Ideograph>)
          1169  => 16#5633#,   --  嘳 (<CJK Ideograph>)
          1170  => 16#5635#,   --  嘵 (<CJK Ideograph>)
          1171  => 16#5637#,   --  嘷 (<CJK Ideograph>)
          1172  => 16#5638#,   --  嘸 (<CJK Ideograph>)
          1173  => 16#563A#,   --  嘺 (<CJK Ideograph>)
          1174  => 16#563C#,   --  嘼 (<CJK Ideograph>)
          1175  => 16#563D#,   --  嘽 (<CJK Ideograph>)
          1176  => 16#563E#,   --  嘾 (<CJK Ideograph>)
          1177  => 16#5640#,   --  噀 (<CJK Ideograph>)
          1178  => 16#5641#,   --  噁 (<CJK Ideograph>)
          1179  => 16#5642#,   --  噂 (<CJK Ideograph>)
          1180  => 16#5643#,   --  噃 (<CJK Ideograph>)
          1181  => 16#5644#,   --  噄 (<CJK Ideograph>)
          1182  => 16#5645#,   --  噅 (<CJK Ideograph>)
          1183  => 16#5646#,   --  噆 (<CJK Ideograph>)
          1184  => 16#5647#,   --  噇 (<CJK Ideograph>)
          1185  => 16#5648#,   --  噈 (<CJK Ideograph>)
          1186  => 16#5649#,   --  噉 (<CJK Ideograph>)
          1187  => 16#564A#,   --  噊 (<CJK Ideograph>)
          1188  => 16#564B#,   --  噋 (<CJK Ideograph>)
          1189  => 16#564F#,   --  噏 (<CJK Ideograph>)
          1190  => 16#5650#,   --  噐 (<CJK Ideograph>)
          1191  => 16#5651#,   --  噑 (<CJK Ideograph>)
          1192  => 16#5652#,   --  噒 (<CJK Ideograph>)
          1193  => 16#5653#,   --  噓 (<CJK Ideograph>)
          1194  => 16#5655#,   --  噕 (<CJK Ideograph>)
          1195  => 16#5656#,   --  噖 (<CJK Ideograph>)
          1196  => 16#565A#,   --  噚 (<CJK Ideograph>)
          1197  => 16#565B#,   --  噛 (<CJK Ideograph>)
          1198  => 16#565D#,   --  噝 (<CJK Ideograph>)
          1199  => 16#565E#,   --  噞 (<CJK Ideograph>)
          1200  => 16#565F#,   --  噟 (<CJK Ideograph>)
          1201  => 16#5660#,   --  噠 (<CJK Ideograph>)
          1202  => 16#5661#,   --  噡 (<CJK Ideograph>)
          1203  => 16#5663#,   --  噣 (<CJK Ideograph>)
          1204  => 16#5665#,   --  噥 (<CJK Ideograph>)
          1205  => 16#5666#,   --  噦 (<CJK Ideograph>)
          1206  => 16#5667#,   --  噧 (<CJK Ideograph>)
          1207  => 16#566D#,   --  噭 (<CJK Ideograph>)
          1208  => 16#566E#,   --  噮 (<CJK Ideograph>)
          1209  => 16#566F#,   --  噯 (<CJK Ideograph>)
          1210  => 16#5670#,   --  噰 (<CJK Ideograph>)
          1211  => 16#5672#,   --  噲 (<CJK Ideograph>)
          1212  => 16#5673#,   --  噳 (<CJK Ideograph>)
          1213  => 16#5674#,   --  噴 (<CJK Ideograph>)
          1214  => 16#5675#,   --  噵 (<CJK Ideograph>)
          1215  => 16#5677#,   --  噷 (<CJK Ideograph>)
          1216  => 16#5678#,   --  噸 (<CJK Ideograph>)
          1217  => 16#5679#,   --  噹 (<CJK Ideograph>)
          1218  => 16#567A#,   --  噺 (<CJK Ideograph>)
          1219  => 16#567D#,   --  噽 (<CJK Ideograph>)
          1220  => 16#567E#,   --  噾 (<CJK Ideograph>)
          1221  => 16#567F#,   --  噿 (<CJK Ideograph>)
          1222  => 16#5680#,   --  嚀 (<CJK Ideograph>)
          1223  => 16#5681#,   --  嚁 (<CJK Ideograph>)
          1224  => 16#5682#,   --  嚂 (<CJK Ideograph>)
          1225  => 16#5683#,   --  嚃 (<CJK Ideograph>)
          1226  => 16#5684#,   --  嚄 (<CJK Ideograph>)
          1227  => 16#5687#,   --  嚇 (<CJK Ideograph>)
          1228  => 16#5688#,   --  嚈 (<CJK Ideograph>)
          1229  => 16#5689#,   --  嚉 (<CJK Ideograph>)
          1230  => 16#568A#,   --  嚊 (<CJK Ideograph>)
          1231  => 16#568B#,   --  嚋 (<CJK Ideograph>)
          1232  => 16#568C#,   --  嚌 (<CJK Ideograph>)
          1233  => 16#568D#,   --  嚍 (<CJK Ideograph>)
          1234  => 16#5690#,   --  嚐 (<CJK Ideograph>)
          1235  => 16#5691#,   --  嚑 (<CJK Ideograph>)
          1236  => 16#5692#,   --  嚒 (<CJK Ideograph>)
          1237  => 16#5694#,   --  嚔 (<CJK Ideograph>)
          1238  => 16#5695#,   --  嚕 (<CJK Ideograph>)
          1239  => 16#5696#,   --  嚖 (<CJK Ideograph>)
          1240  => 16#5697#,   --  嚗 (<CJK Ideograph>)
          1241  => 16#5698#,   --  嚘 (<CJK Ideograph>)
          1242  => 16#5699#,   --  嚙 (<CJK Ideograph>)
          1243  => 16#569A#,   --  嚚 (<CJK Ideograph>)
          1244  => 16#569B#,   --  嚛 (<CJK Ideograph>)
          1245  => 16#569C#,   --  嚜 (<CJK Ideograph>)
          1246  => 16#569D#,   --  嚝 (<CJK Ideograph>)
          1247  => 16#569E#,   --  嚞 (<CJK Ideograph>)
          1248  => 16#569F#,   --  嚟 (<CJK Ideograph>)
          1249  => 16#56A0#,   --  嚠 (<CJK Ideograph>)
          1250  => 16#56A1#,   --  嚡 (<CJK Ideograph>)
          1251  => 16#56A2#,   --  嚢 (<CJK Ideograph>)
          1252  => 16#56A4#,   --  嚤 (<CJK Ideograph>)
          1253  => 16#56A5#,   --  嚥 (<CJK Ideograph>)
          1254  => 16#56A6#,   --  嚦 (<CJK Ideograph>)
          1255  => 16#56A7#,   --  嚧 (<CJK Ideograph>)
          1256  => 16#56A8#,   --  嚨 (<CJK Ideograph>)
          1257  => 16#56A9#,   --  嚩 (<CJK Ideograph>)
          1258  => 16#56AA#,   --  嚪 (<CJK Ideograph>)
          1259  => 16#56AB#,   --  嚫 (<CJK Ideograph>)
          1260  => 16#56AC#,   --  嚬 (<CJK Ideograph>)
          1261  => 16#56AD#,   --  嚭 (<CJK Ideograph>)
          1262  => 16#56AE#,   --  嚮 (<CJK Ideograph>)
          1263  => 16#56B0#,   --  嚰 (<CJK Ideograph>)
          1264  => 16#56B1#,   --  嚱 (<CJK Ideograph>)
          1265  => 16#56B2#,   --  嚲 (<CJK Ideograph>)
          1266  => 16#56B3#,   --  嚳 (<CJK Ideograph>)
          1267  => 16#56B4#,   --  嚴 (<CJK Ideograph>)
          1268  => 16#56B5#,   --  嚵 (<CJK Ideograph>)
          1269  => 16#56B6#,   --  嚶 (<CJK Ideograph>)
          1270  => 16#56B8#,   --  嚸 (<CJK Ideograph>)
          1271  => 16#56B9#,   --  嚹 (<CJK Ideograph>)
          1272  => 16#56BA#,   --  嚺 (<CJK Ideograph>)
          1273  => 16#56BB#,   --  嚻 (<CJK Ideograph>)
          1274  => 16#56BD#,   --  嚽 (<CJK Ideograph>)
          1275  => 16#56BE#,   --  嚾 (<CJK Ideograph>)
          1276  => 16#56BF#,   --  嚿 (<CJK Ideograph>)
          1277  => 16#56C0#,   --  囀 (<CJK Ideograph>)
          1278  => 16#56C1#,   --  囁 (<CJK Ideograph>)
          1279  => 16#56C2#,   --  囂 (<CJK Ideograph>)
          1280  => 16#56C3#,   --  囃 (<CJK Ideograph>)
          1281  => 16#56C4#,   --  囄 (<CJK Ideograph>)
          1282  => 16#56C5#,   --  囅 (<CJK Ideograph>)
          1283  => 16#56C6#,   --  囆 (<CJK Ideograph>)
          1284  => 16#56C7#,   --  囇 (<CJK Ideograph>)
          1285  => 16#56C8#,   --  囈 (<CJK Ideograph>)
          1286  => 16#56C9#,   --  囉 (<CJK Ideograph>)
          1287  => 16#56CB#,   --  囋 (<CJK Ideograph>)
          1288  => 16#56CC#,   --  囌 (<CJK Ideograph>)
          1289  => 16#56CD#,   --  囍 (<CJK Ideograph>)
          1290  => 16#56CE#,   --  囎 (<CJK Ideograph>)
          1291  => 16#56CF#,   --  囏 (<CJK Ideograph>)
          1292  => 16#56D0#,   --  囐 (<CJK Ideograph>)
          1293  => 16#56D1#,   --  囑 (<CJK Ideograph>)
          1294  => 16#56D2#,   --  囒 (<CJK Ideograph>)
          1295  => 16#56D3#,   --  囓 (<CJK Ideograph>)
          1296  => 16#56D5#,   --  囕 (<CJK Ideograph>)
          1297  => 16#56D6#,   --  囖 (<CJK Ideograph>)
          1298  => 16#56D8#,   --  囘 (<CJK Ideograph>)
          1299  => 16#56D9#,   --  囙 (<CJK Ideograph>)
          1300  => 16#56DC#,   --  囜 (<CJK Ideograph>)
          1301  => 16#56E3#,   --  団 (<CJK Ideograph>)
          1302  => 16#56E5#,   --  囥 (<CJK Ideograph>)
          1303  => 16#56E6#,   --  囦 (<CJK Ideograph>)
          1304  => 16#56E7#,   --  囧 (<CJK Ideograph>)
          1305  => 16#56E8#,   --  囨 (<CJK Ideograph>)
          1306  => 16#56E9#,   --  囩 (<CJK Ideograph>)
          1307  => 16#56EA#,   --  囪 (<CJK Ideograph>)
          1308  => 16#56EC#,   --  囬 (<CJK Ideograph>)
          1309  => 16#56EE#,   --  囮 (<CJK Ideograph>)
          1310  => 16#56EF#,   --  囯 (<CJK Ideograph>)
          1311  => 16#56F2#,   --  囲 (<CJK Ideograph>)
          1312  => 16#56F3#,   --  図 (<CJK Ideograph>)
          1313  => 16#56F6#,   --  囶 (<CJK Ideograph>)
          1314  => 16#56F7#,   --  囷 (<CJK Ideograph>)
          1315  => 16#56F8#,   --  囸 (<CJK Ideograph>)
          1316  => 16#56FB#,   --  囻 (<CJK Ideograph>)
          1317  => 16#56FC#,   --  囼 (<CJK Ideograph>)
          1318  => 16#5700#,   --  圀 (<CJK Ideograph>)
          1319  => 16#5701#,   --  圁 (<CJK Ideograph>)
          1320  => 16#5702#,   --  圂 (<CJK Ideograph>)
          1321  => 16#5705#,   --  圅 (<CJK Ideograph>)
          1322  => 16#5707#,   --  圇 (<CJK Ideograph>)
          1323  => 16#570B#,   --  國 (<CJK Ideograph>)
          1324  => 16#570C#,   --  圌 (<CJK Ideograph>)
          1325  => 16#570D#,   --  圍 (<CJK Ideograph>)
          1326  => 16#570E#,   --  圎 (<CJK Ideograph>)
          1327  => 16#570F#,   --  圏 (<CJK Ideograph>)
          1328  => 16#5710#,   --  圐 (<CJK Ideograph>)
          1329  => 16#5711#,   --  圑 (<CJK Ideograph>)
          1330  => 16#5712#,   --  園 (<CJK Ideograph>)
          1331  => 16#5713#,   --  圓 (<CJK Ideograph>)
          1332  => 16#5714#,   --  圔 (<CJK Ideograph>)
          1333  => 16#5715#,   --  圕 (<CJK Ideograph>)
          1334  => 16#5716#,   --  圖 (<CJK Ideograph>)
          1335  => 16#5717#,   --  圗 (<CJK Ideograph>)
          1336  => 16#5718#,   --  團 (<CJK Ideograph>)
          1337  => 16#5719#,   --  圙 (<CJK Ideograph>)
          1338  => 16#571A#,   --  圚 (<CJK Ideograph>)
          1339  => 16#571B#,   --  圛 (<CJK Ideograph>)
          1340  => 16#571D#,   --  圝 (<CJK Ideograph>)
          1341  => 16#571E#,   --  圞 (<CJK Ideograph>)
          1342  => 16#5720#,   --  圠 (<CJK Ideograph>)
          1343  => 16#5721#,   --  圡 (<CJK Ideograph>)
          1344  => 16#5722#,   --  圢 (<CJK Ideograph>)
          1345  => 16#5724#,   --  圤 (<CJK Ideograph>)
          1346  => 16#5725#,   --  圥 (<CJK Ideograph>)
          1347  => 16#5726#,   --  圦 (<CJK Ideograph>)
          1348  => 16#5727#,   --  圧 (<CJK Ideograph>)
          1349  => 16#572B#,   --  圫 (<CJK Ideograph>)
          1350  => 16#5731#,   --  圱 (<CJK Ideograph>)
          1351  => 16#5732#,   --  圲 (<CJK Ideograph>)
          1352  => 16#5734#,   --  圴 (<CJK Ideograph>)
          1353  => 16#5735#,   --  圵 (<CJK Ideograph>)
          1354  => 16#5736#,   --  圶 (<CJK Ideograph>)
          1355  => 16#5737#,   --  圷 (<CJK Ideograph>)
          1356  => 16#5738#,   --  圸 (<CJK Ideograph>)
          1357  => 16#573C#,   --  圼 (<CJK Ideograph>)
          1358  => 16#573D#,   --  圽 (<CJK Ideograph>)
          1359  => 16#573F#,   --  圿 (<CJK Ideograph>)
          1360  => 16#5741#,   --  坁 (<CJK Ideograph>)
          1361  => 16#5743#,   --  坃 (<CJK Ideograph>)
          1362  => 16#5744#,   --  坄 (<CJK Ideograph>)
          1363  => 16#5745#,   --  坅 (<CJK Ideograph>)
          1364  => 16#5746#,   --  坆 (<CJK Ideograph>)
          1365  => 16#5748#,   --  坈 (<CJK Ideograph>)
          1366  => 16#5749#,   --  坉 (<CJK Ideograph>)
          1367  => 16#574B#,   --  坋 (<CJK Ideograph>)
          1368  => 16#5752#,   --  坒 (<CJK Ideograph>)
          1369  => 16#5753#,   --  坓 (<CJK Ideograph>)
          1370  => 16#5754#,   --  坔 (<CJK Ideograph>)
          1371  => 16#5755#,   --  坕 (<CJK Ideograph>)
          1372  => 16#5756#,   --  坖 (<CJK Ideograph>)
          1373  => 16#5758#,   --  坘 (<CJK Ideograph>)
          1374  => 16#5759#,   --  坙 (<CJK Ideograph>)
          1375  => 16#5762#,   --  坢 (<CJK Ideograph>)
          1376  => 16#5763#,   --  坣 (<CJK Ideograph>)
          1377  => 16#5765#,   --  坥 (<CJK Ideograph>)
          1378  => 16#5767#,   --  坧 (<CJK Ideograph>)
          1379  => 16#576C#,   --  坬 (<CJK Ideograph>)
          1380  => 16#576E#,   --  坮 (<CJK Ideograph>)
          1381  => 16#5770#,   --  坰 (<CJK Ideograph>)
          1382  => 16#5771#,   --  坱 (<CJK Ideograph>)
          1383  => 16#5772#,   --  坲 (<CJK Ideograph>)
          1384  => 16#5774#,   --  坴 (<CJK Ideograph>)
          1385  => 16#5775#,   --  坵 (<CJK Ideograph>)
          1386  => 16#5778#,   --  坸 (<CJK Ideograph>)
          1387  => 16#5779#,   --  坹 (<CJK Ideograph>)
          1388  => 16#577A#,   --  坺 (<CJK Ideograph>)
          1389  => 16#577D#,   --  坽 (<CJK Ideograph>)
          1390  => 16#577E#,   --  坾 (<CJK Ideograph>)
          1391  => 16#577F#,   --  坿 (<CJK Ideograph>)
          1392  => 16#5780#,   --  垀 (<CJK Ideograph>)
          1393  => 16#5781#,   --  垁 (<CJK Ideograph>)
          1394  => 16#5787#,   --  垇 (<CJK Ideograph>)
          1395  => 16#5788#,   --  垈 (<CJK Ideograph>)
          1396  => 16#5789#,   --  垉 (<CJK Ideograph>)
          1397  => 16#578A#,   --  垊 (<CJK Ideograph>)
          1398  => 16#578D#,   --  垍 (<CJK Ideograph>)
          1399  => 16#578E#,   --  垎 (<CJK Ideograph>)
          1400  => 16#578F#,   --  垏 (<CJK Ideograph>)
          1401  => 16#5790#,   --  垐 (<CJK Ideograph>)
          1402  => 16#5791#,   --  垑 (<CJK Ideograph>)
          1403  => 16#5794#,   --  垔 (<CJK Ideograph>)
          1404  => 16#5795#,   --  垕 (<CJK Ideograph>)
          1405  => 16#5796#,   --  垖 (<CJK Ideograph>)
          1406  => 16#5797#,   --  垗 (<CJK Ideograph>)
          1407  => 16#5798#,   --  垘 (<CJK Ideograph>)
          1408  => 16#5799#,   --  垙 (<CJK Ideograph>)
          1409  => 16#579A#,   --  垚 (<CJK Ideograph>)
          1410  => 16#579C#,   --  垜 (<CJK Ideograph>)
          1411  => 16#579D#,   --  垝 (<CJK Ideograph>)
          1412  => 16#579E#,   --  垞 (<CJK Ideograph>)
          1413  => 16#579F#,   --  垟 (<CJK Ideograph>)
          1414  => 16#57A5#,   --  垥 (<CJK Ideograph>)
          1415  => 16#57A8#,   --  垨 (<CJK Ideograph>)
          1416  => 16#57AA#,   --  垪 (<CJK Ideograph>)
          1417  => 16#57AC#,   --  垬 (<CJK Ideograph>)
          1418  => 16#57AF#,   --  垯 (<CJK Ideograph>)
          1419  => 16#57B0#,   --  垰 (<CJK Ideograph>)
          1420  => 16#57B1#,   --  垱 (<CJK Ideograph>)
          1421  => 16#57B3#,   --  垳 (<CJK Ideograph>)
          1422  => 16#57B5#,   --  垵 (<CJK Ideograph>)
          1423  => 16#57B6#,   --  垶 (<CJK Ideograph>)
          1424  => 16#57B7#,   --  垷 (<CJK Ideograph>)
          1425  => 16#57B9#,   --  垹 (<CJK Ideograph>)
          1426  => 16#57BA#,   --  垺 (<CJK Ideograph>)
          1427  => 16#57BB#,   --  垻 (<CJK Ideograph>)
          1428  => 16#57BC#,   --  垼 (<CJK Ideograph>)
          1429  => 16#57BD#,   --  垽 (<CJK Ideograph>)
          1430  => 16#57BE#,   --  垾 (<CJK Ideograph>)
          1431  => 16#57BF#,   --  垿 (<CJK Ideograph>)
          1432  => 16#57C0#,   --  埀 (<CJK Ideograph>)
          1433  => 16#57C1#,   --  埁 (<CJK Ideograph>)
          1434  => 16#57C4#,   --  埄 (<CJK Ideograph>)
          1435  => 16#57C5#,   --  埅 (<CJK Ideograph>)
          1436  => 16#57C6#,   --  埆 (<CJK Ideograph>)
          1437  => 16#57C7#,   --  埇 (<CJK Ideograph>)
          1438  => 16#57C8#,   --  埈 (<CJK Ideograph>)
          1439  => 16#57C9#,   --  埉 (<CJK Ideograph>)
          1440  => 16#57CA#,   --  埊 (<CJK Ideograph>)
          1441  => 16#57CC#,   --  埌 (<CJK Ideograph>)
          1442  => 16#57CD#,   --  埍 (<CJK Ideograph>)
          1443  => 16#57D0#,   --  埐 (<CJK Ideograph>)
          1444  => 16#57D1#,   --  埑 (<CJK Ideograph>)
          1445  => 16#57D3#,   --  埓 (<CJK Ideograph>)
          1446  => 16#57D6#,   --  埖 (<CJK Ideograph>)
          1447  => 16#57D7#,   --  埗 (<CJK Ideograph>)
          1448  => 16#57DB#,   --  埛 (<CJK Ideograph>)
          1449  => 16#57DC#,   --  埜 (<CJK Ideograph>)
          1450  => 16#57DE#,   --  埞 (<CJK Ideograph>)
          1451  => 16#57E1#,   --  埡 (<CJK Ideograph>)
          1452  => 16#57E2#,   --  埢 (<CJK Ideograph>)
          1453  => 16#57E3#,   --  埣 (<CJK Ideograph>)
          1454  => 16#57E5#,   --  埥 (<CJK Ideograph>)
          1455  => 16#57E6#,   --  埦 (<CJK Ideograph>)
          1456  => 16#57E7#,   --  埧 (<CJK Ideograph>)
          1457  => 16#57E8#,   --  埨 (<CJK Ideograph>)
          1458  => 16#57E9#,   --  埩 (<CJK Ideograph>)
          1459  => 16#57EA#,   --  埪 (<CJK Ideograph>)
          1460  => 16#57EB#,   --  埫 (<CJK Ideograph>)
          1461  => 16#57EC#,   --  埬 (<CJK Ideograph>)
          1462  => 16#57EE#,   --  埮 (<CJK Ideograph>)
          1463  => 16#57F0#,   --  埰 (<CJK Ideograph>)
          1464  => 16#57F1#,   --  埱 (<CJK Ideograph>)
          1465  => 16#57F2#,   --  埲 (<CJK Ideograph>)
          1466  => 16#57F3#,   --  埳 (<CJK Ideograph>)
          1467  => 16#57F5#,   --  埵 (<CJK Ideograph>)
          1468  => 16#57F6#,   --  埶 (<CJK Ideograph>)
          1469  => 16#57F7#,   --  執 (<CJK Ideograph>)
          1470  => 16#57FB#,   --  埻 (<CJK Ideograph>)
          1471  => 16#57FC#,   --  埼 (<CJK Ideograph>)
          1472  => 16#57FE#,   --  埾 (<CJK Ideograph>)
          1473  => 16#57FF#,   --  埿 (<CJK Ideograph>)
          1474  => 16#5801#,   --  堁 (<CJK Ideograph>)
          1475  => 16#5803#,   --  堃 (<CJK Ideograph>)
          1476  => 16#5804#,   --  堄 (<CJK Ideograph>)
          1477  => 16#5805#,   --  堅 (<CJK Ideograph>)
          1478  => 16#5808#,   --  堈 (<CJK Ideograph>)
          1479  => 16#5809#,   --  堉 (<CJK Ideograph>)
          1480  => 16#580A#,   --  堊 (<CJK Ideograph>)
          1481  => 16#580C#,   --  堌 (<CJK Ideograph>)
          1482  => 16#580E#,   --  堎 (<CJK Ideograph>)
          1483  => 16#580F#,   --  堏 (<CJK Ideograph>)
          1484  => 16#5810#,   --  堐 (<CJK Ideograph>)
          1485  => 16#5812#,   --  堒 (<CJK Ideograph>)
          1486  => 16#5813#,   --  堓 (<CJK Ideograph>)
          1487  => 16#5814#,   --  堔 (<CJK Ideograph>)
          1488  => 16#5816#,   --  堖 (<CJK Ideograph>)
          1489  => 16#5817#,   --  堗 (<CJK Ideograph>)
          1490  => 16#5818#,   --  堘 (<CJK Ideograph>)
          1491  => 16#581A#,   --  堚 (<CJK Ideograph>)
          1492  => 16#581B#,   --  堛 (<CJK Ideograph>)
          1493  => 16#581C#,   --  堜 (<CJK Ideograph>)
          1494  => 16#581D#,   --  堝 (<CJK Ideograph>)
          1495  => 16#581F#,   --  堟 (<CJK Ideograph>)
          1496  => 16#5822#,   --  堢 (<CJK Ideograph>)
          1497  => 16#5823#,   --  堣 (<CJK Ideograph>)
          1498  => 16#5825#,   --  堥 (<CJK Ideograph>)
          1499  => 16#5826#,   --  堦 (<CJK Ideograph>)
          1500  => 16#5827#,   --  堧 (<CJK Ideograph>)
          1501  => 16#5828#,   --  堨 (<CJK Ideograph>)
          1502  => 16#5829#,   --  堩 (<CJK Ideograph>)
          1503  => 16#582B#,   --  堫 (<CJK Ideograph>)
          1504  => 16#582C#,   --  堬 (<CJK Ideograph>)
          1505  => 16#582D#,   --  堭 (<CJK Ideograph>)
          1506  => 16#582E#,   --  堮 (<CJK Ideograph>)
          1507  => 16#582F#,   --  堯 (<CJK Ideograph>)
          1508  => 16#5831#,   --  報 (<CJK Ideograph>)
          1509  => 16#5832#,   --  堲 (<CJK Ideograph>)
          1510  => 16#5833#,   --  堳 (<CJK Ideograph>)
          1511  => 16#5834#,   --  場 (<CJK Ideograph>)
          1512  => 16#5836#,   --  堶 (<CJK Ideograph>)
          1513  => 16#5837#,   --  堷 (<CJK Ideograph>)
          1514  => 16#5838#,   --  堸 (<CJK Ideograph>)
          1515  => 16#5839#,   --  堹 (<CJK Ideograph>)
          1516  => 16#583A#,   --  堺 (<CJK Ideograph>)
          1517  => 16#583B#,   --  堻 (<CJK Ideograph>)
          1518  => 16#583C#,   --  堼 (<CJK Ideograph>)
          1519  => 16#583D#,   --  堽 (<CJK Ideograph>)
          1520  => 16#583E#,   --  堾 (<CJK Ideograph>)
          1521  => 16#583F#,   --  堿 (<CJK Ideograph>)
          1522  => 16#5840#,   --  塀 (<CJK Ideograph>)
          1523  => 16#5841#,   --  塁 (<CJK Ideograph>)
          1524  => 16#5842#,   --  塂 (<CJK Ideograph>)
          1525  => 16#5843#,   --  塃 (<CJK Ideograph>)
          1526  => 16#5845#,   --  塅 (<CJK Ideograph>)
          1527  => 16#5846#,   --  塆 (<CJK Ideograph>)
          1528  => 16#5847#,   --  塇 (<CJK Ideograph>)
          1529  => 16#5848#,   --  塈 (<CJK Ideograph>)
          1530  => 16#5849#,   --  塉 (<CJK Ideograph>)
          1531  => 16#584A#,   --  塊 (<CJK Ideograph>)
          1532  => 16#584B#,   --  塋 (<CJK Ideograph>)
          1533  => 16#584E#,   --  塎 (<CJK Ideograph>)
          1534  => 16#584F#,   --  塏 (<CJK Ideograph>)
          1535  => 16#5850#,   --  塐 (<CJK Ideograph>)
          1536  => 16#5852#,   --  塒 (<CJK Ideograph>)
          1537  => 16#5853#,   --  塓 (<CJK Ideograph>)
          1538  => 16#5855#,   --  塕 (<CJK Ideograph>)
          1539  => 16#5856#,   --  塖 (<CJK Ideograph>)
          1540  => 16#5857#,   --  塗 (<CJK Ideograph>)
          1541  => 16#5859#,   --  塙 (<CJK Ideograph>)
          1542  => 16#585A#,   --  塚 (<CJK Ideograph>)
          1543  => 16#585B#,   --  塛 (<CJK Ideograph>)
          1544  => 16#585C#,   --  塜 (<CJK Ideograph>)
          1545  => 16#585D#,   --  塝 (<CJK Ideograph>)
          1546  => 16#585F#,   --  塟 (<CJK Ideograph>)
          1547  => 16#5860#,   --  塠 (<CJK Ideograph>)
          1548  => 16#5861#,   --  塡 (<CJK Ideograph>)
          1549  => 16#5862#,   --  塢 (<CJK Ideograph>)
          1550  => 16#5863#,   --  塣 (<CJK Ideograph>)
          1551  => 16#5864#,   --  塤 (<CJK Ideograph>)
          1552  => 16#5866#,   --  塦 (<CJK Ideograph>)
          1553  => 16#5867#,   --  塧 (<CJK Ideograph>)
          1554  => 16#5868#,   --  塨 (<CJK Ideograph>)
          1555  => 16#5869#,   --  塩 (<CJK Ideograph>)
          1556  => 16#586A#,   --  塪 (<CJK Ideograph>)
          1557  => 16#586D#,   --  塭 (<CJK Ideograph>)
          1558  => 16#586E#,   --  塮 (<CJK Ideograph>)
          1559  => 16#586F#,   --  塯 (<CJK Ideograph>)
          1560  => 16#5870#,   --  塰 (<CJK Ideograph>)
          1561  => 16#5871#,   --  塱 (<CJK Ideograph>)
          1562  => 16#5872#,   --  塲 (<CJK Ideograph>)
          1563  => 16#5873#,   --  塳 (<CJK Ideograph>)
          1564  => 16#5874#,   --  塴 (<CJK Ideograph>)
          1565  => 16#5875#,   --  塵 (<CJK Ideograph>)
          1566  => 16#5876#,   --  塶 (<CJK Ideograph>)
          1567  => 16#5877#,   --  塷 (<CJK Ideograph>)
          1568  => 16#5878#,   --  塸 (<CJK Ideograph>)
          1569  => 16#5879#,   --  塹 (<CJK Ideograph>)
          1570  => 16#587A#,   --  塺 (<CJK Ideograph>)
          1571  => 16#587B#,   --  塻 (<CJK Ideograph>)
          1572  => 16#587C#,   --  塼 (<CJK Ideograph>)
          1573  => 16#587D#,   --  塽 (<CJK Ideograph>)
          1574  => 16#587F#,   --  塿 (<CJK Ideograph>)
          1575  => 16#5882#,   --  墂 (<CJK Ideograph>)
          1576  => 16#5884#,   --  墄 (<CJK Ideograph>)
          1577  => 16#5886#,   --  墆 (<CJK Ideograph>)
          1578  => 16#5887#,   --  墇 (<CJK Ideograph>)
          1579  => 16#5888#,   --  墈 (<CJK Ideograph>)
          1580  => 16#588A#,   --  墊 (<CJK Ideograph>)
          1581  => 16#588B#,   --  墋 (<CJK Ideograph>)
          1582  => 16#588C#,   --  墌 (<CJK Ideograph>)
          1583  => 16#588D#,   --  墍 (<CJK Ideograph>)
          1584  => 16#588E#,   --  墎 (<CJK Ideograph>)
          1585  => 16#588F#,   --  墏 (<CJK Ideograph>)
          1586  => 16#5890#,   --  墐 (<CJK Ideograph>)
          1587  => 16#5891#,   --  墑 (<CJK Ideograph>)
          1588  => 16#5894#,   --  墔 (<CJK Ideograph>)
          1589  => 16#5895#,   --  墕 (<CJK Ideograph>)
          1590  => 16#5896#,   --  墖 (<CJK Ideograph>)
          1591  => 16#5897#,   --  増 (<CJK Ideograph>)
          1592  => 16#5898#,   --  墘 (<CJK Ideograph>)
          1593  => 16#589B#,   --  墛 (<CJK Ideograph>)
          1594  => 16#589C#,   --  墜 (<CJK Ideograph>)
          1595  => 16#589D#,   --  墝 (<CJK Ideograph>)
          1596  => 16#58A0#,   --  墠 (<CJK Ideograph>)
          1597  => 16#58A1#,   --  墡 (<CJK Ideograph>)
          1598  => 16#58A2#,   --  墢 (<CJK Ideograph>)
          1599  => 16#58A3#,   --  墣 (<CJK Ideograph>)
          1600  => 16#58A4#,   --  墤 (<CJK Ideograph>)
          1601  => 16#58A5#,   --  墥 (<CJK Ideograph>)
          1602  => 16#58A6#,   --  墦 (<CJK Ideograph>)
          1603  => 16#58A7#,   --  墧 (<CJK Ideograph>)
          1604  => 16#58AA#,   --  墪 (<CJK Ideograph>)
          1605  => 16#58AB#,   --  墫 (<CJK Ideograph>)
          1606  => 16#58AC#,   --  墬 (<CJK Ideograph>)
          1607  => 16#58AD#,   --  墭 (<CJK Ideograph>)
          1608  => 16#58AE#,   --  墮 (<CJK Ideograph>)
          1609  => 16#58AF#,   --  墯 (<CJK Ideograph>)
          1610  => 16#58B0#,   --  墰 (<CJK Ideograph>)
          1611  => 16#58B1#,   --  墱 (<CJK Ideograph>)
          1612  => 16#58B2#,   --  墲 (<CJK Ideograph>)
          1613  => 16#58B3#,   --  墳 (<CJK Ideograph>)
          1614  => 16#58B4#,   --  墴 (<CJK Ideograph>)
          1615  => 16#58B5#,   --  墵 (<CJK Ideograph>)
          1616  => 16#58B6#,   --  墶 (<CJK Ideograph>)
          1617  => 16#58B7#,   --  墷 (<CJK Ideograph>)
          1618  => 16#58B8#,   --  墸 (<CJK Ideograph>)
          1619  => 16#58B9#,   --  墹 (<CJK Ideograph>)
          1620  => 16#58BA#,   --  墺 (<CJK Ideograph>)
          1621  => 16#58BB#,   --  墻 (<CJK Ideograph>)
          1622  => 16#58BD#,   --  墽 (<CJK Ideograph>)
          1623  => 16#58BE#,   --  墾 (<CJK Ideograph>)
          1624  => 16#58BF#,   --  墿 (<CJK Ideograph>)
          1625  => 16#58C0#,   --  壀 (<CJK Ideograph>)
          1626  => 16#58C2#,   --  壂 (<CJK Ideograph>)
          1627  => 16#58C3#,   --  壃 (<CJK Ideograph>)
          1628  => 16#58C4#,   --  壄 (<CJK Ideograph>)
          1629  => 16#58C6#,   --  壆 (<CJK Ideograph>)
          1630  => 16#58C7#,   --  壇 (<CJK Ideograph>)
          1631  => 16#58C8#,   --  壈 (<CJK Ideograph>)
          1632  => 16#58C9#,   --  壉 (<CJK Ideograph>)
          1633  => 16#58CA#,   --  壊 (<CJK Ideograph>)
          1634  => 16#58CB#,   --  壋 (<CJK Ideograph>)
          1635  => 16#58CC#,   --  壌 (<CJK Ideograph>)
          1636  => 16#58CD#,   --  壍 (<CJK Ideograph>)
          1637  => 16#58CE#,   --  壎 (<CJK Ideograph>)
          1638  => 16#58CF#,   --  壏 (<CJK Ideograph>)
          1639  => 16#58D0#,   --  壐 (<CJK Ideograph>)
          1640  => 16#58D2#,   --  壒 (<CJK Ideograph>)
          1641  => 16#58D3#,   --  壓 (<CJK Ideograph>)
          1642  => 16#58D4#,   --  壔 (<CJK Ideograph>)
          1643  => 16#58D6#,   --  壖 (<CJK Ideograph>)
          1644  => 16#58D7#,   --  壗 (<CJK Ideograph>)
          1645  => 16#58D8#,   --  壘 (<CJK Ideograph>)
          1646  => 16#58D9#,   --  壙 (<CJK Ideograph>)
          1647  => 16#58DA#,   --  壚 (<CJK Ideograph>)
          1648  => 16#58DB#,   --  壛 (<CJK Ideograph>)
          1649  => 16#58DC#,   --  壜 (<CJK Ideograph>)
          1650  => 16#58DD#,   --  壝 (<CJK Ideograph>)
          1651  => 16#58DE#,   --  壞 (<CJK Ideograph>)
          1652  => 16#58DF#,   --  壟 (<CJK Ideograph>)
          1653  => 16#58E0#,   --  壠 (<CJK Ideograph>)
          1654  => 16#58E1#,   --  壡 (<CJK Ideograph>)
          1655  => 16#58E2#,   --  壢 (<CJK Ideograph>)
          1656  => 16#58E3#,   --  壣 (<CJK Ideograph>)
          1657  => 16#58E5#,   --  壥 (<CJK Ideograph>)
          1658  => 16#58E6#,   --  壦 (<CJK Ideograph>)
          1659  => 16#58E7#,   --  壧 (<CJK Ideograph>)
          1660  => 16#58E8#,   --  壨 (<CJK Ideograph>)
          1661  => 16#58E9#,   --  壩 (<CJK Ideograph>)
          1662  => 16#58EA#,   --  壪 (<CJK Ideograph>)
          1663  => 16#58ED#,   --  壭 (<CJK Ideograph>)
          1664  => 16#58EF#,   --  壯 (<CJK Ideograph>)
          1665  => 16#58F1#,   --  壱 (<CJK Ideograph>)
          1666  => 16#58F2#,   --  売 (<CJK Ideograph>)
          1667  => 16#58F4#,   --  壴 (<CJK Ideograph>)
          1668  => 16#58F5#,   --  壵 (<CJK Ideograph>)
          1669  => 16#58F7#,   --  壷 (<CJK Ideograph>)
          1670  => 16#58F8#,   --  壸 (<CJK Ideograph>)
          1671  => 16#58FA#,   --  壺 (<CJK Ideograph>)
          1672  => 16#58FB#,   --  壻 (<CJK Ideograph>)
          1673  => 16#58FC#,   --  壼 (<CJK Ideograph>)
          1674  => 16#58FD#,   --  壽 (<CJK Ideograph>)
          1675  => 16#58FE#,   --  壾 (<CJK Ideograph>)
          1676  => 16#58FF#,   --  壿 (<CJK Ideograph>)
          1677  => 16#5900#,   --  夀 (<CJK Ideograph>)
          1678  => 16#5901#,   --  夁 (<CJK Ideograph>)
          1679  => 16#5903#,   --  夃 (<CJK Ideograph>)
          1680  => 16#5905#,   --  夅 (<CJK Ideograph>)
          1681  => 16#5906#,   --  夆 (<CJK Ideograph>)
          1682  => 16#5908#,   --  夈 (<CJK Ideograph>)
          1683  => 16#5909#,   --  変 (<CJK Ideograph>)
          1684  => 16#590A#,   --  夊 (<CJK Ideograph>)
          1685  => 16#590B#,   --  夋 (<CJK Ideograph>)
          1686  => 16#590C#,   --  夌 (<CJK Ideograph>)
          1687  => 16#590E#,   --  夎 (<CJK Ideograph>)
          1688  => 16#5910#,   --  夐 (<CJK Ideograph>)
          1689  => 16#5911#,   --  夑 (<CJK Ideograph>)
          1690  => 16#5912#,   --  夒 (<CJK Ideograph>)
          1691  => 16#5913#,   --  夓 (<CJK Ideograph>)
          1692  => 16#5917#,   --  夗 (<CJK Ideograph>)
          1693  => 16#5918#,   --  夘 (<CJK Ideograph>)
          1694  => 16#591B#,   --  夛 (<CJK Ideograph>)
          1695  => 16#591D#,   --  夝 (<CJK Ideograph>)
          1696  => 16#591E#,   --  夞 (<CJK Ideograph>)
          1697  => 16#5920#,   --  夠 (<CJK Ideograph>)
          1698  => 16#5921#,   --  夡 (<CJK Ideograph>)
          1699  => 16#5922#,   --  夢 (<CJK Ideograph>)
          1700  => 16#5923#,   --  夣 (<CJK Ideograph>)
          1701  => 16#5926#,   --  夦 (<CJK Ideograph>)
          1702  => 16#5928#,   --  夨 (<CJK Ideograph>)
          1703  => 16#592C#,   --  夬 (<CJK Ideograph>)
          1704  => 16#5930#,   --  夰 (<CJK Ideograph>)
          1705  => 16#5932#,   --  夲 (<CJK Ideograph>)
          1706  => 16#5933#,   --  夳 (<CJK Ideograph>)
          1707  => 16#5935#,   --  夵 (<CJK Ideograph>)
          1708  => 16#5936#,   --  夶 (<CJK Ideograph>)
          1709  => 16#593B#,   --  夻 (<CJK Ideograph>)
          1710  => 16#593D#,   --  夽 (<CJK Ideograph>)
          1711  => 16#593E#,   --  夾 (<CJK Ideograph>)
          1712  => 16#593F#,   --  夿 (<CJK Ideograph>)
          1713  => 16#5940#,   --  奀 (<CJK Ideograph>)
          1714  => 16#5943#,   --  奃 (<CJK Ideograph>)
          1715  => 16#5945#,   --  奅 (<CJK Ideograph>)
          1716  => 16#5946#,   --  奆 (<CJK Ideograph>)
          1717  => 16#594A#,   --  奊 (<CJK Ideograph>)
          1718  => 16#594C#,   --  奌 (<CJK Ideograph>)
          1719  => 16#594D#,   --  奍 (<CJK Ideograph>)
          1720  => 16#5950#,   --  奐 (<CJK Ideograph>)
          1721  => 16#5952#,   --  奒 (<CJK Ideograph>)
          1722  => 16#5953#,   --  奓 (<CJK Ideograph>)
          1723  => 16#5959#,   --  奙 (<CJK Ideograph>)
          1724  => 16#595B#,   --  奛 (<CJK Ideograph>)
          1725  => 16#595C#,   --  奜 (<CJK Ideograph>)
          1726  => 16#595D#,   --  奝 (<CJK Ideograph>)
          1727  => 16#595E#,   --  奞 (<CJK Ideograph>)
          1728  => 16#595F#,   --  奟 (<CJK Ideograph>)
          1729  => 16#5961#,   --  奡 (<CJK Ideograph>)
          1730  => 16#5963#,   --  奣 (<CJK Ideograph>)
          1731  => 16#5964#,   --  奤 (<CJK Ideograph>)
          1732  => 16#5966#,   --  奦 (<CJK Ideograph>)
          1733  => 16#5967#,   --  奧 (<CJK Ideograph>)
          1734  => 16#5968#,   --  奨 (<CJK Ideograph>)
          1735  => 16#5969#,   --  奩 (<CJK Ideograph>)
          1736  => 16#596A#,   --  奪 (<CJK Ideograph>)
          1737  => 16#596B#,   --  奫 (<CJK Ideograph>)
          1738  => 16#596C#,   --  奬 (<CJK Ideograph>)
          1739  => 16#596D#,   --  奭 (<CJK Ideograph>)
          1740  => 16#596E#,   --  奮 (<CJK Ideograph>)
          1741  => 16#596F#,   --  奯 (<CJK Ideograph>)
          1742  => 16#5970#,   --  奰 (<CJK Ideograph>)
          1743  => 16#5971#,   --  奱 (<CJK Ideograph>)
          1744  => 16#5972#,   --  奲 (<CJK Ideograph>)
          1745  => 16#5975#,   --  奵 (<CJK Ideograph>)
          1746  => 16#5977#,   --  奷 (<CJK Ideograph>)
          1747  => 16#597A#,   --  奺 (<CJK Ideograph>)
          1748  => 16#597B#,   --  奻 (<CJK Ideograph>)
          1749  => 16#597C#,   --  奼 (<CJK Ideograph>)
          1750  => 16#597E#,   --  奾 (<CJK Ideograph>)
          1751  => 16#597F#,   --  奿 (<CJK Ideograph>)
          1752  => 16#5980#,   --  妀 (<CJK Ideograph>)
          1753  => 16#5985#,   --  妅 (<CJK Ideograph>)
          1754  => 16#5989#,   --  妉 (<CJK Ideograph>)
          1755  => 16#598B#,   --  妋 (<CJK Ideograph>)
          1756  => 16#598C#,   --  妌 (<CJK Ideograph>)
          1757  => 16#598E#,   --  妎 (<CJK Ideograph>)
          1758  => 16#598F#,   --  妏 (<CJK Ideograph>)
          1759  => 16#5990#,   --  妐 (<CJK Ideograph>)
          1760  => 16#5991#,   --  妑 (<CJK Ideograph>)
          1761  => 16#5994#,   --  妔 (<CJK Ideograph>)
          1762  => 16#5995#,   --  妕 (<CJK Ideograph>)
          1763  => 16#5998#,   --  妘 (<CJK Ideograph>)
          1764  => 16#599A#,   --  妚 (<CJK Ideograph>)
          1765  => 16#599B#,   --  妛 (<CJK Ideograph>)
          1766  => 16#599C#,   --  妜 (<CJK Ideograph>)
          1767  => 16#599D#,   --  妝 (<CJK Ideograph>)
          1768  => 16#599F#,   --  妟 (<CJK Ideograph>)
          1769  => 16#59A0#,   --  妠 (<CJK Ideograph>)
          1770  => 16#59A1#,   --  妡 (<CJK Ideograph>)
          1771  => 16#59A2#,   --  妢 (<CJK Ideograph>)
          1772  => 16#59A6#,   --  妦 (<CJK Ideograph>)
          1773  => 16#59A7#,   --  妧 (<CJK Ideograph>)
          1774  => 16#59AC#,   --  妬 (<CJK Ideograph>)
          1775  => 16#59AD#,   --  妭 (<CJK Ideograph>)
          1776  => 16#59B0#,   --  妰 (<CJK Ideograph>)
          1777  => 16#59B1#,   --  妱 (<CJK Ideograph>)
          1778  => 16#59B3#,   --  妳 (<CJK Ideograph>)
          1779  => 16#59B4#,   --  妴 (<CJK Ideograph>)
          1780  => 16#59B5#,   --  妵 (<CJK Ideograph>)
          1781  => 16#59B6#,   --  妶 (<CJK Ideograph>)
          1782  => 16#59B7#,   --  妷 (<CJK Ideograph>)
          1783  => 16#59B8#,   --  妸 (<CJK Ideograph>)
          1784  => 16#59BA#,   --  妺 (<CJK Ideograph>)
          1785  => 16#59BC#,   --  妼 (<CJK Ideograph>)
          1786  => 16#59BD#,   --  妽 (<CJK Ideograph>)
          1787  => 16#59BF#,   --  妿 (<CJK Ideograph>)
          1788  => 16#59C0#,   --  姀 (<CJK Ideograph>)
          1789  => 16#59C1#,   --  姁 (<CJK Ideograph>)
          1790  => 16#59C2#,   --  姂 (<CJK Ideograph>)
          1791  => 16#59C3#,   --  姃 (<CJK Ideograph>)
          1792  => 16#59C4#,   --  姄 (<CJK Ideograph>)
          1793  => 16#59C5#,   --  姅 (<CJK Ideograph>)
          1794  => 16#59C7#,   --  姇 (<CJK Ideograph>)
          1795  => 16#59C8#,   --  姈 (<CJK Ideograph>)
          1796  => 16#59C9#,   --  姉 (<CJK Ideograph>)
          1797  => 16#59CC#,   --  姌 (<CJK Ideograph>)
          1798  => 16#59CD#,   --  姍 (<CJK Ideograph>)
          1799  => 16#59CE#,   --  姎 (<CJK Ideograph>)
          1800  => 16#59CF#,   --  姏 (<CJK Ideograph>)
          1801  => 16#59D5#,   --  姕 (<CJK Ideograph>)
          1802  => 16#59D6#,   --  姖 (<CJK Ideograph>)
          1803  => 16#59D9#,   --  姙 (<CJK Ideograph>)
          1804  => 16#59DB#,   --  姛 (<CJK Ideograph>)
          1805  => 16#59DE#,   --  姞 (<CJK Ideograph>)
          1806  => 16#59DF#,   --  姟 (<CJK Ideograph>)
          1807  => 16#59E0#,   --  姠 (<CJK Ideograph>)
          1808  => 16#59E1#,   --  姡 (<CJK Ideograph>)
          1809  => 16#59E2#,   --  姢 (<CJK Ideograph>)
          1810  => 16#59E4#,   --  姤 (<CJK Ideograph>)
          1811  => 16#59E6#,   --  姦 (<CJK Ideograph>)
          1812  => 16#59E7#,   --  姧 (<CJK Ideograph>)
          1813  => 16#59E9#,   --  姩 (<CJK Ideograph>)
          1814  => 16#59EA#,   --  姪 (<CJK Ideograph>)
          1815  => 16#59EB#,   --  姫 (<CJK Ideograph>)
          1816  => 16#59ED#,   --  姭 (<CJK Ideograph>)
          1817  => 16#59EE#,   --  姮 (<CJK Ideograph>)
          1818  => 16#59EF#,   --  姯 (<CJK Ideograph>)
          1819  => 16#59F0#,   --  姰 (<CJK Ideograph>)
          1820  => 16#59F1#,   --  姱 (<CJK Ideograph>)
          1821  => 16#59F2#,   --  姲 (<CJK Ideograph>)
          1822  => 16#59F3#,   --  姳 (<CJK Ideograph>)
          1823  => 16#59F4#,   --  姴 (<CJK Ideograph>)
          1824  => 16#59F5#,   --  姵 (<CJK Ideograph>)
          1825  => 16#59F6#,   --  姶 (<CJK Ideograph>)
          1826  => 16#59F7#,   --  姷 (<CJK Ideograph>)
          1827  => 16#59F8#,   --  姸 (<CJK Ideograph>)
          1828  => 16#59FA#,   --  姺 (<CJK Ideograph>)
          1829  => 16#59FC#,   --  姼 (<CJK Ideograph>)
          1830  => 16#59FD#,   --  姽 (<CJK Ideograph>)
          1831  => 16#59FE#,   --  姾 (<CJK Ideograph>)
          1832  => 16#5A00#,   --  娀 (<CJK Ideograph>)
          1833  => 16#5A02#,   --  娂 (<CJK Ideograph>)
          1834  => 16#5A0A#,   --  娊 (<CJK Ideograph>)
          1835  => 16#5A0B#,   --  娋 (<CJK Ideograph>)
          1836  => 16#5A0D#,   --  娍 (<CJK Ideograph>)
          1837  => 16#5A0E#,   --  娎 (<CJK Ideograph>)
          1838  => 16#5A0F#,   --  娏 (<CJK Ideograph>)
          1839  => 16#5A10#,   --  娐 (<CJK Ideograph>)
          1840  => 16#5A12#,   --  娒 (<CJK Ideograph>)
          1841  => 16#5A14#,   --  娔 (<CJK Ideograph>)
          1842  => 16#5A15#,   --  娕 (<CJK Ideograph>)
          1843  => 16#5A16#,   --  娖 (<CJK Ideograph>)
          1844  => 16#5A17#,   --  娗 (<CJK Ideograph>)
          1845  => 16#5A19#,   --  娙 (<CJK Ideograph>)
          1846  => 16#5A1A#,   --  娚 (<CJK Ideograph>)
          1847  => 16#5A1B#,   --  娛 (<CJK Ideograph>)
          1848  => 16#5A1D#,   --  娝 (<CJK Ideograph>)
          1849  => 16#5A1E#,   --  娞 (<CJK Ideograph>)
          1850  => 16#5A21#,   --  娡 (<CJK Ideograph>)
          1851  => 16#5A22#,   --  娢 (<CJK Ideograph>)
          1852  => 16#5A24#,   --  娤 (<CJK Ideograph>)
          1853  => 16#5A26#,   --  娦 (<CJK Ideograph>)
          1854  => 16#5A27#,   --  娧 (<CJK Ideograph>)
          1855  => 16#5A28#,   --  娨 (<CJK Ideograph>)
          1856  => 16#5A2A#,   --  娪 (<CJK Ideograph>)
          1857  => 16#5A2B#,   --  娫 (<CJK Ideograph>)
          1858  => 16#5A2C#,   --  娬 (<CJK Ideograph>)
          1859  => 16#5A2D#,   --  娭 (<CJK Ideograph>)
          1860  => 16#5A2E#,   --  娮 (<CJK Ideograph>)
          1861  => 16#5A2F#,   --  娯 (<CJK Ideograph>)
          1862  => 16#5A30#,   --  娰 (<CJK Ideograph>)
          1863  => 16#5A33#,   --  娳 (<CJK Ideograph>)
          1864  => 16#5A35#,   --  娵 (<CJK Ideograph>)
          1865  => 16#5A37#,   --  娷 (<CJK Ideograph>)
          1866  => 16#5A38#,   --  娸 (<CJK Ideograph>)
          1867  => 16#5A39#,   --  娹 (<CJK Ideograph>)
          1868  => 16#5A3A#,   --  娺 (<CJK Ideograph>)
          1869  => 16#5A3B#,   --  娻 (<CJK Ideograph>)
          1870  => 16#5A3D#,   --  娽 (<CJK Ideograph>)
          1871  => 16#5A3E#,   --  娾 (<CJK Ideograph>)
          1872  => 16#5A3F#,   --  娿 (<CJK Ideograph>)
          1873  => 16#5A41#,   --  婁 (<CJK Ideograph>)
          1874  => 16#5A42#,   --  婂 (<CJK Ideograph>)
          1875  => 16#5A43#,   --  婃 (<CJK Ideograph>)
          1876  => 16#5A44#,   --  婄 (<CJK Ideograph>)
          1877  => 16#5A45#,   --  婅 (<CJK Ideograph>)
          1878  => 16#5A47#,   --  婇 (<CJK Ideograph>)
          1879  => 16#5A48#,   --  婈 (<CJK Ideograph>)
          1880  => 16#5A4B#,   --  婋 (<CJK Ideograph>)
          1881  => 16#5A4C#,   --  婌 (<CJK Ideograph>)
          1882  => 16#5A4D#,   --  婍 (<CJK Ideograph>)
          1883  => 16#5A4E#,   --  婎 (<CJK Ideograph>)
          1884  => 16#5A4F#,   --  婏 (<CJK Ideograph>)
          1885  => 16#5A50#,   --  婐 (<CJK Ideograph>)
          1886  => 16#5A51#,   --  婑 (<CJK Ideograph>)
          1887  => 16#5A52#,   --  婒 (<CJK Ideograph>)
          1888  => 16#5A53#,   --  婓 (<CJK Ideograph>)
          1889  => 16#5A54#,   --  婔 (<CJK Ideograph>)
          1890  => 16#5A56#,   --  婖 (<CJK Ideograph>)
          1891  => 16#5A57#,   --  婗 (<CJK Ideograph>)
          1892  => 16#5A58#,   --  婘 (<CJK Ideograph>)
          1893  => 16#5A59#,   --  婙 (<CJK Ideograph>)
          1894  => 16#5A5B#,   --  婛 (<CJK Ideograph>)
          1895  => 16#5A5C#,   --  婜 (<CJK Ideograph>)
          1896  => 16#5A5D#,   --  婝 (<CJK Ideograph>)
          1897  => 16#5A5E#,   --  婞 (<CJK Ideograph>)
          1898  => 16#5A5F#,   --  婟 (<CJK Ideograph>)
          1899  => 16#5A60#,   --  婠 (<CJK Ideograph>)
          1900  => 16#5A61#,   --  婡 (<CJK Ideograph>)
          1901  => 16#5A63#,   --  婣 (<CJK Ideograph>)
          1902  => 16#5A64#,   --  婤 (<CJK Ideograph>)
          1903  => 16#5A65#,   --  婥 (<CJK Ideograph>)
          1904  => 16#5A66#,   --  婦 (<CJK Ideograph>)
          1905  => 16#5A68#,   --  婨 (<CJK Ideograph>)
          1906  => 16#5A69#,   --  婩 (<CJK Ideograph>)
          1907  => 16#5A6B#,   --  婫 (<CJK Ideograph>)
          1908  => 16#5A6C#,   --  婬 (<CJK Ideograph>)
          1909  => 16#5A6D#,   --  婭 (<CJK Ideograph>)
          1910  => 16#5A6E#,   --  婮 (<CJK Ideograph>)
          1911  => 16#5A6F#,   --  婯 (<CJK Ideograph>)
          1912  => 16#5A70#,   --  婰 (<CJK Ideograph>)
          1913  => 16#5A71#,   --  婱 (<CJK Ideograph>)
          1914  => 16#5A72#,   --  婲 (<CJK Ideograph>)
          1915  => 16#5A73#,   --  婳 (<CJK Ideograph>)
          1916  => 16#5A78#,   --  婸 (<CJK Ideograph>)
          1917  => 16#5A79#,   --  婹 (<CJK Ideograph>)
          1918  => 16#5A7B#,   --  婻 (<CJK Ideograph>)
          1919  => 16#5A7C#,   --  婼 (<CJK Ideograph>)
          1920  => 16#5A7D#,   --  婽 (<CJK Ideograph>)
          1921  => 16#5A7E#,   --  婾 (<CJK Ideograph>)
          1922  => 16#5A80#,   --  媀 (<CJK Ideograph>)
          1923  => 16#5A81#,   --  媁 (<CJK Ideograph>)
          1924  => 16#5A82#,   --  媂 (<CJK Ideograph>)
          1925  => 16#5A83#,   --  媃 (<CJK Ideograph>)
          1926  => 16#5A84#,   --  媄 (<CJK Ideograph>)
          1927  => 16#5A85#,   --  媅 (<CJK Ideograph>)
          1928  => 16#5A86#,   --  媆 (<CJK Ideograph>)
          1929  => 16#5A87#,   --  媇 (<CJK Ideograph>)
          1930  => 16#5A88#,   --  媈 (<CJK Ideograph>)
          1931  => 16#5A89#,   --  媉 (<CJK Ideograph>)
          1932  => 16#5A8A#,   --  媊 (<CJK Ideograph>)
          1933  => 16#5A8B#,   --  媋 (<CJK Ideograph>)
          1934  => 16#5A8C#,   --  媌 (<CJK Ideograph>)
          1935  => 16#5A8D#,   --  媍 (<CJK Ideograph>)
          1936  => 16#5A8E#,   --  媎 (<CJK Ideograph>)
          1937  => 16#5A8F#,   --  媏 (<CJK Ideograph>)
          1938  => 16#5A90#,   --  媐 (<CJK Ideograph>)
          1939  => 16#5A91#,   --  媑 (<CJK Ideograph>)
          1940  => 16#5A93#,   --  媓 (<CJK Ideograph>)
          1941  => 16#5A94#,   --  媔 (<CJK Ideograph>)
          1942  => 16#5A95#,   --  媕 (<CJK Ideograph>)
          1943  => 16#5A96#,   --  媖 (<CJK Ideograph>)
          1944  => 16#5A97#,   --  媗 (<CJK Ideograph>)
          1945  => 16#5A98#,   --  媘 (<CJK Ideograph>)
          1946  => 16#5A99#,   --  媙 (<CJK Ideograph>)
          1947  => 16#5A9C#,   --  媜 (<CJK Ideograph>)
          1948  => 16#5A9D#,   --  媝 (<CJK Ideograph>)
          1949  => 16#5A9E#,   --  媞 (<CJK Ideograph>)
          1950  => 16#5A9F#,   --  媟 (<CJK Ideograph>)
          1951  => 16#5AA0#,   --  媠 (<CJK Ideograph>)
          1952  => 16#5AA1#,   --  媡 (<CJK Ideograph>)
          1953  => 16#5AA2#,   --  媢 (<CJK Ideograph>)
          1954  => 16#5AA3#,   --  媣 (<CJK Ideograph>)
          1955  => 16#5AA4#,   --  媤 (<CJK Ideograph>)
          1956  => 16#5AA5#,   --  媥 (<CJK Ideograph>)
          1957  => 16#5AA6#,   --  媦 (<CJK Ideograph>)
          1958  => 16#5AA7#,   --  媧 (<CJK Ideograph>)
          1959  => 16#5AA8#,   --  媨 (<CJK Ideograph>)
          1960  => 16#5AA9#,   --  媩 (<CJK Ideograph>)
          1961  => 16#5AAB#,   --  媫 (<CJK Ideograph>)
          1962  => 16#5AAC#,   --  媬 (<CJK Ideograph>)
          1963  => 16#5AAD#,   --  媭 (<CJK Ideograph>)
          1964  => 16#5AAE#,   --  媮 (<CJK Ideograph>)
          1965  => 16#5AAF#,   --  媯 (<CJK Ideograph>)
          1966  => 16#5AB0#,   --  媰 (<CJK Ideograph>)
          1967  => 16#5AB1#,   --  媱 (<CJK Ideograph>)
          1968  => 16#5AB4#,   --  媴 (<CJK Ideograph>)
          1969  => 16#5AB6#,   --  媶 (<CJK Ideograph>)
          1970  => 16#5AB7#,   --  媷 (<CJK Ideograph>)
          1971  => 16#5AB9#,   --  媹 (<CJK Ideograph>)
          1972  => 16#5ABA#,   --  媺 (<CJK Ideograph>)
          1973  => 16#5ABB#,   --  媻 (<CJK Ideograph>)
          1974  => 16#5ABC#,   --  媼 (<CJK Ideograph>)
          1975  => 16#5ABD#,   --  媽 (<CJK Ideograph>)
          1976  => 16#5ABF#,   --  媿 (<CJK Ideograph>)
          1977  => 16#5AC0#,   --  嫀 (<CJK Ideograph>)
          1978  => 16#5AC3#,   --  嫃 (<CJK Ideograph>)
          1979  => 16#5AC4#,   --  嫄 (<CJK Ideograph>)
          1980  => 16#5AC5#,   --  嫅 (<CJK Ideograph>)
          1981  => 16#5AC6#,   --  嫆 (<CJK Ideograph>)
          1982  => 16#5AC7#,   --  嫇 (<CJK Ideograph>)
          1983  => 16#5AC8#,   --  嫈 (<CJK Ideograph>)
          1984  => 16#5ACA#,   --  嫊 (<CJK Ideograph>)
          1985  => 16#5ACB#,   --  嫋 (<CJK Ideograph>)
          1986  => 16#5ACD#,   --  嫍 (<CJK Ideograph>)
          1987  => 16#5ACE#,   --  嫎 (<CJK Ideograph>)
          1988  => 16#5ACF#,   --  嫏 (<CJK Ideograph>)
          1989  => 16#5AD0#,   --  嫐 (<CJK Ideograph>)
          1990  => 16#5AD1#,   --  嫑 (<CJK Ideograph>)
          1991  => 16#5AD3#,   --  嫓 (<CJK Ideograph>)
          1992  => 16#5AD5#,   --  嫕 (<CJK Ideograph>)
          1993  => 16#5AD7#,   --  嫗 (<CJK Ideograph>)
          1994  => 16#5AD9#,   --  嫙 (<CJK Ideograph>)
          1995  => 16#5ADA#,   --  嫚 (<CJK Ideograph>)
          1996  => 16#5ADB#,   --  嫛 (<CJK Ideograph>)
          1997  => 16#5ADD#,   --  嫝 (<CJK Ideograph>)
          1998  => 16#5ADE#,   --  嫞 (<CJK Ideograph>)
          1999  => 16#5ADF#,   --  嫟 (<CJK Ideograph>)
          2000  => 16#5AE2#,   --  嫢 (<CJK Ideograph>)
          2001  => 16#5AE4#,   --  嫤 (<CJK Ideograph>)
          2002  => 16#5AE5#,   --  嫥 (<CJK Ideograph>)
          2003  => 16#5AE7#,   --  嫧 (<CJK Ideograph>)
          2004  => 16#5AE8#,   --  嫨 (<CJK Ideograph>)
          2005  => 16#5AEA#,   --  嫪 (<CJK Ideograph>)
          2006  => 16#5AEC#,   --  嫬 (<CJK Ideograph>)
          2007  => 16#5AED#,   --  嫭 (<CJK Ideograph>)
          2008  => 16#5AEE#,   --  嫮 (<CJK Ideograph>)
          2009  => 16#5AEF#,   --  嫯 (<CJK Ideograph>)
          2010  => 16#5AF0#,   --  嫰 (<CJK Ideograph>)
          2011  => 16#5AF2#,   --  嫲 (<CJK Ideograph>)
          2012  => 16#5AF3#,   --  嫳 (<CJK Ideograph>)
          2013  => 16#5AF4#,   --  嫴 (<CJK Ideograph>)
          2014  => 16#5AF5#,   --  嫵 (<CJK Ideograph>)
          2015  => 16#5AF6#,   --  嫶 (<CJK Ideograph>)
          2016  => 16#5AF7#,   --  嫷 (<CJK Ideograph>)
          2017  => 16#5AF8#,   --  嫸 (<CJK Ideograph>)
          2018  => 16#5AF9#,   --  嫹 (<CJK Ideograph>)
          2019  => 16#5AFA#,   --  嫺 (<CJK Ideograph>)
          2020  => 16#5AFB#,   --  嫻 (<CJK Ideograph>)
          2021  => 16#5AFC#,   --  嫼 (<CJK Ideograph>)
          2022  => 16#5AFD#,   --  嫽 (<CJK Ideograph>)
          2023  => 16#5AFE#,   --  嫾 (<CJK Ideograph>)
          2024  => 16#5AFF#,   --  嫿 (<CJK Ideograph>)
          2025  => 16#5B00#,   --  嬀 (<CJK Ideograph>)
          2026  => 16#5B01#,   --  嬁 (<CJK Ideograph>)
          2027  => 16#5B02#,   --  嬂 (<CJK Ideograph>)
          2028  => 16#5B03#,   --  嬃 (<CJK Ideograph>)
          2029  => 16#5B04#,   --  嬄 (<CJK Ideograph>)
          2030  => 16#5B05#,   --  嬅 (<CJK Ideograph>)
          2031  => 16#5B06#,   --  嬆 (<CJK Ideograph>)
          2032  => 16#5B07#,   --  嬇 (<CJK Ideograph>)
          2033  => 16#5B08#,   --  嬈 (<CJK Ideograph>)
          2034  => 16#5B0A#,   --  嬊 (<CJK Ideograph>)
          2035  => 16#5B0B#,   --  嬋 (<CJK Ideograph>)
          2036  => 16#5B0C#,   --  嬌 (<CJK Ideograph>)
          2037  => 16#5B0D#,   --  嬍 (<CJK Ideograph>)
          2038  => 16#5B0E#,   --  嬎 (<CJK Ideograph>)
          2039  => 16#5B0F#,   --  嬏 (<CJK Ideograph>)
          2040  => 16#5B10#,   --  嬐 (<CJK Ideograph>)
          2041  => 16#5B11#,   --  嬑 (<CJK Ideograph>)
          2042  => 16#5B12#,   --  嬒 (<CJK Ideograph>)
          2043  => 16#5B13#,   --  嬓 (<CJK Ideograph>)
          2044  => 16#5B14#,   --  嬔 (<CJK Ideograph>)
          2045  => 16#5B15#,   --  嬕 (<CJK Ideograph>)
          2046  => 16#5B18#,   --  嬘 (<CJK Ideograph>)
          2047  => 16#5B19#,   --  嬙 (<CJK Ideograph>)
          2048  => 16#5B1A#,   --  嬚 (<CJK Ideograph>)
          2049  => 16#5B1B#,   --  嬛 (<CJK Ideograph>)
          2050  => 16#5B1C#,   --  嬜 (<CJK Ideograph>)
          2051  => 16#5B1D#,   --  嬝 (<CJK Ideograph>)
          2052  => 16#5B1E#,   --  嬞 (<CJK Ideograph>)
          2053  => 16#5B1F#,   --  嬟 (<CJK Ideograph>)
          2054  => 16#5B20#,   --  嬠 (<CJK Ideograph>)
          2055  => 16#5B21#,   --  嬡 (<CJK Ideograph>)
          2056  => 16#5B22#,   --  嬢 (<CJK Ideograph>)
          2057  => 16#5B23#,   --  嬣 (<CJK Ideograph>)
          2058  => 16#5B24#,   --  嬤 (<CJK Ideograph>)
          2059  => 16#5B25#,   --  嬥 (<CJK Ideograph>)
          2060  => 16#5B26#,   --  嬦 (<CJK Ideograph>)
          2061  => 16#5B27#,   --  嬧 (<CJK Ideograph>)
          2062  => 16#5B28#,   --  嬨 (<CJK Ideograph>)
          2063  => 16#5B29#,   --  嬩 (<CJK Ideograph>)
          2064  => 16#5B2A#,   --  嬪 (<CJK Ideograph>)
          2065  => 16#5B2B#,   --  嬫 (<CJK Ideograph>)
          2066  => 16#5B2C#,   --  嬬 (<CJK Ideograph>)
          2067  => 16#5B2D#,   --  嬭 (<CJK Ideograph>)
          2068  => 16#5B2E#,   --  嬮 (<CJK Ideograph>)
          2069  => 16#5B2F#,   --  嬯 (<CJK Ideograph>)
          2070  => 16#5B30#,   --  嬰 (<CJK Ideograph>)
          2071  => 16#5B31#,   --  嬱 (<CJK Ideograph>)
          2072  => 16#5B33#,   --  嬳 (<CJK Ideograph>)
          2073  => 16#5B35#,   --  嬵 (<CJK Ideograph>)
          2074  => 16#5B36#,   --  嬶 (<CJK Ideograph>)
          2075  => 16#5B38#,   --  嬸 (<CJK Ideograph>)
          2076  => 16#5B39#,   --  嬹 (<CJK Ideograph>)
          2077  => 16#5B3A#,   --  嬺 (<CJK Ideograph>)
          2078  => 16#5B3B#,   --  嬻 (<CJK Ideograph>)
          2079  => 16#5B3C#,   --  嬼 (<CJK Ideograph>)
          2080  => 16#5B3D#,   --  嬽 (<CJK Ideograph>)
          2081  => 16#5B3E#,   --  嬾 (<CJK Ideograph>)
          2082  => 16#5B3F#,   --  嬿 (<CJK Ideograph>)
          2083  => 16#5B41#,   --  孁 (<CJK Ideograph>)
          2084  => 16#5B42#,   --  孂 (<CJK Ideograph>)
          2085  => 16#5B43#,   --  孃 (<CJK Ideograph>)
          2086  => 16#5B44#,   --  孄 (<CJK Ideograph>)
          2087  => 16#5B45#,   --  孅 (<CJK Ideograph>)
          2088  => 16#5B46#,   --  孆 (<CJK Ideograph>)
          2089  => 16#5B47#,   --  孇 (<CJK Ideograph>)
          2090  => 16#5B48#,   --  孈 (<CJK Ideograph>)
          2091  => 16#5B49#,   --  孉 (<CJK Ideograph>)
          2092  => 16#5B4A#,   --  孊 (<CJK Ideograph>)
          2093  => 16#5B4B#,   --  孋 (<CJK Ideograph>)
          2094  => 16#5B4C#,   --  孌 (<CJK Ideograph>)
          2095  => 16#5B4D#,   --  孍 (<CJK Ideograph>)
          2096  => 16#5B4E#,   --  孎 (<CJK Ideograph>)
          2097  => 16#5B4F#,   --  孏 (<CJK Ideograph>)
          2098  => 16#5B52#,   --  孒 (<CJK Ideograph>)
          2099  => 16#5B56#,   --  孖 (<CJK Ideograph>)
          2100  => 16#5B5E#,   --  孞 (<CJK Ideograph>)
          2101  => 16#5B60#,   --  孠 (<CJK Ideograph>)
          2102  => 16#5B61#,   --  孡 (<CJK Ideograph>)
          2103  => 16#5B67#,   --  孧 (<CJK Ideograph>)
          2104  => 16#5B68#,   --  孨 (<CJK Ideograph>)
          2105  => 16#5B6B#,   --  孫 (<CJK Ideograph>)
          2106  => 16#5B6D#,   --  孭 (<CJK Ideograph>)
          2107  => 16#5B6E#,   --  孮 (<CJK Ideograph>)
          2108  => 16#5B6F#,   --  孯 (<CJK Ideograph>)
          2109  => 16#5B72#,   --  孲 (<CJK Ideograph>)
          2110  => 16#5B74#,   --  孴 (<CJK Ideograph>)
          2111  => 16#5B76#,   --  孶 (<CJK Ideograph>)
          2112  => 16#5B77#,   --  孷 (<CJK Ideograph>)
          2113  => 16#5B78#,   --  學 (<CJK Ideograph>)
          2114  => 16#5B79#,   --  孹 (<CJK Ideograph>)
          2115  => 16#5B7B#,   --  孻 (<CJK Ideograph>)
          2116  => 16#5B7C#,   --  孼 (<CJK Ideograph>)
          2117  => 16#5B7E#,   --  孾 (<CJK Ideograph>)
          2118  => 16#5B7F#,   --  孿 (<CJK Ideograph>)
          2119  => 16#5B82#,   --  宂 (<CJK Ideograph>)
          2120  => 16#5B86#,   --  宆 (<CJK Ideograph>)
          2121  => 16#5B8A#,   --  宊 (<CJK Ideograph>)
          2122  => 16#5B8D#,   --  宍 (<CJK Ideograph>)
          2123  => 16#5B8E#,   --  宎 (<CJK Ideograph>)
          2124  => 16#5B90#,   --  宐 (<CJK Ideograph>)
          2125  => 16#5B91#,   --  宑 (<CJK Ideograph>)
          2126  => 16#5B92#,   --  宒 (<CJK Ideograph>)
          2127  => 16#5B94#,   --  宔 (<CJK Ideograph>)
          2128  => 16#5B96#,   --  宖 (<CJK Ideograph>)
          2129  => 16#5B9F#,   --  実 (<CJK Ideograph>)
          2130  => 16#5BA7#,   --  宧 (<CJK Ideograph>)
          2131  => 16#5BA8#,   --  宨 (<CJK Ideograph>)
          2132  => 16#5BA9#,   --  宩 (<CJK Ideograph>)
          2133  => 16#5BAC#,   --  宬 (<CJK Ideograph>)
          2134  => 16#5BAD#,   --  宭 (<CJK Ideograph>)
          2135  => 16#5BAE#,   --  宮 (<CJK Ideograph>)
          2136  => 16#5BAF#,   --  宯 (<CJK Ideograph>)
          2137  => 16#5BB1#,   --  宱 (<CJK Ideograph>)
          2138  => 16#5BB2#,   --  宲 (<CJK Ideograph>)
          2139  => 16#5BB7#,   --  宷 (<CJK Ideograph>)
          2140  => 16#5BBA#,   --  宺 (<CJK Ideograph>)
          2141  => 16#5BBB#,   --  宻 (<CJK Ideograph>)
          2142  => 16#5BBC#,   --  宼 (<CJK Ideograph>)
          2143  => 16#5BC0#,   --  寀 (<CJK Ideograph>)
          2144  => 16#5BC1#,   --  寁 (<CJK Ideograph>)
          2145  => 16#5BC3#,   --  寃 (<CJK Ideograph>)
          2146  => 16#5BC8#,   --  寈 (<CJK Ideograph>)
          2147  => 16#5BC9#,   --  寉 (<CJK Ideograph>)
          2148  => 16#5BCA#,   --  寊 (<CJK Ideograph>)
          2149  => 16#5BCB#,   --  寋 (<CJK Ideograph>)
          2150  => 16#5BCD#,   --  寍 (<CJK Ideograph>)
          2151  => 16#5BCE#,   --  寎 (<CJK Ideograph>)
          2152  => 16#5BCF#,   --  寏 (<CJK Ideograph>)
          2153  => 16#5BD1#,   --  寑 (<CJK Ideograph>)
          2154  => 16#5BD4#,   --  寔 (<CJK Ideograph>)
          2155  => 16#5BD5#,   --  寕 (<CJK Ideograph>)
          2156  => 16#5BD6#,   --  寖 (<CJK Ideograph>)
          2157  => 16#5BD7#,   --  寗 (<CJK Ideograph>)
          2158  => 16#5BD8#,   --  寘 (<CJK Ideograph>)
          2159  => 16#5BD9#,   --  寙 (<CJK Ideograph>)
          2160  => 16#5BDA#,   --  寚 (<CJK Ideograph>)
          2161  => 16#5BDB#,   --  寛 (<CJK Ideograph>)
          2162  => 16#5BDC#,   --  寜 (<CJK Ideograph>)
          2163  => 16#5BE0#,   --  寠 (<CJK Ideograph>)
          2164  => 16#5BE2#,   --  寢 (<CJK Ideograph>)
          2165  => 16#5BE3#,   --  寣 (<CJK Ideograph>)
          2166  => 16#5BE6#,   --  實 (<CJK Ideograph>)
          2167  => 16#5BE7#,   --  寧 (<CJK Ideograph>)
          2168  => 16#5BE9#,   --  審 (<CJK Ideograph>)
          2169  => 16#5BEA#,   --  寪 (<CJK Ideograph>)
          2170  => 16#5BEB#,   --  寫 (<CJK Ideograph>)
          2171  => 16#5BEC#,   --  寬 (<CJK Ideograph>)
          2172  => 16#5BED#,   --  寭 (<CJK Ideograph>)
          2173  => 16#5BEF#,   --  寯 (<CJK Ideograph>)
          2174  => 16#5BF1#,   --  寱 (<CJK Ideograph>)
          2175  => 16#5BF2#,   --  寲 (<CJK Ideograph>)
          2176  => 16#5BF3#,   --  寳 (<CJK Ideograph>)
          2177  => 16#5BF4#,   --  寴 (<CJK Ideograph>)
          2178  => 16#5BF5#,   --  寵 (<CJK Ideograph>)
          2179  => 16#5BF6#,   --  寶 (<CJK Ideograph>)
          2180  => 16#5BF7#,   --  寷 (<CJK Ideograph>)
          2181  => 16#5BFD#,   --  寽 (<CJK Ideograph>)
          2182  => 16#5BFE#,   --  対 (<CJK Ideograph>)
          2183  => 16#5C00#,   --  尀 (<CJK Ideograph>)
          2184  => 16#5C02#,   --  専 (<CJK Ideograph>)
          2185  => 16#5C03#,   --  尃 (<CJK Ideograph>)
          2186  => 16#5C05#,   --  尅 (<CJK Ideograph>)
          2187  => 16#5C07#,   --  將 (<CJK Ideograph>)
          2188  => 16#5C08#,   --  專 (<CJK Ideograph>)
          2189  => 16#5C0B#,   --  尋 (<CJK Ideograph>)
          2190  => 16#5C0C#,   --  尌 (<CJK Ideograph>)
          2191  => 16#5C0D#,   --  對 (<CJK Ideograph>)
          2192  => 16#5C0E#,   --  導 (<CJK Ideograph>)
          2193  => 16#5C10#,   --  尐 (<CJK Ideograph>)
          2194  => 16#5C12#,   --  尒 (<CJK Ideograph>)
          2195  => 16#5C13#,   --  尓 (<CJK Ideograph>)
          2196  => 16#5C17#,   --  尗 (<CJK Ideograph>)
          2197  => 16#5C19#,   --  尙 (<CJK Ideograph>)
          2198  => 16#5C1B#,   --  尛 (<CJK Ideograph>)
          2199  => 16#5C1E#,   --  尞 (<CJK Ideograph>)
          2200  => 16#5C1F#,   --  尟 (<CJK Ideograph>)
          2201  => 16#5C20#,   --  尠 (<CJK Ideograph>)
          2202  => 16#5C21#,   --  尡 (<CJK Ideograph>)
          2203  => 16#5C23#,   --  尣 (<CJK Ideograph>)
          2204  => 16#5C26#,   --  尦 (<CJK Ideograph>)
          2205  => 16#5C28#,   --  尨 (<CJK Ideograph>)
          2206  => 16#5C29#,   --  尩 (<CJK Ideograph>)
          2207  => 16#5C2A#,   --  尪 (<CJK Ideograph>)
          2208  => 16#5C2B#,   --  尫 (<CJK Ideograph>)
          2209  => 16#5C2D#,   --  尭 (<CJK Ideograph>)
          2210  => 16#5C2E#,   --  尮 (<CJK Ideograph>)
          2211  => 16#5C2F#,   --  尯 (<CJK Ideograph>)
          2212  => 16#5C30#,   --  尰 (<CJK Ideograph>)
          2213  => 16#5C32#,   --  尲 (<CJK Ideograph>)
          2214  => 16#5C33#,   --  尳 (<CJK Ideograph>)
          2215  => 16#5C35#,   --  尵 (<CJK Ideograph>)
          2216  => 16#5C36#,   --  尶 (<CJK Ideograph>)
          2217  => 16#5C37#,   --  尷 (<CJK Ideograph>)
          2218  => 16#5C43#,   --  屃 (<CJK Ideograph>)
          2219  => 16#5C44#,   --  屄 (<CJK Ideograph>)
          2220  => 16#5C46#,   --  屆 (<CJK Ideograph>)
          2221  => 16#5C47#,   --  屇 (<CJK Ideograph>)
          2222  => 16#5C4C#,   --  屌 (<CJK Ideograph>)
          2223  => 16#5C4D#,   --  屍 (<CJK Ideograph>)
          2224  => 16#5C52#,   --  屒 (<CJK Ideograph>)
          2225  => 16#5C53#,   --  屓 (<CJK Ideograph>)
          2226  => 16#5C54#,   --  屔 (<CJK Ideograph>)
          2227  => 16#5C56#,   --  屖 (<CJK Ideograph>)
          2228  => 16#5C57#,   --  屗 (<CJK Ideograph>)
          2229  => 16#5C58#,   --  屘 (<CJK Ideograph>)
          2230  => 16#5C5A#,   --  屚 (<CJK Ideograph>)
          2231  => 16#5C5B#,   --  屛 (<CJK Ideograph>)
          2232  => 16#5C5C#,   --  屜 (<CJK Ideograph>)
          2233  => 16#5C5D#,   --  屝 (<CJK Ideograph>)
          2234  => 16#5C5F#,   --  屟 (<CJK Ideograph>)
          2235  => 16#5C62#,   --  屢 (<CJK Ideograph>)
          2236  => 16#5C64#,   --  層 (<CJK Ideograph>)
          2237  => 16#5C67#,   --  屧 (<CJK Ideograph>)
          2238  => 16#5C68#,   --  屨 (<CJK Ideograph>)
          2239  => 16#5C69#,   --  屩 (<CJK Ideograph>)
          2240  => 16#5C6A#,   --  屪 (<CJK Ideograph>)
          2241  => 16#5C6B#,   --  屫 (<CJK Ideograph>)
          2242  => 16#5C6C#,   --  屬 (<CJK Ideograph>)
          2243  => 16#5C6D#,   --  屭 (<CJK Ideograph>)
          2244  => 16#5C70#,   --  屰 (<CJK Ideograph>)
          2245  => 16#5C72#,   --  屲 (<CJK Ideograph>)
          2246  => 16#5C73#,   --  屳 (<CJK Ideograph>)
          2247  => 16#5C74#,   --  屴 (<CJK Ideograph>)
          2248  => 16#5C75#,   --  屵 (<CJK Ideograph>)
          2249  => 16#5C76#,   --  屶 (<CJK Ideograph>)
          2250  => 16#5C77#,   --  屷 (<CJK Ideograph>)
          2251  => 16#5C78#,   --  屸 (<CJK Ideograph>)
          2252  => 16#5C7B#,   --  屻 (<CJK Ideograph>)
          2253  => 16#5C7C#,   --  屼 (<CJK Ideograph>)
          2254  => 16#5C7D#,   --  屽 (<CJK Ideograph>)
          2255  => 16#5C7E#,   --  屾 (<CJK Ideograph>)
          2256  => 16#5C80#,   --  岀 (<CJK Ideograph>)
          2257  => 16#5C83#,   --  岃 (<CJK Ideograph>)
          2258  => 16#5C84#,   --  岄 (<CJK Ideograph>)
          2259  => 16#5C85#,   --  岅 (<CJK Ideograph>)
          2260  => 16#5C86#,   --  岆 (<CJK Ideograph>)
          2261  => 16#5C87#,   --  岇 (<CJK Ideograph>)
          2262  => 16#5C89#,   --  岉 (<CJK Ideograph>)
          2263  => 16#5C8A#,   --  岊 (<CJK Ideograph>)
          2264  => 16#5C8B#,   --  岋 (<CJK Ideograph>)
          2265  => 16#5C8E#,   --  岎 (<CJK Ideograph>)
          2266  => 16#5C8F#,   --  岏 (<CJK Ideograph>)
          2267  => 16#5C92#,   --  岒 (<CJK Ideograph>)
          2268  => 16#5C93#,   --  岓 (<CJK Ideograph>)
          2269  => 16#5C95#,   --  岕 (<CJK Ideograph>)
          2270  => 16#5C9D#,   --  岝 (<CJK Ideograph>)
          2271  => 16#5C9E#,   --  岞 (<CJK Ideograph>)
          2272  => 16#5C9F#,   --  岟 (<CJK Ideograph>)
          2273  => 16#5CA0#,   --  岠 (<CJK Ideograph>)
          2274  => 16#5CA1#,   --  岡 (<CJK Ideograph>)
          2275  => 16#5CA4#,   --  岤 (<CJK Ideograph>)
          2276  => 16#5CA5#,   --  岥 (<CJK Ideograph>)
          2277  => 16#5CA6#,   --  岦 (<CJK Ideograph>)
          2278  => 16#5CA7#,   --  岧 (<CJK Ideograph>)
          2279  => 16#5CA8#,   --  岨 (<CJK Ideograph>)
          2280  => 16#5CAA#,   --  岪 (<CJK Ideograph>)
          2281  => 16#5CAE#,   --  岮 (<CJK Ideograph>)
          2282  => 16#5CAF#,   --  岯 (<CJK Ideograph>)
          2283  => 16#5CB0#,   --  岰 (<CJK Ideograph>)
          2284  => 16#5CB2#,   --  岲 (<CJK Ideograph>)
          2285  => 16#5CB4#,   --  岴 (<CJK Ideograph>)
          2286  => 16#5CB6#,   --  岶 (<CJK Ideograph>)
          2287  => 16#5CB9#,   --  岹 (<CJK Ideograph>)
          2288  => 16#5CBA#,   --  岺 (<CJK Ideograph>)
          2289  => 16#5CBB#,   --  岻 (<CJK Ideograph>)
          2290  => 16#5CBC#,   --  岼 (<CJK Ideograph>)
          2291  => 16#5CBE#,   --  岾 (<CJK Ideograph>)
          2292  => 16#5CC0#,   --  峀 (<CJK Ideograph>)
          2293  => 16#5CC2#,   --  峂 (<CJK Ideograph>)
          2294  => 16#5CC3#,   --  峃 (<CJK Ideograph>)
          2295  => 16#5CC5#,   --  峅 (<CJK Ideograph>)
          2296  => 16#5CC6#,   --  峆 (<CJK Ideograph>)
          2297  => 16#5CC7#,   --  峇 (<CJK Ideograph>)
          2298  => 16#5CC8#,   --  峈 (<CJK Ideograph>)
          2299  => 16#5CC9#,   --  峉 (<CJK Ideograph>)
          2300  => 16#5CCA#,   --  峊 (<CJK Ideograph>)
          2301  => 16#5CCC#,   --  峌 (<CJK Ideograph>)
          2302  => 16#5CCD#,   --  峍 (<CJK Ideograph>)
          2303  => 16#5CCE#,   --  峎 (<CJK Ideograph>)
          2304  => 16#5CCF#,   --  峏 (<CJK Ideograph>)
          2305  => 16#5CD0#,   --  峐 (<CJK Ideograph>)
          2306  => 16#5CD1#,   --  峑 (<CJK Ideograph>)
          2307  => 16#5CD3#,   --  峓 (<CJK Ideograph>)
          2308  => 16#5CD4#,   --  峔 (<CJK Ideograph>)
          2309  => 16#5CD5#,   --  峕 (<CJK Ideograph>)
          2310  => 16#5CD6#,   --  峖 (<CJK Ideograph>)
          2311  => 16#5CD7#,   --  峗 (<CJK Ideograph>)
          2312  => 16#5CD8#,   --  峘 (<CJK Ideograph>)
          2313  => 16#5CDA#,   --  峚 (<CJK Ideograph>)
          2314  => 16#5CDB#,   --  峛 (<CJK Ideograph>)
          2315  => 16#5CDC#,   --  峜 (<CJK Ideograph>)
          2316  => 16#5CDD#,   --  峝 (<CJK Ideograph>)
          2317  => 16#5CDE#,   --  峞 (<CJK Ideograph>)
          2318  => 16#5CDF#,   --  峟 (<CJK Ideograph>)
          2319  => 16#5CE0#,   --  峠 (<CJK Ideograph>)
          2320  => 16#5CE2#,   --  峢 (<CJK Ideograph>)
          2321  => 16#5CE3#,   --  峣 (<CJK Ideograph>)
          2322  => 16#5CE7#,   --  峧 (<CJK Ideograph>)
          2323  => 16#5CE9#,   --  峩 (<CJK Ideograph>)
          2324  => 16#5CEB#,   --  峫 (<CJK Ideograph>)
          2325  => 16#5CEC#,   --  峬 (<CJK Ideograph>)
          2326  => 16#5CEE#,   --  峮 (<CJK Ideograph>)
          2327  => 16#5CEF#,   --  峯 (<CJK Ideograph>)
          2328  => 16#5CF1#,   --  峱 (<CJK Ideograph>)
          2329  => 16#5CF2#,   --  峲 (<CJK Ideograph>)
          2330  => 16#5CF3#,   --  峳 (<CJK Ideograph>)
          2331  => 16#5CF4#,   --  峴 (<CJK Ideograph>)
          2332  => 16#5CF5#,   --  峵 (<CJK Ideograph>)
          2333  => 16#5CF6#,   --  島 (<CJK Ideograph>)
          2334  => 16#5CF7#,   --  峷 (<CJK Ideograph>)
          2335  => 16#5CF8#,   --  峸 (<CJK Ideograph>)
          2336  => 16#5CF9#,   --  峹 (<CJK Ideograph>)
          2337  => 16#5CFA#,   --  峺 (<CJK Ideograph>)
          2338  => 16#5CFC#,   --  峼 (<CJK Ideograph>)
          2339  => 16#5CFD#,   --  峽 (<CJK Ideograph>)
          2340  => 16#5CFE#,   --  峾 (<CJK Ideograph>)
          2341  => 16#5CFF#,   --  峿 (<CJK Ideograph>)
          2342  => 16#5D00#,   --  崀 (<CJK Ideograph>)
          2343  => 16#5D01#,   --  崁 (<CJK Ideograph>)
          2344  => 16#5D04#,   --  崄 (<CJK Ideograph>)
          2345  => 16#5D05#,   --  崅 (<CJK Ideograph>)
          2346  => 16#5D08#,   --  崈 (<CJK Ideograph>)
          2347  => 16#5D09#,   --  崉 (<CJK Ideograph>)
          2348  => 16#5D0A#,   --  崊 (<CJK Ideograph>)
          2349  => 16#5D0B#,   --  崋 (<CJK Ideograph>)
          2350  => 16#5D0C#,   --  崌 (<CJK Ideograph>)
          2351  => 16#5D0D#,   --  崍 (<CJK Ideograph>)
          2352  => 16#5D0F#,   --  崏 (<CJK Ideograph>)
          2353  => 16#5D10#,   --  崐 (<CJK Ideograph>)
          2354  => 16#5D11#,   --  崑 (<CJK Ideograph>)
          2355  => 16#5D12#,   --  崒 (<CJK Ideograph>)
          2356  => 16#5D13#,   --  崓 (<CJK Ideograph>)
          2357  => 16#5D15#,   --  崕 (<CJK Ideograph>)
          2358  => 16#5D17#,   --  崗 (<CJK Ideograph>)
          2359  => 16#5D18#,   --  崘 (<CJK Ideograph>)
          2360  => 16#5D19#,   --  崙 (<CJK Ideograph>)
          2361  => 16#5D1A#,   --  崚 (<CJK Ideograph>)
          2362  => 16#5D1C#,   --  崜 (<CJK Ideograph>)
          2363  => 16#5D1D#,   --  崝 (<CJK Ideograph>)
          2364  => 16#5D1F#,   --  崟 (<CJK Ideograph>)
          2365  => 16#5D20#,   --  崠 (<CJK Ideograph>)
          2366  => 16#5D21#,   --  崡 (<CJK Ideograph>)
          2367  => 16#5D22#,   --  崢 (<CJK Ideograph>)
          2368  => 16#5D23#,   --  崣 (<CJK Ideograph>)
          2369  => 16#5D25#,   --  崥 (<CJK Ideograph>)
          2370  => 16#5D28#,   --  崨 (<CJK Ideograph>)
          2371  => 16#5D2A#,   --  崪 (<CJK Ideograph>)
          2372  => 16#5D2B#,   --  崫 (<CJK Ideograph>)
          2373  => 16#5D2C#,   --  崬 (<CJK Ideograph>)
          2374  => 16#5D2F#,   --  崯 (<CJK Ideograph>)
          2375  => 16#5D30#,   --  崰 (<CJK Ideograph>)
          2376  => 16#5D31#,   --  崱 (<CJK Ideograph>)
          2377  => 16#5D32#,   --  崲 (<CJK Ideograph>)
          2378  => 16#5D33#,   --  崳 (<CJK Ideograph>)
          2379  => 16#5D35#,   --  崵 (<CJK Ideograph>)
          2380  => 16#5D36#,   --  崶 (<CJK Ideograph>)
          2381  => 16#5D37#,   --  崷 (<CJK Ideograph>)
          2382  => 16#5D38#,   --  崸 (<CJK Ideograph>)
          2383  => 16#5D39#,   --  崹 (<CJK Ideograph>)
          2384  => 16#5D3A#,   --  崺 (<CJK Ideograph>)
          2385  => 16#5D3B#,   --  崻 (<CJK Ideograph>)
          2386  => 16#5D3C#,   --  崼 (<CJK Ideograph>)
          2387  => 16#5D3F#,   --  崿 (<CJK Ideograph>)
          2388  => 16#5D40#,   --  嵀 (<CJK Ideograph>)
          2389  => 16#5D41#,   --  嵁 (<CJK Ideograph>)
          2390  => 16#5D42#,   --  嵂 (<CJK Ideograph>)
          2391  => 16#5D43#,   --  嵃 (<CJK Ideograph>)
          2392  => 16#5D44#,   --  嵄 (<CJK Ideograph>)
          2393  => 16#5D45#,   --  嵅 (<CJK Ideograph>)
          2394  => 16#5D46#,   --  嵆 (<CJK Ideograph>)
          2395  => 16#5D48#,   --  嵈 (<CJK Ideograph>)
          2396  => 16#5D49#,   --  嵉 (<CJK Ideograph>)
          2397  => 16#5D4D#,   --  嵍 (<CJK Ideograph>)
          2398  => 16#5D4E#,   --  嵎 (<CJK Ideograph>)
          2399  => 16#5D4F#,   --  嵏 (<CJK Ideograph>)
          2400  => 16#5D50#,   --  嵐 (<CJK Ideograph>)
          2401  => 16#5D51#,   --  嵑 (<CJK Ideograph>)
          2402  => 16#5D52#,   --  嵒 (<CJK Ideograph>)
          2403  => 16#5D53#,   --  嵓 (<CJK Ideograph>)
          2404  => 16#5D54#,   --  嵔 (<CJK Ideograph>)
          2405  => 16#5D55#,   --  嵕 (<CJK Ideograph>)
          2406  => 16#5D56#,   --  嵖 (<CJK Ideograph>)
          2407  => 16#5D57#,   --  嵗 (<CJK Ideograph>)
          2408  => 16#5D59#,   --  嵙 (<CJK Ideograph>)
          2409  => 16#5D5A#,   --  嵚 (<CJK Ideograph>)
          2410  => 16#5D5C#,   --  嵜 (<CJK Ideograph>)
          2411  => 16#5D5E#,   --  嵞 (<CJK Ideograph>)
          2412  => 16#5D5F#,   --  嵟 (<CJK Ideograph>)
          2413  => 16#5D60#,   --  嵠 (<CJK Ideograph>)
          2414  => 16#5D61#,   --  嵡 (<CJK Ideograph>)
          2415  => 16#5D62#,   --  嵢 (<CJK Ideograph>)
          2416  => 16#5D63#,   --  嵣 (<CJK Ideograph>)
          2417  => 16#5D64#,   --  嵤 (<CJK Ideograph>)
          2418  => 16#5D65#,   --  嵥 (<CJK Ideograph>)
          2419  => 16#5D66#,   --  嵦 (<CJK Ideograph>)
          2420  => 16#5D67#,   --  嵧 (<CJK Ideograph>)
          2421  => 16#5D68#,   --  嵨 (<CJK Ideograph>)
          2422  => 16#5D6A#,   --  嵪 (<CJK Ideograph>)
          2423  => 16#5D6D#,   --  嵭 (<CJK Ideograph>)
          2424  => 16#5D6E#,   --  嵮 (<CJK Ideograph>)
          2425  => 16#5D70#,   --  嵰 (<CJK Ideograph>)
          2426  => 16#5D71#,   --  嵱 (<CJK Ideograph>)
          2427  => 16#5D72#,   --  嵲 (<CJK Ideograph>)
          2428  => 16#5D73#,   --  嵳 (<CJK Ideograph>)
          2429  => 16#5D75#,   --  嵵 (<CJK Ideograph>)
          2430  => 16#5D76#,   --  嵶 (<CJK Ideograph>)
          2431  => 16#5D77#,   --  嵷 (<CJK Ideograph>)
          2432  => 16#5D78#,   --  嵸 (<CJK Ideograph>)
          2433  => 16#5D79#,   --  嵹 (<CJK Ideograph>)
          2434  => 16#5D7A#,   --  嵺 (<CJK Ideograph>)
          2435  => 16#5D7B#,   --  嵻 (<CJK Ideograph>)
          2436  => 16#5D7C#,   --  嵼 (<CJK Ideograph>)
          2437  => 16#5D7D#,   --  嵽 (<CJK Ideograph>)
          2438  => 16#5D7E#,   --  嵾 (<CJK Ideograph>)
          2439  => 16#5D7F#,   --  嵿 (<CJK Ideograph>)
          2440  => 16#5D80#,   --  嶀 (<CJK Ideograph>)
          2441  => 16#5D81#,   --  嶁 (<CJK Ideograph>)
          2442  => 16#5D83#,   --  嶃 (<CJK Ideograph>)
          2443  => 16#5D84#,   --  嶄 (<CJK Ideograph>)
          2444  => 16#5D85#,   --  嶅 (<CJK Ideograph>)
          2445  => 16#5D86#,   --  嶆 (<CJK Ideograph>)
          2446  => 16#5D87#,   --  嶇 (<CJK Ideograph>)
          2447  => 16#5D88#,   --  嶈 (<CJK Ideograph>)
          2448  => 16#5D89#,   --  嶉 (<CJK Ideograph>)
          2449  => 16#5D8A#,   --  嶊 (<CJK Ideograph>)
          2450  => 16#5D8B#,   --  嶋 (<CJK Ideograph>)
          2451  => 16#5D8C#,   --  嶌 (<CJK Ideograph>)
          2452  => 16#5D8D#,   --  嶍 (<CJK Ideograph>)
          2453  => 16#5D8E#,   --  嶎 (<CJK Ideograph>)
          2454  => 16#5D8F#,   --  嶏 (<CJK Ideograph>)
          2455  => 16#5D90#,   --  嶐 (<CJK Ideograph>)
          2456  => 16#5D91#,   --  嶑 (<CJK Ideograph>)
          2457  => 16#5D92#,   --  嶒 (<CJK Ideograph>)
          2458  => 16#5D93#,   --  嶓 (<CJK Ideograph>)
          2459  => 16#5D94#,   --  嶔 (<CJK Ideograph>)
          2460  => 16#5D95#,   --  嶕 (<CJK Ideograph>)
          2461  => 16#5D96#,   --  嶖 (<CJK Ideograph>)
          2462  => 16#5D97#,   --  嶗 (<CJK Ideograph>)
          2463  => 16#5D98#,   --  嶘 (<CJK Ideograph>)
          2464  => 16#5D9A#,   --  嶚 (<CJK Ideograph>)
          2465  => 16#5D9B#,   --  嶛 (<CJK Ideograph>)
          2466  => 16#5D9C#,   --  嶜 (<CJK Ideograph>)
          2467  => 16#5D9E#,   --  嶞 (<CJK Ideograph>)
          2468  => 16#5D9F#,   --  嶟 (<CJK Ideograph>)
          2469  => 16#5DA0#,   --  嶠 (<CJK Ideograph>)
          2470  => 16#5DA1#,   --  嶡 (<CJK Ideograph>)
          2471  => 16#5DA2#,   --  嶢 (<CJK Ideograph>)
          2472  => 16#5DA3#,   --  嶣 (<CJK Ideograph>)
          2473  => 16#5DA4#,   --  嶤 (<CJK Ideograph>)
          2474  => 16#5DA5#,   --  嶥 (<CJK Ideograph>)
          2475  => 16#5DA6#,   --  嶦 (<CJK Ideograph>)
          2476  => 16#5DA7#,   --  嶧 (<CJK Ideograph>)
          2477  => 16#5DA8#,   --  嶨 (<CJK Ideograph>)
          2478  => 16#5DA9#,   --  嶩 (<CJK Ideograph>)
          2479  => 16#5DAA#,   --  嶪 (<CJK Ideograph>)
          2480  => 16#5DAB#,   --  嶫 (<CJK Ideograph>)
          2481  => 16#5DAC#,   --  嶬 (<CJK Ideograph>)
          2482  => 16#5DAD#,   --  嶭 (<CJK Ideograph>)
          2483  => 16#5DAE#,   --  嶮 (<CJK Ideograph>)
          2484  => 16#5DAF#,   --  嶯 (<CJK Ideograph>)
          2485  => 16#5DB0#,   --  嶰 (<CJK Ideograph>)
          2486  => 16#5DB1#,   --  嶱 (<CJK Ideograph>)
          2487  => 16#5DB2#,   --  嶲 (<CJK Ideograph>)
          2488  => 16#5DB3#,   --  嶳 (<CJK Ideograph>)
          2489  => 16#5DB4#,   --  嶴 (<CJK Ideograph>)
          2490  => 16#5DB5#,   --  嶵 (<CJK Ideograph>)
          2491  => 16#5DB6#,   --  嶶 (<CJK Ideograph>)
          2492  => 16#5DB8#,   --  嶸 (<CJK Ideograph>)
          2493  => 16#5DB9#,   --  嶹 (<CJK Ideograph>)
          2494  => 16#5DBA#,   --  嶺 (<CJK Ideograph>)
          2495  => 16#5DBB#,   --  嶻 (<CJK Ideograph>)
          2496  => 16#5DBC#,   --  嶼 (<CJK Ideograph>)
          2497  => 16#5DBD#,   --  嶽 (<CJK Ideograph>)
          2498  => 16#5DBE#,   --  嶾 (<CJK Ideograph>)
          2499  => 16#5DBF#,   --  嶿 (<CJK Ideograph>)
          2500  => 16#5DC0#,   --  巀 (<CJK Ideograph>)
          2501  => 16#5DC1#,   --  巁 (<CJK Ideograph>)
          2502  => 16#5DC2#,   --  巂 (<CJK Ideograph>)
          2503  => 16#5DC3#,   --  巃 (<CJK Ideograph>)
          2504  => 16#5DC4#,   --  巄 (<CJK Ideograph>)
          2505  => 16#5DC6#,   --  巆 (<CJK Ideograph>)
          2506  => 16#5DC7#,   --  巇 (<CJK Ideograph>)
          2507  => 16#5DC8#,   --  巈 (<CJK Ideograph>)
          2508  => 16#5DC9#,   --  巉 (<CJK Ideograph>)
          2509  => 16#5DCA#,   --  巊 (<CJK Ideograph>)
          2510  => 16#5DCB#,   --  巋 (<CJK Ideograph>)
          2511  => 16#5DCC#,   --  巌 (<CJK Ideograph>)
          2512  => 16#5DCE#,   --  巎 (<CJK Ideograph>)
          2513  => 16#5DCF#,   --  巏 (<CJK Ideograph>)
          2514  => 16#5DD0#,   --  巐 (<CJK Ideograph>)
          2515  => 16#5DD1#,   --  巑 (<CJK Ideograph>)
          2516  => 16#5DD2#,   --  巒 (<CJK Ideograph>)
          2517  => 16#5DD3#,   --  巓 (<CJK Ideograph>)
          2518  => 16#5DD4#,   --  巔 (<CJK Ideograph>)
          2519  => 16#5DD5#,   --  巕 (<CJK Ideograph>)
          2520  => 16#5DD6#,   --  巖 (<CJK Ideograph>)
          2521  => 16#5DD7#,   --  巗 (<CJK Ideograph>)
          2522  => 16#5DD8#,   --  巘 (<CJK Ideograph>)
          2523  => 16#5DD9#,   --  巙 (<CJK Ideograph>)
          2524  => 16#5DDA#,   --  巚 (<CJK Ideograph>)
          2525  => 16#5DDC#,   --  巜 (<CJK Ideograph>)
          2526  => 16#5DDF#,   --  巟 (<CJK Ideograph>)
          2527  => 16#5DE0#,   --  巠 (<CJK Ideograph>)
          2528  => 16#5DE3#,   --  巣 (<CJK Ideograph>)
          2529  => 16#5DE4#,   --  巤 (<CJK Ideograph>)
          2530  => 16#5DEA#,   --  巪 (<CJK Ideograph>)
          2531  => 16#5DEC#,   --  巬 (<CJK Ideograph>)
          2532  => 16#5DED#,   --  巭 (<CJK Ideograph>)
          2533  => 16#5DF0#,   --  巰 (<CJK Ideograph>)
          2534  => 16#5DF5#,   --  巵 (<CJK Ideograph>)
          2535  => 16#5DF6#,   --  巶 (<CJK Ideograph>)
          2536  => 16#5DF8#,   --  巸 (<CJK Ideograph>)
          2537  => 16#5DF9#,   --  巹 (<CJK Ideograph>)
          2538  => 16#5DFA#,   --  巺 (<CJK Ideograph>)
          2539  => 16#5DFB#,   --  巻 (<CJK Ideograph>)
          2540  => 16#5DFC#,   --  巼 (<CJK Ideograph>)
          2541  => 16#5DFF#,   --  巿 (<CJK Ideograph>)
          2542  => 16#5E00#,   --  帀 (<CJK Ideograph>)
          2543  => 16#5E04#,   --  帄 (<CJK Ideograph>)
          2544  => 16#5E07#,   --  帇 (<CJK Ideograph>)
          2545  => 16#5E09#,   --  帉 (<CJK Ideograph>)
          2546  => 16#5E0A#,   --  帊 (<CJK Ideograph>)
          2547  => 16#5E0B#,   --  帋 (<CJK Ideograph>)
          2548  => 16#5E0D#,   --  帍 (<CJK Ideograph>)
          2549  => 16#5E0E#,   --  帎 (<CJK Ideograph>)
          2550  => 16#5E12#,   --  帒 (<CJK Ideograph>)
          2551  => 16#5E13#,   --  帓 (<CJK Ideograph>)
          2552  => 16#5E17#,   --  帗 (<CJK Ideograph>)
          2553  => 16#5E1E#,   --  帞 (<CJK Ideograph>)
          2554  => 16#5E1F#,   --  帟 (<CJK Ideograph>)
          2555  => 16#5E20#,   --  帠 (<CJK Ideograph>)
          2556  => 16#5E21#,   --  帡 (<CJK Ideograph>)
          2557  => 16#5E22#,   --  帢 (<CJK Ideograph>)
          2558  => 16#5E23#,   --  帣 (<CJK Ideograph>)
          2559  => 16#5E24#,   --  帤 (<CJK Ideograph>)
          2560  => 16#5E25#,   --  帥 (<CJK Ideograph>)
          2561  => 16#5E28#,   --  帨 (<CJK Ideograph>)
          2562  => 16#5E29#,   --  帩 (<CJK Ideograph>)
          2563  => 16#5E2A#,   --  帪 (<CJK Ideograph>)
          2564  => 16#5E2B#,   --  師 (<CJK Ideograph>)
          2565  => 16#5E2C#,   --  帬 (<CJK Ideograph>)
          2566  => 16#5E2F#,   --  帯 (<CJK Ideograph>)
          2567  => 16#5E30#,   --  帰 (<CJK Ideograph>)
          2568  => 16#5E32#,   --  帲 (<CJK Ideograph>)
          2569  => 16#5E33#,   --  帳 (<CJK Ideograph>)
          2570  => 16#5E34#,   --  帴 (<CJK Ideograph>)
          2571  => 16#5E35#,   --  帵 (<CJK Ideograph>)
          2572  => 16#5E36#,   --  帶 (<CJK Ideograph>)
          2573  => 16#5E39#,   --  帹 (<CJK Ideograph>)
          2574  => 16#5E3A#,   --  帺 (<CJK Ideograph>)
          2575  => 16#5E3E#,   --  帾 (<CJK Ideograph>)
          2576  => 16#5E3F#,   --  帿 (<CJK Ideograph>)
          2577  => 16#5E40#,   --  幀 (<CJK Ideograph>)
          2578  => 16#5E41#,   --  幁 (<CJK Ideograph>)
          2579  => 16#5E43#,   --  幃 (<CJK Ideograph>)
          2580  => 16#5E46#,   --  幆 (<CJK Ideograph>)
          2581  => 16#5E47#,   --  幇 (<CJK Ideograph>)
          2582  => 16#5E48#,   --  幈 (<CJK Ideograph>)
          2583  => 16#5E49#,   --  幉 (<CJK Ideograph>)
          2584  => 16#5E4A#,   --  幊 (<CJK Ideograph>)
          2585  => 16#5E4B#,   --  幋 (<CJK Ideograph>)
          2586  => 16#5E4D#,   --  幍 (<CJK Ideograph>)
          2587  => 16#5E4E#,   --  幎 (<CJK Ideograph>)
          2588  => 16#5E4F#,   --  幏 (<CJK Ideograph>)
          2589  => 16#5E50#,   --  幐 (<CJK Ideograph>)
          2590  => 16#5E51#,   --  幑 (<CJK Ideograph>)
          2591  => 16#5E52#,   --  幒 (<CJK Ideograph>)
          2592  => 16#5E53#,   --  幓 (<CJK Ideograph>)
          2593  => 16#5E56#,   --  幖 (<CJK Ideograph>)
          2594  => 16#5E57#,   --  幗 (<CJK Ideograph>)
          2595  => 16#5E58#,   --  幘 (<CJK Ideograph>)
          2596  => 16#5E59#,   --  幙 (<CJK Ideograph>)
          2597  => 16#5E5A#,   --  幚 (<CJK Ideograph>)
          2598  => 16#5E5C#,   --  幜 (<CJK Ideograph>)
          2599  => 16#5E5D#,   --  幝 (<CJK Ideograph>)
          2600  => 16#5E5F#,   --  幟 (<CJK Ideograph>)
          2601  => 16#5E60#,   --  幠 (<CJK Ideograph>)
          2602  => 16#5E63#,   --  幣 (<CJK Ideograph>)
          2603  => 16#5E64#,   --  幤 (<CJK Ideograph>)
          2604  => 16#5E65#,   --  幥 (<CJK Ideograph>)
          2605  => 16#5E66#,   --  幦 (<CJK Ideograph>)
          2606  => 16#5E67#,   --  幧 (<CJK Ideograph>)
          2607  => 16#5E68#,   --  幨 (<CJK Ideograph>)
          2608  => 16#5E69#,   --  幩 (<CJK Ideograph>)
          2609  => 16#5E6A#,   --  幪 (<CJK Ideograph>)
          2610  => 16#5E6B#,   --  幫 (<CJK Ideograph>)
          2611  => 16#5E6C#,   --  幬 (<CJK Ideograph>)
          2612  => 16#5E6D#,   --  幭 (<CJK Ideograph>)
          2613  => 16#5E6E#,   --  幮 (<CJK Ideograph>)
          2614  => 16#5E6F#,   --  幯 (<CJK Ideograph>)
          2615  => 16#5E70#,   --  幰 (<CJK Ideograph>)
          2616  => 16#5E71#,   --  幱 (<CJK Ideograph>)
          2617  => 16#5E75#,   --  幵 (<CJK Ideograph>)
          2618  => 16#5E77#,   --  幷 (<CJK Ideograph>)
          2619  => 16#5E79#,   --  幹 (<CJK Ideograph>)
          2620  => 16#5E7E#,   --  幾 (<CJK Ideograph>)
          2621  => 16#5E81#,   --  庁 (<CJK Ideograph>)
          2622  => 16#5E82#,   --  庂 (<CJK Ideograph>)
          2623  => 16#5E83#,   --  広 (<CJK Ideograph>)
          2624  => 16#5E85#,   --  庅 (<CJK Ideograph>)
          2625  => 16#5E88#,   --  庈 (<CJK Ideograph>)
          2626  => 16#5E89#,   --  庉 (<CJK Ideograph>)
          2627  => 16#5E8C#,   --  庌 (<CJK Ideograph>)
          2628  => 16#5E8D#,   --  庍 (<CJK Ideograph>)
          2629  => 16#5E8E#,   --  庎 (<CJK Ideograph>)
          2630  => 16#5E92#,   --  庒 (<CJK Ideograph>)
          2631  => 16#5E98#,   --  庘 (<CJK Ideograph>)
          2632  => 16#5E9B#,   --  庛 (<CJK Ideograph>)
          2633  => 16#5E9D#,   --  庝 (<CJK Ideograph>)
          2634  => 16#5EA1#,   --  庡 (<CJK Ideograph>)
          2635  => 16#5EA2#,   --  庢 (<CJK Ideograph>)
          2636  => 16#5EA3#,   --  庣 (<CJK Ideograph>)
          2637  => 16#5EA4#,   --  庤 (<CJK Ideograph>)
          2638  => 16#5EA8#,   --  庨 (<CJK Ideograph>)
          2639  => 16#5EA9#,   --  庩 (<CJK Ideograph>)
          2640  => 16#5EAA#,   --  庪 (<CJK Ideograph>)
          2641  => 16#5EAB#,   --  庫 (<CJK Ideograph>)
          2642  => 16#5EAC#,   --  庬 (<CJK Ideograph>)
          2643  => 16#5EAE#,   --  庮 (<CJK Ideograph>)
          2644  => 16#5EAF#,   --  庯 (<CJK Ideograph>)
          2645  => 16#5EB0#,   --  庰 (<CJK Ideograph>)
          2646  => 16#5EB1#,   --  庱 (<CJK Ideograph>)
          2647  => 16#5EB2#,   --  庲 (<CJK Ideograph>)
          2648  => 16#5EB4#,   --  庴 (<CJK Ideograph>)
          2649  => 16#5EBA#,   --  庺 (<CJK Ideograph>)
          2650  => 16#5EBB#,   --  庻 (<CJK Ideograph>)
          2651  => 16#5EBC#,   --  庼 (<CJK Ideograph>)
          2652  => 16#5EBD#,   --  庽 (<CJK Ideograph>)
          2653  => 16#5EBF#,   --  庿 (<CJK Ideograph>)
          2654  => 16#5EC0#,   --  廀 (<CJK Ideograph>)
          2655  => 16#5EC1#,   --  廁 (<CJK Ideograph>)
          2656  => 16#5EC2#,   --  廂 (<CJK Ideograph>)
          2657  => 16#5EC3#,   --  廃 (<CJK Ideograph>)
          2658  => 16#5EC4#,   --  廄 (<CJK Ideograph>)
          2659  => 16#5EC5#,   --  廅 (<CJK Ideograph>)
          2660  => 16#5EC6#,   --  廆 (<CJK Ideograph>)
          2661  => 16#5EC7#,   --  廇 (<CJK Ideograph>)
          2662  => 16#5EC8#,   --  廈 (<CJK Ideograph>)
          2663  => 16#5ECB#,   --  廋 (<CJK Ideograph>)
          2664  => 16#5ECC#,   --  廌 (<CJK Ideograph>)
          2665  => 16#5ECD#,   --  廍 (<CJK Ideograph>)
          2666  => 16#5ECE#,   --  廎 (<CJK Ideograph>)
          2667  => 16#5ECF#,   --  廏 (<CJK Ideograph>)
          2668  => 16#5ED0#,   --  廐 (<CJK Ideograph>)
          2669  => 16#5ED4#,   --  廔 (<CJK Ideograph>)
          2670  => 16#5ED5#,   --  廕 (<CJK Ideograph>)
          2671  => 16#5ED7#,   --  廗 (<CJK Ideograph>)
          2672  => 16#5ED8#,   --  廘 (<CJK Ideograph>)
          2673  => 16#5ED9#,   --  廙 (<CJK Ideograph>)
          2674  => 16#5EDA#,   --  廚 (<CJK Ideograph>)
          2675  => 16#5EDC#,   --  廜 (<CJK Ideograph>)
          2676  => 16#5EDD#,   --  廝 (<CJK Ideograph>)
          2677  => 16#5EDE#,   --  廞 (<CJK Ideograph>)
          2678  => 16#5EDF#,   --  廟 (<CJK Ideograph>)
          2679  => 16#5EE0#,   --  廠 (<CJK Ideograph>)
          2680  => 16#5EE1#,   --  廡 (<CJK Ideograph>)
          2681  => 16#5EE2#,   --  廢 (<CJK Ideograph>)
          2682  => 16#5EE3#,   --  廣 (<CJK Ideograph>)
          2683  => 16#5EE4#,   --  廤 (<CJK Ideograph>)
          2684  => 16#5EE5#,   --  廥 (<CJK Ideograph>)
          2685  => 16#5EE6#,   --  廦 (<CJK Ideograph>)
          2686  => 16#5EE7#,   --  廧 (<CJK Ideograph>)
          2687  => 16#5EE9#,   --  廩 (<CJK Ideograph>)
          2688  => 16#5EEB#,   --  廫 (<CJK Ideograph>)
          2689  => 16#5EEC#,   --  廬 (<CJK Ideograph>)
          2690  => 16#5EED#,   --  廭 (<CJK Ideograph>)
          2691  => 16#5EEE#,   --  廮 (<CJK Ideograph>)
          2692  => 16#5EEF#,   --  廯 (<CJK Ideograph>)
          2693  => 16#5EF0#,   --  廰 (<CJK Ideograph>)
          2694  => 16#5EF1#,   --  廱 (<CJK Ideograph>)
          2695  => 16#5EF2#,   --  廲 (<CJK Ideograph>)
          2696  => 16#5EF3#,   --  廳 (<CJK Ideograph>)
          2697  => 16#5EF5#,   --  廵 (<CJK Ideograph>)
          2698  => 16#5EF8#,   --  廸 (<CJK Ideograph>)
          2699  => 16#5EF9#,   --  廹 (<CJK Ideograph>)
          2700  => 16#5EFB#,   --  廻 (<CJK Ideograph>)
          2701  => 16#5EFC#,   --  廼 (<CJK Ideograph>)
          2702  => 16#5EFD#,   --  廽 (<CJK Ideograph>)
          2703  => 16#5F05#,   --  弅 (<CJK Ideograph>)
          2704  => 16#5F06#,   --  弆 (<CJK Ideograph>)
          2705  => 16#5F07#,   --  弇 (<CJK Ideograph>)
          2706  => 16#5F09#,   --  弉 (<CJK Ideograph>)
          2707  => 16#5F0C#,   --  弌 (<CJK Ideograph>)
          2708  => 16#5F0D#,   --  弍 (<CJK Ideograph>)
          2709  => 16#5F0E#,   --  弎 (<CJK Ideograph>)
          2710  => 16#5F10#,   --  弐 (<CJK Ideograph>)
          2711  => 16#5F12#,   --  弒 (<CJK Ideograph>)
          2712  => 16#5F14#,   --  弔 (<CJK Ideograph>)
          2713  => 16#5F16#,   --  弖 (<CJK Ideograph>)
          2714  => 16#5F19#,   --  弙 (<CJK Ideograph>)
          2715  => 16#5F1A#,   --  弚 (<CJK Ideograph>)
          2716  => 16#5F1C#,   --  弜 (<CJK Ideograph>)
          2717  => 16#5F1D#,   --  弝 (<CJK Ideograph>)
          2718  => 16#5F1E#,   --  弞 (<CJK Ideograph>)
          2719  => 16#5F21#,   --  弡 (<CJK Ideograph>)
          2720  => 16#5F22#,   --  弢 (<CJK Ideograph>)
          2721  => 16#5F23#,   --  弣 (<CJK Ideograph>)
          2722  => 16#5F24#,   --  弤 (<CJK Ideograph>)
          2723  => 16#5F28#,   --  弨 (<CJK Ideograph>)
          2724  => 16#5F2B#,   --  弫 (<CJK Ideograph>)
          2725  => 16#5F2C#,   --  弬 (<CJK Ideograph>)
          2726  => 16#5F2E#,   --  弮 (<CJK Ideograph>)
          2727  => 16#5F30#,   --  弰 (<CJK Ideograph>)
          2728  => 16#5F32#,   --  弲 (<CJK Ideograph>)
          2729  => 16#5F33#,   --  弳 (<CJK Ideograph>)
          2730  => 16#5F34#,   --  弴 (<CJK Ideograph>)
          2731  => 16#5F35#,   --  張 (<CJK Ideograph>)
          2732  => 16#5F36#,   --  弶 (<CJK Ideograph>)
          2733  => 16#5F37#,   --  強 (<CJK Ideograph>)
          2734  => 16#5F38#,   --  弸 (<CJK Ideograph>)
          2735  => 16#5F3B#,   --  弻 (<CJK Ideograph>)
          2736  => 16#5F3D#,   --  弽 (<CJK Ideograph>)
          2737  => 16#5F3E#,   --  弾 (<CJK Ideograph>)
          2738  => 16#5F3F#,   --  弿 (<CJK Ideograph>)
          2739  => 16#5F41#,   --  彁 (<CJK Ideograph>)
          2740  => 16#5F42#,   --  彂 (<CJK Ideograph>)
          2741  => 16#5F43#,   --  彃 (<CJK Ideograph>)
          2742  => 16#5F44#,   --  彄 (<CJK Ideograph>)
          2743  => 16#5F45#,   --  彅 (<CJK Ideograph>)
          2744  => 16#5F46#,   --  彆 (<CJK Ideograph>)
          2745  => 16#5F47#,   --  彇 (<CJK Ideograph>)
          2746  => 16#5F48#,   --  彈 (<CJK Ideograph>)
          2747  => 16#5F49#,   --  彉 (<CJK Ideograph>)
          2748  => 16#5F4A#,   --  彊 (<CJK Ideograph>)
          2749  => 16#5F4B#,   --  彋 (<CJK Ideograph>)
          2750  => 16#5F4C#,   --  彌 (<CJK Ideograph>)
          2751  => 16#5F4D#,   --  彍 (<CJK Ideograph>)
          2752  => 16#5F4E#,   --  彎 (<CJK Ideograph>)
          2753  => 16#5F4F#,   --  彏 (<CJK Ideograph>)
          2754  => 16#5F51#,   --  彑 (<CJK Ideograph>)
          2755  => 16#5F54#,   --  彔 (<CJK Ideograph>)
          2756  => 16#5F59#,   --  彙 (<CJK Ideograph>)
          2757  => 16#5F5A#,   --  彚 (<CJK Ideograph>)
          2758  => 16#5F5B#,   --  彛 (<CJK Ideograph>)
          2759  => 16#5F5C#,   --  彜 (<CJK Ideograph>)
          2760  => 16#5F5E#,   --  彞 (<CJK Ideograph>)
          2761  => 16#5F5F#,   --  彟 (<CJK Ideograph>)
          2762  => 16#5F60#,   --  彠 (<CJK Ideograph>)
          2763  => 16#5F63#,   --  彣 (<CJK Ideograph>)
          2764  => 16#5F65#,   --  彥 (<CJK Ideograph>)
          2765  => 16#5F67#,   --  彧 (<CJK Ideograph>)
          2766  => 16#5F68#,   --  彨 (<CJK Ideograph>)
          2767  => 16#5F6B#,   --  彫 (<CJK Ideograph>)
          2768  => 16#5F6E#,   --  彮 (<CJK Ideograph>)
          2769  => 16#5F6F#,   --  彯 (<CJK Ideograph>)
          2770  => 16#5F72#,   --  彲 (<CJK Ideograph>)
          2771  => 16#5F74#,   --  彴 (<CJK Ideograph>)
          2772  => 16#5F75#,   --  彵 (<CJK Ideograph>)
          2773  => 16#5F76#,   --  彶 (<CJK Ideograph>)
          2774  => 16#5F78#,   --  彸 (<CJK Ideograph>)
          2775  => 16#5F7A#,   --  彺 (<CJK Ideograph>)
          2776  => 16#5F7D#,   --  彽 (<CJK Ideograph>)
          2777  => 16#5F7E#,   --  彾 (<CJK Ideograph>)
          2778  => 16#5F7F#,   --  彿 (<CJK Ideograph>)
          2779  => 16#5F83#,   --  徃 (<CJK Ideograph>)
          2780  => 16#5F86#,   --  徆 (<CJK Ideograph>)
          2781  => 16#5F8D#,   --  徍 (<CJK Ideograph>)
          2782  => 16#5F8E#,   --  徎 (<CJK Ideograph>)
          2783  => 16#5F8F#,   --  徏 (<CJK Ideograph>)
          2784  => 16#5F91#,   --  徑 (<CJK Ideograph>)
          2785  => 16#5F93#,   --  従 (<CJK Ideograph>)
          2786  => 16#5F94#,   --  徔 (<CJK Ideograph>)
          2787  => 16#5F96#,   --  徖 (<CJK Ideograph>)
          2788  => 16#5F9A#,   --  徚 (<CJK Ideograph>)
          2789  => 16#5F9B#,   --  徛 (<CJK Ideograph>)
          2790  => 16#5F9D#,   --  徝 (<CJK Ideograph>)
          2791  => 16#5F9E#,   --  從 (<CJK Ideograph>)
          2792  => 16#5F9F#,   --  徟 (<CJK Ideograph>)
          2793  => 16#5FA0#,   --  徠 (<CJK Ideograph>)
          2794  => 16#5FA2#,   --  徢 (<CJK Ideograph>)
          2795  => 16#5FA3#,   --  徣 (<CJK Ideograph>)
          2796  => 16#5FA4#,   --  徤 (<CJK Ideograph>)
          2797  => 16#5FA5#,   --  徥 (<CJK Ideograph>)
          2798  => 16#5FA6#,   --  徦 (<CJK Ideograph>)
          2799  => 16#5FA7#,   --  徧 (<CJK Ideograph>)
          2800  => 16#5FA9#,   --  復 (<CJK Ideograph>)
          2801  => 16#5FAB#,   --  徫 (<CJK Ideograph>)
          2802  => 16#5FAC#,   --  徬 (<CJK Ideograph>)
          2803  => 16#5FAF#,   --  徯 (<CJK Ideograph>)
          2804  => 16#5FB0#,   --  徰 (<CJK Ideograph>)
          2805  => 16#5FB1#,   --  徱 (<CJK Ideograph>)
          2806  => 16#5FB2#,   --  徲 (<CJK Ideograph>)
          2807  => 16#5FB3#,   --  徳 (<CJK Ideograph>)
          2808  => 16#5FB4#,   --  徴 (<CJK Ideograph>)
          2809  => 16#5FB6#,   --  徶 (<CJK Ideograph>)
          2810  => 16#5FB8#,   --  徸 (<CJK Ideograph>)
          2811  => 16#5FB9#,   --  徹 (<CJK Ideograph>)
          2812  => 16#5FBA#,   --  徺 (<CJK Ideograph>)
          2813  => 16#5FBB#,   --  徻 (<CJK Ideograph>)
          2814  => 16#5FBE#,   --  徾 (<CJK Ideograph>)
          2815  => 16#5FBF#,   --  徿 (<CJK Ideograph>)
          2816  => 16#5FC0#,   --  忀 (<CJK Ideograph>)
          2817  => 16#5FC1#,   --  忁 (<CJK Ideograph>)
          2818  => 16#5FC2#,   --  忂 (<CJK Ideograph>)
          2819  => 16#5FC7#,   --  忇 (<CJK Ideograph>)
          2820  => 16#5FC8#,   --  忈 (<CJK Ideograph>)
          2821  => 16#5FCA#,   --  忊 (<CJK Ideograph>)
          2822  => 16#5FCB#,   --  忋 (<CJK Ideograph>)
          2823  => 16#5FCE#,   --  忎 (<CJK Ideograph>)
          2824  => 16#5FD3#,   --  忓 (<CJK Ideograph>)
          2825  => 16#5FD4#,   --  忔 (<CJK Ideograph>)
          2826  => 16#5FD5#,   --  忕 (<CJK Ideograph>)
          2827  => 16#5FDA#,   --  忚 (<CJK Ideograph>)
          2828  => 16#5FDB#,   --  忛 (<CJK Ideograph>)
          2829  => 16#5FDC#,   --  応 (<CJK Ideograph>)
          2830  => 16#5FDE#,   --  忞 (<CJK Ideograph>)
          2831  => 16#5FDF#,   --  忟 (<CJK Ideograph>)
          2832  => 16#5FE2#,   --  忢 (<CJK Ideograph>)
          2833  => 16#5FE3#,   --  忣 (<CJK Ideograph>)
          2834  => 16#5FE5#,   --  忥 (<CJK Ideograph>)
          2835  => 16#5FE6#,   --  忦 (<CJK Ideograph>)
          2836  => 16#5FE8#,   --  忨 (<CJK Ideograph>)
          2837  => 16#5FE9#,   --  忩 (<CJK Ideograph>)
          2838  => 16#5FEC#,   --  忬 (<CJK Ideograph>)
          2839  => 16#5FEF#,   --  忯 (<CJK Ideograph>)
          2840  => 16#5FF0#,   --  忰 (<CJK Ideograph>)
          2841  => 16#5FF2#,   --  忲 (<CJK Ideograph>)
          2842  => 16#5FF3#,   --  忳 (<CJK Ideograph>)
          2843  => 16#5FF4#,   --  忴 (<CJK Ideograph>)
          2844  => 16#5FF6#,   --  忶 (<CJK Ideograph>)
          2845  => 16#5FF7#,   --  忷 (<CJK Ideograph>)
          2846  => 16#5FF9#,   --  忹 (<CJK Ideograph>)
          2847  => 16#5FFA#,   --  忺 (<CJK Ideograph>)
          2848  => 16#5FFC#,   --  忼 (<CJK Ideograph>)
          2849  => 16#6007#,   --  怇 (<CJK Ideograph>)
          2850  => 16#6008#,   --  怈 (<CJK Ideograph>)
          2851  => 16#6009#,   --  怉 (<CJK Ideograph>)
          2852  => 16#600B#,   --  怋 (<CJK Ideograph>)
          2853  => 16#600C#,   --  怌 (<CJK Ideograph>)
          2854  => 16#6010#,   --  怐 (<CJK Ideograph>)
          2855  => 16#6011#,   --  怑 (<CJK Ideograph>)
          2856  => 16#6013#,   --  怓 (<CJK Ideograph>)
          2857  => 16#6017#,   --  怗 (<CJK Ideograph>)
          2858  => 16#6018#,   --  怘 (<CJK Ideograph>)
          2859  => 16#601A#,   --  怚 (<CJK Ideograph>)
          2860  => 16#601E#,   --  怞 (<CJK Ideograph>)
          2861  => 16#601F#,   --  怟 (<CJK Ideograph>)
          2862  => 16#6022#,   --  怢 (<CJK Ideograph>)
          2863  => 16#6023#,   --  怣 (<CJK Ideograph>)
          2864  => 16#6024#,   --  怤 (<CJK Ideograph>)
          2865  => 16#602C#,   --  怬 (<CJK Ideograph>)
          2866  => 16#602D#,   --  怭 (<CJK Ideograph>)
          2867  => 16#602E#,   --  怮 (<CJK Ideograph>)
          2868  => 16#6030#,   --  怰 (<CJK Ideograph>)
          2869  => 16#6031#,   --  怱 (<CJK Ideograph>)
          2870  => 16#6032#,   --  怲 (<CJK Ideograph>)
          2871  => 16#6033#,   --  怳 (<CJK Ideograph>)
          2872  => 16#6034#,   --  怴 (<CJK Ideograph>)
          2873  => 16#6036#,   --  怶 (<CJK Ideograph>)
          2874  => 16#6037#,   --  怷 (<CJK Ideograph>)
          2875  => 16#6038#,   --  怸 (<CJK Ideograph>)
          2876  => 16#6039#,   --  怹 (<CJK Ideograph>)
          2877  => 16#603A#,   --  怺 (<CJK Ideograph>)
          2878  => 16#603D#,   --  怽 (<CJK Ideograph>)
          2879  => 16#603E#,   --  怾 (<CJK Ideograph>)
          2880  => 16#6040#,   --  恀 (<CJK Ideograph>)
          2881  => 16#6044#,   --  恄 (<CJK Ideograph>)
          2882  => 16#6045#,   --  恅 (<CJK Ideograph>)
          2883  => 16#6046#,   --  恆 (<CJK Ideograph>)
          2884  => 16#6047#,   --  恇 (<CJK Ideograph>)
          2885  => 16#6048#,   --  恈 (<CJK Ideograph>)
          2886  => 16#6049#,   --  恉 (<CJK Ideograph>)
          2887  => 16#604A#,   --  恊 (<CJK Ideograph>)
          2888  => 16#604C#,   --  恌 (<CJK Ideograph>)
          2889  => 16#604E#,   --  恎 (<CJK Ideograph>)
          2890  => 16#604F#,   --  恏 (<CJK Ideograph>)
          2891  => 16#6051#,   --  恑 (<CJK Ideograph>)
          2892  => 16#6053#,   --  恓 (<CJK Ideograph>)
          2893  => 16#6054#,   --  恔 (<CJK Ideograph>)
          2894  => 16#6056#,   --  恖 (<CJK Ideograph>)
          2895  => 16#6057#,   --  恗 (<CJK Ideograph>)
          2896  => 16#6058#,   --  恘 (<CJK Ideograph>)
          2897  => 16#605B#,   --  恛 (<CJK Ideograph>)
          2898  => 16#605C#,   --  恜 (<CJK Ideograph>)
          2899  => 16#605E#,   --  恞 (<CJK Ideograph>)
          2900  => 16#605F#,   --  恟 (<CJK Ideograph>)
          2901  => 16#6060#,   --  恠 (<CJK Ideograph>)
          2902  => 16#6061#,   --  恡 (<CJK Ideograph>)
          2903  => 16#6065#,   --  恥 (<CJK Ideograph>)
          2904  => 16#6066#,   --  恦 (<CJK Ideograph>)
          2905  => 16#606E#,   --  恮 (<CJK Ideograph>)
          2906  => 16#6071#,   --  恱 (<CJK Ideograph>)
          2907  => 16#6072#,   --  恲 (<CJK Ideograph>)
          2908  => 16#6074#,   --  恴 (<CJK Ideograph>)
          2909  => 16#6075#,   --  恵 (<CJK Ideograph>)
          2910  => 16#6077#,   --  恷 (<CJK Ideograph>)
          2911  => 16#607E#,   --  恾 (<CJK Ideograph>)
          2912  => 16#6080#,   --  悀 (<CJK Ideograph>)
          2913  => 16#6081#,   --  悁 (<CJK Ideograph>)
          2914  => 16#6082#,   --  悂 (<CJK Ideograph>)
          2915  => 16#6085#,   --  悅 (<CJK Ideograph>)
          2916  => 16#6086#,   --  悆 (<CJK Ideograph>)
          2917  => 16#6087#,   --  悇 (<CJK Ideograph>)
          2918  => 16#6088#,   --  悈 (<CJK Ideograph>)
          2919  => 16#608A#,   --  悊 (<CJK Ideograph>)
          2920  => 16#608B#,   --  悋 (<CJK Ideograph>)
          2921  => 16#608E#,   --  悎 (<CJK Ideograph>)
          2922  => 16#608F#,   --  悏 (<CJK Ideograph>)
          2923  => 16#6090#,   --  悐 (<CJK Ideograph>)
          2924  => 16#6091#,   --  悑 (<CJK Ideograph>)
          2925  => 16#6093#,   --  悓 (<CJK Ideograph>)
          2926  => 16#6095#,   --  悕 (<CJK Ideograph>)
          2927  => 16#6097#,   --  悗 (<CJK Ideograph>)
          2928  => 16#6098#,   --  悘 (<CJK Ideograph>)
          2929  => 16#6099#,   --  悙 (<CJK Ideograph>)
          2930  => 16#609C#,   --  悜 (<CJK Ideograph>)
          2931  => 16#609E#,   --  悞 (<CJK Ideograph>)
          2932  => 16#60A1#,   --  悡 (<CJK Ideograph>)
          2933  => 16#60A2#,   --  悢 (<CJK Ideograph>)
          2934  => 16#60A4#,   --  悤 (<CJK Ideograph>)
          2935  => 16#60A5#,   --  悥 (<CJK Ideograph>)
          2936  => 16#60A7#,   --  悧 (<CJK Ideograph>)
          2937  => 16#60A9#,   --  悩 (<CJK Ideograph>)
          2938  => 16#60AA#,   --  悪 (<CJK Ideograph>)
          2939  => 16#60AE#,   --  悮 (<CJK Ideograph>)
          2940  => 16#60B0#,   --  悰 (<CJK Ideograph>)
          2941  => 16#60B3#,   --  悳 (<CJK Ideograph>)
          2942  => 16#60B5#,   --  悵 (<CJK Ideograph>)
          2943  => 16#60B6#,   --  悶 (<CJK Ideograph>)
          2944  => 16#60B7#,   --  悷 (<CJK Ideograph>)
          2945  => 16#60B9#,   --  悹 (<CJK Ideograph>)
          2946  => 16#60BA#,   --  悺 (<CJK Ideograph>)
          2947  => 16#60BD#,   --  悽 (<CJK Ideograph>)
          2948  => 16#60BE#,   --  悾 (<CJK Ideograph>)
          2949  => 16#60BF#,   --  悿 (<CJK Ideograph>)
          2950  => 16#60C0#,   --  惀 (<CJK Ideograph>)
          2951  => 16#60C1#,   --  惁 (<CJK Ideograph>)
          2952  => 16#60C2#,   --  惂 (<CJK Ideograph>)
          2953  => 16#60C3#,   --  惃 (<CJK Ideograph>)
          2954  => 16#60C4#,   --  惄 (<CJK Ideograph>)
          2955  => 16#60C7#,   --  惇 (<CJK Ideograph>)
          2956  => 16#60C8#,   --  惈 (<CJK Ideograph>)
          2957  => 16#60C9#,   --  惉 (<CJK Ideograph>)
          2958  => 16#60CC#,   --  惌 (<CJK Ideograph>)
          2959  => 16#60CD#,   --  惍 (<CJK Ideograph>)
          2960  => 16#60CE#,   --  惎 (<CJK Ideograph>)
          2961  => 16#60CF#,   --  惏 (<CJK Ideograph>)
          2962  => 16#60D0#,   --  惐 (<CJK Ideograph>)
          2963  => 16#60D2#,   --  惒 (<CJK Ideograph>)
          2964  => 16#60D3#,   --  惓 (<CJK Ideograph>)
          2965  => 16#60D4#,   --  惔 (<CJK Ideograph>)
          2966  => 16#60D6#,   --  惖 (<CJK Ideograph>)
          2967  => 16#60D7#,   --  惗 (<CJK Ideograph>)
          2968  => 16#60D9#,   --  惙 (<CJK Ideograph>)
          2969  => 16#60DB#,   --  惛 (<CJK Ideograph>)
          2970  => 16#60DE#,   --  惞 (<CJK Ideograph>)
          2971  => 16#60E1#,   --  惡 (<CJK Ideograph>)
          2972  => 16#60E2#,   --  惢 (<CJK Ideograph>)
          2973  => 16#60E3#,   --  惣 (<CJK Ideograph>)
          2974  => 16#60E4#,   --  惤 (<CJK Ideograph>)
          2975  => 16#60E5#,   --  惥 (<CJK Ideograph>)
          2976  => 16#60EA#,   --  惪 (<CJK Ideograph>)
          2977  => 16#60F1#,   --  惱 (<CJK Ideograph>)
          2978  => 16#60F2#,   --  惲 (<CJK Ideograph>)
          2979  => 16#60F5#,   --  惵 (<CJK Ideograph>)
          2980  => 16#60F7#,   --  惷 (<CJK Ideograph>)
          2981  => 16#60F8#,   --  惸 (<CJK Ideograph>)
          2982  => 16#60FB#,   --  惻 (<CJK Ideograph>)
          2983  => 16#60FC#,   --  惼 (<CJK Ideograph>)
          2984  => 16#60FD#,   --  惽 (<CJK Ideograph>)
          2985  => 16#60FE#,   --  惾 (<CJK Ideograph>)
          2986  => 16#60FF#,   --  惿 (<CJK Ideograph>)
          2987  => 16#6102#,   --  愂 (<CJK Ideograph>)
          2988  => 16#6103#,   --  愃 (<CJK Ideograph>)
          2989  => 16#6104#,   --  愄 (<CJK Ideograph>)
          2990  => 16#6105#,   --  愅 (<CJK Ideograph>)
          2991  => 16#6107#,   --  愇 (<CJK Ideograph>)
          2992  => 16#610A#,   --  愊 (<CJK Ideograph>)
          2993  => 16#610B#,   --  愋 (<CJK Ideograph>)
          2994  => 16#610C#,   --  愌 (<CJK Ideograph>)
          2995  => 16#6110#,   --  愐 (<CJK Ideograph>)
          2996  => 16#6111#,   --  愑 (<CJK Ideograph>)
          2997  => 16#6112#,   --  愒 (<CJK Ideograph>)
          2998  => 16#6113#,   --  愓 (<CJK Ideograph>)
          2999  => 16#6114#,   --  愔 (<CJK Ideograph>)
          3000  => 16#6116#,   --  愖 (<CJK Ideograph>)
          3001  => 16#6117#,   --  愗 (<CJK Ideograph>)
          3002  => 16#6118#,   --  愘 (<CJK Ideograph>)
          3003  => 16#6119#,   --  愙 (<CJK Ideograph>)
          3004  => 16#611B#,   --  愛 (<CJK Ideograph>)
          3005  => 16#611C#,   --  愜 (<CJK Ideograph>)
          3006  => 16#611D#,   --  愝 (<CJK Ideograph>)
          3007  => 16#611E#,   --  愞 (<CJK Ideograph>)
          3008  => 16#6121#,   --  愡 (<CJK Ideograph>)
          3009  => 16#6122#,   --  愢 (<CJK Ideograph>)
          3010  => 16#6125#,   --  愥 (<CJK Ideograph>)
          3011  => 16#6128#,   --  愨 (<CJK Ideograph>)
          3012  => 16#6129#,   --  愩 (<CJK Ideograph>)
          3013  => 16#612A#,   --  愪 (<CJK Ideograph>)
          3014  => 16#612C#,   --  愬 (<CJK Ideograph>)
          3015  => 16#612D#,   --  愭 (<CJK Ideograph>)
          3016  => 16#612E#,   --  愮 (<CJK Ideograph>)
          3017  => 16#612F#,   --  愯 (<CJK Ideograph>)
          3018  => 16#6130#,   --  愰 (<CJK Ideograph>)
          3019  => 16#6131#,   --  愱 (<CJK Ideograph>)
          3020  => 16#6132#,   --  愲 (<CJK Ideograph>)
          3021  => 16#6133#,   --  愳 (<CJK Ideograph>)
          3022  => 16#6134#,   --  愴 (<CJK Ideograph>)
          3023  => 16#6135#,   --  愵 (<CJK Ideograph>)
          3024  => 16#6136#,   --  愶 (<CJK Ideograph>)
          3025  => 16#6137#,   --  愷 (<CJK Ideograph>)
          3026  => 16#6138#,   --  愸 (<CJK Ideograph>)
          3027  => 16#6139#,   --  愹 (<CJK Ideograph>)
          3028  => 16#613A#,   --  愺 (<CJK Ideograph>)
          3029  => 16#613B#,   --  愻 (<CJK Ideograph>)
          3030  => 16#613C#,   --  愼 (<CJK Ideograph>)
          3031  => 16#613D#,   --  愽 (<CJK Ideograph>)
          3032  => 16#613E#,   --  愾 (<CJK Ideograph>)
          3033  => 16#6140#,   --  慀 (<CJK Ideograph>)
          3034  => 16#6141#,   --  慁 (<CJK Ideograph>)
          3035  => 16#6142#,   --  慂 (<CJK Ideograph>)
          3036  => 16#6143#,   --  慃 (<CJK Ideograph>)
          3037  => 16#6144#,   --  慄 (<CJK Ideograph>)
          3038  => 16#6145#,   --  慅 (<CJK Ideograph>)
          3039  => 16#6146#,   --  慆 (<CJK Ideograph>)
          3040  => 16#6147#,   --  慇 (<CJK Ideograph>)
          3041  => 16#6149#,   --  慉 (<CJK Ideograph>)
          3042  => 16#614B#,   --  態 (<CJK Ideograph>)
          3043  => 16#614D#,   --  慍 (<CJK Ideograph>)
          3044  => 16#614F#,   --  慏 (<CJK Ideograph>)
          3045  => 16#6150#,   --  慐 (<CJK Ideograph>)
          3046  => 16#6152#,   --  慒 (<CJK Ideograph>)
          3047  => 16#6153#,   --  慓 (<CJK Ideograph>)
          3048  => 16#6154#,   --  慔 (<CJK Ideograph>)
          3049  => 16#6156#,   --  慖 (<CJK Ideograph>)
          3050  => 16#6157#,   --  慗 (<CJK Ideograph>)
          3051  => 16#6158#,   --  慘 (<CJK Ideograph>)
          3052  => 16#6159#,   --  慙 (<CJK Ideograph>)
          3053  => 16#615A#,   --  慚 (<CJK Ideograph>)
          3054  => 16#615B#,   --  慛 (<CJK Ideograph>)
          3055  => 16#615C#,   --  慜 (<CJK Ideograph>)
          3056  => 16#615E#,   --  慞 (<CJK Ideograph>)
          3057  => 16#615F#,   --  慟 (<CJK Ideograph>)
          3058  => 16#6160#,   --  慠 (<CJK Ideograph>)
          3059  => 16#6161#,   --  慡 (<CJK Ideograph>)
          3060  => 16#6163#,   --  慣 (<CJK Ideograph>)
          3061  => 16#6164#,   --  慤 (<CJK Ideograph>)
          3062  => 16#6165#,   --  慥 (<CJK Ideograph>)
          3063  => 16#6166#,   --  慦 (<CJK Ideograph>)
          3064  => 16#6169#,   --  慩 (<CJK Ideograph>)
          3065  => 16#616A#,   --  慪 (<CJK Ideograph>)
          3066  => 16#616B#,   --  慫 (<CJK Ideograph>)
          3067  => 16#616C#,   --  慬 (<CJK Ideograph>)
          3068  => 16#616D#,   --  慭 (<CJK Ideograph>)
          3069  => 16#616E#,   --  慮 (<CJK Ideograph>)
          3070  => 16#616F#,   --  慯 (<CJK Ideograph>)
          3071  => 16#6171#,   --  慱 (<CJK Ideograph>)
          3072  => 16#6172#,   --  慲 (<CJK Ideograph>)
          3073  => 16#6173#,   --  慳 (<CJK Ideograph>)
          3074  => 16#6174#,   --  慴 (<CJK Ideograph>)
          3075  => 16#6176#,   --  慶 (<CJK Ideograph>)
          3076  => 16#6178#,   --  慸 (<CJK Ideograph>)
          3077  => 16#6179#,   --  慹 (<CJK Ideograph>)
          3078  => 16#617A#,   --  慺 (<CJK Ideograph>)
          3079  => 16#617B#,   --  慻 (<CJK Ideograph>)
          3080  => 16#617C#,   --  慼 (<CJK Ideograph>)
          3081  => 16#617D#,   --  慽 (<CJK Ideograph>)
          3082  => 16#617E#,   --  慾 (<CJK Ideograph>)
          3083  => 16#617F#,   --  慿 (<CJK Ideograph>)
          3084  => 16#6180#,   --  憀 (<CJK Ideograph>)
          3085  => 16#6181#,   --  憁 (<CJK Ideograph>)
          3086  => 16#6182#,   --  憂 (<CJK Ideograph>)
          3087  => 16#6183#,   --  憃 (<CJK Ideograph>)
          3088  => 16#6184#,   --  憄 (<CJK Ideograph>)
          3089  => 16#6185#,   --  憅 (<CJK Ideograph>)
          3090  => 16#6186#,   --  憆 (<CJK Ideograph>)
          3091  => 16#6187#,   --  憇 (<CJK Ideograph>)
          3092  => 16#6188#,   --  憈 (<CJK Ideograph>)
          3093  => 16#6189#,   --  憉 (<CJK Ideograph>)
          3094  => 16#618A#,   --  憊 (<CJK Ideograph>)
          3095  => 16#618C#,   --  憌 (<CJK Ideograph>)
          3096  => 16#618D#,   --  憍 (<CJK Ideograph>)
          3097  => 16#618F#,   --  憏 (<CJK Ideograph>)
          3098  => 16#6190#,   --  憐 (<CJK Ideograph>)
          3099  => 16#6191#,   --  憑 (<CJK Ideograph>)
          3100  => 16#6192#,   --  憒 (<CJK Ideograph>)
          3101  => 16#6193#,   --  憓 (<CJK Ideograph>)
          3102  => 16#6195#,   --  憕 (<CJK Ideograph>)
          3103  => 16#6196#,   --  憖 (<CJK Ideograph>)
          3104  => 16#6197#,   --  憗 (<CJK Ideograph>)
          3105  => 16#6198#,   --  憘 (<CJK Ideograph>)
          3106  => 16#6199#,   --  憙 (<CJK Ideograph>)
          3107  => 16#619A#,   --  憚 (<CJK Ideograph>)
          3108  => 16#619B#,   --  憛 (<CJK Ideograph>)
          3109  => 16#619C#,   --  憜 (<CJK Ideograph>)
          3110  => 16#619E#,   --  憞 (<CJK Ideograph>)
          3111  => 16#619F#,   --  憟 (<CJK Ideograph>)
          3112  => 16#61A0#,   --  憠 (<CJK Ideograph>)
          3113  => 16#61A1#,   --  憡 (<CJK Ideograph>)
          3114  => 16#61A2#,   --  憢 (<CJK Ideograph>)
          3115  => 16#61A3#,   --  憣 (<CJK Ideograph>)
          3116  => 16#61A4#,   --  憤 (<CJK Ideograph>)
          3117  => 16#61A5#,   --  憥 (<CJK Ideograph>)
          3118  => 16#61A6#,   --  憦 (<CJK Ideograph>)
          3119  => 16#61AA#,   --  憪 (<CJK Ideograph>)
          3120  => 16#61AB#,   --  憫 (<CJK Ideograph>)
          3121  => 16#61AD#,   --  憭 (<CJK Ideograph>)
          3122  => 16#61AE#,   --  憮 (<CJK Ideograph>)
          3123  => 16#61AF#,   --  憯 (<CJK Ideograph>)
          3124  => 16#61B0#,   --  憰 (<CJK Ideograph>)
          3125  => 16#61B1#,   --  憱 (<CJK Ideograph>)
          3126  => 16#61B2#,   --  憲 (<CJK Ideograph>)
          3127  => 16#61B3#,   --  憳 (<CJK Ideograph>)
          3128  => 16#61B4#,   --  憴 (<CJK Ideograph>)
          3129  => 16#61B5#,   --  憵 (<CJK Ideograph>)
          3130  => 16#61B6#,   --  憶 (<CJK Ideograph>)
          3131  => 16#61B8#,   --  憸 (<CJK Ideograph>)
          3132  => 16#61B9#,   --  憹 (<CJK Ideograph>)
          3133  => 16#61BA#,   --  憺 (<CJK Ideograph>)
          3134  => 16#61BB#,   --  憻 (<CJK Ideograph>)
          3135  => 16#61BC#,   --  憼 (<CJK Ideograph>)
          3136  => 16#61BD#,   --  憽 (<CJK Ideograph>)
          3137  => 16#61BF#,   --  憿 (<CJK Ideograph>)
          3138  => 16#61C0#,   --  懀 (<CJK Ideograph>)
          3139  => 16#61C1#,   --  懁 (<CJK Ideograph>)
          3140  => 16#61C3#,   --  懃 (<CJK Ideograph>)
          3141  => 16#61C4#,   --  懄 (<CJK Ideograph>)
          3142  => 16#61C5#,   --  懅 (<CJK Ideograph>)
          3143  => 16#61C6#,   --  懆 (<CJK Ideograph>)
          3144  => 16#61C7#,   --  懇 (<CJK Ideograph>)
          3145  => 16#61C9#,   --  應 (<CJK Ideograph>)
          3146  => 16#61CC#,   --  懌 (<CJK Ideograph>)
          3147  => 16#61CD#,   --  懍 (<CJK Ideograph>)
          3148  => 16#61CE#,   --  懎 (<CJK Ideograph>)
          3149  => 16#61CF#,   --  懏 (<CJK Ideograph>)
          3150  => 16#61D0#,   --  懐 (<CJK Ideograph>)
          3151  => 16#61D3#,   --  懓 (<CJK Ideograph>)
          3152  => 16#61D5#,   --  懕 (<CJK Ideograph>)
          3153  => 16#61D6#,   --  懖 (<CJK Ideograph>)
          3154  => 16#61D7#,   --  懗 (<CJK Ideograph>)
          3155  => 16#61D8#,   --  懘 (<CJK Ideograph>)
          3156  => 16#61D9#,   --  懙 (<CJK Ideograph>)
          3157  => 16#61DA#,   --  懚 (<CJK Ideograph>)
          3158  => 16#61DB#,   --  懛 (<CJK Ideograph>)
          3159  => 16#61DC#,   --  懜 (<CJK Ideograph>)
          3160  => 16#61DD#,   --  懝 (<CJK Ideograph>)
          3161  => 16#61DE#,   --  懞 (<CJK Ideograph>)
          3162  => 16#61DF#,   --  懟 (<CJK Ideograph>)
          3163  => 16#61E0#,   --  懠 (<CJK Ideograph>)
          3164  => 16#61E1#,   --  懡 (<CJK Ideograph>)
          3165  => 16#61E2#,   --  懢 (<CJK Ideograph>)
          3166  => 16#61E3#,   --  懣 (<CJK Ideograph>)
          3167  => 16#61E4#,   --  懤 (<CJK Ideograph>)
          3168  => 16#61E5#,   --  懥 (<CJK Ideograph>)
          3169  => 16#61E7#,   --  懧 (<CJK Ideograph>)
          3170  => 16#61E8#,   --  懨 (<CJK Ideograph>)
          3171  => 16#61E9#,   --  懩 (<CJK Ideograph>)
          3172  => 16#61EA#,   --  懪 (<CJK Ideograph>)
          3173  => 16#61EB#,   --  懫 (<CJK Ideograph>)
          3174  => 16#61EC#,   --  懬 (<CJK Ideograph>)
          3175  => 16#61ED#,   --  懭 (<CJK Ideograph>)
          3176  => 16#61EE#,   --  懮 (<CJK Ideograph>)
          3177  => 16#61EF#,   --  懯 (<CJK Ideograph>)
          3178  => 16#61F0#,   --  懰 (<CJK Ideograph>)
          3179  => 16#61F1#,   --  懱 (<CJK Ideograph>)
          3180  => 16#61F2#,   --  懲 (<CJK Ideograph>)
          3181  => 16#61F3#,   --  懳 (<CJK Ideograph>)
          3182  => 16#61F4#,   --  懴 (<CJK Ideograph>)
          3183  => 16#61F6#,   --  懶 (<CJK Ideograph>)
          3184  => 16#61F7#,   --  懷 (<CJK Ideograph>)
          3185  => 16#61F8#,   --  懸 (<CJK Ideograph>)
          3186  => 16#61F9#,   --  懹 (<CJK Ideograph>)
          3187  => 16#61FA#,   --  懺 (<CJK Ideograph>)
          3188  => 16#61FB#,   --  懻 (<CJK Ideograph>)
          3189  => 16#61FC#,   --  懼 (<CJK Ideograph>)
          3190  => 16#61FD#,   --  懽 (<CJK Ideograph>)
          3191  => 16#61FE#,   --  懾 (<CJK Ideograph>)
          3192  => 16#6200#,   --  戀 (<CJK Ideograph>)
          3193  => 16#6201#,   --  戁 (<CJK Ideograph>)
          3194  => 16#6202#,   --  戂 (<CJK Ideograph>)
          3195  => 16#6203#,   --  戃 (<CJK Ideograph>)
          3196  => 16#6204#,   --  戄 (<CJK Ideograph>)
          3197  => 16#6205#,   --  戅 (<CJK Ideograph>)
          3198  => 16#6207#,   --  戇 (<CJK Ideograph>)
          3199  => 16#6209#,   --  戉 (<CJK Ideograph>)
          3200  => 16#6213#,   --  戓 (<CJK Ideograph>)
          3201  => 16#6214#,   --  戔 (<CJK Ideograph>)
          3202  => 16#6219#,   --  戙 (<CJK Ideograph>)
          3203  => 16#621C#,   --  戜 (<CJK Ideograph>)
          3204  => 16#621D#,   --  戝 (<CJK Ideograph>)
          3205  => 16#621E#,   --  戞 (<CJK Ideograph>)
          3206  => 16#6220#,   --  戠 (<CJK Ideograph>)
          3207  => 16#6223#,   --  戣 (<CJK Ideograph>)
          3208  => 16#6226#,   --  戦 (<CJK Ideograph>)
          3209  => 16#6227#,   --  戧 (<CJK Ideograph>)
          3210  => 16#6228#,   --  戨 (<CJK Ideograph>)
          3211  => 16#6229#,   --  戩 (<CJK Ideograph>)
          3212  => 16#622B#,   --  戫 (<CJK Ideograph>)
          3213  => 16#622D#,   --  戭 (<CJK Ideograph>)
          3214  => 16#622F#,   --  戯 (<CJK Ideograph>)
          3215  => 16#6230#,   --  戰 (<CJK Ideograph>)
          3216  => 16#6231#,   --  戱 (<CJK Ideograph>)
          3217  => 16#6232#,   --  戲 (<CJK Ideograph>)
          3218  => 16#6235#,   --  戵 (<CJK Ideograph>)
          3219  => 16#6236#,   --  戶 (<CJK Ideograph>)
          3220  => 16#6238#,   --  戸 (<CJK Ideograph>)
          3221  => 16#6239#,   --  戹 (<CJK Ideograph>)
          3222  => 16#623A#,   --  戺 (<CJK Ideograph>)
          3223  => 16#623B#,   --  戻 (<CJK Ideograph>)
          3224  => 16#623C#,   --  戼 (<CJK Ideograph>)
          3225  => 16#6242#,   --  扂 (<CJK Ideograph>)
          3226  => 16#6244#,   --  扄 (<CJK Ideograph>)
          3227  => 16#6245#,   --  扅 (<CJK Ideograph>)
          3228  => 16#6246#,   --  扆 (<CJK Ideograph>)
          3229  => 16#624A#,   --  扊 (<CJK Ideograph>)
          3230  => 16#624F#,   --  扏 (<CJK Ideograph>)
          3231  => 16#6250#,   --  扐 (<CJK Ideograph>)
          3232  => 16#6255#,   --  払 (<CJK Ideograph>)
          3233  => 16#6256#,   --  扖 (<CJK Ideograph>)
          3234  => 16#6257#,   --  扗 (<CJK Ideograph>)
          3235  => 16#6259#,   --  扙 (<CJK Ideograph>)
          3236  => 16#625A#,   --  扚 (<CJK Ideograph>)
          3237  => 16#625C#,   --  扜 (<CJK Ideograph>)
          3238  => 16#625D#,   --  扝 (<CJK Ideograph>)
          3239  => 16#625E#,   --  扞 (<CJK Ideograph>)
          3240  => 16#625F#,   --  扟 (<CJK Ideograph>)
          3241  => 16#6260#,   --  扠 (<CJK Ideograph>)
          3242  => 16#6261#,   --  扡 (<CJK Ideograph>)
          3243  => 16#6262#,   --  扢 (<CJK Ideograph>)
          3244  => 16#6264#,   --  扤 (<CJK Ideograph>)
          3245  => 16#6265#,   --  扥 (<CJK Ideograph>)
          3246  => 16#6268#,   --  扨 (<CJK Ideograph>)
          3247  => 16#6271#,   --  扱 (<CJK Ideograph>)
          3248  => 16#6272#,   --  扲 (<CJK Ideograph>)
          3249  => 16#6274#,   --  扴 (<CJK Ideograph>)
          3250  => 16#6275#,   --  扵 (<CJK Ideograph>)
          3251  => 16#6277#,   --  扷 (<CJK Ideograph>)
          3252  => 16#6278#,   --  扸 (<CJK Ideograph>)
          3253  => 16#627A#,   --  扺 (<CJK Ideograph>)
          3254  => 16#627B#,   --  扻 (<CJK Ideograph>)
          3255  => 16#627D#,   --  扽 (<CJK Ideograph>)
          3256  => 16#6281#,   --  抁 (<CJK Ideograph>)
          3257  => 16#6282#,   --  抂 (<CJK Ideograph>)
          3258  => 16#6283#,   --  抃 (<CJK Ideograph>)
          3259  => 16#6285#,   --  抅 (<CJK Ideograph>)
          3260  => 16#6286#,   --  抆 (<CJK Ideograph>)
          3261  => 16#6287#,   --  抇 (<CJK Ideograph>)
          3262  => 16#6288#,   --  抈 (<CJK Ideograph>)
          3263  => 16#628B#,   --  抋 (<CJK Ideograph>)
          3264  => 16#628C#,   --  抌 (<CJK Ideograph>)
          3265  => 16#628D#,   --  抍 (<CJK Ideograph>)
          3266  => 16#628E#,   --  抎 (<CJK Ideograph>)
          3267  => 16#628F#,   --  抏 (<CJK Ideograph>)
          3268  => 16#6290#,   --  抐 (<CJK Ideograph>)
          3269  => 16#6294#,   --  抔 (<CJK Ideograph>)
          3270  => 16#6299#,   --  抙 (<CJK Ideograph>)
          3271  => 16#629C#,   --  抜 (<CJK Ideograph>)
          3272  => 16#629D#,   --  抝 (<CJK Ideograph>)
          3273  => 16#629E#,   --  択 (<CJK Ideograph>)
          3274  => 16#62A3#,   --  抣 (<CJK Ideograph>)
          3275  => 16#62A6#,   --  抦 (<CJK Ideograph>)
          3276  => 16#62A7#,   --  抧 (<CJK Ideograph>)
          3277  => 16#62A9#,   --  抩 (<CJK Ideograph>)
          3278  => 16#62AA#,   --  抪 (<CJK Ideograph>)
          3279  => 16#62AD#,   --  抭 (<CJK Ideograph>)
          3280  => 16#62AE#,   --  抮 (<CJK Ideograph>)
          3281  => 16#62AF#,   --  抯 (<CJK Ideograph>)
          3282  => 16#62B0#,   --  抰 (<CJK Ideograph>)
          3283  => 16#62B2#,   --  抲 (<CJK Ideograph>)
          3284  => 16#62B3#,   --  抳 (<CJK Ideograph>)
          3285  => 16#62B4#,   --  抴 (<CJK Ideograph>)
          3286  => 16#62B6#,   --  抶 (<CJK Ideograph>)
          3287  => 16#62B7#,   --  抷 (<CJK Ideograph>)
          3288  => 16#62B8#,   --  抸 (<CJK Ideograph>)
          3289  => 16#62BA#,   --  抺 (<CJK Ideograph>)
          3290  => 16#62BE#,   --  抾 (<CJK Ideograph>)
          3291  => 16#62C0#,   --  拀 (<CJK Ideograph>)
          3292  => 16#62C1#,   --  拁 (<CJK Ideograph>)
          3293  => 16#62C3#,   --  拃 (<CJK Ideograph>)
          3294  => 16#62CB#,   --  拋 (<CJK Ideograph>)
          3295  => 16#62CF#,   --  拏 (<CJK Ideograph>)
          3296  => 16#62D1#,   --  拑 (<CJK Ideograph>)
          3297  => 16#62D5#,   --  拕 (<CJK Ideograph>)
          3298  => 16#62DD#,   --  拝 (<CJK Ideograph>)
          3299  => 16#62DE#,   --  拞 (<CJK Ideograph>)
          3300  => 16#62E0#,   --  拠 (<CJK Ideograph>)
          3301  => 16#62E1#,   --  拡 (<CJK Ideograph>)
          3302  => 16#62E4#,   --  拤 (<CJK Ideograph>)
          3303  => 16#62EA#,   --  拪 (<CJK Ideograph>)
          3304  => 16#62EB#,   --  拫 (<CJK Ideograph>)
          3305  => 16#62F0#,   --  拰 (<CJK Ideograph>)
          3306  => 16#62F2#,   --  拲 (<CJK Ideograph>)
          3307  => 16#62F5#,   --  拵 (<CJK Ideograph>)
          3308  => 16#62F8#,   --  拸 (<CJK Ideograph>)
          3309  => 16#62F9#,   --  拹 (<CJK Ideograph>)
          3310  => 16#62FA#,   --  拺 (<CJK Ideograph>)
          3311  => 16#62FB#,   --  拻 (<CJK Ideograph>)
          3312  => 16#6300#,   --  挀 (<CJK Ideograph>)
          3313  => 16#6303#,   --  挃 (<CJK Ideograph>)
          3314  => 16#6304#,   --  挄 (<CJK Ideograph>)
          3315  => 16#6305#,   --  挅 (<CJK Ideograph>)
          3316  => 16#6306#,   --  挆 (<CJK Ideograph>)
          3317  => 16#630A#,   --  挊 (<CJK Ideograph>)
          3318  => 16#630B#,   --  挋 (<CJK Ideograph>)
          3319  => 16#630C#,   --  挌 (<CJK Ideograph>)
          3320  => 16#630D#,   --  挍 (<CJK Ideograph>)
          3321  => 16#630F#,   --  挏 (<CJK Ideograph>)
          3322  => 16#6310#,   --  挐 (<CJK Ideograph>)
          3323  => 16#6312#,   --  挒 (<CJK Ideograph>)
          3324  => 16#6313#,   --  挓 (<CJK Ideograph>)
          3325  => 16#6314#,   --  挔 (<CJK Ideograph>)
          3326  => 16#6315#,   --  挕 (<CJK Ideograph>)
          3327  => 16#6317#,   --  挗 (<CJK Ideograph>)
          3328  => 16#6318#,   --  挘 (<CJK Ideograph>)
          3329  => 16#6319#,   --  挙 (<CJK Ideograph>)
          3330  => 16#631C#,   --  挜 (<CJK Ideograph>)
          3331  => 16#6326#,   --  挦 (<CJK Ideograph>)
          3332  => 16#6327#,   --  挧 (<CJK Ideograph>)
          3333  => 16#6329#,   --  挩 (<CJK Ideograph>)
          3334  => 16#632C#,   --  挬 (<CJK Ideograph>)
          3335  => 16#632D#,   --  挭 (<CJK Ideograph>)
          3336  => 16#632E#,   --  挮 (<CJK Ideograph>)
          3337  => 16#6330#,   --  挰 (<CJK Ideograph>)
          3338  => 16#6331#,   --  挱 (<CJK Ideograph>)
          3339  => 16#6333#,   --  挳 (<CJK Ideograph>)
          3340  => 16#6334#,   --  挴 (<CJK Ideograph>)
          3341  => 16#6335#,   --  挵 (<CJK Ideograph>)
          3342  => 16#6336#,   --  挶 (<CJK Ideograph>)
          3343  => 16#6337#,   --  挷 (<CJK Ideograph>)
          3344  => 16#6338#,   --  挸 (<CJK Ideograph>)
          3345  => 16#633B#,   --  挻 (<CJK Ideograph>)
          3346  => 16#633C#,   --  挼 (<CJK Ideograph>)
          3347  => 16#633E#,   --  挾 (<CJK Ideograph>)
          3348  => 16#633F#,   --  挿 (<CJK Ideograph>)
          3349  => 16#6340#,   --  捀 (<CJK Ideograph>)
          3350  => 16#6341#,   --  捁 (<CJK Ideograph>)
          3351  => 16#6344#,   --  捄 (<CJK Ideograph>)
          3352  => 16#6347#,   --  捇 (<CJK Ideograph>)
          3353  => 16#6348#,   --  捈 (<CJK Ideograph>)
          3354  => 16#634A#,   --  捊 (<CJK Ideograph>)
          3355  => 16#6351#,   --  捑 (<CJK Ideograph>)
          3356  => 16#6352#,   --  捒 (<CJK Ideograph>)
          3357  => 16#6353#,   --  捓 (<CJK Ideograph>)
          3358  => 16#6354#,   --  捔 (<CJK Ideograph>)
          3359  => 16#6356#,   --  捖 (<CJK Ideograph>)
          3360  => 16#6357#,   --  捗 (<CJK Ideograph>)
          3361  => 16#6358#,   --  捘 (<CJK Ideograph>)
          3362  => 16#6359#,   --  捙 (<CJK Ideograph>)
          3363  => 16#635A#,   --  捚 (<CJK Ideograph>)
          3364  => 16#635B#,   --  捛 (<CJK Ideograph>)
          3365  => 16#635C#,   --  捜 (<CJK Ideograph>)
          3366  => 16#635D#,   --  捝 (<CJK Ideograph>)
          3367  => 16#6360#,   --  捠 (<CJK Ideograph>)
          3368  => 16#6364#,   --  捤 (<CJK Ideograph>)
          3369  => 16#6365#,   --  捥 (<CJK Ideograph>)
          3370  => 16#6366#,   --  捦 (<CJK Ideograph>)
          3371  => 16#6368#,   --  捨 (<CJK Ideograph>)
          3372  => 16#636A#,   --  捪 (<CJK Ideograph>)
          3373  => 16#636B#,   --  捫 (<CJK Ideograph>)
          3374  => 16#636C#,   --  捬 (<CJK Ideograph>)
          3375  => 16#636F#,   --  捯 (<CJK Ideograph>)
          3376  => 16#6370#,   --  捰 (<CJK Ideograph>)
          3377  => 16#6372#,   --  捲 (<CJK Ideograph>)
          3378  => 16#6373#,   --  捳 (<CJK Ideograph>)
          3379  => 16#6374#,   --  捴 (<CJK Ideograph>)
          3380  => 16#6375#,   --  捵 (<CJK Ideograph>)
          3381  => 16#6378#,   --  捸 (<CJK Ideograph>)
          3382  => 16#6379#,   --  捹 (<CJK Ideograph>)
          3383  => 16#637C#,   --  捼 (<CJK Ideograph>)
          3384  => 16#637D#,   --  捽 (<CJK Ideograph>)
          3385  => 16#637E#,   --  捾 (<CJK Ideograph>)
          3386  => 16#637F#,   --  捿 (<CJK Ideograph>)
          3387  => 16#6381#,   --  掁 (<CJK Ideograph>)
          3388  => 16#6383#,   --  掃 (<CJK Ideograph>)
          3389  => 16#6384#,   --  掄 (<CJK Ideograph>)
          3390  => 16#6385#,   --  掅 (<CJK Ideograph>)
          3391  => 16#6386#,   --  掆 (<CJK Ideograph>)
          3392  => 16#638B#,   --  掋 (<CJK Ideograph>)
          3393  => 16#638D#,   --  掍 (<CJK Ideograph>)
          3394  => 16#6391#,   --  掑 (<CJK Ideograph>)
          3395  => 16#6393#,   --  掓 (<CJK Ideograph>)
          3396  => 16#6394#,   --  掔 (<CJK Ideograph>)
          3397  => 16#6395#,   --  掕 (<CJK Ideograph>)
          3398  => 16#6397#,   --  掗 (<CJK Ideograph>)
          3399  => 16#6399#,   --  掙 (<CJK Ideograph>)
          3400  => 16#639A#,   --  掚 (<CJK Ideograph>)
          3401  => 16#639B#,   --  掛 (<CJK Ideograph>)
          3402  => 16#639C#,   --  掜 (<CJK Ideograph>)
          3403  => 16#639D#,   --  掝 (<CJK Ideograph>)
          3404  => 16#639E#,   --  掞 (<CJK Ideograph>)
          3405  => 16#639F#,   --  掟 (<CJK Ideograph>)
          3406  => 16#63A1#,   --  採 (<CJK Ideograph>)
          3407  => 16#63A4#,   --  掤 (<CJK Ideograph>)
          3408  => 16#63A6#,   --  掦 (<CJK Ideograph>)
          3409  => 16#63AB#,   --  掫 (<CJK Ideograph>)
          3410  => 16#63AF#,   --  掯 (<CJK Ideograph>)
          3411  => 16#63B1#,   --  掱 (<CJK Ideograph>)
          3412  => 16#63B2#,   --  掲 (<CJK Ideograph>)
          3413  => 16#63B5#,   --  掵 (<CJK Ideograph>)
          3414  => 16#63B6#,   --  掶 (<CJK Ideograph>)
          3415  => 16#63B9#,   --  掹 (<CJK Ideograph>)
          3416  => 16#63BB#,   --  掻 (<CJK Ideograph>)
          3417  => 16#63BD#,   --  掽 (<CJK Ideograph>)
          3418  => 16#63BF#,   --  掿 (<CJK Ideograph>)
          3419  => 16#63C0#,   --  揀 (<CJK Ideograph>)
          3420  => 16#63C1#,   --  揁 (<CJK Ideograph>)
          3421  => 16#63C2#,   --  揂 (<CJK Ideograph>)
          3422  => 16#63C3#,   --  揃 (<CJK Ideograph>)
          3423  => 16#63C5#,   --  揅 (<CJK Ideograph>)
          3424  => 16#63C7#,   --  揇 (<CJK Ideograph>)
          3425  => 16#63C8#,   --  揈 (<CJK Ideograph>)
          3426  => 16#63CA#,   --  揊 (<CJK Ideograph>)
          3427  => 16#63CB#,   --  揋 (<CJK Ideograph>)
          3428  => 16#63CC#,   --  揌 (<CJK Ideograph>)
          3429  => 16#63D1#,   --  揑 (<CJK Ideograph>)
          3430  => 16#63D3#,   --  揓 (<CJK Ideograph>)
          3431  => 16#63D4#,   --  揔 (<CJK Ideograph>)
          3432  => 16#63D5#,   --  揕 (<CJK Ideograph>)
          3433  => 16#63D7#,   --  揗 (<CJK Ideograph>)
          3434  => 16#63D8#,   --  揘 (<CJK Ideograph>)
          3435  => 16#63D9#,   --  揙 (<CJK Ideograph>)
          3436  => 16#63DA#,   --  揚 (<CJK Ideograph>)
          3437  => 16#63DB#,   --  換 (<CJK Ideograph>)
          3438  => 16#63DC#,   --  揜 (<CJK Ideograph>)
          3439  => 16#63DD#,   --  揝 (<CJK Ideograph>)
          3440  => 16#63DF#,   --  揟 (<CJK Ideograph>)
          3441  => 16#63E2#,   --  揢 (<CJK Ideograph>)
          3442  => 16#63E4#,   --  揤 (<CJK Ideograph>)
          3443  => 16#63E5#,   --  揥 (<CJK Ideograph>)
          3444  => 16#63E6#,   --  揦 (<CJK Ideograph>)
          3445  => 16#63E7#,   --  揧 (<CJK Ideograph>)
          3446  => 16#63E8#,   --  揨 (<CJK Ideograph>)
          3447  => 16#63EB#,   --  揫 (<CJK Ideograph>)
          3448  => 16#63EC#,   --  揬 (<CJK Ideograph>)
          3449  => 16#63EE#,   --  揮 (<CJK Ideograph>)
          3450  => 16#63EF#,   --  揯 (<CJK Ideograph>)
          3451  => 16#63F0#,   --  揰 (<CJK Ideograph>)
          3452  => 16#63F1#,   --  揱 (<CJK Ideograph>)
          3453  => 16#63F3#,   --  揳 (<CJK Ideograph>)
          3454  => 16#63F5#,   --  揵 (<CJK Ideograph>)
          3455  => 16#63F7#,   --  揷 (<CJK Ideograph>)
          3456  => 16#63F9#,   --  揹 (<CJK Ideograph>)
          3457  => 16#63FA#,   --  揺 (<CJK Ideograph>)
          3458  => 16#63FB#,   --  揻 (<CJK Ideograph>)
          3459  => 16#63FC#,   --  揼 (<CJK Ideograph>)
          3460  => 16#63FE#,   --  揾 (<CJK Ideograph>)
          3461  => 16#6403#,   --  搃 (<CJK Ideograph>)
          3462  => 16#6404#,   --  搄 (<CJK Ideograph>)
          3463  => 16#6406#,   --  搆 (<CJK Ideograph>)
          3464  => 16#6407#,   --  搇 (<CJK Ideograph>)
          3465  => 16#6408#,   --  搈 (<CJK Ideograph>)
          3466  => 16#6409#,   --  搉 (<CJK Ideograph>)
          3467  => 16#640A#,   --  搊 (<CJK Ideograph>)
          3468  => 16#640D#,   --  損 (<CJK Ideograph>)
          3469  => 16#640E#,   --  搎 (<CJK Ideograph>)
          3470  => 16#6411#,   --  搑 (<CJK Ideograph>)
          3471  => 16#6412#,   --  搒 (<CJK Ideograph>)
          3472  => 16#6415#,   --  搕 (<CJK Ideograph>)
          3473  => 16#6416#,   --  搖 (<CJK Ideograph>)
          3474  => 16#6417#,   --  搗 (<CJK Ideograph>)
          3475  => 16#6418#,   --  搘 (<CJK Ideograph>)
          3476  => 16#6419#,   --  搙 (<CJK Ideograph>)
          3477  => 16#641A#,   --  搚 (<CJK Ideograph>)
          3478  => 16#641D#,   --  搝 (<CJK Ideograph>)
          3479  => 16#641F#,   --  搟 (<CJK Ideograph>)
          3480  => 16#6422#,   --  搢 (<CJK Ideograph>)
          3481  => 16#6423#,   --  搣 (<CJK Ideograph>)
          3482  => 16#6424#,   --  搤 (<CJK Ideograph>)
          3483  => 16#6425#,   --  搥 (<CJK Ideograph>)
          3484  => 16#6427#,   --  搧 (<CJK Ideograph>)
          3485  => 16#6428#,   --  搨 (<CJK Ideograph>)
          3486  => 16#6429#,   --  搩 (<CJK Ideograph>)
          3487  => 16#642B#,   --  搫 (<CJK Ideograph>)
          3488  => 16#642E#,   --  搮 (<CJK Ideograph>)
          3489  => 16#642F#,   --  搯 (<CJK Ideograph>)
          3490  => 16#6430#,   --  搰 (<CJK Ideograph>)
          3491  => 16#6431#,   --  搱 (<CJK Ideograph>)
          3492  => 16#6432#,   --  搲 (<CJK Ideograph>)
          3493  => 16#6433#,   --  搳 (<CJK Ideograph>)
          3494  => 16#6435#,   --  搵 (<CJK Ideograph>)
          3495  => 16#6436#,   --  搶 (<CJK Ideograph>)
          3496  => 16#6437#,   --  搷 (<CJK Ideograph>)
          3497  => 16#6438#,   --  搸 (<CJK Ideograph>)
          3498  => 16#6439#,   --  搹 (<CJK Ideograph>)
          3499  => 16#643B#,   --  搻 (<CJK Ideograph>)
          3500  => 16#643C#,   --  搼 (<CJK Ideograph>)
          3501  => 16#643E#,   --  搾 (<CJK Ideograph>)
          3502  => 16#6440#,   --  摀 (<CJK Ideograph>)
          3503  => 16#6442#,   --  摂 (<CJK Ideograph>)
          3504  => 16#6443#,   --  摃 (<CJK Ideograph>)
          3505  => 16#6449#,   --  摉 (<CJK Ideograph>)
          3506  => 16#644B#,   --  摋 (<CJK Ideograph>)
          3507  => 16#644C#,   --  摌 (<CJK Ideograph>)
          3508  => 16#644D#,   --  摍 (<CJK Ideograph>)
          3509  => 16#644E#,   --  摎 (<CJK Ideograph>)
          3510  => 16#644F#,   --  摏 (<CJK Ideograph>)
          3511  => 16#6450#,   --  摐 (<CJK Ideograph>)
          3512  => 16#6451#,   --  摑 (<CJK Ideograph>)
          3513  => 16#6453#,   --  摓 (<CJK Ideograph>)
          3514  => 16#6455#,   --  摕 (<CJK Ideograph>)
          3515  => 16#6456#,   --  摖 (<CJK Ideograph>)
          3516  => 16#6457#,   --  摗 (<CJK Ideograph>)
          3517  => 16#6459#,   --  摙 (<CJK Ideograph>)
          3518  => 16#645A#,   --  摚 (<CJK Ideograph>)
          3519  => 16#645B#,   --  摛 (<CJK Ideograph>)
          3520  => 16#645C#,   --  摜 (<CJK Ideograph>)
          3521  => 16#645D#,   --  摝 (<CJK Ideograph>)
          3522  => 16#645F#,   --  摟 (<CJK Ideograph>)
          3523  => 16#6460#,   --  摠 (<CJK Ideograph>)
          3524  => 16#6461#,   --  摡 (<CJK Ideograph>)
          3525  => 16#6462#,   --  摢 (<CJK Ideograph>)
          3526  => 16#6463#,   --  摣 (<CJK Ideograph>)
          3527  => 16#6464#,   --  摤 (<CJK Ideograph>)
          3528  => 16#6465#,   --  摥 (<CJK Ideograph>)
          3529  => 16#6466#,   --  摦 (<CJK Ideograph>)
          3530  => 16#6468#,   --  摨 (<CJK Ideograph>)
          3531  => 16#646A#,   --  摪 (<CJK Ideograph>)
          3532  => 16#646B#,   --  摫 (<CJK Ideograph>)
          3533  => 16#646C#,   --  摬 (<CJK Ideograph>)
          3534  => 16#646E#,   --  摮 (<CJK Ideograph>)
          3535  => 16#646F#,   --  摯 (<CJK Ideograph>)
          3536  => 16#6470#,   --  摰 (<CJK Ideograph>)
          3537  => 16#6471#,   --  摱 (<CJK Ideograph>)
          3538  => 16#6472#,   --  摲 (<CJK Ideograph>)
          3539  => 16#6473#,   --  摳 (<CJK Ideograph>)
          3540  => 16#6474#,   --  摴 (<CJK Ideograph>)
          3541  => 16#6475#,   --  摵 (<CJK Ideograph>)
          3542  => 16#6476#,   --  摶 (<CJK Ideograph>)
          3543  => 16#6477#,   --  摷 (<CJK Ideograph>)
          3544  => 16#647B#,   --  摻 (<CJK Ideograph>)
          3545  => 16#647C#,   --  摼 (<CJK Ideograph>)
          3546  => 16#647D#,   --  摽 (<CJK Ideograph>)
          3547  => 16#647E#,   --  摾 (<CJK Ideograph>)
          3548  => 16#647F#,   --  摿 (<CJK Ideograph>)
          3549  => 16#6480#,   --  撀 (<CJK Ideograph>)
          3550  => 16#6481#,   --  撁 (<CJK Ideograph>)
          3551  => 16#6483#,   --  撃 (<CJK Ideograph>)
          3552  => 16#6486#,   --  撆 (<CJK Ideograph>)
          3553  => 16#6488#,   --  撈 (<CJK Ideograph>)
          3554  => 16#6489#,   --  撉 (<CJK Ideograph>)
          3555  => 16#648A#,   --  撊 (<CJK Ideograph>)
          3556  => 16#648B#,   --  撋 (<CJK Ideograph>)
          3557  => 16#648C#,   --  撌 (<CJK Ideograph>)
          3558  => 16#648D#,   --  撍 (<CJK Ideograph>)
          3559  => 16#648E#,   --  撎 (<CJK Ideograph>)
          3560  => 16#648F#,   --  撏 (<CJK Ideograph>)
          3561  => 16#6490#,   --  撐 (<CJK Ideograph>)
          3562  => 16#6493#,   --  撓 (<CJK Ideograph>)
          3563  => 16#6494#,   --  撔 (<CJK Ideograph>)
          3564  => 16#6497#,   --  撗 (<CJK Ideograph>)
          3565  => 16#6498#,   --  撘 (<CJK Ideograph>)
          3566  => 16#649A#,   --  撚 (<CJK Ideograph>)
          3567  => 16#649B#,   --  撛 (<CJK Ideograph>)
          3568  => 16#649C#,   --  撜 (<CJK Ideograph>)
          3569  => 16#649D#,   --  撝 (<CJK Ideograph>)
          3570  => 16#649F#,   --  撟 (<CJK Ideograph>)
          3571  => 16#64A0#,   --  撠 (<CJK Ideograph>)
          3572  => 16#64A1#,   --  撡 (<CJK Ideograph>)
          3573  => 16#64A2#,   --  撢 (<CJK Ideograph>)
          3574  => 16#64A3#,   --  撣 (<CJK Ideograph>)
          3575  => 16#64A5#,   --  撥 (<CJK Ideograph>)
          3576  => 16#64A6#,   --  撦 (<CJK Ideograph>)
          3577  => 16#64A7#,   --  撧 (<CJK Ideograph>)
          3578  => 16#64A8#,   --  撨 (<CJK Ideograph>)
          3579  => 16#64AA#,   --  撪 (<CJK Ideograph>)
          3580  => 16#64AB#,   --  撫 (<CJK Ideograph>)
          3581  => 16#64AF#,   --  撯 (<CJK Ideograph>)
          3582  => 16#64B1#,   --  撱 (<CJK Ideograph>)
          3583  => 16#64B2#,   --  撲 (<CJK Ideograph>)
          3584  => 16#64B3#,   --  撳 (<CJK Ideograph>)
          3585  => 16#64B4#,   --  撴 (<CJK Ideograph>)
          3586  => 16#64B6#,   --  撶 (<CJK Ideograph>)
          3587  => 16#64B9#,   --  撹 (<CJK Ideograph>)
          3588  => 16#64BB#,   --  撻 (<CJK Ideograph>)
          3589  => 16#64BD#,   --  撽 (<CJK Ideograph>)
          3590  => 16#64BE#,   --  撾 (<CJK Ideograph>)
          3591  => 16#64BF#,   --  撿 (<CJK Ideograph>)
          3592  => 16#64C1#,   --  擁 (<CJK Ideograph>)
          3593  => 16#64C3#,   --  擃 (<CJK Ideograph>)
          3594  => 16#64C4#,   --  擄 (<CJK Ideograph>)
          3595  => 16#64C6#,   --  擆 (<CJK Ideograph>)
          3596  => 16#64C7#,   --  擇 (<CJK Ideograph>)
          3597  => 16#64C8#,   --  擈 (<CJK Ideograph>)
          3598  => 16#64C9#,   --  擉 (<CJK Ideograph>)
          3599  => 16#64CA#,   --  擊 (<CJK Ideograph>)
          3600  => 16#64CB#,   --  擋 (<CJK Ideograph>)
          3601  => 16#64CC#,   --  擌 (<CJK Ideograph>)
          3602  => 16#64CF#,   --  擏 (<CJK Ideograph>)
          3603  => 16#64D1#,   --  擑 (<CJK Ideograph>)
          3604  => 16#64D3#,   --  擓 (<CJK Ideograph>)
          3605  => 16#64D4#,   --  擔 (<CJK Ideograph>)
          3606  => 16#64D5#,   --  擕 (<CJK Ideograph>)
          3607  => 16#64D6#,   --  擖 (<CJK Ideograph>)
          3608  => 16#64D9#,   --  擙 (<CJK Ideograph>)
          3609  => 16#64DA#,   --  據 (<CJK Ideograph>)
          3610  => 16#64DB#,   --  擛 (<CJK Ideograph>)
          3611  => 16#64DC#,   --  擜 (<CJK Ideograph>)
          3612  => 16#64DD#,   --  擝 (<CJK Ideograph>)
          3613  => 16#64DF#,   --  擟 (<CJK Ideograph>)
          3614  => 16#64E0#,   --  擠 (<CJK Ideograph>)
          3615  => 16#64E1#,   --  擡 (<CJK Ideograph>)
          3616  => 16#64E3#,   --  擣 (<CJK Ideograph>)
          3617  => 16#64E5#,   --  擥 (<CJK Ideograph>)
          3618  => 16#64E7#,   --  擧 (<CJK Ideograph>)
          3619  => 16#64E8#,   --  擨 (<CJK Ideograph>)
          3620  => 16#64E9#,   --  擩 (<CJK Ideograph>)
          3621  => 16#64EA#,   --  擪 (<CJK Ideograph>)
          3622  => 16#64EB#,   --  擫 (<CJK Ideograph>)
          3623  => 16#64EC#,   --  擬 (<CJK Ideograph>)
          3624  => 16#64ED#,   --  擭 (<CJK Ideograph>)
          3625  => 16#64EE#,   --  擮 (<CJK Ideograph>)
          3626  => 16#64EF#,   --  擯 (<CJK Ideograph>)
          3627  => 16#64F0#,   --  擰 (<CJK Ideograph>)
          3628  => 16#64F1#,   --  擱 (<CJK Ideograph>)
          3629  => 16#64F2#,   --  擲 (<CJK Ideograph>)
          3630  => 16#64F3#,   --  擳 (<CJK Ideograph>)
          3631  => 16#64F4#,   --  擴 (<CJK Ideograph>)
          3632  => 16#64F5#,   --  擵 (<CJK Ideograph>)
          3633  => 16#64F6#,   --  擶 (<CJK Ideograph>)
          3634  => 16#64F7#,   --  擷 (<CJK Ideograph>)
          3635  => 16#64F8#,   --  擸 (<CJK Ideograph>)
          3636  => 16#64F9#,   --  擹 (<CJK Ideograph>)
          3637  => 16#64FA#,   --  擺 (<CJK Ideograph>)
          3638  => 16#64FB#,   --  擻 (<CJK Ideograph>)
          3639  => 16#64FC#,   --  擼 (<CJK Ideograph>)
          3640  => 16#64FD#,   --  擽 (<CJK Ideograph>)
          3641  => 16#64FE#,   --  擾 (<CJK Ideograph>)
          3642  => 16#64FF#,   --  擿 (<CJK Ideograph>)
          3643  => 16#6501#,   --  攁 (<CJK Ideograph>)
          3644  => 16#6502#,   --  攂 (<CJK Ideograph>)
          3645  => 16#6503#,   --  攃 (<CJK Ideograph>)
          3646  => 16#6504#,   --  攄 (<CJK Ideograph>)
          3647  => 16#6505#,   --  攅 (<CJK Ideograph>)
          3648  => 16#6506#,   --  攆 (<CJK Ideograph>)
          3649  => 16#6507#,   --  攇 (<CJK Ideograph>)
          3650  => 16#6508#,   --  攈 (<CJK Ideograph>)
          3651  => 16#650A#,   --  攊 (<CJK Ideograph>)
          3652  => 16#650B#,   --  攋 (<CJK Ideograph>)
          3653  => 16#650C#,   --  攌 (<CJK Ideograph>)
          3654  => 16#650D#,   --  攍 (<CJK Ideograph>)
          3655  => 16#650E#,   --  攎 (<CJK Ideograph>)
          3656  => 16#650F#,   --  攏 (<CJK Ideograph>)
          3657  => 16#6510#,   --  攐 (<CJK Ideograph>)
          3658  => 16#6511#,   --  攑 (<CJK Ideograph>)
          3659  => 16#6513#,   --  攓 (<CJK Ideograph>)
          3660  => 16#6514#,   --  攔 (<CJK Ideograph>)
          3661  => 16#6515#,   --  攕 (<CJK Ideograph>)
          3662  => 16#6516#,   --  攖 (<CJK Ideograph>)
          3663  => 16#6517#,   --  攗 (<CJK Ideograph>)
          3664  => 16#6519#,   --  攙 (<CJK Ideograph>)
          3665  => 16#651A#,   --  攚 (<CJK Ideograph>)
          3666  => 16#651B#,   --  攛 (<CJK Ideograph>)
          3667  => 16#651C#,   --  攜 (<CJK Ideograph>)
          3668  => 16#651D#,   --  攝 (<CJK Ideograph>)
          3669  => 16#651E#,   --  攞 (<CJK Ideograph>)
          3670  => 16#651F#,   --  攟 (<CJK Ideograph>)
          3671  => 16#6520#,   --  攠 (<CJK Ideograph>)
          3672  => 16#6521#,   --  攡 (<CJK Ideograph>)
          3673  => 16#6522#,   --  攢 (<CJK Ideograph>)
          3674  => 16#6523#,   --  攣 (<CJK Ideograph>)
          3675  => 16#6524#,   --  攤 (<CJK Ideograph>)
          3676  => 16#6526#,   --  攦 (<CJK Ideograph>)
          3677  => 16#6527#,   --  攧 (<CJK Ideograph>)
          3678  => 16#6528#,   --  攨 (<CJK Ideograph>)
          3679  => 16#6529#,   --  攩 (<CJK Ideograph>)
          3680  => 16#652A#,   --  攪 (<CJK Ideograph>)
          3681  => 16#652C#,   --  攬 (<CJK Ideograph>)
          3682  => 16#652D#,   --  攭 (<CJK Ideograph>)
          3683  => 16#6530#,   --  攰 (<CJK Ideograph>)
          3684  => 16#6531#,   --  攱 (<CJK Ideograph>)
          3685  => 16#6532#,   --  攲 (<CJK Ideograph>)
          3686  => 16#6533#,   --  攳 (<CJK Ideograph>)
          3687  => 16#6537#,   --  攷 (<CJK Ideograph>)
          3688  => 16#653A#,   --  攺 (<CJK Ideograph>)
          3689  => 16#653C#,   --  攼 (<CJK Ideograph>)
          3690  => 16#653D#,   --  攽 (<CJK Ideograph>)
          3691  => 16#6540#,   --  敀 (<CJK Ideograph>)
          3692  => 16#6541#,   --  敁 (<CJK Ideograph>)
          3693  => 16#6542#,   --  敂 (<CJK Ideograph>)
          3694  => 16#6543#,   --  敃 (<CJK Ideograph>)
          3695  => 16#6544#,   --  敄 (<CJK Ideograph>)
          3696  => 16#6546#,   --  敆 (<CJK Ideograph>)
          3697  => 16#6547#,   --  敇 (<CJK Ideograph>)
          3698  => 16#654A#,   --  敊 (<CJK Ideograph>)
          3699  => 16#654B#,   --  敋 (<CJK Ideograph>)
          3700  => 16#654D#,   --  敍 (<CJK Ideograph>)
          3701  => 16#654E#,   --  敎 (<CJK Ideograph>)
          3702  => 16#6550#,   --  敐 (<CJK Ideograph>)
          3703  => 16#6552#,   --  敒 (<CJK Ideograph>)
          3704  => 16#6553#,   --  敓 (<CJK Ideograph>)
          3705  => 16#6554#,   --  敔 (<CJK Ideograph>)
          3706  => 16#6557#,   --  敗 (<CJK Ideograph>)
          3707  => 16#6558#,   --  敘 (<CJK Ideograph>)
          3708  => 16#655A#,   --  敚 (<CJK Ideograph>)
          3709  => 16#655C#,   --  敜 (<CJK Ideograph>)
          3710  => 16#655F#,   --  敟 (<CJK Ideograph>)
          3711  => 16#6560#,   --  敠 (<CJK Ideograph>)
          3712  => 16#6561#,   --  敡 (<CJK Ideograph>)
          3713  => 16#6564#,   --  敤 (<CJK Ideograph>)
          3714  => 16#6565#,   --  敥 (<CJK Ideograph>)
          3715  => 16#6567#,   --  敧 (<CJK Ideograph>)
          3716  => 16#6568#,   --  敨 (<CJK Ideograph>)
          3717  => 16#6569#,   --  敩 (<CJK Ideograph>)
          3718  => 16#656A#,   --  敪 (<CJK Ideograph>)
          3719  => 16#656D#,   --  敭 (<CJK Ideograph>)
          3720  => 16#656E#,   --  敮 (<CJK Ideograph>)
          3721  => 16#656F#,   --  敯 (<CJK Ideograph>)
          3722  => 16#6571#,   --  敱 (<CJK Ideograph>)
          3723  => 16#6573#,   --  敳 (<CJK Ideograph>)
          3724  => 16#6575#,   --  敵 (<CJK Ideograph>)
          3725  => 16#6576#,   --  敶 (<CJK Ideograph>)
          3726  => 16#6578#,   --  數 (<CJK Ideograph>)
          3727  => 16#6579#,   --  敹 (<CJK Ideograph>)
          3728  => 16#657A#,   --  敺 (<CJK Ideograph>)
          3729  => 16#657B#,   --  敻 (<CJK Ideograph>)
          3730  => 16#657C#,   --  敼 (<CJK Ideograph>)
          3731  => 16#657D#,   --  敽 (<CJK Ideograph>)
          3732  => 16#657E#,   --  敾 (<CJK Ideograph>)
          3733  => 16#657F#,   --  敿 (<CJK Ideograph>)
          3734  => 16#6580#,   --  斀 (<CJK Ideograph>)
          3735  => 16#6581#,   --  斁 (<CJK Ideograph>)
          3736  => 16#6582#,   --  斂 (<CJK Ideograph>)
          3737  => 16#6583#,   --  斃 (<CJK Ideograph>)
          3738  => 16#6584#,   --  斄 (<CJK Ideograph>)
          3739  => 16#6585#,   --  斅 (<CJK Ideograph>)
          3740  => 16#6586#,   --  斆 (<CJK Ideograph>)
          3741  => 16#6588#,   --  斈 (<CJK Ideograph>)
          3742  => 16#6589#,   --  斉 (<CJK Ideograph>)
          3743  => 16#658A#,   --  斊 (<CJK Ideograph>)
          3744  => 16#658D#,   --  斍 (<CJK Ideograph>)
          3745  => 16#658E#,   --  斎 (<CJK Ideograph>)
          3746  => 16#658F#,   --  斏 (<CJK Ideograph>)
          3747  => 16#6592#,   --  斒 (<CJK Ideograph>)
          3748  => 16#6594#,   --  斔 (<CJK Ideograph>)
          3749  => 16#6595#,   --  斕 (<CJK Ideograph>)
          3750  => 16#6596#,   --  斖 (<CJK Ideograph>)
          3751  => 16#6598#,   --  斘 (<CJK Ideograph>)
          3752  => 16#659A#,   --  斚 (<CJK Ideograph>)
          3753  => 16#659D#,   --  斝 (<CJK Ideograph>)
          3754  => 16#659E#,   --  斞 (<CJK Ideograph>)
          3755  => 16#65A0#,   --  斠 (<CJK Ideograph>)
          3756  => 16#65A2#,   --  斢 (<CJK Ideograph>)
          3757  => 16#65A3#,   --  斣 (<CJK Ideograph>)
          3758  => 16#65A6#,   --  斦 (<CJK Ideograph>)
          3759  => 16#65A8#,   --  斨 (<CJK Ideograph>)
          3760  => 16#65AA#,   --  斪 (<CJK Ideograph>)
          3761  => 16#65AC#,   --  斬 (<CJK Ideograph>)
          3762  => 16#65AE#,   --  斮 (<CJK Ideograph>)
          3763  => 16#65B1#,   --  斱 (<CJK Ideograph>)
          3764  => 16#65B2#,   --  斲 (<CJK Ideograph>)
          3765  => 16#65B3#,   --  斳 (<CJK Ideograph>)
          3766  => 16#65B4#,   --  斴 (<CJK Ideograph>)
          3767  => 16#65B5#,   --  斵 (<CJK Ideograph>)
          3768  => 16#65B6#,   --  斶 (<CJK Ideograph>)
          3769  => 16#65B7#,   --  斷 (<CJK Ideograph>)
          3770  => 16#65B8#,   --  斸 (<CJK Ideograph>)
          3771  => 16#65BA#,   --  斺 (<CJK Ideograph>)
          3772  => 16#65BB#,   --  斻 (<CJK Ideograph>)
          3773  => 16#65BE#,   --  斾 (<CJK Ideograph>)
          3774  => 16#65BF#,   --  斿 (<CJK Ideograph>)
          3775  => 16#65C0#,   --  旀 (<CJK Ideograph>)
          3776  => 16#65C2#,   --  旂 (<CJK Ideograph>)
          3777  => 16#65C7#,   --  旇 (<CJK Ideograph>)
          3778  => 16#65C8#,   --  旈 (<CJK Ideograph>)
          3779  => 16#65C9#,   --  旉 (<CJK Ideograph>)
          3780  => 16#65CA#,   --  旊 (<CJK Ideograph>)
          3781  => 16#65CD#,   --  旍 (<CJK Ideograph>)
          3782  => 16#65D0#,   --  旐 (<CJK Ideograph>)
          3783  => 16#65D1#,   --  旑 (<CJK Ideograph>)
          3784  => 16#65D3#,   --  旓 (<CJK Ideograph>)
          3785  => 16#65D4#,   --  旔 (<CJK Ideograph>)
          3786  => 16#65D5#,   --  旕 (<CJK Ideograph>)
          3787  => 16#65D8#,   --  旘 (<CJK Ideograph>)
          3788  => 16#65D9#,   --  旙 (<CJK Ideograph>)
          3789  => 16#65DA#,   --  旚 (<CJK Ideograph>)
          3790  => 16#65DB#,   --  旛 (<CJK Ideograph>)
          3791  => 16#65DC#,   --  旜 (<CJK Ideograph>)
          3792  => 16#65DD#,   --  旝 (<CJK Ideograph>)
          3793  => 16#65DE#,   --  旞 (<CJK Ideograph>)
          3794  => 16#65DF#,   --  旟 (<CJK Ideograph>)
          3795  => 16#65E1#,   --  旡 (<CJK Ideograph>)
          3796  => 16#65E3#,   --  旣 (<CJK Ideograph>)
          3797  => 16#65E4#,   --  旤 (<CJK Ideograph>)
          3798  => 16#65EA#,   --  旪 (<CJK Ideograph>)
          3799  => 16#65EB#,   --  旫 (<CJK Ideograph>)
          3800  => 16#65F2#,   --  旲 (<CJK Ideograph>)
          3801  => 16#65F3#,   --  旳 (<CJK Ideograph>)
          3802  => 16#65F4#,   --  旴 (<CJK Ideograph>)
          3803  => 16#65F5#,   --  旵 (<CJK Ideograph>)
          3804  => 16#65F8#,   --  旸 (<CJK Ideograph>)
          3805  => 16#65F9#,   --  旹 (<CJK Ideograph>)
          3806  => 16#65FB#,   --  旻 (<CJK Ideograph>)
          3807  => 16#65FC#,   --  旼 (<CJK Ideograph>)
          3808  => 16#65FD#,   --  旽 (<CJK Ideograph>)
          3809  => 16#65FE#,   --  旾 (<CJK Ideograph>)
          3810  => 16#65FF#,   --  旿 (<CJK Ideograph>)
          3811  => 16#6601#,   --  昁 (<CJK Ideograph>)
          3812  => 16#6604#,   --  昄 (<CJK Ideograph>)
          3813  => 16#6605#,   --  昅 (<CJK Ideograph>)
          3814  => 16#6607#,   --  昇 (<CJK Ideograph>)
          3815  => 16#6608#,   --  昈 (<CJK Ideograph>)
          3816  => 16#6609#,   --  昉 (<CJK Ideograph>)
          3817  => 16#660B#,   --  昋 (<CJK Ideograph>)
          3818  => 16#660D#,   --  昍 (<CJK Ideograph>)
          3819  => 16#6610#,   --  昐 (<CJK Ideograph>)
          3820  => 16#6611#,   --  昑 (<CJK Ideograph>)
          3821  => 16#6612#,   --  昒 (<CJK Ideograph>)
          3822  => 16#6616#,   --  昖 (<CJK Ideograph>)
          3823  => 16#6617#,   --  昗 (<CJK Ideograph>)
          3824  => 16#6618#,   --  昘 (<CJK Ideograph>)
          3825  => 16#661A#,   --  昚 (<CJK Ideograph>)
          3826  => 16#661B#,   --  昛 (<CJK Ideograph>)
          3827  => 16#661C#,   --  昜 (<CJK Ideograph>)
          3828  => 16#661E#,   --  昞 (<CJK Ideograph>)
          3829  => 16#6621#,   --  昡 (<CJK Ideograph>)
          3830  => 16#6622#,   --  昢 (<CJK Ideograph>)
          3831  => 16#6623#,   --  昣 (<CJK Ideograph>)
          3832  => 16#6624#,   --  昤 (<CJK Ideograph>)
          3833  => 16#6626#,   --  昦 (<CJK Ideograph>)
          3834  => 16#6629#,   --  昩 (<CJK Ideograph>)
          3835  => 16#662A#,   --  昪 (<CJK Ideograph>)
          3836  => 16#662B#,   --  昫 (<CJK Ideograph>)
          3837  => 16#662C#,   --  昬 (<CJK Ideograph>)
          3838  => 16#662E#,   --  昮 (<CJK Ideograph>)
          3839  => 16#6630#,   --  昰 (<CJK Ideograph>)
          3840  => 16#6632#,   --  昲 (<CJK Ideograph>)
          3841  => 16#6633#,   --  昳 (<CJK Ideograph>)
          3842  => 16#6637#,   --  昷 (<CJK Ideograph>)
          3843  => 16#6638#,   --  昸 (<CJK Ideograph>)
          3844  => 16#6639#,   --  昹 (<CJK Ideograph>)
          3845  => 16#663A#,   --  昺 (<CJK Ideograph>)
          3846  => 16#663B#,   --  昻 (<CJK Ideograph>)
          3847  => 16#663D#,   --  昽 (<CJK Ideograph>)
          3848  => 16#663F#,   --  昿 (<CJK Ideograph>)
          3849  => 16#6640#,   --  晀 (<CJK Ideograph>)
          3850  => 16#6642#,   --  時 (<CJK Ideograph>)
          3851  => 16#6644#,   --  晄 (<CJK Ideograph>)
          3852  => 16#6645#,   --  晅 (<CJK Ideograph>)
          3853  => 16#6646#,   --  晆 (<CJK Ideograph>)
          3854  => 16#6647#,   --  晇 (<CJK Ideograph>)
          3855  => 16#6648#,   --  晈 (<CJK Ideograph>)
          3856  => 16#6649#,   --  晉 (<CJK Ideograph>)
          3857  => 16#664A#,   --  晊 (<CJK Ideograph>)
          3858  => 16#664D#,   --  晍 (<CJK Ideograph>)
          3859  => 16#664E#,   --  晎 (<CJK Ideograph>)
          3860  => 16#6650#,   --  晐 (<CJK Ideograph>)
          3861  => 16#6651#,   --  晑 (<CJK Ideograph>)
          3862  => 16#6658#,   --  晘 (<CJK Ideograph>)
          3863  => 16#6659#,   --  晙 (<CJK Ideograph>)
          3864  => 16#665B#,   --  晛 (<CJK Ideograph>)
          3865  => 16#665C#,   --  晜 (<CJK Ideograph>)
          3866  => 16#665D#,   --  晝 (<CJK Ideograph>)
          3867  => 16#665E#,   --  晞 (<CJK Ideograph>)
          3868  => 16#6660#,   --  晠 (<CJK Ideograph>)
          3869  => 16#6662#,   --  晢 (<CJK Ideograph>)
          3870  => 16#6663#,   --  晣 (<CJK Ideograph>)
          3871  => 16#6665#,   --  晥 (<CJK Ideograph>)
          3872  => 16#6667#,   --  晧 (<CJK Ideograph>)
          3873  => 16#6669#,   --  晩 (<CJK Ideograph>)
          3874  => 16#666A#,   --  晪 (<CJK Ideograph>)
          3875  => 16#666B#,   --  晫 (<CJK Ideograph>)
          3876  => 16#666C#,   --  晬 (<CJK Ideograph>)
          3877  => 16#666D#,   --  晭 (<CJK Ideograph>)
          3878  => 16#6671#,   --  晱 (<CJK Ideograph>)
          3879  => 16#6672#,   --  晲 (<CJK Ideograph>)
          3880  => 16#6673#,   --  晳 (<CJK Ideograph>)
          3881  => 16#6675#,   --  晵 (<CJK Ideograph>)
          3882  => 16#6678#,   --  晸 (<CJK Ideograph>)
          3883  => 16#6679#,   --  晹 (<CJK Ideograph>)
          3884  => 16#667B#,   --  晻 (<CJK Ideograph>)
          3885  => 16#667C#,   --  晼 (<CJK Ideograph>)
          3886  => 16#667D#,   --  晽 (<CJK Ideograph>)
          3887  => 16#667F#,   --  晿 (<CJK Ideograph>)
          3888  => 16#6680#,   --  暀 (<CJK Ideograph>)
          3889  => 16#6681#,   --  暁 (<CJK Ideograph>)
          3890  => 16#6683#,   --  暃 (<CJK Ideograph>)
          3891  => 16#6685#,   --  暅 (<CJK Ideograph>)
          3892  => 16#6686#,   --  暆 (<CJK Ideograph>)
          3893  => 16#6688#,   --  暈 (<CJK Ideograph>)
          3894  => 16#6689#,   --  暉 (<CJK Ideograph>)
          3895  => 16#668A#,   --  暊 (<CJK Ideograph>)
          3896  => 16#668B#,   --  暋 (<CJK Ideograph>)
          3897  => 16#668D#,   --  暍 (<CJK Ideograph>)
          3898  => 16#668E#,   --  暎 (<CJK Ideograph>)
          3899  => 16#668F#,   --  暏 (<CJK Ideograph>)
          3900  => 16#6690#,   --  暐 (<CJK Ideograph>)
          3901  => 16#6692#,   --  暒 (<CJK Ideograph>)
          3902  => 16#6693#,   --  暓 (<CJK Ideograph>)
          3903  => 16#6694#,   --  暔 (<CJK Ideograph>)
          3904  => 16#6695#,   --  暕 (<CJK Ideograph>)
          3905  => 16#6698#,   --  暘 (<CJK Ideograph>)
          3906  => 16#6699#,   --  暙 (<CJK Ideograph>)
          3907  => 16#669A#,   --  暚 (<CJK Ideograph>)
          3908  => 16#669B#,   --  暛 (<CJK Ideograph>)
          3909  => 16#669C#,   --  暜 (<CJK Ideograph>)
          3910  => 16#669E#,   --  暞 (<CJK Ideograph>)
          3911  => 16#669F#,   --  暟 (<CJK Ideograph>)
          3912  => 16#66A0#,   --  暠 (<CJK Ideograph>)
          3913  => 16#66A1#,   --  暡 (<CJK Ideograph>)
          3914  => 16#66A2#,   --  暢 (<CJK Ideograph>)
          3915  => 16#66A3#,   --  暣 (<CJK Ideograph>)
          3916  => 16#66A4#,   --  暤 (<CJK Ideograph>)
          3917  => 16#66A5#,   --  暥 (<CJK Ideograph>)
          3918  => 16#66A6#,   --  暦 (<CJK Ideograph>)
          3919  => 16#66A9#,   --  暩 (<CJK Ideograph>)
          3920  => 16#66AA#,   --  暪 (<CJK Ideograph>)
          3921  => 16#66AB#,   --  暫 (<CJK Ideograph>)
          3922  => 16#66AC#,   --  暬 (<CJK Ideograph>)
          3923  => 16#66AD#,   --  暭 (<CJK Ideograph>)
          3924  => 16#66AF#,   --  暯 (<CJK Ideograph>)
          3925  => 16#66B0#,   --  暰 (<CJK Ideograph>)
          3926  => 16#66B1#,   --  暱 (<CJK Ideograph>)
          3927  => 16#66B2#,   --  暲 (<CJK Ideograph>)
          3928  => 16#66B3#,   --  暳 (<CJK Ideograph>)
          3929  => 16#66B5#,   --  暵 (<CJK Ideograph>)
          3930  => 16#66B6#,   --  暶 (<CJK Ideograph>)
          3931  => 16#66B7#,   --  暷 (<CJK Ideograph>)
          3932  => 16#66B8#,   --  暸 (<CJK Ideograph>)
          3933  => 16#66BA#,   --  暺 (<CJK Ideograph>)
          3934  => 16#66BB#,   --  暻 (<CJK Ideograph>)
          3935  => 16#66BC#,   --  暼 (<CJK Ideograph>)
          3936  => 16#66BD#,   --  暽 (<CJK Ideograph>)
          3937  => 16#66BF#,   --  暿 (<CJK Ideograph>)
          3938  => 16#66C0#,   --  曀 (<CJK Ideograph>)
          3939  => 16#66C1#,   --  曁 (<CJK Ideograph>)
          3940  => 16#66C2#,   --  曂 (<CJK Ideograph>)
          3941  => 16#66C3#,   --  曃 (<CJK Ideograph>)
          3942  => 16#66C4#,   --  曄 (<CJK Ideograph>)
          3943  => 16#66C5#,   --  曅 (<CJK Ideograph>)
          3944  => 16#66C6#,   --  曆 (<CJK Ideograph>)
          3945  => 16#66C7#,   --  曇 (<CJK Ideograph>)
          3946  => 16#66C8#,   --  曈 (<CJK Ideograph>)
          3947  => 16#66C9#,   --  曉 (<CJK Ideograph>)
          3948  => 16#66CA#,   --  曊 (<CJK Ideograph>)
          3949  => 16#66CB#,   --  曋 (<CJK Ideograph>)
          3950  => 16#66CC#,   --  曌 (<CJK Ideograph>)
          3951  => 16#66CD#,   --  曍 (<CJK Ideograph>)
          3952  => 16#66CE#,   --  曎 (<CJK Ideograph>)
          3953  => 16#66CF#,   --  曏 (<CJK Ideograph>)
          3954  => 16#66D0#,   --  曐 (<CJK Ideograph>)
          3955  => 16#66D1#,   --  曑 (<CJK Ideograph>)
          3956  => 16#66D2#,   --  曒 (<CJK Ideograph>)
          3957  => 16#66D3#,   --  曓 (<CJK Ideograph>)
          3958  => 16#66D4#,   --  曔 (<CJK Ideograph>)
          3959  => 16#66D5#,   --  曕 (<CJK Ideograph>)
          3960  => 16#66D6#,   --  曖 (<CJK Ideograph>)
          3961  => 16#66D7#,   --  曗 (<CJK Ideograph>)
          3962  => 16#66D8#,   --  曘 (<CJK Ideograph>)
          3963  => 16#66DA#,   --  曚 (<CJK Ideograph>)
          3964  => 16#66DE#,   --  曞 (<CJK Ideograph>)
          3965  => 16#66DF#,   --  曟 (<CJK Ideograph>)
          3966  => 16#66E0#,   --  曠 (<CJK Ideograph>)
          3967  => 16#66E1#,   --  曡 (<CJK Ideograph>)
          3968  => 16#66E2#,   --  曢 (<CJK Ideograph>)
          3969  => 16#66E3#,   --  曣 (<CJK Ideograph>)
          3970  => 16#66E4#,   --  曤 (<CJK Ideograph>)
          3971  => 16#66E5#,   --  曥 (<CJK Ideograph>)
          3972  => 16#66E7#,   --  曧 (<CJK Ideograph>)
          3973  => 16#66E8#,   --  曨 (<CJK Ideograph>)
          3974  => 16#66EA#,   --  曪 (<CJK Ideograph>)
          3975  => 16#66EB#,   --  曫 (<CJK Ideograph>)
          3976  => 16#66EC#,   --  曬 (<CJK Ideograph>)
          3977  => 16#66ED#,   --  曭 (<CJK Ideograph>)
          3978  => 16#66EE#,   --  曮 (<CJK Ideograph>)
          3979  => 16#66EF#,   --  曯 (<CJK Ideograph>)
          3980  => 16#66F1#,   --  曱 (<CJK Ideograph>)
          3981  => 16#66F5#,   --  曵 (<CJK Ideograph>)
          3982  => 16#66F6#,   --  曶 (<CJK Ideograph>)
          3983  => 16#66F8#,   --  書 (<CJK Ideograph>)
          3984  => 16#66FA#,   --  曺 (<CJK Ideograph>)
          3985  => 16#66FB#,   --  曻 (<CJK Ideograph>)
          3986  => 16#66FD#,   --  曽 (<CJK Ideograph>)
          3987  => 16#6701#,   --  朁 (<CJK Ideograph>)
          3988  => 16#6702#,   --  朂 (<CJK Ideograph>)
          3989  => 16#6703#,   --  會 (<CJK Ideograph>)
          3990  => 16#6704#,   --  朄 (<CJK Ideograph>)
          3991  => 16#6705#,   --  朅 (<CJK Ideograph>)
          3992  => 16#6706#,   --  朆 (<CJK Ideograph>)
          3993  => 16#6707#,   --  朇 (<CJK Ideograph>)
          3994  => 16#670C#,   --  朌 (<CJK Ideograph>)
          3995  => 16#670E#,   --  朎 (<CJK Ideograph>)
          3996  => 16#670F#,   --  朏 (<CJK Ideograph>)
          3997  => 16#6711#,   --  朑 (<CJK Ideograph>)
          3998  => 16#6712#,   --  朒 (<CJK Ideograph>)
          3999  => 16#6713#,   --  朓 (<CJK Ideograph>)
          4000  => 16#6716#,   --  朖 (<CJK Ideograph>)
          4001  => 16#6718#,   --  朘 (<CJK Ideograph>)
          4002  => 16#6719#,   --  朙 (<CJK Ideograph>)
          4003  => 16#671A#,   --  朚 (<CJK Ideograph>)
          4004  => 16#671C#,   --  朜 (<CJK Ideograph>)
          4005  => 16#671E#,   --  朞 (<CJK Ideograph>)
          4006  => 16#6720#,   --  朠 (<CJK Ideograph>)
          4007  => 16#6721#,   --  朡 (<CJK Ideograph>)
          4008  => 16#6722#,   --  朢 (<CJK Ideograph>)
          4009  => 16#6723#,   --  朣 (<CJK Ideograph>)
          4010  => 16#6724#,   --  朤 (<CJK Ideograph>)
          4011  => 16#6725#,   --  朥 (<CJK Ideograph>)
          4012  => 16#6727#,   --  朧 (<CJK Ideograph>)
          4013  => 16#6729#,   --  朩 (<CJK Ideograph>)
          4014  => 16#672E#,   --  朮 (<CJK Ideograph>)
          4015  => 16#6730#,   --  朰 (<CJK Ideograph>)
          4016  => 16#6732#,   --  朲 (<CJK Ideograph>)
          4017  => 16#6733#,   --  朳 (<CJK Ideograph>)
          4018  => 16#6736#,   --  朶 (<CJK Ideograph>)
          4019  => 16#6737#,   --  朷 (<CJK Ideograph>)
          4020  => 16#6738#,   --  朸 (<CJK Ideograph>)
          4021  => 16#6739#,   --  朹 (<CJK Ideograph>)
          4022  => 16#673B#,   --  朻 (<CJK Ideograph>)
          4023  => 16#673C#,   --  朼 (<CJK Ideograph>)
          4024  => 16#673E#,   --  朾 (<CJK Ideograph>)
          4025  => 16#673F#,   --  朿 (<CJK Ideograph>)
          4026  => 16#6741#,   --  杁 (<CJK Ideograph>)
          4027  => 16#6744#,   --  杄 (<CJK Ideograph>)
          4028  => 16#6745#,   --  杅 (<CJK Ideograph>)
          4029  => 16#6747#,   --  杇 (<CJK Ideograph>)
          4030  => 16#674A#,   --  杊 (<CJK Ideograph>)
          4031  => 16#674B#,   --  杋 (<CJK Ideograph>)
          4032  => 16#674D#,   --  杍 (<CJK Ideograph>)
          4033  => 16#6752#,   --  杒 (<CJK Ideograph>)
          4034  => 16#6754#,   --  杔 (<CJK Ideograph>)
          4035  => 16#6755#,   --  杕 (<CJK Ideograph>)
          4036  => 16#6757#,   --  杗 (<CJK Ideograph>)
          4037  => 16#6758#,   --  杘 (<CJK Ideograph>)
          4038  => 16#6759#,   --  杙 (<CJK Ideograph>)
          4039  => 16#675A#,   --  杚 (<CJK Ideograph>)
          4040  => 16#675B#,   --  杛 (<CJK Ideograph>)
          4041  => 16#675D#,   --  杝 (<CJK Ideograph>)
          4042  => 16#6762#,   --  杢 (<CJK Ideograph>)
          4043  => 16#6763#,   --  杣 (<CJK Ideograph>)
          4044  => 16#6764#,   --  杤 (<CJK Ideograph>)
          4045  => 16#6766#,   --  杦 (<CJK Ideograph>)
          4046  => 16#6767#,   --  杧 (<CJK Ideograph>)
          4047  => 16#676B#,   --  杫 (<CJK Ideograph>)
          4048  => 16#676C#,   --  杬 (<CJK Ideograph>)
          4049  => 16#676E#,   --  杮 (<CJK Ideograph>)
          4050  => 16#6771#,   --  東 (<CJK Ideograph>)
          4051  => 16#6774#,   --  杴 (<CJK Ideograph>)
          4052  => 16#6776#,   --  杶 (<CJK Ideograph>)
          4053  => 16#6778#,   --  杸 (<CJK Ideograph>)
          4054  => 16#6779#,   --  杹 (<CJK Ideograph>)
          4055  => 16#677A#,   --  杺 (<CJK Ideograph>)
          4056  => 16#677B#,   --  杻 (<CJK Ideograph>)
          4057  => 16#677D#,   --  杽 (<CJK Ideograph>)
          4058  => 16#6780#,   --  枀 (<CJK Ideograph>)
          4059  => 16#6782#,   --  枂 (<CJK Ideograph>)
          4060  => 16#6783#,   --  枃 (<CJK Ideograph>)
          4061  => 16#6785#,   --  枅 (<CJK Ideograph>)
          4062  => 16#6786#,   --  枆 (<CJK Ideograph>)
          4063  => 16#6788#,   --  枈 (<CJK Ideograph>)
          4064  => 16#678A#,   --  枊 (<CJK Ideograph>)
          4065  => 16#678C#,   --  枌 (<CJK Ideograph>)
          4066  => 16#678D#,   --  枍 (<CJK Ideograph>)
          4067  => 16#678E#,   --  枎 (<CJK Ideograph>)
          4068  => 16#678F#,   --  枏 (<CJK Ideograph>)
          4069  => 16#6791#,   --  枑 (<CJK Ideograph>)
          4070  => 16#6792#,   --  枒 (<CJK Ideograph>)
          4071  => 16#6793#,   --  枓 (<CJK Ideograph>)
          4072  => 16#6794#,   --  枔 (<CJK Ideograph>)
          4073  => 16#6796#,   --  枖 (<CJK Ideograph>)
          4074  => 16#6799#,   --  枙 (<CJK Ideograph>)
          4075  => 16#679B#,   --  枛 (<CJK Ideograph>)
          4076  => 16#679F#,   --  枟 (<CJK Ideograph>)
          4077  => 16#67A0#,   --  枠 (<CJK Ideograph>)
          4078  => 16#67A1#,   --  枡 (<CJK Ideograph>)
          4079  => 16#67A4#,   --  枤 (<CJK Ideograph>)
          4080  => 16#67A6#,   --  枦 (<CJK Ideograph>)
          4081  => 16#67A9#,   --  枩 (<CJK Ideograph>)
          4082  => 16#67AC#,   --  枬 (<CJK Ideograph>)
          4083  => 16#67AE#,   --  枮 (<CJK Ideograph>)
          4084  => 16#67B1#,   --  枱 (<CJK Ideograph>)
          4085  => 16#67B2#,   --  枲 (<CJK Ideograph>)
          4086  => 16#67B4#,   --  枴 (<CJK Ideograph>)
          4087  => 16#67B9#,   --  枹 (<CJK Ideograph>)
          4088  => 16#67BA#,   --  枺 (<CJK Ideograph>)
          4089  => 16#67BB#,   --  枻 (<CJK Ideograph>)
          4090  => 16#67BC#,   --  枼 (<CJK Ideograph>)
          4091  => 16#67BD#,   --  枽 (<CJK Ideograph>)
          4092  => 16#67BE#,   --  枾 (<CJK Ideograph>)
          4093  => 16#67BF#,   --  枿 (<CJK Ideograph>)
          4094  => 16#67C0#,   --  柀 (<CJK Ideograph>)
          4095  => 16#67C2#,   --  柂 (<CJK Ideograph>)
          4096  => 16#67C5#,   --  柅 (<CJK Ideograph>)
          4097  => 16#67C6#,   --  柆 (<CJK Ideograph>)
          4098  => 16#67C7#,   --  柇 (<CJK Ideograph>)
          4099  => 16#67C8#,   --  柈 (<CJK Ideograph>)
          4100  => 16#67C9#,   --  柉 (<CJK Ideograph>)
          4101  => 16#67CA#,   --  柊 (<CJK Ideograph>)
          4102  => 16#67CB#,   --  柋 (<CJK Ideograph>)
          4103  => 16#67CC#,   --  柌 (<CJK Ideograph>)
          4104  => 16#67CD#,   --  柍 (<CJK Ideograph>)
          4105  => 16#67CE#,   --  柎 (<CJK Ideograph>)
          4106  => 16#67D5#,   --  柕 (<CJK Ideograph>)
          4107  => 16#67D6#,   --  柖 (<CJK Ideograph>)
          4108  => 16#67D7#,   --  柗 (<CJK Ideograph>)
          4109  => 16#67DB#,   --  柛 (<CJK Ideograph>)
          4110  => 16#67DF#,   --  柟 (<CJK Ideograph>)
          4111  => 16#67E1#,   --  柡 (<CJK Ideograph>)
          4112  => 16#67E3#,   --  柣 (<CJK Ideograph>)
          4113  => 16#67E4#,   --  柤 (<CJK Ideograph>)
          4114  => 16#67E6#,   --  柦 (<CJK Ideograph>)
          4115  => 16#67E7#,   --  柧 (<CJK Ideograph>)
          4116  => 16#67E8#,   --  柨 (<CJK Ideograph>)
          4117  => 16#67EA#,   --  柪 (<CJK Ideograph>)
          4118  => 16#67EB#,   --  柫 (<CJK Ideograph>)
          4119  => 16#67ED#,   --  柭 (<CJK Ideograph>)
          4120  => 16#67EE#,   --  柮 (<CJK Ideograph>)
          4121  => 16#67F2#,   --  柲 (<CJK Ideograph>)
          4122  => 16#67F5#,   --  柵 (<CJK Ideograph>)
          4123  => 16#67F6#,   --  柶 (<CJK Ideograph>)
          4124  => 16#67F7#,   --  柷 (<CJK Ideograph>)
          4125  => 16#67F8#,   --  柸 (<CJK Ideograph>)
          4126  => 16#67F9#,   --  柹 (<CJK Ideograph>)
          4127  => 16#67FA#,   --  柺 (<CJK Ideograph>)
          4128  => 16#67FB#,   --  査 (<CJK Ideograph>)
          4129  => 16#67FC#,   --  柼 (<CJK Ideograph>)
          4130  => 16#67FE#,   --  柾 (<CJK Ideograph>)
          4131  => 16#6801#,   --  栁 (<CJK Ideograph>)
          4132  => 16#6802#,   --  栂 (<CJK Ideograph>)
          4133  => 16#6803#,   --  栃 (<CJK Ideograph>)
          4134  => 16#6804#,   --  栄 (<CJK Ideograph>)
          4135  => 16#6806#,   --  栆 (<CJK Ideograph>)
          4136  => 16#680D#,   --  栍 (<CJK Ideograph>)
          4137  => 16#6810#,   --  栐 (<CJK Ideograph>)
          4138  => 16#6812#,   --  栒 (<CJK Ideograph>)
          4139  => 16#6814#,   --  栔 (<CJK Ideograph>)
          4140  => 16#6815#,   --  栕 (<CJK Ideograph>)
          4141  => 16#6818#,   --  栘 (<CJK Ideograph>)
          4142  => 16#6819#,   --  栙 (<CJK Ideograph>)
          4143  => 16#681A#,   --  栚 (<CJK Ideograph>)
          4144  => 16#681B#,   --  栛 (<CJK Ideograph>)
          4145  => 16#681C#,   --  栜 (<CJK Ideograph>)
          4146  => 16#681E#,   --  栞 (<CJK Ideograph>)
          4147  => 16#681F#,   --  栟 (<CJK Ideograph>)
          4148  => 16#6820#,   --  栠 (<CJK Ideograph>)
          4149  => 16#6822#,   --  栢 (<CJK Ideograph>)
          4150  => 16#6823#,   --  栣 (<CJK Ideograph>)
          4151  => 16#6824#,   --  栤 (<CJK Ideograph>)
          4152  => 16#6825#,   --  栥 (<CJK Ideograph>)
          4153  => 16#6826#,   --  栦 (<CJK Ideograph>)
          4154  => 16#6827#,   --  栧 (<CJK Ideograph>)
          4155  => 16#6828#,   --  栨 (<CJK Ideograph>)
          4156  => 16#682B#,   --  栫 (<CJK Ideograph>)
          4157  => 16#682C#,   --  栬 (<CJK Ideograph>)
          4158  => 16#682D#,   --  栭 (<CJK Ideograph>)
          4159  => 16#682E#,   --  栮 (<CJK Ideograph>)
          4160  => 16#682F#,   --  栯 (<CJK Ideograph>)
          4161  => 16#6830#,   --  栰 (<CJK Ideograph>)
          4162  => 16#6831#,   --  栱 (<CJK Ideograph>)
          4163  => 16#6834#,   --  栴 (<CJK Ideograph>)
          4164  => 16#6835#,   --  栵 (<CJK Ideograph>)
          4165  => 16#6836#,   --  栶 (<CJK Ideograph>)
          4166  => 16#683A#,   --  栺 (<CJK Ideograph>)
          4167  => 16#683B#,   --  栻 (<CJK Ideograph>)
          4168  => 16#683F#,   --  栿 (<CJK Ideograph>)
          4169  => 16#6847#,   --  桇 (<CJK Ideograph>)
          4170  => 16#684B#,   --  桋 (<CJK Ideograph>)
          4171  => 16#684D#,   --  桍 (<CJK Ideograph>)
          4172  => 16#684F#,   --  桏 (<CJK Ideograph>)
          4173  => 16#6852#,   --  桒 (<CJK Ideograph>)
          4174  => 16#6856#,   --  桖 (<CJK Ideograph>)
          4175  => 16#6857#,   --  桗 (<CJK Ideograph>)
          4176  => 16#6858#,   --  桘 (<CJK Ideograph>)
          4177  => 16#6859#,   --  桙 (<CJK Ideograph>)
          4178  => 16#685A#,   --  桚 (<CJK Ideograph>)
          4179  => 16#685B#,   --  桛 (<CJK Ideograph>)
          4180  => 16#685C#,   --  桜 (<CJK Ideograph>)
          4181  => 16#685D#,   --  桝 (<CJK Ideograph>)
          4182  => 16#685E#,   --  桞 (<CJK Ideograph>)
          4183  => 16#685F#,   --  桟 (<CJK Ideograph>)
          4184  => 16#686A#,   --  桪 (<CJK Ideograph>)
          4185  => 16#686C#,   --  桬 (<CJK Ideograph>)
          4186  => 16#686D#,   --  桭 (<CJK Ideograph>)
          4187  => 16#686E#,   --  桮 (<CJK Ideograph>)
          4188  => 16#686F#,   --  桯 (<CJK Ideograph>)
          4189  => 16#6870#,   --  桰 (<CJK Ideograph>)
          4190  => 16#6871#,   --  桱 (<CJK Ideograph>)
          4191  => 16#6872#,   --  桲 (<CJK Ideograph>)
          4192  => 16#6873#,   --  桳 (<CJK Ideograph>)
          4193  => 16#6875#,   --  桵 (<CJK Ideograph>)
          4194  => 16#6878#,   --  桸 (<CJK Ideograph>)
          4195  => 16#6879#,   --  桹 (<CJK Ideograph>)
          4196  => 16#687A#,   --  桺 (<CJK Ideograph>)
          4197  => 16#687B#,   --  桻 (<CJK Ideograph>)
          4198  => 16#687C#,   --  桼 (<CJK Ideograph>)
          4199  => 16#687D#,   --  桽 (<CJK Ideograph>)
          4200  => 16#687E#,   --  桾 (<CJK Ideograph>)
          4201  => 16#687F#,   --  桿 (<CJK Ideograph>)
          4202  => 16#6880#,   --  梀 (<CJK Ideograph>)
          4203  => 16#6882#,   --  梂 (<CJK Ideograph>)
          4204  => 16#6884#,   --  梄 (<CJK Ideograph>)
          4205  => 16#6887#,   --  梇 (<CJK Ideograph>)
          4206  => 16#6888#,   --  梈 (<CJK Ideograph>)
          4207  => 16#6889#,   --  梉 (<CJK Ideograph>)
          4208  => 16#688A#,   --  梊 (<CJK Ideograph>)
          4209  => 16#688B#,   --  梋 (<CJK Ideograph>)
          4210  => 16#688C#,   --  梌 (<CJK Ideograph>)
          4211  => 16#688D#,   --  梍 (<CJK Ideograph>)
          4212  => 16#688E#,   --  梎 (<CJK Ideograph>)
          4213  => 16#6890#,   --  梐 (<CJK Ideograph>)
          4214  => 16#6891#,   --  梑 (<CJK Ideograph>)
          4215  => 16#6892#,   --  梒 (<CJK Ideograph>)
          4216  => 16#6894#,   --  梔 (<CJK Ideograph>)
          4217  => 16#6895#,   --  梕 (<CJK Ideograph>)
          4218  => 16#6896#,   --  梖 (<CJK Ideograph>)
          4219  => 16#6898#,   --  梘 (<CJK Ideograph>)
          4220  => 16#6899#,   --  梙 (<CJK Ideograph>)
          4221  => 16#689A#,   --  梚 (<CJK Ideograph>)
          4222  => 16#689B#,   --  梛 (<CJK Ideograph>)
          4223  => 16#689C#,   --  梜 (<CJK Ideograph>)
          4224  => 16#689D#,   --  條 (<CJK Ideograph>)
          4225  => 16#689E#,   --  梞 (<CJK Ideograph>)
          4226  => 16#689F#,   --  梟 (<CJK Ideograph>)
          4227  => 16#68A0#,   --  梠 (<CJK Ideograph>)
          4228  => 16#68A1#,   --  梡 (<CJK Ideograph>)
          4229  => 16#68A3#,   --  梣 (<CJK Ideograph>)
          4230  => 16#68A4#,   --  梤 (<CJK Ideograph>)
          4231  => 16#68A5#,   --  梥 (<CJK Ideograph>)
          4232  => 16#68A9#,   --  梩 (<CJK Ideograph>)
          4233  => 16#68AA#,   --  梪 (<CJK Ideograph>)
          4234  => 16#68AB#,   --  梫 (<CJK Ideograph>)
          4235  => 16#68AC#,   --  梬 (<CJK Ideograph>)
          4236  => 16#68AE#,   --  梮 (<CJK Ideograph>)
          4237  => 16#68B1#,   --  梱 (<CJK Ideograph>)
          4238  => 16#68B2#,   --  梲 (<CJK Ideograph>)
          4239  => 16#68B4#,   --  梴 (<CJK Ideograph>)
          4240  => 16#68B6#,   --  梶 (<CJK Ideograph>)
          4241  => 16#68B7#,   --  梷 (<CJK Ideograph>)
          4242  => 16#68B8#,   --  梸 (<CJK Ideograph>)
          4243  => 16#68B9#,   --  梹 (<CJK Ideograph>)
          4244  => 16#68BA#,   --  梺 (<CJK Ideograph>)
          4245  => 16#68BB#,   --  梻 (<CJK Ideograph>)
          4246  => 16#68BC#,   --  梼 (<CJK Ideograph>)
          4247  => 16#68BD#,   --  梽 (<CJK Ideograph>)
          4248  => 16#68BE#,   --  梾 (<CJK Ideograph>)
          4249  => 16#68BF#,   --  梿 (<CJK Ideograph>)
          4250  => 16#68C1#,   --  棁 (<CJK Ideograph>)
          4251  => 16#68C3#,   --  棃 (<CJK Ideograph>)
          4252  => 16#68C4#,   --  棄 (<CJK Ideograph>)
          4253  => 16#68C5#,   --  棅 (<CJK Ideograph>)
          4254  => 16#68C6#,   --  棆 (<CJK Ideograph>)
          4255  => 16#68C7#,   --  棇 (<CJK Ideograph>)
          4256  => 16#68C8#,   --  棈 (<CJK Ideograph>)
          4257  => 16#68CA#,   --  棊 (<CJK Ideograph>)
          4258  => 16#68CC#,   --  棌 (<CJK Ideograph>)
          4259  => 16#68CE#,   --  棎 (<CJK Ideograph>)
          4260  => 16#68CF#,   --  棏 (<CJK Ideograph>)
          4261  => 16#68D0#,   --  棐 (<CJK Ideograph>)
          4262  => 16#68D1#,   --  棑 (<CJK Ideograph>)
          4263  => 16#68D3#,   --  棓 (<CJK Ideograph>)
          4264  => 16#68D4#,   --  棔 (<CJK Ideograph>)
          4265  => 16#68D6#,   --  棖 (<CJK Ideograph>)
          4266  => 16#68D7#,   --  棗 (<CJK Ideograph>)
          4267  => 16#68D9#,   --  棙 (<CJK Ideograph>)
          4268  => 16#68DB#,   --  棛 (<CJK Ideograph>)
          4269  => 16#68DC#,   --  棜 (<CJK Ideograph>)
          4270  => 16#68DD#,   --  棝 (<CJK Ideograph>)
          4271  => 16#68DE#,   --  棞 (<CJK Ideograph>)
          4272  => 16#68DF#,   --  棟 (<CJK Ideograph>)
          4273  => 16#68E1#,   --  棡 (<CJK Ideograph>)
          4274  => 16#68E2#,   --  棢 (<CJK Ideograph>)
          4275  => 16#68E4#,   --  棤 (<CJK Ideograph>)
          4276  => 16#68E5#,   --  棥 (<CJK Ideograph>)
          4277  => 16#68E6#,   --  棦 (<CJK Ideograph>)
          4278  => 16#68E7#,   --  棧 (<CJK Ideograph>)
          4279  => 16#68E8#,   --  棨 (<CJK Ideograph>)
          4280  => 16#68E9#,   --  棩 (<CJK Ideograph>)
          4281  => 16#68EA#,   --  棪 (<CJK Ideograph>)
          4282  => 16#68EB#,   --  棫 (<CJK Ideograph>)
          4283  => 16#68EC#,   --  棬 (<CJK Ideograph>)
          4284  => 16#68ED#,   --  棭 (<CJK Ideograph>)
          4285  => 16#68EF#,   --  棯 (<CJK Ideograph>)
          4286  => 16#68F2#,   --  棲 (<CJK Ideograph>)
          4287  => 16#68F3#,   --  棳 (<CJK Ideograph>)
          4288  => 16#68F4#,   --  棴 (<CJK Ideograph>)
          4289  => 16#68F6#,   --  棶 (<CJK Ideograph>)
          4290  => 16#68F7#,   --  棷 (<CJK Ideograph>)
          4291  => 16#68F8#,   --  棸 (<CJK Ideograph>)
          4292  => 16#68FB#,   --  棻 (<CJK Ideograph>)
          4293  => 16#68FD#,   --  棽 (<CJK Ideograph>)
          4294  => 16#68FE#,   --  棾 (<CJK Ideograph>)
          4295  => 16#68FF#,   --  棿 (<CJK Ideograph>)
          4296  => 16#6900#,   --  椀 (<CJK Ideograph>)
          4297  => 16#6902#,   --  椂 (<CJK Ideograph>)
          4298  => 16#6903#,   --  椃 (<CJK Ideograph>)
          4299  => 16#6904#,   --  椄 (<CJK Ideograph>)
          4300  => 16#6906#,   --  椆 (<CJK Ideograph>)
          4301  => 16#6907#,   --  椇 (<CJK Ideograph>)
          4302  => 16#6908#,   --  椈 (<CJK Ideograph>)
          4303  => 16#6909#,   --  椉 (<CJK Ideograph>)
          4304  => 16#690A#,   --  椊 (<CJK Ideograph>)
          4305  => 16#690C#,   --  椌 (<CJK Ideograph>)
          4306  => 16#690F#,   --  椏 (<CJK Ideograph>)
          4307  => 16#6911#,   --  椑 (<CJK Ideograph>)
          4308  => 16#6913#,   --  椓 (<CJK Ideograph>)
          4309  => 16#6914#,   --  椔 (<CJK Ideograph>)
          4310  => 16#6915#,   --  椕 (<CJK Ideograph>)
          4311  => 16#6916#,   --  椖 (<CJK Ideograph>)
          4312  => 16#6917#,   --  椗 (<CJK Ideograph>)
          4313  => 16#6918#,   --  椘 (<CJK Ideograph>)
          4314  => 16#6919#,   --  椙 (<CJK Ideograph>)
          4315  => 16#691A#,   --  椚 (<CJK Ideograph>)
          4316  => 16#691B#,   --  椛 (<CJK Ideograph>)
          4317  => 16#691C#,   --  検 (<CJK Ideograph>)
          4318  => 16#691D#,   --  椝 (<CJK Ideograph>)
          4319  => 16#691E#,   --  椞 (<CJK Ideograph>)
          4320  => 16#6921#,   --  椡 (<CJK Ideograph>)
          4321  => 16#6922#,   --  椢 (<CJK Ideograph>)
          4322  => 16#6923#,   --  椣 (<CJK Ideograph>)
          4323  => 16#6925#,   --  椥 (<CJK Ideograph>)
          4324  => 16#6926#,   --  椦 (<CJK Ideograph>)
          4325  => 16#6927#,   --  椧 (<CJK Ideograph>)
          4326  => 16#6928#,   --  椨 (<CJK Ideograph>)
          4327  => 16#6929#,   --  椩 (<CJK Ideograph>)
          4328  => 16#692A#,   --  椪 (<CJK Ideograph>)
          4329  => 16#692B#,   --  椫 (<CJK Ideograph>)
          4330  => 16#692C#,   --  椬 (<CJK Ideograph>)
          4331  => 16#692E#,   --  椮 (<CJK Ideograph>)
          4332  => 16#692F#,   --  椯 (<CJK Ideograph>)
          4333  => 16#6931#,   --  椱 (<CJK Ideograph>)
          4334  => 16#6932#,   --  椲 (<CJK Ideograph>)
          4335  => 16#6933#,   --  椳 (<CJK Ideograph>)
          4336  => 16#6935#,   --  椵 (<CJK Ideograph>)
          4337  => 16#6936#,   --  椶 (<CJK Ideograph>)
          4338  => 16#6937#,   --  椷 (<CJK Ideograph>)
          4339  => 16#6938#,   --  椸 (<CJK Ideograph>)
          4340  => 16#693A#,   --  椺 (<CJK Ideograph>)
          4341  => 16#693B#,   --  椻 (<CJK Ideograph>)
          4342  => 16#693C#,   --  椼 (<CJK Ideograph>)
          4343  => 16#693E#,   --  椾 (<CJK Ideograph>)
          4344  => 16#6940#,   --  楀 (<CJK Ideograph>)
          4345  => 16#6941#,   --  楁 (<CJK Ideograph>)
          4346  => 16#6943#,   --  楃 (<CJK Ideograph>)
          4347  => 16#6944#,   --  楄 (<CJK Ideograph>)
          4348  => 16#6945#,   --  楅 (<CJK Ideograph>)
          4349  => 16#6946#,   --  楆 (<CJK Ideograph>)
          4350  => 16#6947#,   --  楇 (<CJK Ideograph>)
          4351  => 16#6948#,   --  楈 (<CJK Ideograph>)
          4352  => 16#6949#,   --  楉 (<CJK Ideograph>)
          4353  => 16#694A#,   --  楊 (<CJK Ideograph>)
          4354  => 16#694B#,   --  楋 (<CJK Ideograph>)
          4355  => 16#694C#,   --  楌 (<CJK Ideograph>)
          4356  => 16#694D#,   --  楍 (<CJK Ideograph>)
          4357  => 16#694E#,   --  楎 (<CJK Ideograph>)
          4358  => 16#694F#,   --  楏 (<CJK Ideograph>)
          4359  => 16#6950#,   --  楐 (<CJK Ideograph>)
          4360  => 16#6951#,   --  楑 (<CJK Ideograph>)
          4361  => 16#6952#,   --  楒 (<CJK Ideograph>)
          4362  => 16#6953#,   --  楓 (<CJK Ideograph>)
          4363  => 16#6955#,   --  楕 (<CJK Ideograph>)
          4364  => 16#6956#,   --  楖 (<CJK Ideograph>)
          4365  => 16#6958#,   --  楘 (<CJK Ideograph>)
          4366  => 16#6959#,   --  楙 (<CJK Ideograph>)
          4367  => 16#695B#,   --  楛 (<CJK Ideograph>)
          4368  => 16#695C#,   --  楜 (<CJK Ideograph>)
          4369  => 16#695F#,   --  楟 (<CJK Ideograph>)
          4370  => 16#6961#,   --  楡 (<CJK Ideograph>)
          4371  => 16#6962#,   --  楢 (<CJK Ideograph>)
          4372  => 16#6964#,   --  楤 (<CJK Ideograph>)
          4373  => 16#6965#,   --  楥 (<CJK Ideograph>)
          4374  => 16#6967#,   --  楧 (<CJK Ideograph>)
          4375  => 16#6968#,   --  楨 (<CJK Ideograph>)
          4376  => 16#6969#,   --  楩 (<CJK Ideograph>)
          4377  => 16#696A#,   --  楪 (<CJK Ideograph>)
          4378  => 16#696C#,   --  楬 (<CJK Ideograph>)
          4379  => 16#696D#,   --  業 (<CJK Ideograph>)
          4380  => 16#696F#,   --  楯 (<CJK Ideograph>)
          4381  => 16#6970#,   --  楰 (<CJK Ideograph>)
          4382  => 16#6972#,   --  楲 (<CJK Ideograph>)
          4383  => 16#6973#,   --  楳 (<CJK Ideograph>)
          4384  => 16#6974#,   --  楴 (<CJK Ideograph>)
          4385  => 16#6975#,   --  極 (<CJK Ideograph>)
          4386  => 16#6976#,   --  楶 (<CJK Ideograph>)
          4387  => 16#697A#,   --  楺 (<CJK Ideograph>)
          4388  => 16#697B#,   --  楻 (<CJK Ideograph>)
          4389  => 16#697D#,   --  楽 (<CJK Ideograph>)
          4390  => 16#697E#,   --  楾 (<CJK Ideograph>)
          4391  => 16#697F#,   --  楿 (<CJK Ideograph>)
          4392  => 16#6981#,   --  榁 (<CJK Ideograph>)
          4393  => 16#6983#,   --  榃 (<CJK Ideograph>)
          4394  => 16#6985#,   --  榅 (<CJK Ideograph>)
          4395  => 16#698A#,   --  榊 (<CJK Ideograph>)
          4396  => 16#698B#,   --  榋 (<CJK Ideograph>)
          4397  => 16#698C#,   --  榌 (<CJK Ideograph>)
          4398  => 16#698E#,   --  榎 (<CJK Ideograph>)
          4399  => 16#698F#,   --  榏 (<CJK Ideograph>)
          4400  => 16#6990#,   --  榐 (<CJK Ideograph>)
          4401  => 16#6991#,   --  榑 (<CJK Ideograph>)
          4402  => 16#6992#,   --  榒 (<CJK Ideograph>)
          4403  => 16#6993#,   --  榓 (<CJK Ideograph>)
          4404  => 16#6996#,   --  榖 (<CJK Ideograph>)
          4405  => 16#6997#,   --  榗 (<CJK Ideograph>)
          4406  => 16#6999#,   --  榙 (<CJK Ideograph>)
          4407  => 16#699A#,   --  榚 (<CJK Ideograph>)
          4408  => 16#699D#,   --  榝 (<CJK Ideograph>)
          4409  => 16#699E#,   --  榞 (<CJK Ideograph>)
          4410  => 16#699F#,   --  榟 (<CJK Ideograph>)
          4411  => 16#69A0#,   --  榠 (<CJK Ideograph>)
          4412  => 16#69A1#,   --  榡 (<CJK Ideograph>)
          4413  => 16#69A2#,   --  榢 (<CJK Ideograph>)
          4414  => 16#69A3#,   --  榣 (<CJK Ideograph>)
          4415  => 16#69A4#,   --  榤 (<CJK Ideograph>)
          4416  => 16#69A5#,   --  榥 (<CJK Ideograph>)
          4417  => 16#69A6#,   --  榦 (<CJK Ideograph>)
          4418  => 16#69A9#,   --  榩 (<CJK Ideograph>)
          4419  => 16#69AA#,   --  榪 (<CJK Ideograph>)
          4420  => 16#69AC#,   --  榬 (<CJK Ideograph>)
          4421  => 16#69AE#,   --  榮 (<CJK Ideograph>)
          4422  => 16#69AF#,   --  榯 (<CJK Ideograph>)
          4423  => 16#69B0#,   --  榰 (<CJK Ideograph>)
          4424  => 16#69B2#,   --  榲 (<CJK Ideograph>)
          4425  => 16#69B3#,   --  榳 (<CJK Ideograph>)
          4426  => 16#69B5#,   --  榵 (<CJK Ideograph>)
          4427  => 16#69B6#,   --  榶 (<CJK Ideograph>)
          4428  => 16#69B8#,   --  榸 (<CJK Ideograph>)
          4429  => 16#69B9#,   --  榹 (<CJK Ideograph>)
          4430  => 16#69BA#,   --  榺 (<CJK Ideograph>)
          4431  => 16#69BC#,   --  榼 (<CJK Ideograph>)
          4432  => 16#69BD#,   --  榽 (<CJK Ideograph>)
          4433  => 16#69BE#,   --  榾 (<CJK Ideograph>)
          4434  => 16#69BF#,   --  榿 (<CJK Ideograph>)
          4435  => 16#69C0#,   --  槀 (<CJK Ideograph>)
          4436  => 16#69C2#,   --  槂 (<CJK Ideograph>)
          4437  => 16#69C3#,   --  槃 (<CJK Ideograph>)
          4438  => 16#69C4#,   --  槄 (<CJK Ideograph>)
          4439  => 16#69C5#,   --  槅 (<CJK Ideograph>)
          4440  => 16#69C6#,   --  槆 (<CJK Ideograph>)
          4441  => 16#69C7#,   --  槇 (<CJK Ideograph>)
          4442  => 16#69C8#,   --  槈 (<CJK Ideograph>)
          4443  => 16#69C9#,   --  槉 (<CJK Ideograph>)
          4444  => 16#69CB#,   --  構 (<CJK Ideograph>)
          4445  => 16#69CD#,   --  槍 (<CJK Ideograph>)
          4446  => 16#69CF#,   --  槏 (<CJK Ideograph>)
          4447  => 16#69D1#,   --  槑 (<CJK Ideograph>)
          4448  => 16#69D2#,   --  槒 (<CJK Ideograph>)
          4449  => 16#69D3#,   --  槓 (<CJK Ideograph>)
          4450  => 16#69D5#,   --  槕 (<CJK Ideograph>)
          4451  => 16#69D6#,   --  槖 (<CJK Ideograph>)
          4452  => 16#69D7#,   --  槗 (<CJK Ideograph>)
          4453  => 16#69D8#,   --  様 (<CJK Ideograph>)
          4454  => 16#69D9#,   --  槙 (<CJK Ideograph>)
          4455  => 16#69DA#,   --  槚 (<CJK Ideograph>)
          4456  => 16#69DC#,   --  槜 (<CJK Ideograph>)
          4457  => 16#69DD#,   --  槝 (<CJK Ideograph>)
          4458  => 16#69DE#,   --  槞 (<CJK Ideograph>)
          4459  => 16#69E1#,   --  槡 (<CJK Ideograph>)
          4460  => 16#69E2#,   --  槢 (<CJK Ideograph>)
          4461  => 16#69E3#,   --  槣 (<CJK Ideograph>)
          4462  => 16#69E4#,   --  槤 (<CJK Ideograph>)
          4463  => 16#69E5#,   --  槥 (<CJK Ideograph>)
          4464  => 16#69E6#,   --  槦 (<CJK Ideograph>)
          4465  => 16#69E7#,   --  槧 (<CJK Ideograph>)
          4466  => 16#69E8#,   --  槨 (<CJK Ideograph>)
          4467  => 16#69E9#,   --  槩 (<CJK Ideograph>)
          4468  => 16#69EA#,   --  槪 (<CJK Ideograph>)
          4469  => 16#69EB#,   --  槫 (<CJK Ideograph>)
          4470  => 16#69EC#,   --  槬 (<CJK Ideograph>)
          4471  => 16#69EE#,   --  槮 (<CJK Ideograph>)
          4472  => 16#69EF#,   --  槯 (<CJK Ideograph>)
          4473  => 16#69F0#,   --  槰 (<CJK Ideograph>)
          4474  => 16#69F1#,   --  槱 (<CJK Ideograph>)
          4475  => 16#69F3#,   --  槳 (<CJK Ideograph>)
          4476  => 16#69F4#,   --  槴 (<CJK Ideograph>)
          4477  => 16#69F5#,   --  槵 (<CJK Ideograph>)
          4478  => 16#69F6#,   --  槶 (<CJK Ideograph>)
          4479  => 16#69F7#,   --  槷 (<CJK Ideograph>)
          4480  => 16#69F8#,   --  槸 (<CJK Ideograph>)
          4481  => 16#69F9#,   --  槹 (<CJK Ideograph>)
          4482  => 16#69FA#,   --  槺 (<CJK Ideograph>)
          4483  => 16#69FB#,   --  槻 (<CJK Ideograph>)
          4484  => 16#69FC#,   --  槼 (<CJK Ideograph>)
          4485  => 16#69FE#,   --  槾 (<CJK Ideograph>)
          4486  => 16#6A00#,   --  樀 (<CJK Ideograph>)
          4487  => 16#6A01#,   --  樁 (<CJK Ideograph>)
          4488  => 16#6A02#,   --  樂 (<CJK Ideograph>)
          4489  => 16#6A03#,   --  樃 (<CJK Ideograph>)
          4490  => 16#6A04#,   --  樄 (<CJK Ideograph>)
          4491  => 16#6A05#,   --  樅 (<CJK Ideograph>)
          4492  => 16#6A06#,   --  樆 (<CJK Ideograph>)
          4493  => 16#6A07#,   --  樇 (<CJK Ideograph>)
          4494  => 16#6A08#,   --  樈 (<CJK Ideograph>)
          4495  => 16#6A09#,   --  樉 (<CJK Ideograph>)
          4496  => 16#6A0B#,   --  樋 (<CJK Ideograph>)
          4497  => 16#6A0C#,   --  樌 (<CJK Ideograph>)
          4498  => 16#6A0D#,   --  樍 (<CJK Ideograph>)
          4499  => 16#6A0E#,   --  樎 (<CJK Ideograph>)
          4500  => 16#6A0F#,   --  樏 (<CJK Ideograph>)
          4501  => 16#6A10#,   --  樐 (<CJK Ideograph>)
          4502  => 16#6A11#,   --  樑 (<CJK Ideograph>)
          4503  => 16#6A12#,   --  樒 (<CJK Ideograph>)
          4504  => 16#6A13#,   --  樓 (<CJK Ideograph>)
          4505  => 16#6A14#,   --  樔 (<CJK Ideograph>)
          4506  => 16#6A15#,   --  樕 (<CJK Ideograph>)
          4507  => 16#6A16#,   --  樖 (<CJK Ideograph>)
          4508  => 16#6A19#,   --  標 (<CJK Ideograph>)
          4509  => 16#6A1A#,   --  樚 (<CJK Ideograph>)
          4510  => 16#6A1B#,   --  樛 (<CJK Ideograph>)
          4511  => 16#6A1C#,   --  樜 (<CJK Ideograph>)
          4512  => 16#6A1D#,   --  樝 (<CJK Ideograph>)
          4513  => 16#6A1E#,   --  樞 (<CJK Ideograph>)
          4514  => 16#6A20#,   --  樠 (<CJK Ideograph>)
          4515  => 16#6A22#,   --  樢 (<CJK Ideograph>)
          4516  => 16#6A23#,   --  樣 (<CJK Ideograph>)
          4517  => 16#6A24#,   --  樤 (<CJK Ideograph>)
          4518  => 16#6A25#,   --  樥 (<CJK Ideograph>)
          4519  => 16#6A26#,   --  樦 (<CJK Ideograph>)
          4520  => 16#6A27#,   --  樧 (<CJK Ideograph>)
          4521  => 16#6A29#,   --  権 (<CJK Ideograph>)
          4522  => 16#6A2B#,   --  樫 (<CJK Ideograph>)
          4523  => 16#6A2C#,   --  樬 (<CJK Ideograph>)
          4524  => 16#6A2D#,   --  樭 (<CJK Ideograph>)
          4525  => 16#6A2E#,   --  樮 (<CJK Ideograph>)
          4526  => 16#6A30#,   --  樰 (<CJK Ideograph>)
          4527  => 16#6A32#,   --  樲 (<CJK Ideograph>)
          4528  => 16#6A33#,   --  樳 (<CJK Ideograph>)
          4529  => 16#6A34#,   --  樴 (<CJK Ideograph>)
          4530  => 16#6A36#,   --  樶 (<CJK Ideograph>)
          4531  => 16#6A37#,   --  樷 (<CJK Ideograph>)
          4532  => 16#6A38#,   --  樸 (<CJK Ideograph>)
          4533  => 16#6A39#,   --  樹 (<CJK Ideograph>)
          4534  => 16#6A3A#,   --  樺 (<CJK Ideograph>)
          4535  => 16#6A3B#,   --  樻 (<CJK Ideograph>)
          4536  => 16#6A3C#,   --  樼 (<CJK Ideograph>)
          4537  => 16#6A3F#,   --  樿 (<CJK Ideograph>)
          4538  => 16#6A40#,   --  橀 (<CJK Ideograph>)
          4539  => 16#6A41#,   --  橁 (<CJK Ideograph>)
          4540  => 16#6A42#,   --  橂 (<CJK Ideograph>)
          4541  => 16#6A43#,   --  橃 (<CJK Ideograph>)
          4542  => 16#6A45#,   --  橅 (<CJK Ideograph>)
          4543  => 16#6A46#,   --  橆 (<CJK Ideograph>)
          4544  => 16#6A48#,   --  橈 (<CJK Ideograph>)
          4545  => 16#6A49#,   --  橉 (<CJK Ideograph>)
          4546  => 16#6A4A#,   --  橊 (<CJK Ideograph>)
          4547  => 16#6A4B#,   --  橋 (<CJK Ideograph>)
          4548  => 16#6A4C#,   --  橌 (<CJK Ideograph>)
          4549  => 16#6A4D#,   --  橍 (<CJK Ideograph>)
          4550  => 16#6A4E#,   --  橎 (<CJK Ideograph>)
          4551  => 16#6A4F#,   --  橏 (<CJK Ideograph>)
          4552  => 16#6A51#,   --  橑 (<CJK Ideograph>)
          4553  => 16#6A52#,   --  橒 (<CJK Ideograph>)
          4554  => 16#6A53#,   --  橓 (<CJK Ideograph>)
          4555  => 16#6A54#,   --  橔 (<CJK Ideograph>)
          4556  => 16#6A55#,   --  橕 (<CJK Ideograph>)
          4557  => 16#6A56#,   --  橖 (<CJK Ideograph>)
          4558  => 16#6A57#,   --  橗 (<CJK Ideograph>)
          4559  => 16#6A5A#,   --  橚 (<CJK Ideograph>)
          4560  => 16#6A5C#,   --  橜 (<CJK Ideograph>)
          4561  => 16#6A5D#,   --  橝 (<CJK Ideograph>)
          4562  => 16#6A5E#,   --  橞 (<CJK Ideograph>)
          4563  => 16#6A5F#,   --  機 (<CJK Ideograph>)
          4564  => 16#6A60#,   --  橠 (<CJK Ideograph>)
          4565  => 16#6A62#,   --  橢 (<CJK Ideograph>)
          4566  => 16#6A63#,   --  橣 (<CJK Ideograph>)
          4567  => 16#6A64#,   --  橤 (<CJK Ideograph>)
          4568  => 16#6A66#,   --  橦 (<CJK Ideograph>)
          4569  => 16#6A67#,   --  橧 (<CJK Ideograph>)
          4570  => 16#6A68#,   --  橨 (<CJK Ideograph>)
          4571  => 16#6A69#,   --  橩 (<CJK Ideograph>)
          4572  => 16#6A6A#,   --  橪 (<CJK Ideograph>)
          4573  => 16#6A6B#,   --  橫 (<CJK Ideograph>)
          4574  => 16#6A6C#,   --  橬 (<CJK Ideograph>)
          4575  => 16#6A6D#,   --  橭 (<CJK Ideograph>)
          4576  => 16#6A6E#,   --  橮 (<CJK Ideograph>)
          4577  => 16#6A6F#,   --  橯 (<CJK Ideograph>)
          4578  => 16#6A70#,   --  橰 (<CJK Ideograph>)
          4579  => 16#6A72#,   --  橲 (<CJK Ideograph>)
          4580  => 16#6A73#,   --  橳 (<CJK Ideograph>)
          4581  => 16#6A74#,   --  橴 (<CJK Ideograph>)
          4582  => 16#6A75#,   --  橵 (<CJK Ideograph>)
          4583  => 16#6A76#,   --  橶 (<CJK Ideograph>)
          4584  => 16#6A77#,   --  橷 (<CJK Ideograph>)
          4585  => 16#6A78#,   --  橸 (<CJK Ideograph>)
          4586  => 16#6A7A#,   --  橺 (<CJK Ideograph>)
          4587  => 16#6A7B#,   --  橻 (<CJK Ideograph>)
          4588  => 16#6A7D#,   --  橽 (<CJK Ideograph>)
          4589  => 16#6A7E#,   --  橾 (<CJK Ideograph>)
          4590  => 16#6A7F#,   --  橿 (<CJK Ideograph>)
          4591  => 16#6A81#,   --  檁 (<CJK Ideograph>)
          4592  => 16#6A82#,   --  檂 (<CJK Ideograph>)
          4593  => 16#6A83#,   --  檃 (<CJK Ideograph>)
          4594  => 16#6A85#,   --  檅 (<CJK Ideograph>)
          4595  => 16#6A86#,   --  檆 (<CJK Ideograph>)
          4596  => 16#6A87#,   --  檇 (<CJK Ideograph>)
          4597  => 16#6A88#,   --  檈 (<CJK Ideograph>)
          4598  => 16#6A89#,   --  檉 (<CJK Ideograph>)
          4599  => 16#6A8A#,   --  檊 (<CJK Ideograph>)
          4600  => 16#6A8B#,   --  檋 (<CJK Ideograph>)
          4601  => 16#6A8C#,   --  檌 (<CJK Ideograph>)
          4602  => 16#6A8D#,   --  檍 (<CJK Ideograph>)
          4603  => 16#6A8F#,   --  檏 (<CJK Ideograph>)
          4604  => 16#6A92#,   --  檒 (<CJK Ideograph>)
          4605  => 16#6A93#,   --  檓 (<CJK Ideograph>)
          4606  => 16#6A94#,   --  檔 (<CJK Ideograph>)
          4607  => 16#6A95#,   --  檕 (<CJK Ideograph>)
          4608  => 16#6A96#,   --  檖 (<CJK Ideograph>)
          4609  => 16#6A98#,   --  檘 (<CJK Ideograph>)
          4610  => 16#6A99#,   --  檙 (<CJK Ideograph>)
          4611  => 16#6A9A#,   --  檚 (<CJK Ideograph>)
          4612  => 16#6A9B#,   --  檛 (<CJK Ideograph>)
          4613  => 16#6A9C#,   --  檜 (<CJK Ideograph>)
          4614  => 16#6A9D#,   --  檝 (<CJK Ideograph>)
          4615  => 16#6A9E#,   --  檞 (<CJK Ideograph>)
          4616  => 16#6A9F#,   --  檟 (<CJK Ideograph>)
          4617  => 16#6AA1#,   --  檡 (<CJK Ideograph>)
          4618  => 16#6AA2#,   --  檢 (<CJK Ideograph>)
          4619  => 16#6AA3#,   --  檣 (<CJK Ideograph>)
          4620  => 16#6AA4#,   --  檤 (<CJK Ideograph>)
          4621  => 16#6AA5#,   --  檥 (<CJK Ideograph>)
          4622  => 16#6AA6#,   --  檦 (<CJK Ideograph>)
          4623  => 16#6AA7#,   --  檧 (<CJK Ideograph>)
          4624  => 16#6AA8#,   --  檨 (<CJK Ideograph>)
          4625  => 16#6AAA#,   --  檪 (<CJK Ideograph>)
          4626  => 16#6AAD#,   --  檭 (<CJK Ideograph>)
          4627  => 16#6AAE#,   --  檮 (<CJK Ideograph>)
          4628  => 16#6AAF#,   --  檯 (<CJK Ideograph>)
          4629  => 16#6AB0#,   --  檰 (<CJK Ideograph>)
          4630  => 16#6AB1#,   --  檱 (<CJK Ideograph>)
          4631  => 16#6AB2#,   --  檲 (<CJK Ideograph>)
          4632  => 16#6AB3#,   --  檳 (<CJK Ideograph>)
          4633  => 16#6AB4#,   --  檴 (<CJK Ideograph>)
          4634  => 16#6AB5#,   --  檵 (<CJK Ideograph>)
          4635  => 16#6AB6#,   --  檶 (<CJK Ideograph>)
          4636  => 16#6AB7#,   --  檷 (<CJK Ideograph>)
          4637  => 16#6AB8#,   --  檸 (<CJK Ideograph>)
          4638  => 16#6AB9#,   --  檹 (<CJK Ideograph>)
          4639  => 16#6ABA#,   --  檺 (<CJK Ideograph>)
          4640  => 16#6ABB#,   --  檻 (<CJK Ideograph>)
          4641  => 16#6ABC#,   --  檼 (<CJK Ideograph>)
          4642  => 16#6ABD#,   --  檽 (<CJK Ideograph>)
          4643  => 16#6ABE#,   --  檾 (<CJK Ideograph>)
          4644  => 16#6ABF#,   --  檿 (<CJK Ideograph>)
          4645  => 16#6AC0#,   --  櫀 (<CJK Ideograph>)
          4646  => 16#6AC1#,   --  櫁 (<CJK Ideograph>)
          4647  => 16#6AC2#,   --  櫂 (<CJK Ideograph>)
          4648  => 16#6AC3#,   --  櫃 (<CJK Ideograph>)
          4649  => 16#6AC4#,   --  櫄 (<CJK Ideograph>)
          4650  => 16#6AC5#,   --  櫅 (<CJK Ideograph>)
          4651  => 16#6AC6#,   --  櫆 (<CJK Ideograph>)
          4652  => 16#6AC7#,   --  櫇 (<CJK Ideograph>)
          4653  => 16#6AC8#,   --  櫈 (<CJK Ideograph>)
          4654  => 16#6AC9#,   --  櫉 (<CJK Ideograph>)
          4655  => 16#6ACA#,   --  櫊 (<CJK Ideograph>)
          4656  => 16#6ACB#,   --  櫋 (<CJK Ideograph>)
          4657  => 16#6ACC#,   --  櫌 (<CJK Ideograph>)
          4658  => 16#6ACD#,   --  櫍 (<CJK Ideograph>)
          4659  => 16#6ACE#,   --  櫎 (<CJK Ideograph>)
          4660  => 16#6ACF#,   --  櫏 (<CJK Ideograph>)
          4661  => 16#6AD0#,   --  櫐 (<CJK Ideograph>)
          4662  => 16#6AD1#,   --  櫑 (<CJK Ideograph>)
          4663  => 16#6AD2#,   --  櫒 (<CJK Ideograph>)
          4664  => 16#6AD3#,   --  櫓 (<CJK Ideograph>)
          4665  => 16#6AD4#,   --  櫔 (<CJK Ideograph>)
          4666  => 16#6AD5#,   --  櫕 (<CJK Ideograph>)
          4667  => 16#6AD6#,   --  櫖 (<CJK Ideograph>)
          4668  => 16#6AD7#,   --  櫗 (<CJK Ideograph>)
          4669  => 16#6AD8#,   --  櫘 (<CJK Ideograph>)
          4670  => 16#6AD9#,   --  櫙 (<CJK Ideograph>)
          4671  => 16#6ADA#,   --  櫚 (<CJK Ideograph>)
          4672  => 16#6ADB#,   --  櫛 (<CJK Ideograph>)
          4673  => 16#6ADC#,   --  櫜 (<CJK Ideograph>)
          4674  => 16#6ADD#,   --  櫝 (<CJK Ideograph>)
          4675  => 16#6ADE#,   --  櫞 (<CJK Ideograph>)
          4676  => 16#6ADF#,   --  櫟 (<CJK Ideograph>)
          4677  => 16#6AE0#,   --  櫠 (<CJK Ideograph>)
          4678  => 16#6AE1#,   --  櫡 (<CJK Ideograph>)
          4679  => 16#6AE2#,   --  櫢 (<CJK Ideograph>)
          4680  => 16#6AE3#,   --  櫣 (<CJK Ideograph>)
          4681  => 16#6AE4#,   --  櫤 (<CJK Ideograph>)
          4682  => 16#6AE5#,   --  櫥 (<CJK Ideograph>)
          4683  => 16#6AE6#,   --  櫦 (<CJK Ideograph>)
          4684  => 16#6AE7#,   --  櫧 (<CJK Ideograph>)
          4685  => 16#6AE8#,   --  櫨 (<CJK Ideograph>)
          4686  => 16#6AE9#,   --  櫩 (<CJK Ideograph>)
          4687  => 16#6AEA#,   --  櫪 (<CJK Ideograph>)
          4688  => 16#6AEB#,   --  櫫 (<CJK Ideograph>)
          4689  => 16#6AEC#,   --  櫬 (<CJK Ideograph>)
          4690  => 16#6AED#,   --  櫭 (<CJK Ideograph>)
          4691  => 16#6AEE#,   --  櫮 (<CJK Ideograph>)
          4692  => 16#6AEF#,   --  櫯 (<CJK Ideograph>)
          4693  => 16#6AF0#,   --  櫰 (<CJK Ideograph>)
          4694  => 16#6AF1#,   --  櫱 (<CJK Ideograph>)
          4695  => 16#6AF2#,   --  櫲 (<CJK Ideograph>)
          4696  => 16#6AF3#,   --  櫳 (<CJK Ideograph>)
          4697  => 16#6AF4#,   --  櫴 (<CJK Ideograph>)
          4698  => 16#6AF5#,   --  櫵 (<CJK Ideograph>)
          4699  => 16#6AF6#,   --  櫶 (<CJK Ideograph>)
          4700  => 16#6AF7#,   --  櫷 (<CJK Ideograph>)
          4701  => 16#6AF8#,   --  櫸 (<CJK Ideograph>)
          4702  => 16#6AF9#,   --  櫹 (<CJK Ideograph>)
          4703  => 16#6AFA#,   --  櫺 (<CJK Ideograph>)
          4704  => 16#6AFB#,   --  櫻 (<CJK Ideograph>)
          4705  => 16#6AFC#,   --  櫼 (<CJK Ideograph>)
          4706  => 16#6AFD#,   --  櫽 (<CJK Ideograph>)
          4707  => 16#6AFE#,   --  櫾 (<CJK Ideograph>)
          4708  => 16#6AFF#,   --  櫿 (<CJK Ideograph>)
          4709  => 16#6B00#,   --  欀 (<CJK Ideograph>)
          4710  => 16#6B01#,   --  欁 (<CJK Ideograph>)
          4711  => 16#6B02#,   --  欂 (<CJK Ideograph>)
          4712  => 16#6B03#,   --  欃 (<CJK Ideograph>)
          4713  => 16#6B04#,   --  欄 (<CJK Ideograph>)
          4714  => 16#6B05#,   --  欅 (<CJK Ideograph>)
          4715  => 16#6B06#,   --  欆 (<CJK Ideograph>)
          4716  => 16#6B07#,   --  欇 (<CJK Ideograph>)
          4717  => 16#6B08#,   --  欈 (<CJK Ideograph>)
          4718  => 16#6B09#,   --  欉 (<CJK Ideograph>)
          4719  => 16#6B0A#,   --  權 (<CJK Ideograph>)
          4720  => 16#6B0B#,   --  欋 (<CJK Ideograph>)
          4721  => 16#6B0C#,   --  欌 (<CJK Ideograph>)
          4722  => 16#6B0D#,   --  欍 (<CJK Ideograph>)
          4723  => 16#6B0E#,   --  欎 (<CJK Ideograph>)
          4724  => 16#6B0F#,   --  欏 (<CJK Ideograph>)
          4725  => 16#6B10#,   --  欐 (<CJK Ideograph>)
          4726  => 16#6B11#,   --  欑 (<CJK Ideograph>)
          4727  => 16#6B12#,   --  欒 (<CJK Ideograph>)
          4728  => 16#6B13#,   --  欓 (<CJK Ideograph>)
          4729  => 16#6B14#,   --  欔 (<CJK Ideograph>)
          4730  => 16#6B15#,   --  欕 (<CJK Ideograph>)
          4731  => 16#6B16#,   --  欖 (<CJK Ideograph>)
          4732  => 16#6B17#,   --  欗 (<CJK Ideograph>)
          4733  => 16#6B18#,   --  欘 (<CJK Ideograph>)
          4734  => 16#6B19#,   --  欙 (<CJK Ideograph>)
          4735  => 16#6B1A#,   --  欚 (<CJK Ideograph>)
          4736  => 16#6B1B#,   --  欛 (<CJK Ideograph>)
          4737  => 16#6B1C#,   --  欜 (<CJK Ideograph>)
          4738  => 16#6B1D#,   --  欝 (<CJK Ideograph>)
          4739  => 16#6B1E#,   --  欞 (<CJK Ideograph>)
          4740  => 16#6B1F#,   --  欟 (<CJK Ideograph>)
          4741  => 16#6B25#,   --  欥 (<CJK Ideograph>)
          4742  => 16#6B26#,   --  欦 (<CJK Ideograph>)
          4743  => 16#6B28#,   --  欨 (<CJK Ideograph>)
          4744  => 16#6B29#,   --  欩 (<CJK Ideograph>)
          4745  => 16#6B2A#,   --  欪 (<CJK Ideograph>)
          4746  => 16#6B2B#,   --  欫 (<CJK Ideograph>)
          4747  => 16#6B2C#,   --  欬 (<CJK Ideograph>)
          4748  => 16#6B2D#,   --  欭 (<CJK Ideograph>)
          4749  => 16#6B2E#,   --  欮 (<CJK Ideograph>)
          4750  => 16#6B2F#,   --  欯 (<CJK Ideograph>)
          4751  => 16#6B30#,   --  欰 (<CJK Ideograph>)
          4752  => 16#6B31#,   --  欱 (<CJK Ideograph>)
          4753  => 16#6B33#,   --  欳 (<CJK Ideograph>)
          4754  => 16#6B34#,   --  欴 (<CJK Ideograph>)
          4755  => 16#6B35#,   --  欵 (<CJK Ideograph>)
          4756  => 16#6B36#,   --  欶 (<CJK Ideograph>)
          4757  => 16#6B38#,   --  欸 (<CJK Ideograph>)
          4758  => 16#6B3B#,   --  欻 (<CJK Ideograph>)
          4759  => 16#6B3C#,   --  欼 (<CJK Ideograph>)
          4760  => 16#6B3D#,   --  欽 (<CJK Ideograph>)
          4761  => 16#6B3F#,   --  欿 (<CJK Ideograph>)
          4762  => 16#6B40#,   --  歀 (<CJK Ideograph>)
          4763  => 16#6B41#,   --  歁 (<CJK Ideograph>)
          4764  => 16#6B42#,   --  歂 (<CJK Ideograph>)
          4765  => 16#6B44#,   --  歄 (<CJK Ideograph>)
          4766  => 16#6B45#,   --  歅 (<CJK Ideograph>)
          4767  => 16#6B48#,   --  歈 (<CJK Ideograph>)
          4768  => 16#6B4A#,   --  歊 (<CJK Ideograph>)
          4769  => 16#6B4B#,   --  歋 (<CJK Ideograph>)
          4770  => 16#6B4D#,   --  歍 (<CJK Ideograph>)
          4771  => 16#6B4E#,   --  歎 (<CJK Ideograph>)
          4772  => 16#6B4F#,   --  歏 (<CJK Ideograph>)
          4773  => 16#6B50#,   --  歐 (<CJK Ideograph>)
          4774  => 16#6B51#,   --  歑 (<CJK Ideograph>)
          4775  => 16#6B52#,   --  歒 (<CJK Ideograph>)
          4776  => 16#6B53#,   --  歓 (<CJK Ideograph>)
          4777  => 16#6B54#,   --  歔 (<CJK Ideograph>)
          4778  => 16#6B55#,   --  歕 (<CJK Ideograph>)
          4779  => 16#6B56#,   --  歖 (<CJK Ideograph>)
          4780  => 16#6B57#,   --  歗 (<CJK Ideograph>)
          4781  => 16#6B58#,   --  歘 (<CJK Ideograph>)
          4782  => 16#6B5A#,   --  歚 (<CJK Ideograph>)
          4783  => 16#6B5B#,   --  歛 (<CJK Ideograph>)
          4784  => 16#6B5C#,   --  歜 (<CJK Ideograph>)
          4785  => 16#6B5D#,   --  歝 (<CJK Ideograph>)
          4786  => 16#6B5E#,   --  歞 (<CJK Ideograph>)
          4787  => 16#6B5F#,   --  歟 (<CJK Ideograph>)
          4788  => 16#6B60#,   --  歠 (<CJK Ideograph>)
          4789  => 16#6B61#,   --  歡 (<CJK Ideograph>)
          4790  => 16#6B68#,   --  歨 (<CJK Ideograph>)
          4791  => 16#6B69#,   --  歩 (<CJK Ideograph>)
          4792  => 16#6B6B#,   --  歫 (<CJK Ideograph>)
          4793  => 16#6B6C#,   --  歬 (<CJK Ideograph>)
          4794  => 16#6B6D#,   --  歭 (<CJK Ideograph>)
          4795  => 16#6B6E#,   --  歮 (<CJK Ideograph>)
          4796  => 16#6B6F#,   --  歯 (<CJK Ideograph>)
          4797  => 16#6B70#,   --  歰 (<CJK Ideograph>)
          4798  => 16#6B71#,   --  歱 (<CJK Ideograph>)
          4799  => 16#6B72#,   --  歲 (<CJK Ideograph>)
          4800  => 16#6B73#,   --  歳 (<CJK Ideograph>)
          4801  => 16#6B74#,   --  歴 (<CJK Ideograph>)
          4802  => 16#6B75#,   --  歵 (<CJK Ideograph>)
          4803  => 16#6B76#,   --  歶 (<CJK Ideograph>)
          4804  => 16#6B77#,   --  歷 (<CJK Ideograph>)
          4805  => 16#6B78#,   --  歸 (<CJK Ideograph>)
          4806  => 16#6B7A#,   --  歺 (<CJK Ideograph>)
          4807  => 16#6B7D#,   --  歽 (<CJK Ideograph>)
          4808  => 16#6B7E#,   --  歾 (<CJK Ideograph>)
          4809  => 16#6B7F#,   --  歿 (<CJK Ideograph>)
          4810  => 16#6B80#,   --  殀 (<CJK Ideograph>)
          4811  => 16#6B85#,   --  殅 (<CJK Ideograph>)
          4812  => 16#6B88#,   --  殈 (<CJK Ideograph>)
          4813  => 16#6B8C#,   --  殌 (<CJK Ideograph>)
          4814  => 16#6B8E#,   --  殎 (<CJK Ideograph>)
          4815  => 16#6B8F#,   --  殏 (<CJK Ideograph>)
          4816  => 16#6B90#,   --  殐 (<CJK Ideograph>)
          4817  => 16#6B91#,   --  殑 (<CJK Ideograph>)
          4818  => 16#6B94#,   --  殔 (<CJK Ideograph>)
          4819  => 16#6B95#,   --  殕 (<CJK Ideograph>)
          4820  => 16#6B97#,   --  殗 (<CJK Ideograph>)
          4821  => 16#6B98#,   --  殘 (<CJK Ideograph>)
          4822  => 16#6B99#,   --  殙 (<CJK Ideograph>)
          4823  => 16#6B9C#,   --  殜 (<CJK Ideograph>)
          4824  => 16#6B9D#,   --  殝 (<CJK Ideograph>)
          4825  => 16#6B9E#,   --  殞 (<CJK Ideograph>)
          4826  => 16#6B9F#,   --  殟 (<CJK Ideograph>)
          4827  => 16#6BA0#,   --  殠 (<CJK Ideograph>)
          4828  => 16#6BA2#,   --  殢 (<CJK Ideograph>)
          4829  => 16#6BA3#,   --  殣 (<CJK Ideograph>)
          4830  => 16#6BA4#,   --  殤 (<CJK Ideograph>)
          4831  => 16#6BA5#,   --  殥 (<CJK Ideograph>)
          4832  => 16#6BA6#,   --  殦 (<CJK Ideograph>)
          4833  => 16#6BA7#,   --  殧 (<CJK Ideograph>)
          4834  => 16#6BA8#,   --  殨 (<CJK Ideograph>)
          4835  => 16#6BA9#,   --  殩 (<CJK Ideograph>)
          4836  => 16#6BAB#,   --  殫 (<CJK Ideograph>)
          4837  => 16#6BAC#,   --  殬 (<CJK Ideograph>)
          4838  => 16#6BAD#,   --  殭 (<CJK Ideograph>)
          4839  => 16#6BAE#,   --  殮 (<CJK Ideograph>)
          4840  => 16#6BAF#,   --  殯 (<CJK Ideograph>)
          4841  => 16#6BB0#,   --  殰 (<CJK Ideograph>)
          4842  => 16#6BB1#,   --  殱 (<CJK Ideograph>)
          4843  => 16#6BB2#,   --  殲 (<CJK Ideograph>)
          4844  => 16#6BB6#,   --  殶 (<CJK Ideograph>)
          4845  => 16#6BB8#,   --  殸 (<CJK Ideograph>)
          4846  => 16#6BB9#,   --  殹 (<CJK Ideograph>)
          4847  => 16#6BBA#,   --  殺 (<CJK Ideograph>)
          4848  => 16#6BBB#,   --  殻 (<CJK Ideograph>)
          4849  => 16#6BBC#,   --  殼 (<CJK Ideograph>)
          4850  => 16#6BBD#,   --  殽 (<CJK Ideograph>)
          4851  => 16#6BBE#,   --  殾 (<CJK Ideograph>)
          4852  => 16#6BC0#,   --  毀 (<CJK Ideograph>)
          4853  => 16#6BC3#,   --  毃 (<CJK Ideograph>)
          4854  => 16#6BC4#,   --  毄 (<CJK Ideograph>)
          4855  => 16#6BC6#,   --  毆 (<CJK Ideograph>)
          4856  => 16#6BC7#,   --  毇 (<CJK Ideograph>)
          4857  => 16#6BC8#,   --  毈 (<CJK Ideograph>)
          4858  => 16#6BC9#,   --  毉 (<CJK Ideograph>)
          4859  => 16#6BCA#,   --  毊 (<CJK Ideograph>)
          4860  => 16#6BCC#,   --  毌 (<CJK Ideograph>)
          4861  => 16#6BCE#,   --  毎 (<CJK Ideograph>)
          4862  => 16#6BD0#,   --  毐 (<CJK Ideograph>)
          4863  => 16#6BD1#,   --  毑 (<CJK Ideograph>)
          4864  => 16#6BD8#,   --  毘 (<CJK Ideograph>)
          4865  => 16#6BDA#,   --  毚 (<CJK Ideograph>)
          4866  => 16#6BDC#,   --  毜 (<CJK Ideograph>)
          4867  => 16#6BDD#,   --  毝 (<CJK Ideograph>)
          4868  => 16#6BDE#,   --  毞 (<CJK Ideograph>)
          4869  => 16#6BDF#,   --  毟 (<CJK Ideograph>)
          4870  => 16#6BE0#,   --  毠 (<CJK Ideograph>)
          4871  => 16#6BE2#,   --  毢 (<CJK Ideograph>)
          4872  => 16#6BE3#,   --  毣 (<CJK Ideograph>)
          4873  => 16#6BE4#,   --  毤 (<CJK Ideograph>)
          4874  => 16#6BE5#,   --  毥 (<CJK Ideograph>)
          4875  => 16#6BE6#,   --  毦 (<CJK Ideograph>)
          4876  => 16#6BE7#,   --  毧 (<CJK Ideograph>)
          4877  => 16#6BE8#,   --  毨 (<CJK Ideograph>)
          4878  => 16#6BE9#,   --  毩 (<CJK Ideograph>)
          4879  => 16#6BEC#,   --  毬 (<CJK Ideograph>)
          4880  => 16#6BED#,   --  毭 (<CJK Ideograph>)
          4881  => 16#6BEE#,   --  毮 (<CJK Ideograph>)
          4882  => 16#6BF0#,   --  毰 (<CJK Ideograph>)
          4883  => 16#6BF1#,   --  毱 (<CJK Ideograph>)
          4884  => 16#6BF2#,   --  毲 (<CJK Ideograph>)
          4885  => 16#6BF4#,   --  毴 (<CJK Ideograph>)
          4886  => 16#6BF6#,   --  毶 (<CJK Ideograph>)
          4887  => 16#6BF7#,   --  毷 (<CJK Ideograph>)
          4888  => 16#6BF8#,   --  毸 (<CJK Ideograph>)
          4889  => 16#6BFA#,   --  毺 (<CJK Ideograph>)
          4890  => 16#6BFB#,   --  毻 (<CJK Ideograph>)
          4891  => 16#6BFC#,   --  毼 (<CJK Ideograph>)
          4892  => 16#6BFE#,   --  毾 (<CJK Ideograph>)
          4893  => 16#6BFF#,   --  毿 (<CJK Ideograph>)
          4894  => 16#6C00#,   --  氀 (<CJK Ideograph>)
          4895  => 16#6C01#,   --  氁 (<CJK Ideograph>)
          4896  => 16#6C02#,   --  氂 (<CJK Ideograph>)
          4897  => 16#6C03#,   --  氃 (<CJK Ideograph>)
          4898  => 16#6C04#,   --  氄 (<CJK Ideograph>)
          4899  => 16#6C08#,   --  氈 (<CJK Ideograph>)
          4900  => 16#6C09#,   --  氉 (<CJK Ideograph>)
          4901  => 16#6C0A#,   --  氊 (<CJK Ideograph>)
          4902  => 16#6C0B#,   --  氋 (<CJK Ideograph>)
          4903  => 16#6C0C#,   --  氌 (<CJK Ideograph>)
          4904  => 16#6C0E#,   --  氎 (<CJK Ideograph>)
          4905  => 16#6C12#,   --  氒 (<CJK Ideograph>)
          4906  => 16#6C17#,   --  気 (<CJK Ideograph>)
          4907  => 16#6C1C#,   --  氜 (<CJK Ideograph>)
          4908  => 16#6C1D#,   --  氝 (<CJK Ideograph>)
          4909  => 16#6C1E#,   --  氞 (<CJK Ideograph>)
          4910  => 16#6C20#,   --  氠 (<CJK Ideograph>)
          4911  => 16#6C23#,   --  氣 (<CJK Ideograph>)
          4912  => 16#6C25#,   --  氥 (<CJK Ideograph>)
          4913  => 16#6C2B#,   --  氫 (<CJK Ideograph>)
          4914  => 16#6C2C#,   --  氬 (<CJK Ideograph>)
          4915  => 16#6C2D#,   --  氭 (<CJK Ideograph>)
          4916  => 16#6C31#,   --  氱 (<CJK Ideograph>)
          4917  => 16#6C33#,   --  氳 (<CJK Ideograph>)
          4918  => 16#6C36#,   --  氶 (<CJK Ideograph>)
          4919  => 16#6C37#,   --  氷 (<CJK Ideograph>)
          4920  => 16#6C39#,   --  氹 (<CJK Ideograph>)
          4921  => 16#6C3A#,   --  氺 (<CJK Ideograph>)
          4922  => 16#6C3B#,   --  氻 (<CJK Ideograph>)
          4923  => 16#6C3C#,   --  氼 (<CJK Ideograph>)
          4924  => 16#6C3E#,   --  氾 (<CJK Ideograph>)
          4925  => 16#6C3F#,   --  氿 (<CJK Ideograph>)
          4926  => 16#6C43#,   --  汃 (<CJK Ideograph>)
          4927  => 16#6C44#,   --  汄 (<CJK Ideograph>)
          4928  => 16#6C45#,   --  汅 (<CJK Ideograph>)
          4929  => 16#6C48#,   --  汈 (<CJK Ideograph>)
          4930  => 16#6C4B#,   --  汋 (<CJK Ideograph>)
          4931  => 16#6C4C#,   --  汌 (<CJK Ideograph>)
          4932  => 16#6C4D#,   --  汍 (<CJK Ideograph>)
          4933  => 16#6C4E#,   --  汎 (<CJK Ideograph>)
          4934  => 16#6C4F#,   --  汏 (<CJK Ideograph>)
          4935  => 16#6C51#,   --  汑 (<CJK Ideograph>)
          4936  => 16#6C52#,   --  汒 (<CJK Ideograph>)
          4937  => 16#6C53#,   --  汓 (<CJK Ideograph>)
          4938  => 16#6C56#,   --  汖 (<CJK Ideograph>)
          4939  => 16#6C58#,   --  汘 (<CJK Ideograph>)
          4940  => 16#6C59#,   --  汙 (<CJK Ideograph>)
          4941  => 16#6C5A#,   --  汚 (<CJK Ideograph>)
          4942  => 16#6C62#,   --  汢 (<CJK Ideograph>)
          4943  => 16#6C63#,   --  汣 (<CJK Ideograph>)
          4944  => 16#6C65#,   --  汥 (<CJK Ideograph>)
          4945  => 16#6C66#,   --  汦 (<CJK Ideograph>)
          4946  => 16#6C67#,   --  汧 (<CJK Ideograph>)
          4947  => 16#6C6B#,   --  汫 (<CJK Ideograph>)
          4948  => 16#6C6C#,   --  汬 (<CJK Ideograph>)
          4949  => 16#6C6D#,   --  汭 (<CJK Ideograph>)
          4950  => 16#6C6E#,   --  汮 (<CJK Ideograph>)
          4951  => 16#6C6F#,   --  汯 (<CJK Ideograph>)
          4952  => 16#6C71#,   --  汱 (<CJK Ideograph>)
          4953  => 16#6C73#,   --  汳 (<CJK Ideograph>)
          4954  => 16#6C75#,   --  汵 (<CJK Ideograph>)
          4955  => 16#6C77#,   --  汷 (<CJK Ideograph>)
          4956  => 16#6C78#,   --  汸 (<CJK Ideograph>)
          4957  => 16#6C7A#,   --  決 (<CJK Ideograph>)
          4958  => 16#6C7B#,   --  汻 (<CJK Ideograph>)
          4959  => 16#6C7C#,   --  汼 (<CJK Ideograph>)
          4960  => 16#6C7F#,   --  汿 (<CJK Ideograph>)
          4961  => 16#6C80#,   --  沀 (<CJK Ideograph>)
          4962  => 16#6C84#,   --  沄 (<CJK Ideograph>)
          4963  => 16#6C87#,   --  沇 (<CJK Ideograph>)
          4964  => 16#6C8A#,   --  沊 (<CJK Ideograph>)
          4965  => 16#6C8B#,   --  沋 (<CJK Ideograph>)
          4966  => 16#6C8D#,   --  沍 (<CJK Ideograph>)
          4967  => 16#6C8E#,   --  沎 (<CJK Ideograph>)
          4968  => 16#6C91#,   --  沑 (<CJK Ideograph>)
          4969  => 16#6C92#,   --  沒 (<CJK Ideograph>)
          4970  => 16#6C95#,   --  沕 (<CJK Ideograph>)
          4971  => 16#6C96#,   --  沖 (<CJK Ideograph>)
          4972  => 16#6C97#,   --  沗 (<CJK Ideograph>)
          4973  => 16#6C98#,   --  沘 (<CJK Ideograph>)
          4974  => 16#6C9A#,   --  沚 (<CJK Ideograph>)
          4975  => 16#6C9C#,   --  沜 (<CJK Ideograph>)
          4976  => 16#6C9D#,   --  沝 (<CJK Ideograph>)
          4977  => 16#6C9E#,   --  沞 (<CJK Ideograph>)
          4978  => 16#6CA0#,   --  沠 (<CJK Ideograph>)
          4979  => 16#6CA2#,   --  沢 (<CJK Ideograph>)
          4980  => 16#6CA8#,   --  沨 (<CJK Ideograph>)
          4981  => 16#6CAC#,   --  沬 (<CJK Ideograph>)
          4982  => 16#6CAF#,   --  沯 (<CJK Ideograph>)
          4983  => 16#6CB0#,   --  沰 (<CJK Ideograph>)
          4984  => 16#6CB4#,   --  沴 (<CJK Ideograph>)
          4985  => 16#6CB5#,   --  沵 (<CJK Ideograph>)
          4986  => 16#6CB6#,   --  沶 (<CJK Ideograph>)
          4987  => 16#6CB7#,   --  沷 (<CJK Ideograph>)
          4988  => 16#6CBA#,   --  沺 (<CJK Ideograph>)
          4989  => 16#6CC0#,   --  泀 (<CJK Ideograph>)
          4990  => 16#6CC1#,   --  況 (<CJK Ideograph>)
          4991  => 16#6CC2#,   --  泂 (<CJK Ideograph>)
          4992  => 16#6CC3#,   --  泃 (<CJK Ideograph>)
          4993  => 16#6CC6#,   --  泆 (<CJK Ideograph>)
          4994  => 16#6CC7#,   --  泇 (<CJK Ideograph>)
          4995  => 16#6CC8#,   --  泈 (<CJK Ideograph>)
          4996  => 16#6CCB#,   --  泋 (<CJK Ideograph>)
          4997  => 16#6CCD#,   --  泍 (<CJK Ideograph>)
          4998  => 16#6CCE#,   --  泎 (<CJK Ideograph>)
          4999  => 16#6CCF#,   --  泏 (<CJK Ideograph>)
          5000  => 16#6CD1#,   --  泑 (<CJK Ideograph>)
          5001  => 16#6CD2#,   --  泒 (<CJK Ideograph>)
          5002  => 16#6CD8#,   --  泘 (<CJK Ideograph>)
          5003  => 16#6CD9#,   --  泙 (<CJK Ideograph>)
          5004  => 16#6CDA#,   --  泚 (<CJK Ideograph>)
          5005  => 16#6CDC#,   --  泜 (<CJK Ideograph>)
          5006  => 16#6CDD#,   --  泝 (<CJK Ideograph>)
          5007  => 16#6CDF#,   --  泟 (<CJK Ideograph>)
          5008  => 16#6CE4#,   --  泤 (<CJK Ideograph>)
          5009  => 16#6CE6#,   --  泦 (<CJK Ideograph>)
          5010  => 16#6CE7#,   --  泧 (<CJK Ideograph>)
          5011  => 16#6CE9#,   --  泩 (<CJK Ideograph>)
          5012  => 16#6CEC#,   --  泬 (<CJK Ideograph>)
          5013  => 16#6CED#,   --  泭 (<CJK Ideograph>)
          5014  => 16#6CF2#,   --  泲 (<CJK Ideograph>)
          5015  => 16#6CF4#,   --  泴 (<CJK Ideograph>)
          5016  => 16#6CF9#,   --  泹 (<CJK Ideograph>)
          5017  => 16#6CFF#,   --  泿 (<CJK Ideograph>)
          5018  => 16#6D00#,   --  洀 (<CJK Ideograph>)
          5019  => 16#6D02#,   --  洂 (<CJK Ideograph>)
          5020  => 16#6D03#,   --  洃 (<CJK Ideograph>)
          5021  => 16#6D05#,   --  洅 (<CJK Ideograph>)
          5022  => 16#6D06#,   --  洆 (<CJK Ideograph>)
          5023  => 16#6D08#,   --  洈 (<CJK Ideograph>)
          5024  => 16#6D09#,   --  洉 (<CJK Ideograph>)
          5025  => 16#6D0A#,   --  洊 (<CJK Ideograph>)
          5026  => 16#6D0D#,   --  洍 (<CJK Ideograph>)
          5027  => 16#6D0F#,   --  洏 (<CJK Ideograph>)
          5028  => 16#6D10#,   --  洐 (<CJK Ideograph>)
          5029  => 16#6D11#,   --  洑 (<CJK Ideograph>)
          5030  => 16#6D13#,   --  洓 (<CJK Ideograph>)
          5031  => 16#6D14#,   --  洔 (<CJK Ideograph>)
          5032  => 16#6D15#,   --  洕 (<CJK Ideograph>)
          5033  => 16#6D16#,   --  洖 (<CJK Ideograph>)
          5034  => 16#6D18#,   --  洘 (<CJK Ideograph>)
          5035  => 16#6D1C#,   --  洜 (<CJK Ideograph>)
          5036  => 16#6D1D#,   --  洝 (<CJK Ideograph>)
          5037  => 16#6D1F#,   --  洟 (<CJK Ideograph>)
          5038  => 16#6D20#,   --  洠 (<CJK Ideograph>)
          5039  => 16#6D21#,   --  洡 (<CJK Ideograph>)
          5040  => 16#6D22#,   --  洢 (<CJK Ideograph>)
          5041  => 16#6D23#,   --  洣 (<CJK Ideograph>)
          5042  => 16#6D24#,   --  洤 (<CJK Ideograph>)
          5043  => 16#6D26#,   --  洦 (<CJK Ideograph>)
          5044  => 16#6D28#,   --  洨 (<CJK Ideograph>)
          5045  => 16#6D29#,   --  洩 (<CJK Ideograph>)
          5046  => 16#6D2C#,   --  洬 (<CJK Ideograph>)
          5047  => 16#6D2D#,   --  洭 (<CJK Ideograph>)
          5048  => 16#6D2F#,   --  洯 (<CJK Ideograph>)
          5049  => 16#6D30#,   --  洰 (<CJK Ideograph>)
          5050  => 16#6D34#,   --  洴 (<CJK Ideograph>)
          5051  => 16#6D36#,   --  洶 (<CJK Ideograph>)
          5052  => 16#6D37#,   --  洷 (<CJK Ideograph>)
          5053  => 16#6D38#,   --  洸 (<CJK Ideograph>)
          5054  => 16#6D3A#,   --  洺 (<CJK Ideograph>)
          5055  => 16#6D3F#,   --  洿 (<CJK Ideograph>)
          5056  => 16#6D40#,   --  浀 (<CJK Ideograph>)
          5057  => 16#6D42#,   --  浂 (<CJK Ideograph>)
          5058  => 16#6D44#,   --  浄 (<CJK Ideograph>)
          5059  => 16#6D49#,   --  浉 (<CJK Ideograph>)
          5060  => 16#6D4C#,   --  浌 (<CJK Ideograph>)
          5061  => 16#6D50#,   --  浐 (<CJK Ideograph>)
          5062  => 16#6D55#,   --  浕 (<CJK Ideograph>)
          5063  => 16#6D56#,   --  浖 (<CJK Ideograph>)
          5064  => 16#6D57#,   --  浗 (<CJK Ideograph>)
          5065  => 16#6D58#,   --  浘 (<CJK Ideograph>)
          5066  => 16#6D5B#,   --  浛 (<CJK Ideograph>)
          5067  => 16#6D5D#,   --  浝 (<CJK Ideograph>)
          5068  => 16#6D5F#,   --  浟 (<CJK Ideograph>)
          5069  => 16#6D61#,   --  浡 (<CJK Ideograph>)
          5070  => 16#6D62#,   --  浢 (<CJK Ideograph>)
          5071  => 16#6D64#,   --  浤 (<CJK Ideograph>)
          5072  => 16#6D65#,   --  浥 (<CJK Ideograph>)
          5073  => 16#6D67#,   --  浧 (<CJK Ideograph>)
          5074  => 16#6D68#,   --  浨 (<CJK Ideograph>)
          5075  => 16#6D6B#,   --  浫 (<CJK Ideograph>)
          5076  => 16#6D6C#,   --  浬 (<CJK Ideograph>)
          5077  => 16#6D6D#,   --  浭 (<CJK Ideograph>)
          5078  => 16#6D70#,   --  浰 (<CJK Ideograph>)
          5079  => 16#6D71#,   --  浱 (<CJK Ideograph>)
          5080  => 16#6D72#,   --  浲 (<CJK Ideograph>)
          5081  => 16#6D73#,   --  浳 (<CJK Ideograph>)
          5082  => 16#6D75#,   --  浵 (<CJK Ideograph>)
          5083  => 16#6D76#,   --  浶 (<CJK Ideograph>)
          5084  => 16#6D79#,   --  浹 (<CJK Ideograph>)
          5085  => 16#6D7A#,   --  浺 (<CJK Ideograph>)
          5086  => 16#6D7B#,   --  浻 (<CJK Ideograph>)
          5087  => 16#6D7D#,   --  浽 (<CJK Ideograph>)
          5088  => 16#6D7E#,   --  浾 (<CJK Ideograph>)
          5089  => 16#6D7F#,   --  浿 (<CJK Ideograph>)
          5090  => 16#6D80#,   --  涀 (<CJK Ideograph>)
          5091  => 16#6D81#,   --  涁 (<CJK Ideograph>)
          5092  => 16#6D83#,   --  涃 (<CJK Ideograph>)
          5093  => 16#6D84#,   --  涄 (<CJK Ideograph>)
          5094  => 16#6D86#,   --  涆 (<CJK Ideograph>)
          5095  => 16#6D87#,   --  涇 (<CJK Ideograph>)
          5096  => 16#6D8A#,   --  涊 (<CJK Ideograph>)
          5097  => 16#6D8B#,   --  涋 (<CJK Ideograph>)
          5098  => 16#6D8D#,   --  涍 (<CJK Ideograph>)
          5099  => 16#6D8F#,   --  涏 (<CJK Ideograph>)
          5100  => 16#6D90#,   --  涐 (<CJK Ideograph>)
          5101  => 16#6D92#,   --  涒 (<CJK Ideograph>)
          5102  => 16#6D96#,   --  涖 (<CJK Ideograph>)
          5103  => 16#6D97#,   --  涗 (<CJK Ideograph>)
          5104  => 16#6D98#,   --  涘 (<CJK Ideograph>)
          5105  => 16#6D99#,   --  涙 (<CJK Ideograph>)
          5106  => 16#6D9A#,   --  涚 (<CJK Ideograph>)
          5107  => 16#6D9C#,   --  涜 (<CJK Ideograph>)
          5108  => 16#6DA2#,   --  涢 (<CJK Ideograph>)
          5109  => 16#6DA5#,   --  涥 (<CJK Ideograph>)
          5110  => 16#6DAC#,   --  涬 (<CJK Ideograph>)
          5111  => 16#6DAD#,   --  涭 (<CJK Ideograph>)
          5112  => 16#6DB0#,   --  涰 (<CJK Ideograph>)
          5113  => 16#6DB1#,   --  涱 (<CJK Ideograph>)
          5114  => 16#6DB3#,   --  涳 (<CJK Ideograph>)
          5115  => 16#6DB4#,   --  涴 (<CJK Ideograph>)
          5116  => 16#6DB6#,   --  涶 (<CJK Ideograph>)
          5117  => 16#6DB7#,   --  涷 (<CJK Ideograph>)
          5118  => 16#6DB9#,   --  涹 (<CJK Ideograph>)
          5119  => 16#6DBA#,   --  涺 (<CJK Ideograph>)
          5120  => 16#6DBB#,   --  涻 (<CJK Ideograph>)
          5121  => 16#6DBC#,   --  涼 (<CJK Ideograph>)
          5122  => 16#6DBD#,   --  涽 (<CJK Ideograph>)
          5123  => 16#6DBE#,   --  涾 (<CJK Ideograph>)
          5124  => 16#6DC1#,   --  淁 (<CJK Ideograph>)
          5125  => 16#6DC2#,   --  淂 (<CJK Ideograph>)
          5126  => 16#6DC3#,   --  淃 (<CJK Ideograph>)
          5127  => 16#6DC8#,   --  淈 (<CJK Ideograph>)
          5128  => 16#6DC9#,   --  淉 (<CJK Ideograph>)
          5129  => 16#6DCA#,   --  淊 (<CJK Ideograph>)
          5130  => 16#6DCD#,   --  淍 (<CJK Ideograph>)
          5131  => 16#6DCE#,   --  淎 (<CJK Ideograph>)
          5132  => 16#6DCF#,   --  淏 (<CJK Ideograph>)
          5133  => 16#6DD0#,   --  淐 (<CJK Ideograph>)
          5134  => 16#6DD2#,   --  淒 (<CJK Ideograph>)
          5135  => 16#6DD3#,   --  淓 (<CJK Ideograph>)
          5136  => 16#6DD4#,   --  淔 (<CJK Ideograph>)
          5137  => 16#6DD5#,   --  淕 (<CJK Ideograph>)
          5138  => 16#6DD7#,   --  淗 (<CJK Ideograph>)
          5139  => 16#6DDA#,   --  淚 (<CJK Ideograph>)
          5140  => 16#6DDB#,   --  淛 (<CJK Ideograph>)
          5141  => 16#6DDC#,   --  淜 (<CJK Ideograph>)
          5142  => 16#6DDF#,   --  淟 (<CJK Ideograph>)
          5143  => 16#6DE2#,   --  淢 (<CJK Ideograph>)
          5144  => 16#6DE3#,   --  淣 (<CJK Ideograph>)
          5145  => 16#6DE5#,   --  淥 (<CJK Ideograph>)
          5146  => 16#6DE7#,   --  淧 (<CJK Ideograph>)
          5147  => 16#6DE8#,   --  淨 (<CJK Ideograph>)
          5148  => 16#6DE9#,   --  淩 (<CJK Ideograph>)
          5149  => 16#6DEA#,   --  淪 (<CJK Ideograph>)
          5150  => 16#6DED#,   --  淭 (<CJK Ideograph>)
          5151  => 16#6DEF#,   --  淯 (<CJK Ideograph>)
          5152  => 16#6DF0#,   --  淰 (<CJK Ideograph>)
          5153  => 16#6DF2#,   --  淲 (<CJK Ideograph>)
          5154  => 16#6DF4#,   --  淴 (<CJK Ideograph>)
          5155  => 16#6DF5#,   --  淵 (<CJK Ideograph>)
          5156  => 16#6DF6#,   --  淶 (<CJK Ideograph>)
          5157  => 16#6DF8#,   --  淸 (<CJK Ideograph>)
          5158  => 16#6DFA#,   --  淺 (<CJK Ideograph>)
          5159  => 16#6DFD#,   --  淽 (<CJK Ideograph>)
          5160  => 16#6DFE#,   --  淾 (<CJK Ideograph>)
          5161  => 16#6DFF#,   --  淿 (<CJK Ideograph>)
          5162  => 16#6E00#,   --  渀 (<CJK Ideograph>)
          5163  => 16#6E01#,   --  渁 (<CJK Ideograph>)
          5164  => 16#6E02#,   --  渂 (<CJK Ideograph>)
          5165  => 16#6E03#,   --  渃 (<CJK Ideograph>)
          5166  => 16#6E04#,   --  渄 (<CJK Ideograph>)
          5167  => 16#6E06#,   --  渆 (<CJK Ideograph>)
          5168  => 16#6E07#,   --  渇 (<CJK Ideograph>)
          5169  => 16#6E08#,   --  済 (<CJK Ideograph>)
          5170  => 16#6E09#,   --  渉 (<CJK Ideograph>)
          5171  => 16#6E0B#,   --  渋 (<CJK Ideograph>)
          5172  => 16#6E0F#,   --  渏 (<CJK Ideograph>)
          5173  => 16#6E12#,   --  渒 (<CJK Ideograph>)
          5174  => 16#6E13#,   --  渓 (<CJK Ideograph>)
          5175  => 16#6E15#,   --  渕 (<CJK Ideograph>)
          5176  => 16#6E18#,   --  渘 (<CJK Ideograph>)
          5177  => 16#6E19#,   --  渙 (<CJK Ideograph>)
          5178  => 16#6E1B#,   --  減 (<CJK Ideograph>)
          5179  => 16#6E1C#,   --  渜 (<CJK Ideograph>)
          5180  => 16#6E1E#,   --  渞 (<CJK Ideograph>)
          5181  => 16#6E1F#,   --  渟 (<CJK Ideograph>)
          5182  => 16#6E22#,   --  渢 (<CJK Ideograph>)
          5183  => 16#6E26#,   --  渦 (<CJK Ideograph>)
          5184  => 16#6E27#,   --  渧 (<CJK Ideograph>)
          5185  => 16#6E28#,   --  渨 (<CJK Ideograph>)
          5186  => 16#6E2A#,   --  渪 (<CJK Ideograph>)
          5187  => 16#6E2C#,   --  測 (<CJK Ideograph>)
          5188  => 16#6E2E#,   --  渮 (<CJK Ideograph>)
          5189  => 16#6E30#,   --  渰 (<CJK Ideograph>)
          5190  => 16#6E31#,   --  渱 (<CJK Ideograph>)
          5191  => 16#6E33#,   --  渳 (<CJK Ideograph>)
          5192  => 16#6E35#,   --  渵 (<CJK Ideograph>)
          5193  => 16#6E36#,   --  渶 (<CJK Ideograph>)
          5194  => 16#6E37#,   --  渷 (<CJK Ideograph>)
          5195  => 16#6E39#,   --  渹 (<CJK Ideograph>)
          5196  => 16#6E3B#,   --  渻 (<CJK Ideograph>)
          5197  => 16#6E3C#,   --  渼 (<CJK Ideograph>)
          5198  => 16#6E3D#,   --  渽 (<CJK Ideograph>)
          5199  => 16#6E3E#,   --  渾 (<CJK Ideograph>)
          5200  => 16#6E3F#,   --  渿 (<CJK Ideograph>)
          5201  => 16#6E40#,   --  湀 (<CJK Ideograph>)
          5202  => 16#6E41#,   --  湁 (<CJK Ideograph>)
          5203  => 16#6E42#,   --  湂 (<CJK Ideograph>)
          5204  => 16#6E45#,   --  湅 (<CJK Ideograph>)
          5205  => 16#6E46#,   --  湆 (<CJK Ideograph>)
          5206  => 16#6E47#,   --  湇 (<CJK Ideograph>)
          5207  => 16#6E48#,   --  湈 (<CJK Ideograph>)
          5208  => 16#6E49#,   --  湉 (<CJK Ideograph>)
          5209  => 16#6E4A#,   --  湊 (<CJK Ideograph>)
          5210  => 16#6E4B#,   --  湋 (<CJK Ideograph>)
          5211  => 16#6E4C#,   --  湌 (<CJK Ideograph>)
          5212  => 16#6E4F#,   --  湏 (<CJK Ideograph>)
          5213  => 16#6E50#,   --  湐 (<CJK Ideograph>)
          5214  => 16#6E51#,   --  湑 (<CJK Ideograph>)
          5215  => 16#6E52#,   --  湒 (<CJK Ideograph>)
          5216  => 16#6E55#,   --  湕 (<CJK Ideograph>)
          5217  => 16#6E57#,   --  湗 (<CJK Ideograph>)
          5218  => 16#6E59#,   --  湙 (<CJK Ideograph>)
          5219  => 16#6E5A#,   --  湚 (<CJK Ideograph>)
          5220  => 16#6E5C#,   --  湜 (<CJK Ideograph>)
          5221  => 16#6E5D#,   --  湝 (<CJK Ideograph>)
          5222  => 16#6E5E#,   --  湞 (<CJK Ideograph>)
          5223  => 16#6E60#,   --  湠 (<CJK Ideograph>)
          5224  => 16#6E61#,   --  湡 (<CJK Ideograph>)
          5225  => 16#6E62#,   --  湢 (<CJK Ideograph>)
          5226  => 16#6E63#,   --  湣 (<CJK Ideograph>)
          5227  => 16#6E64#,   --  湤 (<CJK Ideograph>)
          5228  => 16#6E65#,   --  湥 (<CJK Ideograph>)
          5229  => 16#6E66#,   --  湦 (<CJK Ideograph>)
          5230  => 16#6E67#,   --  湧 (<CJK Ideograph>)
          5231  => 16#6E68#,   --  湨 (<CJK Ideograph>)
          5232  => 16#6E69#,   --  湩 (<CJK Ideograph>)
          5233  => 16#6E6A#,   --  湪 (<CJK Ideograph>)
          5234  => 16#6E6C#,   --  湬 (<CJK Ideograph>)
          5235  => 16#6E6D#,   --  湭 (<CJK Ideograph>)
          5236  => 16#6E6F#,   --  湯 (<CJK Ideograph>)
          5237  => 16#6E70#,   --  湰 (<CJK Ideograph>)
          5238  => 16#6E71#,   --  湱 (<CJK Ideograph>)
          5239  => 16#6E72#,   --  湲 (<CJK Ideograph>)
          5240  => 16#6E73#,   --  湳 (<CJK Ideograph>)
          5241  => 16#6E74#,   --  湴 (<CJK Ideograph>)
          5242  => 16#6E75#,   --  湵 (<CJK Ideograph>)
          5243  => 16#6E76#,   --  湶 (<CJK Ideograph>)
          5244  => 16#6E77#,   --  湷 (<CJK Ideograph>)
          5245  => 16#6E78#,   --  湸 (<CJK Ideograph>)
          5246  => 16#6E79#,   --  湹 (<CJK Ideograph>)
          5247  => 16#6E7A#,   --  湺 (<CJK Ideograph>)
          5248  => 16#6E7B#,   --  湻 (<CJK Ideograph>)
          5249  => 16#6E7C#,   --  湼 (<CJK Ideograph>)
          5250  => 16#6E7D#,   --  湽 (<CJK Ideograph>)
          5251  => 16#6E80#,   --  満 (<CJK Ideograph>)
          5252  => 16#6E81#,   --  溁 (<CJK Ideograph>)
          5253  => 16#6E82#,   --  溂 (<CJK Ideograph>)
          5254  => 16#6E84#,   --  溄 (<CJK Ideograph>)
          5255  => 16#6E87#,   --  溇 (<CJK Ideograph>)
          5256  => 16#6E88#,   --  溈 (<CJK Ideograph>)
          5257  => 16#6E8A#,   --  溊 (<CJK Ideograph>)
          5258  => 16#6E8B#,   --  溋 (<CJK Ideograph>)
          5259  => 16#6E8C#,   --  溌 (<CJK Ideograph>)
          5260  => 16#6E8D#,   --  溍 (<CJK Ideograph>)
          5261  => 16#6E8E#,   --  溎 (<CJK Ideograph>)
          5262  => 16#6E91#,   --  溑 (<CJK Ideograph>)
          5263  => 16#6E92#,   --  溒 (<CJK Ideograph>)
          5264  => 16#6E93#,   --  溓 (<CJK Ideograph>)
          5265  => 16#6E94#,   --  溔 (<CJK Ideograph>)
          5266  => 16#6E95#,   --  溕 (<CJK Ideograph>)
          5267  => 16#6E96#,   --  準 (<CJK Ideograph>)
          5268  => 16#6E97#,   --  溗 (<CJK Ideograph>)
          5269  => 16#6E99#,   --  溙 (<CJK Ideograph>)
          5270  => 16#6E9A#,   --  溚 (<CJK Ideograph>)
          5271  => 16#6E9B#,   --  溛 (<CJK Ideograph>)
          5272  => 16#6E9D#,   --  溝 (<CJK Ideograph>)
          5273  => 16#6E9E#,   --  溞 (<CJK Ideograph>)
          5274  => 16#6EA0#,   --  溠 (<CJK Ideograph>)
          5275  => 16#6EA1#,   --  溡 (<CJK Ideograph>)
          5276  => 16#6EA3#,   --  溣 (<CJK Ideograph>)
          5277  => 16#6EA4#,   --  溤 (<CJK Ideograph>)
          5278  => 16#6EA6#,   --  溦 (<CJK Ideograph>)
          5279  => 16#6EA8#,   --  溨 (<CJK Ideograph>)
          5280  => 16#6EA9#,   --  溩 (<CJK Ideograph>)
          5281  => 16#6EAB#,   --  溫 (<CJK Ideograph>)
          5282  => 16#6EAC#,   --  溬 (<CJK Ideograph>)
          5283  => 16#6EAD#,   --  溭 (<CJK Ideograph>)
          5284  => 16#6EAE#,   --  溮 (<CJK Ideograph>)
          5285  => 16#6EB0#,   --  溰 (<CJK Ideograph>)
          5286  => 16#6EB3#,   --  溳 (<CJK Ideograph>)
          5287  => 16#6EB5#,   --  溵 (<CJK Ideograph>)
          5288  => 16#6EB8#,   --  溸 (<CJK Ideograph>)
          5289  => 16#6EB9#,   --  溹 (<CJK Ideograph>)
          5290  => 16#6EBC#,   --  溼 (<CJK Ideograph>)
          5291  => 16#6EBE#,   --  溾 (<CJK Ideograph>)
          5292  => 16#6EBF#,   --  溿 (<CJK Ideograph>)
          5293  => 16#6EC0#,   --  滀 (<CJK Ideograph>)
          5294  => 16#6EC3#,   --  滃 (<CJK Ideograph>)
          5295  => 16#6EC4#,   --  滄 (<CJK Ideograph>)
          5296  => 16#6EC5#,   --  滅 (<CJK Ideograph>)
          5297  => 16#6EC6#,   --  滆 (<CJK Ideograph>)
          5298  => 16#6EC8#,   --  滈 (<CJK Ideograph>)
          5299  => 16#6EC9#,   --  滉 (<CJK Ideograph>)
          5300  => 16#6ECA#,   --  滊 (<CJK Ideograph>)
          5301  => 16#6ECC#,   --  滌 (<CJK Ideograph>)
          5302  => 16#6ECD#,   --  滍 (<CJK Ideograph>)
          5303  => 16#6ECE#,   --  滎 (<CJK Ideograph>)
          5304  => 16#6ED0#,   --  滐 (<CJK Ideograph>)
          5305  => 16#6ED2#,   --  滒 (<CJK Ideograph>)
          5306  => 16#6ED6#,   --  滖 (<CJK Ideograph>)
          5307  => 16#6ED8#,   --  滘 (<CJK Ideograph>)
          5308  => 16#6ED9#,   --  滙 (<CJK Ideograph>)
          5309  => 16#6EDB#,   --  滛 (<CJK Ideograph>)
          5310  => 16#6EDC#,   --  滜 (<CJK Ideograph>)
          5311  => 16#6EDD#,   --  滝 (<CJK Ideograph>)
          5312  => 16#6EE3#,   --  滣 (<CJK Ideograph>)
          5313  => 16#6EE7#,   --  滧 (<CJK Ideograph>)
          5314  => 16#6EEA#,   --  滪 (<CJK Ideograph>)
          5315  => 16#6EEB#,   --  滫 (<CJK Ideograph>)
          5316  => 16#6EEC#,   --  滬 (<CJK Ideograph>)
          5317  => 16#6EED#,   --  滭 (<CJK Ideograph>)
          5318  => 16#6EEE#,   --  滮 (<CJK Ideograph>)
          5319  => 16#6EEF#,   --  滯 (<CJK Ideograph>)
          5320  => 16#6EF0#,   --  滰 (<CJK Ideograph>)
          5321  => 16#6EF1#,   --  滱 (<CJK Ideograph>)
          5322  => 16#6EF2#,   --  滲 (<CJK Ideograph>)
          5323  => 16#6EF3#,   --  滳 (<CJK Ideograph>)
          5324  => 16#6EF5#,   --  滵 (<CJK Ideograph>)
          5325  => 16#6EF6#,   --  滶 (<CJK Ideograph>)
          5326  => 16#6EF7#,   --  滷 (<CJK Ideograph>)
          5327  => 16#6EF8#,   --  滸 (<CJK Ideograph>)
          5328  => 16#6EFA#,   --  滺 (<CJK Ideograph>)
          5329  => 16#6EFB#,   --  滻 (<CJK Ideograph>)
          5330  => 16#6EFC#,   --  滼 (<CJK Ideograph>)
          5331  => 16#6EFD#,   --  滽 (<CJK Ideograph>)
          5332  => 16#6EFE#,   --  滾 (<CJK Ideograph>)
          5333  => 16#6EFF#,   --  滿 (<CJK Ideograph>)
          5334  => 16#6F00#,   --  漀 (<CJK Ideograph>)
          5335  => 16#6F01#,   --  漁 (<CJK Ideograph>)
          5336  => 16#6F03#,   --  漃 (<CJK Ideograph>)
          5337  => 16#6F04#,   --  漄 (<CJK Ideograph>)
          5338  => 16#6F05#,   --  漅 (<CJK Ideograph>)
          5339  => 16#6F07#,   --  漇 (<CJK Ideograph>)
          5340  => 16#6F08#,   --  漈 (<CJK Ideograph>)
          5341  => 16#6F0A#,   --  漊 (<CJK Ideograph>)
          5342  => 16#6F0B#,   --  漋 (<CJK Ideograph>)
          5343  => 16#6F0C#,   --  漌 (<CJK Ideograph>)
          5344  => 16#6F0D#,   --  漍 (<CJK Ideograph>)
          5345  => 16#6F0E#,   --  漎 (<CJK Ideograph>)
          5346  => 16#6F10#,   --  漐 (<CJK Ideograph>)
          5347  => 16#6F11#,   --  漑 (<CJK Ideograph>)
          5348  => 16#6F12#,   --  漒 (<CJK Ideograph>)
          5349  => 16#6F16#,   --  漖 (<CJK Ideograph>)
          5350  => 16#6F17#,   --  漗 (<CJK Ideograph>)
          5351  => 16#6F18#,   --  漘 (<CJK Ideograph>)
          5352  => 16#6F19#,   --  漙 (<CJK Ideograph>)
          5353  => 16#6F1A#,   --  漚 (<CJK Ideograph>)
          5354  => 16#6F1B#,   --  漛 (<CJK Ideograph>)
          5355  => 16#6F1C#,   --  漜 (<CJK Ideograph>)
          5356  => 16#6F1D#,   --  漝 (<CJK Ideograph>)
          5357  => 16#6F1E#,   --  漞 (<CJK Ideograph>)
          5358  => 16#6F1F#,   --  漟 (<CJK Ideograph>)
          5359  => 16#6F21#,   --  漡 (<CJK Ideograph>)
          5360  => 16#6F22#,   --  漢 (<CJK Ideograph>)
          5361  => 16#6F23#,   --  漣 (<CJK Ideograph>)
          5362  => 16#6F25#,   --  漥 (<CJK Ideograph>)
          5363  => 16#6F26#,   --  漦 (<CJK Ideograph>)
          5364  => 16#6F27#,   --  漧 (<CJK Ideograph>)
          5365  => 16#6F28#,   --  漨 (<CJK Ideograph>)
          5366  => 16#6F2C#,   --  漬 (<CJK Ideograph>)
          5367  => 16#6F2E#,   --  漮 (<CJK Ideograph>)
          5368  => 16#6F30#,   --  漰 (<CJK Ideograph>)
          5369  => 16#6F32#,   --  漲 (<CJK Ideograph>)
          5370  => 16#6F34#,   --  漴 (<CJK Ideograph>)
          5371  => 16#6F35#,   --  漵 (<CJK Ideograph>)
          5372  => 16#6F37#,   --  漷 (<CJK Ideograph>)
          5373  => 16#6F38#,   --  漸 (<CJK Ideograph>)
          5374  => 16#6F39#,   --  漹 (<CJK Ideograph>)
          5375  => 16#6F3A#,   --  漺 (<CJK Ideograph>)
          5376  => 16#6F3B#,   --  漻 (<CJK Ideograph>)
          5377  => 16#6F3C#,   --  漼 (<CJK Ideograph>)
          5378  => 16#6F3D#,   --  漽 (<CJK Ideograph>)
          5379  => 16#6F3F#,   --  漿 (<CJK Ideograph>)
          5380  => 16#6F40#,   --  潀 (<CJK Ideograph>)
          5381  => 16#6F41#,   --  潁 (<CJK Ideograph>)
          5382  => 16#6F42#,   --  潂 (<CJK Ideograph>)
          5383  => 16#6F43#,   --  潃 (<CJK Ideograph>)
          5384  => 16#6F44#,   --  潄 (<CJK Ideograph>)
          5385  => 16#6F45#,   --  潅 (<CJK Ideograph>)
          5386  => 16#6F48#,   --  潈 (<CJK Ideograph>)
          5387  => 16#6F49#,   --  潉 (<CJK Ideograph>)
          5388  => 16#6F4A#,   --  潊 (<CJK Ideograph>)
          5389  => 16#6F4C#,   --  潌 (<CJK Ideograph>)
          5390  => 16#6F4E#,   --  潎 (<CJK Ideograph>)
          5391  => 16#6F4F#,   --  潏 (<CJK Ideograph>)
          5392  => 16#6F50#,   --  潐 (<CJK Ideograph>)
          5393  => 16#6F51#,   --  潑 (<CJK Ideograph>)
          5394  => 16#6F52#,   --  潒 (<CJK Ideograph>)
          5395  => 16#6F53#,   --  潓 (<CJK Ideograph>)
          5396  => 16#6F54#,   --  潔 (<CJK Ideograph>)
          5397  => 16#6F55#,   --  潕 (<CJK Ideograph>)
          5398  => 16#6F56#,   --  潖 (<CJK Ideograph>)
          5399  => 16#6F57#,   --  潗 (<CJK Ideograph>)
          5400  => 16#6F59#,   --  潙 (<CJK Ideograph>)
          5401  => 16#6F5A#,   --  潚 (<CJK Ideograph>)
          5402  => 16#6F5B#,   --  潛 (<CJK Ideograph>)
          5403  => 16#6F5D#,   --  潝 (<CJK Ideograph>)
          5404  => 16#6F5F#,   --  潟 (<CJK Ideograph>)
          5405  => 16#6F60#,   --  潠 (<CJK Ideograph>)
          5406  => 16#6F61#,   --  潡 (<CJK Ideograph>)
          5407  => 16#6F63#,   --  潣 (<CJK Ideograph>)
          5408  => 16#6F64#,   --  潤 (<CJK Ideograph>)
          5409  => 16#6F65#,   --  潥 (<CJK Ideograph>)
          5410  => 16#6F67#,   --  潧 (<CJK Ideograph>)
          5411  => 16#6F68#,   --  潨 (<CJK Ideograph>)
          5412  => 16#6F69#,   --  潩 (<CJK Ideograph>)
          5413  => 16#6F6A#,   --  潪 (<CJK Ideograph>)
          5414  => 16#6F6B#,   --  潫 (<CJK Ideograph>)
          5415  => 16#6F6C#,   --  潬 (<CJK Ideograph>)
          5416  => 16#6F6F#,   --  潯 (<CJK Ideograph>)
          5417  => 16#6F70#,   --  潰 (<CJK Ideograph>)
          5418  => 16#6F71#,   --  潱 (<CJK Ideograph>)
          5419  => 16#6F73#,   --  潳 (<CJK Ideograph>)
          5420  => 16#6F75#,   --  潵 (<CJK Ideograph>)
          5421  => 16#6F76#,   --  潶 (<CJK Ideograph>)
          5422  => 16#6F77#,   --  潷 (<CJK Ideograph>)
          5423  => 16#6F79#,   --  潹 (<CJK Ideograph>)
          5424  => 16#6F7B#,   --  潻 (<CJK Ideograph>)
          5425  => 16#6F7D#,   --  潽 (<CJK Ideograph>)
          5426  => 16#6F7E#,   --  潾 (<CJK Ideograph>)
          5427  => 16#6F7F#,   --  潿 (<CJK Ideograph>)
          5428  => 16#6F80#,   --  澀 (<CJK Ideograph>)
          5429  => 16#6F81#,   --  澁 (<CJK Ideograph>)
          5430  => 16#6F82#,   --  澂 (<CJK Ideograph>)
          5431  => 16#6F83#,   --  澃 (<CJK Ideograph>)
          5432  => 16#6F85#,   --  澅 (<CJK Ideograph>)
          5433  => 16#6F86#,   --  澆 (<CJK Ideograph>)
          5434  => 16#6F87#,   --  澇 (<CJK Ideograph>)
          5435  => 16#6F8A#,   --  澊 (<CJK Ideograph>)
          5436  => 16#6F8B#,   --  澋 (<CJK Ideograph>)
          5437  => 16#6F8F#,   --  澏 (<CJK Ideograph>)
          5438  => 16#6F90#,   --  澐 (<CJK Ideograph>)
          5439  => 16#6F91#,   --  澑 (<CJK Ideograph>)
          5440  => 16#6F92#,   --  澒 (<CJK Ideograph>)
          5441  => 16#6F93#,   --  澓 (<CJK Ideograph>)
          5442  => 16#6F94#,   --  澔 (<CJK Ideograph>)
          5443  => 16#6F95#,   --  澕 (<CJK Ideograph>)
          5444  => 16#6F96#,   --  澖 (<CJK Ideograph>)
          5445  => 16#6F97#,   --  澗 (<CJK Ideograph>)
          5446  => 16#6F98#,   --  澘 (<CJK Ideograph>)
          5447  => 16#6F99#,   --  澙 (<CJK Ideograph>)
          5448  => 16#6F9A#,   --  澚 (<CJK Ideograph>)
          5449  => 16#6F9B#,   --  澛 (<CJK Ideograph>)
          5450  => 16#6F9D#,   --  澝 (<CJK Ideograph>)
          5451  => 16#6F9E#,   --  澞 (<CJK Ideograph>)
          5452  => 16#6F9F#,   --  澟 (<CJK Ideograph>)
          5453  => 16#6FA0#,   --  澠 (<CJK Ideograph>)
          5454  => 16#6FA2#,   --  澢 (<CJK Ideograph>)
          5455  => 16#6FA3#,   --  澣 (<CJK Ideograph>)
          5456  => 16#6FA4#,   --  澤 (<CJK Ideograph>)
          5457  => 16#6FA5#,   --  澥 (<CJK Ideograph>)
          5458  => 16#6FA6#,   --  澦 (<CJK Ideograph>)
          5459  => 16#6FA8#,   --  澨 (<CJK Ideograph>)
          5460  => 16#6FA9#,   --  澩 (<CJK Ideograph>)
          5461  => 16#6FAA#,   --  澪 (<CJK Ideograph>)
          5462  => 16#6FAB#,   --  澫 (<CJK Ideograph>)
          5463  => 16#6FAC#,   --  澬 (<CJK Ideograph>)
          5464  => 16#6FAD#,   --  澭 (<CJK Ideograph>)
          5465  => 16#6FAE#,   --  澮 (<CJK Ideograph>)
          5466  => 16#6FAF#,   --  澯 (<CJK Ideograph>)
          5467  => 16#6FB0#,   --  澰 (<CJK Ideograph>)
          5468  => 16#6FB1#,   --  澱 (<CJK Ideograph>)
          5469  => 16#6FB2#,   --  澲 (<CJK Ideograph>)
          5470  => 16#6FB4#,   --  澴 (<CJK Ideograph>)
          5471  => 16#6FB5#,   --  澵 (<CJK Ideograph>)
          5472  => 16#6FB7#,   --  澷 (<CJK Ideograph>)
          5473  => 16#6FB8#,   --  澸 (<CJK Ideograph>)
          5474  => 16#6FBA#,   --  澺 (<CJK Ideograph>)
          5475  => 16#6FBB#,   --  澻 (<CJK Ideograph>)
          5476  => 16#6FBC#,   --  澼 (<CJK Ideograph>)
          5477  => 16#6FBD#,   --  澽 (<CJK Ideograph>)
          5478  => 16#6FBE#,   --  澾 (<CJK Ideograph>)
          5479  => 16#6FBF#,   --  澿 (<CJK Ideograph>)
          5480  => 16#6FC1#,   --  濁 (<CJK Ideograph>)
          5481  => 16#6FC3#,   --  濃 (<CJK Ideograph>)
          5482  => 16#6FC4#,   --  濄 (<CJK Ideograph>)
          5483  => 16#6FC5#,   --  濅 (<CJK Ideograph>)
          5484  => 16#6FC6#,   --  濆 (<CJK Ideograph>)
          5485  => 16#6FC7#,   --  濇 (<CJK Ideograph>)
          5486  => 16#6FC8#,   --  濈 (<CJK Ideograph>)
          5487  => 16#6FCA#,   --  濊 (<CJK Ideograph>)
          5488  => 16#6FCB#,   --  濋 (<CJK Ideograph>)
          5489  => 16#6FCC#,   --  濌 (<CJK Ideograph>)
          5490  => 16#6FCD#,   --  濍 (<CJK Ideograph>)
          5491  => 16#6FCE#,   --  濎 (<CJK Ideograph>)
          5492  => 16#6FCF#,   --  濏 (<CJK Ideograph>)
          5493  => 16#6FD0#,   --  濐 (<CJK Ideograph>)
          5494  => 16#6FD3#,   --  濓 (<CJK Ideograph>)
          5495  => 16#6FD4#,   --  濔 (<CJK Ideograph>)
          5496  => 16#6FD5#,   --  濕 (<CJK Ideograph>)
          5497  => 16#6FD6#,   --  濖 (<CJK Ideograph>)
          5498  => 16#6FD7#,   --  濗 (<CJK Ideograph>)
          5499  => 16#6FD8#,   --  濘 (<CJK Ideograph>)
          5500  => 16#6FD9#,   --  濙 (<CJK Ideograph>)
          5501  => 16#6FDA#,   --  濚 (<CJK Ideograph>)
          5502  => 16#6FDB#,   --  濛 (<CJK Ideograph>)
          5503  => 16#6FDC#,   --  濜 (<CJK Ideograph>)
          5504  => 16#6FDD#,   --  濝 (<CJK Ideograph>)
          5505  => 16#6FDF#,   --  濟 (<CJK Ideograph>)
          5506  => 16#6FE2#,   --  濢 (<CJK Ideograph>)
          5507  => 16#6FE3#,   --  濣 (<CJK Ideograph>)
          5508  => 16#6FE4#,   --  濤 (<CJK Ideograph>)
          5509  => 16#6FE5#,   --  濥 (<CJK Ideograph>)
          5510  => 16#6FE6#,   --  濦 (<CJK Ideograph>)
          5511  => 16#6FE7#,   --  濧 (<CJK Ideograph>)
          5512  => 16#6FE8#,   --  濨 (<CJK Ideograph>)
          5513  => 16#6FE9#,   --  濩 (<CJK Ideograph>)
          5514  => 16#6FEA#,   --  濪 (<CJK Ideograph>)
          5515  => 16#6FEB#,   --  濫 (<CJK Ideograph>)
          5516  => 16#6FEC#,   --  濬 (<CJK Ideograph>)
          5517  => 16#6FED#,   --  濭 (<CJK Ideograph>)
          5518  => 16#6FF0#,   --  濰 (<CJK Ideograph>)
          5519  => 16#6FF1#,   --  濱 (<CJK Ideograph>)
          5520  => 16#6FF2#,   --  濲 (<CJK Ideograph>)
          5521  => 16#6FF3#,   --  濳 (<CJK Ideograph>)
          5522  => 16#6FF4#,   --  濴 (<CJK Ideograph>)
          5523  => 16#6FF5#,   --  濵 (<CJK Ideograph>)
          5524  => 16#6FF6#,   --  濶 (<CJK Ideograph>)
          5525  => 16#6FF7#,   --  濷 (<CJK Ideograph>)
          5526  => 16#6FF8#,   --  濸 (<CJK Ideograph>)
          5527  => 16#6FF9#,   --  濹 (<CJK Ideograph>)
          5528  => 16#6FFA#,   --  濺 (<CJK Ideograph>)
          5529  => 16#6FFB#,   --  濻 (<CJK Ideograph>)
          5530  => 16#6FFC#,   --  濼 (<CJK Ideograph>)
          5531  => 16#6FFD#,   --  濽 (<CJK Ideograph>)
          5532  => 16#6FFE#,   --  濾 (<CJK Ideograph>)
          5533  => 16#6FFF#,   --  濿 (<CJK Ideograph>)
          5534  => 16#7000#,   --  瀀 (<CJK Ideograph>)
          5535  => 16#7001#,   --  瀁 (<CJK Ideograph>)
          5536  => 16#7002#,   --  瀂 (<CJK Ideograph>)
          5537  => 16#7003#,   --  瀃 (<CJK Ideograph>)
          5538  => 16#7004#,   --  瀄 (<CJK Ideograph>)
          5539  => 16#7005#,   --  瀅 (<CJK Ideograph>)
          5540  => 16#7006#,   --  瀆 (<CJK Ideograph>)
          5541  => 16#7007#,   --  瀇 (<CJK Ideograph>)
          5542  => 16#7008#,   --  瀈 (<CJK Ideograph>)
          5543  => 16#7009#,   --  瀉 (<CJK Ideograph>)
          5544  => 16#700A#,   --  瀊 (<CJK Ideograph>)
          5545  => 16#700B#,   --  瀋 (<CJK Ideograph>)
          5546  => 16#700C#,   --  瀌 (<CJK Ideograph>)
          5547  => 16#700D#,   --  瀍 (<CJK Ideograph>)
          5548  => 16#700E#,   --  瀎 (<CJK Ideograph>)
          5549  => 16#700F#,   --  瀏 (<CJK Ideograph>)
          5550  => 16#7010#,   --  瀐 (<CJK Ideograph>)
          5551  => 16#7012#,   --  瀒 (<CJK Ideograph>)
          5552  => 16#7013#,   --  瀓 (<CJK Ideograph>)
          5553  => 16#7014#,   --  瀔 (<CJK Ideograph>)
          5554  => 16#7015#,   --  瀕 (<CJK Ideograph>)
          5555  => 16#7016#,   --  瀖 (<CJK Ideograph>)
          5556  => 16#7017#,   --  瀗 (<CJK Ideograph>)
          5557  => 16#7018#,   --  瀘 (<CJK Ideograph>)
          5558  => 16#7019#,   --  瀙 (<CJK Ideograph>)
          5559  => 16#701C#,   --  瀜 (<CJK Ideograph>)
          5560  => 16#701D#,   --  瀝 (<CJK Ideograph>)
          5561  => 16#701E#,   --  瀞 (<CJK Ideograph>)
          5562  => 16#701F#,   --  瀟 (<CJK Ideograph>)
          5563  => 16#7020#,   --  瀠 (<CJK Ideograph>)
          5564  => 16#7021#,   --  瀡 (<CJK Ideograph>)
          5565  => 16#7022#,   --  瀢 (<CJK Ideograph>)
          5566  => 16#7024#,   --  瀤 (<CJK Ideograph>)
          5567  => 16#7025#,   --  瀥 (<CJK Ideograph>)
          5568  => 16#7026#,   --  瀦 (<CJK Ideograph>)
          5569  => 16#7027#,   --  瀧 (<CJK Ideograph>)
          5570  => 16#7028#,   --  瀨 (<CJK Ideograph>)
          5571  => 16#7029#,   --  瀩 (<CJK Ideograph>)
          5572  => 16#702A#,   --  瀪 (<CJK Ideograph>)
          5573  => 16#702B#,   --  瀫 (<CJK Ideograph>)
          5574  => 16#702C#,   --  瀬 (<CJK Ideograph>)
          5575  => 16#702D#,   --  瀭 (<CJK Ideograph>)
          5576  => 16#702E#,   --  瀮 (<CJK Ideograph>)
          5577  => 16#702F#,   --  瀯 (<CJK Ideograph>)
          5578  => 16#7030#,   --  瀰 (<CJK Ideograph>)
          5579  => 16#7031#,   --  瀱 (<CJK Ideograph>)
          5580  => 16#7032#,   --  瀲 (<CJK Ideograph>)
          5581  => 16#7033#,   --  瀳 (<CJK Ideograph>)
          5582  => 16#7034#,   --  瀴 (<CJK Ideograph>)
          5583  => 16#7036#,   --  瀶 (<CJK Ideograph>)
          5584  => 16#7037#,   --  瀷 (<CJK Ideograph>)
          5585  => 16#7038#,   --  瀸 (<CJK Ideograph>)
          5586  => 16#703A#,   --  瀺 (<CJK Ideograph>)
          5587  => 16#703B#,   --  瀻 (<CJK Ideograph>)
          5588  => 16#703C#,   --  瀼 (<CJK Ideograph>)
          5589  => 16#703D#,   --  瀽 (<CJK Ideograph>)
          5590  => 16#703E#,   --  瀾 (<CJK Ideograph>)
          5591  => 16#703F#,   --  瀿 (<CJK Ideograph>)
          5592  => 16#7040#,   --  灀 (<CJK Ideograph>)
          5593  => 16#7041#,   --  灁 (<CJK Ideograph>)
          5594  => 16#7042#,   --  灂 (<CJK Ideograph>)
          5595  => 16#7043#,   --  灃 (<CJK Ideograph>)
          5596  => 16#7044#,   --  灄 (<CJK Ideograph>)
          5597  => 16#7045#,   --  灅 (<CJK Ideograph>)
          5598  => 16#7046#,   --  灆 (<CJK Ideograph>)
          5599  => 16#7047#,   --  灇 (<CJK Ideograph>)
          5600  => 16#7048#,   --  灈 (<CJK Ideograph>)
          5601  => 16#7049#,   --  灉 (<CJK Ideograph>)
          5602  => 16#704A#,   --  灊 (<CJK Ideograph>)
          5603  => 16#704B#,   --  灋 (<CJK Ideograph>)
          5604  => 16#704D#,   --  灍 (<CJK Ideograph>)
          5605  => 16#704E#,   --  灎 (<CJK Ideograph>)
          5606  => 16#7050#,   --  灐 (<CJK Ideograph>)
          5607  => 16#7051#,   --  灑 (<CJK Ideograph>)
          5608  => 16#7052#,   --  灒 (<CJK Ideograph>)
          5609  => 16#7053#,   --  灓 (<CJK Ideograph>)
          5610  => 16#7054#,   --  灔 (<CJK Ideograph>)
          5611  => 16#7055#,   --  灕 (<CJK Ideograph>)
          5612  => 16#7056#,   --  灖 (<CJK Ideograph>)
          5613  => 16#7057#,   --  灗 (<CJK Ideograph>)
          5614  => 16#7058#,   --  灘 (<CJK Ideograph>)
          5615  => 16#7059#,   --  灙 (<CJK Ideograph>)
          5616  => 16#705A#,   --  灚 (<CJK Ideograph>)
          5617  => 16#705B#,   --  灛 (<CJK Ideograph>)
          5618  => 16#705C#,   --  灜 (<CJK Ideograph>)
          5619  => 16#705D#,   --  灝 (<CJK Ideograph>)
          5620  => 16#705F#,   --  灟 (<CJK Ideograph>)
          5621  => 16#7060#,   --  灠 (<CJK Ideograph>)
          5622  => 16#7061#,   --  灡 (<CJK Ideograph>)
          5623  => 16#7062#,   --  灢 (<CJK Ideograph>)
          5624  => 16#7063#,   --  灣 (<CJK Ideograph>)
          5625  => 16#7064#,   --  灤 (<CJK Ideograph>)
          5626  => 16#7065#,   --  灥 (<CJK Ideograph>)
          5627  => 16#7066#,   --  灦 (<CJK Ideograph>)
          5628  => 16#7067#,   --  灧 (<CJK Ideograph>)
          5629  => 16#7068#,   --  灨 (<CJK Ideograph>)
          5630  => 16#7069#,   --  灩 (<CJK Ideograph>)
          5631  => 16#706A#,   --  灪 (<CJK Ideograph>)
          5632  => 16#706E#,   --  灮 (<CJK Ideograph>)
          5633  => 16#7071#,   --  灱 (<CJK Ideograph>)
          5634  => 16#7072#,   --  灲 (<CJK Ideograph>)
          5635  => 16#7073#,   --  灳 (<CJK Ideograph>)
          5636  => 16#7074#,   --  灴 (<CJK Ideograph>)
          5637  => 16#7077#,   --  灷 (<CJK Ideograph>)
          5638  => 16#7079#,   --  灹 (<CJK Ideograph>)
          5639  => 16#707A#,   --  灺 (<CJK Ideograph>)
          5640  => 16#707B#,   --  灻 (<CJK Ideograph>)
          5641  => 16#707D#,   --  災 (<CJK Ideograph>)
          5642  => 16#7081#,   --  炁 (<CJK Ideograph>)
          5643  => 16#7082#,   --  炂 (<CJK Ideograph>)
          5644  => 16#7083#,   --  炃 (<CJK Ideograph>)
          5645  => 16#7084#,   --  炄 (<CJK Ideograph>)
          5646  => 16#7086#,   --  炆 (<CJK Ideograph>)
          5647  => 16#7087#,   --  炇 (<CJK Ideograph>)
          5648  => 16#7088#,   --  炈 (<CJK Ideograph>)
          5649  => 16#708B#,   --  炋 (<CJK Ideograph>)
          5650  => 16#708C#,   --  炌 (<CJK Ideograph>)
          5651  => 16#708D#,   --  炍 (<CJK Ideograph>)
          5652  => 16#708F#,   --  炏 (<CJK Ideograph>)
          5653  => 16#7090#,   --  炐 (<CJK Ideograph>)
          5654  => 16#7091#,   --  炑 (<CJK Ideograph>)
          5655  => 16#7093#,   --  炓 (<CJK Ideograph>)
          5656  => 16#7097#,   --  炗 (<CJK Ideograph>)
          5657  => 16#7098#,   --  炘 (<CJK Ideograph>)
          5658  => 16#709A#,   --  炚 (<CJK Ideograph>)
          5659  => 16#709B#,   --  炛 (<CJK Ideograph>)
          5660  => 16#709E#,   --  炞 (<CJK Ideograph>)
          5661  => 16#709F#,   --  炟 (<CJK Ideograph>)
          5662  => 16#70A0#,   --  炠 (<CJK Ideograph>)
          5663  => 16#70A1#,   --  炡 (<CJK Ideograph>)
          5664  => 16#70A2#,   --  炢 (<CJK Ideograph>)
          5665  => 16#70A3#,   --  炣 (<CJK Ideograph>)
          5666  => 16#70A4#,   --  炤 (<CJK Ideograph>)
          5667  => 16#70A5#,   --  炥 (<CJK Ideograph>)
          5668  => 16#70A6#,   --  炦 (<CJK Ideograph>)
          5669  => 16#70A7#,   --  炧 (<CJK Ideograph>)
          5670  => 16#70A8#,   --  炨 (<CJK Ideograph>)
          5671  => 16#70A9#,   --  炩 (<CJK Ideograph>)
          5672  => 16#70AA#,   --  炪 (<CJK Ideograph>)
          5673  => 16#70B0#,   --  炰 (<CJK Ideograph>)
          5674  => 16#70B2#,   --  炲 (<CJK Ideograph>)
          5675  => 16#70B4#,   --  炴 (<CJK Ideograph>)
          5676  => 16#70B5#,   --  炵 (<CJK Ideograph>)
          5677  => 16#70B6#,   --  炶 (<CJK Ideograph>)
          5678  => 16#70BA#,   --  為 (<CJK Ideograph>)
          5679  => 16#70BE#,   --  炾 (<CJK Ideograph>)
          5680  => 16#70BF#,   --  炿 (<CJK Ideograph>)
          5681  => 16#70C4#,   --  烄 (<CJK Ideograph>)
          5682  => 16#70C5#,   --  烅 (<CJK Ideograph>)
          5683  => 16#70C6#,   --  烆 (<CJK Ideograph>)
          5684  => 16#70C7#,   --  烇 (<CJK Ideograph>)
          5685  => 16#70C9#,   --  烉 (<CJK Ideograph>)
          5686  => 16#70CB#,   --  烋 (<CJK Ideograph>)
          5687  => 16#70CC#,   --  烌 (<CJK Ideograph>)
          5688  => 16#70CD#,   --  烍 (<CJK Ideograph>)
          5689  => 16#70CE#,   --  烎 (<CJK Ideograph>)
          5690  => 16#70CF#,   --  烏 (<CJK Ideograph>)
          5691  => 16#70D0#,   --  烐 (<CJK Ideograph>)
          5692  => 16#70D1#,   --  烑 (<CJK Ideograph>)
          5693  => 16#70D2#,   --  烒 (<CJK Ideograph>)
          5694  => 16#70D3#,   --  烓 (<CJK Ideograph>)
          5695  => 16#70D4#,   --  烔 (<CJK Ideograph>)
          5696  => 16#70D5#,   --  烕 (<CJK Ideograph>)
          5697  => 16#70D6#,   --  烖 (<CJK Ideograph>)
          5698  => 16#70D7#,   --  烗 (<CJK Ideograph>)
          5699  => 16#70DA#,   --  烚 (<CJK Ideograph>)
          5700  => 16#70DC#,   --  烜 (<CJK Ideograph>)
          5701  => 16#70DD#,   --  烝 (<CJK Ideograph>)
          5702  => 16#70DE#,   --  烞 (<CJK Ideograph>)
          5703  => 16#70E0#,   --  烠 (<CJK Ideograph>)
          5704  => 16#70E1#,   --  烡 (<CJK Ideograph>)
          5705  => 16#70E2#,   --  烢 (<CJK Ideograph>)
          5706  => 16#70E3#,   --  烣 (<CJK Ideograph>)
          5707  => 16#70E5#,   --  烥 (<CJK Ideograph>)
          5708  => 16#70EA#,   --  烪 (<CJK Ideograph>)
          5709  => 16#70EE#,   --  烮 (<CJK Ideograph>)
          5710  => 16#70F0#,   --  烰 (<CJK Ideograph>)
          5711  => 16#70F1#,   --  烱 (<CJK Ideograph>)
          5712  => 16#70F2#,   --  烲 (<CJK Ideograph>)
          5713  => 16#70F3#,   --  烳 (<CJK Ideograph>)
          5714  => 16#70F4#,   --  烴 (<CJK Ideograph>)
          5715  => 16#70F5#,   --  烵 (<CJK Ideograph>)
          5716  => 16#70F6#,   --  烶 (<CJK Ideograph>)
          5717  => 16#70F8#,   --  烸 (<CJK Ideograph>)
          5718  => 16#70FA#,   --  烺 (<CJK Ideograph>)
          5719  => 16#70FB#,   --  烻 (<CJK Ideograph>)
          5720  => 16#70FC#,   --  烼 (<CJK Ideograph>)
          5721  => 16#70FE#,   --  烾 (<CJK Ideograph>)
          5722  => 16#70FF#,   --  烿 (<CJK Ideograph>)
          5723  => 16#7100#,   --  焀 (<CJK Ideograph>)
          5724  => 16#7101#,   --  焁 (<CJK Ideograph>)
          5725  => 16#7102#,   --  焂 (<CJK Ideograph>)
          5726  => 16#7103#,   --  焃 (<CJK Ideograph>)
          5727  => 16#7104#,   --  焄 (<CJK Ideograph>)
          5728  => 16#7105#,   --  焅 (<CJK Ideograph>)
          5729  => 16#7106#,   --  焆 (<CJK Ideograph>)
          5730  => 16#7107#,   --  焇 (<CJK Ideograph>)
          5731  => 16#7108#,   --  焈 (<CJK Ideograph>)
          5732  => 16#710B#,   --  焋 (<CJK Ideograph>)
          5733  => 16#710C#,   --  焌 (<CJK Ideograph>)
          5734  => 16#710D#,   --  焍 (<CJK Ideograph>)
          5735  => 16#710E#,   --  焎 (<CJK Ideograph>)
          5736  => 16#710F#,   --  焏 (<CJK Ideograph>)
          5737  => 16#7111#,   --  焑 (<CJK Ideograph>)
          5738  => 16#7112#,   --  焒 (<CJK Ideograph>)
          5739  => 16#7114#,   --  焔 (<CJK Ideograph>)
          5740  => 16#7117#,   --  焗 (<CJK Ideograph>)
          5741  => 16#711B#,   --  焛 (<CJK Ideograph>)
          5742  => 16#711C#,   --  焜 (<CJK Ideograph>)
          5743  => 16#711D#,   --  焝 (<CJK Ideograph>)
          5744  => 16#711E#,   --  焞 (<CJK Ideograph>)
          5745  => 16#711F#,   --  焟 (<CJK Ideograph>)
          5746  => 16#7120#,   --  焠 (<CJK Ideograph>)
          5747  => 16#7121#,   --  無 (<CJK Ideograph>)
          5748  => 16#7122#,   --  焢 (<CJK Ideograph>)
          5749  => 16#7123#,   --  焣 (<CJK Ideograph>)
          5750  => 16#7124#,   --  焤 (<CJK Ideograph>)
          5751  => 16#7125#,   --  焥 (<CJK Ideograph>)
          5752  => 16#7127#,   --  焧 (<CJK Ideograph>)
          5753  => 16#7128#,   --  焨 (<CJK Ideograph>)
          5754  => 16#7129#,   --  焩 (<CJK Ideograph>)
          5755  => 16#712A#,   --  焪 (<CJK Ideograph>)
          5756  => 16#712B#,   --  焫 (<CJK Ideograph>)
          5757  => 16#712C#,   --  焬 (<CJK Ideograph>)
          5758  => 16#712D#,   --  焭 (<CJK Ideograph>)
          5759  => 16#712E#,   --  焮 (<CJK Ideograph>)
          5760  => 16#7132#,   --  焲 (<CJK Ideograph>)
          5761  => 16#7133#,   --  焳 (<CJK Ideograph>)
          5762  => 16#7134#,   --  焴 (<CJK Ideograph>)
          5763  => 16#7135#,   --  焵 (<CJK Ideograph>)
          5764  => 16#7137#,   --  焷 (<CJK Ideograph>)
          5765  => 16#7138#,   --  焸 (<CJK Ideograph>)
          5766  => 16#7139#,   --  焹 (<CJK Ideograph>)
          5767  => 16#713A#,   --  焺 (<CJK Ideograph>)
          5768  => 16#713B#,   --  焻 (<CJK Ideograph>)
          5769  => 16#713C#,   --  焼 (<CJK Ideograph>)
          5770  => 16#713D#,   --  焽 (<CJK Ideograph>)
          5771  => 16#713E#,   --  焾 (<CJK Ideograph>)
          5772  => 16#713F#,   --  焿 (<CJK Ideograph>)
          5773  => 16#7140#,   --  煀 (<CJK Ideograph>)
          5774  => 16#7141#,   --  煁 (<CJK Ideograph>)
          5775  => 16#7142#,   --  煂 (<CJK Ideograph>)
          5776  => 16#7143#,   --  煃 (<CJK Ideograph>)
          5777  => 16#7144#,   --  煄 (<CJK Ideograph>)
          5778  => 16#7146#,   --  煆 (<CJK Ideograph>)
          5779  => 16#7147#,   --  煇 (<CJK Ideograph>)
          5780  => 16#7148#,   --  煈 (<CJK Ideograph>)
          5781  => 16#7149#,   --  煉 (<CJK Ideograph>)
          5782  => 16#714B#,   --  煋 (<CJK Ideograph>)
          5783  => 16#714D#,   --  煍 (<CJK Ideograph>)
          5784  => 16#714F#,   --  煏 (<CJK Ideograph>)
          5785  => 16#7150#,   --  煐 (<CJK Ideograph>)
          5786  => 16#7151#,   --  煑 (<CJK Ideograph>)
          5787  => 16#7152#,   --  煒 (<CJK Ideograph>)
          5788  => 16#7153#,   --  煓 (<CJK Ideograph>)
          5789  => 16#7154#,   --  煔 (<CJK Ideograph>)
          5790  => 16#7155#,   --  煕 (<CJK Ideograph>)
          5791  => 16#7156#,   --  煖 (<CJK Ideograph>)
          5792  => 16#7157#,   --  煗 (<CJK Ideograph>)
          5793  => 16#7158#,   --  煘 (<CJK Ideograph>)
          5794  => 16#7159#,   --  煙 (<CJK Ideograph>)
          5795  => 16#715A#,   --  煚 (<CJK Ideograph>)
          5796  => 16#715B#,   --  煛 (<CJK Ideograph>)
          5797  => 16#715D#,   --  煝 (<CJK Ideograph>)
          5798  => 16#715F#,   --  煟 (<CJK Ideograph>)
          5799  => 16#7160#,   --  煠 (<CJK Ideograph>)
          5800  => 16#7161#,   --  煡 (<CJK Ideograph>)
          5801  => 16#7162#,   --  煢 (<CJK Ideograph>)
          5802  => 16#7163#,   --  煣 (<CJK Ideograph>)
          5803  => 16#7165#,   --  煥 (<CJK Ideograph>)
          5804  => 16#7169#,   --  煩 (<CJK Ideograph>)
          5805  => 16#716A#,   --  煪 (<CJK Ideograph>)
          5806  => 16#716B#,   --  煫 (<CJK Ideograph>)
          5807  => 16#716C#,   --  煬 (<CJK Ideograph>)
          5808  => 16#716D#,   --  煭 (<CJK Ideograph>)
          5809  => 16#716F#,   --  煯 (<CJK Ideograph>)
          5810  => 16#7170#,   --  煰 (<CJK Ideograph>)
          5811  => 16#7171#,   --  煱 (<CJK Ideograph>)
          5812  => 16#7174#,   --  煴 (<CJK Ideograph>)
          5813  => 16#7175#,   --  煵 (<CJK Ideograph>)
          5814  => 16#7176#,   --  煶 (<CJK Ideograph>)
          5815  => 16#7177#,   --  煷 (<CJK Ideograph>)
          5816  => 16#7179#,   --  煹 (<CJK Ideograph>)
          5817  => 16#717B#,   --  煻 (<CJK Ideograph>)
          5818  => 16#717C#,   --  煼 (<CJK Ideograph>)
          5819  => 16#717E#,   --  煾 (<CJK Ideograph>)
          5820  => 16#717F#,   --  煿 (<CJK Ideograph>)
          5821  => 16#7180#,   --  熀 (<CJK Ideograph>)
          5822  => 16#7181#,   --  熁 (<CJK Ideograph>)
          5823  => 16#7182#,   --  熂 (<CJK Ideograph>)
          5824  => 16#7183#,   --  熃 (<CJK Ideograph>)
          5825  => 16#7185#,   --  熅 (<CJK Ideograph>)
          5826  => 16#7186#,   --  熆 (<CJK Ideograph>)
          5827  => 16#7187#,   --  熇 (<CJK Ideograph>)
          5828  => 16#7188#,   --  熈 (<CJK Ideograph>)
          5829  => 16#7189#,   --  熉 (<CJK Ideograph>)
          5830  => 16#718B#,   --  熋 (<CJK Ideograph>)
          5831  => 16#718C#,   --  熌 (<CJK Ideograph>)
          5832  => 16#718D#,   --  熍 (<CJK Ideograph>)
          5833  => 16#718E#,   --  熎 (<CJK Ideograph>)
          5834  => 16#7190#,   --  熐 (<CJK Ideograph>)
          5835  => 16#7191#,   --  熑 (<CJK Ideograph>)
          5836  => 16#7192#,   --  熒 (<CJK Ideograph>)
          5837  => 16#7193#,   --  熓 (<CJK Ideograph>)
          5838  => 16#7195#,   --  熕 (<CJK Ideograph>)
          5839  => 16#7196#,   --  熖 (<CJK Ideograph>)
          5840  => 16#7197#,   --  熗 (<CJK Ideograph>)
          5841  => 16#719A#,   --  熚 (<CJK Ideograph>)
          5842  => 16#719B#,   --  熛 (<CJK Ideograph>)
          5843  => 16#719C#,   --  熜 (<CJK Ideograph>)
          5844  => 16#719D#,   --  熝 (<CJK Ideograph>)
          5845  => 16#719E#,   --  熞 (<CJK Ideograph>)
          5846  => 16#71A1#,   --  熡 (<CJK Ideograph>)
          5847  => 16#71A2#,   --  熢 (<CJK Ideograph>)
          5848  => 16#71A3#,   --  熣 (<CJK Ideograph>)
          5849  => 16#71A4#,   --  熤 (<CJK Ideograph>)
          5850  => 16#71A5#,   --  熥 (<CJK Ideograph>)
          5851  => 16#71A6#,   --  熦 (<CJK Ideograph>)
          5852  => 16#71A7#,   --  熧 (<CJK Ideograph>)
          5853  => 16#71A9#,   --  熩 (<CJK Ideograph>)
          5854  => 16#71AA#,   --  熪 (<CJK Ideograph>)
          5855  => 16#71AB#,   --  熫 (<CJK Ideograph>)
          5856  => 16#71AD#,   --  熭 (<CJK Ideograph>)
          5857  => 16#71AE#,   --  熮 (<CJK Ideograph>)
          5858  => 16#71AF#,   --  熯 (<CJK Ideograph>)
          5859  => 16#71B0#,   --  熰 (<CJK Ideograph>)
          5860  => 16#71B1#,   --  熱 (<CJK Ideograph>)
          5861  => 16#71B2#,   --  熲 (<CJK Ideograph>)
          5862  => 16#71B4#,   --  熴 (<CJK Ideograph>)
          5863  => 16#71B6#,   --  熶 (<CJK Ideograph>)
          5864  => 16#71B7#,   --  熷 (<CJK Ideograph>)
          5865  => 16#71B8#,   --  熸 (<CJK Ideograph>)
          5866  => 16#71BA#,   --  熺 (<CJK Ideograph>)
          5867  => 16#71BB#,   --  熻 (<CJK Ideograph>)
          5868  => 16#71BC#,   --  熼 (<CJK Ideograph>)
          5869  => 16#71BD#,   --  熽 (<CJK Ideograph>)
          5870  => 16#71BE#,   --  熾 (<CJK Ideograph>)
          5871  => 16#71BF#,   --  熿 (<CJK Ideograph>)
          5872  => 16#71C0#,   --  燀 (<CJK Ideograph>)
          5873  => 16#71C1#,   --  燁 (<CJK Ideograph>)
          5874  => 16#71C2#,   --  燂 (<CJK Ideograph>)
          5875  => 16#71C4#,   --  燄 (<CJK Ideograph>)
          5876  => 16#71C5#,   --  燅 (<CJK Ideograph>)
          5877  => 16#71C6#,   --  燆 (<CJK Ideograph>)
          5878  => 16#71C7#,   --  燇 (<CJK Ideograph>)
          5879  => 16#71C8#,   --  燈 (<CJK Ideograph>)
          5880  => 16#71C9#,   --  燉 (<CJK Ideograph>)
          5881  => 16#71CA#,   --  燊 (<CJK Ideograph>)
          5882  => 16#71CB#,   --  燋 (<CJK Ideograph>)
          5883  => 16#71CC#,   --  燌 (<CJK Ideograph>)
          5884  => 16#71CD#,   --  燍 (<CJK Ideograph>)
          5885  => 16#71CF#,   --  燏 (<CJK Ideograph>)
          5886  => 16#71D0#,   --  燐 (<CJK Ideograph>)
          5887  => 16#71D1#,   --  燑 (<CJK Ideograph>)
          5888  => 16#71D2#,   --  燒 (<CJK Ideograph>)
          5889  => 16#71D3#,   --  燓 (<CJK Ideograph>)
          5890  => 16#71D6#,   --  燖 (<CJK Ideograph>)
          5891  => 16#71D7#,   --  燗 (<CJK Ideograph>)
          5892  => 16#71D8#,   --  燘 (<CJK Ideograph>)
          5893  => 16#71D9#,   --  燙 (<CJK Ideograph>)
          5894  => 16#71DA#,   --  燚 (<CJK Ideograph>)
          5895  => 16#71DB#,   --  燛 (<CJK Ideograph>)
          5896  => 16#71DC#,   --  燜 (<CJK Ideograph>)
          5897  => 16#71DD#,   --  燝 (<CJK Ideograph>)
          5898  => 16#71DE#,   --  燞 (<CJK Ideograph>)
          5899  => 16#71DF#,   --  營 (<CJK Ideograph>)
          5900  => 16#71E1#,   --  燡 (<CJK Ideograph>)
          5901  => 16#71E2#,   --  燢 (<CJK Ideograph>)
          5902  => 16#71E3#,   --  燣 (<CJK Ideograph>)
          5903  => 16#71E4#,   --  燤 (<CJK Ideograph>)
          5904  => 16#71E6#,   --  燦 (<CJK Ideograph>)
          5905  => 16#71E8#,   --  燨 (<CJK Ideograph>)
          5906  => 16#71E9#,   --  燩 (<CJK Ideograph>)
          5907  => 16#71EA#,   --  燪 (<CJK Ideograph>)
          5908  => 16#71EB#,   --  燫 (<CJK Ideograph>)
          5909  => 16#71EC#,   --  燬 (<CJK Ideograph>)
          5910  => 16#71ED#,   --  燭 (<CJK Ideograph>)
          5911  => 16#71EF#,   --  燯 (<CJK Ideograph>)
          5912  => 16#71F0#,   --  燰 (<CJK Ideograph>)
          5913  => 16#71F1#,   --  燱 (<CJK Ideograph>)
          5914  => 16#71F2#,   --  燲 (<CJK Ideograph>)
          5915  => 16#71F3#,   --  燳 (<CJK Ideograph>)
          5916  => 16#71F4#,   --  燴 (<CJK Ideograph>)
          5917  => 16#71F5#,   --  燵 (<CJK Ideograph>)
          5918  => 16#71F6#,   --  燶 (<CJK Ideograph>)
          5919  => 16#71F7#,   --  燷 (<CJK Ideograph>)
          5920  => 16#71F8#,   --  燸 (<CJK Ideograph>)
          5921  => 16#71FA#,   --  燺 (<CJK Ideograph>)
          5922  => 16#71FB#,   --  燻 (<CJK Ideograph>)
          5923  => 16#71FC#,   --  燼 (<CJK Ideograph>)
          5924  => 16#71FD#,   --  燽 (<CJK Ideograph>)
          5925  => 16#71FE#,   --  燾 (<CJK Ideograph>)
          5926  => 16#71FF#,   --  燿 (<CJK Ideograph>)
          5927  => 16#7200#,   --  爀 (<CJK Ideograph>)
          5928  => 16#7201#,   --  爁 (<CJK Ideograph>)
          5929  => 16#7202#,   --  爂 (<CJK Ideograph>)
          5930  => 16#7203#,   --  爃 (<CJK Ideograph>)
          5931  => 16#7204#,   --  爄 (<CJK Ideograph>)
          5932  => 16#7205#,   --  爅 (<CJK Ideograph>)
          5933  => 16#7207#,   --  爇 (<CJK Ideograph>)
          5934  => 16#7208#,   --  爈 (<CJK Ideograph>)
          5935  => 16#7209#,   --  爉 (<CJK Ideograph>)
          5936  => 16#720A#,   --  爊 (<CJK Ideograph>)
          5937  => 16#720B#,   --  爋 (<CJK Ideograph>)
          5938  => 16#720C#,   --  爌 (<CJK Ideograph>)
          5939  => 16#720D#,   --  爍 (<CJK Ideograph>)
          5940  => 16#720E#,   --  爎 (<CJK Ideograph>)
          5941  => 16#720F#,   --  爏 (<CJK Ideograph>)
          5942  => 16#7210#,   --  爐 (<CJK Ideograph>)
          5943  => 16#7211#,   --  爑 (<CJK Ideograph>)
          5944  => 16#7212#,   --  爒 (<CJK Ideograph>)
          5945  => 16#7213#,   --  爓 (<CJK Ideograph>)
          5946  => 16#7214#,   --  爔 (<CJK Ideograph>)
          5947  => 16#7215#,   --  爕 (<CJK Ideograph>)
          5948  => 16#7216#,   --  爖 (<CJK Ideograph>)
          5949  => 16#7217#,   --  爗 (<CJK Ideograph>)
          5950  => 16#7218#,   --  爘 (<CJK Ideograph>)
          5951  => 16#7219#,   --  爙 (<CJK Ideograph>)
          5952  => 16#721A#,   --  爚 (<CJK Ideograph>)
          5953  => 16#721B#,   --  爛 (<CJK Ideograph>)
          5954  => 16#721C#,   --  爜 (<CJK Ideograph>)
          5955  => 16#721E#,   --  爞 (<CJK Ideograph>)
          5956  => 16#721F#,   --  爟 (<CJK Ideograph>)
          5957  => 16#7220#,   --  爠 (<CJK Ideograph>)
          5958  => 16#7221#,   --  爡 (<CJK Ideograph>)
          5959  => 16#7222#,   --  爢 (<CJK Ideograph>)
          5960  => 16#7223#,   --  爣 (<CJK Ideograph>)
          5961  => 16#7224#,   --  爤 (<CJK Ideograph>)
          5962  => 16#7225#,   --  爥 (<CJK Ideograph>)
          5963  => 16#7226#,   --  爦 (<CJK Ideograph>)
          5964  => 16#7227#,   --  爧 (<CJK Ideograph>)
          5965  => 16#7229#,   --  爩 (<CJK Ideograph>)
          5966  => 16#722B#,   --  爫 (<CJK Ideograph>)
          5967  => 16#722D#,   --  爭 (<CJK Ideograph>)
          5968  => 16#722E#,   --  爮 (<CJK Ideograph>)
          5969  => 16#722F#,   --  爯 (<CJK Ideograph>)
          5970  => 16#7232#,   --  爲 (<CJK Ideograph>)
          5971  => 16#7233#,   --  爳 (<CJK Ideograph>)
          5972  => 16#7234#,   --  爴 (<CJK Ideograph>)
          5973  => 16#723A#,   --  爺 (<CJK Ideograph>)
          5974  => 16#723C#,   --  爼 (<CJK Ideograph>)
          5975  => 16#723E#,   --  爾 (<CJK Ideograph>)
          5976  => 16#7240#,   --  牀 (<CJK Ideograph>)
          5977  => 16#7241#,   --  牁 (<CJK Ideograph>)
          5978  => 16#7242#,   --  牂 (<CJK Ideograph>)
          5979  => 16#7243#,   --  牃 (<CJK Ideograph>)
          5980  => 16#7244#,   --  牄 (<CJK Ideograph>)
          5981  => 16#7245#,   --  牅 (<CJK Ideograph>)
          5982  => 16#7246#,   --  牆 (<CJK Ideograph>)
          5983  => 16#7249#,   --  牉 (<CJK Ideograph>)
          5984  => 16#724A#,   --  牊 (<CJK Ideograph>)
          5985  => 16#724B#,   --  牋 (<CJK Ideograph>)
          5986  => 16#724E#,   --  牎 (<CJK Ideograph>)
          5987  => 16#724F#,   --  牏 (<CJK Ideograph>)
          5988  => 16#7250#,   --  牐 (<CJK Ideograph>)
          5989  => 16#7251#,   --  牑 (<CJK Ideograph>)
          5990  => 16#7253#,   --  牓 (<CJK Ideograph>)
          5991  => 16#7254#,   --  牔 (<CJK Ideograph>)
          5992  => 16#7255#,   --  牕 (<CJK Ideograph>)
          5993  => 16#7257#,   --  牗 (<CJK Ideograph>)
          5994  => 16#7258#,   --  牘 (<CJK Ideograph>)
          5995  => 16#725A#,   --  牚 (<CJK Ideograph>)
          5996  => 16#725C#,   --  牜 (<CJK Ideograph>)
          5997  => 16#725E#,   --  牞 (<CJK Ideograph>)
          5998  => 16#7260#,   --  牠 (<CJK Ideograph>)
          5999  => 16#7263#,   --  牣 (<CJK Ideograph>)
          6000  => 16#7264#,   --  牤 (<CJK Ideograph>)
          6001  => 16#7265#,   --  牥 (<CJK Ideograph>)
          6002  => 16#7268#,   --  牨 (<CJK Ideograph>)
          6003  => 16#726A#,   --  牪 (<CJK Ideograph>)
          6004  => 16#726B#,   --  牫 (<CJK Ideograph>)
          6005  => 16#726C#,   --  牬 (<CJK Ideograph>)
          6006  => 16#726D#,   --  牭 (<CJK Ideograph>)
          6007  => 16#7270#,   --  牰 (<CJK Ideograph>)
          6008  => 16#7271#,   --  牱 (<CJK Ideograph>)
          6009  => 16#7273#,   --  牳 (<CJK Ideograph>)
          6010  => 16#7274#,   --  牴 (<CJK Ideograph>)
          6011  => 16#7276#,   --  牶 (<CJK Ideograph>)
          6012  => 16#7277#,   --  牷 (<CJK Ideograph>)
          6013  => 16#7278#,   --  牸 (<CJK Ideograph>)
          6014  => 16#727B#,   --  牻 (<CJK Ideograph>)
          6015  => 16#727C#,   --  牼 (<CJK Ideograph>)
          6016  => 16#727D#,   --  牽 (<CJK Ideograph>)
          6017  => 16#7282#,   --  犂 (<CJK Ideograph>)
          6018  => 16#7283#,   --  犃 (<CJK Ideograph>)
          6019  => 16#7285#,   --  犅 (<CJK Ideograph>)
          6020  => 16#7286#,   --  犆 (<CJK Ideograph>)
          6021  => 16#7287#,   --  犇 (<CJK Ideograph>)
          6022  => 16#7288#,   --  犈 (<CJK Ideograph>)
          6023  => 16#7289#,   --  犉 (<CJK Ideograph>)
          6024  => 16#728C#,   --  犌 (<CJK Ideograph>)
          6025  => 16#728E#,   --  犎 (<CJK Ideograph>)
          6026  => 16#7290#,   --  犐 (<CJK Ideograph>)
          6027  => 16#7291#,   --  犑 (<CJK Ideograph>)
          6028  => 16#7293#,   --  犓 (<CJK Ideograph>)
          6029  => 16#7294#,   --  犔 (<CJK Ideograph>)
          6030  => 16#7295#,   --  犕 (<CJK Ideograph>)
          6031  => 16#7296#,   --  犖 (<CJK Ideograph>)
          6032  => 16#7297#,   --  犗 (<CJK Ideograph>)
          6033  => 16#7298#,   --  犘 (<CJK Ideograph>)
          6034  => 16#7299#,   --  犙 (<CJK Ideograph>)
          6035  => 16#729A#,   --  犚 (<CJK Ideograph>)
          6036  => 16#729B#,   --  犛 (<CJK Ideograph>)
          6037  => 16#729C#,   --  犜 (<CJK Ideograph>)
          6038  => 16#729D#,   --  犝 (<CJK Ideograph>)
          6039  => 16#729E#,   --  犞 (<CJK Ideograph>)
          6040  => 16#72A0#,   --  犠 (<CJK Ideograph>)
          6041  => 16#72A1#,   --  犡 (<CJK Ideograph>)
          6042  => 16#72A2#,   --  犢 (<CJK Ideograph>)
          6043  => 16#72A3#,   --  犣 (<CJK Ideograph>)
          6044  => 16#72A4#,   --  犤 (<CJK Ideograph>)
          6045  => 16#72A5#,   --  犥 (<CJK Ideograph>)
          6046  => 16#72A6#,   --  犦 (<CJK Ideograph>)
          6047  => 16#72A7#,   --  犧 (<CJK Ideograph>)
          6048  => 16#72A8#,   --  犨 (<CJK Ideograph>)
          6049  => 16#72A9#,   --  犩 (<CJK Ideograph>)
          6050  => 16#72AA#,   --  犪 (<CJK Ideograph>)
          6051  => 16#72AB#,   --  犫 (<CJK Ideograph>)
          6052  => 16#72AE#,   --  犮 (<CJK Ideograph>)
          6053  => 16#72B1#,   --  犱 (<CJK Ideograph>)
          6054  => 16#72B2#,   --  犲 (<CJK Ideograph>)
          6055  => 16#72B3#,   --  犳 (<CJK Ideograph>)
          6056  => 16#72B5#,   --  犵 (<CJK Ideograph>)
          6057  => 16#72BA#,   --  犺 (<CJK Ideograph>)
          6058  => 16#72BB#,   --  犻 (<CJK Ideograph>)
          6059  => 16#72BC#,   --  犼 (<CJK Ideograph>)
          6060  => 16#72BD#,   --  犽 (<CJK Ideograph>)
          6061  => 16#72BE#,   --  犾 (<CJK Ideograph>)
          6062  => 16#72BF#,   --  犿 (<CJK Ideograph>)
          6063  => 16#72C0#,   --  狀 (<CJK Ideograph>)
          6064  => 16#72C5#,   --  狅 (<CJK Ideograph>)
          6065  => 16#72C6#,   --  狆 (<CJK Ideograph>)
          6066  => 16#72C7#,   --  狇 (<CJK Ideograph>)
          6067  => 16#72C9#,   --  狉 (<CJK Ideograph>)
          6068  => 16#72CA#,   --  狊 (<CJK Ideograph>)
          6069  => 16#72CB#,   --  狋 (<CJK Ideograph>)
          6070  => 16#72CC#,   --  狌 (<CJK Ideograph>)
          6071  => 16#72CF#,   --  狏 (<CJK Ideograph>)
          6072  => 16#72D1#,   --  狑 (<CJK Ideograph>)
          6073  => 16#72D3#,   --  狓 (<CJK Ideograph>)
          6074  => 16#72D4#,   --  狔 (<CJK Ideograph>)
          6075  => 16#72D5#,   --  狕 (<CJK Ideograph>)
          6076  => 16#72D6#,   --  狖 (<CJK Ideograph>)
          6077  => 16#72D8#,   --  狘 (<CJK Ideograph>)
          6078  => 16#72DA#,   --  狚 (<CJK Ideograph>)
          6079  => 16#72DB#,   --  狛 (<CJK Ideograph>)
          6080  => 16#E4C6#,   --   (<Private Use>)
          6081  => 16#E4C7#,   --   (<Private Use>)
          6082  => 16#E4C8#,   --   (<Private Use>)
          6083  => 16#E4C9#,   --   (<Private Use>)
          6084  => 16#E4CA#,   --   (<Private Use>)
          6085  => 16#E4CB#,   --   (<Private Use>)
          6086  => 16#E4CC#,   --   (<Private Use>)
          6087  => 16#E4CD#,   --   (<Private Use>)
          6088  => 16#E4CE#,   --   (<Private Use>)
          6089  => 16#E4CF#,   --   (<Private Use>)
          6090  => 16#E4D0#,   --   (<Private Use>)
          6091  => 16#E4D1#,   --   (<Private Use>)
          6092  => 16#E4D2#,   --   (<Private Use>)
          6093  => 16#E4D3#,   --   (<Private Use>)
          6094  => 16#E4D4#,   --   (<Private Use>)
          6095  => 16#E4D5#,   --   (<Private Use>)
          6096  => 16#E4D6#,   --   (<Private Use>)
          6097  => 16#E4D7#,   --   (<Private Use>)
          6098  => 16#E4D8#,   --   (<Private Use>)
          6099  => 16#E4D9#,   --   (<Private Use>)
          6100  => 16#E4DA#,   --   (<Private Use>)
          6101  => 16#E4DB#,   --   (<Private Use>)
          6102  => 16#E4DC#,   --   (<Private Use>)
          6103  => 16#E4DD#,   --   (<Private Use>)
          6104  => 16#E4DE#,   --   (<Private Use>)
          6105  => 16#E4DF#,   --   (<Private Use>)
          6106  => 16#E4E0#,   --   (<Private Use>)
          6107  => 16#E4E1#,   --   (<Private Use>)
          6108  => 16#E4E2#,   --   (<Private Use>)
          6109  => 16#E4E3#,   --   (<Private Use>)
          6110  => 16#E4E4#,   --   (<Private Use>)
          6111  => 16#E4E5#,   --   (<Private Use>)
          6112  => 16#E4E6#,   --   (<Private Use>)
          6113  => 16#E4E7#,   --   (<Private Use>)
          6114  => 16#E4E8#,   --   (<Private Use>)
          6115  => 16#E4E9#,   --   (<Private Use>)
          6116  => 16#E4EA#,   --   (<Private Use>)
          6117  => 16#E4EB#,   --   (<Private Use>)
          6118  => 16#E4EC#,   --   (<Private Use>)
          6119  => 16#E4ED#,   --   (<Private Use>)
          6120  => 16#E4EE#,   --   (<Private Use>)
          6121  => 16#E4EF#,   --   (<Private Use>)
          6122  => 16#E4F0#,   --   (<Private Use>)
          6123  => 16#E4F1#,   --   (<Private Use>)
          6124  => 16#E4F2#,   --   (<Private Use>)
          6125  => 16#E4F3#,   --   (<Private Use>)
          6126  => 16#E4F4#,   --   (<Private Use>)
          6127  => 16#E4F5#,   --   (<Private Use>)
          6128  => 16#E4F6#,   --   (<Private Use>)
          6129  => 16#E4F7#,   --   (<Private Use>)
          6130  => 16#E4F8#,   --   (<Private Use>)
          6131  => 16#E4F9#,   --   (<Private Use>)
          6132  => 16#E4FA#,   --   (<Private Use>)
          6133  => 16#E4FB#,   --   (<Private Use>)
          6134  => 16#E4FC#,   --   (<Private Use>)
          6135  => 16#E4FD#,   --   (<Private Use>)
          6136  => 16#E4FE#,   --   (<Private Use>)
          6137  => 16#E4FF#,   --   (<Private Use>)
          6138  => 16#E500#,   --   (<Private Use>)
          6139  => 16#E501#,   --   (<Private Use>)
          6140  => 16#E502#,   --   (<Private Use>)
          6141  => 16#E503#,   --   (<Private Use>)
          6142  => 16#E504#,   --   (<Private Use>)
          6143  => 16#E505#,   --   (<Private Use>)
          6144  => 16#E506#,   --   (<Private Use>)
          6145  => 16#E507#,   --   (<Private Use>)
          6146  => 16#E508#,   --   (<Private Use>)
          6147  => 16#E509#,   --   (<Private Use>)
          6148  => 16#E50A#,   --   (<Private Use>)
          6149  => 16#E50B#,   --   (<Private Use>)
          6150  => 16#E50C#,   --   (<Private Use>)
          6151  => 16#E50D#,   --   (<Private Use>)
          6152  => 16#E50E#,   --   (<Private Use>)
          6153  => 16#E50F#,   --   (<Private Use>)
          6154  => 16#E510#,   --   (<Private Use>)
          6155  => 16#E511#,   --   (<Private Use>)
          6156  => 16#E512#,   --   (<Private Use>)
          6157  => 16#E513#,   --   (<Private Use>)
          6158  => 16#E514#,   --   (<Private Use>)
          6159  => 16#E515#,   --   (<Private Use>)
          6160  => 16#E516#,   --   (<Private Use>)
          6161  => 16#E517#,   --   (<Private Use>)
          6162  => 16#E518#,   --   (<Private Use>)
          6163  => 16#E519#,   --   (<Private Use>)
          6164  => 16#E51A#,   --   (<Private Use>)
          6165  => 16#E51B#,   --   (<Private Use>)
          6166  => 16#E51C#,   --   (<Private Use>)
          6167  => 16#E51D#,   --   (<Private Use>)
          6168  => 16#E51E#,   --   (<Private Use>)
          6169  => 16#E51F#,   --   (<Private Use>)
          6170  => 16#E520#,   --   (<Private Use>)
          6171  => 16#E521#,   --   (<Private Use>)
          6172  => 16#E522#,   --   (<Private Use>)
          6173  => 16#E523#,   --   (<Private Use>)
          6174  => 16#E524#,   --   (<Private Use>)
          6175  => 16#E525#,   --   (<Private Use>)
          6176  => 16#3000#,   --  　 (IDEOGRAPHIC SPACE)
          6177  => 16#3001#,   --  、 (IDEOGRAPHIC COMMA)
          6178  => 16#3002#,   --  。 (IDEOGRAPHIC FULL STOP)
          6179  => 16#00B7#,   --  · (MIDDLE DOT)
          6180  => 16#02C9#,   --  ˉ (MODIFIER LETTER MACRON)
          6181  => 16#02C7#,   --  ˇ (CARON)
          6182  => 16#00A8#,   --  ¨ (DIAERESIS)
          6183  => 16#3003#,   --  〃 (DITTO MARK)
          6184  => 16#3005#,   --  々 (IDEOGRAPHIC ITERATION MARK)
          6185  => 16#2014#,   --  — (EM DASH)
          6186  => 16#FF5E#,   --  ～ (FULLWIDTH TILDE)
          6187  => 16#2016#,   --  ‖ (DOUBLE VERTICAL LINE)
          6188  => 16#2026#,   --  … (HORIZONTAL ELLIPSIS)
          6189  => 16#2018#,   --  ‘ (LEFT SINGLE QUOTATION MARK)
          6190  => 16#2019#,   --  ’ (RIGHT SINGLE QUOTATION MARK)
          6191  => 16#201C#,   --  “ (LEFT DOUBLE QUOTATION MARK)
          6192  => 16#201D#,   --  ” (RIGHT DOUBLE QUOTATION MARK)
          6193  => 16#3014#,   --  〔 (LEFT TORTOISE SHELL BRACKET)
          6194  => 16#3015#,   --  〕 (RIGHT TORTOISE SHELL BRACKET)
          6195  => 16#3008#,   --  〈 (LEFT ANGLE BRACKET)
          6196  => 16#3009#,   --  〉 (RIGHT ANGLE BRACKET)
          6197  => 16#300A#,   --  《 (LEFT DOUBLE ANGLE BRACKET)
          6198  => 16#300B#,   --  》 (RIGHT DOUBLE ANGLE BRACKET)
          6199  => 16#300C#,   --  「 (LEFT CORNER BRACKET)
          6200  => 16#300D#,   --  」 (RIGHT CORNER BRACKET)
          6201  => 16#300E#,   --  『 (LEFT WHITE CORNER BRACKET)
          6202  => 16#300F#,   --  』 (RIGHT WHITE CORNER BRACKET)
          6203  => 16#3016#,   --  〖 (LEFT WHITE LENTICULAR BRACKET)
          6204  => 16#3017#,   --  〗 (RIGHT WHITE LENTICULAR BRACKET)
          6205  => 16#3010#,   --  【 (LEFT BLACK LENTICULAR BRACKET)
          6206  => 16#3011#,   --  】 (RIGHT BLACK LENTICULAR BRACKET)
          6207  => 16#00B1#,   --  ± (PLUS-MINUS SIGN)
          6208  => 16#00D7#,   --  × (MULTIPLICATION SIGN)
          6209  => 16#00F7#,   --  ÷ (DIVISION SIGN)
          6210  => 16#2236#,   --  ∶ (RATIO)
          6211  => 16#2227#,   --  ∧ (LOGICAL AND)
          6212  => 16#2228#,   --  ∨ (LOGICAL OR)
          6213  => 16#2211#,   --  ∑ (N-ARY SUMMATION)
          6214  => 16#220F#,   --  ∏ (N-ARY PRODUCT)
          6215  => 16#222A#,   --  ∪ (UNION)
          6216  => 16#2229#,   --  ∩ (INTERSECTION)
          6217  => 16#2208#,   --  ∈ (ELEMENT OF)
          6218  => 16#2237#,   --  ∷ (PROPORTION)
          6219  => 16#221A#,   --  √ (SQUARE ROOT)
          6220  => 16#22A5#,   --  ⊥ (UP TACK)
          6221  => 16#2225#,   --  ∥ (PARALLEL TO)
          6222  => 16#2220#,   --  ∠ (ANGLE)
          6223  => 16#2312#,   --  ⌒ (ARC)
          6224  => 16#2299#,   --  ⊙ (CIRCLED DOT OPERATOR)
          6225  => 16#222B#,   --  ∫ (INTEGRAL)
          6226  => 16#222E#,   --  ∮ (CONTOUR INTEGRAL)
          6227  => 16#2261#,   --  ≡ (IDENTICAL TO)
          6228  => 16#224C#,   --  ≌ (ALL EQUAL TO)
          6229  => 16#2248#,   --  ≈ (ALMOST EQUAL TO)
          6230  => 16#223D#,   --  ∽ (REVERSED TILDE)
          6231  => 16#221D#,   --  ∝ (PROPORTIONAL TO)
          6232  => 16#2260#,   --  ≠ (NOT EQUAL TO)
          6233  => 16#226E#,   --  ≮ (NOT LESS-THAN)
          6234  => 16#226F#,   --  ≯ (NOT GREATER-THAN)
          6235  => 16#2264#,   --  ≤ (LESS-THAN OR EQUAL TO)
          6236  => 16#2265#,   --  ≥ (GREATER-THAN OR EQUAL TO)
          6237  => 16#221E#,   --  ∞ (INFINITY)
          6238  => 16#2235#,   --  ∵ (BECAUSE)
          6239  => 16#2234#,   --  ∴ (THEREFORE)
          6240  => 16#2642#,   --  ♂ (MALE SIGN)
          6241  => 16#2640#,   --  ♀ (FEMALE SIGN)
          6242  => 16#00B0#,   --  ° (DEGREE SIGN)
          6243  => 16#2032#,   --  ′ (PRIME)
          6244  => 16#2033#,   --  ″ (DOUBLE PRIME)
          6245  => 16#2103#,   --  ℃ (DEGREE CELSIUS)
          6246  => 16#FF04#,   --  ＄ (FULLWIDTH DOLLAR SIGN)
          6247  => 16#00A4#,   --  ¤ (CURRENCY SIGN)
          6248  => 16#FFE0#,   --  ￠ (FULLWIDTH CENT SIGN)
          6249  => 16#FFE1#,   --  ￡ (FULLWIDTH POUND SIGN)
          6250  => 16#2030#,   --  ‰ (PER MILLE SIGN)
          6251  => 16#00A7#,   --  § (SECTION SIGN)
          6252  => 16#2116#,   --  № (NUMERO SIGN)
          6253  => 16#2606#,   --  ☆ (WHITE STAR)
          6254  => 16#2605#,   --  ★ (BLACK STAR)
          6255  => 16#25CB#,   --  ○ (WHITE CIRCLE)
          6256  => 16#25CF#,   --  ● (BLACK CIRCLE)
          6257  => 16#25CE#,   --  ◎ (BULLSEYE)
          6258  => 16#25C7#,   --  ◇ (WHITE DIAMOND)
          6259  => 16#25C6#,   --  ◆ (BLACK DIAMOND)
          6260  => 16#25A1#,   --  □ (WHITE SQUARE)
          6261  => 16#25A0#,   --  ■ (BLACK SQUARE)
          6262  => 16#25B3#,   --  △ (WHITE UP-POINTING TRIANGLE)
          6263  => 16#25B2#,   --  ▲ (BLACK UP-POINTING TRIANGLE)
          6264  => 16#203B#,   --  ※ (REFERENCE MARK)
          6265  => 16#2192#,   --  → (RIGHTWARDS ARROW)
          6266  => 16#2190#,   --  ← (LEFTWARDS ARROW)
          6267  => 16#2191#,   --  ↑ (UPWARDS ARROW)
          6268  => 16#2193#,   --  ↓ (DOWNWARDS ARROW)
          6269  => 16#3013#,   --  〓 (GETA MARK)
          6270  => 16#E526#,   --   (<Private Use>)
          6271  => 16#E527#,   --   (<Private Use>)
          6272  => 16#E528#,   --   (<Private Use>)
          6273  => 16#E529#,   --   (<Private Use>)
          6274  => 16#E52A#,   --   (<Private Use>)
          6275  => 16#E52B#,   --   (<Private Use>)
          6276  => 16#E52C#,   --   (<Private Use>)
          6277  => 16#E52D#,   --   (<Private Use>)
          6278  => 16#E52E#,   --   (<Private Use>)
          6279  => 16#E52F#,   --   (<Private Use>)
          6280  => 16#E530#,   --   (<Private Use>)
          6281  => 16#E531#,   --   (<Private Use>)
          6282  => 16#E532#,   --   (<Private Use>)
          6283  => 16#E533#,   --   (<Private Use>)
          6284  => 16#E534#,   --   (<Private Use>)
          6285  => 16#E535#,   --   (<Private Use>)
          6286  => 16#E536#,   --   (<Private Use>)
          6287  => 16#E537#,   --   (<Private Use>)
          6288  => 16#E538#,   --   (<Private Use>)
          6289  => 16#E539#,   --   (<Private Use>)
          6290  => 16#E53A#,   --   (<Private Use>)
          6291  => 16#E53B#,   --   (<Private Use>)
          6292  => 16#E53C#,   --   (<Private Use>)
          6293  => 16#E53D#,   --   (<Private Use>)
          6294  => 16#E53E#,   --   (<Private Use>)
          6295  => 16#E53F#,   --   (<Private Use>)
          6296  => 16#E540#,   --   (<Private Use>)
          6297  => 16#E541#,   --   (<Private Use>)
          6298  => 16#E542#,   --   (<Private Use>)
          6299  => 16#E543#,   --   (<Private Use>)
          6300  => 16#E544#,   --   (<Private Use>)
          6301  => 16#E545#,   --   (<Private Use>)
          6302  => 16#E546#,   --   (<Private Use>)
          6303  => 16#E547#,   --   (<Private Use>)
          6304  => 16#E548#,   --   (<Private Use>)
          6305  => 16#E549#,   --   (<Private Use>)
          6306  => 16#E54A#,   --   (<Private Use>)
          6307  => 16#E54B#,   --   (<Private Use>)
          6308  => 16#E54C#,   --   (<Private Use>)
          6309  => 16#E54D#,   --   (<Private Use>)
          6310  => 16#E54E#,   --   (<Private Use>)
          6311  => 16#E54F#,   --   (<Private Use>)
          6312  => 16#E550#,   --   (<Private Use>)
          6313  => 16#E551#,   --   (<Private Use>)
          6314  => 16#E552#,   --   (<Private Use>)
          6315  => 16#E553#,   --   (<Private Use>)
          6316  => 16#E554#,   --   (<Private Use>)
          6317  => 16#E555#,   --   (<Private Use>)
          6318  => 16#E556#,   --   (<Private Use>)
          6319  => 16#E557#,   --   (<Private Use>)
          6320  => 16#E558#,   --   (<Private Use>)
          6321  => 16#E559#,   --   (<Private Use>)
          6322  => 16#E55A#,   --   (<Private Use>)
          6323  => 16#E55B#,   --   (<Private Use>)
          6324  => 16#E55C#,   --   (<Private Use>)
          6325  => 16#E55D#,   --   (<Private Use>)
          6326  => 16#E55E#,   --   (<Private Use>)
          6327  => 16#E55F#,   --   (<Private Use>)
          6328  => 16#E560#,   --   (<Private Use>)
          6329  => 16#E561#,   --   (<Private Use>)
          6330  => 16#E562#,   --   (<Private Use>)
          6331  => 16#E563#,   --   (<Private Use>)
          6332  => 16#E564#,   --   (<Private Use>)
          6333  => 16#E565#,   --   (<Private Use>)
          6334  => 16#E566#,   --   (<Private Use>)
          6335  => 16#E567#,   --   (<Private Use>)
          6336  => 16#E568#,   --   (<Private Use>)
          6337  => 16#E569#,   --   (<Private Use>)
          6338  => 16#E56A#,   --   (<Private Use>)
          6339  => 16#E56B#,   --   (<Private Use>)
          6340  => 16#E56C#,   --   (<Private Use>)
          6341  => 16#E56D#,   --   (<Private Use>)
          6342  => 16#E56E#,   --   (<Private Use>)
          6343  => 16#E56F#,   --   (<Private Use>)
          6344  => 16#E570#,   --   (<Private Use>)
          6345  => 16#E571#,   --   (<Private Use>)
          6346  => 16#E572#,   --   (<Private Use>)
          6347  => 16#E573#,   --   (<Private Use>)
          6348  => 16#E574#,   --   (<Private Use>)
          6349  => 16#E575#,   --   (<Private Use>)
          6350  => 16#E576#,   --   (<Private Use>)
          6351  => 16#E577#,   --   (<Private Use>)
          6352  => 16#E578#,   --   (<Private Use>)
          6353  => 16#E579#,   --   (<Private Use>)
          6354  => 16#E57A#,   --   (<Private Use>)
          6355  => 16#E57B#,   --   (<Private Use>)
          6356  => 16#E57C#,   --   (<Private Use>)
          6357  => 16#E57D#,   --   (<Private Use>)
          6358  => 16#E57E#,   --   (<Private Use>)
          6359  => 16#E57F#,   --   (<Private Use>)
          6360  => 16#E580#,   --   (<Private Use>)
          6361  => 16#E581#,   --   (<Private Use>)
          6362  => 16#E582#,   --   (<Private Use>)
          6363  => 16#E583#,   --   (<Private Use>)
          6364  => 16#E584#,   --   (<Private Use>)
          6365  => 16#E585#,   --   (<Private Use>)
          6366  => 16#2170#,   --  ⅰ (SMALL ROMAN NUMERAL ONE)
          6367  => 16#2171#,   --  ⅱ (SMALL ROMAN NUMERAL TWO)
          6368  => 16#2172#,   --  ⅲ (SMALL ROMAN NUMERAL THREE)
          6369  => 16#2173#,   --  ⅳ (SMALL ROMAN NUMERAL FOUR)
          6370  => 16#2174#,   --  ⅴ (SMALL ROMAN NUMERAL FIVE)
          6371  => 16#2175#,   --  ⅵ (SMALL ROMAN NUMERAL SIX)
          6372  => 16#2176#,   --  ⅶ (SMALL ROMAN NUMERAL SEVEN)
          6373  => 16#2177#,   --  ⅷ (SMALL ROMAN NUMERAL EIGHT)
          6374  => 16#2178#,   --  ⅸ (SMALL ROMAN NUMERAL NINE)
          6375  => 16#2179#,   --  ⅹ (SMALL ROMAN NUMERAL TEN)
          6376  => 16#E766#,   --   (<Private Use>)
          6377  => 16#E767#,   --   (<Private Use>)
          6378  => 16#E768#,   --   (<Private Use>)
          6379  => 16#E769#,   --   (<Private Use>)
          6380  => 16#E76A#,   --   (<Private Use>)
          6381  => 16#E76B#,   --   (<Private Use>)
          6382  => 16#2488#,   --  ⒈ (DIGIT ONE FULL STOP)
          6383  => 16#2489#,   --  ⒉ (DIGIT TWO FULL STOP)
          6384  => 16#248A#,   --  ⒊ (DIGIT THREE FULL STOP)
          6385  => 16#248B#,   --  ⒋ (DIGIT FOUR FULL STOP)
          6386  => 16#248C#,   --  ⒌ (DIGIT FIVE FULL STOP)
          6387  => 16#248D#,   --  ⒍ (DIGIT SIX FULL STOP)
          6388  => 16#248E#,   --  ⒎ (DIGIT SEVEN FULL STOP)
          6389  => 16#248F#,   --  ⒏ (DIGIT EIGHT FULL STOP)
          6390  => 16#2490#,   --  ⒐ (DIGIT NINE FULL STOP)
          6391  => 16#2491#,   --  ⒑ (NUMBER TEN FULL STOP)
          6392  => 16#2492#,   --  ⒒ (NUMBER ELEVEN FULL STOP)
          6393  => 16#2493#,   --  ⒓ (NUMBER TWELVE FULL STOP)
          6394  => 16#2494#,   --  ⒔ (NUMBER THIRTEEN FULL STOP)
          6395  => 16#2495#,   --  ⒕ (NUMBER FOURTEEN FULL STOP)
          6396  => 16#2496#,   --  ⒖ (NUMBER FIFTEEN FULL STOP)
          6397  => 16#2497#,   --  ⒗ (NUMBER SIXTEEN FULL STOP)
          6398  => 16#2498#,   --  ⒘ (NUMBER SEVENTEEN FULL STOP)
          6399  => 16#2499#,   --  ⒙ (NUMBER EIGHTEEN FULL STOP)
          6400  => 16#249A#,   --  ⒚ (NUMBER NINETEEN FULL STOP)
          6401  => 16#249B#,   --  ⒛ (NUMBER TWENTY FULL STOP)
          6402  => 16#2474#,   --  ⑴ (PARENTHESIZED DIGIT ONE)
          6403  => 16#2475#,   --  ⑵ (PARENTHESIZED DIGIT TWO)
          6404  => 16#2476#,   --  ⑶ (PARENTHESIZED DIGIT THREE)
          6405  => 16#2477#,   --  ⑷ (PARENTHESIZED DIGIT FOUR)
          6406  => 16#2478#,   --  ⑸ (PARENTHESIZED DIGIT FIVE)
          6407  => 16#2479#,   --  ⑹ (PARENTHESIZED DIGIT SIX)
          6408  => 16#247A#,   --  ⑺ (PARENTHESIZED DIGIT SEVEN)
          6409  => 16#247B#,   --  ⑻ (PARENTHESIZED DIGIT EIGHT)
          6410  => 16#247C#,   --  ⑼ (PARENTHESIZED DIGIT NINE)
          6411  => 16#247D#,   --  ⑽ (PARENTHESIZED NUMBER TEN)
          6412  => 16#247E#,   --  ⑾ (PARENTHESIZED NUMBER ELEVEN)
          6413  => 16#247F#,   --  ⑿ (PARENTHESIZED NUMBER TWELVE)
          6414  => 16#2480#,   --  ⒀ (PARENTHESIZED NUMBER THIRTEEN)
          6415  => 16#2481#,   --  ⒁ (PARENTHESIZED NUMBER FOURTEEN)
          6416  => 16#2482#,   --  ⒂ (PARENTHESIZED NUMBER FIFTEEN)
          6417  => 16#2483#,   --  ⒃ (PARENTHESIZED NUMBER SIXTEEN)
          6418  => 16#2484#,   --  ⒄ (PARENTHESIZED NUMBER SEVENTEEN)
          6419  => 16#2485#,   --  ⒅ (PARENTHESIZED NUMBER EIGHTEEN)
          6420  => 16#2486#,   --  ⒆ (PARENTHESIZED NUMBER NINETEEN)
          6421  => 16#2487#,   --  ⒇ (PARENTHESIZED NUMBER TWENTY)
          6422  => 16#2460#,   --  ① (CIRCLED DIGIT ONE)
          6423  => 16#2461#,   --  ② (CIRCLED DIGIT TWO)
          6424  => 16#2462#,   --  ③ (CIRCLED DIGIT THREE)
          6425  => 16#2463#,   --  ④ (CIRCLED DIGIT FOUR)
          6426  => 16#2464#,   --  ⑤ (CIRCLED DIGIT FIVE)
          6427  => 16#2465#,   --  ⑥ (CIRCLED DIGIT SIX)
          6428  => 16#2466#,   --  ⑦ (CIRCLED DIGIT SEVEN)
          6429  => 16#2467#,   --  ⑧ (CIRCLED DIGIT EIGHT)
          6430  => 16#2468#,   --  ⑨ (CIRCLED DIGIT NINE)
          6431  => 16#2469#,   --  ⑩ (CIRCLED NUMBER TEN)
          6432  => 16#20AC#,   --  € (EURO SIGN)
          6433  => 16#E76D#,   --   (<Private Use>)
          6434  => 16#3220#,   --  ㈠ (PARENTHESIZED IDEOGRAPH ONE)
          6435  => 16#3221#,   --  ㈡ (PARENTHESIZED IDEOGRAPH TWO)
          6436  => 16#3222#,   --  ㈢ (PARENTHESIZED IDEOGRAPH THREE)
          6437  => 16#3223#,   --  ㈣ (PARENTHESIZED IDEOGRAPH FOUR)
          6438  => 16#3224#,   --  ㈤ (PARENTHESIZED IDEOGRAPH FIVE)
          6439  => 16#3225#,   --  ㈥ (PARENTHESIZED IDEOGRAPH SIX)
          6440  => 16#3226#,   --  ㈦ (PARENTHESIZED IDEOGRAPH SEVEN)
          6441  => 16#3227#,   --  ㈧ (PARENTHESIZED IDEOGRAPH EIGHT)
          6442  => 16#3228#,   --  ㈨ (PARENTHESIZED IDEOGRAPH NINE)
          6443  => 16#3229#,   --  ㈩ (PARENTHESIZED IDEOGRAPH TEN)
          6444  => 16#E76E#,   --   (<Private Use>)
          6445  => 16#E76F#,   --   (<Private Use>)
          6446  => 16#2160#,   --  Ⅰ (ROMAN NUMERAL ONE)
          6447  => 16#2161#,   --  Ⅱ (ROMAN NUMERAL TWO)
          6448  => 16#2162#,   --  Ⅲ (ROMAN NUMERAL THREE)
          6449  => 16#2163#,   --  Ⅳ (ROMAN NUMERAL FOUR)
          6450  => 16#2164#,   --  Ⅴ (ROMAN NUMERAL FIVE)
          6451  => 16#2165#,   --  Ⅵ (ROMAN NUMERAL SIX)
          6452  => 16#2166#,   --  Ⅶ (ROMAN NUMERAL SEVEN)
          6453  => 16#2167#,   --  Ⅷ (ROMAN NUMERAL EIGHT)
          6454  => 16#2168#,   --  Ⅸ (ROMAN NUMERAL NINE)
          6455  => 16#2169#,   --  Ⅹ (ROMAN NUMERAL TEN)
          6456  => 16#216A#,   --  Ⅺ (ROMAN NUMERAL ELEVEN)
          6457  => 16#216B#,   --  Ⅻ (ROMAN NUMERAL TWELVE)
          6458  => 16#E770#,   --   (<Private Use>)
          6459  => 16#E771#,   --   (<Private Use>)
          6460  => 16#E586#,   --   (<Private Use>)
          6461  => 16#E587#,   --   (<Private Use>)
          6462  => 16#E588#,   --   (<Private Use>)
          6463  => 16#E589#,   --   (<Private Use>)
          6464  => 16#E58A#,   --   (<Private Use>)
          6465  => 16#E58B#,   --   (<Private Use>)
          6466  => 16#E58C#,   --   (<Private Use>)
          6467  => 16#E58D#,   --   (<Private Use>)
          6468  => 16#E58E#,   --   (<Private Use>)
          6469  => 16#E58F#,   --   (<Private Use>)
          6470  => 16#E590#,   --   (<Private Use>)
          6471  => 16#E591#,   --   (<Private Use>)
          6472  => 16#E592#,   --   (<Private Use>)
          6473  => 16#E593#,   --   (<Private Use>)
          6474  => 16#E594#,   --   (<Private Use>)
          6475  => 16#E595#,   --   (<Private Use>)
          6476  => 16#E596#,   --   (<Private Use>)
          6477  => 16#E597#,   --   (<Private Use>)
          6478  => 16#E598#,   --   (<Private Use>)
          6479  => 16#E599#,   --   (<Private Use>)
          6480  => 16#E59A#,   --   (<Private Use>)
          6481  => 16#E59B#,   --   (<Private Use>)
          6482  => 16#E59C#,   --   (<Private Use>)
          6483  => 16#E59D#,   --   (<Private Use>)
          6484  => 16#E59E#,   --   (<Private Use>)
          6485  => 16#E59F#,   --   (<Private Use>)
          6486  => 16#E5A0#,   --   (<Private Use>)
          6487  => 16#E5A1#,   --   (<Private Use>)
          6488  => 16#E5A2#,   --   (<Private Use>)
          6489  => 16#E5A3#,   --   (<Private Use>)
          6490  => 16#E5A4#,   --   (<Private Use>)
          6491  => 16#E5A5#,   --   (<Private Use>)
          6492  => 16#E5A6#,   --   (<Private Use>)
          6493  => 16#E5A7#,   --   (<Private Use>)
          6494  => 16#E5A8#,   --   (<Private Use>)
          6495  => 16#E5A9#,   --   (<Private Use>)
          6496  => 16#E5AA#,   --   (<Private Use>)
          6497  => 16#E5AB#,   --   (<Private Use>)
          6498  => 16#E5AC#,   --   (<Private Use>)
          6499  => 16#E5AD#,   --   (<Private Use>)
          6500  => 16#E5AE#,   --   (<Private Use>)
          6501  => 16#E5AF#,   --   (<Private Use>)
          6502  => 16#E5B0#,   --   (<Private Use>)
          6503  => 16#E5B1#,   --   (<Private Use>)
          6504  => 16#E5B2#,   --   (<Private Use>)
          6505  => 16#E5B3#,   --   (<Private Use>)
          6506  => 16#E5B4#,   --   (<Private Use>)
          6507  => 16#E5B5#,   --   (<Private Use>)
          6508  => 16#E5B6#,   --   (<Private Use>)
          6509  => 16#E5B7#,   --   (<Private Use>)
          6510  => 16#E5B8#,   --   (<Private Use>)
          6511  => 16#E5B9#,   --   (<Private Use>)
          6512  => 16#E5BA#,   --   (<Private Use>)
          6513  => 16#E5BB#,   --   (<Private Use>)
          6514  => 16#E5BC#,   --   (<Private Use>)
          6515  => 16#E5BD#,   --   (<Private Use>)
          6516  => 16#E5BE#,   --   (<Private Use>)
          6517  => 16#E5BF#,   --   (<Private Use>)
          6518  => 16#E5C0#,   --   (<Private Use>)
          6519  => 16#E5C1#,   --   (<Private Use>)
          6520  => 16#E5C2#,   --   (<Private Use>)
          6521  => 16#E5C3#,   --   (<Private Use>)
          6522  => 16#E5C4#,   --   (<Private Use>)
          6523  => 16#E5C5#,   --   (<Private Use>)
          6524  => 16#E5C6#,   --   (<Private Use>)
          6525  => 16#E5C7#,   --   (<Private Use>)
          6526  => 16#E5C8#,   --   (<Private Use>)
          6527  => 16#E5C9#,   --   (<Private Use>)
          6528  => 16#E5CA#,   --   (<Private Use>)
          6529  => 16#E5CB#,   --   (<Private Use>)
          6530  => 16#E5CC#,   --   (<Private Use>)
          6531  => 16#E5CD#,   --   (<Private Use>)
          6532  => 16#E5CE#,   --   (<Private Use>)
          6533  => 16#E5CF#,   --   (<Private Use>)
          6534  => 16#E5D0#,   --   (<Private Use>)
          6535  => 16#E5D1#,   --   (<Private Use>)
          6536  => 16#E5D2#,   --   (<Private Use>)
          6537  => 16#E5D3#,   --   (<Private Use>)
          6538  => 16#E5D4#,   --   (<Private Use>)
          6539  => 16#E5D5#,   --   (<Private Use>)
          6540  => 16#E5D6#,   --   (<Private Use>)
          6541  => 16#E5D7#,   --   (<Private Use>)
          6542  => 16#E5D8#,   --   (<Private Use>)
          6543  => 16#E5D9#,   --   (<Private Use>)
          6544  => 16#E5DA#,   --   (<Private Use>)
          6545  => 16#E5DB#,   --   (<Private Use>)
          6546  => 16#E5DC#,   --   (<Private Use>)
          6547  => 16#E5DD#,   --   (<Private Use>)
          6548  => 16#E5DE#,   --   (<Private Use>)
          6549  => 16#E5DF#,   --   (<Private Use>)
          6550  => 16#E5E0#,   --   (<Private Use>)
          6551  => 16#E5E1#,   --   (<Private Use>)
          6552  => 16#E5E2#,   --   (<Private Use>)
          6553  => 16#E5E3#,   --   (<Private Use>)
          6554  => 16#E5E4#,   --   (<Private Use>)
          6555  => 16#3000#,   --  　 (IDEOGRAPHIC SPACE)
          6556  => 16#FF01#,   --  ！ (FULLWIDTH EXCLAMATION MARK)
          6557  => 16#FF02#,   --  ＂ (FULLWIDTH QUOTATION MARK)
          6558  => 16#FF03#,   --  ＃ (FULLWIDTH NUMBER SIGN)
          6559  => 16#FFE5#,   --  ￥ (FULLWIDTH YEN SIGN)
          6560  => 16#FF05#,   --  ％ (FULLWIDTH PERCENT SIGN)
          6561  => 16#FF06#,   --  ＆ (FULLWIDTH AMPERSAND)
          6562  => 16#FF07#,   --  ＇ (FULLWIDTH APOSTROPHE)
          6563  => 16#FF08#,   --  （ (FULLWIDTH LEFT PARENTHESIS)
          6564  => 16#FF09#,   --  ） (FULLWIDTH RIGHT PARENTHESIS)
          6565  => 16#FF0A#,   --  ＊ (FULLWIDTH ASTERISK)
          6566  => 16#FF0B#,   --  ＋ (FULLWIDTH PLUS SIGN)
          6567  => 16#FF0C#,   --  ， (FULLWIDTH COMMA)
          6568  => 16#FF0D#,   --  － (FULLWIDTH HYPHEN-MINUS)
          6569  => 16#FF0E#,   --  ． (FULLWIDTH FULL STOP)
          6570  => 16#FF0F#,   --  ／ (FULLWIDTH SOLIDUS)
          6571  => 16#FF10#,   --  ０ (FULLWIDTH DIGIT ZERO)
          6572  => 16#FF11#,   --  １ (FULLWIDTH DIGIT ONE)
          6573  => 16#FF12#,   --  ２ (FULLWIDTH DIGIT TWO)
          6574  => 16#FF13#,   --  ３ (FULLWIDTH DIGIT THREE)
          6575  => 16#FF14#,   --  ４ (FULLWIDTH DIGIT FOUR)
          6576  => 16#FF15#,   --  ５ (FULLWIDTH DIGIT FIVE)
          6577  => 16#FF16#,   --  ６ (FULLWIDTH DIGIT SIX)
          6578  => 16#FF17#,   --  ７ (FULLWIDTH DIGIT SEVEN)
          6579  => 16#FF18#,   --  ８ (FULLWIDTH DIGIT EIGHT)
          6580  => 16#FF19#,   --  ９ (FULLWIDTH DIGIT NINE)
          6581  => 16#FF1A#,   --  ： (FULLWIDTH COLON)
          6582  => 16#FF1B#,   --  ； (FULLWIDTH SEMICOLON)
          6583  => 16#FF1C#,   --  ＜ (FULLWIDTH LESS-THAN SIGN)
          6584  => 16#FF1D#,   --  ＝ (FULLWIDTH EQUALS SIGN)
          6585  => 16#FF1E#,   --  ＞ (FULLWIDTH GREATER-THAN SIGN)
          6586  => 16#FF1F#,   --  ？ (FULLWIDTH QUESTION MARK)
          6587  => 16#FF20#,   --  ＠ (FULLWIDTH COMMERCIAL AT)
          6588  => 16#FF21#,   --  Ａ (FULLWIDTH LATIN CAPITAL LETTER A)
          6589  => 16#FF22#,   --  Ｂ (FULLWIDTH LATIN CAPITAL LETTER B)
          6590  => 16#FF23#,   --  Ｃ (FULLWIDTH LATIN CAPITAL LETTER C)
          6591  => 16#FF24#,   --  Ｄ (FULLWIDTH LATIN CAPITAL LETTER D)
          6592  => 16#FF25#,   --  Ｅ (FULLWIDTH LATIN CAPITAL LETTER E)
          6593  => 16#FF26#,   --  Ｆ (FULLWIDTH LATIN CAPITAL LETTER F)
          6594  => 16#FF27#,   --  Ｇ (FULLWIDTH LATIN CAPITAL LETTER G)
          6595  => 16#FF28#,   --  Ｈ (FULLWIDTH LATIN CAPITAL LETTER H)
          6596  => 16#FF29#,   --  Ｉ (FULLWIDTH LATIN CAPITAL LETTER I)
          6597  => 16#FF2A#,   --  Ｊ (FULLWIDTH LATIN CAPITAL LETTER J)
          6598  => 16#FF2B#,   --  Ｋ (FULLWIDTH LATIN CAPITAL LETTER K)
          6599  => 16#FF2C#,   --  Ｌ (FULLWIDTH LATIN CAPITAL LETTER L)
          6600  => 16#FF2D#,   --  Ｍ (FULLWIDTH LATIN CAPITAL LETTER M)
          6601  => 16#FF2E#,   --  Ｎ (FULLWIDTH LATIN CAPITAL LETTER N)
          6602  => 16#FF2F#,   --  Ｏ (FULLWIDTH LATIN CAPITAL LETTER O)
          6603  => 16#FF30#,   --  Ｐ (FULLWIDTH LATIN CAPITAL LETTER P)
          6604  => 16#FF31#,   --  Ｑ (FULLWIDTH LATIN CAPITAL LETTER Q)
          6605  => 16#FF32#,   --  Ｒ (FULLWIDTH LATIN CAPITAL LETTER R)
          6606  => 16#FF33#,   --  Ｓ (FULLWIDTH LATIN CAPITAL LETTER S)
          6607  => 16#FF34#,   --  Ｔ (FULLWIDTH LATIN CAPITAL LETTER T)
          6608  => 16#FF35#,   --  Ｕ (FULLWIDTH LATIN CAPITAL LETTER U)
          6609  => 16#FF36#,   --  Ｖ (FULLWIDTH LATIN CAPITAL LETTER V)
          6610  => 16#FF37#,   --  Ｗ (FULLWIDTH LATIN CAPITAL LETTER W)
          6611  => 16#FF38#,   --  Ｘ (FULLWIDTH LATIN CAPITAL LETTER X)
          6612  => 16#FF39#,   --  Ｙ (FULLWIDTH LATIN CAPITAL LETTER Y)
          6613  => 16#FF3A#,   --  Ｚ (FULLWIDTH LATIN CAPITAL LETTER Z)
          6614  => 16#FF3B#,   --  ［ (FULLWIDTH LEFT SQUARE BRACKET)
          6615  => 16#FF3C#,   --  ＼ (FULLWIDTH REVERSE SOLIDUS)
          6616  => 16#FF3D#,   --  ］ (FULLWIDTH RIGHT SQUARE BRACKET)
          6617  => 16#FF3E#,   --  ＾ (FULLWIDTH CIRCUMFLEX ACCENT)
          6618  => 16#FF3F#,   --  ＿ (FULLWIDTH LOW LINE)
          6619  => 16#FF40#,   --  ｀ (FULLWIDTH GRAVE ACCENT)
          6620  => 16#FF41#,   --  ａ (FULLWIDTH LATIN SMALL LETTER A)
          6621  => 16#FF42#,   --  ｂ (FULLWIDTH LATIN SMALL LETTER B)
          6622  => 16#FF43#,   --  ｃ (FULLWIDTH LATIN SMALL LETTER C)
          6623  => 16#FF44#,   --  ｄ (FULLWIDTH LATIN SMALL LETTER D)
          6624  => 16#FF45#,   --  ｅ (FULLWIDTH LATIN SMALL LETTER E)
          6625  => 16#FF46#,   --  ｆ (FULLWIDTH LATIN SMALL LETTER F)
          6626  => 16#FF47#,   --  ｇ (FULLWIDTH LATIN SMALL LETTER G)
          6627  => 16#FF48#,   --  ｈ (FULLWIDTH LATIN SMALL LETTER H)
          6628  => 16#FF49#,   --  ｉ (FULLWIDTH LATIN SMALL LETTER I)
          6629  => 16#FF4A#,   --  ｊ (FULLWIDTH LATIN SMALL LETTER J)
          6630  => 16#FF4B#,   --  ｋ (FULLWIDTH LATIN SMALL LETTER K)
          6631  => 16#FF4C#,   --  ｌ (FULLWIDTH LATIN SMALL LETTER L)
          6632  => 16#FF4D#,   --  ｍ (FULLWIDTH LATIN SMALL LETTER M)
          6633  => 16#FF4E#,   --  ｎ (FULLWIDTH LATIN SMALL LETTER N)
          6634  => 16#FF4F#,   --  ｏ (FULLWIDTH LATIN SMALL LETTER O)
          6635  => 16#FF50#,   --  ｐ (FULLWIDTH LATIN SMALL LETTER P)
          6636  => 16#FF51#,   --  ｑ (FULLWIDTH LATIN SMALL LETTER Q)
          6637  => 16#FF52#,   --  ｒ (FULLWIDTH LATIN SMALL LETTER R)
          6638  => 16#FF53#,   --  ｓ (FULLWIDTH LATIN SMALL LETTER S)
          6639  => 16#FF54#,   --  ｔ (FULLWIDTH LATIN SMALL LETTER T)
          6640  => 16#FF55#,   --  ｕ (FULLWIDTH LATIN SMALL LETTER U)
          6641  => 16#FF56#,   --  ｖ (FULLWIDTH LATIN SMALL LETTER V)
          6642  => 16#FF57#,   --  ｗ (FULLWIDTH LATIN SMALL LETTER W)
          6643  => 16#FF58#,   --  ｘ (FULLWIDTH LATIN SMALL LETTER X)
          6644  => 16#FF59#,   --  ｙ (FULLWIDTH LATIN SMALL LETTER Y)
          6645  => 16#FF5A#,   --  ｚ (FULLWIDTH LATIN SMALL LETTER Z)
          6646  => 16#FF5B#,   --  ｛ (FULLWIDTH LEFT CURLY BRACKET)
          6647  => 16#FF5C#,   --  ｜ (FULLWIDTH VERTICAL LINE)
          6648  => 16#FF5D#,   --  ｝ (FULLWIDTH RIGHT CURLY BRACKET)
          6649  => 16#FFE3#,   --  ￣ (FULLWIDTH MACRON)
          6650  => 16#E5E6#,   --   (<Private Use>)
          6651  => 16#E5E7#,   --   (<Private Use>)
          6652  => 16#E5E8#,   --   (<Private Use>)
          6653  => 16#E5E9#,   --   (<Private Use>)
          6654  => 16#E5EA#,   --   (<Private Use>)
          6655  => 16#E5EB#,   --   (<Private Use>)
          6656  => 16#E5EC#,   --   (<Private Use>)
          6657  => 16#E5ED#,   --   (<Private Use>)
          6658  => 16#E5EE#,   --   (<Private Use>)
          6659  => 16#E5EF#,   --   (<Private Use>)
          6660  => 16#E5F0#,   --   (<Private Use>)
          6661  => 16#E5F1#,   --   (<Private Use>)
          6662  => 16#E5F2#,   --   (<Private Use>)
          6663  => 16#E5F3#,   --   (<Private Use>)
          6664  => 16#E5F4#,   --   (<Private Use>)
          6665  => 16#E5F5#,   --   (<Private Use>)
          6666  => 16#E5F6#,   --   (<Private Use>)
          6667  => 16#E5F7#,   --   (<Private Use>)
          6668  => 16#E5F8#,   --   (<Private Use>)
          6669  => 16#E5F9#,   --   (<Private Use>)
          6670  => 16#E5FA#,   --   (<Private Use>)
          6671  => 16#E5FB#,   --   (<Private Use>)
          6672  => 16#E5FC#,   --   (<Private Use>)
          6673  => 16#E5FD#,   --   (<Private Use>)
          6674  => 16#E5FE#,   --   (<Private Use>)
          6675  => 16#E5FF#,   --   (<Private Use>)
          6676  => 16#E600#,   --   (<Private Use>)
          6677  => 16#E601#,   --   (<Private Use>)
          6678  => 16#E602#,   --   (<Private Use>)
          6679  => 16#E603#,   --   (<Private Use>)
          6680  => 16#E604#,   --   (<Private Use>)
          6681  => 16#E605#,   --   (<Private Use>)
          6682  => 16#E606#,   --   (<Private Use>)
          6683  => 16#E607#,   --   (<Private Use>)
          6684  => 16#E608#,   --   (<Private Use>)
          6685  => 16#E609#,   --   (<Private Use>)
          6686  => 16#E60A#,   --   (<Private Use>)
          6687  => 16#E60B#,   --   (<Private Use>)
          6688  => 16#E60C#,   --   (<Private Use>)
          6689  => 16#E60D#,   --   (<Private Use>)
          6690  => 16#E60E#,   --   (<Private Use>)
          6691  => 16#E60F#,   --   (<Private Use>)
          6692  => 16#E610#,   --   (<Private Use>)
          6693  => 16#E611#,   --   (<Private Use>)
          6694  => 16#E612#,   --   (<Private Use>)
          6695  => 16#E613#,   --   (<Private Use>)
          6696  => 16#E614#,   --   (<Private Use>)
          6697  => 16#E615#,   --   (<Private Use>)
          6698  => 16#E616#,   --   (<Private Use>)
          6699  => 16#E617#,   --   (<Private Use>)
          6700  => 16#E618#,   --   (<Private Use>)
          6701  => 16#E619#,   --   (<Private Use>)
          6702  => 16#E61A#,   --   (<Private Use>)
          6703  => 16#E61B#,   --   (<Private Use>)
          6704  => 16#E61C#,   --   (<Private Use>)
          6705  => 16#E61D#,   --   (<Private Use>)
          6706  => 16#E61E#,   --   (<Private Use>)
          6707  => 16#E61F#,   --   (<Private Use>)
          6708  => 16#E620#,   --   (<Private Use>)
          6709  => 16#E621#,   --   (<Private Use>)
          6710  => 16#E622#,   --   (<Private Use>)
          6711  => 16#E623#,   --   (<Private Use>)
          6712  => 16#E624#,   --   (<Private Use>)
          6713  => 16#E625#,   --   (<Private Use>)
          6714  => 16#E626#,   --   (<Private Use>)
          6715  => 16#E627#,   --   (<Private Use>)
          6716  => 16#E628#,   --   (<Private Use>)
          6717  => 16#E629#,   --   (<Private Use>)
          6718  => 16#E62A#,   --   (<Private Use>)
          6719  => 16#E62B#,   --   (<Private Use>)
          6720  => 16#E62C#,   --   (<Private Use>)
          6721  => 16#E62D#,   --   (<Private Use>)
          6722  => 16#E62E#,   --   (<Private Use>)
          6723  => 16#E62F#,   --   (<Private Use>)
          6724  => 16#E630#,   --   (<Private Use>)
          6725  => 16#E631#,   --   (<Private Use>)
          6726  => 16#E632#,   --   (<Private Use>)
          6727  => 16#E633#,   --   (<Private Use>)
          6728  => 16#E634#,   --   (<Private Use>)
          6729  => 16#E635#,   --   (<Private Use>)
          6730  => 16#E636#,   --   (<Private Use>)
          6731  => 16#E637#,   --   (<Private Use>)
          6732  => 16#E638#,   --   (<Private Use>)
          6733  => 16#E639#,   --   (<Private Use>)
          6734  => 16#E63A#,   --   (<Private Use>)
          6735  => 16#E63B#,   --   (<Private Use>)
          6736  => 16#E63C#,   --   (<Private Use>)
          6737  => 16#E63D#,   --   (<Private Use>)
          6738  => 16#E63E#,   --   (<Private Use>)
          6739  => 16#E63F#,   --   (<Private Use>)
          6740  => 16#E640#,   --   (<Private Use>)
          6741  => 16#E641#,   --   (<Private Use>)
          6742  => 16#E642#,   --   (<Private Use>)
          6743  => 16#E643#,   --   (<Private Use>)
          6744  => 16#E644#,   --   (<Private Use>)
          6745  => 16#E645#,   --   (<Private Use>)
          6746  => 16#3041#,   --  ぁ (HIRAGANA LETTER SMALL A)
          6747  => 16#3042#,   --  あ (HIRAGANA LETTER A)
          6748  => 16#3043#,   --  ぃ (HIRAGANA LETTER SMALL I)
          6749  => 16#3044#,   --  い (HIRAGANA LETTER I)
          6750  => 16#3045#,   --  ぅ (HIRAGANA LETTER SMALL U)
          6751  => 16#3046#,   --  う (HIRAGANA LETTER U)
          6752  => 16#3047#,   --  ぇ (HIRAGANA LETTER SMALL E)
          6753  => 16#3048#,   --  え (HIRAGANA LETTER E)
          6754  => 16#3049#,   --  ぉ (HIRAGANA LETTER SMALL O)
          6755  => 16#304A#,   --  お (HIRAGANA LETTER O)
          6756  => 16#304B#,   --  か (HIRAGANA LETTER KA)
          6757  => 16#304C#,   --  が (HIRAGANA LETTER GA)
          6758  => 16#304D#,   --  き (HIRAGANA LETTER KI)
          6759  => 16#304E#,   --  ぎ (HIRAGANA LETTER GI)
          6760  => 16#304F#,   --  く (HIRAGANA LETTER KU)
          6761  => 16#3050#,   --  ぐ (HIRAGANA LETTER GU)
          6762  => 16#3051#,   --  け (HIRAGANA LETTER KE)
          6763  => 16#3052#,   --  げ (HIRAGANA LETTER GE)
          6764  => 16#3053#,   --  こ (HIRAGANA LETTER KO)
          6765  => 16#3054#,   --  ご (HIRAGANA LETTER GO)
          6766  => 16#3055#,   --  さ (HIRAGANA LETTER SA)
          6767  => 16#3056#,   --  ざ (HIRAGANA LETTER ZA)
          6768  => 16#3057#,   --  し (HIRAGANA LETTER SI)
          6769  => 16#3058#,   --  じ (HIRAGANA LETTER ZI)
          6770  => 16#3059#,   --  す (HIRAGANA LETTER SU)
          6771  => 16#305A#,   --  ず (HIRAGANA LETTER ZU)
          6772  => 16#305B#,   --  せ (HIRAGANA LETTER SE)
          6773  => 16#305C#,   --  ぜ (HIRAGANA LETTER ZE)
          6774  => 16#305D#,   --  そ (HIRAGANA LETTER SO)
          6775  => 16#305E#,   --  ぞ (HIRAGANA LETTER ZO)
          6776  => 16#305F#,   --  た (HIRAGANA LETTER TA)
          6777  => 16#3060#,   --  だ (HIRAGANA LETTER DA)
          6778  => 16#3061#,   --  ち (HIRAGANA LETTER TI)
          6779  => 16#3062#,   --  ぢ (HIRAGANA LETTER DI)
          6780  => 16#3063#,   --  っ (HIRAGANA LETTER SMALL TU)
          6781  => 16#3064#,   --  つ (HIRAGANA LETTER TU)
          6782  => 16#3065#,   --  づ (HIRAGANA LETTER DU)
          6783  => 16#3066#,   --  て (HIRAGANA LETTER TE)
          6784  => 16#3067#,   --  で (HIRAGANA LETTER DE)
          6785  => 16#3068#,   --  と (HIRAGANA LETTER TO)
          6786  => 16#3069#,   --  ど (HIRAGANA LETTER DO)
          6787  => 16#306A#,   --  な (HIRAGANA LETTER NA)
          6788  => 16#306B#,   --  に (HIRAGANA LETTER NI)
          6789  => 16#306C#,   --  ぬ (HIRAGANA LETTER NU)
          6790  => 16#306D#,   --  ね (HIRAGANA LETTER NE)
          6791  => 16#306E#,   --  の (HIRAGANA LETTER NO)
          6792  => 16#306F#,   --  は (HIRAGANA LETTER HA)
          6793  => 16#3070#,   --  ば (HIRAGANA LETTER BA)
          6794  => 16#3071#,   --  ぱ (HIRAGANA LETTER PA)
          6795  => 16#3072#,   --  ひ (HIRAGANA LETTER HI)
          6796  => 16#3073#,   --  び (HIRAGANA LETTER BI)
          6797  => 16#3074#,   --  ぴ (HIRAGANA LETTER PI)
          6798  => 16#3075#,   --  ふ (HIRAGANA LETTER HU)
          6799  => 16#3076#,   --  ぶ (HIRAGANA LETTER BU)
          6800  => 16#3077#,   --  ぷ (HIRAGANA LETTER PU)
          6801  => 16#3078#,   --  へ (HIRAGANA LETTER HE)
          6802  => 16#3079#,   --  べ (HIRAGANA LETTER BE)
          6803  => 16#307A#,   --  ぺ (HIRAGANA LETTER PE)
          6804  => 16#307B#,   --  ほ (HIRAGANA LETTER HO)
          6805  => 16#307C#,   --  ぼ (HIRAGANA LETTER BO)
          6806  => 16#307D#,   --  ぽ (HIRAGANA LETTER PO)
          6807  => 16#307E#,   --  ま (HIRAGANA LETTER MA)
          6808  => 16#307F#,   --  み (HIRAGANA LETTER MI)
          6809  => 16#3080#,   --  む (HIRAGANA LETTER MU)
          6810  => 16#3081#,   --  め (HIRAGANA LETTER ME)
          6811  => 16#3082#,   --  も (HIRAGANA LETTER MO)
          6812  => 16#3083#,   --  ゃ (HIRAGANA LETTER SMALL YA)
          6813  => 16#3084#,   --  や (HIRAGANA LETTER YA)
          6814  => 16#3085#,   --  ゅ (HIRAGANA LETTER SMALL YU)
          6815  => 16#3086#,   --  ゆ (HIRAGANA LETTER YU)
          6816  => 16#3087#,   --  ょ (HIRAGANA LETTER SMALL YO)
          6817  => 16#3088#,   --  よ (HIRAGANA LETTER YO)
          6818  => 16#3089#,   --  ら (HIRAGANA LETTER RA)
          6819  => 16#308A#,   --  り (HIRAGANA LETTER RI)
          6820  => 16#308B#,   --  る (HIRAGANA LETTER RU)
          6821  => 16#308C#,   --  れ (HIRAGANA LETTER RE)
          6822  => 16#308D#,   --  ろ (HIRAGANA LETTER RO)
          6823  => 16#308E#,   --  ゎ (HIRAGANA LETTER SMALL WA)
          6824  => 16#308F#,   --  わ (HIRAGANA LETTER WA)
          6825  => 16#3090#,   --  ゐ (HIRAGANA LETTER WI)
          6826  => 16#3091#,   --  ゑ (HIRAGANA LETTER WE)
          6827  => 16#3092#,   --  を (HIRAGANA LETTER WO)
          6828  => 16#3093#,   --  ん (HIRAGANA LETTER N)
          6829  => 16#E772#,   --   (<Private Use>)
          6830  => 16#E773#,   --   (<Private Use>)
          6831  => 16#E774#,   --   (<Private Use>)
          6832  => 16#E775#,   --   (<Private Use>)
          6833  => 16#E776#,   --   (<Private Use>)
          6834  => 16#E777#,   --   (<Private Use>)
          6835  => 16#E778#,   --   (<Private Use>)
          6836  => 16#E779#,   --   (<Private Use>)
          6837  => 16#E77A#,   --   (<Private Use>)
          6838  => 16#E77B#,   --   (<Private Use>)
          6839  => 16#E77C#,   --   (<Private Use>)
          6840  => 16#E646#,   --   (<Private Use>)
          6841  => 16#E647#,   --   (<Private Use>)
          6842  => 16#E648#,   --   (<Private Use>)
          6843  => 16#E649#,   --   (<Private Use>)
          6844  => 16#E64A#,   --   (<Private Use>)
          6845  => 16#E64B#,   --   (<Private Use>)
          6846  => 16#E64C#,   --   (<Private Use>)
          6847  => 16#E64D#,   --   (<Private Use>)
          6848  => 16#E64E#,   --   (<Private Use>)
          6849  => 16#E64F#,   --   (<Private Use>)
          6850  => 16#E650#,   --   (<Private Use>)
          6851  => 16#E651#,   --   (<Private Use>)
          6852  => 16#E652#,   --   (<Private Use>)
          6853  => 16#E653#,   --   (<Private Use>)
          6854  => 16#E654#,   --   (<Private Use>)
          6855  => 16#E655#,   --   (<Private Use>)
          6856  => 16#E656#,   --   (<Private Use>)
          6857  => 16#E657#,   --   (<Private Use>)
          6858  => 16#E658#,   --   (<Private Use>)
          6859  => 16#E659#,   --   (<Private Use>)
          6860  => 16#E65A#,   --   (<Private Use>)
          6861  => 16#E65B#,   --   (<Private Use>)
          6862  => 16#E65C#,   --   (<Private Use>)
          6863  => 16#E65D#,   --   (<Private Use>)
          6864  => 16#E65E#,   --   (<Private Use>)
          6865  => 16#E65F#,   --   (<Private Use>)
          6866  => 16#E660#,   --   (<Private Use>)
          6867  => 16#E661#,   --   (<Private Use>)
          6868  => 16#E662#,   --   (<Private Use>)
          6869  => 16#E663#,   --   (<Private Use>)
          6870  => 16#E664#,   --   (<Private Use>)
          6871  => 16#E665#,   --   (<Private Use>)
          6872  => 16#E666#,   --   (<Private Use>)
          6873  => 16#E667#,   --   (<Private Use>)
          6874  => 16#E668#,   --   (<Private Use>)
          6875  => 16#E669#,   --   (<Private Use>)
          6876  => 16#E66A#,   --   (<Private Use>)
          6877  => 16#E66B#,   --   (<Private Use>)
          6878  => 16#E66C#,   --   (<Private Use>)
          6879  => 16#E66D#,   --   (<Private Use>)
          6880  => 16#E66E#,   --   (<Private Use>)
          6881  => 16#E66F#,   --   (<Private Use>)
          6882  => 16#E670#,   --   (<Private Use>)
          6883  => 16#E671#,   --   (<Private Use>)
          6884  => 16#E672#,   --   (<Private Use>)
          6885  => 16#E673#,   --   (<Private Use>)
          6886  => 16#E674#,   --   (<Private Use>)
          6887  => 16#E675#,   --   (<Private Use>)
          6888  => 16#E676#,   --   (<Private Use>)
          6889  => 16#E677#,   --   (<Private Use>)
          6890  => 16#E678#,   --   (<Private Use>)
          6891  => 16#E679#,   --   (<Private Use>)
          6892  => 16#E67A#,   --   (<Private Use>)
          6893  => 16#E67B#,   --   (<Private Use>)
          6894  => 16#E67C#,   --   (<Private Use>)
          6895  => 16#E67D#,   --   (<Private Use>)
          6896  => 16#E67E#,   --   (<Private Use>)
          6897  => 16#E67F#,   --   (<Private Use>)
          6898  => 16#E680#,   --   (<Private Use>)
          6899  => 16#E681#,   --   (<Private Use>)
          6900  => 16#E682#,   --   (<Private Use>)
          6901  => 16#E683#,   --   (<Private Use>)
          6902  => 16#E684#,   --   (<Private Use>)
          6903  => 16#E685#,   --   (<Private Use>)
          6904  => 16#E686#,   --   (<Private Use>)
          6905  => 16#E687#,   --   (<Private Use>)
          6906  => 16#E688#,   --   (<Private Use>)
          6907  => 16#E689#,   --   (<Private Use>)
          6908  => 16#E68A#,   --   (<Private Use>)
          6909  => 16#E68B#,   --   (<Private Use>)
          6910  => 16#E68C#,   --   (<Private Use>)
          6911  => 16#E68D#,   --   (<Private Use>)
          6912  => 16#E68E#,   --   (<Private Use>)
          6913  => 16#E68F#,   --   (<Private Use>)
          6914  => 16#E690#,   --   (<Private Use>)
          6915  => 16#E691#,   --   (<Private Use>)
          6916  => 16#E692#,   --   (<Private Use>)
          6917  => 16#E693#,   --   (<Private Use>)
          6918  => 16#E694#,   --   (<Private Use>)
          6919  => 16#E695#,   --   (<Private Use>)
          6920  => 16#E696#,   --   (<Private Use>)
          6921  => 16#E697#,   --   (<Private Use>)
          6922  => 16#E698#,   --   (<Private Use>)
          6923  => 16#E699#,   --   (<Private Use>)
          6924  => 16#E69A#,   --   (<Private Use>)
          6925  => 16#E69B#,   --   (<Private Use>)
          6926  => 16#E69C#,   --   (<Private Use>)
          6927  => 16#E69D#,   --   (<Private Use>)
          6928  => 16#E69E#,   --   (<Private Use>)
          6929  => 16#E69F#,   --   (<Private Use>)
          6930  => 16#E6A0#,   --   (<Private Use>)
          6931  => 16#E6A1#,   --   (<Private Use>)
          6932  => 16#E6A2#,   --   (<Private Use>)
          6933  => 16#E6A3#,   --   (<Private Use>)
          6934  => 16#E6A4#,   --   (<Private Use>)
          6935  => 16#E6A5#,   --   (<Private Use>)
          6936  => 16#30A1#,   --  ァ (KATAKANA LETTER SMALL A)
          6937  => 16#30A2#,   --  ア (KATAKANA LETTER A)
          6938  => 16#30A3#,   --  ィ (KATAKANA LETTER SMALL I)
          6939  => 16#30A4#,   --  イ (KATAKANA LETTER I)
          6940  => 16#30A5#,   --  ゥ (KATAKANA LETTER SMALL U)
          6941  => 16#30A6#,   --  ウ (KATAKANA LETTER U)
          6942  => 16#30A7#,   --  ェ (KATAKANA LETTER SMALL E)
          6943  => 16#30A8#,   --  エ (KATAKANA LETTER E)
          6944  => 16#30A9#,   --  ォ (KATAKANA LETTER SMALL O)
          6945  => 16#30AA#,   --  オ (KATAKANA LETTER O)
          6946  => 16#30AB#,   --  カ (KATAKANA LETTER KA)
          6947  => 16#30AC#,   --  ガ (KATAKANA LETTER GA)
          6948  => 16#30AD#,   --  キ (KATAKANA LETTER KI)
          6949  => 16#30AE#,   --  ギ (KATAKANA LETTER GI)
          6950  => 16#30AF#,   --  ク (KATAKANA LETTER KU)
          6951  => 16#30B0#,   --  グ (KATAKANA LETTER GU)
          6952  => 16#30B1#,   --  ケ (KATAKANA LETTER KE)
          6953  => 16#30B2#,   --  ゲ (KATAKANA LETTER GE)
          6954  => 16#30B3#,   --  コ (KATAKANA LETTER KO)
          6955  => 16#30B4#,   --  ゴ (KATAKANA LETTER GO)
          6956  => 16#30B5#,   --  サ (KATAKANA LETTER SA)
          6957  => 16#30B6#,   --  ザ (KATAKANA LETTER ZA)
          6958  => 16#30B7#,   --  シ (KATAKANA LETTER SI)
          6959  => 16#30B8#,   --  ジ (KATAKANA LETTER ZI)
          6960  => 16#30B9#,   --  ス (KATAKANA LETTER SU)
          6961  => 16#30BA#,   --  ズ (KATAKANA LETTER ZU)
          6962  => 16#30BB#,   --  セ (KATAKANA LETTER SE)
          6963  => 16#30BC#,   --  ゼ (KATAKANA LETTER ZE)
          6964  => 16#30BD#,   --  ソ (KATAKANA LETTER SO)
          6965  => 16#30BE#,   --  ゾ (KATAKANA LETTER ZO)
          6966  => 16#30BF#,   --  タ (KATAKANA LETTER TA)
          6967  => 16#30C0#,   --  ダ (KATAKANA LETTER DA)
          6968  => 16#30C1#,   --  チ (KATAKANA LETTER TI)
          6969  => 16#30C2#,   --  ヂ (KATAKANA LETTER DI)
          6970  => 16#30C3#,   --  ッ (KATAKANA LETTER SMALL TU)
          6971  => 16#30C4#,   --  ツ (KATAKANA LETTER TU)
          6972  => 16#30C5#,   --  ヅ (KATAKANA LETTER DU)
          6973  => 16#30C6#,   --  テ (KATAKANA LETTER TE)
          6974  => 16#30C7#,   --  デ (KATAKANA LETTER DE)
          6975  => 16#30C8#,   --  ト (KATAKANA LETTER TO)
          6976  => 16#30C9#,   --  ド (KATAKANA LETTER DO)
          6977  => 16#30CA#,   --  ナ (KATAKANA LETTER NA)
          6978  => 16#30CB#,   --  ニ (KATAKANA LETTER NI)
          6979  => 16#30CC#,   --  ヌ (KATAKANA LETTER NU)
          6980  => 16#30CD#,   --  ネ (KATAKANA LETTER NE)
          6981  => 16#30CE#,   --  ノ (KATAKANA LETTER NO)
          6982  => 16#30CF#,   --  ハ (KATAKANA LETTER HA)
          6983  => 16#30D0#,   --  バ (KATAKANA LETTER BA)
          6984  => 16#30D1#,   --  パ (KATAKANA LETTER PA)
          6985  => 16#30D2#,   --  ヒ (KATAKANA LETTER HI)
          6986  => 16#30D3#,   --  ビ (KATAKANA LETTER BI)
          6987  => 16#30D4#,   --  ピ (KATAKANA LETTER PI)
          6988  => 16#30D5#,   --  フ (KATAKANA LETTER HU)
          6989  => 16#30D6#,   --  ブ (KATAKANA LETTER BU)
          6990  => 16#30D7#,   --  プ (KATAKANA LETTER PU)
          6991  => 16#30D8#,   --  ヘ (KATAKANA LETTER HE)
          6992  => 16#30D9#,   --  ベ (KATAKANA LETTER BE)
          6993  => 16#30DA#,   --  ペ (KATAKANA LETTER PE)
          6994  => 16#30DB#,   --  ホ (KATAKANA LETTER HO)
          6995  => 16#30DC#,   --  ボ (KATAKANA LETTER BO)
          6996  => 16#30DD#,   --  ポ (KATAKANA LETTER PO)
          6997  => 16#30DE#,   --  マ (KATAKANA LETTER MA)
          6998  => 16#30DF#,   --  ミ (KATAKANA LETTER MI)
          6999  => 16#30E0#,   --  ム (KATAKANA LETTER MU)
          7000  => 16#30E1#,   --  メ (KATAKANA LETTER ME)
          7001  => 16#30E2#,   --  モ (KATAKANA LETTER MO)
          7002  => 16#30E3#,   --  ャ (KATAKANA LETTER SMALL YA)
          7003  => 16#30E4#,   --  ヤ (KATAKANA LETTER YA)
          7004  => 16#30E5#,   --  ュ (KATAKANA LETTER SMALL YU)
          7005  => 16#30E6#,   --  ユ (KATAKANA LETTER YU)
          7006  => 16#30E7#,   --  ョ (KATAKANA LETTER SMALL YO)
          7007  => 16#30E8#,   --  ヨ (KATAKANA LETTER YO)
          7008  => 16#30E9#,   --  ラ (KATAKANA LETTER RA)
          7009  => 16#30EA#,   --  リ (KATAKANA LETTER RI)
          7010  => 16#30EB#,   --  ル (KATAKANA LETTER RU)
          7011  => 16#30EC#,   --  レ (KATAKANA LETTER RE)
          7012  => 16#30ED#,   --  ロ (KATAKANA LETTER RO)
          7013  => 16#30EE#,   --  ヮ (KATAKANA LETTER SMALL WA)
          7014  => 16#30EF#,   --  ワ (KATAKANA LETTER WA)
          7015  => 16#30F0#,   --  ヰ (KATAKANA LETTER WI)
          7016  => 16#30F1#,   --  ヱ (KATAKANA LETTER WE)
          7017  => 16#30F2#,   --  ヲ (KATAKANA LETTER WO)
          7018  => 16#30F3#,   --  ン (KATAKANA LETTER N)
          7019  => 16#30F4#,   --  ヴ (KATAKANA LETTER VU)
          7020  => 16#30F5#,   --  ヵ (KATAKANA LETTER SMALL KA)
          7021  => 16#30F6#,   --  ヶ (KATAKANA LETTER SMALL KE)
          7022  => 16#E77D#,   --   (<Private Use>)
          7023  => 16#E77E#,   --   (<Private Use>)
          7024  => 16#E77F#,   --   (<Private Use>)
          7025  => 16#E780#,   --   (<Private Use>)
          7026  => 16#E781#,   --   (<Private Use>)
          7027  => 16#E782#,   --   (<Private Use>)
          7028  => 16#E783#,   --   (<Private Use>)
          7029  => 16#E784#,   --   (<Private Use>)
          7030  => 16#E6A6#,   --   (<Private Use>)
          7031  => 16#E6A7#,   --   (<Private Use>)
          7032  => 16#E6A8#,   --   (<Private Use>)
          7033  => 16#E6A9#,   --   (<Private Use>)
          7034  => 16#E6AA#,   --   (<Private Use>)
          7035  => 16#E6AB#,   --   (<Private Use>)
          7036  => 16#E6AC#,   --   (<Private Use>)
          7037  => 16#E6AD#,   --   (<Private Use>)
          7038  => 16#E6AE#,   --   (<Private Use>)
          7039  => 16#E6AF#,   --   (<Private Use>)
          7040  => 16#E6B0#,   --   (<Private Use>)
          7041  => 16#E6B1#,   --   (<Private Use>)
          7042  => 16#E6B2#,   --   (<Private Use>)
          7043  => 16#E6B3#,   --   (<Private Use>)
          7044  => 16#E6B4#,   --   (<Private Use>)
          7045  => 16#E6B5#,   --   (<Private Use>)
          7046  => 16#E6B6#,   --   (<Private Use>)
          7047  => 16#E6B7#,   --   (<Private Use>)
          7048  => 16#E6B8#,   --   (<Private Use>)
          7049  => 16#E6B9#,   --   (<Private Use>)
          7050  => 16#E6BA#,   --   (<Private Use>)
          7051  => 16#E6BB#,   --   (<Private Use>)
          7052  => 16#E6BC#,   --   (<Private Use>)
          7053  => 16#E6BD#,   --   (<Private Use>)
          7054  => 16#E6BE#,   --   (<Private Use>)
          7055  => 16#E6BF#,   --   (<Private Use>)
          7056  => 16#E6C0#,   --   (<Private Use>)
          7057  => 16#E6C1#,   --   (<Private Use>)
          7058  => 16#E6C2#,   --   (<Private Use>)
          7059  => 16#E6C3#,   --   (<Private Use>)
          7060  => 16#E6C4#,   --   (<Private Use>)
          7061  => 16#E6C5#,   --   (<Private Use>)
          7062  => 16#E6C6#,   --   (<Private Use>)
          7063  => 16#E6C7#,   --   (<Private Use>)
          7064  => 16#E6C8#,   --   (<Private Use>)
          7065  => 16#E6C9#,   --   (<Private Use>)
          7066  => 16#E6CA#,   --   (<Private Use>)
          7067  => 16#E6CB#,   --   (<Private Use>)
          7068  => 16#E6CC#,   --   (<Private Use>)
          7069  => 16#E6CD#,   --   (<Private Use>)
          7070  => 16#E6CE#,   --   (<Private Use>)
          7071  => 16#E6CF#,   --   (<Private Use>)
          7072  => 16#E6D0#,   --   (<Private Use>)
          7073  => 16#E6D1#,   --   (<Private Use>)
          7074  => 16#E6D2#,   --   (<Private Use>)
          7075  => 16#E6D3#,   --   (<Private Use>)
          7076  => 16#E6D4#,   --   (<Private Use>)
          7077  => 16#E6D5#,   --   (<Private Use>)
          7078  => 16#E6D6#,   --   (<Private Use>)
          7079  => 16#E6D7#,   --   (<Private Use>)
          7080  => 16#E6D8#,   --   (<Private Use>)
          7081  => 16#E6D9#,   --   (<Private Use>)
          7082  => 16#E6DA#,   --   (<Private Use>)
          7083  => 16#E6DB#,   --   (<Private Use>)
          7084  => 16#E6DC#,   --   (<Private Use>)
          7085  => 16#E6DD#,   --   (<Private Use>)
          7086  => 16#E6DE#,   --   (<Private Use>)
          7087  => 16#E6DF#,   --   (<Private Use>)
          7088  => 16#E6E0#,   --   (<Private Use>)
          7089  => 16#E6E1#,   --   (<Private Use>)
          7090  => 16#E6E2#,   --   (<Private Use>)
          7091  => 16#E6E3#,   --   (<Private Use>)
          7092  => 16#E6E4#,   --   (<Private Use>)
          7093  => 16#E6E5#,   --   (<Private Use>)
          7094  => 16#E6E6#,   --   (<Private Use>)
          7095  => 16#E6E7#,   --   (<Private Use>)
          7096  => 16#E6E8#,   --   (<Private Use>)
          7097  => 16#E6E9#,   --   (<Private Use>)
          7098  => 16#E6EA#,   --   (<Private Use>)
          7099  => 16#E6EB#,   --   (<Private Use>)
          7100  => 16#E6EC#,   --   (<Private Use>)
          7101  => 16#E6ED#,   --   (<Private Use>)
          7102  => 16#E6EE#,   --   (<Private Use>)
          7103  => 16#E6EF#,   --   (<Private Use>)
          7104  => 16#E6F0#,   --   (<Private Use>)
          7105  => 16#E6F1#,   --   (<Private Use>)
          7106  => 16#E6F2#,   --   (<Private Use>)
          7107  => 16#E6F3#,   --   (<Private Use>)
          7108  => 16#E6F4#,   --   (<Private Use>)
          7109  => 16#E6F5#,   --   (<Private Use>)
          7110  => 16#E6F6#,   --   (<Private Use>)
          7111  => 16#E6F7#,   --   (<Private Use>)
          7112  => 16#E6F8#,   --   (<Private Use>)
          7113  => 16#E6F9#,   --   (<Private Use>)
          7114  => 16#E6FA#,   --   (<Private Use>)
          7115  => 16#E6FB#,   --   (<Private Use>)
          7116  => 16#E6FC#,   --   (<Private Use>)
          7117  => 16#E6FD#,   --   (<Private Use>)
          7118  => 16#E6FE#,   --   (<Private Use>)
          7119  => 16#E6FF#,   --   (<Private Use>)
          7120  => 16#E700#,   --   (<Private Use>)
          7121  => 16#E701#,   --   (<Private Use>)
          7122  => 16#E702#,   --   (<Private Use>)
          7123  => 16#E703#,   --   (<Private Use>)
          7124  => 16#E704#,   --   (<Private Use>)
          7125  => 16#E705#,   --   (<Private Use>)
          7126  => 16#0391#,   --  Α (GREEK CAPITAL LETTER ALPHA)
          7127  => 16#0392#,   --  Β (GREEK CAPITAL LETTER BETA)
          7128  => 16#0393#,   --  Γ (GREEK CAPITAL LETTER GAMMA)
          7129  => 16#0394#,   --  Δ (GREEK CAPITAL LETTER DELTA)
          7130  => 16#0395#,   --  Ε (GREEK CAPITAL LETTER EPSILON)
          7131  => 16#0396#,   --  Ζ (GREEK CAPITAL LETTER ZETA)
          7132  => 16#0397#,   --  Η (GREEK CAPITAL LETTER ETA)
          7133  => 16#0398#,   --  Θ (GREEK CAPITAL LETTER THETA)
          7134  => 16#0399#,   --  Ι (GREEK CAPITAL LETTER IOTA)
          7135  => 16#039A#,   --  Κ (GREEK CAPITAL LETTER KAPPA)
          7136  => 16#039B#,   --  Λ (GREEK CAPITAL LETTER LAMDA)
          7137  => 16#039C#,   --  Μ (GREEK CAPITAL LETTER MU)
          7138  => 16#039D#,   --  Ν (GREEK CAPITAL LETTER NU)
          7139  => 16#039E#,   --  Ξ (GREEK CAPITAL LETTER XI)
          7140  => 16#039F#,   --  Ο (GREEK CAPITAL LETTER OMICRON)
          7141  => 16#03A0#,   --  Π (GREEK CAPITAL LETTER PI)
          7142  => 16#03A1#,   --  Ρ (GREEK CAPITAL LETTER RHO)
          7143  => 16#03A3#,   --  Σ (GREEK CAPITAL LETTER SIGMA)
          7144  => 16#03A4#,   --  Τ (GREEK CAPITAL LETTER TAU)
          7145  => 16#03A5#,   --  Υ (GREEK CAPITAL LETTER UPSILON)
          7146  => 16#03A6#,   --  Φ (GREEK CAPITAL LETTER PHI)
          7147  => 16#03A7#,   --  Χ (GREEK CAPITAL LETTER CHI)
          7148  => 16#03A8#,   --  Ψ (GREEK CAPITAL LETTER PSI)
          7149  => 16#03A9#,   --  Ω (GREEK CAPITAL LETTER OMEGA)
          7150  => 16#E785#,   --   (<Private Use>)
          7151  => 16#E786#,   --   (<Private Use>)
          7152  => 16#E787#,   --   (<Private Use>)
          7153  => 16#E788#,   --   (<Private Use>)
          7154  => 16#E789#,   --   (<Private Use>)
          7155  => 16#E78A#,   --   (<Private Use>)
          7156  => 16#E78B#,   --   (<Private Use>)
          7157  => 16#E78C#,   --   (<Private Use>)
          7158  => 16#03B1#,   --  α (GREEK SMALL LETTER ALPHA)
          7159  => 16#03B2#,   --  β (GREEK SMALL LETTER BETA)
          7160  => 16#03B3#,   --  γ (GREEK SMALL LETTER GAMMA)
          7161  => 16#03B4#,   --  δ (GREEK SMALL LETTER DELTA)
          7162  => 16#03B5#,   --  ε (GREEK SMALL LETTER EPSILON)
          7163  => 16#03B6#,   --  ζ (GREEK SMALL LETTER ZETA)
          7164  => 16#03B7#,   --  η (GREEK SMALL LETTER ETA)
          7165  => 16#03B8#,   --  θ (GREEK SMALL LETTER THETA)
          7166  => 16#03B9#,   --  ι (GREEK SMALL LETTER IOTA)
          7167  => 16#03BA#,   --  κ (GREEK SMALL LETTER KAPPA)
          7168  => 16#03BB#,   --  λ (GREEK SMALL LETTER LAMDA)
          7169  => 16#03BC#,   --  μ (GREEK SMALL LETTER MU)
          7170  => 16#03BD#,   --  ν (GREEK SMALL LETTER NU)
          7171  => 16#03BE#,   --  ξ (GREEK SMALL LETTER XI)
          7172  => 16#03BF#,   --  ο (GREEK SMALL LETTER OMICRON)
          7173  => 16#03C0#,   --  π (GREEK SMALL LETTER PI)
          7174  => 16#03C1#,   --  ρ (GREEK SMALL LETTER RHO)
          7175  => 16#03C3#,   --  σ (GREEK SMALL LETTER SIGMA)
          7176  => 16#03C4#,   --  τ (GREEK SMALL LETTER TAU)
          7177  => 16#03C5#,   --  υ (GREEK SMALL LETTER UPSILON)
          7178  => 16#03C6#,   --  φ (GREEK SMALL LETTER PHI)
          7179  => 16#03C7#,   --  χ (GREEK SMALL LETTER CHI)
          7180  => 16#03C8#,   --  ψ (GREEK SMALL LETTER PSI)
          7181  => 16#03C9#,   --  ω (GREEK SMALL LETTER OMEGA)
          7182  => 16#E78D#,   --   (<Private Use>)
          7183  => 16#E78E#,   --   (<Private Use>)
          7184  => 16#E78F#,   --   (<Private Use>)
          7185  => 16#E790#,   --   (<Private Use>)
          7186  => 16#E791#,   --   (<Private Use>)
          7187  => 16#E792#,   --   (<Private Use>)
          7188  => 16#E793#,   --   (<Private Use>)
          7189  => 16#FE35#,   --  ︵ (PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS)
          7190  => 16#FE36#,   --  ︶ (PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS)
          7191  => 16#FE39#,   --  ︹ (PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET)
          7192  => 16#FE3A#,   --  ︺ (PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET)
          7193  => 16#FE3F#,   --  ︿ (PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET)
          7194  => 16#FE40#,   --  ﹀ (PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET)
          7195  => 16#FE3D#,   --  ︽ (PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET)
          7196  => 16#FE3E#,   --  ︾ (PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET)
          7197  => 16#FE41#,   --  ﹁ (PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET)
          7198  => 16#FE42#,   --  ﹂ (PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET)
          7199  => 16#FE43#,   --  ﹃ (PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET)
          7200  => 16#FE44#,   --  ﹄ (PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET)
          7201  => 16#E794#,   --   (<Private Use>)
          7202  => 16#E795#,   --   (<Private Use>)
          7203  => 16#FE3B#,   --  ︻ (PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET)
          7204  => 16#FE3C#,   --  ︼ (PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET)
          7205  => 16#FE37#,   --  ︷ (PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET)
          7206  => 16#FE38#,   --  ︸ (PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET)
          7207  => 16#FE31#,   --  ︱ (PRESENTATION FORM FOR VERTICAL EM DASH)
          7208  => 16#E796#,   --   (<Private Use>)
          7209  => 16#FE33#,   --  ︳ (PRESENTATION FORM FOR VERTICAL LOW LINE)
          7210  => 16#FE34#,   --  ︴ (PRESENTATION FORM FOR VERTICAL WAVY LOW LINE)
          7211  => 16#E797#,   --   (<Private Use>)
          7212  => 16#E798#,   --   (<Private Use>)
          7213  => 16#E799#,   --   (<Private Use>)
          7214  => 16#E79A#,   --   (<Private Use>)
          7215  => 16#E79B#,   --   (<Private Use>)
          7216  => 16#E79C#,   --   (<Private Use>)
          7217  => 16#E79D#,   --   (<Private Use>)
          7218  => 16#E79E#,   --   (<Private Use>)
          7219  => 16#E79F#,   --   (<Private Use>)
          7220  => 16#E706#,   --   (<Private Use>)
          7221  => 16#E707#,   --   (<Private Use>)
          7222  => 16#E708#,   --   (<Private Use>)
          7223  => 16#E709#,   --   (<Private Use>)
          7224  => 16#E70A#,   --   (<Private Use>)
          7225  => 16#E70B#,   --   (<Private Use>)
          7226  => 16#E70C#,   --   (<Private Use>)
          7227  => 16#E70D#,   --   (<Private Use>)
          7228  => 16#E70E#,   --   (<Private Use>)
          7229  => 16#E70F#,   --   (<Private Use>)
          7230  => 16#E710#,   --   (<Private Use>)
          7231  => 16#E711#,   --   (<Private Use>)
          7232  => 16#E712#,   --   (<Private Use>)
          7233  => 16#E713#,   --   (<Private Use>)
          7234  => 16#E714#,   --   (<Private Use>)
          7235  => 16#E715#,   --   (<Private Use>)
          7236  => 16#E716#,   --   (<Private Use>)
          7237  => 16#E717#,   --   (<Private Use>)
          7238  => 16#E718#,   --   (<Private Use>)
          7239  => 16#E719#,   --   (<Private Use>)
          7240  => 16#E71A#,   --   (<Private Use>)
          7241  => 16#E71B#,   --   (<Private Use>)
          7242  => 16#E71C#,   --   (<Private Use>)
          7243  => 16#E71D#,   --   (<Private Use>)
          7244  => 16#E71E#,   --   (<Private Use>)
          7245  => 16#E71F#,   --   (<Private Use>)
          7246  => 16#E720#,   --   (<Private Use>)
          7247  => 16#E721#,   --   (<Private Use>)
          7248  => 16#E722#,   --   (<Private Use>)
          7249  => 16#E723#,   --   (<Private Use>)
          7250  => 16#E724#,   --   (<Private Use>)
          7251  => 16#E725#,   --   (<Private Use>)
          7252  => 16#E726#,   --   (<Private Use>)
          7253  => 16#E727#,   --   (<Private Use>)
          7254  => 16#E728#,   --   (<Private Use>)
          7255  => 16#E729#,   --   (<Private Use>)
          7256  => 16#E72A#,   --   (<Private Use>)
          7257  => 16#E72B#,   --   (<Private Use>)
          7258  => 16#E72C#,   --   (<Private Use>)
          7259  => 16#E72D#,   --   (<Private Use>)
          7260  => 16#E72E#,   --   (<Private Use>)
          7261  => 16#E72F#,   --   (<Private Use>)
          7262  => 16#E730#,   --   (<Private Use>)
          7263  => 16#E731#,   --   (<Private Use>)
          7264  => 16#E732#,   --   (<Private Use>)
          7265  => 16#E733#,   --   (<Private Use>)
          7266  => 16#E734#,   --   (<Private Use>)
          7267  => 16#E735#,   --   (<Private Use>)
          7268  => 16#E736#,   --   (<Private Use>)
          7269  => 16#E737#,   --   (<Private Use>)
          7270  => 16#E738#,   --   (<Private Use>)
          7271  => 16#E739#,   --   (<Private Use>)
          7272  => 16#E73A#,   --   (<Private Use>)
          7273  => 16#E73B#,   --   (<Private Use>)
          7274  => 16#E73C#,   --   (<Private Use>)
          7275  => 16#E73D#,   --   (<Private Use>)
          7276  => 16#E73E#,   --   (<Private Use>)
          7277  => 16#E73F#,   --   (<Private Use>)
          7278  => 16#E740#,   --   (<Private Use>)
          7279  => 16#E741#,   --   (<Private Use>)
          7280  => 16#E742#,   --   (<Private Use>)
          7281  => 16#E743#,   --   (<Private Use>)
          7282  => 16#E744#,   --   (<Private Use>)
          7283  => 16#E745#,   --   (<Private Use>)
          7284  => 16#E746#,   --   (<Private Use>)
          7285  => 16#E747#,   --   (<Private Use>)
          7286  => 16#E748#,   --   (<Private Use>)
          7287  => 16#E749#,   --   (<Private Use>)
          7288  => 16#E74A#,   --   (<Private Use>)
          7289  => 16#E74B#,   --   (<Private Use>)
          7290  => 16#E74C#,   --   (<Private Use>)
          7291  => 16#E74D#,   --   (<Private Use>)
          7292  => 16#E74E#,   --   (<Private Use>)
          7293  => 16#E74F#,   --   (<Private Use>)
          7294  => 16#E750#,   --   (<Private Use>)
          7295  => 16#E751#,   --   (<Private Use>)
          7296  => 16#E752#,   --   (<Private Use>)
          7297  => 16#E753#,   --   (<Private Use>)
          7298  => 16#E754#,   --   (<Private Use>)
          7299  => 16#E755#,   --   (<Private Use>)
          7300  => 16#E756#,   --   (<Private Use>)
          7301  => 16#E757#,   --   (<Private Use>)
          7302  => 16#E758#,   --   (<Private Use>)
          7303  => 16#E759#,   --   (<Private Use>)
          7304  => 16#E75A#,   --   (<Private Use>)
          7305  => 16#E75B#,   --   (<Private Use>)
          7306  => 16#E75C#,   --   (<Private Use>)
          7307  => 16#E75D#,   --   (<Private Use>)
          7308  => 16#E75E#,   --   (<Private Use>)
          7309  => 16#E75F#,   --   (<Private Use>)
          7310  => 16#E760#,   --   (<Private Use>)
          7311  => 16#E761#,   --   (<Private Use>)
          7312  => 16#E762#,   --   (<Private Use>)
          7313  => 16#E763#,   --   (<Private Use>)
          7314  => 16#E764#,   --   (<Private Use>)
          7315  => 16#E765#,   --   (<Private Use>)
          7316  => 16#0410#,   --  А (CYRILLIC CAPITAL LETTER A)
          7317  => 16#0411#,   --  Б (CYRILLIC CAPITAL LETTER BE)
          7318  => 16#0412#,   --  В (CYRILLIC CAPITAL LETTER VE)
          7319  => 16#0413#,   --  Г (CYRILLIC CAPITAL LETTER GHE)
          7320  => 16#0414#,   --  Д (CYRILLIC CAPITAL LETTER DE)
          7321  => 16#0415#,   --  Е (CYRILLIC CAPITAL LETTER IE)
          7322  => 16#0401#,   --  Ё (CYRILLIC CAPITAL LETTER IO)
          7323  => 16#0416#,   --  Ж (CYRILLIC CAPITAL LETTER ZHE)
          7324  => 16#0417#,   --  З (CYRILLIC CAPITAL LETTER ZE)
          7325  => 16#0418#,   --  И (CYRILLIC CAPITAL LETTER I)
          7326  => 16#0419#,   --  Й (CYRILLIC CAPITAL LETTER SHORT I)
          7327  => 16#041A#,   --  К (CYRILLIC CAPITAL LETTER KA)
          7328  => 16#041B#,   --  Л (CYRILLIC CAPITAL LETTER EL)
          7329  => 16#041C#,   --  М (CYRILLIC CAPITAL LETTER EM)
          7330  => 16#041D#,   --  Н (CYRILLIC CAPITAL LETTER EN)
          7331  => 16#041E#,   --  О (CYRILLIC CAPITAL LETTER O)
          7332  => 16#041F#,   --  П (CYRILLIC CAPITAL LETTER PE)
          7333  => 16#0420#,   --  Р (CYRILLIC CAPITAL LETTER ER)
          7334  => 16#0421#,   --  С (CYRILLIC CAPITAL LETTER ES)
          7335  => 16#0422#,   --  Т (CYRILLIC CAPITAL LETTER TE)
          7336  => 16#0423#,   --  У (CYRILLIC CAPITAL LETTER U)
          7337  => 16#0424#,   --  Ф (CYRILLIC CAPITAL LETTER EF)
          7338  => 16#0425#,   --  Х (CYRILLIC CAPITAL LETTER HA)
          7339  => 16#0426#,   --  Ц (CYRILLIC CAPITAL LETTER TSE)
          7340  => 16#0427#,   --  Ч (CYRILLIC CAPITAL LETTER CHE)
          7341  => 16#0428#,   --  Ш (CYRILLIC CAPITAL LETTER SHA)
          7342  => 16#0429#,   --  Щ (CYRILLIC CAPITAL LETTER SHCHA)
          7343  => 16#042A#,   --  Ъ (CYRILLIC CAPITAL LETTER HARD SIGN)
          7344  => 16#042B#,   --  Ы (CYRILLIC CAPITAL LETTER YERU)
          7345  => 16#042C#,   --  Ь (CYRILLIC CAPITAL LETTER SOFT SIGN)
          7346  => 16#042D#,   --  Э (CYRILLIC CAPITAL LETTER E)
          7347  => 16#042E#,   --  Ю (CYRILLIC CAPITAL LETTER YU)
          7348  => 16#042F#,   --  Я (CYRILLIC CAPITAL LETTER YA)
          7349  => 16#E7A0#,   --   (<Private Use>)
          7350  => 16#E7A1#,   --   (<Private Use>)
          7351  => 16#E7A2#,   --   (<Private Use>)
          7352  => 16#E7A3#,   --   (<Private Use>)
          7353  => 16#E7A4#,   --   (<Private Use>)
          7354  => 16#E7A5#,   --   (<Private Use>)
          7355  => 16#E7A6#,   --   (<Private Use>)
          7356  => 16#E7A7#,   --   (<Private Use>)
          7357  => 16#E7A8#,   --   (<Private Use>)
          7358  => 16#E7A9#,   --   (<Private Use>)
          7359  => 16#E7AA#,   --   (<Private Use>)
          7360  => 16#E7AB#,   --   (<Private Use>)
          7361  => 16#E7AC#,   --   (<Private Use>)
          7362  => 16#E7AD#,   --   (<Private Use>)
          7363  => 16#E7AE#,   --   (<Private Use>)
          7364  => 16#0430#,   --  а (CYRILLIC SMALL LETTER A)
          7365  => 16#0431#,   --  б (CYRILLIC SMALL LETTER BE)
          7366  => 16#0432#,   --  в (CYRILLIC SMALL LETTER VE)
          7367  => 16#0433#,   --  г (CYRILLIC SMALL LETTER GHE)
          7368  => 16#0434#,   --  д (CYRILLIC SMALL LETTER DE)
          7369  => 16#0435#,   --  е (CYRILLIC SMALL LETTER IE)
          7370  => 16#0451#,   --  ё (CYRILLIC SMALL LETTER IO)
          7371  => 16#0436#,   --  ж (CYRILLIC SMALL LETTER ZHE)
          7372  => 16#0437#,   --  з (CYRILLIC SMALL LETTER ZE)
          7373  => 16#0438#,   --  и (CYRILLIC SMALL LETTER I)
          7374  => 16#0439#,   --  й (CYRILLIC SMALL LETTER SHORT I)
          7375  => 16#043A#,   --  к (CYRILLIC SMALL LETTER KA)
          7376  => 16#043B#,   --  л (CYRILLIC SMALL LETTER EL)
          7377  => 16#043C#,   --  м (CYRILLIC SMALL LETTER EM)
          7378  => 16#043D#,   --  н (CYRILLIC SMALL LETTER EN)
          7379  => 16#043E#,   --  о (CYRILLIC SMALL LETTER O)
          7380  => 16#043F#,   --  п (CYRILLIC SMALL LETTER PE)
          7381  => 16#0440#,   --  р (CYRILLIC SMALL LETTER ER)
          7382  => 16#0441#,   --  с (CYRILLIC SMALL LETTER ES)
          7383  => 16#0442#,   --  т (CYRILLIC SMALL LETTER TE)
          7384  => 16#0443#,   --  у (CYRILLIC SMALL LETTER U)
          7385  => 16#0444#,   --  ф (CYRILLIC SMALL LETTER EF)
          7386  => 16#0445#,   --  х (CYRILLIC SMALL LETTER HA)
          7387  => 16#0446#,   --  ц (CYRILLIC SMALL LETTER TSE)
          7388  => 16#0447#,   --  ч (CYRILLIC SMALL LETTER CHE)
          7389  => 16#0448#,   --  ш (CYRILLIC SMALL LETTER SHA)
          7390  => 16#0449#,   --  щ (CYRILLIC SMALL LETTER SHCHA)
          7391  => 16#044A#,   --  ъ (CYRILLIC SMALL LETTER HARD SIGN)
          7392  => 16#044B#,   --  ы (CYRILLIC SMALL LETTER YERU)
          7393  => 16#044C#,   --  ь (CYRILLIC SMALL LETTER SOFT SIGN)
          7394  => 16#044D#,   --  э (CYRILLIC SMALL LETTER E)
          7395  => 16#044E#,   --  ю (CYRILLIC SMALL LETTER YU)
          7396  => 16#044F#,   --  я (CYRILLIC SMALL LETTER YA)
          7397  => 16#E7AF#,   --   (<Private Use>)
          7398  => 16#E7B0#,   --   (<Private Use>)
          7399  => 16#E7B1#,   --   (<Private Use>)
          7400  => 16#E7B2#,   --   (<Private Use>)
          7401  => 16#E7B3#,   --   (<Private Use>)
          7402  => 16#E7B4#,   --   (<Private Use>)
          7403  => 16#E7B5#,   --   (<Private Use>)
          7404  => 16#E7B6#,   --   (<Private Use>)
          7405  => 16#E7B7#,   --   (<Private Use>)
          7406  => 16#E7B8#,   --   (<Private Use>)
          7407  => 16#E7B9#,   --   (<Private Use>)
          7408  => 16#E7BA#,   --   (<Private Use>)
          7409  => 16#E7BB#,   --   (<Private Use>)
          7410  => 16#02CA#,   --  ˊ (MODIFIER LETTER ACUTE ACCENT)
          7411  => 16#02CB#,   --  ˋ (MODIFIER LETTER GRAVE ACCENT)
          7412  => 16#02D9#,   --  ˙ (DOT ABOVE)
          7413  => 16#2013#,   --  – (EN DASH)
          7414  => 16#2015#,   --  ― (HORIZONTAL BAR)
          7415  => 16#2025#,   --  ‥ (TWO DOT LEADER)
          7416  => 16#2035#,   --  ‵ (REVERSED PRIME)
          7417  => 16#2105#,   --  ℅ (CARE OF)
          7418  => 16#2109#,   --  ℉ (DEGREE FAHRENHEIT)
          7419  => 16#2196#,   --  ↖ (NORTH WEST ARROW)
          7420  => 16#2197#,   --  ↗ (NORTH EAST ARROW)
          7421  => 16#2198#,   --  ↘ (SOUTH EAST ARROW)
          7422  => 16#2199#,   --  ↙ (SOUTH WEST ARROW)
          7423  => 16#2215#,   --  ∕ (DIVISION SLASH)
          7424  => 16#221F#,   --  ∟ (RIGHT ANGLE)
          7425  => 16#2223#,   --  ∣ (DIVIDES)
          7426  => 16#2252#,   --  ≒ (APPROXIMATELY EQUAL TO OR THE IMAGE OF)
          7427  => 16#2266#,   --  ≦ (LESS-THAN OVER EQUAL TO)
          7428  => 16#2267#,   --  ≧ (GREATER-THAN OVER EQUAL TO)
          7429  => 16#22BF#,   --  ⊿ (RIGHT TRIANGLE)
          7430  => 16#2550#,   --  ═ (BOX DRAWINGS DOUBLE HORIZONTAL)
          7431  => 16#2551#,   --  ║ (BOX DRAWINGS DOUBLE VERTICAL)
          7432  => 16#2552#,   --  ╒ (BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE)
          7433  => 16#2553#,   --  ╓ (BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE)
          7434  => 16#2554#,   --  ╔ (BOX DRAWINGS DOUBLE DOWN AND RIGHT)
          7435  => 16#2555#,   --  ╕ (BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE)
          7436  => 16#2556#,   --  ╖ (BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE)
          7437  => 16#2557#,   --  ╗ (BOX DRAWINGS DOUBLE DOWN AND LEFT)
          7438  => 16#2558#,   --  ╘ (BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE)
          7439  => 16#2559#,   --  ╙ (BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE)
          7440  => 16#255A#,   --  ╚ (BOX DRAWINGS DOUBLE UP AND RIGHT)
          7441  => 16#255B#,   --  ╛ (BOX DRAWINGS UP SINGLE AND LEFT DOUBLE)
          7442  => 16#255C#,   --  ╜ (BOX DRAWINGS UP DOUBLE AND LEFT SINGLE)
          7443  => 16#255D#,   --  ╝ (BOX DRAWINGS DOUBLE UP AND LEFT)
          7444  => 16#255E#,   --  ╞ (BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE)
          7445  => 16#255F#,   --  ╟ (BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE)
          7446  => 16#2560#,   --  ╠ (BOX DRAWINGS DOUBLE VERTICAL AND RIGHT)
          7447  => 16#2561#,   --  ╡ (BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE)
          7448  => 16#2562#,   --  ╢ (BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE)
          7449  => 16#2563#,   --  ╣ (BOX DRAWINGS DOUBLE VERTICAL AND LEFT)
          7450  => 16#2564#,   --  ╤ (BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE)
          7451  => 16#2565#,   --  ╥ (BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE)
          7452  => 16#2566#,   --  ╦ (BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL)
          7453  => 16#2567#,   --  ╧ (BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE)
          7454  => 16#2568#,   --  ╨ (BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE)
          7455  => 16#2569#,   --  ╩ (BOX DRAWINGS DOUBLE UP AND HORIZONTAL)
          7456  => 16#256A#,   --  ╪ (BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE)
          7457  => 16#256B#,   --  ╫ (BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE)
          7458  => 16#256C#,   --  ╬ (BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL)
          7459  => 16#256D#,   --  ╭ (BOX DRAWINGS LIGHT ARC DOWN AND RIGHT)
          7460  => 16#256E#,   --  ╮ (BOX DRAWINGS LIGHT ARC DOWN AND LEFT)
          7461  => 16#256F#,   --  ╯ (BOX DRAWINGS LIGHT ARC UP AND LEFT)
          7462  => 16#2570#,   --  ╰ (BOX DRAWINGS LIGHT ARC UP AND RIGHT)
          7463  => 16#2571#,   --  ╱ (BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT)
          7464  => 16#2572#,   --  ╲ (BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT)
          7465  => 16#2573#,   --  ╳ (BOX DRAWINGS LIGHT DIAGONAL CROSS)
          7466  => 16#2581#,   --  ▁ (LOWER ONE EIGHTH BLOCK)
          7467  => 16#2582#,   --  ▂ (LOWER ONE QUARTER BLOCK)
          7468  => 16#2583#,   --  ▃ (LOWER THREE EIGHTHS BLOCK)
          7469  => 16#2584#,   --  ▄ (LOWER HALF BLOCK)
          7470  => 16#2585#,   --  ▅ (LOWER FIVE EIGHTHS BLOCK)
          7471  => 16#2586#,   --  ▆ (LOWER THREE QUARTERS BLOCK)
          7472  => 16#2587#,   --  ▇ (LOWER SEVEN EIGHTHS BLOCK)
          7473  => 16#2588#,   --  █ (FULL BLOCK)
          7474  => 16#2589#,   --  ▉ (LEFT SEVEN EIGHTHS BLOCK)
          7475  => 16#258A#,   --  ▊ (LEFT THREE QUARTERS BLOCK)
          7476  => 16#258B#,   --  ▋ (LEFT FIVE EIGHTHS BLOCK)
          7477  => 16#258C#,   --  ▌ (LEFT HALF BLOCK)
          7478  => 16#258D#,   --  ▍ (LEFT THREE EIGHTHS BLOCK)
          7479  => 16#258E#,   --  ▎ (LEFT ONE QUARTER BLOCK)
          7480  => 16#258F#,   --  ▏ (LEFT ONE EIGHTH BLOCK)
          7481  => 16#2593#,   --  ▓ (DARK SHADE)
          7482  => 16#2594#,   --  ▔ (UPPER ONE EIGHTH BLOCK)
          7483  => 16#2595#,   --  ▕ (RIGHT ONE EIGHTH BLOCK)
          7484  => 16#25BC#,   --  ▼ (BLACK DOWN-POINTING TRIANGLE)
          7485  => 16#25BD#,   --  ▽ (WHITE DOWN-POINTING TRIANGLE)
          7486  => 16#25E2#,   --  ◢ (BLACK LOWER RIGHT TRIANGLE)
          7487  => 16#25E3#,   --  ◣ (BLACK LOWER LEFT TRIANGLE)
          7488  => 16#25E4#,   --  ◤ (BLACK UPPER LEFT TRIANGLE)
          7489  => 16#25E5#,   --  ◥ (BLACK UPPER RIGHT TRIANGLE)
          7490  => 16#2609#,   --  ☉ (SUN)
          7491  => 16#2295#,   --  ⊕ (CIRCLED PLUS)
          7492  => 16#3012#,   --  〒 (POSTAL MARK)
          7493  => 16#301D#,   --  〝 (REVERSED DOUBLE PRIME QUOTATION MARK)
          7494  => 16#301E#,   --  〞 (DOUBLE PRIME QUOTATION MARK)
          7495  => 16#E7BC#,   --   (<Private Use>)
          7496  => 16#E7BD#,   --   (<Private Use>)
          7497  => 16#E7BE#,   --   (<Private Use>)
          7498  => 16#E7BF#,   --   (<Private Use>)
          7499  => 16#E7C0#,   --   (<Private Use>)
          7500  => 16#E7C1#,   --   (<Private Use>)
          7501  => 16#E7C2#,   --   (<Private Use>)
          7502  => 16#E7C3#,   --   (<Private Use>)
          7503  => 16#E7C4#,   --   (<Private Use>)
          7504  => 16#E7C5#,   --   (<Private Use>)
          7505  => 16#E7C6#,   --   (<Private Use>)
          7506  => 16#0101#,   --  ā (LATIN SMALL LETTER A WITH MACRON)
          7507  => 16#00E1#,   --  á (LATIN SMALL LETTER A WITH ACUTE)
          7508  => 16#01CE#,   --  ǎ (LATIN SMALL LETTER A WITH CARON)
          7509  => 16#00E0#,   --  à (LATIN SMALL LETTER A WITH GRAVE)
          7510  => 16#0113#,   --  ē (LATIN SMALL LETTER E WITH MACRON)
          7511  => 16#00E9#,   --  é (LATIN SMALL LETTER E WITH ACUTE)
          7512  => 16#011B#,   --  ě (LATIN SMALL LETTER E WITH CARON)
          7513  => 16#00E8#,   --  è (LATIN SMALL LETTER E WITH GRAVE)
          7514  => 16#012B#,   --  ī (LATIN SMALL LETTER I WITH MACRON)
          7515  => 16#00ED#,   --  í (LATIN SMALL LETTER I WITH ACUTE)
          7516  => 16#01D0#,   --  ǐ (LATIN SMALL LETTER I WITH CARON)
          7517  => 16#00EC#,   --  ì (LATIN SMALL LETTER I WITH GRAVE)
          7518  => 16#014D#,   --  ō (LATIN SMALL LETTER O WITH MACRON)
          7519  => 16#00F3#,   --  ó (LATIN SMALL LETTER O WITH ACUTE)
          7520  => 16#01D2#,   --  ǒ (LATIN SMALL LETTER O WITH CARON)
          7521  => 16#00F2#,   --  ò (LATIN SMALL LETTER O WITH GRAVE)
          7522  => 16#016B#,   --  ū (LATIN SMALL LETTER U WITH MACRON)
          7523  => 16#00FA#,   --  ú (LATIN SMALL LETTER U WITH ACUTE)
          7524  => 16#01D4#,   --  ǔ (LATIN SMALL LETTER U WITH CARON)
          7525  => 16#00F9#,   --  ù (LATIN SMALL LETTER U WITH GRAVE)
          7526  => 16#01D6#,   --  ǖ (LATIN SMALL LETTER U WITH DIAERESIS AND MACRON)
          7527  => 16#01D8#,   --  ǘ (LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE)
          7528  => 16#01DA#,   --  ǚ (LATIN SMALL LETTER U WITH DIAERESIS AND CARON)
          7529  => 16#01DC#,   --  ǜ (LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE)
          7530  => 16#00FC#,   --  ü (LATIN SMALL LETTER U WITH DIAERESIS)
          7531  => 16#00EA#,   --  ê (LATIN SMALL LETTER E WITH CIRCUMFLEX)
          7532  => 16#0251#,   --  ɑ (LATIN SMALL LETTER ALPHA)
          7533  => 16#1E3F#,   --  ḿ (LATIN SMALL LETTER M WITH ACUTE)
          7534  => 16#0144#,   --  ń (LATIN SMALL LETTER N WITH ACUTE)
          7535  => 16#0148#,   --  ň (LATIN SMALL LETTER N WITH CARON)
          7536  => 16#01F9#,   --  ǹ (LATIN SMALL LETTER N WITH GRAVE)
          7537  => 16#0261#,   --  ɡ (LATIN SMALL LETTER SCRIPT G)
          7538  => 16#E7C9#,   --   (<Private Use>)
          7539  => 16#E7CA#,   --   (<Private Use>)
          7540  => 16#E7CB#,   --   (<Private Use>)
          7541  => 16#E7CC#,   --   (<Private Use>)
          7542  => 16#3105#,   --  ㄅ (BOPOMOFO LETTER B)
          7543  => 16#3106#,   --  ㄆ (BOPOMOFO LETTER P)
          7544  => 16#3107#,   --  ㄇ (BOPOMOFO LETTER M)
          7545  => 16#3108#,   --  ㄈ (BOPOMOFO LETTER F)
          7546  => 16#3109#,   --  ㄉ (BOPOMOFO LETTER D)
          7547  => 16#310A#,   --  ㄊ (BOPOMOFO LETTER T)
          7548  => 16#310B#,   --  ㄋ (BOPOMOFO LETTER N)
          7549  => 16#310C#,   --  ㄌ (BOPOMOFO LETTER L)
          7550  => 16#310D#,   --  ㄍ (BOPOMOFO LETTER G)
          7551  => 16#310E#,   --  ㄎ (BOPOMOFO LETTER K)
          7552  => 16#310F#,   --  ㄏ (BOPOMOFO LETTER H)
          7553  => 16#3110#,   --  ㄐ (BOPOMOFO LETTER J)
          7554  => 16#3111#,   --  ㄑ (BOPOMOFO LETTER Q)
          7555  => 16#3112#,   --  ㄒ (BOPOMOFO LETTER X)
          7556  => 16#3113#,   --  ㄓ (BOPOMOFO LETTER ZH)
          7557  => 16#3114#,   --  ㄔ (BOPOMOFO LETTER CH)
          7558  => 16#3115#,   --  ㄕ (BOPOMOFO LETTER SH)
          7559  => 16#3116#,   --  ㄖ (BOPOMOFO LETTER R)
          7560  => 16#3117#,   --  ㄗ (BOPOMOFO LETTER Z)
          7561  => 16#3118#,   --  ㄘ (BOPOMOFO LETTER C)
          7562  => 16#3119#,   --  ㄙ (BOPOMOFO LETTER S)
          7563  => 16#311A#,   --  ㄚ (BOPOMOFO LETTER A)
          7564  => 16#311B#,   --  ㄛ (BOPOMOFO LETTER O)
          7565  => 16#311C#,   --  ㄜ (BOPOMOFO LETTER E)
          7566  => 16#311D#,   --  ㄝ (BOPOMOFO LETTER EH)
          7567  => 16#311E#,   --  ㄞ (BOPOMOFO LETTER AI)
          7568  => 16#311F#,   --  ㄟ (BOPOMOFO LETTER EI)
          7569  => 16#3120#,   --  ㄠ (BOPOMOFO LETTER AU)
          7570  => 16#3121#,   --  ㄡ (BOPOMOFO LETTER OU)
          7571  => 16#3122#,   --  ㄢ (BOPOMOFO LETTER AN)
          7572  => 16#3123#,   --  ㄣ (BOPOMOFO LETTER EN)
          7573  => 16#3124#,   --  ㄤ (BOPOMOFO LETTER ANG)
          7574  => 16#3125#,   --  ㄥ (BOPOMOFO LETTER ENG)
          7575  => 16#3126#,   --  ㄦ (BOPOMOFO LETTER ER)
          7576  => 16#3127#,   --  ㄧ (BOPOMOFO LETTER I)
          7577  => 16#3128#,   --  ㄨ (BOPOMOFO LETTER U)
          7578  => 16#3129#,   --  ㄩ (BOPOMOFO LETTER IU)
          7579  => 16#E7CD#,   --   (<Private Use>)
          7580  => 16#E7CE#,   --   (<Private Use>)
          7581  => 16#E7CF#,   --   (<Private Use>)
          7582  => 16#E7D0#,   --   (<Private Use>)
          7583  => 16#E7D1#,   --   (<Private Use>)
          7584  => 16#E7D2#,   --   (<Private Use>)
          7585  => 16#E7D3#,   --   (<Private Use>)
          7586  => 16#E7D4#,   --   (<Private Use>)
          7587  => 16#E7D5#,   --   (<Private Use>)
          7588  => 16#E7D6#,   --   (<Private Use>)
          7589  => 16#E7D7#,   --   (<Private Use>)
          7590  => 16#E7D8#,   --   (<Private Use>)
          7591  => 16#E7D9#,   --   (<Private Use>)
          7592  => 16#E7DA#,   --   (<Private Use>)
          7593  => 16#E7DB#,   --   (<Private Use>)
          7594  => 16#E7DC#,   --   (<Private Use>)
          7595  => 16#E7DD#,   --   (<Private Use>)
          7596  => 16#E7DE#,   --   (<Private Use>)
          7597  => 16#E7DF#,   --   (<Private Use>)
          7598  => 16#E7E0#,   --   (<Private Use>)
          7599  => 16#E7E1#,   --   (<Private Use>)
          7600  => 16#3021#,   --  〡 (HANGZHOU NUMERAL ONE)
          7601  => 16#3022#,   --  〢 (HANGZHOU NUMERAL TWO)
          7602  => 16#3023#,   --  〣 (HANGZHOU NUMERAL THREE)
          7603  => 16#3024#,   --  〤 (HANGZHOU NUMERAL FOUR)
          7604  => 16#3025#,   --  〥 (HANGZHOU NUMERAL FIVE)
          7605  => 16#3026#,   --  〦 (HANGZHOU NUMERAL SIX)
          7606  => 16#3027#,   --  〧 (HANGZHOU NUMERAL SEVEN)
          7607  => 16#3028#,   --  〨 (HANGZHOU NUMERAL EIGHT)
          7608  => 16#3029#,   --  〩 (HANGZHOU NUMERAL NINE)
          7609  => 16#32A3#,   --  ㊣ (CIRCLED IDEOGRAPH CORRECT)
          7610  => 16#338E#,   --  ㎎ (SQUARE MG)
          7611  => 16#338F#,   --  ㎏ (SQUARE KG)
          7612  => 16#339C#,   --  ㎜ (SQUARE MM)
          7613  => 16#339D#,   --  ㎝ (SQUARE CM)
          7614  => 16#339E#,   --  ㎞ (SQUARE KM)
          7615  => 16#33A1#,   --  ㎡ (SQUARE M SQUARED)
          7616  => 16#33C4#,   --  ㏄ (SQUARE CC)
          7617  => 16#33CE#,   --  ㏎ (SQUARE KM CAPITAL)
          7618  => 16#33D1#,   --  ㏑ (SQUARE LN)
          7619  => 16#33D2#,   --  ㏒ (SQUARE LOG)
          7620  => 16#33D5#,   --  ㏕ (SQUARE MIL)
          7621  => 16#FE30#,   --  ︰ (PRESENTATION FORM FOR VERTICAL TWO DOT LEADER)
          7622  => 16#FFE2#,   --  ￢ (FULLWIDTH NOT SIGN)
          7623  => 16#FFE4#,   --  ￤ (FULLWIDTH BROKEN BAR)
          7624  => 16#E7E2#,   --   (<Private Use>)
          7625  => 16#2121#,   --  ℡ (TELEPHONE SIGN)
          7626  => 16#3231#,   --  ㈱ (PARENTHESIZED IDEOGRAPH STOCK)
          7627  => 16#E7E3#,   --   (<Private Use>)
          7628  => 16#2010#,   --  ‐ (HYPHEN)
          7629  => 16#E7E4#,   --   (<Private Use>)
          7630  => 16#E7E5#,   --   (<Private Use>)
          7631  => 16#E7E6#,   --   (<Private Use>)
          7632  => 16#30FC#,   --  ー (KATAKANA-HIRAGANA PROLONGED SOUND MARK)
          7633  => 16#309B#,   --  ゛ (KATAKANA-HIRAGANA VOICED SOUND MARK)
          7634  => 16#309C#,   --  ゜ (KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK)
          7635  => 16#30FD#,   --  ヽ (KATAKANA ITERATION MARK)
          7636  => 16#30FE#,   --  ヾ (KATAKANA VOICED ITERATION MARK)
          7637  => 16#3006#,   --  〆 (IDEOGRAPHIC CLOSING MARK)
          7638  => 16#309D#,   --  ゝ (HIRAGANA ITERATION MARK)
          7639  => 16#309E#,   --  ゞ (HIRAGANA VOICED ITERATION MARK)
          7640  => 16#FE49#,   --  ﹉ (DASHED OVERLINE)
          7641  => 16#FE4A#,   --  ﹊ (CENTRELINE OVERLINE)
          7642  => 16#FE4B#,   --  ﹋ (WAVY OVERLINE)
          7643  => 16#FE4C#,   --  ﹌ (DOUBLE WAVY OVERLINE)
          7644  => 16#FE4D#,   --  ﹍ (DASHED LOW LINE)
          7645  => 16#FE4E#,   --  ﹎ (CENTRELINE LOW LINE)
          7646  => 16#FE4F#,   --  ﹏ (WAVY LOW LINE)
          7647  => 16#FE50#,   --  ﹐ (SMALL COMMA)
          7648  => 16#FE51#,   --  ﹑ (SMALL IDEOGRAPHIC COMMA)
          7649  => 16#FE52#,   --  ﹒ (SMALL FULL STOP)
          7650  => 16#FE54#,   --  ﹔ (SMALL SEMICOLON)
          7651  => 16#FE55#,   --  ﹕ (SMALL COLON)
          7652  => 16#FE56#,   --  ﹖ (SMALL QUESTION MARK)
          7653  => 16#FE57#,   --  ﹗ (SMALL EXCLAMATION MARK)
          7654  => 16#FE59#,   --  ﹙ (SMALL LEFT PARENTHESIS)
          7655  => 16#FE5A#,   --  ﹚ (SMALL RIGHT PARENTHESIS)
          7656  => 16#FE5B#,   --  ﹛ (SMALL LEFT CURLY BRACKET)
          7657  => 16#FE5C#,   --  ﹜ (SMALL RIGHT CURLY BRACKET)
          7658  => 16#FE5D#,   --  ﹝ (SMALL LEFT TORTOISE SHELL BRACKET)
          7659  => 16#FE5E#,   --  ﹞ (SMALL RIGHT TORTOISE SHELL BRACKET)
          7660  => 16#FE5F#,   --  ﹟ (SMALL NUMBER SIGN)
          7661  => 16#FE60#,   --  ﹠ (SMALL AMPERSAND)
          7662  => 16#FE61#,   --  ﹡ (SMALL ASTERISK)
          7663  => 16#FE62#,   --  ﹢ (SMALL PLUS SIGN)
          7664  => 16#FE63#,   --  ﹣ (SMALL HYPHEN-MINUS)
          7665  => 16#FE64#,   --  ﹤ (SMALL LESS-THAN SIGN)
          7666  => 16#FE65#,   --  ﹥ (SMALL GREATER-THAN SIGN)
          7667  => 16#FE66#,   --  ﹦ (SMALL EQUALS SIGN)
          7668  => 16#FE68#,   --  ﹨ (SMALL REVERSE SOLIDUS)
          7669  => 16#FE69#,   --  ﹩ (SMALL DOLLAR SIGN)
          7670  => 16#FE6A#,   --  ﹪ (SMALL PERCENT SIGN)
          7671  => 16#FE6B#,   --  ﹫ (SMALL COMMERCIAL AT)
          7672  => 16#303E#,   --  〾 (IDEOGRAPHIC VARIATION INDICATOR)
          7673  => 16#2FF0#,   --  ⿰ (IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT)
          7674  => 16#2FF1#,   --  ⿱ (IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW)
          7675  => 16#2FF2#,   --  ⿲ (IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT)
          7676  => 16#2FF3#,   --  ⿳ (IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW)
          7677  => 16#2FF4#,   --  ⿴ (IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND)
          7678  => 16#2FF5#,   --  ⿵ (IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE)
          7679  => 16#2FF6#,   --  ⿶ (IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW)
          7680  => 16#2FF7#,   --  ⿷ (IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT)
          7681  => 16#2FF8#,   --  ⿸ (IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT)
          7682  => 16#2FF9#,   --  ⿹ (IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT)
          7683  => 16#2FFA#,   --  ⿺ (IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT)
          7684  => 16#2FFB#,   --  ⿻ (IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID)
          7685  => 16#3007#,   --  〇 (IDEOGRAPHIC NUMBER ZERO)
          7686  => 16#E7F4#,   --   (<Private Use>)
          7687  => 16#E7F5#,   --   (<Private Use>)
          7688  => 16#E7F6#,   --   (<Private Use>)
          7689  => 16#E7F7#,   --   (<Private Use>)
          7690  => 16#E7F8#,   --   (<Private Use>)
          7691  => 16#E7F9#,   --   (<Private Use>)
          7692  => 16#E7FA#,   --   (<Private Use>)
          7693  => 16#E7FB#,   --   (<Private Use>)
          7694  => 16#E7FC#,   --   (<Private Use>)
          7695  => 16#E7FD#,   --   (<Private Use>)
          7696  => 16#E7FE#,   --   (<Private Use>)
          7697  => 16#E7FF#,   --   (<Private Use>)
          7698  => 16#E800#,   --   (<Private Use>)
          7699  => 16#2500#,   --  ─ (BOX DRAWINGS LIGHT HORIZONTAL)
          7700  => 16#2501#,   --  ━ (BOX DRAWINGS HEAVY HORIZONTAL)
          7701  => 16#2502#,   --  │ (BOX DRAWINGS LIGHT VERTICAL)
          7702  => 16#2503#,   --  ┃ (BOX DRAWINGS HEAVY VERTICAL)
          7703  => 16#2504#,   --  ┄ (BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL)
          7704  => 16#2505#,   --  ┅ (BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL)
          7705  => 16#2506#,   --  ┆ (BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL)
          7706  => 16#2507#,   --  ┇ (BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL)
          7707  => 16#2508#,   --  ┈ (BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL)
          7708  => 16#2509#,   --  ┉ (BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL)
          7709  => 16#250A#,   --  ┊ (BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL)
          7710  => 16#250B#,   --  ┋ (BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL)
          7711  => 16#250C#,   --  ┌ (BOX DRAWINGS LIGHT DOWN AND RIGHT)
          7712  => 16#250D#,   --  ┍ (BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY)
          7713  => 16#250E#,   --  ┎ (BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT)
          7714  => 16#250F#,   --  ┏ (BOX DRAWINGS HEAVY DOWN AND RIGHT)
          7715  => 16#2510#,   --  ┐ (BOX DRAWINGS LIGHT DOWN AND LEFT)
          7716  => 16#2511#,   --  ┑ (BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY)
          7717  => 16#2512#,   --  ┒ (BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT)
          7718  => 16#2513#,   --  ┓ (BOX DRAWINGS HEAVY DOWN AND LEFT)
          7719  => 16#2514#,   --  └ (BOX DRAWINGS LIGHT UP AND RIGHT)
          7720  => 16#2515#,   --  ┕ (BOX DRAWINGS UP LIGHT AND RIGHT HEAVY)
          7721  => 16#2516#,   --  ┖ (BOX DRAWINGS UP HEAVY AND RIGHT LIGHT)
          7722  => 16#2517#,   --  ┗ (BOX DRAWINGS HEAVY UP AND RIGHT)
          7723  => 16#2518#,   --  ┘ (BOX DRAWINGS LIGHT UP AND LEFT)
          7724  => 16#2519#,   --  ┙ (BOX DRAWINGS UP LIGHT AND LEFT HEAVY)
          7725  => 16#251A#,   --  ┚ (BOX DRAWINGS UP HEAVY AND LEFT LIGHT)
          7726  => 16#251B#,   --  ┛ (BOX DRAWINGS HEAVY UP AND LEFT)
          7727  => 16#251C#,   --  ├ (BOX DRAWINGS LIGHT VERTICAL AND RIGHT)
          7728  => 16#251D#,   --  ┝ (BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY)
          7729  => 16#251E#,   --  ┞ (BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT)
          7730  => 16#251F#,   --  ┟ (BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT)
          7731  => 16#2520#,   --  ┠ (BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT)
          7732  => 16#2521#,   --  ┡ (BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY)
          7733  => 16#2522#,   --  ┢ (BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY)
          7734  => 16#2523#,   --  ┣ (BOX DRAWINGS HEAVY VERTICAL AND RIGHT)
          7735  => 16#2524#,   --  ┤ (BOX DRAWINGS LIGHT VERTICAL AND LEFT)
          7736  => 16#2525#,   --  ┥ (BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY)
          7737  => 16#2526#,   --  ┦ (BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT)
          7738  => 16#2527#,   --  ┧ (BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT)
          7739  => 16#2528#,   --  ┨ (BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT)
          7740  => 16#2529#,   --  ┩ (BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY)
          7741  => 16#252A#,   --  ┪ (BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY)
          7742  => 16#252B#,   --  ┫ (BOX DRAWINGS HEAVY VERTICAL AND LEFT)
          7743  => 16#252C#,   --  ┬ (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL)
          7744  => 16#252D#,   --  ┭ (BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT)
          7745  => 16#252E#,   --  ┮ (BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT)
          7746  => 16#252F#,   --  ┯ (BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY)
          7747  => 16#2530#,   --  ┰ (BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT)
          7748  => 16#2531#,   --  ┱ (BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY)
          7749  => 16#2532#,   --  ┲ (BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY)
          7750  => 16#2533#,   --  ┳ (BOX DRAWINGS HEAVY DOWN AND HORIZONTAL)
          7751  => 16#2534#,   --  ┴ (BOX DRAWINGS LIGHT UP AND HORIZONTAL)
          7752  => 16#2535#,   --  ┵ (BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT)
          7753  => 16#2536#,   --  ┶ (BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT)
          7754  => 16#2537#,   --  ┷ (BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY)
          7755  => 16#2538#,   --  ┸ (BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT)
          7756  => 16#2539#,   --  ┹ (BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY)
          7757  => 16#253A#,   --  ┺ (BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY)
          7758  => 16#253B#,   --  ┻ (BOX DRAWINGS HEAVY UP AND HORIZONTAL)
          7759  => 16#253C#,   --  ┼ (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL)
          7760  => 16#253D#,   --  ┽ (BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT)
          7761  => 16#253E#,   --  ┾ (BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT)
          7762  => 16#253F#,   --  ┿ (BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY)
          7763  => 16#2540#,   --  ╀ (BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT)
          7764  => 16#2541#,   --  ╁ (BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT)
          7765  => 16#2542#,   --  ╂ (BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT)
          7766  => 16#2543#,   --  ╃ (BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT)
          7767  => 16#2544#,   --  ╄ (BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT)
          7768  => 16#2545#,   --  ╅ (BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT)
          7769  => 16#2546#,   --  ╆ (BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT)
          7770  => 16#2547#,   --  ╇ (BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY)
          7771  => 16#2548#,   --  ╈ (BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY)
          7772  => 16#2549#,   --  ╉ (BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY)
          7773  => 16#254A#,   --  ╊ (BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY)
          7774  => 16#254B#,   --  ╋ (BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL)
          7775  => 16#E801#,   --   (<Private Use>)
          7776  => 16#E802#,   --   (<Private Use>)
          7777  => 16#E803#,   --   (<Private Use>)
          7778  => 16#E804#,   --   (<Private Use>)
          7779  => 16#E805#,   --   (<Private Use>)
          7780  => 16#E806#,   --   (<Private Use>)
          7781  => 16#E807#,   --   (<Private Use>)
          7782  => 16#E808#,   --   (<Private Use>)
          7783  => 16#E809#,   --   (<Private Use>)
          7784  => 16#E80A#,   --   (<Private Use>)
          7785  => 16#E80B#,   --   (<Private Use>)
          7786  => 16#E80C#,   --   (<Private Use>)
          7787  => 16#E80D#,   --   (<Private Use>)
          7788  => 16#E80E#,   --   (<Private Use>)
          7789  => 16#E80F#,   --   (<Private Use>)
          7790  => 16#72DC#,   --  狜 (<CJK Ideograph>)
          7791  => 16#72DD#,   --  狝 (<CJK Ideograph>)
          7792  => 16#72DF#,   --  狟 (<CJK Ideograph>)
          7793  => 16#72E2#,   --  狢 (<CJK Ideograph>)
          7794  => 16#72E3#,   --  狣 (<CJK Ideograph>)
          7795  => 16#72E4#,   --  狤 (<CJK Ideograph>)
          7796  => 16#72E5#,   --  狥 (<CJK Ideograph>)
          7797  => 16#72E6#,   --  狦 (<CJK Ideograph>)
          7798  => 16#72E7#,   --  狧 (<CJK Ideograph>)
          7799  => 16#72EA#,   --  狪 (<CJK Ideograph>)
          7800  => 16#72EB#,   --  狫 (<CJK Ideograph>)
          7801  => 16#72F5#,   --  狵 (<CJK Ideograph>)
          7802  => 16#72F6#,   --  狶 (<CJK Ideograph>)
          7803  => 16#72F9#,   --  狹 (<CJK Ideograph>)
          7804  => 16#72FD#,   --  狽 (<CJK Ideograph>)
          7805  => 16#72FE#,   --  狾 (<CJK Ideograph>)
          7806  => 16#72FF#,   --  狿 (<CJK Ideograph>)
          7807  => 16#7300#,   --  猀 (<CJK Ideograph>)
          7808  => 16#7302#,   --  猂 (<CJK Ideograph>)
          7809  => 16#7304#,   --  猄 (<CJK Ideograph>)
          7810  => 16#7305#,   --  猅 (<CJK Ideograph>)
          7811  => 16#7306#,   --  猆 (<CJK Ideograph>)
          7812  => 16#7307#,   --  猇 (<CJK Ideograph>)
          7813  => 16#7308#,   --  猈 (<CJK Ideograph>)
          7814  => 16#7309#,   --  猉 (<CJK Ideograph>)
          7815  => 16#730B#,   --  猋 (<CJK Ideograph>)
          7816  => 16#730C#,   --  猌 (<CJK Ideograph>)
          7817  => 16#730D#,   --  猍 (<CJK Ideograph>)
          7818  => 16#730F#,   --  猏 (<CJK Ideograph>)
          7819  => 16#7310#,   --  猐 (<CJK Ideograph>)
          7820  => 16#7311#,   --  猑 (<CJK Ideograph>)
          7821  => 16#7312#,   --  猒 (<CJK Ideograph>)
          7822  => 16#7314#,   --  猔 (<CJK Ideograph>)
          7823  => 16#7318#,   --  猘 (<CJK Ideograph>)
          7824  => 16#7319#,   --  猙 (<CJK Ideograph>)
          7825  => 16#731A#,   --  猚 (<CJK Ideograph>)
          7826  => 16#731F#,   --  猟 (<CJK Ideograph>)
          7827  => 16#7320#,   --  猠 (<CJK Ideograph>)
          7828  => 16#7323#,   --  猣 (<CJK Ideograph>)
          7829  => 16#7324#,   --  猤 (<CJK Ideograph>)
          7830  => 16#7326#,   --  猦 (<CJK Ideograph>)
          7831  => 16#7327#,   --  猧 (<CJK Ideograph>)
          7832  => 16#7328#,   --  猨 (<CJK Ideograph>)
          7833  => 16#732D#,   --  猭 (<CJK Ideograph>)
          7834  => 16#732F#,   --  猯 (<CJK Ideograph>)
          7835  => 16#7330#,   --  猰 (<CJK Ideograph>)
          7836  => 16#7332#,   --  猲 (<CJK Ideograph>)
          7837  => 16#7333#,   --  猳 (<CJK Ideograph>)
          7838  => 16#7335#,   --  猵 (<CJK Ideograph>)
          7839  => 16#7336#,   --  猶 (<CJK Ideograph>)
          7840  => 16#733A#,   --  猺 (<CJK Ideograph>)
          7841  => 16#733B#,   --  猻 (<CJK Ideograph>)
          7842  => 16#733C#,   --  猼 (<CJK Ideograph>)
          7843  => 16#733D#,   --  猽 (<CJK Ideograph>)
          7844  => 16#7340#,   --  獀 (<CJK Ideograph>)
          7845  => 16#7341#,   --  獁 (<CJK Ideograph>)
          7846  => 16#7342#,   --  獂 (<CJK Ideograph>)
          7847  => 16#7343#,   --  獃 (<CJK Ideograph>)
          7848  => 16#7344#,   --  獄 (<CJK Ideograph>)
          7849  => 16#7345#,   --  獅 (<CJK Ideograph>)
          7850  => 16#7346#,   --  獆 (<CJK Ideograph>)
          7851  => 16#7347#,   --  獇 (<CJK Ideograph>)
          7852  => 16#7348#,   --  獈 (<CJK Ideograph>)
          7853  => 16#7349#,   --  獉 (<CJK Ideograph>)
          7854  => 16#734A#,   --  獊 (<CJK Ideograph>)
          7855  => 16#734B#,   --  獋 (<CJK Ideograph>)
          7856  => 16#734C#,   --  獌 (<CJK Ideograph>)
          7857  => 16#734E#,   --  獎 (<CJK Ideograph>)
          7858  => 16#734F#,   --  獏 (<CJK Ideograph>)
          7859  => 16#7351#,   --  獑 (<CJK Ideograph>)
          7860  => 16#7353#,   --  獓 (<CJK Ideograph>)
          7861  => 16#7354#,   --  獔 (<CJK Ideograph>)
          7862  => 16#7355#,   --  獕 (<CJK Ideograph>)
          7863  => 16#7356#,   --  獖 (<CJK Ideograph>)
          7864  => 16#7358#,   --  獘 (<CJK Ideograph>)
          7865  => 16#7359#,   --  獙 (<CJK Ideograph>)
          7866  => 16#735A#,   --  獚 (<CJK Ideograph>)
          7867  => 16#735B#,   --  獛 (<CJK Ideograph>)
          7868  => 16#735C#,   --  獜 (<CJK Ideograph>)
          7869  => 16#735D#,   --  獝 (<CJK Ideograph>)
          7870  => 16#735E#,   --  獞 (<CJK Ideograph>)
          7871  => 16#735F#,   --  獟 (<CJK Ideograph>)
          7872  => 16#7361#,   --  獡 (<CJK Ideograph>)
          7873  => 16#7362#,   --  獢 (<CJK Ideograph>)
          7874  => 16#7363#,   --  獣 (<CJK Ideograph>)
          7875  => 16#7364#,   --  獤 (<CJK Ideograph>)
          7876  => 16#7365#,   --  獥 (<CJK Ideograph>)
          7877  => 16#7366#,   --  獦 (<CJK Ideograph>)
          7878  => 16#7367#,   --  獧 (<CJK Ideograph>)
          7879  => 16#7368#,   --  獨 (<CJK Ideograph>)
          7880  => 16#7369#,   --  獩 (<CJK Ideograph>)
          7881  => 16#736A#,   --  獪 (<CJK Ideograph>)
          7882  => 16#736B#,   --  獫 (<CJK Ideograph>)
          7883  => 16#736E#,   --  獮 (<CJK Ideograph>)
          7884  => 16#7370#,   --  獰 (<CJK Ideograph>)
          7885  => 16#7371#,   --  獱 (<CJK Ideograph>)
          7886  => 16#E000#,   --   (<Private Use>)
          7887  => 16#E001#,   --   (<Private Use>)
          7888  => 16#E002#,   --   (<Private Use>)
          7889  => 16#E003#,   --   (<Private Use>)
          7890  => 16#E004#,   --   (<Private Use>)
          7891  => 16#E005#,   --   (<Private Use>)
          7892  => 16#E006#,   --   (<Private Use>)
          7893  => 16#E007#,   --   (<Private Use>)
          7894  => 16#E008#,   --   (<Private Use>)
          7895  => 16#E009#,   --   (<Private Use>)
          7896  => 16#E00A#,   --   (<Private Use>)
          7897  => 16#E00B#,   --   (<Private Use>)
          7898  => 16#E00C#,   --   (<Private Use>)
          7899  => 16#E00D#,   --   (<Private Use>)
          7900  => 16#E00E#,   --   (<Private Use>)
          7901  => 16#E00F#,   --   (<Private Use>)
          7902  => 16#E010#,   --   (<Private Use>)
          7903  => 16#E011#,   --   (<Private Use>)
          7904  => 16#E012#,   --   (<Private Use>)
          7905  => 16#E013#,   --   (<Private Use>)
          7906  => 16#E014#,   --   (<Private Use>)
          7907  => 16#E015#,   --   (<Private Use>)
          7908  => 16#E016#,   --   (<Private Use>)
          7909  => 16#E017#,   --   (<Private Use>)
          7910  => 16#E018#,   --   (<Private Use>)
          7911  => 16#E019#,   --   (<Private Use>)
          7912  => 16#E01A#,   --   (<Private Use>)
          7913  => 16#E01B#,   --   (<Private Use>)
          7914  => 16#E01C#,   --   (<Private Use>)
          7915  => 16#E01D#,   --   (<Private Use>)
          7916  => 16#E01E#,   --   (<Private Use>)
          7917  => 16#E01F#,   --   (<Private Use>)
          7918  => 16#E020#,   --   (<Private Use>)
          7919  => 16#E021#,   --   (<Private Use>)
          7920  => 16#E022#,   --   (<Private Use>)
          7921  => 16#E023#,   --   (<Private Use>)
          7922  => 16#E024#,   --   (<Private Use>)
          7923  => 16#E025#,   --   (<Private Use>)
          7924  => 16#E026#,   --   (<Private Use>)
          7925  => 16#E027#,   --   (<Private Use>)
          7926  => 16#E028#,   --   (<Private Use>)
          7927  => 16#E029#,   --   (<Private Use>)
          7928  => 16#E02A#,   --   (<Private Use>)
          7929  => 16#E02B#,   --   (<Private Use>)
          7930  => 16#E02C#,   --   (<Private Use>)
          7931  => 16#E02D#,   --   (<Private Use>)
          7932  => 16#E02E#,   --   (<Private Use>)
          7933  => 16#E02F#,   --   (<Private Use>)
          7934  => 16#E030#,   --   (<Private Use>)
          7935  => 16#E031#,   --   (<Private Use>)
          7936  => 16#E032#,   --   (<Private Use>)
          7937  => 16#E033#,   --   (<Private Use>)
          7938  => 16#E034#,   --   (<Private Use>)
          7939  => 16#E035#,   --   (<Private Use>)
          7940  => 16#E036#,   --   (<Private Use>)
          7941  => 16#E037#,   --   (<Private Use>)
          7942  => 16#E038#,   --   (<Private Use>)
          7943  => 16#E039#,   --   (<Private Use>)
          7944  => 16#E03A#,   --   (<Private Use>)
          7945  => 16#E03B#,   --   (<Private Use>)
          7946  => 16#E03C#,   --   (<Private Use>)
          7947  => 16#E03D#,   --   (<Private Use>)
          7948  => 16#E03E#,   --   (<Private Use>)
          7949  => 16#E03F#,   --   (<Private Use>)
          7950  => 16#E040#,   --   (<Private Use>)
          7951  => 16#E041#,   --   (<Private Use>)
          7952  => 16#E042#,   --   (<Private Use>)
          7953  => 16#E043#,   --   (<Private Use>)
          7954  => 16#E044#,   --   (<Private Use>)
          7955  => 16#E045#,   --   (<Private Use>)
          7956  => 16#E046#,   --   (<Private Use>)
          7957  => 16#E047#,   --   (<Private Use>)
          7958  => 16#E048#,   --   (<Private Use>)
          7959  => 16#E049#,   --   (<Private Use>)
          7960  => 16#E04A#,   --   (<Private Use>)
          7961  => 16#E04B#,   --   (<Private Use>)
          7962  => 16#E04C#,   --   (<Private Use>)
          7963  => 16#E04D#,   --   (<Private Use>)
          7964  => 16#E04E#,   --   (<Private Use>)
          7965  => 16#E04F#,   --   (<Private Use>)
          7966  => 16#E050#,   --   (<Private Use>)
          7967  => 16#E051#,   --   (<Private Use>)
          7968  => 16#E052#,   --   (<Private Use>)
          7969  => 16#E053#,   --   (<Private Use>)
          7970  => 16#E054#,   --   (<Private Use>)
          7971  => 16#E055#,   --   (<Private Use>)
          7972  => 16#E056#,   --   (<Private Use>)
          7973  => 16#E057#,   --   (<Private Use>)
          7974  => 16#E058#,   --   (<Private Use>)
          7975  => 16#E059#,   --   (<Private Use>)
          7976  => 16#E05A#,   --   (<Private Use>)
          7977  => 16#E05B#,   --   (<Private Use>)
          7978  => 16#E05C#,   --   (<Private Use>)
          7979  => 16#E05D#,   --   (<Private Use>)
          7980  => 16#7372#,   --  獲 (<CJK Ideograph>)
          7981  => 16#7373#,   --  獳 (<CJK Ideograph>)
          7982  => 16#7374#,   --  獴 (<CJK Ideograph>)
          7983  => 16#7375#,   --  獵 (<CJK Ideograph>)
          7984  => 16#7376#,   --  獶 (<CJK Ideograph>)
          7985  => 16#7377#,   --  獷 (<CJK Ideograph>)
          7986  => 16#7378#,   --  獸 (<CJK Ideograph>)
          7987  => 16#7379#,   --  獹 (<CJK Ideograph>)
          7988  => 16#737A#,   --  獺 (<CJK Ideograph>)
          7989  => 16#737B#,   --  獻 (<CJK Ideograph>)
          7990  => 16#737C#,   --  獼 (<CJK Ideograph>)
          7991  => 16#737D#,   --  獽 (<CJK Ideograph>)
          7992  => 16#737F#,   --  獿 (<CJK Ideograph>)
          7993  => 16#7380#,   --  玀 (<CJK Ideograph>)
          7994  => 16#7381#,   --  玁 (<CJK Ideograph>)
          7995  => 16#7382#,   --  玂 (<CJK Ideograph>)
          7996  => 16#7383#,   --  玃 (<CJK Ideograph>)
          7997  => 16#7385#,   --  玅 (<CJK Ideograph>)
          7998  => 16#7386#,   --  玆 (<CJK Ideograph>)
          7999  => 16#7388#,   --  玈 (<CJK Ideograph>)
          8000  => 16#738A#,   --  玊 (<CJK Ideograph>)
          8001  => 16#738C#,   --  玌 (<CJK Ideograph>)
          8002  => 16#738D#,   --  玍 (<CJK Ideograph>)
          8003  => 16#738F#,   --  玏 (<CJK Ideograph>)
          8004  => 16#7390#,   --  玐 (<CJK Ideograph>)
          8005  => 16#7392#,   --  玒 (<CJK Ideograph>)
          8006  => 16#7393#,   --  玓 (<CJK Ideograph>)
          8007  => 16#7394#,   --  玔 (<CJK Ideograph>)
          8008  => 16#7395#,   --  玕 (<CJK Ideograph>)
          8009  => 16#7397#,   --  玗 (<CJK Ideograph>)
          8010  => 16#7398#,   --  玘 (<CJK Ideograph>)
          8011  => 16#7399#,   --  玙 (<CJK Ideograph>)
          8012  => 16#739A#,   --  玚 (<CJK Ideograph>)
          8013  => 16#739C#,   --  玜 (<CJK Ideograph>)
          8014  => 16#739D#,   --  玝 (<CJK Ideograph>)
          8015  => 16#739E#,   --  玞 (<CJK Ideograph>)
          8016  => 16#73A0#,   --  玠 (<CJK Ideograph>)
          8017  => 16#73A1#,   --  玡 (<CJK Ideograph>)
          8018  => 16#73A3#,   --  玣 (<CJK Ideograph>)
          8019  => 16#73A4#,   --  玤 (<CJK Ideograph>)
          8020  => 16#73A5#,   --  玥 (<CJK Ideograph>)
          8021  => 16#73A6#,   --  玦 (<CJK Ideograph>)
          8022  => 16#73A7#,   --  玧 (<CJK Ideograph>)
          8023  => 16#73A8#,   --  玨 (<CJK Ideograph>)
          8024  => 16#73AA#,   --  玪 (<CJK Ideograph>)
          8025  => 16#73AC#,   --  玬 (<CJK Ideograph>)
          8026  => 16#73AD#,   --  玭 (<CJK Ideograph>)
          8027  => 16#73B1#,   --  玱 (<CJK Ideograph>)
          8028  => 16#73B4#,   --  玴 (<CJK Ideograph>)
          8029  => 16#73B5#,   --  玵 (<CJK Ideograph>)
          8030  => 16#73B6#,   --  玶 (<CJK Ideograph>)
          8031  => 16#73B8#,   --  玸 (<CJK Ideograph>)
          8032  => 16#73B9#,   --  玹 (<CJK Ideograph>)
          8033  => 16#73BC#,   --  玼 (<CJK Ideograph>)
          8034  => 16#73BD#,   --  玽 (<CJK Ideograph>)
          8035  => 16#73BE#,   --  玾 (<CJK Ideograph>)
          8036  => 16#73BF#,   --  玿 (<CJK Ideograph>)
          8037  => 16#73C1#,   --  珁 (<CJK Ideograph>)
          8038  => 16#73C3#,   --  珃 (<CJK Ideograph>)
          8039  => 16#73C4#,   --  珄 (<CJK Ideograph>)
          8040  => 16#73C5#,   --  珅 (<CJK Ideograph>)
          8041  => 16#73C6#,   --  珆 (<CJK Ideograph>)
          8042  => 16#73C7#,   --  珇 (<CJK Ideograph>)
          8043  => 16#73CB#,   --  珋 (<CJK Ideograph>)
          8044  => 16#73CC#,   --  珌 (<CJK Ideograph>)
          8045  => 16#73CE#,   --  珎 (<CJK Ideograph>)
          8046  => 16#73D2#,   --  珒 (<CJK Ideograph>)
          8047  => 16#73D3#,   --  珓 (<CJK Ideograph>)
          8048  => 16#73D4#,   --  珔 (<CJK Ideograph>)
          8049  => 16#73D5#,   --  珕 (<CJK Ideograph>)
          8050  => 16#73D6#,   --  珖 (<CJK Ideograph>)
          8051  => 16#73D7#,   --  珗 (<CJK Ideograph>)
          8052  => 16#73D8#,   --  珘 (<CJK Ideograph>)
          8053  => 16#73DA#,   --  珚 (<CJK Ideograph>)
          8054  => 16#73DB#,   --  珛 (<CJK Ideograph>)
          8055  => 16#73DC#,   --  珜 (<CJK Ideograph>)
          8056  => 16#73DD#,   --  珝 (<CJK Ideograph>)
          8057  => 16#73DF#,   --  珟 (<CJK Ideograph>)
          8058  => 16#73E1#,   --  珡 (<CJK Ideograph>)
          8059  => 16#73E2#,   --  珢 (<CJK Ideograph>)
          8060  => 16#73E3#,   --  珣 (<CJK Ideograph>)
          8061  => 16#73E4#,   --  珤 (<CJK Ideograph>)
          8062  => 16#73E6#,   --  珦 (<CJK Ideograph>)
          8063  => 16#73E8#,   --  珨 (<CJK Ideograph>)
          8064  => 16#73EA#,   --  珪 (<CJK Ideograph>)
          8065  => 16#73EB#,   --  珫 (<CJK Ideograph>)
          8066  => 16#73EC#,   --  珬 (<CJK Ideograph>)
          8067  => 16#73EE#,   --  珮 (<CJK Ideograph>)
          8068  => 16#73EF#,   --  珯 (<CJK Ideograph>)
          8069  => 16#73F0#,   --  珰 (<CJK Ideograph>)
          8070  => 16#73F1#,   --  珱 (<CJK Ideograph>)
          8071  => 16#73F3#,   --  珳 (<CJK Ideograph>)
          8072  => 16#73F4#,   --  珴 (<CJK Ideograph>)
          8073  => 16#73F5#,   --  珵 (<CJK Ideograph>)
          8074  => 16#73F6#,   --  珶 (<CJK Ideograph>)
          8075  => 16#73F7#,   --  珷 (<CJK Ideograph>)
          8076  => 16#E05E#,   --   (<Private Use>)
          8077  => 16#E05F#,   --   (<Private Use>)
          8078  => 16#E060#,   --   (<Private Use>)
          8079  => 16#E061#,   --   (<Private Use>)
          8080  => 16#E062#,   --   (<Private Use>)
          8081  => 16#E063#,   --   (<Private Use>)
          8082  => 16#E064#,   --   (<Private Use>)
          8083  => 16#E065#,   --   (<Private Use>)
          8084  => 16#E066#,   --   (<Private Use>)
          8085  => 16#E067#,   --   (<Private Use>)
          8086  => 16#E068#,   --   (<Private Use>)
          8087  => 16#E069#,   --   (<Private Use>)
          8088  => 16#E06A#,   --   (<Private Use>)
          8089  => 16#E06B#,   --   (<Private Use>)
          8090  => 16#E06C#,   --   (<Private Use>)
          8091  => 16#E06D#,   --   (<Private Use>)
          8092  => 16#E06E#,   --   (<Private Use>)
          8093  => 16#E06F#,   --   (<Private Use>)
          8094  => 16#E070#,   --   (<Private Use>)
          8095  => 16#E071#,   --   (<Private Use>)
          8096  => 16#E072#,   --   (<Private Use>)
          8097  => 16#E073#,   --   (<Private Use>)
          8098  => 16#E074#,   --   (<Private Use>)
          8099  => 16#E075#,   --   (<Private Use>)
          8100  => 16#E076#,   --   (<Private Use>)
          8101  => 16#E077#,   --   (<Private Use>)
          8102  => 16#E078#,   --   (<Private Use>)
          8103  => 16#E079#,   --   (<Private Use>)
          8104  => 16#E07A#,   --   (<Private Use>)
          8105  => 16#E07B#,   --   (<Private Use>)
          8106  => 16#E07C#,   --   (<Private Use>)
          8107  => 16#E07D#,   --   (<Private Use>)
          8108  => 16#E07E#,   --   (<Private Use>)
          8109  => 16#E07F#,   --   (<Private Use>)
          8110  => 16#E080#,   --   (<Private Use>)
          8111  => 16#E081#,   --   (<Private Use>)
          8112  => 16#E082#,   --   (<Private Use>)
          8113  => 16#E083#,   --   (<Private Use>)
          8114  => 16#E084#,   --   (<Private Use>)
          8115  => 16#E085#,   --   (<Private Use>)
          8116  => 16#E086#,   --   (<Private Use>)
          8117  => 16#E087#,   --   (<Private Use>)
          8118  => 16#E088#,   --   (<Private Use>)
          8119  => 16#E089#,   --   (<Private Use>)
          8120  => 16#E08A#,   --   (<Private Use>)
          8121  => 16#E08B#,   --   (<Private Use>)
          8122  => 16#E08C#,   --   (<Private Use>)
          8123  => 16#E08D#,   --   (<Private Use>)
          8124  => 16#E08E#,   --   (<Private Use>)
          8125  => 16#E08F#,   --   (<Private Use>)
          8126  => 16#E090#,   --   (<Private Use>)
          8127  => 16#E091#,   --   (<Private Use>)
          8128  => 16#E092#,   --   (<Private Use>)
          8129  => 16#E093#,   --   (<Private Use>)
          8130  => 16#E094#,   --   (<Private Use>)
          8131  => 16#E095#,   --   (<Private Use>)
          8132  => 16#E096#,   --   (<Private Use>)
          8133  => 16#E097#,   --   (<Private Use>)
          8134  => 16#E098#,   --   (<Private Use>)
          8135  => 16#E099#,   --   (<Private Use>)
          8136  => 16#E09A#,   --   (<Private Use>)
          8137  => 16#E09B#,   --   (<Private Use>)
          8138  => 16#E09C#,   --   (<Private Use>)
          8139  => 16#E09D#,   --   (<Private Use>)
          8140  => 16#E09E#,   --   (<Private Use>)
          8141  => 16#E09F#,   --   (<Private Use>)
          8142  => 16#E0A0#,   --   (<Private Use>)
          8143  => 16#E0A1#,   --   (<Private Use>)
          8144  => 16#E0A2#,   --   (<Private Use>)
          8145  => 16#E0A3#,   --   (<Private Use>)
          8146  => 16#E0A4#,   --   (<Private Use>)
          8147  => 16#E0A5#,   --   (<Private Use>)
          8148  => 16#E0A6#,   --   (<Private Use>)
          8149  => 16#E0A7#,   --   (<Private Use>)
          8150  => 16#E0A8#,   --   (<Private Use>)
          8151  => 16#E0A9#,   --   (<Private Use>)
          8152  => 16#E0AA#,   --   (<Private Use>)
          8153  => 16#E0AB#,   --   (<Private Use>)
          8154  => 16#E0AC#,   --   (<Private Use>)
          8155  => 16#E0AD#,   --   (<Private Use>)
          8156  => 16#E0AE#,   --   (<Private Use>)
          8157  => 16#E0AF#,   --   (<Private Use>)
          8158  => 16#E0B0#,   --   (<Private Use>)
          8159  => 16#E0B1#,   --   (<Private Use>)
          8160  => 16#E0B2#,   --   (<Private Use>)
          8161  => 16#E0B3#,   --   (<Private Use>)
          8162  => 16#E0B4#,   --   (<Private Use>)
          8163  => 16#E0B5#,   --   (<Private Use>)
          8164  => 16#E0B6#,   --   (<Private Use>)
          8165  => 16#E0B7#,   --   (<Private Use>)
          8166  => 16#E0B8#,   --   (<Private Use>)
          8167  => 16#E0B9#,   --   (<Private Use>)
          8168  => 16#E0BA#,   --   (<Private Use>)
          8169  => 16#E0BB#,   --   (<Private Use>)
          8170  => 16#73F8#,   --  珸 (<CJK Ideograph>)
          8171  => 16#73F9#,   --  珹 (<CJK Ideograph>)
          8172  => 16#73FA#,   --  珺 (<CJK Ideograph>)
          8173  => 16#73FB#,   --  珻 (<CJK Ideograph>)
          8174  => 16#73FC#,   --  珼 (<CJK Ideograph>)
          8175  => 16#73FD#,   --  珽 (<CJK Ideograph>)
          8176  => 16#73FE#,   --  現 (<CJK Ideograph>)
          8177  => 16#73FF#,   --  珿 (<CJK Ideograph>)
          8178  => 16#7400#,   --  琀 (<CJK Ideograph>)
          8179  => 16#7401#,   --  琁 (<CJK Ideograph>)
          8180  => 16#7402#,   --  琂 (<CJK Ideograph>)
          8181  => 16#7404#,   --  琄 (<CJK Ideograph>)
          8182  => 16#7407#,   --  琇 (<CJK Ideograph>)
          8183  => 16#7408#,   --  琈 (<CJK Ideograph>)
          8184  => 16#740B#,   --  琋 (<CJK Ideograph>)
          8185  => 16#740C#,   --  琌 (<CJK Ideograph>)
          8186  => 16#740D#,   --  琍 (<CJK Ideograph>)
          8187  => 16#740E#,   --  琎 (<CJK Ideograph>)
          8188  => 16#7411#,   --  琑 (<CJK Ideograph>)
          8189  => 16#7412#,   --  琒 (<CJK Ideograph>)
          8190  => 16#7413#,   --  琓 (<CJK Ideograph>)
          8191  => 16#7414#,   --  琔 (<CJK Ideograph>)
          8192  => 16#7415#,   --  琕 (<CJK Ideograph>)
          8193  => 16#7416#,   --  琖 (<CJK Ideograph>)
          8194  => 16#7417#,   --  琗 (<CJK Ideograph>)
          8195  => 16#7418#,   --  琘 (<CJK Ideograph>)
          8196  => 16#7419#,   --  琙 (<CJK Ideograph>)
          8197  => 16#741C#,   --  琜 (<CJK Ideograph>)
          8198  => 16#741D#,   --  琝 (<CJK Ideograph>)
          8199  => 16#741E#,   --  琞 (<CJK Ideograph>)
          8200  => 16#741F#,   --  琟 (<CJK Ideograph>)
          8201  => 16#7420#,   --  琠 (<CJK Ideograph>)
          8202  => 16#7421#,   --  琡 (<CJK Ideograph>)
          8203  => 16#7423#,   --  琣 (<CJK Ideograph>)
          8204  => 16#7424#,   --  琤 (<CJK Ideograph>)
          8205  => 16#7427#,   --  琧 (<CJK Ideograph>)
          8206  => 16#7429#,   --  琩 (<CJK Ideograph>)
          8207  => 16#742B#,   --  琫 (<CJK Ideograph>)
          8208  => 16#742D#,   --  琭 (<CJK Ideograph>)
          8209  => 16#742F#,   --  琯 (<CJK Ideograph>)
          8210  => 16#7431#,   --  琱 (<CJK Ideograph>)
          8211  => 16#7432#,   --  琲 (<CJK Ideograph>)
          8212  => 16#7437#,   --  琷 (<CJK Ideograph>)
          8213  => 16#7438#,   --  琸 (<CJK Ideograph>)
          8214  => 16#7439#,   --  琹 (<CJK Ideograph>)
          8215  => 16#743A#,   --  琺 (<CJK Ideograph>)
          8216  => 16#743B#,   --  琻 (<CJK Ideograph>)
          8217  => 16#743D#,   --  琽 (<CJK Ideograph>)
          8218  => 16#743E#,   --  琾 (<CJK Ideograph>)
          8219  => 16#743F#,   --  琿 (<CJK Ideograph>)
          8220  => 16#7440#,   --  瑀 (<CJK Ideograph>)
          8221  => 16#7442#,   --  瑂 (<CJK Ideograph>)
          8222  => 16#7443#,   --  瑃 (<CJK Ideograph>)
          8223  => 16#7444#,   --  瑄 (<CJK Ideograph>)
          8224  => 16#7445#,   --  瑅 (<CJK Ideograph>)
          8225  => 16#7446#,   --  瑆 (<CJK Ideograph>)
          8226  => 16#7447#,   --  瑇 (<CJK Ideograph>)
          8227  => 16#7448#,   --  瑈 (<CJK Ideograph>)
          8228  => 16#7449#,   --  瑉 (<CJK Ideograph>)
          8229  => 16#744A#,   --  瑊 (<CJK Ideograph>)
          8230  => 16#744B#,   --  瑋 (<CJK Ideograph>)
          8231  => 16#744C#,   --  瑌 (<CJK Ideograph>)
          8232  => 16#744D#,   --  瑍 (<CJK Ideograph>)
          8233  => 16#744E#,   --  瑎 (<CJK Ideograph>)
          8234  => 16#744F#,   --  瑏 (<CJK Ideograph>)
          8235  => 16#7450#,   --  瑐 (<CJK Ideograph>)
          8236  => 16#7451#,   --  瑑 (<CJK Ideograph>)
          8237  => 16#7452#,   --  瑒 (<CJK Ideograph>)
          8238  => 16#7453#,   --  瑓 (<CJK Ideograph>)
          8239  => 16#7454#,   --  瑔 (<CJK Ideograph>)
          8240  => 16#7456#,   --  瑖 (<CJK Ideograph>)
          8241  => 16#7458#,   --  瑘 (<CJK Ideograph>)
          8242  => 16#745D#,   --  瑝 (<CJK Ideograph>)
          8243  => 16#7460#,   --  瑠 (<CJK Ideograph>)
          8244  => 16#7461#,   --  瑡 (<CJK Ideograph>)
          8245  => 16#7462#,   --  瑢 (<CJK Ideograph>)
          8246  => 16#7463#,   --  瑣 (<CJK Ideograph>)
          8247  => 16#7464#,   --  瑤 (<CJK Ideograph>)
          8248  => 16#7465#,   --  瑥 (<CJK Ideograph>)
          8249  => 16#7466#,   --  瑦 (<CJK Ideograph>)
          8250  => 16#7467#,   --  瑧 (<CJK Ideograph>)
          8251  => 16#7468#,   --  瑨 (<CJK Ideograph>)
          8252  => 16#7469#,   --  瑩 (<CJK Ideograph>)
          8253  => 16#746A#,   --  瑪 (<CJK Ideograph>)
          8254  => 16#746B#,   --  瑫 (<CJK Ideograph>)
          8255  => 16#746C#,   --  瑬 (<CJK Ideograph>)
          8256  => 16#746E#,   --  瑮 (<CJK Ideograph>)
          8257  => 16#746F#,   --  瑯 (<CJK Ideograph>)
          8258  => 16#7471#,   --  瑱 (<CJK Ideograph>)
          8259  => 16#7472#,   --  瑲 (<CJK Ideograph>)
          8260  => 16#7473#,   --  瑳 (<CJK Ideograph>)
          8261  => 16#7474#,   --  瑴 (<CJK Ideograph>)
          8262  => 16#7475#,   --  瑵 (<CJK Ideograph>)
          8263  => 16#7478#,   --  瑸 (<CJK Ideograph>)
          8264  => 16#7479#,   --  瑹 (<CJK Ideograph>)
          8265  => 16#747A#,   --  瑺 (<CJK Ideograph>)
          8266  => 16#E0BC#,   --   (<Private Use>)
          8267  => 16#E0BD#,   --   (<Private Use>)
          8268  => 16#E0BE#,   --   (<Private Use>)
          8269  => 16#E0BF#,   --   (<Private Use>)
          8270  => 16#E0C0#,   --   (<Private Use>)
          8271  => 16#E0C1#,   --   (<Private Use>)
          8272  => 16#E0C2#,   --   (<Private Use>)
          8273  => 16#E0C3#,   --   (<Private Use>)
          8274  => 16#E0C4#,   --   (<Private Use>)
          8275  => 16#E0C5#,   --   (<Private Use>)
          8276  => 16#E0C6#,   --   (<Private Use>)
          8277  => 16#E0C7#,   --   (<Private Use>)
          8278  => 16#E0C8#,   --   (<Private Use>)
          8279  => 16#E0C9#,   --   (<Private Use>)
          8280  => 16#E0CA#,   --   (<Private Use>)
          8281  => 16#E0CB#,   --   (<Private Use>)
          8282  => 16#E0CC#,   --   (<Private Use>)
          8283  => 16#E0CD#,   --   (<Private Use>)
          8284  => 16#E0CE#,   --   (<Private Use>)
          8285  => 16#E0CF#,   --   (<Private Use>)
          8286  => 16#E0D0#,   --   (<Private Use>)
          8287  => 16#E0D1#,   --   (<Private Use>)
          8288  => 16#E0D2#,   --   (<Private Use>)
          8289  => 16#E0D3#,   --   (<Private Use>)
          8290  => 16#E0D4#,   --   (<Private Use>)
          8291  => 16#E0D5#,   --   (<Private Use>)
          8292  => 16#E0D6#,   --   (<Private Use>)
          8293  => 16#E0D7#,   --   (<Private Use>)
          8294  => 16#E0D8#,   --   (<Private Use>)
          8295  => 16#E0D9#,   --   (<Private Use>)
          8296  => 16#E0DA#,   --   (<Private Use>)
          8297  => 16#E0DB#,   --   (<Private Use>)
          8298  => 16#E0DC#,   --   (<Private Use>)
          8299  => 16#E0DD#,   --   (<Private Use>)
          8300  => 16#E0DE#,   --   (<Private Use>)
          8301  => 16#E0DF#,   --   (<Private Use>)
          8302  => 16#E0E0#,   --   (<Private Use>)
          8303  => 16#E0E1#,   --   (<Private Use>)
          8304  => 16#E0E2#,   --   (<Private Use>)
          8305  => 16#E0E3#,   --   (<Private Use>)
          8306  => 16#E0E4#,   --   (<Private Use>)
          8307  => 16#E0E5#,   --   (<Private Use>)
          8308  => 16#E0E6#,   --   (<Private Use>)
          8309  => 16#E0E7#,   --   (<Private Use>)
          8310  => 16#E0E8#,   --   (<Private Use>)
          8311  => 16#E0E9#,   --   (<Private Use>)
          8312  => 16#E0EA#,   --   (<Private Use>)
          8313  => 16#E0EB#,   --   (<Private Use>)
          8314  => 16#E0EC#,   --   (<Private Use>)
          8315  => 16#E0ED#,   --   (<Private Use>)
          8316  => 16#E0EE#,   --   (<Private Use>)
          8317  => 16#E0EF#,   --   (<Private Use>)
          8318  => 16#E0F0#,   --   (<Private Use>)
          8319  => 16#E0F1#,   --   (<Private Use>)
          8320  => 16#E0F2#,   --   (<Private Use>)
          8321  => 16#E0F3#,   --   (<Private Use>)
          8322  => 16#E0F4#,   --   (<Private Use>)
          8323  => 16#E0F5#,   --   (<Private Use>)
          8324  => 16#E0F6#,   --   (<Private Use>)
          8325  => 16#E0F7#,   --   (<Private Use>)
          8326  => 16#E0F8#,   --   (<Private Use>)
          8327  => 16#E0F9#,   --   (<Private Use>)
          8328  => 16#E0FA#,   --   (<Private Use>)
          8329  => 16#E0FB#,   --   (<Private Use>)
          8330  => 16#E0FC#,   --   (<Private Use>)
          8331  => 16#E0FD#,   --   (<Private Use>)
          8332  => 16#E0FE#,   --   (<Private Use>)
          8333  => 16#E0FF#,   --   (<Private Use>)
          8334  => 16#E100#,   --   (<Private Use>)
          8335  => 16#E101#,   --   (<Private Use>)
          8336  => 16#E102#,   --   (<Private Use>)
          8337  => 16#E103#,   --   (<Private Use>)
          8338  => 16#E104#,   --   (<Private Use>)
          8339  => 16#E105#,   --   (<Private Use>)
          8340  => 16#E106#,   --   (<Private Use>)
          8341  => 16#E107#,   --   (<Private Use>)
          8342  => 16#E108#,   --   (<Private Use>)
          8343  => 16#E109#,   --   (<Private Use>)
          8344  => 16#E10A#,   --   (<Private Use>)
          8345  => 16#E10B#,   --   (<Private Use>)
          8346  => 16#E10C#,   --   (<Private Use>)
          8347  => 16#E10D#,   --   (<Private Use>)
          8348  => 16#E10E#,   --   (<Private Use>)
          8349  => 16#E10F#,   --   (<Private Use>)
          8350  => 16#E110#,   --   (<Private Use>)
          8351  => 16#E111#,   --   (<Private Use>)
          8352  => 16#E112#,   --   (<Private Use>)
          8353  => 16#E113#,   --   (<Private Use>)
          8354  => 16#E114#,   --   (<Private Use>)
          8355  => 16#E115#,   --   (<Private Use>)
          8356  => 16#E116#,   --   (<Private Use>)
          8357  => 16#E117#,   --   (<Private Use>)
          8358  => 16#E118#,   --   (<Private Use>)
          8359  => 16#E119#,   --   (<Private Use>)
          8360  => 16#747B#,   --  瑻 (<CJK Ideograph>)
          8361  => 16#747C#,   --  瑼 (<CJK Ideograph>)
          8362  => 16#747D#,   --  瑽 (<CJK Ideograph>)
          8363  => 16#747F#,   --  瑿 (<CJK Ideograph>)
          8364  => 16#7482#,   --  璂 (<CJK Ideograph>)
          8365  => 16#7484#,   --  璄 (<CJK Ideograph>)
          8366  => 16#7485#,   --  璅 (<CJK Ideograph>)
          8367  => 16#7486#,   --  璆 (<CJK Ideograph>)
          8368  => 16#7488#,   --  璈 (<CJK Ideograph>)
          8369  => 16#7489#,   --  璉 (<CJK Ideograph>)
          8370  => 16#748A#,   --  璊 (<CJK Ideograph>)
          8371  => 16#748C#,   --  璌 (<CJK Ideograph>)
          8372  => 16#748D#,   --  璍 (<CJK Ideograph>)
          8373  => 16#748F#,   --  璏 (<CJK Ideograph>)
          8374  => 16#7491#,   --  璑 (<CJK Ideograph>)
          8375  => 16#7492#,   --  璒 (<CJK Ideograph>)
          8376  => 16#7493#,   --  璓 (<CJK Ideograph>)
          8377  => 16#7494#,   --  璔 (<CJK Ideograph>)
          8378  => 16#7495#,   --  璕 (<CJK Ideograph>)
          8379  => 16#7496#,   --  璖 (<CJK Ideograph>)
          8380  => 16#7497#,   --  璗 (<CJK Ideograph>)
          8381  => 16#7498#,   --  璘 (<CJK Ideograph>)
          8382  => 16#7499#,   --  璙 (<CJK Ideograph>)
          8383  => 16#749A#,   --  璚 (<CJK Ideograph>)
          8384  => 16#749B#,   --  璛 (<CJK Ideograph>)
          8385  => 16#749D#,   --  璝 (<CJK Ideograph>)
          8386  => 16#749F#,   --  璟 (<CJK Ideograph>)
          8387  => 16#74A0#,   --  璠 (<CJK Ideograph>)
          8388  => 16#74A1#,   --  璡 (<CJK Ideograph>)
          8389  => 16#74A2#,   --  璢 (<CJK Ideograph>)
          8390  => 16#74A3#,   --  璣 (<CJK Ideograph>)
          8391  => 16#74A4#,   --  璤 (<CJK Ideograph>)
          8392  => 16#74A5#,   --  璥 (<CJK Ideograph>)
          8393  => 16#74A6#,   --  璦 (<CJK Ideograph>)
          8394  => 16#74AA#,   --  璪 (<CJK Ideograph>)
          8395  => 16#74AB#,   --  璫 (<CJK Ideograph>)
          8396  => 16#74AC#,   --  璬 (<CJK Ideograph>)
          8397  => 16#74AD#,   --  璭 (<CJK Ideograph>)
          8398  => 16#74AE#,   --  璮 (<CJK Ideograph>)
          8399  => 16#74AF#,   --  璯 (<CJK Ideograph>)
          8400  => 16#74B0#,   --  環 (<CJK Ideograph>)
          8401  => 16#74B1#,   --  璱 (<CJK Ideograph>)
          8402  => 16#74B2#,   --  璲 (<CJK Ideograph>)
          8403  => 16#74B3#,   --  璳 (<CJK Ideograph>)
          8404  => 16#74B4#,   --  璴 (<CJK Ideograph>)
          8405  => 16#74B5#,   --  璵 (<CJK Ideograph>)
          8406  => 16#74B6#,   --  璶 (<CJK Ideograph>)
          8407  => 16#74B7#,   --  璷 (<CJK Ideograph>)
          8408  => 16#74B8#,   --  璸 (<CJK Ideograph>)
          8409  => 16#74B9#,   --  璹 (<CJK Ideograph>)
          8410  => 16#74BB#,   --  璻 (<CJK Ideograph>)
          8411  => 16#74BC#,   --  璼 (<CJK Ideograph>)
          8412  => 16#74BD#,   --  璽 (<CJK Ideograph>)
          8413  => 16#74BE#,   --  璾 (<CJK Ideograph>)
          8414  => 16#74BF#,   --  璿 (<CJK Ideograph>)
          8415  => 16#74C0#,   --  瓀 (<CJK Ideograph>)
          8416  => 16#74C1#,   --  瓁 (<CJK Ideograph>)
          8417  => 16#74C2#,   --  瓂 (<CJK Ideograph>)
          8418  => 16#74C3#,   --  瓃 (<CJK Ideograph>)
          8419  => 16#74C4#,   --  瓄 (<CJK Ideograph>)
          8420  => 16#74C5#,   --  瓅 (<CJK Ideograph>)
          8421  => 16#74C6#,   --  瓆 (<CJK Ideograph>)
          8422  => 16#74C7#,   --  瓇 (<CJK Ideograph>)
          8423  => 16#74C8#,   --  瓈 (<CJK Ideograph>)
          8424  => 16#74C9#,   --  瓉 (<CJK Ideograph>)
          8425  => 16#74CA#,   --  瓊 (<CJK Ideograph>)
          8426  => 16#74CB#,   --  瓋 (<CJK Ideograph>)
          8427  => 16#74CC#,   --  瓌 (<CJK Ideograph>)
          8428  => 16#74CD#,   --  瓍 (<CJK Ideograph>)
          8429  => 16#74CE#,   --  瓎 (<CJK Ideograph>)
          8430  => 16#74CF#,   --  瓏 (<CJK Ideograph>)
          8431  => 16#74D0#,   --  瓐 (<CJK Ideograph>)
          8432  => 16#74D1#,   --  瓑 (<CJK Ideograph>)
          8433  => 16#74D3#,   --  瓓 (<CJK Ideograph>)
          8434  => 16#74D4#,   --  瓔 (<CJK Ideograph>)
          8435  => 16#74D5#,   --  瓕 (<CJK Ideograph>)
          8436  => 16#74D6#,   --  瓖 (<CJK Ideograph>)
          8437  => 16#74D7#,   --  瓗 (<CJK Ideograph>)
          8438  => 16#74D8#,   --  瓘 (<CJK Ideograph>)
          8439  => 16#74D9#,   --  瓙 (<CJK Ideograph>)
          8440  => 16#74DA#,   --  瓚 (<CJK Ideograph>)
          8441  => 16#74DB#,   --  瓛 (<CJK Ideograph>)
          8442  => 16#74DD#,   --  瓝 (<CJK Ideograph>)
          8443  => 16#74DF#,   --  瓟 (<CJK Ideograph>)
          8444  => 16#74E1#,   --  瓡 (<CJK Ideograph>)
          8445  => 16#74E5#,   --  瓥 (<CJK Ideograph>)
          8446  => 16#74E7#,   --  瓧 (<CJK Ideograph>)
          8447  => 16#74E8#,   --  瓨 (<CJK Ideograph>)
          8448  => 16#74E9#,   --  瓩 (<CJK Ideograph>)
          8449  => 16#74EA#,   --  瓪 (<CJK Ideograph>)
          8450  => 16#74EB#,   --  瓫 (<CJK Ideograph>)
          8451  => 16#74EC#,   --  瓬 (<CJK Ideograph>)
          8452  => 16#74ED#,   --  瓭 (<CJK Ideograph>)
          8453  => 16#74F0#,   --  瓰 (<CJK Ideograph>)
          8454  => 16#74F1#,   --  瓱 (<CJK Ideograph>)
          8455  => 16#74F2#,   --  瓲 (<CJK Ideograph>)
          8456  => 16#E11A#,   --   (<Private Use>)
          8457  => 16#E11B#,   --   (<Private Use>)
          8458  => 16#E11C#,   --   (<Private Use>)
          8459  => 16#E11D#,   --   (<Private Use>)
          8460  => 16#E11E#,   --   (<Private Use>)
          8461  => 16#E11F#,   --   (<Private Use>)
          8462  => 16#E120#,   --   (<Private Use>)
          8463  => 16#E121#,   --   (<Private Use>)
          8464  => 16#E122#,   --   (<Private Use>)
          8465  => 16#E123#,   --   (<Private Use>)
          8466  => 16#E124#,   --   (<Private Use>)
          8467  => 16#E125#,   --   (<Private Use>)
          8468  => 16#E126#,   --   (<Private Use>)
          8469  => 16#E127#,   --   (<Private Use>)
          8470  => 16#E128#,   --   (<Private Use>)
          8471  => 16#E129#,   --   (<Private Use>)
          8472  => 16#E12A#,   --   (<Private Use>)
          8473  => 16#E12B#,   --   (<Private Use>)
          8474  => 16#E12C#,   --   (<Private Use>)
          8475  => 16#E12D#,   --   (<Private Use>)
          8476  => 16#E12E#,   --   (<Private Use>)
          8477  => 16#E12F#,   --   (<Private Use>)
          8478  => 16#E130#,   --   (<Private Use>)
          8479  => 16#E131#,   --   (<Private Use>)
          8480  => 16#E132#,   --   (<Private Use>)
          8481  => 16#E133#,   --   (<Private Use>)
          8482  => 16#E134#,   --   (<Private Use>)
          8483  => 16#E135#,   --   (<Private Use>)
          8484  => 16#E136#,   --   (<Private Use>)
          8485  => 16#E137#,   --   (<Private Use>)
          8486  => 16#E138#,   --   (<Private Use>)
          8487  => 16#E139#,   --   (<Private Use>)
          8488  => 16#E13A#,   --   (<Private Use>)
          8489  => 16#E13B#,   --   (<Private Use>)
          8490  => 16#E13C#,   --   (<Private Use>)
          8491  => 16#E13D#,   --   (<Private Use>)
          8492  => 16#E13E#,   --   (<Private Use>)
          8493  => 16#E13F#,   --   (<Private Use>)
          8494  => 16#E140#,   --   (<Private Use>)
          8495  => 16#E141#,   --   (<Private Use>)
          8496  => 16#E142#,   --   (<Private Use>)
          8497  => 16#E143#,   --   (<Private Use>)
          8498  => 16#E144#,   --   (<Private Use>)
          8499  => 16#E145#,   --   (<Private Use>)
          8500  => 16#E146#,   --   (<Private Use>)
          8501  => 16#E147#,   --   (<Private Use>)
          8502  => 16#E148#,   --   (<Private Use>)
          8503  => 16#E149#,   --   (<Private Use>)
          8504  => 16#E14A#,   --   (<Private Use>)
          8505  => 16#E14B#,   --   (<Private Use>)
          8506  => 16#E14C#,   --   (<Private Use>)
          8507  => 16#E14D#,   --   (<Private Use>)
          8508  => 16#E14E#,   --   (<Private Use>)
          8509  => 16#E14F#,   --   (<Private Use>)
          8510  => 16#E150#,   --   (<Private Use>)
          8511  => 16#E151#,   --   (<Private Use>)
          8512  => 16#E152#,   --   (<Private Use>)
          8513  => 16#E153#,   --   (<Private Use>)
          8514  => 16#E154#,   --   (<Private Use>)
          8515  => 16#E155#,   --   (<Private Use>)
          8516  => 16#E156#,   --   (<Private Use>)
          8517  => 16#E157#,   --   (<Private Use>)
          8518  => 16#E158#,   --   (<Private Use>)
          8519  => 16#E159#,   --   (<Private Use>)
          8520  => 16#E15A#,   --   (<Private Use>)
          8521  => 16#E15B#,   --   (<Private Use>)
          8522  => 16#E15C#,   --   (<Private Use>)
          8523  => 16#E15D#,   --   (<Private Use>)
          8524  => 16#E15E#,   --   (<Private Use>)
          8525  => 16#E15F#,   --   (<Private Use>)
          8526  => 16#E160#,   --   (<Private Use>)
          8527  => 16#E161#,   --   (<Private Use>)
          8528  => 16#E162#,   --   (<Private Use>)
          8529  => 16#E163#,   --   (<Private Use>)
          8530  => 16#E164#,   --   (<Private Use>)
          8531  => 16#E165#,   --   (<Private Use>)
          8532  => 16#E166#,   --   (<Private Use>)
          8533  => 16#E167#,   --   (<Private Use>)
          8534  => 16#E168#,   --   (<Private Use>)
          8535  => 16#E169#,   --   (<Private Use>)
          8536  => 16#E16A#,   --   (<Private Use>)
          8537  => 16#E16B#,   --   (<Private Use>)
          8538  => 16#E16C#,   --   (<Private Use>)
          8539  => 16#E16D#,   --   (<Private Use>)
          8540  => 16#E16E#,   --   (<Private Use>)
          8541  => 16#E16F#,   --   (<Private Use>)
          8542  => 16#E170#,   --   (<Private Use>)
          8543  => 16#E171#,   --   (<Private Use>)
          8544  => 16#E172#,   --   (<Private Use>)
          8545  => 16#E173#,   --   (<Private Use>)
          8546  => 16#E174#,   --   (<Private Use>)
          8547  => 16#E175#,   --   (<Private Use>)
          8548  => 16#E176#,   --   (<Private Use>)
          8549  => 16#E177#,   --   (<Private Use>)
          8550  => 16#74F3#,   --  瓳 (<CJK Ideograph>)
          8551  => 16#74F5#,   --  瓵 (<CJK Ideograph>)
          8552  => 16#74F8#,   --  瓸 (<CJK Ideograph>)
          8553  => 16#74F9#,   --  瓹 (<CJK Ideograph>)
          8554  => 16#74FA#,   --  瓺 (<CJK Ideograph>)
          8555  => 16#74FB#,   --  瓻 (<CJK Ideograph>)
          8556  => 16#74FC#,   --  瓼 (<CJK Ideograph>)
          8557  => 16#74FD#,   --  瓽 (<CJK Ideograph>)
          8558  => 16#74FE#,   --  瓾 (<CJK Ideograph>)
          8559  => 16#7500#,   --  甀 (<CJK Ideograph>)
          8560  => 16#7501#,   --  甁 (<CJK Ideograph>)
          8561  => 16#7502#,   --  甂 (<CJK Ideograph>)
          8562  => 16#7503#,   --  甃 (<CJK Ideograph>)
          8563  => 16#7505#,   --  甅 (<CJK Ideograph>)
          8564  => 16#7506#,   --  甆 (<CJK Ideograph>)
          8565  => 16#7507#,   --  甇 (<CJK Ideograph>)
          8566  => 16#7508#,   --  甈 (<CJK Ideograph>)
          8567  => 16#7509#,   --  甉 (<CJK Ideograph>)
          8568  => 16#750A#,   --  甊 (<CJK Ideograph>)
          8569  => 16#750B#,   --  甋 (<CJK Ideograph>)
          8570  => 16#750C#,   --  甌 (<CJK Ideograph>)
          8571  => 16#750E#,   --  甎 (<CJK Ideograph>)
          8572  => 16#7510#,   --  甐 (<CJK Ideograph>)
          8573  => 16#7512#,   --  甒 (<CJK Ideograph>)
          8574  => 16#7514#,   --  甔 (<CJK Ideograph>)
          8575  => 16#7515#,   --  甕 (<CJK Ideograph>)
          8576  => 16#7516#,   --  甖 (<CJK Ideograph>)
          8577  => 16#7517#,   --  甗 (<CJK Ideograph>)
          8578  => 16#751B#,   --  甛 (<CJK Ideograph>)
          8579  => 16#751D#,   --  甝 (<CJK Ideograph>)
          8580  => 16#751E#,   --  甞 (<CJK Ideograph>)
          8581  => 16#7520#,   --  甠 (<CJK Ideograph>)
          8582  => 16#7521#,   --  甡 (<CJK Ideograph>)
          8583  => 16#7522#,   --  產 (<CJK Ideograph>)
          8584  => 16#7523#,   --  産 (<CJK Ideograph>)
          8585  => 16#7524#,   --  甤 (<CJK Ideograph>)
          8586  => 16#7526#,   --  甦 (<CJK Ideograph>)
          8587  => 16#7527#,   --  甧 (<CJK Ideograph>)
          8588  => 16#752A#,   --  甪 (<CJK Ideograph>)
          8589  => 16#752E#,   --  甮 (<CJK Ideograph>)
          8590  => 16#7534#,   --  甴 (<CJK Ideograph>)
          8591  => 16#7536#,   --  甶 (<CJK Ideograph>)
          8592  => 16#7539#,   --  甹 (<CJK Ideograph>)
          8593  => 16#753C#,   --  甼 (<CJK Ideograph>)
          8594  => 16#753D#,   --  甽 (<CJK Ideograph>)
          8595  => 16#753F#,   --  甿 (<CJK Ideograph>)
          8596  => 16#7541#,   --  畁 (<CJK Ideograph>)
          8597  => 16#7542#,   --  畂 (<CJK Ideograph>)
          8598  => 16#7543#,   --  畃 (<CJK Ideograph>)
          8599  => 16#7544#,   --  畄 (<CJK Ideograph>)
          8600  => 16#7546#,   --  畆 (<CJK Ideograph>)
          8601  => 16#7547#,   --  畇 (<CJK Ideograph>)
          8602  => 16#7549#,   --  畉 (<CJK Ideograph>)
          8603  => 16#754A#,   --  畊 (<CJK Ideograph>)
          8604  => 16#754D#,   --  畍 (<CJK Ideograph>)
          8605  => 16#7550#,   --  畐 (<CJK Ideograph>)
          8606  => 16#7551#,   --  畑 (<CJK Ideograph>)
          8607  => 16#7552#,   --  畒 (<CJK Ideograph>)
          8608  => 16#7553#,   --  畓 (<CJK Ideograph>)
          8609  => 16#7555#,   --  畕 (<CJK Ideograph>)
          8610  => 16#7556#,   --  畖 (<CJK Ideograph>)
          8611  => 16#7557#,   --  畗 (<CJK Ideograph>)
          8612  => 16#7558#,   --  畘 (<CJK Ideograph>)
          8613  => 16#755D#,   --  畝 (<CJK Ideograph>)
          8614  => 16#755E#,   --  畞 (<CJK Ideograph>)
          8615  => 16#755F#,   --  畟 (<CJK Ideograph>)
          8616  => 16#7560#,   --  畠 (<CJK Ideograph>)
          8617  => 16#7561#,   --  畡 (<CJK Ideograph>)
          8618  => 16#7562#,   --  畢 (<CJK Ideograph>)
          8619  => 16#7563#,   --  畣 (<CJK Ideograph>)
          8620  => 16#7564#,   --  畤 (<CJK Ideograph>)
          8621  => 16#7567#,   --  畧 (<CJK Ideograph>)
          8622  => 16#7568#,   --  畨 (<CJK Ideograph>)
          8623  => 16#7569#,   --  畩 (<CJK Ideograph>)
          8624  => 16#756B#,   --  畫 (<CJK Ideograph>)
          8625  => 16#756C#,   --  畬 (<CJK Ideograph>)
          8626  => 16#756D#,   --  畭 (<CJK Ideograph>)
          8627  => 16#756E#,   --  畮 (<CJK Ideograph>)
          8628  => 16#756F#,   --  畯 (<CJK Ideograph>)
          8629  => 16#7570#,   --  異 (<CJK Ideograph>)
          8630  => 16#7571#,   --  畱 (<CJK Ideograph>)
          8631  => 16#7573#,   --  畳 (<CJK Ideograph>)
          8632  => 16#7575#,   --  畵 (<CJK Ideograph>)
          8633  => 16#7576#,   --  當 (<CJK Ideograph>)
          8634  => 16#7577#,   --  畷 (<CJK Ideograph>)
          8635  => 16#757A#,   --  畺 (<CJK Ideograph>)
          8636  => 16#757B#,   --  畻 (<CJK Ideograph>)
          8637  => 16#757C#,   --  畼 (<CJK Ideograph>)
          8638  => 16#757D#,   --  畽 (<CJK Ideograph>)
          8639  => 16#757E#,   --  畾 (<CJK Ideograph>)
          8640  => 16#7580#,   --  疀 (<CJK Ideograph>)
          8641  => 16#7581#,   --  疁 (<CJK Ideograph>)
          8642  => 16#7582#,   --  疂 (<CJK Ideograph>)
          8643  => 16#7584#,   --  疄 (<CJK Ideograph>)
          8644  => 16#7585#,   --  疅 (<CJK Ideograph>)
          8645  => 16#7587#,   --  疇 (<CJK Ideograph>)
          8646  => 16#E178#,   --   (<Private Use>)
          8647  => 16#E179#,   --   (<Private Use>)
          8648  => 16#E17A#,   --   (<Private Use>)
          8649  => 16#E17B#,   --   (<Private Use>)
          8650  => 16#E17C#,   --   (<Private Use>)
          8651  => 16#E17D#,   --   (<Private Use>)
          8652  => 16#E17E#,   --   (<Private Use>)
          8653  => 16#E17F#,   --   (<Private Use>)
          8654  => 16#E180#,   --   (<Private Use>)
          8655  => 16#E181#,   --   (<Private Use>)
          8656  => 16#E182#,   --   (<Private Use>)
          8657  => 16#E183#,   --   (<Private Use>)
          8658  => 16#E184#,   --   (<Private Use>)
          8659  => 16#E185#,   --   (<Private Use>)
          8660  => 16#E186#,   --   (<Private Use>)
          8661  => 16#E187#,   --   (<Private Use>)
          8662  => 16#E188#,   --   (<Private Use>)
          8663  => 16#E189#,   --   (<Private Use>)
          8664  => 16#E18A#,   --   (<Private Use>)
          8665  => 16#E18B#,   --   (<Private Use>)
          8666  => 16#E18C#,   --   (<Private Use>)
          8667  => 16#E18D#,   --   (<Private Use>)
          8668  => 16#E18E#,   --   (<Private Use>)
          8669  => 16#E18F#,   --   (<Private Use>)
          8670  => 16#E190#,   --   (<Private Use>)
          8671  => 16#E191#,   --   (<Private Use>)
          8672  => 16#E192#,   --   (<Private Use>)
          8673  => 16#E193#,   --   (<Private Use>)
          8674  => 16#E194#,   --   (<Private Use>)
          8675  => 16#E195#,   --   (<Private Use>)
          8676  => 16#E196#,   --   (<Private Use>)
          8677  => 16#E197#,   --   (<Private Use>)
          8678  => 16#E198#,   --   (<Private Use>)
          8679  => 16#E199#,   --   (<Private Use>)
          8680  => 16#E19A#,   --   (<Private Use>)
          8681  => 16#E19B#,   --   (<Private Use>)
          8682  => 16#E19C#,   --   (<Private Use>)
          8683  => 16#E19D#,   --   (<Private Use>)
          8684  => 16#E19E#,   --   (<Private Use>)
          8685  => 16#E19F#,   --   (<Private Use>)
          8686  => 16#E1A0#,   --   (<Private Use>)
          8687  => 16#E1A1#,   --   (<Private Use>)
          8688  => 16#E1A2#,   --   (<Private Use>)
          8689  => 16#E1A3#,   --   (<Private Use>)
          8690  => 16#E1A4#,   --   (<Private Use>)
          8691  => 16#E1A5#,   --   (<Private Use>)
          8692  => 16#E1A6#,   --   (<Private Use>)
          8693  => 16#E1A7#,   --   (<Private Use>)
          8694  => 16#E1A8#,   --   (<Private Use>)
          8695  => 16#E1A9#,   --   (<Private Use>)
          8696  => 16#E1AA#,   --   (<Private Use>)
          8697  => 16#E1AB#,   --   (<Private Use>)
          8698  => 16#E1AC#,   --   (<Private Use>)
          8699  => 16#E1AD#,   --   (<Private Use>)
          8700  => 16#E1AE#,   --   (<Private Use>)
          8701  => 16#E1AF#,   --   (<Private Use>)
          8702  => 16#E1B0#,   --   (<Private Use>)
          8703  => 16#E1B1#,   --   (<Private Use>)
          8704  => 16#E1B2#,   --   (<Private Use>)
          8705  => 16#E1B3#,   --   (<Private Use>)
          8706  => 16#E1B4#,   --   (<Private Use>)
          8707  => 16#E1B5#,   --   (<Private Use>)
          8708  => 16#E1B6#,   --   (<Private Use>)
          8709  => 16#E1B7#,   --   (<Private Use>)
          8710  => 16#E1B8#,   --   (<Private Use>)
          8711  => 16#E1B9#,   --   (<Private Use>)
          8712  => 16#E1BA#,   --   (<Private Use>)
          8713  => 16#E1BB#,   --   (<Private Use>)
          8714  => 16#E1BC#,   --   (<Private Use>)
          8715  => 16#E1BD#,   --   (<Private Use>)
          8716  => 16#E1BE#,   --   (<Private Use>)
          8717  => 16#E1BF#,   --   (<Private Use>)
          8718  => 16#E1C0#,   --   (<Private Use>)
          8719  => 16#E1C1#,   --   (<Private Use>)
          8720  => 16#E1C2#,   --   (<Private Use>)
          8721  => 16#E1C3#,   --   (<Private Use>)
          8722  => 16#E1C4#,   --   (<Private Use>)
          8723  => 16#E1C5#,   --   (<Private Use>)
          8724  => 16#E1C6#,   --   (<Private Use>)
          8725  => 16#E1C7#,   --   (<Private Use>)
          8726  => 16#E1C8#,   --   (<Private Use>)
          8727  => 16#E1C9#,   --   (<Private Use>)
          8728  => 16#E1CA#,   --   (<Private Use>)
          8729  => 16#E1CB#,   --   (<Private Use>)
          8730  => 16#E1CC#,   --   (<Private Use>)
          8731  => 16#E1CD#,   --   (<Private Use>)
          8732  => 16#E1CE#,   --   (<Private Use>)
          8733  => 16#E1CF#,   --   (<Private Use>)
          8734  => 16#E1D0#,   --   (<Private Use>)
          8735  => 16#E1D1#,   --   (<Private Use>)
          8736  => 16#E1D2#,   --   (<Private Use>)
          8737  => 16#E1D3#,   --   (<Private Use>)
          8738  => 16#E1D4#,   --   (<Private Use>)
          8739  => 16#E1D5#,   --   (<Private Use>)
          8740  => 16#7588#,   --  疈 (<CJK Ideograph>)
          8741  => 16#7589#,   --  疉 (<CJK Ideograph>)
          8742  => 16#758A#,   --  疊 (<CJK Ideograph>)
          8743  => 16#758C#,   --  疌 (<CJK Ideograph>)
          8744  => 16#758D#,   --  疍 (<CJK Ideograph>)
          8745  => 16#758E#,   --  疎 (<CJK Ideograph>)
          8746  => 16#7590#,   --  疐 (<CJK Ideograph>)
          8747  => 16#7593#,   --  疓 (<CJK Ideograph>)
          8748  => 16#7595#,   --  疕 (<CJK Ideograph>)
          8749  => 16#7598#,   --  疘 (<CJK Ideograph>)
          8750  => 16#759B#,   --  疛 (<CJK Ideograph>)
          8751  => 16#759C#,   --  疜 (<CJK Ideograph>)
          8752  => 16#759E#,   --  疞 (<CJK Ideograph>)
          8753  => 16#75A2#,   --  疢 (<CJK Ideograph>)
          8754  => 16#75A6#,   --  疦 (<CJK Ideograph>)
          8755  => 16#75A7#,   --  疧 (<CJK Ideograph>)
          8756  => 16#75A8#,   --  疨 (<CJK Ideograph>)
          8757  => 16#75A9#,   --  疩 (<CJK Ideograph>)
          8758  => 16#75AA#,   --  疪 (<CJK Ideograph>)
          8759  => 16#75AD#,   --  疭 (<CJK Ideograph>)
          8760  => 16#75B6#,   --  疶 (<CJK Ideograph>)
          8761  => 16#75B7#,   --  疷 (<CJK Ideograph>)
          8762  => 16#75BA#,   --  疺 (<CJK Ideograph>)
          8763  => 16#75BB#,   --  疻 (<CJK Ideograph>)
          8764  => 16#75BF#,   --  疿 (<CJK Ideograph>)
          8765  => 16#75C0#,   --  痀 (<CJK Ideograph>)
          8766  => 16#75C1#,   --  痁 (<CJK Ideograph>)
          8767  => 16#75C6#,   --  痆 (<CJK Ideograph>)
          8768  => 16#75CB#,   --  痋 (<CJK Ideograph>)
          8769  => 16#75CC#,   --  痌 (<CJK Ideograph>)
          8770  => 16#75CE#,   --  痎 (<CJK Ideograph>)
          8771  => 16#75CF#,   --  痏 (<CJK Ideograph>)
          8772  => 16#75D0#,   --  痐 (<CJK Ideograph>)
          8773  => 16#75D1#,   --  痑 (<CJK Ideograph>)
          8774  => 16#75D3#,   --  痓 (<CJK Ideograph>)
          8775  => 16#75D7#,   --  痗 (<CJK Ideograph>)
          8776  => 16#75D9#,   --  痙 (<CJK Ideograph>)
          8777  => 16#75DA#,   --  痚 (<CJK Ideograph>)
          8778  => 16#75DC#,   --  痜 (<CJK Ideograph>)
          8779  => 16#75DD#,   --  痝 (<CJK Ideograph>)
          8780  => 16#75DF#,   --  痟 (<CJK Ideograph>)
          8781  => 16#75E0#,   --  痠 (<CJK Ideograph>)
          8782  => 16#75E1#,   --  痡 (<CJK Ideograph>)
          8783  => 16#75E5#,   --  痥 (<CJK Ideograph>)
          8784  => 16#75E9#,   --  痩 (<CJK Ideograph>)
          8785  => 16#75EC#,   --  痬 (<CJK Ideograph>)
          8786  => 16#75ED#,   --  痭 (<CJK Ideograph>)
          8787  => 16#75EE#,   --  痮 (<CJK Ideograph>)
          8788  => 16#75EF#,   --  痯 (<CJK Ideograph>)
          8789  => 16#75F2#,   --  痲 (<CJK Ideograph>)
          8790  => 16#75F3#,   --  痳 (<CJK Ideograph>)
          8791  => 16#75F5#,   --  痵 (<CJK Ideograph>)
          8792  => 16#75F6#,   --  痶 (<CJK Ideograph>)
          8793  => 16#75F7#,   --  痷 (<CJK Ideograph>)
          8794  => 16#75F8#,   --  痸 (<CJK Ideograph>)
          8795  => 16#75FA#,   --  痺 (<CJK Ideograph>)
          8796  => 16#75FB#,   --  痻 (<CJK Ideograph>)
          8797  => 16#75FD#,   --  痽 (<CJK Ideograph>)
          8798  => 16#75FE#,   --  痾 (<CJK Ideograph>)
          8799  => 16#7602#,   --  瘂 (<CJK Ideograph>)
          8800  => 16#7604#,   --  瘄 (<CJK Ideograph>)
          8801  => 16#7606#,   --  瘆 (<CJK Ideograph>)
          8802  => 16#7607#,   --  瘇 (<CJK Ideograph>)
          8803  => 16#7608#,   --  瘈 (<CJK Ideograph>)
          8804  => 16#7609#,   --  瘉 (<CJK Ideograph>)
          8805  => 16#760B#,   --  瘋 (<CJK Ideograph>)
          8806  => 16#760D#,   --  瘍 (<CJK Ideograph>)
          8807  => 16#760E#,   --  瘎 (<CJK Ideograph>)
          8808  => 16#760F#,   --  瘏 (<CJK Ideograph>)
          8809  => 16#7611#,   --  瘑 (<CJK Ideograph>)
          8810  => 16#7612#,   --  瘒 (<CJK Ideograph>)
          8811  => 16#7613#,   --  瘓 (<CJK Ideograph>)
          8812  => 16#7614#,   --  瘔 (<CJK Ideograph>)
          8813  => 16#7616#,   --  瘖 (<CJK Ideograph>)
          8814  => 16#761A#,   --  瘚 (<CJK Ideograph>)
          8815  => 16#761C#,   --  瘜 (<CJK Ideograph>)
          8816  => 16#761D#,   --  瘝 (<CJK Ideograph>)
          8817  => 16#761E#,   --  瘞 (<CJK Ideograph>)
          8818  => 16#7621#,   --  瘡 (<CJK Ideograph>)
          8819  => 16#7623#,   --  瘣 (<CJK Ideograph>)
          8820  => 16#7627#,   --  瘧 (<CJK Ideograph>)
          8821  => 16#7628#,   --  瘨 (<CJK Ideograph>)
          8822  => 16#762C#,   --  瘬 (<CJK Ideograph>)
          8823  => 16#762E#,   --  瘮 (<CJK Ideograph>)
          8824  => 16#762F#,   --  瘯 (<CJK Ideograph>)
          8825  => 16#7631#,   --  瘱 (<CJK Ideograph>)
          8826  => 16#7632#,   --  瘲 (<CJK Ideograph>)
          8827  => 16#7636#,   --  瘶 (<CJK Ideograph>)
          8828  => 16#7637#,   --  瘷 (<CJK Ideograph>)
          8829  => 16#7639#,   --  瘹 (<CJK Ideograph>)
          8830  => 16#763A#,   --  瘺 (<CJK Ideograph>)
          8831  => 16#763B#,   --  瘻 (<CJK Ideograph>)
          8832  => 16#763D#,   --  瘽 (<CJK Ideograph>)
          8833  => 16#7641#,   --  癁 (<CJK Ideograph>)
          8834  => 16#7642#,   --  療 (<CJK Ideograph>)
          8835  => 16#7644#,   --  癄 (<CJK Ideograph>)
          8836  => 16#E1D6#,   --   (<Private Use>)
          8837  => 16#E1D7#,   --   (<Private Use>)
          8838  => 16#E1D8#,   --   (<Private Use>)
          8839  => 16#E1D9#,   --   (<Private Use>)
          8840  => 16#E1DA#,   --   (<Private Use>)
          8841  => 16#E1DB#,   --   (<Private Use>)
          8842  => 16#E1DC#,   --   (<Private Use>)
          8843  => 16#E1DD#,   --   (<Private Use>)
          8844  => 16#E1DE#,   --   (<Private Use>)
          8845  => 16#E1DF#,   --   (<Private Use>)
          8846  => 16#E1E0#,   --   (<Private Use>)
          8847  => 16#E1E1#,   --   (<Private Use>)
          8848  => 16#E1E2#,   --   (<Private Use>)
          8849  => 16#E1E3#,   --   (<Private Use>)
          8850  => 16#E1E4#,   --   (<Private Use>)
          8851  => 16#E1E5#,   --   (<Private Use>)
          8852  => 16#E1E6#,   --   (<Private Use>)
          8853  => 16#E1E7#,   --   (<Private Use>)
          8854  => 16#E1E8#,   --   (<Private Use>)
          8855  => 16#E1E9#,   --   (<Private Use>)
          8856  => 16#E1EA#,   --   (<Private Use>)
          8857  => 16#E1EB#,   --   (<Private Use>)
          8858  => 16#E1EC#,   --   (<Private Use>)
          8859  => 16#E1ED#,   --   (<Private Use>)
          8860  => 16#E1EE#,   --   (<Private Use>)
          8861  => 16#E1EF#,   --   (<Private Use>)
          8862  => 16#E1F0#,   --   (<Private Use>)
          8863  => 16#E1F1#,   --   (<Private Use>)
          8864  => 16#E1F2#,   --   (<Private Use>)
          8865  => 16#E1F3#,   --   (<Private Use>)
          8866  => 16#E1F4#,   --   (<Private Use>)
          8867  => 16#E1F5#,   --   (<Private Use>)
          8868  => 16#E1F6#,   --   (<Private Use>)
          8869  => 16#E1F7#,   --   (<Private Use>)
          8870  => 16#E1F8#,   --   (<Private Use>)
          8871  => 16#E1F9#,   --   (<Private Use>)
          8872  => 16#E1FA#,   --   (<Private Use>)
          8873  => 16#E1FB#,   --   (<Private Use>)
          8874  => 16#E1FC#,   --   (<Private Use>)
          8875  => 16#E1FD#,   --   (<Private Use>)
          8876  => 16#E1FE#,   --   (<Private Use>)
          8877  => 16#E1FF#,   --   (<Private Use>)
          8878  => 16#E200#,   --   (<Private Use>)
          8879  => 16#E201#,   --   (<Private Use>)
          8880  => 16#E202#,   --   (<Private Use>)
          8881  => 16#E203#,   --   (<Private Use>)
          8882  => 16#E204#,   --   (<Private Use>)
          8883  => 16#E205#,   --   (<Private Use>)
          8884  => 16#E206#,   --   (<Private Use>)
          8885  => 16#E207#,   --   (<Private Use>)
          8886  => 16#E208#,   --   (<Private Use>)
          8887  => 16#E209#,   --   (<Private Use>)
          8888  => 16#E20A#,   --   (<Private Use>)
          8889  => 16#E20B#,   --   (<Private Use>)
          8890  => 16#E20C#,   --   (<Private Use>)
          8891  => 16#E20D#,   --   (<Private Use>)
          8892  => 16#E20E#,   --   (<Private Use>)
          8893  => 16#E20F#,   --   (<Private Use>)
          8894  => 16#E210#,   --   (<Private Use>)
          8895  => 16#E211#,   --   (<Private Use>)
          8896  => 16#E212#,   --   (<Private Use>)
          8897  => 16#E213#,   --   (<Private Use>)
          8898  => 16#E214#,   --   (<Private Use>)
          8899  => 16#E215#,   --   (<Private Use>)
          8900  => 16#E216#,   --   (<Private Use>)
          8901  => 16#E217#,   --   (<Private Use>)
          8902  => 16#E218#,   --   (<Private Use>)
          8903  => 16#E219#,   --   (<Private Use>)
          8904  => 16#E21A#,   --   (<Private Use>)
          8905  => 16#E21B#,   --   (<Private Use>)
          8906  => 16#E21C#,   --   (<Private Use>)
          8907  => 16#E21D#,   --   (<Private Use>)
          8908  => 16#E21E#,   --   (<Private Use>)
          8909  => 16#E21F#,   --   (<Private Use>)
          8910  => 16#E220#,   --   (<Private Use>)
          8911  => 16#E221#,   --   (<Private Use>)
          8912  => 16#E222#,   --   (<Private Use>)
          8913  => 16#E223#,   --   (<Private Use>)
          8914  => 16#E224#,   --   (<Private Use>)
          8915  => 16#E225#,   --   (<Private Use>)
          8916  => 16#E226#,   --   (<Private Use>)
          8917  => 16#E227#,   --   (<Private Use>)
          8918  => 16#E228#,   --   (<Private Use>)
          8919  => 16#E229#,   --   (<Private Use>)
          8920  => 16#E22A#,   --   (<Private Use>)
          8921  => 16#E22B#,   --   (<Private Use>)
          8922  => 16#E22C#,   --   (<Private Use>)
          8923  => 16#E22D#,   --   (<Private Use>)
          8924  => 16#E22E#,   --   (<Private Use>)
          8925  => 16#E22F#,   --   (<Private Use>)
          8926  => 16#E230#,   --   (<Private Use>)
          8927  => 16#E231#,   --   (<Private Use>)
          8928  => 16#E232#,   --   (<Private Use>)
          8929  => 16#E233#,   --   (<Private Use>)
          8930  => 16#7645#,   --  癅 (<CJK Ideograph>)
          8931  => 16#7646#,   --  癆 (<CJK Ideograph>)
          8932  => 16#7647#,   --  癇 (<CJK Ideograph>)
          8933  => 16#7648#,   --  癈 (<CJK Ideograph>)
          8934  => 16#7649#,   --  癉 (<CJK Ideograph>)
          8935  => 16#764A#,   --  癊 (<CJK Ideograph>)
          8936  => 16#764B#,   --  癋 (<CJK Ideograph>)
          8937  => 16#764E#,   --  癎 (<CJK Ideograph>)
          8938  => 16#764F#,   --  癏 (<CJK Ideograph>)
          8939  => 16#7650#,   --  癐 (<CJK Ideograph>)
          8940  => 16#7651#,   --  癑 (<CJK Ideograph>)
          8941  => 16#7652#,   --  癒 (<CJK Ideograph>)
          8942  => 16#7653#,   --  癓 (<CJK Ideograph>)
          8943  => 16#7655#,   --  癕 (<CJK Ideograph>)
          8944  => 16#7657#,   --  癗 (<CJK Ideograph>)
          8945  => 16#7658#,   --  癘 (<CJK Ideograph>)
          8946  => 16#7659#,   --  癙 (<CJK Ideograph>)
          8947  => 16#765A#,   --  癚 (<CJK Ideograph>)
          8948  => 16#765B#,   --  癛 (<CJK Ideograph>)
          8949  => 16#765D#,   --  癝 (<CJK Ideograph>)
          8950  => 16#765F#,   --  癟 (<CJK Ideograph>)
          8951  => 16#7660#,   --  癠 (<CJK Ideograph>)
          8952  => 16#7661#,   --  癡 (<CJK Ideograph>)
          8953  => 16#7662#,   --  癢 (<CJK Ideograph>)
          8954  => 16#7664#,   --  癤 (<CJK Ideograph>)
          8955  => 16#7665#,   --  癥 (<CJK Ideograph>)
          8956  => 16#7666#,   --  癦 (<CJK Ideograph>)
          8957  => 16#7667#,   --  癧 (<CJK Ideograph>)
          8958  => 16#7668#,   --  癨 (<CJK Ideograph>)
          8959  => 16#7669#,   --  癩 (<CJK Ideograph>)
          8960  => 16#766A#,   --  癪 (<CJK Ideograph>)
          8961  => 16#766C#,   --  癬 (<CJK Ideograph>)
          8962  => 16#766D#,   --  癭 (<CJK Ideograph>)
          8963  => 16#766E#,   --  癮 (<CJK Ideograph>)
          8964  => 16#7670#,   --  癰 (<CJK Ideograph>)
          8965  => 16#7671#,   --  癱 (<CJK Ideograph>)
          8966  => 16#7672#,   --  癲 (<CJK Ideograph>)
          8967  => 16#7673#,   --  癳 (<CJK Ideograph>)
          8968  => 16#7674#,   --  癴 (<CJK Ideograph>)
          8969  => 16#7675#,   --  癵 (<CJK Ideograph>)
          8970  => 16#7676#,   --  癶 (<CJK Ideograph>)
          8971  => 16#7677#,   --  癷 (<CJK Ideograph>)
          8972  => 16#7679#,   --  癹 (<CJK Ideograph>)
          8973  => 16#767A#,   --  発 (<CJK Ideograph>)
          8974  => 16#767C#,   --  發 (<CJK Ideograph>)
          8975  => 16#767F#,   --  癿 (<CJK Ideograph>)
          8976  => 16#7680#,   --  皀 (<CJK Ideograph>)
          8977  => 16#7681#,   --  皁 (<CJK Ideograph>)
          8978  => 16#7683#,   --  皃 (<CJK Ideograph>)
          8979  => 16#7685#,   --  皅 (<CJK Ideograph>)
          8980  => 16#7689#,   --  皉 (<CJK Ideograph>)
          8981  => 16#768A#,   --  皊 (<CJK Ideograph>)
          8982  => 16#768C#,   --  皌 (<CJK Ideograph>)
          8983  => 16#768D#,   --  皍 (<CJK Ideograph>)
          8984  => 16#768F#,   --  皏 (<CJK Ideograph>)
          8985  => 16#7690#,   --  皐 (<CJK Ideograph>)
          8986  => 16#7692#,   --  皒 (<CJK Ideograph>)
          8987  => 16#7694#,   --  皔 (<CJK Ideograph>)
          8988  => 16#7695#,   --  皕 (<CJK Ideograph>)
          8989  => 16#7697#,   --  皗 (<CJK Ideograph>)
          8990  => 16#7698#,   --  皘 (<CJK Ideograph>)
          8991  => 16#769A#,   --  皚 (<CJK Ideograph>)
          8992  => 16#769B#,   --  皛 (<CJK Ideograph>)
          8993  => 16#769C#,   --  皜 (<CJK Ideograph>)
          8994  => 16#769D#,   --  皝 (<CJK Ideograph>)
          8995  => 16#769E#,   --  皞 (<CJK Ideograph>)
          8996  => 16#769F#,   --  皟 (<CJK Ideograph>)
          8997  => 16#76A0#,   --  皠 (<CJK Ideograph>)
          8998  => 16#76A1#,   --  皡 (<CJK Ideograph>)
          8999  => 16#76A2#,   --  皢 (<CJK Ideograph>)
          9000  => 16#76A3#,   --  皣 (<CJK Ideograph>)
          9001  => 16#76A5#,   --  皥 (<CJK Ideograph>)
          9002  => 16#76A6#,   --  皦 (<CJK Ideograph>)
          9003  => 16#76A7#,   --  皧 (<CJK Ideograph>)
          9004  => 16#76A8#,   --  皨 (<CJK Ideograph>)
          9005  => 16#76A9#,   --  皩 (<CJK Ideograph>)
          9006  => 16#76AA#,   --  皪 (<CJK Ideograph>)
          9007  => 16#76AB#,   --  皫 (<CJK Ideograph>)
          9008  => 16#76AC#,   --  皬 (<CJK Ideograph>)
          9009  => 16#76AD#,   --  皭 (<CJK Ideograph>)
          9010  => 16#76AF#,   --  皯 (<CJK Ideograph>)
          9011  => 16#76B0#,   --  皰 (<CJK Ideograph>)
          9012  => 16#76B3#,   --  皳 (<CJK Ideograph>)
          9013  => 16#76B5#,   --  皵 (<CJK Ideograph>)
          9014  => 16#76B6#,   --  皶 (<CJK Ideograph>)
          9015  => 16#76B7#,   --  皷 (<CJK Ideograph>)
          9016  => 16#76B8#,   --  皸 (<CJK Ideograph>)
          9017  => 16#76B9#,   --  皹 (<CJK Ideograph>)
          9018  => 16#76BA#,   --  皺 (<CJK Ideograph>)
          9019  => 16#76BB#,   --  皻 (<CJK Ideograph>)
          9020  => 16#76BC#,   --  皼 (<CJK Ideograph>)
          9021  => 16#76BD#,   --  皽 (<CJK Ideograph>)
          9022  => 16#76BE#,   --  皾 (<CJK Ideograph>)
          9023  => 16#76C0#,   --  盀 (<CJK Ideograph>)
          9024  => 16#76C1#,   --  盁 (<CJK Ideograph>)
          9025  => 16#76C3#,   --  盃 (<CJK Ideograph>)
          9026  => 16#554A#,   --  啊 (<CJK Ideograph>)
          9027  => 16#963F#,   --  阿 (<CJK Ideograph>)
          9028  => 16#57C3#,   --  埃 (<CJK Ideograph>)
          9029  => 16#6328#,   --  挨 (<CJK Ideograph>)
          9030  => 16#54CE#,   --  哎 (<CJK Ideograph>)
          9031  => 16#5509#,   --  唉 (<CJK Ideograph>)
          9032  => 16#54C0#,   --  哀 (<CJK Ideograph>)
          9033  => 16#7691#,   --  皑 (<CJK Ideograph>)
          9034  => 16#764C#,   --  癌 (<CJK Ideograph>)
          9035  => 16#853C#,   --  蔼 (<CJK Ideograph>)
          9036  => 16#77EE#,   --  矮 (<CJK Ideograph>)
          9037  => 16#827E#,   --  艾 (<CJK Ideograph>)
          9038  => 16#788D#,   --  碍 (<CJK Ideograph>)
          9039  => 16#7231#,   --  爱 (<CJK Ideograph>)
          9040  => 16#9698#,   --  隘 (<CJK Ideograph>)
          9041  => 16#978D#,   --  鞍 (<CJK Ideograph>)
          9042  => 16#6C28#,   --  氨 (<CJK Ideograph>)
          9043  => 16#5B89#,   --  安 (<CJK Ideograph>)
          9044  => 16#4FFA#,   --  俺 (<CJK Ideograph>)
          9045  => 16#6309#,   --  按 (<CJK Ideograph>)
          9046  => 16#6697#,   --  暗 (<CJK Ideograph>)
          9047  => 16#5CB8#,   --  岸 (<CJK Ideograph>)
          9048  => 16#80FA#,   --  胺 (<CJK Ideograph>)
          9049  => 16#6848#,   --  案 (<CJK Ideograph>)
          9050  => 16#80AE#,   --  肮 (<CJK Ideograph>)
          9051  => 16#6602#,   --  昂 (<CJK Ideograph>)
          9052  => 16#76CE#,   --  盎 (<CJK Ideograph>)
          9053  => 16#51F9#,   --  凹 (<CJK Ideograph>)
          9054  => 16#6556#,   --  敖 (<CJK Ideograph>)
          9055  => 16#71AC#,   --  熬 (<CJK Ideograph>)
          9056  => 16#7FF1#,   --  翱 (<CJK Ideograph>)
          9057  => 16#8884#,   --  袄 (<CJK Ideograph>)
          9058  => 16#50B2#,   --  傲 (<CJK Ideograph>)
          9059  => 16#5965#,   --  奥 (<CJK Ideograph>)
          9060  => 16#61CA#,   --  懊 (<CJK Ideograph>)
          9061  => 16#6FB3#,   --  澳 (<CJK Ideograph>)
          9062  => 16#82AD#,   --  芭 (<CJK Ideograph>)
          9063  => 16#634C#,   --  捌 (<CJK Ideograph>)
          9064  => 16#6252#,   --  扒 (<CJK Ideograph>)
          9065  => 16#53ED#,   --  叭 (<CJK Ideograph>)
          9066  => 16#5427#,   --  吧 (<CJK Ideograph>)
          9067  => 16#7B06#,   --  笆 (<CJK Ideograph>)
          9068  => 16#516B#,   --  八 (<CJK Ideograph>)
          9069  => 16#75A4#,   --  疤 (<CJK Ideograph>)
          9070  => 16#5DF4#,   --  巴 (<CJK Ideograph>)
          9071  => 16#62D4#,   --  拔 (<CJK Ideograph>)
          9072  => 16#8DCB#,   --  跋 (<CJK Ideograph>)
          9073  => 16#9776#,   --  靶 (<CJK Ideograph>)
          9074  => 16#628A#,   --  把 (<CJK Ideograph>)
          9075  => 16#8019#,   --  耙 (<CJK Ideograph>)
          9076  => 16#575D#,   --  坝 (<CJK Ideograph>)
          9077  => 16#9738#,   --  霸 (<CJK Ideograph>)
          9078  => 16#7F62#,   --  罢 (<CJK Ideograph>)
          9079  => 16#7238#,   --  爸 (<CJK Ideograph>)
          9080  => 16#767D#,   --  白 (<CJK Ideograph>)
          9081  => 16#67CF#,   --  柏 (<CJK Ideograph>)
          9082  => 16#767E#,   --  百 (<CJK Ideograph>)
          9083  => 16#6446#,   --  摆 (<CJK Ideograph>)
          9084  => 16#4F70#,   --  佰 (<CJK Ideograph>)
          9085  => 16#8D25#,   --  败 (<CJK Ideograph>)
          9086  => 16#62DC#,   --  拜 (<CJK Ideograph>)
          9087  => 16#7A17#,   --  稗 (<CJK Ideograph>)
          9088  => 16#6591#,   --  斑 (<CJK Ideograph>)
          9089  => 16#73ED#,   --  班 (<CJK Ideograph>)
          9090  => 16#642C#,   --  搬 (<CJK Ideograph>)
          9091  => 16#6273#,   --  扳 (<CJK Ideograph>)
          9092  => 16#822C#,   --  般 (<CJK Ideograph>)
          9093  => 16#9881#,   --  颁 (<CJK Ideograph>)
          9094  => 16#677F#,   --  板 (<CJK Ideograph>)
          9095  => 16#7248#,   --  版 (<CJK Ideograph>)
          9096  => 16#626E#,   --  扮 (<CJK Ideograph>)
          9097  => 16#62CC#,   --  拌 (<CJK Ideograph>)
          9098  => 16#4F34#,   --  伴 (<CJK Ideograph>)
          9099  => 16#74E3#,   --  瓣 (<CJK Ideograph>)
          9100  => 16#534A#,   --  半 (<CJK Ideograph>)
          9101  => 16#529E#,   --  办 (<CJK Ideograph>)
          9102  => 16#7ECA#,   --  绊 (<CJK Ideograph>)
          9103  => 16#90A6#,   --  邦 (<CJK Ideograph>)
          9104  => 16#5E2E#,   --  帮 (<CJK Ideograph>)
          9105  => 16#6886#,   --  梆 (<CJK Ideograph>)
          9106  => 16#699C#,   --  榜 (<CJK Ideograph>)
          9107  => 16#8180#,   --  膀 (<CJK Ideograph>)
          9108  => 16#7ED1#,   --  绑 (<CJK Ideograph>)
          9109  => 16#68D2#,   --  棒 (<CJK Ideograph>)
          9110  => 16#78C5#,   --  磅 (<CJK Ideograph>)
          9111  => 16#868C#,   --  蚌 (<CJK Ideograph>)
          9112  => 16#9551#,   --  镑 (<CJK Ideograph>)
          9113  => 16#508D#,   --  傍 (<CJK Ideograph>)
          9114  => 16#8C24#,   --  谤 (<CJK Ideograph>)
          9115  => 16#82DE#,   --  苞 (<CJK Ideograph>)
          9116  => 16#80DE#,   --  胞 (<CJK Ideograph>)
          9117  => 16#5305#,   --  包 (<CJK Ideograph>)
          9118  => 16#8912#,   --  褒 (<CJK Ideograph>)
          9119  => 16#5265#,   --  剥 (<CJK Ideograph>)
          9120  => 16#76C4#,   --  盄 (<CJK Ideograph>)
          9121  => 16#76C7#,   --  盇 (<CJK Ideograph>)
          9122  => 16#76C9#,   --  盉 (<CJK Ideograph>)
          9123  => 16#76CB#,   --  盋 (<CJK Ideograph>)
          9124  => 16#76CC#,   --  盌 (<CJK Ideograph>)
          9125  => 16#76D3#,   --  盓 (<CJK Ideograph>)
          9126  => 16#76D5#,   --  盕 (<CJK Ideograph>)
          9127  => 16#76D9#,   --  盙 (<CJK Ideograph>)
          9128  => 16#76DA#,   --  盚 (<CJK Ideograph>)
          9129  => 16#76DC#,   --  盜 (<CJK Ideograph>)
          9130  => 16#76DD#,   --  盝 (<CJK Ideograph>)
          9131  => 16#76DE#,   --  盞 (<CJK Ideograph>)
          9132  => 16#76E0#,   --  盠 (<CJK Ideograph>)
          9133  => 16#76E1#,   --  盡 (<CJK Ideograph>)
          9134  => 16#76E2#,   --  盢 (<CJK Ideograph>)
          9135  => 16#76E3#,   --  監 (<CJK Ideograph>)
          9136  => 16#76E4#,   --  盤 (<CJK Ideograph>)
          9137  => 16#76E6#,   --  盦 (<CJK Ideograph>)
          9138  => 16#76E7#,   --  盧 (<CJK Ideograph>)
          9139  => 16#76E8#,   --  盨 (<CJK Ideograph>)
          9140  => 16#76E9#,   --  盩 (<CJK Ideograph>)
          9141  => 16#76EA#,   --  盪 (<CJK Ideograph>)
          9142  => 16#76EB#,   --  盫 (<CJK Ideograph>)
          9143  => 16#76EC#,   --  盬 (<CJK Ideograph>)
          9144  => 16#76ED#,   --  盭 (<CJK Ideograph>)
          9145  => 16#76F0#,   --  盰 (<CJK Ideograph>)
          9146  => 16#76F3#,   --  盳 (<CJK Ideograph>)
          9147  => 16#76F5#,   --  盵 (<CJK Ideograph>)
          9148  => 16#76F6#,   --  盶 (<CJK Ideograph>)
          9149  => 16#76F7#,   --  盷 (<CJK Ideograph>)
          9150  => 16#76FA#,   --  盺 (<CJK Ideograph>)
          9151  => 16#76FB#,   --  盻 (<CJK Ideograph>)
          9152  => 16#76FD#,   --  盽 (<CJK Ideograph>)
          9153  => 16#76FF#,   --  盿 (<CJK Ideograph>)
          9154  => 16#7700#,   --  眀 (<CJK Ideograph>)
          9155  => 16#7702#,   --  眂 (<CJK Ideograph>)
          9156  => 16#7703#,   --  眃 (<CJK Ideograph>)
          9157  => 16#7705#,   --  眅 (<CJK Ideograph>)
          9158  => 16#7706#,   --  眆 (<CJK Ideograph>)
          9159  => 16#770A#,   --  眊 (<CJK Ideograph>)
          9160  => 16#770C#,   --  県 (<CJK Ideograph>)
          9161  => 16#770E#,   --  眎 (<CJK Ideograph>)
          9162  => 16#770F#,   --  眏 (<CJK Ideograph>)
          9163  => 16#7710#,   --  眐 (<CJK Ideograph>)
          9164  => 16#7711#,   --  眑 (<CJK Ideograph>)
          9165  => 16#7712#,   --  眒 (<CJK Ideograph>)
          9166  => 16#7713#,   --  眓 (<CJK Ideograph>)
          9167  => 16#7714#,   --  眔 (<CJK Ideograph>)
          9168  => 16#7715#,   --  眕 (<CJK Ideograph>)
          9169  => 16#7716#,   --  眖 (<CJK Ideograph>)
          9170  => 16#7717#,   --  眗 (<CJK Ideograph>)
          9171  => 16#7718#,   --  眘 (<CJK Ideograph>)
          9172  => 16#771B#,   --  眛 (<CJK Ideograph>)
          9173  => 16#771C#,   --  眜 (<CJK Ideograph>)
          9174  => 16#771D#,   --  眝 (<CJK Ideograph>)
          9175  => 16#771E#,   --  眞 (<CJK Ideograph>)
          9176  => 16#7721#,   --  眡 (<CJK Ideograph>)
          9177  => 16#7723#,   --  眣 (<CJK Ideograph>)
          9178  => 16#7724#,   --  眤 (<CJK Ideograph>)
          9179  => 16#7725#,   --  眥 (<CJK Ideograph>)
          9180  => 16#7727#,   --  眧 (<CJK Ideograph>)
          9181  => 16#772A#,   --  眪 (<CJK Ideograph>)
          9182  => 16#772B#,   --  眫 (<CJK Ideograph>)
          9183  => 16#772C#,   --  眬 (<CJK Ideograph>)
          9184  => 16#772E#,   --  眮 (<CJK Ideograph>)
          9185  => 16#7730#,   --  眰 (<CJK Ideograph>)
          9186  => 16#7731#,   --  眱 (<CJK Ideograph>)
          9187  => 16#7732#,   --  眲 (<CJK Ideograph>)
          9188  => 16#7733#,   --  眳 (<CJK Ideograph>)
          9189  => 16#7734#,   --  眴 (<CJK Ideograph>)
          9190  => 16#7739#,   --  眹 (<CJK Ideograph>)
          9191  => 16#773B#,   --  眻 (<CJK Ideograph>)
          9192  => 16#773D#,   --  眽 (<CJK Ideograph>)
          9193  => 16#773E#,   --  眾 (<CJK Ideograph>)
          9194  => 16#773F#,   --  眿 (<CJK Ideograph>)
          9195  => 16#7742#,   --  睂 (<CJK Ideograph>)
          9196  => 16#7744#,   --  睄 (<CJK Ideograph>)
          9197  => 16#7745#,   --  睅 (<CJK Ideograph>)
          9198  => 16#7746#,   --  睆 (<CJK Ideograph>)
          9199  => 16#7748#,   --  睈 (<CJK Ideograph>)
          9200  => 16#7749#,   --  睉 (<CJK Ideograph>)
          9201  => 16#774A#,   --  睊 (<CJK Ideograph>)
          9202  => 16#774B#,   --  睋 (<CJK Ideograph>)
          9203  => 16#774C#,   --  睌 (<CJK Ideograph>)
          9204  => 16#774D#,   --  睍 (<CJK Ideograph>)
          9205  => 16#774E#,   --  睎 (<CJK Ideograph>)
          9206  => 16#774F#,   --  睏 (<CJK Ideograph>)
          9207  => 16#7752#,   --  睒 (<CJK Ideograph>)
          9208  => 16#7753#,   --  睓 (<CJK Ideograph>)
          9209  => 16#7754#,   --  睔 (<CJK Ideograph>)
          9210  => 16#7755#,   --  睕 (<CJK Ideograph>)
          9211  => 16#7756#,   --  睖 (<CJK Ideograph>)
          9212  => 16#7757#,   --  睗 (<CJK Ideograph>)
          9213  => 16#7758#,   --  睘 (<CJK Ideograph>)
          9214  => 16#7759#,   --  睙 (<CJK Ideograph>)
          9215  => 16#775C#,   --  睜 (<CJK Ideograph>)
          9216  => 16#8584#,   --  薄 (<CJK Ideograph>)
          9217  => 16#96F9#,   --  雹 (<CJK Ideograph>)
          9218  => 16#4FDD#,   --  保 (<CJK Ideograph>)
          9219  => 16#5821#,   --  堡 (<CJK Ideograph>)
          9220  => 16#9971#,   --  饱 (<CJK Ideograph>)
          9221  => 16#5B9D#,   --  宝 (<CJK Ideograph>)
          9222  => 16#62B1#,   --  抱 (<CJK Ideograph>)
          9223  => 16#62A5#,   --  报 (<CJK Ideograph>)
          9224  => 16#66B4#,   --  暴 (<CJK Ideograph>)
          9225  => 16#8C79#,   --  豹 (<CJK Ideograph>)
          9226  => 16#9C8D#,   --  鲍 (<CJK Ideograph>)
          9227  => 16#7206#,   --  爆 (<CJK Ideograph>)
          9228  => 16#676F#,   --  杯 (<CJK Ideograph>)
          9229  => 16#7891#,   --  碑 (<CJK Ideograph>)
          9230  => 16#60B2#,   --  悲 (<CJK Ideograph>)
          9231  => 16#5351#,   --  卑 (<CJK Ideograph>)
          9232  => 16#5317#,   --  北 (<CJK Ideograph>)
          9233  => 16#8F88#,   --  辈 (<CJK Ideograph>)
          9234  => 16#80CC#,   --  背 (<CJK Ideograph>)
          9235  => 16#8D1D#,   --  贝 (<CJK Ideograph>)
          9236  => 16#94A1#,   --  钡 (<CJK Ideograph>)
          9237  => 16#500D#,   --  倍 (<CJK Ideograph>)
          9238  => 16#72C8#,   --  狈 (<CJK Ideograph>)
          9239  => 16#5907#,   --  备 (<CJK Ideograph>)
          9240  => 16#60EB#,   --  惫 (<CJK Ideograph>)
          9241  => 16#7119#,   --  焙 (<CJK Ideograph>)
          9242  => 16#88AB#,   --  被 (<CJK Ideograph>)
          9243  => 16#5954#,   --  奔 (<CJK Ideograph>)
          9244  => 16#82EF#,   --  苯 (<CJK Ideograph>)
          9245  => 16#672C#,   --  本 (<CJK Ideograph>)
          9246  => 16#7B28#,   --  笨 (<CJK Ideograph>)
          9247  => 16#5D29#,   --  崩 (<CJK Ideograph>)
          9248  => 16#7EF7#,   --  绷 (<CJK Ideograph>)
          9249  => 16#752D#,   --  甭 (<CJK Ideograph>)
          9250  => 16#6CF5#,   --  泵 (<CJK Ideograph>)
          9251  => 16#8E66#,   --  蹦 (<CJK Ideograph>)
          9252  => 16#8FF8#,   --  迸 (<CJK Ideograph>)
          9253  => 16#903C#,   --  逼 (<CJK Ideograph>)
          9254  => 16#9F3B#,   --  鼻 (<CJK Ideograph>)
          9255  => 16#6BD4#,   --  比 (<CJK Ideograph>)
          9256  => 16#9119#,   --  鄙 (<CJK Ideograph>)
          9257  => 16#7B14#,   --  笔 (<CJK Ideograph>)
          9258  => 16#5F7C#,   --  彼 (<CJK Ideograph>)
          9259  => 16#78A7#,   --  碧 (<CJK Ideograph>)
          9260  => 16#84D6#,   --  蓖 (<CJK Ideograph>)
          9261  => 16#853D#,   --  蔽 (<CJK Ideograph>)
          9262  => 16#6BD5#,   --  毕 (<CJK Ideograph>)
          9263  => 16#6BD9#,   --  毙 (<CJK Ideograph>)
          9264  => 16#6BD6#,   --  毖 (<CJK Ideograph>)
          9265  => 16#5E01#,   --  币 (<CJK Ideograph>)
          9266  => 16#5E87#,   --  庇 (<CJK Ideograph>)
          9267  => 16#75F9#,   --  痹 (<CJK Ideograph>)
          9268  => 16#95ED#,   --  闭 (<CJK Ideograph>)
          9269  => 16#655D#,   --  敝 (<CJK Ideograph>)
          9270  => 16#5F0A#,   --  弊 (<CJK Ideograph>)
          9271  => 16#5FC5#,   --  必 (<CJK Ideograph>)
          9272  => 16#8F9F#,   --  辟 (<CJK Ideograph>)
          9273  => 16#58C1#,   --  壁 (<CJK Ideograph>)
          9274  => 16#81C2#,   --  臂 (<CJK Ideograph>)
          9275  => 16#907F#,   --  避 (<CJK Ideograph>)
          9276  => 16#965B#,   --  陛 (<CJK Ideograph>)
          9277  => 16#97AD#,   --  鞭 (<CJK Ideograph>)
          9278  => 16#8FB9#,   --  边 (<CJK Ideograph>)
          9279  => 16#7F16#,   --  编 (<CJK Ideograph>)
          9280  => 16#8D2C#,   --  贬 (<CJK Ideograph>)
          9281  => 16#6241#,   --  扁 (<CJK Ideograph>)
          9282  => 16#4FBF#,   --  便 (<CJK Ideograph>)
          9283  => 16#53D8#,   --  变 (<CJK Ideograph>)
          9284  => 16#535E#,   --  卞 (<CJK Ideograph>)
          9285  => 16#8FA8#,   --  辨 (<CJK Ideograph>)
          9286  => 16#8FA9#,   --  辩 (<CJK Ideograph>)
          9287  => 16#8FAB#,   --  辫 (<CJK Ideograph>)
          9288  => 16#904D#,   --  遍 (<CJK Ideograph>)
          9289  => 16#6807#,   --  标 (<CJK Ideograph>)
          9290  => 16#5F6A#,   --  彪 (<CJK Ideograph>)
          9291  => 16#8198#,   --  膘 (<CJK Ideograph>)
          9292  => 16#8868#,   --  表 (<CJK Ideograph>)
          9293  => 16#9CD6#,   --  鳖 (<CJK Ideograph>)
          9294  => 16#618B#,   --  憋 (<CJK Ideograph>)
          9295  => 16#522B#,   --  别 (<CJK Ideograph>)
          9296  => 16#762A#,   --  瘪 (<CJK Ideograph>)
          9297  => 16#5F6C#,   --  彬 (<CJK Ideograph>)
          9298  => 16#658C#,   --  斌 (<CJK Ideograph>)
          9299  => 16#6FD2#,   --  濒 (<CJK Ideograph>)
          9300  => 16#6EE8#,   --  滨 (<CJK Ideograph>)
          9301  => 16#5BBE#,   --  宾 (<CJK Ideograph>)
          9302  => 16#6448#,   --  摈 (<CJK Ideograph>)
          9303  => 16#5175#,   --  兵 (<CJK Ideograph>)
          9304  => 16#51B0#,   --  冰 (<CJK Ideograph>)
          9305  => 16#67C4#,   --  柄 (<CJK Ideograph>)
          9306  => 16#4E19#,   --  丙 (<CJK Ideograph>)
          9307  => 16#79C9#,   --  秉 (<CJK Ideograph>)
          9308  => 16#997C#,   --  饼 (<CJK Ideograph>)
          9309  => 16#70B3#,   --  炳 (<CJK Ideograph>)
          9310  => 16#775D#,   --  睝 (<CJK Ideograph>)
          9311  => 16#775E#,   --  睞 (<CJK Ideograph>)
          9312  => 16#775F#,   --  睟 (<CJK Ideograph>)
          9313  => 16#7760#,   --  睠 (<CJK Ideograph>)
          9314  => 16#7764#,   --  睤 (<CJK Ideograph>)
          9315  => 16#7767#,   --  睧 (<CJK Ideograph>)
          9316  => 16#7769#,   --  睩 (<CJK Ideograph>)
          9317  => 16#776A#,   --  睪 (<CJK Ideograph>)
          9318  => 16#776D#,   --  睭 (<CJK Ideograph>)
          9319  => 16#776E#,   --  睮 (<CJK Ideograph>)
          9320  => 16#776F#,   --  睯 (<CJK Ideograph>)
          9321  => 16#7770#,   --  睰 (<CJK Ideograph>)
          9322  => 16#7771#,   --  睱 (<CJK Ideograph>)
          9323  => 16#7772#,   --  睲 (<CJK Ideograph>)
          9324  => 16#7773#,   --  睳 (<CJK Ideograph>)
          9325  => 16#7774#,   --  睴 (<CJK Ideograph>)
          9326  => 16#7775#,   --  睵 (<CJK Ideograph>)
          9327  => 16#7776#,   --  睶 (<CJK Ideograph>)
          9328  => 16#7777#,   --  睷 (<CJK Ideograph>)
          9329  => 16#7778#,   --  睸 (<CJK Ideograph>)
          9330  => 16#777A#,   --  睺 (<CJK Ideograph>)
          9331  => 16#777B#,   --  睻 (<CJK Ideograph>)
          9332  => 16#777C#,   --  睼 (<CJK Ideograph>)
          9333  => 16#7781#,   --  瞁 (<CJK Ideograph>)
          9334  => 16#7782#,   --  瞂 (<CJK Ideograph>)
          9335  => 16#7783#,   --  瞃 (<CJK Ideograph>)
          9336  => 16#7786#,   --  瞆 (<CJK Ideograph>)
          9337  => 16#7787#,   --  瞇 (<CJK Ideograph>)
          9338  => 16#7788#,   --  瞈 (<CJK Ideograph>)
          9339  => 16#7789#,   --  瞉 (<CJK Ideograph>)
          9340  => 16#778A#,   --  瞊 (<CJK Ideograph>)
          9341  => 16#778B#,   --  瞋 (<CJK Ideograph>)
          9342  => 16#778F#,   --  瞏 (<CJK Ideograph>)
          9343  => 16#7790#,   --  瞐 (<CJK Ideograph>)
          9344  => 16#7793#,   --  瞓 (<CJK Ideograph>)
          9345  => 16#7794#,   --  瞔 (<CJK Ideograph>)
          9346  => 16#7795#,   --  瞕 (<CJK Ideograph>)
          9347  => 16#7796#,   --  瞖 (<CJK Ideograph>)
          9348  => 16#7797#,   --  瞗 (<CJK Ideograph>)
          9349  => 16#7798#,   --  瞘 (<CJK Ideograph>)
          9350  => 16#7799#,   --  瞙 (<CJK Ideograph>)
          9351  => 16#779A#,   --  瞚 (<CJK Ideograph>)
          9352  => 16#779B#,   --  瞛 (<CJK Ideograph>)
          9353  => 16#779C#,   --  瞜 (<CJK Ideograph>)
          9354  => 16#779D#,   --  瞝 (<CJK Ideograph>)
          9355  => 16#779E#,   --  瞞 (<CJK Ideograph>)
          9356  => 16#77A1#,   --  瞡 (<CJK Ideograph>)
          9357  => 16#77A3#,   --  瞣 (<CJK Ideograph>)
          9358  => 16#77A4#,   --  瞤 (<CJK Ideograph>)
          9359  => 16#77A6#,   --  瞦 (<CJK Ideograph>)
          9360  => 16#77A8#,   --  瞨 (<CJK Ideograph>)
          9361  => 16#77AB#,   --  瞫 (<CJK Ideograph>)
          9362  => 16#77AD#,   --  瞭 (<CJK Ideograph>)
          9363  => 16#77AE#,   --  瞮 (<CJK Ideograph>)
          9364  => 16#77AF#,   --  瞯 (<CJK Ideograph>)
          9365  => 16#77B1#,   --  瞱 (<CJK Ideograph>)
          9366  => 16#77B2#,   --  瞲 (<CJK Ideograph>)
          9367  => 16#77B4#,   --  瞴 (<CJK Ideograph>)
          9368  => 16#77B6#,   --  瞶 (<CJK Ideograph>)
          9369  => 16#77B7#,   --  瞷 (<CJK Ideograph>)
          9370  => 16#77B8#,   --  瞸 (<CJK Ideograph>)
          9371  => 16#77B9#,   --  瞹 (<CJK Ideograph>)
          9372  => 16#77BA#,   --  瞺 (<CJK Ideograph>)
          9373  => 16#77BC#,   --  瞼 (<CJK Ideograph>)
          9374  => 16#77BE#,   --  瞾 (<CJK Ideograph>)
          9375  => 16#77C0#,   --  矀 (<CJK Ideograph>)
          9376  => 16#77C1#,   --  矁 (<CJK Ideograph>)
          9377  => 16#77C2#,   --  矂 (<CJK Ideograph>)
          9378  => 16#77C3#,   --  矃 (<CJK Ideograph>)
          9379  => 16#77C4#,   --  矄 (<CJK Ideograph>)
          9380  => 16#77C5#,   --  矅 (<CJK Ideograph>)
          9381  => 16#77C6#,   --  矆 (<CJK Ideograph>)
          9382  => 16#77C7#,   --  矇 (<CJK Ideograph>)
          9383  => 16#77C8#,   --  矈 (<CJK Ideograph>)
          9384  => 16#77C9#,   --  矉 (<CJK Ideograph>)
          9385  => 16#77CA#,   --  矊 (<CJK Ideograph>)
          9386  => 16#77CB#,   --  矋 (<CJK Ideograph>)
          9387  => 16#77CC#,   --  矌 (<CJK Ideograph>)
          9388  => 16#77CE#,   --  矎 (<CJK Ideograph>)
          9389  => 16#77CF#,   --  矏 (<CJK Ideograph>)
          9390  => 16#77D0#,   --  矐 (<CJK Ideograph>)
          9391  => 16#77D1#,   --  矑 (<CJK Ideograph>)
          9392  => 16#77D2#,   --  矒 (<CJK Ideograph>)
          9393  => 16#77D3#,   --  矓 (<CJK Ideograph>)
          9394  => 16#77D4#,   --  矔 (<CJK Ideograph>)
          9395  => 16#77D5#,   --  矕 (<CJK Ideograph>)
          9396  => 16#77D6#,   --  矖 (<CJK Ideograph>)
          9397  => 16#77D8#,   --  矘 (<CJK Ideograph>)
          9398  => 16#77D9#,   --  矙 (<CJK Ideograph>)
          9399  => 16#77DA#,   --  矚 (<CJK Ideograph>)
          9400  => 16#77DD#,   --  矝 (<CJK Ideograph>)
          9401  => 16#77DE#,   --  矞 (<CJK Ideograph>)
          9402  => 16#77DF#,   --  矟 (<CJK Ideograph>)
          9403  => 16#77E0#,   --  矠 (<CJK Ideograph>)
          9404  => 16#77E1#,   --  矡 (<CJK Ideograph>)
          9405  => 16#77E4#,   --  矤 (<CJK Ideograph>)
          9406  => 16#75C5#,   --  病 (<CJK Ideograph>)
          9407  => 16#5E76#,   --  并 (<CJK Ideograph>)
          9408  => 16#73BB#,   --  玻 (<CJK Ideograph>)
          9409  => 16#83E0#,   --  菠 (<CJK Ideograph>)
          9410  => 16#64AD#,   --  播 (<CJK Ideograph>)
          9411  => 16#62E8#,   --  拨 (<CJK Ideograph>)
          9412  => 16#94B5#,   --  钵 (<CJK Ideograph>)
          9413  => 16#6CE2#,   --  波 (<CJK Ideograph>)
          9414  => 16#535A#,   --  博 (<CJK Ideograph>)
          9415  => 16#52C3#,   --  勃 (<CJK Ideograph>)
          9416  => 16#640F#,   --  搏 (<CJK Ideograph>)
          9417  => 16#94C2#,   --  铂 (<CJK Ideograph>)
          9418  => 16#7B94#,   --  箔 (<CJK Ideograph>)
          9419  => 16#4F2F#,   --  伯 (<CJK Ideograph>)
          9420  => 16#5E1B#,   --  帛 (<CJK Ideograph>)
          9421  => 16#8236#,   --  舶 (<CJK Ideograph>)
          9422  => 16#8116#,   --  脖 (<CJK Ideograph>)
          9423  => 16#818A#,   --  膊 (<CJK Ideograph>)
          9424  => 16#6E24#,   --  渤 (<CJK Ideograph>)
          9425  => 16#6CCA#,   --  泊 (<CJK Ideograph>)
          9426  => 16#9A73#,   --  驳 (<CJK Ideograph>)
          9427  => 16#6355#,   --  捕 (<CJK Ideograph>)
          9428  => 16#535C#,   --  卜 (<CJK Ideograph>)
          9429  => 16#54FA#,   --  哺 (<CJK Ideograph>)
          9430  => 16#8865#,   --  补 (<CJK Ideograph>)
          9431  => 16#57E0#,   --  埠 (<CJK Ideograph>)
          9432  => 16#4E0D#,   --  不 (<CJK Ideograph>)
          9433  => 16#5E03#,   --  布 (<CJK Ideograph>)
          9434  => 16#6B65#,   --  步 (<CJK Ideograph>)
          9435  => 16#7C3F#,   --  簿 (<CJK Ideograph>)
          9436  => 16#90E8#,   --  部 (<CJK Ideograph>)
          9437  => 16#6016#,   --  怖 (<CJK Ideograph>)
          9438  => 16#64E6#,   --  擦 (<CJK Ideograph>)
          9439  => 16#731C#,   --  猜 (<CJK Ideograph>)
          9440  => 16#88C1#,   --  裁 (<CJK Ideograph>)
          9441  => 16#6750#,   --  材 (<CJK Ideograph>)
          9442  => 16#624D#,   --  才 (<CJK Ideograph>)
          9443  => 16#8D22#,   --  财 (<CJK Ideograph>)
          9444  => 16#776C#,   --  睬 (<CJK Ideograph>)
          9445  => 16#8E29#,   --  踩 (<CJK Ideograph>)
          9446  => 16#91C7#,   --  采 (<CJK Ideograph>)
          9447  => 16#5F69#,   --  彩 (<CJK Ideograph>)
          9448  => 16#83DC#,   --  菜 (<CJK Ideograph>)
          9449  => 16#8521#,   --  蔡 (<CJK Ideograph>)
          9450  => 16#9910#,   --  餐 (<CJK Ideograph>)
          9451  => 16#53C2#,   --  参 (<CJK Ideograph>)
          9452  => 16#8695#,   --  蚕 (<CJK Ideograph>)
          9453  => 16#6B8B#,   --  残 (<CJK Ideograph>)
          9454  => 16#60ED#,   --  惭 (<CJK Ideograph>)
          9455  => 16#60E8#,   --  惨 (<CJK Ideograph>)
          9456  => 16#707F#,   --  灿 (<CJK Ideograph>)
          9457  => 16#82CD#,   --  苍 (<CJK Ideograph>)
          9458  => 16#8231#,   --  舱 (<CJK Ideograph>)
          9459  => 16#4ED3#,   --  仓 (<CJK Ideograph>)
          9460  => 16#6CA7#,   --  沧 (<CJK Ideograph>)
          9461  => 16#85CF#,   --  藏 (<CJK Ideograph>)
          9462  => 16#64CD#,   --  操 (<CJK Ideograph>)
          9463  => 16#7CD9#,   --  糙 (<CJK Ideograph>)
          9464  => 16#69FD#,   --  槽 (<CJK Ideograph>)
          9465  => 16#66F9#,   --  曹 (<CJK Ideograph>)
          9466  => 16#8349#,   --  草 (<CJK Ideograph>)
          9467  => 16#5395#,   --  厕 (<CJK Ideograph>)
          9468  => 16#7B56#,   --  策 (<CJK Ideograph>)
          9469  => 16#4FA7#,   --  侧 (<CJK Ideograph>)
          9470  => 16#518C#,   --  册 (<CJK Ideograph>)
          9471  => 16#6D4B#,   --  测 (<CJK Ideograph>)
          9472  => 16#5C42#,   --  层 (<CJK Ideograph>)
          9473  => 16#8E6D#,   --  蹭 (<CJK Ideograph>)
          9474  => 16#63D2#,   --  插 (<CJK Ideograph>)
          9475  => 16#53C9#,   --  叉 (<CJK Ideograph>)
          9476  => 16#832C#,   --  茬 (<CJK Ideograph>)
          9477  => 16#8336#,   --  茶 (<CJK Ideograph>)
          9478  => 16#67E5#,   --  查 (<CJK Ideograph>)
          9479  => 16#78B4#,   --  碴 (<CJK Ideograph>)
          9480  => 16#643D#,   --  搽 (<CJK Ideograph>)
          9481  => 16#5BDF#,   --  察 (<CJK Ideograph>)
          9482  => 16#5C94#,   --  岔 (<CJK Ideograph>)
          9483  => 16#5DEE#,   --  差 (<CJK Ideograph>)
          9484  => 16#8BE7#,   --  诧 (<CJK Ideograph>)
          9485  => 16#62C6#,   --  拆 (<CJK Ideograph>)
          9486  => 16#67F4#,   --  柴 (<CJK Ideograph>)
          9487  => 16#8C7A#,   --  豺 (<CJK Ideograph>)
          9488  => 16#6400#,   --  搀 (<CJK Ideograph>)
          9489  => 16#63BA#,   --  掺 (<CJK Ideograph>)
          9490  => 16#8749#,   --  蝉 (<CJK Ideograph>)
          9491  => 16#998B#,   --  馋 (<CJK Ideograph>)
          9492  => 16#8C17#,   --  谗 (<CJK Ideograph>)
          9493  => 16#7F20#,   --  缠 (<CJK Ideograph>)
          9494  => 16#94F2#,   --  铲 (<CJK Ideograph>)
          9495  => 16#4EA7#,   --  产 (<CJK Ideograph>)
          9496  => 16#9610#,   --  阐 (<CJK Ideograph>)
          9497  => 16#98A4#,   --  颤 (<CJK Ideograph>)
          9498  => 16#660C#,   --  昌 (<CJK Ideograph>)
          9499  => 16#7316#,   --  猖 (<CJK Ideograph>)
          9500  => 16#77E6#,   --  矦 (<CJK Ideograph>)
          9501  => 16#77E8#,   --  矨 (<CJK Ideograph>)
          9502  => 16#77EA#,   --  矪 (<CJK Ideograph>)
          9503  => 16#77EF#,   --  矯 (<CJK Ideograph>)
          9504  => 16#77F0#,   --  矰 (<CJK Ideograph>)
          9505  => 16#77F1#,   --  矱 (<CJK Ideograph>)
          9506  => 16#77F2#,   --  矲 (<CJK Ideograph>)
          9507  => 16#77F4#,   --  矴 (<CJK Ideograph>)
          9508  => 16#77F5#,   --  矵 (<CJK Ideograph>)
          9509  => 16#77F7#,   --  矷 (<CJK Ideograph>)
          9510  => 16#77F9#,   --  矹 (<CJK Ideograph>)
          9511  => 16#77FA#,   --  矺 (<CJK Ideograph>)
          9512  => 16#77FB#,   --  矻 (<CJK Ideograph>)
          9513  => 16#77FC#,   --  矼 (<CJK Ideograph>)
          9514  => 16#7803#,   --  砃 (<CJK Ideograph>)
          9515  => 16#7804#,   --  砄 (<CJK Ideograph>)
          9516  => 16#7805#,   --  砅 (<CJK Ideograph>)
          9517  => 16#7806#,   --  砆 (<CJK Ideograph>)
          9518  => 16#7807#,   --  砇 (<CJK Ideograph>)
          9519  => 16#7808#,   --  砈 (<CJK Ideograph>)
          9520  => 16#780A#,   --  砊 (<CJK Ideograph>)
          9521  => 16#780B#,   --  砋 (<CJK Ideograph>)
          9522  => 16#780E#,   --  砎 (<CJK Ideograph>)
          9523  => 16#780F#,   --  砏 (<CJK Ideograph>)
          9524  => 16#7810#,   --  砐 (<CJK Ideograph>)
          9525  => 16#7813#,   --  砓 (<CJK Ideograph>)
          9526  => 16#7815#,   --  砕 (<CJK Ideograph>)
          9527  => 16#7819#,   --  砙 (<CJK Ideograph>)
          9528  => 16#781B#,   --  砛 (<CJK Ideograph>)
          9529  => 16#781E#,   --  砞 (<CJK Ideograph>)
          9530  => 16#7820#,   --  砠 (<CJK Ideograph>)
          9531  => 16#7821#,   --  砡 (<CJK Ideograph>)
          9532  => 16#7822#,   --  砢 (<CJK Ideograph>)
          9533  => 16#7824#,   --  砤 (<CJK Ideograph>)
          9534  => 16#7828#,   --  砨 (<CJK Ideograph>)
          9535  => 16#782A#,   --  砪 (<CJK Ideograph>)
          9536  => 16#782B#,   --  砫 (<CJK Ideograph>)
          9537  => 16#782E#,   --  砮 (<CJK Ideograph>)
          9538  => 16#782F#,   --  砯 (<CJK Ideograph>)
          9539  => 16#7831#,   --  砱 (<CJK Ideograph>)
          9540  => 16#7832#,   --  砲 (<CJK Ideograph>)
          9541  => 16#7833#,   --  砳 (<CJK Ideograph>)
          9542  => 16#7835#,   --  砵 (<CJK Ideograph>)
          9543  => 16#7836#,   --  砶 (<CJK Ideograph>)
          9544  => 16#783D#,   --  砽 (<CJK Ideograph>)
          9545  => 16#783F#,   --  砿 (<CJK Ideograph>)
          9546  => 16#7841#,   --  硁 (<CJK Ideograph>)
          9547  => 16#7842#,   --  硂 (<CJK Ideograph>)
          9548  => 16#7843#,   --  硃 (<CJK Ideograph>)
          9549  => 16#7844#,   --  硄 (<CJK Ideograph>)
          9550  => 16#7846#,   --  硆 (<CJK Ideograph>)
          9551  => 16#7848#,   --  硈 (<CJK Ideograph>)
          9552  => 16#7849#,   --  硉 (<CJK Ideograph>)
          9553  => 16#784A#,   --  硊 (<CJK Ideograph>)
          9554  => 16#784B#,   --  硋 (<CJK Ideograph>)
          9555  => 16#784D#,   --  硍 (<CJK Ideograph>)
          9556  => 16#784F#,   --  硏 (<CJK Ideograph>)
          9557  => 16#7851#,   --  硑 (<CJK Ideograph>)
          9558  => 16#7853#,   --  硓 (<CJK Ideograph>)
          9559  => 16#7854#,   --  硔 (<CJK Ideograph>)
          9560  => 16#7858#,   --  硘 (<CJK Ideograph>)
          9561  => 16#7859#,   --  硙 (<CJK Ideograph>)
          9562  => 16#785A#,   --  硚 (<CJK Ideograph>)
          9563  => 16#785B#,   --  硛 (<CJK Ideograph>)
          9564  => 16#785C#,   --  硜 (<CJK Ideograph>)
          9565  => 16#785E#,   --  硞 (<CJK Ideograph>)
          9566  => 16#785F#,   --  硟 (<CJK Ideograph>)
          9567  => 16#7860#,   --  硠 (<CJK Ideograph>)
          9568  => 16#7861#,   --  硡 (<CJK Ideograph>)
          9569  => 16#7862#,   --  硢 (<CJK Ideograph>)
          9570  => 16#7863#,   --  硣 (<CJK Ideograph>)
          9571  => 16#7864#,   --  硤 (<CJK Ideograph>)
          9572  => 16#7865#,   --  硥 (<CJK Ideograph>)
          9573  => 16#7866#,   --  硦 (<CJK Ideograph>)
          9574  => 16#7867#,   --  硧 (<CJK Ideograph>)
          9575  => 16#7868#,   --  硨 (<CJK Ideograph>)
          9576  => 16#7869#,   --  硩 (<CJK Ideograph>)
          9577  => 16#786F#,   --  硯 (<CJK Ideograph>)
          9578  => 16#7870#,   --  硰 (<CJK Ideograph>)
          9579  => 16#7871#,   --  硱 (<CJK Ideograph>)
          9580  => 16#7872#,   --  硲 (<CJK Ideograph>)
          9581  => 16#7873#,   --  硳 (<CJK Ideograph>)
          9582  => 16#7874#,   --  硴 (<CJK Ideograph>)
          9583  => 16#7875#,   --  硵 (<CJK Ideograph>)
          9584  => 16#7876#,   --  硶 (<CJK Ideograph>)
          9585  => 16#7878#,   --  硸 (<CJK Ideograph>)
          9586  => 16#7879#,   --  硹 (<CJK Ideograph>)
          9587  => 16#787A#,   --  硺 (<CJK Ideograph>)
          9588  => 16#787B#,   --  硻 (<CJK Ideograph>)
          9589  => 16#787D#,   --  硽 (<CJK Ideograph>)
          9590  => 16#787E#,   --  硾 (<CJK Ideograph>)
          9591  => 16#787F#,   --  硿 (<CJK Ideograph>)
          9592  => 16#7880#,   --  碀 (<CJK Ideograph>)
          9593  => 16#7881#,   --  碁 (<CJK Ideograph>)
          9594  => 16#7882#,   --  碂 (<CJK Ideograph>)
          9595  => 16#7883#,   --  碃 (<CJK Ideograph>)
          9596  => 16#573A#,   --  场 (<CJK Ideograph>)
          9597  => 16#5C1D#,   --  尝 (<CJK Ideograph>)
          9598  => 16#5E38#,   --  常 (<CJK Ideograph>)
          9599  => 16#957F#,   --  长 (<CJK Ideograph>)
          9600  => 16#507F#,   --  偿 (<CJK Ideograph>)
          9601  => 16#80A0#,   --  肠 (<CJK Ideograph>)
          9602  => 16#5382#,   --  厂 (<CJK Ideograph>)
          9603  => 16#655E#,   --  敞 (<CJK Ideograph>)
          9604  => 16#7545#,   --  畅 (<CJK Ideograph>)
          9605  => 16#5531#,   --  唱 (<CJK Ideograph>)
          9606  => 16#5021#,   --  倡 (<CJK Ideograph>)
          9607  => 16#8D85#,   --  超 (<CJK Ideograph>)
          9608  => 16#6284#,   --  抄 (<CJK Ideograph>)
          9609  => 16#949E#,   --  钞 (<CJK Ideograph>)
          9610  => 16#671D#,   --  朝 (<CJK Ideograph>)
          9611  => 16#5632#,   --  嘲 (<CJK Ideograph>)
          9612  => 16#6F6E#,   --  潮 (<CJK Ideograph>)
          9613  => 16#5DE2#,   --  巢 (<CJK Ideograph>)
          9614  => 16#5435#,   --  吵 (<CJK Ideograph>)
          9615  => 16#7092#,   --  炒 (<CJK Ideograph>)
          9616  => 16#8F66#,   --  车 (<CJK Ideograph>)
          9617  => 16#626F#,   --  扯 (<CJK Ideograph>)
          9618  => 16#64A4#,   --  撤 (<CJK Ideograph>)
          9619  => 16#63A3#,   --  掣 (<CJK Ideograph>)
          9620  => 16#5F7B#,   --  彻 (<CJK Ideograph>)
          9621  => 16#6F88#,   --  澈 (<CJK Ideograph>)
          9622  => 16#90F4#,   --  郴 (<CJK Ideograph>)
          9623  => 16#81E3#,   --  臣 (<CJK Ideograph>)
          9624  => 16#8FB0#,   --  辰 (<CJK Ideograph>)
          9625  => 16#5C18#,   --  尘 (<CJK Ideograph>)
          9626  => 16#6668#,   --  晨 (<CJK Ideograph>)
          9627  => 16#5FF1#,   --  忱 (<CJK Ideograph>)
          9628  => 16#6C89#,   --  沉 (<CJK Ideograph>)
          9629  => 16#9648#,   --  陈 (<CJK Ideograph>)
          9630  => 16#8D81#,   --  趁 (<CJK Ideograph>)
          9631  => 16#886C#,   --  衬 (<CJK Ideograph>)
          9632  => 16#6491#,   --  撑 (<CJK Ideograph>)
          9633  => 16#79F0#,   --  称 (<CJK Ideograph>)
          9634  => 16#57CE#,   --  城 (<CJK Ideograph>)
          9635  => 16#6A59#,   --  橙 (<CJK Ideograph>)
          9636  => 16#6210#,   --  成 (<CJK Ideograph>)
          9637  => 16#5448#,   --  呈 (<CJK Ideograph>)
          9638  => 16#4E58#,   --  乘 (<CJK Ideograph>)
          9639  => 16#7A0B#,   --  程 (<CJK Ideograph>)
          9640  => 16#60E9#,   --  惩 (<CJK Ideograph>)
          9641  => 16#6F84#,   --  澄 (<CJK Ideograph>)
          9642  => 16#8BDA#,   --  诚 (<CJK Ideograph>)
          9643  => 16#627F#,   --  承 (<CJK Ideograph>)
          9644  => 16#901E#,   --  逞 (<CJK Ideograph>)
          9645  => 16#9A8B#,   --  骋 (<CJK Ideograph>)
          9646  => 16#79E4#,   --  秤 (<CJK Ideograph>)
          9647  => 16#5403#,   --  吃 (<CJK Ideograph>)
          9648  => 16#75F4#,   --  痴 (<CJK Ideograph>)
          9649  => 16#6301#,   --  持 (<CJK Ideograph>)
          9650  => 16#5319#,   --  匙 (<CJK Ideograph>)
          9651  => 16#6C60#,   --  池 (<CJK Ideograph>)
          9652  => 16#8FDF#,   --  迟 (<CJK Ideograph>)
          9653  => 16#5F1B#,   --  弛 (<CJK Ideograph>)
          9654  => 16#9A70#,   --  驰 (<CJK Ideograph>)
          9655  => 16#803B#,   --  耻 (<CJK Ideograph>)
          9656  => 16#9F7F#,   --  齿 (<CJK Ideograph>)
          9657  => 16#4F88#,   --  侈 (<CJK Ideograph>)
          9658  => 16#5C3A#,   --  尺 (<CJK Ideograph>)
          9659  => 16#8D64#,   --  赤 (<CJK Ideograph>)
          9660  => 16#7FC5#,   --  翅 (<CJK Ideograph>)
          9661  => 16#65A5#,   --  斥 (<CJK Ideograph>)
          9662  => 16#70BD#,   --  炽 (<CJK Ideograph>)
          9663  => 16#5145#,   --  充 (<CJK Ideograph>)
          9664  => 16#51B2#,   --  冲 (<CJK Ideograph>)
          9665  => 16#866B#,   --  虫 (<CJK Ideograph>)
          9666  => 16#5D07#,   --  崇 (<CJK Ideograph>)
          9667  => 16#5BA0#,   --  宠 (<CJK Ideograph>)
          9668  => 16#62BD#,   --  抽 (<CJK Ideograph>)
          9669  => 16#916C#,   --  酬 (<CJK Ideograph>)
          9670  => 16#7574#,   --  畴 (<CJK Ideograph>)
          9671  => 16#8E0C#,   --  踌 (<CJK Ideograph>)
          9672  => 16#7A20#,   --  稠 (<CJK Ideograph>)
          9673  => 16#6101#,   --  愁 (<CJK Ideograph>)
          9674  => 16#7B79#,   --  筹 (<CJK Ideograph>)
          9675  => 16#4EC7#,   --  仇 (<CJK Ideograph>)
          9676  => 16#7EF8#,   --  绸 (<CJK Ideograph>)
          9677  => 16#7785#,   --  瞅 (<CJK Ideograph>)
          9678  => 16#4E11#,   --  丑 (<CJK Ideograph>)
          9679  => 16#81ED#,   --  臭 (<CJK Ideograph>)
          9680  => 16#521D#,   --  初 (<CJK Ideograph>)
          9681  => 16#51FA#,   --  出 (<CJK Ideograph>)
          9682  => 16#6A71#,   --  橱 (<CJK Ideograph>)
          9683  => 16#53A8#,   --  厨 (<CJK Ideograph>)
          9684  => 16#8E87#,   --  躇 (<CJK Ideograph>)
          9685  => 16#9504#,   --  锄 (<CJK Ideograph>)
          9686  => 16#96CF#,   --  雏 (<CJK Ideograph>)
          9687  => 16#6EC1#,   --  滁 (<CJK Ideograph>)
          9688  => 16#9664#,   --  除 (<CJK Ideograph>)
          9689  => 16#695A#,   --  楚 (<CJK Ideograph>)
          9690  => 16#7884#,   --  碄 (<CJK Ideograph>)
          9691  => 16#7885#,   --  碅 (<CJK Ideograph>)
          9692  => 16#7886#,   --  碆 (<CJK Ideograph>)
          9693  => 16#7888#,   --  碈 (<CJK Ideograph>)
          9694  => 16#788A#,   --  碊 (<CJK Ideograph>)
          9695  => 16#788B#,   --  碋 (<CJK Ideograph>)
          9696  => 16#788F#,   --  碏 (<CJK Ideograph>)
          9697  => 16#7890#,   --  碐 (<CJK Ideograph>)
          9698  => 16#7892#,   --  碒 (<CJK Ideograph>)
          9699  => 16#7894#,   --  碔 (<CJK Ideograph>)
          9700  => 16#7895#,   --  碕 (<CJK Ideograph>)
          9701  => 16#7896#,   --  碖 (<CJK Ideograph>)
          9702  => 16#7899#,   --  碙 (<CJK Ideograph>)
          9703  => 16#789D#,   --  碝 (<CJK Ideograph>)
          9704  => 16#789E#,   --  碞 (<CJK Ideograph>)
          9705  => 16#78A0#,   --  碠 (<CJK Ideograph>)
          9706  => 16#78A2#,   --  碢 (<CJK Ideograph>)
          9707  => 16#78A4#,   --  碤 (<CJK Ideograph>)
          9708  => 16#78A6#,   --  碦 (<CJK Ideograph>)
          9709  => 16#78A8#,   --  碨 (<CJK Ideograph>)
          9710  => 16#78A9#,   --  碩 (<CJK Ideograph>)
          9711  => 16#78AA#,   --  碪 (<CJK Ideograph>)
          9712  => 16#78AB#,   --  碫 (<CJK Ideograph>)
          9713  => 16#78AC#,   --  碬 (<CJK Ideograph>)
          9714  => 16#78AD#,   --  碭 (<CJK Ideograph>)
          9715  => 16#78AE#,   --  碮 (<CJK Ideograph>)
          9716  => 16#78AF#,   --  碯 (<CJK Ideograph>)
          9717  => 16#78B5#,   --  碵 (<CJK Ideograph>)
          9718  => 16#78B6#,   --  碶 (<CJK Ideograph>)
          9719  => 16#78B7#,   --  碷 (<CJK Ideograph>)
          9720  => 16#78B8#,   --  碸 (<CJK Ideograph>)
          9721  => 16#78BA#,   --  確 (<CJK Ideograph>)
          9722  => 16#78BB#,   --  碻 (<CJK Ideograph>)
          9723  => 16#78BC#,   --  碼 (<CJK Ideograph>)
          9724  => 16#78BD#,   --  碽 (<CJK Ideograph>)
          9725  => 16#78BF#,   --  碿 (<CJK Ideograph>)
          9726  => 16#78C0#,   --  磀 (<CJK Ideograph>)
          9727  => 16#78C2#,   --  磂 (<CJK Ideograph>)
          9728  => 16#78C3#,   --  磃 (<CJK Ideograph>)
          9729  => 16#78C4#,   --  磄 (<CJK Ideograph>)
          9730  => 16#78C6#,   --  磆 (<CJK Ideograph>)
          9731  => 16#78C7#,   --  磇 (<CJK Ideograph>)
          9732  => 16#78C8#,   --  磈 (<CJK Ideograph>)
          9733  => 16#78CC#,   --  磌 (<CJK Ideograph>)
          9734  => 16#78CD#,   --  磍 (<CJK Ideograph>)
          9735  => 16#78CE#,   --  磎 (<CJK Ideograph>)
          9736  => 16#78CF#,   --  磏 (<CJK Ideograph>)
          9737  => 16#78D1#,   --  磑 (<CJK Ideograph>)
          9738  => 16#78D2#,   --  磒 (<CJK Ideograph>)
          9739  => 16#78D3#,   --  磓 (<CJK Ideograph>)
          9740  => 16#78D6#,   --  磖 (<CJK Ideograph>)
          9741  => 16#78D7#,   --  磗 (<CJK Ideograph>)
          9742  => 16#78D8#,   --  磘 (<CJK Ideograph>)
          9743  => 16#78DA#,   --  磚 (<CJK Ideograph>)
          9744  => 16#78DB#,   --  磛 (<CJK Ideograph>)
          9745  => 16#78DC#,   --  磜 (<CJK Ideograph>)
          9746  => 16#78DD#,   --  磝 (<CJK Ideograph>)
          9747  => 16#78DE#,   --  磞 (<CJK Ideograph>)
          9748  => 16#78DF#,   --  磟 (<CJK Ideograph>)
          9749  => 16#78E0#,   --  磠 (<CJK Ideograph>)
          9750  => 16#78E1#,   --  磡 (<CJK Ideograph>)
          9751  => 16#78E2#,   --  磢 (<CJK Ideograph>)
          9752  => 16#78E3#,   --  磣 (<CJK Ideograph>)
          9753  => 16#78E4#,   --  磤 (<CJK Ideograph>)
          9754  => 16#78E5#,   --  磥 (<CJK Ideograph>)
          9755  => 16#78E6#,   --  磦 (<CJK Ideograph>)
          9756  => 16#78E7#,   --  磧 (<CJK Ideograph>)
          9757  => 16#78E9#,   --  磩 (<CJK Ideograph>)
          9758  => 16#78EA#,   --  磪 (<CJK Ideograph>)
          9759  => 16#78EB#,   --  磫 (<CJK Ideograph>)
          9760  => 16#78ED#,   --  磭 (<CJK Ideograph>)
          9761  => 16#78EE#,   --  磮 (<CJK Ideograph>)
          9762  => 16#78EF#,   --  磯 (<CJK Ideograph>)
          9763  => 16#78F0#,   --  磰 (<CJK Ideograph>)
          9764  => 16#78F1#,   --  磱 (<CJK Ideograph>)
          9765  => 16#78F3#,   --  磳 (<CJK Ideograph>)
          9766  => 16#78F5#,   --  磵 (<CJK Ideograph>)
          9767  => 16#78F6#,   --  磶 (<CJK Ideograph>)
          9768  => 16#78F8#,   --  磸 (<CJK Ideograph>)
          9769  => 16#78F9#,   --  磹 (<CJK Ideograph>)
          9770  => 16#78FB#,   --  磻 (<CJK Ideograph>)
          9771  => 16#78FC#,   --  磼 (<CJK Ideograph>)
          9772  => 16#78FD#,   --  磽 (<CJK Ideograph>)
          9773  => 16#78FE#,   --  磾 (<CJK Ideograph>)
          9774  => 16#78FF#,   --  磿 (<CJK Ideograph>)
          9775  => 16#7900#,   --  礀 (<CJK Ideograph>)
          9776  => 16#7902#,   --  礂 (<CJK Ideograph>)
          9777  => 16#7903#,   --  礃 (<CJK Ideograph>)
          9778  => 16#7904#,   --  礄 (<CJK Ideograph>)
          9779  => 16#7906#,   --  礆 (<CJK Ideograph>)
          9780  => 16#7907#,   --  礇 (<CJK Ideograph>)
          9781  => 16#7908#,   --  礈 (<CJK Ideograph>)
          9782  => 16#7909#,   --  礉 (<CJK Ideograph>)
          9783  => 16#790A#,   --  礊 (<CJK Ideograph>)
          9784  => 16#790B#,   --  礋 (<CJK Ideograph>)
          9785  => 16#790C#,   --  礌 (<CJK Ideograph>)
          9786  => 16#7840#,   --  础 (<CJK Ideograph>)
          9787  => 16#50A8#,   --  储 (<CJK Ideograph>)
          9788  => 16#77D7#,   --  矗 (<CJK Ideograph>)
          9789  => 16#6410#,   --  搐 (<CJK Ideograph>)
          9790  => 16#89E6#,   --  触 (<CJK Ideograph>)
          9791  => 16#5904#,   --  处 (<CJK Ideograph>)
          9792  => 16#63E3#,   --  揣 (<CJK Ideograph>)
          9793  => 16#5DDD#,   --  川 (<CJK Ideograph>)
          9794  => 16#7A7F#,   --  穿 (<CJK Ideograph>)
          9795  => 16#693D#,   --  椽 (<CJK Ideograph>)
          9796  => 16#4F20#,   --  传 (<CJK Ideograph>)
          9797  => 16#8239#,   --  船 (<CJK Ideograph>)
          9798  => 16#5598#,   --  喘 (<CJK Ideograph>)
          9799  => 16#4E32#,   --  串 (<CJK Ideograph>)
          9800  => 16#75AE#,   --  疮 (<CJK Ideograph>)
          9801  => 16#7A97#,   --  窗 (<CJK Ideograph>)
          9802  => 16#5E62#,   --  幢 (<CJK Ideograph>)
          9803  => 16#5E8A#,   --  床 (<CJK Ideograph>)
          9804  => 16#95EF#,   --  闯 (<CJK Ideograph>)
          9805  => 16#521B#,   --  创 (<CJK Ideograph>)
          9806  => 16#5439#,   --  吹 (<CJK Ideograph>)
          9807  => 16#708A#,   --  炊 (<CJK Ideograph>)
          9808  => 16#6376#,   --  捶 (<CJK Ideograph>)
          9809  => 16#9524#,   --  锤 (<CJK Ideograph>)
          9810  => 16#5782#,   --  垂 (<CJK Ideograph>)
          9811  => 16#6625#,   --  春 (<CJK Ideograph>)
          9812  => 16#693F#,   --  椿 (<CJK Ideograph>)
          9813  => 16#9187#,   --  醇 (<CJK Ideograph>)
          9814  => 16#5507#,   --  唇 (<CJK Ideograph>)
          9815  => 16#6DF3#,   --  淳 (<CJK Ideograph>)
          9816  => 16#7EAF#,   --  纯 (<CJK Ideograph>)
          9817  => 16#8822#,   --  蠢 (<CJK Ideograph>)
          9818  => 16#6233#,   --  戳 (<CJK Ideograph>)
          9819  => 16#7EF0#,   --  绰 (<CJK Ideograph>)
          9820  => 16#75B5#,   --  疵 (<CJK Ideograph>)
          9821  => 16#8328#,   --  茨 (<CJK Ideograph>)
          9822  => 16#78C1#,   --  磁 (<CJK Ideograph>)
          9823  => 16#96CC#,   --  雌 (<CJK Ideograph>)
          9824  => 16#8F9E#,   --  辞 (<CJK Ideograph>)
          9825  => 16#6148#,   --  慈 (<CJK Ideograph>)
          9826  => 16#74F7#,   --  瓷 (<CJK Ideograph>)
          9827  => 16#8BCD#,   --  词 (<CJK Ideograph>)
          9828  => 16#6B64#,   --  此 (<CJK Ideograph>)
          9829  => 16#523A#,   --  刺 (<CJK Ideograph>)
          9830  => 16#8D50#,   --  赐 (<CJK Ideograph>)
          9831  => 16#6B21#,   --  次 (<CJK Ideograph>)
          9832  => 16#806A#,   --  聪 (<CJK Ideograph>)
          9833  => 16#8471#,   --  葱 (<CJK Ideograph>)
          9834  => 16#56F1#,   --  囱 (<CJK Ideograph>)
          9835  => 16#5306#,   --  匆 (<CJK Ideograph>)
          9836  => 16#4ECE#,   --  从 (<CJK Ideograph>)
          9837  => 16#4E1B#,   --  丛 (<CJK Ideograph>)
          9838  => 16#51D1#,   --  凑 (<CJK Ideograph>)
          9839  => 16#7C97#,   --  粗 (<CJK Ideograph>)
          9840  => 16#918B#,   --  醋 (<CJK Ideograph>)
          9841  => 16#7C07#,   --  簇 (<CJK Ideograph>)
          9842  => 16#4FC3#,   --  促 (<CJK Ideograph>)
          9843  => 16#8E7F#,   --  蹿 (<CJK Ideograph>)
          9844  => 16#7BE1#,   --  篡 (<CJK Ideograph>)
          9845  => 16#7A9C#,   --  窜 (<CJK Ideograph>)
          9846  => 16#6467#,   --  摧 (<CJK Ideograph>)
          9847  => 16#5D14#,   --  崔 (<CJK Ideograph>)
          9848  => 16#50AC#,   --  催 (<CJK Ideograph>)
          9849  => 16#8106#,   --  脆 (<CJK Ideograph>)
          9850  => 16#7601#,   --  瘁 (<CJK Ideograph>)
          9851  => 16#7CB9#,   --  粹 (<CJK Ideograph>)
          9852  => 16#6DEC#,   --  淬 (<CJK Ideograph>)
          9853  => 16#7FE0#,   --  翠 (<CJK Ideograph>)
          9854  => 16#6751#,   --  村 (<CJK Ideograph>)
          9855  => 16#5B58#,   --  存 (<CJK Ideograph>)
          9856  => 16#5BF8#,   --  寸 (<CJK Ideograph>)
          9857  => 16#78CB#,   --  磋 (<CJK Ideograph>)
          9858  => 16#64AE#,   --  撮 (<CJK Ideograph>)
          9859  => 16#6413#,   --  搓 (<CJK Ideograph>)
          9860  => 16#63AA#,   --  措 (<CJK Ideograph>)
          9861  => 16#632B#,   --  挫 (<CJK Ideograph>)
          9862  => 16#9519#,   --  错 (<CJK Ideograph>)
          9863  => 16#642D#,   --  搭 (<CJK Ideograph>)
          9864  => 16#8FBE#,   --  达 (<CJK Ideograph>)
          9865  => 16#7B54#,   --  答 (<CJK Ideograph>)
          9866  => 16#7629#,   --  瘩 (<CJK Ideograph>)
          9867  => 16#6253#,   --  打 (<CJK Ideograph>)
          9868  => 16#5927#,   --  大 (<CJK Ideograph>)
          9869  => 16#5446#,   --  呆 (<CJK Ideograph>)
          9870  => 16#6B79#,   --  歹 (<CJK Ideograph>)
          9871  => 16#50A3#,   --  傣 (<CJK Ideograph>)
          9872  => 16#6234#,   --  戴 (<CJK Ideograph>)
          9873  => 16#5E26#,   --  带 (<CJK Ideograph>)
          9874  => 16#6B86#,   --  殆 (<CJK Ideograph>)
          9875  => 16#4EE3#,   --  代 (<CJK Ideograph>)
          9876  => 16#8D37#,   --  贷 (<CJK Ideograph>)
          9877  => 16#888B#,   --  袋 (<CJK Ideograph>)
          9878  => 16#5F85#,   --  待 (<CJK Ideograph>)
          9879  => 16#902E#,   --  逮 (<CJK Ideograph>)
          9880  => 16#790D#,   --  礍 (<CJK Ideograph>)
          9881  => 16#790E#,   --  礎 (<CJK Ideograph>)
          9882  => 16#790F#,   --  礏 (<CJK Ideograph>)
          9883  => 16#7910#,   --  礐 (<CJK Ideograph>)
          9884  => 16#7911#,   --  礑 (<CJK Ideograph>)
          9885  => 16#7912#,   --  礒 (<CJK Ideograph>)
          9886  => 16#7914#,   --  礔 (<CJK Ideograph>)
          9887  => 16#7915#,   --  礕 (<CJK Ideograph>)
          9888  => 16#7916#,   --  礖 (<CJK Ideograph>)
          9889  => 16#7917#,   --  礗 (<CJK Ideograph>)
          9890  => 16#7918#,   --  礘 (<CJK Ideograph>)
          9891  => 16#7919#,   --  礙 (<CJK Ideograph>)
          9892  => 16#791A#,   --  礚 (<CJK Ideograph>)
          9893  => 16#791B#,   --  礛 (<CJK Ideograph>)
          9894  => 16#791C#,   --  礜 (<CJK Ideograph>)
          9895  => 16#791D#,   --  礝 (<CJK Ideograph>)
          9896  => 16#791F#,   --  礟 (<CJK Ideograph>)
          9897  => 16#7920#,   --  礠 (<CJK Ideograph>)
          9898  => 16#7921#,   --  礡 (<CJK Ideograph>)
          9899  => 16#7922#,   --  礢 (<CJK Ideograph>)
          9900  => 16#7923#,   --  礣 (<CJK Ideograph>)
          9901  => 16#7925#,   --  礥 (<CJK Ideograph>)
          9902  => 16#7926#,   --  礦 (<CJK Ideograph>)
          9903  => 16#7927#,   --  礧 (<CJK Ideograph>)
          9904  => 16#7928#,   --  礨 (<CJK Ideograph>)
          9905  => 16#7929#,   --  礩 (<CJK Ideograph>)
          9906  => 16#792A#,   --  礪 (<CJK Ideograph>)
          9907  => 16#792B#,   --  礫 (<CJK Ideograph>)
          9908  => 16#792C#,   --  礬 (<CJK Ideograph>)
          9909  => 16#792D#,   --  礭 (<CJK Ideograph>)
          9910  => 16#792E#,   --  礮 (<CJK Ideograph>)
          9911  => 16#792F#,   --  礯 (<CJK Ideograph>)
          9912  => 16#7930#,   --  礰 (<CJK Ideograph>)
          9913  => 16#7931#,   --  礱 (<CJK Ideograph>)
          9914  => 16#7932#,   --  礲 (<CJK Ideograph>)
          9915  => 16#7933#,   --  礳 (<CJK Ideograph>)
          9916  => 16#7935#,   --  礵 (<CJK Ideograph>)
          9917  => 16#7936#,   --  礶 (<CJK Ideograph>)
          9918  => 16#7937#,   --  礷 (<CJK Ideograph>)
          9919  => 16#7938#,   --  礸 (<CJK Ideograph>)
          9920  => 16#7939#,   --  礹 (<CJK Ideograph>)
          9921  => 16#793D#,   --  礽 (<CJK Ideograph>)
          9922  => 16#793F#,   --  礿 (<CJK Ideograph>)
          9923  => 16#7942#,   --  祂 (<CJK Ideograph>)
          9924  => 16#7943#,   --  祃 (<CJK Ideograph>)
          9925  => 16#7944#,   --  祄 (<CJK Ideograph>)
          9926  => 16#7945#,   --  祅 (<CJK Ideograph>)
          9927  => 16#7947#,   --  祇 (<CJK Ideograph>)
          9928  => 16#794A#,   --  祊 (<CJK Ideograph>)
          9929  => 16#794B#,   --  祋 (<CJK Ideograph>)
          9930  => 16#794C#,   --  祌 (<CJK Ideograph>)
          9931  => 16#794D#,   --  祍 (<CJK Ideograph>)
          9932  => 16#794E#,   --  祎 (<CJK Ideograph>)
          9933  => 16#794F#,   --  祏 (<CJK Ideograph>)
          9934  => 16#7950#,   --  祐 (<CJK Ideograph>)
          9935  => 16#7951#,   --  祑 (<CJK Ideograph>)
          9936  => 16#7952#,   --  祒 (<CJK Ideograph>)
          9937  => 16#7954#,   --  祔 (<CJK Ideograph>)
          9938  => 16#7955#,   --  祕 (<CJK Ideograph>)
          9939  => 16#7958#,   --  祘 (<CJK Ideograph>)
          9940  => 16#7959#,   --  祙 (<CJK Ideograph>)
          9941  => 16#7961#,   --  祡 (<CJK Ideograph>)
          9942  => 16#7963#,   --  祣 (<CJK Ideograph>)
          9943  => 16#7964#,   --  祤 (<CJK Ideograph>)
          9944  => 16#7966#,   --  祦 (<CJK Ideograph>)
          9945  => 16#7969#,   --  祩 (<CJK Ideograph>)
          9946  => 16#796A#,   --  祪 (<CJK Ideograph>)
          9947  => 16#796B#,   --  祫 (<CJK Ideograph>)
          9948  => 16#796C#,   --  祬 (<CJK Ideograph>)
          9949  => 16#796E#,   --  祮 (<CJK Ideograph>)
          9950  => 16#7970#,   --  祰 (<CJK Ideograph>)
          9951  => 16#7971#,   --  祱 (<CJK Ideograph>)
          9952  => 16#7972#,   --  祲 (<CJK Ideograph>)
          9953  => 16#7973#,   --  祳 (<CJK Ideograph>)
          9954  => 16#7974#,   --  祴 (<CJK Ideograph>)
          9955  => 16#7975#,   --  祵 (<CJK Ideograph>)
          9956  => 16#7976#,   --  祶 (<CJK Ideograph>)
          9957  => 16#7979#,   --  祹 (<CJK Ideograph>)
          9958  => 16#797B#,   --  祻 (<CJK Ideograph>)
          9959  => 16#797C#,   --  祼 (<CJK Ideograph>)
          9960  => 16#797D#,   --  祽 (<CJK Ideograph>)
          9961  => 16#797E#,   --  祾 (<CJK Ideograph>)
          9962  => 16#797F#,   --  祿 (<CJK Ideograph>)
          9963  => 16#7982#,   --  禂 (<CJK Ideograph>)
          9964  => 16#7983#,   --  禃 (<CJK Ideograph>)
          9965  => 16#7986#,   --  禆 (<CJK Ideograph>)
          9966  => 16#7987#,   --  禇 (<CJK Ideograph>)
          9967  => 16#7988#,   --  禈 (<CJK Ideograph>)
          9968  => 16#7989#,   --  禉 (<CJK Ideograph>)
          9969  => 16#798B#,   --  禋 (<CJK Ideograph>)
          9970  => 16#798C#,   --  禌 (<CJK Ideograph>)
          9971  => 16#798D#,   --  禍 (<CJK Ideograph>)
          9972  => 16#798E#,   --  禎 (<CJK Ideograph>)
          9973  => 16#7990#,   --  禐 (<CJK Ideograph>)
          9974  => 16#7991#,   --  禑 (<CJK Ideograph>)
          9975  => 16#7992#,   --  禒 (<CJK Ideograph>)
          9976  => 16#6020#,   --  怠 (<CJK Ideograph>)
          9977  => 16#803D#,   --  耽 (<CJK Ideograph>)
          9978  => 16#62C5#,   --  担 (<CJK Ideograph>)
          9979  => 16#4E39#,   --  丹 (<CJK Ideograph>)
          9980  => 16#5355#,   --  单 (<CJK Ideograph>)
          9981  => 16#90F8#,   --  郸 (<CJK Ideograph>)
          9982  => 16#63B8#,   --  掸 (<CJK Ideograph>)
          9983  => 16#80C6#,   --  胆 (<CJK Ideograph>)
          9984  => 16#65E6#,   --  旦 (<CJK Ideograph>)
          9985  => 16#6C2E#,   --  氮 (<CJK Ideograph>)
          9986  => 16#4F46#,   --  但 (<CJK Ideograph>)
          9987  => 16#60EE#,   --  惮 (<CJK Ideograph>)
          9988  => 16#6DE1#,   --  淡 (<CJK Ideograph>)
          9989  => 16#8BDE#,   --  诞 (<CJK Ideograph>)
          9990  => 16#5F39#,   --  弹 (<CJK Ideograph>)
          9991  => 16#86CB#,   --  蛋 (<CJK Ideograph>)
          9992  => 16#5F53#,   --  当 (<CJK Ideograph>)
          9993  => 16#6321#,   --  挡 (<CJK Ideograph>)
          9994  => 16#515A#,   --  党 (<CJK Ideograph>)
          9995  => 16#8361#,   --  荡 (<CJK Ideograph>)
          9996  => 16#6863#,   --  档 (<CJK Ideograph>)
          9997  => 16#5200#,   --  刀 (<CJK Ideograph>)
          9998  => 16#6363#,   --  捣 (<CJK Ideograph>)
          9999  => 16#8E48#,   --  蹈 (<CJK Ideograph>)
          10000 => 16#5012#,   --  倒 (<CJK Ideograph>)
          10001 => 16#5C9B#,   --  岛 (<CJK Ideograph>)
          10002 => 16#7977#,   --  祷 (<CJK Ideograph>)
          10003 => 16#5BFC#,   --  导 (<CJK Ideograph>)
          10004 => 16#5230#,   --  到 (<CJK Ideograph>)
          10005 => 16#7A3B#,   --  稻 (<CJK Ideograph>)
          10006 => 16#60BC#,   --  悼 (<CJK Ideograph>)
          10007 => 16#9053#,   --  道 (<CJK Ideograph>)
          10008 => 16#76D7#,   --  盗 (<CJK Ideograph>)
          10009 => 16#5FB7#,   --  德 (<CJK Ideograph>)
          10010 => 16#5F97#,   --  得 (<CJK Ideograph>)
          10011 => 16#7684#,   --  的 (<CJK Ideograph>)
          10012 => 16#8E6C#,   --  蹬 (<CJK Ideograph>)
          10013 => 16#706F#,   --  灯 (<CJK Ideograph>)
          10014 => 16#767B#,   --  登 (<CJK Ideograph>)
          10015 => 16#7B49#,   --  等 (<CJK Ideograph>)
          10016 => 16#77AA#,   --  瞪 (<CJK Ideograph>)
          10017 => 16#51F3#,   --  凳 (<CJK Ideograph>)
          10018 => 16#9093#,   --  邓 (<CJK Ideograph>)
          10019 => 16#5824#,   --  堤 (<CJK Ideograph>)
          10020 => 16#4F4E#,   --  低 (<CJK Ideograph>)
          10021 => 16#6EF4#,   --  滴 (<CJK Ideograph>)
          10022 => 16#8FEA#,   --  迪 (<CJK Ideograph>)
          10023 => 16#654C#,   --  敌 (<CJK Ideograph>)
          10024 => 16#7B1B#,   --  笛 (<CJK Ideograph>)
          10025 => 16#72C4#,   --  狄 (<CJK Ideograph>)
          10026 => 16#6DA4#,   --  涤 (<CJK Ideograph>)
          10027 => 16#7FDF#,   --  翟 (<CJK Ideograph>)
          10028 => 16#5AE1#,   --  嫡 (<CJK Ideograph>)
          10029 => 16#62B5#,   --  抵 (<CJK Ideograph>)
          10030 => 16#5E95#,   --  底 (<CJK Ideograph>)
          10031 => 16#5730#,   --  地 (<CJK Ideograph>)
          10032 => 16#8482#,   --  蒂 (<CJK Ideograph>)
          10033 => 16#7B2C#,   --  第 (<CJK Ideograph>)
          10034 => 16#5E1D#,   --  帝 (<CJK Ideograph>)
          10035 => 16#5F1F#,   --  弟 (<CJK Ideograph>)
          10036 => 16#9012#,   --  递 (<CJK Ideograph>)
          10037 => 16#7F14#,   --  缔 (<CJK Ideograph>)
          10038 => 16#98A0#,   --  颠 (<CJK Ideograph>)
          10039 => 16#6382#,   --  掂 (<CJK Ideograph>)
          10040 => 16#6EC7#,   --  滇 (<CJK Ideograph>)
          10041 => 16#7898#,   --  碘 (<CJK Ideograph>)
          10042 => 16#70B9#,   --  点 (<CJK Ideograph>)
          10043 => 16#5178#,   --  典 (<CJK Ideograph>)
          10044 => 16#975B#,   --  靛 (<CJK Ideograph>)
          10045 => 16#57AB#,   --  垫 (<CJK Ideograph>)
          10046 => 16#7535#,   --  电 (<CJK Ideograph>)
          10047 => 16#4F43#,   --  佃 (<CJK Ideograph>)
          10048 => 16#7538#,   --  甸 (<CJK Ideograph>)
          10049 => 16#5E97#,   --  店 (<CJK Ideograph>)
          10050 => 16#60E6#,   --  惦 (<CJK Ideograph>)
          10051 => 16#5960#,   --  奠 (<CJK Ideograph>)
          10052 => 16#6DC0#,   --  淀 (<CJK Ideograph>)
          10053 => 16#6BBF#,   --  殿 (<CJK Ideograph>)
          10054 => 16#7889#,   --  碉 (<CJK Ideograph>)
          10055 => 16#53FC#,   --  叼 (<CJK Ideograph>)
          10056 => 16#96D5#,   --  雕 (<CJK Ideograph>)
          10057 => 16#51CB#,   --  凋 (<CJK Ideograph>)
          10058 => 16#5201#,   --  刁 (<CJK Ideograph>)
          10059 => 16#6389#,   --  掉 (<CJK Ideograph>)
          10060 => 16#540A#,   --  吊 (<CJK Ideograph>)
          10061 => 16#9493#,   --  钓 (<CJK Ideograph>)
          10062 => 16#8C03#,   --  调 (<CJK Ideograph>)
          10063 => 16#8DCC#,   --  跌 (<CJK Ideograph>)
          10064 => 16#7239#,   --  爹 (<CJK Ideograph>)
          10065 => 16#789F#,   --  碟 (<CJK Ideograph>)
          10066 => 16#8776#,   --  蝶 (<CJK Ideograph>)
          10067 => 16#8FED#,   --  迭 (<CJK Ideograph>)
          10068 => 16#8C0D#,   --  谍 (<CJK Ideograph>)
          10069 => 16#53E0#,   --  叠 (<CJK Ideograph>)
          10070 => 16#7993#,   --  禓 (<CJK Ideograph>)
          10071 => 16#7994#,   --  禔 (<CJK Ideograph>)
          10072 => 16#7995#,   --  禕 (<CJK Ideograph>)
          10073 => 16#7996#,   --  禖 (<CJK Ideograph>)
          10074 => 16#7997#,   --  禗 (<CJK Ideograph>)
          10075 => 16#7998#,   --  禘 (<CJK Ideograph>)
          10076 => 16#7999#,   --  禙 (<CJK Ideograph>)
          10077 => 16#799B#,   --  禛 (<CJK Ideograph>)
          10078 => 16#799C#,   --  禜 (<CJK Ideograph>)
          10079 => 16#799D#,   --  禝 (<CJK Ideograph>)
          10080 => 16#799E#,   --  禞 (<CJK Ideograph>)
          10081 => 16#799F#,   --  禟 (<CJK Ideograph>)
          10082 => 16#79A0#,   --  禠 (<CJK Ideograph>)
          10083 => 16#79A1#,   --  禡 (<CJK Ideograph>)
          10084 => 16#79A2#,   --  禢 (<CJK Ideograph>)
          10085 => 16#79A3#,   --  禣 (<CJK Ideograph>)
          10086 => 16#79A4#,   --  禤 (<CJK Ideograph>)
          10087 => 16#79A5#,   --  禥 (<CJK Ideograph>)
          10088 => 16#79A6#,   --  禦 (<CJK Ideograph>)
          10089 => 16#79A8#,   --  禨 (<CJK Ideograph>)
          10090 => 16#79A9#,   --  禩 (<CJK Ideograph>)
          10091 => 16#79AA#,   --  禪 (<CJK Ideograph>)
          10092 => 16#79AB#,   --  禫 (<CJK Ideograph>)
          10093 => 16#79AC#,   --  禬 (<CJK Ideograph>)
          10094 => 16#79AD#,   --  禭 (<CJK Ideograph>)
          10095 => 16#79AE#,   --  禮 (<CJK Ideograph>)
          10096 => 16#79AF#,   --  禯 (<CJK Ideograph>)
          10097 => 16#79B0#,   --  禰 (<CJK Ideograph>)
          10098 => 16#79B1#,   --  禱 (<CJK Ideograph>)
          10099 => 16#79B2#,   --  禲 (<CJK Ideograph>)
          10100 => 16#79B4#,   --  禴 (<CJK Ideograph>)
          10101 => 16#79B5#,   --  禵 (<CJK Ideograph>)
          10102 => 16#79B6#,   --  禶 (<CJK Ideograph>)
          10103 => 16#79B7#,   --  禷 (<CJK Ideograph>)
          10104 => 16#79B8#,   --  禸 (<CJK Ideograph>)
          10105 => 16#79BC#,   --  禼 (<CJK Ideograph>)
          10106 => 16#79BF#,   --  禿 (<CJK Ideograph>)
          10107 => 16#79C2#,   --  秂 (<CJK Ideograph>)
          10108 => 16#79C4#,   --  秄 (<CJK Ideograph>)
          10109 => 16#79C5#,   --  秅 (<CJK Ideograph>)
          10110 => 16#79C7#,   --  秇 (<CJK Ideograph>)
          10111 => 16#79C8#,   --  秈 (<CJK Ideograph>)
          10112 => 16#79CA#,   --  秊 (<CJK Ideograph>)
          10113 => 16#79CC#,   --  秌 (<CJK Ideograph>)
          10114 => 16#79CE#,   --  秎 (<CJK Ideograph>)
          10115 => 16#79CF#,   --  秏 (<CJK Ideograph>)
          10116 => 16#79D0#,   --  秐 (<CJK Ideograph>)
          10117 => 16#79D3#,   --  秓 (<CJK Ideograph>)
          10118 => 16#79D4#,   --  秔 (<CJK Ideograph>)
          10119 => 16#79D6#,   --  秖 (<CJK Ideograph>)
          10120 => 16#79D7#,   --  秗 (<CJK Ideograph>)
          10121 => 16#79D9#,   --  秙 (<CJK Ideograph>)
          10122 => 16#79DA#,   --  秚 (<CJK Ideograph>)
          10123 => 16#79DB#,   --  秛 (<CJK Ideograph>)
          10124 => 16#79DC#,   --  秜 (<CJK Ideograph>)
          10125 => 16#79DD#,   --  秝 (<CJK Ideograph>)
          10126 => 16#79DE#,   --  秞 (<CJK Ideograph>)
          10127 => 16#79E0#,   --  秠 (<CJK Ideograph>)
          10128 => 16#79E1#,   --  秡 (<CJK Ideograph>)
          10129 => 16#79E2#,   --  秢 (<CJK Ideograph>)
          10130 => 16#79E5#,   --  秥 (<CJK Ideograph>)
          10131 => 16#79E8#,   --  秨 (<CJK Ideograph>)
          10132 => 16#79EA#,   --  秪 (<CJK Ideograph>)
          10133 => 16#79EC#,   --  秬 (<CJK Ideograph>)
          10134 => 16#79EE#,   --  秮 (<CJK Ideograph>)
          10135 => 16#79F1#,   --  秱 (<CJK Ideograph>)
          10136 => 16#79F2#,   --  秲 (<CJK Ideograph>)
          10137 => 16#79F3#,   --  秳 (<CJK Ideograph>)
          10138 => 16#79F4#,   --  秴 (<CJK Ideograph>)
          10139 => 16#79F5#,   --  秵 (<CJK Ideograph>)
          10140 => 16#79F6#,   --  秶 (<CJK Ideograph>)
          10141 => 16#79F7#,   --  秷 (<CJK Ideograph>)
          10142 => 16#79F9#,   --  秹 (<CJK Ideograph>)
          10143 => 16#79FA#,   --  秺 (<CJK Ideograph>)
          10144 => 16#79FC#,   --  秼 (<CJK Ideograph>)
          10145 => 16#79FE#,   --  秾 (<CJK Ideograph>)
          10146 => 16#79FF#,   --  秿 (<CJK Ideograph>)
          10147 => 16#7A01#,   --  稁 (<CJK Ideograph>)
          10148 => 16#7A04#,   --  稄 (<CJK Ideograph>)
          10149 => 16#7A05#,   --  稅 (<CJK Ideograph>)
          10150 => 16#7A07#,   --  稇 (<CJK Ideograph>)
          10151 => 16#7A08#,   --  稈 (<CJK Ideograph>)
          10152 => 16#7A09#,   --  稉 (<CJK Ideograph>)
          10153 => 16#7A0A#,   --  稊 (<CJK Ideograph>)
          10154 => 16#7A0C#,   --  稌 (<CJK Ideograph>)
          10155 => 16#7A0F#,   --  稏 (<CJK Ideograph>)
          10156 => 16#7A10#,   --  稐 (<CJK Ideograph>)
          10157 => 16#7A11#,   --  稑 (<CJK Ideograph>)
          10158 => 16#7A12#,   --  稒 (<CJK Ideograph>)
          10159 => 16#7A13#,   --  稓 (<CJK Ideograph>)
          10160 => 16#7A15#,   --  稕 (<CJK Ideograph>)
          10161 => 16#7A16#,   --  稖 (<CJK Ideograph>)
          10162 => 16#7A18#,   --  稘 (<CJK Ideograph>)
          10163 => 16#7A19#,   --  稙 (<CJK Ideograph>)
          10164 => 16#7A1B#,   --  稛 (<CJK Ideograph>)
          10165 => 16#7A1C#,   --  稜 (<CJK Ideograph>)
          10166 => 16#4E01#,   --  丁 (<CJK Ideograph>)
          10167 => 16#76EF#,   --  盯 (<CJK Ideograph>)
          10168 => 16#53EE#,   --  叮 (<CJK Ideograph>)
          10169 => 16#9489#,   --  钉 (<CJK Ideograph>)
          10170 => 16#9876#,   --  顶 (<CJK Ideograph>)
          10171 => 16#9F0E#,   --  鼎 (<CJK Ideograph>)
          10172 => 16#952D#,   --  锭 (<CJK Ideograph>)
          10173 => 16#5B9A#,   --  定 (<CJK Ideograph>)
          10174 => 16#8BA2#,   --  订 (<CJK Ideograph>)
          10175 => 16#4E22#,   --  丢 (<CJK Ideograph>)
          10176 => 16#4E1C#,   --  东 (<CJK Ideograph>)
          10177 => 16#51AC#,   --  冬 (<CJK Ideograph>)
          10178 => 16#8463#,   --  董 (<CJK Ideograph>)
          10179 => 16#61C2#,   --  懂 (<CJK Ideograph>)
          10180 => 16#52A8#,   --  动 (<CJK Ideograph>)
          10181 => 16#680B#,   --  栋 (<CJK Ideograph>)
          10182 => 16#4F97#,   --  侗 (<CJK Ideograph>)
          10183 => 16#606B#,   --  恫 (<CJK Ideograph>)
          10184 => 16#51BB#,   --  冻 (<CJK Ideograph>)
          10185 => 16#6D1E#,   --  洞 (<CJK Ideograph>)
          10186 => 16#515C#,   --  兜 (<CJK Ideograph>)
          10187 => 16#6296#,   --  抖 (<CJK Ideograph>)
          10188 => 16#6597#,   --  斗 (<CJK Ideograph>)
          10189 => 16#9661#,   --  陡 (<CJK Ideograph>)
          10190 => 16#8C46#,   --  豆 (<CJK Ideograph>)
          10191 => 16#9017#,   --  逗 (<CJK Ideograph>)
          10192 => 16#75D8#,   --  痘 (<CJK Ideograph>)
          10193 => 16#90FD#,   --  都 (<CJK Ideograph>)
          10194 => 16#7763#,   --  督 (<CJK Ideograph>)
          10195 => 16#6BD2#,   --  毒 (<CJK Ideograph>)
          10196 => 16#728A#,   --  犊 (<CJK Ideograph>)
          10197 => 16#72EC#,   --  独 (<CJK Ideograph>)
          10198 => 16#8BFB#,   --  读 (<CJK Ideograph>)
          10199 => 16#5835#,   --  堵 (<CJK Ideograph>)
          10200 => 16#7779#,   --  睹 (<CJK Ideograph>)
          10201 => 16#8D4C#,   --  赌 (<CJK Ideograph>)
          10202 => 16#675C#,   --  杜 (<CJK Ideograph>)
          10203 => 16#9540#,   --  镀 (<CJK Ideograph>)
          10204 => 16#809A#,   --  肚 (<CJK Ideograph>)
          10205 => 16#5EA6#,   --  度 (<CJK Ideograph>)
          10206 => 16#6E21#,   --  渡 (<CJK Ideograph>)
          10207 => 16#5992#,   --  妒 (<CJK Ideograph>)
          10208 => 16#7AEF#,   --  端 (<CJK Ideograph>)
          10209 => 16#77ED#,   --  短 (<CJK Ideograph>)
          10210 => 16#953B#,   --  锻 (<CJK Ideograph>)
          10211 => 16#6BB5#,   --  段 (<CJK Ideograph>)
          10212 => 16#65AD#,   --  断 (<CJK Ideograph>)
          10213 => 16#7F0E#,   --  缎 (<CJK Ideograph>)
          10214 => 16#5806#,   --  堆 (<CJK Ideograph>)
          10215 => 16#5151#,   --  兑 (<CJK Ideograph>)
          10216 => 16#961F#,   --  队 (<CJK Ideograph>)
          10217 => 16#5BF9#,   --  对 (<CJK Ideograph>)
          10218 => 16#58A9#,   --  墩 (<CJK Ideograph>)
          10219 => 16#5428#,   --  吨 (<CJK Ideograph>)
          10220 => 16#8E72#,   --  蹲 (<CJK Ideograph>)
          10221 => 16#6566#,   --  敦 (<CJK Ideograph>)
          10222 => 16#987F#,   --  顿 (<CJK Ideograph>)
          10223 => 16#56E4#,   --  囤 (<CJK Ideograph>)
          10224 => 16#949D#,   --  钝 (<CJK Ideograph>)
          10225 => 16#76FE#,   --  盾 (<CJK Ideograph>)
          10226 => 16#9041#,   --  遁 (<CJK Ideograph>)
          10227 => 16#6387#,   --  掇 (<CJK Ideograph>)
          10228 => 16#54C6#,   --  哆 (<CJK Ideograph>)
          10229 => 16#591A#,   --  多 (<CJK Ideograph>)
          10230 => 16#593A#,   --  夺 (<CJK Ideograph>)
          10231 => 16#579B#,   --  垛 (<CJK Ideograph>)
          10232 => 16#8EB2#,   --  躲 (<CJK Ideograph>)
          10233 => 16#6735#,   --  朵 (<CJK Ideograph>)
          10234 => 16#8DFA#,   --  跺 (<CJK Ideograph>)
          10235 => 16#8235#,   --  舵 (<CJK Ideograph>)
          10236 => 16#5241#,   --  剁 (<CJK Ideograph>)
          10237 => 16#60F0#,   --  惰 (<CJK Ideograph>)
          10238 => 16#5815#,   --  堕 (<CJK Ideograph>)
          10239 => 16#86FE#,   --  蛾 (<CJK Ideograph>)
          10240 => 16#5CE8#,   --  峨 (<CJK Ideograph>)
          10241 => 16#9E45#,   --  鹅 (<CJK Ideograph>)
          10242 => 16#4FC4#,   --  俄 (<CJK Ideograph>)
          10243 => 16#989D#,   --  额 (<CJK Ideograph>)
          10244 => 16#8BB9#,   --  讹 (<CJK Ideograph>)
          10245 => 16#5A25#,   --  娥 (<CJK Ideograph>)
          10246 => 16#6076#,   --  恶 (<CJK Ideograph>)
          10247 => 16#5384#,   --  厄 (<CJK Ideograph>)
          10248 => 16#627C#,   --  扼 (<CJK Ideograph>)
          10249 => 16#904F#,   --  遏 (<CJK Ideograph>)
          10250 => 16#9102#,   --  鄂 (<CJK Ideograph>)
          10251 => 16#997F#,   --  饿 (<CJK Ideograph>)
          10252 => 16#6069#,   --  恩 (<CJK Ideograph>)
          10253 => 16#800C#,   --  而 (<CJK Ideograph>)
          10254 => 16#513F#,   --  儿 (<CJK Ideograph>)
          10255 => 16#8033#,   --  耳 (<CJK Ideograph>)
          10256 => 16#5C14#,   --  尔 (<CJK Ideograph>)
          10257 => 16#9975#,   --  饵 (<CJK Ideograph>)
          10258 => 16#6D31#,   --  洱 (<CJK Ideograph>)
          10259 => 16#4E8C#,   --  二 (<CJK Ideograph>)
          10260 => 16#7A1D#,   --  稝 (<CJK Ideograph>)
          10261 => 16#7A1F#,   --  稟 (<CJK Ideograph>)
          10262 => 16#7A21#,   --  稡 (<CJK Ideograph>)
          10263 => 16#7A22#,   --  稢 (<CJK Ideograph>)
          10264 => 16#7A24#,   --  稤 (<CJK Ideograph>)
          10265 => 16#7A25#,   --  稥 (<CJK Ideograph>)
          10266 => 16#7A26#,   --  稦 (<CJK Ideograph>)
          10267 => 16#7A27#,   --  稧 (<CJK Ideograph>)
          10268 => 16#7A28#,   --  稨 (<CJK Ideograph>)
          10269 => 16#7A29#,   --  稩 (<CJK Ideograph>)
          10270 => 16#7A2A#,   --  稪 (<CJK Ideograph>)
          10271 => 16#7A2B#,   --  稫 (<CJK Ideograph>)
          10272 => 16#7A2C#,   --  稬 (<CJK Ideograph>)
          10273 => 16#7A2D#,   --  稭 (<CJK Ideograph>)
          10274 => 16#7A2E#,   --  種 (<CJK Ideograph>)
          10275 => 16#7A2F#,   --  稯 (<CJK Ideograph>)
          10276 => 16#7A30#,   --  稰 (<CJK Ideograph>)
          10277 => 16#7A31#,   --  稱 (<CJK Ideograph>)
          10278 => 16#7A32#,   --  稲 (<CJK Ideograph>)
          10279 => 16#7A34#,   --  稴 (<CJK Ideograph>)
          10280 => 16#7A35#,   --  稵 (<CJK Ideograph>)
          10281 => 16#7A36#,   --  稶 (<CJK Ideograph>)
          10282 => 16#7A38#,   --  稸 (<CJK Ideograph>)
          10283 => 16#7A3A#,   --  稺 (<CJK Ideograph>)
          10284 => 16#7A3E#,   --  稾 (<CJK Ideograph>)
          10285 => 16#7A40#,   --  穀 (<CJK Ideograph>)
          10286 => 16#7A41#,   --  穁 (<CJK Ideograph>)
          10287 => 16#7A42#,   --  穂 (<CJK Ideograph>)
          10288 => 16#7A43#,   --  穃 (<CJK Ideograph>)
          10289 => 16#7A44#,   --  穄 (<CJK Ideograph>)
          10290 => 16#7A45#,   --  穅 (<CJK Ideograph>)
          10291 => 16#7A47#,   --  穇 (<CJK Ideograph>)
          10292 => 16#7A48#,   --  穈 (<CJK Ideograph>)
          10293 => 16#7A49#,   --  穉 (<CJK Ideograph>)
          10294 => 16#7A4A#,   --  穊 (<CJK Ideograph>)
          10295 => 16#7A4B#,   --  穋 (<CJK Ideograph>)
          10296 => 16#7A4C#,   --  穌 (<CJK Ideograph>)
          10297 => 16#7A4D#,   --  積 (<CJK Ideograph>)
          10298 => 16#7A4E#,   --  穎 (<CJK Ideograph>)
          10299 => 16#7A4F#,   --  穏 (<CJK Ideograph>)
          10300 => 16#7A50#,   --  穐 (<CJK Ideograph>)
          10301 => 16#7A52#,   --  穒 (<CJK Ideograph>)
          10302 => 16#7A53#,   --  穓 (<CJK Ideograph>)
          10303 => 16#7A54#,   --  穔 (<CJK Ideograph>)
          10304 => 16#7A55#,   --  穕 (<CJK Ideograph>)
          10305 => 16#7A56#,   --  穖 (<CJK Ideograph>)
          10306 => 16#7A58#,   --  穘 (<CJK Ideograph>)
          10307 => 16#7A59#,   --  穙 (<CJK Ideograph>)
          10308 => 16#7A5A#,   --  穚 (<CJK Ideograph>)
          10309 => 16#7A5B#,   --  穛 (<CJK Ideograph>)
          10310 => 16#7A5C#,   --  穜 (<CJK Ideograph>)
          10311 => 16#7A5D#,   --  穝 (<CJK Ideograph>)
          10312 => 16#7A5E#,   --  穞 (<CJK Ideograph>)
          10313 => 16#7A5F#,   --  穟 (<CJK Ideograph>)
          10314 => 16#7A60#,   --  穠 (<CJK Ideograph>)
          10315 => 16#7A61#,   --  穡 (<CJK Ideograph>)
          10316 => 16#7A62#,   --  穢 (<CJK Ideograph>)
          10317 => 16#7A63#,   --  穣 (<CJK Ideograph>)
          10318 => 16#7A64#,   --  穤 (<CJK Ideograph>)
          10319 => 16#7A65#,   --  穥 (<CJK Ideograph>)
          10320 => 16#7A66#,   --  穦 (<CJK Ideograph>)
          10321 => 16#7A67#,   --  穧 (<CJK Ideograph>)
          10322 => 16#7A68#,   --  穨 (<CJK Ideograph>)
          10323 => 16#7A69#,   --  穩 (<CJK Ideograph>)
          10324 => 16#7A6A#,   --  穪 (<CJK Ideograph>)
          10325 => 16#7A6B#,   --  穫 (<CJK Ideograph>)
          10326 => 16#7A6C#,   --  穬 (<CJK Ideograph>)
          10327 => 16#7A6D#,   --  穭 (<CJK Ideograph>)
          10328 => 16#7A6E#,   --  穮 (<CJK Ideograph>)
          10329 => 16#7A6F#,   --  穯 (<CJK Ideograph>)
          10330 => 16#7A71#,   --  穱 (<CJK Ideograph>)
          10331 => 16#7A72#,   --  穲 (<CJK Ideograph>)
          10332 => 16#7A73#,   --  穳 (<CJK Ideograph>)
          10333 => 16#7A75#,   --  穵 (<CJK Ideograph>)
          10334 => 16#7A7B#,   --  穻 (<CJK Ideograph>)
          10335 => 16#7A7C#,   --  穼 (<CJK Ideograph>)
          10336 => 16#7A7D#,   --  穽 (<CJK Ideograph>)
          10337 => 16#7A7E#,   --  穾 (<CJK Ideograph>)
          10338 => 16#7A82#,   --  窂 (<CJK Ideograph>)
          10339 => 16#7A85#,   --  窅 (<CJK Ideograph>)
          10340 => 16#7A87#,   --  窇 (<CJK Ideograph>)
          10341 => 16#7A89#,   --  窉 (<CJK Ideograph>)
          10342 => 16#7A8A#,   --  窊 (<CJK Ideograph>)
          10343 => 16#7A8B#,   --  窋 (<CJK Ideograph>)
          10344 => 16#7A8C#,   --  窌 (<CJK Ideograph>)
          10345 => 16#7A8E#,   --  窎 (<CJK Ideograph>)
          10346 => 16#7A8F#,   --  窏 (<CJK Ideograph>)
          10347 => 16#7A90#,   --  窐 (<CJK Ideograph>)
          10348 => 16#7A93#,   --  窓 (<CJK Ideograph>)
          10349 => 16#7A94#,   --  窔 (<CJK Ideograph>)
          10350 => 16#7A99#,   --  窙 (<CJK Ideograph>)
          10351 => 16#7A9A#,   --  窚 (<CJK Ideograph>)
          10352 => 16#7A9B#,   --  窛 (<CJK Ideograph>)
          10353 => 16#7A9E#,   --  窞 (<CJK Ideograph>)
          10354 => 16#7AA1#,   --  窡 (<CJK Ideograph>)
          10355 => 16#7AA2#,   --  窢 (<CJK Ideograph>)
          10356 => 16#8D30#,   --  贰 (<CJK Ideograph>)
          10357 => 16#53D1#,   --  发 (<CJK Ideograph>)
          10358 => 16#7F5A#,   --  罚 (<CJK Ideograph>)
          10359 => 16#7B4F#,   --  筏 (<CJK Ideograph>)
          10360 => 16#4F10#,   --  伐 (<CJK Ideograph>)
          10361 => 16#4E4F#,   --  乏 (<CJK Ideograph>)
          10362 => 16#9600#,   --  阀 (<CJK Ideograph>)
          10363 => 16#6CD5#,   --  法 (<CJK Ideograph>)
          10364 => 16#73D0#,   --  珐 (<CJK Ideograph>)
          10365 => 16#85E9#,   --  藩 (<CJK Ideograph>)
          10366 => 16#5E06#,   --  帆 (<CJK Ideograph>)
          10367 => 16#756A#,   --  番 (<CJK Ideograph>)
          10368 => 16#7FFB#,   --  翻 (<CJK Ideograph>)
          10369 => 16#6A0A#,   --  樊 (<CJK Ideograph>)
          10370 => 16#77FE#,   --  矾 (<CJK Ideograph>)
          10371 => 16#9492#,   --  钒 (<CJK Ideograph>)
          10372 => 16#7E41#,   --  繁 (<CJK Ideograph>)
          10373 => 16#51E1#,   --  凡 (<CJK Ideograph>)
          10374 => 16#70E6#,   --  烦 (<CJK Ideograph>)
          10375 => 16#53CD#,   --  反 (<CJK Ideograph>)
          10376 => 16#8FD4#,   --  返 (<CJK Ideograph>)
          10377 => 16#8303#,   --  范 (<CJK Ideograph>)
          10378 => 16#8D29#,   --  贩 (<CJK Ideograph>)
          10379 => 16#72AF#,   --  犯 (<CJK Ideograph>)
          10380 => 16#996D#,   --  饭 (<CJK Ideograph>)
          10381 => 16#6CDB#,   --  泛 (<CJK Ideograph>)
          10382 => 16#574A#,   --  坊 (<CJK Ideograph>)
          10383 => 16#82B3#,   --  芳 (<CJK Ideograph>)
          10384 => 16#65B9#,   --  方 (<CJK Ideograph>)
          10385 => 16#80AA#,   --  肪 (<CJK Ideograph>)
          10386 => 16#623F#,   --  房 (<CJK Ideograph>)
          10387 => 16#9632#,   --  防 (<CJK Ideograph>)
          10388 => 16#59A8#,   --  妨 (<CJK Ideograph>)
          10389 => 16#4EFF#,   --  仿 (<CJK Ideograph>)
          10390 => 16#8BBF#,   --  访 (<CJK Ideograph>)
          10391 => 16#7EBA#,   --  纺 (<CJK Ideograph>)
          10392 => 16#653E#,   --  放 (<CJK Ideograph>)
          10393 => 16#83F2#,   --  菲 (<CJK Ideograph>)
          10394 => 16#975E#,   --  非 (<CJK Ideograph>)
          10395 => 16#5561#,   --  啡 (<CJK Ideograph>)
          10396 => 16#98DE#,   --  飞 (<CJK Ideograph>)
          10397 => 16#80A5#,   --  肥 (<CJK Ideograph>)
          10398 => 16#532A#,   --  匪 (<CJK Ideograph>)
          10399 => 16#8BFD#,   --  诽 (<CJK Ideograph>)
          10400 => 16#5420#,   --  吠 (<CJK Ideograph>)
          10401 => 16#80BA#,   --  肺 (<CJK Ideograph>)
          10402 => 16#5E9F#,   --  废 (<CJK Ideograph>)
          10403 => 16#6CB8#,   --  沸 (<CJK Ideograph>)
          10404 => 16#8D39#,   --  费 (<CJK Ideograph>)
          10405 => 16#82AC#,   --  芬 (<CJK Ideograph>)
          10406 => 16#915A#,   --  酚 (<CJK Ideograph>)
          10407 => 16#5429#,   --  吩 (<CJK Ideograph>)
          10408 => 16#6C1B#,   --  氛 (<CJK Ideograph>)
          10409 => 16#5206#,   --  分 (<CJK Ideograph>)
          10410 => 16#7EB7#,   --  纷 (<CJK Ideograph>)
          10411 => 16#575F#,   --  坟 (<CJK Ideograph>)
          10412 => 16#711A#,   --  焚 (<CJK Ideograph>)
          10413 => 16#6C7E#,   --  汾 (<CJK Ideograph>)
          10414 => 16#7C89#,   --  粉 (<CJK Ideograph>)
          10415 => 16#594B#,   --  奋 (<CJK Ideograph>)
          10416 => 16#4EFD#,   --  份 (<CJK Ideograph>)
          10417 => 16#5FFF#,   --  忿 (<CJK Ideograph>)
          10418 => 16#6124#,   --  愤 (<CJK Ideograph>)
          10419 => 16#7CAA#,   --  粪 (<CJK Ideograph>)
          10420 => 16#4E30#,   --  丰 (<CJK Ideograph>)
          10421 => 16#5C01#,   --  封 (<CJK Ideograph>)
          10422 => 16#67AB#,   --  枫 (<CJK Ideograph>)
          10423 => 16#8702#,   --  蜂 (<CJK Ideograph>)
          10424 => 16#5CF0#,   --  峰 (<CJK Ideograph>)
          10425 => 16#950B#,   --  锋 (<CJK Ideograph>)
          10426 => 16#98CE#,   --  风 (<CJK Ideograph>)
          10427 => 16#75AF#,   --  疯 (<CJK Ideograph>)
          10428 => 16#70FD#,   --  烽 (<CJK Ideograph>)
          10429 => 16#9022#,   --  逢 (<CJK Ideograph>)
          10430 => 16#51AF#,   --  冯 (<CJK Ideograph>)
          10431 => 16#7F1D#,   --  缝 (<CJK Ideograph>)
          10432 => 16#8BBD#,   --  讽 (<CJK Ideograph>)
          10433 => 16#5949#,   --  奉 (<CJK Ideograph>)
          10434 => 16#51E4#,   --  凤 (<CJK Ideograph>)
          10435 => 16#4F5B#,   --  佛 (<CJK Ideograph>)
          10436 => 16#5426#,   --  否 (<CJK Ideograph>)
          10437 => 16#592B#,   --  夫 (<CJK Ideograph>)
          10438 => 16#6577#,   --  敷 (<CJK Ideograph>)
          10439 => 16#80A4#,   --  肤 (<CJK Ideograph>)
          10440 => 16#5B75#,   --  孵 (<CJK Ideograph>)
          10441 => 16#6276#,   --  扶 (<CJK Ideograph>)
          10442 => 16#62C2#,   --  拂 (<CJK Ideograph>)
          10443 => 16#8F90#,   --  辐 (<CJK Ideograph>)
          10444 => 16#5E45#,   --  幅 (<CJK Ideograph>)
          10445 => 16#6C1F#,   --  氟 (<CJK Ideograph>)
          10446 => 16#7B26#,   --  符 (<CJK Ideograph>)
          10447 => 16#4F0F#,   --  伏 (<CJK Ideograph>)
          10448 => 16#4FD8#,   --  俘 (<CJK Ideograph>)
          10449 => 16#670D#,   --  服 (<CJK Ideograph>)
          10450 => 16#7AA3#,   --  窣 (<CJK Ideograph>)
          10451 => 16#7AA4#,   --  窤 (<CJK Ideograph>)
          10452 => 16#7AA7#,   --  窧 (<CJK Ideograph>)
          10453 => 16#7AA9#,   --  窩 (<CJK Ideograph>)
          10454 => 16#7AAA#,   --  窪 (<CJK Ideograph>)
          10455 => 16#7AAB#,   --  窫 (<CJK Ideograph>)
          10456 => 16#7AAE#,   --  窮 (<CJK Ideograph>)
          10457 => 16#7AAF#,   --  窯 (<CJK Ideograph>)
          10458 => 16#7AB0#,   --  窰 (<CJK Ideograph>)
          10459 => 16#7AB1#,   --  窱 (<CJK Ideograph>)
          10460 => 16#7AB2#,   --  窲 (<CJK Ideograph>)
          10461 => 16#7AB4#,   --  窴 (<CJK Ideograph>)
          10462 => 16#7AB5#,   --  窵 (<CJK Ideograph>)
          10463 => 16#7AB6#,   --  窶 (<CJK Ideograph>)
          10464 => 16#7AB7#,   --  窷 (<CJK Ideograph>)
          10465 => 16#7AB8#,   --  窸 (<CJK Ideograph>)
          10466 => 16#7AB9#,   --  窹 (<CJK Ideograph>)
          10467 => 16#7ABA#,   --  窺 (<CJK Ideograph>)
          10468 => 16#7ABB#,   --  窻 (<CJK Ideograph>)
          10469 => 16#7ABC#,   --  窼 (<CJK Ideograph>)
          10470 => 16#7ABD#,   --  窽 (<CJK Ideograph>)
          10471 => 16#7ABE#,   --  窾 (<CJK Ideograph>)
          10472 => 16#7AC0#,   --  竀 (<CJK Ideograph>)
          10473 => 16#7AC1#,   --  竁 (<CJK Ideograph>)
          10474 => 16#7AC2#,   --  竂 (<CJK Ideograph>)
          10475 => 16#7AC3#,   --  竃 (<CJK Ideograph>)
          10476 => 16#7AC4#,   --  竄 (<CJK Ideograph>)
          10477 => 16#7AC5#,   --  竅 (<CJK Ideograph>)
          10478 => 16#7AC6#,   --  竆 (<CJK Ideograph>)
          10479 => 16#7AC7#,   --  竇 (<CJK Ideograph>)
          10480 => 16#7AC8#,   --  竈 (<CJK Ideograph>)
          10481 => 16#7AC9#,   --  竉 (<CJK Ideograph>)
          10482 => 16#7ACA#,   --  竊 (<CJK Ideograph>)
          10483 => 16#7ACC#,   --  竌 (<CJK Ideograph>)
          10484 => 16#7ACD#,   --  竍 (<CJK Ideograph>)
          10485 => 16#7ACE#,   --  竎 (<CJK Ideograph>)
          10486 => 16#7ACF#,   --  竏 (<CJK Ideograph>)
          10487 => 16#7AD0#,   --  竐 (<CJK Ideograph>)
          10488 => 16#7AD1#,   --  竑 (<CJK Ideograph>)
          10489 => 16#7AD2#,   --  竒 (<CJK Ideograph>)
          10490 => 16#7AD3#,   --  竓 (<CJK Ideograph>)
          10491 => 16#7AD4#,   --  竔 (<CJK Ideograph>)
          10492 => 16#7AD5#,   --  竕 (<CJK Ideograph>)
          10493 => 16#7AD7#,   --  竗 (<CJK Ideograph>)
          10494 => 16#7AD8#,   --  竘 (<CJK Ideograph>)
          10495 => 16#7ADA#,   --  竚 (<CJK Ideograph>)
          10496 => 16#7ADB#,   --  竛 (<CJK Ideograph>)
          10497 => 16#7ADC#,   --  竜 (<CJK Ideograph>)
          10498 => 16#7ADD#,   --  竝 (<CJK Ideograph>)
          10499 => 16#7AE1#,   --  竡 (<CJK Ideograph>)
          10500 => 16#7AE2#,   --  竢 (<CJK Ideograph>)
          10501 => 16#7AE4#,   --  竤 (<CJK Ideograph>)
          10502 => 16#7AE7#,   --  竧 (<CJK Ideograph>)
          10503 => 16#7AE8#,   --  竨 (<CJK Ideograph>)
          10504 => 16#7AE9#,   --  竩 (<CJK Ideograph>)
          10505 => 16#7AEA#,   --  竪 (<CJK Ideograph>)
          10506 => 16#7AEB#,   --  竫 (<CJK Ideograph>)
          10507 => 16#7AEC#,   --  竬 (<CJK Ideograph>)
          10508 => 16#7AEE#,   --  竮 (<CJK Ideograph>)
          10509 => 16#7AF0#,   --  竰 (<CJK Ideograph>)
          10510 => 16#7AF1#,   --  竱 (<CJK Ideograph>)
          10511 => 16#7AF2#,   --  竲 (<CJK Ideograph>)
          10512 => 16#7AF3#,   --  竳 (<CJK Ideograph>)
          10513 => 16#7AF4#,   --  竴 (<CJK Ideograph>)
          10514 => 16#7AF5#,   --  竵 (<CJK Ideograph>)
          10515 => 16#7AF6#,   --  競 (<CJK Ideograph>)
          10516 => 16#7AF7#,   --  竷 (<CJK Ideograph>)
          10517 => 16#7AF8#,   --  竸 (<CJK Ideograph>)
          10518 => 16#7AFB#,   --  竻 (<CJK Ideograph>)
          10519 => 16#7AFC#,   --  竼 (<CJK Ideograph>)
          10520 => 16#7AFE#,   --  竾 (<CJK Ideograph>)
          10521 => 16#7B00#,   --  笀 (<CJK Ideograph>)
          10522 => 16#7B01#,   --  笁 (<CJK Ideograph>)
          10523 => 16#7B02#,   --  笂 (<CJK Ideograph>)
          10524 => 16#7B05#,   --  笅 (<CJK Ideograph>)
          10525 => 16#7B07#,   --  笇 (<CJK Ideograph>)
          10526 => 16#7B09#,   --  笉 (<CJK Ideograph>)
          10527 => 16#7B0C#,   --  笌 (<CJK Ideograph>)
          10528 => 16#7B0D#,   --  笍 (<CJK Ideograph>)
          10529 => 16#7B0E#,   --  笎 (<CJK Ideograph>)
          10530 => 16#7B10#,   --  笐 (<CJK Ideograph>)
          10531 => 16#7B12#,   --  笒 (<CJK Ideograph>)
          10532 => 16#7B13#,   --  笓 (<CJK Ideograph>)
          10533 => 16#7B16#,   --  笖 (<CJK Ideograph>)
          10534 => 16#7B17#,   --  笗 (<CJK Ideograph>)
          10535 => 16#7B18#,   --  笘 (<CJK Ideograph>)
          10536 => 16#7B1A#,   --  笚 (<CJK Ideograph>)
          10537 => 16#7B1C#,   --  笜 (<CJK Ideograph>)
          10538 => 16#7B1D#,   --  笝 (<CJK Ideograph>)
          10539 => 16#7B1F#,   --  笟 (<CJK Ideograph>)
          10540 => 16#7B21#,   --  笡 (<CJK Ideograph>)
          10541 => 16#7B22#,   --  笢 (<CJK Ideograph>)
          10542 => 16#7B23#,   --  笣 (<CJK Ideograph>)
          10543 => 16#7B27#,   --  笧 (<CJK Ideograph>)
          10544 => 16#7B29#,   --  笩 (<CJK Ideograph>)
          10545 => 16#7B2D#,   --  笭 (<CJK Ideograph>)
          10546 => 16#6D6E#,   --  浮 (<CJK Ideograph>)
          10547 => 16#6DAA#,   --  涪 (<CJK Ideograph>)
          10548 => 16#798F#,   --  福 (<CJK Ideograph>)
          10549 => 16#88B1#,   --  袱 (<CJK Ideograph>)
          10550 => 16#5F17#,   --  弗 (<CJK Ideograph>)
          10551 => 16#752B#,   --  甫 (<CJK Ideograph>)
          10552 => 16#629A#,   --  抚 (<CJK Ideograph>)
          10553 => 16#8F85#,   --  辅 (<CJK Ideograph>)
          10554 => 16#4FEF#,   --  俯 (<CJK Ideograph>)
          10555 => 16#91DC#,   --  釜 (<CJK Ideograph>)
          10556 => 16#65A7#,   --  斧 (<CJK Ideograph>)
          10557 => 16#812F#,   --  脯 (<CJK Ideograph>)
          10558 => 16#8151#,   --  腑 (<CJK Ideograph>)
          10559 => 16#5E9C#,   --  府 (<CJK Ideograph>)
          10560 => 16#8150#,   --  腐 (<CJK Ideograph>)
          10561 => 16#8D74#,   --  赴 (<CJK Ideograph>)
          10562 => 16#526F#,   --  副 (<CJK Ideograph>)
          10563 => 16#8986#,   --  覆 (<CJK Ideograph>)
          10564 => 16#8D4B#,   --  赋 (<CJK Ideograph>)
          10565 => 16#590D#,   --  复 (<CJK Ideograph>)
          10566 => 16#5085#,   --  傅 (<CJK Ideograph>)
          10567 => 16#4ED8#,   --  付 (<CJK Ideograph>)
          10568 => 16#961C#,   --  阜 (<CJK Ideograph>)
          10569 => 16#7236#,   --  父 (<CJK Ideograph>)
          10570 => 16#8179#,   --  腹 (<CJK Ideograph>)
          10571 => 16#8D1F#,   --  负 (<CJK Ideograph>)
          10572 => 16#5BCC#,   --  富 (<CJK Ideograph>)
          10573 => 16#8BA3#,   --  讣 (<CJK Ideograph>)
          10574 => 16#9644#,   --  附 (<CJK Ideograph>)
          10575 => 16#5987#,   --  妇 (<CJK Ideograph>)
          10576 => 16#7F1A#,   --  缚 (<CJK Ideograph>)
          10577 => 16#5490#,   --  咐 (<CJK Ideograph>)
          10578 => 16#5676#,   --  噶 (<CJK Ideograph>)
          10579 => 16#560E#,   --  嘎 (<CJK Ideograph>)
          10580 => 16#8BE5#,   --  该 (<CJK Ideograph>)
          10581 => 16#6539#,   --  改 (<CJK Ideograph>)
          10582 => 16#6982#,   --  概 (<CJK Ideograph>)
          10583 => 16#9499#,   --  钙 (<CJK Ideograph>)
          10584 => 16#76D6#,   --  盖 (<CJK Ideograph>)
          10585 => 16#6E89#,   --  溉 (<CJK Ideograph>)
          10586 => 16#5E72#,   --  干 (<CJK Ideograph>)
          10587 => 16#7518#,   --  甘 (<CJK Ideograph>)
          10588 => 16#6746#,   --  杆 (<CJK Ideograph>)
          10589 => 16#67D1#,   --  柑 (<CJK Ideograph>)
          10590 => 16#7AFF#,   --  竿 (<CJK Ideograph>)
          10591 => 16#809D#,   --  肝 (<CJK Ideograph>)
          10592 => 16#8D76#,   --  赶 (<CJK Ideograph>)
          10593 => 16#611F#,   --  感 (<CJK Ideograph>)
          10594 => 16#79C6#,   --  秆 (<CJK Ideograph>)
          10595 => 16#6562#,   --  敢 (<CJK Ideograph>)
          10596 => 16#8D63#,   --  赣 (<CJK Ideograph>)
          10597 => 16#5188#,   --  冈 (<CJK Ideograph>)
          10598 => 16#521A#,   --  刚 (<CJK Ideograph>)
          10599 => 16#94A2#,   --  钢 (<CJK Ideograph>)
          10600 => 16#7F38#,   --  缸 (<CJK Ideograph>)
          10601 => 16#809B#,   --  肛 (<CJK Ideograph>)
          10602 => 16#7EB2#,   --  纲 (<CJK Ideograph>)
          10603 => 16#5C97#,   --  岗 (<CJK Ideograph>)
          10604 => 16#6E2F#,   --  港 (<CJK Ideograph>)
          10605 => 16#6760#,   --  杠 (<CJK Ideograph>)
          10606 => 16#7BD9#,   --  篙 (<CJK Ideograph>)
          10607 => 16#768B#,   --  皋 (<CJK Ideograph>)
          10608 => 16#9AD8#,   --  高 (<CJK Ideograph>)
          10609 => 16#818F#,   --  膏 (<CJK Ideograph>)
          10610 => 16#7F94#,   --  羔 (<CJK Ideograph>)
          10611 => 16#7CD5#,   --  糕 (<CJK Ideograph>)
          10612 => 16#641E#,   --  搞 (<CJK Ideograph>)
          10613 => 16#9550#,   --  镐 (<CJK Ideograph>)
          10614 => 16#7A3F#,   --  稿 (<CJK Ideograph>)
          10615 => 16#544A#,   --  告 (<CJK Ideograph>)
          10616 => 16#54E5#,   --  哥 (<CJK Ideograph>)
          10617 => 16#6B4C#,   --  歌 (<CJK Ideograph>)
          10618 => 16#6401#,   --  搁 (<CJK Ideograph>)
          10619 => 16#6208#,   --  戈 (<CJK Ideograph>)
          10620 => 16#9E3D#,   --  鸽 (<CJK Ideograph>)
          10621 => 16#80F3#,   --  胳 (<CJK Ideograph>)
          10622 => 16#7599#,   --  疙 (<CJK Ideograph>)
          10623 => 16#5272#,   --  割 (<CJK Ideograph>)
          10624 => 16#9769#,   --  革 (<CJK Ideograph>)
          10625 => 16#845B#,   --  葛 (<CJK Ideograph>)
          10626 => 16#683C#,   --  格 (<CJK Ideograph>)
          10627 => 16#86E4#,   --  蛤 (<CJK Ideograph>)
          10628 => 16#9601#,   --  阁 (<CJK Ideograph>)
          10629 => 16#9694#,   --  隔 (<CJK Ideograph>)
          10630 => 16#94EC#,   --  铬 (<CJK Ideograph>)
          10631 => 16#4E2A#,   --  个 (<CJK Ideograph>)
          10632 => 16#5404#,   --  各 (<CJK Ideograph>)
          10633 => 16#7ED9#,   --  给 (<CJK Ideograph>)
          10634 => 16#6839#,   --  根 (<CJK Ideograph>)
          10635 => 16#8DDF#,   --  跟 (<CJK Ideograph>)
          10636 => 16#8015#,   --  耕 (<CJK Ideograph>)
          10637 => 16#66F4#,   --  更 (<CJK Ideograph>)
          10638 => 16#5E9A#,   --  庚 (<CJK Ideograph>)
          10639 => 16#7FB9#,   --  羹 (<CJK Ideograph>)
          10640 => 16#7B2F#,   --  笯 (<CJK Ideograph>)
          10641 => 16#7B30#,   --  笰 (<CJK Ideograph>)
          10642 => 16#7B32#,   --  笲 (<CJK Ideograph>)
          10643 => 16#7B34#,   --  笴 (<CJK Ideograph>)
          10644 => 16#7B35#,   --  笵 (<CJK Ideograph>)
          10645 => 16#7B36#,   --  笶 (<CJK Ideograph>)
          10646 => 16#7B37#,   --  笷 (<CJK Ideograph>)
          10647 => 16#7B39#,   --  笹 (<CJK Ideograph>)
          10648 => 16#7B3B#,   --  笻 (<CJK Ideograph>)
          10649 => 16#7B3D#,   --  笽 (<CJK Ideograph>)
          10650 => 16#7B3F#,   --  笿 (<CJK Ideograph>)
          10651 => 16#7B40#,   --  筀 (<CJK Ideograph>)
          10652 => 16#7B41#,   --  筁 (<CJK Ideograph>)
          10653 => 16#7B42#,   --  筂 (<CJK Ideograph>)
          10654 => 16#7B43#,   --  筃 (<CJK Ideograph>)
          10655 => 16#7B44#,   --  筄 (<CJK Ideograph>)
          10656 => 16#7B46#,   --  筆 (<CJK Ideograph>)
          10657 => 16#7B48#,   --  筈 (<CJK Ideograph>)
          10658 => 16#7B4A#,   --  筊 (<CJK Ideograph>)
          10659 => 16#7B4D#,   --  筍 (<CJK Ideograph>)
          10660 => 16#7B4E#,   --  筎 (<CJK Ideograph>)
          10661 => 16#7B53#,   --  筓 (<CJK Ideograph>)
          10662 => 16#7B55#,   --  筕 (<CJK Ideograph>)
          10663 => 16#7B57#,   --  筗 (<CJK Ideograph>)
          10664 => 16#7B59#,   --  筙 (<CJK Ideograph>)
          10665 => 16#7B5C#,   --  筜 (<CJK Ideograph>)
          10666 => 16#7B5E#,   --  筞 (<CJK Ideograph>)
          10667 => 16#7B5F#,   --  筟 (<CJK Ideograph>)
          10668 => 16#7B61#,   --  筡 (<CJK Ideograph>)
          10669 => 16#7B63#,   --  筣 (<CJK Ideograph>)
          10670 => 16#7B64#,   --  筤 (<CJK Ideograph>)
          10671 => 16#7B65#,   --  筥 (<CJK Ideograph>)
          10672 => 16#7B66#,   --  筦 (<CJK Ideograph>)
          10673 => 16#7B67#,   --  筧 (<CJK Ideograph>)
          10674 => 16#7B68#,   --  筨 (<CJK Ideograph>)
          10675 => 16#7B69#,   --  筩 (<CJK Ideograph>)
          10676 => 16#7B6A#,   --  筪 (<CJK Ideograph>)
          10677 => 16#7B6B#,   --  筫 (<CJK Ideograph>)
          10678 => 16#7B6C#,   --  筬 (<CJK Ideograph>)
          10679 => 16#7B6D#,   --  筭 (<CJK Ideograph>)
          10680 => 16#7B6F#,   --  筯 (<CJK Ideograph>)
          10681 => 16#7B70#,   --  筰 (<CJK Ideograph>)
          10682 => 16#7B73#,   --  筳 (<CJK Ideograph>)
          10683 => 16#7B74#,   --  筴 (<CJK Ideograph>)
          10684 => 16#7B76#,   --  筶 (<CJK Ideograph>)
          10685 => 16#7B78#,   --  筸 (<CJK Ideograph>)
          10686 => 16#7B7A#,   --  筺 (<CJK Ideograph>)
          10687 => 16#7B7C#,   --  筼 (<CJK Ideograph>)
          10688 => 16#7B7D#,   --  筽 (<CJK Ideograph>)
          10689 => 16#7B7F#,   --  筿 (<CJK Ideograph>)
          10690 => 16#7B81#,   --  箁 (<CJK Ideograph>)
          10691 => 16#7B82#,   --  箂 (<CJK Ideograph>)
          10692 => 16#7B83#,   --  箃 (<CJK Ideograph>)
          10693 => 16#7B84#,   --  箄 (<CJK Ideograph>)
          10694 => 16#7B86#,   --  箆 (<CJK Ideograph>)
          10695 => 16#7B87#,   --  箇 (<CJK Ideograph>)
          10696 => 16#7B88#,   --  箈 (<CJK Ideograph>)
          10697 => 16#7B89#,   --  箉 (<CJK Ideograph>)
          10698 => 16#7B8A#,   --  箊 (<CJK Ideograph>)
          10699 => 16#7B8B#,   --  箋 (<CJK Ideograph>)
          10700 => 16#7B8C#,   --  箌 (<CJK Ideograph>)
          10701 => 16#7B8E#,   --  箎 (<CJK Ideograph>)
          10702 => 16#7B8F#,   --  箏 (<CJK Ideograph>)
          10703 => 16#7B91#,   --  箑 (<CJK Ideograph>)
          10704 => 16#7B92#,   --  箒 (<CJK Ideograph>)
          10705 => 16#7B93#,   --  箓 (<CJK Ideograph>)
          10706 => 16#7B96#,   --  箖 (<CJK Ideograph>)
          10707 => 16#7B98#,   --  箘 (<CJK Ideograph>)
          10708 => 16#7B99#,   --  箙 (<CJK Ideograph>)
          10709 => 16#7B9A#,   --  箚 (<CJK Ideograph>)
          10710 => 16#7B9B#,   --  箛 (<CJK Ideograph>)
          10711 => 16#7B9E#,   --  箞 (<CJK Ideograph>)
          10712 => 16#7B9F#,   --  箟 (<CJK Ideograph>)
          10713 => 16#7BA0#,   --  箠 (<CJK Ideograph>)
          10714 => 16#7BA3#,   --  箣 (<CJK Ideograph>)
          10715 => 16#7BA4#,   --  箤 (<CJK Ideograph>)
          10716 => 16#7BA5#,   --  箥 (<CJK Ideograph>)
          10717 => 16#7BAE#,   --  箮 (<CJK Ideograph>)
          10718 => 16#7BAF#,   --  箯 (<CJK Ideograph>)
          10719 => 16#7BB0#,   --  箰 (<CJK Ideograph>)
          10720 => 16#7BB2#,   --  箲 (<CJK Ideograph>)
          10721 => 16#7BB3#,   --  箳 (<CJK Ideograph>)
          10722 => 16#7BB5#,   --  箵 (<CJK Ideograph>)
          10723 => 16#7BB6#,   --  箶 (<CJK Ideograph>)
          10724 => 16#7BB7#,   --  箷 (<CJK Ideograph>)
          10725 => 16#7BB9#,   --  箹 (<CJK Ideograph>)
          10726 => 16#7BBA#,   --  箺 (<CJK Ideograph>)
          10727 => 16#7BBB#,   --  箻 (<CJK Ideograph>)
          10728 => 16#7BBC#,   --  箼 (<CJK Ideograph>)
          10729 => 16#7BBD#,   --  箽 (<CJK Ideograph>)
          10730 => 16#7BBE#,   --  箾 (<CJK Ideograph>)
          10731 => 16#7BBF#,   --  箿 (<CJK Ideograph>)
          10732 => 16#7BC0#,   --  節 (<CJK Ideograph>)
          10733 => 16#7BC2#,   --  篂 (<CJK Ideograph>)
          10734 => 16#7BC3#,   --  篃 (<CJK Ideograph>)
          10735 => 16#7BC4#,   --  範 (<CJK Ideograph>)
          10736 => 16#57C2#,   --  埂 (<CJK Ideograph>)
          10737 => 16#803F#,   --  耿 (<CJK Ideograph>)
          10738 => 16#6897#,   --  梗 (<CJK Ideograph>)
          10739 => 16#5DE5#,   --  工 (<CJK Ideograph>)
          10740 => 16#653B#,   --  攻 (<CJK Ideograph>)
          10741 => 16#529F#,   --  功 (<CJK Ideograph>)
          10742 => 16#606D#,   --  恭 (<CJK Ideograph>)
          10743 => 16#9F9A#,   --  龚 (<CJK Ideograph>)
          10744 => 16#4F9B#,   --  供 (<CJK Ideograph>)
          10745 => 16#8EAC#,   --  躬 (<CJK Ideograph>)
          10746 => 16#516C#,   --  公 (<CJK Ideograph>)
          10747 => 16#5BAB#,   --  宫 (<CJK Ideograph>)
          10748 => 16#5F13#,   --  弓 (<CJK Ideograph>)
          10749 => 16#5DE9#,   --  巩 (<CJK Ideograph>)
          10750 => 16#6C5E#,   --  汞 (<CJK Ideograph>)
          10751 => 16#62F1#,   --  拱 (<CJK Ideograph>)
          10752 => 16#8D21#,   --  贡 (<CJK Ideograph>)
          10753 => 16#5171#,   --  共 (<CJK Ideograph>)
          10754 => 16#94A9#,   --  钩 (<CJK Ideograph>)
          10755 => 16#52FE#,   --  勾 (<CJK Ideograph>)
          10756 => 16#6C9F#,   --  沟 (<CJK Ideograph>)
          10757 => 16#82DF#,   --  苟 (<CJK Ideograph>)
          10758 => 16#72D7#,   --  狗 (<CJK Ideograph>)
          10759 => 16#57A2#,   --  垢 (<CJK Ideograph>)
          10760 => 16#6784#,   --  构 (<CJK Ideograph>)
          10761 => 16#8D2D#,   --  购 (<CJK Ideograph>)
          10762 => 16#591F#,   --  够 (<CJK Ideograph>)
          10763 => 16#8F9C#,   --  辜 (<CJK Ideograph>)
          10764 => 16#83C7#,   --  菇 (<CJK Ideograph>)
          10765 => 16#5495#,   --  咕 (<CJK Ideograph>)
          10766 => 16#7B8D#,   --  箍 (<CJK Ideograph>)
          10767 => 16#4F30#,   --  估 (<CJK Ideograph>)
          10768 => 16#6CBD#,   --  沽 (<CJK Ideograph>)
          10769 => 16#5B64#,   --  孤 (<CJK Ideograph>)
          10770 => 16#59D1#,   --  姑 (<CJK Ideograph>)
          10771 => 16#9F13#,   --  鼓 (<CJK Ideograph>)
          10772 => 16#53E4#,   --  古 (<CJK Ideograph>)
          10773 => 16#86CA#,   --  蛊 (<CJK Ideograph>)
          10774 => 16#9AA8#,   --  骨 (<CJK Ideograph>)
          10775 => 16#8C37#,   --  谷 (<CJK Ideograph>)
          10776 => 16#80A1#,   --  股 (<CJK Ideograph>)
          10777 => 16#6545#,   --  故 (<CJK Ideograph>)
          10778 => 16#987E#,   --  顾 (<CJK Ideograph>)
          10779 => 16#56FA#,   --  固 (<CJK Ideograph>)
          10780 => 16#96C7#,   --  雇 (<CJK Ideograph>)
          10781 => 16#522E#,   --  刮 (<CJK Ideograph>)
          10782 => 16#74DC#,   --  瓜 (<CJK Ideograph>)
          10783 => 16#5250#,   --  剐 (<CJK Ideograph>)
          10784 => 16#5BE1#,   --  寡 (<CJK Ideograph>)
          10785 => 16#6302#,   --  挂 (<CJK Ideograph>)
          10786 => 16#8902#,   --  褂 (<CJK Ideograph>)
          10787 => 16#4E56#,   --  乖 (<CJK Ideograph>)
          10788 => 16#62D0#,   --  拐 (<CJK Ideograph>)
          10789 => 16#602A#,   --  怪 (<CJK Ideograph>)
          10790 => 16#68FA#,   --  棺 (<CJK Ideograph>)
          10791 => 16#5173#,   --  关 (<CJK Ideograph>)
          10792 => 16#5B98#,   --  官 (<CJK Ideograph>)
          10793 => 16#51A0#,   --  冠 (<CJK Ideograph>)
          10794 => 16#89C2#,   --  观 (<CJK Ideograph>)
          10795 => 16#7BA1#,   --  管 (<CJK Ideograph>)
          10796 => 16#9986#,   --  馆 (<CJK Ideograph>)
          10797 => 16#7F50#,   --  罐 (<CJK Ideograph>)
          10798 => 16#60EF#,   --  惯 (<CJK Ideograph>)
          10799 => 16#704C#,   --  灌 (<CJK Ideograph>)
          10800 => 16#8D2F#,   --  贯 (<CJK Ideograph>)
          10801 => 16#5149#,   --  光 (<CJK Ideograph>)
          10802 => 16#5E7F#,   --  广 (<CJK Ideograph>)
          10803 => 16#901B#,   --  逛 (<CJK Ideograph>)
          10804 => 16#7470#,   --  瑰 (<CJK Ideograph>)
          10805 => 16#89C4#,   --  规 (<CJK Ideograph>)
          10806 => 16#572D#,   --  圭 (<CJK Ideograph>)
          10807 => 16#7845#,   --  硅 (<CJK Ideograph>)
          10808 => 16#5F52#,   --  归 (<CJK Ideograph>)
          10809 => 16#9F9F#,   --  龟 (<CJK Ideograph>)
          10810 => 16#95FA#,   --  闺 (<CJK Ideograph>)
          10811 => 16#8F68#,   --  轨 (<CJK Ideograph>)
          10812 => 16#9B3C#,   --  鬼 (<CJK Ideograph>)
          10813 => 16#8BE1#,   --  诡 (<CJK Ideograph>)
          10814 => 16#7678#,   --  癸 (<CJK Ideograph>)
          10815 => 16#6842#,   --  桂 (<CJK Ideograph>)
          10816 => 16#67DC#,   --  柜 (<CJK Ideograph>)
          10817 => 16#8DEA#,   --  跪 (<CJK Ideograph>)
          10818 => 16#8D35#,   --  贵 (<CJK Ideograph>)
          10819 => 16#523D#,   --  刽 (<CJK Ideograph>)
          10820 => 16#8F8A#,   --  辊 (<CJK Ideograph>)
          10821 => 16#6EDA#,   --  滚 (<CJK Ideograph>)
          10822 => 16#68CD#,   --  棍 (<CJK Ideograph>)
          10823 => 16#9505#,   --  锅 (<CJK Ideograph>)
          10824 => 16#90ED#,   --  郭 (<CJK Ideograph>)
          10825 => 16#56FD#,   --  国 (<CJK Ideograph>)
          10826 => 16#679C#,   --  果 (<CJK Ideograph>)
          10827 => 16#88F9#,   --  裹 (<CJK Ideograph>)
          10828 => 16#8FC7#,   --  过 (<CJK Ideograph>)
          10829 => 16#54C8#,   --  哈 (<CJK Ideograph>)
          10830 => 16#7BC5#,   --  篅 (<CJK Ideograph>)
          10831 => 16#7BC8#,   --  篈 (<CJK Ideograph>)
          10832 => 16#7BC9#,   --  築 (<CJK Ideograph>)
          10833 => 16#7BCA#,   --  篊 (<CJK Ideograph>)
          10834 => 16#7BCB#,   --  篋 (<CJK Ideograph>)
          10835 => 16#7BCD#,   --  篍 (<CJK Ideograph>)
          10836 => 16#7BCE#,   --  篎 (<CJK Ideograph>)
          10837 => 16#7BCF#,   --  篏 (<CJK Ideograph>)
          10838 => 16#7BD0#,   --  篐 (<CJK Ideograph>)
          10839 => 16#7BD2#,   --  篒 (<CJK Ideograph>)
          10840 => 16#7BD4#,   --  篔 (<CJK Ideograph>)
          10841 => 16#7BD5#,   --  篕 (<CJK Ideograph>)
          10842 => 16#7BD6#,   --  篖 (<CJK Ideograph>)
          10843 => 16#7BD7#,   --  篗 (<CJK Ideograph>)
          10844 => 16#7BD8#,   --  篘 (<CJK Ideograph>)
          10845 => 16#7BDB#,   --  篛 (<CJK Ideograph>)
          10846 => 16#7BDC#,   --  篜 (<CJK Ideograph>)
          10847 => 16#7BDE#,   --  篞 (<CJK Ideograph>)
          10848 => 16#7BDF#,   --  篟 (<CJK Ideograph>)
          10849 => 16#7BE0#,   --  篠 (<CJK Ideograph>)
          10850 => 16#7BE2#,   --  篢 (<CJK Ideograph>)
          10851 => 16#7BE3#,   --  篣 (<CJK Ideograph>)
          10852 => 16#7BE4#,   --  篤 (<CJK Ideograph>)
          10853 => 16#7BE7#,   --  篧 (<CJK Ideograph>)
          10854 => 16#7BE8#,   --  篨 (<CJK Ideograph>)
          10855 => 16#7BE9#,   --  篩 (<CJK Ideograph>)
          10856 => 16#7BEB#,   --  篫 (<CJK Ideograph>)
          10857 => 16#7BEC#,   --  篬 (<CJK Ideograph>)
          10858 => 16#7BED#,   --  篭 (<CJK Ideograph>)
          10859 => 16#7BEF#,   --  篯 (<CJK Ideograph>)
          10860 => 16#7BF0#,   --  篰 (<CJK Ideograph>)
          10861 => 16#7BF2#,   --  篲 (<CJK Ideograph>)
          10862 => 16#7BF3#,   --  篳 (<CJK Ideograph>)
          10863 => 16#7BF4#,   --  篴 (<CJK Ideograph>)
          10864 => 16#7BF5#,   --  篵 (<CJK Ideograph>)
          10865 => 16#7BF6#,   --  篶 (<CJK Ideograph>)
          10866 => 16#7BF8#,   --  篸 (<CJK Ideograph>)
          10867 => 16#7BF9#,   --  篹 (<CJK Ideograph>)
          10868 => 16#7BFA#,   --  篺 (<CJK Ideograph>)
          10869 => 16#7BFB#,   --  篻 (<CJK Ideograph>)
          10870 => 16#7BFD#,   --  篽 (<CJK Ideograph>)
          10871 => 16#7BFF#,   --  篿 (<CJK Ideograph>)
          10872 => 16#7C00#,   --  簀 (<CJK Ideograph>)
          10873 => 16#7C01#,   --  簁 (<CJK Ideograph>)
          10874 => 16#7C02#,   --  簂 (<CJK Ideograph>)
          10875 => 16#7C03#,   --  簃 (<CJK Ideograph>)
          10876 => 16#7C04#,   --  簄 (<CJK Ideograph>)
          10877 => 16#7C05#,   --  簅 (<CJK Ideograph>)
          10878 => 16#7C06#,   --  簆 (<CJK Ideograph>)
          10879 => 16#7C08#,   --  簈 (<CJK Ideograph>)
          10880 => 16#7C09#,   --  簉 (<CJK Ideograph>)
          10881 => 16#7C0A#,   --  簊 (<CJK Ideograph>)
          10882 => 16#7C0D#,   --  簍 (<CJK Ideograph>)
          10883 => 16#7C0E#,   --  簎 (<CJK Ideograph>)
          10884 => 16#7C10#,   --  簐 (<CJK Ideograph>)
          10885 => 16#7C11#,   --  簑 (<CJK Ideograph>)
          10886 => 16#7C12#,   --  簒 (<CJK Ideograph>)
          10887 => 16#7C13#,   --  簓 (<CJK Ideograph>)
          10888 => 16#7C14#,   --  簔 (<CJK Ideograph>)
          10889 => 16#7C15#,   --  簕 (<CJK Ideograph>)
          10890 => 16#7C17#,   --  簗 (<CJK Ideograph>)
          10891 => 16#7C18#,   --  簘 (<CJK Ideograph>)
          10892 => 16#7C19#,   --  簙 (<CJK Ideograph>)
          10893 => 16#7C1A#,   --  簚 (<CJK Ideograph>)
          10894 => 16#7C1B#,   --  簛 (<CJK Ideograph>)
          10895 => 16#7C1C#,   --  簜 (<CJK Ideograph>)
          10896 => 16#7C1D#,   --  簝 (<CJK Ideograph>)
          10897 => 16#7C1E#,   --  簞 (<CJK Ideograph>)
          10898 => 16#7C20#,   --  簠 (<CJK Ideograph>)
          10899 => 16#7C21#,   --  簡 (<CJK Ideograph>)
          10900 => 16#7C22#,   --  簢 (<CJK Ideograph>)
          10901 => 16#7C23#,   --  簣 (<CJK Ideograph>)
          10902 => 16#7C24#,   --  簤 (<CJK Ideograph>)
          10903 => 16#7C25#,   --  簥 (<CJK Ideograph>)
          10904 => 16#7C28#,   --  簨 (<CJK Ideograph>)
          10905 => 16#7C29#,   --  簩 (<CJK Ideograph>)
          10906 => 16#7C2B#,   --  簫 (<CJK Ideograph>)
          10907 => 16#7C2C#,   --  簬 (<CJK Ideograph>)
          10908 => 16#7C2D#,   --  簭 (<CJK Ideograph>)
          10909 => 16#7C2E#,   --  簮 (<CJK Ideograph>)
          10910 => 16#7C2F#,   --  簯 (<CJK Ideograph>)
          10911 => 16#7C30#,   --  簰 (<CJK Ideograph>)
          10912 => 16#7C31#,   --  簱 (<CJK Ideograph>)
          10913 => 16#7C32#,   --  簲 (<CJK Ideograph>)
          10914 => 16#7C33#,   --  簳 (<CJK Ideograph>)
          10915 => 16#7C34#,   --  簴 (<CJK Ideograph>)
          10916 => 16#7C35#,   --  簵 (<CJK Ideograph>)
          10917 => 16#7C36#,   --  簶 (<CJK Ideograph>)
          10918 => 16#7C37#,   --  簷 (<CJK Ideograph>)
          10919 => 16#7C39#,   --  簹 (<CJK Ideograph>)
          10920 => 16#7C3A#,   --  簺 (<CJK Ideograph>)
          10921 => 16#7C3B#,   --  簻 (<CJK Ideograph>)
          10922 => 16#7C3C#,   --  簼 (<CJK Ideograph>)
          10923 => 16#7C3D#,   --  簽 (<CJK Ideograph>)
          10924 => 16#7C3E#,   --  簾 (<CJK Ideograph>)
          10925 => 16#7C42#,   --  籂 (<CJK Ideograph>)
          10926 => 16#9AB8#,   --  骸 (<CJK Ideograph>)
          10927 => 16#5B69#,   --  孩 (<CJK Ideograph>)
          10928 => 16#6D77#,   --  海 (<CJK Ideograph>)
          10929 => 16#6C26#,   --  氦 (<CJK Ideograph>)
          10930 => 16#4EA5#,   --  亥 (<CJK Ideograph>)
          10931 => 16#5BB3#,   --  害 (<CJK Ideograph>)
          10932 => 16#9A87#,   --  骇 (<CJK Ideograph>)
          10933 => 16#9163#,   --  酣 (<CJK Ideograph>)
          10934 => 16#61A8#,   --  憨 (<CJK Ideograph>)
          10935 => 16#90AF#,   --  邯 (<CJK Ideograph>)
          10936 => 16#97E9#,   --  韩 (<CJK Ideograph>)
          10937 => 16#542B#,   --  含 (<CJK Ideograph>)
          10938 => 16#6DB5#,   --  涵 (<CJK Ideograph>)
          10939 => 16#5BD2#,   --  寒 (<CJK Ideograph>)
          10940 => 16#51FD#,   --  函 (<CJK Ideograph>)
          10941 => 16#558A#,   --  喊 (<CJK Ideograph>)
          10942 => 16#7F55#,   --  罕 (<CJK Ideograph>)
          10943 => 16#7FF0#,   --  翰 (<CJK Ideograph>)
          10944 => 16#64BC#,   --  撼 (<CJK Ideograph>)
          10945 => 16#634D#,   --  捍 (<CJK Ideograph>)
          10946 => 16#65F1#,   --  旱 (<CJK Ideograph>)
          10947 => 16#61BE#,   --  憾 (<CJK Ideograph>)
          10948 => 16#608D#,   --  悍 (<CJK Ideograph>)
          10949 => 16#710A#,   --  焊 (<CJK Ideograph>)
          10950 => 16#6C57#,   --  汗 (<CJK Ideograph>)
          10951 => 16#6C49#,   --  汉 (<CJK Ideograph>)
          10952 => 16#592F#,   --  夯 (<CJK Ideograph>)
          10953 => 16#676D#,   --  杭 (<CJK Ideograph>)
          10954 => 16#822A#,   --  航 (<CJK Ideograph>)
          10955 => 16#58D5#,   --  壕 (<CJK Ideograph>)
          10956 => 16#568E#,   --  嚎 (<CJK Ideograph>)
          10957 => 16#8C6A#,   --  豪 (<CJK Ideograph>)
          10958 => 16#6BEB#,   --  毫 (<CJK Ideograph>)
          10959 => 16#90DD#,   --  郝 (<CJK Ideograph>)
          10960 => 16#597D#,   --  好 (<CJK Ideograph>)
          10961 => 16#8017#,   --  耗 (<CJK Ideograph>)
          10962 => 16#53F7#,   --  号 (<CJK Ideograph>)
          10963 => 16#6D69#,   --  浩 (<CJK Ideograph>)
          10964 => 16#5475#,   --  呵 (<CJK Ideograph>)
          10965 => 16#559D#,   --  喝 (<CJK Ideograph>)
          10966 => 16#8377#,   --  荷 (<CJK Ideograph>)
          10967 => 16#83CF#,   --  菏 (<CJK Ideograph>)
          10968 => 16#6838#,   --  核 (<CJK Ideograph>)
          10969 => 16#79BE#,   --  禾 (<CJK Ideograph>)
          10970 => 16#548C#,   --  和 (<CJK Ideograph>)
          10971 => 16#4F55#,   --  何 (<CJK Ideograph>)
          10972 => 16#5408#,   --  合 (<CJK Ideograph>)
          10973 => 16#76D2#,   --  盒 (<CJK Ideograph>)
          10974 => 16#8C89#,   --  貉 (<CJK Ideograph>)
          10975 => 16#9602#,   --  阂 (<CJK Ideograph>)
          10976 => 16#6CB3#,   --  河 (<CJK Ideograph>)
          10977 => 16#6DB8#,   --  涸 (<CJK Ideograph>)
          10978 => 16#8D6B#,   --  赫 (<CJK Ideograph>)
          10979 => 16#8910#,   --  褐 (<CJK Ideograph>)
          10980 => 16#9E64#,   --  鹤 (<CJK Ideograph>)
          10981 => 16#8D3A#,   --  贺 (<CJK Ideograph>)
          10982 => 16#563F#,   --  嘿 (<CJK Ideograph>)
          10983 => 16#9ED1#,   --  黑 (<CJK Ideograph>)
          10984 => 16#75D5#,   --  痕 (<CJK Ideograph>)
          10985 => 16#5F88#,   --  很 (<CJK Ideograph>)
          10986 => 16#72E0#,   --  狠 (<CJK Ideograph>)
          10987 => 16#6068#,   --  恨 (<CJK Ideograph>)
          10988 => 16#54FC#,   --  哼 (<CJK Ideograph>)
          10989 => 16#4EA8#,   --  亨 (<CJK Ideograph>)
          10990 => 16#6A2A#,   --  横 (<CJK Ideograph>)
          10991 => 16#8861#,   --  衡 (<CJK Ideograph>)
          10992 => 16#6052#,   --  恒 (<CJK Ideograph>)
          10993 => 16#8F70#,   --  轰 (<CJK Ideograph>)
          10994 => 16#54C4#,   --  哄 (<CJK Ideograph>)
          10995 => 16#70D8#,   --  烘 (<CJK Ideograph>)
          10996 => 16#8679#,   --  虹 (<CJK Ideograph>)
          10997 => 16#9E3F#,   --  鸿 (<CJK Ideograph>)
          10998 => 16#6D2A#,   --  洪 (<CJK Ideograph>)
          10999 => 16#5B8F#,   --  宏 (<CJK Ideograph>)
          11000 => 16#5F18#,   --  弘 (<CJK Ideograph>)
          11001 => 16#7EA2#,   --  红 (<CJK Ideograph>)
          11002 => 16#5589#,   --  喉 (<CJK Ideograph>)
          11003 => 16#4FAF#,   --  侯 (<CJK Ideograph>)
          11004 => 16#7334#,   --  猴 (<CJK Ideograph>)
          11005 => 16#543C#,   --  吼 (<CJK Ideograph>)
          11006 => 16#539A#,   --  厚 (<CJK Ideograph>)
          11007 => 16#5019#,   --  候 (<CJK Ideograph>)
          11008 => 16#540E#,   --  后 (<CJK Ideograph>)
          11009 => 16#547C#,   --  呼 (<CJK Ideograph>)
          11010 => 16#4E4E#,   --  乎 (<CJK Ideograph>)
          11011 => 16#5FFD#,   --  忽 (<CJK Ideograph>)
          11012 => 16#745A#,   --  瑚 (<CJK Ideograph>)
          11013 => 16#58F6#,   --  壶 (<CJK Ideograph>)
          11014 => 16#846B#,   --  葫 (<CJK Ideograph>)
          11015 => 16#80E1#,   --  胡 (<CJK Ideograph>)
          11016 => 16#8774#,   --  蝴 (<CJK Ideograph>)
          11017 => 16#72D0#,   --  狐 (<CJK Ideograph>)
          11018 => 16#7CCA#,   --  糊 (<CJK Ideograph>)
          11019 => 16#6E56#,   --  湖 (<CJK Ideograph>)
          11020 => 16#7C43#,   --  籃 (<CJK Ideograph>)
          11021 => 16#7C44#,   --  籄 (<CJK Ideograph>)
          11022 => 16#7C45#,   --  籅 (<CJK Ideograph>)
          11023 => 16#7C46#,   --  籆 (<CJK Ideograph>)
          11024 => 16#7C47#,   --  籇 (<CJK Ideograph>)
          11025 => 16#7C48#,   --  籈 (<CJK Ideograph>)
          11026 => 16#7C49#,   --  籉 (<CJK Ideograph>)
          11027 => 16#7C4A#,   --  籊 (<CJK Ideograph>)
          11028 => 16#7C4B#,   --  籋 (<CJK Ideograph>)
          11029 => 16#7C4C#,   --  籌 (<CJK Ideograph>)
          11030 => 16#7C4E#,   --  籎 (<CJK Ideograph>)
          11031 => 16#7C4F#,   --  籏 (<CJK Ideograph>)
          11032 => 16#7C50#,   --  籐 (<CJK Ideograph>)
          11033 => 16#7C51#,   --  籑 (<CJK Ideograph>)
          11034 => 16#7C52#,   --  籒 (<CJK Ideograph>)
          11035 => 16#7C53#,   --  籓 (<CJK Ideograph>)
          11036 => 16#7C54#,   --  籔 (<CJK Ideograph>)
          11037 => 16#7C55#,   --  籕 (<CJK Ideograph>)
          11038 => 16#7C56#,   --  籖 (<CJK Ideograph>)
          11039 => 16#7C57#,   --  籗 (<CJK Ideograph>)
          11040 => 16#7C58#,   --  籘 (<CJK Ideograph>)
          11041 => 16#7C59#,   --  籙 (<CJK Ideograph>)
          11042 => 16#7C5A#,   --  籚 (<CJK Ideograph>)
          11043 => 16#7C5B#,   --  籛 (<CJK Ideograph>)
          11044 => 16#7C5C#,   --  籜 (<CJK Ideograph>)
          11045 => 16#7C5D#,   --  籝 (<CJK Ideograph>)
          11046 => 16#7C5E#,   --  籞 (<CJK Ideograph>)
          11047 => 16#7C5F#,   --  籟 (<CJK Ideograph>)
          11048 => 16#7C60#,   --  籠 (<CJK Ideograph>)
          11049 => 16#7C61#,   --  籡 (<CJK Ideograph>)
          11050 => 16#7C62#,   --  籢 (<CJK Ideograph>)
          11051 => 16#7C63#,   --  籣 (<CJK Ideograph>)
          11052 => 16#7C64#,   --  籤 (<CJK Ideograph>)
          11053 => 16#7C65#,   --  籥 (<CJK Ideograph>)
          11054 => 16#7C66#,   --  籦 (<CJK Ideograph>)
          11055 => 16#7C67#,   --  籧 (<CJK Ideograph>)
          11056 => 16#7C68#,   --  籨 (<CJK Ideograph>)
          11057 => 16#7C69#,   --  籩 (<CJK Ideograph>)
          11058 => 16#7C6A#,   --  籪 (<CJK Ideograph>)
          11059 => 16#7C6B#,   --  籫 (<CJK Ideograph>)
          11060 => 16#7C6C#,   --  籬 (<CJK Ideograph>)
          11061 => 16#7C6D#,   --  籭 (<CJK Ideograph>)
          11062 => 16#7C6E#,   --  籮 (<CJK Ideograph>)
          11063 => 16#7C6F#,   --  籯 (<CJK Ideograph>)
          11064 => 16#7C70#,   --  籰 (<CJK Ideograph>)
          11065 => 16#7C71#,   --  籱 (<CJK Ideograph>)
          11066 => 16#7C72#,   --  籲 (<CJK Ideograph>)
          11067 => 16#7C75#,   --  籵 (<CJK Ideograph>)
          11068 => 16#7C76#,   --  籶 (<CJK Ideograph>)
          11069 => 16#7C77#,   --  籷 (<CJK Ideograph>)
          11070 => 16#7C78#,   --  籸 (<CJK Ideograph>)
          11071 => 16#7C79#,   --  籹 (<CJK Ideograph>)
          11072 => 16#7C7A#,   --  籺 (<CJK Ideograph>)
          11073 => 16#7C7E#,   --  籾 (<CJK Ideograph>)
          11074 => 16#7C7F#,   --  籿 (<CJK Ideograph>)
          11075 => 16#7C80#,   --  粀 (<CJK Ideograph>)
          11076 => 16#7C81#,   --  粁 (<CJK Ideograph>)
          11077 => 16#7C82#,   --  粂 (<CJK Ideograph>)
          11078 => 16#7C83#,   --  粃 (<CJK Ideograph>)
          11079 => 16#7C84#,   --  粄 (<CJK Ideograph>)
          11080 => 16#7C85#,   --  粅 (<CJK Ideograph>)
          11081 => 16#7C86#,   --  粆 (<CJK Ideograph>)
          11082 => 16#7C87#,   --  粇 (<CJK Ideograph>)
          11083 => 16#7C88#,   --  粈 (<CJK Ideograph>)
          11084 => 16#7C8A#,   --  粊 (<CJK Ideograph>)
          11085 => 16#7C8B#,   --  粋 (<CJK Ideograph>)
          11086 => 16#7C8C#,   --  粌 (<CJK Ideograph>)
          11087 => 16#7C8D#,   --  粍 (<CJK Ideograph>)
          11088 => 16#7C8E#,   --  粎 (<CJK Ideograph>)
          11089 => 16#7C8F#,   --  粏 (<CJK Ideograph>)
          11090 => 16#7C90#,   --  粐 (<CJK Ideograph>)
          11091 => 16#7C93#,   --  粓 (<CJK Ideograph>)
          11092 => 16#7C94#,   --  粔 (<CJK Ideograph>)
          11093 => 16#7C96#,   --  粖 (<CJK Ideograph>)
          11094 => 16#7C99#,   --  粙 (<CJK Ideograph>)
          11095 => 16#7C9A#,   --  粚 (<CJK Ideograph>)
          11096 => 16#7C9B#,   --  粛 (<CJK Ideograph>)
          11097 => 16#7CA0#,   --  粠 (<CJK Ideograph>)
          11098 => 16#7CA1#,   --  粡 (<CJK Ideograph>)
          11099 => 16#7CA3#,   --  粣 (<CJK Ideograph>)
          11100 => 16#7CA6#,   --  粦 (<CJK Ideograph>)
          11101 => 16#7CA7#,   --  粧 (<CJK Ideograph>)
          11102 => 16#7CA8#,   --  粨 (<CJK Ideograph>)
          11103 => 16#7CA9#,   --  粩 (<CJK Ideograph>)
          11104 => 16#7CAB#,   --  粫 (<CJK Ideograph>)
          11105 => 16#7CAC#,   --  粬 (<CJK Ideograph>)
          11106 => 16#7CAD#,   --  粭 (<CJK Ideograph>)
          11107 => 16#7CAF#,   --  粯 (<CJK Ideograph>)
          11108 => 16#7CB0#,   --  粰 (<CJK Ideograph>)
          11109 => 16#7CB4#,   --  粴 (<CJK Ideograph>)
          11110 => 16#7CB5#,   --  粵 (<CJK Ideograph>)
          11111 => 16#7CB6#,   --  粶 (<CJK Ideograph>)
          11112 => 16#7CB7#,   --  粷 (<CJK Ideograph>)
          11113 => 16#7CB8#,   --  粸 (<CJK Ideograph>)
          11114 => 16#7CBA#,   --  粺 (<CJK Ideograph>)
          11115 => 16#7CBB#,   --  粻 (<CJK Ideograph>)
          11116 => 16#5F27#,   --  弧 (<CJK Ideograph>)
          11117 => 16#864E#,   --  虎 (<CJK Ideograph>)
          11118 => 16#552C#,   --  唬 (<CJK Ideograph>)
          11119 => 16#62A4#,   --  护 (<CJK Ideograph>)
          11120 => 16#4E92#,   --  互 (<CJK Ideograph>)
          11121 => 16#6CAA#,   --  沪 (<CJK Ideograph>)
          11122 => 16#6237#,   --  户 (<CJK Ideograph>)
          11123 => 16#82B1#,   --  花 (<CJK Ideograph>)
          11124 => 16#54D7#,   --  哗 (<CJK Ideograph>)
          11125 => 16#534E#,   --  华 (<CJK Ideograph>)
          11126 => 16#733E#,   --  猾 (<CJK Ideograph>)
          11127 => 16#6ED1#,   --  滑 (<CJK Ideograph>)
          11128 => 16#753B#,   --  画 (<CJK Ideograph>)
          11129 => 16#5212#,   --  划 (<CJK Ideograph>)
          11130 => 16#5316#,   --  化 (<CJK Ideograph>)
          11131 => 16#8BDD#,   --  话 (<CJK Ideograph>)
          11132 => 16#69D0#,   --  槐 (<CJK Ideograph>)
          11133 => 16#5F8A#,   --  徊 (<CJK Ideograph>)
          11134 => 16#6000#,   --  怀 (<CJK Ideograph>)
          11135 => 16#6DEE#,   --  淮 (<CJK Ideograph>)
          11136 => 16#574F#,   --  坏 (<CJK Ideograph>)
          11137 => 16#6B22#,   --  欢 (<CJK Ideograph>)
          11138 => 16#73AF#,   --  环 (<CJK Ideograph>)
          11139 => 16#6853#,   --  桓 (<CJK Ideograph>)
          11140 => 16#8FD8#,   --  还 (<CJK Ideograph>)
          11141 => 16#7F13#,   --  缓 (<CJK Ideograph>)
          11142 => 16#6362#,   --  换 (<CJK Ideograph>)
          11143 => 16#60A3#,   --  患 (<CJK Ideograph>)
          11144 => 16#5524#,   --  唤 (<CJK Ideograph>)
          11145 => 16#75EA#,   --  痪 (<CJK Ideograph>)
          11146 => 16#8C62#,   --  豢 (<CJK Ideograph>)
          11147 => 16#7115#,   --  焕 (<CJK Ideograph>)
          11148 => 16#6DA3#,   --  涣 (<CJK Ideograph>)
          11149 => 16#5BA6#,   --  宦 (<CJK Ideograph>)
          11150 => 16#5E7B#,   --  幻 (<CJK Ideograph>)
          11151 => 16#8352#,   --  荒 (<CJK Ideograph>)
          11152 => 16#614C#,   --  慌 (<CJK Ideograph>)
          11153 => 16#9EC4#,   --  黄 (<CJK Ideograph>)
          11154 => 16#78FA#,   --  磺 (<CJK Ideograph>)
          11155 => 16#8757#,   --  蝗 (<CJK Ideograph>)
          11156 => 16#7C27#,   --  簧 (<CJK Ideograph>)
          11157 => 16#7687#,   --  皇 (<CJK Ideograph>)
          11158 => 16#51F0#,   --  凰 (<CJK Ideograph>)
          11159 => 16#60F6#,   --  惶 (<CJK Ideograph>)
          11160 => 16#714C#,   --  煌 (<CJK Ideograph>)
          11161 => 16#6643#,   --  晃 (<CJK Ideograph>)
          11162 => 16#5E4C#,   --  幌 (<CJK Ideograph>)
          11163 => 16#604D#,   --  恍 (<CJK Ideograph>)
          11164 => 16#8C0E#,   --  谎 (<CJK Ideograph>)
          11165 => 16#7070#,   --  灰 (<CJK Ideograph>)
          11166 => 16#6325#,   --  挥 (<CJK Ideograph>)
          11167 => 16#8F89#,   --  辉 (<CJK Ideograph>)
          11168 => 16#5FBD#,   --  徽 (<CJK Ideograph>)
          11169 => 16#6062#,   --  恢 (<CJK Ideograph>)
          11170 => 16#86D4#,   --  蛔 (<CJK Ideograph>)
          11171 => 16#56DE#,   --  回 (<CJK Ideograph>)
          11172 => 16#6BC1#,   --  毁 (<CJK Ideograph>)
          11173 => 16#6094#,   --  悔 (<CJK Ideograph>)
          11174 => 16#6167#,   --  慧 (<CJK Ideograph>)
          11175 => 16#5349#,   --  卉 (<CJK Ideograph>)
          11176 => 16#60E0#,   --  惠 (<CJK Ideograph>)
          11177 => 16#6666#,   --  晦 (<CJK Ideograph>)
          11178 => 16#8D3F#,   --  贿 (<CJK Ideograph>)
          11179 => 16#79FD#,   --  秽 (<CJK Ideograph>)
          11180 => 16#4F1A#,   --  会 (<CJK Ideograph>)
          11181 => 16#70E9#,   --  烩 (<CJK Ideograph>)
          11182 => 16#6C47#,   --  汇 (<CJK Ideograph>)
          11183 => 16#8BB3#,   --  讳 (<CJK Ideograph>)
          11184 => 16#8BF2#,   --  诲 (<CJK Ideograph>)
          11185 => 16#7ED8#,   --  绘 (<CJK Ideograph>)
          11186 => 16#8364#,   --  荤 (<CJK Ideograph>)
          11187 => 16#660F#,   --  昏 (<CJK Ideograph>)
          11188 => 16#5A5A#,   --  婚 (<CJK Ideograph>)
          11189 => 16#9B42#,   --  魂 (<CJK Ideograph>)
          11190 => 16#6D51#,   --  浑 (<CJK Ideograph>)
          11191 => 16#6DF7#,   --  混 (<CJK Ideograph>)
          11192 => 16#8C41#,   --  豁 (<CJK Ideograph>)
          11193 => 16#6D3B#,   --  活 (<CJK Ideograph>)
          11194 => 16#4F19#,   --  伙 (<CJK Ideograph>)
          11195 => 16#706B#,   --  火 (<CJK Ideograph>)
          11196 => 16#83B7#,   --  获 (<CJK Ideograph>)
          11197 => 16#6216#,   --  或 (<CJK Ideograph>)
          11198 => 16#60D1#,   --  惑 (<CJK Ideograph>)
          11199 => 16#970D#,   --  霍 (<CJK Ideograph>)
          11200 => 16#8D27#,   --  货 (<CJK Ideograph>)
          11201 => 16#7978#,   --  祸 (<CJK Ideograph>)
          11202 => 16#51FB#,   --  击 (<CJK Ideograph>)
          11203 => 16#573E#,   --  圾 (<CJK Ideograph>)
          11204 => 16#57FA#,   --  基 (<CJK Ideograph>)
          11205 => 16#673A#,   --  机 (<CJK Ideograph>)
          11206 => 16#7578#,   --  畸 (<CJK Ideograph>)
          11207 => 16#7A3D#,   --  稽 (<CJK Ideograph>)
          11208 => 16#79EF#,   --  积 (<CJK Ideograph>)
          11209 => 16#7B95#,   --  箕 (<CJK Ideograph>)
          11210 => 16#7CBF#,   --  粿 (<CJK Ideograph>)
          11211 => 16#7CC0#,   --  糀 (<CJK Ideograph>)
          11212 => 16#7CC2#,   --  糂 (<CJK Ideograph>)
          11213 => 16#7CC3#,   --  糃 (<CJK Ideograph>)
          11214 => 16#7CC4#,   --  糄 (<CJK Ideograph>)
          11215 => 16#7CC6#,   --  糆 (<CJK Ideograph>)
          11216 => 16#7CC9#,   --  糉 (<CJK Ideograph>)
          11217 => 16#7CCB#,   --  糋 (<CJK Ideograph>)
          11218 => 16#7CCE#,   --  糎 (<CJK Ideograph>)
          11219 => 16#7CCF#,   --  糏 (<CJK Ideograph>)
          11220 => 16#7CD0#,   --  糐 (<CJK Ideograph>)
          11221 => 16#7CD1#,   --  糑 (<CJK Ideograph>)
          11222 => 16#7CD2#,   --  糒 (<CJK Ideograph>)
          11223 => 16#7CD3#,   --  糓 (<CJK Ideograph>)
          11224 => 16#7CD4#,   --  糔 (<CJK Ideograph>)
          11225 => 16#7CD8#,   --  糘 (<CJK Ideograph>)
          11226 => 16#7CDA#,   --  糚 (<CJK Ideograph>)
          11227 => 16#7CDB#,   --  糛 (<CJK Ideograph>)
          11228 => 16#7CDD#,   --  糝 (<CJK Ideograph>)
          11229 => 16#7CDE#,   --  糞 (<CJK Ideograph>)
          11230 => 16#7CE1#,   --  糡 (<CJK Ideograph>)
          11231 => 16#7CE2#,   --  糢 (<CJK Ideograph>)
          11232 => 16#7CE3#,   --  糣 (<CJK Ideograph>)
          11233 => 16#7CE4#,   --  糤 (<CJK Ideograph>)
          11234 => 16#7CE5#,   --  糥 (<CJK Ideograph>)
          11235 => 16#7CE6#,   --  糦 (<CJK Ideograph>)
          11236 => 16#7CE7#,   --  糧 (<CJK Ideograph>)
          11237 => 16#7CE9#,   --  糩 (<CJK Ideograph>)
          11238 => 16#7CEA#,   --  糪 (<CJK Ideograph>)
          11239 => 16#7CEB#,   --  糫 (<CJK Ideograph>)
          11240 => 16#7CEC#,   --  糬 (<CJK Ideograph>)
          11241 => 16#7CED#,   --  糭 (<CJK Ideograph>)
          11242 => 16#7CEE#,   --  糮 (<CJK Ideograph>)
          11243 => 16#7CF0#,   --  糰 (<CJK Ideograph>)
          11244 => 16#7CF1#,   --  糱 (<CJK Ideograph>)
          11245 => 16#7CF2#,   --  糲 (<CJK Ideograph>)
          11246 => 16#7CF3#,   --  糳 (<CJK Ideograph>)
          11247 => 16#7CF4#,   --  糴 (<CJK Ideograph>)
          11248 => 16#7CF5#,   --  糵 (<CJK Ideograph>)
          11249 => 16#7CF6#,   --  糶 (<CJK Ideograph>)
          11250 => 16#7CF7#,   --  糷 (<CJK Ideograph>)
          11251 => 16#7CF9#,   --  糹 (<CJK Ideograph>)
          11252 => 16#7CFA#,   --  糺 (<CJK Ideograph>)
          11253 => 16#7CFC#,   --  糼 (<CJK Ideograph>)
          11254 => 16#7CFD#,   --  糽 (<CJK Ideograph>)
          11255 => 16#7CFE#,   --  糾 (<CJK Ideograph>)
          11256 => 16#7CFF#,   --  糿 (<CJK Ideograph>)
          11257 => 16#7D00#,   --  紀 (<CJK Ideograph>)
          11258 => 16#7D01#,   --  紁 (<CJK Ideograph>)
          11259 => 16#7D02#,   --  紂 (<CJK Ideograph>)
          11260 => 16#7D03#,   --  紃 (<CJK Ideograph>)
          11261 => 16#7D04#,   --  約 (<CJK Ideograph>)
          11262 => 16#7D05#,   --  紅 (<CJK Ideograph>)
          11263 => 16#7D06#,   --  紆 (<CJK Ideograph>)
          11264 => 16#7D07#,   --  紇 (<CJK Ideograph>)
          11265 => 16#7D08#,   --  紈 (<CJK Ideograph>)
          11266 => 16#7D09#,   --  紉 (<CJK Ideograph>)
          11267 => 16#7D0B#,   --  紋 (<CJK Ideograph>)
          11268 => 16#7D0C#,   --  紌 (<CJK Ideograph>)
          11269 => 16#7D0D#,   --  納 (<CJK Ideograph>)
          11270 => 16#7D0E#,   --  紎 (<CJK Ideograph>)
          11271 => 16#7D0F#,   --  紏 (<CJK Ideograph>)
          11272 => 16#7D10#,   --  紐 (<CJK Ideograph>)
          11273 => 16#7D11#,   --  紑 (<CJK Ideograph>)
          11274 => 16#7D12#,   --  紒 (<CJK Ideograph>)
          11275 => 16#7D13#,   --  紓 (<CJK Ideograph>)
          11276 => 16#7D14#,   --  純 (<CJK Ideograph>)
          11277 => 16#7D15#,   --  紕 (<CJK Ideograph>)
          11278 => 16#7D16#,   --  紖 (<CJK Ideograph>)
          11279 => 16#7D17#,   --  紗 (<CJK Ideograph>)
          11280 => 16#7D18#,   --  紘 (<CJK Ideograph>)
          11281 => 16#7D19#,   --  紙 (<CJK Ideograph>)
          11282 => 16#7D1A#,   --  級 (<CJK Ideograph>)
          11283 => 16#7D1B#,   --  紛 (<CJK Ideograph>)
          11284 => 16#7D1C#,   --  紜 (<CJK Ideograph>)
          11285 => 16#7D1D#,   --  紝 (<CJK Ideograph>)
          11286 => 16#7D1E#,   --  紞 (<CJK Ideograph>)
          11287 => 16#7D1F#,   --  紟 (<CJK Ideograph>)
          11288 => 16#7D21#,   --  紡 (<CJK Ideograph>)
          11289 => 16#7D23#,   --  紣 (<CJK Ideograph>)
          11290 => 16#7D24#,   --  紤 (<CJK Ideograph>)
          11291 => 16#7D25#,   --  紥 (<CJK Ideograph>)
          11292 => 16#7D26#,   --  紦 (<CJK Ideograph>)
          11293 => 16#7D28#,   --  紨 (<CJK Ideograph>)
          11294 => 16#7D29#,   --  紩 (<CJK Ideograph>)
          11295 => 16#7D2A#,   --  紪 (<CJK Ideograph>)
          11296 => 16#7D2C#,   --  紬 (<CJK Ideograph>)
          11297 => 16#7D2D#,   --  紭 (<CJK Ideograph>)
          11298 => 16#7D2E#,   --  紮 (<CJK Ideograph>)
          11299 => 16#7D30#,   --  細 (<CJK Ideograph>)
          11300 => 16#7D31#,   --  紱 (<CJK Ideograph>)
          11301 => 16#7D32#,   --  紲 (<CJK Ideograph>)
          11302 => 16#7D33#,   --  紳 (<CJK Ideograph>)
          11303 => 16#7D34#,   --  紴 (<CJK Ideograph>)
          11304 => 16#7D35#,   --  紵 (<CJK Ideograph>)
          11305 => 16#7D36#,   --  紶 (<CJK Ideograph>)
          11306 => 16#808C#,   --  肌 (<CJK Ideograph>)
          11307 => 16#9965#,   --  饥 (<CJK Ideograph>)
          11308 => 16#8FF9#,   --  迹 (<CJK Ideograph>)
          11309 => 16#6FC0#,   --  激 (<CJK Ideograph>)
          11310 => 16#8BA5#,   --  讥 (<CJK Ideograph>)
          11311 => 16#9E21#,   --  鸡 (<CJK Ideograph>)
          11312 => 16#59EC#,   --  姬 (<CJK Ideograph>)
          11313 => 16#7EE9#,   --  绩 (<CJK Ideograph>)
          11314 => 16#7F09#,   --  缉 (<CJK Ideograph>)
          11315 => 16#5409#,   --  吉 (<CJK Ideograph>)
          11316 => 16#6781#,   --  极 (<CJK Ideograph>)
          11317 => 16#68D8#,   --  棘 (<CJK Ideograph>)
          11318 => 16#8F91#,   --  辑 (<CJK Ideograph>)
          11319 => 16#7C4D#,   --  籍 (<CJK Ideograph>)
          11320 => 16#96C6#,   --  集 (<CJK Ideograph>)
          11321 => 16#53CA#,   --  及 (<CJK Ideograph>)
          11322 => 16#6025#,   --  急 (<CJK Ideograph>)
          11323 => 16#75BE#,   --  疾 (<CJK Ideograph>)
          11324 => 16#6C72#,   --  汲 (<CJK Ideograph>)
          11325 => 16#5373#,   --  即 (<CJK Ideograph>)
          11326 => 16#5AC9#,   --  嫉 (<CJK Ideograph>)
          11327 => 16#7EA7#,   --  级 (<CJK Ideograph>)
          11328 => 16#6324#,   --  挤 (<CJK Ideograph>)
          11329 => 16#51E0#,   --  几 (<CJK Ideograph>)
          11330 => 16#810A#,   --  脊 (<CJK Ideograph>)
          11331 => 16#5DF1#,   --  己 (<CJK Ideograph>)
          11332 => 16#84DF#,   --  蓟 (<CJK Ideograph>)
          11333 => 16#6280#,   --  技 (<CJK Ideograph>)
          11334 => 16#5180#,   --  冀 (<CJK Ideograph>)
          11335 => 16#5B63#,   --  季 (<CJK Ideograph>)
          11336 => 16#4F0E#,   --  伎 (<CJK Ideograph>)
          11337 => 16#796D#,   --  祭 (<CJK Ideograph>)
          11338 => 16#5242#,   --  剂 (<CJK Ideograph>)
          11339 => 16#60B8#,   --  悸 (<CJK Ideograph>)
          11340 => 16#6D4E#,   --  济 (<CJK Ideograph>)
          11341 => 16#5BC4#,   --  寄 (<CJK Ideograph>)
          11342 => 16#5BC2#,   --  寂 (<CJK Ideograph>)
          11343 => 16#8BA1#,   --  计 (<CJK Ideograph>)
          11344 => 16#8BB0#,   --  记 (<CJK Ideograph>)
          11345 => 16#65E2#,   --  既 (<CJK Ideograph>)
          11346 => 16#5FCC#,   --  忌 (<CJK Ideograph>)
          11347 => 16#9645#,   --  际 (<CJK Ideograph>)
          11348 => 16#5993#,   --  妓 (<CJK Ideograph>)
          11349 => 16#7EE7#,   --  继 (<CJK Ideograph>)
          11350 => 16#7EAA#,   --  纪 (<CJK Ideograph>)
          11351 => 16#5609#,   --  嘉 (<CJK Ideograph>)
          11352 => 16#67B7#,   --  枷 (<CJK Ideograph>)
          11353 => 16#5939#,   --  夹 (<CJK Ideograph>)
          11354 => 16#4F73#,   --  佳 (<CJK Ideograph>)
          11355 => 16#5BB6#,   --  家 (<CJK Ideograph>)
          11356 => 16#52A0#,   --  加 (<CJK Ideograph>)
          11357 => 16#835A#,   --  荚 (<CJK Ideograph>)
          11358 => 16#988A#,   --  颊 (<CJK Ideograph>)
          11359 => 16#8D3E#,   --  贾 (<CJK Ideograph>)
          11360 => 16#7532#,   --  甲 (<CJK Ideograph>)
          11361 => 16#94BE#,   --  钾 (<CJK Ideograph>)
          11362 => 16#5047#,   --  假 (<CJK Ideograph>)
          11363 => 16#7A3C#,   --  稼 (<CJK Ideograph>)
          11364 => 16#4EF7#,   --  价 (<CJK Ideograph>)
          11365 => 16#67B6#,   --  架 (<CJK Ideograph>)
          11366 => 16#9A7E#,   --  驾 (<CJK Ideograph>)
          11367 => 16#5AC1#,   --  嫁 (<CJK Ideograph>)
          11368 => 16#6B7C#,   --  歼 (<CJK Ideograph>)
          11369 => 16#76D1#,   --  监 (<CJK Ideograph>)
          11370 => 16#575A#,   --  坚 (<CJK Ideograph>)
          11371 => 16#5C16#,   --  尖 (<CJK Ideograph>)
          11372 => 16#7B3A#,   --  笺 (<CJK Ideograph>)
          11373 => 16#95F4#,   --  间 (<CJK Ideograph>)
          11374 => 16#714E#,   --  煎 (<CJK Ideograph>)
          11375 => 16#517C#,   --  兼 (<CJK Ideograph>)
          11376 => 16#80A9#,   --  肩 (<CJK Ideograph>)
          11377 => 16#8270#,   --  艰 (<CJK Ideograph>)
          11378 => 16#5978#,   --  奸 (<CJK Ideograph>)
          11379 => 16#7F04#,   --  缄 (<CJK Ideograph>)
          11380 => 16#8327#,   --  茧 (<CJK Ideograph>)
          11381 => 16#68C0#,   --  检 (<CJK Ideograph>)
          11382 => 16#67EC#,   --  柬 (<CJK Ideograph>)
          11383 => 16#78B1#,   --  碱 (<CJK Ideograph>)
          11384 => 16#7877#,   --  硷 (<CJK Ideograph>)
          11385 => 16#62E3#,   --  拣 (<CJK Ideograph>)
          11386 => 16#6361#,   --  捡 (<CJK Ideograph>)
          11387 => 16#7B80#,   --  简 (<CJK Ideograph>)
          11388 => 16#4FED#,   --  俭 (<CJK Ideograph>)
          11389 => 16#526A#,   --  剪 (<CJK Ideograph>)
          11390 => 16#51CF#,   --  减 (<CJK Ideograph>)
          11391 => 16#8350#,   --  荐 (<CJK Ideograph>)
          11392 => 16#69DB#,   --  槛 (<CJK Ideograph>)
          11393 => 16#9274#,   --  鉴 (<CJK Ideograph>)
          11394 => 16#8DF5#,   --  践 (<CJK Ideograph>)
          11395 => 16#8D31#,   --  贱 (<CJK Ideograph>)
          11396 => 16#89C1#,   --  见 (<CJK Ideograph>)
          11397 => 16#952E#,   --  键 (<CJK Ideograph>)
          11398 => 16#7BAD#,   --  箭 (<CJK Ideograph>)
          11399 => 16#4EF6#,   --  件 (<CJK Ideograph>)
          11400 => 16#7D37#,   --  紷 (<CJK Ideograph>)
          11401 => 16#7D38#,   --  紸 (<CJK Ideograph>)
          11402 => 16#7D39#,   --  紹 (<CJK Ideograph>)
          11403 => 16#7D3A#,   --  紺 (<CJK Ideograph>)
          11404 => 16#7D3B#,   --  紻 (<CJK Ideograph>)
          11405 => 16#7D3C#,   --  紼 (<CJK Ideograph>)
          11406 => 16#7D3D#,   --  紽 (<CJK Ideograph>)
          11407 => 16#7D3E#,   --  紾 (<CJK Ideograph>)
          11408 => 16#7D3F#,   --  紿 (<CJK Ideograph>)
          11409 => 16#7D40#,   --  絀 (<CJK Ideograph>)
          11410 => 16#7D41#,   --  絁 (<CJK Ideograph>)
          11411 => 16#7D42#,   --  終 (<CJK Ideograph>)
          11412 => 16#7D43#,   --  絃 (<CJK Ideograph>)
          11413 => 16#7D44#,   --  組 (<CJK Ideograph>)
          11414 => 16#7D45#,   --  絅 (<CJK Ideograph>)
          11415 => 16#7D46#,   --  絆 (<CJK Ideograph>)
          11416 => 16#7D47#,   --  絇 (<CJK Ideograph>)
          11417 => 16#7D48#,   --  絈 (<CJK Ideograph>)
          11418 => 16#7D49#,   --  絉 (<CJK Ideograph>)
          11419 => 16#7D4A#,   --  絊 (<CJK Ideograph>)
          11420 => 16#7D4B#,   --  絋 (<CJK Ideograph>)
          11421 => 16#7D4C#,   --  経 (<CJK Ideograph>)
          11422 => 16#7D4D#,   --  絍 (<CJK Ideograph>)
          11423 => 16#7D4E#,   --  絎 (<CJK Ideograph>)
          11424 => 16#7D4F#,   --  絏 (<CJK Ideograph>)
          11425 => 16#7D50#,   --  結 (<CJK Ideograph>)
          11426 => 16#7D51#,   --  絑 (<CJK Ideograph>)
          11427 => 16#7D52#,   --  絒 (<CJK Ideograph>)
          11428 => 16#7D53#,   --  絓 (<CJK Ideograph>)
          11429 => 16#7D54#,   --  絔 (<CJK Ideograph>)
          11430 => 16#7D55#,   --  絕 (<CJK Ideograph>)
          11431 => 16#7D56#,   --  絖 (<CJK Ideograph>)
          11432 => 16#7D57#,   --  絗 (<CJK Ideograph>)
          11433 => 16#7D58#,   --  絘 (<CJK Ideograph>)
          11434 => 16#7D59#,   --  絙 (<CJK Ideograph>)
          11435 => 16#7D5A#,   --  絚 (<CJK Ideograph>)
          11436 => 16#7D5B#,   --  絛 (<CJK Ideograph>)
          11437 => 16#7D5C#,   --  絜 (<CJK Ideograph>)
          11438 => 16#7D5D#,   --  絝 (<CJK Ideograph>)
          11439 => 16#7D5E#,   --  絞 (<CJK Ideograph>)
          11440 => 16#7D5F#,   --  絟 (<CJK Ideograph>)
          11441 => 16#7D60#,   --  絠 (<CJK Ideograph>)
          11442 => 16#7D61#,   --  絡 (<CJK Ideograph>)
          11443 => 16#7D62#,   --  絢 (<CJK Ideograph>)
          11444 => 16#7D63#,   --  絣 (<CJK Ideograph>)
          11445 => 16#7D64#,   --  絤 (<CJK Ideograph>)
          11446 => 16#7D65#,   --  絥 (<CJK Ideograph>)
          11447 => 16#7D66#,   --  給 (<CJK Ideograph>)
          11448 => 16#7D67#,   --  絧 (<CJK Ideograph>)
          11449 => 16#7D68#,   --  絨 (<CJK Ideograph>)
          11450 => 16#7D69#,   --  絩 (<CJK Ideograph>)
          11451 => 16#7D6A#,   --  絪 (<CJK Ideograph>)
          11452 => 16#7D6B#,   --  絫 (<CJK Ideograph>)
          11453 => 16#7D6C#,   --  絬 (<CJK Ideograph>)
          11454 => 16#7D6D#,   --  絭 (<CJK Ideograph>)
          11455 => 16#7D6F#,   --  絯 (<CJK Ideograph>)
          11456 => 16#7D70#,   --  絰 (<CJK Ideograph>)
          11457 => 16#7D71#,   --  統 (<CJK Ideograph>)
          11458 => 16#7D72#,   --  絲 (<CJK Ideograph>)
          11459 => 16#7D73#,   --  絳 (<CJK Ideograph>)
          11460 => 16#7D74#,   --  絴 (<CJK Ideograph>)
          11461 => 16#7D75#,   --  絵 (<CJK Ideograph>)
          11462 => 16#7D76#,   --  絶 (<CJK Ideograph>)
          11463 => 16#7D78#,   --  絸 (<CJK Ideograph>)
          11464 => 16#7D79#,   --  絹 (<CJK Ideograph>)
          11465 => 16#7D7A#,   --  絺 (<CJK Ideograph>)
          11466 => 16#7D7B#,   --  絻 (<CJK Ideograph>)
          11467 => 16#7D7C#,   --  絼 (<CJK Ideograph>)
          11468 => 16#7D7D#,   --  絽 (<CJK Ideograph>)
          11469 => 16#7D7E#,   --  絾 (<CJK Ideograph>)
          11470 => 16#7D7F#,   --  絿 (<CJK Ideograph>)
          11471 => 16#7D80#,   --  綀 (<CJK Ideograph>)
          11472 => 16#7D81#,   --  綁 (<CJK Ideograph>)
          11473 => 16#7D82#,   --  綂 (<CJK Ideograph>)
          11474 => 16#7D83#,   --  綃 (<CJK Ideograph>)
          11475 => 16#7D84#,   --  綄 (<CJK Ideograph>)
          11476 => 16#7D85#,   --  綅 (<CJK Ideograph>)
          11477 => 16#7D86#,   --  綆 (<CJK Ideograph>)
          11478 => 16#7D87#,   --  綇 (<CJK Ideograph>)
          11479 => 16#7D88#,   --  綈 (<CJK Ideograph>)
          11480 => 16#7D89#,   --  綉 (<CJK Ideograph>)
          11481 => 16#7D8A#,   --  綊 (<CJK Ideograph>)
          11482 => 16#7D8B#,   --  綋 (<CJK Ideograph>)
          11483 => 16#7D8C#,   --  綌 (<CJK Ideograph>)
          11484 => 16#7D8D#,   --  綍 (<CJK Ideograph>)
          11485 => 16#7D8E#,   --  綎 (<CJK Ideograph>)
          11486 => 16#7D8F#,   --  綏 (<CJK Ideograph>)
          11487 => 16#7D90#,   --  綐 (<CJK Ideograph>)
          11488 => 16#7D91#,   --  綑 (<CJK Ideograph>)
          11489 => 16#7D92#,   --  綒 (<CJK Ideograph>)
          11490 => 16#7D93#,   --  經 (<CJK Ideograph>)
          11491 => 16#7D94#,   --  綔 (<CJK Ideograph>)
          11492 => 16#7D95#,   --  綕 (<CJK Ideograph>)
          11493 => 16#7D96#,   --  綖 (<CJK Ideograph>)
          11494 => 16#7D97#,   --  綗 (<CJK Ideograph>)
          11495 => 16#7D98#,   --  綘 (<CJK Ideograph>)
          11496 => 16#5065#,   --  健 (<CJK Ideograph>)
          11497 => 16#8230#,   --  舰 (<CJK Ideograph>)
          11498 => 16#5251#,   --  剑 (<CJK Ideograph>)
          11499 => 16#996F#,   --  饯 (<CJK Ideograph>)
          11500 => 16#6E10#,   --  渐 (<CJK Ideograph>)
          11501 => 16#6E85#,   --  溅 (<CJK Ideograph>)
          11502 => 16#6DA7#,   --  涧 (<CJK Ideograph>)
          11503 => 16#5EFA#,   --  建 (<CJK Ideograph>)
          11504 => 16#50F5#,   --  僵 (<CJK Ideograph>)
          11505 => 16#59DC#,   --  姜 (<CJK Ideograph>)
          11506 => 16#5C06#,   --  将 (<CJK Ideograph>)
          11507 => 16#6D46#,   --  浆 (<CJK Ideograph>)
          11508 => 16#6C5F#,   --  江 (<CJK Ideograph>)
          11509 => 16#7586#,   --  疆 (<CJK Ideograph>)
          11510 => 16#848B#,   --  蒋 (<CJK Ideograph>)
          11511 => 16#6868#,   --  桨 (<CJK Ideograph>)
          11512 => 16#5956#,   --  奖 (<CJK Ideograph>)
          11513 => 16#8BB2#,   --  讲 (<CJK Ideograph>)
          11514 => 16#5320#,   --  匠 (<CJK Ideograph>)
          11515 => 16#9171#,   --  酱 (<CJK Ideograph>)
          11516 => 16#964D#,   --  降 (<CJK Ideograph>)
          11517 => 16#8549#,   --  蕉 (<CJK Ideograph>)
          11518 => 16#6912#,   --  椒 (<CJK Ideograph>)
          11519 => 16#7901#,   --  礁 (<CJK Ideograph>)
          11520 => 16#7126#,   --  焦 (<CJK Ideograph>)
          11521 => 16#80F6#,   --  胶 (<CJK Ideograph>)
          11522 => 16#4EA4#,   --  交 (<CJK Ideograph>)
          11523 => 16#90CA#,   --  郊 (<CJK Ideograph>)
          11524 => 16#6D47#,   --  浇 (<CJK Ideograph>)
          11525 => 16#9A84#,   --  骄 (<CJK Ideograph>)
          11526 => 16#5A07#,   --  娇 (<CJK Ideograph>)
          11527 => 16#56BC#,   --  嚼 (<CJK Ideograph>)
          11528 => 16#6405#,   --  搅 (<CJK Ideograph>)
          11529 => 16#94F0#,   --  铰 (<CJK Ideograph>)
          11530 => 16#77EB#,   --  矫 (<CJK Ideograph>)
          11531 => 16#4FA5#,   --  侥 (<CJK Ideograph>)
          11532 => 16#811A#,   --  脚 (<CJK Ideograph>)
          11533 => 16#72E1#,   --  狡 (<CJK Ideograph>)
          11534 => 16#89D2#,   --  角 (<CJK Ideograph>)
          11535 => 16#997A#,   --  饺 (<CJK Ideograph>)
          11536 => 16#7F34#,   --  缴 (<CJK Ideograph>)
          11537 => 16#7EDE#,   --  绞 (<CJK Ideograph>)
          11538 => 16#527F#,   --  剿 (<CJK Ideograph>)
          11539 => 16#6559#,   --  教 (<CJK Ideograph>)
          11540 => 16#9175#,   --  酵 (<CJK Ideograph>)
          11541 => 16#8F7F#,   --  轿 (<CJK Ideograph>)
          11542 => 16#8F83#,   --  较 (<CJK Ideograph>)
          11543 => 16#53EB#,   --  叫 (<CJK Ideograph>)
          11544 => 16#7A96#,   --  窖 (<CJK Ideograph>)
          11545 => 16#63ED#,   --  揭 (<CJK Ideograph>)
          11546 => 16#63A5#,   --  接 (<CJK Ideograph>)
          11547 => 16#7686#,   --  皆 (<CJK Ideograph>)
          11548 => 16#79F8#,   --  秸 (<CJK Ideograph>)
          11549 => 16#8857#,   --  街 (<CJK Ideograph>)
          11550 => 16#9636#,   --  阶 (<CJK Ideograph>)
          11551 => 16#622A#,   --  截 (<CJK Ideograph>)
          11552 => 16#52AB#,   --  劫 (<CJK Ideograph>)
          11553 => 16#8282#,   --  节 (<CJK Ideograph>)
          11554 => 16#6854#,   --  桔 (<CJK Ideograph>)
          11555 => 16#6770#,   --  杰 (<CJK Ideograph>)
          11556 => 16#6377#,   --  捷 (<CJK Ideograph>)
          11557 => 16#776B#,   --  睫 (<CJK Ideograph>)
          11558 => 16#7AED#,   --  竭 (<CJK Ideograph>)
          11559 => 16#6D01#,   --  洁 (<CJK Ideograph>)
          11560 => 16#7ED3#,   --  结 (<CJK Ideograph>)
          11561 => 16#89E3#,   --  解 (<CJK Ideograph>)
          11562 => 16#59D0#,   --  姐 (<CJK Ideograph>)
          11563 => 16#6212#,   --  戒 (<CJK Ideograph>)
          11564 => 16#85C9#,   --  藉 (<CJK Ideograph>)
          11565 => 16#82A5#,   --  芥 (<CJK Ideograph>)
          11566 => 16#754C#,   --  界 (<CJK Ideograph>)
          11567 => 16#501F#,   --  借 (<CJK Ideograph>)
          11568 => 16#4ECB#,   --  介 (<CJK Ideograph>)
          11569 => 16#75A5#,   --  疥 (<CJK Ideograph>)
          11570 => 16#8BEB#,   --  诫 (<CJK Ideograph>)
          11571 => 16#5C4A#,   --  届 (<CJK Ideograph>)
          11572 => 16#5DFE#,   --  巾 (<CJK Ideograph>)
          11573 => 16#7B4B#,   --  筋 (<CJK Ideograph>)
          11574 => 16#65A4#,   --  斤 (<CJK Ideograph>)
          11575 => 16#91D1#,   --  金 (<CJK Ideograph>)
          11576 => 16#4ECA#,   --  今 (<CJK Ideograph>)
          11577 => 16#6D25#,   --  津 (<CJK Ideograph>)
          11578 => 16#895F#,   --  襟 (<CJK Ideograph>)
          11579 => 16#7D27#,   --  紧 (<CJK Ideograph>)
          11580 => 16#9526#,   --  锦 (<CJK Ideograph>)
          11581 => 16#4EC5#,   --  仅 (<CJK Ideograph>)
          11582 => 16#8C28#,   --  谨 (<CJK Ideograph>)
          11583 => 16#8FDB#,   --  进 (<CJK Ideograph>)
          11584 => 16#9773#,   --  靳 (<CJK Ideograph>)
          11585 => 16#664B#,   --  晋 (<CJK Ideograph>)
          11586 => 16#7981#,   --  禁 (<CJK Ideograph>)
          11587 => 16#8FD1#,   --  近 (<CJK Ideograph>)
          11588 => 16#70EC#,   --  烬 (<CJK Ideograph>)
          11589 => 16#6D78#,   --  浸 (<CJK Ideograph>)
          11590 => 16#7D99#,   --  継 (<CJK Ideograph>)
          11591 => 16#7D9A#,   --  続 (<CJK Ideograph>)
          11592 => 16#7D9B#,   --  綛 (<CJK Ideograph>)
          11593 => 16#7D9C#,   --  綜 (<CJK Ideograph>)
          11594 => 16#7D9D#,   --  綝 (<CJK Ideograph>)
          11595 => 16#7D9E#,   --  綞 (<CJK Ideograph>)
          11596 => 16#7D9F#,   --  綟 (<CJK Ideograph>)
          11597 => 16#7DA0#,   --  綠 (<CJK Ideograph>)
          11598 => 16#7DA1#,   --  綡 (<CJK Ideograph>)
          11599 => 16#7DA2#,   --  綢 (<CJK Ideograph>)
          11600 => 16#7DA3#,   --  綣 (<CJK Ideograph>)
          11601 => 16#7DA4#,   --  綤 (<CJK Ideograph>)
          11602 => 16#7DA5#,   --  綥 (<CJK Ideograph>)
          11603 => 16#7DA7#,   --  綧 (<CJK Ideograph>)
          11604 => 16#7DA8#,   --  綨 (<CJK Ideograph>)
          11605 => 16#7DA9#,   --  綩 (<CJK Ideograph>)
          11606 => 16#7DAA#,   --  綪 (<CJK Ideograph>)
          11607 => 16#7DAB#,   --  綫 (<CJK Ideograph>)
          11608 => 16#7DAC#,   --  綬 (<CJK Ideograph>)
          11609 => 16#7DAD#,   --  維 (<CJK Ideograph>)
          11610 => 16#7DAF#,   --  綯 (<CJK Ideograph>)
          11611 => 16#7DB0#,   --  綰 (<CJK Ideograph>)
          11612 => 16#7DB1#,   --  綱 (<CJK Ideograph>)
          11613 => 16#7DB2#,   --  網 (<CJK Ideograph>)
          11614 => 16#7DB3#,   --  綳 (<CJK Ideograph>)
          11615 => 16#7DB4#,   --  綴 (<CJK Ideograph>)
          11616 => 16#7DB5#,   --  綵 (<CJK Ideograph>)
          11617 => 16#7DB6#,   --  綶 (<CJK Ideograph>)
          11618 => 16#7DB7#,   --  綷 (<CJK Ideograph>)
          11619 => 16#7DB8#,   --  綸 (<CJK Ideograph>)
          11620 => 16#7DB9#,   --  綹 (<CJK Ideograph>)
          11621 => 16#7DBA#,   --  綺 (<CJK Ideograph>)
          11622 => 16#7DBB#,   --  綻 (<CJK Ideograph>)
          11623 => 16#7DBC#,   --  綼 (<CJK Ideograph>)
          11624 => 16#7DBD#,   --  綽 (<CJK Ideograph>)
          11625 => 16#7DBE#,   --  綾 (<CJK Ideograph>)
          11626 => 16#7DBF#,   --  綿 (<CJK Ideograph>)
          11627 => 16#7DC0#,   --  緀 (<CJK Ideograph>)
          11628 => 16#7DC1#,   --  緁 (<CJK Ideograph>)
          11629 => 16#7DC2#,   --  緂 (<CJK Ideograph>)
          11630 => 16#7DC3#,   --  緃 (<CJK Ideograph>)
          11631 => 16#7DC4#,   --  緄 (<CJK Ideograph>)
          11632 => 16#7DC5#,   --  緅 (<CJK Ideograph>)
          11633 => 16#7DC6#,   --  緆 (<CJK Ideograph>)
          11634 => 16#7DC7#,   --  緇 (<CJK Ideograph>)
          11635 => 16#7DC8#,   --  緈 (<CJK Ideograph>)
          11636 => 16#7DC9#,   --  緉 (<CJK Ideograph>)
          11637 => 16#7DCA#,   --  緊 (<CJK Ideograph>)
          11638 => 16#7DCB#,   --  緋 (<CJK Ideograph>)
          11639 => 16#7DCC#,   --  緌 (<CJK Ideograph>)
          11640 => 16#7DCD#,   --  緍 (<CJK Ideograph>)
          11641 => 16#7DCE#,   --  緎 (<CJK Ideograph>)
          11642 => 16#7DCF#,   --  総 (<CJK Ideograph>)
          11643 => 16#7DD0#,   --  緐 (<CJK Ideograph>)
          11644 => 16#7DD1#,   --  緑 (<CJK Ideograph>)
          11645 => 16#7DD2#,   --  緒 (<CJK Ideograph>)
          11646 => 16#7DD3#,   --  緓 (<CJK Ideograph>)
          11647 => 16#7DD4#,   --  緔 (<CJK Ideograph>)
          11648 => 16#7DD5#,   --  緕 (<CJK Ideograph>)
          11649 => 16#7DD6#,   --  緖 (<CJK Ideograph>)
          11650 => 16#7DD7#,   --  緗 (<CJK Ideograph>)
          11651 => 16#7DD8#,   --  緘 (<CJK Ideograph>)
          11652 => 16#7DD9#,   --  緙 (<CJK Ideograph>)
          11653 => 16#7DDA#,   --  線 (<CJK Ideograph>)
          11654 => 16#7DDB#,   --  緛 (<CJK Ideograph>)
          11655 => 16#7DDC#,   --  緜 (<CJK Ideograph>)
          11656 => 16#7DDD#,   --  緝 (<CJK Ideograph>)
          11657 => 16#7DDE#,   --  緞 (<CJK Ideograph>)
          11658 => 16#7DDF#,   --  緟 (<CJK Ideograph>)
          11659 => 16#7DE0#,   --  締 (<CJK Ideograph>)
          11660 => 16#7DE1#,   --  緡 (<CJK Ideograph>)
          11661 => 16#7DE2#,   --  緢 (<CJK Ideograph>)
          11662 => 16#7DE3#,   --  緣 (<CJK Ideograph>)
          11663 => 16#7DE4#,   --  緤 (<CJK Ideograph>)
          11664 => 16#7DE5#,   --  緥 (<CJK Ideograph>)
          11665 => 16#7DE6#,   --  緦 (<CJK Ideograph>)
          11666 => 16#7DE7#,   --  緧 (<CJK Ideograph>)
          11667 => 16#7DE8#,   --  編 (<CJK Ideograph>)
          11668 => 16#7DE9#,   --  緩 (<CJK Ideograph>)
          11669 => 16#7DEA#,   --  緪 (<CJK Ideograph>)
          11670 => 16#7DEB#,   --  緫 (<CJK Ideograph>)
          11671 => 16#7DEC#,   --  緬 (<CJK Ideograph>)
          11672 => 16#7DED#,   --  緭 (<CJK Ideograph>)
          11673 => 16#7DEE#,   --  緮 (<CJK Ideograph>)
          11674 => 16#7DEF#,   --  緯 (<CJK Ideograph>)
          11675 => 16#7DF0#,   --  緰 (<CJK Ideograph>)
          11676 => 16#7DF1#,   --  緱 (<CJK Ideograph>)
          11677 => 16#7DF2#,   --  緲 (<CJK Ideograph>)
          11678 => 16#7DF3#,   --  緳 (<CJK Ideograph>)
          11679 => 16#7DF4#,   --  練 (<CJK Ideograph>)
          11680 => 16#7DF5#,   --  緵 (<CJK Ideograph>)
          11681 => 16#7DF6#,   --  緶 (<CJK Ideograph>)
          11682 => 16#7DF7#,   --  緷 (<CJK Ideograph>)
          11683 => 16#7DF8#,   --  緸 (<CJK Ideograph>)
          11684 => 16#7DF9#,   --  緹 (<CJK Ideograph>)
          11685 => 16#7DFA#,   --  緺 (<CJK Ideograph>)
          11686 => 16#5C3D#,   --  尽 (<CJK Ideograph>)
          11687 => 16#52B2#,   --  劲 (<CJK Ideograph>)
          11688 => 16#8346#,   --  荆 (<CJK Ideograph>)
          11689 => 16#5162#,   --  兢 (<CJK Ideograph>)
          11690 => 16#830E#,   --  茎 (<CJK Ideograph>)
          11691 => 16#775B#,   --  睛 (<CJK Ideograph>)
          11692 => 16#6676#,   --  晶 (<CJK Ideograph>)
          11693 => 16#9CB8#,   --  鲸 (<CJK Ideograph>)
          11694 => 16#4EAC#,   --  京 (<CJK Ideograph>)
          11695 => 16#60CA#,   --  惊 (<CJK Ideograph>)
          11696 => 16#7CBE#,   --  精 (<CJK Ideograph>)
          11697 => 16#7CB3#,   --  粳 (<CJK Ideograph>)
          11698 => 16#7ECF#,   --  经 (<CJK Ideograph>)
          11699 => 16#4E95#,   --  井 (<CJK Ideograph>)
          11700 => 16#8B66#,   --  警 (<CJK Ideograph>)
          11701 => 16#666F#,   --  景 (<CJK Ideograph>)
          11702 => 16#9888#,   --  颈 (<CJK Ideograph>)
          11703 => 16#9759#,   --  静 (<CJK Ideograph>)
          11704 => 16#5883#,   --  境 (<CJK Ideograph>)
          11705 => 16#656C#,   --  敬 (<CJK Ideograph>)
          11706 => 16#955C#,   --  镜 (<CJK Ideograph>)
          11707 => 16#5F84#,   --  径 (<CJK Ideograph>)
          11708 => 16#75C9#,   --  痉 (<CJK Ideograph>)
          11709 => 16#9756#,   --  靖 (<CJK Ideograph>)
          11710 => 16#7ADF#,   --  竟 (<CJK Ideograph>)
          11711 => 16#7ADE#,   --  竞 (<CJK Ideograph>)
          11712 => 16#51C0#,   --  净 (<CJK Ideograph>)
          11713 => 16#70AF#,   --  炯 (<CJK Ideograph>)
          11714 => 16#7A98#,   --  窘 (<CJK Ideograph>)
          11715 => 16#63EA#,   --  揪 (<CJK Ideograph>)
          11716 => 16#7A76#,   --  究 (<CJK Ideograph>)
          11717 => 16#7EA0#,   --  纠 (<CJK Ideograph>)
          11718 => 16#7396#,   --  玖 (<CJK Ideograph>)
          11719 => 16#97ED#,   --  韭 (<CJK Ideograph>)
          11720 => 16#4E45#,   --  久 (<CJK Ideograph>)
          11721 => 16#7078#,   --  灸 (<CJK Ideograph>)
          11722 => 16#4E5D#,   --  九 (<CJK Ideograph>)
          11723 => 16#9152#,   --  酒 (<CJK Ideograph>)
          11724 => 16#53A9#,   --  厩 (<CJK Ideograph>)
          11725 => 16#6551#,   --  救 (<CJK Ideograph>)
          11726 => 16#65E7#,   --  旧 (<CJK Ideograph>)
          11727 => 16#81FC#,   --  臼 (<CJK Ideograph>)
          11728 => 16#8205#,   --  舅 (<CJK Ideograph>)
          11729 => 16#548E#,   --  咎 (<CJK Ideograph>)
          11730 => 16#5C31#,   --  就 (<CJK Ideograph>)
          11731 => 16#759A#,   --  疚 (<CJK Ideograph>)
          11732 => 16#97A0#,   --  鞠 (<CJK Ideograph>)
          11733 => 16#62D8#,   --  拘 (<CJK Ideograph>)
          11734 => 16#72D9#,   --  狙 (<CJK Ideograph>)
          11735 => 16#75BD#,   --  疽 (<CJK Ideograph>)
          11736 => 16#5C45#,   --  居 (<CJK Ideograph>)
          11737 => 16#9A79#,   --  驹 (<CJK Ideograph>)
          11738 => 16#83CA#,   --  菊 (<CJK Ideograph>)
          11739 => 16#5C40#,   --  局 (<CJK Ideograph>)
          11740 => 16#5480#,   --  咀 (<CJK Ideograph>)
          11741 => 16#77E9#,   --  矩 (<CJK Ideograph>)
          11742 => 16#4E3E#,   --  举 (<CJK Ideograph>)
          11743 => 16#6CAE#,   --  沮 (<CJK Ideograph>)
          11744 => 16#805A#,   --  聚 (<CJK Ideograph>)
          11745 => 16#62D2#,   --  拒 (<CJK Ideograph>)
          11746 => 16#636E#,   --  据 (<CJK Ideograph>)
          11747 => 16#5DE8#,   --  巨 (<CJK Ideograph>)
          11748 => 16#5177#,   --  具 (<CJK Ideograph>)
          11749 => 16#8DDD#,   --  距 (<CJK Ideograph>)
          11750 => 16#8E1E#,   --  踞 (<CJK Ideograph>)
          11751 => 16#952F#,   --  锯 (<CJK Ideograph>)
          11752 => 16#4FF1#,   --  俱 (<CJK Ideograph>)
          11753 => 16#53E5#,   --  句 (<CJK Ideograph>)
          11754 => 16#60E7#,   --  惧 (<CJK Ideograph>)
          11755 => 16#70AC#,   --  炬 (<CJK Ideograph>)
          11756 => 16#5267#,   --  剧 (<CJK Ideograph>)
          11757 => 16#6350#,   --  捐 (<CJK Ideograph>)
          11758 => 16#9E43#,   --  鹃 (<CJK Ideograph>)
          11759 => 16#5A1F#,   --  娟 (<CJK Ideograph>)
          11760 => 16#5026#,   --  倦 (<CJK Ideograph>)
          11761 => 16#7737#,   --  眷 (<CJK Ideograph>)
          11762 => 16#5377#,   --  卷 (<CJK Ideograph>)
          11763 => 16#7EE2#,   --  绢 (<CJK Ideograph>)
          11764 => 16#6485#,   --  撅 (<CJK Ideograph>)
          11765 => 16#652B#,   --  攫 (<CJK Ideograph>)
          11766 => 16#6289#,   --  抉 (<CJK Ideograph>)
          11767 => 16#6398#,   --  掘 (<CJK Ideograph>)
          11768 => 16#5014#,   --  倔 (<CJK Ideograph>)
          11769 => 16#7235#,   --  爵 (<CJK Ideograph>)
          11770 => 16#89C9#,   --  觉 (<CJK Ideograph>)
          11771 => 16#51B3#,   --  决 (<CJK Ideograph>)
          11772 => 16#8BC0#,   --  诀 (<CJK Ideograph>)
          11773 => 16#7EDD#,   --  绝 (<CJK Ideograph>)
          11774 => 16#5747#,   --  均 (<CJK Ideograph>)
          11775 => 16#83CC#,   --  菌 (<CJK Ideograph>)
          11776 => 16#94A7#,   --  钧 (<CJK Ideograph>)
          11777 => 16#519B#,   --  军 (<CJK Ideograph>)
          11778 => 16#541B#,   --  君 (<CJK Ideograph>)
          11779 => 16#5CFB#,   --  峻 (<CJK Ideograph>)
          11780 => 16#7DFB#,   --  緻 (<CJK Ideograph>)
          11781 => 16#7DFC#,   --  緼 (<CJK Ideograph>)
          11782 => 16#7DFD#,   --  緽 (<CJK Ideograph>)
          11783 => 16#7DFE#,   --  緾 (<CJK Ideograph>)
          11784 => 16#7DFF#,   --  緿 (<CJK Ideograph>)
          11785 => 16#7E00#,   --  縀 (<CJK Ideograph>)
          11786 => 16#7E01#,   --  縁 (<CJK Ideograph>)
          11787 => 16#7E02#,   --  縂 (<CJK Ideograph>)
          11788 => 16#7E03#,   --  縃 (<CJK Ideograph>)
          11789 => 16#7E04#,   --  縄 (<CJK Ideograph>)
          11790 => 16#7E05#,   --  縅 (<CJK Ideograph>)
          11791 => 16#7E06#,   --  縆 (<CJK Ideograph>)
          11792 => 16#7E07#,   --  縇 (<CJK Ideograph>)
          11793 => 16#7E08#,   --  縈 (<CJK Ideograph>)
          11794 => 16#7E09#,   --  縉 (<CJK Ideograph>)
          11795 => 16#7E0A#,   --  縊 (<CJK Ideograph>)
          11796 => 16#7E0B#,   --  縋 (<CJK Ideograph>)
          11797 => 16#7E0C#,   --  縌 (<CJK Ideograph>)
          11798 => 16#7E0D#,   --  縍 (<CJK Ideograph>)
          11799 => 16#7E0E#,   --  縎 (<CJK Ideograph>)
          11800 => 16#7E0F#,   --  縏 (<CJK Ideograph>)
          11801 => 16#7E10#,   --  縐 (<CJK Ideograph>)
          11802 => 16#7E11#,   --  縑 (<CJK Ideograph>)
          11803 => 16#7E12#,   --  縒 (<CJK Ideograph>)
          11804 => 16#7E13#,   --  縓 (<CJK Ideograph>)
          11805 => 16#7E14#,   --  縔 (<CJK Ideograph>)
          11806 => 16#7E15#,   --  縕 (<CJK Ideograph>)
          11807 => 16#7E16#,   --  縖 (<CJK Ideograph>)
          11808 => 16#7E17#,   --  縗 (<CJK Ideograph>)
          11809 => 16#7E18#,   --  縘 (<CJK Ideograph>)
          11810 => 16#7E19#,   --  縙 (<CJK Ideograph>)
          11811 => 16#7E1A#,   --  縚 (<CJK Ideograph>)
          11812 => 16#7E1B#,   --  縛 (<CJK Ideograph>)
          11813 => 16#7E1C#,   --  縜 (<CJK Ideograph>)
          11814 => 16#7E1D#,   --  縝 (<CJK Ideograph>)
          11815 => 16#7E1E#,   --  縞 (<CJK Ideograph>)
          11816 => 16#7E1F#,   --  縟 (<CJK Ideograph>)
          11817 => 16#7E20#,   --  縠 (<CJK Ideograph>)
          11818 => 16#7E21#,   --  縡 (<CJK Ideograph>)
          11819 => 16#7E22#,   --  縢 (<CJK Ideograph>)
          11820 => 16#7E23#,   --  縣 (<CJK Ideograph>)
          11821 => 16#7E24#,   --  縤 (<CJK Ideograph>)
          11822 => 16#7E25#,   --  縥 (<CJK Ideograph>)
          11823 => 16#7E26#,   --  縦 (<CJK Ideograph>)
          11824 => 16#7E27#,   --  縧 (<CJK Ideograph>)
          11825 => 16#7E28#,   --  縨 (<CJK Ideograph>)
          11826 => 16#7E29#,   --  縩 (<CJK Ideograph>)
          11827 => 16#7E2A#,   --  縪 (<CJK Ideograph>)
          11828 => 16#7E2B#,   --  縫 (<CJK Ideograph>)
          11829 => 16#7E2C#,   --  縬 (<CJK Ideograph>)
          11830 => 16#7E2D#,   --  縭 (<CJK Ideograph>)
          11831 => 16#7E2E#,   --  縮 (<CJK Ideograph>)
          11832 => 16#7E2F#,   --  縯 (<CJK Ideograph>)
          11833 => 16#7E30#,   --  縰 (<CJK Ideograph>)
          11834 => 16#7E31#,   --  縱 (<CJK Ideograph>)
          11835 => 16#7E32#,   --  縲 (<CJK Ideograph>)
          11836 => 16#7E33#,   --  縳 (<CJK Ideograph>)
          11837 => 16#7E34#,   --  縴 (<CJK Ideograph>)
          11838 => 16#7E35#,   --  縵 (<CJK Ideograph>)
          11839 => 16#7E36#,   --  縶 (<CJK Ideograph>)
          11840 => 16#7E37#,   --  縷 (<CJK Ideograph>)
          11841 => 16#7E38#,   --  縸 (<CJK Ideograph>)
          11842 => 16#7E39#,   --  縹 (<CJK Ideograph>)
          11843 => 16#7E3A#,   --  縺 (<CJK Ideograph>)
          11844 => 16#7E3C#,   --  縼 (<CJK Ideograph>)
          11845 => 16#7E3D#,   --  總 (<CJK Ideograph>)
          11846 => 16#7E3E#,   --  績 (<CJK Ideograph>)
          11847 => 16#7E3F#,   --  縿 (<CJK Ideograph>)
          11848 => 16#7E40#,   --  繀 (<CJK Ideograph>)
          11849 => 16#7E42#,   --  繂 (<CJK Ideograph>)
          11850 => 16#7E43#,   --  繃 (<CJK Ideograph>)
          11851 => 16#7E44#,   --  繄 (<CJK Ideograph>)
          11852 => 16#7E45#,   --  繅 (<CJK Ideograph>)
          11853 => 16#7E46#,   --  繆 (<CJK Ideograph>)
          11854 => 16#7E48#,   --  繈 (<CJK Ideograph>)
          11855 => 16#7E49#,   --  繉 (<CJK Ideograph>)
          11856 => 16#7E4A#,   --  繊 (<CJK Ideograph>)
          11857 => 16#7E4B#,   --  繋 (<CJK Ideograph>)
          11858 => 16#7E4C#,   --  繌 (<CJK Ideograph>)
          11859 => 16#7E4D#,   --  繍 (<CJK Ideograph>)
          11860 => 16#7E4E#,   --  繎 (<CJK Ideograph>)
          11861 => 16#7E4F#,   --  繏 (<CJK Ideograph>)
          11862 => 16#7E50#,   --  繐 (<CJK Ideograph>)
          11863 => 16#7E51#,   --  繑 (<CJK Ideograph>)
          11864 => 16#7E52#,   --  繒 (<CJK Ideograph>)
          11865 => 16#7E53#,   --  繓 (<CJK Ideograph>)
          11866 => 16#7E54#,   --  織 (<CJK Ideograph>)
          11867 => 16#7E55#,   --  繕 (<CJK Ideograph>)
          11868 => 16#7E56#,   --  繖 (<CJK Ideograph>)
          11869 => 16#7E57#,   --  繗 (<CJK Ideograph>)
          11870 => 16#7E58#,   --  繘 (<CJK Ideograph>)
          11871 => 16#7E59#,   --  繙 (<CJK Ideograph>)
          11872 => 16#7E5A#,   --  繚 (<CJK Ideograph>)
          11873 => 16#7E5B#,   --  繛 (<CJK Ideograph>)
          11874 => 16#7E5C#,   --  繜 (<CJK Ideograph>)
          11875 => 16#7E5D#,   --  繝 (<CJK Ideograph>)
          11876 => 16#4FCA#,   --  俊 (<CJK Ideograph>)
          11877 => 16#7AE3#,   --  竣 (<CJK Ideograph>)
          11878 => 16#6D5A#,   --  浚 (<CJK Ideograph>)
          11879 => 16#90E1#,   --  郡 (<CJK Ideograph>)
          11880 => 16#9A8F#,   --  骏 (<CJK Ideograph>)
          11881 => 16#5580#,   --  喀 (<CJK Ideograph>)
          11882 => 16#5496#,   --  咖 (<CJK Ideograph>)
          11883 => 16#5361#,   --  卡 (<CJK Ideograph>)
          11884 => 16#54AF#,   --  咯 (<CJK Ideograph>)
          11885 => 16#5F00#,   --  开 (<CJK Ideograph>)
          11886 => 16#63E9#,   --  揩 (<CJK Ideograph>)
          11887 => 16#6977#,   --  楷 (<CJK Ideograph>)
          11888 => 16#51EF#,   --  凯 (<CJK Ideograph>)
          11889 => 16#6168#,   --  慨 (<CJK Ideograph>)
          11890 => 16#520A#,   --  刊 (<CJK Ideograph>)
          11891 => 16#582A#,   --  堪 (<CJK Ideograph>)
          11892 => 16#52D8#,   --  勘 (<CJK Ideograph>)
          11893 => 16#574E#,   --  坎 (<CJK Ideograph>)
          11894 => 16#780D#,   --  砍 (<CJK Ideograph>)
          11895 => 16#770B#,   --  看 (<CJK Ideograph>)
          11896 => 16#5EB7#,   --  康 (<CJK Ideograph>)
          11897 => 16#6177#,   --  慷 (<CJK Ideograph>)
          11898 => 16#7CE0#,   --  糠 (<CJK Ideograph>)
          11899 => 16#625B#,   --  扛 (<CJK Ideograph>)
          11900 => 16#6297#,   --  抗 (<CJK Ideograph>)
          11901 => 16#4EA2#,   --  亢 (<CJK Ideograph>)
          11902 => 16#7095#,   --  炕 (<CJK Ideograph>)
          11903 => 16#8003#,   --  考 (<CJK Ideograph>)
          11904 => 16#62F7#,   --  拷 (<CJK Ideograph>)
          11905 => 16#70E4#,   --  烤 (<CJK Ideograph>)
          11906 => 16#9760#,   --  靠 (<CJK Ideograph>)
          11907 => 16#5777#,   --  坷 (<CJK Ideograph>)
          11908 => 16#82DB#,   --  苛 (<CJK Ideograph>)
          11909 => 16#67EF#,   --  柯 (<CJK Ideograph>)
          11910 => 16#68F5#,   --  棵 (<CJK Ideograph>)
          11911 => 16#78D5#,   --  磕 (<CJK Ideograph>)
          11912 => 16#9897#,   --  颗 (<CJK Ideograph>)
          11913 => 16#79D1#,   --  科 (<CJK Ideograph>)
          11914 => 16#58F3#,   --  壳 (<CJK Ideograph>)
          11915 => 16#54B3#,   --  咳 (<CJK Ideograph>)
          11916 => 16#53EF#,   --  可 (<CJK Ideograph>)
          11917 => 16#6E34#,   --  渴 (<CJK Ideograph>)
          11918 => 16#514B#,   --  克 (<CJK Ideograph>)
          11919 => 16#523B#,   --  刻 (<CJK Ideograph>)
          11920 => 16#5BA2#,   --  客 (<CJK Ideograph>)
          11921 => 16#8BFE#,   --  课 (<CJK Ideograph>)
          11922 => 16#80AF#,   --  肯 (<CJK Ideograph>)
          11923 => 16#5543#,   --  啃 (<CJK Ideograph>)
          11924 => 16#57A6#,   --  垦 (<CJK Ideograph>)
          11925 => 16#6073#,   --  恳 (<CJK Ideograph>)
          11926 => 16#5751#,   --  坑 (<CJK Ideograph>)
          11927 => 16#542D#,   --  吭 (<CJK Ideograph>)
          11928 => 16#7A7A#,   --  空 (<CJK Ideograph>)
          11929 => 16#6050#,   --  恐 (<CJK Ideograph>)
          11930 => 16#5B54#,   --  孔 (<CJK Ideograph>)
          11931 => 16#63A7#,   --  控 (<CJK Ideograph>)
          11932 => 16#62A0#,   --  抠 (<CJK Ideograph>)
          11933 => 16#53E3#,   --  口 (<CJK Ideograph>)
          11934 => 16#6263#,   --  扣 (<CJK Ideograph>)
          11935 => 16#5BC7#,   --  寇 (<CJK Ideograph>)
          11936 => 16#67AF#,   --  枯 (<CJK Ideograph>)
          11937 => 16#54ED#,   --  哭 (<CJK Ideograph>)
          11938 => 16#7A9F#,   --  窟 (<CJK Ideograph>)
          11939 => 16#82E6#,   --  苦 (<CJK Ideograph>)
          11940 => 16#9177#,   --  酷 (<CJK Ideograph>)
          11941 => 16#5E93#,   --  库 (<CJK Ideograph>)
          11942 => 16#88E4#,   --  裤 (<CJK Ideograph>)
          11943 => 16#5938#,   --  夸 (<CJK Ideograph>)
          11944 => 16#57AE#,   --  垮 (<CJK Ideograph>)
          11945 => 16#630E#,   --  挎 (<CJK Ideograph>)
          11946 => 16#8DE8#,   --  跨 (<CJK Ideograph>)
          11947 => 16#80EF#,   --  胯 (<CJK Ideograph>)
          11948 => 16#5757#,   --  块 (<CJK Ideograph>)
          11949 => 16#7B77#,   --  筷 (<CJK Ideograph>)
          11950 => 16#4FA9#,   --  侩 (<CJK Ideograph>)
          11951 => 16#5FEB#,   --  快 (<CJK Ideograph>)
          11952 => 16#5BBD#,   --  宽 (<CJK Ideograph>)
          11953 => 16#6B3E#,   --  款 (<CJK Ideograph>)
          11954 => 16#5321#,   --  匡 (<CJK Ideograph>)
          11955 => 16#7B50#,   --  筐 (<CJK Ideograph>)
          11956 => 16#72C2#,   --  狂 (<CJK Ideograph>)
          11957 => 16#6846#,   --  框 (<CJK Ideograph>)
          11958 => 16#77FF#,   --  矿 (<CJK Ideograph>)
          11959 => 16#7736#,   --  眶 (<CJK Ideograph>)
          11960 => 16#65F7#,   --  旷 (<CJK Ideograph>)
          11961 => 16#51B5#,   --  况 (<CJK Ideograph>)
          11962 => 16#4E8F#,   --  亏 (<CJK Ideograph>)
          11963 => 16#76D4#,   --  盔 (<CJK Ideograph>)
          11964 => 16#5CBF#,   --  岿 (<CJK Ideograph>)
          11965 => 16#7AA5#,   --  窥 (<CJK Ideograph>)
          11966 => 16#8475#,   --  葵 (<CJK Ideograph>)
          11967 => 16#594E#,   --  奎 (<CJK Ideograph>)
          11968 => 16#9B41#,   --  魁 (<CJK Ideograph>)
          11969 => 16#5080#,   --  傀 (<CJK Ideograph>)
          11970 => 16#7E5E#,   --  繞 (<CJK Ideograph>)
          11971 => 16#7E5F#,   --  繟 (<CJK Ideograph>)
          11972 => 16#7E60#,   --  繠 (<CJK Ideograph>)
          11973 => 16#7E61#,   --  繡 (<CJK Ideograph>)
          11974 => 16#7E62#,   --  繢 (<CJK Ideograph>)
          11975 => 16#7E63#,   --  繣 (<CJK Ideograph>)
          11976 => 16#7E64#,   --  繤 (<CJK Ideograph>)
          11977 => 16#7E65#,   --  繥 (<CJK Ideograph>)
          11978 => 16#7E66#,   --  繦 (<CJK Ideograph>)
          11979 => 16#7E67#,   --  繧 (<CJK Ideograph>)
          11980 => 16#7E68#,   --  繨 (<CJK Ideograph>)
          11981 => 16#7E69#,   --  繩 (<CJK Ideograph>)
          11982 => 16#7E6A#,   --  繪 (<CJK Ideograph>)
          11983 => 16#7E6B#,   --  繫 (<CJK Ideograph>)
          11984 => 16#7E6C#,   --  繬 (<CJK Ideograph>)
          11985 => 16#7E6D#,   --  繭 (<CJK Ideograph>)
          11986 => 16#7E6E#,   --  繮 (<CJK Ideograph>)
          11987 => 16#7E6F#,   --  繯 (<CJK Ideograph>)
          11988 => 16#7E70#,   --  繰 (<CJK Ideograph>)
          11989 => 16#7E71#,   --  繱 (<CJK Ideograph>)
          11990 => 16#7E72#,   --  繲 (<CJK Ideograph>)
          11991 => 16#7E73#,   --  繳 (<CJK Ideograph>)
          11992 => 16#7E74#,   --  繴 (<CJK Ideograph>)
          11993 => 16#7E75#,   --  繵 (<CJK Ideograph>)
          11994 => 16#7E76#,   --  繶 (<CJK Ideograph>)
          11995 => 16#7E77#,   --  繷 (<CJK Ideograph>)
          11996 => 16#7E78#,   --  繸 (<CJK Ideograph>)
          11997 => 16#7E79#,   --  繹 (<CJK Ideograph>)
          11998 => 16#7E7A#,   --  繺 (<CJK Ideograph>)
          11999 => 16#7E7B#,   --  繻 (<CJK Ideograph>)
          12000 => 16#7E7C#,   --  繼 (<CJK Ideograph>)
          12001 => 16#7E7D#,   --  繽 (<CJK Ideograph>)
          12002 => 16#7E7E#,   --  繾 (<CJK Ideograph>)
          12003 => 16#7E7F#,   --  繿 (<CJK Ideograph>)
          12004 => 16#7E80#,   --  纀 (<CJK Ideograph>)
          12005 => 16#7E81#,   --  纁 (<CJK Ideograph>)
          12006 => 16#7E83#,   --  纃 (<CJK Ideograph>)
          12007 => 16#7E84#,   --  纄 (<CJK Ideograph>)
          12008 => 16#7E85#,   --  纅 (<CJK Ideograph>)
          12009 => 16#7E86#,   --  纆 (<CJK Ideograph>)
          12010 => 16#7E87#,   --  纇 (<CJK Ideograph>)
          12011 => 16#7E88#,   --  纈 (<CJK Ideograph>)
          12012 => 16#7E89#,   --  纉 (<CJK Ideograph>)
          12013 => 16#7E8A#,   --  纊 (<CJK Ideograph>)
          12014 => 16#7E8B#,   --  纋 (<CJK Ideograph>)
          12015 => 16#7E8C#,   --  續 (<CJK Ideograph>)
          12016 => 16#7E8D#,   --  纍 (<CJK Ideograph>)
          12017 => 16#7E8E#,   --  纎 (<CJK Ideograph>)
          12018 => 16#7E8F#,   --  纏 (<CJK Ideograph>)
          12019 => 16#7E90#,   --  纐 (<CJK Ideograph>)
          12020 => 16#7E91#,   --  纑 (<CJK Ideograph>)
          12021 => 16#7E92#,   --  纒 (<CJK Ideograph>)
          12022 => 16#7E93#,   --  纓 (<CJK Ideograph>)
          12023 => 16#7E94#,   --  纔 (<CJK Ideograph>)
          12024 => 16#7E95#,   --  纕 (<CJK Ideograph>)
          12025 => 16#7E96#,   --  纖 (<CJK Ideograph>)
          12026 => 16#7E97#,   --  纗 (<CJK Ideograph>)
          12027 => 16#7E98#,   --  纘 (<CJK Ideograph>)
          12028 => 16#7E99#,   --  纙 (<CJK Ideograph>)
          12029 => 16#7E9A#,   --  纚 (<CJK Ideograph>)
          12030 => 16#7E9C#,   --  纜 (<CJK Ideograph>)
          12031 => 16#7E9D#,   --  纝 (<CJK Ideograph>)
          12032 => 16#7E9E#,   --  纞 (<CJK Ideograph>)
          12033 => 16#7EAE#,   --  纮 (<CJK Ideograph>)
          12034 => 16#7EB4#,   --  纴 (<CJK Ideograph>)
          12035 => 16#7EBB#,   --  纻 (<CJK Ideograph>)
          12036 => 16#7EBC#,   --  纼 (<CJK Ideograph>)
          12037 => 16#7ED6#,   --  绖 (<CJK Ideograph>)
          12038 => 16#7EE4#,   --  绤 (<CJK Ideograph>)
          12039 => 16#7EEC#,   --  绬 (<CJK Ideograph>)
          12040 => 16#7EF9#,   --  绹 (<CJK Ideograph>)
          12041 => 16#7F0A#,   --  缊 (<CJK Ideograph>)
          12042 => 16#7F10#,   --  缐 (<CJK Ideograph>)
          12043 => 16#7F1E#,   --  缞 (<CJK Ideograph>)
          12044 => 16#7F37#,   --  缷 (<CJK Ideograph>)
          12045 => 16#7F39#,   --  缹 (<CJK Ideograph>)
          12046 => 16#7F3B#,   --  缻 (<CJK Ideograph>)
          12047 => 16#7F3C#,   --  缼 (<CJK Ideograph>)
          12048 => 16#7F3D#,   --  缽 (<CJK Ideograph>)
          12049 => 16#7F3E#,   --  缾 (<CJK Ideograph>)
          12050 => 16#7F3F#,   --  缿 (<CJK Ideograph>)
          12051 => 16#7F40#,   --  罀 (<CJK Ideograph>)
          12052 => 16#7F41#,   --  罁 (<CJK Ideograph>)
          12053 => 16#7F43#,   --  罃 (<CJK Ideograph>)
          12054 => 16#7F46#,   --  罆 (<CJK Ideograph>)
          12055 => 16#7F47#,   --  罇 (<CJK Ideograph>)
          12056 => 16#7F48#,   --  罈 (<CJK Ideograph>)
          12057 => 16#7F49#,   --  罉 (<CJK Ideograph>)
          12058 => 16#7F4A#,   --  罊 (<CJK Ideograph>)
          12059 => 16#7F4B#,   --  罋 (<CJK Ideograph>)
          12060 => 16#7F4C#,   --  罌 (<CJK Ideograph>)
          12061 => 16#7F4D#,   --  罍 (<CJK Ideograph>)
          12062 => 16#7F4E#,   --  罎 (<CJK Ideograph>)
          12063 => 16#7F4F#,   --  罏 (<CJK Ideograph>)
          12064 => 16#7F52#,   --  罒 (<CJK Ideograph>)
          12065 => 16#7F53#,   --  罓 (<CJK Ideograph>)
          12066 => 16#9988#,   --  馈 (<CJK Ideograph>)
          12067 => 16#6127#,   --  愧 (<CJK Ideograph>)
          12068 => 16#6E83#,   --  溃 (<CJK Ideograph>)
          12069 => 16#5764#,   --  坤 (<CJK Ideograph>)
          12070 => 16#6606#,   --  昆 (<CJK Ideograph>)
          12071 => 16#6346#,   --  捆 (<CJK Ideograph>)
          12072 => 16#56F0#,   --  困 (<CJK Ideograph>)
          12073 => 16#62EC#,   --  括 (<CJK Ideograph>)
          12074 => 16#6269#,   --  扩 (<CJK Ideograph>)
          12075 => 16#5ED3#,   --  廓 (<CJK Ideograph>)
          12076 => 16#9614#,   --  阔 (<CJK Ideograph>)
          12077 => 16#5783#,   --  垃 (<CJK Ideograph>)
          12078 => 16#62C9#,   --  拉 (<CJK Ideograph>)
          12079 => 16#5587#,   --  喇 (<CJK Ideograph>)
          12080 => 16#8721#,   --  蜡 (<CJK Ideograph>)
          12081 => 16#814A#,   --  腊 (<CJK Ideograph>)
          12082 => 16#8FA3#,   --  辣 (<CJK Ideograph>)
          12083 => 16#5566#,   --  啦 (<CJK Ideograph>)
          12084 => 16#83B1#,   --  莱 (<CJK Ideograph>)
          12085 => 16#6765#,   --  来 (<CJK Ideograph>)
          12086 => 16#8D56#,   --  赖 (<CJK Ideograph>)
          12087 => 16#84DD#,   --  蓝 (<CJK Ideograph>)
          12088 => 16#5A6A#,   --  婪 (<CJK Ideograph>)
          12089 => 16#680F#,   --  栏 (<CJK Ideograph>)
          12090 => 16#62E6#,   --  拦 (<CJK Ideograph>)
          12091 => 16#7BEE#,   --  篮 (<CJK Ideograph>)
          12092 => 16#9611#,   --  阑 (<CJK Ideograph>)
          12093 => 16#5170#,   --  兰 (<CJK Ideograph>)
          12094 => 16#6F9C#,   --  澜 (<CJK Ideograph>)
          12095 => 16#8C30#,   --  谰 (<CJK Ideograph>)
          12096 => 16#63FD#,   --  揽 (<CJK Ideograph>)
          12097 => 16#89C8#,   --  览 (<CJK Ideograph>)
          12098 => 16#61D2#,   --  懒 (<CJK Ideograph>)
          12099 => 16#7F06#,   --  缆 (<CJK Ideograph>)
          12100 => 16#70C2#,   --  烂 (<CJK Ideograph>)
          12101 => 16#6EE5#,   --  滥 (<CJK Ideograph>)
          12102 => 16#7405#,   --  琅 (<CJK Ideograph>)
          12103 => 16#6994#,   --  榔 (<CJK Ideograph>)
          12104 => 16#72FC#,   --  狼 (<CJK Ideograph>)
          12105 => 16#5ECA#,   --  廊 (<CJK Ideograph>)
          12106 => 16#90CE#,   --  郎 (<CJK Ideograph>)
          12107 => 16#6717#,   --  朗 (<CJK Ideograph>)
          12108 => 16#6D6A#,   --  浪 (<CJK Ideograph>)
          12109 => 16#635E#,   --  捞 (<CJK Ideograph>)
          12110 => 16#52B3#,   --  劳 (<CJK Ideograph>)
          12111 => 16#7262#,   --  牢 (<CJK Ideograph>)
          12112 => 16#8001#,   --  老 (<CJK Ideograph>)
          12113 => 16#4F6C#,   --  佬 (<CJK Ideograph>)
          12114 => 16#59E5#,   --  姥 (<CJK Ideograph>)
          12115 => 16#916A#,   --  酪 (<CJK Ideograph>)
          12116 => 16#70D9#,   --  烙 (<CJK Ideograph>)
          12117 => 16#6D9D#,   --  涝 (<CJK Ideograph>)
          12118 => 16#52D2#,   --  勒 (<CJK Ideograph>)
          12119 => 16#4E50#,   --  乐 (<CJK Ideograph>)
          12120 => 16#96F7#,   --  雷 (<CJK Ideograph>)
          12121 => 16#956D#,   --  镭 (<CJK Ideograph>)
          12122 => 16#857E#,   --  蕾 (<CJK Ideograph>)
          12123 => 16#78CA#,   --  磊 (<CJK Ideograph>)
          12124 => 16#7D2F#,   --  累 (<CJK Ideograph>)
          12125 => 16#5121#,   --  儡 (<CJK Ideograph>)
          12126 => 16#5792#,   --  垒 (<CJK Ideograph>)
          12127 => 16#64C2#,   --  擂 (<CJK Ideograph>)
          12128 => 16#808B#,   --  肋 (<CJK Ideograph>)
          12129 => 16#7C7B#,   --  类 (<CJK Ideograph>)
          12130 => 16#6CEA#,   --  泪 (<CJK Ideograph>)
          12131 => 16#68F1#,   --  棱 (<CJK Ideograph>)
          12132 => 16#695E#,   --  楞 (<CJK Ideograph>)
          12133 => 16#51B7#,   --  冷 (<CJK Ideograph>)
          12134 => 16#5398#,   --  厘 (<CJK Ideograph>)
          12135 => 16#68A8#,   --  梨 (<CJK Ideograph>)
          12136 => 16#7281#,   --  犁 (<CJK Ideograph>)
          12137 => 16#9ECE#,   --  黎 (<CJK Ideograph>)
          12138 => 16#7BF1#,   --  篱 (<CJK Ideograph>)
          12139 => 16#72F8#,   --  狸 (<CJK Ideograph>)
          12140 => 16#79BB#,   --  离 (<CJK Ideograph>)
          12141 => 16#6F13#,   --  漓 (<CJK Ideograph>)
          12142 => 16#7406#,   --  理 (<CJK Ideograph>)
          12143 => 16#674E#,   --  李 (<CJK Ideograph>)
          12144 => 16#91CC#,   --  里 (<CJK Ideograph>)
          12145 => 16#9CA4#,   --  鲤 (<CJK Ideograph>)
          12146 => 16#793C#,   --  礼 (<CJK Ideograph>)
          12147 => 16#8389#,   --  莉 (<CJK Ideograph>)
          12148 => 16#8354#,   --  荔 (<CJK Ideograph>)
          12149 => 16#540F#,   --  吏 (<CJK Ideograph>)
          12150 => 16#6817#,   --  栗 (<CJK Ideograph>)
          12151 => 16#4E3D#,   --  丽 (<CJK Ideograph>)
          12152 => 16#5389#,   --  厉 (<CJK Ideograph>)
          12153 => 16#52B1#,   --  励 (<CJK Ideograph>)
          12154 => 16#783E#,   --  砾 (<CJK Ideograph>)
          12155 => 16#5386#,   --  历 (<CJK Ideograph>)
          12156 => 16#5229#,   --  利 (<CJK Ideograph>)
          12157 => 16#5088#,   --  傈 (<CJK Ideograph>)
          12158 => 16#4F8B#,   --  例 (<CJK Ideograph>)
          12159 => 16#4FD0#,   --  俐 (<CJK Ideograph>)
          12160 => 16#7F56#,   --  罖 (<CJK Ideograph>)
          12161 => 16#7F59#,   --  罙 (<CJK Ideograph>)
          12162 => 16#7F5B#,   --  罛 (<CJK Ideograph>)
          12163 => 16#7F5C#,   --  罜 (<CJK Ideograph>)
          12164 => 16#7F5D#,   --  罝 (<CJK Ideograph>)
          12165 => 16#7F5E#,   --  罞 (<CJK Ideograph>)
          12166 => 16#7F60#,   --  罠 (<CJK Ideograph>)
          12167 => 16#7F63#,   --  罣 (<CJK Ideograph>)
          12168 => 16#7F64#,   --  罤 (<CJK Ideograph>)
          12169 => 16#7F65#,   --  罥 (<CJK Ideograph>)
          12170 => 16#7F66#,   --  罦 (<CJK Ideograph>)
          12171 => 16#7F67#,   --  罧 (<CJK Ideograph>)
          12172 => 16#7F6B#,   --  罫 (<CJK Ideograph>)
          12173 => 16#7F6C#,   --  罬 (<CJK Ideograph>)
          12174 => 16#7F6D#,   --  罭 (<CJK Ideograph>)
          12175 => 16#7F6F#,   --  罯 (<CJK Ideograph>)
          12176 => 16#7F70#,   --  罰 (<CJK Ideograph>)
          12177 => 16#7F73#,   --  罳 (<CJK Ideograph>)
          12178 => 16#7F75#,   --  罵 (<CJK Ideograph>)
          12179 => 16#7F76#,   --  罶 (<CJK Ideograph>)
          12180 => 16#7F77#,   --  罷 (<CJK Ideograph>)
          12181 => 16#7F78#,   --  罸 (<CJK Ideograph>)
          12182 => 16#7F7A#,   --  罺 (<CJK Ideograph>)
          12183 => 16#7F7B#,   --  罻 (<CJK Ideograph>)
          12184 => 16#7F7C#,   --  罼 (<CJK Ideograph>)
          12185 => 16#7F7D#,   --  罽 (<CJK Ideograph>)
          12186 => 16#7F7F#,   --  罿 (<CJK Ideograph>)
          12187 => 16#7F80#,   --  羀 (<CJK Ideograph>)
          12188 => 16#7F82#,   --  羂 (<CJK Ideograph>)
          12189 => 16#7F83#,   --  羃 (<CJK Ideograph>)
          12190 => 16#7F84#,   --  羄 (<CJK Ideograph>)
          12191 => 16#7F85#,   --  羅 (<CJK Ideograph>)
          12192 => 16#7F86#,   --  羆 (<CJK Ideograph>)
          12193 => 16#7F87#,   --  羇 (<CJK Ideograph>)
          12194 => 16#7F88#,   --  羈 (<CJK Ideograph>)
          12195 => 16#7F89#,   --  羉 (<CJK Ideograph>)
          12196 => 16#7F8B#,   --  羋 (<CJK Ideograph>)
          12197 => 16#7F8D#,   --  羍 (<CJK Ideograph>)
          12198 => 16#7F8F#,   --  羏 (<CJK Ideograph>)
          12199 => 16#7F90#,   --  羐 (<CJK Ideograph>)
          12200 => 16#7F91#,   --  羑 (<CJK Ideograph>)
          12201 => 16#7F92#,   --  羒 (<CJK Ideograph>)
          12202 => 16#7F93#,   --  羓 (<CJK Ideograph>)
          12203 => 16#7F95#,   --  羕 (<CJK Ideograph>)
          12204 => 16#7F96#,   --  羖 (<CJK Ideograph>)
          12205 => 16#7F97#,   --  羗 (<CJK Ideograph>)
          12206 => 16#7F98#,   --  羘 (<CJK Ideograph>)
          12207 => 16#7F99#,   --  羙 (<CJK Ideograph>)
          12208 => 16#7F9B#,   --  羛 (<CJK Ideograph>)
          12209 => 16#7F9C#,   --  羜 (<CJK Ideograph>)
          12210 => 16#7FA0#,   --  羠 (<CJK Ideograph>)
          12211 => 16#7FA2#,   --  羢 (<CJK Ideograph>)
          12212 => 16#7FA3#,   --  羣 (<CJK Ideograph>)
          12213 => 16#7FA5#,   --  羥 (<CJK Ideograph>)
          12214 => 16#7FA6#,   --  羦 (<CJK Ideograph>)
          12215 => 16#7FA8#,   --  羨 (<CJK Ideograph>)
          12216 => 16#7FA9#,   --  義 (<CJK Ideograph>)
          12217 => 16#7FAA#,   --  羪 (<CJK Ideograph>)
          12218 => 16#7FAB#,   --  羫 (<CJK Ideograph>)
          12219 => 16#7FAC#,   --  羬 (<CJK Ideograph>)
          12220 => 16#7FAD#,   --  羭 (<CJK Ideograph>)
          12221 => 16#7FAE#,   --  羮 (<CJK Ideograph>)
          12222 => 16#7FB1#,   --  羱 (<CJK Ideograph>)
          12223 => 16#7FB3#,   --  羳 (<CJK Ideograph>)
          12224 => 16#7FB4#,   --  羴 (<CJK Ideograph>)
          12225 => 16#7FB5#,   --  羵 (<CJK Ideograph>)
          12226 => 16#7FB6#,   --  羶 (<CJK Ideograph>)
          12227 => 16#7FB7#,   --  羷 (<CJK Ideograph>)
          12228 => 16#7FBA#,   --  羺 (<CJK Ideograph>)
          12229 => 16#7FBB#,   --  羻 (<CJK Ideograph>)
          12230 => 16#7FBE#,   --  羾 (<CJK Ideograph>)
          12231 => 16#7FC0#,   --  翀 (<CJK Ideograph>)
          12232 => 16#7FC2#,   --  翂 (<CJK Ideograph>)
          12233 => 16#7FC3#,   --  翃 (<CJK Ideograph>)
          12234 => 16#7FC4#,   --  翄 (<CJK Ideograph>)
          12235 => 16#7FC6#,   --  翆 (<CJK Ideograph>)
          12236 => 16#7FC7#,   --  翇 (<CJK Ideograph>)
          12237 => 16#7FC8#,   --  翈 (<CJK Ideograph>)
          12238 => 16#7FC9#,   --  翉 (<CJK Ideograph>)
          12239 => 16#7FCB#,   --  翋 (<CJK Ideograph>)
          12240 => 16#7FCD#,   --  翍 (<CJK Ideograph>)
          12241 => 16#7FCF#,   --  翏 (<CJK Ideograph>)
          12242 => 16#7FD0#,   --  翐 (<CJK Ideograph>)
          12243 => 16#7FD1#,   --  翑 (<CJK Ideograph>)
          12244 => 16#7FD2#,   --  習 (<CJK Ideograph>)
          12245 => 16#7FD3#,   --  翓 (<CJK Ideograph>)
          12246 => 16#7FD6#,   --  翖 (<CJK Ideograph>)
          12247 => 16#7FD7#,   --  翗 (<CJK Ideograph>)
          12248 => 16#7FD9#,   --  翙 (<CJK Ideograph>)
          12249 => 16#7FDA#,   --  翚 (<CJK Ideograph>)
          12250 => 16#7FDB#,   --  翛 (<CJK Ideograph>)
          12251 => 16#7FDC#,   --  翜 (<CJK Ideograph>)
          12252 => 16#7FDD#,   --  翝 (<CJK Ideograph>)
          12253 => 16#7FDE#,   --  翞 (<CJK Ideograph>)
          12254 => 16#7FE2#,   --  翢 (<CJK Ideograph>)
          12255 => 16#7FE3#,   --  翣 (<CJK Ideograph>)
          12256 => 16#75E2#,   --  痢 (<CJK Ideograph>)
          12257 => 16#7ACB#,   --  立 (<CJK Ideograph>)
          12258 => 16#7C92#,   --  粒 (<CJK Ideograph>)
          12259 => 16#6CA5#,   --  沥 (<CJK Ideograph>)
          12260 => 16#96B6#,   --  隶 (<CJK Ideograph>)
          12261 => 16#529B#,   --  力 (<CJK Ideograph>)
          12262 => 16#7483#,   --  璃 (<CJK Ideograph>)
          12263 => 16#54E9#,   --  哩 (<CJK Ideograph>)
          12264 => 16#4FE9#,   --  俩 (<CJK Ideograph>)
          12265 => 16#8054#,   --  联 (<CJK Ideograph>)
          12266 => 16#83B2#,   --  莲 (<CJK Ideograph>)
          12267 => 16#8FDE#,   --  连 (<CJK Ideograph>)
          12268 => 16#9570#,   --  镰 (<CJK Ideograph>)
          12269 => 16#5EC9#,   --  廉 (<CJK Ideograph>)
          12270 => 16#601C#,   --  怜 (<CJK Ideograph>)
          12271 => 16#6D9F#,   --  涟 (<CJK Ideograph>)
          12272 => 16#5E18#,   --  帘 (<CJK Ideograph>)
          12273 => 16#655B#,   --  敛 (<CJK Ideograph>)
          12274 => 16#8138#,   --  脸 (<CJK Ideograph>)
          12275 => 16#94FE#,   --  链 (<CJK Ideograph>)
          12276 => 16#604B#,   --  恋 (<CJK Ideograph>)
          12277 => 16#70BC#,   --  炼 (<CJK Ideograph>)
          12278 => 16#7EC3#,   --  练 (<CJK Ideograph>)
          12279 => 16#7CAE#,   --  粮 (<CJK Ideograph>)
          12280 => 16#51C9#,   --  凉 (<CJK Ideograph>)
          12281 => 16#6881#,   --  梁 (<CJK Ideograph>)
          12282 => 16#7CB1#,   --  粱 (<CJK Ideograph>)
          12283 => 16#826F#,   --  良 (<CJK Ideograph>)
          12284 => 16#4E24#,   --  两 (<CJK Ideograph>)
          12285 => 16#8F86#,   --  辆 (<CJK Ideograph>)
          12286 => 16#91CF#,   --  量 (<CJK Ideograph>)
          12287 => 16#667E#,   --  晾 (<CJK Ideograph>)
          12288 => 16#4EAE#,   --  亮 (<CJK Ideograph>)
          12289 => 16#8C05#,   --  谅 (<CJK Ideograph>)
          12290 => 16#64A9#,   --  撩 (<CJK Ideograph>)
          12291 => 16#804A#,   --  聊 (<CJK Ideograph>)
          12292 => 16#50DA#,   --  僚 (<CJK Ideograph>)
          12293 => 16#7597#,   --  疗 (<CJK Ideograph>)
          12294 => 16#71CE#,   --  燎 (<CJK Ideograph>)
          12295 => 16#5BE5#,   --  寥 (<CJK Ideograph>)
          12296 => 16#8FBD#,   --  辽 (<CJK Ideograph>)
          12297 => 16#6F66#,   --  潦 (<CJK Ideograph>)
          12298 => 16#4E86#,   --  了 (<CJK Ideograph>)
          12299 => 16#6482#,   --  撂 (<CJK Ideograph>)
          12300 => 16#9563#,   --  镣 (<CJK Ideograph>)
          12301 => 16#5ED6#,   --  廖 (<CJK Ideograph>)
          12302 => 16#6599#,   --  料 (<CJK Ideograph>)
          12303 => 16#5217#,   --  列 (<CJK Ideograph>)
          12304 => 16#88C2#,   --  裂 (<CJK Ideograph>)
          12305 => 16#70C8#,   --  烈 (<CJK Ideograph>)
          12306 => 16#52A3#,   --  劣 (<CJK Ideograph>)
          12307 => 16#730E#,   --  猎 (<CJK Ideograph>)
          12308 => 16#7433#,   --  琳 (<CJK Ideograph>)
          12309 => 16#6797#,   --  林 (<CJK Ideograph>)
          12310 => 16#78F7#,   --  磷 (<CJK Ideograph>)
          12311 => 16#9716#,   --  霖 (<CJK Ideograph>)
          12312 => 16#4E34#,   --  临 (<CJK Ideograph>)
          12313 => 16#90BB#,   --  邻 (<CJK Ideograph>)
          12314 => 16#9CDE#,   --  鳞 (<CJK Ideograph>)
          12315 => 16#6DCB#,   --  淋 (<CJK Ideograph>)
          12316 => 16#51DB#,   --  凛 (<CJK Ideograph>)
          12317 => 16#8D41#,   --  赁 (<CJK Ideograph>)
          12318 => 16#541D#,   --  吝 (<CJK Ideograph>)
          12319 => 16#62CE#,   --  拎 (<CJK Ideograph>)
          12320 => 16#73B2#,   --  玲 (<CJK Ideograph>)
          12321 => 16#83F1#,   --  菱 (<CJK Ideograph>)
          12322 => 16#96F6#,   --  零 (<CJK Ideograph>)
          12323 => 16#9F84#,   --  龄 (<CJK Ideograph>)
          12324 => 16#94C3#,   --  铃 (<CJK Ideograph>)
          12325 => 16#4F36#,   --  伶 (<CJK Ideograph>)
          12326 => 16#7F9A#,   --  羚 (<CJK Ideograph>)
          12327 => 16#51CC#,   --  凌 (<CJK Ideograph>)
          12328 => 16#7075#,   --  灵 (<CJK Ideograph>)
          12329 => 16#9675#,   --  陵 (<CJK Ideograph>)
          12330 => 16#5CAD#,   --  岭 (<CJK Ideograph>)
          12331 => 16#9886#,   --  领 (<CJK Ideograph>)
          12332 => 16#53E6#,   --  另 (<CJK Ideograph>)
          12333 => 16#4EE4#,   --  令 (<CJK Ideograph>)
          12334 => 16#6E9C#,   --  溜 (<CJK Ideograph>)
          12335 => 16#7409#,   --  琉 (<CJK Ideograph>)
          12336 => 16#69B4#,   --  榴 (<CJK Ideograph>)
          12337 => 16#786B#,   --  硫 (<CJK Ideograph>)
          12338 => 16#998F#,   --  馏 (<CJK Ideograph>)
          12339 => 16#7559#,   --  留 (<CJK Ideograph>)
          12340 => 16#5218#,   --  刘 (<CJK Ideograph>)
          12341 => 16#7624#,   --  瘤 (<CJK Ideograph>)
          12342 => 16#6D41#,   --  流 (<CJK Ideograph>)
          12343 => 16#67F3#,   --  柳 (<CJK Ideograph>)
          12344 => 16#516D#,   --  六 (<CJK Ideograph>)
          12345 => 16#9F99#,   --  龙 (<CJK Ideograph>)
          12346 => 16#804B#,   --  聋 (<CJK Ideograph>)
          12347 => 16#5499#,   --  咙 (<CJK Ideograph>)
          12348 => 16#7B3C#,   --  笼 (<CJK Ideograph>)
          12349 => 16#7ABF#,   --  窿 (<CJK Ideograph>)
          12350 => 16#7FE4#,   --  翤 (<CJK Ideograph>)
          12351 => 16#7FE7#,   --  翧 (<CJK Ideograph>)
          12352 => 16#7FE8#,   --  翨 (<CJK Ideograph>)
          12353 => 16#7FEA#,   --  翪 (<CJK Ideograph>)
          12354 => 16#7FEB#,   --  翫 (<CJK Ideograph>)
          12355 => 16#7FEC#,   --  翬 (<CJK Ideograph>)
          12356 => 16#7FED#,   --  翭 (<CJK Ideograph>)
          12357 => 16#7FEF#,   --  翯 (<CJK Ideograph>)
          12358 => 16#7FF2#,   --  翲 (<CJK Ideograph>)
          12359 => 16#7FF4#,   --  翴 (<CJK Ideograph>)
          12360 => 16#7FF5#,   --  翵 (<CJK Ideograph>)
          12361 => 16#7FF6#,   --  翶 (<CJK Ideograph>)
          12362 => 16#7FF7#,   --  翷 (<CJK Ideograph>)
          12363 => 16#7FF8#,   --  翸 (<CJK Ideograph>)
          12364 => 16#7FF9#,   --  翹 (<CJK Ideograph>)
          12365 => 16#7FFA#,   --  翺 (<CJK Ideograph>)
          12366 => 16#7FFD#,   --  翽 (<CJK Ideograph>)
          12367 => 16#7FFE#,   --  翾 (<CJK Ideograph>)
          12368 => 16#7FFF#,   --  翿 (<CJK Ideograph>)
          12369 => 16#8002#,   --  耂 (<CJK Ideograph>)
          12370 => 16#8007#,   --  耇 (<CJK Ideograph>)
          12371 => 16#8008#,   --  耈 (<CJK Ideograph>)
          12372 => 16#8009#,   --  耉 (<CJK Ideograph>)
          12373 => 16#800A#,   --  耊 (<CJK Ideograph>)
          12374 => 16#800E#,   --  耎 (<CJK Ideograph>)
          12375 => 16#800F#,   --  耏 (<CJK Ideograph>)
          12376 => 16#8011#,   --  耑 (<CJK Ideograph>)
          12377 => 16#8013#,   --  耓 (<CJK Ideograph>)
          12378 => 16#801A#,   --  耚 (<CJK Ideograph>)
          12379 => 16#801B#,   --  耛 (<CJK Ideograph>)
          12380 => 16#801D#,   --  耝 (<CJK Ideograph>)
          12381 => 16#801E#,   --  耞 (<CJK Ideograph>)
          12382 => 16#801F#,   --  耟 (<CJK Ideograph>)
          12383 => 16#8021#,   --  耡 (<CJK Ideograph>)
          12384 => 16#8023#,   --  耣 (<CJK Ideograph>)
          12385 => 16#8024#,   --  耤 (<CJK Ideograph>)
          12386 => 16#802B#,   --  耫 (<CJK Ideograph>)
          12387 => 16#802C#,   --  耬 (<CJK Ideograph>)
          12388 => 16#802D#,   --  耭 (<CJK Ideograph>)
          12389 => 16#802E#,   --  耮 (<CJK Ideograph>)
          12390 => 16#802F#,   --  耯 (<CJK Ideograph>)
          12391 => 16#8030#,   --  耰 (<CJK Ideograph>)
          12392 => 16#8032#,   --  耲 (<CJK Ideograph>)
          12393 => 16#8034#,   --  耴 (<CJK Ideograph>)
          12394 => 16#8039#,   --  耹 (<CJK Ideograph>)
          12395 => 16#803A#,   --  耺 (<CJK Ideograph>)
          12396 => 16#803C#,   --  耼 (<CJK Ideograph>)
          12397 => 16#803E#,   --  耾 (<CJK Ideograph>)
          12398 => 16#8040#,   --  聀 (<CJK Ideograph>)
          12399 => 16#8041#,   --  聁 (<CJK Ideograph>)
          12400 => 16#8044#,   --  聄 (<CJK Ideograph>)
          12401 => 16#8045#,   --  聅 (<CJK Ideograph>)
          12402 => 16#8047#,   --  聇 (<CJK Ideograph>)
          12403 => 16#8048#,   --  聈 (<CJK Ideograph>)
          12404 => 16#8049#,   --  聉 (<CJK Ideograph>)
          12405 => 16#804E#,   --  聎 (<CJK Ideograph>)
          12406 => 16#804F#,   --  聏 (<CJK Ideograph>)
          12407 => 16#8050#,   --  聐 (<CJK Ideograph>)
          12408 => 16#8051#,   --  聑 (<CJK Ideograph>)
          12409 => 16#8053#,   --  聓 (<CJK Ideograph>)
          12410 => 16#8055#,   --  聕 (<CJK Ideograph>)
          12411 => 16#8056#,   --  聖 (<CJK Ideograph>)
          12412 => 16#8057#,   --  聗 (<CJK Ideograph>)
          12413 => 16#8059#,   --  聙 (<CJK Ideograph>)
          12414 => 16#805B#,   --  聛 (<CJK Ideograph>)
          12415 => 16#805C#,   --  聜 (<CJK Ideograph>)
          12416 => 16#805D#,   --  聝 (<CJK Ideograph>)
          12417 => 16#805E#,   --  聞 (<CJK Ideograph>)
          12418 => 16#805F#,   --  聟 (<CJK Ideograph>)
          12419 => 16#8060#,   --  聠 (<CJK Ideograph>)
          12420 => 16#8061#,   --  聡 (<CJK Ideograph>)
          12421 => 16#8062#,   --  聢 (<CJK Ideograph>)
          12422 => 16#8063#,   --  聣 (<CJK Ideograph>)
          12423 => 16#8064#,   --  聤 (<CJK Ideograph>)
          12424 => 16#8065#,   --  聥 (<CJK Ideograph>)
          12425 => 16#8066#,   --  聦 (<CJK Ideograph>)
          12426 => 16#8067#,   --  聧 (<CJK Ideograph>)
          12427 => 16#8068#,   --  聨 (<CJK Ideograph>)
          12428 => 16#806B#,   --  聫 (<CJK Ideograph>)
          12429 => 16#806C#,   --  聬 (<CJK Ideograph>)
          12430 => 16#806D#,   --  聭 (<CJK Ideograph>)
          12431 => 16#806E#,   --  聮 (<CJK Ideograph>)
          12432 => 16#806F#,   --  聯 (<CJK Ideograph>)
          12433 => 16#8070#,   --  聰 (<CJK Ideograph>)
          12434 => 16#8072#,   --  聲 (<CJK Ideograph>)
          12435 => 16#8073#,   --  聳 (<CJK Ideograph>)
          12436 => 16#8074#,   --  聴 (<CJK Ideograph>)
          12437 => 16#8075#,   --  聵 (<CJK Ideograph>)
          12438 => 16#8076#,   --  聶 (<CJK Ideograph>)
          12439 => 16#8077#,   --  職 (<CJK Ideograph>)
          12440 => 16#8078#,   --  聸 (<CJK Ideograph>)
          12441 => 16#8079#,   --  聹 (<CJK Ideograph>)
          12442 => 16#807A#,   --  聺 (<CJK Ideograph>)
          12443 => 16#807B#,   --  聻 (<CJK Ideograph>)
          12444 => 16#807C#,   --  聼 (<CJK Ideograph>)
          12445 => 16#807D#,   --  聽 (<CJK Ideograph>)
          12446 => 16#9686#,   --  隆 (<CJK Ideograph>)
          12447 => 16#5784#,   --  垄 (<CJK Ideograph>)
          12448 => 16#62E2#,   --  拢 (<CJK Ideograph>)
          12449 => 16#9647#,   --  陇 (<CJK Ideograph>)
          12450 => 16#697C#,   --  楼 (<CJK Ideograph>)
          12451 => 16#5A04#,   --  娄 (<CJK Ideograph>)
          12452 => 16#6402#,   --  搂 (<CJK Ideograph>)
          12453 => 16#7BD3#,   --  篓 (<CJK Ideograph>)
          12454 => 16#6F0F#,   --  漏 (<CJK Ideograph>)
          12455 => 16#964B#,   --  陋 (<CJK Ideograph>)
          12456 => 16#82A6#,   --  芦 (<CJK Ideograph>)
          12457 => 16#5362#,   --  卢 (<CJK Ideograph>)
          12458 => 16#9885#,   --  颅 (<CJK Ideograph>)
          12459 => 16#5E90#,   --  庐 (<CJK Ideograph>)
          12460 => 16#7089#,   --  炉 (<CJK Ideograph>)
          12461 => 16#63B3#,   --  掳 (<CJK Ideograph>)
          12462 => 16#5364#,   --  卤 (<CJK Ideograph>)
          12463 => 16#864F#,   --  虏 (<CJK Ideograph>)
          12464 => 16#9C81#,   --  鲁 (<CJK Ideograph>)
          12465 => 16#9E93#,   --  麓 (<CJK Ideograph>)
          12466 => 16#788C#,   --  碌 (<CJK Ideograph>)
          12467 => 16#9732#,   --  露 (<CJK Ideograph>)
          12468 => 16#8DEF#,   --  路 (<CJK Ideograph>)
          12469 => 16#8D42#,   --  赂 (<CJK Ideograph>)
          12470 => 16#9E7F#,   --  鹿 (<CJK Ideograph>)
          12471 => 16#6F5E#,   --  潞 (<CJK Ideograph>)
          12472 => 16#7984#,   --  禄 (<CJK Ideograph>)
          12473 => 16#5F55#,   --  录 (<CJK Ideograph>)
          12474 => 16#9646#,   --  陆 (<CJK Ideograph>)
          12475 => 16#622E#,   --  戮 (<CJK Ideograph>)
          12476 => 16#9A74#,   --  驴 (<CJK Ideograph>)
          12477 => 16#5415#,   --  吕 (<CJK Ideograph>)
          12478 => 16#94DD#,   --  铝 (<CJK Ideograph>)
          12479 => 16#4FA3#,   --  侣 (<CJK Ideograph>)
          12480 => 16#65C5#,   --  旅 (<CJK Ideograph>)
          12481 => 16#5C65#,   --  履 (<CJK Ideograph>)
          12482 => 16#5C61#,   --  屡 (<CJK Ideograph>)
          12483 => 16#7F15#,   --  缕 (<CJK Ideograph>)
          12484 => 16#8651#,   --  虑 (<CJK Ideograph>)
          12485 => 16#6C2F#,   --  氯 (<CJK Ideograph>)
          12486 => 16#5F8B#,   --  律 (<CJK Ideograph>)
          12487 => 16#7387#,   --  率 (<CJK Ideograph>)
          12488 => 16#6EE4#,   --  滤 (<CJK Ideograph>)
          12489 => 16#7EFF#,   --  绿 (<CJK Ideograph>)
          12490 => 16#5CE6#,   --  峦 (<CJK Ideograph>)
          12491 => 16#631B#,   --  挛 (<CJK Ideograph>)
          12492 => 16#5B6A#,   --  孪 (<CJK Ideograph>)
          12493 => 16#6EE6#,   --  滦 (<CJK Ideograph>)
          12494 => 16#5375#,   --  卵 (<CJK Ideograph>)
          12495 => 16#4E71#,   --  乱 (<CJK Ideograph>)
          12496 => 16#63A0#,   --  掠 (<CJK Ideograph>)
          12497 => 16#7565#,   --  略 (<CJK Ideograph>)
          12498 => 16#62A1#,   --  抡 (<CJK Ideograph>)
          12499 => 16#8F6E#,   --  轮 (<CJK Ideograph>)
          12500 => 16#4F26#,   --  伦 (<CJK Ideograph>)
          12501 => 16#4ED1#,   --  仑 (<CJK Ideograph>)
          12502 => 16#6CA6#,   --  沦 (<CJK Ideograph>)
          12503 => 16#7EB6#,   --  纶 (<CJK Ideograph>)
          12504 => 16#8BBA#,   --  论 (<CJK Ideograph>)
          12505 => 16#841D#,   --  萝 (<CJK Ideograph>)
          12506 => 16#87BA#,   --  螺 (<CJK Ideograph>)
          12507 => 16#7F57#,   --  罗 (<CJK Ideograph>)
          12508 => 16#903B#,   --  逻 (<CJK Ideograph>)
          12509 => 16#9523#,   --  锣 (<CJK Ideograph>)
          12510 => 16#7BA9#,   --  箩 (<CJK Ideograph>)
          12511 => 16#9AA1#,   --  骡 (<CJK Ideograph>)
          12512 => 16#88F8#,   --  裸 (<CJK Ideograph>)
          12513 => 16#843D#,   --  落 (<CJK Ideograph>)
          12514 => 16#6D1B#,   --  洛 (<CJK Ideograph>)
          12515 => 16#9A86#,   --  骆 (<CJK Ideograph>)
          12516 => 16#7EDC#,   --  络 (<CJK Ideograph>)
          12517 => 16#5988#,   --  妈 (<CJK Ideograph>)
          12518 => 16#9EBB#,   --  麻 (<CJK Ideograph>)
          12519 => 16#739B#,   --  玛 (<CJK Ideograph>)
          12520 => 16#7801#,   --  码 (<CJK Ideograph>)
          12521 => 16#8682#,   --  蚂 (<CJK Ideograph>)
          12522 => 16#9A6C#,   --  马 (<CJK Ideograph>)
          12523 => 16#9A82#,   --  骂 (<CJK Ideograph>)
          12524 => 16#561B#,   --  嘛 (<CJK Ideograph>)
          12525 => 16#5417#,   --  吗 (<CJK Ideograph>)
          12526 => 16#57CB#,   --  埋 (<CJK Ideograph>)
          12527 => 16#4E70#,   --  买 (<CJK Ideograph>)
          12528 => 16#9EA6#,   --  麦 (<CJK Ideograph>)
          12529 => 16#5356#,   --  卖 (<CJK Ideograph>)
          12530 => 16#8FC8#,   --  迈 (<CJK Ideograph>)
          12531 => 16#8109#,   --  脉 (<CJK Ideograph>)
          12532 => 16#7792#,   --  瞒 (<CJK Ideograph>)
          12533 => 16#9992#,   --  馒 (<CJK Ideograph>)
          12534 => 16#86EE#,   --  蛮 (<CJK Ideograph>)
          12535 => 16#6EE1#,   --  满 (<CJK Ideograph>)
          12536 => 16#8513#,   --  蔓 (<CJK Ideograph>)
          12537 => 16#66FC#,   --  曼 (<CJK Ideograph>)
          12538 => 16#6162#,   --  慢 (<CJK Ideograph>)
          12539 => 16#6F2B#,   --  漫 (<CJK Ideograph>)
          12540 => 16#807E#,   --  聾 (<CJK Ideograph>)
          12541 => 16#8081#,   --  肁 (<CJK Ideograph>)
          12542 => 16#8082#,   --  肂 (<CJK Ideograph>)
          12543 => 16#8085#,   --  肅 (<CJK Ideograph>)
          12544 => 16#8088#,   --  肈 (<CJK Ideograph>)
          12545 => 16#808A#,   --  肊 (<CJK Ideograph>)
          12546 => 16#808D#,   --  肍 (<CJK Ideograph>)
          12547 => 16#808E#,   --  肎 (<CJK Ideograph>)
          12548 => 16#808F#,   --  肏 (<CJK Ideograph>)
          12549 => 16#8090#,   --  肐 (<CJK Ideograph>)
          12550 => 16#8091#,   --  肑 (<CJK Ideograph>)
          12551 => 16#8092#,   --  肒 (<CJK Ideograph>)
          12552 => 16#8094#,   --  肔 (<CJK Ideograph>)
          12553 => 16#8095#,   --  肕 (<CJK Ideograph>)
          12554 => 16#8097#,   --  肗 (<CJK Ideograph>)
          12555 => 16#8099#,   --  肙 (<CJK Ideograph>)
          12556 => 16#809E#,   --  肞 (<CJK Ideograph>)
          12557 => 16#80A3#,   --  肣 (<CJK Ideograph>)
          12558 => 16#80A6#,   --  肦 (<CJK Ideograph>)
          12559 => 16#80A7#,   --  肧 (<CJK Ideograph>)
          12560 => 16#80A8#,   --  肨 (<CJK Ideograph>)
          12561 => 16#80AC#,   --  肬 (<CJK Ideograph>)
          12562 => 16#80B0#,   --  肰 (<CJK Ideograph>)
          12563 => 16#80B3#,   --  肳 (<CJK Ideograph>)
          12564 => 16#80B5#,   --  肵 (<CJK Ideograph>)
          12565 => 16#80B6#,   --  肶 (<CJK Ideograph>)
          12566 => 16#80B8#,   --  肸 (<CJK Ideograph>)
          12567 => 16#80B9#,   --  肹 (<CJK Ideograph>)
          12568 => 16#80BB#,   --  肻 (<CJK Ideograph>)
          12569 => 16#80C5#,   --  胅 (<CJK Ideograph>)
          12570 => 16#80C7#,   --  胇 (<CJK Ideograph>)
          12571 => 16#80C8#,   --  胈 (<CJK Ideograph>)
          12572 => 16#80C9#,   --  胉 (<CJK Ideograph>)
          12573 => 16#80CA#,   --  胊 (<CJK Ideograph>)
          12574 => 16#80CB#,   --  胋 (<CJK Ideograph>)
          12575 => 16#80CF#,   --  胏 (<CJK Ideograph>)
          12576 => 16#80D0#,   --  胐 (<CJK Ideograph>)
          12577 => 16#80D1#,   --  胑 (<CJK Ideograph>)
          12578 => 16#80D2#,   --  胒 (<CJK Ideograph>)
          12579 => 16#80D3#,   --  胓 (<CJK Ideograph>)
          12580 => 16#80D4#,   --  胔 (<CJK Ideograph>)
          12581 => 16#80D5#,   --  胕 (<CJK Ideograph>)
          12582 => 16#80D8#,   --  胘 (<CJK Ideograph>)
          12583 => 16#80DF#,   --  胟 (<CJK Ideograph>)
          12584 => 16#80E0#,   --  胠 (<CJK Ideograph>)
          12585 => 16#80E2#,   --  胢 (<CJK Ideograph>)
          12586 => 16#80E3#,   --  胣 (<CJK Ideograph>)
          12587 => 16#80E6#,   --  胦 (<CJK Ideograph>)
          12588 => 16#80EE#,   --  胮 (<CJK Ideograph>)
          12589 => 16#80F5#,   --  胵 (<CJK Ideograph>)
          12590 => 16#80F7#,   --  胷 (<CJK Ideograph>)
          12591 => 16#80F9#,   --  胹 (<CJK Ideograph>)
          12592 => 16#80FB#,   --  胻 (<CJK Ideograph>)
          12593 => 16#80FE#,   --  胾 (<CJK Ideograph>)
          12594 => 16#80FF#,   --  胿 (<CJK Ideograph>)
          12595 => 16#8100#,   --  脀 (<CJK Ideograph>)
          12596 => 16#8101#,   --  脁 (<CJK Ideograph>)
          12597 => 16#8103#,   --  脃 (<CJK Ideograph>)
          12598 => 16#8104#,   --  脄 (<CJK Ideograph>)
          12599 => 16#8105#,   --  脅 (<CJK Ideograph>)
          12600 => 16#8107#,   --  脇 (<CJK Ideograph>)
          12601 => 16#8108#,   --  脈 (<CJK Ideograph>)
          12602 => 16#810B#,   --  脋 (<CJK Ideograph>)
          12603 => 16#810C#,   --  脌 (<CJK Ideograph>)
          12604 => 16#8115#,   --  脕 (<CJK Ideograph>)
          12605 => 16#8117#,   --  脗 (<CJK Ideograph>)
          12606 => 16#8119#,   --  脙 (<CJK Ideograph>)
          12607 => 16#811B#,   --  脛 (<CJK Ideograph>)
          12608 => 16#811C#,   --  脜 (<CJK Ideograph>)
          12609 => 16#811D#,   --  脝 (<CJK Ideograph>)
          12610 => 16#811F#,   --  脟 (<CJK Ideograph>)
          12611 => 16#8120#,   --  脠 (<CJK Ideograph>)
          12612 => 16#8121#,   --  脡 (<CJK Ideograph>)
          12613 => 16#8122#,   --  脢 (<CJK Ideograph>)
          12614 => 16#8123#,   --  脣 (<CJK Ideograph>)
          12615 => 16#8124#,   --  脤 (<CJK Ideograph>)
          12616 => 16#8125#,   --  脥 (<CJK Ideograph>)
          12617 => 16#8126#,   --  脦 (<CJK Ideograph>)
          12618 => 16#8127#,   --  脧 (<CJK Ideograph>)
          12619 => 16#8128#,   --  脨 (<CJK Ideograph>)
          12620 => 16#8129#,   --  脩 (<CJK Ideograph>)
          12621 => 16#812A#,   --  脪 (<CJK Ideograph>)
          12622 => 16#812B#,   --  脫 (<CJK Ideograph>)
          12623 => 16#812D#,   --  脭 (<CJK Ideograph>)
          12624 => 16#812E#,   --  脮 (<CJK Ideograph>)
          12625 => 16#8130#,   --  脰 (<CJK Ideograph>)
          12626 => 16#8133#,   --  脳 (<CJK Ideograph>)
          12627 => 16#8134#,   --  脴 (<CJK Ideograph>)
          12628 => 16#8135#,   --  脵 (<CJK Ideograph>)
          12629 => 16#8137#,   --  脷 (<CJK Ideograph>)
          12630 => 16#8139#,   --  脹 (<CJK Ideograph>)
          12631 => 16#813A#,   --  脺 (<CJK Ideograph>)
          12632 => 16#813B#,   --  脻 (<CJK Ideograph>)
          12633 => 16#813C#,   --  脼 (<CJK Ideograph>)
          12634 => 16#813D#,   --  脽 (<CJK Ideograph>)
          12635 => 16#813F#,   --  脿 (<CJK Ideograph>)
          12636 => 16#8C29#,   --  谩 (<CJK Ideograph>)
          12637 => 16#8292#,   --  芒 (<CJK Ideograph>)
          12638 => 16#832B#,   --  茫 (<CJK Ideograph>)
          12639 => 16#76F2#,   --  盲 (<CJK Ideograph>)
          12640 => 16#6C13#,   --  氓 (<CJK Ideograph>)
          12641 => 16#5FD9#,   --  忙 (<CJK Ideograph>)
          12642 => 16#83BD#,   --  莽 (<CJK Ideograph>)
          12643 => 16#732B#,   --  猫 (<CJK Ideograph>)
          12644 => 16#8305#,   --  茅 (<CJK Ideograph>)
          12645 => 16#951A#,   --  锚 (<CJK Ideograph>)
          12646 => 16#6BDB#,   --  毛 (<CJK Ideograph>)
          12647 => 16#77DB#,   --  矛 (<CJK Ideograph>)
          12648 => 16#94C6#,   --  铆 (<CJK Ideograph>)
          12649 => 16#536F#,   --  卯 (<CJK Ideograph>)
          12650 => 16#8302#,   --  茂 (<CJK Ideograph>)
          12651 => 16#5192#,   --  冒 (<CJK Ideograph>)
          12652 => 16#5E3D#,   --  帽 (<CJK Ideograph>)
          12653 => 16#8C8C#,   --  貌 (<CJK Ideograph>)
          12654 => 16#8D38#,   --  贸 (<CJK Ideograph>)
          12655 => 16#4E48#,   --  么 (<CJK Ideograph>)
          12656 => 16#73AB#,   --  玫 (<CJK Ideograph>)
          12657 => 16#679A#,   --  枚 (<CJK Ideograph>)
          12658 => 16#6885#,   --  梅 (<CJK Ideograph>)
          12659 => 16#9176#,   --  酶 (<CJK Ideograph>)
          12660 => 16#9709#,   --  霉 (<CJK Ideograph>)
          12661 => 16#7164#,   --  煤 (<CJK Ideograph>)
          12662 => 16#6CA1#,   --  没 (<CJK Ideograph>)
          12663 => 16#7709#,   --  眉 (<CJK Ideograph>)
          12664 => 16#5A92#,   --  媒 (<CJK Ideograph>)
          12665 => 16#9541#,   --  镁 (<CJK Ideograph>)
          12666 => 16#6BCF#,   --  每 (<CJK Ideograph>)
          12667 => 16#7F8E#,   --  美 (<CJK Ideograph>)
          12668 => 16#6627#,   --  昧 (<CJK Ideograph>)
          12669 => 16#5BD0#,   --  寐 (<CJK Ideograph>)
          12670 => 16#59B9#,   --  妹 (<CJK Ideograph>)
          12671 => 16#5A9A#,   --  媚 (<CJK Ideograph>)
          12672 => 16#95E8#,   --  门 (<CJK Ideograph>)
          12673 => 16#95F7#,   --  闷 (<CJK Ideograph>)
          12674 => 16#4EEC#,   --  们 (<CJK Ideograph>)
          12675 => 16#840C#,   --  萌 (<CJK Ideograph>)
          12676 => 16#8499#,   --  蒙 (<CJK Ideograph>)
          12677 => 16#6AAC#,   --  檬 (<CJK Ideograph>)
          12678 => 16#76DF#,   --  盟 (<CJK Ideograph>)
          12679 => 16#9530#,   --  锰 (<CJK Ideograph>)
          12680 => 16#731B#,   --  猛 (<CJK Ideograph>)
          12681 => 16#68A6#,   --  梦 (<CJK Ideograph>)
          12682 => 16#5B5F#,   --  孟 (<CJK Ideograph>)
          12683 => 16#772F#,   --  眯 (<CJK Ideograph>)
          12684 => 16#919A#,   --  醚 (<CJK Ideograph>)
          12685 => 16#9761#,   --  靡 (<CJK Ideograph>)
          12686 => 16#7CDC#,   --  糜 (<CJK Ideograph>)
          12687 => 16#8FF7#,   --  迷 (<CJK Ideograph>)
          12688 => 16#8C1C#,   --  谜 (<CJK Ideograph>)
          12689 => 16#5F25#,   --  弥 (<CJK Ideograph>)
          12690 => 16#7C73#,   --  米 (<CJK Ideograph>)
          12691 => 16#79D8#,   --  秘 (<CJK Ideograph>)
          12692 => 16#89C5#,   --  觅 (<CJK Ideograph>)
          12693 => 16#6CCC#,   --  泌 (<CJK Ideograph>)
          12694 => 16#871C#,   --  蜜 (<CJK Ideograph>)
          12695 => 16#5BC6#,   --  密 (<CJK Ideograph>)
          12696 => 16#5E42#,   --  幂 (<CJK Ideograph>)
          12697 => 16#68C9#,   --  棉 (<CJK Ideograph>)
          12698 => 16#7720#,   --  眠 (<CJK Ideograph>)
          12699 => 16#7EF5#,   --  绵 (<CJK Ideograph>)
          12700 => 16#5195#,   --  冕 (<CJK Ideograph>)
          12701 => 16#514D#,   --  免 (<CJK Ideograph>)
          12702 => 16#52C9#,   --  勉 (<CJK Ideograph>)
          12703 => 16#5A29#,   --  娩 (<CJK Ideograph>)
          12704 => 16#7F05#,   --  缅 (<CJK Ideograph>)
          12705 => 16#9762#,   --  面 (<CJK Ideograph>)
          12706 => 16#82D7#,   --  苗 (<CJK Ideograph>)
          12707 => 16#63CF#,   --  描 (<CJK Ideograph>)
          12708 => 16#7784#,   --  瞄 (<CJK Ideograph>)
          12709 => 16#85D0#,   --  藐 (<CJK Ideograph>)
          12710 => 16#79D2#,   --  秒 (<CJK Ideograph>)
          12711 => 16#6E3A#,   --  渺 (<CJK Ideograph>)
          12712 => 16#5E99#,   --  庙 (<CJK Ideograph>)
          12713 => 16#5999#,   --  妙 (<CJK Ideograph>)
          12714 => 16#8511#,   --  蔑 (<CJK Ideograph>)
          12715 => 16#706D#,   --  灭 (<CJK Ideograph>)
          12716 => 16#6C11#,   --  民 (<CJK Ideograph>)
          12717 => 16#62BF#,   --  抿 (<CJK Ideograph>)
          12718 => 16#76BF#,   --  皿 (<CJK Ideograph>)
          12719 => 16#654F#,   --  敏 (<CJK Ideograph>)
          12720 => 16#60AF#,   --  悯 (<CJK Ideograph>)
          12721 => 16#95FD#,   --  闽 (<CJK Ideograph>)
          12722 => 16#660E#,   --  明 (<CJK Ideograph>)
          12723 => 16#879F#,   --  螟 (<CJK Ideograph>)
          12724 => 16#9E23#,   --  鸣 (<CJK Ideograph>)
          12725 => 16#94ED#,   --  铭 (<CJK Ideograph>)
          12726 => 16#540D#,   --  名 (<CJK Ideograph>)
          12727 => 16#547D#,   --  命 (<CJK Ideograph>)
          12728 => 16#8C2C#,   --  谬 (<CJK Ideograph>)
          12729 => 16#6478#,   --  摸 (<CJK Ideograph>)
          12730 => 16#8140#,   --  腀 (<CJK Ideograph>)
          12731 => 16#8141#,   --  腁 (<CJK Ideograph>)
          12732 => 16#8142#,   --  腂 (<CJK Ideograph>)
          12733 => 16#8143#,   --  腃 (<CJK Ideograph>)
          12734 => 16#8144#,   --  腄 (<CJK Ideograph>)
          12735 => 16#8145#,   --  腅 (<CJK Ideograph>)
          12736 => 16#8147#,   --  腇 (<CJK Ideograph>)
          12737 => 16#8149#,   --  腉 (<CJK Ideograph>)
          12738 => 16#814D#,   --  腍 (<CJK Ideograph>)
          12739 => 16#814E#,   --  腎 (<CJK Ideograph>)
          12740 => 16#814F#,   --  腏 (<CJK Ideograph>)
          12741 => 16#8152#,   --  腒 (<CJK Ideograph>)
          12742 => 16#8156#,   --  腖 (<CJK Ideograph>)
          12743 => 16#8157#,   --  腗 (<CJK Ideograph>)
          12744 => 16#8158#,   --  腘 (<CJK Ideograph>)
          12745 => 16#815B#,   --  腛 (<CJK Ideograph>)
          12746 => 16#815C#,   --  腜 (<CJK Ideograph>)
          12747 => 16#815D#,   --  腝 (<CJK Ideograph>)
          12748 => 16#815E#,   --  腞 (<CJK Ideograph>)
          12749 => 16#815F#,   --  腟 (<CJK Ideograph>)
          12750 => 16#8161#,   --  腡 (<CJK Ideograph>)
          12751 => 16#8162#,   --  腢 (<CJK Ideograph>)
          12752 => 16#8163#,   --  腣 (<CJK Ideograph>)
          12753 => 16#8164#,   --  腤 (<CJK Ideograph>)
          12754 => 16#8166#,   --  腦 (<CJK Ideograph>)
          12755 => 16#8168#,   --  腨 (<CJK Ideograph>)
          12756 => 16#816A#,   --  腪 (<CJK Ideograph>)
          12757 => 16#816B#,   --  腫 (<CJK Ideograph>)
          12758 => 16#816C#,   --  腬 (<CJK Ideograph>)
          12759 => 16#816F#,   --  腯 (<CJK Ideograph>)
          12760 => 16#8172#,   --  腲 (<CJK Ideograph>)
          12761 => 16#8173#,   --  腳 (<CJK Ideograph>)
          12762 => 16#8175#,   --  腵 (<CJK Ideograph>)
          12763 => 16#8176#,   --  腶 (<CJK Ideograph>)
          12764 => 16#8177#,   --  腷 (<CJK Ideograph>)
          12765 => 16#8178#,   --  腸 (<CJK Ideograph>)
          12766 => 16#8181#,   --  膁 (<CJK Ideograph>)
          12767 => 16#8183#,   --  膃 (<CJK Ideograph>)
          12768 => 16#8184#,   --  膄 (<CJK Ideograph>)
          12769 => 16#8185#,   --  膅 (<CJK Ideograph>)
          12770 => 16#8186#,   --  膆 (<CJK Ideograph>)
          12771 => 16#8187#,   --  膇 (<CJK Ideograph>)
          12772 => 16#8189#,   --  膉 (<CJK Ideograph>)
          12773 => 16#818B#,   --  膋 (<CJK Ideograph>)
          12774 => 16#818C#,   --  膌 (<CJK Ideograph>)
          12775 => 16#818D#,   --  膍 (<CJK Ideograph>)
          12776 => 16#818E#,   --  膎 (<CJK Ideograph>)
          12777 => 16#8190#,   --  膐 (<CJK Ideograph>)
          12778 => 16#8192#,   --  膒 (<CJK Ideograph>)
          12779 => 16#8193#,   --  膓 (<CJK Ideograph>)
          12780 => 16#8194#,   --  膔 (<CJK Ideograph>)
          12781 => 16#8195#,   --  膕 (<CJK Ideograph>)
          12782 => 16#8196#,   --  膖 (<CJK Ideograph>)
          12783 => 16#8197#,   --  膗 (<CJK Ideograph>)
          12784 => 16#8199#,   --  膙 (<CJK Ideograph>)
          12785 => 16#819A#,   --  膚 (<CJK Ideograph>)
          12786 => 16#819E#,   --  膞 (<CJK Ideograph>)
          12787 => 16#819F#,   --  膟 (<CJK Ideograph>)
          12788 => 16#81A0#,   --  膠 (<CJK Ideograph>)
          12789 => 16#81A1#,   --  膡 (<CJK Ideograph>)
          12790 => 16#81A2#,   --  膢 (<CJK Ideograph>)
          12791 => 16#81A4#,   --  膤 (<CJK Ideograph>)
          12792 => 16#81A5#,   --  膥 (<CJK Ideograph>)
          12793 => 16#81A7#,   --  膧 (<CJK Ideograph>)
          12794 => 16#81A9#,   --  膩 (<CJK Ideograph>)
          12795 => 16#81AB#,   --  膫 (<CJK Ideograph>)
          12796 => 16#81AC#,   --  膬 (<CJK Ideograph>)
          12797 => 16#81AD#,   --  膭 (<CJK Ideograph>)
          12798 => 16#81AE#,   --  膮 (<CJK Ideograph>)
          12799 => 16#81AF#,   --  膯 (<CJK Ideograph>)
          12800 => 16#81B0#,   --  膰 (<CJK Ideograph>)
          12801 => 16#81B1#,   --  膱 (<CJK Ideograph>)
          12802 => 16#81B2#,   --  膲 (<CJK Ideograph>)
          12803 => 16#81B4#,   --  膴 (<CJK Ideograph>)
          12804 => 16#81B5#,   --  膵 (<CJK Ideograph>)
          12805 => 16#81B6#,   --  膶 (<CJK Ideograph>)
          12806 => 16#81B7#,   --  膷 (<CJK Ideograph>)
          12807 => 16#81B8#,   --  膸 (<CJK Ideograph>)
          12808 => 16#81B9#,   --  膹 (<CJK Ideograph>)
          12809 => 16#81BC#,   --  膼 (<CJK Ideograph>)
          12810 => 16#81BD#,   --  膽 (<CJK Ideograph>)
          12811 => 16#81BE#,   --  膾 (<CJK Ideograph>)
          12812 => 16#81BF#,   --  膿 (<CJK Ideograph>)
          12813 => 16#81C4#,   --  臄 (<CJK Ideograph>)
          12814 => 16#81C5#,   --  臅 (<CJK Ideograph>)
          12815 => 16#81C7#,   --  臇 (<CJK Ideograph>)
          12816 => 16#81C8#,   --  臈 (<CJK Ideograph>)
          12817 => 16#81C9#,   --  臉 (<CJK Ideograph>)
          12818 => 16#81CB#,   --  臋 (<CJK Ideograph>)
          12819 => 16#81CD#,   --  臍 (<CJK Ideograph>)
          12820 => 16#81CE#,   --  臎 (<CJK Ideograph>)
          12821 => 16#81CF#,   --  臏 (<CJK Ideograph>)
          12822 => 16#81D0#,   --  臐 (<CJK Ideograph>)
          12823 => 16#81D1#,   --  臑 (<CJK Ideograph>)
          12824 => 16#81D2#,   --  臒 (<CJK Ideograph>)
          12825 => 16#81D3#,   --  臓 (<CJK Ideograph>)
          12826 => 16#6479#,   --  摹 (<CJK Ideograph>)
          12827 => 16#8611#,   --  蘑 (<CJK Ideograph>)
          12828 => 16#6A21#,   --  模 (<CJK Ideograph>)
          12829 => 16#819C#,   --  膜 (<CJK Ideograph>)
          12830 => 16#78E8#,   --  磨 (<CJK Ideograph>)
          12831 => 16#6469#,   --  摩 (<CJK Ideograph>)
          12832 => 16#9B54#,   --  魔 (<CJK Ideograph>)
          12833 => 16#62B9#,   --  抹 (<CJK Ideograph>)
          12834 => 16#672B#,   --  末 (<CJK Ideograph>)
          12835 => 16#83AB#,   --  莫 (<CJK Ideograph>)
          12836 => 16#58A8#,   --  墨 (<CJK Ideograph>)
          12837 => 16#9ED8#,   --  默 (<CJK Ideograph>)
          12838 => 16#6CAB#,   --  沫 (<CJK Ideograph>)
          12839 => 16#6F20#,   --  漠 (<CJK Ideograph>)
          12840 => 16#5BDE#,   --  寞 (<CJK Ideograph>)
          12841 => 16#964C#,   --  陌 (<CJK Ideograph>)
          12842 => 16#8C0B#,   --  谋 (<CJK Ideograph>)
          12843 => 16#725F#,   --  牟 (<CJK Ideograph>)
          12844 => 16#67D0#,   --  某 (<CJK Ideograph>)
          12845 => 16#62C7#,   --  拇 (<CJK Ideograph>)
          12846 => 16#7261#,   --  牡 (<CJK Ideograph>)
          12847 => 16#4EA9#,   --  亩 (<CJK Ideograph>)
          12848 => 16#59C6#,   --  姆 (<CJK Ideograph>)
          12849 => 16#6BCD#,   --  母 (<CJK Ideograph>)
          12850 => 16#5893#,   --  墓 (<CJK Ideograph>)
          12851 => 16#66AE#,   --  暮 (<CJK Ideograph>)
          12852 => 16#5E55#,   --  幕 (<CJK Ideograph>)
          12853 => 16#52DF#,   --  募 (<CJK Ideograph>)
          12854 => 16#6155#,   --  慕 (<CJK Ideograph>)
          12855 => 16#6728#,   --  木 (<CJK Ideograph>)
          12856 => 16#76EE#,   --  目 (<CJK Ideograph>)
          12857 => 16#7766#,   --  睦 (<CJK Ideograph>)
          12858 => 16#7267#,   --  牧 (<CJK Ideograph>)
          12859 => 16#7A46#,   --  穆 (<CJK Ideograph>)
          12860 => 16#62FF#,   --  拿 (<CJK Ideograph>)
          12861 => 16#54EA#,   --  哪 (<CJK Ideograph>)
          12862 => 16#5450#,   --  呐 (<CJK Ideograph>)
          12863 => 16#94A0#,   --  钠 (<CJK Ideograph>)
          12864 => 16#90A3#,   --  那 (<CJK Ideograph>)
          12865 => 16#5A1C#,   --  娜 (<CJK Ideograph>)
          12866 => 16#7EB3#,   --  纳 (<CJK Ideograph>)
          12867 => 16#6C16#,   --  氖 (<CJK Ideograph>)
          12868 => 16#4E43#,   --  乃 (<CJK Ideograph>)
          12869 => 16#5976#,   --  奶 (<CJK Ideograph>)
          12870 => 16#8010#,   --  耐 (<CJK Ideograph>)
          12871 => 16#5948#,   --  奈 (<CJK Ideograph>)
          12872 => 16#5357#,   --  南 (<CJK Ideograph>)
          12873 => 16#7537#,   --  男 (<CJK Ideograph>)
          12874 => 16#96BE#,   --  难 (<CJK Ideograph>)
          12875 => 16#56CA#,   --  囊 (<CJK Ideograph>)
          12876 => 16#6320#,   --  挠 (<CJK Ideograph>)
          12877 => 16#8111#,   --  脑 (<CJK Ideograph>)
          12878 => 16#607C#,   --  恼 (<CJK Ideograph>)
          12879 => 16#95F9#,   --  闹 (<CJK Ideograph>)
          12880 => 16#6DD6#,   --  淖 (<CJK Ideograph>)
          12881 => 16#5462#,   --  呢 (<CJK Ideograph>)
          12882 => 16#9981#,   --  馁 (<CJK Ideograph>)
          12883 => 16#5185#,   --  内 (<CJK Ideograph>)
          12884 => 16#5AE9#,   --  嫩 (<CJK Ideograph>)
          12885 => 16#80FD#,   --  能 (<CJK Ideograph>)
          12886 => 16#59AE#,   --  妮 (<CJK Ideograph>)
          12887 => 16#9713#,   --  霓 (<CJK Ideograph>)
          12888 => 16#502A#,   --  倪 (<CJK Ideograph>)
          12889 => 16#6CE5#,   --  泥 (<CJK Ideograph>)
          12890 => 16#5C3C#,   --  尼 (<CJK Ideograph>)
          12891 => 16#62DF#,   --  拟 (<CJK Ideograph>)
          12892 => 16#4F60#,   --  你 (<CJK Ideograph>)
          12893 => 16#533F#,   --  匿 (<CJK Ideograph>)
          12894 => 16#817B#,   --  腻 (<CJK Ideograph>)
          12895 => 16#9006#,   --  逆 (<CJK Ideograph>)
          12896 => 16#6EBA#,   --  溺 (<CJK Ideograph>)
          12897 => 16#852B#,   --  蔫 (<CJK Ideograph>)
          12898 => 16#62C8#,   --  拈 (<CJK Ideograph>)
          12899 => 16#5E74#,   --  年 (<CJK Ideograph>)
          12900 => 16#78BE#,   --  碾 (<CJK Ideograph>)
          12901 => 16#64B5#,   --  撵 (<CJK Ideograph>)
          12902 => 16#637B#,   --  捻 (<CJK Ideograph>)
          12903 => 16#5FF5#,   --  念 (<CJK Ideograph>)
          12904 => 16#5A18#,   --  娘 (<CJK Ideograph>)
          12905 => 16#917F#,   --  酿 (<CJK Ideograph>)
          12906 => 16#9E1F#,   --  鸟 (<CJK Ideograph>)
          12907 => 16#5C3F#,   --  尿 (<CJK Ideograph>)
          12908 => 16#634F#,   --  捏 (<CJK Ideograph>)
          12909 => 16#8042#,   --  聂 (<CJK Ideograph>)
          12910 => 16#5B7D#,   --  孽 (<CJK Ideograph>)
          12911 => 16#556E#,   --  啮 (<CJK Ideograph>)
          12912 => 16#954A#,   --  镊 (<CJK Ideograph>)
          12913 => 16#954D#,   --  镍 (<CJK Ideograph>)
          12914 => 16#6D85#,   --  涅 (<CJK Ideograph>)
          12915 => 16#60A8#,   --  您 (<CJK Ideograph>)
          12916 => 16#67E0#,   --  柠 (<CJK Ideograph>)
          12917 => 16#72DE#,   --  狞 (<CJK Ideograph>)
          12918 => 16#51DD#,   --  凝 (<CJK Ideograph>)
          12919 => 16#5B81#,   --  宁 (<CJK Ideograph>)
          12920 => 16#81D4#,   --  臔 (<CJK Ideograph>)
          12921 => 16#81D5#,   --  臕 (<CJK Ideograph>)
          12922 => 16#81D6#,   --  臖 (<CJK Ideograph>)
          12923 => 16#81D7#,   --  臗 (<CJK Ideograph>)
          12924 => 16#81D8#,   --  臘 (<CJK Ideograph>)
          12925 => 16#81D9#,   --  臙 (<CJK Ideograph>)
          12926 => 16#81DA#,   --  臚 (<CJK Ideograph>)
          12927 => 16#81DB#,   --  臛 (<CJK Ideograph>)
          12928 => 16#81DC#,   --  臜 (<CJK Ideograph>)
          12929 => 16#81DD#,   --  臝 (<CJK Ideograph>)
          12930 => 16#81DE#,   --  臞 (<CJK Ideograph>)
          12931 => 16#81DF#,   --  臟 (<CJK Ideograph>)
          12932 => 16#81E0#,   --  臠 (<CJK Ideograph>)
          12933 => 16#81E1#,   --  臡 (<CJK Ideograph>)
          12934 => 16#81E2#,   --  臢 (<CJK Ideograph>)
          12935 => 16#81E4#,   --  臤 (<CJK Ideograph>)
          12936 => 16#81E5#,   --  臥 (<CJK Ideograph>)
          12937 => 16#81E6#,   --  臦 (<CJK Ideograph>)
          12938 => 16#81E8#,   --  臨 (<CJK Ideograph>)
          12939 => 16#81E9#,   --  臩 (<CJK Ideograph>)
          12940 => 16#81EB#,   --  臫 (<CJK Ideograph>)
          12941 => 16#81EE#,   --  臮 (<CJK Ideograph>)
          12942 => 16#81EF#,   --  臯 (<CJK Ideograph>)
          12943 => 16#81F0#,   --  臰 (<CJK Ideograph>)
          12944 => 16#81F1#,   --  臱 (<CJK Ideograph>)
          12945 => 16#81F2#,   --  臲 (<CJK Ideograph>)
          12946 => 16#81F5#,   --  臵 (<CJK Ideograph>)
          12947 => 16#81F6#,   --  臶 (<CJK Ideograph>)
          12948 => 16#81F7#,   --  臷 (<CJK Ideograph>)
          12949 => 16#81F8#,   --  臸 (<CJK Ideograph>)
          12950 => 16#81F9#,   --  臹 (<CJK Ideograph>)
          12951 => 16#81FA#,   --  臺 (<CJK Ideograph>)
          12952 => 16#81FD#,   --  臽 (<CJK Ideograph>)
          12953 => 16#81FF#,   --  臿 (<CJK Ideograph>)
          12954 => 16#8203#,   --  舃 (<CJK Ideograph>)
          12955 => 16#8207#,   --  與 (<CJK Ideograph>)
          12956 => 16#8208#,   --  興 (<CJK Ideograph>)
          12957 => 16#8209#,   --  舉 (<CJK Ideograph>)
          12958 => 16#820A#,   --  舊 (<CJK Ideograph>)
          12959 => 16#820B#,   --  舋 (<CJK Ideograph>)
          12960 => 16#820E#,   --  舎 (<CJK Ideograph>)
          12961 => 16#820F#,   --  舏 (<CJK Ideograph>)
          12962 => 16#8211#,   --  舑 (<CJK Ideograph>)
          12963 => 16#8213#,   --  舓 (<CJK Ideograph>)
          12964 => 16#8215#,   --  舕 (<CJK Ideograph>)
          12965 => 16#8216#,   --  舖 (<CJK Ideograph>)
          12966 => 16#8217#,   --  舗 (<CJK Ideograph>)
          12967 => 16#8218#,   --  舘 (<CJK Ideograph>)
          12968 => 16#8219#,   --  舙 (<CJK Ideograph>)
          12969 => 16#821A#,   --  舚 (<CJK Ideograph>)
          12970 => 16#821D#,   --  舝 (<CJK Ideograph>)
          12971 => 16#8220#,   --  舠 (<CJK Ideograph>)
          12972 => 16#8224#,   --  舤 (<CJK Ideograph>)
          12973 => 16#8225#,   --  舥 (<CJK Ideograph>)
          12974 => 16#8226#,   --  舦 (<CJK Ideograph>)
          12975 => 16#8227#,   --  舧 (<CJK Ideograph>)
          12976 => 16#8229#,   --  舩 (<CJK Ideograph>)
          12977 => 16#822E#,   --  舮 (<CJK Ideograph>)
          12978 => 16#8232#,   --  舲 (<CJK Ideograph>)
          12979 => 16#823A#,   --  舺 (<CJK Ideograph>)
          12980 => 16#823C#,   --  舼 (<CJK Ideograph>)
          12981 => 16#823D#,   --  舽 (<CJK Ideograph>)
          12982 => 16#823F#,   --  舿 (<CJK Ideograph>)
          12983 => 16#8240#,   --  艀 (<CJK Ideograph>)
          12984 => 16#8241#,   --  艁 (<CJK Ideograph>)
          12985 => 16#8242#,   --  艂 (<CJK Ideograph>)
          12986 => 16#8243#,   --  艃 (<CJK Ideograph>)
          12987 => 16#8245#,   --  艅 (<CJK Ideograph>)
          12988 => 16#8246#,   --  艆 (<CJK Ideograph>)
          12989 => 16#8248#,   --  艈 (<CJK Ideograph>)
          12990 => 16#824A#,   --  艊 (<CJK Ideograph>)
          12991 => 16#824C#,   --  艌 (<CJK Ideograph>)
          12992 => 16#824D#,   --  艍 (<CJK Ideograph>)
          12993 => 16#824E#,   --  艎 (<CJK Ideograph>)
          12994 => 16#8250#,   --  艐 (<CJK Ideograph>)
          12995 => 16#8251#,   --  艑 (<CJK Ideograph>)
          12996 => 16#8252#,   --  艒 (<CJK Ideograph>)
          12997 => 16#8253#,   --  艓 (<CJK Ideograph>)
          12998 => 16#8254#,   --  艔 (<CJK Ideograph>)
          12999 => 16#8255#,   --  艕 (<CJK Ideograph>)
          13000 => 16#8256#,   --  艖 (<CJK Ideograph>)
          13001 => 16#8257#,   --  艗 (<CJK Ideograph>)
          13002 => 16#8259#,   --  艙 (<CJK Ideograph>)
          13003 => 16#825B#,   --  艛 (<CJK Ideograph>)
          13004 => 16#825C#,   --  艜 (<CJK Ideograph>)
          13005 => 16#825D#,   --  艝 (<CJK Ideograph>)
          13006 => 16#825E#,   --  艞 (<CJK Ideograph>)
          13007 => 16#8260#,   --  艠 (<CJK Ideograph>)
          13008 => 16#8261#,   --  艡 (<CJK Ideograph>)
          13009 => 16#8262#,   --  艢 (<CJK Ideograph>)
          13010 => 16#8263#,   --  艣 (<CJK Ideograph>)
          13011 => 16#8264#,   --  艤 (<CJK Ideograph>)
          13012 => 16#8265#,   --  艥 (<CJK Ideograph>)
          13013 => 16#8266#,   --  艦 (<CJK Ideograph>)
          13014 => 16#8267#,   --  艧 (<CJK Ideograph>)
          13015 => 16#8269#,   --  艩 (<CJK Ideograph>)
          13016 => 16#62E7#,   --  拧 (<CJK Ideograph>)
          13017 => 16#6CDE#,   --  泞 (<CJK Ideograph>)
          13018 => 16#725B#,   --  牛 (<CJK Ideograph>)
          13019 => 16#626D#,   --  扭 (<CJK Ideograph>)
          13020 => 16#94AE#,   --  钮 (<CJK Ideograph>)
          13021 => 16#7EBD#,   --  纽 (<CJK Ideograph>)
          13022 => 16#8113#,   --  脓 (<CJK Ideograph>)
          13023 => 16#6D53#,   --  浓 (<CJK Ideograph>)
          13024 => 16#519C#,   --  农 (<CJK Ideograph>)
          13025 => 16#5F04#,   --  弄 (<CJK Ideograph>)
          13026 => 16#5974#,   --  奴 (<CJK Ideograph>)
          13027 => 16#52AA#,   --  努 (<CJK Ideograph>)
          13028 => 16#6012#,   --  怒 (<CJK Ideograph>)
          13029 => 16#5973#,   --  女 (<CJK Ideograph>)
          13030 => 16#6696#,   --  暖 (<CJK Ideograph>)
          13031 => 16#8650#,   --  虐 (<CJK Ideograph>)
          13032 => 16#759F#,   --  疟 (<CJK Ideograph>)
          13033 => 16#632A#,   --  挪 (<CJK Ideograph>)
          13034 => 16#61E6#,   --  懦 (<CJK Ideograph>)
          13035 => 16#7CEF#,   --  糯 (<CJK Ideograph>)
          13036 => 16#8BFA#,   --  诺 (<CJK Ideograph>)
          13037 => 16#54E6#,   --  哦 (<CJK Ideograph>)
          13038 => 16#6B27#,   --  欧 (<CJK Ideograph>)
          13039 => 16#9E25#,   --  鸥 (<CJK Ideograph>)
          13040 => 16#6BB4#,   --  殴 (<CJK Ideograph>)
          13041 => 16#85D5#,   --  藕 (<CJK Ideograph>)
          13042 => 16#5455#,   --  呕 (<CJK Ideograph>)
          13043 => 16#5076#,   --  偶 (<CJK Ideograph>)
          13044 => 16#6CA4#,   --  沤 (<CJK Ideograph>)
          13045 => 16#556A#,   --  啪 (<CJK Ideograph>)
          13046 => 16#8DB4#,   --  趴 (<CJK Ideograph>)
          13047 => 16#722C#,   --  爬 (<CJK Ideograph>)
          13048 => 16#5E15#,   --  帕 (<CJK Ideograph>)
          13049 => 16#6015#,   --  怕 (<CJK Ideograph>)
          13050 => 16#7436#,   --  琶 (<CJK Ideograph>)
          13051 => 16#62CD#,   --  拍 (<CJK Ideograph>)
          13052 => 16#6392#,   --  排 (<CJK Ideograph>)
          13053 => 16#724C#,   --  牌 (<CJK Ideograph>)
          13054 => 16#5F98#,   --  徘 (<CJK Ideograph>)
          13055 => 16#6E43#,   --  湃 (<CJK Ideograph>)
          13056 => 16#6D3E#,   --  派 (<CJK Ideograph>)
          13057 => 16#6500#,   --  攀 (<CJK Ideograph>)
          13058 => 16#6F58#,   --  潘 (<CJK Ideograph>)
          13059 => 16#76D8#,   --  盘 (<CJK Ideograph>)
          13060 => 16#78D0#,   --  磐 (<CJK Ideograph>)
          13061 => 16#76FC#,   --  盼 (<CJK Ideograph>)
          13062 => 16#7554#,   --  畔 (<CJK Ideograph>)
          13063 => 16#5224#,   --  判 (<CJK Ideograph>)
          13064 => 16#53DB#,   --  叛 (<CJK Ideograph>)
          13065 => 16#4E53#,   --  乓 (<CJK Ideograph>)
          13066 => 16#5E9E#,   --  庞 (<CJK Ideograph>)
          13067 => 16#65C1#,   --  旁 (<CJK Ideograph>)
          13068 => 16#802A#,   --  耪 (<CJK Ideograph>)
          13069 => 16#80D6#,   --  胖 (<CJK Ideograph>)
          13070 => 16#629B#,   --  抛 (<CJK Ideograph>)
          13071 => 16#5486#,   --  咆 (<CJK Ideograph>)
          13072 => 16#5228#,   --  刨 (<CJK Ideograph>)
          13073 => 16#70AE#,   --  炮 (<CJK Ideograph>)
          13074 => 16#888D#,   --  袍 (<CJK Ideograph>)
          13075 => 16#8DD1#,   --  跑 (<CJK Ideograph>)
          13076 => 16#6CE1#,   --  泡 (<CJK Ideograph>)
          13077 => 16#5478#,   --  呸 (<CJK Ideograph>)
          13078 => 16#80DA#,   --  胚 (<CJK Ideograph>)
          13079 => 16#57F9#,   --  培 (<CJK Ideograph>)
          13080 => 16#88F4#,   --  裴 (<CJK Ideograph>)
          13081 => 16#8D54#,   --  赔 (<CJK Ideograph>)
          13082 => 16#966A#,   --  陪 (<CJK Ideograph>)
          13083 => 16#914D#,   --  配 (<CJK Ideograph>)
          13084 => 16#4F69#,   --  佩 (<CJK Ideograph>)
          13085 => 16#6C9B#,   --  沛 (<CJK Ideograph>)
          13086 => 16#55B7#,   --  喷 (<CJK Ideograph>)
          13087 => 16#76C6#,   --  盆 (<CJK Ideograph>)
          13088 => 16#7830#,   --  砰 (<CJK Ideograph>)
          13089 => 16#62A8#,   --  抨 (<CJK Ideograph>)
          13090 => 16#70F9#,   --  烹 (<CJK Ideograph>)
          13091 => 16#6F8E#,   --  澎 (<CJK Ideograph>)
          13092 => 16#5F6D#,   --  彭 (<CJK Ideograph>)
          13093 => 16#84EC#,   --  蓬 (<CJK Ideograph>)
          13094 => 16#68DA#,   --  棚 (<CJK Ideograph>)
          13095 => 16#787C#,   --  硼 (<CJK Ideograph>)
          13096 => 16#7BF7#,   --  篷 (<CJK Ideograph>)
          13097 => 16#81A8#,   --  膨 (<CJK Ideograph>)
          13098 => 16#670B#,   --  朋 (<CJK Ideograph>)
          13099 => 16#9E4F#,   --  鹏 (<CJK Ideograph>)
          13100 => 16#6367#,   --  捧 (<CJK Ideograph>)
          13101 => 16#78B0#,   --  碰 (<CJK Ideograph>)
          13102 => 16#576F#,   --  坯 (<CJK Ideograph>)
          13103 => 16#7812#,   --  砒 (<CJK Ideograph>)
          13104 => 16#9739#,   --  霹 (<CJK Ideograph>)
          13105 => 16#6279#,   --  批 (<CJK Ideograph>)
          13106 => 16#62AB#,   --  披 (<CJK Ideograph>)
          13107 => 16#5288#,   --  劈 (<CJK Ideograph>)
          13108 => 16#7435#,   --  琵 (<CJK Ideograph>)
          13109 => 16#6BD7#,   --  毗 (<CJK Ideograph>)
          13110 => 16#826A#,   --  艪 (<CJK Ideograph>)
          13111 => 16#826B#,   --  艫 (<CJK Ideograph>)
          13112 => 16#826C#,   --  艬 (<CJK Ideograph>)
          13113 => 16#826D#,   --  艭 (<CJK Ideograph>)
          13114 => 16#8271#,   --  艱 (<CJK Ideograph>)
          13115 => 16#8275#,   --  艵 (<CJK Ideograph>)
          13116 => 16#8276#,   --  艶 (<CJK Ideograph>)
          13117 => 16#8277#,   --  艷 (<CJK Ideograph>)
          13118 => 16#8278#,   --  艸 (<CJK Ideograph>)
          13119 => 16#827B#,   --  艻 (<CJK Ideograph>)
          13120 => 16#827C#,   --  艼 (<CJK Ideograph>)
          13121 => 16#8280#,   --  芀 (<CJK Ideograph>)
          13122 => 16#8281#,   --  芁 (<CJK Ideograph>)
          13123 => 16#8283#,   --  芃 (<CJK Ideograph>)
          13124 => 16#8285#,   --  芅 (<CJK Ideograph>)
          13125 => 16#8286#,   --  芆 (<CJK Ideograph>)
          13126 => 16#8287#,   --  芇 (<CJK Ideograph>)
          13127 => 16#8289#,   --  芉 (<CJK Ideograph>)
          13128 => 16#828C#,   --  芌 (<CJK Ideograph>)
          13129 => 16#8290#,   --  芐 (<CJK Ideograph>)
          13130 => 16#8293#,   --  芓 (<CJK Ideograph>)
          13131 => 16#8294#,   --  芔 (<CJK Ideograph>)
          13132 => 16#8295#,   --  芕 (<CJK Ideograph>)
          13133 => 16#8296#,   --  芖 (<CJK Ideograph>)
          13134 => 16#829A#,   --  芚 (<CJK Ideograph>)
          13135 => 16#829B#,   --  芛 (<CJK Ideograph>)
          13136 => 16#829E#,   --  芞 (<CJK Ideograph>)
          13137 => 16#82A0#,   --  芠 (<CJK Ideograph>)
          13138 => 16#82A2#,   --  芢 (<CJK Ideograph>)
          13139 => 16#82A3#,   --  芣 (<CJK Ideograph>)
          13140 => 16#82A7#,   --  芧 (<CJK Ideograph>)
          13141 => 16#82B2#,   --  芲 (<CJK Ideograph>)
          13142 => 16#82B5#,   --  芵 (<CJK Ideograph>)
          13143 => 16#82B6#,   --  芶 (<CJK Ideograph>)
          13144 => 16#82BA#,   --  芺 (<CJK Ideograph>)
          13145 => 16#82BB#,   --  芻 (<CJK Ideograph>)
          13146 => 16#82BC#,   --  芼 (<CJK Ideograph>)
          13147 => 16#82BF#,   --  芿 (<CJK Ideograph>)
          13148 => 16#82C0#,   --  苀 (<CJK Ideograph>)
          13149 => 16#82C2#,   --  苂 (<CJK Ideograph>)
          13150 => 16#82C3#,   --  苃 (<CJK Ideograph>)
          13151 => 16#82C5#,   --  苅 (<CJK Ideograph>)
          13152 => 16#82C6#,   --  苆 (<CJK Ideograph>)
          13153 => 16#82C9#,   --  苉 (<CJK Ideograph>)
          13154 => 16#82D0#,   --  苐 (<CJK Ideograph>)
          13155 => 16#82D6#,   --  苖 (<CJK Ideograph>)
          13156 => 16#82D9#,   --  苙 (<CJK Ideograph>)
          13157 => 16#82DA#,   --  苚 (<CJK Ideograph>)
          13158 => 16#82DD#,   --  苝 (<CJK Ideograph>)
          13159 => 16#82E2#,   --  苢 (<CJK Ideograph>)
          13160 => 16#82E7#,   --  苧 (<CJK Ideograph>)
          13161 => 16#82E8#,   --  苨 (<CJK Ideograph>)
          13162 => 16#82E9#,   --  苩 (<CJK Ideograph>)
          13163 => 16#82EA#,   --  苪 (<CJK Ideograph>)
          13164 => 16#82EC#,   --  苬 (<CJK Ideograph>)
          13165 => 16#82ED#,   --  苭 (<CJK Ideograph>)
          13166 => 16#82EE#,   --  苮 (<CJK Ideograph>)
          13167 => 16#82F0#,   --  苰 (<CJK Ideograph>)
          13168 => 16#82F2#,   --  苲 (<CJK Ideograph>)
          13169 => 16#82F3#,   --  苳 (<CJK Ideograph>)
          13170 => 16#82F5#,   --  苵 (<CJK Ideograph>)
          13171 => 16#82F6#,   --  苶 (<CJK Ideograph>)
          13172 => 16#82F8#,   --  苸 (<CJK Ideograph>)
          13173 => 16#82FA#,   --  苺 (<CJK Ideograph>)
          13174 => 16#82FC#,   --  苼 (<CJK Ideograph>)
          13175 => 16#82FD#,   --  苽 (<CJK Ideograph>)
          13176 => 16#82FE#,   --  苾 (<CJK Ideograph>)
          13177 => 16#82FF#,   --  苿 (<CJK Ideograph>)
          13178 => 16#8300#,   --  茀 (<CJK Ideograph>)
          13179 => 16#830A#,   --  茊 (<CJK Ideograph>)
          13180 => 16#830B#,   --  茋 (<CJK Ideograph>)
          13181 => 16#830D#,   --  茍 (<CJK Ideograph>)
          13182 => 16#8310#,   --  茐 (<CJK Ideograph>)
          13183 => 16#8312#,   --  茒 (<CJK Ideograph>)
          13184 => 16#8313#,   --  茓 (<CJK Ideograph>)
          13185 => 16#8316#,   --  茖 (<CJK Ideograph>)
          13186 => 16#8318#,   --  茘 (<CJK Ideograph>)
          13187 => 16#8319#,   --  茙 (<CJK Ideograph>)
          13188 => 16#831D#,   --  茝 (<CJK Ideograph>)
          13189 => 16#831E#,   --  茞 (<CJK Ideograph>)
          13190 => 16#831F#,   --  茟 (<CJK Ideograph>)
          13191 => 16#8320#,   --  茠 (<CJK Ideograph>)
          13192 => 16#8321#,   --  茡 (<CJK Ideograph>)
          13193 => 16#8322#,   --  茢 (<CJK Ideograph>)
          13194 => 16#8323#,   --  茣 (<CJK Ideograph>)
          13195 => 16#8324#,   --  茤 (<CJK Ideograph>)
          13196 => 16#8325#,   --  茥 (<CJK Ideograph>)
          13197 => 16#8326#,   --  茦 (<CJK Ideograph>)
          13198 => 16#8329#,   --  茩 (<CJK Ideograph>)
          13199 => 16#832A#,   --  茪 (<CJK Ideograph>)
          13200 => 16#832E#,   --  茮 (<CJK Ideograph>)
          13201 => 16#8330#,   --  茰 (<CJK Ideograph>)
          13202 => 16#8332#,   --  茲 (<CJK Ideograph>)
          13203 => 16#8337#,   --  茷 (<CJK Ideograph>)
          13204 => 16#833B#,   --  茻 (<CJK Ideograph>)
          13205 => 16#833D#,   --  茽 (<CJK Ideograph>)
          13206 => 16#5564#,   --  啤 (<CJK Ideograph>)
          13207 => 16#813E#,   --  脾 (<CJK Ideograph>)
          13208 => 16#75B2#,   --  疲 (<CJK Ideograph>)
          13209 => 16#76AE#,   --  皮 (<CJK Ideograph>)
          13210 => 16#5339#,   --  匹 (<CJK Ideograph>)
          13211 => 16#75DE#,   --  痞 (<CJK Ideograph>)
          13212 => 16#50FB#,   --  僻 (<CJK Ideograph>)
          13213 => 16#5C41#,   --  屁 (<CJK Ideograph>)
          13214 => 16#8B6C#,   --  譬 (<CJK Ideograph>)
          13215 => 16#7BC7#,   --  篇 (<CJK Ideograph>)
          13216 => 16#504F#,   --  偏 (<CJK Ideograph>)
          13217 => 16#7247#,   --  片 (<CJK Ideograph>)
          13218 => 16#9A97#,   --  骗 (<CJK Ideograph>)
          13219 => 16#98D8#,   --  飘 (<CJK Ideograph>)
          13220 => 16#6F02#,   --  漂 (<CJK Ideograph>)
          13221 => 16#74E2#,   --  瓢 (<CJK Ideograph>)
          13222 => 16#7968#,   --  票 (<CJK Ideograph>)
          13223 => 16#6487#,   --  撇 (<CJK Ideograph>)
          13224 => 16#77A5#,   --  瞥 (<CJK Ideograph>)
          13225 => 16#62FC#,   --  拼 (<CJK Ideograph>)
          13226 => 16#9891#,   --  频 (<CJK Ideograph>)
          13227 => 16#8D2B#,   --  贫 (<CJK Ideograph>)
          13228 => 16#54C1#,   --  品 (<CJK Ideograph>)
          13229 => 16#8058#,   --  聘 (<CJK Ideograph>)
          13230 => 16#4E52#,   --  乒 (<CJK Ideograph>)
          13231 => 16#576A#,   --  坪 (<CJK Ideograph>)
          13232 => 16#82F9#,   --  苹 (<CJK Ideograph>)
          13233 => 16#840D#,   --  萍 (<CJK Ideograph>)
          13234 => 16#5E73#,   --  平 (<CJK Ideograph>)
          13235 => 16#51ED#,   --  凭 (<CJK Ideograph>)
          13236 => 16#74F6#,   --  瓶 (<CJK Ideograph>)
          13237 => 16#8BC4#,   --  评 (<CJK Ideograph>)
          13238 => 16#5C4F#,   --  屏 (<CJK Ideograph>)
          13239 => 16#5761#,   --  坡 (<CJK Ideograph>)
          13240 => 16#6CFC#,   --  泼 (<CJK Ideograph>)
          13241 => 16#9887#,   --  颇 (<CJK Ideograph>)
          13242 => 16#5A46#,   --  婆 (<CJK Ideograph>)
          13243 => 16#7834#,   --  破 (<CJK Ideograph>)
          13244 => 16#9B44#,   --  魄 (<CJK Ideograph>)
          13245 => 16#8FEB#,   --  迫 (<CJK Ideograph>)
          13246 => 16#7C95#,   --  粕 (<CJK Ideograph>)
          13247 => 16#5256#,   --  剖 (<CJK Ideograph>)
          13248 => 16#6251#,   --  扑 (<CJK Ideograph>)
          13249 => 16#94FA#,   --  铺 (<CJK Ideograph>)
          13250 => 16#4EC6#,   --  仆 (<CJK Ideograph>)
          13251 => 16#8386#,   --  莆 (<CJK Ideograph>)
          13252 => 16#8461#,   --  葡 (<CJK Ideograph>)
          13253 => 16#83E9#,   --  菩 (<CJK Ideograph>)
          13254 => 16#84B2#,   --  蒲 (<CJK Ideograph>)
          13255 => 16#57D4#,   --  埔 (<CJK Ideograph>)
          13256 => 16#6734#,   --  朴 (<CJK Ideograph>)
          13257 => 16#5703#,   --  圃 (<CJK Ideograph>)
          13258 => 16#666E#,   --  普 (<CJK Ideograph>)
          13259 => 16#6D66#,   --  浦 (<CJK Ideograph>)
          13260 => 16#8C31#,   --  谱 (<CJK Ideograph>)
          13261 => 16#66DD#,   --  曝 (<CJK Ideograph>)
          13262 => 16#7011#,   --  瀑 (<CJK Ideograph>)
          13263 => 16#671F#,   --  期 (<CJK Ideograph>)
          13264 => 16#6B3A#,   --  欺 (<CJK Ideograph>)
          13265 => 16#6816#,   --  栖 (<CJK Ideograph>)
          13266 => 16#621A#,   --  戚 (<CJK Ideograph>)
          13267 => 16#59BB#,   --  妻 (<CJK Ideograph>)
          13268 => 16#4E03#,   --  七 (<CJK Ideograph>)
          13269 => 16#51C4#,   --  凄 (<CJK Ideograph>)
          13270 => 16#6F06#,   --  漆 (<CJK Ideograph>)
          13271 => 16#67D2#,   --  柒 (<CJK Ideograph>)
          13272 => 16#6C8F#,   --  沏 (<CJK Ideograph>)
          13273 => 16#5176#,   --  其 (<CJK Ideograph>)
          13274 => 16#68CB#,   --  棋 (<CJK Ideograph>)
          13275 => 16#5947#,   --  奇 (<CJK Ideograph>)
          13276 => 16#6B67#,   --  歧 (<CJK Ideograph>)
          13277 => 16#7566#,   --  畦 (<CJK Ideograph>)
          13278 => 16#5D0E#,   --  崎 (<CJK Ideograph>)
          13279 => 16#8110#,   --  脐 (<CJK Ideograph>)
          13280 => 16#9F50#,   --  齐 (<CJK Ideograph>)
          13281 => 16#65D7#,   --  旗 (<CJK Ideograph>)
          13282 => 16#7948#,   --  祈 (<CJK Ideograph>)
          13283 => 16#7941#,   --  祁 (<CJK Ideograph>)
          13284 => 16#9A91#,   --  骑 (<CJK Ideograph>)
          13285 => 16#8D77#,   --  起 (<CJK Ideograph>)
          13286 => 16#5C82#,   --  岂 (<CJK Ideograph>)
          13287 => 16#4E5E#,   --  乞 (<CJK Ideograph>)
          13288 => 16#4F01#,   --  企 (<CJK Ideograph>)
          13289 => 16#542F#,   --  启 (<CJK Ideograph>)
          13290 => 16#5951#,   --  契 (<CJK Ideograph>)
          13291 => 16#780C#,   --  砌 (<CJK Ideograph>)
          13292 => 16#5668#,   --  器 (<CJK Ideograph>)
          13293 => 16#6C14#,   --  气 (<CJK Ideograph>)
          13294 => 16#8FC4#,   --  迄 (<CJK Ideograph>)
          13295 => 16#5F03#,   --  弃 (<CJK Ideograph>)
          13296 => 16#6C7D#,   --  汽 (<CJK Ideograph>)
          13297 => 16#6CE3#,   --  泣 (<CJK Ideograph>)
          13298 => 16#8BAB#,   --  讫 (<CJK Ideograph>)
          13299 => 16#6390#,   --  掐 (<CJK Ideograph>)
          13300 => 16#833E#,   --  茾 (<CJK Ideograph>)
          13301 => 16#833F#,   --  茿 (<CJK Ideograph>)
          13302 => 16#8341#,   --  荁 (<CJK Ideograph>)
          13303 => 16#8342#,   --  荂 (<CJK Ideograph>)
          13304 => 16#8344#,   --  荄 (<CJK Ideograph>)
          13305 => 16#8345#,   --  荅 (<CJK Ideograph>)
          13306 => 16#8348#,   --  荈 (<CJK Ideograph>)
          13307 => 16#834A#,   --  荊 (<CJK Ideograph>)
          13308 => 16#834B#,   --  荋 (<CJK Ideograph>)
          13309 => 16#834C#,   --  荌 (<CJK Ideograph>)
          13310 => 16#834D#,   --  荍 (<CJK Ideograph>)
          13311 => 16#834E#,   --  荎 (<CJK Ideograph>)
          13312 => 16#8353#,   --  荓 (<CJK Ideograph>)
          13313 => 16#8355#,   --  荕 (<CJK Ideograph>)
          13314 => 16#8356#,   --  荖 (<CJK Ideograph>)
          13315 => 16#8357#,   --  荗 (<CJK Ideograph>)
          13316 => 16#8358#,   --  荘 (<CJK Ideograph>)
          13317 => 16#8359#,   --  荙 (<CJK Ideograph>)
          13318 => 16#835D#,   --  荝 (<CJK Ideograph>)
          13319 => 16#8362#,   --  荢 (<CJK Ideograph>)
          13320 => 16#8370#,   --  荰 (<CJK Ideograph>)
          13321 => 16#8371#,   --  荱 (<CJK Ideograph>)
          13322 => 16#8372#,   --  荲 (<CJK Ideograph>)
          13323 => 16#8373#,   --  荳 (<CJK Ideograph>)
          13324 => 16#8374#,   --  荴 (<CJK Ideograph>)
          13325 => 16#8375#,   --  荵 (<CJK Ideograph>)
          13326 => 16#8376#,   --  荶 (<CJK Ideograph>)
          13327 => 16#8379#,   --  荹 (<CJK Ideograph>)
          13328 => 16#837A#,   --  荺 (<CJK Ideograph>)
          13329 => 16#837E#,   --  荾 (<CJK Ideograph>)
          13330 => 16#837F#,   --  荿 (<CJK Ideograph>)
          13331 => 16#8380#,   --  莀 (<CJK Ideograph>)
          13332 => 16#8381#,   --  莁 (<CJK Ideograph>)
          13333 => 16#8382#,   --  莂 (<CJK Ideograph>)
          13334 => 16#8383#,   --  莃 (<CJK Ideograph>)
          13335 => 16#8384#,   --  莄 (<CJK Ideograph>)
          13336 => 16#8387#,   --  莇 (<CJK Ideograph>)
          13337 => 16#8388#,   --  莈 (<CJK Ideograph>)
          13338 => 16#838A#,   --  莊 (<CJK Ideograph>)
          13339 => 16#838B#,   --  莋 (<CJK Ideograph>)
          13340 => 16#838C#,   --  莌 (<CJK Ideograph>)
          13341 => 16#838D#,   --  莍 (<CJK Ideograph>)
          13342 => 16#838F#,   --  莏 (<CJK Ideograph>)
          13343 => 16#8390#,   --  莐 (<CJK Ideograph>)
          13344 => 16#8391#,   --  莑 (<CJK Ideograph>)
          13345 => 16#8394#,   --  莔 (<CJK Ideograph>)
          13346 => 16#8395#,   --  莕 (<CJK Ideograph>)
          13347 => 16#8396#,   --  莖 (<CJK Ideograph>)
          13348 => 16#8397#,   --  莗 (<CJK Ideograph>)
          13349 => 16#8399#,   --  莙 (<CJK Ideograph>)
          13350 => 16#839A#,   --  莚 (<CJK Ideograph>)
          13351 => 16#839D#,   --  莝 (<CJK Ideograph>)
          13352 => 16#839F#,   --  莟 (<CJK Ideograph>)
          13353 => 16#83A1#,   --  莡 (<CJK Ideograph>)
          13354 => 16#83A2#,   --  莢 (<CJK Ideograph>)
          13355 => 16#83A3#,   --  莣 (<CJK Ideograph>)
          13356 => 16#83A4#,   --  莤 (<CJK Ideograph>)
          13357 => 16#83A5#,   --  莥 (<CJK Ideograph>)
          13358 => 16#83A6#,   --  莦 (<CJK Ideograph>)
          13359 => 16#83A7#,   --  莧 (<CJK Ideograph>)
          13360 => 16#83AC#,   --  莬 (<CJK Ideograph>)
          13361 => 16#83AD#,   --  莭 (<CJK Ideograph>)
          13362 => 16#83AE#,   --  莮 (<CJK Ideograph>)
          13363 => 16#83AF#,   --  莯 (<CJK Ideograph>)
          13364 => 16#83B5#,   --  莵 (<CJK Ideograph>)
          13365 => 16#83BB#,   --  莻 (<CJK Ideograph>)
          13366 => 16#83BE#,   --  莾 (<CJK Ideograph>)
          13367 => 16#83BF#,   --  莿 (<CJK Ideograph>)
          13368 => 16#83C2#,   --  菂 (<CJK Ideograph>)
          13369 => 16#83C3#,   --  菃 (<CJK Ideograph>)
          13370 => 16#83C4#,   --  菄 (<CJK Ideograph>)
          13371 => 16#83C6#,   --  菆 (<CJK Ideograph>)
          13372 => 16#83C8#,   --  菈 (<CJK Ideograph>)
          13373 => 16#83C9#,   --  菉 (<CJK Ideograph>)
          13374 => 16#83CB#,   --  菋 (<CJK Ideograph>)
          13375 => 16#83CD#,   --  菍 (<CJK Ideograph>)
          13376 => 16#83CE#,   --  菎 (<CJK Ideograph>)
          13377 => 16#83D0#,   --  菐 (<CJK Ideograph>)
          13378 => 16#83D1#,   --  菑 (<CJK Ideograph>)
          13379 => 16#83D2#,   --  菒 (<CJK Ideograph>)
          13380 => 16#83D3#,   --  菓 (<CJK Ideograph>)
          13381 => 16#83D5#,   --  菕 (<CJK Ideograph>)
          13382 => 16#83D7#,   --  菗 (<CJK Ideograph>)
          13383 => 16#83D9#,   --  菙 (<CJK Ideograph>)
          13384 => 16#83DA#,   --  菚 (<CJK Ideograph>)
          13385 => 16#83DB#,   --  菛 (<CJK Ideograph>)
          13386 => 16#83DE#,   --  菞 (<CJK Ideograph>)
          13387 => 16#83E2#,   --  菢 (<CJK Ideograph>)
          13388 => 16#83E3#,   --  菣 (<CJK Ideograph>)
          13389 => 16#83E4#,   --  菤 (<CJK Ideograph>)
          13390 => 16#83E6#,   --  菦 (<CJK Ideograph>)
          13391 => 16#83E7#,   --  菧 (<CJK Ideograph>)
          13392 => 16#83E8#,   --  菨 (<CJK Ideograph>)
          13393 => 16#83EB#,   --  菫 (<CJK Ideograph>)
          13394 => 16#83EC#,   --  菬 (<CJK Ideograph>)
          13395 => 16#83ED#,   --  菭 (<CJK Ideograph>)
          13396 => 16#6070#,   --  恰 (<CJK Ideograph>)
          13397 => 16#6D3D#,   --  洽 (<CJK Ideograph>)
          13398 => 16#7275#,   --  牵 (<CJK Ideograph>)
          13399 => 16#6266#,   --  扦 (<CJK Ideograph>)
          13400 => 16#948E#,   --  钎 (<CJK Ideograph>)
          13401 => 16#94C5#,   --  铅 (<CJK Ideograph>)
          13402 => 16#5343#,   --  千 (<CJK Ideograph>)
          13403 => 16#8FC1#,   --  迁 (<CJK Ideograph>)
          13404 => 16#7B7E#,   --  签 (<CJK Ideograph>)
          13405 => 16#4EDF#,   --  仟 (<CJK Ideograph>)
          13406 => 16#8C26#,   --  谦 (<CJK Ideograph>)
          13407 => 16#4E7E#,   --  乾 (<CJK Ideograph>)
          13408 => 16#9ED4#,   --  黔 (<CJK Ideograph>)
          13409 => 16#94B1#,   --  钱 (<CJK Ideograph>)
          13410 => 16#94B3#,   --  钳 (<CJK Ideograph>)
          13411 => 16#524D#,   --  前 (<CJK Ideograph>)
          13412 => 16#6F5C#,   --  潜 (<CJK Ideograph>)
          13413 => 16#9063#,   --  遣 (<CJK Ideograph>)
          13414 => 16#6D45#,   --  浅 (<CJK Ideograph>)
          13415 => 16#8C34#,   --  谴 (<CJK Ideograph>)
          13416 => 16#5811#,   --  堑 (<CJK Ideograph>)
          13417 => 16#5D4C#,   --  嵌 (<CJK Ideograph>)
          13418 => 16#6B20#,   --  欠 (<CJK Ideograph>)
          13419 => 16#6B49#,   --  歉 (<CJK Ideograph>)
          13420 => 16#67AA#,   --  枪 (<CJK Ideograph>)
          13421 => 16#545B#,   --  呛 (<CJK Ideograph>)
          13422 => 16#8154#,   --  腔 (<CJK Ideograph>)
          13423 => 16#7F8C#,   --  羌 (<CJK Ideograph>)
          13424 => 16#5899#,   --  墙 (<CJK Ideograph>)
          13425 => 16#8537#,   --  蔷 (<CJK Ideograph>)
          13426 => 16#5F3A#,   --  强 (<CJK Ideograph>)
          13427 => 16#62A2#,   --  抢 (<CJK Ideograph>)
          13428 => 16#6A47#,   --  橇 (<CJK Ideograph>)
          13429 => 16#9539#,   --  锹 (<CJK Ideograph>)
          13430 => 16#6572#,   --  敲 (<CJK Ideograph>)
          13431 => 16#6084#,   --  悄 (<CJK Ideograph>)
          13432 => 16#6865#,   --  桥 (<CJK Ideograph>)
          13433 => 16#77A7#,   --  瞧 (<CJK Ideograph>)
          13434 => 16#4E54#,   --  乔 (<CJK Ideograph>)
          13435 => 16#4FA8#,   --  侨 (<CJK Ideograph>)
          13436 => 16#5DE7#,   --  巧 (<CJK Ideograph>)
          13437 => 16#9798#,   --  鞘 (<CJK Ideograph>)
          13438 => 16#64AC#,   --  撬 (<CJK Ideograph>)
          13439 => 16#7FD8#,   --  翘 (<CJK Ideograph>)
          13440 => 16#5CED#,   --  峭 (<CJK Ideograph>)
          13441 => 16#4FCF#,   --  俏 (<CJK Ideograph>)
          13442 => 16#7A8D#,   --  窍 (<CJK Ideograph>)
          13443 => 16#5207#,   --  切 (<CJK Ideograph>)
          13444 => 16#8304#,   --  茄 (<CJK Ideograph>)
          13445 => 16#4E14#,   --  且 (<CJK Ideograph>)
          13446 => 16#602F#,   --  怯 (<CJK Ideograph>)
          13447 => 16#7A83#,   --  窃 (<CJK Ideograph>)
          13448 => 16#94A6#,   --  钦 (<CJK Ideograph>)
          13449 => 16#4FB5#,   --  侵 (<CJK Ideograph>)
          13450 => 16#4EB2#,   --  亲 (<CJK Ideograph>)
          13451 => 16#79E6#,   --  秦 (<CJK Ideograph>)
          13452 => 16#7434#,   --  琴 (<CJK Ideograph>)
          13453 => 16#52E4#,   --  勤 (<CJK Ideograph>)
          13454 => 16#82B9#,   --  芹 (<CJK Ideograph>)
          13455 => 16#64D2#,   --  擒 (<CJK Ideograph>)
          13456 => 16#79BD#,   --  禽 (<CJK Ideograph>)
          13457 => 16#5BDD#,   --  寝 (<CJK Ideograph>)
          13458 => 16#6C81#,   --  沁 (<CJK Ideograph>)
          13459 => 16#9752#,   --  青 (<CJK Ideograph>)
          13460 => 16#8F7B#,   --  轻 (<CJK Ideograph>)
          13461 => 16#6C22#,   --  氢 (<CJK Ideograph>)
          13462 => 16#503E#,   --  倾 (<CJK Ideograph>)
          13463 => 16#537F#,   --  卿 (<CJK Ideograph>)
          13464 => 16#6E05#,   --  清 (<CJK Ideograph>)
          13465 => 16#64CE#,   --  擎 (<CJK Ideograph>)
          13466 => 16#6674#,   --  晴 (<CJK Ideograph>)
          13467 => 16#6C30#,   --  氰 (<CJK Ideograph>)
          13468 => 16#60C5#,   --  情 (<CJK Ideograph>)
          13469 => 16#9877#,   --  顷 (<CJK Ideograph>)
          13470 => 16#8BF7#,   --  请 (<CJK Ideograph>)
          13471 => 16#5E86#,   --  庆 (<CJK Ideograph>)
          13472 => 16#743C#,   --  琼 (<CJK Ideograph>)
          13473 => 16#7A77#,   --  穷 (<CJK Ideograph>)
          13474 => 16#79CB#,   --  秋 (<CJK Ideograph>)
          13475 => 16#4E18#,   --  丘 (<CJK Ideograph>)
          13476 => 16#90B1#,   --  邱 (<CJK Ideograph>)
          13477 => 16#7403#,   --  球 (<CJK Ideograph>)
          13478 => 16#6C42#,   --  求 (<CJK Ideograph>)
          13479 => 16#56DA#,   --  囚 (<CJK Ideograph>)
          13480 => 16#914B#,   --  酋 (<CJK Ideograph>)
          13481 => 16#6CC5#,   --  泅 (<CJK Ideograph>)
          13482 => 16#8D8B#,   --  趋 (<CJK Ideograph>)
          13483 => 16#533A#,   --  区 (<CJK Ideograph>)
          13484 => 16#86C6#,   --  蛆 (<CJK Ideograph>)
          13485 => 16#66F2#,   --  曲 (<CJK Ideograph>)
          13486 => 16#8EAF#,   --  躯 (<CJK Ideograph>)
          13487 => 16#5C48#,   --  屈 (<CJK Ideograph>)
          13488 => 16#9A71#,   --  驱 (<CJK Ideograph>)
          13489 => 16#6E20#,   --  渠 (<CJK Ideograph>)
          13490 => 16#83EE#,   --  菮 (<CJK Ideograph>)
          13491 => 16#83EF#,   --  華 (<CJK Ideograph>)
          13492 => 16#83F3#,   --  菳 (<CJK Ideograph>)
          13493 => 16#83F4#,   --  菴 (<CJK Ideograph>)
          13494 => 16#83F5#,   --  菵 (<CJK Ideograph>)
          13495 => 16#83F6#,   --  菶 (<CJK Ideograph>)
          13496 => 16#83F7#,   --  菷 (<CJK Ideograph>)
          13497 => 16#83FA#,   --  菺 (<CJK Ideograph>)
          13498 => 16#83FB#,   --  菻 (<CJK Ideograph>)
          13499 => 16#83FC#,   --  菼 (<CJK Ideograph>)
          13500 => 16#83FE#,   --  菾 (<CJK Ideograph>)
          13501 => 16#83FF#,   --  菿 (<CJK Ideograph>)
          13502 => 16#8400#,   --  萀 (<CJK Ideograph>)
          13503 => 16#8402#,   --  萂 (<CJK Ideograph>)
          13504 => 16#8405#,   --  萅 (<CJK Ideograph>)
          13505 => 16#8407#,   --  萇 (<CJK Ideograph>)
          13506 => 16#8408#,   --  萈 (<CJK Ideograph>)
          13507 => 16#8409#,   --  萉 (<CJK Ideograph>)
          13508 => 16#840A#,   --  萊 (<CJK Ideograph>)
          13509 => 16#8410#,   --  萐 (<CJK Ideograph>)
          13510 => 16#8412#,   --  萒 (<CJK Ideograph>)
          13511 => 16#8413#,   --  萓 (<CJK Ideograph>)
          13512 => 16#8414#,   --  萔 (<CJK Ideograph>)
          13513 => 16#8415#,   --  萕 (<CJK Ideograph>)
          13514 => 16#8416#,   --  萖 (<CJK Ideograph>)
          13515 => 16#8417#,   --  萗 (<CJK Ideograph>)
          13516 => 16#8419#,   --  萙 (<CJK Ideograph>)
          13517 => 16#841A#,   --  萚 (<CJK Ideograph>)
          13518 => 16#841B#,   --  萛 (<CJK Ideograph>)
          13519 => 16#841E#,   --  萞 (<CJK Ideograph>)
          13520 => 16#841F#,   --  萟 (<CJK Ideograph>)
          13521 => 16#8420#,   --  萠 (<CJK Ideograph>)
          13522 => 16#8421#,   --  萡 (<CJK Ideograph>)
          13523 => 16#8422#,   --  萢 (<CJK Ideograph>)
          13524 => 16#8423#,   --  萣 (<CJK Ideograph>)
          13525 => 16#8429#,   --  萩 (<CJK Ideograph>)
          13526 => 16#842A#,   --  萪 (<CJK Ideograph>)
          13527 => 16#842B#,   --  萫 (<CJK Ideograph>)
          13528 => 16#842C#,   --  萬 (<CJK Ideograph>)
          13529 => 16#842D#,   --  萭 (<CJK Ideograph>)
          13530 => 16#842E#,   --  萮 (<CJK Ideograph>)
          13531 => 16#842F#,   --  萯 (<CJK Ideograph>)
          13532 => 16#8430#,   --  萰 (<CJK Ideograph>)
          13533 => 16#8432#,   --  萲 (<CJK Ideograph>)
          13534 => 16#8433#,   --  萳 (<CJK Ideograph>)
          13535 => 16#8434#,   --  萴 (<CJK Ideograph>)
          13536 => 16#8435#,   --  萵 (<CJK Ideograph>)
          13537 => 16#8436#,   --  萶 (<CJK Ideograph>)
          13538 => 16#8437#,   --  萷 (<CJK Ideograph>)
          13539 => 16#8439#,   --  萹 (<CJK Ideograph>)
          13540 => 16#843A#,   --  萺 (<CJK Ideograph>)
          13541 => 16#843B#,   --  萻 (<CJK Ideograph>)
          13542 => 16#843E#,   --  萾 (<CJK Ideograph>)
          13543 => 16#843F#,   --  萿 (<CJK Ideograph>)
          13544 => 16#8440#,   --  葀 (<CJK Ideograph>)
          13545 => 16#8441#,   --  葁 (<CJK Ideograph>)
          13546 => 16#8442#,   --  葂 (<CJK Ideograph>)
          13547 => 16#8443#,   --  葃 (<CJK Ideograph>)
          13548 => 16#8444#,   --  葄 (<CJK Ideograph>)
          13549 => 16#8445#,   --  葅 (<CJK Ideograph>)
          13550 => 16#8447#,   --  葇 (<CJK Ideograph>)
          13551 => 16#8448#,   --  葈 (<CJK Ideograph>)
          13552 => 16#8449#,   --  葉 (<CJK Ideograph>)
          13553 => 16#844A#,   --  葊 (<CJK Ideograph>)
          13554 => 16#844B#,   --  葋 (<CJK Ideograph>)
          13555 => 16#844C#,   --  葌 (<CJK Ideograph>)
          13556 => 16#844D#,   --  葍 (<CJK Ideograph>)
          13557 => 16#844E#,   --  葎 (<CJK Ideograph>)
          13558 => 16#844F#,   --  葏 (<CJK Ideograph>)
          13559 => 16#8450#,   --  葐 (<CJK Ideograph>)
          13560 => 16#8452#,   --  葒 (<CJK Ideograph>)
          13561 => 16#8453#,   --  葓 (<CJK Ideograph>)
          13562 => 16#8454#,   --  葔 (<CJK Ideograph>)
          13563 => 16#8455#,   --  葕 (<CJK Ideograph>)
          13564 => 16#8456#,   --  葖 (<CJK Ideograph>)
          13565 => 16#8458#,   --  葘 (<CJK Ideograph>)
          13566 => 16#845D#,   --  葝 (<CJK Ideograph>)
          13567 => 16#845E#,   --  葞 (<CJK Ideograph>)
          13568 => 16#845F#,   --  葟 (<CJK Ideograph>)
          13569 => 16#8460#,   --  葠 (<CJK Ideograph>)
          13570 => 16#8462#,   --  葢 (<CJK Ideograph>)
          13571 => 16#8464#,   --  葤 (<CJK Ideograph>)
          13572 => 16#8465#,   --  葥 (<CJK Ideograph>)
          13573 => 16#8466#,   --  葦 (<CJK Ideograph>)
          13574 => 16#8467#,   --  葧 (<CJK Ideograph>)
          13575 => 16#8468#,   --  葨 (<CJK Ideograph>)
          13576 => 16#846A#,   --  葪 (<CJK Ideograph>)
          13577 => 16#846E#,   --  葮 (<CJK Ideograph>)
          13578 => 16#846F#,   --  葯 (<CJK Ideograph>)
          13579 => 16#8470#,   --  葰 (<CJK Ideograph>)
          13580 => 16#8472#,   --  葲 (<CJK Ideograph>)
          13581 => 16#8474#,   --  葴 (<CJK Ideograph>)
          13582 => 16#8477#,   --  葷 (<CJK Ideograph>)
          13583 => 16#8479#,   --  葹 (<CJK Ideograph>)
          13584 => 16#847B#,   --  葻 (<CJK Ideograph>)
          13585 => 16#847C#,   --  葼 (<CJK Ideograph>)
          13586 => 16#53D6#,   --  取 (<CJK Ideograph>)
          13587 => 16#5A36#,   --  娶 (<CJK Ideograph>)
          13588 => 16#9F8B#,   --  龋 (<CJK Ideograph>)
          13589 => 16#8DA3#,   --  趣 (<CJK Ideograph>)
          13590 => 16#53BB#,   --  去 (<CJK Ideograph>)
          13591 => 16#5708#,   --  圈 (<CJK Ideograph>)
          13592 => 16#98A7#,   --  颧 (<CJK Ideograph>)
          13593 => 16#6743#,   --  权 (<CJK Ideograph>)
          13594 => 16#919B#,   --  醛 (<CJK Ideograph>)
          13595 => 16#6CC9#,   --  泉 (<CJK Ideograph>)
          13596 => 16#5168#,   --  全 (<CJK Ideograph>)
          13597 => 16#75CA#,   --  痊 (<CJK Ideograph>)
          13598 => 16#62F3#,   --  拳 (<CJK Ideograph>)
          13599 => 16#72AC#,   --  犬 (<CJK Ideograph>)
          13600 => 16#5238#,   --  券 (<CJK Ideograph>)
          13601 => 16#529D#,   --  劝 (<CJK Ideograph>)
          13602 => 16#7F3A#,   --  缺 (<CJK Ideograph>)
          13603 => 16#7094#,   --  炔 (<CJK Ideograph>)
          13604 => 16#7638#,   --  瘸 (<CJK Ideograph>)
          13605 => 16#5374#,   --  却 (<CJK Ideograph>)
          13606 => 16#9E4A#,   --  鹊 (<CJK Ideograph>)
          13607 => 16#69B7#,   --  榷 (<CJK Ideograph>)
          13608 => 16#786E#,   --  确 (<CJK Ideograph>)
          13609 => 16#96C0#,   --  雀 (<CJK Ideograph>)
          13610 => 16#88D9#,   --  裙 (<CJK Ideograph>)
          13611 => 16#7FA4#,   --  群 (<CJK Ideograph>)
          13612 => 16#7136#,   --  然 (<CJK Ideograph>)
          13613 => 16#71C3#,   --  燃 (<CJK Ideograph>)
          13614 => 16#5189#,   --  冉 (<CJK Ideograph>)
          13615 => 16#67D3#,   --  染 (<CJK Ideograph>)
          13616 => 16#74E4#,   --  瓤 (<CJK Ideograph>)
          13617 => 16#58E4#,   --  壤 (<CJK Ideograph>)
          13618 => 16#6518#,   --  攘 (<CJK Ideograph>)
          13619 => 16#56B7#,   --  嚷 (<CJK Ideograph>)
          13620 => 16#8BA9#,   --  让 (<CJK Ideograph>)
          13621 => 16#9976#,   --  饶 (<CJK Ideograph>)
          13622 => 16#6270#,   --  扰 (<CJK Ideograph>)
          13623 => 16#7ED5#,   --  绕 (<CJK Ideograph>)
          13624 => 16#60F9#,   --  惹 (<CJK Ideograph>)
          13625 => 16#70ED#,   --  热 (<CJK Ideograph>)
          13626 => 16#58EC#,   --  壬 (<CJK Ideograph>)
          13627 => 16#4EC1#,   --  仁 (<CJK Ideograph>)
          13628 => 16#4EBA#,   --  人 (<CJK Ideograph>)
          13629 => 16#5FCD#,   --  忍 (<CJK Ideograph>)
          13630 => 16#97E7#,   --  韧 (<CJK Ideograph>)
          13631 => 16#4EFB#,   --  任 (<CJK Ideograph>)
          13632 => 16#8BA4#,   --  认 (<CJK Ideograph>)
          13633 => 16#5203#,   --  刃 (<CJK Ideograph>)
          13634 => 16#598A#,   --  妊 (<CJK Ideograph>)
          13635 => 16#7EAB#,   --  纫 (<CJK Ideograph>)
          13636 => 16#6254#,   --  扔 (<CJK Ideograph>)
          13637 => 16#4ECD#,   --  仍 (<CJK Ideograph>)
          13638 => 16#65E5#,   --  日 (<CJK Ideograph>)
          13639 => 16#620E#,   --  戎 (<CJK Ideograph>)
          13640 => 16#8338#,   --  茸 (<CJK Ideograph>)
          13641 => 16#84C9#,   --  蓉 (<CJK Ideograph>)
          13642 => 16#8363#,   --  荣 (<CJK Ideograph>)
          13643 => 16#878D#,   --  融 (<CJK Ideograph>)
          13644 => 16#7194#,   --  熔 (<CJK Ideograph>)
          13645 => 16#6EB6#,   --  溶 (<CJK Ideograph>)
          13646 => 16#5BB9#,   --  容 (<CJK Ideograph>)
          13647 => 16#7ED2#,   --  绒 (<CJK Ideograph>)
          13648 => 16#5197#,   --  冗 (<CJK Ideograph>)
          13649 => 16#63C9#,   --  揉 (<CJK Ideograph>)
          13650 => 16#67D4#,   --  柔 (<CJK Ideograph>)
          13651 => 16#8089#,   --  肉 (<CJK Ideograph>)
          13652 => 16#8339#,   --  茹 (<CJK Ideograph>)
          13653 => 16#8815#,   --  蠕 (<CJK Ideograph>)
          13654 => 16#5112#,   --  儒 (<CJK Ideograph>)
          13655 => 16#5B7A#,   --  孺 (<CJK Ideograph>)
          13656 => 16#5982#,   --  如 (<CJK Ideograph>)
          13657 => 16#8FB1#,   --  辱 (<CJK Ideograph>)
          13658 => 16#4E73#,   --  乳 (<CJK Ideograph>)
          13659 => 16#6C5D#,   --  汝 (<CJK Ideograph>)
          13660 => 16#5165#,   --  入 (<CJK Ideograph>)
          13661 => 16#8925#,   --  褥 (<CJK Ideograph>)
          13662 => 16#8F6F#,   --  软 (<CJK Ideograph>)
          13663 => 16#962E#,   --  阮 (<CJK Ideograph>)
          13664 => 16#854A#,   --  蕊 (<CJK Ideograph>)
          13665 => 16#745E#,   --  瑞 (<CJK Ideograph>)
          13666 => 16#9510#,   --  锐 (<CJK Ideograph>)
          13667 => 16#95F0#,   --  闰 (<CJK Ideograph>)
          13668 => 16#6DA6#,   --  润 (<CJK Ideograph>)
          13669 => 16#82E5#,   --  若 (<CJK Ideograph>)
          13670 => 16#5F31#,   --  弱 (<CJK Ideograph>)
          13671 => 16#6492#,   --  撒 (<CJK Ideograph>)
          13672 => 16#6D12#,   --  洒 (<CJK Ideograph>)
          13673 => 16#8428#,   --  萨 (<CJK Ideograph>)
          13674 => 16#816E#,   --  腮 (<CJK Ideograph>)
          13675 => 16#9CC3#,   --  鳃 (<CJK Ideograph>)
          13676 => 16#585E#,   --  塞 (<CJK Ideograph>)
          13677 => 16#8D5B#,   --  赛 (<CJK Ideograph>)
          13678 => 16#4E09#,   --  三 (<CJK Ideograph>)
          13679 => 16#53C1#,   --  叁 (<CJK Ideograph>)
          13680 => 16#847D#,   --  葽 (<CJK Ideograph>)
          13681 => 16#847E#,   --  葾 (<CJK Ideograph>)
          13682 => 16#847F#,   --  葿 (<CJK Ideograph>)
          13683 => 16#8480#,   --  蒀 (<CJK Ideograph>)
          13684 => 16#8481#,   --  蒁 (<CJK Ideograph>)
          13685 => 16#8483#,   --  蒃 (<CJK Ideograph>)
          13686 => 16#8484#,   --  蒄 (<CJK Ideograph>)
          13687 => 16#8485#,   --  蒅 (<CJK Ideograph>)
          13688 => 16#8486#,   --  蒆 (<CJK Ideograph>)
          13689 => 16#848A#,   --  蒊 (<CJK Ideograph>)
          13690 => 16#848D#,   --  蒍 (<CJK Ideograph>)
          13691 => 16#848F#,   --  蒏 (<CJK Ideograph>)
          13692 => 16#8490#,   --  蒐 (<CJK Ideograph>)
          13693 => 16#8491#,   --  蒑 (<CJK Ideograph>)
          13694 => 16#8492#,   --  蒒 (<CJK Ideograph>)
          13695 => 16#8493#,   --  蒓 (<CJK Ideograph>)
          13696 => 16#8494#,   --  蒔 (<CJK Ideograph>)
          13697 => 16#8495#,   --  蒕 (<CJK Ideograph>)
          13698 => 16#8496#,   --  蒖 (<CJK Ideograph>)
          13699 => 16#8498#,   --  蒘 (<CJK Ideograph>)
          13700 => 16#849A#,   --  蒚 (<CJK Ideograph>)
          13701 => 16#849B#,   --  蒛 (<CJK Ideograph>)
          13702 => 16#849D#,   --  蒝 (<CJK Ideograph>)
          13703 => 16#849E#,   --  蒞 (<CJK Ideograph>)
          13704 => 16#849F#,   --  蒟 (<CJK Ideograph>)
          13705 => 16#84A0#,   --  蒠 (<CJK Ideograph>)
          13706 => 16#84A2#,   --  蒢 (<CJK Ideograph>)
          13707 => 16#84A3#,   --  蒣 (<CJK Ideograph>)
          13708 => 16#84A4#,   --  蒤 (<CJK Ideograph>)
          13709 => 16#84A5#,   --  蒥 (<CJK Ideograph>)
          13710 => 16#84A6#,   --  蒦 (<CJK Ideograph>)
          13711 => 16#84A7#,   --  蒧 (<CJK Ideograph>)
          13712 => 16#84A8#,   --  蒨 (<CJK Ideograph>)
          13713 => 16#84A9#,   --  蒩 (<CJK Ideograph>)
          13714 => 16#84AA#,   --  蒪 (<CJK Ideograph>)
          13715 => 16#84AB#,   --  蒫 (<CJK Ideograph>)
          13716 => 16#84AC#,   --  蒬 (<CJK Ideograph>)
          13717 => 16#84AD#,   --  蒭 (<CJK Ideograph>)
          13718 => 16#84AE#,   --  蒮 (<CJK Ideograph>)
          13719 => 16#84B0#,   --  蒰 (<CJK Ideograph>)
          13720 => 16#84B1#,   --  蒱 (<CJK Ideograph>)
          13721 => 16#84B3#,   --  蒳 (<CJK Ideograph>)
          13722 => 16#84B5#,   --  蒵 (<CJK Ideograph>)
          13723 => 16#84B6#,   --  蒶 (<CJK Ideograph>)
          13724 => 16#84B7#,   --  蒷 (<CJK Ideograph>)
          13725 => 16#84BB#,   --  蒻 (<CJK Ideograph>)
          13726 => 16#84BC#,   --  蒼 (<CJK Ideograph>)
          13727 => 16#84BE#,   --  蒾 (<CJK Ideograph>)
          13728 => 16#84C0#,   --  蓀 (<CJK Ideograph>)
          13729 => 16#84C2#,   --  蓂 (<CJK Ideograph>)
          13730 => 16#84C3#,   --  蓃 (<CJK Ideograph>)
          13731 => 16#84C5#,   --  蓅 (<CJK Ideograph>)
          13732 => 16#84C6#,   --  蓆 (<CJK Ideograph>)
          13733 => 16#84C7#,   --  蓇 (<CJK Ideograph>)
          13734 => 16#84C8#,   --  蓈 (<CJK Ideograph>)
          13735 => 16#84CB#,   --  蓋 (<CJK Ideograph>)
          13736 => 16#84CC#,   --  蓌 (<CJK Ideograph>)
          13737 => 16#84CE#,   --  蓎 (<CJK Ideograph>)
          13738 => 16#84CF#,   --  蓏 (<CJK Ideograph>)
          13739 => 16#84D2#,   --  蓒 (<CJK Ideograph>)
          13740 => 16#84D4#,   --  蓔 (<CJK Ideograph>)
          13741 => 16#84D5#,   --  蓕 (<CJK Ideograph>)
          13742 => 16#84D7#,   --  蓗 (<CJK Ideograph>)
          13743 => 16#84D8#,   --  蓘 (<CJK Ideograph>)
          13744 => 16#84D9#,   --  蓙 (<CJK Ideograph>)
          13745 => 16#84DA#,   --  蓚 (<CJK Ideograph>)
          13746 => 16#84DB#,   --  蓛 (<CJK Ideograph>)
          13747 => 16#84DC#,   --  蓜 (<CJK Ideograph>)
          13748 => 16#84DE#,   --  蓞 (<CJK Ideograph>)
          13749 => 16#84E1#,   --  蓡 (<CJK Ideograph>)
          13750 => 16#84E2#,   --  蓢 (<CJK Ideograph>)
          13751 => 16#84E4#,   --  蓤 (<CJK Ideograph>)
          13752 => 16#84E7#,   --  蓧 (<CJK Ideograph>)
          13753 => 16#84E8#,   --  蓨 (<CJK Ideograph>)
          13754 => 16#84E9#,   --  蓩 (<CJK Ideograph>)
          13755 => 16#84EA#,   --  蓪 (<CJK Ideograph>)
          13756 => 16#84EB#,   --  蓫 (<CJK Ideograph>)
          13757 => 16#84ED#,   --  蓭 (<CJK Ideograph>)
          13758 => 16#84EE#,   --  蓮 (<CJK Ideograph>)
          13759 => 16#84EF#,   --  蓯 (<CJK Ideograph>)
          13760 => 16#84F1#,   --  蓱 (<CJK Ideograph>)
          13761 => 16#84F2#,   --  蓲 (<CJK Ideograph>)
          13762 => 16#84F3#,   --  蓳 (<CJK Ideograph>)
          13763 => 16#84F4#,   --  蓴 (<CJK Ideograph>)
          13764 => 16#84F5#,   --  蓵 (<CJK Ideograph>)
          13765 => 16#84F6#,   --  蓶 (<CJK Ideograph>)
          13766 => 16#84F7#,   --  蓷 (<CJK Ideograph>)
          13767 => 16#84F8#,   --  蓸 (<CJK Ideograph>)
          13768 => 16#84F9#,   --  蓹 (<CJK Ideograph>)
          13769 => 16#84FA#,   --  蓺 (<CJK Ideograph>)
          13770 => 16#84FB#,   --  蓻 (<CJK Ideograph>)
          13771 => 16#84FD#,   --  蓽 (<CJK Ideograph>)
          13772 => 16#84FE#,   --  蓾 (<CJK Ideograph>)
          13773 => 16#8500#,   --  蔀 (<CJK Ideograph>)
          13774 => 16#8501#,   --  蔁 (<CJK Ideograph>)
          13775 => 16#8502#,   --  蔂 (<CJK Ideograph>)
          13776 => 16#4F1E#,   --  伞 (<CJK Ideograph>)
          13777 => 16#6563#,   --  散 (<CJK Ideograph>)
          13778 => 16#6851#,   --  桑 (<CJK Ideograph>)
          13779 => 16#55D3#,   --  嗓 (<CJK Ideograph>)
          13780 => 16#4E27#,   --  丧 (<CJK Ideograph>)
          13781 => 16#6414#,   --  搔 (<CJK Ideograph>)
          13782 => 16#9A9A#,   --  骚 (<CJK Ideograph>)
          13783 => 16#626B#,   --  扫 (<CJK Ideograph>)
          13784 => 16#5AC2#,   --  嫂 (<CJK Ideograph>)
          13785 => 16#745F#,   --  瑟 (<CJK Ideograph>)
          13786 => 16#8272#,   --  色 (<CJK Ideograph>)
          13787 => 16#6DA9#,   --  涩 (<CJK Ideograph>)
          13788 => 16#68EE#,   --  森 (<CJK Ideograph>)
          13789 => 16#50E7#,   --  僧 (<CJK Ideograph>)
          13790 => 16#838E#,   --  莎 (<CJK Ideograph>)
          13791 => 16#7802#,   --  砂 (<CJK Ideograph>)
          13792 => 16#6740#,   --  杀 (<CJK Ideograph>)
          13793 => 16#5239#,   --  刹 (<CJK Ideograph>)
          13794 => 16#6C99#,   --  沙 (<CJK Ideograph>)
          13795 => 16#7EB1#,   --  纱 (<CJK Ideograph>)
          13796 => 16#50BB#,   --  傻 (<CJK Ideograph>)
          13797 => 16#5565#,   --  啥 (<CJK Ideograph>)
          13798 => 16#715E#,   --  煞 (<CJK Ideograph>)
          13799 => 16#7B5B#,   --  筛 (<CJK Ideograph>)
          13800 => 16#6652#,   --  晒 (<CJK Ideograph>)
          13801 => 16#73CA#,   --  珊 (<CJK Ideograph>)
          13802 => 16#82EB#,   --  苫 (<CJK Ideograph>)
          13803 => 16#6749#,   --  杉 (<CJK Ideograph>)
          13804 => 16#5C71#,   --  山 (<CJK Ideograph>)
          13805 => 16#5220#,   --  删 (<CJK Ideograph>)
          13806 => 16#717D#,   --  煽 (<CJK Ideograph>)
          13807 => 16#886B#,   --  衫 (<CJK Ideograph>)
          13808 => 16#95EA#,   --  闪 (<CJK Ideograph>)
          13809 => 16#9655#,   --  陕 (<CJK Ideograph>)
          13810 => 16#64C5#,   --  擅 (<CJK Ideograph>)
          13811 => 16#8D61#,   --  赡 (<CJK Ideograph>)
          13812 => 16#81B3#,   --  膳 (<CJK Ideograph>)
          13813 => 16#5584#,   --  善 (<CJK Ideograph>)
          13814 => 16#6C55#,   --  汕 (<CJK Ideograph>)
          13815 => 16#6247#,   --  扇 (<CJK Ideograph>)
          13816 => 16#7F2E#,   --  缮 (<CJK Ideograph>)
          13817 => 16#5892#,   --  墒 (<CJK Ideograph>)
          13818 => 16#4F24#,   --  伤 (<CJK Ideograph>)
          13819 => 16#5546#,   --  商 (<CJK Ideograph>)
          13820 => 16#8D4F#,   --  赏 (<CJK Ideograph>)
          13821 => 16#664C#,   --  晌 (<CJK Ideograph>)
          13822 => 16#4E0A#,   --  上 (<CJK Ideograph>)
          13823 => 16#5C1A#,   --  尚 (<CJK Ideograph>)
          13824 => 16#88F3#,   --  裳 (<CJK Ideograph>)
          13825 => 16#68A2#,   --  梢 (<CJK Ideograph>)
          13826 => 16#634E#,   --  捎 (<CJK Ideograph>)
          13827 => 16#7A0D#,   --  稍 (<CJK Ideograph>)
          13828 => 16#70E7#,   --  烧 (<CJK Ideograph>)
          13829 => 16#828D#,   --  芍 (<CJK Ideograph>)
          13830 => 16#52FA#,   --  勺 (<CJK Ideograph>)
          13831 => 16#97F6#,   --  韶 (<CJK Ideograph>)
          13832 => 16#5C11#,   --  少 (<CJK Ideograph>)
          13833 => 16#54E8#,   --  哨 (<CJK Ideograph>)
          13834 => 16#90B5#,   --  邵 (<CJK Ideograph>)
          13835 => 16#7ECD#,   --  绍 (<CJK Ideograph>)
          13836 => 16#5962#,   --  奢 (<CJK Ideograph>)
          13837 => 16#8D4A#,   --  赊 (<CJK Ideograph>)
          13838 => 16#86C7#,   --  蛇 (<CJK Ideograph>)
          13839 => 16#820C#,   --  舌 (<CJK Ideograph>)
          13840 => 16#820D#,   --  舍 (<CJK Ideograph>)
          13841 => 16#8D66#,   --  赦 (<CJK Ideograph>)
          13842 => 16#6444#,   --  摄 (<CJK Ideograph>)
          13843 => 16#5C04#,   --  射 (<CJK Ideograph>)
          13844 => 16#6151#,   --  慑 (<CJK Ideograph>)
          13845 => 16#6D89#,   --  涉 (<CJK Ideograph>)
          13846 => 16#793E#,   --  社 (<CJK Ideograph>)
          13847 => 16#8BBE#,   --  设 (<CJK Ideograph>)
          13848 => 16#7837#,   --  砷 (<CJK Ideograph>)
          13849 => 16#7533#,   --  申 (<CJK Ideograph>)
          13850 => 16#547B#,   --  呻 (<CJK Ideograph>)
          13851 => 16#4F38#,   --  伸 (<CJK Ideograph>)
          13852 => 16#8EAB#,   --  身 (<CJK Ideograph>)
          13853 => 16#6DF1#,   --  深 (<CJK Ideograph>)
          13854 => 16#5A20#,   --  娠 (<CJK Ideograph>)
          13855 => 16#7EC5#,   --  绅 (<CJK Ideograph>)
          13856 => 16#795E#,   --  神 (<CJK Ideograph>)
          13857 => 16#6C88#,   --  沈 (<CJK Ideograph>)
          13858 => 16#5BA1#,   --  审 (<CJK Ideograph>)
          13859 => 16#5A76#,   --  婶 (<CJK Ideograph>)
          13860 => 16#751A#,   --  甚 (<CJK Ideograph>)
          13861 => 16#80BE#,   --  肾 (<CJK Ideograph>)
          13862 => 16#614E#,   --  慎 (<CJK Ideograph>)
          13863 => 16#6E17#,   --  渗 (<CJK Ideograph>)
          13864 => 16#58F0#,   --  声 (<CJK Ideograph>)
          13865 => 16#751F#,   --  生 (<CJK Ideograph>)
          13866 => 16#7525#,   --  甥 (<CJK Ideograph>)
          13867 => 16#7272#,   --  牲 (<CJK Ideograph>)
          13868 => 16#5347#,   --  升 (<CJK Ideograph>)
          13869 => 16#7EF3#,   --  绳 (<CJK Ideograph>)
          13870 => 16#8503#,   --  蔃 (<CJK Ideograph>)
          13871 => 16#8504#,   --  蔄 (<CJK Ideograph>)
          13872 => 16#8505#,   --  蔅 (<CJK Ideograph>)
          13873 => 16#8506#,   --  蔆 (<CJK Ideograph>)
          13874 => 16#8507#,   --  蔇 (<CJK Ideograph>)
          13875 => 16#8508#,   --  蔈 (<CJK Ideograph>)
          13876 => 16#8509#,   --  蔉 (<CJK Ideograph>)
          13877 => 16#850A#,   --  蔊 (<CJK Ideograph>)
          13878 => 16#850B#,   --  蔋 (<CJK Ideograph>)
          13879 => 16#850D#,   --  蔍 (<CJK Ideograph>)
          13880 => 16#850E#,   --  蔎 (<CJK Ideograph>)
          13881 => 16#850F#,   --  蔏 (<CJK Ideograph>)
          13882 => 16#8510#,   --  蔐 (<CJK Ideograph>)
          13883 => 16#8512#,   --  蔒 (<CJK Ideograph>)
          13884 => 16#8514#,   --  蔔 (<CJK Ideograph>)
          13885 => 16#8515#,   --  蔕 (<CJK Ideograph>)
          13886 => 16#8516#,   --  蔖 (<CJK Ideograph>)
          13887 => 16#8518#,   --  蔘 (<CJK Ideograph>)
          13888 => 16#8519#,   --  蔙 (<CJK Ideograph>)
          13889 => 16#851B#,   --  蔛 (<CJK Ideograph>)
          13890 => 16#851C#,   --  蔜 (<CJK Ideograph>)
          13891 => 16#851D#,   --  蔝 (<CJK Ideograph>)
          13892 => 16#851E#,   --  蔞 (<CJK Ideograph>)
          13893 => 16#8520#,   --  蔠 (<CJK Ideograph>)
          13894 => 16#8522#,   --  蔢 (<CJK Ideograph>)
          13895 => 16#8523#,   --  蔣 (<CJK Ideograph>)
          13896 => 16#8524#,   --  蔤 (<CJK Ideograph>)
          13897 => 16#8525#,   --  蔥 (<CJK Ideograph>)
          13898 => 16#8526#,   --  蔦 (<CJK Ideograph>)
          13899 => 16#8527#,   --  蔧 (<CJK Ideograph>)
          13900 => 16#8528#,   --  蔨 (<CJK Ideograph>)
          13901 => 16#8529#,   --  蔩 (<CJK Ideograph>)
          13902 => 16#852A#,   --  蔪 (<CJK Ideograph>)
          13903 => 16#852D#,   --  蔭 (<CJK Ideograph>)
          13904 => 16#852E#,   --  蔮 (<CJK Ideograph>)
          13905 => 16#852F#,   --  蔯 (<CJK Ideograph>)
          13906 => 16#8530#,   --  蔰 (<CJK Ideograph>)
          13907 => 16#8531#,   --  蔱 (<CJK Ideograph>)
          13908 => 16#8532#,   --  蔲 (<CJK Ideograph>)
          13909 => 16#8533#,   --  蔳 (<CJK Ideograph>)
          13910 => 16#8534#,   --  蔴 (<CJK Ideograph>)
          13911 => 16#8535#,   --  蔵 (<CJK Ideograph>)
          13912 => 16#8536#,   --  蔶 (<CJK Ideograph>)
          13913 => 16#853E#,   --  蔾 (<CJK Ideograph>)
          13914 => 16#853F#,   --  蔿 (<CJK Ideograph>)
          13915 => 16#8540#,   --  蕀 (<CJK Ideograph>)
          13916 => 16#8541#,   --  蕁 (<CJK Ideograph>)
          13917 => 16#8542#,   --  蕂 (<CJK Ideograph>)
          13918 => 16#8544#,   --  蕄 (<CJK Ideograph>)
          13919 => 16#8545#,   --  蕅 (<CJK Ideograph>)
          13920 => 16#8546#,   --  蕆 (<CJK Ideograph>)
          13921 => 16#8547#,   --  蕇 (<CJK Ideograph>)
          13922 => 16#854B#,   --  蕋 (<CJK Ideograph>)
          13923 => 16#854C#,   --  蕌 (<CJK Ideograph>)
          13924 => 16#854D#,   --  蕍 (<CJK Ideograph>)
          13925 => 16#854E#,   --  蕎 (<CJK Ideograph>)
          13926 => 16#854F#,   --  蕏 (<CJK Ideograph>)
          13927 => 16#8550#,   --  蕐 (<CJK Ideograph>)
          13928 => 16#8551#,   --  蕑 (<CJK Ideograph>)
          13929 => 16#8552#,   --  蕒 (<CJK Ideograph>)
          13930 => 16#8553#,   --  蕓 (<CJK Ideograph>)
          13931 => 16#8554#,   --  蕔 (<CJK Ideograph>)
          13932 => 16#8555#,   --  蕕 (<CJK Ideograph>)
          13933 => 16#8557#,   --  蕗 (<CJK Ideograph>)
          13934 => 16#8558#,   --  蕘 (<CJK Ideograph>)
          13935 => 16#855A#,   --  蕚 (<CJK Ideograph>)
          13936 => 16#855B#,   --  蕛 (<CJK Ideograph>)
          13937 => 16#855C#,   --  蕜 (<CJK Ideograph>)
          13938 => 16#855D#,   --  蕝 (<CJK Ideograph>)
          13939 => 16#855F#,   --  蕟 (<CJK Ideograph>)
          13940 => 16#8560#,   --  蕠 (<CJK Ideograph>)
          13941 => 16#8561#,   --  蕡 (<CJK Ideograph>)
          13942 => 16#8562#,   --  蕢 (<CJK Ideograph>)
          13943 => 16#8563#,   --  蕣 (<CJK Ideograph>)
          13944 => 16#8565#,   --  蕥 (<CJK Ideograph>)
          13945 => 16#8566#,   --  蕦 (<CJK Ideograph>)
          13946 => 16#8567#,   --  蕧 (<CJK Ideograph>)
          13947 => 16#8569#,   --  蕩 (<CJK Ideograph>)
          13948 => 16#856A#,   --  蕪 (<CJK Ideograph>)
          13949 => 16#856B#,   --  蕫 (<CJK Ideograph>)
          13950 => 16#856C#,   --  蕬 (<CJK Ideograph>)
          13951 => 16#856D#,   --  蕭 (<CJK Ideograph>)
          13952 => 16#856E#,   --  蕮 (<CJK Ideograph>)
          13953 => 16#856F#,   --  蕯 (<CJK Ideograph>)
          13954 => 16#8570#,   --  蕰 (<CJK Ideograph>)
          13955 => 16#8571#,   --  蕱 (<CJK Ideograph>)
          13956 => 16#8573#,   --  蕳 (<CJK Ideograph>)
          13957 => 16#8575#,   --  蕵 (<CJK Ideograph>)
          13958 => 16#8576#,   --  蕶 (<CJK Ideograph>)
          13959 => 16#8577#,   --  蕷 (<CJK Ideograph>)
          13960 => 16#8578#,   --  蕸 (<CJK Ideograph>)
          13961 => 16#857C#,   --  蕼 (<CJK Ideograph>)
          13962 => 16#857D#,   --  蕽 (<CJK Ideograph>)
          13963 => 16#857F#,   --  蕿 (<CJK Ideograph>)
          13964 => 16#8580#,   --  薀 (<CJK Ideograph>)
          13965 => 16#8581#,   --  薁 (<CJK Ideograph>)
          13966 => 16#7701#,   --  省 (<CJK Ideograph>)
          13967 => 16#76DB#,   --  盛 (<CJK Ideograph>)
          13968 => 16#5269#,   --  剩 (<CJK Ideograph>)
          13969 => 16#80DC#,   --  胜 (<CJK Ideograph>)
          13970 => 16#5723#,   --  圣 (<CJK Ideograph>)
          13971 => 16#5E08#,   --  师 (<CJK Ideograph>)
          13972 => 16#5931#,   --  失 (<CJK Ideograph>)
          13973 => 16#72EE#,   --  狮 (<CJK Ideograph>)
          13974 => 16#65BD#,   --  施 (<CJK Ideograph>)
          13975 => 16#6E7F#,   --  湿 (<CJK Ideograph>)
          13976 => 16#8BD7#,   --  诗 (<CJK Ideograph>)
          13977 => 16#5C38#,   --  尸 (<CJK Ideograph>)
          13978 => 16#8671#,   --  虱 (<CJK Ideograph>)
          13979 => 16#5341#,   --  十 (<CJK Ideograph>)
          13980 => 16#77F3#,   --  石 (<CJK Ideograph>)
          13981 => 16#62FE#,   --  拾 (<CJK Ideograph>)
          13982 => 16#65F6#,   --  时 (<CJK Ideograph>)
          13983 => 16#4EC0#,   --  什 (<CJK Ideograph>)
          13984 => 16#98DF#,   --  食 (<CJK Ideograph>)
          13985 => 16#8680#,   --  蚀 (<CJK Ideograph>)
          13986 => 16#5B9E#,   --  实 (<CJK Ideograph>)
          13987 => 16#8BC6#,   --  识 (<CJK Ideograph>)
          13988 => 16#53F2#,   --  史 (<CJK Ideograph>)
          13989 => 16#77E2#,   --  矢 (<CJK Ideograph>)
          13990 => 16#4F7F#,   --  使 (<CJK Ideograph>)
          13991 => 16#5C4E#,   --  屎 (<CJK Ideograph>)
          13992 => 16#9A76#,   --  驶 (<CJK Ideograph>)
          13993 => 16#59CB#,   --  始 (<CJK Ideograph>)
          13994 => 16#5F0F#,   --  式 (<CJK Ideograph>)
          13995 => 16#793A#,   --  示 (<CJK Ideograph>)
          13996 => 16#58EB#,   --  士 (<CJK Ideograph>)
          13997 => 16#4E16#,   --  世 (<CJK Ideograph>)
          13998 => 16#67FF#,   --  柿 (<CJK Ideograph>)
          13999 => 16#4E8B#,   --  事 (<CJK Ideograph>)
          14000 => 16#62ED#,   --  拭 (<CJK Ideograph>)
          14001 => 16#8A93#,   --  誓 (<CJK Ideograph>)
          14002 => 16#901D#,   --  逝 (<CJK Ideograph>)
          14003 => 16#52BF#,   --  势 (<CJK Ideograph>)
          14004 => 16#662F#,   --  是 (<CJK Ideograph>)
          14005 => 16#55DC#,   --  嗜 (<CJK Ideograph>)
          14006 => 16#566C#,   --  噬 (<CJK Ideograph>)
          14007 => 16#9002#,   --  适 (<CJK Ideograph>)
          14008 => 16#4ED5#,   --  仕 (<CJK Ideograph>)
          14009 => 16#4F8D#,   --  侍 (<CJK Ideograph>)
          14010 => 16#91CA#,   --  释 (<CJK Ideograph>)
          14011 => 16#9970#,   --  饰 (<CJK Ideograph>)
          14012 => 16#6C0F#,   --  氏 (<CJK Ideograph>)
          14013 => 16#5E02#,   --  市 (<CJK Ideograph>)
          14014 => 16#6043#,   --  恃 (<CJK Ideograph>)
          14015 => 16#5BA4#,   --  室 (<CJK Ideograph>)
          14016 => 16#89C6#,   --  视 (<CJK Ideograph>)
          14017 => 16#8BD5#,   --  试 (<CJK Ideograph>)
          14018 => 16#6536#,   --  收 (<CJK Ideograph>)
          14019 => 16#624B#,   --  手 (<CJK Ideograph>)
          14020 => 16#9996#,   --  首 (<CJK Ideograph>)
          14021 => 16#5B88#,   --  守 (<CJK Ideograph>)
          14022 => 16#5BFF#,   --  寿 (<CJK Ideograph>)
          14023 => 16#6388#,   --  授 (<CJK Ideograph>)
          14024 => 16#552E#,   --  售 (<CJK Ideograph>)
          14025 => 16#53D7#,   --  受 (<CJK Ideograph>)
          14026 => 16#7626#,   --  瘦 (<CJK Ideograph>)
          14027 => 16#517D#,   --  兽 (<CJK Ideograph>)
          14028 => 16#852C#,   --  蔬 (<CJK Ideograph>)
          14029 => 16#67A2#,   --  枢 (<CJK Ideograph>)
          14030 => 16#68B3#,   --  梳 (<CJK Ideograph>)
          14031 => 16#6B8A#,   --  殊 (<CJK Ideograph>)
          14032 => 16#6292#,   --  抒 (<CJK Ideograph>)
          14033 => 16#8F93#,   --  输 (<CJK Ideograph>)
          14034 => 16#53D4#,   --  叔 (<CJK Ideograph>)
          14035 => 16#8212#,   --  舒 (<CJK Ideograph>)
          14036 => 16#6DD1#,   --  淑 (<CJK Ideograph>)
          14037 => 16#758F#,   --  疏 (<CJK Ideograph>)
          14038 => 16#4E66#,   --  书 (<CJK Ideograph>)
          14039 => 16#8D4E#,   --  赎 (<CJK Ideograph>)
          14040 => 16#5B70#,   --  孰 (<CJK Ideograph>)
          14041 => 16#719F#,   --  熟 (<CJK Ideograph>)
          14042 => 16#85AF#,   --  薯 (<CJK Ideograph>)
          14043 => 16#6691#,   --  暑 (<CJK Ideograph>)
          14044 => 16#66D9#,   --  曙 (<CJK Ideograph>)
          14045 => 16#7F72#,   --  署 (<CJK Ideograph>)
          14046 => 16#8700#,   --  蜀 (<CJK Ideograph>)
          14047 => 16#9ECD#,   --  黍 (<CJK Ideograph>)
          14048 => 16#9F20#,   --  鼠 (<CJK Ideograph>)
          14049 => 16#5C5E#,   --  属 (<CJK Ideograph>)
          14050 => 16#672F#,   --  术 (<CJK Ideograph>)
          14051 => 16#8FF0#,   --  述 (<CJK Ideograph>)
          14052 => 16#6811#,   --  树 (<CJK Ideograph>)
          14053 => 16#675F#,   --  束 (<CJK Ideograph>)
          14054 => 16#620D#,   --  戍 (<CJK Ideograph>)
          14055 => 16#7AD6#,   --  竖 (<CJK Ideograph>)
          14056 => 16#5885#,   --  墅 (<CJK Ideograph>)
          14057 => 16#5EB6#,   --  庶 (<CJK Ideograph>)
          14058 => 16#6570#,   --  数 (<CJK Ideograph>)
          14059 => 16#6F31#,   --  漱 (<CJK Ideograph>)
          14060 => 16#8582#,   --  薂 (<CJK Ideograph>)
          14061 => 16#8583#,   --  薃 (<CJK Ideograph>)
          14062 => 16#8586#,   --  薆 (<CJK Ideograph>)
          14063 => 16#8588#,   --  薈 (<CJK Ideograph>)
          14064 => 16#8589#,   --  薉 (<CJK Ideograph>)
          14065 => 16#858A#,   --  薊 (<CJK Ideograph>)
          14066 => 16#858B#,   --  薋 (<CJK Ideograph>)
          14067 => 16#858C#,   --  薌 (<CJK Ideograph>)
          14068 => 16#858D#,   --  薍 (<CJK Ideograph>)
          14069 => 16#858E#,   --  薎 (<CJK Ideograph>)
          14070 => 16#8590#,   --  薐 (<CJK Ideograph>)
          14071 => 16#8591#,   --  薑 (<CJK Ideograph>)
          14072 => 16#8592#,   --  薒 (<CJK Ideograph>)
          14073 => 16#8593#,   --  薓 (<CJK Ideograph>)
          14074 => 16#8594#,   --  薔 (<CJK Ideograph>)
          14075 => 16#8595#,   --  薕 (<CJK Ideograph>)
          14076 => 16#8596#,   --  薖 (<CJK Ideograph>)
          14077 => 16#8597#,   --  薗 (<CJK Ideograph>)
          14078 => 16#8598#,   --  薘 (<CJK Ideograph>)
          14079 => 16#8599#,   --  薙 (<CJK Ideograph>)
          14080 => 16#859A#,   --  薚 (<CJK Ideograph>)
          14081 => 16#859D#,   --  薝 (<CJK Ideograph>)
          14082 => 16#859E#,   --  薞 (<CJK Ideograph>)
          14083 => 16#859F#,   --  薟 (<CJK Ideograph>)
          14084 => 16#85A0#,   --  薠 (<CJK Ideograph>)
          14085 => 16#85A1#,   --  薡 (<CJK Ideograph>)
          14086 => 16#85A2#,   --  薢 (<CJK Ideograph>)
          14087 => 16#85A3#,   --  薣 (<CJK Ideograph>)
          14088 => 16#85A5#,   --  薥 (<CJK Ideograph>)
          14089 => 16#85A6#,   --  薦 (<CJK Ideograph>)
          14090 => 16#85A7#,   --  薧 (<CJK Ideograph>)
          14091 => 16#85A9#,   --  薩 (<CJK Ideograph>)
          14092 => 16#85AB#,   --  薫 (<CJK Ideograph>)
          14093 => 16#85AC#,   --  薬 (<CJK Ideograph>)
          14094 => 16#85AD#,   --  薭 (<CJK Ideograph>)
          14095 => 16#85B1#,   --  薱 (<CJK Ideograph>)
          14096 => 16#85B2#,   --  薲 (<CJK Ideograph>)
          14097 => 16#85B3#,   --  薳 (<CJK Ideograph>)
          14098 => 16#85B4#,   --  薴 (<CJK Ideograph>)
          14099 => 16#85B5#,   --  薵 (<CJK Ideograph>)
          14100 => 16#85B6#,   --  薶 (<CJK Ideograph>)
          14101 => 16#85B8#,   --  薸 (<CJK Ideograph>)
          14102 => 16#85BA#,   --  薺 (<CJK Ideograph>)
          14103 => 16#85BB#,   --  薻 (<CJK Ideograph>)
          14104 => 16#85BC#,   --  薼 (<CJK Ideograph>)
          14105 => 16#85BD#,   --  薽 (<CJK Ideograph>)
          14106 => 16#85BE#,   --  薾 (<CJK Ideograph>)
          14107 => 16#85BF#,   --  薿 (<CJK Ideograph>)
          14108 => 16#85C0#,   --  藀 (<CJK Ideograph>)
          14109 => 16#85C2#,   --  藂 (<CJK Ideograph>)
          14110 => 16#85C3#,   --  藃 (<CJK Ideograph>)
          14111 => 16#85C4#,   --  藄 (<CJK Ideograph>)
          14112 => 16#85C5#,   --  藅 (<CJK Ideograph>)
          14113 => 16#85C6#,   --  藆 (<CJK Ideograph>)
          14114 => 16#85C7#,   --  藇 (<CJK Ideograph>)
          14115 => 16#85C8#,   --  藈 (<CJK Ideograph>)
          14116 => 16#85CA#,   --  藊 (<CJK Ideograph>)
          14117 => 16#85CB#,   --  藋 (<CJK Ideograph>)
          14118 => 16#85CC#,   --  藌 (<CJK Ideograph>)
          14119 => 16#85CD#,   --  藍 (<CJK Ideograph>)
          14120 => 16#85CE#,   --  藎 (<CJK Ideograph>)
          14121 => 16#85D1#,   --  藑 (<CJK Ideograph>)
          14122 => 16#85D2#,   --  藒 (<CJK Ideograph>)
          14123 => 16#85D4#,   --  藔 (<CJK Ideograph>)
          14124 => 16#85D6#,   --  藖 (<CJK Ideograph>)
          14125 => 16#85D7#,   --  藗 (<CJK Ideograph>)
          14126 => 16#85D8#,   --  藘 (<CJK Ideograph>)
          14127 => 16#85D9#,   --  藙 (<CJK Ideograph>)
          14128 => 16#85DA#,   --  藚 (<CJK Ideograph>)
          14129 => 16#85DB#,   --  藛 (<CJK Ideograph>)
          14130 => 16#85DD#,   --  藝 (<CJK Ideograph>)
          14131 => 16#85DE#,   --  藞 (<CJK Ideograph>)
          14132 => 16#85DF#,   --  藟 (<CJK Ideograph>)
          14133 => 16#85E0#,   --  藠 (<CJK Ideograph>)
          14134 => 16#85E1#,   --  藡 (<CJK Ideograph>)
          14135 => 16#85E2#,   --  藢 (<CJK Ideograph>)
          14136 => 16#85E3#,   --  藣 (<CJK Ideograph>)
          14137 => 16#85E5#,   --  藥 (<CJK Ideograph>)
          14138 => 16#85E6#,   --  藦 (<CJK Ideograph>)
          14139 => 16#85E7#,   --  藧 (<CJK Ideograph>)
          14140 => 16#85E8#,   --  藨 (<CJK Ideograph>)
          14141 => 16#85EA#,   --  藪 (<CJK Ideograph>)
          14142 => 16#85EB#,   --  藫 (<CJK Ideograph>)
          14143 => 16#85EC#,   --  藬 (<CJK Ideograph>)
          14144 => 16#85ED#,   --  藭 (<CJK Ideograph>)
          14145 => 16#85EE#,   --  藮 (<CJK Ideograph>)
          14146 => 16#85EF#,   --  藯 (<CJK Ideograph>)
          14147 => 16#85F0#,   --  藰 (<CJK Ideograph>)
          14148 => 16#85F1#,   --  藱 (<CJK Ideograph>)
          14149 => 16#85F2#,   --  藲 (<CJK Ideograph>)
          14150 => 16#85F3#,   --  藳 (<CJK Ideograph>)
          14151 => 16#85F4#,   --  藴 (<CJK Ideograph>)
          14152 => 16#85F5#,   --  藵 (<CJK Ideograph>)
          14153 => 16#85F6#,   --  藶 (<CJK Ideograph>)
          14154 => 16#85F7#,   --  藷 (<CJK Ideograph>)
          14155 => 16#85F8#,   --  藸 (<CJK Ideograph>)
          14156 => 16#6055#,   --  恕 (<CJK Ideograph>)
          14157 => 16#5237#,   --  刷 (<CJK Ideograph>)
          14158 => 16#800D#,   --  耍 (<CJK Ideograph>)
          14159 => 16#6454#,   --  摔 (<CJK Ideograph>)
          14160 => 16#8870#,   --  衰 (<CJK Ideograph>)
          14161 => 16#7529#,   --  甩 (<CJK Ideograph>)
          14162 => 16#5E05#,   --  帅 (<CJK Ideograph>)
          14163 => 16#6813#,   --  栓 (<CJK Ideograph>)
          14164 => 16#62F4#,   --  拴 (<CJK Ideograph>)
          14165 => 16#971C#,   --  霜 (<CJK Ideograph>)
          14166 => 16#53CC#,   --  双 (<CJK Ideograph>)
          14167 => 16#723D#,   --  爽 (<CJK Ideograph>)
          14168 => 16#8C01#,   --  谁 (<CJK Ideograph>)
          14169 => 16#6C34#,   --  水 (<CJK Ideograph>)
          14170 => 16#7761#,   --  睡 (<CJK Ideograph>)
          14171 => 16#7A0E#,   --  税 (<CJK Ideograph>)
          14172 => 16#542E#,   --  吮 (<CJK Ideograph>)
          14173 => 16#77AC#,   --  瞬 (<CJK Ideograph>)
          14174 => 16#987A#,   --  顺 (<CJK Ideograph>)
          14175 => 16#821C#,   --  舜 (<CJK Ideograph>)
          14176 => 16#8BF4#,   --  说 (<CJK Ideograph>)
          14177 => 16#7855#,   --  硕 (<CJK Ideograph>)
          14178 => 16#6714#,   --  朔 (<CJK Ideograph>)
          14179 => 16#70C1#,   --  烁 (<CJK Ideograph>)
          14180 => 16#65AF#,   --  斯 (<CJK Ideograph>)
          14181 => 16#6495#,   --  撕 (<CJK Ideograph>)
          14182 => 16#5636#,   --  嘶 (<CJK Ideograph>)
          14183 => 16#601D#,   --  思 (<CJK Ideograph>)
          14184 => 16#79C1#,   --  私 (<CJK Ideograph>)
          14185 => 16#53F8#,   --  司 (<CJK Ideograph>)
          14186 => 16#4E1D#,   --  丝 (<CJK Ideograph>)
          14187 => 16#6B7B#,   --  死 (<CJK Ideograph>)
          14188 => 16#8086#,   --  肆 (<CJK Ideograph>)
          14189 => 16#5BFA#,   --  寺 (<CJK Ideograph>)
          14190 => 16#55E3#,   --  嗣 (<CJK Ideograph>)
          14191 => 16#56DB#,   --  四 (<CJK Ideograph>)
          14192 => 16#4F3A#,   --  伺 (<CJK Ideograph>)
          14193 => 16#4F3C#,   --  似 (<CJK Ideograph>)
          14194 => 16#9972#,   --  饲 (<CJK Ideograph>)
          14195 => 16#5DF3#,   --  巳 (<CJK Ideograph>)
          14196 => 16#677E#,   --  松 (<CJK Ideograph>)
          14197 => 16#8038#,   --  耸 (<CJK Ideograph>)
          14198 => 16#6002#,   --  怂 (<CJK Ideograph>)
          14199 => 16#9882#,   --  颂 (<CJK Ideograph>)
          14200 => 16#9001#,   --  送 (<CJK Ideograph>)
          14201 => 16#5B8B#,   --  宋 (<CJK Ideograph>)
          14202 => 16#8BBC#,   --  讼 (<CJK Ideograph>)
          14203 => 16#8BF5#,   --  诵 (<CJK Ideograph>)
          14204 => 16#641C#,   --  搜 (<CJK Ideograph>)
          14205 => 16#8258#,   --  艘 (<CJK Ideograph>)
          14206 => 16#64DE#,   --  擞 (<CJK Ideograph>)
          14207 => 16#55FD#,   --  嗽 (<CJK Ideograph>)
          14208 => 16#82CF#,   --  苏 (<CJK Ideograph>)
          14209 => 16#9165#,   --  酥 (<CJK Ideograph>)
          14210 => 16#4FD7#,   --  俗 (<CJK Ideograph>)
          14211 => 16#7D20#,   --  素 (<CJK Ideograph>)
          14212 => 16#901F#,   --  速 (<CJK Ideograph>)
          14213 => 16#7C9F#,   --  粟 (<CJK Ideograph>)
          14214 => 16#50F3#,   --  僳 (<CJK Ideograph>)
          14215 => 16#5851#,   --  塑 (<CJK Ideograph>)
          14216 => 16#6EAF#,   --  溯 (<CJK Ideograph>)
          14217 => 16#5BBF#,   --  宿 (<CJK Ideograph>)
          14218 => 16#8BC9#,   --  诉 (<CJK Ideograph>)
          14219 => 16#8083#,   --  肃 (<CJK Ideograph>)
          14220 => 16#9178#,   --  酸 (<CJK Ideograph>)
          14221 => 16#849C#,   --  蒜 (<CJK Ideograph>)
          14222 => 16#7B97#,   --  算 (<CJK Ideograph>)
          14223 => 16#867D#,   --  虽 (<CJK Ideograph>)
          14224 => 16#968B#,   --  隋 (<CJK Ideograph>)
          14225 => 16#968F#,   --  随 (<CJK Ideograph>)
          14226 => 16#7EE5#,   --  绥 (<CJK Ideograph>)
          14227 => 16#9AD3#,   --  髓 (<CJK Ideograph>)
          14228 => 16#788E#,   --  碎 (<CJK Ideograph>)
          14229 => 16#5C81#,   --  岁 (<CJK Ideograph>)
          14230 => 16#7A57#,   --  穗 (<CJK Ideograph>)
          14231 => 16#9042#,   --  遂 (<CJK Ideograph>)
          14232 => 16#96A7#,   --  隧 (<CJK Ideograph>)
          14233 => 16#795F#,   --  祟 (<CJK Ideograph>)
          14234 => 16#5B59#,   --  孙 (<CJK Ideograph>)
          14235 => 16#635F#,   --  损 (<CJK Ideograph>)
          14236 => 16#7B0B#,   --  笋 (<CJK Ideograph>)
          14237 => 16#84D1#,   --  蓑 (<CJK Ideograph>)
          14238 => 16#68AD#,   --  梭 (<CJK Ideograph>)
          14239 => 16#5506#,   --  唆 (<CJK Ideograph>)
          14240 => 16#7F29#,   --  缩 (<CJK Ideograph>)
          14241 => 16#7410#,   --  琐 (<CJK Ideograph>)
          14242 => 16#7D22#,   --  索 (<CJK Ideograph>)
          14243 => 16#9501#,   --  锁 (<CJK Ideograph>)
          14244 => 16#6240#,   --  所 (<CJK Ideograph>)
          14245 => 16#584C#,   --  塌 (<CJK Ideograph>)
          14246 => 16#4ED6#,   --  他 (<CJK Ideograph>)
          14247 => 16#5B83#,   --  它 (<CJK Ideograph>)
          14248 => 16#5979#,   --  她 (<CJK Ideograph>)
          14249 => 16#5854#,   --  塔 (<CJK Ideograph>)
          14250 => 16#85F9#,   --  藹 (<CJK Ideograph>)
          14251 => 16#85FA#,   --  藺 (<CJK Ideograph>)
          14252 => 16#85FC#,   --  藼 (<CJK Ideograph>)
          14253 => 16#85FD#,   --  藽 (<CJK Ideograph>)
          14254 => 16#85FE#,   --  藾 (<CJK Ideograph>)
          14255 => 16#8600#,   --  蘀 (<CJK Ideograph>)
          14256 => 16#8601#,   --  蘁 (<CJK Ideograph>)
          14257 => 16#8602#,   --  蘂 (<CJK Ideograph>)
          14258 => 16#8603#,   --  蘃 (<CJK Ideograph>)
          14259 => 16#8604#,   --  蘄 (<CJK Ideograph>)
          14260 => 16#8606#,   --  蘆 (<CJK Ideograph>)
          14261 => 16#8607#,   --  蘇 (<CJK Ideograph>)
          14262 => 16#8608#,   --  蘈 (<CJK Ideograph>)
          14263 => 16#8609#,   --  蘉 (<CJK Ideograph>)
          14264 => 16#860A#,   --  蘊 (<CJK Ideograph>)
          14265 => 16#860B#,   --  蘋 (<CJK Ideograph>)
          14266 => 16#860C#,   --  蘌 (<CJK Ideograph>)
          14267 => 16#860D#,   --  蘍 (<CJK Ideograph>)
          14268 => 16#860E#,   --  蘎 (<CJK Ideograph>)
          14269 => 16#860F#,   --  蘏 (<CJK Ideograph>)
          14270 => 16#8610#,   --  蘐 (<CJK Ideograph>)
          14271 => 16#8612#,   --  蘒 (<CJK Ideograph>)
          14272 => 16#8613#,   --  蘓 (<CJK Ideograph>)
          14273 => 16#8614#,   --  蘔 (<CJK Ideograph>)
          14274 => 16#8615#,   --  蘕 (<CJK Ideograph>)
          14275 => 16#8617#,   --  蘗 (<CJK Ideograph>)
          14276 => 16#8618#,   --  蘘 (<CJK Ideograph>)
          14277 => 16#8619#,   --  蘙 (<CJK Ideograph>)
          14278 => 16#861A#,   --  蘚 (<CJK Ideograph>)
          14279 => 16#861B#,   --  蘛 (<CJK Ideograph>)
          14280 => 16#861C#,   --  蘜 (<CJK Ideograph>)
          14281 => 16#861D#,   --  蘝 (<CJK Ideograph>)
          14282 => 16#861E#,   --  蘞 (<CJK Ideograph>)
          14283 => 16#861F#,   --  蘟 (<CJK Ideograph>)
          14284 => 16#8620#,   --  蘠 (<CJK Ideograph>)
          14285 => 16#8621#,   --  蘡 (<CJK Ideograph>)
          14286 => 16#8622#,   --  蘢 (<CJK Ideograph>)
          14287 => 16#8623#,   --  蘣 (<CJK Ideograph>)
          14288 => 16#8624#,   --  蘤 (<CJK Ideograph>)
          14289 => 16#8625#,   --  蘥 (<CJK Ideograph>)
          14290 => 16#8626#,   --  蘦 (<CJK Ideograph>)
          14291 => 16#8628#,   --  蘨 (<CJK Ideograph>)
          14292 => 16#862A#,   --  蘪 (<CJK Ideograph>)
          14293 => 16#862B#,   --  蘫 (<CJK Ideograph>)
          14294 => 16#862C#,   --  蘬 (<CJK Ideograph>)
          14295 => 16#862D#,   --  蘭 (<CJK Ideograph>)
          14296 => 16#862E#,   --  蘮 (<CJK Ideograph>)
          14297 => 16#862F#,   --  蘯 (<CJK Ideograph>)
          14298 => 16#8630#,   --  蘰 (<CJK Ideograph>)
          14299 => 16#8631#,   --  蘱 (<CJK Ideograph>)
          14300 => 16#8632#,   --  蘲 (<CJK Ideograph>)
          14301 => 16#8633#,   --  蘳 (<CJK Ideograph>)
          14302 => 16#8634#,   --  蘴 (<CJK Ideograph>)
          14303 => 16#8635#,   --  蘵 (<CJK Ideograph>)
          14304 => 16#8636#,   --  蘶 (<CJK Ideograph>)
          14305 => 16#8637#,   --  蘷 (<CJK Ideograph>)
          14306 => 16#8639#,   --  蘹 (<CJK Ideograph>)
          14307 => 16#863A#,   --  蘺 (<CJK Ideograph>)
          14308 => 16#863B#,   --  蘻 (<CJK Ideograph>)
          14309 => 16#863D#,   --  蘽 (<CJK Ideograph>)
          14310 => 16#863E#,   --  蘾 (<CJK Ideograph>)
          14311 => 16#863F#,   --  蘿 (<CJK Ideograph>)
          14312 => 16#8640#,   --  虀 (<CJK Ideograph>)
          14313 => 16#8641#,   --  虁 (<CJK Ideograph>)
          14314 => 16#8642#,   --  虂 (<CJK Ideograph>)
          14315 => 16#8643#,   --  虃 (<CJK Ideograph>)
          14316 => 16#8644#,   --  虄 (<CJK Ideograph>)
          14317 => 16#8645#,   --  虅 (<CJK Ideograph>)
          14318 => 16#8646#,   --  虆 (<CJK Ideograph>)
          14319 => 16#8647#,   --  虇 (<CJK Ideograph>)
          14320 => 16#8648#,   --  虈 (<CJK Ideograph>)
          14321 => 16#8649#,   --  虉 (<CJK Ideograph>)
          14322 => 16#864A#,   --  虊 (<CJK Ideograph>)
          14323 => 16#864B#,   --  虋 (<CJK Ideograph>)
          14324 => 16#864C#,   --  虌 (<CJK Ideograph>)
          14325 => 16#8652#,   --  虒 (<CJK Ideograph>)
          14326 => 16#8653#,   --  虓 (<CJK Ideograph>)
          14327 => 16#8655#,   --  處 (<CJK Ideograph>)
          14328 => 16#8656#,   --  虖 (<CJK Ideograph>)
          14329 => 16#8657#,   --  虗 (<CJK Ideograph>)
          14330 => 16#8658#,   --  虘 (<CJK Ideograph>)
          14331 => 16#8659#,   --  虙 (<CJK Ideograph>)
          14332 => 16#865B#,   --  虛 (<CJK Ideograph>)
          14333 => 16#865C#,   --  虜 (<CJK Ideograph>)
          14334 => 16#865D#,   --  虝 (<CJK Ideograph>)
          14335 => 16#865F#,   --  號 (<CJK Ideograph>)
          14336 => 16#8660#,   --  虠 (<CJK Ideograph>)
          14337 => 16#8661#,   --  虡 (<CJK Ideograph>)
          14338 => 16#8663#,   --  虣 (<CJK Ideograph>)
          14339 => 16#8664#,   --  虤 (<CJK Ideograph>)
          14340 => 16#8665#,   --  虥 (<CJK Ideograph>)
          14341 => 16#8666#,   --  虦 (<CJK Ideograph>)
          14342 => 16#8667#,   --  虧 (<CJK Ideograph>)
          14343 => 16#8668#,   --  虨 (<CJK Ideograph>)
          14344 => 16#8669#,   --  虩 (<CJK Ideograph>)
          14345 => 16#866A#,   --  虪 (<CJK Ideograph>)
          14346 => 16#736D#,   --  獭 (<CJK Ideograph>)
          14347 => 16#631E#,   --  挞 (<CJK Ideograph>)
          14348 => 16#8E4B#,   --  蹋 (<CJK Ideograph>)
          14349 => 16#8E0F#,   --  踏 (<CJK Ideograph>)
          14350 => 16#80CE#,   --  胎 (<CJK Ideograph>)
          14351 => 16#82D4#,   --  苔 (<CJK Ideograph>)
          14352 => 16#62AC#,   --  抬 (<CJK Ideograph>)
          14353 => 16#53F0#,   --  台 (<CJK Ideograph>)
          14354 => 16#6CF0#,   --  泰 (<CJK Ideograph>)
          14355 => 16#915E#,   --  酞 (<CJK Ideograph>)
          14356 => 16#592A#,   --  太 (<CJK Ideograph>)
          14357 => 16#6001#,   --  态 (<CJK Ideograph>)
          14358 => 16#6C70#,   --  汰 (<CJK Ideograph>)
          14359 => 16#574D#,   --  坍 (<CJK Ideograph>)
          14360 => 16#644A#,   --  摊 (<CJK Ideograph>)
          14361 => 16#8D2A#,   --  贪 (<CJK Ideograph>)
          14362 => 16#762B#,   --  瘫 (<CJK Ideograph>)
          14363 => 16#6EE9#,   --  滩 (<CJK Ideograph>)
          14364 => 16#575B#,   --  坛 (<CJK Ideograph>)
          14365 => 16#6A80#,   --  檀 (<CJK Ideograph>)
          14366 => 16#75F0#,   --  痰 (<CJK Ideograph>)
          14367 => 16#6F6D#,   --  潭 (<CJK Ideograph>)
          14368 => 16#8C2D#,   --  谭 (<CJK Ideograph>)
          14369 => 16#8C08#,   --  谈 (<CJK Ideograph>)
          14370 => 16#5766#,   --  坦 (<CJK Ideograph>)
          14371 => 16#6BEF#,   --  毯 (<CJK Ideograph>)
          14372 => 16#8892#,   --  袒 (<CJK Ideograph>)
          14373 => 16#78B3#,   --  碳 (<CJK Ideograph>)
          14374 => 16#63A2#,   --  探 (<CJK Ideograph>)
          14375 => 16#53F9#,   --  叹 (<CJK Ideograph>)
          14376 => 16#70AD#,   --  炭 (<CJK Ideograph>)
          14377 => 16#6C64#,   --  汤 (<CJK Ideograph>)
          14378 => 16#5858#,   --  塘 (<CJK Ideograph>)
          14379 => 16#642A#,   --  搪 (<CJK Ideograph>)
          14380 => 16#5802#,   --  堂 (<CJK Ideograph>)
          14381 => 16#68E0#,   --  棠 (<CJK Ideograph>)
          14382 => 16#819B#,   --  膛 (<CJK Ideograph>)
          14383 => 16#5510#,   --  唐 (<CJK Ideograph>)
          14384 => 16#7CD6#,   --  糖 (<CJK Ideograph>)
          14385 => 16#5018#,   --  倘 (<CJK Ideograph>)
          14386 => 16#8EBA#,   --  躺 (<CJK Ideograph>)
          14387 => 16#6DCC#,   --  淌 (<CJK Ideograph>)
          14388 => 16#8D9F#,   --  趟 (<CJK Ideograph>)
          14389 => 16#70EB#,   --  烫 (<CJK Ideograph>)
          14390 => 16#638F#,   --  掏 (<CJK Ideograph>)
          14391 => 16#6D9B#,   --  涛 (<CJK Ideograph>)
          14392 => 16#6ED4#,   --  滔 (<CJK Ideograph>)
          14393 => 16#7EE6#,   --  绦 (<CJK Ideograph>)
          14394 => 16#8404#,   --  萄 (<CJK Ideograph>)
          14395 => 16#6843#,   --  桃 (<CJK Ideograph>)
          14396 => 16#9003#,   --  逃 (<CJK Ideograph>)
          14397 => 16#6DD8#,   --  淘 (<CJK Ideograph>)
          14398 => 16#9676#,   --  陶 (<CJK Ideograph>)
          14399 => 16#8BA8#,   --  讨 (<CJK Ideograph>)
          14400 => 16#5957#,   --  套 (<CJK Ideograph>)
          14401 => 16#7279#,   --  特 (<CJK Ideograph>)
          14402 => 16#85E4#,   --  藤 (<CJK Ideograph>)
          14403 => 16#817E#,   --  腾 (<CJK Ideograph>)
          14404 => 16#75BC#,   --  疼 (<CJK Ideograph>)
          14405 => 16#8A8A#,   --  誊 (<CJK Ideograph>)
          14406 => 16#68AF#,   --  梯 (<CJK Ideograph>)
          14407 => 16#5254#,   --  剔 (<CJK Ideograph>)
          14408 => 16#8E22#,   --  踢 (<CJK Ideograph>)
          14409 => 16#9511#,   --  锑 (<CJK Ideograph>)
          14410 => 16#63D0#,   --  提 (<CJK Ideograph>)
          14411 => 16#9898#,   --  题 (<CJK Ideograph>)
          14412 => 16#8E44#,   --  蹄 (<CJK Ideograph>)
          14413 => 16#557C#,   --  啼 (<CJK Ideograph>)
          14414 => 16#4F53#,   --  体 (<CJK Ideograph>)
          14415 => 16#66FF#,   --  替 (<CJK Ideograph>)
          14416 => 16#568F#,   --  嚏 (<CJK Ideograph>)
          14417 => 16#60D5#,   --  惕 (<CJK Ideograph>)
          14418 => 16#6D95#,   --  涕 (<CJK Ideograph>)
          14419 => 16#5243#,   --  剃 (<CJK Ideograph>)
          14420 => 16#5C49#,   --  屉 (<CJK Ideograph>)
          14421 => 16#5929#,   --  天 (<CJK Ideograph>)
          14422 => 16#6DFB#,   --  添 (<CJK Ideograph>)
          14423 => 16#586B#,   --  填 (<CJK Ideograph>)
          14424 => 16#7530#,   --  田 (<CJK Ideograph>)
          14425 => 16#751C#,   --  甜 (<CJK Ideograph>)
          14426 => 16#606C#,   --  恬 (<CJK Ideograph>)
          14427 => 16#8214#,   --  舔 (<CJK Ideograph>)
          14428 => 16#8146#,   --  腆 (<CJK Ideograph>)
          14429 => 16#6311#,   --  挑 (<CJK Ideograph>)
          14430 => 16#6761#,   --  条 (<CJK Ideograph>)
          14431 => 16#8FE2#,   --  迢 (<CJK Ideograph>)
          14432 => 16#773A#,   --  眺 (<CJK Ideograph>)
          14433 => 16#8DF3#,   --  跳 (<CJK Ideograph>)
          14434 => 16#8D34#,   --  贴 (<CJK Ideograph>)
          14435 => 16#94C1#,   --  铁 (<CJK Ideograph>)
          14436 => 16#5E16#,   --  帖 (<CJK Ideograph>)
          14437 => 16#5385#,   --  厅 (<CJK Ideograph>)
          14438 => 16#542C#,   --  听 (<CJK Ideograph>)
          14439 => 16#70C3#,   --  烃 (<CJK Ideograph>)
          14440 => 16#866D#,   --  虭 (<CJK Ideograph>)
          14441 => 16#866F#,   --  虯 (<CJK Ideograph>)
          14442 => 16#8670#,   --  虰 (<CJK Ideograph>)
          14443 => 16#8672#,   --  虲 (<CJK Ideograph>)
          14444 => 16#8673#,   --  虳 (<CJK Ideograph>)
          14445 => 16#8674#,   --  虴 (<CJK Ideograph>)
          14446 => 16#8675#,   --  虵 (<CJK Ideograph>)
          14447 => 16#8676#,   --  虶 (<CJK Ideograph>)
          14448 => 16#8677#,   --  虷 (<CJK Ideograph>)
          14449 => 16#8678#,   --  虸 (<CJK Ideograph>)
          14450 => 16#8683#,   --  蚃 (<CJK Ideograph>)
          14451 => 16#8684#,   --  蚄 (<CJK Ideograph>)
          14452 => 16#8685#,   --  蚅 (<CJK Ideograph>)
          14453 => 16#8686#,   --  蚆 (<CJK Ideograph>)
          14454 => 16#8687#,   --  蚇 (<CJK Ideograph>)
          14455 => 16#8688#,   --  蚈 (<CJK Ideograph>)
          14456 => 16#8689#,   --  蚉 (<CJK Ideograph>)
          14457 => 16#868E#,   --  蚎 (<CJK Ideograph>)
          14458 => 16#868F#,   --  蚏 (<CJK Ideograph>)
          14459 => 16#8690#,   --  蚐 (<CJK Ideograph>)
          14460 => 16#8691#,   --  蚑 (<CJK Ideograph>)
          14461 => 16#8692#,   --  蚒 (<CJK Ideograph>)
          14462 => 16#8694#,   --  蚔 (<CJK Ideograph>)
          14463 => 16#8696#,   --  蚖 (<CJK Ideograph>)
          14464 => 16#8697#,   --  蚗 (<CJK Ideograph>)
          14465 => 16#8698#,   --  蚘 (<CJK Ideograph>)
          14466 => 16#8699#,   --  蚙 (<CJK Ideograph>)
          14467 => 16#869A#,   --  蚚 (<CJK Ideograph>)
          14468 => 16#869B#,   --  蚛 (<CJK Ideograph>)
          14469 => 16#869E#,   --  蚞 (<CJK Ideograph>)
          14470 => 16#869F#,   --  蚟 (<CJK Ideograph>)
          14471 => 16#86A0#,   --  蚠 (<CJK Ideograph>)
          14472 => 16#86A1#,   --  蚡 (<CJK Ideograph>)
          14473 => 16#86A2#,   --  蚢 (<CJK Ideograph>)
          14474 => 16#86A5#,   --  蚥 (<CJK Ideograph>)
          14475 => 16#86A6#,   --  蚦 (<CJK Ideograph>)
          14476 => 16#86AB#,   --  蚫 (<CJK Ideograph>)
          14477 => 16#86AD#,   --  蚭 (<CJK Ideograph>)
          14478 => 16#86AE#,   --  蚮 (<CJK Ideograph>)
          14479 => 16#86B2#,   --  蚲 (<CJK Ideograph>)
          14480 => 16#86B3#,   --  蚳 (<CJK Ideograph>)
          14481 => 16#86B7#,   --  蚷 (<CJK Ideograph>)
          14482 => 16#86B8#,   --  蚸 (<CJK Ideograph>)
          14483 => 16#86B9#,   --  蚹 (<CJK Ideograph>)
          14484 => 16#86BB#,   --  蚻 (<CJK Ideograph>)
          14485 => 16#86BC#,   --  蚼 (<CJK Ideograph>)
          14486 => 16#86BD#,   --  蚽 (<CJK Ideograph>)
          14487 => 16#86BE#,   --  蚾 (<CJK Ideograph>)
          14488 => 16#86BF#,   --  蚿 (<CJK Ideograph>)
          14489 => 16#86C1#,   --  蛁 (<CJK Ideograph>)
          14490 => 16#86C2#,   --  蛂 (<CJK Ideograph>)
          14491 => 16#86C3#,   --  蛃 (<CJK Ideograph>)
          14492 => 16#86C5#,   --  蛅 (<CJK Ideograph>)
          14493 => 16#86C8#,   --  蛈 (<CJK Ideograph>)
          14494 => 16#86CC#,   --  蛌 (<CJK Ideograph>)
          14495 => 16#86CD#,   --  蛍 (<CJK Ideograph>)
          14496 => 16#86D2#,   --  蛒 (<CJK Ideograph>)
          14497 => 16#86D3#,   --  蛓 (<CJK Ideograph>)
          14498 => 16#86D5#,   --  蛕 (<CJK Ideograph>)
          14499 => 16#86D6#,   --  蛖 (<CJK Ideograph>)
          14500 => 16#86D7#,   --  蛗 (<CJK Ideograph>)
          14501 => 16#86DA#,   --  蛚 (<CJK Ideograph>)
          14502 => 16#86DC#,   --  蛜 (<CJK Ideograph>)
          14503 => 16#86DD#,   --  蛝 (<CJK Ideograph>)
          14504 => 16#86E0#,   --  蛠 (<CJK Ideograph>)
          14505 => 16#86E1#,   --  蛡 (<CJK Ideograph>)
          14506 => 16#86E2#,   --  蛢 (<CJK Ideograph>)
          14507 => 16#86E3#,   --  蛣 (<CJK Ideograph>)
          14508 => 16#86E5#,   --  蛥 (<CJK Ideograph>)
          14509 => 16#86E6#,   --  蛦 (<CJK Ideograph>)
          14510 => 16#86E7#,   --  蛧 (<CJK Ideograph>)
          14511 => 16#86E8#,   --  蛨 (<CJK Ideograph>)
          14512 => 16#86EA#,   --  蛪 (<CJK Ideograph>)
          14513 => 16#86EB#,   --  蛫 (<CJK Ideograph>)
          14514 => 16#86EC#,   --  蛬 (<CJK Ideograph>)
          14515 => 16#86EF#,   --  蛯 (<CJK Ideograph>)
          14516 => 16#86F5#,   --  蛵 (<CJK Ideograph>)
          14517 => 16#86F6#,   --  蛶 (<CJK Ideograph>)
          14518 => 16#86F7#,   --  蛷 (<CJK Ideograph>)
          14519 => 16#86FA#,   --  蛺 (<CJK Ideograph>)
          14520 => 16#86FB#,   --  蛻 (<CJK Ideograph>)
          14521 => 16#86FC#,   --  蛼 (<CJK Ideograph>)
          14522 => 16#86FD#,   --  蛽 (<CJK Ideograph>)
          14523 => 16#86FF#,   --  蛿 (<CJK Ideograph>)
          14524 => 16#8701#,   --  蜁 (<CJK Ideograph>)
          14525 => 16#8704#,   --  蜄 (<CJK Ideograph>)
          14526 => 16#8705#,   --  蜅 (<CJK Ideograph>)
          14527 => 16#8706#,   --  蜆 (<CJK Ideograph>)
          14528 => 16#870B#,   --  蜋 (<CJK Ideograph>)
          14529 => 16#870C#,   --  蜌 (<CJK Ideograph>)
          14530 => 16#870E#,   --  蜎 (<CJK Ideograph>)
          14531 => 16#870F#,   --  蜏 (<CJK Ideograph>)
          14532 => 16#8710#,   --  蜐 (<CJK Ideograph>)
          14533 => 16#8711#,   --  蜑 (<CJK Ideograph>)
          14534 => 16#8714#,   --  蜔 (<CJK Ideograph>)
          14535 => 16#8716#,   --  蜖 (<CJK Ideograph>)
          14536 => 16#6C40#,   --  汀 (<CJK Ideograph>)
          14537 => 16#5EF7#,   --  廷 (<CJK Ideograph>)
          14538 => 16#505C#,   --  停 (<CJK Ideograph>)
          14539 => 16#4EAD#,   --  亭 (<CJK Ideograph>)
          14540 => 16#5EAD#,   --  庭 (<CJK Ideograph>)
          14541 => 16#633A#,   --  挺 (<CJK Ideograph>)
          14542 => 16#8247#,   --  艇 (<CJK Ideograph>)
          14543 => 16#901A#,   --  通 (<CJK Ideograph>)
          14544 => 16#6850#,   --  桐 (<CJK Ideograph>)
          14545 => 16#916E#,   --  酮 (<CJK Ideograph>)
          14546 => 16#77B3#,   --  瞳 (<CJK Ideograph>)
          14547 => 16#540C#,   --  同 (<CJK Ideograph>)
          14548 => 16#94DC#,   --  铜 (<CJK Ideograph>)
          14549 => 16#5F64#,   --  彤 (<CJK Ideograph>)
          14550 => 16#7AE5#,   --  童 (<CJK Ideograph>)
          14551 => 16#6876#,   --  桶 (<CJK Ideograph>)
          14552 => 16#6345#,   --  捅 (<CJK Ideograph>)
          14553 => 16#7B52#,   --  筒 (<CJK Ideograph>)
          14554 => 16#7EDF#,   --  统 (<CJK Ideograph>)
          14555 => 16#75DB#,   --  痛 (<CJK Ideograph>)
          14556 => 16#5077#,   --  偷 (<CJK Ideograph>)
          14557 => 16#6295#,   --  投 (<CJK Ideograph>)
          14558 => 16#5934#,   --  头 (<CJK Ideograph>)
          14559 => 16#900F#,   --  透 (<CJK Ideograph>)
          14560 => 16#51F8#,   --  凸 (<CJK Ideograph>)
          14561 => 16#79C3#,   --  秃 (<CJK Ideograph>)
          14562 => 16#7A81#,   --  突 (<CJK Ideograph>)
          14563 => 16#56FE#,   --  图 (<CJK Ideograph>)
          14564 => 16#5F92#,   --  徒 (<CJK Ideograph>)
          14565 => 16#9014#,   --  途 (<CJK Ideograph>)
          14566 => 16#6D82#,   --  涂 (<CJK Ideograph>)
          14567 => 16#5C60#,   --  屠 (<CJK Ideograph>)
          14568 => 16#571F#,   --  土 (<CJK Ideograph>)
          14569 => 16#5410#,   --  吐 (<CJK Ideograph>)
          14570 => 16#5154#,   --  兔 (<CJK Ideograph>)
          14571 => 16#6E4D#,   --  湍 (<CJK Ideograph>)
          14572 => 16#56E2#,   --  团 (<CJK Ideograph>)
          14573 => 16#63A8#,   --  推 (<CJK Ideograph>)
          14574 => 16#9893#,   --  颓 (<CJK Ideograph>)
          14575 => 16#817F#,   --  腿 (<CJK Ideograph>)
          14576 => 16#8715#,   --  蜕 (<CJK Ideograph>)
          14577 => 16#892A#,   --  褪 (<CJK Ideograph>)
          14578 => 16#9000#,   --  退 (<CJK Ideograph>)
          14579 => 16#541E#,   --  吞 (<CJK Ideograph>)
          14580 => 16#5C6F#,   --  屯 (<CJK Ideograph>)
          14581 => 16#81C0#,   --  臀 (<CJK Ideograph>)
          14582 => 16#62D6#,   --  拖 (<CJK Ideograph>)
          14583 => 16#6258#,   --  托 (<CJK Ideograph>)
          14584 => 16#8131#,   --  脱 (<CJK Ideograph>)
          14585 => 16#9E35#,   --  鸵 (<CJK Ideograph>)
          14586 => 16#9640#,   --  陀 (<CJK Ideograph>)
          14587 => 16#9A6E#,   --  驮 (<CJK Ideograph>)
          14588 => 16#9A7C#,   --  驼 (<CJK Ideograph>)
          14589 => 16#692D#,   --  椭 (<CJK Ideograph>)
          14590 => 16#59A5#,   --  妥 (<CJK Ideograph>)
          14591 => 16#62D3#,   --  拓 (<CJK Ideograph>)
          14592 => 16#553E#,   --  唾 (<CJK Ideograph>)
          14593 => 16#6316#,   --  挖 (<CJK Ideograph>)
          14594 => 16#54C7#,   --  哇 (<CJK Ideograph>)
          14595 => 16#86D9#,   --  蛙 (<CJK Ideograph>)
          14596 => 16#6D3C#,   --  洼 (<CJK Ideograph>)
          14597 => 16#5A03#,   --  娃 (<CJK Ideograph>)
          14598 => 16#74E6#,   --  瓦 (<CJK Ideograph>)
          14599 => 16#889C#,   --  袜 (<CJK Ideograph>)
          14600 => 16#6B6A#,   --  歪 (<CJK Ideograph>)
          14601 => 16#5916#,   --  外 (<CJK Ideograph>)
          14602 => 16#8C4C#,   --  豌 (<CJK Ideograph>)
          14603 => 16#5F2F#,   --  弯 (<CJK Ideograph>)
          14604 => 16#6E7E#,   --  湾 (<CJK Ideograph>)
          14605 => 16#73A9#,   --  玩 (<CJK Ideograph>)
          14606 => 16#987D#,   --  顽 (<CJK Ideograph>)
          14607 => 16#4E38#,   --  丸 (<CJK Ideograph>)
          14608 => 16#70F7#,   --  烷 (<CJK Ideograph>)
          14609 => 16#5B8C#,   --  完 (<CJK Ideograph>)
          14610 => 16#7897#,   --  碗 (<CJK Ideograph>)
          14611 => 16#633D#,   --  挽 (<CJK Ideograph>)
          14612 => 16#665A#,   --  晚 (<CJK Ideograph>)
          14613 => 16#7696#,   --  皖 (<CJK Ideograph>)
          14614 => 16#60CB#,   --  惋 (<CJK Ideograph>)
          14615 => 16#5B9B#,   --  宛 (<CJK Ideograph>)
          14616 => 16#5A49#,   --  婉 (<CJK Ideograph>)
          14617 => 16#4E07#,   --  万 (<CJK Ideograph>)
          14618 => 16#8155#,   --  腕 (<CJK Ideograph>)
          14619 => 16#6C6A#,   --  汪 (<CJK Ideograph>)
          14620 => 16#738B#,   --  王 (<CJK Ideograph>)
          14621 => 16#4EA1#,   --  亡 (<CJK Ideograph>)
          14622 => 16#6789#,   --  枉 (<CJK Ideograph>)
          14623 => 16#7F51#,   --  网 (<CJK Ideograph>)
          14624 => 16#5F80#,   --  往 (<CJK Ideograph>)
          14625 => 16#65FA#,   --  旺 (<CJK Ideograph>)
          14626 => 16#671B#,   --  望 (<CJK Ideograph>)
          14627 => 16#5FD8#,   --  忘 (<CJK Ideograph>)
          14628 => 16#5984#,   --  妄 (<CJK Ideograph>)
          14629 => 16#5A01#,   --  威 (<CJK Ideograph>)
          14630 => 16#8719#,   --  蜙 (<CJK Ideograph>)
          14631 => 16#871B#,   --  蜛 (<CJK Ideograph>)
          14632 => 16#871D#,   --  蜝 (<CJK Ideograph>)
          14633 => 16#871F#,   --  蜟 (<CJK Ideograph>)
          14634 => 16#8720#,   --  蜠 (<CJK Ideograph>)
          14635 => 16#8724#,   --  蜤 (<CJK Ideograph>)
          14636 => 16#8726#,   --  蜦 (<CJK Ideograph>)
          14637 => 16#8727#,   --  蜧 (<CJK Ideograph>)
          14638 => 16#8728#,   --  蜨 (<CJK Ideograph>)
          14639 => 16#872A#,   --  蜪 (<CJK Ideograph>)
          14640 => 16#872B#,   --  蜫 (<CJK Ideograph>)
          14641 => 16#872C#,   --  蜬 (<CJK Ideograph>)
          14642 => 16#872D#,   --  蜭 (<CJK Ideograph>)
          14643 => 16#872F#,   --  蜯 (<CJK Ideograph>)
          14644 => 16#8730#,   --  蜰 (<CJK Ideograph>)
          14645 => 16#8732#,   --  蜲 (<CJK Ideograph>)
          14646 => 16#8733#,   --  蜳 (<CJK Ideograph>)
          14647 => 16#8735#,   --  蜵 (<CJK Ideograph>)
          14648 => 16#8736#,   --  蜶 (<CJK Ideograph>)
          14649 => 16#8738#,   --  蜸 (<CJK Ideograph>)
          14650 => 16#8739#,   --  蜹 (<CJK Ideograph>)
          14651 => 16#873A#,   --  蜺 (<CJK Ideograph>)
          14652 => 16#873C#,   --  蜼 (<CJK Ideograph>)
          14653 => 16#873D#,   --  蜽 (<CJK Ideograph>)
          14654 => 16#8740#,   --  蝀 (<CJK Ideograph>)
          14655 => 16#8741#,   --  蝁 (<CJK Ideograph>)
          14656 => 16#8742#,   --  蝂 (<CJK Ideograph>)
          14657 => 16#8743#,   --  蝃 (<CJK Ideograph>)
          14658 => 16#8744#,   --  蝄 (<CJK Ideograph>)
          14659 => 16#8745#,   --  蝅 (<CJK Ideograph>)
          14660 => 16#8746#,   --  蝆 (<CJK Ideograph>)
          14661 => 16#874A#,   --  蝊 (<CJK Ideograph>)
          14662 => 16#874B#,   --  蝋 (<CJK Ideograph>)
          14663 => 16#874D#,   --  蝍 (<CJK Ideograph>)
          14664 => 16#874F#,   --  蝏 (<CJK Ideograph>)
          14665 => 16#8750#,   --  蝐 (<CJK Ideograph>)
          14666 => 16#8751#,   --  蝑 (<CJK Ideograph>)
          14667 => 16#8752#,   --  蝒 (<CJK Ideograph>)
          14668 => 16#8754#,   --  蝔 (<CJK Ideograph>)
          14669 => 16#8755#,   --  蝕 (<CJK Ideograph>)
          14670 => 16#8756#,   --  蝖 (<CJK Ideograph>)
          14671 => 16#8758#,   --  蝘 (<CJK Ideograph>)
          14672 => 16#875A#,   --  蝚 (<CJK Ideograph>)
          14673 => 16#875B#,   --  蝛 (<CJK Ideograph>)
          14674 => 16#875C#,   --  蝜 (<CJK Ideograph>)
          14675 => 16#875D#,   --  蝝 (<CJK Ideograph>)
          14676 => 16#875E#,   --  蝞 (<CJK Ideograph>)
          14677 => 16#875F#,   --  蝟 (<CJK Ideograph>)
          14678 => 16#8761#,   --  蝡 (<CJK Ideograph>)
          14679 => 16#8762#,   --  蝢 (<CJK Ideograph>)
          14680 => 16#8766#,   --  蝦 (<CJK Ideograph>)
          14681 => 16#8767#,   --  蝧 (<CJK Ideograph>)
          14682 => 16#8768#,   --  蝨 (<CJK Ideograph>)
          14683 => 16#8769#,   --  蝩 (<CJK Ideograph>)
          14684 => 16#876A#,   --  蝪 (<CJK Ideograph>)
          14685 => 16#876B#,   --  蝫 (<CJK Ideograph>)
          14686 => 16#876C#,   --  蝬 (<CJK Ideograph>)
          14687 => 16#876D#,   --  蝭 (<CJK Ideograph>)
          14688 => 16#876F#,   --  蝯 (<CJK Ideograph>)
          14689 => 16#8771#,   --  蝱 (<CJK Ideograph>)
          14690 => 16#8772#,   --  蝲 (<CJK Ideograph>)
          14691 => 16#8773#,   --  蝳 (<CJK Ideograph>)
          14692 => 16#8775#,   --  蝵 (<CJK Ideograph>)
          14693 => 16#8777#,   --  蝷 (<CJK Ideograph>)
          14694 => 16#8778#,   --  蝸 (<CJK Ideograph>)
          14695 => 16#8779#,   --  蝹 (<CJK Ideograph>)
          14696 => 16#877A#,   --  蝺 (<CJK Ideograph>)
          14697 => 16#877F#,   --  蝿 (<CJK Ideograph>)
          14698 => 16#8780#,   --  螀 (<CJK Ideograph>)
          14699 => 16#8781#,   --  螁 (<CJK Ideograph>)
          14700 => 16#8784#,   --  螄 (<CJK Ideograph>)
          14701 => 16#8786#,   --  螆 (<CJK Ideograph>)
          14702 => 16#8787#,   --  螇 (<CJK Ideograph>)
          14703 => 16#8789#,   --  螉 (<CJK Ideograph>)
          14704 => 16#878A#,   --  螊 (<CJK Ideograph>)
          14705 => 16#878C#,   --  螌 (<CJK Ideograph>)
          14706 => 16#878E#,   --  螎 (<CJK Ideograph>)
          14707 => 16#878F#,   --  螏 (<CJK Ideograph>)
          14708 => 16#8790#,   --  螐 (<CJK Ideograph>)
          14709 => 16#8791#,   --  螑 (<CJK Ideograph>)
          14710 => 16#8792#,   --  螒 (<CJK Ideograph>)
          14711 => 16#8794#,   --  螔 (<CJK Ideograph>)
          14712 => 16#8795#,   --  螕 (<CJK Ideograph>)
          14713 => 16#8796#,   --  螖 (<CJK Ideograph>)
          14714 => 16#8798#,   --  螘 (<CJK Ideograph>)
          14715 => 16#8799#,   --  螙 (<CJK Ideograph>)
          14716 => 16#879A#,   --  螚 (<CJK Ideograph>)
          14717 => 16#879B#,   --  螛 (<CJK Ideograph>)
          14718 => 16#879C#,   --  螜 (<CJK Ideograph>)
          14719 => 16#879D#,   --  螝 (<CJK Ideograph>)
          14720 => 16#879E#,   --  螞 (<CJK Ideograph>)
          14721 => 16#87A0#,   --  螠 (<CJK Ideograph>)
          14722 => 16#87A1#,   --  螡 (<CJK Ideograph>)
          14723 => 16#87A2#,   --  螢 (<CJK Ideograph>)
          14724 => 16#87A3#,   --  螣 (<CJK Ideograph>)
          14725 => 16#87A4#,   --  螤 (<CJK Ideograph>)
          14726 => 16#5DCD#,   --  巍 (<CJK Ideograph>)
          14727 => 16#5FAE#,   --  微 (<CJK Ideograph>)
          14728 => 16#5371#,   --  危 (<CJK Ideograph>)
          14729 => 16#97E6#,   --  韦 (<CJK Ideograph>)
          14730 => 16#8FDD#,   --  违 (<CJK Ideograph>)
          14731 => 16#6845#,   --  桅 (<CJK Ideograph>)
          14732 => 16#56F4#,   --  围 (<CJK Ideograph>)
          14733 => 16#552F#,   --  唯 (<CJK Ideograph>)
          14734 => 16#60DF#,   --  惟 (<CJK Ideograph>)
          14735 => 16#4E3A#,   --  为 (<CJK Ideograph>)
          14736 => 16#6F4D#,   --  潍 (<CJK Ideograph>)
          14737 => 16#7EF4#,   --  维 (<CJK Ideograph>)
          14738 => 16#82C7#,   --  苇 (<CJK Ideograph>)
          14739 => 16#840E#,   --  萎 (<CJK Ideograph>)
          14740 => 16#59D4#,   --  委 (<CJK Ideograph>)
          14741 => 16#4F1F#,   --  伟 (<CJK Ideograph>)
          14742 => 16#4F2A#,   --  伪 (<CJK Ideograph>)
          14743 => 16#5C3E#,   --  尾 (<CJK Ideograph>)
          14744 => 16#7EAC#,   --  纬 (<CJK Ideograph>)
          14745 => 16#672A#,   --  未 (<CJK Ideograph>)
          14746 => 16#851A#,   --  蔚 (<CJK Ideograph>)
          14747 => 16#5473#,   --  味 (<CJK Ideograph>)
          14748 => 16#754F#,   --  畏 (<CJK Ideograph>)
          14749 => 16#80C3#,   --  胃 (<CJK Ideograph>)
          14750 => 16#5582#,   --  喂 (<CJK Ideograph>)
          14751 => 16#9B4F#,   --  魏 (<CJK Ideograph>)
          14752 => 16#4F4D#,   --  位 (<CJK Ideograph>)
          14753 => 16#6E2D#,   --  渭 (<CJK Ideograph>)
          14754 => 16#8C13#,   --  谓 (<CJK Ideograph>)
          14755 => 16#5C09#,   --  尉 (<CJK Ideograph>)
          14756 => 16#6170#,   --  慰 (<CJK Ideograph>)
          14757 => 16#536B#,   --  卫 (<CJK Ideograph>)
          14758 => 16#761F#,   --  瘟 (<CJK Ideograph>)
          14759 => 16#6E29#,   --  温 (<CJK Ideograph>)
          14760 => 16#868A#,   --  蚊 (<CJK Ideograph>)
          14761 => 16#6587#,   --  文 (<CJK Ideograph>)
          14762 => 16#95FB#,   --  闻 (<CJK Ideograph>)
          14763 => 16#7EB9#,   --  纹 (<CJK Ideograph>)
          14764 => 16#543B#,   --  吻 (<CJK Ideograph>)
          14765 => 16#7A33#,   --  稳 (<CJK Ideograph>)
          14766 => 16#7D0A#,   --  紊 (<CJK Ideograph>)
          14767 => 16#95EE#,   --  问 (<CJK Ideograph>)
          14768 => 16#55E1#,   --  嗡 (<CJK Ideograph>)
          14769 => 16#7FC1#,   --  翁 (<CJK Ideograph>)
          14770 => 16#74EE#,   --  瓮 (<CJK Ideograph>)
          14771 => 16#631D#,   --  挝 (<CJK Ideograph>)
          14772 => 16#8717#,   --  蜗 (<CJK Ideograph>)
          14773 => 16#6DA1#,   --  涡 (<CJK Ideograph>)
          14774 => 16#7A9D#,   --  窝 (<CJK Ideograph>)
          14775 => 16#6211#,   --  我 (<CJK Ideograph>)
          14776 => 16#65A1#,   --  斡 (<CJK Ideograph>)
          14777 => 16#5367#,   --  卧 (<CJK Ideograph>)
          14778 => 16#63E1#,   --  握 (<CJK Ideograph>)
          14779 => 16#6C83#,   --  沃 (<CJK Ideograph>)
          14780 => 16#5DEB#,   --  巫 (<CJK Ideograph>)
          14781 => 16#545C#,   --  呜 (<CJK Ideograph>)
          14782 => 16#94A8#,   --  钨 (<CJK Ideograph>)
          14783 => 16#4E4C#,   --  乌 (<CJK Ideograph>)
          14784 => 16#6C61#,   --  污 (<CJK Ideograph>)
          14785 => 16#8BEC#,   --  诬 (<CJK Ideograph>)
          14786 => 16#5C4B#,   --  屋 (<CJK Ideograph>)
          14787 => 16#65E0#,   --  无 (<CJK Ideograph>)
          14788 => 16#829C#,   --  芜 (<CJK Ideograph>)
          14789 => 16#68A7#,   --  梧 (<CJK Ideograph>)
          14790 => 16#543E#,   --  吾 (<CJK Ideograph>)
          14791 => 16#5434#,   --  吴 (<CJK Ideograph>)
          14792 => 16#6BCB#,   --  毋 (<CJK Ideograph>)
          14793 => 16#6B66#,   --  武 (<CJK Ideograph>)
          14794 => 16#4E94#,   --  五 (<CJK Ideograph>)
          14795 => 16#6342#,   --  捂 (<CJK Ideograph>)
          14796 => 16#5348#,   --  午 (<CJK Ideograph>)
          14797 => 16#821E#,   --  舞 (<CJK Ideograph>)
          14798 => 16#4F0D#,   --  伍 (<CJK Ideograph>)
          14799 => 16#4FAE#,   --  侮 (<CJK Ideograph>)
          14800 => 16#575E#,   --  坞 (<CJK Ideograph>)
          14801 => 16#620A#,   --  戊 (<CJK Ideograph>)
          14802 => 16#96FE#,   --  雾 (<CJK Ideograph>)
          14803 => 16#6664#,   --  晤 (<CJK Ideograph>)
          14804 => 16#7269#,   --  物 (<CJK Ideograph>)
          14805 => 16#52FF#,   --  勿 (<CJK Ideograph>)
          14806 => 16#52A1#,   --  务 (<CJK Ideograph>)
          14807 => 16#609F#,   --  悟 (<CJK Ideograph>)
          14808 => 16#8BEF#,   --  误 (<CJK Ideograph>)
          14809 => 16#6614#,   --  昔 (<CJK Ideograph>)
          14810 => 16#7199#,   --  熙 (<CJK Ideograph>)
          14811 => 16#6790#,   --  析 (<CJK Ideograph>)
          14812 => 16#897F#,   --  西 (<CJK Ideograph>)
          14813 => 16#7852#,   --  硒 (<CJK Ideograph>)
          14814 => 16#77FD#,   --  矽 (<CJK Ideograph>)
          14815 => 16#6670#,   --  晰 (<CJK Ideograph>)
          14816 => 16#563B#,   --  嘻 (<CJK Ideograph>)
          14817 => 16#5438#,   --  吸 (<CJK Ideograph>)
          14818 => 16#9521#,   --  锡 (<CJK Ideograph>)
          14819 => 16#727A#,   --  牺 (<CJK Ideograph>)
          14820 => 16#87A5#,   --  螥 (<CJK Ideograph>)
          14821 => 16#87A6#,   --  螦 (<CJK Ideograph>)
          14822 => 16#87A7#,   --  螧 (<CJK Ideograph>)
          14823 => 16#87A9#,   --  螩 (<CJK Ideograph>)
          14824 => 16#87AA#,   --  螪 (<CJK Ideograph>)
          14825 => 16#87AE#,   --  螮 (<CJK Ideograph>)
          14826 => 16#87B0#,   --  螰 (<CJK Ideograph>)
          14827 => 16#87B1#,   --  螱 (<CJK Ideograph>)
          14828 => 16#87B2#,   --  螲 (<CJK Ideograph>)
          14829 => 16#87B4#,   --  螴 (<CJK Ideograph>)
          14830 => 16#87B6#,   --  螶 (<CJK Ideograph>)
          14831 => 16#87B7#,   --  螷 (<CJK Ideograph>)
          14832 => 16#87B8#,   --  螸 (<CJK Ideograph>)
          14833 => 16#87B9#,   --  螹 (<CJK Ideograph>)
          14834 => 16#87BB#,   --  螻 (<CJK Ideograph>)
          14835 => 16#87BC#,   --  螼 (<CJK Ideograph>)
          14836 => 16#87BE#,   --  螾 (<CJK Ideograph>)
          14837 => 16#87BF#,   --  螿 (<CJK Ideograph>)
          14838 => 16#87C1#,   --  蟁 (<CJK Ideograph>)
          14839 => 16#87C2#,   --  蟂 (<CJK Ideograph>)
          14840 => 16#87C3#,   --  蟃 (<CJK Ideograph>)
          14841 => 16#87C4#,   --  蟄 (<CJK Ideograph>)
          14842 => 16#87C5#,   --  蟅 (<CJK Ideograph>)
          14843 => 16#87C7#,   --  蟇 (<CJK Ideograph>)
          14844 => 16#87C8#,   --  蟈 (<CJK Ideograph>)
          14845 => 16#87C9#,   --  蟉 (<CJK Ideograph>)
          14846 => 16#87CC#,   --  蟌 (<CJK Ideograph>)
          14847 => 16#87CD#,   --  蟍 (<CJK Ideograph>)
          14848 => 16#87CE#,   --  蟎 (<CJK Ideograph>)
          14849 => 16#87CF#,   --  蟏 (<CJK Ideograph>)
          14850 => 16#87D0#,   --  蟐 (<CJK Ideograph>)
          14851 => 16#87D4#,   --  蟔 (<CJK Ideograph>)
          14852 => 16#87D5#,   --  蟕 (<CJK Ideograph>)
          14853 => 16#87D6#,   --  蟖 (<CJK Ideograph>)
          14854 => 16#87D7#,   --  蟗 (<CJK Ideograph>)
          14855 => 16#87D8#,   --  蟘 (<CJK Ideograph>)
          14856 => 16#87D9#,   --  蟙 (<CJK Ideograph>)
          14857 => 16#87DA#,   --  蟚 (<CJK Ideograph>)
          14858 => 16#87DC#,   --  蟜 (<CJK Ideograph>)
          14859 => 16#87DD#,   --  蟝 (<CJK Ideograph>)
          14860 => 16#87DE#,   --  蟞 (<CJK Ideograph>)
          14861 => 16#87DF#,   --  蟟 (<CJK Ideograph>)
          14862 => 16#87E1#,   --  蟡 (<CJK Ideograph>)
          14863 => 16#87E2#,   --  蟢 (<CJK Ideograph>)
          14864 => 16#87E3#,   --  蟣 (<CJK Ideograph>)
          14865 => 16#87E4#,   --  蟤 (<CJK Ideograph>)
          14866 => 16#87E6#,   --  蟦 (<CJK Ideograph>)
          14867 => 16#87E7#,   --  蟧 (<CJK Ideograph>)
          14868 => 16#87E8#,   --  蟨 (<CJK Ideograph>)
          14869 => 16#87E9#,   --  蟩 (<CJK Ideograph>)
          14870 => 16#87EB#,   --  蟫 (<CJK Ideograph>)
          14871 => 16#87EC#,   --  蟬 (<CJK Ideograph>)
          14872 => 16#87ED#,   --  蟭 (<CJK Ideograph>)
          14873 => 16#87EF#,   --  蟯 (<CJK Ideograph>)
          14874 => 16#87F0#,   --  蟰 (<CJK Ideograph>)
          14875 => 16#87F1#,   --  蟱 (<CJK Ideograph>)
          14876 => 16#87F2#,   --  蟲 (<CJK Ideograph>)
          14877 => 16#87F3#,   --  蟳 (<CJK Ideograph>)
          14878 => 16#87F4#,   --  蟴 (<CJK Ideograph>)
          14879 => 16#87F5#,   --  蟵 (<CJK Ideograph>)
          14880 => 16#87F6#,   --  蟶 (<CJK Ideograph>)
          14881 => 16#87F7#,   --  蟷 (<CJK Ideograph>)
          14882 => 16#87F8#,   --  蟸 (<CJK Ideograph>)
          14883 => 16#87FA#,   --  蟺 (<CJK Ideograph>)
          14884 => 16#87FB#,   --  蟻 (<CJK Ideograph>)
          14885 => 16#87FC#,   --  蟼 (<CJK Ideograph>)
          14886 => 16#87FD#,   --  蟽 (<CJK Ideograph>)
          14887 => 16#87FF#,   --  蟿 (<CJK Ideograph>)
          14888 => 16#8800#,   --  蠀 (<CJK Ideograph>)
          14889 => 16#8801#,   --  蠁 (<CJK Ideograph>)
          14890 => 16#8802#,   --  蠂 (<CJK Ideograph>)
          14891 => 16#8804#,   --  蠄 (<CJK Ideograph>)
          14892 => 16#8805#,   --  蠅 (<CJK Ideograph>)
          14893 => 16#8806#,   --  蠆 (<CJK Ideograph>)
          14894 => 16#8807#,   --  蠇 (<CJK Ideograph>)
          14895 => 16#8808#,   --  蠈 (<CJK Ideograph>)
          14896 => 16#8809#,   --  蠉 (<CJK Ideograph>)
          14897 => 16#880B#,   --  蠋 (<CJK Ideograph>)
          14898 => 16#880C#,   --  蠌 (<CJK Ideograph>)
          14899 => 16#880D#,   --  蠍 (<CJK Ideograph>)
          14900 => 16#880E#,   --  蠎 (<CJK Ideograph>)
          14901 => 16#880F#,   --  蠏 (<CJK Ideograph>)
          14902 => 16#8810#,   --  蠐 (<CJK Ideograph>)
          14903 => 16#8811#,   --  蠑 (<CJK Ideograph>)
          14904 => 16#8812#,   --  蠒 (<CJK Ideograph>)
          14905 => 16#8814#,   --  蠔 (<CJK Ideograph>)
          14906 => 16#8817#,   --  蠗 (<CJK Ideograph>)
          14907 => 16#8818#,   --  蠘 (<CJK Ideograph>)
          14908 => 16#8819#,   --  蠙 (<CJK Ideograph>)
          14909 => 16#881A#,   --  蠚 (<CJK Ideograph>)
          14910 => 16#881C#,   --  蠜 (<CJK Ideograph>)
          14911 => 16#881D#,   --  蠝 (<CJK Ideograph>)
          14912 => 16#881E#,   --  蠞 (<CJK Ideograph>)
          14913 => 16#881F#,   --  蠟 (<CJK Ideograph>)
          14914 => 16#8820#,   --  蠠 (<CJK Ideograph>)
          14915 => 16#8823#,   --  蠣 (<CJK Ideograph>)
          14916 => 16#7A00#,   --  稀 (<CJK Ideograph>)
          14917 => 16#606F#,   --  息 (<CJK Ideograph>)
          14918 => 16#5E0C#,   --  希 (<CJK Ideograph>)
          14919 => 16#6089#,   --  悉 (<CJK Ideograph>)
          14920 => 16#819D#,   --  膝 (<CJK Ideograph>)
          14921 => 16#5915#,   --  夕 (<CJK Ideograph>)
          14922 => 16#60DC#,   --  惜 (<CJK Ideograph>)
          14923 => 16#7184#,   --  熄 (<CJK Ideograph>)
          14924 => 16#70EF#,   --  烯 (<CJK Ideograph>)
          14925 => 16#6EAA#,   --  溪 (<CJK Ideograph>)
          14926 => 16#6C50#,   --  汐 (<CJK Ideograph>)
          14927 => 16#7280#,   --  犀 (<CJK Ideograph>)
          14928 => 16#6A84#,   --  檄 (<CJK Ideograph>)
          14929 => 16#88AD#,   --  袭 (<CJK Ideograph>)
          14930 => 16#5E2D#,   --  席 (<CJK Ideograph>)
          14931 => 16#4E60#,   --  习 (<CJK Ideograph>)
          14932 => 16#5AB3#,   --  媳 (<CJK Ideograph>)
          14933 => 16#559C#,   --  喜 (<CJK Ideograph>)
          14934 => 16#94E3#,   --  铣 (<CJK Ideograph>)
          14935 => 16#6D17#,   --  洗 (<CJK Ideograph>)
          14936 => 16#7CFB#,   --  系 (<CJK Ideograph>)
          14937 => 16#9699#,   --  隙 (<CJK Ideograph>)
          14938 => 16#620F#,   --  戏 (<CJK Ideograph>)
          14939 => 16#7EC6#,   --  细 (<CJK Ideograph>)
          14940 => 16#778E#,   --  瞎 (<CJK Ideograph>)
          14941 => 16#867E#,   --  虾 (<CJK Ideograph>)
          14942 => 16#5323#,   --  匣 (<CJK Ideograph>)
          14943 => 16#971E#,   --  霞 (<CJK Ideograph>)
          14944 => 16#8F96#,   --  辖 (<CJK Ideograph>)
          14945 => 16#6687#,   --  暇 (<CJK Ideograph>)
          14946 => 16#5CE1#,   --  峡 (<CJK Ideograph>)
          14947 => 16#4FA0#,   --  侠 (<CJK Ideograph>)
          14948 => 16#72ED#,   --  狭 (<CJK Ideograph>)
          14949 => 16#4E0B#,   --  下 (<CJK Ideograph>)
          14950 => 16#53A6#,   --  厦 (<CJK Ideograph>)
          14951 => 16#590F#,   --  夏 (<CJK Ideograph>)
          14952 => 16#5413#,   --  吓 (<CJK Ideograph>)
          14953 => 16#6380#,   --  掀 (<CJK Ideograph>)
          14954 => 16#9528#,   --  锨 (<CJK Ideograph>)
          14955 => 16#5148#,   --  先 (<CJK Ideograph>)
          14956 => 16#4ED9#,   --  仙 (<CJK Ideograph>)
          14957 => 16#9C9C#,   --  鲜 (<CJK Ideograph>)
          14958 => 16#7EA4#,   --  纤 (<CJK Ideograph>)
          14959 => 16#54B8#,   --  咸 (<CJK Ideograph>)
          14960 => 16#8D24#,   --  贤 (<CJK Ideograph>)
          14961 => 16#8854#,   --  衔 (<CJK Ideograph>)
          14962 => 16#8237#,   --  舷 (<CJK Ideograph>)
          14963 => 16#95F2#,   --  闲 (<CJK Ideograph>)
          14964 => 16#6D8E#,   --  涎 (<CJK Ideograph>)
          14965 => 16#5F26#,   --  弦 (<CJK Ideograph>)
          14966 => 16#5ACC#,   --  嫌 (<CJK Ideograph>)
          14967 => 16#663E#,   --  显 (<CJK Ideograph>)
          14968 => 16#9669#,   --  险 (<CJK Ideograph>)
          14969 => 16#73B0#,   --  现 (<CJK Ideograph>)
          14970 => 16#732E#,   --  献 (<CJK Ideograph>)
          14971 => 16#53BF#,   --  县 (<CJK Ideograph>)
          14972 => 16#817A#,   --  腺 (<CJK Ideograph>)
          14973 => 16#9985#,   --  馅 (<CJK Ideograph>)
          14974 => 16#7FA1#,   --  羡 (<CJK Ideograph>)
          14975 => 16#5BAA#,   --  宪 (<CJK Ideograph>)
          14976 => 16#9677#,   --  陷 (<CJK Ideograph>)
          14977 => 16#9650#,   --  限 (<CJK Ideograph>)
          14978 => 16#7EBF#,   --  线 (<CJK Ideograph>)
          14979 => 16#76F8#,   --  相 (<CJK Ideograph>)
          14980 => 16#53A2#,   --  厢 (<CJK Ideograph>)
          14981 => 16#9576#,   --  镶 (<CJK Ideograph>)
          14982 => 16#9999#,   --  香 (<CJK Ideograph>)
          14983 => 16#7BB1#,   --  箱 (<CJK Ideograph>)
          14984 => 16#8944#,   --  襄 (<CJK Ideograph>)
          14985 => 16#6E58#,   --  湘 (<CJK Ideograph>)
          14986 => 16#4E61#,   --  乡 (<CJK Ideograph>)
          14987 => 16#7FD4#,   --  翔 (<CJK Ideograph>)
          14988 => 16#7965#,   --  祥 (<CJK Ideograph>)
          14989 => 16#8BE6#,   --  详 (<CJK Ideograph>)
          14990 => 16#60F3#,   --  想 (<CJK Ideograph>)
          14991 => 16#54CD#,   --  响 (<CJK Ideograph>)
          14992 => 16#4EAB#,   --  享 (<CJK Ideograph>)
          14993 => 16#9879#,   --  项 (<CJK Ideograph>)
          14994 => 16#5DF7#,   --  巷 (<CJK Ideograph>)
          14995 => 16#6A61#,   --  橡 (<CJK Ideograph>)
          14996 => 16#50CF#,   --  像 (<CJK Ideograph>)
          14997 => 16#5411#,   --  向 (<CJK Ideograph>)
          14998 => 16#8C61#,   --  象 (<CJK Ideograph>)
          14999 => 16#8427#,   --  萧 (<CJK Ideograph>)
          15000 => 16#785D#,   --  硝 (<CJK Ideograph>)
          15001 => 16#9704#,   --  霄 (<CJK Ideograph>)
          15002 => 16#524A#,   --  削 (<CJK Ideograph>)
          15003 => 16#54EE#,   --  哮 (<CJK Ideograph>)
          15004 => 16#56A3#,   --  嚣 (<CJK Ideograph>)
          15005 => 16#9500#,   --  销 (<CJK Ideograph>)
          15006 => 16#6D88#,   --  消 (<CJK Ideograph>)
          15007 => 16#5BB5#,   --  宵 (<CJK Ideograph>)
          15008 => 16#6DC6#,   --  淆 (<CJK Ideograph>)
          15009 => 16#6653#,   --  晓 (<CJK Ideograph>)
          15010 => 16#8824#,   --  蠤 (<CJK Ideograph>)
          15011 => 16#8825#,   --  蠥 (<CJK Ideograph>)
          15012 => 16#8826#,   --  蠦 (<CJK Ideograph>)
          15013 => 16#8827#,   --  蠧 (<CJK Ideograph>)
          15014 => 16#8828#,   --  蠨 (<CJK Ideograph>)
          15015 => 16#8829#,   --  蠩 (<CJK Ideograph>)
          15016 => 16#882A#,   --  蠪 (<CJK Ideograph>)
          15017 => 16#882B#,   --  蠫 (<CJK Ideograph>)
          15018 => 16#882C#,   --  蠬 (<CJK Ideograph>)
          15019 => 16#882D#,   --  蠭 (<CJK Ideograph>)
          15020 => 16#882E#,   --  蠮 (<CJK Ideograph>)
          15021 => 16#882F#,   --  蠯 (<CJK Ideograph>)
          15022 => 16#8830#,   --  蠰 (<CJK Ideograph>)
          15023 => 16#8831#,   --  蠱 (<CJK Ideograph>)
          15024 => 16#8833#,   --  蠳 (<CJK Ideograph>)
          15025 => 16#8834#,   --  蠴 (<CJK Ideograph>)
          15026 => 16#8835#,   --  蠵 (<CJK Ideograph>)
          15027 => 16#8836#,   --  蠶 (<CJK Ideograph>)
          15028 => 16#8837#,   --  蠷 (<CJK Ideograph>)
          15029 => 16#8838#,   --  蠸 (<CJK Ideograph>)
          15030 => 16#883A#,   --  蠺 (<CJK Ideograph>)
          15031 => 16#883B#,   --  蠻 (<CJK Ideograph>)
          15032 => 16#883D#,   --  蠽 (<CJK Ideograph>)
          15033 => 16#883E#,   --  蠾 (<CJK Ideograph>)
          15034 => 16#883F#,   --  蠿 (<CJK Ideograph>)
          15035 => 16#8841#,   --  衁 (<CJK Ideograph>)
          15036 => 16#8842#,   --  衂 (<CJK Ideograph>)
          15037 => 16#8843#,   --  衃 (<CJK Ideograph>)
          15038 => 16#8846#,   --  衆 (<CJK Ideograph>)
          15039 => 16#8847#,   --  衇 (<CJK Ideograph>)
          15040 => 16#8848#,   --  衈 (<CJK Ideograph>)
          15041 => 16#8849#,   --  衉 (<CJK Ideograph>)
          15042 => 16#884A#,   --  衊 (<CJK Ideograph>)
          15043 => 16#884B#,   --  衋 (<CJK Ideograph>)
          15044 => 16#884E#,   --  衎 (<CJK Ideograph>)
          15045 => 16#884F#,   --  衏 (<CJK Ideograph>)
          15046 => 16#8850#,   --  衐 (<CJK Ideograph>)
          15047 => 16#8851#,   --  衑 (<CJK Ideograph>)
          15048 => 16#8852#,   --  衒 (<CJK Ideograph>)
          15049 => 16#8853#,   --  術 (<CJK Ideograph>)
          15050 => 16#8855#,   --  衕 (<CJK Ideograph>)
          15051 => 16#8856#,   --  衖 (<CJK Ideograph>)
          15052 => 16#8858#,   --  衘 (<CJK Ideograph>)
          15053 => 16#885A#,   --  衚 (<CJK Ideograph>)
          15054 => 16#885B#,   --  衛 (<CJK Ideograph>)
          15055 => 16#885C#,   --  衜 (<CJK Ideograph>)
          15056 => 16#885D#,   --  衝 (<CJK Ideograph>)
          15057 => 16#885E#,   --  衞 (<CJK Ideograph>)
          15058 => 16#885F#,   --  衟 (<CJK Ideograph>)
          15059 => 16#8860#,   --  衠 (<CJK Ideograph>)
          15060 => 16#8866#,   --  衦 (<CJK Ideograph>)
          15061 => 16#8867#,   --  衧 (<CJK Ideograph>)
          15062 => 16#886A#,   --  衪 (<CJK Ideograph>)
          15063 => 16#886D#,   --  衭 (<CJK Ideograph>)
          15064 => 16#886F#,   --  衯 (<CJK Ideograph>)
          15065 => 16#8871#,   --  衱 (<CJK Ideograph>)
          15066 => 16#8873#,   --  衳 (<CJK Ideograph>)
          15067 => 16#8874#,   --  衴 (<CJK Ideograph>)
          15068 => 16#8875#,   --  衵 (<CJK Ideograph>)
          15069 => 16#8876#,   --  衶 (<CJK Ideograph>)
          15070 => 16#8878#,   --  衸 (<CJK Ideograph>)
          15071 => 16#8879#,   --  衹 (<CJK Ideograph>)
          15072 => 16#887A#,   --  衺 (<CJK Ideograph>)
          15073 => 16#887B#,   --  衻 (<CJK Ideograph>)
          15074 => 16#887C#,   --  衼 (<CJK Ideograph>)
          15075 => 16#8880#,   --  袀 (<CJK Ideograph>)
          15076 => 16#8883#,   --  袃 (<CJK Ideograph>)
          15077 => 16#8886#,   --  袆 (<CJK Ideograph>)
          15078 => 16#8887#,   --  袇 (<CJK Ideograph>)
          15079 => 16#8889#,   --  袉 (<CJK Ideograph>)
          15080 => 16#888A#,   --  袊 (<CJK Ideograph>)
          15081 => 16#888C#,   --  袌 (<CJK Ideograph>)
          15082 => 16#888E#,   --  袎 (<CJK Ideograph>)
          15083 => 16#888F#,   --  袏 (<CJK Ideograph>)
          15084 => 16#8890#,   --  袐 (<CJK Ideograph>)
          15085 => 16#8891#,   --  袑 (<CJK Ideograph>)
          15086 => 16#8893#,   --  袓 (<CJK Ideograph>)
          15087 => 16#8894#,   --  袔 (<CJK Ideograph>)
          15088 => 16#8895#,   --  袕 (<CJK Ideograph>)
          15089 => 16#8897#,   --  袗 (<CJK Ideograph>)
          15090 => 16#8898#,   --  袘 (<CJK Ideograph>)
          15091 => 16#8899#,   --  袙 (<CJK Ideograph>)
          15092 => 16#889A#,   --  袚 (<CJK Ideograph>)
          15093 => 16#889B#,   --  袛 (<CJK Ideograph>)
          15094 => 16#889D#,   --  袝 (<CJK Ideograph>)
          15095 => 16#889E#,   --  袞 (<CJK Ideograph>)
          15096 => 16#889F#,   --  袟 (<CJK Ideograph>)
          15097 => 16#88A0#,   --  袠 (<CJK Ideograph>)
          15098 => 16#88A1#,   --  袡 (<CJK Ideograph>)
          15099 => 16#88A3#,   --  袣 (<CJK Ideograph>)
          15100 => 16#88A5#,   --  袥 (<CJK Ideograph>)
          15101 => 16#88A6#,   --  袦 (<CJK Ideograph>)
          15102 => 16#88A7#,   --  袧 (<CJK Ideograph>)
          15103 => 16#88A8#,   --  袨 (<CJK Ideograph>)
          15104 => 16#88A9#,   --  袩 (<CJK Ideograph>)
          15105 => 16#88AA#,   --  袪 (<CJK Ideograph>)
          15106 => 16#5C0F#,   --  小 (<CJK Ideograph>)
          15107 => 16#5B5D#,   --  孝 (<CJK Ideograph>)
          15108 => 16#6821#,   --  校 (<CJK Ideograph>)
          15109 => 16#8096#,   --  肖 (<CJK Ideograph>)
          15110 => 16#5578#,   --  啸 (<CJK Ideograph>)
          15111 => 16#7B11#,   --  笑 (<CJK Ideograph>)
          15112 => 16#6548#,   --  效 (<CJK Ideograph>)
          15113 => 16#6954#,   --  楔 (<CJK Ideograph>)
          15114 => 16#4E9B#,   --  些 (<CJK Ideograph>)
          15115 => 16#6B47#,   --  歇 (<CJK Ideograph>)
          15116 => 16#874E#,   --  蝎 (<CJK Ideograph>)
          15117 => 16#978B#,   --  鞋 (<CJK Ideograph>)
          15118 => 16#534F#,   --  协 (<CJK Ideograph>)
          15119 => 16#631F#,   --  挟 (<CJK Ideograph>)
          15120 => 16#643A#,   --  携 (<CJK Ideograph>)
          15121 => 16#90AA#,   --  邪 (<CJK Ideograph>)
          15122 => 16#659C#,   --  斜 (<CJK Ideograph>)
          15123 => 16#80C1#,   --  胁 (<CJK Ideograph>)
          15124 => 16#8C10#,   --  谐 (<CJK Ideograph>)
          15125 => 16#5199#,   --  写 (<CJK Ideograph>)
          15126 => 16#68B0#,   --  械 (<CJK Ideograph>)
          15127 => 16#5378#,   --  卸 (<CJK Ideograph>)
          15128 => 16#87F9#,   --  蟹 (<CJK Ideograph>)
          15129 => 16#61C8#,   --  懈 (<CJK Ideograph>)
          15130 => 16#6CC4#,   --  泄 (<CJK Ideograph>)
          15131 => 16#6CFB#,   --  泻 (<CJK Ideograph>)
          15132 => 16#8C22#,   --  谢 (<CJK Ideograph>)
          15133 => 16#5C51#,   --  屑 (<CJK Ideograph>)
          15134 => 16#85AA#,   --  薪 (<CJK Ideograph>)
          15135 => 16#82AF#,   --  芯 (<CJK Ideograph>)
          15136 => 16#950C#,   --  锌 (<CJK Ideograph>)
          15137 => 16#6B23#,   --  欣 (<CJK Ideograph>)
          15138 => 16#8F9B#,   --  辛 (<CJK Ideograph>)
          15139 => 16#65B0#,   --  新 (<CJK Ideograph>)
          15140 => 16#5FFB#,   --  忻 (<CJK Ideograph>)
          15141 => 16#5FC3#,   --  心 (<CJK Ideograph>)
          15142 => 16#4FE1#,   --  信 (<CJK Ideograph>)
          15143 => 16#8845#,   --  衅 (<CJK Ideograph>)
          15144 => 16#661F#,   --  星 (<CJK Ideograph>)
          15145 => 16#8165#,   --  腥 (<CJK Ideograph>)
          15146 => 16#7329#,   --  猩 (<CJK Ideograph>)
          15147 => 16#60FA#,   --  惺 (<CJK Ideograph>)
          15148 => 16#5174#,   --  兴 (<CJK Ideograph>)
          15149 => 16#5211#,   --  刑 (<CJK Ideograph>)
          15150 => 16#578B#,   --  型 (<CJK Ideograph>)
          15151 => 16#5F62#,   --  形 (<CJK Ideograph>)
          15152 => 16#90A2#,   --  邢 (<CJK Ideograph>)
          15153 => 16#884C#,   --  行 (<CJK Ideograph>)
          15154 => 16#9192#,   --  醒 (<CJK Ideograph>)
          15155 => 16#5E78#,   --  幸 (<CJK Ideograph>)
          15156 => 16#674F#,   --  杏 (<CJK Ideograph>)
          15157 => 16#6027#,   --  性 (<CJK Ideograph>)
          15158 => 16#59D3#,   --  姓 (<CJK Ideograph>)
          15159 => 16#5144#,   --  兄 (<CJK Ideograph>)
          15160 => 16#51F6#,   --  凶 (<CJK Ideograph>)
          15161 => 16#80F8#,   --  胸 (<CJK Ideograph>)
          15162 => 16#5308#,   --  匈 (<CJK Ideograph>)
          15163 => 16#6C79#,   --  汹 (<CJK Ideograph>)
          15164 => 16#96C4#,   --  雄 (<CJK Ideograph>)
          15165 => 16#718A#,   --  熊 (<CJK Ideograph>)
          15166 => 16#4F11#,   --  休 (<CJK Ideograph>)
          15167 => 16#4FEE#,   --  修 (<CJK Ideograph>)
          15168 => 16#7F9E#,   --  羞 (<CJK Ideograph>)
          15169 => 16#673D#,   --  朽 (<CJK Ideograph>)
          15170 => 16#55C5#,   --  嗅 (<CJK Ideograph>)
          15171 => 16#9508#,   --  锈 (<CJK Ideograph>)
          15172 => 16#79C0#,   --  秀 (<CJK Ideograph>)
          15173 => 16#8896#,   --  袖 (<CJK Ideograph>)
          15174 => 16#7EE3#,   --  绣 (<CJK Ideograph>)
          15175 => 16#589F#,   --  墟 (<CJK Ideograph>)
          15176 => 16#620C#,   --  戌 (<CJK Ideograph>)
          15177 => 16#9700#,   --  需 (<CJK Ideograph>)
          15178 => 16#865A#,   --  虚 (<CJK Ideograph>)
          15179 => 16#5618#,   --  嘘 (<CJK Ideograph>)
          15180 => 16#987B#,   --  须 (<CJK Ideograph>)
          15181 => 16#5F90#,   --  徐 (<CJK Ideograph>)
          15182 => 16#8BB8#,   --  许 (<CJK Ideograph>)
          15183 => 16#84C4#,   --  蓄 (<CJK Ideograph>)
          15184 => 16#9157#,   --  酗 (<CJK Ideograph>)
          15185 => 16#53D9#,   --  叙 (<CJK Ideograph>)
          15186 => 16#65ED#,   --  旭 (<CJK Ideograph>)
          15187 => 16#5E8F#,   --  序 (<CJK Ideograph>)
          15188 => 16#755C#,   --  畜 (<CJK Ideograph>)
          15189 => 16#6064#,   --  恤 (<CJK Ideograph>)
          15190 => 16#7D6E#,   --  絮 (<CJK Ideograph>)
          15191 => 16#5A7F#,   --  婿 (<CJK Ideograph>)
          15192 => 16#7EEA#,   --  绪 (<CJK Ideograph>)
          15193 => 16#7EED#,   --  续 (<CJK Ideograph>)
          15194 => 16#8F69#,   --  轩 (<CJK Ideograph>)
          15195 => 16#55A7#,   --  喧 (<CJK Ideograph>)
          15196 => 16#5BA3#,   --  宣 (<CJK Ideograph>)
          15197 => 16#60AC#,   --  悬 (<CJK Ideograph>)
          15198 => 16#65CB#,   --  旋 (<CJK Ideograph>)
          15199 => 16#7384#,   --  玄 (<CJK Ideograph>)
          15200 => 16#88AC#,   --  袬 (<CJK Ideograph>)
          15201 => 16#88AE#,   --  袮 (<CJK Ideograph>)
          15202 => 16#88AF#,   --  袯 (<CJK Ideograph>)
          15203 => 16#88B0#,   --  袰 (<CJK Ideograph>)
          15204 => 16#88B2#,   --  袲 (<CJK Ideograph>)
          15205 => 16#88B3#,   --  袳 (<CJK Ideograph>)
          15206 => 16#88B4#,   --  袴 (<CJK Ideograph>)
          15207 => 16#88B5#,   --  袵 (<CJK Ideograph>)
          15208 => 16#88B6#,   --  袶 (<CJK Ideograph>)
          15209 => 16#88B8#,   --  袸 (<CJK Ideograph>)
          15210 => 16#88B9#,   --  袹 (<CJK Ideograph>)
          15211 => 16#88BA#,   --  袺 (<CJK Ideograph>)
          15212 => 16#88BB#,   --  袻 (<CJK Ideograph>)
          15213 => 16#88BD#,   --  袽 (<CJK Ideograph>)
          15214 => 16#88BE#,   --  袾 (<CJK Ideograph>)
          15215 => 16#88BF#,   --  袿 (<CJK Ideograph>)
          15216 => 16#88C0#,   --  裀 (<CJK Ideograph>)
          15217 => 16#88C3#,   --  裃 (<CJK Ideograph>)
          15218 => 16#88C4#,   --  裄 (<CJK Ideograph>)
          15219 => 16#88C7#,   --  裇 (<CJK Ideograph>)
          15220 => 16#88C8#,   --  裈 (<CJK Ideograph>)
          15221 => 16#88CA#,   --  裊 (<CJK Ideograph>)
          15222 => 16#88CB#,   --  裋 (<CJK Ideograph>)
          15223 => 16#88CC#,   --  裌 (<CJK Ideograph>)
          15224 => 16#88CD#,   --  裍 (<CJK Ideograph>)
          15225 => 16#88CF#,   --  裏 (<CJK Ideograph>)
          15226 => 16#88D0#,   --  裐 (<CJK Ideograph>)
          15227 => 16#88D1#,   --  裑 (<CJK Ideograph>)
          15228 => 16#88D3#,   --  裓 (<CJK Ideograph>)
          15229 => 16#88D6#,   --  裖 (<CJK Ideograph>)
          15230 => 16#88D7#,   --  裗 (<CJK Ideograph>)
          15231 => 16#88DA#,   --  裚 (<CJK Ideograph>)
          15232 => 16#88DB#,   --  裛 (<CJK Ideograph>)
          15233 => 16#88DC#,   --  補 (<CJK Ideograph>)
          15234 => 16#88DD#,   --  裝 (<CJK Ideograph>)
          15235 => 16#88DE#,   --  裞 (<CJK Ideograph>)
          15236 => 16#88E0#,   --  裠 (<CJK Ideograph>)
          15237 => 16#88E1#,   --  裡 (<CJK Ideograph>)
          15238 => 16#88E6#,   --  裦 (<CJK Ideograph>)
          15239 => 16#88E7#,   --  裧 (<CJK Ideograph>)
          15240 => 16#88E9#,   --  裩 (<CJK Ideograph>)
          15241 => 16#88EA#,   --  裪 (<CJK Ideograph>)
          15242 => 16#88EB#,   --  裫 (<CJK Ideograph>)
          15243 => 16#88EC#,   --  裬 (<CJK Ideograph>)
          15244 => 16#88ED#,   --  裭 (<CJK Ideograph>)
          15245 => 16#88EE#,   --  裮 (<CJK Ideograph>)
          15246 => 16#88EF#,   --  裯 (<CJK Ideograph>)
          15247 => 16#88F2#,   --  裲 (<CJK Ideograph>)
          15248 => 16#88F5#,   --  裵 (<CJK Ideograph>)
          15249 => 16#88F6#,   --  裶 (<CJK Ideograph>)
          15250 => 16#88F7#,   --  裷 (<CJK Ideograph>)
          15251 => 16#88FA#,   --  裺 (<CJK Ideograph>)
          15252 => 16#88FB#,   --  裻 (<CJK Ideograph>)
          15253 => 16#88FD#,   --  製 (<CJK Ideograph>)
          15254 => 16#88FF#,   --  裿 (<CJK Ideograph>)
          15255 => 16#8900#,   --  褀 (<CJK Ideograph>)
          15256 => 16#8901#,   --  褁 (<CJK Ideograph>)
          15257 => 16#8903#,   --  褃 (<CJK Ideograph>)
          15258 => 16#8904#,   --  褄 (<CJK Ideograph>)
          15259 => 16#8905#,   --  褅 (<CJK Ideograph>)
          15260 => 16#8906#,   --  褆 (<CJK Ideograph>)
          15261 => 16#8907#,   --  複 (<CJK Ideograph>)
          15262 => 16#8908#,   --  褈 (<CJK Ideograph>)
          15263 => 16#8909#,   --  褉 (<CJK Ideograph>)
          15264 => 16#890B#,   --  褋 (<CJK Ideograph>)
          15265 => 16#890C#,   --  褌 (<CJK Ideograph>)
          15266 => 16#890D#,   --  褍 (<CJK Ideograph>)
          15267 => 16#890E#,   --  褎 (<CJK Ideograph>)
          15268 => 16#890F#,   --  褏 (<CJK Ideograph>)
          15269 => 16#8911#,   --  褑 (<CJK Ideograph>)
          15270 => 16#8914#,   --  褔 (<CJK Ideograph>)
          15271 => 16#8915#,   --  褕 (<CJK Ideograph>)
          15272 => 16#8916#,   --  褖 (<CJK Ideograph>)
          15273 => 16#8917#,   --  褗 (<CJK Ideograph>)
          15274 => 16#8918#,   --  褘 (<CJK Ideograph>)
          15275 => 16#891C#,   --  褜 (<CJK Ideograph>)
          15276 => 16#891D#,   --  褝 (<CJK Ideograph>)
          15277 => 16#891E#,   --  褞 (<CJK Ideograph>)
          15278 => 16#891F#,   --  褟 (<CJK Ideograph>)
          15279 => 16#8920#,   --  褠 (<CJK Ideograph>)
          15280 => 16#8922#,   --  褢 (<CJK Ideograph>)
          15281 => 16#8923#,   --  褣 (<CJK Ideograph>)
          15282 => 16#8924#,   --  褤 (<CJK Ideograph>)
          15283 => 16#8926#,   --  褦 (<CJK Ideograph>)
          15284 => 16#8927#,   --  褧 (<CJK Ideograph>)
          15285 => 16#8928#,   --  褨 (<CJK Ideograph>)
          15286 => 16#8929#,   --  褩 (<CJK Ideograph>)
          15287 => 16#892C#,   --  褬 (<CJK Ideograph>)
          15288 => 16#892D#,   --  褭 (<CJK Ideograph>)
          15289 => 16#892E#,   --  褮 (<CJK Ideograph>)
          15290 => 16#892F#,   --  褯 (<CJK Ideograph>)
          15291 => 16#8931#,   --  褱 (<CJK Ideograph>)
          15292 => 16#8932#,   --  褲 (<CJK Ideograph>)
          15293 => 16#8933#,   --  褳 (<CJK Ideograph>)
          15294 => 16#8935#,   --  褵 (<CJK Ideograph>)
          15295 => 16#8937#,   --  褷 (<CJK Ideograph>)
          15296 => 16#9009#,   --  选 (<CJK Ideograph>)
          15297 => 16#7663#,   --  癣 (<CJK Ideograph>)
          15298 => 16#7729#,   --  眩 (<CJK Ideograph>)
          15299 => 16#7EDA#,   --  绚 (<CJK Ideograph>)
          15300 => 16#9774#,   --  靴 (<CJK Ideograph>)
          15301 => 16#859B#,   --  薛 (<CJK Ideograph>)
          15302 => 16#5B66#,   --  学 (<CJK Ideograph>)
          15303 => 16#7A74#,   --  穴 (<CJK Ideograph>)
          15304 => 16#96EA#,   --  雪 (<CJK Ideograph>)
          15305 => 16#8840#,   --  血 (<CJK Ideograph>)
          15306 => 16#52CB#,   --  勋 (<CJK Ideograph>)
          15307 => 16#718F#,   --  熏 (<CJK Ideograph>)
          15308 => 16#5FAA#,   --  循 (<CJK Ideograph>)
          15309 => 16#65EC#,   --  旬 (<CJK Ideograph>)
          15310 => 16#8BE2#,   --  询 (<CJK Ideograph>)
          15311 => 16#5BFB#,   --  寻 (<CJK Ideograph>)
          15312 => 16#9A6F#,   --  驯 (<CJK Ideograph>)
          15313 => 16#5DE1#,   --  巡 (<CJK Ideograph>)
          15314 => 16#6B89#,   --  殉 (<CJK Ideograph>)
          15315 => 16#6C5B#,   --  汛 (<CJK Ideograph>)
          15316 => 16#8BAD#,   --  训 (<CJK Ideograph>)
          15317 => 16#8BAF#,   --  讯 (<CJK Ideograph>)
          15318 => 16#900A#,   --  逊 (<CJK Ideograph>)
          15319 => 16#8FC5#,   --  迅 (<CJK Ideograph>)
          15320 => 16#538B#,   --  压 (<CJK Ideograph>)
          15321 => 16#62BC#,   --  押 (<CJK Ideograph>)
          15322 => 16#9E26#,   --  鸦 (<CJK Ideograph>)
          15323 => 16#9E2D#,   --  鸭 (<CJK Ideograph>)
          15324 => 16#5440#,   --  呀 (<CJK Ideograph>)
          15325 => 16#4E2B#,   --  丫 (<CJK Ideograph>)
          15326 => 16#82BD#,   --  芽 (<CJK Ideograph>)
          15327 => 16#7259#,   --  牙 (<CJK Ideograph>)
          15328 => 16#869C#,   --  蚜 (<CJK Ideograph>)
          15329 => 16#5D16#,   --  崖 (<CJK Ideograph>)
          15330 => 16#8859#,   --  衙 (<CJK Ideograph>)
          15331 => 16#6DAF#,   --  涯 (<CJK Ideograph>)
          15332 => 16#96C5#,   --  雅 (<CJK Ideograph>)
          15333 => 16#54D1#,   --  哑 (<CJK Ideograph>)
          15334 => 16#4E9A#,   --  亚 (<CJK Ideograph>)
          15335 => 16#8BB6#,   --  讶 (<CJK Ideograph>)
          15336 => 16#7109#,   --  焉 (<CJK Ideograph>)
          15337 => 16#54BD#,   --  咽 (<CJK Ideograph>)
          15338 => 16#9609#,   --  阉 (<CJK Ideograph>)
          15339 => 16#70DF#,   --  烟 (<CJK Ideograph>)
          15340 => 16#6DF9#,   --  淹 (<CJK Ideograph>)
          15341 => 16#76D0#,   --  盐 (<CJK Ideograph>)
          15342 => 16#4E25#,   --  严 (<CJK Ideograph>)
          15343 => 16#7814#,   --  研 (<CJK Ideograph>)
          15344 => 16#8712#,   --  蜒 (<CJK Ideograph>)
          15345 => 16#5CA9#,   --  岩 (<CJK Ideograph>)
          15346 => 16#5EF6#,   --  延 (<CJK Ideograph>)
          15347 => 16#8A00#,   --  言 (<CJK Ideograph>)
          15348 => 16#989C#,   --  颜 (<CJK Ideograph>)
          15349 => 16#960E#,   --  阎 (<CJK Ideograph>)
          15350 => 16#708E#,   --  炎 (<CJK Ideograph>)
          15351 => 16#6CBF#,   --  沿 (<CJK Ideograph>)
          15352 => 16#5944#,   --  奄 (<CJK Ideograph>)
          15353 => 16#63A9#,   --  掩 (<CJK Ideograph>)
          15354 => 16#773C#,   --  眼 (<CJK Ideograph>)
          15355 => 16#884D#,   --  衍 (<CJK Ideograph>)
          15356 => 16#6F14#,   --  演 (<CJK Ideograph>)
          15357 => 16#8273#,   --  艳 (<CJK Ideograph>)
          15358 => 16#5830#,   --  堰 (<CJK Ideograph>)
          15359 => 16#71D5#,   --  燕 (<CJK Ideograph>)
          15360 => 16#538C#,   --  厌 (<CJK Ideograph>)
          15361 => 16#781A#,   --  砚 (<CJK Ideograph>)
          15362 => 16#96C1#,   --  雁 (<CJK Ideograph>)
          15363 => 16#5501#,   --  唁 (<CJK Ideograph>)
          15364 => 16#5F66#,   --  彦 (<CJK Ideograph>)
          15365 => 16#7130#,   --  焰 (<CJK Ideograph>)
          15366 => 16#5BB4#,   --  宴 (<CJK Ideograph>)
          15367 => 16#8C1A#,   --  谚 (<CJK Ideograph>)
          15368 => 16#9A8C#,   --  验 (<CJK Ideograph>)
          15369 => 16#6B83#,   --  殃 (<CJK Ideograph>)
          15370 => 16#592E#,   --  央 (<CJK Ideograph>)
          15371 => 16#9E2F#,   --  鸯 (<CJK Ideograph>)
          15372 => 16#79E7#,   --  秧 (<CJK Ideograph>)
          15373 => 16#6768#,   --  杨 (<CJK Ideograph>)
          15374 => 16#626C#,   --  扬 (<CJK Ideograph>)
          15375 => 16#4F6F#,   --  佯 (<CJK Ideograph>)
          15376 => 16#75A1#,   --  疡 (<CJK Ideograph>)
          15377 => 16#7F8A#,   --  羊 (<CJK Ideograph>)
          15378 => 16#6D0B#,   --  洋 (<CJK Ideograph>)
          15379 => 16#9633#,   --  阳 (<CJK Ideograph>)
          15380 => 16#6C27#,   --  氧 (<CJK Ideograph>)
          15381 => 16#4EF0#,   --  仰 (<CJK Ideograph>)
          15382 => 16#75D2#,   --  痒 (<CJK Ideograph>)
          15383 => 16#517B#,   --  养 (<CJK Ideograph>)
          15384 => 16#6837#,   --  样 (<CJK Ideograph>)
          15385 => 16#6F3E#,   --  漾 (<CJK Ideograph>)
          15386 => 16#9080#,   --  邀 (<CJK Ideograph>)
          15387 => 16#8170#,   --  腰 (<CJK Ideograph>)
          15388 => 16#5996#,   --  妖 (<CJK Ideograph>)
          15389 => 16#7476#,   --  瑶 (<CJK Ideograph>)
          15390 => 16#8938#,   --  褸 (<CJK Ideograph>)
          15391 => 16#8939#,   --  褹 (<CJK Ideograph>)
          15392 => 16#893A#,   --  褺 (<CJK Ideograph>)
          15393 => 16#893B#,   --  褻 (<CJK Ideograph>)
          15394 => 16#893C#,   --  褼 (<CJK Ideograph>)
          15395 => 16#893D#,   --  褽 (<CJK Ideograph>)
          15396 => 16#893E#,   --  褾 (<CJK Ideograph>)
          15397 => 16#893F#,   --  褿 (<CJK Ideograph>)
          15398 => 16#8940#,   --  襀 (<CJK Ideograph>)
          15399 => 16#8942#,   --  襂 (<CJK Ideograph>)
          15400 => 16#8943#,   --  襃 (<CJK Ideograph>)
          15401 => 16#8945#,   --  襅 (<CJK Ideograph>)
          15402 => 16#8946#,   --  襆 (<CJK Ideograph>)
          15403 => 16#8947#,   --  襇 (<CJK Ideograph>)
          15404 => 16#8948#,   --  襈 (<CJK Ideograph>)
          15405 => 16#8949#,   --  襉 (<CJK Ideograph>)
          15406 => 16#894A#,   --  襊 (<CJK Ideograph>)
          15407 => 16#894B#,   --  襋 (<CJK Ideograph>)
          15408 => 16#894C#,   --  襌 (<CJK Ideograph>)
          15409 => 16#894D#,   --  襍 (<CJK Ideograph>)
          15410 => 16#894E#,   --  襎 (<CJK Ideograph>)
          15411 => 16#894F#,   --  襏 (<CJK Ideograph>)
          15412 => 16#8950#,   --  襐 (<CJK Ideograph>)
          15413 => 16#8951#,   --  襑 (<CJK Ideograph>)
          15414 => 16#8952#,   --  襒 (<CJK Ideograph>)
          15415 => 16#8953#,   --  襓 (<CJK Ideograph>)
          15416 => 16#8954#,   --  襔 (<CJK Ideograph>)
          15417 => 16#8955#,   --  襕 (<CJK Ideograph>)
          15418 => 16#8956#,   --  襖 (<CJK Ideograph>)
          15419 => 16#8957#,   --  襗 (<CJK Ideograph>)
          15420 => 16#8958#,   --  襘 (<CJK Ideograph>)
          15421 => 16#8959#,   --  襙 (<CJK Ideograph>)
          15422 => 16#895A#,   --  襚 (<CJK Ideograph>)
          15423 => 16#895B#,   --  襛 (<CJK Ideograph>)
          15424 => 16#895C#,   --  襜 (<CJK Ideograph>)
          15425 => 16#895D#,   --  襝 (<CJK Ideograph>)
          15426 => 16#8960#,   --  襠 (<CJK Ideograph>)
          15427 => 16#8961#,   --  襡 (<CJK Ideograph>)
          15428 => 16#8962#,   --  襢 (<CJK Ideograph>)
          15429 => 16#8963#,   --  襣 (<CJK Ideograph>)
          15430 => 16#8964#,   --  襤 (<CJK Ideograph>)
          15431 => 16#8965#,   --  襥 (<CJK Ideograph>)
          15432 => 16#8967#,   --  襧 (<CJK Ideograph>)
          15433 => 16#8968#,   --  襨 (<CJK Ideograph>)
          15434 => 16#8969#,   --  襩 (<CJK Ideograph>)
          15435 => 16#896A#,   --  襪 (<CJK Ideograph>)
          15436 => 16#896B#,   --  襫 (<CJK Ideograph>)
          15437 => 16#896C#,   --  襬 (<CJK Ideograph>)
          15438 => 16#896D#,   --  襭 (<CJK Ideograph>)
          15439 => 16#896E#,   --  襮 (<CJK Ideograph>)
          15440 => 16#896F#,   --  襯 (<CJK Ideograph>)
          15441 => 16#8970#,   --  襰 (<CJK Ideograph>)
          15442 => 16#8971#,   --  襱 (<CJK Ideograph>)
          15443 => 16#8972#,   --  襲 (<CJK Ideograph>)
          15444 => 16#8973#,   --  襳 (<CJK Ideograph>)
          15445 => 16#8974#,   --  襴 (<CJK Ideograph>)
          15446 => 16#8975#,   --  襵 (<CJK Ideograph>)
          15447 => 16#8976#,   --  襶 (<CJK Ideograph>)
          15448 => 16#8977#,   --  襷 (<CJK Ideograph>)
          15449 => 16#8978#,   --  襸 (<CJK Ideograph>)
          15450 => 16#8979#,   --  襹 (<CJK Ideograph>)
          15451 => 16#897A#,   --  襺 (<CJK Ideograph>)
          15452 => 16#897C#,   --  襼 (<CJK Ideograph>)
          15453 => 16#897D#,   --  襽 (<CJK Ideograph>)
          15454 => 16#897E#,   --  襾 (<CJK Ideograph>)
          15455 => 16#8980#,   --  覀 (<CJK Ideograph>)
          15456 => 16#8982#,   --  覂 (<CJK Ideograph>)
          15457 => 16#8984#,   --  覄 (<CJK Ideograph>)
          15458 => 16#8985#,   --  覅 (<CJK Ideograph>)
          15459 => 16#8987#,   --  覇 (<CJK Ideograph>)
          15460 => 16#8988#,   --  覈 (<CJK Ideograph>)
          15461 => 16#8989#,   --  覉 (<CJK Ideograph>)
          15462 => 16#898A#,   --  覊 (<CJK Ideograph>)
          15463 => 16#898B#,   --  見 (<CJK Ideograph>)
          15464 => 16#898C#,   --  覌 (<CJK Ideograph>)
          15465 => 16#898D#,   --  覍 (<CJK Ideograph>)
          15466 => 16#898E#,   --  覎 (<CJK Ideograph>)
          15467 => 16#898F#,   --  規 (<CJK Ideograph>)
          15468 => 16#8990#,   --  覐 (<CJK Ideograph>)
          15469 => 16#8991#,   --  覑 (<CJK Ideograph>)
          15470 => 16#8992#,   --  覒 (<CJK Ideograph>)
          15471 => 16#8993#,   --  覓 (<CJK Ideograph>)
          15472 => 16#8994#,   --  覔 (<CJK Ideograph>)
          15473 => 16#8995#,   --  覕 (<CJK Ideograph>)
          15474 => 16#8996#,   --  視 (<CJK Ideograph>)
          15475 => 16#8997#,   --  覗 (<CJK Ideograph>)
          15476 => 16#8998#,   --  覘 (<CJK Ideograph>)
          15477 => 16#8999#,   --  覙 (<CJK Ideograph>)
          15478 => 16#899A#,   --  覚 (<CJK Ideograph>)
          15479 => 16#899B#,   --  覛 (<CJK Ideograph>)
          15480 => 16#899C#,   --  覜 (<CJK Ideograph>)
          15481 => 16#899D#,   --  覝 (<CJK Ideograph>)
          15482 => 16#899E#,   --  覞 (<CJK Ideograph>)
          15483 => 16#899F#,   --  覟 (<CJK Ideograph>)
          15484 => 16#89A0#,   --  覠 (<CJK Ideograph>)
          15485 => 16#89A1#,   --  覡 (<CJK Ideograph>)
          15486 => 16#6447#,   --  摇 (<CJK Ideograph>)
          15487 => 16#5C27#,   --  尧 (<CJK Ideograph>)
          15488 => 16#9065#,   --  遥 (<CJK Ideograph>)
          15489 => 16#7A91#,   --  窑 (<CJK Ideograph>)
          15490 => 16#8C23#,   --  谣 (<CJK Ideograph>)
          15491 => 16#59DA#,   --  姚 (<CJK Ideograph>)
          15492 => 16#54AC#,   --  咬 (<CJK Ideograph>)
          15493 => 16#8200#,   --  舀 (<CJK Ideograph>)
          15494 => 16#836F#,   --  药 (<CJK Ideograph>)
          15495 => 16#8981#,   --  要 (<CJK Ideograph>)
          15496 => 16#8000#,   --  耀 (<CJK Ideograph>)
          15497 => 16#6930#,   --  椰 (<CJK Ideograph>)
          15498 => 16#564E#,   --  噎 (<CJK Ideograph>)
          15499 => 16#8036#,   --  耶 (<CJK Ideograph>)
          15500 => 16#7237#,   --  爷 (<CJK Ideograph>)
          15501 => 16#91CE#,   --  野 (<CJK Ideograph>)
          15502 => 16#51B6#,   --  冶 (<CJK Ideograph>)
          15503 => 16#4E5F#,   --  也 (<CJK Ideograph>)
          15504 => 16#9875#,   --  页 (<CJK Ideograph>)
          15505 => 16#6396#,   --  掖 (<CJK Ideograph>)
          15506 => 16#4E1A#,   --  业 (<CJK Ideograph>)
          15507 => 16#53F6#,   --  叶 (<CJK Ideograph>)
          15508 => 16#66F3#,   --  曳 (<CJK Ideograph>)
          15509 => 16#814B#,   --  腋 (<CJK Ideograph>)
          15510 => 16#591C#,   --  夜 (<CJK Ideograph>)
          15511 => 16#6DB2#,   --  液 (<CJK Ideograph>)
          15512 => 16#4E00#,   --  一 (<CJK Ideograph>)
          15513 => 16#58F9#,   --  壹 (<CJK Ideograph>)
          15514 => 16#533B#,   --  医 (<CJK Ideograph>)
          15515 => 16#63D6#,   --  揖 (<CJK Ideograph>)
          15516 => 16#94F1#,   --  铱 (<CJK Ideograph>)
          15517 => 16#4F9D#,   --  依 (<CJK Ideograph>)
          15518 => 16#4F0A#,   --  伊 (<CJK Ideograph>)
          15519 => 16#8863#,   --  衣 (<CJK Ideograph>)
          15520 => 16#9890#,   --  颐 (<CJK Ideograph>)
          15521 => 16#5937#,   --  夷 (<CJK Ideograph>)
          15522 => 16#9057#,   --  遗 (<CJK Ideograph>)
          15523 => 16#79FB#,   --  移 (<CJK Ideograph>)
          15524 => 16#4EEA#,   --  仪 (<CJK Ideograph>)
          15525 => 16#80F0#,   --  胰 (<CJK Ideograph>)
          15526 => 16#7591#,   --  疑 (<CJK Ideograph>)
          15527 => 16#6C82#,   --  沂 (<CJK Ideograph>)
          15528 => 16#5B9C#,   --  宜 (<CJK Ideograph>)
          15529 => 16#59E8#,   --  姨 (<CJK Ideograph>)
          15530 => 16#5F5D#,   --  彝 (<CJK Ideograph>)
          15531 => 16#6905#,   --  椅 (<CJK Ideograph>)
          15532 => 16#8681#,   --  蚁 (<CJK Ideograph>)
          15533 => 16#501A#,   --  倚 (<CJK Ideograph>)
          15534 => 16#5DF2#,   --  已 (<CJK Ideograph>)
          15535 => 16#4E59#,   --  乙 (<CJK Ideograph>)
          15536 => 16#77E3#,   --  矣 (<CJK Ideograph>)
          15537 => 16#4EE5#,   --  以 (<CJK Ideograph>)
          15538 => 16#827A#,   --  艺 (<CJK Ideograph>)
          15539 => 16#6291#,   --  抑 (<CJK Ideograph>)
          15540 => 16#6613#,   --  易 (<CJK Ideograph>)
          15541 => 16#9091#,   --  邑 (<CJK Ideograph>)
          15542 => 16#5C79#,   --  屹 (<CJK Ideograph>)
          15543 => 16#4EBF#,   --  亿 (<CJK Ideograph>)
          15544 => 16#5F79#,   --  役 (<CJK Ideograph>)
          15545 => 16#81C6#,   --  臆 (<CJK Ideograph>)
          15546 => 16#9038#,   --  逸 (<CJK Ideograph>)
          15547 => 16#8084#,   --  肄 (<CJK Ideograph>)
          15548 => 16#75AB#,   --  疫 (<CJK Ideograph>)
          15549 => 16#4EA6#,   --  亦 (<CJK Ideograph>)
          15550 => 16#88D4#,   --  裔 (<CJK Ideograph>)
          15551 => 16#610F#,   --  意 (<CJK Ideograph>)
          15552 => 16#6BC5#,   --  毅 (<CJK Ideograph>)
          15553 => 16#5FC6#,   --  忆 (<CJK Ideograph>)
          15554 => 16#4E49#,   --  义 (<CJK Ideograph>)
          15555 => 16#76CA#,   --  益 (<CJK Ideograph>)
          15556 => 16#6EA2#,   --  溢 (<CJK Ideograph>)
          15557 => 16#8BE3#,   --  诣 (<CJK Ideograph>)
          15558 => 16#8BAE#,   --  议 (<CJK Ideograph>)
          15559 => 16#8C0A#,   --  谊 (<CJK Ideograph>)
          15560 => 16#8BD1#,   --  译 (<CJK Ideograph>)
          15561 => 16#5F02#,   --  异 (<CJK Ideograph>)
          15562 => 16#7FFC#,   --  翼 (<CJK Ideograph>)
          15563 => 16#7FCC#,   --  翌 (<CJK Ideograph>)
          15564 => 16#7ECE#,   --  绎 (<CJK Ideograph>)
          15565 => 16#8335#,   --  茵 (<CJK Ideograph>)
          15566 => 16#836B#,   --  荫 (<CJK Ideograph>)
          15567 => 16#56E0#,   --  因 (<CJK Ideograph>)
          15568 => 16#6BB7#,   --  殷 (<CJK Ideograph>)
          15569 => 16#97F3#,   --  音 (<CJK Ideograph>)
          15570 => 16#9634#,   --  阴 (<CJK Ideograph>)
          15571 => 16#59FB#,   --  姻 (<CJK Ideograph>)
          15572 => 16#541F#,   --  吟 (<CJK Ideograph>)
          15573 => 16#94F6#,   --  银 (<CJK Ideograph>)
          15574 => 16#6DEB#,   --  淫 (<CJK Ideograph>)
          15575 => 16#5BC5#,   --  寅 (<CJK Ideograph>)
          15576 => 16#996E#,   --  饮 (<CJK Ideograph>)
          15577 => 16#5C39#,   --  尹 (<CJK Ideograph>)
          15578 => 16#5F15#,   --  引 (<CJK Ideograph>)
          15579 => 16#9690#,   --  隐 (<CJK Ideograph>)
          15580 => 16#89A2#,   --  覢 (<CJK Ideograph>)
          15581 => 16#89A3#,   --  覣 (<CJK Ideograph>)
          15582 => 16#89A4#,   --  覤 (<CJK Ideograph>)
          15583 => 16#89A5#,   --  覥 (<CJK Ideograph>)
          15584 => 16#89A6#,   --  覦 (<CJK Ideograph>)
          15585 => 16#89A7#,   --  覧 (<CJK Ideograph>)
          15586 => 16#89A8#,   --  覨 (<CJK Ideograph>)
          15587 => 16#89A9#,   --  覩 (<CJK Ideograph>)
          15588 => 16#89AA#,   --  親 (<CJK Ideograph>)
          15589 => 16#89AB#,   --  覫 (<CJK Ideograph>)
          15590 => 16#89AC#,   --  覬 (<CJK Ideograph>)
          15591 => 16#89AD#,   --  覭 (<CJK Ideograph>)
          15592 => 16#89AE#,   --  覮 (<CJK Ideograph>)
          15593 => 16#89AF#,   --  覯 (<CJK Ideograph>)
          15594 => 16#89B0#,   --  覰 (<CJK Ideograph>)
          15595 => 16#89B1#,   --  覱 (<CJK Ideograph>)
          15596 => 16#89B2#,   --  覲 (<CJK Ideograph>)
          15597 => 16#89B3#,   --  観 (<CJK Ideograph>)
          15598 => 16#89B4#,   --  覴 (<CJK Ideograph>)
          15599 => 16#89B5#,   --  覵 (<CJK Ideograph>)
          15600 => 16#89B6#,   --  覶 (<CJK Ideograph>)
          15601 => 16#89B7#,   --  覷 (<CJK Ideograph>)
          15602 => 16#89B8#,   --  覸 (<CJK Ideograph>)
          15603 => 16#89B9#,   --  覹 (<CJK Ideograph>)
          15604 => 16#89BA#,   --  覺 (<CJK Ideograph>)
          15605 => 16#89BB#,   --  覻 (<CJK Ideograph>)
          15606 => 16#89BC#,   --  覼 (<CJK Ideograph>)
          15607 => 16#89BD#,   --  覽 (<CJK Ideograph>)
          15608 => 16#89BE#,   --  覾 (<CJK Ideograph>)
          15609 => 16#89BF#,   --  覿 (<CJK Ideograph>)
          15610 => 16#89C0#,   --  觀 (<CJK Ideograph>)
          15611 => 16#89C3#,   --  觃 (<CJK Ideograph>)
          15612 => 16#89CD#,   --  觍 (<CJK Ideograph>)
          15613 => 16#89D3#,   --  觓 (<CJK Ideograph>)
          15614 => 16#89D4#,   --  觔 (<CJK Ideograph>)
          15615 => 16#89D5#,   --  觕 (<CJK Ideograph>)
          15616 => 16#89D7#,   --  觗 (<CJK Ideograph>)
          15617 => 16#89D8#,   --  觘 (<CJK Ideograph>)
          15618 => 16#89D9#,   --  觙 (<CJK Ideograph>)
          15619 => 16#89DB#,   --  觛 (<CJK Ideograph>)
          15620 => 16#89DD#,   --  觝 (<CJK Ideograph>)
          15621 => 16#89DF#,   --  觟 (<CJK Ideograph>)
          15622 => 16#89E0#,   --  觠 (<CJK Ideograph>)
          15623 => 16#89E1#,   --  觡 (<CJK Ideograph>)
          15624 => 16#89E2#,   --  觢 (<CJK Ideograph>)
          15625 => 16#89E4#,   --  觤 (<CJK Ideograph>)
          15626 => 16#89E7#,   --  觧 (<CJK Ideograph>)
          15627 => 16#89E8#,   --  觨 (<CJK Ideograph>)
          15628 => 16#89E9#,   --  觩 (<CJK Ideograph>)
          15629 => 16#89EA#,   --  觪 (<CJK Ideograph>)
          15630 => 16#89EC#,   --  觬 (<CJK Ideograph>)
          15631 => 16#89ED#,   --  觭 (<CJK Ideograph>)
          15632 => 16#89EE#,   --  觮 (<CJK Ideograph>)
          15633 => 16#89F0#,   --  觰 (<CJK Ideograph>)
          15634 => 16#89F1#,   --  觱 (<CJK Ideograph>)
          15635 => 16#89F2#,   --  觲 (<CJK Ideograph>)
          15636 => 16#89F4#,   --  觴 (<CJK Ideograph>)
          15637 => 16#89F5#,   --  觵 (<CJK Ideograph>)
          15638 => 16#89F6#,   --  觶 (<CJK Ideograph>)
          15639 => 16#89F7#,   --  觷 (<CJK Ideograph>)
          15640 => 16#89F8#,   --  觸 (<CJK Ideograph>)
          15641 => 16#89F9#,   --  觹 (<CJK Ideograph>)
          15642 => 16#89FA#,   --  觺 (<CJK Ideograph>)
          15643 => 16#89FB#,   --  觻 (<CJK Ideograph>)
          15644 => 16#89FC#,   --  觼 (<CJK Ideograph>)
          15645 => 16#89FD#,   --  觽 (<CJK Ideograph>)
          15646 => 16#89FE#,   --  觾 (<CJK Ideograph>)
          15647 => 16#89FF#,   --  觿 (<CJK Ideograph>)
          15648 => 16#8A01#,   --  訁 (<CJK Ideograph>)
          15649 => 16#8A02#,   --  訂 (<CJK Ideograph>)
          15650 => 16#8A03#,   --  訃 (<CJK Ideograph>)
          15651 => 16#8A04#,   --  訄 (<CJK Ideograph>)
          15652 => 16#8A05#,   --  訅 (<CJK Ideograph>)
          15653 => 16#8A06#,   --  訆 (<CJK Ideograph>)
          15654 => 16#8A08#,   --  計 (<CJK Ideograph>)
          15655 => 16#8A09#,   --  訉 (<CJK Ideograph>)
          15656 => 16#8A0A#,   --  訊 (<CJK Ideograph>)
          15657 => 16#8A0B#,   --  訋 (<CJK Ideograph>)
          15658 => 16#8A0C#,   --  訌 (<CJK Ideograph>)
          15659 => 16#8A0D#,   --  訍 (<CJK Ideograph>)
          15660 => 16#8A0E#,   --  討 (<CJK Ideograph>)
          15661 => 16#8A0F#,   --  訏 (<CJK Ideograph>)
          15662 => 16#8A10#,   --  訐 (<CJK Ideograph>)
          15663 => 16#8A11#,   --  訑 (<CJK Ideograph>)
          15664 => 16#8A12#,   --  訒 (<CJK Ideograph>)
          15665 => 16#8A13#,   --  訓 (<CJK Ideograph>)
          15666 => 16#8A14#,   --  訔 (<CJK Ideograph>)
          15667 => 16#8A15#,   --  訕 (<CJK Ideograph>)
          15668 => 16#8A16#,   --  訖 (<CJK Ideograph>)
          15669 => 16#8A17#,   --  託 (<CJK Ideograph>)
          15670 => 16#8A18#,   --  記 (<CJK Ideograph>)
          15671 => 16#8A19#,   --  訙 (<CJK Ideograph>)
          15672 => 16#8A1A#,   --  訚 (<CJK Ideograph>)
          15673 => 16#8A1B#,   --  訛 (<CJK Ideograph>)
          15674 => 16#8A1C#,   --  訜 (<CJK Ideograph>)
          15675 => 16#8A1D#,   --  訝 (<CJK Ideograph>)
          15676 => 16#5370#,   --  印 (<CJK Ideograph>)
          15677 => 16#82F1#,   --  英 (<CJK Ideograph>)
          15678 => 16#6A31#,   --  樱 (<CJK Ideograph>)
          15679 => 16#5A74#,   --  婴 (<CJK Ideograph>)
          15680 => 16#9E70#,   --  鹰 (<CJK Ideograph>)
          15681 => 16#5E94#,   --  应 (<CJK Ideograph>)
          15682 => 16#7F28#,   --  缨 (<CJK Ideograph>)
          15683 => 16#83B9#,   --  莹 (<CJK Ideograph>)
          15684 => 16#8424#,   --  萤 (<CJK Ideograph>)
          15685 => 16#8425#,   --  营 (<CJK Ideograph>)
          15686 => 16#8367#,   --  荧 (<CJK Ideograph>)
          15687 => 16#8747#,   --  蝇 (<CJK Ideograph>)
          15688 => 16#8FCE#,   --  迎 (<CJK Ideograph>)
          15689 => 16#8D62#,   --  赢 (<CJK Ideograph>)
          15690 => 16#76C8#,   --  盈 (<CJK Ideograph>)
          15691 => 16#5F71#,   --  影 (<CJK Ideograph>)
          15692 => 16#9896#,   --  颖 (<CJK Ideograph>)
          15693 => 16#786C#,   --  硬 (<CJK Ideograph>)
          15694 => 16#6620#,   --  映 (<CJK Ideograph>)
          15695 => 16#54DF#,   --  哟 (<CJK Ideograph>)
          15696 => 16#62E5#,   --  拥 (<CJK Ideograph>)
          15697 => 16#4F63#,   --  佣 (<CJK Ideograph>)
          15698 => 16#81C3#,   --  臃 (<CJK Ideograph>)
          15699 => 16#75C8#,   --  痈 (<CJK Ideograph>)
          15700 => 16#5EB8#,   --  庸 (<CJK Ideograph>)
          15701 => 16#96CD#,   --  雍 (<CJK Ideograph>)
          15702 => 16#8E0A#,   --  踊 (<CJK Ideograph>)
          15703 => 16#86F9#,   --  蛹 (<CJK Ideograph>)
          15704 => 16#548F#,   --  咏 (<CJK Ideograph>)
          15705 => 16#6CF3#,   --  泳 (<CJK Ideograph>)
          15706 => 16#6D8C#,   --  涌 (<CJK Ideograph>)
          15707 => 16#6C38#,   --  永 (<CJK Ideograph>)
          15708 => 16#607F#,   --  恿 (<CJK Ideograph>)
          15709 => 16#52C7#,   --  勇 (<CJK Ideograph>)
          15710 => 16#7528#,   --  用 (<CJK Ideograph>)
          15711 => 16#5E7D#,   --  幽 (<CJK Ideograph>)
          15712 => 16#4F18#,   --  优 (<CJK Ideograph>)
          15713 => 16#60A0#,   --  悠 (<CJK Ideograph>)
          15714 => 16#5FE7#,   --  忧 (<CJK Ideograph>)
          15715 => 16#5C24#,   --  尤 (<CJK Ideograph>)
          15716 => 16#7531#,   --  由 (<CJK Ideograph>)
          15717 => 16#90AE#,   --  邮 (<CJK Ideograph>)
          15718 => 16#94C0#,   --  铀 (<CJK Ideograph>)
          15719 => 16#72B9#,   --  犹 (<CJK Ideograph>)
          15720 => 16#6CB9#,   --  油 (<CJK Ideograph>)
          15721 => 16#6E38#,   --  游 (<CJK Ideograph>)
          15722 => 16#9149#,   --  酉 (<CJK Ideograph>)
          15723 => 16#6709#,   --  有 (<CJK Ideograph>)
          15724 => 16#53CB#,   --  友 (<CJK Ideograph>)
          15725 => 16#53F3#,   --  右 (<CJK Ideograph>)
          15726 => 16#4F51#,   --  佑 (<CJK Ideograph>)
          15727 => 16#91C9#,   --  釉 (<CJK Ideograph>)
          15728 => 16#8BF1#,   --  诱 (<CJK Ideograph>)
          15729 => 16#53C8#,   --  又 (<CJK Ideograph>)
          15730 => 16#5E7C#,   --  幼 (<CJK Ideograph>)
          15731 => 16#8FC2#,   --  迂 (<CJK Ideograph>)
          15732 => 16#6DE4#,   --  淤 (<CJK Ideograph>)
          15733 => 16#4E8E#,   --  于 (<CJK Ideograph>)
          15734 => 16#76C2#,   --  盂 (<CJK Ideograph>)
          15735 => 16#6986#,   --  榆 (<CJK Ideograph>)
          15736 => 16#865E#,   --  虞 (<CJK Ideograph>)
          15737 => 16#611A#,   --  愚 (<CJK Ideograph>)
          15738 => 16#8206#,   --  舆 (<CJK Ideograph>)
          15739 => 16#4F59#,   --  余 (<CJK Ideograph>)
          15740 => 16#4FDE#,   --  俞 (<CJK Ideograph>)
          15741 => 16#903E#,   --  逾 (<CJK Ideograph>)
          15742 => 16#9C7C#,   --  鱼 (<CJK Ideograph>)
          15743 => 16#6109#,   --  愉 (<CJK Ideograph>)
          15744 => 16#6E1D#,   --  渝 (<CJK Ideograph>)
          15745 => 16#6E14#,   --  渔 (<CJK Ideograph>)
          15746 => 16#9685#,   --  隅 (<CJK Ideograph>)
          15747 => 16#4E88#,   --  予 (<CJK Ideograph>)
          15748 => 16#5A31#,   --  娱 (<CJK Ideograph>)
          15749 => 16#96E8#,   --  雨 (<CJK Ideograph>)
          15750 => 16#4E0E#,   --  与 (<CJK Ideograph>)
          15751 => 16#5C7F#,   --  屿 (<CJK Ideograph>)
          15752 => 16#79B9#,   --  禹 (<CJK Ideograph>)
          15753 => 16#5B87#,   --  宇 (<CJK Ideograph>)
          15754 => 16#8BED#,   --  语 (<CJK Ideograph>)
          15755 => 16#7FBD#,   --  羽 (<CJK Ideograph>)
          15756 => 16#7389#,   --  玉 (<CJK Ideograph>)
          15757 => 16#57DF#,   --  域 (<CJK Ideograph>)
          15758 => 16#828B#,   --  芋 (<CJK Ideograph>)
          15759 => 16#90C1#,   --  郁 (<CJK Ideograph>)
          15760 => 16#5401#,   --  吁 (<CJK Ideograph>)
          15761 => 16#9047#,   --  遇 (<CJK Ideograph>)
          15762 => 16#55BB#,   --  喻 (<CJK Ideograph>)
          15763 => 16#5CEA#,   --  峪 (<CJK Ideograph>)
          15764 => 16#5FA1#,   --  御 (<CJK Ideograph>)
          15765 => 16#6108#,   --  愈 (<CJK Ideograph>)
          15766 => 16#6B32#,   --  欲 (<CJK Ideograph>)
          15767 => 16#72F1#,   --  狱 (<CJK Ideograph>)
          15768 => 16#80B2#,   --  育 (<CJK Ideograph>)
          15769 => 16#8A89#,   --  誉 (<CJK Ideograph>)
          15770 => 16#8A1E#,   --  訞 (<CJK Ideograph>)
          15771 => 16#8A1F#,   --  訟 (<CJK Ideograph>)
          15772 => 16#8A20#,   --  訠 (<CJK Ideograph>)
          15773 => 16#8A21#,   --  訡 (<CJK Ideograph>)
          15774 => 16#8A22#,   --  訢 (<CJK Ideograph>)
          15775 => 16#8A23#,   --  訣 (<CJK Ideograph>)
          15776 => 16#8A24#,   --  訤 (<CJK Ideograph>)
          15777 => 16#8A25#,   --  訥 (<CJK Ideograph>)
          15778 => 16#8A26#,   --  訦 (<CJK Ideograph>)
          15779 => 16#8A27#,   --  訧 (<CJK Ideograph>)
          15780 => 16#8A28#,   --  訨 (<CJK Ideograph>)
          15781 => 16#8A29#,   --  訩 (<CJK Ideograph>)
          15782 => 16#8A2A#,   --  訪 (<CJK Ideograph>)
          15783 => 16#8A2B#,   --  訫 (<CJK Ideograph>)
          15784 => 16#8A2C#,   --  訬 (<CJK Ideograph>)
          15785 => 16#8A2D#,   --  設 (<CJK Ideograph>)
          15786 => 16#8A2E#,   --  訮 (<CJK Ideograph>)
          15787 => 16#8A2F#,   --  訯 (<CJK Ideograph>)
          15788 => 16#8A30#,   --  訰 (<CJK Ideograph>)
          15789 => 16#8A31#,   --  許 (<CJK Ideograph>)
          15790 => 16#8A32#,   --  訲 (<CJK Ideograph>)
          15791 => 16#8A33#,   --  訳 (<CJK Ideograph>)
          15792 => 16#8A34#,   --  訴 (<CJK Ideograph>)
          15793 => 16#8A35#,   --  訵 (<CJK Ideograph>)
          15794 => 16#8A36#,   --  訶 (<CJK Ideograph>)
          15795 => 16#8A37#,   --  訷 (<CJK Ideograph>)
          15796 => 16#8A38#,   --  訸 (<CJK Ideograph>)
          15797 => 16#8A39#,   --  訹 (<CJK Ideograph>)
          15798 => 16#8A3A#,   --  診 (<CJK Ideograph>)
          15799 => 16#8A3B#,   --  註 (<CJK Ideograph>)
          15800 => 16#8A3C#,   --  証 (<CJK Ideograph>)
          15801 => 16#8A3D#,   --  訽 (<CJK Ideograph>)
          15802 => 16#8A3F#,   --  訿 (<CJK Ideograph>)
          15803 => 16#8A40#,   --  詀 (<CJK Ideograph>)
          15804 => 16#8A41#,   --  詁 (<CJK Ideograph>)
          15805 => 16#8A42#,   --  詂 (<CJK Ideograph>)
          15806 => 16#8A43#,   --  詃 (<CJK Ideograph>)
          15807 => 16#8A44#,   --  詄 (<CJK Ideograph>)
          15808 => 16#8A45#,   --  詅 (<CJK Ideograph>)
          15809 => 16#8A46#,   --  詆 (<CJK Ideograph>)
          15810 => 16#8A47#,   --  詇 (<CJK Ideograph>)
          15811 => 16#8A49#,   --  詉 (<CJK Ideograph>)
          15812 => 16#8A4A#,   --  詊 (<CJK Ideograph>)
          15813 => 16#8A4B#,   --  詋 (<CJK Ideograph>)
          15814 => 16#8A4C#,   --  詌 (<CJK Ideograph>)
          15815 => 16#8A4D#,   --  詍 (<CJK Ideograph>)
          15816 => 16#8A4E#,   --  詎 (<CJK Ideograph>)
          15817 => 16#8A4F#,   --  詏 (<CJK Ideograph>)
          15818 => 16#8A50#,   --  詐 (<CJK Ideograph>)
          15819 => 16#8A51#,   --  詑 (<CJK Ideograph>)
          15820 => 16#8A52#,   --  詒 (<CJK Ideograph>)
          15821 => 16#8A53#,   --  詓 (<CJK Ideograph>)
          15822 => 16#8A54#,   --  詔 (<CJK Ideograph>)
          15823 => 16#8A55#,   --  評 (<CJK Ideograph>)
          15824 => 16#8A56#,   --  詖 (<CJK Ideograph>)
          15825 => 16#8A57#,   --  詗 (<CJK Ideograph>)
          15826 => 16#8A58#,   --  詘 (<CJK Ideograph>)
          15827 => 16#8A59#,   --  詙 (<CJK Ideograph>)
          15828 => 16#8A5A#,   --  詚 (<CJK Ideograph>)
          15829 => 16#8A5B#,   --  詛 (<CJK Ideograph>)
          15830 => 16#8A5C#,   --  詜 (<CJK Ideograph>)
          15831 => 16#8A5D#,   --  詝 (<CJK Ideograph>)
          15832 => 16#8A5E#,   --  詞 (<CJK Ideograph>)
          15833 => 16#8A5F#,   --  詟 (<CJK Ideograph>)
          15834 => 16#8A60#,   --  詠 (<CJK Ideograph>)
          15835 => 16#8A61#,   --  詡 (<CJK Ideograph>)
          15836 => 16#8A62#,   --  詢 (<CJK Ideograph>)
          15837 => 16#8A63#,   --  詣 (<CJK Ideograph>)
          15838 => 16#8A64#,   --  詤 (<CJK Ideograph>)
          15839 => 16#8A65#,   --  詥 (<CJK Ideograph>)
          15840 => 16#8A66#,   --  試 (<CJK Ideograph>)
          15841 => 16#8A67#,   --  詧 (<CJK Ideograph>)
          15842 => 16#8A68#,   --  詨 (<CJK Ideograph>)
          15843 => 16#8A69#,   --  詩 (<CJK Ideograph>)
          15844 => 16#8A6A#,   --  詪 (<CJK Ideograph>)
          15845 => 16#8A6B#,   --  詫 (<CJK Ideograph>)
          15846 => 16#8A6C#,   --  詬 (<CJK Ideograph>)
          15847 => 16#8A6D#,   --  詭 (<CJK Ideograph>)
          15848 => 16#8A6E#,   --  詮 (<CJK Ideograph>)
          15849 => 16#8A6F#,   --  詯 (<CJK Ideograph>)
          15850 => 16#8A70#,   --  詰 (<CJK Ideograph>)
          15851 => 16#8A71#,   --  話 (<CJK Ideograph>)
          15852 => 16#8A72#,   --  該 (<CJK Ideograph>)
          15853 => 16#8A73#,   --  詳 (<CJK Ideograph>)
          15854 => 16#8A74#,   --  詴 (<CJK Ideograph>)
          15855 => 16#8A75#,   --  詵 (<CJK Ideograph>)
          15856 => 16#8A76#,   --  詶 (<CJK Ideograph>)
          15857 => 16#8A77#,   --  詷 (<CJK Ideograph>)
          15858 => 16#8A78#,   --  詸 (<CJK Ideograph>)
          15859 => 16#8A7A#,   --  詺 (<CJK Ideograph>)
          15860 => 16#8A7B#,   --  詻 (<CJK Ideograph>)
          15861 => 16#8A7C#,   --  詼 (<CJK Ideograph>)
          15862 => 16#8A7D#,   --  詽 (<CJK Ideograph>)
          15863 => 16#8A7E#,   --  詾 (<CJK Ideograph>)
          15864 => 16#8A7F#,   --  詿 (<CJK Ideograph>)
          15865 => 16#8A80#,   --  誀 (<CJK Ideograph>)
          15866 => 16#6D74#,   --  浴 (<CJK Ideograph>)
          15867 => 16#5BD3#,   --  寓 (<CJK Ideograph>)
          15868 => 16#88D5#,   --  裕 (<CJK Ideograph>)
          15869 => 16#9884#,   --  预 (<CJK Ideograph>)
          15870 => 16#8C6B#,   --  豫 (<CJK Ideograph>)
          15871 => 16#9A6D#,   --  驭 (<CJK Ideograph>)
          15872 => 16#9E33#,   --  鸳 (<CJK Ideograph>)
          15873 => 16#6E0A#,   --  渊 (<CJK Ideograph>)
          15874 => 16#51A4#,   --  冤 (<CJK Ideograph>)
          15875 => 16#5143#,   --  元 (<CJK Ideograph>)
          15876 => 16#57A3#,   --  垣 (<CJK Ideograph>)
          15877 => 16#8881#,   --  袁 (<CJK Ideograph>)
          15878 => 16#539F#,   --  原 (<CJK Ideograph>)
          15879 => 16#63F4#,   --  援 (<CJK Ideograph>)
          15880 => 16#8F95#,   --  辕 (<CJK Ideograph>)
          15881 => 16#56ED#,   --  园 (<CJK Ideograph>)
          15882 => 16#5458#,   --  员 (<CJK Ideograph>)
          15883 => 16#5706#,   --  圆 (<CJK Ideograph>)
          15884 => 16#733F#,   --  猿 (<CJK Ideograph>)
          15885 => 16#6E90#,   --  源 (<CJK Ideograph>)
          15886 => 16#7F18#,   --  缘 (<CJK Ideograph>)
          15887 => 16#8FDC#,   --  远 (<CJK Ideograph>)
          15888 => 16#82D1#,   --  苑 (<CJK Ideograph>)
          15889 => 16#613F#,   --  愿 (<CJK Ideograph>)
          15890 => 16#6028#,   --  怨 (<CJK Ideograph>)
          15891 => 16#9662#,   --  院 (<CJK Ideograph>)
          15892 => 16#66F0#,   --  曰 (<CJK Ideograph>)
          15893 => 16#7EA6#,   --  约 (<CJK Ideograph>)
          15894 => 16#8D8A#,   --  越 (<CJK Ideograph>)
          15895 => 16#8DC3#,   --  跃 (<CJK Ideograph>)
          15896 => 16#94A5#,   --  钥 (<CJK Ideograph>)
          15897 => 16#5CB3#,   --  岳 (<CJK Ideograph>)
          15898 => 16#7CA4#,   --  粤 (<CJK Ideograph>)
          15899 => 16#6708#,   --  月 (<CJK Ideograph>)
          15900 => 16#60A6#,   --  悦 (<CJK Ideograph>)
          15901 => 16#9605#,   --  阅 (<CJK Ideograph>)
          15902 => 16#8018#,   --  耘 (<CJK Ideograph>)
          15903 => 16#4E91#,   --  云 (<CJK Ideograph>)
          15904 => 16#90E7#,   --  郧 (<CJK Ideograph>)
          15905 => 16#5300#,   --  匀 (<CJK Ideograph>)
          15906 => 16#9668#,   --  陨 (<CJK Ideograph>)
          15907 => 16#5141#,   --  允 (<CJK Ideograph>)
          15908 => 16#8FD0#,   --  运 (<CJK Ideograph>)
          15909 => 16#8574#,   --  蕴 (<CJK Ideograph>)
          15910 => 16#915D#,   --  酝 (<CJK Ideograph>)
          15911 => 16#6655#,   --  晕 (<CJK Ideograph>)
          15912 => 16#97F5#,   --  韵 (<CJK Ideograph>)
          15913 => 16#5B55#,   --  孕 (<CJK Ideograph>)
          15914 => 16#531D#,   --  匝 (<CJK Ideograph>)
          15915 => 16#7838#,   --  砸 (<CJK Ideograph>)
          15916 => 16#6742#,   --  杂 (<CJK Ideograph>)
          15917 => 16#683D#,   --  栽 (<CJK Ideograph>)
          15918 => 16#54C9#,   --  哉 (<CJK Ideograph>)
          15919 => 16#707E#,   --  灾 (<CJK Ideograph>)
          15920 => 16#5BB0#,   --  宰 (<CJK Ideograph>)
          15921 => 16#8F7D#,   --  载 (<CJK Ideograph>)
          15922 => 16#518D#,   --  再 (<CJK Ideograph>)
          15923 => 16#5728#,   --  在 (<CJK Ideograph>)
          15924 => 16#54B1#,   --  咱 (<CJK Ideograph>)
          15925 => 16#6512#,   --  攒 (<CJK Ideograph>)
          15926 => 16#6682#,   --  暂 (<CJK Ideograph>)
          15927 => 16#8D5E#,   --  赞 (<CJK Ideograph>)
          15928 => 16#8D43#,   --  赃 (<CJK Ideograph>)
          15929 => 16#810F#,   --  脏 (<CJK Ideograph>)
          15930 => 16#846C#,   --  葬 (<CJK Ideograph>)
          15931 => 16#906D#,   --  遭 (<CJK Ideograph>)
          15932 => 16#7CDF#,   --  糟 (<CJK Ideograph>)
          15933 => 16#51FF#,   --  凿 (<CJK Ideograph>)
          15934 => 16#85FB#,   --  藻 (<CJK Ideograph>)
          15935 => 16#67A3#,   --  枣 (<CJK Ideograph>)
          15936 => 16#65E9#,   --  早 (<CJK Ideograph>)
          15937 => 16#6FA1#,   --  澡 (<CJK Ideograph>)
          15938 => 16#86A4#,   --  蚤 (<CJK Ideograph>)
          15939 => 16#8E81#,   --  躁 (<CJK Ideograph>)
          15940 => 16#566A#,   --  噪 (<CJK Ideograph>)
          15941 => 16#9020#,   --  造 (<CJK Ideograph>)
          15942 => 16#7682#,   --  皂 (<CJK Ideograph>)
          15943 => 16#7076#,   --  灶 (<CJK Ideograph>)
          15944 => 16#71E5#,   --  燥 (<CJK Ideograph>)
          15945 => 16#8D23#,   --  责 (<CJK Ideograph>)
          15946 => 16#62E9#,   --  择 (<CJK Ideograph>)
          15947 => 16#5219#,   --  则 (<CJK Ideograph>)
          15948 => 16#6CFD#,   --  泽 (<CJK Ideograph>)
          15949 => 16#8D3C#,   --  贼 (<CJK Ideograph>)
          15950 => 16#600E#,   --  怎 (<CJK Ideograph>)
          15951 => 16#589E#,   --  增 (<CJK Ideograph>)
          15952 => 16#618E#,   --  憎 (<CJK Ideograph>)
          15953 => 16#66FE#,   --  曾 (<CJK Ideograph>)
          15954 => 16#8D60#,   --  赠 (<CJK Ideograph>)
          15955 => 16#624E#,   --  扎 (<CJK Ideograph>)
          15956 => 16#55B3#,   --  喳 (<CJK Ideograph>)
          15957 => 16#6E23#,   --  渣 (<CJK Ideograph>)
          15958 => 16#672D#,   --  札 (<CJK Ideograph>)
          15959 => 16#8F67#,   --  轧 (<CJK Ideograph>)
          15960 => 16#8A81#,   --  誁 (<CJK Ideograph>)
          15961 => 16#8A82#,   --  誂 (<CJK Ideograph>)
          15962 => 16#8A83#,   --  誃 (<CJK Ideograph>)
          15963 => 16#8A84#,   --  誄 (<CJK Ideograph>)
          15964 => 16#8A85#,   --  誅 (<CJK Ideograph>)
          15965 => 16#8A86#,   --  誆 (<CJK Ideograph>)
          15966 => 16#8A87#,   --  誇 (<CJK Ideograph>)
          15967 => 16#8A88#,   --  誈 (<CJK Ideograph>)
          15968 => 16#8A8B#,   --  誋 (<CJK Ideograph>)
          15969 => 16#8A8C#,   --  誌 (<CJK Ideograph>)
          15970 => 16#8A8D#,   --  認 (<CJK Ideograph>)
          15971 => 16#8A8E#,   --  誎 (<CJK Ideograph>)
          15972 => 16#8A8F#,   --  誏 (<CJK Ideograph>)
          15973 => 16#8A90#,   --  誐 (<CJK Ideograph>)
          15974 => 16#8A91#,   --  誑 (<CJK Ideograph>)
          15975 => 16#8A92#,   --  誒 (<CJK Ideograph>)
          15976 => 16#8A94#,   --  誔 (<CJK Ideograph>)
          15977 => 16#8A95#,   --  誕 (<CJK Ideograph>)
          15978 => 16#8A96#,   --  誖 (<CJK Ideograph>)
          15979 => 16#8A97#,   --  誗 (<CJK Ideograph>)
          15980 => 16#8A98#,   --  誘 (<CJK Ideograph>)
          15981 => 16#8A99#,   --  誙 (<CJK Ideograph>)
          15982 => 16#8A9A#,   --  誚 (<CJK Ideograph>)
          15983 => 16#8A9B#,   --  誛 (<CJK Ideograph>)
          15984 => 16#8A9C#,   --  誜 (<CJK Ideograph>)
          15985 => 16#8A9D#,   --  誝 (<CJK Ideograph>)
          15986 => 16#8A9E#,   --  語 (<CJK Ideograph>)
          15987 => 16#8A9F#,   --  誟 (<CJK Ideograph>)
          15988 => 16#8AA0#,   --  誠 (<CJK Ideograph>)
          15989 => 16#8AA1#,   --  誡 (<CJK Ideograph>)
          15990 => 16#8AA2#,   --  誢 (<CJK Ideograph>)
          15991 => 16#8AA3#,   --  誣 (<CJK Ideograph>)
          15992 => 16#8AA4#,   --  誤 (<CJK Ideograph>)
          15993 => 16#8AA5#,   --  誥 (<CJK Ideograph>)
          15994 => 16#8AA6#,   --  誦 (<CJK Ideograph>)
          15995 => 16#8AA7#,   --  誧 (<CJK Ideograph>)
          15996 => 16#8AA8#,   --  誨 (<CJK Ideograph>)
          15997 => 16#8AA9#,   --  誩 (<CJK Ideograph>)
          15998 => 16#8AAA#,   --  說 (<CJK Ideograph>)
          15999 => 16#8AAB#,   --  誫 (<CJK Ideograph>)
          16000 => 16#8AAC#,   --  説 (<CJK Ideograph>)
          16001 => 16#8AAD#,   --  読 (<CJK Ideograph>)
          16002 => 16#8AAE#,   --  誮 (<CJK Ideograph>)
          16003 => 16#8AAF#,   --  誯 (<CJK Ideograph>)
          16004 => 16#8AB0#,   --  誰 (<CJK Ideograph>)
          16005 => 16#8AB1#,   --  誱 (<CJK Ideograph>)
          16006 => 16#8AB2#,   --  課 (<CJK Ideograph>)
          16007 => 16#8AB3#,   --  誳 (<CJK Ideograph>)
          16008 => 16#8AB4#,   --  誴 (<CJK Ideograph>)
          16009 => 16#8AB5#,   --  誵 (<CJK Ideograph>)
          16010 => 16#8AB6#,   --  誶 (<CJK Ideograph>)
          16011 => 16#8AB7#,   --  誷 (<CJK Ideograph>)
          16012 => 16#8AB8#,   --  誸 (<CJK Ideograph>)
          16013 => 16#8AB9#,   --  誹 (<CJK Ideograph>)
          16014 => 16#8ABA#,   --  誺 (<CJK Ideograph>)
          16015 => 16#8ABB#,   --  誻 (<CJK Ideograph>)
          16016 => 16#8ABC#,   --  誼 (<CJK Ideograph>)
          16017 => 16#8ABD#,   --  誽 (<CJK Ideograph>)
          16018 => 16#8ABE#,   --  誾 (<CJK Ideograph>)
          16019 => 16#8ABF#,   --  調 (<CJK Ideograph>)
          16020 => 16#8AC0#,   --  諀 (<CJK Ideograph>)
          16021 => 16#8AC1#,   --  諁 (<CJK Ideograph>)
          16022 => 16#8AC2#,   --  諂 (<CJK Ideograph>)
          16023 => 16#8AC3#,   --  諃 (<CJK Ideograph>)
          16024 => 16#8AC4#,   --  諄 (<CJK Ideograph>)
          16025 => 16#8AC5#,   --  諅 (<CJK Ideograph>)
          16026 => 16#8AC6#,   --  諆 (<CJK Ideograph>)
          16027 => 16#8AC7#,   --  談 (<CJK Ideograph>)
          16028 => 16#8AC8#,   --  諈 (<CJK Ideograph>)
          16029 => 16#8AC9#,   --  諉 (<CJK Ideograph>)
          16030 => 16#8ACA#,   --  諊 (<CJK Ideograph>)
          16031 => 16#8ACB#,   --  請 (<CJK Ideograph>)
          16032 => 16#8ACC#,   --  諌 (<CJK Ideograph>)
          16033 => 16#8ACD#,   --  諍 (<CJK Ideograph>)
          16034 => 16#8ACE#,   --  諎 (<CJK Ideograph>)
          16035 => 16#8ACF#,   --  諏 (<CJK Ideograph>)
          16036 => 16#8AD0#,   --  諐 (<CJK Ideograph>)
          16037 => 16#8AD1#,   --  諑 (<CJK Ideograph>)
          16038 => 16#8AD2#,   --  諒 (<CJK Ideograph>)
          16039 => 16#8AD3#,   --  諓 (<CJK Ideograph>)
          16040 => 16#8AD4#,   --  諔 (<CJK Ideograph>)
          16041 => 16#8AD5#,   --  諕 (<CJK Ideograph>)
          16042 => 16#8AD6#,   --  論 (<CJK Ideograph>)
          16043 => 16#8AD7#,   --  諗 (<CJK Ideograph>)
          16044 => 16#8AD8#,   --  諘 (<CJK Ideograph>)
          16045 => 16#8AD9#,   --  諙 (<CJK Ideograph>)
          16046 => 16#8ADA#,   --  諚 (<CJK Ideograph>)
          16047 => 16#8ADB#,   --  諛 (<CJK Ideograph>)
          16048 => 16#8ADC#,   --  諜 (<CJK Ideograph>)
          16049 => 16#8ADD#,   --  諝 (<CJK Ideograph>)
          16050 => 16#8ADE#,   --  諞 (<CJK Ideograph>)
          16051 => 16#8ADF#,   --  諟 (<CJK Ideograph>)
          16052 => 16#8AE0#,   --  諠 (<CJK Ideograph>)
          16053 => 16#8AE1#,   --  諡 (<CJK Ideograph>)
          16054 => 16#8AE2#,   --  諢 (<CJK Ideograph>)
          16055 => 16#8AE3#,   --  諣 (<CJK Ideograph>)
          16056 => 16#94E1#,   --  铡 (<CJK Ideograph>)
          16057 => 16#95F8#,   --  闸 (<CJK Ideograph>)
          16058 => 16#7728#,   --  眨 (<CJK Ideograph>)
          16059 => 16#6805#,   --  栅 (<CJK Ideograph>)
          16060 => 16#69A8#,   --  榨 (<CJK Ideograph>)
          16061 => 16#548B#,   --  咋 (<CJK Ideograph>)
          16062 => 16#4E4D#,   --  乍 (<CJK Ideograph>)
          16063 => 16#70B8#,   --  炸 (<CJK Ideograph>)
          16064 => 16#8BC8#,   --  诈 (<CJK Ideograph>)
          16065 => 16#6458#,   --  摘 (<CJK Ideograph>)
          16066 => 16#658B#,   --  斋 (<CJK Ideograph>)
          16067 => 16#5B85#,   --  宅 (<CJK Ideograph>)
          16068 => 16#7A84#,   --  窄 (<CJK Ideograph>)
          16069 => 16#503A#,   --  债 (<CJK Ideograph>)
          16070 => 16#5BE8#,   --  寨 (<CJK Ideograph>)
          16071 => 16#77BB#,   --  瞻 (<CJK Ideograph>)
          16072 => 16#6BE1#,   --  毡 (<CJK Ideograph>)
          16073 => 16#8A79#,   --  詹 (<CJK Ideograph>)
          16074 => 16#7C98#,   --  粘 (<CJK Ideograph>)
          16075 => 16#6CBE#,   --  沾 (<CJK Ideograph>)
          16076 => 16#76CF#,   --  盏 (<CJK Ideograph>)
          16077 => 16#65A9#,   --  斩 (<CJK Ideograph>)
          16078 => 16#8F97#,   --  辗 (<CJK Ideograph>)
          16079 => 16#5D2D#,   --  崭 (<CJK Ideograph>)
          16080 => 16#5C55#,   --  展 (<CJK Ideograph>)
          16081 => 16#8638#,   --  蘸 (<CJK Ideograph>)
          16082 => 16#6808#,   --  栈 (<CJK Ideograph>)
          16083 => 16#5360#,   --  占 (<CJK Ideograph>)
          16084 => 16#6218#,   --  战 (<CJK Ideograph>)
          16085 => 16#7AD9#,   --  站 (<CJK Ideograph>)
          16086 => 16#6E5B#,   --  湛 (<CJK Ideograph>)
          16087 => 16#7EFD#,   --  绽 (<CJK Ideograph>)
          16088 => 16#6A1F#,   --  樟 (<CJK Ideograph>)
          16089 => 16#7AE0#,   --  章 (<CJK Ideograph>)
          16090 => 16#5F70#,   --  彰 (<CJK Ideograph>)
          16091 => 16#6F33#,   --  漳 (<CJK Ideograph>)
          16092 => 16#5F20#,   --  张 (<CJK Ideograph>)
          16093 => 16#638C#,   --  掌 (<CJK Ideograph>)
          16094 => 16#6DA8#,   --  涨 (<CJK Ideograph>)
          16095 => 16#6756#,   --  杖 (<CJK Ideograph>)
          16096 => 16#4E08#,   --  丈 (<CJK Ideograph>)
          16097 => 16#5E10#,   --  帐 (<CJK Ideograph>)
          16098 => 16#8D26#,   --  账 (<CJK Ideograph>)
          16099 => 16#4ED7#,   --  仗 (<CJK Ideograph>)
          16100 => 16#80C0#,   --  胀 (<CJK Ideograph>)
          16101 => 16#7634#,   --  瘴 (<CJK Ideograph>)
          16102 => 16#969C#,   --  障 (<CJK Ideograph>)
          16103 => 16#62DB#,   --  招 (<CJK Ideograph>)
          16104 => 16#662D#,   --  昭 (<CJK Ideograph>)
          16105 => 16#627E#,   --  找 (<CJK Ideograph>)
          16106 => 16#6CBC#,   --  沼 (<CJK Ideograph>)
          16107 => 16#8D75#,   --  赵 (<CJK Ideograph>)
          16108 => 16#7167#,   --  照 (<CJK Ideograph>)
          16109 => 16#7F69#,   --  罩 (<CJK Ideograph>)
          16110 => 16#5146#,   --  兆 (<CJK Ideograph>)
          16111 => 16#8087#,   --  肇 (<CJK Ideograph>)
          16112 => 16#53EC#,   --  召 (<CJK Ideograph>)
          16113 => 16#906E#,   --  遮 (<CJK Ideograph>)
          16114 => 16#6298#,   --  折 (<CJK Ideograph>)
          16115 => 16#54F2#,   --  哲 (<CJK Ideograph>)
          16116 => 16#86F0#,   --  蛰 (<CJK Ideograph>)
          16117 => 16#8F99#,   --  辙 (<CJK Ideograph>)
          16118 => 16#8005#,   --  者 (<CJK Ideograph>)
          16119 => 16#9517#,   --  锗 (<CJK Ideograph>)
          16120 => 16#8517#,   --  蔗 (<CJK Ideograph>)
          16121 => 16#8FD9#,   --  这 (<CJK Ideograph>)
          16122 => 16#6D59#,   --  浙 (<CJK Ideograph>)
          16123 => 16#73CD#,   --  珍 (<CJK Ideograph>)
          16124 => 16#659F#,   --  斟 (<CJK Ideograph>)
          16125 => 16#771F#,   --  真 (<CJK Ideograph>)
          16126 => 16#7504#,   --  甄 (<CJK Ideograph>)
          16127 => 16#7827#,   --  砧 (<CJK Ideograph>)
          16128 => 16#81FB#,   --  臻 (<CJK Ideograph>)
          16129 => 16#8D1E#,   --  贞 (<CJK Ideograph>)
          16130 => 16#9488#,   --  针 (<CJK Ideograph>)
          16131 => 16#4FA6#,   --  侦 (<CJK Ideograph>)
          16132 => 16#6795#,   --  枕 (<CJK Ideograph>)
          16133 => 16#75B9#,   --  疹 (<CJK Ideograph>)
          16134 => 16#8BCA#,   --  诊 (<CJK Ideograph>)
          16135 => 16#9707#,   --  震 (<CJK Ideograph>)
          16136 => 16#632F#,   --  振 (<CJK Ideograph>)
          16137 => 16#9547#,   --  镇 (<CJK Ideograph>)
          16138 => 16#9635#,   --  阵 (<CJK Ideograph>)
          16139 => 16#84B8#,   --  蒸 (<CJK Ideograph>)
          16140 => 16#6323#,   --  挣 (<CJK Ideograph>)
          16141 => 16#7741#,   --  睁 (<CJK Ideograph>)
          16142 => 16#5F81#,   --  征 (<CJK Ideograph>)
          16143 => 16#72F0#,   --  狰 (<CJK Ideograph>)
          16144 => 16#4E89#,   --  争 (<CJK Ideograph>)
          16145 => 16#6014#,   --  怔 (<CJK Ideograph>)
          16146 => 16#6574#,   --  整 (<CJK Ideograph>)
          16147 => 16#62EF#,   --  拯 (<CJK Ideograph>)
          16148 => 16#6B63#,   --  正 (<CJK Ideograph>)
          16149 => 16#653F#,   --  政 (<CJK Ideograph>)
          16150 => 16#8AE4#,   --  諤 (<CJK Ideograph>)
          16151 => 16#8AE5#,   --  諥 (<CJK Ideograph>)
          16152 => 16#8AE6#,   --  諦 (<CJK Ideograph>)
          16153 => 16#8AE7#,   --  諧 (<CJK Ideograph>)
          16154 => 16#8AE8#,   --  諨 (<CJK Ideograph>)
          16155 => 16#8AE9#,   --  諩 (<CJK Ideograph>)
          16156 => 16#8AEA#,   --  諪 (<CJK Ideograph>)
          16157 => 16#8AEB#,   --  諫 (<CJK Ideograph>)
          16158 => 16#8AEC#,   --  諬 (<CJK Ideograph>)
          16159 => 16#8AED#,   --  諭 (<CJK Ideograph>)
          16160 => 16#8AEE#,   --  諮 (<CJK Ideograph>)
          16161 => 16#8AEF#,   --  諯 (<CJK Ideograph>)
          16162 => 16#8AF0#,   --  諰 (<CJK Ideograph>)
          16163 => 16#8AF1#,   --  諱 (<CJK Ideograph>)
          16164 => 16#8AF2#,   --  諲 (<CJK Ideograph>)
          16165 => 16#8AF3#,   --  諳 (<CJK Ideograph>)
          16166 => 16#8AF4#,   --  諴 (<CJK Ideograph>)
          16167 => 16#8AF5#,   --  諵 (<CJK Ideograph>)
          16168 => 16#8AF6#,   --  諶 (<CJK Ideograph>)
          16169 => 16#8AF7#,   --  諷 (<CJK Ideograph>)
          16170 => 16#8AF8#,   --  諸 (<CJK Ideograph>)
          16171 => 16#8AF9#,   --  諹 (<CJK Ideograph>)
          16172 => 16#8AFA#,   --  諺 (<CJK Ideograph>)
          16173 => 16#8AFB#,   --  諻 (<CJK Ideograph>)
          16174 => 16#8AFC#,   --  諼 (<CJK Ideograph>)
          16175 => 16#8AFD#,   --  諽 (<CJK Ideograph>)
          16176 => 16#8AFE#,   --  諾 (<CJK Ideograph>)
          16177 => 16#8AFF#,   --  諿 (<CJK Ideograph>)
          16178 => 16#8B00#,   --  謀 (<CJK Ideograph>)
          16179 => 16#8B01#,   --  謁 (<CJK Ideograph>)
          16180 => 16#8B02#,   --  謂 (<CJK Ideograph>)
          16181 => 16#8B03#,   --  謃 (<CJK Ideograph>)
          16182 => 16#8B04#,   --  謄 (<CJK Ideograph>)
          16183 => 16#8B05#,   --  謅 (<CJK Ideograph>)
          16184 => 16#8B06#,   --  謆 (<CJK Ideograph>)
          16185 => 16#8B08#,   --  謈 (<CJK Ideograph>)
          16186 => 16#8B09#,   --  謉 (<CJK Ideograph>)
          16187 => 16#8B0A#,   --  謊 (<CJK Ideograph>)
          16188 => 16#8B0B#,   --  謋 (<CJK Ideograph>)
          16189 => 16#8B0C#,   --  謌 (<CJK Ideograph>)
          16190 => 16#8B0D#,   --  謍 (<CJK Ideograph>)
          16191 => 16#8B0E#,   --  謎 (<CJK Ideograph>)
          16192 => 16#8B0F#,   --  謏 (<CJK Ideograph>)
          16193 => 16#8B10#,   --  謐 (<CJK Ideograph>)
          16194 => 16#8B11#,   --  謑 (<CJK Ideograph>)
          16195 => 16#8B12#,   --  謒 (<CJK Ideograph>)
          16196 => 16#8B13#,   --  謓 (<CJK Ideograph>)
          16197 => 16#8B14#,   --  謔 (<CJK Ideograph>)
          16198 => 16#8B15#,   --  謕 (<CJK Ideograph>)
          16199 => 16#8B16#,   --  謖 (<CJK Ideograph>)
          16200 => 16#8B17#,   --  謗 (<CJK Ideograph>)
          16201 => 16#8B18#,   --  謘 (<CJK Ideograph>)
          16202 => 16#8B19#,   --  謙 (<CJK Ideograph>)
          16203 => 16#8B1A#,   --  謚 (<CJK Ideograph>)
          16204 => 16#8B1B#,   --  講 (<CJK Ideograph>)
          16205 => 16#8B1C#,   --  謜 (<CJK Ideograph>)
          16206 => 16#8B1D#,   --  謝 (<CJK Ideograph>)
          16207 => 16#8B1E#,   --  謞 (<CJK Ideograph>)
          16208 => 16#8B1F#,   --  謟 (<CJK Ideograph>)
          16209 => 16#8B20#,   --  謠 (<CJK Ideograph>)
          16210 => 16#8B21#,   --  謡 (<CJK Ideograph>)
          16211 => 16#8B22#,   --  謢 (<CJK Ideograph>)
          16212 => 16#8B23#,   --  謣 (<CJK Ideograph>)
          16213 => 16#8B24#,   --  謤 (<CJK Ideograph>)
          16214 => 16#8B25#,   --  謥 (<CJK Ideograph>)
          16215 => 16#8B27#,   --  謧 (<CJK Ideograph>)
          16216 => 16#8B28#,   --  謨 (<CJK Ideograph>)
          16217 => 16#8B29#,   --  謩 (<CJK Ideograph>)
          16218 => 16#8B2A#,   --  謪 (<CJK Ideograph>)
          16219 => 16#8B2B#,   --  謫 (<CJK Ideograph>)
          16220 => 16#8B2C#,   --  謬 (<CJK Ideograph>)
          16221 => 16#8B2D#,   --  謭 (<CJK Ideograph>)
          16222 => 16#8B2E#,   --  謮 (<CJK Ideograph>)
          16223 => 16#8B2F#,   --  謯 (<CJK Ideograph>)
          16224 => 16#8B30#,   --  謰 (<CJK Ideograph>)
          16225 => 16#8B31#,   --  謱 (<CJK Ideograph>)
          16226 => 16#8B32#,   --  謲 (<CJK Ideograph>)
          16227 => 16#8B33#,   --  謳 (<CJK Ideograph>)
          16228 => 16#8B34#,   --  謴 (<CJK Ideograph>)
          16229 => 16#8B35#,   --  謵 (<CJK Ideograph>)
          16230 => 16#8B36#,   --  謶 (<CJK Ideograph>)
          16231 => 16#8B37#,   --  謷 (<CJK Ideograph>)
          16232 => 16#8B38#,   --  謸 (<CJK Ideograph>)
          16233 => 16#8B39#,   --  謹 (<CJK Ideograph>)
          16234 => 16#8B3A#,   --  謺 (<CJK Ideograph>)
          16235 => 16#8B3B#,   --  謻 (<CJK Ideograph>)
          16236 => 16#8B3C#,   --  謼 (<CJK Ideograph>)
          16237 => 16#8B3D#,   --  謽 (<CJK Ideograph>)
          16238 => 16#8B3E#,   --  謾 (<CJK Ideograph>)
          16239 => 16#8B3F#,   --  謿 (<CJK Ideograph>)
          16240 => 16#8B40#,   --  譀 (<CJK Ideograph>)
          16241 => 16#8B41#,   --  譁 (<CJK Ideograph>)
          16242 => 16#8B42#,   --  譂 (<CJK Ideograph>)
          16243 => 16#8B43#,   --  譃 (<CJK Ideograph>)
          16244 => 16#8B44#,   --  譄 (<CJK Ideograph>)
          16245 => 16#8B45#,   --  譅 (<CJK Ideograph>)
          16246 => 16#5E27#,   --  帧 (<CJK Ideograph>)
          16247 => 16#75C7#,   --  症 (<CJK Ideograph>)
          16248 => 16#90D1#,   --  郑 (<CJK Ideograph>)
          16249 => 16#8BC1#,   --  证 (<CJK Ideograph>)
          16250 => 16#829D#,   --  芝 (<CJK Ideograph>)
          16251 => 16#679D#,   --  枝 (<CJK Ideograph>)
          16252 => 16#652F#,   --  支 (<CJK Ideograph>)
          16253 => 16#5431#,   --  吱 (<CJK Ideograph>)
          16254 => 16#8718#,   --  蜘 (<CJK Ideograph>)
          16255 => 16#77E5#,   --  知 (<CJK Ideograph>)
          16256 => 16#80A2#,   --  肢 (<CJK Ideograph>)
          16257 => 16#8102#,   --  脂 (<CJK Ideograph>)
          16258 => 16#6C41#,   --  汁 (<CJK Ideograph>)
          16259 => 16#4E4B#,   --  之 (<CJK Ideograph>)
          16260 => 16#7EC7#,   --  织 (<CJK Ideograph>)
          16261 => 16#804C#,   --  职 (<CJK Ideograph>)
          16262 => 16#76F4#,   --  直 (<CJK Ideograph>)
          16263 => 16#690D#,   --  植 (<CJK Ideograph>)
          16264 => 16#6B96#,   --  殖 (<CJK Ideograph>)
          16265 => 16#6267#,   --  执 (<CJK Ideograph>)
          16266 => 16#503C#,   --  值 (<CJK Ideograph>)
          16267 => 16#4F84#,   --  侄 (<CJK Ideograph>)
          16268 => 16#5740#,   --  址 (<CJK Ideograph>)
          16269 => 16#6307#,   --  指 (<CJK Ideograph>)
          16270 => 16#6B62#,   --  止 (<CJK Ideograph>)
          16271 => 16#8DBE#,   --  趾 (<CJK Ideograph>)
          16272 => 16#53EA#,   --  只 (<CJK Ideograph>)
          16273 => 16#65E8#,   --  旨 (<CJK Ideograph>)
          16274 => 16#7EB8#,   --  纸 (<CJK Ideograph>)
          16275 => 16#5FD7#,   --  志 (<CJK Ideograph>)
          16276 => 16#631A#,   --  挚 (<CJK Ideograph>)
          16277 => 16#63B7#,   --  掷 (<CJK Ideograph>)
          16278 => 16#81F3#,   --  至 (<CJK Ideograph>)
          16279 => 16#81F4#,   --  致 (<CJK Ideograph>)
          16280 => 16#7F6E#,   --  置 (<CJK Ideograph>)
          16281 => 16#5E1C#,   --  帜 (<CJK Ideograph>)
          16282 => 16#5CD9#,   --  峙 (<CJK Ideograph>)
          16283 => 16#5236#,   --  制 (<CJK Ideograph>)
          16284 => 16#667A#,   --  智 (<CJK Ideograph>)
          16285 => 16#79E9#,   --  秩 (<CJK Ideograph>)
          16286 => 16#7A1A#,   --  稚 (<CJK Ideograph>)
          16287 => 16#8D28#,   --  质 (<CJK Ideograph>)
          16288 => 16#7099#,   --  炙 (<CJK Ideograph>)
          16289 => 16#75D4#,   --  痔 (<CJK Ideograph>)
          16290 => 16#6EDE#,   --  滞 (<CJK Ideograph>)
          16291 => 16#6CBB#,   --  治 (<CJK Ideograph>)
          16292 => 16#7A92#,   --  窒 (<CJK Ideograph>)
          16293 => 16#4E2D#,   --  中 (<CJK Ideograph>)
          16294 => 16#76C5#,   --  盅 (<CJK Ideograph>)
          16295 => 16#5FE0#,   --  忠 (<CJK Ideograph>)
          16296 => 16#949F#,   --  钟 (<CJK Ideograph>)
          16297 => 16#8877#,   --  衷 (<CJK Ideograph>)
          16298 => 16#7EC8#,   --  终 (<CJK Ideograph>)
          16299 => 16#79CD#,   --  种 (<CJK Ideograph>)
          16300 => 16#80BF#,   --  肿 (<CJK Ideograph>)
          16301 => 16#91CD#,   --  重 (<CJK Ideograph>)
          16302 => 16#4EF2#,   --  仲 (<CJK Ideograph>)
          16303 => 16#4F17#,   --  众 (<CJK Ideograph>)
          16304 => 16#821F#,   --  舟 (<CJK Ideograph>)
          16305 => 16#5468#,   --  周 (<CJK Ideograph>)
          16306 => 16#5DDE#,   --  州 (<CJK Ideograph>)
          16307 => 16#6D32#,   --  洲 (<CJK Ideograph>)
          16308 => 16#8BCC#,   --  诌 (<CJK Ideograph>)
          16309 => 16#7CA5#,   --  粥 (<CJK Ideograph>)
          16310 => 16#8F74#,   --  轴 (<CJK Ideograph>)
          16311 => 16#8098#,   --  肘 (<CJK Ideograph>)
          16312 => 16#5E1A#,   --  帚 (<CJK Ideograph>)
          16313 => 16#5492#,   --  咒 (<CJK Ideograph>)
          16314 => 16#76B1#,   --  皱 (<CJK Ideograph>)
          16315 => 16#5B99#,   --  宙 (<CJK Ideograph>)
          16316 => 16#663C#,   --  昼 (<CJK Ideograph>)
          16317 => 16#9AA4#,   --  骤 (<CJK Ideograph>)
          16318 => 16#73E0#,   --  珠 (<CJK Ideograph>)
          16319 => 16#682A#,   --  株 (<CJK Ideograph>)
          16320 => 16#86DB#,   --  蛛 (<CJK Ideograph>)
          16321 => 16#6731#,   --  朱 (<CJK Ideograph>)
          16322 => 16#732A#,   --  猪 (<CJK Ideograph>)
          16323 => 16#8BF8#,   --  诸 (<CJK Ideograph>)
          16324 => 16#8BDB#,   --  诛 (<CJK Ideograph>)
          16325 => 16#9010#,   --  逐 (<CJK Ideograph>)
          16326 => 16#7AF9#,   --  竹 (<CJK Ideograph>)
          16327 => 16#70DB#,   --  烛 (<CJK Ideograph>)
          16328 => 16#716E#,   --  煮 (<CJK Ideograph>)
          16329 => 16#62C4#,   --  拄 (<CJK Ideograph>)
          16330 => 16#77A9#,   --  瞩 (<CJK Ideograph>)
          16331 => 16#5631#,   --  嘱 (<CJK Ideograph>)
          16332 => 16#4E3B#,   --  主 (<CJK Ideograph>)
          16333 => 16#8457#,   --  著 (<CJK Ideograph>)
          16334 => 16#67F1#,   --  柱 (<CJK Ideograph>)
          16335 => 16#52A9#,   --  助 (<CJK Ideograph>)
          16336 => 16#86C0#,   --  蛀 (<CJK Ideograph>)
          16337 => 16#8D2E#,   --  贮 (<CJK Ideograph>)
          16338 => 16#94F8#,   --  铸 (<CJK Ideograph>)
          16339 => 16#7B51#,   --  筑 (<CJK Ideograph>)
          16340 => 16#8B46#,   --  譆 (<CJK Ideograph>)
          16341 => 16#8B47#,   --  譇 (<CJK Ideograph>)
          16342 => 16#8B48#,   --  譈 (<CJK Ideograph>)
          16343 => 16#8B49#,   --  證 (<CJK Ideograph>)
          16344 => 16#8B4A#,   --  譊 (<CJK Ideograph>)
          16345 => 16#8B4B#,   --  譋 (<CJK Ideograph>)
          16346 => 16#8B4C#,   --  譌 (<CJK Ideograph>)
          16347 => 16#8B4D#,   --  譍 (<CJK Ideograph>)
          16348 => 16#8B4E#,   --  譎 (<CJK Ideograph>)
          16349 => 16#8B4F#,   --  譏 (<CJK Ideograph>)
          16350 => 16#8B50#,   --  譐 (<CJK Ideograph>)
          16351 => 16#8B51#,   --  譑 (<CJK Ideograph>)
          16352 => 16#8B52#,   --  譒 (<CJK Ideograph>)
          16353 => 16#8B53#,   --  譓 (<CJK Ideograph>)
          16354 => 16#8B54#,   --  譔 (<CJK Ideograph>)
          16355 => 16#8B55#,   --  譕 (<CJK Ideograph>)
          16356 => 16#8B56#,   --  譖 (<CJK Ideograph>)
          16357 => 16#8B57#,   --  譗 (<CJK Ideograph>)
          16358 => 16#8B58#,   --  識 (<CJK Ideograph>)
          16359 => 16#8B59#,   --  譙 (<CJK Ideograph>)
          16360 => 16#8B5A#,   --  譚 (<CJK Ideograph>)
          16361 => 16#8B5B#,   --  譛 (<CJK Ideograph>)
          16362 => 16#8B5C#,   --  譜 (<CJK Ideograph>)
          16363 => 16#8B5D#,   --  譝 (<CJK Ideograph>)
          16364 => 16#8B5E#,   --  譞 (<CJK Ideograph>)
          16365 => 16#8B5F#,   --  譟 (<CJK Ideograph>)
          16366 => 16#8B60#,   --  譠 (<CJK Ideograph>)
          16367 => 16#8B61#,   --  譡 (<CJK Ideograph>)
          16368 => 16#8B62#,   --  譢 (<CJK Ideograph>)
          16369 => 16#8B63#,   --  譣 (<CJK Ideograph>)
          16370 => 16#8B64#,   --  譤 (<CJK Ideograph>)
          16371 => 16#8B65#,   --  譥 (<CJK Ideograph>)
          16372 => 16#8B67#,   --  譧 (<CJK Ideograph>)
          16373 => 16#8B68#,   --  譨 (<CJK Ideograph>)
          16374 => 16#8B69#,   --  譩 (<CJK Ideograph>)
          16375 => 16#8B6A#,   --  譪 (<CJK Ideograph>)
          16376 => 16#8B6B#,   --  譫 (<CJK Ideograph>)
          16377 => 16#8B6D#,   --  譭 (<CJK Ideograph>)
          16378 => 16#8B6E#,   --  譮 (<CJK Ideograph>)
          16379 => 16#8B6F#,   --  譯 (<CJK Ideograph>)
          16380 => 16#8B70#,   --  議 (<CJK Ideograph>)
          16381 => 16#8B71#,   --  譱 (<CJK Ideograph>)
          16382 => 16#8B72#,   --  譲 (<CJK Ideograph>)
          16383 => 16#8B73#,   --  譳 (<CJK Ideograph>)
          16384 => 16#8B74#,   --  譴 (<CJK Ideograph>)
          16385 => 16#8B75#,   --  譵 (<CJK Ideograph>)
          16386 => 16#8B76#,   --  譶 (<CJK Ideograph>)
          16387 => 16#8B77#,   --  護 (<CJK Ideograph>)
          16388 => 16#8B78#,   --  譸 (<CJK Ideograph>)
          16389 => 16#8B79#,   --  譹 (<CJK Ideograph>)
          16390 => 16#8B7A#,   --  譺 (<CJK Ideograph>)
          16391 => 16#8B7B#,   --  譻 (<CJK Ideograph>)
          16392 => 16#8B7C#,   --  譼 (<CJK Ideograph>)
          16393 => 16#8B7D#,   --  譽 (<CJK Ideograph>)
          16394 => 16#8B7E#,   --  譾 (<CJK Ideograph>)
          16395 => 16#8B7F#,   --  譿 (<CJK Ideograph>)
          16396 => 16#8B80#,   --  讀 (<CJK Ideograph>)
          16397 => 16#8B81#,   --  讁 (<CJK Ideograph>)
          16398 => 16#8B82#,   --  讂 (<CJK Ideograph>)
          16399 => 16#8B83#,   --  讃 (<CJK Ideograph>)
          16400 => 16#8B84#,   --  讄 (<CJK Ideograph>)
          16401 => 16#8B85#,   --  讅 (<CJK Ideograph>)
          16402 => 16#8B86#,   --  讆 (<CJK Ideograph>)
          16403 => 16#8B87#,   --  讇 (<CJK Ideograph>)
          16404 => 16#8B88#,   --  讈 (<CJK Ideograph>)
          16405 => 16#8B89#,   --  讉 (<CJK Ideograph>)
          16406 => 16#8B8A#,   --  變 (<CJK Ideograph>)
          16407 => 16#8B8B#,   --  讋 (<CJK Ideograph>)
          16408 => 16#8B8C#,   --  讌 (<CJK Ideograph>)
          16409 => 16#8B8D#,   --  讍 (<CJK Ideograph>)
          16410 => 16#8B8E#,   --  讎 (<CJK Ideograph>)
          16411 => 16#8B8F#,   --  讏 (<CJK Ideograph>)
          16412 => 16#8B90#,   --  讐 (<CJK Ideograph>)
          16413 => 16#8B91#,   --  讑 (<CJK Ideograph>)
          16414 => 16#8B92#,   --  讒 (<CJK Ideograph>)
          16415 => 16#8B93#,   --  讓 (<CJK Ideograph>)
          16416 => 16#8B94#,   --  讔 (<CJK Ideograph>)
          16417 => 16#8B95#,   --  讕 (<CJK Ideograph>)
          16418 => 16#8B96#,   --  讖 (<CJK Ideograph>)
          16419 => 16#8B97#,   --  讗 (<CJK Ideograph>)
          16420 => 16#8B98#,   --  讘 (<CJK Ideograph>)
          16421 => 16#8B99#,   --  讙 (<CJK Ideograph>)
          16422 => 16#8B9A#,   --  讚 (<CJK Ideograph>)
          16423 => 16#8B9B#,   --  讛 (<CJK Ideograph>)
          16424 => 16#8B9C#,   --  讜 (<CJK Ideograph>)
          16425 => 16#8B9D#,   --  讝 (<CJK Ideograph>)
          16426 => 16#8B9E#,   --  讞 (<CJK Ideograph>)
          16427 => 16#8B9F#,   --  讟 (<CJK Ideograph>)
          16428 => 16#8BAC#,   --  讬 (<CJK Ideograph>)
          16429 => 16#8BB1#,   --  讱 (<CJK Ideograph>)
          16430 => 16#8BBB#,   --  讻 (<CJK Ideograph>)
          16431 => 16#8BC7#,   --  诇 (<CJK Ideograph>)
          16432 => 16#8BD0#,   --  诐 (<CJK Ideograph>)
          16433 => 16#8BEA#,   --  诪 (<CJK Ideograph>)
          16434 => 16#8C09#,   --  谉 (<CJK Ideograph>)
          16435 => 16#8C1E#,   --  谞 (<CJK Ideograph>)
          16436 => 16#4F4F#,   --  住 (<CJK Ideograph>)
          16437 => 16#6CE8#,   --  注 (<CJK Ideograph>)
          16438 => 16#795D#,   --  祝 (<CJK Ideograph>)
          16439 => 16#9A7B#,   --  驻 (<CJK Ideograph>)
          16440 => 16#6293#,   --  抓 (<CJK Ideograph>)
          16441 => 16#722A#,   --  爪 (<CJK Ideograph>)
          16442 => 16#62FD#,   --  拽 (<CJK Ideograph>)
          16443 => 16#4E13#,   --  专 (<CJK Ideograph>)
          16444 => 16#7816#,   --  砖 (<CJK Ideograph>)
          16445 => 16#8F6C#,   --  转 (<CJK Ideograph>)
          16446 => 16#64B0#,   --  撰 (<CJK Ideograph>)
          16447 => 16#8D5A#,   --  赚 (<CJK Ideograph>)
          16448 => 16#7BC6#,   --  篆 (<CJK Ideograph>)
          16449 => 16#6869#,   --  桩 (<CJK Ideograph>)
          16450 => 16#5E84#,   --  庄 (<CJK Ideograph>)
          16451 => 16#88C5#,   --  装 (<CJK Ideograph>)
          16452 => 16#5986#,   --  妆 (<CJK Ideograph>)
          16453 => 16#649E#,   --  撞 (<CJK Ideograph>)
          16454 => 16#58EE#,   --  壮 (<CJK Ideograph>)
          16455 => 16#72B6#,   --  状 (<CJK Ideograph>)
          16456 => 16#690E#,   --  椎 (<CJK Ideograph>)
          16457 => 16#9525#,   --  锥 (<CJK Ideograph>)
          16458 => 16#8FFD#,   --  追 (<CJK Ideograph>)
          16459 => 16#8D58#,   --  赘 (<CJK Ideograph>)
          16460 => 16#5760#,   --  坠 (<CJK Ideograph>)
          16461 => 16#7F00#,   --  缀 (<CJK Ideograph>)
          16462 => 16#8C06#,   --  谆 (<CJK Ideograph>)
          16463 => 16#51C6#,   --  准 (<CJK Ideograph>)
          16464 => 16#6349#,   --  捉 (<CJK Ideograph>)
          16465 => 16#62D9#,   --  拙 (<CJK Ideograph>)
          16466 => 16#5353#,   --  卓 (<CJK Ideograph>)
          16467 => 16#684C#,   --  桌 (<CJK Ideograph>)
          16468 => 16#7422#,   --  琢 (<CJK Ideograph>)
          16469 => 16#8301#,   --  茁 (<CJK Ideograph>)
          16470 => 16#914C#,   --  酌 (<CJK Ideograph>)
          16471 => 16#5544#,   --  啄 (<CJK Ideograph>)
          16472 => 16#7740#,   --  着 (<CJK Ideograph>)
          16473 => 16#707C#,   --  灼 (<CJK Ideograph>)
          16474 => 16#6D4A#,   --  浊 (<CJK Ideograph>)
          16475 => 16#5179#,   --  兹 (<CJK Ideograph>)
          16476 => 16#54A8#,   --  咨 (<CJK Ideograph>)
          16477 => 16#8D44#,   --  资 (<CJK Ideograph>)
          16478 => 16#59FF#,   --  姿 (<CJK Ideograph>)
          16479 => 16#6ECB#,   --  滋 (<CJK Ideograph>)
          16480 => 16#6DC4#,   --  淄 (<CJK Ideograph>)
          16481 => 16#5B5C#,   --  孜 (<CJK Ideograph>)
          16482 => 16#7D2B#,   --  紫 (<CJK Ideograph>)
          16483 => 16#4ED4#,   --  仔 (<CJK Ideograph>)
          16484 => 16#7C7D#,   --  籽 (<CJK Ideograph>)
          16485 => 16#6ED3#,   --  滓 (<CJK Ideograph>)
          16486 => 16#5B50#,   --  子 (<CJK Ideograph>)
          16487 => 16#81EA#,   --  自 (<CJK Ideograph>)
          16488 => 16#6E0D#,   --  渍 (<CJK Ideograph>)
          16489 => 16#5B57#,   --  字 (<CJK Ideograph>)
          16490 => 16#9B03#,   --  鬃 (<CJK Ideograph>)
          16491 => 16#68D5#,   --  棕 (<CJK Ideograph>)
          16492 => 16#8E2A#,   --  踪 (<CJK Ideograph>)
          16493 => 16#5B97#,   --  宗 (<CJK Ideograph>)
          16494 => 16#7EFC#,   --  综 (<CJK Ideograph>)
          16495 => 16#603B#,   --  总 (<CJK Ideograph>)
          16496 => 16#7EB5#,   --  纵 (<CJK Ideograph>)
          16497 => 16#90B9#,   --  邹 (<CJK Ideograph>)
          16498 => 16#8D70#,   --  走 (<CJK Ideograph>)
          16499 => 16#594F#,   --  奏 (<CJK Ideograph>)
          16500 => 16#63CD#,   --  揍 (<CJK Ideograph>)
          16501 => 16#79DF#,   --  租 (<CJK Ideograph>)
          16502 => 16#8DB3#,   --  足 (<CJK Ideograph>)
          16503 => 16#5352#,   --  卒 (<CJK Ideograph>)
          16504 => 16#65CF#,   --  族 (<CJK Ideograph>)
          16505 => 16#7956#,   --  祖 (<CJK Ideograph>)
          16506 => 16#8BC5#,   --  诅 (<CJK Ideograph>)
          16507 => 16#963B#,   --  阻 (<CJK Ideograph>)
          16508 => 16#7EC4#,   --  组 (<CJK Ideograph>)
          16509 => 16#94BB#,   --  钻 (<CJK Ideograph>)
          16510 => 16#7E82#,   --  纂 (<CJK Ideograph>)
          16511 => 16#5634#,   --  嘴 (<CJK Ideograph>)
          16512 => 16#9189#,   --  醉 (<CJK Ideograph>)
          16513 => 16#6700#,   --  最 (<CJK Ideograph>)
          16514 => 16#7F6A#,   --  罪 (<CJK Ideograph>)
          16515 => 16#5C0A#,   --  尊 (<CJK Ideograph>)
          16516 => 16#9075#,   --  遵 (<CJK Ideograph>)
          16517 => 16#6628#,   --  昨 (<CJK Ideograph>)
          16518 => 16#5DE6#,   --  左 (<CJK Ideograph>)
          16519 => 16#4F50#,   --  佐 (<CJK Ideograph>)
          16520 => 16#67DE#,   --  柞 (<CJK Ideograph>)
          16521 => 16#505A#,   --  做 (<CJK Ideograph>)
          16522 => 16#4F5C#,   --  作 (<CJK Ideograph>)
          16523 => 16#5750#,   --  坐 (<CJK Ideograph>)
          16524 => 16#5EA7#,   --  座 (<CJK Ideograph>)
          16525 => 16#E810#,   --   (<Private Use>)
          16526 => 16#E811#,   --   (<Private Use>)
          16527 => 16#E812#,   --   (<Private Use>)
          16528 => 16#E813#,   --   (<Private Use>)
          16529 => 16#E814#,   --   (<Private Use>)
          16530 => 16#8C38#,   --  谸 (<CJK Ideograph>)
          16531 => 16#8C39#,   --  谹 (<CJK Ideograph>)
          16532 => 16#8C3A#,   --  谺 (<CJK Ideograph>)
          16533 => 16#8C3B#,   --  谻 (<CJK Ideograph>)
          16534 => 16#8C3C#,   --  谼 (<CJK Ideograph>)
          16535 => 16#8C3D#,   --  谽 (<CJK Ideograph>)
          16536 => 16#8C3E#,   --  谾 (<CJK Ideograph>)
          16537 => 16#8C3F#,   --  谿 (<CJK Ideograph>)
          16538 => 16#8C40#,   --  豀 (<CJK Ideograph>)
          16539 => 16#8C42#,   --  豂 (<CJK Ideograph>)
          16540 => 16#8C43#,   --  豃 (<CJK Ideograph>)
          16541 => 16#8C44#,   --  豄 (<CJK Ideograph>)
          16542 => 16#8C45#,   --  豅 (<CJK Ideograph>)
          16543 => 16#8C48#,   --  豈 (<CJK Ideograph>)
          16544 => 16#8C4A#,   --  豊 (<CJK Ideograph>)
          16545 => 16#8C4B#,   --  豋 (<CJK Ideograph>)
          16546 => 16#8C4D#,   --  豍 (<CJK Ideograph>)
          16547 => 16#8C4E#,   --  豎 (<CJK Ideograph>)
          16548 => 16#8C4F#,   --  豏 (<CJK Ideograph>)
          16549 => 16#8C50#,   --  豐 (<CJK Ideograph>)
          16550 => 16#8C51#,   --  豑 (<CJK Ideograph>)
          16551 => 16#8C52#,   --  豒 (<CJK Ideograph>)
          16552 => 16#8C53#,   --  豓 (<CJK Ideograph>)
          16553 => 16#8C54#,   --  豔 (<CJK Ideograph>)
          16554 => 16#8C56#,   --  豖 (<CJK Ideograph>)
          16555 => 16#8C57#,   --  豗 (<CJK Ideograph>)
          16556 => 16#8C58#,   --  豘 (<CJK Ideograph>)
          16557 => 16#8C59#,   --  豙 (<CJK Ideograph>)
          16558 => 16#8C5B#,   --  豛 (<CJK Ideograph>)
          16559 => 16#8C5C#,   --  豜 (<CJK Ideograph>)
          16560 => 16#8C5D#,   --  豝 (<CJK Ideograph>)
          16561 => 16#8C5E#,   --  豞 (<CJK Ideograph>)
          16562 => 16#8C5F#,   --  豟 (<CJK Ideograph>)
          16563 => 16#8C60#,   --  豠 (<CJK Ideograph>)
          16564 => 16#8C63#,   --  豣 (<CJK Ideograph>)
          16565 => 16#8C64#,   --  豤 (<CJK Ideograph>)
          16566 => 16#8C65#,   --  豥 (<CJK Ideograph>)
          16567 => 16#8C66#,   --  豦 (<CJK Ideograph>)
          16568 => 16#8C67#,   --  豧 (<CJK Ideograph>)
          16569 => 16#8C68#,   --  豨 (<CJK Ideograph>)
          16570 => 16#8C69#,   --  豩 (<CJK Ideograph>)
          16571 => 16#8C6C#,   --  豬 (<CJK Ideograph>)
          16572 => 16#8C6D#,   --  豭 (<CJK Ideograph>)
          16573 => 16#8C6E#,   --  豮 (<CJK Ideograph>)
          16574 => 16#8C6F#,   --  豯 (<CJK Ideograph>)
          16575 => 16#8C70#,   --  豰 (<CJK Ideograph>)
          16576 => 16#8C71#,   --  豱 (<CJK Ideograph>)
          16577 => 16#8C72#,   --  豲 (<CJK Ideograph>)
          16578 => 16#8C74#,   --  豴 (<CJK Ideograph>)
          16579 => 16#8C75#,   --  豵 (<CJK Ideograph>)
          16580 => 16#8C76#,   --  豶 (<CJK Ideograph>)
          16581 => 16#8C77#,   --  豷 (<CJK Ideograph>)
          16582 => 16#8C7B#,   --  豻 (<CJK Ideograph>)
          16583 => 16#8C7C#,   --  豼 (<CJK Ideograph>)
          16584 => 16#8C7D#,   --  豽 (<CJK Ideograph>)
          16585 => 16#8C7E#,   --  豾 (<CJK Ideograph>)
          16586 => 16#8C7F#,   --  豿 (<CJK Ideograph>)
          16587 => 16#8C80#,   --  貀 (<CJK Ideograph>)
          16588 => 16#8C81#,   --  貁 (<CJK Ideograph>)
          16589 => 16#8C83#,   --  貃 (<CJK Ideograph>)
          16590 => 16#8C84#,   --  貄 (<CJK Ideograph>)
          16591 => 16#8C86#,   --  貆 (<CJK Ideograph>)
          16592 => 16#8C87#,   --  貇 (<CJK Ideograph>)
          16593 => 16#8C88#,   --  貈 (<CJK Ideograph>)
          16594 => 16#8C8B#,   --  貋 (<CJK Ideograph>)
          16595 => 16#8C8D#,   --  貍 (<CJK Ideograph>)
          16596 => 16#8C8E#,   --  貎 (<CJK Ideograph>)
          16597 => 16#8C8F#,   --  貏 (<CJK Ideograph>)
          16598 => 16#8C90#,   --  貐 (<CJK Ideograph>)
          16599 => 16#8C91#,   --  貑 (<CJK Ideograph>)
          16600 => 16#8C92#,   --  貒 (<CJK Ideograph>)
          16601 => 16#8C93#,   --  貓 (<CJK Ideograph>)
          16602 => 16#8C95#,   --  貕 (<CJK Ideograph>)
          16603 => 16#8C96#,   --  貖 (<CJK Ideograph>)
          16604 => 16#8C97#,   --  貗 (<CJK Ideograph>)
          16605 => 16#8C99#,   --  貙 (<CJK Ideograph>)
          16606 => 16#8C9A#,   --  貚 (<CJK Ideograph>)
          16607 => 16#8C9B#,   --  貛 (<CJK Ideograph>)
          16608 => 16#8C9C#,   --  貜 (<CJK Ideograph>)
          16609 => 16#8C9D#,   --  貝 (<CJK Ideograph>)
          16610 => 16#8C9E#,   --  貞 (<CJK Ideograph>)
          16611 => 16#8C9F#,   --  貟 (<CJK Ideograph>)
          16612 => 16#8CA0#,   --  負 (<CJK Ideograph>)
          16613 => 16#8CA1#,   --  財 (<CJK Ideograph>)
          16614 => 16#8CA2#,   --  貢 (<CJK Ideograph>)
          16615 => 16#8CA3#,   --  貣 (<CJK Ideograph>)
          16616 => 16#8CA4#,   --  貤 (<CJK Ideograph>)
          16617 => 16#8CA5#,   --  貥 (<CJK Ideograph>)
          16618 => 16#8CA6#,   --  貦 (<CJK Ideograph>)
          16619 => 16#8CA7#,   --  貧 (<CJK Ideograph>)
          16620 => 16#8CA8#,   --  貨 (<CJK Ideograph>)
          16621 => 16#8CA9#,   --  販 (<CJK Ideograph>)
          16622 => 16#8CAA#,   --  貪 (<CJK Ideograph>)
          16623 => 16#8CAB#,   --  貫 (<CJK Ideograph>)
          16624 => 16#8CAC#,   --  責 (<CJK Ideograph>)
          16625 => 16#8CAD#,   --  貭 (<CJK Ideograph>)
          16626 => 16#4E8D#,   --  亍 (<CJK Ideograph>)
          16627 => 16#4E0C#,   --  丌 (<CJK Ideograph>)
          16628 => 16#5140#,   --  兀 (<CJK Ideograph>)
          16629 => 16#4E10#,   --  丐 (<CJK Ideograph>)
          16630 => 16#5EFF#,   --  廿 (<CJK Ideograph>)
          16631 => 16#5345#,   --  卅 (<CJK Ideograph>)
          16632 => 16#4E15#,   --  丕 (<CJK Ideograph>)
          16633 => 16#4E98#,   --  亘 (<CJK Ideograph>)
          16634 => 16#4E1E#,   --  丞 (<CJK Ideograph>)
          16635 => 16#9B32#,   --  鬲 (<CJK Ideograph>)
          16636 => 16#5B6C#,   --  孬 (<CJK Ideograph>)
          16637 => 16#5669#,   --  噩 (<CJK Ideograph>)
          16638 => 16#4E28#,   --  丨 (<CJK Ideograph>)
          16639 => 16#79BA#,   --  禺 (<CJK Ideograph>)
          16640 => 16#4E3F#,   --  丿 (<CJK Ideograph>)
          16641 => 16#5315#,   --  匕 (<CJK Ideograph>)
          16642 => 16#4E47#,   --  乇 (<CJK Ideograph>)
          16643 => 16#592D#,   --  夭 (<CJK Ideograph>)
          16644 => 16#723B#,   --  爻 (<CJK Ideograph>)
          16645 => 16#536E#,   --  卮 (<CJK Ideograph>)
          16646 => 16#6C10#,   --  氐 (<CJK Ideograph>)
          16647 => 16#56DF#,   --  囟 (<CJK Ideograph>)
          16648 => 16#80E4#,   --  胤 (<CJK Ideograph>)
          16649 => 16#9997#,   --  馗 (<CJK Ideograph>)
          16650 => 16#6BD3#,   --  毓 (<CJK Ideograph>)
          16651 => 16#777E#,   --  睾 (<CJK Ideograph>)
          16652 => 16#9F17#,   --  鼗 (<CJK Ideograph>)
          16653 => 16#4E36#,   --  丶 (<CJK Ideograph>)
          16654 => 16#4E9F#,   --  亟 (<CJK Ideograph>)
          16655 => 16#9F10#,   --  鼐 (<CJK Ideograph>)
          16656 => 16#4E5C#,   --  乜 (<CJK Ideograph>)
          16657 => 16#4E69#,   --  乩 (<CJK Ideograph>)
          16658 => 16#4E93#,   --  亓 (<CJK Ideograph>)
          16659 => 16#8288#,   --  芈 (<CJK Ideograph>)
          16660 => 16#5B5B#,   --  孛 (<CJK Ideograph>)
          16661 => 16#556C#,   --  啬 (<CJK Ideograph>)
          16662 => 16#560F#,   --  嘏 (<CJK Ideograph>)
          16663 => 16#4EC4#,   --  仄 (<CJK Ideograph>)
          16664 => 16#538D#,   --  厍 (<CJK Ideograph>)
          16665 => 16#539D#,   --  厝 (<CJK Ideograph>)
          16666 => 16#53A3#,   --  厣 (<CJK Ideograph>)
          16667 => 16#53A5#,   --  厥 (<CJK Ideograph>)
          16668 => 16#53AE#,   --  厮 (<CJK Ideograph>)
          16669 => 16#9765#,   --  靥 (<CJK Ideograph>)
          16670 => 16#8D5D#,   --  赝 (<CJK Ideograph>)
          16671 => 16#531A#,   --  匚 (<CJK Ideograph>)
          16672 => 16#53F5#,   --  叵 (<CJK Ideograph>)
          16673 => 16#5326#,   --  匦 (<CJK Ideograph>)
          16674 => 16#532E#,   --  匮 (<CJK Ideograph>)
          16675 => 16#533E#,   --  匾 (<CJK Ideograph>)
          16676 => 16#8D5C#,   --  赜 (<CJK Ideograph>)
          16677 => 16#5366#,   --  卦 (<CJK Ideograph>)
          16678 => 16#5363#,   --  卣 (<CJK Ideograph>)
          16679 => 16#5202#,   --  刂 (<CJK Ideograph>)
          16680 => 16#5208#,   --  刈 (<CJK Ideograph>)
          16681 => 16#520E#,   --  刎 (<CJK Ideograph>)
          16682 => 16#522D#,   --  刭 (<CJK Ideograph>)
          16683 => 16#5233#,   --  刳 (<CJK Ideograph>)
          16684 => 16#523F#,   --  刿 (<CJK Ideograph>)
          16685 => 16#5240#,   --  剀 (<CJK Ideograph>)
          16686 => 16#524C#,   --  剌 (<CJK Ideograph>)
          16687 => 16#525E#,   --  剞 (<CJK Ideograph>)
          16688 => 16#5261#,   --  剡 (<CJK Ideograph>)
          16689 => 16#525C#,   --  剜 (<CJK Ideograph>)
          16690 => 16#84AF#,   --  蒯 (<CJK Ideograph>)
          16691 => 16#527D#,   --  剽 (<CJK Ideograph>)
          16692 => 16#5282#,   --  劂 (<CJK Ideograph>)
          16693 => 16#5281#,   --  劁 (<CJK Ideograph>)
          16694 => 16#5290#,   --  劐 (<CJK Ideograph>)
          16695 => 16#5293#,   --  劓 (<CJK Ideograph>)
          16696 => 16#5182#,   --  冂 (<CJK Ideograph>)
          16697 => 16#7F54#,   --  罔 (<CJK Ideograph>)
          16698 => 16#4EBB#,   --  亻 (<CJK Ideograph>)
          16699 => 16#4EC3#,   --  仃 (<CJK Ideograph>)
          16700 => 16#4EC9#,   --  仉 (<CJK Ideograph>)
          16701 => 16#4EC2#,   --  仂 (<CJK Ideograph>)
          16702 => 16#4EE8#,   --  仨 (<CJK Ideograph>)
          16703 => 16#4EE1#,   --  仡 (<CJK Ideograph>)
          16704 => 16#4EEB#,   --  仫 (<CJK Ideograph>)
          16705 => 16#4EDE#,   --  仞 (<CJK Ideograph>)
          16706 => 16#4F1B#,   --  伛 (<CJK Ideograph>)
          16707 => 16#4EF3#,   --  仳 (<CJK Ideograph>)
          16708 => 16#4F22#,   --  伢 (<CJK Ideograph>)
          16709 => 16#4F64#,   --  佤 (<CJK Ideograph>)
          16710 => 16#4EF5#,   --  仵 (<CJK Ideograph>)
          16711 => 16#4F25#,   --  伥 (<CJK Ideograph>)
          16712 => 16#4F27#,   --  伧 (<CJK Ideograph>)
          16713 => 16#4F09#,   --  伉 (<CJK Ideograph>)
          16714 => 16#4F2B#,   --  伫 (<CJK Ideograph>)
          16715 => 16#4F5E#,   --  佞 (<CJK Ideograph>)
          16716 => 16#4F67#,   --  佧 (<CJK Ideograph>)
          16717 => 16#6538#,   --  攸 (<CJK Ideograph>)
          16718 => 16#4F5A#,   --  佚 (<CJK Ideograph>)
          16719 => 16#4F5D#,   --  佝 (<CJK Ideograph>)
          16720 => 16#8CAE#,   --  貮 (<CJK Ideograph>)
          16721 => 16#8CAF#,   --  貯 (<CJK Ideograph>)
          16722 => 16#8CB0#,   --  貰 (<CJK Ideograph>)
          16723 => 16#8CB1#,   --  貱 (<CJK Ideograph>)
          16724 => 16#8CB2#,   --  貲 (<CJK Ideograph>)
          16725 => 16#8CB3#,   --  貳 (<CJK Ideograph>)
          16726 => 16#8CB4#,   --  貴 (<CJK Ideograph>)
          16727 => 16#8CB5#,   --  貵 (<CJK Ideograph>)
          16728 => 16#8CB6#,   --  貶 (<CJK Ideograph>)
          16729 => 16#8CB7#,   --  買 (<CJK Ideograph>)
          16730 => 16#8CB8#,   --  貸 (<CJK Ideograph>)
          16731 => 16#8CB9#,   --  貹 (<CJK Ideograph>)
          16732 => 16#8CBA#,   --  貺 (<CJK Ideograph>)
          16733 => 16#8CBB#,   --  費 (<CJK Ideograph>)
          16734 => 16#8CBC#,   --  貼 (<CJK Ideograph>)
          16735 => 16#8CBD#,   --  貽 (<CJK Ideograph>)
          16736 => 16#8CBE#,   --  貾 (<CJK Ideograph>)
          16737 => 16#8CBF#,   --  貿 (<CJK Ideograph>)
          16738 => 16#8CC0#,   --  賀 (<CJK Ideograph>)
          16739 => 16#8CC1#,   --  賁 (<CJK Ideograph>)
          16740 => 16#8CC2#,   --  賂 (<CJK Ideograph>)
          16741 => 16#8CC3#,   --  賃 (<CJK Ideograph>)
          16742 => 16#8CC4#,   --  賄 (<CJK Ideograph>)
          16743 => 16#8CC5#,   --  賅 (<CJK Ideograph>)
          16744 => 16#8CC6#,   --  賆 (<CJK Ideograph>)
          16745 => 16#8CC7#,   --  資 (<CJK Ideograph>)
          16746 => 16#8CC8#,   --  賈 (<CJK Ideograph>)
          16747 => 16#8CC9#,   --  賉 (<CJK Ideograph>)
          16748 => 16#8CCA#,   --  賊 (<CJK Ideograph>)
          16749 => 16#8CCB#,   --  賋 (<CJK Ideograph>)
          16750 => 16#8CCC#,   --  賌 (<CJK Ideograph>)
          16751 => 16#8CCD#,   --  賍 (<CJK Ideograph>)
          16752 => 16#8CCE#,   --  賎 (<CJK Ideograph>)
          16753 => 16#8CCF#,   --  賏 (<CJK Ideograph>)
          16754 => 16#8CD0#,   --  賐 (<CJK Ideograph>)
          16755 => 16#8CD1#,   --  賑 (<CJK Ideograph>)
          16756 => 16#8CD2#,   --  賒 (<CJK Ideograph>)
          16757 => 16#8CD3#,   --  賓 (<CJK Ideograph>)
          16758 => 16#8CD4#,   --  賔 (<CJK Ideograph>)
          16759 => 16#8CD5#,   --  賕 (<CJK Ideograph>)
          16760 => 16#8CD6#,   --  賖 (<CJK Ideograph>)
          16761 => 16#8CD7#,   --  賗 (<CJK Ideograph>)
          16762 => 16#8CD8#,   --  賘 (<CJK Ideograph>)
          16763 => 16#8CD9#,   --  賙 (<CJK Ideograph>)
          16764 => 16#8CDA#,   --  賚 (<CJK Ideograph>)
          16765 => 16#8CDB#,   --  賛 (<CJK Ideograph>)
          16766 => 16#8CDC#,   --  賜 (<CJK Ideograph>)
          16767 => 16#8CDD#,   --  賝 (<CJK Ideograph>)
          16768 => 16#8CDE#,   --  賞 (<CJK Ideograph>)
          16769 => 16#8CDF#,   --  賟 (<CJK Ideograph>)
          16770 => 16#8CE0#,   --  賠 (<CJK Ideograph>)
          16771 => 16#8CE1#,   --  賡 (<CJK Ideograph>)
          16772 => 16#8CE2#,   --  賢 (<CJK Ideograph>)
          16773 => 16#8CE3#,   --  賣 (<CJK Ideograph>)
          16774 => 16#8CE4#,   --  賤 (<CJK Ideograph>)
          16775 => 16#8CE5#,   --  賥 (<CJK Ideograph>)
          16776 => 16#8CE6#,   --  賦 (<CJK Ideograph>)
          16777 => 16#8CE7#,   --  賧 (<CJK Ideograph>)
          16778 => 16#8CE8#,   --  賨 (<CJK Ideograph>)
          16779 => 16#8CE9#,   --  賩 (<CJK Ideograph>)
          16780 => 16#8CEA#,   --  質 (<CJK Ideograph>)
          16781 => 16#8CEB#,   --  賫 (<CJK Ideograph>)
          16782 => 16#8CEC#,   --  賬 (<CJK Ideograph>)
          16783 => 16#8CED#,   --  賭 (<CJK Ideograph>)
          16784 => 16#8CEE#,   --  賮 (<CJK Ideograph>)
          16785 => 16#8CEF#,   --  賯 (<CJK Ideograph>)
          16786 => 16#8CF0#,   --  賰 (<CJK Ideograph>)
          16787 => 16#8CF1#,   --  賱 (<CJK Ideograph>)
          16788 => 16#8CF2#,   --  賲 (<CJK Ideograph>)
          16789 => 16#8CF3#,   --  賳 (<CJK Ideograph>)
          16790 => 16#8CF4#,   --  賴 (<CJK Ideograph>)
          16791 => 16#8CF5#,   --  賵 (<CJK Ideograph>)
          16792 => 16#8CF6#,   --  賶 (<CJK Ideograph>)
          16793 => 16#8CF7#,   --  賷 (<CJK Ideograph>)
          16794 => 16#8CF8#,   --  賸 (<CJK Ideograph>)
          16795 => 16#8CF9#,   --  賹 (<CJK Ideograph>)
          16796 => 16#8CFA#,   --  賺 (<CJK Ideograph>)
          16797 => 16#8CFB#,   --  賻 (<CJK Ideograph>)
          16798 => 16#8CFC#,   --  購 (<CJK Ideograph>)
          16799 => 16#8CFD#,   --  賽 (<CJK Ideograph>)
          16800 => 16#8CFE#,   --  賾 (<CJK Ideograph>)
          16801 => 16#8CFF#,   --  賿 (<CJK Ideograph>)
          16802 => 16#8D00#,   --  贀 (<CJK Ideograph>)
          16803 => 16#8D01#,   --  贁 (<CJK Ideograph>)
          16804 => 16#8D02#,   --  贂 (<CJK Ideograph>)
          16805 => 16#8D03#,   --  贃 (<CJK Ideograph>)
          16806 => 16#8D04#,   --  贄 (<CJK Ideograph>)
          16807 => 16#8D05#,   --  贅 (<CJK Ideograph>)
          16808 => 16#8D06#,   --  贆 (<CJK Ideograph>)
          16809 => 16#8D07#,   --  贇 (<CJK Ideograph>)
          16810 => 16#8D08#,   --  贈 (<CJK Ideograph>)
          16811 => 16#8D09#,   --  贉 (<CJK Ideograph>)
          16812 => 16#8D0A#,   --  贊 (<CJK Ideograph>)
          16813 => 16#8D0B#,   --  贋 (<CJK Ideograph>)
          16814 => 16#8D0C#,   --  贌 (<CJK Ideograph>)
          16815 => 16#8D0D#,   --  贍 (<CJK Ideograph>)
          16816 => 16#4F5F#,   --  佟 (<CJK Ideograph>)
          16817 => 16#4F57#,   --  佗 (<CJK Ideograph>)
          16818 => 16#4F32#,   --  伲 (<CJK Ideograph>)
          16819 => 16#4F3D#,   --  伽 (<CJK Ideograph>)
          16820 => 16#4F76#,   --  佶 (<CJK Ideograph>)
          16821 => 16#4F74#,   --  佴 (<CJK Ideograph>)
          16822 => 16#4F91#,   --  侑 (<CJK Ideograph>)
          16823 => 16#4F89#,   --  侉 (<CJK Ideograph>)
          16824 => 16#4F83#,   --  侃 (<CJK Ideograph>)
          16825 => 16#4F8F#,   --  侏 (<CJK Ideograph>)
          16826 => 16#4F7E#,   --  佾 (<CJK Ideograph>)
          16827 => 16#4F7B#,   --  佻 (<CJK Ideograph>)
          16828 => 16#4FAA#,   --  侪 (<CJK Ideograph>)
          16829 => 16#4F7C#,   --  佼 (<CJK Ideograph>)
          16830 => 16#4FAC#,   --  侬 (<CJK Ideograph>)
          16831 => 16#4F94#,   --  侔 (<CJK Ideograph>)
          16832 => 16#4FE6#,   --  俦 (<CJK Ideograph>)
          16833 => 16#4FE8#,   --  俨 (<CJK Ideograph>)
          16834 => 16#4FEA#,   --  俪 (<CJK Ideograph>)
          16835 => 16#4FC5#,   --  俅 (<CJK Ideograph>)
          16836 => 16#4FDA#,   --  俚 (<CJK Ideograph>)
          16837 => 16#4FE3#,   --  俣 (<CJK Ideograph>)
          16838 => 16#4FDC#,   --  俜 (<CJK Ideograph>)
          16839 => 16#4FD1#,   --  俑 (<CJK Ideograph>)
          16840 => 16#4FDF#,   --  俟 (<CJK Ideograph>)
          16841 => 16#4FF8#,   --  俸 (<CJK Ideograph>)
          16842 => 16#5029#,   --  倩 (<CJK Ideograph>)
          16843 => 16#504C#,   --  偌 (<CJK Ideograph>)
          16844 => 16#4FF3#,   --  俳 (<CJK Ideograph>)
          16845 => 16#502C#,   --  倬 (<CJK Ideograph>)
          16846 => 16#500F#,   --  倏 (<CJK Ideograph>)
          16847 => 16#502E#,   --  倮 (<CJK Ideograph>)
          16848 => 16#502D#,   --  倭 (<CJK Ideograph>)
          16849 => 16#4FFE#,   --  俾 (<CJK Ideograph>)
          16850 => 16#501C#,   --  倜 (<CJK Ideograph>)
          16851 => 16#500C#,   --  倌 (<CJK Ideograph>)
          16852 => 16#5025#,   --  倥 (<CJK Ideograph>)
          16853 => 16#5028#,   --  倨 (<CJK Ideograph>)
          16854 => 16#507E#,   --  偾 (<CJK Ideograph>)
          16855 => 16#5043#,   --  偃 (<CJK Ideograph>)
          16856 => 16#5055#,   --  偕 (<CJK Ideograph>)
          16857 => 16#5048#,   --  偈 (<CJK Ideograph>)
          16858 => 16#504E#,   --  偎 (<CJK Ideograph>)
          16859 => 16#506C#,   --  偬 (<CJK Ideograph>)
          16860 => 16#507B#,   --  偻 (<CJK Ideograph>)
          16861 => 16#50A5#,   --  傥 (<CJK Ideograph>)
          16862 => 16#50A7#,   --  傧 (<CJK Ideograph>)
          16863 => 16#50A9#,   --  傩 (<CJK Ideograph>)
          16864 => 16#50BA#,   --  傺 (<CJK Ideograph>)
          16865 => 16#50D6#,   --  僖 (<CJK Ideograph>)
          16866 => 16#5106#,   --  儆 (<CJK Ideograph>)
          16867 => 16#50ED#,   --  僭 (<CJK Ideograph>)
          16868 => 16#50EC#,   --  僬 (<CJK Ideograph>)
          16869 => 16#50E6#,   --  僦 (<CJK Ideograph>)
          16870 => 16#50EE#,   --  僮 (<CJK Ideograph>)
          16871 => 16#5107#,   --  儇 (<CJK Ideograph>)
          16872 => 16#510B#,   --  儋 (<CJK Ideograph>)
          16873 => 16#4EDD#,   --  仝 (<CJK Ideograph>)
          16874 => 16#6C3D#,   --  氽 (<CJK Ideograph>)
          16875 => 16#4F58#,   --  佘 (<CJK Ideograph>)
          16876 => 16#4F65#,   --  佥 (<CJK Ideograph>)
          16877 => 16#4FCE#,   --  俎 (<CJK Ideograph>)
          16878 => 16#9FA0#,   --  龠 (<CJK Ideograph>)
          16879 => 16#6C46#,   --  汆 (<CJK Ideograph>)
          16880 => 16#7C74#,   --  籴 (<CJK Ideograph>)
          16881 => 16#516E#,   --  兮 (<CJK Ideograph>)
          16882 => 16#5DFD#,   --  巽 (<CJK Ideograph>)
          16883 => 16#9EC9#,   --  黉 (<CJK Ideograph>)
          16884 => 16#9998#,   --  馘 (<CJK Ideograph>)
          16885 => 16#5181#,   --  冁 (<CJK Ideograph>)
          16886 => 16#5914#,   --  夔 (<CJK Ideograph>)
          16887 => 16#52F9#,   --  勹 (<CJK Ideograph>)
          16888 => 16#530D#,   --  匍 (<CJK Ideograph>)
          16889 => 16#8A07#,   --  訇 (<CJK Ideograph>)
          16890 => 16#5310#,   --  匐 (<CJK Ideograph>)
          16891 => 16#51EB#,   --  凫 (<CJK Ideograph>)
          16892 => 16#5919#,   --  夙 (<CJK Ideograph>)
          16893 => 16#5155#,   --  兕 (<CJK Ideograph>)
          16894 => 16#4EA0#,   --  亠 (<CJK Ideograph>)
          16895 => 16#5156#,   --  兖 (<CJK Ideograph>)
          16896 => 16#4EB3#,   --  亳 (<CJK Ideograph>)
          16897 => 16#886E#,   --  衮 (<CJK Ideograph>)
          16898 => 16#88A4#,   --  袤 (<CJK Ideograph>)
          16899 => 16#4EB5#,   --  亵 (<CJK Ideograph>)
          16900 => 16#8114#,   --  脔 (<CJK Ideograph>)
          16901 => 16#88D2#,   --  裒 (<CJK Ideograph>)
          16902 => 16#7980#,   --  禀 (<CJK Ideograph>)
          16903 => 16#5B34#,   --  嬴 (<CJK Ideograph>)
          16904 => 16#8803#,   --  蠃 (<CJK Ideograph>)
          16905 => 16#7FB8#,   --  羸 (<CJK Ideograph>)
          16906 => 16#51AB#,   --  冫 (<CJK Ideograph>)
          16907 => 16#51B1#,   --  冱 (<CJK Ideograph>)
          16908 => 16#51BD#,   --  冽 (<CJK Ideograph>)
          16909 => 16#51BC#,   --  冼 (<CJK Ideograph>)
          16910 => 16#8D0E#,   --  贎 (<CJK Ideograph>)
          16911 => 16#8D0F#,   --  贏 (<CJK Ideograph>)
          16912 => 16#8D10#,   --  贐 (<CJK Ideograph>)
          16913 => 16#8D11#,   --  贑 (<CJK Ideograph>)
          16914 => 16#8D12#,   --  贒 (<CJK Ideograph>)
          16915 => 16#8D13#,   --  贓 (<CJK Ideograph>)
          16916 => 16#8D14#,   --  贔 (<CJK Ideograph>)
          16917 => 16#8D15#,   --  贕 (<CJK Ideograph>)
          16918 => 16#8D16#,   --  贖 (<CJK Ideograph>)
          16919 => 16#8D17#,   --  贗 (<CJK Ideograph>)
          16920 => 16#8D18#,   --  贘 (<CJK Ideograph>)
          16921 => 16#8D19#,   --  贙 (<CJK Ideograph>)
          16922 => 16#8D1A#,   --  贚 (<CJK Ideograph>)
          16923 => 16#8D1B#,   --  贛 (<CJK Ideograph>)
          16924 => 16#8D1C#,   --  贜 (<CJK Ideograph>)
          16925 => 16#8D20#,   --  贠 (<CJK Ideograph>)
          16926 => 16#8D51#,   --  赑 (<CJK Ideograph>)
          16927 => 16#8D52#,   --  赒 (<CJK Ideograph>)
          16928 => 16#8D57#,   --  赗 (<CJK Ideograph>)
          16929 => 16#8D5F#,   --  赟 (<CJK Ideograph>)
          16930 => 16#8D65#,   --  赥 (<CJK Ideograph>)
          16931 => 16#8D68#,   --  赨 (<CJK Ideograph>)
          16932 => 16#8D69#,   --  赩 (<CJK Ideograph>)
          16933 => 16#8D6A#,   --  赪 (<CJK Ideograph>)
          16934 => 16#8D6C#,   --  赬 (<CJK Ideograph>)
          16935 => 16#8D6E#,   --  赮 (<CJK Ideograph>)
          16936 => 16#8D6F#,   --  赯 (<CJK Ideograph>)
          16937 => 16#8D71#,   --  赱 (<CJK Ideograph>)
          16938 => 16#8D72#,   --  赲 (<CJK Ideograph>)
          16939 => 16#8D78#,   --  赸 (<CJK Ideograph>)
          16940 => 16#8D79#,   --  赹 (<CJK Ideograph>)
          16941 => 16#8D7A#,   --  赺 (<CJK Ideograph>)
          16942 => 16#8D7B#,   --  赻 (<CJK Ideograph>)
          16943 => 16#8D7C#,   --  赼 (<CJK Ideograph>)
          16944 => 16#8D7D#,   --  赽 (<CJK Ideograph>)
          16945 => 16#8D7E#,   --  赾 (<CJK Ideograph>)
          16946 => 16#8D7F#,   --  赿 (<CJK Ideograph>)
          16947 => 16#8D80#,   --  趀 (<CJK Ideograph>)
          16948 => 16#8D82#,   --  趂 (<CJK Ideograph>)
          16949 => 16#8D83#,   --  趃 (<CJK Ideograph>)
          16950 => 16#8D86#,   --  趆 (<CJK Ideograph>)
          16951 => 16#8D87#,   --  趇 (<CJK Ideograph>)
          16952 => 16#8D88#,   --  趈 (<CJK Ideograph>)
          16953 => 16#8D89#,   --  趉 (<CJK Ideograph>)
          16954 => 16#8D8C#,   --  趌 (<CJK Ideograph>)
          16955 => 16#8D8D#,   --  趍 (<CJK Ideograph>)
          16956 => 16#8D8E#,   --  趎 (<CJK Ideograph>)
          16957 => 16#8D8F#,   --  趏 (<CJK Ideograph>)
          16958 => 16#8D90#,   --  趐 (<CJK Ideograph>)
          16959 => 16#8D92#,   --  趒 (<CJK Ideograph>)
          16960 => 16#8D93#,   --  趓 (<CJK Ideograph>)
          16961 => 16#8D95#,   --  趕 (<CJK Ideograph>)
          16962 => 16#8D96#,   --  趖 (<CJK Ideograph>)
          16963 => 16#8D97#,   --  趗 (<CJK Ideograph>)
          16964 => 16#8D98#,   --  趘 (<CJK Ideograph>)
          16965 => 16#8D99#,   --  趙 (<CJK Ideograph>)
          16966 => 16#8D9A#,   --  趚 (<CJK Ideograph>)
          16967 => 16#8D9B#,   --  趛 (<CJK Ideograph>)
          16968 => 16#8D9C#,   --  趜 (<CJK Ideograph>)
          16969 => 16#8D9D#,   --  趝 (<CJK Ideograph>)
          16970 => 16#8D9E#,   --  趞 (<CJK Ideograph>)
          16971 => 16#8DA0#,   --  趠 (<CJK Ideograph>)
          16972 => 16#8DA1#,   --  趡 (<CJK Ideograph>)
          16973 => 16#8DA2#,   --  趢 (<CJK Ideograph>)
          16974 => 16#8DA4#,   --  趤 (<CJK Ideograph>)
          16975 => 16#8DA5#,   --  趥 (<CJK Ideograph>)
          16976 => 16#8DA6#,   --  趦 (<CJK Ideograph>)
          16977 => 16#8DA7#,   --  趧 (<CJK Ideograph>)
          16978 => 16#8DA8#,   --  趨 (<CJK Ideograph>)
          16979 => 16#8DA9#,   --  趩 (<CJK Ideograph>)
          16980 => 16#8DAA#,   --  趪 (<CJK Ideograph>)
          16981 => 16#8DAB#,   --  趫 (<CJK Ideograph>)
          16982 => 16#8DAC#,   --  趬 (<CJK Ideograph>)
          16983 => 16#8DAD#,   --  趭 (<CJK Ideograph>)
          16984 => 16#8DAE#,   --  趮 (<CJK Ideograph>)
          16985 => 16#8DAF#,   --  趯 (<CJK Ideograph>)
          16986 => 16#8DB0#,   --  趰 (<CJK Ideograph>)
          16987 => 16#8DB2#,   --  趲 (<CJK Ideograph>)
          16988 => 16#8DB6#,   --  趶 (<CJK Ideograph>)
          16989 => 16#8DB7#,   --  趷 (<CJK Ideograph>)
          16990 => 16#8DB9#,   --  趹 (<CJK Ideograph>)
          16991 => 16#8DBB#,   --  趻 (<CJK Ideograph>)
          16992 => 16#8DBD#,   --  趽 (<CJK Ideograph>)
          16993 => 16#8DC0#,   --  跀 (<CJK Ideograph>)
          16994 => 16#8DC1#,   --  跁 (<CJK Ideograph>)
          16995 => 16#8DC2#,   --  跂 (<CJK Ideograph>)
          16996 => 16#8DC5#,   --  跅 (<CJK Ideograph>)
          16997 => 16#8DC7#,   --  跇 (<CJK Ideograph>)
          16998 => 16#8DC8#,   --  跈 (<CJK Ideograph>)
          16999 => 16#8DC9#,   --  跉 (<CJK Ideograph>)
          17000 => 16#8DCA#,   --  跊 (<CJK Ideograph>)
          17001 => 16#8DCD#,   --  跍 (<CJK Ideograph>)
          17002 => 16#8DD0#,   --  跐 (<CJK Ideograph>)
          17003 => 16#8DD2#,   --  跒 (<CJK Ideograph>)
          17004 => 16#8DD3#,   --  跓 (<CJK Ideograph>)
          17005 => 16#8DD4#,   --  跔 (<CJK Ideograph>)
          17006 => 16#51C7#,   --  凇 (<CJK Ideograph>)
          17007 => 16#5196#,   --  冖 (<CJK Ideograph>)
          17008 => 16#51A2#,   --  冢 (<CJK Ideograph>)
          17009 => 16#51A5#,   --  冥 (<CJK Ideograph>)
          17010 => 16#8BA0#,   --  讠 (<CJK Ideograph>)
          17011 => 16#8BA6#,   --  讦 (<CJK Ideograph>)
          17012 => 16#8BA7#,   --  讧 (<CJK Ideograph>)
          17013 => 16#8BAA#,   --  讪 (<CJK Ideograph>)
          17014 => 16#8BB4#,   --  讴 (<CJK Ideograph>)
          17015 => 16#8BB5#,   --  讵 (<CJK Ideograph>)
          17016 => 16#8BB7#,   --  讷 (<CJK Ideograph>)
          17017 => 16#8BC2#,   --  诂 (<CJK Ideograph>)
          17018 => 16#8BC3#,   --  诃 (<CJK Ideograph>)
          17019 => 16#8BCB#,   --  诋 (<CJK Ideograph>)
          17020 => 16#8BCF#,   --  诏 (<CJK Ideograph>)
          17021 => 16#8BCE#,   --  诎 (<CJK Ideograph>)
          17022 => 16#8BD2#,   --  诒 (<CJK Ideograph>)
          17023 => 16#8BD3#,   --  诓 (<CJK Ideograph>)
          17024 => 16#8BD4#,   --  诔 (<CJK Ideograph>)
          17025 => 16#8BD6#,   --  诖 (<CJK Ideograph>)
          17026 => 16#8BD8#,   --  诘 (<CJK Ideograph>)
          17027 => 16#8BD9#,   --  诙 (<CJK Ideograph>)
          17028 => 16#8BDC#,   --  诜 (<CJK Ideograph>)
          17029 => 16#8BDF#,   --  诟 (<CJK Ideograph>)
          17030 => 16#8BE0#,   --  诠 (<CJK Ideograph>)
          17031 => 16#8BE4#,   --  诤 (<CJK Ideograph>)
          17032 => 16#8BE8#,   --  诨 (<CJK Ideograph>)
          17033 => 16#8BE9#,   --  诩 (<CJK Ideograph>)
          17034 => 16#8BEE#,   --  诮 (<CJK Ideograph>)
          17035 => 16#8BF0#,   --  诰 (<CJK Ideograph>)
          17036 => 16#8BF3#,   --  诳 (<CJK Ideograph>)
          17037 => 16#8BF6#,   --  诶 (<CJK Ideograph>)
          17038 => 16#8BF9#,   --  诹 (<CJK Ideograph>)
          17039 => 16#8BFC#,   --  诼 (<CJK Ideograph>)
          17040 => 16#8BFF#,   --  诿 (<CJK Ideograph>)
          17041 => 16#8C00#,   --  谀 (<CJK Ideograph>)
          17042 => 16#8C02#,   --  谂 (<CJK Ideograph>)
          17043 => 16#8C04#,   --  谄 (<CJK Ideograph>)
          17044 => 16#8C07#,   --  谇 (<CJK Ideograph>)
          17045 => 16#8C0C#,   --  谌 (<CJK Ideograph>)
          17046 => 16#8C0F#,   --  谏 (<CJK Ideograph>)
          17047 => 16#8C11#,   --  谑 (<CJK Ideograph>)
          17048 => 16#8C12#,   --  谒 (<CJK Ideograph>)
          17049 => 16#8C14#,   --  谔 (<CJK Ideograph>)
          17050 => 16#8C15#,   --  谕 (<CJK Ideograph>)
          17051 => 16#8C16#,   --  谖 (<CJK Ideograph>)
          17052 => 16#8C19#,   --  谙 (<CJK Ideograph>)
          17053 => 16#8C1B#,   --  谛 (<CJK Ideograph>)
          17054 => 16#8C18#,   --  谘 (<CJK Ideograph>)
          17055 => 16#8C1D#,   --  谝 (<CJK Ideograph>)
          17056 => 16#8C1F#,   --  谟 (<CJK Ideograph>)
          17057 => 16#8C20#,   --  谠 (<CJK Ideograph>)
          17058 => 16#8C21#,   --  谡 (<CJK Ideograph>)
          17059 => 16#8C25#,   --  谥 (<CJK Ideograph>)
          17060 => 16#8C27#,   --  谧 (<CJK Ideograph>)
          17061 => 16#8C2A#,   --  谪 (<CJK Ideograph>)
          17062 => 16#8C2B#,   --  谫 (<CJK Ideograph>)
          17063 => 16#8C2E#,   --  谮 (<CJK Ideograph>)
          17064 => 16#8C2F#,   --  谯 (<CJK Ideograph>)
          17065 => 16#8C32#,   --  谲 (<CJK Ideograph>)
          17066 => 16#8C33#,   --  谳 (<CJK Ideograph>)
          17067 => 16#8C35#,   --  谵 (<CJK Ideograph>)
          17068 => 16#8C36#,   --  谶 (<CJK Ideograph>)
          17069 => 16#5369#,   --  卩 (<CJK Ideograph>)
          17070 => 16#537A#,   --  卺 (<CJK Ideograph>)
          17071 => 16#961D#,   --  阝 (<CJK Ideograph>)
          17072 => 16#9622#,   --  阢 (<CJK Ideograph>)
          17073 => 16#9621#,   --  阡 (<CJK Ideograph>)
          17074 => 16#9631#,   --  阱 (<CJK Ideograph>)
          17075 => 16#962A#,   --  阪 (<CJK Ideograph>)
          17076 => 16#963D#,   --  阽 (<CJK Ideograph>)
          17077 => 16#963C#,   --  阼 (<CJK Ideograph>)
          17078 => 16#9642#,   --  陂 (<CJK Ideograph>)
          17079 => 16#9649#,   --  陉 (<CJK Ideograph>)
          17080 => 16#9654#,   --  陔 (<CJK Ideograph>)
          17081 => 16#965F#,   --  陟 (<CJK Ideograph>)
          17082 => 16#9667#,   --  陧 (<CJK Ideograph>)
          17083 => 16#966C#,   --  陬 (<CJK Ideograph>)
          17084 => 16#9672#,   --  陲 (<CJK Ideograph>)
          17085 => 16#9674#,   --  陴 (<CJK Ideograph>)
          17086 => 16#9688#,   --  隈 (<CJK Ideograph>)
          17087 => 16#968D#,   --  隍 (<CJK Ideograph>)
          17088 => 16#9697#,   --  隗 (<CJK Ideograph>)
          17089 => 16#96B0#,   --  隰 (<CJK Ideograph>)
          17090 => 16#9097#,   --  邗 (<CJK Ideograph>)
          17091 => 16#909B#,   --  邛 (<CJK Ideograph>)
          17092 => 16#909D#,   --  邝 (<CJK Ideograph>)
          17093 => 16#9099#,   --  邙 (<CJK Ideograph>)
          17094 => 16#90AC#,   --  邬 (<CJK Ideograph>)
          17095 => 16#90A1#,   --  邡 (<CJK Ideograph>)
          17096 => 16#90B4#,   --  邴 (<CJK Ideograph>)
          17097 => 16#90B3#,   --  邳 (<CJK Ideograph>)
          17098 => 16#90B6#,   --  邶 (<CJK Ideograph>)
          17099 => 16#90BA#,   --  邺 (<CJK Ideograph>)
          17100 => 16#8DD5#,   --  跕 (<CJK Ideograph>)
          17101 => 16#8DD8#,   --  跘 (<CJK Ideograph>)
          17102 => 16#8DD9#,   --  跙 (<CJK Ideograph>)
          17103 => 16#8DDC#,   --  跜 (<CJK Ideograph>)
          17104 => 16#8DE0#,   --  跠 (<CJK Ideograph>)
          17105 => 16#8DE1#,   --  跡 (<CJK Ideograph>)
          17106 => 16#8DE2#,   --  跢 (<CJK Ideograph>)
          17107 => 16#8DE5#,   --  跥 (<CJK Ideograph>)
          17108 => 16#8DE6#,   --  跦 (<CJK Ideograph>)
          17109 => 16#8DE7#,   --  跧 (<CJK Ideograph>)
          17110 => 16#8DE9#,   --  跩 (<CJK Ideograph>)
          17111 => 16#8DED#,   --  跭 (<CJK Ideograph>)
          17112 => 16#8DEE#,   --  跮 (<CJK Ideograph>)
          17113 => 16#8DF0#,   --  跰 (<CJK Ideograph>)
          17114 => 16#8DF1#,   --  跱 (<CJK Ideograph>)
          17115 => 16#8DF2#,   --  跲 (<CJK Ideograph>)
          17116 => 16#8DF4#,   --  跴 (<CJK Ideograph>)
          17117 => 16#8DF6#,   --  跶 (<CJK Ideograph>)
          17118 => 16#8DFC#,   --  跼 (<CJK Ideograph>)
          17119 => 16#8DFE#,   --  跾 (<CJK Ideograph>)
          17120 => 16#8DFF#,   --  跿 (<CJK Ideograph>)
          17121 => 16#8E00#,   --  踀 (<CJK Ideograph>)
          17122 => 16#8E01#,   --  踁 (<CJK Ideograph>)
          17123 => 16#8E02#,   --  踂 (<CJK Ideograph>)
          17124 => 16#8E03#,   --  踃 (<CJK Ideograph>)
          17125 => 16#8E04#,   --  踄 (<CJK Ideograph>)
          17126 => 16#8E06#,   --  踆 (<CJK Ideograph>)
          17127 => 16#8E07#,   --  踇 (<CJK Ideograph>)
          17128 => 16#8E08#,   --  踈 (<CJK Ideograph>)
          17129 => 16#8E0B#,   --  踋 (<CJK Ideograph>)
          17130 => 16#8E0D#,   --  踍 (<CJK Ideograph>)
          17131 => 16#8E0E#,   --  踎 (<CJK Ideograph>)
          17132 => 16#8E10#,   --  踐 (<CJK Ideograph>)
          17133 => 16#8E11#,   --  踑 (<CJK Ideograph>)
          17134 => 16#8E12#,   --  踒 (<CJK Ideograph>)
          17135 => 16#8E13#,   --  踓 (<CJK Ideograph>)
          17136 => 16#8E15#,   --  踕 (<CJK Ideograph>)
          17137 => 16#8E16#,   --  踖 (<CJK Ideograph>)
          17138 => 16#8E17#,   --  踗 (<CJK Ideograph>)
          17139 => 16#8E18#,   --  踘 (<CJK Ideograph>)
          17140 => 16#8E19#,   --  踙 (<CJK Ideograph>)
          17141 => 16#8E1A#,   --  踚 (<CJK Ideograph>)
          17142 => 16#8E1B#,   --  踛 (<CJK Ideograph>)
          17143 => 16#8E1C#,   --  踜 (<CJK Ideograph>)
          17144 => 16#8E20#,   --  踠 (<CJK Ideograph>)
          17145 => 16#8E21#,   --  踡 (<CJK Ideograph>)
          17146 => 16#8E24#,   --  踤 (<CJK Ideograph>)
          17147 => 16#8E25#,   --  踥 (<CJK Ideograph>)
          17148 => 16#8E26#,   --  踦 (<CJK Ideograph>)
          17149 => 16#8E27#,   --  踧 (<CJK Ideograph>)
          17150 => 16#8E28#,   --  踨 (<CJK Ideograph>)
          17151 => 16#8E2B#,   --  踫 (<CJK Ideograph>)
          17152 => 16#8E2D#,   --  踭 (<CJK Ideograph>)
          17153 => 16#8E30#,   --  踰 (<CJK Ideograph>)
          17154 => 16#8E32#,   --  踲 (<CJK Ideograph>)
          17155 => 16#8E33#,   --  踳 (<CJK Ideograph>)
          17156 => 16#8E34#,   --  踴 (<CJK Ideograph>)
          17157 => 16#8E36#,   --  踶 (<CJK Ideograph>)
          17158 => 16#8E37#,   --  踷 (<CJK Ideograph>)
          17159 => 16#8E38#,   --  踸 (<CJK Ideograph>)
          17160 => 16#8E3B#,   --  踻 (<CJK Ideograph>)
          17161 => 16#8E3C#,   --  踼 (<CJK Ideograph>)
          17162 => 16#8E3E#,   --  踾 (<CJK Ideograph>)
          17163 => 16#8E3F#,   --  踿 (<CJK Ideograph>)
          17164 => 16#8E43#,   --  蹃 (<CJK Ideograph>)
          17165 => 16#8E45#,   --  蹅 (<CJK Ideograph>)
          17166 => 16#8E46#,   --  蹆 (<CJK Ideograph>)
          17167 => 16#8E4C#,   --  蹌 (<CJK Ideograph>)
          17168 => 16#8E4D#,   --  蹍 (<CJK Ideograph>)
          17169 => 16#8E4E#,   --  蹎 (<CJK Ideograph>)
          17170 => 16#8E4F#,   --  蹏 (<CJK Ideograph>)
          17171 => 16#8E50#,   --  蹐 (<CJK Ideograph>)
          17172 => 16#8E53#,   --  蹓 (<CJK Ideograph>)
          17173 => 16#8E54#,   --  蹔 (<CJK Ideograph>)
          17174 => 16#8E55#,   --  蹕 (<CJK Ideograph>)
          17175 => 16#8E56#,   --  蹖 (<CJK Ideograph>)
          17176 => 16#8E57#,   --  蹗 (<CJK Ideograph>)
          17177 => 16#8E58#,   --  蹘 (<CJK Ideograph>)
          17178 => 16#8E5A#,   --  蹚 (<CJK Ideograph>)
          17179 => 16#8E5B#,   --  蹛 (<CJK Ideograph>)
          17180 => 16#8E5C#,   --  蹜 (<CJK Ideograph>)
          17181 => 16#8E5D#,   --  蹝 (<CJK Ideograph>)
          17182 => 16#8E5E#,   --  蹞 (<CJK Ideograph>)
          17183 => 16#8E5F#,   --  蹟 (<CJK Ideograph>)
          17184 => 16#8E60#,   --  蹠 (<CJK Ideograph>)
          17185 => 16#8E61#,   --  蹡 (<CJK Ideograph>)
          17186 => 16#8E62#,   --  蹢 (<CJK Ideograph>)
          17187 => 16#8E63#,   --  蹣 (<CJK Ideograph>)
          17188 => 16#8E64#,   --  蹤 (<CJK Ideograph>)
          17189 => 16#8E65#,   --  蹥 (<CJK Ideograph>)
          17190 => 16#8E67#,   --  蹧 (<CJK Ideograph>)
          17191 => 16#8E68#,   --  蹨 (<CJK Ideograph>)
          17192 => 16#8E6A#,   --  蹪 (<CJK Ideograph>)
          17193 => 16#8E6B#,   --  蹫 (<CJK Ideograph>)
          17194 => 16#8E6E#,   --  蹮 (<CJK Ideograph>)
          17195 => 16#8E71#,   --  蹱 (<CJK Ideograph>)
          17196 => 16#90B8#,   --  邸 (<CJK Ideograph>)
          17197 => 16#90B0#,   --  邰 (<CJK Ideograph>)
          17198 => 16#90CF#,   --  郏 (<CJK Ideograph>)
          17199 => 16#90C5#,   --  郅 (<CJK Ideograph>)
          17200 => 16#90BE#,   --  邾 (<CJK Ideograph>)
          17201 => 16#90D0#,   --  郐 (<CJK Ideograph>)
          17202 => 16#90C4#,   --  郄 (<CJK Ideograph>)
          17203 => 16#90C7#,   --  郇 (<CJK Ideograph>)
          17204 => 16#90D3#,   --  郓 (<CJK Ideograph>)
          17205 => 16#90E6#,   --  郦 (<CJK Ideograph>)
          17206 => 16#90E2#,   --  郢 (<CJK Ideograph>)
          17207 => 16#90DC#,   --  郜 (<CJK Ideograph>)
          17208 => 16#90D7#,   --  郗 (<CJK Ideograph>)
          17209 => 16#90DB#,   --  郛 (<CJK Ideograph>)
          17210 => 16#90EB#,   --  郫 (<CJK Ideograph>)
          17211 => 16#90EF#,   --  郯 (<CJK Ideograph>)
          17212 => 16#90FE#,   --  郾 (<CJK Ideograph>)
          17213 => 16#9104#,   --  鄄 (<CJK Ideograph>)
          17214 => 16#9122#,   --  鄢 (<CJK Ideograph>)
          17215 => 16#911E#,   --  鄞 (<CJK Ideograph>)
          17216 => 16#9123#,   --  鄣 (<CJK Ideograph>)
          17217 => 16#9131#,   --  鄱 (<CJK Ideograph>)
          17218 => 16#912F#,   --  鄯 (<CJK Ideograph>)
          17219 => 16#9139#,   --  鄹 (<CJK Ideograph>)
          17220 => 16#9143#,   --  酃 (<CJK Ideograph>)
          17221 => 16#9146#,   --  酆 (<CJK Ideograph>)
          17222 => 16#520D#,   --  刍 (<CJK Ideograph>)
          17223 => 16#5942#,   --  奂 (<CJK Ideograph>)
          17224 => 16#52A2#,   --  劢 (<CJK Ideograph>)
          17225 => 16#52AC#,   --  劬 (<CJK Ideograph>)
          17226 => 16#52AD#,   --  劭 (<CJK Ideograph>)
          17227 => 16#52BE#,   --  劾 (<CJK Ideograph>)
          17228 => 16#54FF#,   --  哿 (<CJK Ideograph>)
          17229 => 16#52D0#,   --  勐 (<CJK Ideograph>)
          17230 => 16#52D6#,   --  勖 (<CJK Ideograph>)
          17231 => 16#52F0#,   --  勰 (<CJK Ideograph>)
          17232 => 16#53DF#,   --  叟 (<CJK Ideograph>)
          17233 => 16#71EE#,   --  燮 (<CJK Ideograph>)
          17234 => 16#77CD#,   --  矍 (<CJK Ideograph>)
          17235 => 16#5EF4#,   --  廴 (<CJK Ideograph>)
          17236 => 16#51F5#,   --  凵 (<CJK Ideograph>)
          17237 => 16#51FC#,   --  凼 (<CJK Ideograph>)
          17238 => 16#9B2F#,   --  鬯 (<CJK Ideograph>)
          17239 => 16#53B6#,   --  厶 (<CJK Ideograph>)
          17240 => 16#5F01#,   --  弁 (<CJK Ideograph>)
          17241 => 16#755A#,   --  畚 (<CJK Ideograph>)
          17242 => 16#5DEF#,   --  巯 (<CJK Ideograph>)
          17243 => 16#574C#,   --  坌 (<CJK Ideograph>)
          17244 => 16#57A9#,   --  垩 (<CJK Ideograph>)
          17245 => 16#57A1#,   --  垡 (<CJK Ideograph>)
          17246 => 16#587E#,   --  塾 (<CJK Ideograph>)
          17247 => 16#58BC#,   --  墼 (<CJK Ideograph>)
          17248 => 16#58C5#,   --  壅 (<CJK Ideograph>)
          17249 => 16#58D1#,   --  壑 (<CJK Ideograph>)
          17250 => 16#5729#,   --  圩 (<CJK Ideograph>)
          17251 => 16#572C#,   --  圬 (<CJK Ideograph>)
          17252 => 16#572A#,   --  圪 (<CJK Ideograph>)
          17253 => 16#5733#,   --  圳 (<CJK Ideograph>)
          17254 => 16#5739#,   --  圹 (<CJK Ideograph>)
          17255 => 16#572E#,   --  圮 (<CJK Ideograph>)
          17256 => 16#572F#,   --  圯 (<CJK Ideograph>)
          17257 => 16#575C#,   --  坜 (<CJK Ideograph>)
          17258 => 16#573B#,   --  圻 (<CJK Ideograph>)
          17259 => 16#5742#,   --  坂 (<CJK Ideograph>)
          17260 => 16#5769#,   --  坩 (<CJK Ideograph>)
          17261 => 16#5785#,   --  垅 (<CJK Ideograph>)
          17262 => 16#576B#,   --  坫 (<CJK Ideograph>)
          17263 => 16#5786#,   --  垆 (<CJK Ideograph>)
          17264 => 16#577C#,   --  坼 (<CJK Ideograph>)
          17265 => 16#577B#,   --  坻 (<CJK Ideograph>)
          17266 => 16#5768#,   --  坨 (<CJK Ideograph>)
          17267 => 16#576D#,   --  坭 (<CJK Ideograph>)
          17268 => 16#5776#,   --  坶 (<CJK Ideograph>)
          17269 => 16#5773#,   --  坳 (<CJK Ideograph>)
          17270 => 16#57AD#,   --  垭 (<CJK Ideograph>)
          17271 => 16#57A4#,   --  垤 (<CJK Ideograph>)
          17272 => 16#578C#,   --  垌 (<CJK Ideograph>)
          17273 => 16#57B2#,   --  垲 (<CJK Ideograph>)
          17274 => 16#57CF#,   --  埏 (<CJK Ideograph>)
          17275 => 16#57A7#,   --  垧 (<CJK Ideograph>)
          17276 => 16#57B4#,   --  垴 (<CJK Ideograph>)
          17277 => 16#5793#,   --  垓 (<CJK Ideograph>)
          17278 => 16#57A0#,   --  垠 (<CJK Ideograph>)
          17279 => 16#57D5#,   --  埕 (<CJK Ideograph>)
          17280 => 16#57D8#,   --  埘 (<CJK Ideograph>)
          17281 => 16#57DA#,   --  埚 (<CJK Ideograph>)
          17282 => 16#57D9#,   --  埙 (<CJK Ideograph>)
          17283 => 16#57D2#,   --  埒 (<CJK Ideograph>)
          17284 => 16#57B8#,   --  垸 (<CJK Ideograph>)
          17285 => 16#57F4#,   --  埴 (<CJK Ideograph>)
          17286 => 16#57EF#,   --  埯 (<CJK Ideograph>)
          17287 => 16#57F8#,   --  埸 (<CJK Ideograph>)
          17288 => 16#57E4#,   --  埤 (<CJK Ideograph>)
          17289 => 16#57DD#,   --  埝 (<CJK Ideograph>)
          17290 => 16#8E73#,   --  蹳 (<CJK Ideograph>)
          17291 => 16#8E75#,   --  蹵 (<CJK Ideograph>)
          17292 => 16#8E77#,   --  蹷 (<CJK Ideograph>)
          17293 => 16#8E78#,   --  蹸 (<CJK Ideograph>)
          17294 => 16#8E79#,   --  蹹 (<CJK Ideograph>)
          17295 => 16#8E7A#,   --  蹺 (<CJK Ideograph>)
          17296 => 16#8E7B#,   --  蹻 (<CJK Ideograph>)
          17297 => 16#8E7D#,   --  蹽 (<CJK Ideograph>)
          17298 => 16#8E7E#,   --  蹾 (<CJK Ideograph>)
          17299 => 16#8E80#,   --  躀 (<CJK Ideograph>)
          17300 => 16#8E82#,   --  躂 (<CJK Ideograph>)
          17301 => 16#8E83#,   --  躃 (<CJK Ideograph>)
          17302 => 16#8E84#,   --  躄 (<CJK Ideograph>)
          17303 => 16#8E86#,   --  躆 (<CJK Ideograph>)
          17304 => 16#8E88#,   --  躈 (<CJK Ideograph>)
          17305 => 16#8E89#,   --  躉 (<CJK Ideograph>)
          17306 => 16#8E8A#,   --  躊 (<CJK Ideograph>)
          17307 => 16#8E8B#,   --  躋 (<CJK Ideograph>)
          17308 => 16#8E8C#,   --  躌 (<CJK Ideograph>)
          17309 => 16#8E8D#,   --  躍 (<CJK Ideograph>)
          17310 => 16#8E8E#,   --  躎 (<CJK Ideograph>)
          17311 => 16#8E91#,   --  躑 (<CJK Ideograph>)
          17312 => 16#8E92#,   --  躒 (<CJK Ideograph>)
          17313 => 16#8E93#,   --  躓 (<CJK Ideograph>)
          17314 => 16#8E95#,   --  躕 (<CJK Ideograph>)
          17315 => 16#8E96#,   --  躖 (<CJK Ideograph>)
          17316 => 16#8E97#,   --  躗 (<CJK Ideograph>)
          17317 => 16#8E98#,   --  躘 (<CJK Ideograph>)
          17318 => 16#8E99#,   --  躙 (<CJK Ideograph>)
          17319 => 16#8E9A#,   --  躚 (<CJK Ideograph>)
          17320 => 16#8E9B#,   --  躛 (<CJK Ideograph>)
          17321 => 16#8E9D#,   --  躝 (<CJK Ideograph>)
          17322 => 16#8E9F#,   --  躟 (<CJK Ideograph>)
          17323 => 16#8EA0#,   --  躠 (<CJK Ideograph>)
          17324 => 16#8EA1#,   --  躡 (<CJK Ideograph>)
          17325 => 16#8EA2#,   --  躢 (<CJK Ideograph>)
          17326 => 16#8EA3#,   --  躣 (<CJK Ideograph>)
          17327 => 16#8EA4#,   --  躤 (<CJK Ideograph>)
          17328 => 16#8EA5#,   --  躥 (<CJK Ideograph>)
          17329 => 16#8EA6#,   --  躦 (<CJK Ideograph>)
          17330 => 16#8EA7#,   --  躧 (<CJK Ideograph>)
          17331 => 16#8EA8#,   --  躨 (<CJK Ideograph>)
          17332 => 16#8EA9#,   --  躩 (<CJK Ideograph>)
          17333 => 16#8EAA#,   --  躪 (<CJK Ideograph>)
          17334 => 16#8EAD#,   --  躭 (<CJK Ideograph>)
          17335 => 16#8EAE#,   --  躮 (<CJK Ideograph>)
          17336 => 16#8EB0#,   --  躰 (<CJK Ideograph>)
          17337 => 16#8EB1#,   --  躱 (<CJK Ideograph>)
          17338 => 16#8EB3#,   --  躳 (<CJK Ideograph>)
          17339 => 16#8EB4#,   --  躴 (<CJK Ideograph>)
          17340 => 16#8EB5#,   --  躵 (<CJK Ideograph>)
          17341 => 16#8EB6#,   --  躶 (<CJK Ideograph>)
          17342 => 16#8EB7#,   --  躷 (<CJK Ideograph>)
          17343 => 16#8EB8#,   --  躸 (<CJK Ideograph>)
          17344 => 16#8EB9#,   --  躹 (<CJK Ideograph>)
          17345 => 16#8EBB#,   --  躻 (<CJK Ideograph>)
          17346 => 16#8EBC#,   --  躼 (<CJK Ideograph>)
          17347 => 16#8EBD#,   --  躽 (<CJK Ideograph>)
          17348 => 16#8EBE#,   --  躾 (<CJK Ideograph>)
          17349 => 16#8EBF#,   --  躿 (<CJK Ideograph>)
          17350 => 16#8EC0#,   --  軀 (<CJK Ideograph>)
          17351 => 16#8EC1#,   --  軁 (<CJK Ideograph>)
          17352 => 16#8EC2#,   --  軂 (<CJK Ideograph>)
          17353 => 16#8EC3#,   --  軃 (<CJK Ideograph>)
          17354 => 16#8EC4#,   --  軄 (<CJK Ideograph>)
          17355 => 16#8EC5#,   --  軅 (<CJK Ideograph>)
          17356 => 16#8EC6#,   --  軆 (<CJK Ideograph>)
          17357 => 16#8EC7#,   --  軇 (<CJK Ideograph>)
          17358 => 16#8EC8#,   --  軈 (<CJK Ideograph>)
          17359 => 16#8EC9#,   --  軉 (<CJK Ideograph>)
          17360 => 16#8ECA#,   --  車 (<CJK Ideograph>)
          17361 => 16#8ECB#,   --  軋 (<CJK Ideograph>)
          17362 => 16#8ECC#,   --  軌 (<CJK Ideograph>)
          17363 => 16#8ECD#,   --  軍 (<CJK Ideograph>)
          17364 => 16#8ECF#,   --  軏 (<CJK Ideograph>)
          17365 => 16#8ED0#,   --  軐 (<CJK Ideograph>)
          17366 => 16#8ED1#,   --  軑 (<CJK Ideograph>)
          17367 => 16#8ED2#,   --  軒 (<CJK Ideograph>)
          17368 => 16#8ED3#,   --  軓 (<CJK Ideograph>)
          17369 => 16#8ED4#,   --  軔 (<CJK Ideograph>)
          17370 => 16#8ED5#,   --  軕 (<CJK Ideograph>)
          17371 => 16#8ED6#,   --  軖 (<CJK Ideograph>)
          17372 => 16#8ED7#,   --  軗 (<CJK Ideograph>)
          17373 => 16#8ED8#,   --  軘 (<CJK Ideograph>)
          17374 => 16#8ED9#,   --  軙 (<CJK Ideograph>)
          17375 => 16#8EDA#,   --  軚 (<CJK Ideograph>)
          17376 => 16#8EDB#,   --  軛 (<CJK Ideograph>)
          17377 => 16#8EDC#,   --  軜 (<CJK Ideograph>)
          17378 => 16#8EDD#,   --  軝 (<CJK Ideograph>)
          17379 => 16#8EDE#,   --  軞 (<CJK Ideograph>)
          17380 => 16#8EDF#,   --  軟 (<CJK Ideograph>)
          17381 => 16#8EE0#,   --  軠 (<CJK Ideograph>)
          17382 => 16#8EE1#,   --  軡 (<CJK Ideograph>)
          17383 => 16#8EE2#,   --  転 (<CJK Ideograph>)
          17384 => 16#8EE3#,   --  軣 (<CJK Ideograph>)
          17385 => 16#8EE4#,   --  軤 (<CJK Ideograph>)
          17386 => 16#580B#,   --  堋 (<CJK Ideograph>)
          17387 => 16#580D#,   --  堍 (<CJK Ideograph>)
          17388 => 16#57FD#,   --  埽 (<CJK Ideograph>)
          17389 => 16#57ED#,   --  埭 (<CJK Ideograph>)
          17390 => 16#5800#,   --  堀 (<CJK Ideograph>)
          17391 => 16#581E#,   --  堞 (<CJK Ideograph>)
          17392 => 16#5819#,   --  堙 (<CJK Ideograph>)
          17393 => 16#5844#,   --  塄 (<CJK Ideograph>)
          17394 => 16#5820#,   --  堠 (<CJK Ideograph>)
          17395 => 16#5865#,   --  塥 (<CJK Ideograph>)
          17396 => 16#586C#,   --  塬 (<CJK Ideograph>)
          17397 => 16#5881#,   --  墁 (<CJK Ideograph>)
          17398 => 16#5889#,   --  墉 (<CJK Ideograph>)
          17399 => 16#589A#,   --  墚 (<CJK Ideograph>)
          17400 => 16#5880#,   --  墀 (<CJK Ideograph>)
          17401 => 16#99A8#,   --  馨 (<CJK Ideograph>)
          17402 => 16#9F19#,   --  鼙 (<CJK Ideograph>)
          17403 => 16#61FF#,   --  懿 (<CJK Ideograph>)
          17404 => 16#8279#,   --  艹 (<CJK Ideograph>)
          17405 => 16#827D#,   --  艽 (<CJK Ideograph>)
          17406 => 16#827F#,   --  艿 (<CJK Ideograph>)
          17407 => 16#828F#,   --  芏 (<CJK Ideograph>)
          17408 => 16#828A#,   --  芊 (<CJK Ideograph>)
          17409 => 16#82A8#,   --  芨 (<CJK Ideograph>)
          17410 => 16#8284#,   --  芄 (<CJK Ideograph>)
          17411 => 16#828E#,   --  芎 (<CJK Ideograph>)
          17412 => 16#8291#,   --  芑 (<CJK Ideograph>)
          17413 => 16#8297#,   --  芗 (<CJK Ideograph>)
          17414 => 16#8299#,   --  芙 (<CJK Ideograph>)
          17415 => 16#82AB#,   --  芫 (<CJK Ideograph>)
          17416 => 16#82B8#,   --  芸 (<CJK Ideograph>)
          17417 => 16#82BE#,   --  芾 (<CJK Ideograph>)
          17418 => 16#82B0#,   --  芰 (<CJK Ideograph>)
          17419 => 16#82C8#,   --  苈 (<CJK Ideograph>)
          17420 => 16#82CA#,   --  苊 (<CJK Ideograph>)
          17421 => 16#82E3#,   --  苣 (<CJK Ideograph>)
          17422 => 16#8298#,   --  芘 (<CJK Ideograph>)
          17423 => 16#82B7#,   --  芷 (<CJK Ideograph>)
          17424 => 16#82AE#,   --  芮 (<CJK Ideograph>)
          17425 => 16#82CB#,   --  苋 (<CJK Ideograph>)
          17426 => 16#82CC#,   --  苌 (<CJK Ideograph>)
          17427 => 16#82C1#,   --  苁 (<CJK Ideograph>)
          17428 => 16#82A9#,   --  芩 (<CJK Ideograph>)
          17429 => 16#82B4#,   --  芴 (<CJK Ideograph>)
          17430 => 16#82A1#,   --  芡 (<CJK Ideograph>)
          17431 => 16#82AA#,   --  芪 (<CJK Ideograph>)
          17432 => 16#829F#,   --  芟 (<CJK Ideograph>)
          17433 => 16#82C4#,   --  苄 (<CJK Ideograph>)
          17434 => 16#82CE#,   --  苎 (<CJK Ideograph>)
          17435 => 16#82A4#,   --  芤 (<CJK Ideograph>)
          17436 => 16#82E1#,   --  苡 (<CJK Ideograph>)
          17437 => 16#8309#,   --  茉 (<CJK Ideograph>)
          17438 => 16#82F7#,   --  苷 (<CJK Ideograph>)
          17439 => 16#82E4#,   --  苤 (<CJK Ideograph>)
          17440 => 16#830F#,   --  茏 (<CJK Ideograph>)
          17441 => 16#8307#,   --  茇 (<CJK Ideograph>)
          17442 => 16#82DC#,   --  苜 (<CJK Ideograph>)
          17443 => 16#82F4#,   --  苴 (<CJK Ideograph>)
          17444 => 16#82D2#,   --  苒 (<CJK Ideograph>)
          17445 => 16#82D8#,   --  苘 (<CJK Ideograph>)
          17446 => 16#830C#,   --  茌 (<CJK Ideograph>)
          17447 => 16#82FB#,   --  苻 (<CJK Ideograph>)
          17448 => 16#82D3#,   --  苓 (<CJK Ideograph>)
          17449 => 16#8311#,   --  茑 (<CJK Ideograph>)
          17450 => 16#831A#,   --  茚 (<CJK Ideograph>)
          17451 => 16#8306#,   --  茆 (<CJK Ideograph>)
          17452 => 16#8314#,   --  茔 (<CJK Ideograph>)
          17453 => 16#8315#,   --  茕 (<CJK Ideograph>)
          17454 => 16#82E0#,   --  苠 (<CJK Ideograph>)
          17455 => 16#82D5#,   --  苕 (<CJK Ideograph>)
          17456 => 16#831C#,   --  茜 (<CJK Ideograph>)
          17457 => 16#8351#,   --  荑 (<CJK Ideograph>)
          17458 => 16#835B#,   --  荛 (<CJK Ideograph>)
          17459 => 16#835C#,   --  荜 (<CJK Ideograph>)
          17460 => 16#8308#,   --  茈 (<CJK Ideograph>)
          17461 => 16#8392#,   --  莒 (<CJK Ideograph>)
          17462 => 16#833C#,   --  茼 (<CJK Ideograph>)
          17463 => 16#8334#,   --  茴 (<CJK Ideograph>)
          17464 => 16#8331#,   --  茱 (<CJK Ideograph>)
          17465 => 16#839B#,   --  莛 (<CJK Ideograph>)
          17466 => 16#835E#,   --  荞 (<CJK Ideograph>)
          17467 => 16#832F#,   --  茯 (<CJK Ideograph>)
          17468 => 16#834F#,   --  荏 (<CJK Ideograph>)
          17469 => 16#8347#,   --  荇 (<CJK Ideograph>)
          17470 => 16#8343#,   --  荃 (<CJK Ideograph>)
          17471 => 16#835F#,   --  荟 (<CJK Ideograph>)
          17472 => 16#8340#,   --  荀 (<CJK Ideograph>)
          17473 => 16#8317#,   --  茗 (<CJK Ideograph>)
          17474 => 16#8360#,   --  荠 (<CJK Ideograph>)
          17475 => 16#832D#,   --  茭 (<CJK Ideograph>)
          17476 => 16#833A#,   --  茺 (<CJK Ideograph>)
          17477 => 16#8333#,   --  茳 (<CJK Ideograph>)
          17478 => 16#8366#,   --  荦 (<CJK Ideograph>)
          17479 => 16#8365#,   --  荥 (<CJK Ideograph>)
          17480 => 16#8EE5#,   --  軥 (<CJK Ideograph>)
          17481 => 16#8EE6#,   --  軦 (<CJK Ideograph>)
          17482 => 16#8EE7#,   --  軧 (<CJK Ideograph>)
          17483 => 16#8EE8#,   --  軨 (<CJK Ideograph>)
          17484 => 16#8EE9#,   --  軩 (<CJK Ideograph>)
          17485 => 16#8EEA#,   --  軪 (<CJK Ideograph>)
          17486 => 16#8EEB#,   --  軫 (<CJK Ideograph>)
          17487 => 16#8EEC#,   --  軬 (<CJK Ideograph>)
          17488 => 16#8EED#,   --  軭 (<CJK Ideograph>)
          17489 => 16#8EEE#,   --  軮 (<CJK Ideograph>)
          17490 => 16#8EEF#,   --  軯 (<CJK Ideograph>)
          17491 => 16#8EF0#,   --  軰 (<CJK Ideograph>)
          17492 => 16#8EF1#,   --  軱 (<CJK Ideograph>)
          17493 => 16#8EF2#,   --  軲 (<CJK Ideograph>)
          17494 => 16#8EF3#,   --  軳 (<CJK Ideograph>)
          17495 => 16#8EF4#,   --  軴 (<CJK Ideograph>)
          17496 => 16#8EF5#,   --  軵 (<CJK Ideograph>)
          17497 => 16#8EF6#,   --  軶 (<CJK Ideograph>)
          17498 => 16#8EF7#,   --  軷 (<CJK Ideograph>)
          17499 => 16#8EF8#,   --  軸 (<CJK Ideograph>)
          17500 => 16#8EF9#,   --  軹 (<CJK Ideograph>)
          17501 => 16#8EFA#,   --  軺 (<CJK Ideograph>)
          17502 => 16#8EFB#,   --  軻 (<CJK Ideograph>)
          17503 => 16#8EFC#,   --  軼 (<CJK Ideograph>)
          17504 => 16#8EFD#,   --  軽 (<CJK Ideograph>)
          17505 => 16#8EFE#,   --  軾 (<CJK Ideograph>)
          17506 => 16#8EFF#,   --  軿 (<CJK Ideograph>)
          17507 => 16#8F00#,   --  輀 (<CJK Ideograph>)
          17508 => 16#8F01#,   --  輁 (<CJK Ideograph>)
          17509 => 16#8F02#,   --  輂 (<CJK Ideograph>)
          17510 => 16#8F03#,   --  較 (<CJK Ideograph>)
          17511 => 16#8F04#,   --  輄 (<CJK Ideograph>)
          17512 => 16#8F05#,   --  輅 (<CJK Ideograph>)
          17513 => 16#8F06#,   --  輆 (<CJK Ideograph>)
          17514 => 16#8F07#,   --  輇 (<CJK Ideograph>)
          17515 => 16#8F08#,   --  輈 (<CJK Ideograph>)
          17516 => 16#8F09#,   --  載 (<CJK Ideograph>)
          17517 => 16#8F0A#,   --  輊 (<CJK Ideograph>)
          17518 => 16#8F0B#,   --  輋 (<CJK Ideograph>)
          17519 => 16#8F0C#,   --  輌 (<CJK Ideograph>)
          17520 => 16#8F0D#,   --  輍 (<CJK Ideograph>)
          17521 => 16#8F0E#,   --  輎 (<CJK Ideograph>)
          17522 => 16#8F0F#,   --  輏 (<CJK Ideograph>)
          17523 => 16#8F10#,   --  輐 (<CJK Ideograph>)
          17524 => 16#8F11#,   --  輑 (<CJK Ideograph>)
          17525 => 16#8F12#,   --  輒 (<CJK Ideograph>)
          17526 => 16#8F13#,   --  輓 (<CJK Ideograph>)
          17527 => 16#8F14#,   --  輔 (<CJK Ideograph>)
          17528 => 16#8F15#,   --  輕 (<CJK Ideograph>)
          17529 => 16#8F16#,   --  輖 (<CJK Ideograph>)
          17530 => 16#8F17#,   --  輗 (<CJK Ideograph>)
          17531 => 16#8F18#,   --  輘 (<CJK Ideograph>)
          17532 => 16#8F19#,   --  輙 (<CJK Ideograph>)
          17533 => 16#8F1A#,   --  輚 (<CJK Ideograph>)
          17534 => 16#8F1B#,   --  輛 (<CJK Ideograph>)
          17535 => 16#8F1C#,   --  輜 (<CJK Ideograph>)
          17536 => 16#8F1D#,   --  輝 (<CJK Ideograph>)
          17537 => 16#8F1E#,   --  輞 (<CJK Ideograph>)
          17538 => 16#8F1F#,   --  輟 (<CJK Ideograph>)
          17539 => 16#8F20#,   --  輠 (<CJK Ideograph>)
          17540 => 16#8F21#,   --  輡 (<CJK Ideograph>)
          17541 => 16#8F22#,   --  輢 (<CJK Ideograph>)
          17542 => 16#8F23#,   --  輣 (<CJK Ideograph>)
          17543 => 16#8F24#,   --  輤 (<CJK Ideograph>)
          17544 => 16#8F25#,   --  輥 (<CJK Ideograph>)
          17545 => 16#8F26#,   --  輦 (<CJK Ideograph>)
          17546 => 16#8F27#,   --  輧 (<CJK Ideograph>)
          17547 => 16#8F28#,   --  輨 (<CJK Ideograph>)
          17548 => 16#8F29#,   --  輩 (<CJK Ideograph>)
          17549 => 16#8F2A#,   --  輪 (<CJK Ideograph>)
          17550 => 16#8F2B#,   --  輫 (<CJK Ideograph>)
          17551 => 16#8F2C#,   --  輬 (<CJK Ideograph>)
          17552 => 16#8F2D#,   --  輭 (<CJK Ideograph>)
          17553 => 16#8F2E#,   --  輮 (<CJK Ideograph>)
          17554 => 16#8F2F#,   --  輯 (<CJK Ideograph>)
          17555 => 16#8F30#,   --  輰 (<CJK Ideograph>)
          17556 => 16#8F31#,   --  輱 (<CJK Ideograph>)
          17557 => 16#8F32#,   --  輲 (<CJK Ideograph>)
          17558 => 16#8F33#,   --  輳 (<CJK Ideograph>)
          17559 => 16#8F34#,   --  輴 (<CJK Ideograph>)
          17560 => 16#8F35#,   --  輵 (<CJK Ideograph>)
          17561 => 16#8F36#,   --  輶 (<CJK Ideograph>)
          17562 => 16#8F37#,   --  輷 (<CJK Ideograph>)
          17563 => 16#8F38#,   --  輸 (<CJK Ideograph>)
          17564 => 16#8F39#,   --  輹 (<CJK Ideograph>)
          17565 => 16#8F3A#,   --  輺 (<CJK Ideograph>)
          17566 => 16#8F3B#,   --  輻 (<CJK Ideograph>)
          17567 => 16#8F3C#,   --  輼 (<CJK Ideograph>)
          17568 => 16#8F3D#,   --  輽 (<CJK Ideograph>)
          17569 => 16#8F3E#,   --  輾 (<CJK Ideograph>)
          17570 => 16#8F3F#,   --  輿 (<CJK Ideograph>)
          17571 => 16#8F40#,   --  轀 (<CJK Ideograph>)
          17572 => 16#8F41#,   --  轁 (<CJK Ideograph>)
          17573 => 16#8F42#,   --  轂 (<CJK Ideograph>)
          17574 => 16#8F43#,   --  轃 (<CJK Ideograph>)
          17575 => 16#8F44#,   --  轄 (<CJK Ideograph>)
          17576 => 16#8368#,   --  荨 (<CJK Ideograph>)
          17577 => 16#831B#,   --  茛 (<CJK Ideograph>)
          17578 => 16#8369#,   --  荩 (<CJK Ideograph>)
          17579 => 16#836C#,   --  荬 (<CJK Ideograph>)
          17580 => 16#836A#,   --  荪 (<CJK Ideograph>)
          17581 => 16#836D#,   --  荭 (<CJK Ideograph>)
          17582 => 16#836E#,   --  荮 (<CJK Ideograph>)
          17583 => 16#83B0#,   --  莰 (<CJK Ideograph>)
          17584 => 16#8378#,   --  荸 (<CJK Ideograph>)
          17585 => 16#83B3#,   --  莳 (<CJK Ideograph>)
          17586 => 16#83B4#,   --  莴 (<CJK Ideograph>)
          17587 => 16#83A0#,   --  莠 (<CJK Ideograph>)
          17588 => 16#83AA#,   --  莪 (<CJK Ideograph>)
          17589 => 16#8393#,   --  莓 (<CJK Ideograph>)
          17590 => 16#839C#,   --  莜 (<CJK Ideograph>)
          17591 => 16#8385#,   --  莅 (<CJK Ideograph>)
          17592 => 16#837C#,   --  荼 (<CJK Ideograph>)
          17593 => 16#83B6#,   --  莶 (<CJK Ideograph>)
          17594 => 16#83A9#,   --  莩 (<CJK Ideograph>)
          17595 => 16#837D#,   --  荽 (<CJK Ideograph>)
          17596 => 16#83B8#,   --  莸 (<CJK Ideograph>)
          17597 => 16#837B#,   --  荻 (<CJK Ideograph>)
          17598 => 16#8398#,   --  莘 (<CJK Ideograph>)
          17599 => 16#839E#,   --  莞 (<CJK Ideograph>)
          17600 => 16#83A8#,   --  莨 (<CJK Ideograph>)
          17601 => 16#83BA#,   --  莺 (<CJK Ideograph>)
          17602 => 16#83BC#,   --  莼 (<CJK Ideograph>)
          17603 => 16#83C1#,   --  菁 (<CJK Ideograph>)
          17604 => 16#8401#,   --  萁 (<CJK Ideograph>)
          17605 => 16#83E5#,   --  菥 (<CJK Ideograph>)
          17606 => 16#83D8#,   --  菘 (<CJK Ideograph>)
          17607 => 16#5807#,   --  堇 (<CJK Ideograph>)
          17608 => 16#8418#,   --  萘 (<CJK Ideograph>)
          17609 => 16#840B#,   --  萋 (<CJK Ideograph>)
          17610 => 16#83DD#,   --  菝 (<CJK Ideograph>)
          17611 => 16#83FD#,   --  菽 (<CJK Ideograph>)
          17612 => 16#83D6#,   --  菖 (<CJK Ideograph>)
          17613 => 16#841C#,   --  萜 (<CJK Ideograph>)
          17614 => 16#8438#,   --  萸 (<CJK Ideograph>)
          17615 => 16#8411#,   --  萑 (<CJK Ideograph>)
          17616 => 16#8406#,   --  萆 (<CJK Ideograph>)
          17617 => 16#83D4#,   --  菔 (<CJK Ideograph>)
          17618 => 16#83DF#,   --  菟 (<CJK Ideograph>)
          17619 => 16#840F#,   --  萏 (<CJK Ideograph>)
          17620 => 16#8403#,   --  萃 (<CJK Ideograph>)
          17621 => 16#83F8#,   --  菸 (<CJK Ideograph>)
          17622 => 16#83F9#,   --  菹 (<CJK Ideograph>)
          17623 => 16#83EA#,   --  菪 (<CJK Ideograph>)
          17624 => 16#83C5#,   --  菅 (<CJK Ideograph>)
          17625 => 16#83C0#,   --  菀 (<CJK Ideograph>)
          17626 => 16#8426#,   --  萦 (<CJK Ideograph>)
          17627 => 16#83F0#,   --  菰 (<CJK Ideograph>)
          17628 => 16#83E1#,   --  菡 (<CJK Ideograph>)
          17629 => 16#845C#,   --  葜 (<CJK Ideograph>)
          17630 => 16#8451#,   --  葑 (<CJK Ideograph>)
          17631 => 16#845A#,   --  葚 (<CJK Ideograph>)
          17632 => 16#8459#,   --  葙 (<CJK Ideograph>)
          17633 => 16#8473#,   --  葳 (<CJK Ideograph>)
          17634 => 16#8487#,   --  蒇 (<CJK Ideograph>)
          17635 => 16#8488#,   --  蒈 (<CJK Ideograph>)
          17636 => 16#847A#,   --  葺 (<CJK Ideograph>)
          17637 => 16#8489#,   --  蒉 (<CJK Ideograph>)
          17638 => 16#8478#,   --  葸 (<CJK Ideograph>)
          17639 => 16#843C#,   --  萼 (<CJK Ideograph>)
          17640 => 16#8446#,   --  葆 (<CJK Ideograph>)
          17641 => 16#8469#,   --  葩 (<CJK Ideograph>)
          17642 => 16#8476#,   --  葶 (<CJK Ideograph>)
          17643 => 16#848C#,   --  蒌 (<CJK Ideograph>)
          17644 => 16#848E#,   --  蒎 (<CJK Ideograph>)
          17645 => 16#8431#,   --  萱 (<CJK Ideograph>)
          17646 => 16#846D#,   --  葭 (<CJK Ideograph>)
          17647 => 16#84C1#,   --  蓁 (<CJK Ideograph>)
          17648 => 16#84CD#,   --  蓍 (<CJK Ideograph>)
          17649 => 16#84D0#,   --  蓐 (<CJK Ideograph>)
          17650 => 16#84E6#,   --  蓦 (<CJK Ideograph>)
          17651 => 16#84BD#,   --  蒽 (<CJK Ideograph>)
          17652 => 16#84D3#,   --  蓓 (<CJK Ideograph>)
          17653 => 16#84CA#,   --  蓊 (<CJK Ideograph>)
          17654 => 16#84BF#,   --  蒿 (<CJK Ideograph>)
          17655 => 16#84BA#,   --  蒺 (<CJK Ideograph>)
          17656 => 16#84E0#,   --  蓠 (<CJK Ideograph>)
          17657 => 16#84A1#,   --  蒡 (<CJK Ideograph>)
          17658 => 16#84B9#,   --  蒹 (<CJK Ideograph>)
          17659 => 16#84B4#,   --  蒴 (<CJK Ideograph>)
          17660 => 16#8497#,   --  蒗 (<CJK Ideograph>)
          17661 => 16#84E5#,   --  蓥 (<CJK Ideograph>)
          17662 => 16#84E3#,   --  蓣 (<CJK Ideograph>)
          17663 => 16#850C#,   --  蔌 (<CJK Ideograph>)
          17664 => 16#750D#,   --  甍 (<CJK Ideograph>)
          17665 => 16#8538#,   --  蔸 (<CJK Ideograph>)
          17666 => 16#84F0#,   --  蓰 (<CJK Ideograph>)
          17667 => 16#8539#,   --  蔹 (<CJK Ideograph>)
          17668 => 16#851F#,   --  蔟 (<CJK Ideograph>)
          17669 => 16#853A#,   --  蔺 (<CJK Ideograph>)
          17670 => 16#8F45#,   --  轅 (<CJK Ideograph>)
          17671 => 16#8F46#,   --  轆 (<CJK Ideograph>)
          17672 => 16#8F47#,   --  轇 (<CJK Ideograph>)
          17673 => 16#8F48#,   --  轈 (<CJK Ideograph>)
          17674 => 16#8F49#,   --  轉 (<CJK Ideograph>)
          17675 => 16#8F4A#,   --  轊 (<CJK Ideograph>)
          17676 => 16#8F4B#,   --  轋 (<CJK Ideograph>)
          17677 => 16#8F4C#,   --  轌 (<CJK Ideograph>)
          17678 => 16#8F4D#,   --  轍 (<CJK Ideograph>)
          17679 => 16#8F4E#,   --  轎 (<CJK Ideograph>)
          17680 => 16#8F4F#,   --  轏 (<CJK Ideograph>)
          17681 => 16#8F50#,   --  轐 (<CJK Ideograph>)
          17682 => 16#8F51#,   --  轑 (<CJK Ideograph>)
          17683 => 16#8F52#,   --  轒 (<CJK Ideograph>)
          17684 => 16#8F53#,   --  轓 (<CJK Ideograph>)
          17685 => 16#8F54#,   --  轔 (<CJK Ideograph>)
          17686 => 16#8F55#,   --  轕 (<CJK Ideograph>)
          17687 => 16#8F56#,   --  轖 (<CJK Ideograph>)
          17688 => 16#8F57#,   --  轗 (<CJK Ideograph>)
          17689 => 16#8F58#,   --  轘 (<CJK Ideograph>)
          17690 => 16#8F59#,   --  轙 (<CJK Ideograph>)
          17691 => 16#8F5A#,   --  轚 (<CJK Ideograph>)
          17692 => 16#8F5B#,   --  轛 (<CJK Ideograph>)
          17693 => 16#8F5C#,   --  轜 (<CJK Ideograph>)
          17694 => 16#8F5D#,   --  轝 (<CJK Ideograph>)
          17695 => 16#8F5E#,   --  轞 (<CJK Ideograph>)
          17696 => 16#8F5F#,   --  轟 (<CJK Ideograph>)
          17697 => 16#8F60#,   --  轠 (<CJK Ideograph>)
          17698 => 16#8F61#,   --  轡 (<CJK Ideograph>)
          17699 => 16#8F62#,   --  轢 (<CJK Ideograph>)
          17700 => 16#8F63#,   --  轣 (<CJK Ideograph>)
          17701 => 16#8F64#,   --  轤 (<CJK Ideograph>)
          17702 => 16#8F65#,   --  轥 (<CJK Ideograph>)
          17703 => 16#8F6A#,   --  轪 (<CJK Ideograph>)
          17704 => 16#8F80#,   --  辀 (<CJK Ideograph>)
          17705 => 16#8F8C#,   --  辌 (<CJK Ideograph>)
          17706 => 16#8F92#,   --  辒 (<CJK Ideograph>)
          17707 => 16#8F9D#,   --  辝 (<CJK Ideograph>)
          17708 => 16#8FA0#,   --  辠 (<CJK Ideograph>)
          17709 => 16#8FA1#,   --  辡 (<CJK Ideograph>)
          17710 => 16#8FA2#,   --  辢 (<CJK Ideograph>)
          17711 => 16#8FA4#,   --  辤 (<CJK Ideograph>)
          17712 => 16#8FA5#,   --  辥 (<CJK Ideograph>)
          17713 => 16#8FA6#,   --  辦 (<CJK Ideograph>)
          17714 => 16#8FA7#,   --  辧 (<CJK Ideograph>)
          17715 => 16#8FAA#,   --  辪 (<CJK Ideograph>)
          17716 => 16#8FAC#,   --  辬 (<CJK Ideograph>)
          17717 => 16#8FAD#,   --  辭 (<CJK Ideograph>)
          17718 => 16#8FAE#,   --  辮 (<CJK Ideograph>)
          17719 => 16#8FAF#,   --  辯 (<CJK Ideograph>)
          17720 => 16#8FB2#,   --  農 (<CJK Ideograph>)
          17721 => 16#8FB3#,   --  辳 (<CJK Ideograph>)
          17722 => 16#8FB4#,   --  辴 (<CJK Ideograph>)
          17723 => 16#8FB5#,   --  辵 (<CJK Ideograph>)
          17724 => 16#8FB7#,   --  辷 (<CJK Ideograph>)
          17725 => 16#8FB8#,   --  辸 (<CJK Ideograph>)
          17726 => 16#8FBA#,   --  辺 (<CJK Ideograph>)
          17727 => 16#8FBB#,   --  辻 (<CJK Ideograph>)
          17728 => 16#8FBC#,   --  込 (<CJK Ideograph>)
          17729 => 16#8FBF#,   --  辿 (<CJK Ideograph>)
          17730 => 16#8FC0#,   --  迀 (<CJK Ideograph>)
          17731 => 16#8FC3#,   --  迃 (<CJK Ideograph>)
          17732 => 16#8FC6#,   --  迆 (<CJK Ideograph>)
          17733 => 16#8FC9#,   --  迉 (<CJK Ideograph>)
          17734 => 16#8FCA#,   --  迊 (<CJK Ideograph>)
          17735 => 16#8FCB#,   --  迋 (<CJK Ideograph>)
          17736 => 16#8FCC#,   --  迌 (<CJK Ideograph>)
          17737 => 16#8FCD#,   --  迍 (<CJK Ideograph>)
          17738 => 16#8FCF#,   --  迏 (<CJK Ideograph>)
          17739 => 16#8FD2#,   --  迒 (<CJK Ideograph>)
          17740 => 16#8FD6#,   --  迖 (<CJK Ideograph>)
          17741 => 16#8FD7#,   --  迗 (<CJK Ideograph>)
          17742 => 16#8FDA#,   --  迚 (<CJK Ideograph>)
          17743 => 16#8FE0#,   --  迠 (<CJK Ideograph>)
          17744 => 16#8FE1#,   --  迡 (<CJK Ideograph>)
          17745 => 16#8FE3#,   --  迣 (<CJK Ideograph>)
          17746 => 16#8FE7#,   --  迧 (<CJK Ideograph>)
          17747 => 16#8FEC#,   --  迬 (<CJK Ideograph>)
          17748 => 16#8FEF#,   --  迯 (<CJK Ideograph>)
          17749 => 16#8FF1#,   --  迱 (<CJK Ideograph>)
          17750 => 16#8FF2#,   --  迲 (<CJK Ideograph>)
          17751 => 16#8FF4#,   --  迴 (<CJK Ideograph>)
          17752 => 16#8FF5#,   --  迵 (<CJK Ideograph>)
          17753 => 16#8FF6#,   --  迶 (<CJK Ideograph>)
          17754 => 16#8FFA#,   --  迺 (<CJK Ideograph>)
          17755 => 16#8FFB#,   --  迻 (<CJK Ideograph>)
          17756 => 16#8FFC#,   --  迼 (<CJK Ideograph>)
          17757 => 16#8FFE#,   --  迾 (<CJK Ideograph>)
          17758 => 16#8FFF#,   --  迿 (<CJK Ideograph>)
          17759 => 16#9007#,   --  逇 (<CJK Ideograph>)
          17760 => 16#9008#,   --  逈 (<CJK Ideograph>)
          17761 => 16#900C#,   --  逌 (<CJK Ideograph>)
          17762 => 16#900E#,   --  逎 (<CJK Ideograph>)
          17763 => 16#9013#,   --  逓 (<CJK Ideograph>)
          17764 => 16#9015#,   --  逕 (<CJK Ideograph>)
          17765 => 16#9018#,   --  逘 (<CJK Ideograph>)
          17766 => 16#8556#,   --  蕖 (<CJK Ideograph>)
          17767 => 16#853B#,   --  蔻 (<CJK Ideograph>)
          17768 => 16#84FF#,   --  蓿 (<CJK Ideograph>)
          17769 => 16#84FC#,   --  蓼 (<CJK Ideograph>)
          17770 => 16#8559#,   --  蕙 (<CJK Ideograph>)
          17771 => 16#8548#,   --  蕈 (<CJK Ideograph>)
          17772 => 16#8568#,   --  蕨 (<CJK Ideograph>)
          17773 => 16#8564#,   --  蕤 (<CJK Ideograph>)
          17774 => 16#855E#,   --  蕞 (<CJK Ideograph>)
          17775 => 16#857A#,   --  蕺 (<CJK Ideograph>)
          17776 => 16#77A2#,   --  瞢 (<CJK Ideograph>)
          17777 => 16#8543#,   --  蕃 (<CJK Ideograph>)
          17778 => 16#8572#,   --  蕲 (<CJK Ideograph>)
          17779 => 16#857B#,   --  蕻 (<CJK Ideograph>)
          17780 => 16#85A4#,   --  薤 (<CJK Ideograph>)
          17781 => 16#85A8#,   --  薨 (<CJK Ideograph>)
          17782 => 16#8587#,   --  薇 (<CJK Ideograph>)
          17783 => 16#858F#,   --  薏 (<CJK Ideograph>)
          17784 => 16#8579#,   --  蕹 (<CJK Ideograph>)
          17785 => 16#85AE#,   --  薮 (<CJK Ideograph>)
          17786 => 16#859C#,   --  薜 (<CJK Ideograph>)
          17787 => 16#8585#,   --  薅 (<CJK Ideograph>)
          17788 => 16#85B9#,   --  薹 (<CJK Ideograph>)
          17789 => 16#85B7#,   --  薷 (<CJK Ideograph>)
          17790 => 16#85B0#,   --  薰 (<CJK Ideograph>)
          17791 => 16#85D3#,   --  藓 (<CJK Ideograph>)
          17792 => 16#85C1#,   --  藁 (<CJK Ideograph>)
          17793 => 16#85DC#,   --  藜 (<CJK Ideograph>)
          17794 => 16#85FF#,   --  藿 (<CJK Ideograph>)
          17795 => 16#8627#,   --  蘧 (<CJK Ideograph>)
          17796 => 16#8605#,   --  蘅 (<CJK Ideograph>)
          17797 => 16#8629#,   --  蘩 (<CJK Ideograph>)
          17798 => 16#8616#,   --  蘖 (<CJK Ideograph>)
          17799 => 16#863C#,   --  蘼 (<CJK Ideograph>)
          17800 => 16#5EFE#,   --  廾 (<CJK Ideograph>)
          17801 => 16#5F08#,   --  弈 (<CJK Ideograph>)
          17802 => 16#593C#,   --  夼 (<CJK Ideograph>)
          17803 => 16#5941#,   --  奁 (<CJK Ideograph>)
          17804 => 16#8037#,   --  耷 (<CJK Ideograph>)
          17805 => 16#5955#,   --  奕 (<CJK Ideograph>)
          17806 => 16#595A#,   --  奚 (<CJK Ideograph>)
          17807 => 16#5958#,   --  奘 (<CJK Ideograph>)
          17808 => 16#530F#,   --  匏 (<CJK Ideograph>)
          17809 => 16#5C22#,   --  尢 (<CJK Ideograph>)
          17810 => 16#5C25#,   --  尥 (<CJK Ideograph>)
          17811 => 16#5C2C#,   --  尬 (<CJK Ideograph>)
          17812 => 16#5C34#,   --  尴 (<CJK Ideograph>)
          17813 => 16#624C#,   --  扌 (<CJK Ideograph>)
          17814 => 16#626A#,   --  扪 (<CJK Ideograph>)
          17815 => 16#629F#,   --  抟 (<CJK Ideograph>)
          17816 => 16#62BB#,   --  抻 (<CJK Ideograph>)
          17817 => 16#62CA#,   --  拊 (<CJK Ideograph>)
          17818 => 16#62DA#,   --  拚 (<CJK Ideograph>)
          17819 => 16#62D7#,   --  拗 (<CJK Ideograph>)
          17820 => 16#62EE#,   --  拮 (<CJK Ideograph>)
          17821 => 16#6322#,   --  挢 (<CJK Ideograph>)
          17822 => 16#62F6#,   --  拶 (<CJK Ideograph>)
          17823 => 16#6339#,   --  挹 (<CJK Ideograph>)
          17824 => 16#634B#,   --  捋 (<CJK Ideograph>)
          17825 => 16#6343#,   --  捃 (<CJK Ideograph>)
          17826 => 16#63AD#,   --  掭 (<CJK Ideograph>)
          17827 => 16#63F6#,   --  揶 (<CJK Ideograph>)
          17828 => 16#6371#,   --  捱 (<CJK Ideograph>)
          17829 => 16#637A#,   --  捺 (<CJK Ideograph>)
          17830 => 16#638E#,   --  掎 (<CJK Ideograph>)
          17831 => 16#63B4#,   --  掴 (<CJK Ideograph>)
          17832 => 16#636D#,   --  捭 (<CJK Ideograph>)
          17833 => 16#63AC#,   --  掬 (<CJK Ideograph>)
          17834 => 16#638A#,   --  掊 (<CJK Ideograph>)
          17835 => 16#6369#,   --  捩 (<CJK Ideograph>)
          17836 => 16#63AE#,   --  掮 (<CJK Ideograph>)
          17837 => 16#63BC#,   --  掼 (<CJK Ideograph>)
          17838 => 16#63F2#,   --  揲 (<CJK Ideograph>)
          17839 => 16#63F8#,   --  揸 (<CJK Ideograph>)
          17840 => 16#63E0#,   --  揠 (<CJK Ideograph>)
          17841 => 16#63FF#,   --  揿 (<CJK Ideograph>)
          17842 => 16#63C4#,   --  揄 (<CJK Ideograph>)
          17843 => 16#63DE#,   --  揞 (<CJK Ideograph>)
          17844 => 16#63CE#,   --  揎 (<CJK Ideograph>)
          17845 => 16#6452#,   --  摒 (<CJK Ideograph>)
          17846 => 16#63C6#,   --  揆 (<CJK Ideograph>)
          17847 => 16#63BE#,   --  掾 (<CJK Ideograph>)
          17848 => 16#6445#,   --  摅 (<CJK Ideograph>)
          17849 => 16#6441#,   --  摁 (<CJK Ideograph>)
          17850 => 16#640B#,   --  搋 (<CJK Ideograph>)
          17851 => 16#641B#,   --  搛 (<CJK Ideograph>)
          17852 => 16#6420#,   --  搠 (<CJK Ideograph>)
          17853 => 16#640C#,   --  搌 (<CJK Ideograph>)
          17854 => 16#6426#,   --  搦 (<CJK Ideograph>)
          17855 => 16#6421#,   --  搡 (<CJK Ideograph>)
          17856 => 16#645E#,   --  摞 (<CJK Ideograph>)
          17857 => 16#6484#,   --  撄 (<CJK Ideograph>)
          17858 => 16#646D#,   --  摭 (<CJK Ideograph>)
          17859 => 16#6496#,   --  撖 (<CJK Ideograph>)
          17860 => 16#9019#,   --  這 (<CJK Ideograph>)
          17861 => 16#901C#,   --  逜 (<CJK Ideograph>)
          17862 => 16#9023#,   --  連 (<CJK Ideograph>)
          17863 => 16#9024#,   --  逤 (<CJK Ideograph>)
          17864 => 16#9025#,   --  逥 (<CJK Ideograph>)
          17865 => 16#9027#,   --  逧 (<CJK Ideograph>)
          17866 => 16#9028#,   --  逨 (<CJK Ideograph>)
          17867 => 16#9029#,   --  逩 (<CJK Ideograph>)
          17868 => 16#902A#,   --  逪 (<CJK Ideograph>)
          17869 => 16#902B#,   --  逫 (<CJK Ideograph>)
          17870 => 16#902C#,   --  逬 (<CJK Ideograph>)
          17871 => 16#9030#,   --  逰 (<CJK Ideograph>)
          17872 => 16#9031#,   --  週 (<CJK Ideograph>)
          17873 => 16#9032#,   --  進 (<CJK Ideograph>)
          17874 => 16#9033#,   --  逳 (<CJK Ideograph>)
          17875 => 16#9034#,   --  逴 (<CJK Ideograph>)
          17876 => 16#9037#,   --  逷 (<CJK Ideograph>)
          17877 => 16#9039#,   --  逹 (<CJK Ideograph>)
          17878 => 16#903A#,   --  逺 (<CJK Ideograph>)
          17879 => 16#903D#,   --  逽 (<CJK Ideograph>)
          17880 => 16#903F#,   --  逿 (<CJK Ideograph>)
          17881 => 16#9040#,   --  遀 (<CJK Ideograph>)
          17882 => 16#9043#,   --  遃 (<CJK Ideograph>)
          17883 => 16#9045#,   --  遅 (<CJK Ideograph>)
          17884 => 16#9046#,   --  遆 (<CJK Ideograph>)
          17885 => 16#9048#,   --  遈 (<CJK Ideograph>)
          17886 => 16#9049#,   --  遉 (<CJK Ideograph>)
          17887 => 16#904A#,   --  遊 (<CJK Ideograph>)
          17888 => 16#904B#,   --  運 (<CJK Ideograph>)
          17889 => 16#904C#,   --  遌 (<CJK Ideograph>)
          17890 => 16#904E#,   --  過 (<CJK Ideograph>)
          17891 => 16#9054#,   --  達 (<CJK Ideograph>)
          17892 => 16#9055#,   --  違 (<CJK Ideograph>)
          17893 => 16#9056#,   --  遖 (<CJK Ideograph>)
          17894 => 16#9059#,   --  遙 (<CJK Ideograph>)
          17895 => 16#905A#,   --  遚 (<CJK Ideograph>)
          17896 => 16#905C#,   --  遜 (<CJK Ideograph>)
          17897 => 16#905D#,   --  遝 (<CJK Ideograph>)
          17898 => 16#905E#,   --  遞 (<CJK Ideograph>)
          17899 => 16#905F#,   --  遟 (<CJK Ideograph>)
          17900 => 16#9060#,   --  遠 (<CJK Ideograph>)
          17901 => 16#9061#,   --  遡 (<CJK Ideograph>)
          17902 => 16#9064#,   --  遤 (<CJK Ideograph>)
          17903 => 16#9066#,   --  遦 (<CJK Ideograph>)
          17904 => 16#9067#,   --  遧 (<CJK Ideograph>)
          17905 => 16#9069#,   --  適 (<CJK Ideograph>)
          17906 => 16#906A#,   --  遪 (<CJK Ideograph>)
          17907 => 16#906B#,   --  遫 (<CJK Ideograph>)
          17908 => 16#906C#,   --  遬 (<CJK Ideograph>)
          17909 => 16#906F#,   --  遯 (<CJK Ideograph>)
          17910 => 16#9070#,   --  遰 (<CJK Ideograph>)
          17911 => 16#9071#,   --  遱 (<CJK Ideograph>)
          17912 => 16#9072#,   --  遲 (<CJK Ideograph>)
          17913 => 16#9073#,   --  遳 (<CJK Ideograph>)
          17914 => 16#9076#,   --  遶 (<CJK Ideograph>)
          17915 => 16#9077#,   --  遷 (<CJK Ideograph>)
          17916 => 16#9078#,   --  選 (<CJK Ideograph>)
          17917 => 16#9079#,   --  遹 (<CJK Ideograph>)
          17918 => 16#907A#,   --  遺 (<CJK Ideograph>)
          17919 => 16#907B#,   --  遻 (<CJK Ideograph>)
          17920 => 16#907C#,   --  遼 (<CJK Ideograph>)
          17921 => 16#907E#,   --  遾 (<CJK Ideograph>)
          17922 => 16#9081#,   --  邁 (<CJK Ideograph>)
          17923 => 16#9084#,   --  還 (<CJK Ideograph>)
          17924 => 16#9085#,   --  邅 (<CJK Ideograph>)
          17925 => 16#9086#,   --  邆 (<CJK Ideograph>)
          17926 => 16#9087#,   --  邇 (<CJK Ideograph>)
          17927 => 16#9089#,   --  邉 (<CJK Ideograph>)
          17928 => 16#908A#,   --  邊 (<CJK Ideograph>)
          17929 => 16#908C#,   --  邌 (<CJK Ideograph>)
          17930 => 16#908D#,   --  邍 (<CJK Ideograph>)
          17931 => 16#908E#,   --  邎 (<CJK Ideograph>)
          17932 => 16#908F#,   --  邏 (<CJK Ideograph>)
          17933 => 16#9090#,   --  邐 (<CJK Ideograph>)
          17934 => 16#9092#,   --  邒 (<CJK Ideograph>)
          17935 => 16#9094#,   --  邔 (<CJK Ideograph>)
          17936 => 16#9096#,   --  邖 (<CJK Ideograph>)
          17937 => 16#9098#,   --  邘 (<CJK Ideograph>)
          17938 => 16#909A#,   --  邚 (<CJK Ideograph>)
          17939 => 16#909C#,   --  邜 (<CJK Ideograph>)
          17940 => 16#909E#,   --  邞 (<CJK Ideograph>)
          17941 => 16#909F#,   --  邟 (<CJK Ideograph>)
          17942 => 16#90A0#,   --  邠 (<CJK Ideograph>)
          17943 => 16#90A4#,   --  邤 (<CJK Ideograph>)
          17944 => 16#90A5#,   --  邥 (<CJK Ideograph>)
          17945 => 16#90A7#,   --  邧 (<CJK Ideograph>)
          17946 => 16#90A8#,   --  邨 (<CJK Ideograph>)
          17947 => 16#90A9#,   --  邩 (<CJK Ideograph>)
          17948 => 16#90AB#,   --  邫 (<CJK Ideograph>)
          17949 => 16#90AD#,   --  邭 (<CJK Ideograph>)
          17950 => 16#90B2#,   --  邲 (<CJK Ideograph>)
          17951 => 16#90B7#,   --  邷 (<CJK Ideograph>)
          17952 => 16#90BC#,   --  邼 (<CJK Ideograph>)
          17953 => 16#90BD#,   --  邽 (<CJK Ideograph>)
          17954 => 16#90BF#,   --  邿 (<CJK Ideograph>)
          17955 => 16#90C0#,   --  郀 (<CJK Ideograph>)
          17956 => 16#647A#,   --  摺 (<CJK Ideograph>)
          17957 => 16#64B7#,   --  撷 (<CJK Ideograph>)
          17958 => 16#64B8#,   --  撸 (<CJK Ideograph>)
          17959 => 16#6499#,   --  撙 (<CJK Ideograph>)
          17960 => 16#64BA#,   --  撺 (<CJK Ideograph>)
          17961 => 16#64C0#,   --  擀 (<CJK Ideograph>)
          17962 => 16#64D0#,   --  擐 (<CJK Ideograph>)
          17963 => 16#64D7#,   --  擗 (<CJK Ideograph>)
          17964 => 16#64E4#,   --  擤 (<CJK Ideograph>)
          17965 => 16#64E2#,   --  擢 (<CJK Ideograph>)
          17966 => 16#6509#,   --  攉 (<CJK Ideograph>)
          17967 => 16#6525#,   --  攥 (<CJK Ideograph>)
          17968 => 16#652E#,   --  攮 (<CJK Ideograph>)
          17969 => 16#5F0B#,   --  弋 (<CJK Ideograph>)
          17970 => 16#5FD2#,   --  忒 (<CJK Ideograph>)
          17971 => 16#7519#,   --  甙 (<CJK Ideograph>)
          17972 => 16#5F11#,   --  弑 (<CJK Ideograph>)
          17973 => 16#535F#,   --  卟 (<CJK Ideograph>)
          17974 => 16#53F1#,   --  叱 (<CJK Ideograph>)
          17975 => 16#53FD#,   --  叽 (<CJK Ideograph>)
          17976 => 16#53E9#,   --  叩 (<CJK Ideograph>)
          17977 => 16#53E8#,   --  叨 (<CJK Ideograph>)
          17978 => 16#53FB#,   --  叻 (<CJK Ideograph>)
          17979 => 16#5412#,   --  吒 (<CJK Ideograph>)
          17980 => 16#5416#,   --  吖 (<CJK Ideograph>)
          17981 => 16#5406#,   --  吆 (<CJK Ideograph>)
          17982 => 16#544B#,   --  呋 (<CJK Ideograph>)
          17983 => 16#5452#,   --  呒 (<CJK Ideograph>)
          17984 => 16#5453#,   --  呓 (<CJK Ideograph>)
          17985 => 16#5454#,   --  呔 (<CJK Ideograph>)
          17986 => 16#5456#,   --  呖 (<CJK Ideograph>)
          17987 => 16#5443#,   --  呃 (<CJK Ideograph>)
          17988 => 16#5421#,   --  吡 (<CJK Ideograph>)
          17989 => 16#5457#,   --  呗 (<CJK Ideograph>)
          17990 => 16#5459#,   --  呙 (<CJK Ideograph>)
          17991 => 16#5423#,   --  吣 (<CJK Ideograph>)
          17992 => 16#5432#,   --  吲 (<CJK Ideograph>)
          17993 => 16#5482#,   --  咂 (<CJK Ideograph>)
          17994 => 16#5494#,   --  咔 (<CJK Ideograph>)
          17995 => 16#5477#,   --  呷 (<CJK Ideograph>)
          17996 => 16#5471#,   --  呱 (<CJK Ideograph>)
          17997 => 16#5464#,   --  呤 (<CJK Ideograph>)
          17998 => 16#549A#,   --  咚 (<CJK Ideograph>)
          17999 => 16#549B#,   --  咛 (<CJK Ideograph>)
          18000 => 16#5484#,   --  咄 (<CJK Ideograph>)
          18001 => 16#5476#,   --  呶 (<CJK Ideograph>)
          18002 => 16#5466#,   --  呦 (<CJK Ideograph>)
          18003 => 16#549D#,   --  咝 (<CJK Ideograph>)
          18004 => 16#54D0#,   --  哐 (<CJK Ideograph>)
          18005 => 16#54AD#,   --  咭 (<CJK Ideograph>)
          18006 => 16#54C2#,   --  哂 (<CJK Ideograph>)
          18007 => 16#54B4#,   --  咴 (<CJK Ideograph>)
          18008 => 16#54D2#,   --  哒 (<CJK Ideograph>)
          18009 => 16#54A7#,   --  咧 (<CJK Ideograph>)
          18010 => 16#54A6#,   --  咦 (<CJK Ideograph>)
          18011 => 16#54D3#,   --  哓 (<CJK Ideograph>)
          18012 => 16#54D4#,   --  哔 (<CJK Ideograph>)
          18013 => 16#5472#,   --  呲 (<CJK Ideograph>)
          18014 => 16#54A3#,   --  咣 (<CJK Ideograph>)
          18015 => 16#54D5#,   --  哕 (<CJK Ideograph>)
          18016 => 16#54BB#,   --  咻 (<CJK Ideograph>)
          18017 => 16#54BF#,   --  咿 (<CJK Ideograph>)
          18018 => 16#54CC#,   --  哌 (<CJK Ideograph>)
          18019 => 16#54D9#,   --  哙 (<CJK Ideograph>)
          18020 => 16#54DA#,   --  哚 (<CJK Ideograph>)
          18021 => 16#54DC#,   --  哜 (<CJK Ideograph>)
          18022 => 16#54A9#,   --  咩 (<CJK Ideograph>)
          18023 => 16#54AA#,   --  咪 (<CJK Ideograph>)
          18024 => 16#54A4#,   --  咤 (<CJK Ideograph>)
          18025 => 16#54DD#,   --  哝 (<CJK Ideograph>)
          18026 => 16#54CF#,   --  哏 (<CJK Ideograph>)
          18027 => 16#54DE#,   --  哞 (<CJK Ideograph>)
          18028 => 16#551B#,   --  唛 (<CJK Ideograph>)
          18029 => 16#54E7#,   --  哧 (<CJK Ideograph>)
          18030 => 16#5520#,   --  唠 (<CJK Ideograph>)
          18031 => 16#54FD#,   --  哽 (<CJK Ideograph>)
          18032 => 16#5514#,   --  唔 (<CJK Ideograph>)
          18033 => 16#54F3#,   --  哳 (<CJK Ideograph>)
          18034 => 16#5522#,   --  唢 (<CJK Ideograph>)
          18035 => 16#5523#,   --  唣 (<CJK Ideograph>)
          18036 => 16#550F#,   --  唏 (<CJK Ideograph>)
          18037 => 16#5511#,   --  唑 (<CJK Ideograph>)
          18038 => 16#5527#,   --  唧 (<CJK Ideograph>)
          18039 => 16#552A#,   --  唪 (<CJK Ideograph>)
          18040 => 16#5567#,   --  啧 (<CJK Ideograph>)
          18041 => 16#558F#,   --  喏 (<CJK Ideograph>)
          18042 => 16#55B5#,   --  喵 (<CJK Ideograph>)
          18043 => 16#5549#,   --  啉 (<CJK Ideograph>)
          18044 => 16#556D#,   --  啭 (<CJK Ideograph>)
          18045 => 16#5541#,   --  啁 (<CJK Ideograph>)
          18046 => 16#5555#,   --  啕 (<CJK Ideograph>)
          18047 => 16#553F#,   --  唿 (<CJK Ideograph>)
          18048 => 16#5550#,   --  啐 (<CJK Ideograph>)
          18049 => 16#553C#,   --  唼 (<CJK Ideograph>)
          18050 => 16#90C2#,   --  郂 (<CJK Ideograph>)
          18051 => 16#90C3#,   --  郃 (<CJK Ideograph>)
          18052 => 16#90C6#,   --  郆 (<CJK Ideograph>)
          18053 => 16#90C8#,   --  郈 (<CJK Ideograph>)
          18054 => 16#90C9#,   --  郉 (<CJK Ideograph>)
          18055 => 16#90CB#,   --  郋 (<CJK Ideograph>)
          18056 => 16#90CC#,   --  郌 (<CJK Ideograph>)
          18057 => 16#90CD#,   --  郍 (<CJK Ideograph>)
          18058 => 16#90