/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.GeneratorNodeExtensions;
import org.eclipse.xtext.generator.trace.node.GeneratorNodeProcessor;
import org.eclipse.xtext.generator.trace.node.GeneratorWhiteSpaceConfig;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;

public class TracingSugar
extends GeneratorNodeExtensions {
    @Inject
    protected ILocationInFileProvider locationProvider;
    @Inject
    protected ITraceURIConverter traceURIConverter;
    @Inject
    protected GeneratorWhiteSpaceConfig whiteSpaceConfig;
    @Inject
    protected GeneratorNodeProcessor processor;

    public void generateTracedFile(IFileSystemAccess2 fsa, String path, EObject rootTrace, StringConcatenationClient code) {
        CompositeGeneratorNode node = this.trace(rootTrace, code);
        this.generateTracedFile(fsa, path, node);
    }

    public void generateTracedFile(IFileSystemAccess2 fsa, String path, CompositeGeneratorNode rootNode) {
        GeneratorNodeProcessor.Result result = this.processor.process(rootNode);
        fsa.generateFile(path, result);
    }

    public CompositeGeneratorNode trace(EObject obj) {
        return this.trace(this.location(obj));
    }

    public CompositeGeneratorNode trace(EObject obj, StringConcatenationClient code) {
        return this.appendTemplate(this.trace(obj), code);
    }

    public ILocationData location(EObject obj) {
        ITextRegion region = this.locationProvider.getFullTextRegion(obj);
        SourceRelativeURI uri = this.traceURIConverter.getURIForTrace(obj.eResource());
        return new LocationData((ITextRegionWithLineInformation)region, uri);
    }

    public ILocationData location(EObject obj, EStructuralFeature feature, int idx) {
        ITextRegion region = this.locationProvider.getFullTextRegion(obj, feature, idx);
        SourceRelativeURI uri = this.traceURIConverter.getURIForTrace(obj.eResource());
        return new LocationData((ITextRegionWithLineInformation)region, uri);
    }
}

