/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import org.whispersystems.signalservice.internal.push.BodyRange;

public record TextStyle(Style style, Integer start, Integer length) {
    static TextStyle from(BodyRange bodyRange) {
        return new TextStyle(Style.fromInternal(bodyRange.style), bodyRange.start, bodyRange.length);
    }

    public BodyRange toBodyRange() {
        return new BodyRange.Builder().start(this.start()).length(this.length()).style(this.style().toBodyRangeStyle()).build();
    }

    public static enum Style {
        NONE,
        BOLD,
        ITALIC,
        SPOILER,
        STRIKETHROUGH,
        MONOSPACE;


        static Style fromInternal(BodyRange.Style style) {
            if (style == null) {
                return NONE;
            }
            return switch (style) {
                default -> throw new MatchException(null, null);
                case BodyRange.Style.NONE -> NONE;
                case BodyRange.Style.BOLD -> BOLD;
                case BodyRange.Style.ITALIC -> ITALIC;
                case BodyRange.Style.SPOILER -> SPOILER;
                case BodyRange.Style.STRIKETHROUGH -> STRIKETHROUGH;
                case BodyRange.Style.MONOSPACE -> MONOSPACE;
            };
        }

        public static Style from(String style) {
            return switch (style) {
                case "NONE" -> NONE;
                case "BOLD" -> BOLD;
                case "ITALIC" -> ITALIC;
                case "SPOILER" -> SPOILER;
                case "STRIKETHROUGH" -> STRIKETHROUGH;
                case "MONOSPACE" -> MONOSPACE;
                default -> null;
            };
        }

        BodyRange.Style toBodyRangeStyle() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> BodyRange.Style.NONE;
                case 1 -> BodyRange.Style.BOLD;
                case 2 -> BodyRange.Style.ITALIC;
                case 3 -> BodyRange.Style.SPOILER;
                case 4 -> BodyRange.Style.STRIKETHROUGH;
                case 5 -> BodyRange.Style.MONOSPACE;
            };
        }
    }
}

