/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okhttp3.Credentials;
import org.jetbrains.annotations.NotNull;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.storage.StorageAuthResponse;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.storage.protos.ReadOperation;
import org.whispersystems.signalservice.internal.storage.protos.StorageItems;
import org.whispersystems.signalservice.internal.storage.protos.StorageManifest;
import org.whispersystems.signalservice.internal.storage.protos.WriteOperation;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\nJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "getAuth", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "getStorageManifest", "Lorg/whispersystems/signalservice/internal/storage/protos/StorageManifest;", "authToken", "getStorageManifestIfDifferentVersion", "version", "", "readStorageItems", "Lorg/whispersystems/signalservice/internal/storage/protos/StorageItems;", "operation", "Lorg/whispersystems/signalservice/internal/storage/protos/ReadOperation;", "writeStorageItems", "", "writeOperation", "Lorg/whispersystems/signalservice/internal/storage/protos/WriteOperation;", "pingStorageService", "signal-service-java"})
public final class StorageServiceApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final PushServiceSocket pushServiceSocket;

    public StorageServiceApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket, @NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.authWebSocket = authWebSocket;
        this.pushServiceSocket = pushServiceSocket;
    }

    @NotNull
    public final NetworkResult<String> getAuth() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/storage/auth", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(StorageAuthResponse.class), 0L, 8, null).map(StorageServiceApi::getAuth$lambda$0);
    }

    @NotNull
    public final NetworkResult<StorageManifest> getStorageManifest(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return NetworkResult.Companion.fromFetch(() -> StorageServiceApi.getStorageManifest$lambda$1(this, authToken));
    }

    @NotNull
    public final NetworkResult<StorageManifest> getStorageManifestIfDifferentVersion(@NotNull String authToken, long version) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return NetworkResult.Companion.fromFetch(() -> StorageServiceApi.getStorageManifestIfDifferentVersion$lambda$2(this, authToken, version));
    }

    @NotNull
    public final NetworkResult<StorageItems> readStorageItems(@NotNull String authToken, @NotNull ReadOperation operation) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return NetworkResult.Companion.fromFetch(() -> StorageServiceApi.readStorageItems$lambda$3(this, authToken, operation));
    }

    @NotNull
    public final NetworkResult<Unit> writeStorageItems(@NotNull String authToken, @NotNull WriteOperation writeOperation) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)((Object)writeOperation), (String)"writeOperation");
        return NetworkResult.Companion.fromFetch(() -> StorageServiceApi.writeStorageItems$lambda$4(this, authToken, writeOperation));
    }

    @NotNull
    public final NetworkResult<Unit> pingStorageService() {
        return NetworkResult.Companion.fromFetch(() -> StorageServiceApi.pingStorageService$lambda$5(this));
    }

    private static final String getAuth$lambda$0(StorageAuthResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUsername(...)");
        String string2 = it.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPassword(...)");
        return Credentials.basic$default((String)string, (String)string2, null, (int)4, null);
    }

    private static final StorageManifest getStorageManifest$lambda$1(StorageServiceApi this$0, String $authToken) {
        StorageManifest storageManifest = this$0.pushServiceSocket.getStorageManifest($authToken);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)storageManifest), (String)"getStorageManifest(...)");
        return storageManifest;
    }

    private static final StorageManifest getStorageManifestIfDifferentVersion$lambda$2(StorageServiceApi this$0, String $authToken, long $version) {
        StorageManifest storageManifest = this$0.pushServiceSocket.getStorageManifestIfDifferentVersion($authToken, $version);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)storageManifest), (String)"getStorageManifestIfDifferentVersion(...)");
        return storageManifest;
    }

    private static final StorageItems readStorageItems$lambda$3(StorageServiceApi this$0, String $authToken, ReadOperation $operation) {
        StorageItems storageItems = this$0.pushServiceSocket.readStorageItems($authToken, $operation);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)storageItems), (String)"readStorageItems(...)");
        return storageItems;
    }

    private static final Unit writeStorageItems$lambda$4(StorageServiceApi this$0, String $authToken, WriteOperation $writeOperation) {
        this$0.pushServiceSocket.writeStorageItems($authToken, $writeOperation);
        return Unit.INSTANCE;
    }

    private static final Unit pingStorageService$lambda$5(StorageServiceApi this$0) {
        this$0.pushServiceSocket.pingStorageService();
        return Unit.INSTANCE;
    }
}

