// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// validationGL1_autogen.h:
//   Validation functions for the OpenGL Desktop GL 1.x entry points.

#ifndef LIBANGLE_VALIDATION_GL1_AUTOGEN_H_
#define LIBANGLE_VALIDATION_GL1_AUTOGEN_H_

#include "common/PackedEnums.h"

namespace gl
{
class Context;

// GL 1.0
bool ValidateAccum(const Context *context, GLenum op, GLfloat value);
bool ValidateBegin(const Context *context, GLenum mode);
bool ValidateBitmap(const Context *context,
                    GLsizei width,
                    GLsizei height,
                    GLfloat xorig,
                    GLfloat yorig,
                    GLfloat xmove,
                    GLfloat ymove,
                    const GLubyte *bitmap);
bool ValidateCallList(const Context *context, GLuint list);
bool ValidateCallLists(const Context *context, GLsizei n, GLenum type, const void *lists);
bool ValidateClearAccum(const Context *context,
                        GLfloat red,
                        GLfloat green,
                        GLfloat blue,
                        GLfloat alpha);
bool ValidateClearDepth(const Context *context, GLdouble depth);
bool ValidateClearIndex(const Context *context, GLfloat c);
bool ValidateClipPlane(const Context *context, GLenum plane, const GLdouble *equation);
bool ValidateColor3b(const Context *context, GLbyte red, GLbyte green, GLbyte blue);
bool ValidateColor3bv(const Context *context, const GLbyte *v);
bool ValidateColor3d(const Context *context, GLdouble red, GLdouble green, GLdouble blue);
bool ValidateColor3dv(const Context *context, const GLdouble *v);
bool ValidateColor3f(const Context *context, GLfloat red, GLfloat green, GLfloat blue);
bool ValidateColor3fv(const Context *context, const GLfloat *v);
bool ValidateColor3i(const Context *context, GLint red, GLint green, GLint blue);
bool ValidateColor3iv(const Context *context, const GLint *v);
bool ValidateColor3s(const Context *context, GLshort red, GLshort green, GLshort blue);
bool ValidateColor3sv(const Context *context, const GLshort *v);
bool ValidateColor3ub(const Context *context, GLubyte red, GLubyte green, GLubyte blue);
bool ValidateColor3ubv(const Context *context, const GLubyte *v);
bool ValidateColor3ui(const Context *context, GLuint red, GLuint green, GLuint blue);
bool ValidateColor3uiv(const Context *context, const GLuint *v);
bool ValidateColor3us(const Context *context, GLushort red, GLushort green, GLushort blue);
bool ValidateColor3usv(const Context *context, const GLushort *v);
bool ValidateColor4b(const Context *context, GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
bool ValidateColor4bv(const Context *context, const GLbyte *v);
bool ValidateColor4d(const Context *context,
                     GLdouble red,
                     GLdouble green,
                     GLdouble blue,
                     GLdouble alpha);
bool ValidateColor4dv(const Context *context, const GLdouble *v);
bool ValidateColor4fv(const Context *context, const GLfloat *v);
bool ValidateColor4i(const Context *context, GLint red, GLint green, GLint blue, GLint alpha);
bool ValidateColor4iv(const Context *context, const GLint *v);
bool ValidateColor4s(const Context *context,
                     GLshort red,
                     GLshort green,
                     GLshort blue,
                     GLshort alpha);
bool ValidateColor4sv(const Context *context, const GLshort *v);
bool ValidateColor4ubv(const Context *context, const GLubyte *v);
bool ValidateColor4ui(const Context *context, GLuint red, GLuint green, GLuint blue, GLuint alpha);
bool ValidateColor4uiv(const Context *context, const GLuint *v);
bool ValidateColor4us(const Context *context,
                      GLushort red,
                      GLushort green,
                      GLushort blue,
                      GLushort alpha);
bool ValidateColor4usv(const Context *context, const GLushort *v);
bool ValidateColorMaterial(const Context *context, GLenum face, GLenum mode);
bool ValidateCopyPixels(const Context *context,
                        GLint x,
                        GLint y,
                        GLsizei width,
                        GLsizei height,
                        GLenum type);
bool ValidateDeleteLists(const Context *context, GLuint list, GLsizei range);
bool ValidateDepthRange(const Context *context, GLdouble n, GLdouble f);
bool ValidateDrawBuffer(const Context *context, GLenum buf);
bool ValidateDrawPixels(const Context *context,
                        GLsizei width,
                        GLsizei height,
                        GLenum format,
                        GLenum type,
                        const void *pixels);
bool ValidateEdgeFlag(const Context *context, GLboolean flag);
bool ValidateEdgeFlagv(const Context *context, const GLboolean *flag);
bool ValidateEnd(const Context *context);
bool ValidateEndList(const Context *context);
bool ValidateEvalCoord1d(const Context *context, GLdouble u);
bool ValidateEvalCoord1dv(const Context *context, const GLdouble *u);
bool ValidateEvalCoord1f(const Context *context, GLfloat u);
bool ValidateEvalCoord1fv(const Context *context, const GLfloat *u);
bool ValidateEvalCoord2d(const Context *context, GLdouble u, GLdouble v);
bool ValidateEvalCoord2dv(const Context *context, const GLdouble *u);
bool ValidateEvalCoord2f(const Context *context, GLfloat u, GLfloat v);
bool ValidateEvalCoord2fv(const Context *context, const GLfloat *u);
bool ValidateEvalMesh1(const Context *context, GLenum mode, GLint i1, GLint i2);
bool ValidateEvalMesh2(const Context *context, GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
bool ValidateEvalPoint1(const Context *context, GLint i);
bool ValidateEvalPoint2(const Context *context, GLint i, GLint j);
bool ValidateFeedbackBuffer(const Context *context,
                            GLsizei size,
                            GLenum type,
                            const GLfloat *buffer);
bool ValidateFogi(const Context *context, GLenum pname, GLint param);
bool ValidateFogiv(const Context *context, GLenum pname, const GLint *params);
bool ValidateFrustum(const Context *context,
                     GLdouble left,
                     GLdouble right,
                     GLdouble bottom,
                     GLdouble top,
                     GLdouble zNear,
                     GLdouble zFar);
bool ValidateGenLists(const Context *context, GLsizei range);
bool ValidateGetClipPlane(const Context *context, GLenum plane, const GLdouble *equation);
bool ValidateGetDoublev(const Context *context, GLenum pname, const GLdouble *data);
bool ValidateGetLightiv(const Context *context, GLenum light, GLenum pname, const GLint *params);
bool ValidateGetMapdv(const Context *context, GLenum target, GLenum query, const GLdouble *v);
bool ValidateGetMapfv(const Context *context, GLenum target, GLenum query, const GLfloat *v);
bool ValidateGetMapiv(const Context *context, GLenum target, GLenum query, const GLint *v);
bool ValidateGetMaterialiv(const Context *context, GLenum face, GLenum pname, const GLint *params);
bool ValidateGetPixelMapfv(const Context *context, GLenum map, const GLfloat *values);
bool ValidateGetPixelMapuiv(const Context *context, GLenum map, const GLuint *values);
bool ValidateGetPixelMapusv(const Context *context, GLenum map, const GLushort *values);
bool ValidateGetPolygonStipple(const Context *context, const GLubyte *mask);
bool ValidateGetTexGendv(const Context *context,
                         GLenum coord,
                         GLenum pname,
                         const GLdouble *params);
bool ValidateGetTexGenfv(const Context *context, GLenum coord, GLenum pname, const GLfloat *params);
bool ValidateGetTexGeniv(const Context *context, GLenum coord, GLenum pname, const GLint *params);
bool ValidateGetTexImage(const Context *context,
                         TextureTarget targetPacked,
                         GLint level,
                         GLenum format,
                         GLenum type,
                         const void *pixels);
bool ValidateIndexMask(const Context *context, GLuint mask);
bool ValidateIndexd(const Context *context, GLdouble c);
bool ValidateIndexdv(const Context *context, const GLdouble *c);
bool ValidateIndexf(const Context *context, GLfloat c);
bool ValidateIndexfv(const Context *context, const GLfloat *c);
bool ValidateIndexi(const Context *context, GLint c);
bool ValidateIndexiv(const Context *context, const GLint *c);
bool ValidateIndexs(const Context *context, GLshort c);
bool ValidateIndexsv(const Context *context, const GLshort *c);
bool ValidateInitNames(const Context *context);
bool ValidateIsList(const Context *context, GLuint list);
bool ValidateLightModeli(const Context *context, GLenum pname, GLint param);
bool ValidateLightModeliv(const Context *context, GLenum pname, const GLint *params);
bool ValidateLighti(const Context *context, GLenum light, GLenum pname, GLint param);
bool ValidateLightiv(const Context *context, GLenum light, GLenum pname, const GLint *params);
bool ValidateLineStipple(const Context *context, GLint factor, GLushort pattern);
bool ValidateListBase(const Context *context, GLuint base);
bool ValidateLoadMatrixd(const Context *context, const GLdouble *m);
bool ValidateLoadName(const Context *context, GLuint name);
bool ValidateMap1d(const Context *context,
                   GLenum target,
                   GLdouble u1,
                   GLdouble u2,
                   GLint stride,
                   GLint order,
                   const GLdouble *points);
bool ValidateMap1f(const Context *context,
                   GLenum target,
                   GLfloat u1,
                   GLfloat u2,
                   GLint stride,
                   GLint order,
                   const GLfloat *points);
bool ValidateMap2d(const Context *context,
                   GLenum target,
                   GLdouble u1,
                   GLdouble u2,
                   GLint ustride,
                   GLint uorder,
                   GLdouble v1,
                   GLdouble v2,
                   GLint vstride,
                   GLint vorder,
                   const GLdouble *points);
bool ValidateMap2f(const Context *context,
                   GLenum target,
                   GLfloat u1,
                   GLfloat u2,
                   GLint ustride,
                   GLint uorder,
                   GLfloat v1,
                   GLfloat v2,
                   GLint vstride,
                   GLint vorder,
                   const GLfloat *points);
bool ValidateMapGrid1d(const Context *context, GLint un, GLdouble u1, GLdouble u2);
bool ValidateMapGrid1f(const Context *context, GLint un, GLfloat u1, GLfloat u2);
bool ValidateMapGrid2d(const Context *context,
                       GLint un,
                       GLdouble u1,
                       GLdouble u2,
                       GLint vn,
                       GLdouble v1,
                       GLdouble v2);
bool ValidateMapGrid2f(const Context *context,
                       GLint un,
                       GLfloat u1,
                       GLfloat u2,
                       GLint vn,
                       GLfloat v1,
                       GLfloat v2);
bool ValidateMateriali(const Context *context, GLenum face, GLenum pname, GLint param);
bool ValidateMaterialiv(const Context *context, GLenum face, GLenum pname, const GLint *params);
bool ValidateMultMatrixd(const Context *context, const GLdouble *m);
bool ValidateNewList(const Context *context, GLuint list, GLenum mode);
bool ValidateNormal3b(const Context *context, GLbyte nx, GLbyte ny, GLbyte nz);
bool ValidateNormal3bv(const Context *context, const GLbyte *v);
bool ValidateNormal3d(const Context *context, GLdouble nx, GLdouble ny, GLdouble nz);
bool ValidateNormal3dv(const Context *context, const GLdouble *v);
bool ValidateNormal3fv(const Context *context, const GLfloat *v);
bool ValidateNormal3i(const Context *context, GLint nx, GLint ny, GLint nz);
bool ValidateNormal3iv(const Context *context, const GLint *v);
bool ValidateNormal3s(const Context *context, GLshort nx, GLshort ny, GLshort nz);
bool ValidateNormal3sv(const Context *context, const GLshort *v);
bool ValidateOrtho(const Context *context,
                   GLdouble left,
                   GLdouble right,
                   GLdouble bottom,
                   GLdouble top,
                   GLdouble zNear,
                   GLdouble zFar);
bool ValidatePassThrough(const Context *context, GLfloat token);
bool ValidatePixelMapfv(const Context *context, GLenum map, GLsizei mapsize, const GLfloat *values);
bool ValidatePixelMapuiv(const Context *context, GLenum map, GLsizei mapsize, const GLuint *values);
bool ValidatePixelMapusv(const Context *context,
                         GLenum map,
                         GLsizei mapsize,
                         const GLushort *values);
bool ValidatePixelStoref(const Context *context, GLenum pname, GLfloat param);
bool ValidatePixelTransferf(const Context *context, GLenum pname, GLfloat param);
bool ValidatePixelTransferi(const Context *context, GLenum pname, GLint param);
bool ValidatePixelZoom(const Context *context, GLfloat xfactor, GLfloat yfactor);
bool ValidatePolygonMode(const Context *context, GLenum face, GLenum mode);
bool ValidatePolygonStipple(const Context *context, const GLubyte *mask);
bool ValidatePopAttrib(const Context *context);
bool ValidatePopName(const Context *context);
bool ValidatePushAttrib(const Context *context, GLbitfield mask);
bool ValidatePushName(const Context *context, GLuint name);
bool ValidateRasterPos2d(const Context *context, GLdouble x, GLdouble y);
bool ValidateRasterPos2dv(const Context *context, const GLdouble *v);
bool ValidateRasterPos2f(const Context *context, GLfloat x, GLfloat y);
bool ValidateRasterPos2fv(const Context *context, const GLfloat *v);
bool ValidateRasterPos2i(const Context *context, GLint x, GLint y);
bool ValidateRasterPos2iv(const Context *context, const GLint *v);
bool ValidateRasterPos2s(const Context *context, GLshort x, GLshort y);
bool ValidateRasterPos2sv(const Context *context, const GLshort *v);
bool ValidateRasterPos3d(const Context *context, GLdouble x, GLdouble y, GLdouble z);
bool ValidateRasterPos3dv(const Context *context, const GLdouble *v);
bool ValidateRasterPos3f(const Context *context, GLfloat x, GLfloat y, GLfloat z);
bool ValidateRasterPos3fv(const Context *context, const GLfloat *v);
bool ValidateRasterPos3i(const Context *context, GLint x, GLint y, GLint z);
bool ValidateRasterPos3iv(const Context *context, const GLint *v);
bool ValidateRasterPos3s(const Context *context, GLshort x, GLshort y, GLshort z);
bool ValidateRasterPos3sv(const Context *context, const GLshort *v);
bool ValidateRasterPos4d(const Context *context, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
bool ValidateRasterPos4dv(const Context *context, const GLdouble *v);
bool ValidateRasterPos4f(const Context *context, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
bool ValidateRasterPos4fv(const Context *context, const GLfloat *v);
bool ValidateRasterPos4i(const Context *context, GLint x, GLint y, GLint z, GLint w);
bool ValidateRasterPos4iv(const Context *context, const GLint *v);
bool ValidateRasterPos4s(const Context *context, GLshort x, GLshort y, GLshort z, GLshort w);
bool ValidateRasterPos4sv(const Context *context, const GLshort *v);
bool ValidateRectd(const Context *context, GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
bool ValidateRectdv(const Context *context, const GLdouble *v1, const GLdouble *v2);
bool ValidateRectf(const Context *context, GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
bool ValidateRectfv(const Context *context, const GLfloat *v1, const GLfloat *v2);
bool ValidateRecti(const Context *context, GLint x1, GLint y1, GLint x2, GLint y2);
bool ValidateRectiv(const Context *context, const GLint *v1, const GLint *v2);
bool ValidateRects(const Context *context, GLshort x1, GLshort y1, GLshort x2, GLshort y2);
bool ValidateRectsv(const Context *context, const GLshort *v1, const GLshort *v2);
bool ValidateRenderMode(const Context *context, GLenum mode);
bool ValidateRotated(const Context *context, GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
bool ValidateScaled(const Context *context, GLdouble x, GLdouble y, GLdouble z);
bool ValidateSelectBuffer(const Context *context, GLsizei size, const GLuint *buffer);
bool ValidateTexCoord1d(const Context *context, GLdouble s);
bool ValidateTexCoord1dv(const Context *context, const GLdouble *v);
bool ValidateTexCoord1f(const Context *context, GLfloat s);
bool ValidateTexCoord1fv(const Context *context, const GLfloat *v);
bool ValidateTexCoord1i(const Context *context, GLint s);
bool ValidateTexCoord1iv(const Context *context, const GLint *v);
bool ValidateTexCoord1s(const Context *context, GLshort s);
bool ValidateTexCoord1sv(const Context *context, const GLshort *v);
bool ValidateTexCoord2d(const Context *context, GLdouble s, GLdouble t);
bool ValidateTexCoord2dv(const Context *context, const GLdouble *v);
bool ValidateTexCoord2f(const Context *context, GLfloat s, GLfloat t);
bool ValidateTexCoord2fv(const Context *context, const GLfloat *v);
bool ValidateTexCoord2i(const Context *context, GLint s, GLint t);
bool ValidateTexCoord2iv(const Context *context, const GLint *v);
bool ValidateTexCoord2s(const Context *context, GLshort s, GLshort t);
bool ValidateTexCoord2sv(const Context *context, const GLshort *v);
bool ValidateTexCoord3d(const Context *context, GLdouble s, GLdouble t, GLdouble r);
bool ValidateTexCoord3dv(const Context *context, const GLdouble *v);
bool ValidateTexCoord3f(const Context *context, GLfloat s, GLfloat t, GLfloat r);
bool ValidateTexCoord3fv(const Context *context, const GLfloat *v);
bool ValidateTexCoord3i(const Context *context, GLint s, GLint t, GLint r);
bool ValidateTexCoord3iv(const Context *context, const GLint *v);
bool ValidateTexCoord3s(const Context *context, GLshort s, GLshort t, GLshort r);
bool ValidateTexCoord3sv(const Context *context, const GLshort *v);
bool ValidateTexCoord4d(const Context *context, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
bool ValidateTexCoord4dv(const Context *context, const GLdouble *v);
bool ValidateTexCoord4f(const Context *context, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
bool ValidateTexCoord4fv(const Context *context, const GLfloat *v);
bool ValidateTexCoord4i(const Context *context, GLint s, GLint t, GLint r, GLint q);
bool ValidateTexCoord4iv(const Context *context, const GLint *v);
bool ValidateTexCoord4s(const Context *context, GLshort s, GLshort t, GLshort r, GLshort q);
bool ValidateTexCoord4sv(const Context *context, const GLshort *v);
bool ValidateTexGend(const Context *context, GLenum coord, GLenum pname, GLdouble param);
bool ValidateTexGendv(const Context *context, GLenum coord, GLenum pname, const GLdouble *params);
bool ValidateTexGenf(const Context *context, GLenum coord, GLenum pname, GLfloat param);
bool ValidateTexGenfv(const Context *context, GLenum coord, GLenum pname, const GLfloat *params);
bool ValidateTexGeni(const Context *context, GLenum coord, GLenum pname, GLint param);
bool ValidateTexGeniv(const Context *context, GLenum coord, GLenum pname, const GLint *params);
bool ValidateTexImage1D(const Context *context,
                        GLenum target,
                        GLint level,
                        GLint internalformat,
                        GLsizei width,
                        GLint border,
                        GLenum format,
                        GLenum type,
                        const void *pixels);
bool ValidateTranslated(const Context *context, GLdouble x, GLdouble y, GLdouble z);
bool ValidateVertex2d(const Context *context, GLdouble x, GLdouble y);
bool ValidateVertex2dv(const Context *context, const GLdouble *v);
bool ValidateVertex2f(const Context *context, GLfloat x, GLfloat y);
bool ValidateVertex2fv(const Context *context, const GLfloat *v);
bool ValidateVertex2i(const Context *context, GLint x, GLint y);
bool ValidateVertex2iv(const Context *context, const GLint *v);
bool ValidateVertex2s(const Context *context, GLshort x, GLshort y);
bool ValidateVertex2sv(const Context *context, const GLshort *v);
bool ValidateVertex3d(const Context *context, GLdouble x, GLdouble y, GLdouble z);
bool ValidateVertex3dv(const Context *context, const GLdouble *v);
bool ValidateVertex3f(const Context *context, GLfloat x, GLfloat y, GLfloat z);
bool ValidateVertex3fv(const Context *context, const GLfloat *v);
bool ValidateVertex3i(const Context *context, GLint x, GLint y, GLint z);
bool ValidateVertex3iv(const Context *context, const GLint *v);
bool ValidateVertex3s(const Context *context, GLshort x, GLshort y, GLshort z);
bool ValidateVertex3sv(const Context *context, const GLshort *v);
bool ValidateVertex4d(const Context *context, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
bool ValidateVertex4dv(const Context *context, const GLdouble *v);
bool ValidateVertex4f(const Context *context, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
bool ValidateVertex4fv(const Context *context, const GLfloat *v);
bool ValidateVertex4i(const Context *context, GLint x, GLint y, GLint z, GLint w);
bool ValidateVertex4iv(const Context *context, const GLint *v);
bool ValidateVertex4s(const Context *context, GLshort x, GLshort y, GLshort z, GLshort w);
bool ValidateVertex4sv(const Context *context, const GLshort *v);

// GL 1.1
bool ValidateAreTexturesResident(const Context *context,
                                 GLsizei n,
                                 const GLuint *textures,
                                 const GLboolean *residences);
bool ValidateArrayElement(const Context *context, GLint i);
bool ValidateCopyTexImage1D(const Context *context,
                            GLenum target,
                            GLint level,
                            GLenum internalformat,
                            GLint x,
                            GLint y,
                            GLsizei width,
                            GLint border);
bool ValidateCopyTexSubImage1D(const Context *context,
                               GLenum target,
                               GLint level,
                               GLint xoffset,
                               GLint x,
                               GLint y,
                               GLsizei width);
bool ValidateEdgeFlagPointer(const Context *context, GLsizei stride, const void *pointer);
bool ValidateIndexPointer(const Context *context, GLenum type, GLsizei stride, const void *pointer);
bool ValidateIndexub(const Context *context, GLubyte c);
bool ValidateIndexubv(const Context *context, const GLubyte *c);
bool ValidateInterleavedArrays(const Context *context,
                               GLenum format,
                               GLsizei stride,
                               const void *pointer);
bool ValidatePopClientAttrib(const Context *context);
bool ValidatePrioritizeTextures(const Context *context,
                                GLsizei n,
                                const GLuint *textures,
                                const GLfloat *priorities);
bool ValidatePushClientAttrib(const Context *context, GLbitfield mask);
bool ValidateTexSubImage1D(const Context *context,
                           GLenum target,
                           GLint level,
                           GLint xoffset,
                           GLsizei width,
                           GLenum format,
                           GLenum type,
                           const void *pixels);

// GL 1.2

// GL 1.3
bool ValidateCompressedTexImage1D(const Context *context,
                                  GLenum target,
                                  GLint level,
                                  GLenum internalformat,
                                  GLsizei width,
                                  GLint border,
                                  GLsizei imageSize,
                                  const void *data);
bool ValidateCompressedTexSubImage1D(const Context *context,
                                     GLenum target,
                                     GLint level,
                                     GLint xoffset,
                                     GLsizei width,
                                     GLenum format,
                                     GLsizei imageSize,
                                     const void *data);
bool ValidateGetCompressedTexImage(const Context *context,
                                   GLenum target,
                                   GLint level,
                                   const void *img);
bool ValidateLoadTransposeMatrixd(const Context *context, const GLdouble *m);
bool ValidateLoadTransposeMatrixf(const Context *context, const GLfloat *m);
bool ValidateMultTransposeMatrixd(const Context *context, const GLdouble *m);
bool ValidateMultTransposeMatrixf(const Context *context, const GLfloat *m);
bool ValidateMultiTexCoord1d(const Context *context, GLenum target, GLdouble s);
bool ValidateMultiTexCoord1dv(const Context *context, GLenum target, const GLdouble *v);
bool ValidateMultiTexCoord1f(const Context *context, GLenum target, GLfloat s);
bool ValidateMultiTexCoord1fv(const Context *context, GLenum target, const GLfloat *v);
bool ValidateMultiTexCoord1i(const Context *context, GLenum target, GLint s);
bool ValidateMultiTexCoord1iv(const Context *context, GLenum target, const GLint *v);
bool ValidateMultiTexCoord1s(const Context *context, GLenum target, GLshort s);
bool ValidateMultiTexCoord1sv(const Context *context, GLenum target, const GLshort *v);
bool ValidateMultiTexCoord2d(const Context *context, GLenum target, GLdouble s, GLdouble t);
bool ValidateMultiTexCoord2dv(const Context *context, GLenum target, const GLdouble *v);
bool ValidateMultiTexCoord2f(const Context *context, GLenum target, GLfloat s, GLfloat t);
bool ValidateMultiTexCoord2fv(const Context *context, GLenum target, const GLfloat *v);
bool ValidateMultiTexCoord2i(const Context *context, GLenum target, GLint s, GLint t);
bool ValidateMultiTexCoord2iv(const Context *context, GLenum target, const GLint *v);
bool ValidateMultiTexCoord2s(const Context *context, GLenum target, GLshort s, GLshort t);
bool ValidateMultiTexCoord2sv(const Context *context, GLenum target, const GLshort *v);
bool ValidateMultiTexCoord3d(const Context *context,
                             GLenum target,
                             GLdouble s,
                             GLdouble t,
                             GLdouble r);
bool ValidateMultiTexCoord3dv(const Context *context, GLenum target, const GLdouble *v);
bool ValidateMultiTexCoord3f(const Context *context,
                             GLenum target,
                             GLfloat s,
                             GLfloat t,
                             GLfloat r);
bool ValidateMultiTexCoord3fv(const Context *context, GLenum target, const GLfloat *v);
bool ValidateMultiTexCoord3i(const Context *context, GLenum target, GLint s, GLint t, GLint r);
bool ValidateMultiTexCoord3iv(const Context *context, GLenum target, const GLint *v);
bool ValidateMultiTexCoord3s(const Context *context,
                             GLenum target,
                             GLshort s,
                             GLshort t,
                             GLshort r);
bool ValidateMultiTexCoord3sv(const Context *context, GLenum target, const GLshort *v);
bool ValidateMultiTexCoord4d(const Context *context,
                             GLenum target,
                             GLdouble s,
                             GLdouble t,
                             GLdouble r,
                             GLdouble q);
bool ValidateMultiTexCoord4dv(const Context *context, GLenum target, const GLdouble *v);
bool ValidateMultiTexCoord4fv(const Context *context, GLenum target, const GLfloat *v);
bool ValidateMultiTexCoord4i(const Context *context,
                             GLenum target,
                             GLint s,
                             GLint t,
                             GLint r,
                             GLint q);
bool ValidateMultiTexCoord4iv(const Context *context, GLenum target, const GLint *v);
bool ValidateMultiTexCoord4s(const Context *context,
                             GLenum target,
                             GLshort s,
                             GLshort t,
                             GLshort r,
                             GLshort q);
bool ValidateMultiTexCoord4sv(const Context *context, GLenum target, const GLshort *v);

// GL 1.4
bool ValidateFogCoordPointer(const Context *context,
                             GLenum type,
                             GLsizei stride,
                             const void *pointer);
bool ValidateFogCoordd(const Context *context, GLdouble coord);
bool ValidateFogCoorddv(const Context *context, const GLdouble *coord);
bool ValidateFogCoordf(const Context *context, GLfloat coord);
bool ValidateFogCoordfv(const Context *context, const GLfloat *coord);
bool ValidateMultiDrawArrays(const Context *context,
                             PrimitiveMode modePacked,
                             const GLint *first,
                             const GLsizei *count,
                             GLsizei drawcount);
bool ValidateMultiDrawElements(const Context *context,
                               PrimitiveMode modePacked,
                               const GLsizei *count,
                               DrawElementsType typePacked,
                               const void *const *indices,
                               GLsizei drawcount);
bool ValidatePointParameteri(const Context *context, GLenum pname, GLint param);
bool ValidatePointParameteriv(const Context *context, GLenum pname, const GLint *params);
bool ValidateSecondaryColor3b(const Context *context, GLbyte red, GLbyte green, GLbyte blue);
bool ValidateSecondaryColor3bv(const Context *context, const GLbyte *v);
bool ValidateSecondaryColor3d(const Context *context, GLdouble red, GLdouble green, GLdouble blue);
bool ValidateSecondaryColor3dv(const Context *context, const GLdouble *v);
bool ValidateSecondaryColor3f(const Context *context, GLfloat red, GLfloat green, GLfloat blue);
bool ValidateSecondaryColor3fv(const Context *context, const GLfloat *v);
bool ValidateSecondaryColor3i(const Context *context, GLint red, GLint green, GLint blue);
bool ValidateSecondaryColor3iv(const Context *context, const GLint *v);
bool ValidateSecondaryColor3s(const Context *context, GLshort red, GLshort green, GLshort blue);
bool ValidateSecondaryColor3sv(const Context *context, const GLshort *v);
bool ValidateSecondaryColor3ub(const Context *context, GLubyte red, GLubyte green, GLubyte blue);
bool ValidateSecondaryColor3ubv(const Context *context, const GLubyte *v);
bool ValidateSecondaryColor3ui(const Context *context, GLuint red, GLuint green, GLuint blue);
bool ValidateSecondaryColor3uiv(const Context *context, const GLuint *v);
bool ValidateSecondaryColor3us(const Context *context, GLushort red, GLushort green, GLushort blue);
bool ValidateSecondaryColor3usv(const Context *context, const GLushort *v);
bool ValidateSecondaryColorPointer(const Context *context,
                                   GLint size,
                                   GLenum type,
                                   GLsizei stride,
                                   const void *pointer);
bool ValidateWindowPos2d(const Context *context, GLdouble x, GLdouble y);
bool ValidateWindowPos2dv(const Context *context, const GLdouble *v);
bool ValidateWindowPos2f(const Context *context, GLfloat x, GLfloat y);
bool ValidateWindowPos2fv(const Context *context, const GLfloat *v);
bool ValidateWindowPos2i(const Context *context, GLint x, GLint y);
bool ValidateWindowPos2iv(const Context *context, const GLint *v);
bool ValidateWindowPos2s(const Context *context, GLshort x, GLshort y);
bool ValidateWindowPos2sv(const Context *context, const GLshort *v);
bool ValidateWindowPos3d(const Context *context, GLdouble x, GLdouble y, GLdouble z);
bool ValidateWindowPos3dv(const Context *context, const GLdouble *v);
bool ValidateWindowPos3f(const Context *context, GLfloat x, GLfloat y, GLfloat z);
bool ValidateWindowPos3fv(const Context *context, const GLfloat *v);
bool ValidateWindowPos3i(const Context *context, GLint x, GLint y, GLint z);
bool ValidateWindowPos3iv(const Context *context, const GLint *v);
bool ValidateWindowPos3s(const Context *context, GLshort x, GLshort y, GLshort z);
bool ValidateWindowPos3sv(const Context *context, const GLshort *v);

// GL 1.5
bool ValidateGetBufferSubData(const Context *context,
                              GLenum target,
                              GLintptr offset,
                              GLsizeiptr size,
                              const void *data);
bool ValidateGetQueryObjectiv(const Context *context,
                              QueryID idPacked,
                              GLenum pname,
                              const GLint *params);
bool ValidateMapBuffer(const Context *context, BufferBinding targetPacked, GLenum access);
}  // namespace gl

#endif  // LIBANGLE_VALIDATION_GL1_AUTOGEN_H_
