/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;

public class AudioInputStream
extends InputStream {
    private InputStream stream;
    protected AudioFormat format;
    protected long frameLength;
    protected int frameSize;
    protected long framePos;
    private long markpos;
    private byte[] pushBackBuffer = null;
    private int pushBackLen = 0;
    private byte[] markPushBackBuffer = null;
    private int markPushBackLen = 0;

    public AudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l) {
        this.format = audioFormat;
        this.frameLength = l;
        this.frameSize = audioFormat.getFrameSize();
        if (this.frameSize == -1 || this.frameSize <= 0) {
            this.frameSize = 1;
        }
        this.stream = inputStream;
        this.framePos = 0L;
        this.markpos = 0L;
    }

    public AudioInputStream(TargetDataLine targetDataLine) {
        TargetDataLineInputStream targetDataLineInputStream = new TargetDataLineInputStream(targetDataLine);
        this.format = targetDataLine.getFormat();
        this.frameLength = -1L;
        this.frameSize = this.format.getFrameSize();
        if (this.frameSize == -1 || this.frameSize <= 0) {
            this.frameSize = 1;
        }
        this.stream = targetDataLineInputStream;
        this.framePos = 0L;
        this.markpos = 0L;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    @Override
    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("cannot read a single byte if frame size > 1");
        }
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n <= 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 % this.frameSize != 0 && (n2 -= n2 % this.frameSize) == 0) {
            return 0;
        }
        if (this.frameLength != -1L) {
            if (this.framePos >= this.frameLength) {
                return -1;
            }
            if ((long)(n2 / this.frameSize) > this.frameLength - this.framePos) {
                n2 = (int)(this.frameLength - this.framePos) * this.frameSize;
            }
        }
        int n4 = 0;
        int n5 = n;
        if (this.pushBackLen > 0 && n2 >= this.pushBackLen) {
            System.arraycopy(this.pushBackBuffer, 0, byArray, n, this.pushBackLen);
            n5 += this.pushBackLen;
            n2 -= this.pushBackLen;
            n4 += this.pushBackLen;
            this.pushBackLen = 0;
        }
        if ((n3 = this.stream.read(byArray, n5, n2)) == -1) {
            return -1;
        }
        if (n3 > 0) {
            n4 += n3;
        }
        if (n4 > 0) {
            this.pushBackLen = n4 % this.frameSize;
            if (this.pushBackLen > 0) {
                if (this.pushBackBuffer == null) {
                    this.pushBackBuffer = new byte[this.frameSize];
                }
                System.arraycopy(byArray, n + n4 - this.pushBackLen, this.pushBackBuffer, 0, this.pushBackLen);
                n4 -= this.pushBackLen;
            }
            this.framePos += (long)(n4 / this.frameSize);
        }
        return n4;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2;
        if (l % (long)this.frameSize != 0L) {
            l -= l % (long)this.frameSize;
        }
        if (this.frameLength != -1L && l / (long)this.frameSize > this.frameLength - this.framePos) {
            l = (this.frameLength - this.framePos) * (long)this.frameSize;
        }
        if ((l2 = this.stream.skip(l)) % (long)this.frameSize != 0L) {
            throw new IOException("Could not skip an integer number of frames.");
        }
        if (l2 >= 0L) {
            this.framePos += l2 / (long)this.frameSize;
        }
        return l2;
    }

    @Override
    public int available() throws IOException {
        int n = this.stream.available();
        if (this.frameLength != -1L && (long)(n / this.frameSize) > this.frameLength - this.framePos) {
            return (int)(this.frameLength - this.framePos) * this.frameSize;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void mark(int n) {
        this.stream.mark(n);
        if (this.markSupported()) {
            this.markpos = this.framePos;
            this.markPushBackLen = this.pushBackLen;
            if (this.markPushBackLen > 0) {
                if (this.markPushBackBuffer == null) {
                    this.markPushBackBuffer = new byte[this.frameSize];
                }
                System.arraycopy(this.pushBackBuffer, 0, this.markPushBackBuffer, 0, this.markPushBackLen);
            }
        }
    }

    @Override
    public void reset() throws IOException {
        this.stream.reset();
        this.framePos = this.markpos;
        this.pushBackLen = this.markPushBackLen;
        if (this.pushBackLen > 0) {
            if (this.pushBackBuffer == null) {
                this.pushBackBuffer = new byte[this.frameSize - 1];
            }
            System.arraycopy(this.markPushBackBuffer, 0, this.pushBackBuffer, 0, this.pushBackLen);
        }
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    private class TargetDataLineInputStream
    extends InputStream {
        TargetDataLine line;

        TargetDataLineInputStream(TargetDataLine targetDataLine) {
            this.line = targetDataLine;
        }

        @Override
        public int available() throws IOException {
            return this.line.available();
        }

        @Override
        public void close() throws IOException {
            if (this.line.isActive()) {
                this.line.flush();
                this.line.stop();
            }
            this.line.close();
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == -1) {
                return -1;
            }
            n = byArray[0];
            if (this.line.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                n += 128;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                return this.line.read(byArray, n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        }
    }
}

