/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.cli.CLIException;
import org.jkiss.dbeaver.model.cli.CommandLineContext;
import org.jkiss.dbeaver.model.cli.model.option.DataSourceAuthOptions;
import org.jkiss.dbeaver.model.cli.model.option.DataSourceOptions;
import org.jkiss.dbeaver.model.cli.model.option.InputFileOption;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.PropertySerializationUtils;
import org.jkiss.utils.CommonUtils;

public class CLIUtils {
    private static final Log log = Log.getLog(CLIUtils.class);

    @Nullable
    public static String readValueFromFileOrSystemIn(@Nullable InputFileOption filesOptions) throws CLIException {
        String value = null;
        if (filesOptions == null || filesOptions.getInputFile() == null) {
            value = CLIUtils.tryReadFromSystemIn();
        } else if (filesOptions.getInputFile() != null) {
            if (Files.notExists(filesOptions.getInputFile(), new LinkOption[0])) {
                throw new CLIException("Input file does not exist: " + String.valueOf(filesOptions.getInputFile()), 2);
            }
            try {
                value = Files.readString(filesOptions.getInputFile());
            }
            catch (IOException e) {
                throw new CLIException("Error reading GQL from input file: " + String.valueOf(filesOptions.getInputFile()), e, 1);
            }
        }
        return value;
    }

    @Nullable
    private static String tryReadFromSystemIn() {
        try {
            if (System.in.available() > 0) {
                return new String(System.in.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading from system in", (Throwable)e);
            return null;
        }
        return null;
    }

    @NotNull
    public static DBPProject findProject(@Nullable String projectIdOrName, @NotNull CommandLineContext context) throws CLIException {
        DBPProject project;
        DBPWorkspace workspace = (DBPWorkspace)context.getContextParameter(DBPWorkspace.class.getName());
        if (workspace == null) {
            workspace = DBWorkbench.getPlatform().getWorkspace();
        }
        if (CommonUtils.isEmpty((String)projectIdOrName)) {
            project = workspace.getActiveProject();
        } else {
            project = workspace.getProject(projectIdOrName);
            if (project == null) {
                project = workspace.getProjectById(projectIdOrName);
            }
        }
        if (project == null) {
            throw new CLIException("Can't find project '" + projectIdOrName + "'", 2);
        }
        return project;
    }

    @NotNull
    public static DBPDataSourceContainer findDataSource(@NotNull DBPProject project, @NotNull String existConnectionIdOrName) throws CLIException {
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        DBPDataSourceContainer container = registry.getDataSource(existConnectionIdOrName);
        if (container == null) {
            container = registry.findDataSourceByName(existConnectionIdOrName);
        }
        if (container == null) {
            throw new CLIException("Can't find connection '" + existConnectionIdOrName + "'", 2);
        }
        return container;
    }

    @NotNull
    public static DBPDataSourceContainer createTempDataSource(@NotNull DBPProject project, @NotNull String driverId, @NotNull DataSourceOptions dataSourceOptions, @NotNull DataSourceAuthOptions authOptions) throws CLIException {
        DBPDataSourceContainer tempDatasource = CLIUtils.createDataSource(project, driverId, dataSourceOptions, authOptions, true);
        CLIUtils.processDataSourceAuthOptions(tempDatasource, authOptions);
        return tempDatasource;
    }

    @NotNull
    public static DBPDataSourceContainer createDataSource(@NotNull DBPProject project, @NotNull String driverId, @NotNull DataSourceOptions dataSourceOptions, @NotNull DataSourceAuthOptions authOptions, boolean temporary) throws CLIException {
        DBPDriver driver = DBWorkbench.getPlatform().getDataSourceProviderRegistry().findDriver(driverId);
        if (driver == null) {
            throw new CLIException("Can't find driver '" + driverId + "'", 2);
        }
        DBPConnectionConfiguration connectionConfiguration = CLIUtils.updateConnectionConfiguration(dataSourceOptions, new DBPConnectionConfiguration());
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        DBPDataSourceContainer dataSource = registry.createDataSource(driver, connectionConfiguration);
        CLIUtils.updateDataSource(dataSourceOptions, authOptions, dataSource);
        dataSource.setTemporary(temporary);
        try {
            registry.addDataSource(dataSource);
        }
        catch (Exception e) {
            log.error((Object)"Error adding datasource", (Throwable)e);
        }
        return dataSource;
    }

    public static void updateDataSource(@NotNull DataSourceOptions dataSourceOptions, @NotNull DataSourceAuthOptions authOptions, @NotNull DBPDataSourceContainer dataSource) throws CLIException {
        DBPDataSourceFolder folder;
        Object dsName = dataSourceOptions.getDatasourceName();
        if (CommonUtils.isEmpty((String)dsName)) {
            dsName = "Ext: " + dataSource.getDriver().getName();
            if (CommonUtils.isNotEmpty((String)dataSourceOptions.getDbName())) {
                dsName = (String)dsName + " - " + dataSourceOptions.getDbName();
            } else if (CommonUtils.isNotEmpty((String)dataSourceOptions.getServer())) {
                dsName = (String)dsName + " - " + dataSourceOptions.getServer();
            }
        }
        if (CommonUtils.isNotEmpty((String)dataSourceOptions.getDatasourceName())) {
            dataSource.setName((String)dsName);
        }
        if (CommonUtils.isNotEmpty((String)dataSourceOptions.getFolder()) && (folder = dataSource.getRegistry().getFolder(dataSourceOptions.getFolder())) != null) {
            dataSource.setFolder(folder);
        }
        dataSource.setSavePassword(dataSourceOptions.isSavePassword());
        CLIUtils.processDataSourceAuthOptions(dataSource, authOptions);
    }

    @NotNull
    public static DBPConnectionConfiguration updateConnectionConfiguration(@NotNull DataSourceOptions dataSourceOptions, @NotNull DBPConnectionConfiguration connectionConfiguration) {
        connectionConfiguration.setUrl(dataSourceOptions.getUrl());
        connectionConfiguration.setHostName(dataSourceOptions.getHost());
        connectionConfiguration.setHostPort(dataSourceOptions.getPort() == null ? null : dataSourceOptions.getPort().toString());
        connectionConfiguration.setServerName(dataSourceOptions.getServer());
        connectionConfiguration.setDatabaseName(dataSourceOptions.getDbName());
        if (!CommonUtils.isEmpty((String)dataSourceOptions.getAuthModel())) {
            connectionConfiguration.setAuthModelId(dataSourceOptions.getAuthModel());
        }
        return connectionConfiguration;
    }

    @NotNull
    public static Map<String, String> prepareKeyValueParams(@Nullable Map<String, String> parentParams, @NotNull List<String> cliParams) throws CLIException {
        LinkedHashMap<String, String> properties = parentParams == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(parentParams);
        for (String authParam : cliParams) {
            String[] paramParts = authParam.split("=", 2);
            if (paramParts.length == 2) {
                String paramName = paramParts[0].trim();
                String paramValue = paramParts[1].trim();
                if (!CommonUtils.isNotEmpty((String)paramName) || !CommonUtils.isNotEmpty((String)paramValue)) continue;
                properties.put(paramName, paramValue);
                continue;
            }
            throw new CLIException("Invalid auth-param format: " + authParam, 2);
        }
        return properties;
    }

    public static void processDataSourceAuthOptions(@NotNull DBPDataSourceContainer dataSource, @NotNull DataSourceAuthOptions authOptions) throws CLIException {
        Map<String, String> authProperties;
        DBPConnectionConfiguration connectionConfiguration = dataSource.getConnectionConfiguration();
        if (CommonUtils.isNotEmpty((String)authOptions.getDbUser())) {
            connectionConfiguration.setUserName(authOptions.getDbUser());
        }
        if (CommonUtils.isNotEmpty((String)authOptions.getDbPassword())) {
            connectionConfiguration.setUserPassword(authOptions.getDbPassword());
        }
        if (!CommonUtils.isEmpty(authOptions.getConnectionParams())) {
            connectionConfiguration.setProperties(CLIUtils.prepareKeyValueParams(connectionConfiguration.getProperties(), authOptions.getConnectionParams()));
        }
        if (!CommonUtils.isEmpty(authOptions.getProviderParams())) {
            connectionConfiguration.setProviderProperties(CLIUtils.prepareKeyValueParams(connectionConfiguration.getProviderProperties(), authOptions.getProviderParams()));
        }
        if (!CommonUtils.isEmpty(authOptions.getAuthParams()) && !CommonUtils.isEmpty(authProperties = CLIUtils.prepareKeyValueParams(connectionConfiguration.getAuthProperties(), authOptions.getAuthParams()))) {
            DBAAuthCredentials credentialsInstance = connectionConfiguration.getAuthModel().loadCredentials(dataSource, connectionConfiguration);
            PropertySerializationUtils.updateCredentialsFromProperties((DBRProgressMonitor)new LoggingProgressMonitor(), (DBAAuthCredentials)credentialsInstance, authProperties);
            dataSource.getConnectionConfiguration().getAuthModel().provideCredentials(dataSource, dataSource.getConnectionConfiguration(), credentialsInstance);
        }
    }
}

