/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;

class BufferedGraphicsSource
implements GraphicsSource {
    private Image imageBuffer;
    private GC imageGC;
    private GC controlGC;
    private final Control control;
    private Rectangle inUse;

    public BufferedGraphicsSource(Control c) {
        this.control = c;
    }

    @Override
    public void flushGraphics(Rectangle region) {
        if (this.inUse.isEmpty()) {
            return;
        }
        boolean restoreCaret = false;
        Canvas canvas = null;
        if (this.control instanceof Canvas) {
            canvas = (Canvas)this.control;
            Caret caret = canvas.getCaret();
            if (caret != null) {
                restoreCaret = caret.isVisible();
            }
            if (restoreCaret) {
                caret.setVisible(false);
            }
        }
        if (this.imageBuffer != null) {
            this.imageGC.dispose();
            this.controlGC.drawImage(this.getImage(), 0, 0, this.inUse.width, this.inUse.height, this.inUse.x, this.inUse.y, this.inUse.width, this.inUse.height);
            this.imageBuffer.dispose();
            this.imageBuffer = null;
            this.imageGC = null;
        }
        this.controlGC.dispose();
        this.controlGC = null;
        if (restoreCaret) {
            canvas.getCaret().setVisible(true);
        }
    }

    @Override
    public Graphics getGraphics(Rectangle region) {
        SWTGraphics graphics;
        if (this.control == null || this.control.isDisposed()) {
            return null;
        }
        Point ptSWT = this.control.getSize();
        this.inUse = new Rectangle(0, 0, ptSWT.x, ptSWT.y);
        this.inUse.intersect(region);
        if (this.inUse.isEmpty()) {
            return null;
        }
        try {
            this.imageBuffer = new Image(null, this.inUse.width, this.inUse.height);
        }
        catch (SWTError noMoreHandles) {
            this.imageBuffer = null;
        }
        catch (IllegalArgumentException tooBig) {
            this.imageBuffer = null;
        }
        this.controlGC = new GC((Drawable)this.control, this.control.getStyle() & 0x6000000);
        if (this.imageBuffer != null) {
            this.imageGC = new GC((Drawable)this.imageBuffer, this.control.getStyle() & 0x6000000);
            this.imageGC.setBackground(this.controlGC.getBackground());
            this.imageGC.setForeground(this.controlGC.getForeground());
            this.imageGC.setFont(this.controlGC.getFont());
            this.imageGC.setLineStyle(this.controlGC.getLineStyle());
            this.imageGC.setLineWidth(this.controlGC.getLineWidth());
            this.imageGC.setXORMode(this.controlGC.getXORMode());
            graphics = new SWTGraphics(this.imageGC);
            graphics.translate(this.inUse.getLocation().negate());
        } else {
            graphics = new SWTGraphics(this.controlGC);
        }
        ((Graphics)graphics).setClip(this.inUse);
        return graphics;
    }

    protected Image getImage() {
        return this.imageBuffer;
    }

    protected GC getImageGC() {
        return this.imageGC;
    }
}

