/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.utils;

import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\n\u001a\u00020\u0007*\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/utils/JupyterUrlUtils;", "", "<init>", "()V", "validateUrl", "", "url", "", "convertToUrlObject", "Ljava/net/URL;", "cleanUrlHttpPrefix", "intellij.jupyter.core"})
public final class JupyterUrlUtils {
    @NotNull
    public static final JupyterUrlUtils INSTANCE = new JupyterUrlUtils();

    private JupyterUrlUtils() {
    }

    @Nullable
    public final Throwable validateUrl(@NotNull String url) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            this.convertToUrlObject(url);
            throwable = null;
        }
        catch (Throwable t) {
            throwable = t;
        }
        return throwable;
    }

    @NotNull
    public final URL convertToUrlObject(@NotNull String url) throws URISyntaxException, MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String cleanString = StringsKt.removeSuffix((String)this.cleanUrlHttpPrefix(((Object)StringsKt.trim((CharSequence)url)).toString()), (CharSequence)"/");
        if (StringsKt.isBlank((CharSequence)cleanString)) {
            throw new MalformedURLException(JupyterRemoteBundle.message("jupyter.url.validation.should.not.be.empty", new Object[0]));
        }
        new URI(cleanString);
        URL urlObject = new URL(cleanString);
        String string = urlObject.getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProtocol(...)");
        if (((CharSequence)string).length() == 0) {
            urlObject = new URL("http", urlObject.getHost(), urlObject.getPort(), urlObject.getFile());
        }
        if (!Intrinsics.areEqual((Object)urlObject.getProtocol(), (Object)"http") && !Intrinsics.areEqual((Object)urlObject.getProtocol(), (Object)"https")) {
            throw new MalformedURLException("Protocol should be http or https");
        }
        if (urlObject.getPort() == -1) {
            int port = Intrinsics.areEqual((Object)urlObject.getProtocol(), (Object)"https") ? 443 : 80;
            urlObject = new URL(urlObject.getProtocol(), urlObject.getHost(), port, urlObject.getFile(), null);
        }
        return urlObject;
    }

    private final String cleanUrlHttpPrefix(String $this$cleanUrlHttpPrefix) {
        return StringsKt.isBlank((CharSequence)$this$cleanUrlHttpPrefix) ? "" : (StringsKt.contains$default((CharSequence)$this$cleanUrlHttpPrefix, (CharSequence)"://", (boolean)false, (int)2, null) ? $this$cleanUrlHttpPrefix : "http://" + $this$cleanUrlHttpPrefix);
    }
}

