/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light;

import com.intellij.json.JsonFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "load", "Lcom/intellij/openapi/vfs/VirtualFile;", "Bundled", "Remote", "Lcom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary$Bundled;", "Lcom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary$Remote;", "intellij.json.backend"})
public abstract class StandardJsonSchemaVocabulary {
    @NotNull
    private final String id;

    private StandardJsonSchemaVocabulary(String id) {
        this.id = id;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public abstract VirtualFile load();

    public /* synthetic */ StandardJsonSchemaVocabulary(String id, DefaultConstructorMarker $constructor_marker) {
        this(id);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary$Bundled;", "Lcom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary;", "id", "", "remoteUrl", "resourcePath", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getRemoteUrl", "()Ljava/lang/String;", "getResourcePath", "loadedVocabularyFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLoadedVocabularyFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "loadedVocabularyFile$delegate", "Lkotlin/Lazy;", "load", "loadBundledSchemaUnsafe", "Lcom/intellij/testFramework/LightVirtualFile;", "intellij.json.backend"})
    @SourceDebugExtension(value={"SMAP\njsonSchemaVocabularyResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jsonSchemaVocabularyResolver.kt\ncom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary$Bundled\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,98:1\n1#2:99\n24#3:100\n*S KotlinDebug\n*F\n+ 1 jsonSchemaVocabularyResolver.kt\ncom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary$Bundled\n*L\n64#1:100\n*E\n"})
    public static final class Bundled
    extends StandardJsonSchemaVocabulary {
        @NotNull
        private final String remoteUrl;
        @NotNull
        private final String resourcePath;
        @NotNull
        private final Lazy loadedVocabularyFile$delegate;

        public Bundled(@NotNull String id, @NotNull String remoteUrl, @NotNull String resourcePath) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)remoteUrl, (String)"remoteUrl");
            Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
            super(id, null);
            this.remoteUrl = remoteUrl;
            this.resourcePath = resourcePath;
            this.loadedVocabularyFile$delegate = LazyKt.lazy(() -> Bundled.loadedVocabularyFile_delegate$lambda$0(this));
        }

        @NotNull
        public final String getRemoteUrl() {
            return this.remoteUrl;
        }

        @NotNull
        public final String getResourcePath() {
            return this.resourcePath;
        }

        private final VirtualFile getLoadedVocabularyFile() {
            Lazy lazy = this.loadedVocabularyFile$delegate;
            return (VirtualFile)lazy.getValue();
        }

        @Override
        @Nullable
        public VirtualFile load() {
            return this.getLoadedVocabularyFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final LightVirtualFile loadBundledSchemaUnsafe() {
            Object p0;
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.resourcePath);
            if (inputStream == null) return null;
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                p0 = (InputStream)closeable;
                boolean bl = false;
                p0 = FileUtil.loadTextAndClose((InputStream)p0);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object object = p0;
            if (object == null) return null;
            Object schemaText = object;
            boolean bl = false;
            String schemaName = StringsKt.substringAfterLast$default((String)this.resourcePath, (String)"/", null, (int)2, null) + ".json";
            LightVirtualFile lightVirtualFile = new LightVirtualFile(schemaName, (FileType)JsonFileType.INSTANCE, (CharSequence)schemaText);
            return lightVirtualFile;
        }

        private static final LightVirtualFile loadedVocabularyFile_delegate$lambda$0(Bundled this$0) {
            LightVirtualFile lightVirtualFile;
            try {
                lightVirtualFile = this$0.loadBundledSchemaUnsafe();
            }
            catch (IOException exception) {
                Bundled $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Bundled.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unable to load bundled schema for vocabulary", (Throwable)exception);
                lightVirtualFile = null;
            }
            return lightVirtualFile;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary$Remote;", "Lcom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary;", "id", "", "url", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "load", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.json.backend"})
    @SourceDebugExtension(value={"SMAP\njsonSchemaVocabularyResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jsonSchemaVocabularyResolver.kt\ncom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary$Remote\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,98:1\n24#2:99\n*S KotlinDebug\n*F\n+ 1 jsonSchemaVocabularyResolver.kt\ncom/jetbrains/jsonSchema/impl/light/StandardJsonSchemaVocabulary$Remote\n*L\n91#1:99\n*E\n"})
    public static final class Remote
    extends StandardJsonSchemaVocabulary {
        @NotNull
        private final String url;

        public Remote(@NotNull String id, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(id, null);
            this.url = url;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Override
        @Nullable
        public VirtualFile load() {
            URL uRL;
            try {
                uRL = new URL(this.url);
            }
            catch (MalformedURLException exception) {
                Remote $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Remote.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unable to parse URL for json schema vocabulary", (Throwable)exception);
                return null;
            }
            URL remoteSchemaUrl = uRL;
            return VfsUtil.findFileByURL((URL)remoteSchemaUrl);
        }
    }
}

