/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.userauth.keyprovider.PuTTYSecretKeyDerivationFunction;
import net.schmizz.sshj.userauth.password.PasswordUtils;

class V1PuTTYSecretKeyDerivationFunction
implements PuTTYSecretKeyDerivationFunction {
    private static final String SECRET_KEY_ALGORITHM = "AES";
    private static final String DIGEST_ALGORITHM = "SHA-1";

    V1PuTTYSecretKeyDerivationFunction() {
    }

    @Override
    public SecretKey deriveSecretKey(char[] passphrase) {
        Objects.requireNonNull(passphrase, "Passphrase required");
        MessageDigest digest = this.getMessageDigest();
        byte[] encodedPassphrase = PasswordUtils.toByteArray(passphrase);
        digest.update(new byte[]{0, 0, 0, 0});
        digest.update(encodedPassphrase);
        byte[] key1 = digest.digest();
        digest.update(new byte[]{0, 0, 0, 1});
        digest.update(encodedPassphrase);
        byte[] key2 = digest.digest();
        Arrays.fill(encodedPassphrase, (byte)0);
        byte[] secretKeyEncoded = new byte[32];
        System.arraycopy(key1, 0, secretKeyEncoded, 0, 20);
        System.arraycopy(key2, 0, secretKeyEncoded, 20, 12);
        return new SecretKeySpec(secretKeyEncoded, SECRET_KEY_ALGORITHM);
    }

    private MessageDigest getMessageDigest() {
        try {
            return SecurityUtils.getMessageDigest(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            String message = String.format("Message Digest Algorithm [%s] not supported", DIGEST_ALGORITHM);
            throw new IllegalStateException(message, e);
        }
    }
}

