/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_blo extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Griinwish kaakɔŋkɔŋɔ̀",
               "Gk",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apiya kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Apiya kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Apiya kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Cook = new String[] {
               "Kʊkʊ kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Kʊkʊ kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Kʊkʊ kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubaa kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "CST",
               "Kubaa kaakɔŋkɔŋɔ̀ gafʊbaka",
               "CDT",
               "Kubaa kaakɔŋkɔŋɔ̀",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Fiji kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Fiji kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Gulf = new String[] {
               "Gɔlf kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hɔfɖǝ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Hɔfɖǝ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Hɔfɖǝ kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Iran = new String[] {
               "Iraŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Iraŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Iraŋ kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Niue = new String[] {
               "Niwuye kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ɔmsǝkǝ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Ɔmsǝkǝ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Ɔmsǝkǝ kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Peru = new String[] {
               "Peruu kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Peruu kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Peruu kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Truk = new String[] {
               "Cuuk kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Week kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Shilii kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Shilii kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Shilii kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] China = new String[] {
               "Caɩna kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "CST",
               "Caɩna kaakɔŋkɔŋɔ̀ gafʊbaka",
               "CDT",
               "Caɩna kaakɔŋkɔŋɔ̀",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokoos kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Ɖefis kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Inɖiya kaakɔŋkɔŋɔ̀",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japaŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "JST",
               "Japaŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "JDT",
               "Japaŋ kaakɔŋkɔŋɔ̀",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koree kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "KST",
               "Koree kaakɔŋkɔŋɔ̀ gafʊbaka",
               "KST",
               "Koree kaakɔŋkɔŋɔ̀",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nawuru kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Neepal kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palawoo kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samowa kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "SST",
               "Samowa kaakɔŋkɔŋɔ̀ gafʊbaka",
               "SST",
               "Samowa kaakɔŋkɔŋɔ̀",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Siyowaa kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tɔŋga kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Tɔŋga kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Tɔŋga kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukɔn kaakɔŋkɔŋɔ̀",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaskaa kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "AKST",
               "Alaskaa kaakɔŋkɔŋɔ̀ gafʊbaka",
               "AKDT",
               "Alaskaa kaakɔŋkɔŋɔ̀",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amasɔn kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Amasɔn kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Amasɔn kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Azores = new String[] {
               "Asɔɔr kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Asɔɔr kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Asɔɔr kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunɛɩ Ɖarusalaam kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Paakɩ kaAtukǝltǝna kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Paakɩ kaAtukǝltǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Paakɩ kaAatukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyanaa kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Yishraɛl kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "IST",
               "Yishraɛl kaakɔŋkɔŋɔ̀ gafʊbaka",
               "IDT",
               "Yishraɛl kaakɔŋkɔŋɔ̀",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kɔsrɛɛ kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mɔsɔn kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskuu kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "MSK",
               "Moskuu kaakɔŋkɔŋɔ̀ gafʊbaka",
               "MSK",
               "Moskuu kaakɔŋkɔŋɔ̀",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponapee kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitii kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taɩpei kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "CST",
               "Taɩpei kaakɔŋkɔŋɔ̀ gafʊbaka",
               "CDT",
               "Taɩpei kaakɔŋkɔŋɔ̀",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tufalu kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Fɔstɔk kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Walis na Futuna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Galaaributǝna kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Galaaributǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Galaaributǝna kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenii kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Armenii kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Armenii kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolifiya kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Shatam kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Shatam kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Shatam kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Ɖulinya aŋunii kaakɔŋkɔŋɔ̀",
               "ƉAK",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekuwaɖɔɔr kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiyee kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Jɔrjiya kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Jɔrjiya kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Jɔrjiya kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkut kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Irkut kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Irkut kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Magadan = new String[] {
               "Magaɖan kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Magaɖan kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Magaɖan kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Myanmar = new String[] {
               "Miyanmaa kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Nɔrfook kaAtukǝltǝna kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Nɔrfook kaAtukǝltǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Nɔrfook kaAtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Noronha = new String[] {
               "Fɛrnanɖo ɖe Norɔnya kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Fɛrnanɖo ɖe Norɔnya kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Fɛrnanɖo ɖe Norɔnya kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Reunion = new String[] {
               "Reeniyɔŋ kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Roteraa kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomɔɔn kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelaʊ kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguwee kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Uruguwee kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Uruguwee kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Fanuwatu kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Fanuwatu kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Fanuwatu kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakut kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Yakut kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Yakut kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Atlantic = new String[] {
               "Amalɩka katǝlantika kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "AST",
               "Amalɩka katǝlantika kaakɔŋkɔŋɔ̀ gafʊbaka",
               "AST",
               "Amalɩka katǝlantika kaakɔŋkɔŋɔ̀",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasiliya kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Brasiliya kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Brasiliya kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Chamorro = new String[] {
               "Shamoroo kaakɔŋkɔŋɔ̀",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolɔmbii kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Kolɔmbii kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Kolɔmbii kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Falkland = new String[] {
               "Fɔklanɖ kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Fɔklanɖ kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Fɔklanɖ kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malɛsii kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Malɖiifu kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatɔɔr kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Ulanbatɔɔr kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Ulanbatɔɔr kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "PKT",
               "Pakistan kaakɔŋkɔŋɔ̀ gafʊbaka",
               "PKST",
               "Pakistan kaakɔŋkɔŋɔ̀",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguwee kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Paraguwee kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Paraguwee kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pɩtkɛɛn kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakalin kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Sakalin kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Sakalin kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinam kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Arjantin kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Arjantin kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Arjantin kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Christmas = new String[] {
               "Nowɛl kaAtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagɔs kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hɔŋ Kɔŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "HKT",
               "Hɔŋ Kɔŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "HKST",
               "Hɔŋ Kɔŋ kaakɔŋkɔŋɔ̀",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Inɖicaɩna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lɔrɖ Hoo kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Lɔrɖ Hoo kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Lɔrɖ Hoo kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markesas kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Imoris kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Imoris kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Imoris kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Singapore = new String[] {
               "Siŋgapuur kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Fenesuwelaa kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Fɔlgograaɖ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "MSK",
               "Fɔlgograaɖ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "MSK",
               "Fɔlgograaɖ kaakɔŋkɔŋɔ̀",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Asɛrbaɩjaŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Asɛrbaɩjaŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Asɛrbaɩjaŋ kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Baŋglaɖɛɛshɩ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Baŋglaɖɛɛshɩ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Baŋglaɖɛɛshɩ kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kapfɛɛr kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Kapfɛɛr kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Kapfɛɛr kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] East_Timor = new String[] {
               "Timɔɔ gajakalaŋ kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kasastan kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seshɛl kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tajikistan kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbeekistan kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Usbeekistan kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Usbeekistan kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyark kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Krasnoyark kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Krasnoyark kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Selanɖ afɔlɩ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "NZST",
               "Selanɖ afɔlɩ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "NZDT",
               "Selanɖ afɔlɩ kaakɔŋkɔŋɔ̀",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Nofosibirk kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Nofosibirk kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Nofosibirk kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipiin kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "PST",
               "Filipiin kaakɔŋkɔŋɔ̀ gafʊbaka",
               "PDT",
               "Filipiin kaakɔŋkɔŋɔ̀",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Flaɖifɔstɔk kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Flaɖifɔstɔk kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Flaɖifɔstɔk kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Inɖiya kateŋku kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Laɩn kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Faʊnɖlanɖ afɔlɩ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "NST",
               "Faʊnɖlanɖ afɔlɩ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "NDT",
               "Faʊnɖlanɖ afɔlɩ kaakɔŋkɔŋɔ̀",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Turkmenistan kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Turkmenistan kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Guyanaa Gafɔntǝna kaja kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Kaleɖonii afɔlɩ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Kaleɖonii afɔlɩ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Kaleɖonii afɔlɩ kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Jɔrjiya gʊnyɩsono kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinbuu kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Yekaterinbuu kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Yekaterinbuu kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Garɩɖontǝna gɩcɩɩca kaakɔŋkɔŋɔ̀",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Garɩɖontǝna gajakalaŋ kaakɔŋkɔŋɔ̀",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Garɩɖontǝna gɩteŋshilelaŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "WAT",
               "Garɩɖontǝna gɩteŋshilelaŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "WAT",
               "Garɩɖontǝna gɩteŋshilelaŋ kaakɔŋkɔŋɔ̀",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Ɖimɔn Ɖirfil kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Garɩfɔntǝna gɩcɩɩca kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "CET",
               "Garɩfɔntǝna gɩcɩɩca kaakɔŋkɔŋɔ̀ gafʊbaka",
               "CEST",
               "Garɩfɔntǝna gɩcɩɩca kaakɔŋkɔŋɔ̀",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Garɩfɔntǝna gajakalaŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "EET",
               "Garɩfɔntǝna gajakalaŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "EEST",
               "Garɩfɔntǝna gajakalaŋ kaakɔŋkɔŋɔ̀",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Garɩfɔntǝna gɩteŋshilelaŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "WET",
               "Garɩfɔntǝna gɩteŋshilelaŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "WEST",
               "Garɩfɔntǝna gɩteŋshilelaŋ kaakɔŋkɔŋɔ̀",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mɛsik kapasifika kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "MST",
               "Mɛsik kapasifika kaakɔŋkɔŋɔ̀ gafʊbaka",
               "MDT",
               "Mɛsik kapasifika kaakɔŋkɔŋɔ̀",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Garɩɖontǝna gʊnyɩsonolaŋ kaakɔŋkɔŋɔ̀",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Amalɩka gʊnyɩpɛnɛlaŋ kagɩcɩɩca kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "CST",
               "Amalɩka gʊnyɩpɛnɛlaŋ kagɩcɩɩca kaakɔŋkɔŋɔ̀ gafʊbaka",
               "CDT",
               "Amalɩka gʊnyɩpɛnɛlaŋ kagɩcɩɩca kaakɔŋkɔŋɔ̀",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Amalɩka gʊnyɩpɛnɛlaŋ kaajakalaŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "EST",
               "Amalɩka gʊnyɩpɛnɛlaŋ kaajakalaŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "EST",
               "Amalɩka gʊnyɩpɛnɛlaŋ kaajakalaŋ kaakɔŋkɔŋɔ̀",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Amalɩka kapasifika kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "PST",
               "Amalɩka kapasifika kaakɔŋkɔŋɔ̀ gafʊbaka",
               "PDT",
               "Amalɩka kapasifika kaakɔŋkɔŋɔ̀",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Gafɔntǝna gʊnyɩsonolaŋ na Gatutaltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Jilbɛɛr kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Awayɩɩ n’Alewutii kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "HST",
               "Awayɩɩ n’Alewutii kaakɔŋkɔŋɔ̀ gafʊbaka",
               "HST",
               "Awayɩɩ n’Alewutii kaakɔŋkɔŋɔ̀",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Foeniis kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sɛŋ-Petrɔs na Mikelɔŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Sɛŋ-Petrɔs na Mikelɔŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Sɛŋ-Petrɔs na Mikelɔŋ kaakɔŋkɔŋɔ̀",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Amalɩka gʊnyɩpɛnɛlaŋ kabʊnʊ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "MST",
               "Amalɩka gʊnyɩpɛnɛlaŋ kabʊnʊ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "MST",
               "Amalɩka gʊnyɩpɛnɛlaŋ kabʊnʊ kaakɔŋkɔŋɔ̀",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshal kaBʊtukǝltǝna kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papuasii Ginee afɔlɩ kaakɔŋkɔŋɔ̀",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ɔstraliya kagɩcɩɩca kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "ACST",
               "Ɔstraliya kagɩcɩɩca kaakɔŋkɔŋɔ̀ gafʊbaka",
               "ACDT",
               "Ɔstraliya kagɩcɩɩca kaakɔŋkɔŋɔ̀",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ɔstraliya kaajakalaŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "AEST",
               "Ɔstraliya kaajakalaŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "AEDT",
               "Ɔstraliya kaajakalaŋ kaakɔŋkɔŋɔ̀",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ɔstraliya kagɩteŋshilelaŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "AWST",
               "Ɔstraliya kagɩteŋshilelaŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "AWDT",
               "Ɔstraliya kagɩteŋshilelaŋ kaakɔŋkɔŋɔ̀",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ɛnɖonosii kagɩcɩɩca kaakɔŋkɔŋɔ̀",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ɛnɖonosii kaajakalaŋ kaakɔŋkɔŋɔ̀",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ɛnɖonosii kagɩteŋshilelaŋ kaakɔŋkɔŋɔ̀",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ɔstraliya kagɩcɩɩca gɩteŋshilelaŋ kaakɔŋkɔŋɔ̀ ɖeiɖei",
               "",
               "Ɔstraliya kagɩcɩɩca gɩteŋshilelaŋ kaakɔŋkɔŋɔ̀ gafʊbaka",
               "",
               "Ɔstraliya kagɩcɩɩca gɩteŋshilelaŋ kaakɔŋkɔŋɔ̀",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Griinwish kaakɔŋkɔŋɔ̀",
                    "Gk",
                    "Gagɛɛshɩtǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Ɖulinya aŋunii kaakɔŋkɔŋɔ̀",
                    "ƉAK",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Griinwish kaakɔŋkɔŋɔ̀",
                    "Gk",
                    "Irlanɖ kaakɔŋkɔŋɔ̀",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Ɖulinya aŋunii kaakɔŋkɔŋɔ̀",
                    "ƉAK",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Ɖulinya aŋunii kaakɔŋkɔŋɔ̀",
                    "ƉAK",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Griinwish kaakɔŋkɔŋɔ̀",
                    "Gk",
                    "Gagɛɛshɩtǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Ɖulinya aŋunii kaakɔŋkɔŋɔ̀",
                    "ƉAK",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Ɖulinya aŋunii kaakɔŋkɔŋɔ̀",
                    "ƉAK",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Ɖulinya aŋunii kaakɔŋkɔŋɔ̀",
                    "ƉAK",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Griinwish kaakɔŋkɔŋɔ̀",
                    "Gk",
                    "Irlanɖ kaakɔŋkɔŋɔ̀",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Griinwish kaakɔŋkɔŋɔ̀",
                    "Gk",
                    "Gagɛɛshɩtǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Griinwish kaakɔŋkɔŋɔ̀",
                    "Gk",
                    "Gagɛɛshɩtǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Griinwish kaakɔŋkɔŋɔ̀",
                    "Gk",
                    "Gagɛɛshɩtǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Griinwish kaakɔŋkɔŋɔ̀",
                    "Gk",
                    "Gagɛɛshɩtǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Griinwish kaakɔŋkɔŋɔ̀",
                    "Gk",
                    "Gagɛɛshɩtǝna kaakɔŋkɔŋɔ̀ gafʊbaka",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Aɖɛn" },
            { "timezone.excity.Asia/Baku", "Bakuu" },
            { "timezone.excity.Asia/Dili", "Ɖilii" },
            { "timezone.excity.Asia/Gaza", "Gasaa" },
            { "timezone.excity.Asia/Hovd", "Hɔfɖǝ" },
            { "timezone.excity.Asia/Omsk", "Ɔmsǝkǝ" },
            { "timezone.excity.Asia/Oral", "Oraal" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amaan" },
            { "timezone.excity.Asia/Aqtau", "Aktaʊ" },
            { "timezone.excity.Asia/Chita", "Shitaa" },
            { "timezone.excity.Asia/Dhaka", "Ɖakaa" },
            { "timezone.excity.Asia/Dubai", "Ɖubaɩ" },
            { "timezone.excity.Asia/Macau", "Makawoo" },
            { "timezone.excity.Asia/Qatar", "Kataa" },
            { "timezone.excity.Asia/Seoul", "Sewul" },
            { "timezone.excity.Asia/Tokyo", "Tokiyoo" },
            { "timezone.excity.Asia/Tomsk", "Tɔmsǝkǝ" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Jubaa" },
            { "timezone.excity.Africa/Lome", "Lʊmɛ" },
            { "timezone.excity.Asia/Almaty", "Almatii" },
            { "timezone.excity.Asia/Anadyr", "Anaɖiir" },
            { "timezone.excity.Asia/Aqtobe", "Aktobee" },
            { "timezone.excity.Asia/Atyrau", "Atiraʊ" },
            { "timezone.excity.Asia/Beirut", "Beiruut" },
            { "timezone.excity.Asia/Brunei", "Brunɛɩ" },
            { "timezone.excity.Asia/Hebron", "Hebrɔn" },
            { "timezone.excity.Asia/Kuwait", "Koweeti" },
            { "timezone.excity.Asia/Manila", "Manilaa" },
            { "timezone.excity.Asia/Muscat", "Muskaat" },
            { "timezone.excity.Asia/Riyadh", "Riyaaɖ" },
            { "timezone.excity.Asia/Saigon", "Ho Ci Min kaMpá" },
            { "timezone.excity.Asia/Taipei", "Taɩpei" },
            { "timezone.excity.Asia/Tehran", "Teeraan" },
            { "timezone.excity.Asia/Urumqi", "Urumkii" },
            { "timezone.excity.Etc/Unknown", "mpá nɖee kʊyɔʊ ʊ mana ma" },
            { "timezone.excity.Europe/Kiev", "Kiyɛf" },
            { "timezone.excity.Europe/Oslo", "Ɔsloo" },
            { "timezone.excity.Europe/Riga", "Rigaa" },
            { "timezone.excity.Europe/Rome", "Room" },
            { "timezone.excity.Indian/Mahe", "Mahee" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akraa" },
            { "timezone.excity.Africa/Cairo", "Kairoo" },
            { "timezone.excity.Africa/Ceuta", "Seyuta" },
            { "timezone.excity.Africa/Dakar", "Ɖakaar" },
            { "timezone.excity.Africa/Lagos", "Legɔs" },
            { "timezone.excity.Africa/Tunis", "Tiniis" },
            { "timezone.excity.America/Adak", "Aɖak" },
            { "timezone.excity.America/Lima", "Limaa" },
            { "timezone.excity.Asia/Baghdad", "Bagɖaaɖ" },
            { "timezone.excity.Asia/Bahrain", "Barɛɛn" },
            { "timezone.excity.Asia/Bangkok", "Baŋkɔk" },
            { "timezone.excity.Asia/Barnaul", "Barnawul" },
            { "timezone.excity.Asia/Bishkek", "Bishkɛk" },
            { "timezone.excity.Asia/Colombo", "Kolomboo" },
            { "timezone.excity.Asia/Irkutsk", "Irkut" },
            { "timezone.excity.Asia/Jakarta", "Jakataa" },
            { "timezone.excity.Asia/Karachi", "Karacɩ" },
            { "timezone.excity.Asia/Kuching", "Kuciŋ" },
            { "timezone.excity.Asia/Magadan", "Magaɖan" },
            { "timezone.excity.Asia/Nicosia", "Nikosiya" },
            { "timezone.excity.Asia/Rangoon", "Yaŋgɔn" },
            { "timezone.excity.Asia/Tbilisi", "Tiblisii" },
            { "timezone.excity.Asia/Thimphu", "Timfu" },
            { "timezone.excity.Asia/Yakutsk", "Yakut" },
            { "timezone.excity.Asia/Yerevan", "Yerefaan" },
            { "timezone.excity.Europe/Kirov", "Kirɔɔf" },
            { "timezone.excity.Europe/Minsk", "Mɩns" },
            { "timezone.excity.Europe/Paris", "Parii" },
            { "timezone.excity.Europe/Sofia", "Sofiya" },
            { "timezone.excity.Europe/Vaduz", "Faɖus" },
            { "timezone.excity.Indian/Cocos", "Kokoos" },
            { "timezone.excity.Pacific/Apia", "Apiya" },
            { "timezone.excity.Pacific/Guam", "Guwam" },
            { "timezone.excity.Pacific/Niue", "Niwuye" },
            { "timezone.excity.Pacific/Truk", "Cuuk" },
            { "timezone.excity.Pacific/Wake", "Week" },
            { "timezone.excity.Africa/Asmera", "Asmaraa" },
            { "timezone.excity.Africa/Bamako", "Bamakoo" },
            { "timezone.excity.Africa/Bangui", "Baŋgii" },
            { "timezone.excity.Africa/Bissau", "Bisoo" },
            { "timezone.excity.Africa/Douala", "Ɖuwalaa" },
            { "timezone.excity.Africa/Harare", "Hararee" },
            { "timezone.excity.Africa/Kigali", "Kigalii" },
            { "timezone.excity.Africa/Luanda", "Luwanɖaa" },
            { "timezone.excity.Africa/Lusaka", "Lusakaa" },
            { "timezone.excity.Africa/Malabo", "Malaboo" },
            { "timezone.excity.Africa/Maputo", "Maputoo" },
            { "timezone.excity.Africa/Maseru", "Maseruu" },
            { "timezone.excity.Africa/Niamey", "Nyɛmɛ" },
            { "timezone.excity.America/Aruba", "Arubaa" },
            { "timezone.excity.America/Bahia", "Bahiyaa" },
            { "timezone.excity.America/Belem", "Belɛm" },
            { "timezone.excity.America/Boise", "Bɔwaasɩ" },
            { "timezone.excity.America/Jujuy", "Huhuyi" },
            { "timezone.excity.America/Sitka", "Sitkaa" },
            { "timezone.excity.America/Thule", "Tuule" },
            { "timezone.excity.Asia/Ashgabat", "Ashgabaat" },
            { "timezone.excity.Asia/Calcutta", "Kɔlkata" },
            { "timezone.excity.Asia/Damascus", "Ɖamaskɔɔsɩ" },
            { "timezone.excity.Asia/Dushanbe", "Ɖushanbee" },
            { "timezone.excity.Asia/Jayapura", "Jayapuraa" },
            { "timezone.excity.Asia/Katmandu", "Katmanɖuu" },
            { "timezone.excity.Asia/Khandyga", "Kanɖigaa" },
            { "timezone.excity.Asia/Makassar", "Makasaar" },
            { "timezone.excity.Asia/Qostanay", "Kɔstanaɩ" },
            { "timezone.excity.Asia/Sakhalin", "Sakalin" },
            { "timezone.excity.Asia/Shanghai", "Shaŋgaɩ" },
            { "timezone.excity.Asia/Tashkent", "Tashkɛnt" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Neraa" },
            { "timezone.excity.Europe/Athens", "Atɛn" },
            { "timezone.excity.Europe/Berlin", "Bɛrlɛŋ" },
            { "timezone.excity.Europe/Dublin", "Ɖɔblɛŋ" },
            { "timezone.excity.Europe/Jersey", "Jersei" },
            { "timezone.excity.Europe/Lisbon", "Lisbɔn" },
            { "timezone.excity.Europe/London", "Lɔnɖɔn" },
            { "timezone.excity.Europe/Madrid", "Maɖriiɖ" },
            { "timezone.excity.Europe/Monaco", "Monakoo" },
            { "timezone.excity.Europe/Moscow", "Moskuu" },
            { "timezone.excity.Europe/Prague", "Praag" },
            { "timezone.excity.Europe/Samara", "Samaraa" },
            { "timezone.excity.Europe/Skopje", "Skɔpyɛ" },
            { "timezone.excity.Europe/Tirane", "Tiranaa" },
            { "timezone.excity.Europe/Vienna", "Fiyɛna" },
            { "timezone.excity.Europe/Warsaw", "Warsaʊ" },
            { "timezone.excity.Europe/Zagreb", "Sagrɛb" },
            { "timezone.excity.Europe/Zurich", "Suriik" },
            { "timezone.excity.Indian/Chagos", "Shagɔs" },
            { "timezone.excity.Indian/Comoro", "Komoroo" },
            { "timezone.excity.Pacific/Efate", "Efatee" },
            { "timezone.excity.Pacific/Nauru", "Nawuru" },
            { "timezone.excity.Pacific/Palau", "Palawoo" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abijaŋ" },
            { "timezone.excity.Africa/Algiers", "Aljɛɛr" },
            { "timezone.excity.Africa/Conakry", "Konakrii" },
            { "timezone.excity.Africa/Kampala", "Kampalaa" },
            { "timezone.excity.Africa/Mbabane", "Mbabanee" },
            { "timezone.excity.Africa/Nairobi", "Nairobii" },
            { "timezone.excity.Africa/Tripoli", "Tripolii" },
            { "timezone.excity.America/Belize", "Beliis" },
            { "timezone.excity.America/Cancun", "Kaŋkun" },
            { "timezone.excity.America/Cayman", "Kayimaan" },
            { "timezone.excity.America/Cuiaba", "Kuyabaa" },
            { "timezone.excity.America/Dawson", "Ɖɔɔsǝn" },
            { "timezone.excity.America/Denver", "Ɖɛnfa" },
            { "timezone.excity.America/Guyana", "Guyanaa" },
            { "timezone.excity.America/Havana", "Hafanaa" },
            { "timezone.excity.America/Inuvik", "Inufik" },
            { "timezone.excity.America/Juneau", "Jinoo" },
            { "timezone.excity.America/La_Paz", "La Pas" },
            { "timezone.excity.America/Maceio", "Masɛɩyoo" },
            { "timezone.excity.America/Manaus", "Manaʊs" },
            { "timezone.excity.America/Merida", "Meriiɖa" },
            { "timezone.excity.America/Nassau", "Nasau" },
            { "timezone.excity.America/Panama", "Panamaa" },
            { "timezone.excity.America/Recife", "Resife" },
            { "timezone.excity.America/Regina", "Regiina" },
            { "timezone.excity.Asia/Famagusta", "Famagustaa" },
            { "timezone.excity.Asia/Hong_Kong", "Hɔŋ Kɔŋ" },
            { "timezone.excity.Asia/Jerusalem", "Yerusalɛm" },
            { "timezone.excity.Asia/Kamchatka", "Kamshatkaa" },
            { "timezone.excity.Asia/Pontianak", "Pɔntiyanak" },
            { "timezone.excity.Asia/Pyongyang", "Pɩyɔŋyaŋ" },
            { "timezone.excity.Asia/Qyzylorda", "Kisilɔrɖaa" },
            { "timezone.excity.Asia/Samarkand", "Samarkanɖ" },
            { "timezone.excity.Asia/Singapore", "Siŋgapuur" },
            { "timezone.excity.Asia/Vientiane", "Fiyentiyan" },
            { "timezone.excity.Europe/Andorra", "Anɖɔraa" },
            { "timezone.excity.Europe/Saratov", "Saratɔɔf" },
            { "timezone.excity.Europe/Tallinn", "Talin" },
            { "timezone.excity.Europe/Vatican", "Fatikaŋ" },
            { "timezone.excity.Europe/Vilnius", "Filniyus" },
            { "timezone.excity.Indian/Mayotte", "Mayɔɔtɩ" },
            { "timezone.excity.Indian/Reunion", "Reeniyɔŋ" },
            { "timezone.excity.Pacific/Easter", "Ista" },
            { "timezone.excity.Pacific/Kanton", "Kantɔn" },
            { "timezone.excity.Pacific/Kosrae", "Kɔsrɛɛ" },
            { "timezone.excity.Pacific/Majuro", "Majuroo" },
            { "timezone.excity.Pacific/Midway", "Miɖwee" },
            { "timezone.excity.Pacific/Noumea", "Numeya" },
            { "timezone.excity.Pacific/Ponape", "Poonpee" },
            { "timezone.excity.Pacific/Saipan", "Saɩpan" },
            { "timezone.excity.Pacific/Tahiti", "Tahitii" },
            { "timezone.excity.Pacific/Tarawa", "Tarawaa" },
            { "timezone.excity.Pacific/Wallis", "Walis" },
            { "timezone.excity.Africa/Blantyre", "Blantiir" },
            { "timezone.excity.Africa/Djibouti", "Jibutii" },
            { "timezone.excity.Africa/El_Aaiun", "Ɛl Ayun" },
            { "timezone.excity.Africa/Freetown", "Friitaʊn" },
            { "timezone.excity.Africa/Khartoum", "Kartuum" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasaa" },
            { "timezone.excity.Africa/Monrovia", "Monrofiyaa" },
            { "timezone.excity.Africa/Ndjamena", "Njamenaa" },
            { "timezone.excity.Africa/Sao_Tome", "Saotome kampá" },
            { "timezone.excity.Africa/Windhoek", "Winɖhuk" },
            { "timezone.excity.America/Antigua", "Antiguwaa" },
            { "timezone.excity.America/Caracas", "Karakaas" },
            { "timezone.excity.America/Cayenne", "Kayɛɛn" },
            { "timezone.excity.America/Chicago", "Shikagoo" },
            { "timezone.excity.America/Cordoba", "Kɔrɖobaa" },
            { "timezone.excity.America/Creston", "Krɛstɔn" },
            { "timezone.excity.America/Curacao", "Kurasaawu" },
            { "timezone.excity.America/Detroit", "Ɖitrɔɔɩ" },
            { "timezone.excity.America/Grenada", "Grenaaɖa" },
            { "timezone.excity.America/Halifax", "Halifaas" },
            { "timezone.excity.America/Iqaluit", "Ikaluwiit" },
            { "timezone.excity.America/Jamaica", "Jamaɩka" },
            { "timezone.excity.America/Managua", "Manaaguwa" },
            { "timezone.excity.America/Marigot", "Marigoo" },
            { "timezone.excity.America/Mendoza", "Mɛnɖɔsaa" },
            { "timezone.excity.America/Moncton", "Mɔŋtɔn" },
            { "timezone.excity.America/Noronha", "Norɔnya" },
            { "timezone.excity.America/Ojinaga", "Ojinaaga" },
            { "timezone.excity.America/Phoenix", "Finiis" },
            { "timezone.excity.America/Tijuana", "Tihuwana" },
            { "timezone.excity.America/Toronto", "Torɔntoo" },
            { "timezone.excity.America/Tortola", "Tɔrtɔlaa" },
            { "timezone.excity.Asia/Phnom_Penh", "Nɔm Pɛn" },
            { "timezone.excity.Atlantic/Azores", "Asɔɔr" },
            { "timezone.excity.Atlantic/Canary", "Kanarii" },
            { "timezone.excity.Atlantic/Faeroe", "Faroi" },
            { "timezone.excity.Australia/Eucla", "Uklaa" },
            { "timezone.excity.Australia/Perth", "Pɛrt" },
            { "timezone.excity.Europe/Belgrade", "Bɛlgraaɖ" },
            { "timezone.excity.Europe/Brussels", "Brisɛl" },
            { "timezone.excity.Europe/Budapest", "Buɖapɛs" },
            { "timezone.excity.Europe/Busingen", "Busiŋgɛn" },
            { "timezone.excity.Europe/Chisinau", "Shisinoo" },
            { "timezone.excity.Europe/Guernsey", "Gǝrǝnsɛɩ" },
            { "timezone.excity.Europe/Helsinki", "Hɛlsiŋkii" },
            { "timezone.excity.Europe/Istanbul", "Istambuul" },
            { "timezone.excity.Europe/Sarajevo", "Sarayefoo" },
            { "timezone.excity.Indian/Maldives", "Malɖiifu" },
            { "timezone.excity.Pacific/Chatham", "Shatam" },
            { "timezone.excity.Pacific/Fakaofo", "Fakawofoo" },
            { "timezone.excity.Pacific/Gambier", "Gambiyee" },
            { "timezone.excity.Pacific/Norfolk", "Nɔrfook" },
            { "timezone.excity.Africa/Bujumbura", "Bujumburaa" },
            { "timezone.excity.Africa/Mogadishu", "Mogaɖishuu" },
            { "timezone.excity.America/Anguilla", "Aŋguwilaa" },
            { "timezone.excity.America/Asuncion", "Asunsiyɔn" },
            { "timezone.excity.America/Barbados", "Barbaɖɔɔsɩ" },
            { "timezone.excity.America/Dominica", "Ɖominikaa" },
            { "timezone.excity.America/Edmonton", "Ɛɖmɔntɔn" },
            { "timezone.excity.America/Eirunepe", "Ɛɩrunepee" },
            { "timezone.excity.America/Mazatlan", "Masatǝlan" },
            { "timezone.excity.America/Miquelon", "Mikelɔŋ" },
            { "timezone.excity.America/New_York", "Niu Yɔrk" },
            { "timezone.excity.America/Resolute", "Rɛsoluut" },
            { "timezone.excity.America/Santarem", "Santarɛm" },
            { "timezone.excity.America/Santiago", "Santiyagoo" },
            { "timezone.excity.America/St_Johns", "Sɛŋ Jɔɔns" },
            { "timezone.excity.America/St_Kitts", "Sɛŋ Kits" },
            { "timezone.excity.America/St_Lucia", "Sɛŋ Lusiya" },
            { "timezone.excity.America/Winnipeg", "Winipɛɛg" },
            { "timezone.excity.Antarctica/Casey", "Keesi" },
            { "timezone.excity.Antarctica/Davis", "Ɖefis" },
            { "timezone.excity.Antarctica/Syowa", "Siyowaa" },
            { "timezone.excity.Antarctica/Troll", "Trɔl" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyark" },
            { "timezone.excity.Asia/Novosibirsk", "Nofosibirk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanbatɔɔr" },
            { "timezone.excity.Asia/Vladivostok", "Flaɖifɔstɔk" },
            { "timezone.excity.Atlantic/Bermuda", "Bɛrmuɖaa" },
            { "timezone.excity.Atlantic/Madeira", "Maɖeiraa" },
            { "timezone.excity.Atlantic/Stanley", "Stanlɛɩ" },
            { "timezone.excity.Australia/Darwin", "Ɖarfin" },
            { "timezone.excity.Australia/Hobart", "Hobaa" },
            { "timezone.excity.Australia/Sydney", "Siɖnee" },
            { "timezone.excity.Europe/Amsterdam", "Amstɛrɖam" },
            { "timezone.excity.Europe/Astrakhan", "Astrakaan" },
            { "timezone.excity.Europe/Bucharest", "Bukarɛs" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltaa" },
            { "timezone.excity.Europe/Ljubljana", "Yubǝlyana" },
            { "timezone.excity.Europe/Mariehamn", "Mariyeham" },
            { "timezone.excity.Europe/Podgorica", "Poɖgorikaa" },
            { "timezone.excity.Europe/Stockholm", "Stɔkhɔlm" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanɔɔf" },
            { "timezone.excity.Europe/Volgograd", "Fɔlgograaɖ" },
            { "timezone.excity.Indian/Christmas", "Nowɛl" },
            { "timezone.excity.Indian/Kerguelen", "Kɛrgelɛɛn" },
            { "timezone.excity.Indian/Mauritius", "Imoris" },
            { "timezone.excity.Pacific/Auckland", "Ɔɔklanɖ" },
            { "timezone.excity.Pacific/Funafuti", "Funafutii" },
            { "timezone.excity.Pacific/Pitcairn", "Pɩtkɛɛn" },
            { "timezone.excity.Africa/Casablanca", "Kasablaŋkaa" },
            { "timezone.excity.Africa/Libreville", "Librǝfil" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashii" },
            { "timezone.excity.Africa/Nouakchott", "Nuwakcɔt" },
            { "timezone.excity.Africa/Porto-Novo", "Pɔrto Nofoo" },
            { "timezone.excity.America/Anchorage", "Aŋkɔraajɩ" },
            { "timezone.excity.America/Araguaina", "Araguweena" },
            { "timezone.excity.America/Boa_Vista", "Bowa Fistaa" },
            { "timezone.excity.America/Catamarca", "Katamarkaa" },
            { "timezone.excity.America/Chihuahua", "Shiwawaa" },
            { "timezone.excity.America/Fortaleza", "Fɔrtalɛsaa" },
            { "timezone.excity.America/Glace_Bay", "Glaas Baɩ" },
            { "timezone.excity.America/Goose_Bay", "Guus Baɩ" },
            { "timezone.excity.America/Guatemala", "Guwatemalaa" },
            { "timezone.excity.America/Guayaquil", "Guwayakil" },
            { "timezone.excity.America/Matamoros", "Matamoroos" },
            { "timezone.excity.America/Monterrey", "Mɔntɛrɛɩ" },
            { "timezone.excity.America/Sao_Paulo", "Sao Pauloo" },
            { "timezone.excity.America/St_Thomas", "Sɛŋ Tomaasɩ" },
            { "timezone.excity.America/Vancouver", "Fɛŋkuufa" },
            { "timezone.excity.Antarctica/Mawson", "Mɔsɔn" },
            { "timezone.excity.Antarctica/Palmer", "Palmɛɛr" },
            { "timezone.excity.Antarctica/Vostok", "Fɔstɔk" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuwala Lumpuur" },
            { "timezone.excity.Asia/Novokuznetsk", "Nofokusnɛk" },
            { "timezone.excity.Europe/Bratislava", "Bratislafa" },
            { "timezone.excity.Europe/Copenhagen", "Kopenaag" },
            { "timezone.excity.Europe/Luxembourg", "Lusɛmbuur" },
            { "timezone.excity.Europe/San_Marino", "San Marinoo" },
            { "timezone.excity.Pacific/Galapagos", "Galapagɔs" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalɛɛn" },
            { "timezone.excity.Pacific/Marquesas", "Markesas" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pagoo" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotɔŋga" },
            { "timezone.excity.Pacific/Tongatapu", "Tɔŋgatapuu" },
            { "timezone.excity.Africa/Addis_Ababa", "Aɖis Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brasafil" },
            { "timezone.excity.Africa/Ouagadougou", "Wagaɖugu" },
            { "timezone.excity.America/Costa_Rica", "Kɔsta Rikaa" },
            { "timezone.excity.America/Grand_Turk", "Granɖ Turk" },
            { "timezone.excity.America/Guadeloupe", "Guwaɖeluupu" },
            { "timezone.excity.America/Hermosillo", "Ɛrmosiloo" },
            { "timezone.excity.America/Kralendijk", "Kralɛnɖaɩk" },
            { "timezone.excity.America/Louisville", "Luwifiil" },
            { "timezone.excity.America/Martinique", "Martiniiki" },
            { "timezone.excity.America/Metlakatla", "Metelakatelaa" },
            { "timezone.excity.America/Montevideo", "Mɔntefiɖeyoo" },
            { "timezone.excity.America/Montserrat", "Mɔnsɛraatɩ" },
            { "timezone.excity.America/Paramaribo", "Paramariboo" },
            { "timezone.excity.America/Rio_Branco", "Riyo Braŋkoo" },
            { "timezone.excity.America/St_Vincent", "Sɛŋ Fɩnsaŋ" },
            { "timezone.excity.America/Whitehorse", "Waɩthɔɔs" },
            { "timezone.excity.Antarctica/McMurdo", "MɛkMɔrɖoo" },
            { "timezone.excity.Antarctica/Rothera", "Roteraa" },
            { "timezone.excity.Asia/Srednekolymsk", "Srɛɖnɛkɔlim" },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinbuu" },
            { "timezone.excity.Atlantic/Reykjavik", "Rɛɩkyafik" },
            { "timezone.excity.Atlantic/St_Helena", "Sɛŋ Elenaa" },
            { "timezone.excity.Australia/Adelaide", "Aɖelɛɛɖ" },
            { "timezone.excity.Australia/Brisbane", "Brisbɛn" },
            { "timezone.excity.Australia/Lindeman", "Linɖeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Man kaAtukǝltǝna" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliniŋgraaɖ" },
            { "timezone.excity.Pacific/Kiritimati", "Kirimatii" },
            { "timezone.excity.Africa/Johannesburg", "Yohanɛsbuur" },
            { "timezone.excity.America/El_Salvador", "Ɛl Salfaɖɔɔr" },
            { "timezone.excity.America/Fort_Nelson", "Fɔɔr Nɛlsɔn" },
            { "timezone.excity.America/Los_Angeles", "Lɔs Anjɛlɛɛs" },
            { "timezone.excity.America/Mexico_City", "Mɛsiko Siti" },
            { "timezone.excity.America/Porto_Velho", "Pɔrto Feloo" },
            { "timezone.excity.America/Puerto_Rico", "Pɔrto Rikoo" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Arctic/Longyearbyen", "Lɔŋyiirbiyɛn" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kapfɛɛr" },
            { "timezone.excity.Australia/Lord_Howe", "Lɔrɖ Hoo" },
            { "timezone.excity.Australia/Melbourne", "Mɛlbɔrn" },
            { "timezone.excity.Indian/Antananarivo", "Antananarifoo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guwaɖalkanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Ɖarɛsalaam" },
            { "timezone.excity.America/Blanc-Sablon", "Blaŋ-Sablɔŋ" },
            { "timezone.excity.America/Buenos_Aires", "Buwenɔs Airɛs" },
            { "timezone.excity.America/Campo_Grande", "Campo Granɖee" },
            { "timezone.excity.America/Danmarkshavn", "Ɖanǝmarkɩhaʊn" },
            { "timezone.excity.America/Dawson_Creek", "Ɖɔɔsǝn Kriik" },
            { "timezone.excity.America/Indiana/Knox", "Nɔk, Ɩnɖiyaana" },
            { "timezone.excity.America/Indianapolis", "Ɩnɖiyaanapoli" },
            { "timezone.excity.America/Rankin_Inlet", "Raŋkɩn Ɩnlɛɛtɩ" },
            { "timezone.excity.America/Scoresbysund", "Itokɔrtoomiiti" },
            { "timezone.excity.Antarctica/Macquarie", "Makarii" },
            { "timezone.excity.Pacific/Bougainville", "Bugɛɛŋfil" },
            { "timezone.excity.Pacific/Port_Moresby", "Pɔɔr Mɔrɛsbii" },
            { "timezone.excity.America/Cambridge_Bay", "Kambriijɩ Baɩ" },
            { "timezone.excity.America/Ciudad_Juarez", "Siwuɖaaɖ Huwarɛs" },
            { "timezone.excity.America/Indiana/Vevay", "Fefɛɩ, Ɩnɖiyaana" },
            { "timezone.excity.America/Lower_Princes", "Lowɛɛ Prɛŋs Kwata" },
            { "timezone.excity.America/Port_of_Spain", "Pɔɔr ɔf Spɛɛn" },
            { "timezone.excity.America/Santo_Domingo", "Santo Ɖomɩŋgo" },
            { "timezone.excity.America/St_Barthelemy", "Sɛŋ-Batolomayɔ" },
            { "timezone.excity.America/Swift_Current", "Sǝwɩftɩ Kǝrɛɛntɩ" },
            { "timezone.excity.Australia/Broken_Hill", "Brokǝn Hil" },
            { "timezone.excity.America/Bahia_Banderas", "Bahiiya ɖe Banɖeraasɩ" },
            { "timezone.excity.America/Port-au-Prince", "Pɔɔr o Prɛŋs" },
            { "timezone.excity.Atlantic/South_Georgia", "Jɔrjiya gʊnyɩsonolaŋ kaja" },
            { "timezone.excity.America/Indiana/Marengo", "Marɛŋgo, Ɩnɖiyaana" },
            { "timezone.excity.America/Indiana/Winamac", "Winamaak, Ɩnɖiyaana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuweyaa" },
            { "timezone.excity.America/Indiana/Tell_City", "Tɛl Siti, Ɩnɖiyaana" },
            { "timezone.excity.America/Indiana/Vincennes", "Fɛŋsɛn, Ɩnɖiyaana" },
            { "timezone.excity.Antarctica/DumontDUrville", "Ɖimɔn Ɖirfil" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Riyɔha" },
            { "timezone.excity.America/Argentina/San_Juan", "San Huwan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luwis" },
            { "timezone.excity.America/Indiana/Petersburg", "Petɛrsbuur, Ɩnɖiyaana" },
            { "timezone.excity.America/Kentucky/Monticello", "Mɔntishɛɛlo, Kɛntaki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Biula, Nɔɔr Ɖakoota" },
            { "timezone.excity.America/North_Dakota/Center", "Sɛnta, Nɔɔr Ɖakoota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Riyo Galegɔs" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Niu Salɛm, Nɔɔr Ɖakota" },
        };
        return data;
    }
}
