/*
 * Decompiled with CFR 0.152.
 */
package sjpp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import sjpp.Context;
import sjpp.ContextMode;

public class SjppAntTask
extends Task {
    private String src;
    private String dest;
    private String define;
    private String header;

    public void execute() throws BuildException {
        this.log("Starting SimpleJava PreProcessor.");
        this.log("src: " + this.src);
        this.log("dest: " + this.dest);
        this.log("define: " + this.define);
        this.log("header: " + this.header);
        Path root = Paths.get(this.src, new String[0]);
        Context context = new Context(ContextMode.REGULAR, root);
        context.addDefine(this.define);
        if (this.header != null) {
            try {
                context.addHeader(Files.readAllLines(Paths.get(this.header, new String[0])));
            }
            catch (IOException e) {
                e.printStackTrace();
                this.log("Error " + e.toString());
            }
        }
        Path out = Paths.get(this.dest, new String[0]);
        try {
            context.process(out);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log("Error " + e.toString());
        }
    }

    public final void setSrc(String src) {
        this.src = src;
    }

    public final void setDest(String dest) {
        this.dest = dest;
    }

    public final void setDefine(String define) {
        this.define = define;
    }

    public final void setHeader(String header) {
        this.header = header;
    }
}

