use rmp::encode::*;

#[test]
fn pass_pack_f32() {
    let mut buf = [0x00, 0x00, 0x00, 0x00, 0x00];

    write_f32(&mut &mut buf[..], 3.4028234e38_f32).ok().unwrap();

    assert_eq!([0xca, 0x7f, 0x7f, 0xff, 0xff], buf);
}

#[test]
fn pass_pack_f64() {
    use std::f64;

    let mut buf = [0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00];

    write_f64(&mut &mut buf[..], f64::INFINITY).ok().unwrap();

    assert_eq!([0xcb, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00], buf);
}
