//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/ext_proc/v3/processing_mode.proto

package ext_procv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ProcessingMode with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ProcessingMode) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ProcessingMode with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ProcessingModeMultiError,
// or nil if none found.
func (m *ProcessingMode) ValidateAll() error {
	return m.validate(true)
}

func (m *ProcessingMode) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := ProcessingMode_HeaderSendMode_name[int32(m.GetRequestHeaderMode())]; !ok {
		err := ProcessingModeValidationError{
			field:  "RequestHeaderMode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := ProcessingMode_HeaderSendMode_name[int32(m.GetResponseHeaderMode())]; !ok {
		err := ProcessingModeValidationError{
			field:  "ResponseHeaderMode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := ProcessingMode_BodySendMode_name[int32(m.GetRequestBodyMode())]; !ok {
		err := ProcessingModeValidationError{
			field:  "RequestBodyMode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := ProcessingMode_BodySendMode_name[int32(m.GetResponseBodyMode())]; !ok {
		err := ProcessingModeValidationError{
			field:  "ResponseBodyMode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := ProcessingMode_HeaderSendMode_name[int32(m.GetRequestTrailerMode())]; !ok {
		err := ProcessingModeValidationError{
			field:  "RequestTrailerMode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := ProcessingMode_HeaderSendMode_name[int32(m.GetResponseTrailerMode())]; !ok {
		err := ProcessingModeValidationError{
			field:  "ResponseTrailerMode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ProcessingModeMultiError(errors)
	}

	return nil
}

// ProcessingModeMultiError is an error wrapping multiple validation errors
// returned by ProcessingMode.ValidateAll() if the designated constraints
// aren't met.
type ProcessingModeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProcessingModeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProcessingModeMultiError) AllErrors() []error { return m }

// ProcessingModeValidationError is the validation error returned by
// ProcessingMode.Validate if the designated constraints aren't met.
type ProcessingModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProcessingModeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProcessingModeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProcessingModeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProcessingModeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProcessingModeValidationError) ErrorName() string { return "ProcessingModeValidationError" }

// Error satisfies the builtin error interface
func (e ProcessingModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProcessingMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProcessingModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProcessingModeValidationError{}
