// Copyright 2017, OpenCensus Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.17.3
// source: opencensus/proto/trace/v1/trace.proto

package v1

import (
	v1 "github.com/census-instrumentation/opencensus-proto/gen-go/resource/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of span. Can be used to specify additional relationships between spans
// in addition to a parent/child relationship.
type Span_SpanKind int32

const (
	// Unspecified.
	Span_SPAN_KIND_UNSPECIFIED Span_SpanKind = 0
	// Indicates that the span covers server-side handling of an RPC or other
	// remote network request.
	Span_SERVER Span_SpanKind = 1
	// Indicates that the span covers the client-side wrapper around an RPC or
	// other remote request.
	Span_CLIENT Span_SpanKind = 2
)

// Enum value maps for Span_SpanKind.
var (
	Span_SpanKind_name = map[int32]string{
		0: "SPAN_KIND_UNSPECIFIED",
		1: "SERVER",
		2: "CLIENT",
	}
	Span_SpanKind_value = map[string]int32{
		"SPAN_KIND_UNSPECIFIED": 0,
		"SERVER":                1,
		"CLIENT":                2,
	}
)

func (x Span_SpanKind) Enum() *Span_SpanKind {
	p := new(Span_SpanKind)
	*p = x
	return p
}

func (x Span_SpanKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Span_SpanKind) Descriptor() protoreflect.EnumDescriptor {
	return file_opencensus_proto_trace_v1_trace_proto_enumTypes[0].Descriptor()
}

func (Span_SpanKind) Type() protoreflect.EnumType {
	return &file_opencensus_proto_trace_v1_trace_proto_enumTypes[0]
}

func (x Span_SpanKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Span_SpanKind.Descriptor instead.
func (Span_SpanKind) EnumDescriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 0}
}

// Indicates whether the message was sent or received.
type Span_TimeEvent_MessageEvent_Type int32

const (
	// Unknown event type.
	Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED Span_TimeEvent_MessageEvent_Type = 0
	// Indicates a sent message.
	Span_TimeEvent_MessageEvent_SENT Span_TimeEvent_MessageEvent_Type = 1
	// Indicates a received message.
	Span_TimeEvent_MessageEvent_RECEIVED Span_TimeEvent_MessageEvent_Type = 2
)

// Enum value maps for Span_TimeEvent_MessageEvent_Type.
var (
	Span_TimeEvent_MessageEvent_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SENT",
		2: "RECEIVED",
	}
	Span_TimeEvent_MessageEvent_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SENT":             1,
		"RECEIVED":         2,
	}
)

func (x Span_TimeEvent_MessageEvent_Type) Enum() *Span_TimeEvent_MessageEvent_Type {
	p := new(Span_TimeEvent_MessageEvent_Type)
	*p = x
	return p
}

func (x Span_TimeEvent_MessageEvent_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Span_TimeEvent_MessageEvent_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_opencensus_proto_trace_v1_trace_proto_enumTypes[1].Descriptor()
}

func (Span_TimeEvent_MessageEvent_Type) Type() protoreflect.EnumType {
	return &file_opencensus_proto_trace_v1_trace_proto_enumTypes[1]
}

func (x Span_TimeEvent_MessageEvent_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Span_TimeEvent_MessageEvent_Type.Descriptor instead.
func (Span_TimeEvent_MessageEvent_Type) EnumDescriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 2, 1, 0}
}

// The relationship of the current span relative to the linked span: child,
// parent, or unspecified.
type Span_Link_Type int32

const (
	// The relationship of the two spans is unknown, or known but other
	// than parent-child.
	Span_Link_TYPE_UNSPECIFIED Span_Link_Type = 0
	// The linked span is a child of the current span.
	Span_Link_CHILD_LINKED_SPAN Span_Link_Type = 1
	// The linked span is a parent of the current span.
	Span_Link_PARENT_LINKED_SPAN Span_Link_Type = 2
)

// Enum value maps for Span_Link_Type.
var (
	Span_Link_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "CHILD_LINKED_SPAN",
		2: "PARENT_LINKED_SPAN",
	}
	Span_Link_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":   0,
		"CHILD_LINKED_SPAN":  1,
		"PARENT_LINKED_SPAN": 2,
	}
)

func (x Span_Link_Type) Enum() *Span_Link_Type {
	p := new(Span_Link_Type)
	*p = x
	return p
}

func (x Span_Link_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Span_Link_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_opencensus_proto_trace_v1_trace_proto_enumTypes[2].Descriptor()
}

func (Span_Link_Type) Type() protoreflect.EnumType {
	return &file_opencensus_proto_trace_v1_trace_proto_enumTypes[2]
}

func (x Span_Link_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Span_Link_Type.Descriptor instead.
func (Span_Link_Type) EnumDescriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 4, 0}
}

// A span represents a single operation within a trace. Spans can be
// nested to form a trace tree. Spans may also be linked to other spans
// from the same or different trace. And form graphs. Often, a trace
// contains a root span that describes the end-to-end latency, and one
// or more subspans for its sub-operations. A trace can also contain
// multiple root spans, or none at all. Spans do not need to be
// contiguous - there may be gaps or overlaps between spans in a trace.
//
// The next id is 17.
// TODO(bdrutu): Add an example.
type Span struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for a trace. All spans from the same trace share
	// the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes
	// is considered invalid.
	//
	// This field is semantically required. Receiver should generate new
	// random trace_id if empty or invalid trace_id was received.
	//
	// This field is required.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array. An ID with all zeroes is considered
	// invalid.
	//
	// This field is semantically required. Receiver should generate new
	// random span_id if empty or invalid span_id was received.
	//
	// This field is required.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The Tracestate on the span.
	Tracestate *Span_Tracestate `protobuf:"bytes,15,opt,name=tracestate,proto3" json:"tracestate,omitempty"`
	// The `span_id` of this span's parent span. If this is a root span, then this
	// field must be empty. The ID is an 8-byte array.
	ParentSpanId []byte `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// A description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name at the same call point in an application.
	// This makes it easier to correlate spans in different traces.
	//
	// This field is semantically required to be set to non-empty string.
	// When null or empty string received - receiver may use string "name"
	// as a replacement. There might be smarted algorithms implemented by
	// receiver to fix the empty span name.
	//
	// This field is required.
	Name *TruncatableString `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Distinguishes between spans generated in a particular context. For example,
	// two spans with the same name may be distinguished using `CLIENT` (caller)
	// and `SERVER` (callee) to identify queueing latency associated with the span.
	Kind Span_SpanKind `protobuf:"varint,14,opt,name=kind,proto3,enum=opencensus.proto.trace.v1.Span_SpanKind" json:"kind,omitempty"`
	// The start time of the span. On the client side, this is the time kept by
	// the local machine where the span execution starts. On the server side, this
	// is the time when the server's application handler starts running.
	//
	// This field is semantically required. When not set on receive -
	// receiver should set it to the value of end_time field if it was
	// set. Or to the current time if neither was set. It is important to
	// keep end_time > start_time for consistency.
	//
	// This field is required.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the span. On the client side, this is the time kept by
	// the local machine where the span execution ends. On the server side, this
	// is the time when the server application handler stops running.
	//
	// This field is semantically required. When not set on receive -
	// receiver should set it to start_time value. It is important to
	// keep end_time > start_time for consistency.
	//
	// This field is required.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// A set of attributes on the span.
	Attributes *Span_Attributes `protobuf:"bytes,7,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// A stack trace captured at the start of the span.
	StackTrace *StackTrace `protobuf:"bytes,8,opt,name=stack_trace,json=stackTrace,proto3" json:"stack_trace,omitempty"`
	// The included time events.
	TimeEvents *Span_TimeEvents `protobuf:"bytes,9,opt,name=time_events,json=timeEvents,proto3" json:"time_events,omitempty"`
	// The included links.
	Links *Span_Links `protobuf:"bytes,10,opt,name=links,proto3" json:"links,omitempty"`
	// An optional final status for this span. Semantically when Status
	// wasn't set it is means span ended without errors and assume
	// Status.Ok (code = 0).
	Status *Status `protobuf:"bytes,11,opt,name=status,proto3" json:"status,omitempty"`
	// An optional resource that is associated with this span. If not set, this span
	// should be part of a batch that does include the resource information, unless resource
	// information is unknown.
	Resource *v1.Resource `protobuf:"bytes,16,opt,name=resource,proto3" json:"resource,omitempty"`
	// A highly recommended but not required flag that identifies when a
	// trace crosses a process boundary. True when the parent_span belongs
	// to the same process as the current span. This flag is most commonly
	// used to indicate the need to adjust time as clocks in different
	// processes may not be synchronized.
	SameProcessAsParentSpan *wrapperspb.BoolValue `protobuf:"bytes,12,opt,name=same_process_as_parent_span,json=sameProcessAsParentSpan,proto3" json:"same_process_as_parent_span,omitempty"`
	// An optional number of child spans that were generated while this span
	// was active. If set, allows an implementation to detect missing child spans.
	ChildSpanCount *wrapperspb.UInt32Value `protobuf:"bytes,13,opt,name=child_span_count,json=childSpanCount,proto3" json:"child_span_count,omitempty"`
}

func (x *Span) Reset() {
	*x = Span{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span) ProtoMessage() {}

func (x *Span) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span.ProtoReflect.Descriptor instead.
func (*Span) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0}
}

func (x *Span) GetTraceId() []byte {
	if x != nil {
		return x.TraceId
	}
	return nil
}

func (x *Span) GetSpanId() []byte {
	if x != nil {
		return x.SpanId
	}
	return nil
}

func (x *Span) GetTracestate() *Span_Tracestate {
	if x != nil {
		return x.Tracestate
	}
	return nil
}

func (x *Span) GetParentSpanId() []byte {
	if x != nil {
		return x.ParentSpanId
	}
	return nil
}

func (x *Span) GetName() *TruncatableString {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *Span) GetKind() Span_SpanKind {
	if x != nil {
		return x.Kind
	}
	return Span_SPAN_KIND_UNSPECIFIED
}

func (x *Span) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Span) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Span) GetAttributes() *Span_Attributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Span) GetStackTrace() *StackTrace {
	if x != nil {
		return x.StackTrace
	}
	return nil
}

func (x *Span) GetTimeEvents() *Span_TimeEvents {
	if x != nil {
		return x.TimeEvents
	}
	return nil
}

func (x *Span) GetLinks() *Span_Links {
	if x != nil {
		return x.Links
	}
	return nil
}

func (x *Span) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Span) GetResource() *v1.Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *Span) GetSameProcessAsParentSpan() *wrapperspb.BoolValue {
	if x != nil {
		return x.SameProcessAsParentSpan
	}
	return nil
}

func (x *Span) GetChildSpanCount() *wrapperspb.UInt32Value {
	if x != nil {
		return x.ChildSpanCount
	}
	return nil
}

// The `Status` type defines a logical error model that is suitable for different
// programming environments, including REST APIs and RPC APIs. This proto's fields
// are a subset of those of
// [google.rpc.Status](https://github.com/googleapis/googleapis/blob/master/google/rpc/status.proto),
// which is used by [gRPC](https://github.com/grpc).
type Status struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status code. This is optional field. It is safe to assume 0 (OK)
	// when not set.
	Code int32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// A developer-facing error message, which should be in English.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *Status) Reset() {
	*x = Status{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status) ProtoMessage() {}

func (x *Status) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status.ProtoReflect.Descriptor instead.
func (*Status) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{1}
}

func (x *Status) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *Status) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// The value of an Attribute.
type AttributeValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the value.
	//
	// Types that are assignable to Value:
	//	*AttributeValue_StringValue
	//	*AttributeValue_IntValue
	//	*AttributeValue_BoolValue
	//	*AttributeValue_DoubleValue
	Value isAttributeValue_Value `protobuf_oneof:"value"`
}

func (x *AttributeValue) Reset() {
	*x = AttributeValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeValue) ProtoMessage() {}

func (x *AttributeValue) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeValue.ProtoReflect.Descriptor instead.
func (*AttributeValue) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{2}
}

func (m *AttributeValue) GetValue() isAttributeValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *AttributeValue) GetStringValue() *TruncatableString {
	if x, ok := x.GetValue().(*AttributeValue_StringValue); ok {
		return x.StringValue
	}
	return nil
}

func (x *AttributeValue) GetIntValue() int64 {
	if x, ok := x.GetValue().(*AttributeValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *AttributeValue) GetBoolValue() bool {
	if x, ok := x.GetValue().(*AttributeValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *AttributeValue) GetDoubleValue() float64 {
	if x, ok := x.GetValue().(*AttributeValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

type isAttributeValue_Value interface {
	isAttributeValue_Value()
}

type AttributeValue_StringValue struct {
	// A string up to 256 bytes long.
	StringValue *TruncatableString `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type AttributeValue_IntValue struct {
	// A 64-bit signed integer.
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type AttributeValue_BoolValue struct {
	// A Boolean value represented by `true` or `false`.
	BoolValue bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type AttributeValue_DoubleValue struct {
	// A double value.
	DoubleValue float64 `protobuf:"fixed64,4,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

func (*AttributeValue_StringValue) isAttributeValue_Value() {}

func (*AttributeValue_IntValue) isAttributeValue_Value() {}

func (*AttributeValue_BoolValue) isAttributeValue_Value() {}

func (*AttributeValue_DoubleValue) isAttributeValue_Value() {}

// The call stack which originated this span.
type StackTrace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stack frames in this stack trace.
	StackFrames *StackTrace_StackFrames `protobuf:"bytes,1,opt,name=stack_frames,json=stackFrames,proto3" json:"stack_frames,omitempty"`
	// The hash ID is used to conserve network bandwidth for duplicate
	// stack traces within a single trace.
	//
	// Often multiple spans will have identical stack traces.
	// The first occurrence of a stack trace should contain both
	// `stack_frames` and a value in `stack_trace_hash_id`.
	//
	// Subsequent spans within the same request can refer
	// to that stack trace by setting only `stack_trace_hash_id`.
	//
	// TODO: describe how to deal with the case where stack_trace_hash_id is
	// zero because it was not set.
	StackTraceHashId uint64 `protobuf:"varint,2,opt,name=stack_trace_hash_id,json=stackTraceHashId,proto3" json:"stack_trace_hash_id,omitempty"`
}

func (x *StackTrace) Reset() {
	*x = StackTrace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StackTrace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackTrace) ProtoMessage() {}

func (x *StackTrace) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackTrace.ProtoReflect.Descriptor instead.
func (*StackTrace) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{3}
}

func (x *StackTrace) GetStackFrames() *StackTrace_StackFrames {
	if x != nil {
		return x.StackFrames
	}
	return nil
}

func (x *StackTrace) GetStackTraceHashId() uint64 {
	if x != nil {
		return x.StackTraceHashId
	}
	return 0
}

// A description of a binary module.
type Module struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TODO: document the meaning of this field.
	// For example: main binary, kernel modules, and dynamic libraries
	// such as libc.so, sharedlib.so.
	Module *TruncatableString `protobuf:"bytes,1,opt,name=module,proto3" json:"module,omitempty"`
	// A unique identifier for the module, usually a hash of its
	// contents.
	BuildId *TruncatableString `protobuf:"bytes,2,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
}

func (x *Module) Reset() {
	*x = Module{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Module) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Module) ProtoMessage() {}

func (x *Module) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Module.ProtoReflect.Descriptor instead.
func (*Module) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{4}
}

func (x *Module) GetModule() *TruncatableString {
	if x != nil {
		return x.Module
	}
	return nil
}

func (x *Module) GetBuildId() *TruncatableString {
	if x != nil {
		return x.BuildId
	}
	return nil
}

// A string that might be shortened to a specified length.
type TruncatableString struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The shortened string. For example, if the original string was 500 bytes long and
	// the limit of the string was 128 bytes, then this value contains the first 128
	// bytes of the 500-byte string. Note that truncation always happens on a
	// character boundary, to ensure that a truncated string is still valid UTF-8.
	// Because it may contain multi-byte characters, the size of the truncated string
	// may be less than the truncation limit.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The number of bytes removed from the original string. If this
	// value is 0, then the string was not shortened.
	TruncatedByteCount int32 `protobuf:"varint,2,opt,name=truncated_byte_count,json=truncatedByteCount,proto3" json:"truncated_byte_count,omitempty"`
}

func (x *TruncatableString) Reset() {
	*x = TruncatableString{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TruncatableString) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TruncatableString) ProtoMessage() {}

func (x *TruncatableString) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TruncatableString.ProtoReflect.Descriptor instead.
func (*TruncatableString) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{5}
}

func (x *TruncatableString) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *TruncatableString) GetTruncatedByteCount() int32 {
	if x != nil {
		return x.TruncatedByteCount
	}
	return 0
}

// This field conveys information about request position in multiple distributed tracing graphs.
// It is a list of Tracestate.Entry with a maximum of 32 members in the list.
//
// See the https://github.com/w3c/distributed-tracing for more details about this field.
type Span_Tracestate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of entries that represent the Tracestate.
	Entries []*Span_Tracestate_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *Span_Tracestate) Reset() {
	*x = Span_Tracestate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_Tracestate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_Tracestate) ProtoMessage() {}

func (x *Span_Tracestate) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_Tracestate.ProtoReflect.Descriptor instead.
func (*Span_Tracestate) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Span_Tracestate) GetEntries() []*Span_Tracestate_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// A set of attributes, each with a key and a value.
type Span_Attributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of attributes. The value can be a string, an integer, a double
	// or the Boolean values `true` or `false`. Note, global attributes like
	// server name can be set as tags using resource API. Examples of attributes:
	//
	//     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
	//     "/http/server_latency": 300
	//     "abc.com/myattribute": true
	//     "abc.com/score": 10.239
	AttributeMap map[string]*AttributeValue `protobuf:"bytes,1,rep,name=attribute_map,json=attributeMap,proto3" json:"attribute_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The number of attributes that were discarded. Attributes can be discarded
	// because their keys are too long or because there are too many attributes.
	// If this value is 0, then no attributes were dropped.
	DroppedAttributesCount int32 `protobuf:"varint,2,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
}

func (x *Span_Attributes) Reset() {
	*x = Span_Attributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_Attributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_Attributes) ProtoMessage() {}

func (x *Span_Attributes) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_Attributes.ProtoReflect.Descriptor instead.
func (*Span_Attributes) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Span_Attributes) GetAttributeMap() map[string]*AttributeValue {
	if x != nil {
		return x.AttributeMap
	}
	return nil
}

func (x *Span_Attributes) GetDroppedAttributesCount() int32 {
	if x != nil {
		return x.DroppedAttributesCount
	}
	return 0
}

// A time-stamped annotation or message event in the Span.
type Span_TimeEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the event occurred.
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// A `TimeEvent` can contain either an `Annotation` object or a
	// `MessageEvent` object, but not both.
	//
	// Types that are assignable to Value:
	//	*Span_TimeEvent_Annotation_
	//	*Span_TimeEvent_MessageEvent_
	Value isSpan_TimeEvent_Value `protobuf_oneof:"value"`
}

func (x *Span_TimeEvent) Reset() {
	*x = Span_TimeEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_TimeEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_TimeEvent) ProtoMessage() {}

func (x *Span_TimeEvent) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_TimeEvent.ProtoReflect.Descriptor instead.
func (*Span_TimeEvent) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Span_TimeEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (m *Span_TimeEvent) GetValue() isSpan_TimeEvent_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Span_TimeEvent) GetAnnotation() *Span_TimeEvent_Annotation {
	if x, ok := x.GetValue().(*Span_TimeEvent_Annotation_); ok {
		return x.Annotation
	}
	return nil
}

func (x *Span_TimeEvent) GetMessageEvent() *Span_TimeEvent_MessageEvent {
	if x, ok := x.GetValue().(*Span_TimeEvent_MessageEvent_); ok {
		return x.MessageEvent
	}
	return nil
}

type isSpan_TimeEvent_Value interface {
	isSpan_TimeEvent_Value()
}

type Span_TimeEvent_Annotation_ struct {
	// A text annotation with a set of attributes.
	Annotation *Span_TimeEvent_Annotation `protobuf:"bytes,2,opt,name=annotation,proto3,oneof"`
}

type Span_TimeEvent_MessageEvent_ struct {
	// An event describing a message sent/received between Spans.
	MessageEvent *Span_TimeEvent_MessageEvent `protobuf:"bytes,3,opt,name=message_event,json=messageEvent,proto3,oneof"`
}

func (*Span_TimeEvent_Annotation_) isSpan_TimeEvent_Value() {}

func (*Span_TimeEvent_MessageEvent_) isSpan_TimeEvent_Value() {}

// A collection of `TimeEvent`s. A `TimeEvent` is a time-stamped annotation
// on the span, consisting of either user-supplied key-value pairs, or
// details of a message sent/received between Spans.
type Span_TimeEvents struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of `TimeEvent`s.
	TimeEvent []*Span_TimeEvent `protobuf:"bytes,1,rep,name=time_event,json=timeEvent,proto3" json:"time_event,omitempty"`
	// The number of dropped annotations in all the included time events.
	// If the value is 0, then no annotations were dropped.
	DroppedAnnotationsCount int32 `protobuf:"varint,2,opt,name=dropped_annotations_count,json=droppedAnnotationsCount,proto3" json:"dropped_annotations_count,omitempty"`
	// The number of dropped message events in all the included time events.
	// If the value is 0, then no message events were dropped.
	DroppedMessageEventsCount int32 `protobuf:"varint,3,opt,name=dropped_message_events_count,json=droppedMessageEventsCount,proto3" json:"dropped_message_events_count,omitempty"`
}

func (x *Span_TimeEvents) Reset() {
	*x = Span_TimeEvents{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_TimeEvents) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_TimeEvents) ProtoMessage() {}

func (x *Span_TimeEvents) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_TimeEvents.ProtoReflect.Descriptor instead.
func (*Span_TimeEvents) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Span_TimeEvents) GetTimeEvent() []*Span_TimeEvent {
	if x != nil {
		return x.TimeEvent
	}
	return nil
}

func (x *Span_TimeEvents) GetDroppedAnnotationsCount() int32 {
	if x != nil {
		return x.DroppedAnnotationsCount
	}
	return 0
}

func (x *Span_TimeEvents) GetDroppedMessageEventsCount() int32 {
	if x != nil {
		return x.DroppedMessageEventsCount
	}
	return 0
}

// A pointer from the current span to another span in the same trace or in a
// different trace. For example, this can be used in batching operations,
// where a single batch handler processes multiple requests from different
// traces or when the handler receives a request from a different project.
type Span_Link struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier of a trace that this linked span is part of. The ID is a
	// 16-byte array.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for the linked span. The ID is an 8-byte array.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The relationship of the current span relative to the linked span.
	Type Span_Link_Type `protobuf:"varint,3,opt,name=type,proto3,enum=opencensus.proto.trace.v1.Span_Link_Type" json:"type,omitempty"`
	// A set of attributes on the link.
	Attributes *Span_Attributes `protobuf:"bytes,4,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// The Tracestate associated with the link.
	Tracestate *Span_Tracestate `protobuf:"bytes,5,opt,name=tracestate,proto3" json:"tracestate,omitempty"`
}

func (x *Span_Link) Reset() {
	*x = Span_Link{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_Link) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_Link) ProtoMessage() {}

func (x *Span_Link) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_Link.ProtoReflect.Descriptor instead.
func (*Span_Link) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Span_Link) GetTraceId() []byte {
	if x != nil {
		return x.TraceId
	}
	return nil
}

func (x *Span_Link) GetSpanId() []byte {
	if x != nil {
		return x.SpanId
	}
	return nil
}

func (x *Span_Link) GetType() Span_Link_Type {
	if x != nil {
		return x.Type
	}
	return Span_Link_TYPE_UNSPECIFIED
}

func (x *Span_Link) GetAttributes() *Span_Attributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Span_Link) GetTracestate() *Span_Tracestate {
	if x != nil {
		return x.Tracestate
	}
	return nil
}

// A collection of links, which are references from this span to a span
// in the same or different trace.
type Span_Links struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of links.
	Link []*Span_Link `protobuf:"bytes,1,rep,name=link,proto3" json:"link,omitempty"`
	// The number of dropped links after the maximum size was enforced. If
	// this value is 0, then no links were dropped.
	DroppedLinksCount int32 `protobuf:"varint,2,opt,name=dropped_links_count,json=droppedLinksCount,proto3" json:"dropped_links_count,omitempty"`
}

func (x *Span_Links) Reset() {
	*x = Span_Links{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_Links) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_Links) ProtoMessage() {}

func (x *Span_Links) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_Links.ProtoReflect.Descriptor instead.
func (*Span_Links) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Span_Links) GetLink() []*Span_Link {
	if x != nil {
		return x.Link
	}
	return nil
}

func (x *Span_Links) GetDroppedLinksCount() int32 {
	if x != nil {
		return x.DroppedLinksCount
	}
	return 0
}

type Span_Tracestate_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key must begin with a lowercase letter, and can only contain
	// lowercase letters 'a'-'z', digits '0'-'9', underscores '_', dashes
	// '-', asterisks '*', and forward slashes '/'.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value is opaque string up to 256 characters printable ASCII
	// RFC0020 characters (i.e., the range 0x20 to 0x7E) except ',' and '='.
	// Note that this also excludes tabs, newlines, carriage returns, etc.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Span_Tracestate_Entry) Reset() {
	*x = Span_Tracestate_Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_Tracestate_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_Tracestate_Entry) ProtoMessage() {}

func (x *Span_Tracestate_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_Tracestate_Entry.ProtoReflect.Descriptor instead.
func (*Span_Tracestate_Entry) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Span_Tracestate_Entry) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Span_Tracestate_Entry) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A text annotation with a set of attributes.
type Span_TimeEvent_Annotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-supplied message describing the event.
	Description *TruncatableString `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// A set of attributes on the annotation.
	Attributes *Span_Attributes `protobuf:"bytes,2,opt,name=attributes,proto3" json:"attributes,omitempty"`
}

func (x *Span_TimeEvent_Annotation) Reset() {
	*x = Span_TimeEvent_Annotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_TimeEvent_Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_TimeEvent_Annotation) ProtoMessage() {}

func (x *Span_TimeEvent_Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_TimeEvent_Annotation.ProtoReflect.Descriptor instead.
func (*Span_TimeEvent_Annotation) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *Span_TimeEvent_Annotation) GetDescription() *TruncatableString {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *Span_TimeEvent_Annotation) GetAttributes() *Span_Attributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// An event describing a message sent/received between Spans.
type Span_TimeEvent_MessageEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of MessageEvent. Indicates whether the message was sent or
	// received.
	Type Span_TimeEvent_MessageEvent_Type `protobuf:"varint,1,opt,name=type,proto3,enum=opencensus.proto.trace.v1.Span_TimeEvent_MessageEvent_Type" json:"type,omitempty"`
	// An identifier for the MessageEvent's message that can be used to match
	// SENT and RECEIVED MessageEvents. For example, this field could
	// represent a sequence ID for a streaming RPC. It is recommended to be
	// unique within a Span.
	Id uint64 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// The number of uncompressed bytes sent or received.
	UncompressedSize uint64 `protobuf:"varint,3,opt,name=uncompressed_size,json=uncompressedSize,proto3" json:"uncompressed_size,omitempty"`
	// The number of compressed bytes sent or received. If zero, assumed to
	// be the same size as uncompressed.
	CompressedSize uint64 `protobuf:"varint,4,opt,name=compressed_size,json=compressedSize,proto3" json:"compressed_size,omitempty"`
}

func (x *Span_TimeEvent_MessageEvent) Reset() {
	*x = Span_TimeEvent_MessageEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_TimeEvent_MessageEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_TimeEvent_MessageEvent) ProtoMessage() {}

func (x *Span_TimeEvent_MessageEvent) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_TimeEvent_MessageEvent.ProtoReflect.Descriptor instead.
func (*Span_TimeEvent_MessageEvent) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *Span_TimeEvent_MessageEvent) GetType() Span_TimeEvent_MessageEvent_Type {
	if x != nil {
		return x.Type
	}
	return Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED
}

func (x *Span_TimeEvent_MessageEvent) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Span_TimeEvent_MessageEvent) GetUncompressedSize() uint64 {
	if x != nil {
		return x.UncompressedSize
	}
	return 0
}

func (x *Span_TimeEvent_MessageEvent) GetCompressedSize() uint64 {
	if x != nil {
		return x.CompressedSize
	}
	return 0
}

// A single stack frame in a stack trace.
type StackTrace_StackFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully-qualified name that uniquely identifies the function or
	// method that is active in this frame.
	FunctionName *TruncatableString `protobuf:"bytes,1,opt,name=function_name,json=functionName,proto3" json:"function_name,omitempty"`
	// An un-mangled function name, if `function_name` is
	// [mangled](http://www.avabodh.com/cxxin/namemangling.html). The name can
	// be fully qualified.
	OriginalFunctionName *TruncatableString `protobuf:"bytes,2,opt,name=original_function_name,json=originalFunctionName,proto3" json:"original_function_name,omitempty"`
	// The name of the source file where the function call appears.
	FileName *TruncatableString `protobuf:"bytes,3,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// The line number in `file_name` where the function call appears.
	LineNumber int64 `protobuf:"varint,4,opt,name=line_number,json=lineNumber,proto3" json:"line_number,omitempty"`
	// The column number where the function call appears, if available.
	// This is important in JavaScript because of its anonymous functions.
	ColumnNumber int64 `protobuf:"varint,5,opt,name=column_number,json=columnNumber,proto3" json:"column_number,omitempty"`
	// The binary module from where the code was loaded.
	LoadModule *Module `protobuf:"bytes,6,opt,name=load_module,json=loadModule,proto3" json:"load_module,omitempty"`
	// The version of the deployed source code.
	SourceVersion *TruncatableString `protobuf:"bytes,7,opt,name=source_version,json=sourceVersion,proto3" json:"source_version,omitempty"`
}

func (x *StackTrace_StackFrame) Reset() {
	*x = StackTrace_StackFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StackTrace_StackFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackTrace_StackFrame) ProtoMessage() {}

func (x *StackTrace_StackFrame) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackTrace_StackFrame.ProtoReflect.Descriptor instead.
func (*StackTrace_StackFrame) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{3, 0}
}

func (x *StackTrace_StackFrame) GetFunctionName() *TruncatableString {
	if x != nil {
		return x.FunctionName
	}
	return nil
}

func (x *StackTrace_StackFrame) GetOriginalFunctionName() *TruncatableString {
	if x != nil {
		return x.OriginalFunctionName
	}
	return nil
}

func (x *StackTrace_StackFrame) GetFileName() *TruncatableString {
	if x != nil {
		return x.FileName
	}
	return nil
}

func (x *StackTrace_StackFrame) GetLineNumber() int64 {
	if x != nil {
		return x.LineNumber
	}
	return 0
}

func (x *StackTrace_StackFrame) GetColumnNumber() int64 {
	if x != nil {
		return x.ColumnNumber
	}
	return 0
}

func (x *StackTrace_StackFrame) GetLoadModule() *Module {
	if x != nil {
		return x.LoadModule
	}
	return nil
}

func (x *StackTrace_StackFrame) GetSourceVersion() *TruncatableString {
	if x != nil {
		return x.SourceVersion
	}
	return nil
}

// A collection of stack frames, which can be truncated.
type StackTrace_StackFrames struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stack frames in this call stack.
	Frame []*StackTrace_StackFrame `protobuf:"bytes,1,rep,name=frame,proto3" json:"frame,omitempty"`
	// The number of stack frames that were dropped because there
	// were too many stack frames.
	// If this value is 0, then no stack frames were dropped.
	DroppedFramesCount int32 `protobuf:"varint,2,opt,name=dropped_frames_count,json=droppedFramesCount,proto3" json:"dropped_frames_count,omitempty"`
}

func (x *StackTrace_StackFrames) Reset() {
	*x = StackTrace_StackFrames{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StackTrace_StackFrames) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackTrace_StackFrames) ProtoMessage() {}

func (x *StackTrace_StackFrames) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_trace_v1_trace_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackTrace_StackFrames.ProtoReflect.Descriptor instead.
func (*StackTrace_StackFrames) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP(), []int{3, 1}
}

func (x *StackTrace_StackFrames) GetFrame() []*StackTrace_StackFrame {
	if x != nil {
		return x.Frame
	}
	return nil
}

func (x *StackTrace_StackFrames) GetDroppedFramesCount() int32 {
	if x != nil {
		return x.DroppedFramesCount
	}
	return 0
}

var File_opencensus_proto_trace_v1_trace_proto protoreflect.FileDescriptor

var file_opencensus_proto_trace_v1_trace_proto_rawDesc = []byte{
	0x0a, 0x25, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e,
	0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x1a, 0x2b, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x91, 0x16, 0x0a, 0x04, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x70, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x4a, 0x0a,
	0x0a, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70,
	0x61, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x74,
	0x72, 0x61, 0x63, 0x65, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x49, 0x64, 0x12,
	0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x3c, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x28, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e,
	0x2e, 0x53, 0x70, 0x61, 0x6e, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12,
	0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x46, 0x0a,
	0x0b, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x3b, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70,
	0x61, 0x6e, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12,
	0x39, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x42, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x58,
	0x0a, 0x1b, 0x73, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x61,
	0x73, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x17, 0x73, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x41, 0x73, 0x50, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x46, 0x0a, 0x10, 0x63, 0x68, 0x69, 0x6c,
	0x64, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0e, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x53, 0x70, 0x61, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0x89, 0x01, 0x0a, 0x0a, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x4a, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61,
	0x6e, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x2f, 0x0a, 0x05, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x95, 0x02, 0x0a,
	0x0a, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x0d, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x70, 0x61, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x38,
	0x0a, 0x18, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x16, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x6a, 0x0a, 0x11, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x3f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0xa4, 0x05, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x12, 0x56, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e,
	0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0a,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0d, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70,
	0x61, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x1a, 0xa8, 0x01, 0x0a, 0x0a, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x1a, 0xfb, 0x01, 0x0a, 0x0c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x61, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x10, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x63, 0x6f,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x34, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x45,
	0x4e, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44,
	0x10, 0x02, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xd3, 0x01, 0x0a, 0x0a,
	0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x48, 0x0a, 0x0a, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x3f, 0x0a, 0x1c, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x19, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x1a, 0xde, 0x02, 0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x70, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x3d,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x4c, 0x69,
	0x6e, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x4a, 0x0a,
	0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70,
	0x61, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0a, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x4b, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x48, 0x49, 0x4c, 0x44, 0x5f, 0x4c, 0x49, 0x4e,
	0x4b, 0x45, 0x44, 0x5f, 0x53, 0x50, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x41,
	0x52, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x45, 0x44, 0x5f, 0x53, 0x50, 0x41, 0x4e,
	0x10, 0x02, 0x1a, 0x71, 0x0a, 0x05, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x38, 0x0a, 0x04, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x11, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x3d, 0x0a, 0x08, 0x53, 0x70, 0x61, 0x6e, 0x4b, 0x69, 0x6e,
	0x64, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x50, 0x41, 0x4e, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4c, 0x49, 0x45,
	0x4e, 0x54, 0x10, 0x02, 0x22, 0x36, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xd1, 0x01, 0x0a,
	0x0e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x51, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x8b, 0x06, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12,
	0x54, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x13, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74,
	0x72, 0x61, 0x63, 0x65, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x10, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x48, 0x61,
	0x73, 0x68, 0x49, 0x64, 0x1a, 0xed, 0x03, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x16, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x61, 0x6c, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e,
	0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x52, 0x14, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x09, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x66, 0x69, 0x6c,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x6c, 0x69, 0x6e, 0x65,
	0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x42, 0x0a, 0x0b, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x0a, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x53, 0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65,
	0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x87, 0x01, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x05, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x05, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14,
	0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x64, 0x72, 0x6f, 0x70,
	0x70, 0x65, 0x64, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x97,
	0x01, 0x0a, 0x06, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x44, 0x0a, 0x06, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x47, 0x0a, 0x08, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52,
	0x07, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64, 0x22, 0x5b, 0x0a, 0x11, 0x54, 0x72, 0x75, 0x6e,
	0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x12, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x8f, 0x01, 0x0a, 0x1c, 0x69, 0x6f, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x54, 0x72, 0x61, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x42, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2d, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73,
	0x75, 0x73, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2f,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2f, 0x76, 0x31, 0xea, 0x02, 0x1c, 0x4f, 0x70, 0x65, 0x6e, 0x43,
	0x65, 0x6e, 0x73, 0x75, 0x73, 0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x3a, 0x54, 0x72,
	0x61, 0x63, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_opencensus_proto_trace_v1_trace_proto_rawDescOnce sync.Once
	file_opencensus_proto_trace_v1_trace_proto_rawDescData = file_opencensus_proto_trace_v1_trace_proto_rawDesc
)

func file_opencensus_proto_trace_v1_trace_proto_rawDescGZIP() []byte {
	file_opencensus_proto_trace_v1_trace_proto_rawDescOnce.Do(func() {
		file_opencensus_proto_trace_v1_trace_proto_rawDescData = protoimpl.X.CompressGZIP(file_opencensus_proto_trace_v1_trace_proto_rawDescData)
	})
	return file_opencensus_proto_trace_v1_trace_proto_rawDescData
}

var file_opencensus_proto_trace_v1_trace_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_opencensus_proto_trace_v1_trace_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_opencensus_proto_trace_v1_trace_proto_goTypes = []interface{}{
	(Span_SpanKind)(0),                    // 0: opencensus.proto.trace.v1.Span.SpanKind
	(Span_TimeEvent_MessageEvent_Type)(0), // 1: opencensus.proto.trace.v1.Span.TimeEvent.MessageEvent.Type
	(Span_Link_Type)(0),                   // 2: opencensus.proto.trace.v1.Span.Link.Type
	(*Span)(nil),                          // 3: opencensus.proto.trace.v1.Span
	(*Status)(nil),                        // 4: opencensus.proto.trace.v1.Status
	(*AttributeValue)(nil),                // 5: opencensus.proto.trace.v1.AttributeValue
	(*StackTrace)(nil),                    // 6: opencensus.proto.trace.v1.StackTrace
	(*Module)(nil),                        // 7: opencensus.proto.trace.v1.Module
	(*TruncatableString)(nil),             // 8: opencensus.proto.trace.v1.TruncatableString
	(*Span_Tracestate)(nil),               // 9: opencensus.proto.trace.v1.Span.Tracestate
	(*Span_Attributes)(nil),               // 10: opencensus.proto.trace.v1.Span.Attributes
	(*Span_TimeEvent)(nil),                // 11: opencensus.proto.trace.v1.Span.TimeEvent
	(*Span_TimeEvents)(nil),               // 12: opencensus.proto.trace.v1.Span.TimeEvents
	(*Span_Link)(nil),                     // 13: opencensus.proto.trace.v1.Span.Link
	(*Span_Links)(nil),                    // 14: opencensus.proto.trace.v1.Span.Links
	(*Span_Tracestate_Entry)(nil),         // 15: opencensus.proto.trace.v1.Span.Tracestate.Entry
	nil,                                   // 16: opencensus.proto.trace.v1.Span.Attributes.AttributeMapEntry
	(*Span_TimeEvent_Annotation)(nil),     // 17: opencensus.proto.trace.v1.Span.TimeEvent.Annotation
	(*Span_TimeEvent_MessageEvent)(nil),   // 18: opencensus.proto.trace.v1.Span.TimeEvent.MessageEvent
	(*StackTrace_StackFrame)(nil),         // 19: opencensus.proto.trace.v1.StackTrace.StackFrame
	(*StackTrace_StackFrames)(nil),        // 20: opencensus.proto.trace.v1.StackTrace.StackFrames
	(*timestamppb.Timestamp)(nil),         // 21: google.protobuf.Timestamp
	(*v1.Resource)(nil),                   // 22: opencensus.proto.resource.v1.Resource
	(*wrapperspb.BoolValue)(nil),          // 23: google.protobuf.BoolValue
	(*wrapperspb.UInt32Value)(nil),        // 24: google.protobuf.UInt32Value
}
var file_opencensus_proto_trace_v1_trace_proto_depIdxs = []int32{
	9,  // 0: opencensus.proto.trace.v1.Span.tracestate:type_name -> opencensus.proto.trace.v1.Span.Tracestate
	8,  // 1: opencensus.proto.trace.v1.Span.name:type_name -> opencensus.proto.trace.v1.TruncatableString
	0,  // 2: opencensus.proto.trace.v1.Span.kind:type_name -> opencensus.proto.trace.v1.Span.SpanKind
	21, // 3: opencensus.proto.trace.v1.Span.start_time:type_name -> google.protobuf.Timestamp
	21, // 4: opencensus.proto.trace.v1.Span.end_time:type_name -> google.protobuf.Timestamp
	10, // 5: opencensus.proto.trace.v1.Span.attributes:type_name -> opencensus.proto.trace.v1.Span.Attributes
	6,  // 6: opencensus.proto.trace.v1.Span.stack_trace:type_name -> opencensus.proto.trace.v1.StackTrace
	12, // 7: opencensus.proto.trace.v1.Span.time_events:type_name -> opencensus.proto.trace.v1.Span.TimeEvents
	14, // 8: opencensus.proto.trace.v1.Span.links:type_name -> opencensus.proto.trace.v1.Span.Links
	4,  // 9: opencensus.proto.trace.v1.Span.status:type_name -> opencensus.proto.trace.v1.Status
	22, // 10: opencensus.proto.trace.v1.Span.resource:type_name -> opencensus.proto.resource.v1.Resource
	23, // 11: opencensus.proto.trace.v1.Span.same_process_as_parent_span:type_name -> google.protobuf.BoolValue
	24, // 12: opencensus.proto.trace.v1.Span.child_span_count:type_name -> google.protobuf.UInt32Value
	8,  // 13: opencensus.proto.trace.v1.AttributeValue.string_value:type_name -> opencensus.proto.trace.v1.TruncatableString
	20, // 14: opencensus.proto.trace.v1.StackTrace.stack_frames:type_name -> opencensus.proto.trace.v1.StackTrace.StackFrames
	8,  // 15: opencensus.proto.trace.v1.Module.module:type_name -> opencensus.proto.trace.v1.TruncatableString
	8,  // 16: opencensus.proto.trace.v1.Module.build_id:type_name -> opencensus.proto.trace.v1.TruncatableString
	15, // 17: opencensus.proto.trace.v1.Span.Tracestate.entries:type_name -> opencensus.proto.trace.v1.Span.Tracestate.Entry
	16, // 18: opencensus.proto.trace.v1.Span.Attributes.attribute_map:type_name -> opencensus.proto.trace.v1.Span.Attributes.AttributeMapEntry
	21, // 19: opencensus.proto.trace.v1.Span.TimeEvent.time:type_name -> google.protobuf.Timestamp
	17, // 20: opencensus.proto.trace.v1.Span.TimeEvent.annotation:type_name -> opencensus.proto.trace.v1.Span.TimeEvent.Annotation
	18, // 21: opencensus.proto.trace.v1.Span.TimeEvent.message_event:type_name -> opencensus.proto.trace.v1.Span.TimeEvent.MessageEvent
	11, // 22: opencensus.proto.trace.v1.Span.TimeEvents.time_event:type_name -> opencensus.proto.trace.v1.Span.TimeEvent
	2,  // 23: opencensus.proto.trace.v1.Span.Link.type:type_name -> opencensus.proto.trace.v1.Span.Link.Type
	10, // 24: opencensus.proto.trace.v1.Span.Link.attributes:type_name -> opencensus.proto.trace.v1.Span.Attributes
	9,  // 25: opencensus.proto.trace.v1.Span.Link.tracestate:type_name -> opencensus.proto.trace.v1.Span.Tracestate
	13, // 26: opencensus.proto.trace.v1.Span.Links.link:type_name -> opencensus.proto.trace.v1.Span.Link
	5,  // 27: opencensus.proto.trace.v1.Span.Attributes.AttributeMapEntry.value:type_name -> opencensus.proto.trace.v1.AttributeValue
	8,  // 28: opencensus.proto.trace.v1.Span.TimeEvent.Annotation.description:type_name -> opencensus.proto.trace.v1.TruncatableString
	10, // 29: opencensus.proto.trace.v1.Span.TimeEvent.Annotation.attributes:type_name -> opencensus.proto.trace.v1.Span.Attributes
	1,  // 30: opencensus.proto.trace.v1.Span.TimeEvent.MessageEvent.type:type_name -> opencensus.proto.trace.v1.Span.TimeEvent.MessageEvent.Type
	8,  // 31: opencensus.proto.trace.v1.StackTrace.StackFrame.function_name:type_name -> opencensus.proto.trace.v1.TruncatableString
	8,  // 32: opencensus.proto.trace.v1.StackTrace.StackFrame.original_function_name:type_name -> opencensus.proto.trace.v1.TruncatableString
	8,  // 33: opencensus.proto.trace.v1.StackTrace.StackFrame.file_name:type_name -> opencensus.proto.trace.v1.TruncatableString
	7,  // 34: opencensus.proto.trace.v1.StackTrace.StackFrame.load_module:type_name -> opencensus.proto.trace.v1.Module
	8,  // 35: opencensus.proto.trace.v1.StackTrace.StackFrame.source_version:type_name -> opencensus.proto.trace.v1.TruncatableString
	19, // 36: opencensus.proto.trace.v1.StackTrace.StackFrames.frame:type_name -> opencensus.proto.trace.v1.StackTrace.StackFrame
	37, // [37:37] is the sub-list for method output_type
	37, // [37:37] is the sub-list for method input_type
	37, // [37:37] is the sub-list for extension type_name
	37, // [37:37] is the sub-list for extension extendee
	0,  // [0:37] is the sub-list for field type_name
}

func init() { file_opencensus_proto_trace_v1_trace_proto_init() }
func file_opencensus_proto_trace_v1_trace_proto_init() {
	if File_opencensus_proto_trace_v1_trace_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StackTrace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Module); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TruncatableString); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_Tracestate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_Attributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_TimeEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_TimeEvents); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_Link); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_Links); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_Tracestate_Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_TimeEvent_Annotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_TimeEvent_MessageEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StackTrace_StackFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_trace_v1_trace_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StackTrace_StackFrames); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_opencensus_proto_trace_v1_trace_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*AttributeValue_StringValue)(nil),
		(*AttributeValue_IntValue)(nil),
		(*AttributeValue_BoolValue)(nil),
		(*AttributeValue_DoubleValue)(nil),
	}
	file_opencensus_proto_trace_v1_trace_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*Span_TimeEvent_Annotation_)(nil),
		(*Span_TimeEvent_MessageEvent_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_opencensus_proto_trace_v1_trace_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_opencensus_proto_trace_v1_trace_proto_goTypes,
		DependencyIndexes: file_opencensus_proto_trace_v1_trace_proto_depIdxs,
		EnumInfos:         file_opencensus_proto_trace_v1_trace_proto_enumTypes,
		MessageInfos:      file_opencensus_proto_trace_v1_trace_proto_msgTypes,
	}.Build()
	File_opencensus_proto_trace_v1_trace_proto = out.File
	file_opencensus_proto_trace_v1_trace_proto_rawDesc = nil
	file_opencensus_proto_trace_v1_trace_proto_goTypes = nil
	file_opencensus_proto_trace_v1_trace_proto_depIdxs = nil
}
