---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, légendes
---

# Comment changer l'orientation d'une légende ?

L'extension <ctanpkg:rotating> fournit une commande, habilement nommée 
`\rotcaption`, qui permet de changer l'orientation de la légende. 
Voici un exemple de fonctionnement de cette commande :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{rotating}

\begin{document}
Un peu de texte autour... Un peu de texte autour...
Un peu de texte autour... Un peu de texte autour...
Un peu de texte autour... Un peu de texte autour...
\begin{table}[!ht]
  \begin{minipage}{1cm}
    \rotcaption{La légende}\label{test}
  \end{minipage}
  \centerline{%
  \begin{tabular}{|c|}
    \hline
    Un petit tableau \\
    Avec quelques lignes \\
    Pour voir comment \\
    est placée la légende.\\
    \hline
  \end{tabular}}
\end{table}
Un peu de texte autour... Un peu de texte autour...
Un peu de texte autour... Un peu de texte autour...
Un peu de texte autour... Un peu de texte autour...

Et pour finir, une référence au tableau~\ref{test}.
\end{document}
```

Les environnements `sidewaystable` et `sidewaysfigure` définis 
par cette extension changent automatiquement l'orientation de la légende
avec celle de la table ou de la figure. Noter que dans ce cas, la figure 
sera nécessairement sur une page séparée.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{rotating}

\begin{document}
Un peu de texte avant... Un peu de texte avant...
Un peu de texte avant... Un peu de texte avant...
Un peu de texte avant... Un peu de texte avant...
\begin{sidewaystable}[!ht]
  \caption{La légende}\label{test}
  \centerline{%
  \begin{tabular}{|c|}
    \hline
    Un petit tableau \\
    Avec quelques lignes \\
    Pour voir comment \\
    est placée la légende.\\
    \hline
  \end{tabular}}
\end{sidewaystable}
Un peu de texte après... Un peu de texte après...
Un peu de texte après... Un peu de texte après...
Un peu de texte après... Un peu de texte après...

Et pour finir, une référence au tableau~\ref{test}.
\end{document}
```