use tiny_keccak::{Hasher, ParallelHash};

#[test]
fn test_parallel_hash128_one() {
    let custom_string = b"";
    let input = b"\
        \x00\x01\x02\x03\x04\x05\x06\x07\x10\x11\x12\x13\
        \x14\x15\x16\x17\x20\x21\x22\x23\x24\x25\x26\x27\
    ";
    let block_size = 8;
    let mut phash = ParallelHash::v128(custom_string, block_size);
    let expected = b"\
        \xBA\x8D\xC1\xD1\xD9\x79\x33\x1D\x3F\x81\x36\x03\xC6\x7F\x72\x60\
        \x9A\xB5\xE4\x4B\x94\xA0\xB8\xF9\xAF\x46\x51\x44\x54\xA2\xB4\xF5\
    ";
    let mut output = [0u8; 32];
    phash.update(input);
    phash.finalize(&mut output);
    assert_eq!(expected, &output);
}

#[test]
fn test_parallel_hash128_two() {
    let custom_string = b"Parallel Data";
    let input = b"\
        \x00\x01\x02\x03\x04\x05\x06\x07\x10\x11\x12\x13\
        \x14\x15\x16\x17\x20\x21\x22\x23\x24\x25\x26\x27\
    ";
    let block_size = 8;
    let mut phash = ParallelHash::v128(custom_string, block_size);
    let expected = b"\
        \xFC\x48\x4D\xCB\x3F\x84\xDC\xEE\xDC\x35\x34\x38\x15\x1B\xEE\x58\
        \x15\x7D\x6E\xFE\xD0\x44\x5A\x81\xF1\x65\xE4\x95\x79\x5B\x72\x06\
    ";
    let mut output = [0u8; 32];
    phash.update(input);
    phash.finalize(&mut output);
    assert_eq!(expected, &output);
}

#[test]
fn test_parallel_hash128_three() {
    let custom_string = b"";
    let input = b"\
        \x00\x01\x02\x03\x04\x05\x06\x07\x10\x11\x12\x13\
        \x14\x15\x16\x17\x20\x21\x22\x23\x24\x25\x26\x27\
    ";
    let block_size = 8;
    let mut phash = ParallelHash::v128(custom_string, block_size);
    let expected = b"\
        \xBA\x8D\xC1\xD1\xD9\x79\x33\x1D\x3F\x81\x36\x03\xC6\x7F\x72\x60\
        \x9A\xB5\xE4\x4B\x94\xA0\xB8\xF9\xAF\x46\x51\x44\x54\xA2\xB4\xF5\
    ";
    let mut output = [0u8; 32];
    phash.update(&input[..13]);
    phash.update(&input[13..]);
    phash.finalize(&mut output);
    assert_eq!(expected, &output);
}

#[test]
fn test_parallel_hash256_one() {
    let custom_string = b"";
    let input = b"\
        \x00\x01\x02\x03\x04\x05\x06\x07\x10\x11\x12\x13\
        \x14\x15\x16\x17\x20\x21\x22\x23\x24\x25\x26\x27\
    ";
    let block_size = 8;
    let mut phash = ParallelHash::v256(custom_string, block_size);
    let expected = b"\
        \xBC\x1E\xF1\x24\xDA\x34\x49\x5E\x94\x8E\xAD\x20\x7D\xD9\x84\x22\
        \x35\xDA\x43\x2D\x2B\xBC\x54\xB4\xC1\x10\xE6\x4C\x45\x11\x05\x53\
        \x1B\x7F\x2A\x3E\x0C\xE0\x55\xC0\x28\x05\xE7\xC2\xDE\x1F\xB7\x46\
        \xAF\x97\xA1\xDD\x01\xF4\x3B\x82\x4E\x31\xB8\x76\x12\x41\x04\x29\
    ";
    let mut output = [0u8; 64];
    phash.update(input);
    phash.finalize(&mut output);
    assert_eq!(expected as &[u8], &output as &[u8]);
}

#[test]
fn test_parallel_hash256_two() {
    let custom_string = b"Parallel Data";
    let input = b"\
        \x00\x01\x02\x03\x04\x05\x06\x07\x10\x11\x12\x13\
        \x14\x15\x16\x17\x20\x21\x22\x23\x24\x25\x26\x27\
    ";
    let block_size = 8;
    let mut phash = ParallelHash::v256(custom_string, block_size);
    let expected = b"\
        \xCD\xF1\x52\x89\xB5\x4F\x62\x12\xB4\xBC\x27\x05\x28\xB4\x95\x26\
        \x00\x6D\xD9\xB5\x4E\x2B\x6A\xDD\x1E\xF6\x90\x0D\xDA\x39\x63\xBB\
        \x33\xA7\x24\x91\xF2\x36\x96\x9C\xA8\xAF\xAE\xA2\x9C\x68\x2D\x47\
        \xA3\x93\xC0\x65\xB3\x8E\x29\xFA\xE6\x51\xA2\x09\x1C\x83\x31\x10\
    ";
    let mut output = [0u8; 64];
    phash.update(input);
    phash.finalize(&mut output);
    assert_eq!(expected as &[u8], &output as &[u8]);
}

#[test]
fn test_parallel_hash256_three() {
    let custom_string = b"";
    let input = b"\
        \x00\x01\x02\x03\x04\x05\x06\x07\x10\x11\x12\x13\
        \x14\x15\x16\x17\x20\x21\x22\x23\x24\x25\x26\x27\
    ";
    let block_size = 8;
    let mut phash = ParallelHash::v256(custom_string, block_size);
    let expected = b"\
        \xBC\x1E\xF1\x24\xDA\x34\x49\x5E\x94\x8E\xAD\x20\x7D\xD9\x84\x22\
        \x35\xDA\x43\x2D\x2B\xBC\x54\xB4\xC1\x10\xE6\x4C\x45\x11\x05\x53\
        \x1B\x7F\x2A\x3E\x0C\xE0\x55\xC0\x28\x05\xE7\xC2\xDE\x1F\xB7\x46\
        \xAF\x97\xA1\xDD\x01\xF4\x3B\x82\x4E\x31\xB8\x76\x12\x41\x04\x29\
    ";
    let mut output = [0u8; 64];
    phash.update(&input[..13]);
    phash.update(&input[13..]);
    phash.finalize(&mut output);
    assert_eq!(expected as &[u8], &output as &[u8]);
}
