use strict;
use warnings;

use RT::Test tests => undef;

# create some transactions
my $ticket = RT::Test->create_ticket( Queue => 'General', Subject => 'test ticket' );
my $asset  = RT::Asset->new( RT->SystemUser );
ok( $asset->Create( Catalog => 'General assets', Name => 'test asset' ) );

my $article = RT::Article->new( RT->SystemUser );
ok( $article->Create( Class => 'General', Name => 'test article' ) );

my ( $baseurl, $m ) = RT::Test->started_ok;
$m->login;

# There are a few attributes created by default
for my $object_type ( 'RT::Ticket', 'RT::Asset', 'RT::Article', 'RT::Attribute' ) {
    my $txns = RT::Transactions->new( RT->SystemUser );
    $txns->FromSQL(qq{ObjectType = '$object_type'});
    ok( $txns->Count, 'Found some transactions of $object_type' );
    $m->get_ok(qq{/Search/Results.html?Class=RT::Transactions&ObjectType=$object_type&Query=id>0&OrderBy=id&Format=id});

    if ( $object_type eq 'RT::Ticket' ) {
        $m->text_like(qr/Found \d+ transaction/);
    }
    else {
        $m->text_contains('Found 0 transactions');
    }

    $m->get_ok(qq{/Search/Results.tsv?Class=RT::Transactions&ObjectType=$object_type&Query=id>0&OrderBy=id&Format=id});
    if ( $object_type eq 'RT::Ticket' ) {
        $m->text_like(qr/\d+/, 'Found some transactions');
    }
    else {
        $m->text_unlike(qr/\d+/, 'Found 0 transactions');
    }
}


done_testing;
