% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_hclust.R
\name{model_parameters.hclust}
\alias{model_parameters.hclust}
\title{Parameters from Cluster Models (k-means, ...)}
\usage{
\method{model_parameters}{hclust}(model, data = NULL, clusters = NULL, ...)
}
\arguments{
\item{model}{Cluster model.}

\item{data}{A data frame.}

\item{clusters}{A vector with clusters assignments (must be same length as
rows in data).}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Format cluster models obtained for example by \code{\link[=kmeans]{kmeans()}}.
}
\examples{
\dontshow{if (all(insight::check_if_installed(c("dbscan", "cluster", "fpc"), quietly = TRUE))) withAutoprint(\{ # examplesIf}
\donttest{
#
# K-means -------------------------------
model <- kmeans(iris[1:4], centers = 3)
rez <- model_parameters(model)
rez

# Get clusters
predict(rez)

# Clusters centers in long form
attributes(rez)$means

# Between and Total Sum of Squares
attributes(rez)$Sum_Squares_Total
attributes(rez)$Sum_Squares_Between

#
# Hierarchical clustering (hclust) ---------------------------
data <- iris[1:4]
model <- hclust(dist(data))
clusters <- cutree(model, 3)

rez <- model_parameters(model, data, clusters)
rez

# Get clusters
predict(rez)

# Clusters centers in long form
attributes(rez)$means

# Between and Total Sum of Squares
attributes(rez)$Total_Sum_Squares
attributes(rez)$Between_Sum_Squares

#
# K-Medoids (PAM and HPAM) ==============
model <- cluster::pam(iris[1:4], k = 3)
model_parameters(model)

model <- fpc::pamk(iris[1:4], criterion = "ch")
model_parameters(model)

# DBSCAN ---------------------------
model <- dbscan::dbscan(iris[1:4], eps = 1.45, minPts = 10)

rez <- model_parameters(model, iris[1:4])
rez

# Get clusters
predict(rez)

# Clusters centers in long form
attributes(rez)$means

# Between and Total Sum of Squares
attributes(rez)$Sum_Squares_Total
attributes(rez)$Sum_Squares_Between

# HDBSCAN
model <- dbscan::hdbscan(iris[1:4], minPts = 10)
model_parameters(model, iris[1:4])
}
\dontshow{\}) # examplesIf}
}
