# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementDataCollectionRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_collection_rules_list_by_resource_group(self, resource_group):
        response = self.client.data_collection_rules.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-03-11",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_collection_rules_list_by_subscription(self, resource_group):
        response = self.client.data_collection_rules.list_by_subscription(
            api_version="2023-03-11",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_collection_rules_get(self, resource_group):
        response = self.client.data_collection_rules.get(
            resource_group_name=resource_group.name,
            data_collection_rule_name="str",
            api_version="2023-03-11",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_collection_rules_create(self, resource_group):
        response = self.client.data_collection_rules.create(
            resource_group_name=resource_group.name,
            data_collection_rule_name="str",
            api_version="2023-03-11",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_collection_rules_update(self, resource_group):
        response = self.client.data_collection_rules.update(
            resource_group_name=resource_group.name,
            data_collection_rule_name="str",
            api_version="2023-03-11",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_collection_rules_delete(self, resource_group):
        response = self.client.data_collection_rules.delete(
            resource_group_name=resource_group.name,
            data_collection_rule_name="str",
            api_version="2023-03-11",
        )

        # please add some check logic here by yourself
        # ...
