/* SPDX-FileCopyrightText: 2025 - Sébastien Wilmet
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include <tepl/tepl.h>

static gboolean
metadata_is_present (GtkSourceLanguage *language)
{
	return (gtk_source_language_get_metadata (language, "line-comment-start") != NULL ||
		gtk_source_language_get_metadata (language, "block-comment-start") != NULL ||
		gtk_source_language_get_metadata (language, "block-comment-end") != NULL);
}

static void
test_language (GtkSourceLanguage *language)
{
	GtkSourceView *view;
	GtkSourceBuffer *buffer;
	TeplCodeCommentView *code_comment_view;

	view = GTK_SOURCE_VIEW (gtk_source_view_new ());
	g_object_ref_sink (view);

	buffer = GTK_SOURCE_BUFFER (gtk_text_view_get_buffer (GTK_TEXT_VIEW (view)));
	gtk_source_buffer_set_language (buffer, language);

	code_comment_view = tepl_code_comment_view_new (view);

	if (tepl_code_comment_view_code_comment_is_supported (code_comment_view))
	{
		g_print ("ok");
	}
	else if (metadata_is_present (language))
	{
		g_print ("WARNING: metadata is present but not supported!");
	}
	else
	{
		g_print ("ok, but metadata is not present.");
	}

	g_object_unref (view);
	g_object_unref (code_comment_view);
}

static void
test_all_languages (const gchar *directory)
{
	GtkSourceLanguageManager *language_manager;
	const gchar *search_path[2];
	const gchar * const *language_ids;
	gint i;

	language_manager = gtk_source_language_manager_new ();

	search_path[0] = directory;
	search_path[1] = NULL;
	gtk_source_language_manager_set_search_path (language_manager, (gchar **)search_path);

	language_ids = gtk_source_language_manager_get_language_ids (language_manager);

	for (i = 0; language_ids != NULL && language_ids[i] != NULL; i++)
	{
		const gchar *cur_language_id = language_ids[i];
		GtkSourceLanguage *cur_language;

		cur_language = gtk_source_language_manager_get_language (language_manager, cur_language_id);

		if (!gtk_source_language_get_hidden (cur_language))
		{
			g_print ("%s: ", cur_language_id);
			test_language (cur_language);
			g_print ("\n");
		}
	}

	g_object_unref (language_manager);
}

int
main (int    argc,
      char **argv)
{
	tepl_init ();
	gtk_init (&argc, &argv);

	test_all_languages (GSV_LANG_DIR);

	tepl_finalize ();
	return EXIT_SUCCESS;
}
