/* SPDX-FileCopyrightText: 2010 - Jesse van den Kieboom
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <gtk/gtk.h>

G_BEGIN_DECLS

typedef struct _GtkSourcePixbufHelper GtkSourcePixbufHelper;

G_GNUC_INTERNAL
GtkSourcePixbufHelper *gtk_source_pixbuf_helper_new (void);

G_GNUC_INTERNAL
void gtk_source_pixbuf_helper_free (GtkSourcePixbufHelper *helper);

G_GNUC_INTERNAL
void gtk_source_pixbuf_helper_set_pixbuf (GtkSourcePixbufHelper *helper,
                                          const GdkPixbuf       *pixbuf);

G_GNUC_INTERNAL
GdkPixbuf *gtk_source_pixbuf_helper_get_pixbuf (GtkSourcePixbufHelper *helper);

G_GNUC_INTERNAL
void gtk_source_pixbuf_helper_set_icon_name (GtkSourcePixbufHelper *helper,
                                             const gchar           *icon_name);

G_GNUC_INTERNAL
const gchar *gtk_source_pixbuf_helper_get_icon_name (GtkSourcePixbufHelper *helper);

G_GNUC_INTERNAL
void gtk_source_pixbuf_helper_set_gicon (GtkSourcePixbufHelper *helper,
                                         GIcon                 *gicon);

G_GNUC_INTERNAL
GIcon *gtk_source_pixbuf_helper_get_gicon (GtkSourcePixbufHelper *helper);

G_GNUC_INTERNAL
GdkPixbuf *gtk_source_pixbuf_helper_render (GtkSourcePixbufHelper *helper,
                                            GtkWidget             *widget,
                                            gint                   size);

G_END_DECLS
