# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=sapphirerapids -instruction-tables < %s | FileCheck %s

cmpxchg8b  (%rax)
cmpxchg16b (%rax)
lock cmpxchg8b  (%rax)
lock cmpxchg16b (%rax)

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  16     25    3.50    *      *            cmpxchg8b	(%rax)
# CHECK-NEXT:  22     32    4.00    *      *            cmpxchg16b	(%rax)
# CHECK-NEXT:  16     25    3.50    *      *            lock		cmpxchg8b	(%rax)
# CHECK-NEXT:  22     32    4.00    *      *            lock		cmpxchg16b	(%rax)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SPRPort00
# CHECK-NEXT: [1]   - SPRPort01
# CHECK-NEXT: [2]   - SPRPort02
# CHECK-NEXT: [3]   - SPRPort03
# CHECK-NEXT: [4]   - SPRPort04
# CHECK-NEXT: [5]   - SPRPort05
# CHECK-NEXT: [6]   - SPRPort06
# CHECK-NEXT: [7]   - SPRPort07
# CHECK-NEXT: [8]   - SPRPort08
# CHECK-NEXT: [9]   - SPRPort09
# CHECK-NEXT: [10]  - SPRPort10
# CHECK-NEXT: [11]  - SPRPort11
# CHECK-NEXT: [12]  - SPRPortInvalid

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT: 21.40  10.40  1.33   1.33   2.00   10.40  17.40  2.00   2.00   2.00   4.40   1.33    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT: 4.30   2.80   0.33   0.33   0.50   0.80   4.30   0.50   0.50   0.50   0.80   0.33    -     cmpxchg8b	(%rax)
# CHECK-NEXT: 6.40   2.40   0.33   0.33   0.50   4.40   4.40   0.50   0.50   0.50   1.40   0.33    -     cmpxchg16b	(%rax)
# CHECK-NEXT: 4.30   2.80   0.33   0.33   0.50   0.80   4.30   0.50   0.50   0.50   0.80   0.33    -     lock		cmpxchg8b	(%rax)
# CHECK-NEXT: 6.40   2.40   0.33   0.33   0.50   4.40   4.40   0.50   0.50   0.50   1.40   0.33    -     lock		cmpxchg16b	(%rax)
