# -*- coding: utf-8 -*-

# concertsviewer.py
# This file is part of qarte-4
#    
# Author: Vincent Vande Vyvre <vincent.vandevyvre@oqapy.eu>
# Copyright: 2018 Vincent Vande Vyvre
# Licence: GPL3
# Home page: https://launchpad.net/qarte
#
# List viewer for arte Concerts

from PyQt5.QtCore import Qt, QSize, QCoreApplication
from PyQt5.QtGui import QIcon, QPixmap
from PyQt5.QtWidgets import QListWidget, QListView, QListWidgetItem

class ConcertsViewer(QListWidget):
    def __init__(self, ui, parent=None):
        super().__init__(parent)
        self.ui = ui
        self.core = ui.core
        self.setMaximumSize(QSize(16777215, 200))
        self.setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.setIconSize(QSize(200, 120))
        self.setFlow(QListView.LeftToRight)
        self.setViewMode(QListView.IconMode)
        self.setWrapping(False)
        self.setWordWrap(True)

    def currentChanged(self, current, old):
        self.core.artelive.concert_selection_changed(current)

    def add_item(self, pix, title, link=None, idx=None):
        item = ListItem(pix, title, link, idx)
        self.addItem(item)

    def clean(self):
        QCoreApplication.processEvents()
        self.clearSelection()
        QCoreApplication.processEvents()

    def select_first(self):
        self.setCurrentRow(0)
        

class ListItem(QListWidgetItem):
    def __init__(self, img, text, link, index, parent=None):
        super().__init__(parent)
        icon = QIcon()
        icon.addPixmap(QPixmap(img), QIcon.Normal, QIcon.Off)
        self.setIcon(icon)
        self.setText(text)
        self.link = link
        self.index = index
