package SBOM::CycloneDX::Vulnerability::ProofOfConcept;

use 5.010001;
use strict;
use warnings;
use utf8;

use Types::Standard qw(Str InstanceOf);
use Types::TypeTiny qw(ArrayLike);

use Moo;
use namespace::autoclean;

extends 'SBOM::CycloneDX::Base';

has reproduction_steps => (is => 'rw', isa => Str);
has environment        => (is => 'rw', isa => Str);

has supporting_material => (is => 'rw', isa => ArrayLike [InstanceOf ['SBOM::CycloneDX::Attachment']]);

sub TO_JSON {

    my $self = shift;

    my $json = {};

    $json->{reproductionSteps}  = $self->reproduction_steps  if $self->reproduction_steps;
    $json->{environment}        = $self->environment         if $self->environment;
    $json->{supportingMaterial} = $self->supporting_material if @{$self->supporting_material};

    return $json;

}

1;

=encoding utf-8

=head1 NAME

SBOM::CycloneDX::Vulnerability::ProofOfConcept - Proof of Concept

=head1 SYNOPSIS

    SBOM::CycloneDX::Vulnerability::ProofOfConcept->new();


=head1 DESCRIPTION

L<SBOM::CycloneDX::Vulnerability::ProofOfConcept> Evidence used to
reproduce the vulnerability.

=head2 METHODS

L<SBOM::CycloneDX::Vulnerability::ProofOfConcept> inherits all methods from L<SBOM::CycloneDX::Base>
and implements the following new ones.

=over

=item SBOM::CycloneDX::Vulnerability::ProofOfConcept->new( %PARAMS )

Properties:

=over

=item C<environment>, A description of the environment in which
reproduction was possible.

=item C<reproduction_steps>, Precise steps to reproduce the vulnerability.

=item C<supporting_material>, Supporting material that helps in reproducing
or understanding how reproduction is possible. This may include
screenshots, payloads, and PoC exploit code.

=back

=item $proof_of_concept->environment

=item $proof_of_concept->reproduction_steps

=item $proof_of_concept->supporting_material

=back


=head1 SUPPORT

=head2 Bugs / Feature Requests

Please report any bugs or feature requests through the issue tracker
at L<https://github.com/giterlizzi/perl-SBOM-CycloneDX/issues>.
You will be notified automatically of any progress on your issue.

=head2 Source Code

This is open source software.  The code repository is available for
public review and contribution under the terms of the license.

L<https://github.com/giterlizzi/perl-SBOM-CycloneDX>

    git clone https://github.com/giterlizzi/perl-SBOM-CycloneDX.git


=head1 AUTHOR

=over 4

=item * Giuseppe Di Terlizzi <gdt@cpan.org>

=back


=head1 LICENSE AND COPYRIGHT

This software is copyright (c) 2025-2026 by Giuseppe Di Terlizzi.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
