/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/*************************************************************** -*- c -*-
 * perl5/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Perl_TypeRegister
#define SWIG_TypeCheck       SWIG_Perl_TypeCheck
#define SWIG_TypeCast        SWIG_Perl_TypeCast
#define SWIG_TypeDynamicCast SWIG_Perl_TypeDynamicCast
#define SWIG_TypeName        SWIG_Perl_TypeName
#define SWIG_TypeQuery       SWIG_Perl_TypeQuery
#define SWIG_TypeClientData  SWIG_Perl_TypeClientData
#define SWIG_PackData        SWIG_Perl_PackData 
#define SWIG_UnpackData      SWIG_Perl_UnpackData 


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* ---------------------------------------------------------------------- -*- c -*-
 * perl5.swg
 *
 * Perl5 runtime library
 * $Header: /cvsroot/SWIG/Lib/perl5/perlrun.swg,v 1.14 2003/12/04 19:14:14 beazley Exp $
 * ----------------------------------------------------------------------------- */

#define SWIGPERL
#define SWIGPERL5
#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Get rid of free and malloc defined by perl */
#undef free
#undef malloc

#ifndef pTHX_
#define pTHX_
#endif

#include <string.h>
#ifdef __cplusplus
}
#endif

/* Macro to call an XS function */

#ifdef PERL_OBJECT 
#  define SWIG_CALLXS(_name) _name(cv,pPerl) 
#else 
#  ifndef MULTIPLICITY 
#    define SWIG_CALLXS(_name) _name(cv) 
#  else 
#    define SWIG_CALLXS(_name) _name(PERL_GET_THX, cv) 
#  endif 
#endif 

/* Contract support */

#define SWIG_contract_assert(expr,msg) if (!(expr)) { SWIG_croak(msg); } else

/* Note: SwigMagicFuncHack is a typedef used to get the C++ compiler to just shut up already */

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
typedef int (CPerlObj::*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (CPerlObj::*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
#define SWIGCLASS_STATIC
#else
#define MAGIC_PPERL
#define SWIGCLASS_STATIC static
#ifndef MULTIPLICITY
#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif


#else
#define SWIG_MAGIC(a,b) (struct interpreter *interp, SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#endif
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

/* Modifications for newer Perl 5.005 releases */

#if !defined(PERL_REVISION) || ((PERL_REVISION >= 5) && ((PERL_VERSION < 5) || ((PERL_VERSION == 5) && (PERL_SUBVERSION < 50))))
#  ifndef PL_sv_yes
#    define PL_sv_yes sv_yes
#  endif
#  ifndef PL_sv_undef
#    define PL_sv_undef sv_undef
#  endif
#  ifndef PL_na
#    define PL_na na
#  endif
#endif

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_OWNER 1
#define SWIG_SHADOW 2

/* Common SWIG API */

#ifdef PERL_OBJECT
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(pPerl, obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(pPerl, p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(pPerl, sv, p, s, type)
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(pPerl, obj, p, s, type, flags)

#else
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(sv, p, s, type )
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(obj, p, s, type, flags)
#endif

/* Perl-specific API */
#ifdef PERL_OBJECT
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(pPerl, sv, ptr, type, flags)
#  define SWIG_TypeCheckRV(rv, ty) \
     SWIG_Perl_TypeCheckRV(pPerl, rv, ty)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(pPerl, str)
#else
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(sv, ptr, type, flags)
#  define SWIG_TypeCheckRV(rv, ty) \
     SWIG_Perl_TypeCheckRV(rv, ty)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(str)
#  define SWIG_SetErrorSV(str) \
     SWIG_Perl_SetErrorSV(str)
#endif

#define SWIG_SetErrorf SWIG_Perl_SetErrorf


#ifdef PERL_OBJECT
#  define SWIG_MAYBE_PERL_OBJECT CPerlObj *pPerl,
#else
#  define SWIG_MAYBE_PERL_OBJECT
#endif

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(int)               SWIG_Perl_ConvertPtr(SWIG_MAYBE_PERL_OBJECT SV *, void **, swig_type_info *, int flags);
SWIGIMPORT(void)              SWIG_Perl_MakePtr(SWIG_MAYBE_PERL_OBJECT SV *, void *, swig_type_info *, int flags);
SWIGIMPORT(SV *)              SWIG_Perl_NewPointerObj(SWIG_MAYBE_PERL_OBJECT void *, swig_type_info *, int flags);
SWIGIMPORT(void)              SWIG_Perl_MakePackedObj(SWIG_MAYBE_PERL_OBJECT SV *, void *, int, swig_type_info *);
SWIGIMPORT(int)               SWIG_Perl_ConvertPacked(SWIG_MAYBE_PERL_OBJECT SV *, void *, int, swig_type_info *, int flags);
SWIGIMPORT(swig_type_info *)  SWIG_Perl_TypeCheckRV(SWIG_MAYBE_PERL_OBJECT SV *rv, swig_type_info *ty);
SWIGIMPORT(SV *)              SWIG_Perl_SetError(SWIG_MAYBE_PERL_OBJECT char *);

#else

SWIGRUNTIME(swig_type_info *)
SWIG_Perl_TypeCheckRV(SWIG_MAYBE_PERL_OBJECT SV *rv, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (sv_derived_from(rv, (char *) s->name)) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Function for getting a pointer value */

SWIGRUNTIME(int) 
SWIG_Perl_ConvertPtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void **ptr, swig_type_info *_t, int flags) {
  swig_type_info *tc;
  void *voidptr = (void *)0;

  /* If magical, apply more magic */
  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    IV tmp = 0;
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
        mg = mg_find(tsv,'P');
        if (mg) {
          SV *rsv = mg->mg_obj;
          if (sv_isobject(rsv)) {
            tmp = SvIV((SV*)SvRV(rsv));
          }
        }
      } else {
        return -1;
      }
    } else {
      tmp = SvIV((SV*)SvRV(sv));
    }
    voidptr = (void *)tmp;
    if (!_t) {
      *(ptr) = voidptr;
      return 0;
    }
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return 0;
  } else if (SvTYPE(sv) == SVt_RV) {  /* Check for NULL pointer */
    *(ptr) = (void *) 0;
    if (!SvROK(sv))
      return 0;
    else
      return -1;
  } else {                            /* Don't know what it is */
    *(ptr) = (void *) 0;
    return -1;
  }
  if (_t) {
    /* Now see if the types match */
    tc = SWIG_TypeCheckRV(sv,_t);
    if (!tc) {
      *ptr = voidptr;
      return -1;
    }
    *ptr = SWIG_TypeCast(tc,voidptr);
    return 0;
  }
  *ptr = voidptr;
  return 0;
}

SWIGRUNTIME(void)
SWIG_Perl_MakePtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, swig_type_info *t, int flags) {
  if (ptr && (flags & SWIG_SHADOW)) {
    SV *self;
    SV *obj=newSV(0);
    HV *hash=newHV();
    HV *stash;
    sv_setref_pv(obj, (char *) t->name, ptr);
    stash=SvSTASH(SvRV(obj));
    if (flags & SWIG_OWNER) {
      HV *hv;
      GV *gv=*(GV**)hv_fetch(stash, "OWNER", 5, TRUE);
      if (!isGV(gv))
        gv_init(gv, stash, "OWNER", 5, FALSE);
      hv=GvHVn(gv);
      hv_store_ent(hv, obj, newSViv(1), 0);
    }
    sv_magic((SV *)hash, (SV *)obj, 'P', Nullch, 0);
    SvREFCNT_dec(obj);
    self=newRV_noinc((SV *)hash);
    sv_setsv(sv, self);
    SvREFCNT_dec((SV *)self);
    sv_bless(sv, stash);
  }
  else {
    sv_setref_pv(sv, (char *) t->name, ptr);
  }
}

SWIGRUNTIME(SV *)
SWIG_Perl_NewPointerObj(SWIG_MAYBE_PERL_OBJECT void *ptr, swig_type_info *t, int flags) {
  SV *result = sv_newmortal();
  SWIG_MakePtr(result, ptr, t, flags);
  return result;
}

SWIGRUNTIME(void)
  SWIG_Perl_MakePackedObj(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  sv_setpv(sv, result);
}

/* Convert a packed value value */
SWIGRUNTIME(int)
SWIG_Perl_ConvertPacked(SWIG_MAYBE_PERL_OBJECT SV *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c = 0;

  if ((!obj) || (!SvOK(obj))) return -1;
  c = SvPV(obj, PL_na);
  /* Pointer values must start with leading underscore */
  if (*c != '_') return -1;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) return -1;
  }
  return 0;
}

SWIGRUNTIME(void)
SWIG_Perl_SetError(SWIG_MAYBE_PERL_OBJECT const char *error) {
  if (error) sv_setpv(perl_get_sv("@", TRUE), error);
}

SWIGRUNTIME(void)
SWIG_Perl_SetErrorSV(SWIG_MAYBE_PERL_OBJECT SV *error) {
  if (error) sv_setsv(perl_get_sv("@", TRUE), error);
}

SWIGRUNTIME(void)
SWIG_Perl_SetErrorf(const char *fmt, ...) {
  va_list args;
  va_start(args, fmt);
  sv_vsetpvfn(perl_get_sv("@", TRUE), fmt, strlen(fmt), &args, Null(SV**), 0, Null(bool*));
  va_end(args);
}

#endif

/* Macros for low-level exception handling */
#define SWIG_fail       goto fail
#define SWIG_croak(x)   { SWIG_SetError(x); goto fail; }
#define SWIG_croakSV(x) { SWIG_SetErrorSV(x); goto fail; }
/* most preprocessors do not support vararg macros :-( */
/* #define SWIG_croakf(x...) { SWIG_SetErrorf(x); goto fail; } */


typedef XS(SwigPerlWrapper);
typedef SwigPerlWrapper *SwigPerlWrapperPtr;

/* Structure for command table */
typedef struct {
  const char         *name;
  SwigPerlWrapperPtr  wrapper;
} swig_command_info;

/* Information for constant table */

#define SWIG_INT     1
#define SWIG_FLOAT   2
#define SWIG_STRING  3
#define SWIG_POINTER 4
#define SWIG_BINARY  5

/* Constant information structure */
typedef struct swig_constant_info {
    int              type;
    const char      *name;
    long             lvalue;
    double           dvalue;
    void            *pvalue;
    swig_type_info **ptype;
} swig_constant_info;

#ifdef __cplusplus
}
#endif

/* Structure for variable table */
typedef struct {
  const char   *name;
  SwigMagicFunc   set;
  SwigMagicFunc   get;
  swig_type_info  **type;
} swig_variable_info;

/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
  #ifndef MULTIPLICITY
     static void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int (*get)(SV *,MAGIC *)) {
  #else
     static void _swig_create_magic(SV *sv, char *name, int (*set)(struct interpreter*, SV *, MAGIC *), int (*get)(struct interpreter*, SV *,MAGIC *)) {
  #endif
#else
#  define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
static void _swig_create_magic(CPerlObj *pPerl, SV *sv, const char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) {
#endif
  MAGIC *mg;
  sv_magic(sv,sv,'U',(char *) name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = (SwigMagicFuncHack) get;
  mg->mg_virtual->svt_set = (SwigMagicFuncHack) set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}






#ifdef do_open
  #undef do_open
#endif
#ifdef do_close
  #undef do_close
#endif
#ifdef scalar
  #undef scalar
#endif
#ifdef list
  #undef list
#endif
#ifdef apply
  #undef apply
#endif
#ifdef convert
  #undef convert
#endif
#ifdef Error
  #undef Error
#endif
#ifdef form
  #undef form
#endif
#ifdef vform
  #undef vform
#endif
#ifdef LABEL
  #undef LABEL
#endif
#ifdef METHOD
  #undef METHOD
#endif
#ifdef Move
  #undef Move
#endif
#ifdef yylex
  #undef yylex
#endif
#ifdef yyparse
  #undef yyparse
#endif
#ifdef yyerror
  #undef yyerror
#endif
#ifdef invert
  #undef invert
#endif
#ifdef ref
  #undef ref
#endif
#ifdef ENTER
  #undef ENTER
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_unsigned_char swig_types[0] 
#define  SWIGTYPE_p_GDC_HOLD_IMAGE_T swig_types[1] 
#define  SWIGTYPE_p_scatter swig_types[2] 
#define  SWIGTYPE_p_unsigned_long swig_types[3] 
#define  SWIGTYPE_p_float swig_types[4] 
#define  SWIGTYPE_p_unsigned_int swig_types[5] 
#define  SWIGTYPE_p_void swig_types[6] 
#define  SWIGTYPE_p_short swig_types[7] 
#define  SWIGTYPE_p_p_char swig_types[8] 
#define  SWIGTYPE_p_gdchart_img swig_types[9] 
#define  SWIGTYPE_p_HV swig_types[10] 
#define  SWIGTYPE_p_FILE swig_types[11] 
#define  SWIGTYPE_p_GDC_ANNOTATION_T swig_types[12] 
#define  SWIGTYPE_p_GDC_SCATTER_T swig_types[13] 
#define  SWIGTYPE_p_int swig_types[14] 
#define  SWIGTYPE_p_gdchart swig_types[15] 
#define  SWIGTYPE_p_note swig_types[16] 
static swig_type_info *swig_types[18];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    boot_GD__Chart

#define SWIG_name   "GD::Chartc::boot_GD__Chart"
#define SWIG_prefix "GD::Chartc::"

#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
#ifndef MULTIPLICITY
SWIGEXPORT(void) SWIG_init (CV* cv);
#else
SWIGEXPORT(void) SWIG_init (pTHXo_ CV* cv);
#endif
#else
SWIGEXPORT(void) SWIG_init (CV *cv, CPerlObj *);
#endif


#include "gdc.h"
#include "gdcpie.h"
#include "gdchart.h"
#include "gd_obj.h"
#include "math.h"

note *new_note(char *msg,unsigned long col,int point,enum GDC_font_size font_size,char *tt_font,double tt_size){
			note *n;
			n = malloc(sizeof(note));
			n->n = malloc(sizeof(GDC_ANNOTATION_T));
			strncpy(n->n->note, msg, MAX_NOTE_LEN);
			n->n->color = col;
			n->n->point = point;
			GDC_annotation = n->n;
			GDC_annotation_font_size = font_size;
#ifdef HAVE_LIBFREETYPE
			GDC_annotation_font = tt_font;
			GDC_annotation_ptsize = tt_size;
#endif
			return n;
		}
void delete_note(note *self){
			if(self->n)
				free(self->n);

			free(self);
		}
void note_setnote(note *self,char *msg){
			strncpy(self->n->note, msg, MAX_NOTE_LEN);
		}
void note_col(note *self,unsigned long c){
			self->n->color = c;
		}
void note_point(note *self,unsigned long p){
			self->n->point = p;
		}
void note_font(note *self,enum GDC_font_size size){
			GDC_annotation_font_size = size;
		}
void note_tt_font(note *self,char *fontname){
#ifdef HAVE_LIBFREETYPE
			GDC_annotation_font = fontname;
#endif
		}
void note_tt_font_size(note *self,double size){
#ifdef HAVE_LIBFREETYPE
			GDC_annotation_ptsize = size;
#endif
		}
scatter *new_scatter(int num){
			scatter *s;
			s = malloc(sizeof(scatter));
			s->num = num;
			s->set = 0;
			if(num)
				s->s = malloc(sizeof(GDC_SCATTER_T) * num);

			GDC_scatter = s->s;
			GDC_num_scatter_pts = 0;

			return s;
		}
void delete_scatter(scatter *self){

			if(self->s) {
				free(self->s);
			}

			free(self);
		}
int scatter_add(scatter *self,float p,float v,unsigned short w,unsigned long c,GDC_SCATTER_IND_T i){

			if(self->set >= self->num) {	
				self->num++;
				self->s = realloc(self->s, sizeof(GDC_SCATTER_T) * (self->num));
			}

			self->s[self->set].point = p;
			self->s[self->set].val = v;
			self->s[self->set].width = w;
			self->s[self->set].color = c;
			self->s[self->set].ind = i;

			self->set++;
			GDC_num_scatter_pts++;
		}

typedef union {
		GDC_CHART_T chart;
		GDCPIE_TYPE pie;
	} gdchart_img;


gdchart *new_gdchart(int w,int h){
	gdchart *c;
	c = malloc(sizeof(gdchart));
	c->w = w;
	c->h = h;
	c->flags = 0;
	c->title = NULL;
	c->type = 0;
	c->data = c->vol = NULL;
	c->cols = NULL;
	c->angle_3d = c->depth_3d = 0;
	c->output = NULL;
	c->title_size = c->label_size = GDC_MEDBOLD;
	c->plotcolour = c->linecolour =  c->bgcolour = 0x000000L;
	c->labels = NULL;

	return c;
}
void delete_gdchart(gdchart *self){


	if(self->flags & CLOSE_FD) {
		if(self->output != NULL) {
			fclose(self->output);
		}
	}

	if(self->cols) { free(self->cols); }

	if(self->title) { free(self->title); }

	if(self->data) { free(self->data); }

	if(self->vol) { free(self->vol); }

	if(self->labels) { free(self->labels); }

	free(self);

}
void gdchart_options(gdchart *self,HV *h){
	I32 size, keylen;
	char *key;
	SV *val;

	/* Initilize hash */

	size = hv_iterinit(h);

	/* Traverse hash */

	while(size--) {
		
		val = hv_iternextsv(h, &key, &keylen);

		if(! strcmp("ytitle", key)) { 
			char *a;
			int len;
			if(SvPOK(val)) {
				a = SvPV(val, len);
				GDC_ytitle = malloc(len+1);
				strcpy(GDC_ytitle, a);
			}
		} else if(! strcmp("xtitle", key)) {
			char *a;
			int len;
			if(SvPOK(val)) {
				a = SvPV(val, len);
				GDC_xtitle = malloc(len+1);
				strcpy(GDC_xtitle, a);
			}
		} else if(! strcmp("ytitle2", key)) {
			char *a;
			int len;
			if(SvPOK(val)) {
				a = SvPV(val, len);
				GDC_ytitle2 = malloc(len+1);
				strcpy(GDC_ytitle2, a);
			}
		} else if(! strcmp("title", key)) {
			char *a;
			int len=0;
			if(SvPOK(val)) {
				a = SvPV(val, len);
				self->title = malloc(len+1);
				strcpy(self->title, a);
			}
		} else if(! strcmp("title_size", key)) {
			if(SvIOK(val))
			  self->title_size = SvIV(val);	
		} else if(! strcmp("ytitle_size", key)) {
			if(SvIOK(val))
				GDC_ytitle_size = (enum GDC_font_size)SvIV(val);
		} else if(! strcmp("xtitle_size", key)) {
			if(SvIOK(val))
				GDC_xtitle_size = (enum GDC_font_size)SvIV(val);
		} else if(! strcmp("yaxisfont_size", key)) {
			if(SvIOK(val))
			   GDC_yaxisfont_size = (enum GDC_font_size)SvIV(val);
		} else if(! strcmp("xaxisfont_size", key)) {
			if(SvIOK(val))
			   GDC_xaxisfont_size = (enum GDC_font_size)SvIV(val);
		} else if(! strcmp("ylabel2_fmt", key)) {
			char *a;
			int len;
			if(SvPOK(val)) {
			  a = SvPV(val, len);
			  GDC_ylabel2_fmt = malloc(len+1);
			  strcpy(GDC_ylabel2_fmt, a);
			}
		} else if(! strcmp("xlabel_ctl", key)) {
			char *a;
			int len;
			if(SvPOK(val)) {
			  a = SvPV(val, len);
			  GDC_xlabel_ctl = malloc(len+1);
			  strcpy(GDC_xlabel_ctl, a);
			}
		} else if(! strcmp("xlabel_spacing", key)) {
			if(SvIOK(val))
			  GDC_xlabel_spacing = (short)SvIV(val);
		} else if(! strcmp("ylabel_density", key)) {
			if(SvIOK(val))
			  GDC_ylabel_density = (char)SvIV(val);
		} else if(! strcmp("interpolations", key)) {
			if(SvIOK(val))
			  GDC_interpolations = (char)SvIV(val);
		} else if(! strcmp("requested_ymin", key)) {
			if(SvNOK(val))
			  GDC_requested_ymin = (float)SvNV(val);
		} else if(! strcmp("requested_ymax", key)) {
			if(SvNOK(val))
			  GDC_requested_ymax = (float)SvNV(val);
		} else if(! strcmp("requested_yinterval", key)) {
			if(SvNOK(val))
			  GDC_requested_yinterval =(float)SvNV(val);
		} else if(! strcmp("0Shelf", key)) {
			if(SvIOK(val))
			  GDC_0Shelf = (char)SvIV(val);
		} else if(! strcmp("grid", key)) {
			if(SvIOK(val))
			  GDC_grid = (GDC_TICK_T)SvIV(val);
		} else if(! strcmp("ticks", key)) {
			if(SvIOK(val))
			  GDC_ticks = (GDC_TICK_T)SvIV(val);
		} else if(! strcmp("xaxis", key)) {
			if(SvIOK(val))
			  GDC_xaxis = (char)SvIV(val);
		} else if(! strcmp("yaxis", key)) {
			if(SvIOK(val))
			  GDC_yaxis = (char)SvIV(val);
		} else if(! strcmp("yaxis2", key)) {
			if(SvIOK(val))
			  GDC_yaxis2 = (char)SvIV(val);
		} else if(! strcmp("yval_style", key)) {
			if(SvIOK(val))
			  GDC_yval_style = (char)SvIV(val);
		} else if(! strcmp("stack_type", key)) {
			if(SvIOK(val))
			  GDC_stack_type = (GDC_STACK_T)SvIV(val);
		} else if(! strcmp("3d_depth", key)) {
			if(SvNOK(val))
			  self->depth_3d = (float)SvNV(val);
		} else if(! strcmp("3d_angle", key)) {
			if(SvIOK(val))
			  self->angle_3d = (unsigned char)SvIV(val);
		} else if(! strcmp("bar_width", key)) {
			if(SvIOK(val))
			  GDC_bar_width = (unsigned char)SvIV(val);
		} else if(! strcmp("hlc_style", key)) {
			if(SvIOK(val))
			  GDC_HLC_style = (GDC_HLC_STYLE_T)SvIV(val);
		} else if(! strcmp("hlc_cap_width", key)) {
			if(SvIOK(val))
			  GDC_HLC_cap_width = (unsigned char)SvIV(val);
		} else if(! strcmp("annotation_font_size", key)) {
			if(SvIOK(val))
			  GDC_annotation_font_size = (enum GDC_font_size)SvIV(val);

#ifdef HAVE_LIBFREETYPE
		} else if(! strcmp("annotation_font", key)) {
			char *a;
			int len;

			if(SvPOK(val)) {
				a = SvPV(val, len);
				GDC_annotation_font = malloc(len+1);
				strcpy(GDC_annotation_font, a);
			}
		} else if(! strcmp("annotation_font_ptsize", key)) {
			if(svNOK(val))
				GDC_annotation_ptsize = (double)SvNV(val);
#endif
		} else if(! strcmp("thumbnail", key)) {
			if(SvIOK(val))
			  GDC_thumbnail = (char)SvIV(val);
		} else if(! strcmp("thumblabel", key)) {
			char *a;
			int len;
			if(SvPOK(val)) {
			  a = SvPV(val, len);
			  GDC_thumblabel  = malloc(len+1);
			  strcpy(GDC_thumblabel, a);
			}
		} else if(! strcmp("thumbval", key)) {
			if(SvNOK(val))
			  GDC_thumbval = (float)SvNV(val);
		} else if(! strcmp("border", key)) {
			if(SvIOK(val))
			  GDC_border = (GDC_BORDER_T)SvIV(val);
		} else if(! strcmp("bgcolor", key) || !strcmp("bgcolour",key)) {
			if(SvIOK(val))
				self->bgcolour = (unsigned long)SvIV(val);
		} else if(! strcmp("gridcolor", key) || !strcmp("gridcolour", key)) {
			if(SvIOK(val))
				GDC_GridColor = (unsigned long)SvIV(val);
		} else if(! strcmp("linecolor", key) || !strcmp("linecolour", key)) {
			if(SvIOK(val))
				self->linecolour = (unsigned long)SvIV(val);
		} else if(! strcmp("plotcolor", key) || !strcmp("plotcolour", key)) {
			if(SvIOK(val))
				self->plotcolour = (unsigned long)SvIV(val);
		} else if(! strcmp("volcolor", key) || !strcmp("volcolour", key)) {
			if(SvIOK(val))
				GDC_VolColor = (unsigned long)SvIV(val);
		} else if(! strcmp("titlecolor", key) || !strcmp("titlecolour", key)) {
			if(SvIOK(val))
				GDC_TitleColor = (unsigned long)SvIV(val);
		} else if(! strcmp("xtitlecolor", key) || !strcmp("xititlecolour", key)) {
			if(SvIOK(val))
				GDC_XTitleColor = (unsigned long)SvIV(val);
		} else if(! strcmp("ytitlecolor", key) || !strcmp("ytitlecolour", key)) {
			if(SvIOK(val))
				GDC_YTitleColor = (unsigned long)SvIV(val);
		} else if(! strcmp("ytitle2color", key) || !strcmp("ytitle2colour", key)) {
			if(SvIOK(val))
				GDC_YTitle2Color = (unsigned long)SvIV(val);
		} else if(! strcmp("xlabelcolor", key) || !strcmp("xlabelcolour", key)) {
			if(SvIOK(val))
				GDC_XLabelColor = (unsigned long)SvIV(val);
		} else if(! strcmp("ylabelcolor", key) || !strcmp("ylabelcolour", key)) {
			if(SvIOK(val))
				GDC_YLabelColor = (unsigned long)SvIV(val);
		} else if(! strcmp("ylabel2color", key) || !strcmp("ylabel2colour", key)) {
			if(SvIOK(val))
				GDC_YLabel2Color = (unsigned long)SvIV(val);
		} else if(! strcmp("extvolcolor", key) || !strcmp("extvolcolour", key)) {
			AV *tempav;
			I32 len,i;
			SV **tv;
			if(!SvROK(val)) {
			  croak("Need to be passed ref to extvolcolor array");
			}
			if(SvTYPE(SvRV(val)) != SVt_PVAV) {
			  croak("Need to be passed ref to extvolcolor array");
			}
			tempav = (AV*)SvRV(val);
			len = av_len(tempav);
			GDC_ExtVolColor = malloc((len+2)*sizeof(unsigned long));
			for(i=0;i<=len;i++) {
			  tv = av_fetch(tempav, i, 0);
			  GDC_ExtVolColor[i] = (unsigned long)SvIV(*tv);
			}
			GDC_ExtVolColor[i] = 0;
		} else if(! strcmp("color", key) || ! strcmp("colors", key) || !strcmp("colour", key) || !strcmp("colours", key)) {
			AV *tempav;
			I32 len, i;
			SV **tv;
			if(!SvROK(val)) {
			  croak("Need to be passed ref to colour array");
			}
			if(SvTYPE(SvRV(val)) != SVt_PVAV) {
			  croak("Need to be passed ref to colour array");
			}
			tempav = (AV*)SvRV(val);
			len = av_len(tempav);
			self->cols = malloc((len+2) * sizeof(unsigned long));
			for(i=0;i<=len;i++) {
			  tv = av_fetch(tempav, i, 0);
			  self->cols[i] = (unsigned long)SvIV(*tv);
			}
			self->cols[i] = 0;
		} else if(! strcmp("extcolor", key) || ! strcmp("extcolour", key)) {
			AV *tempav;
			I32 len, i;
			SV **tv;
			if(!SvROK(val)) {
			  croak("Need to be passed ref to extcolour array");
			}
			if(SvTYPE(SvRV(val)) != SVt_PVAV) {
			  croak("Need to be passed ref to array");
			}
			tempav = (AV*)SvRV(val);
			len = av_len(tempav);
			GDC_ExtColor = malloc((len+2) * sizeof(unsigned long));
			for(i=0;i<=len;i++) {
			  tv = av_fetch(tempav, i, 0);
			  GDC_ExtColor[i] = (unsigned long)SvIV(*tv);
			}
			GDC_ExtColor[i] = 0;
		} else if(! strcmp("transparent_bg", key)) {
			if(SvIOK(val))
				GDC_transparent_bg = (char)SvIV(val);
		} else if(! strcmp("bgimage", key)) {
			char *a;
			int len;
			if(SvPOK(val)) {
				a = SvPV(val, len);
				GDC_BGImage = malloc(len+1);
				strcpy(GDC_BGImage, a);
			}
		} else if(! strcmp("pie_type", key)) {
			if(SvIOK(val)) {
				self->type = PIE;
				self->img.pie = SvIV(val);
			}
		} else if(! strcmp("chart_type", key)) {
			if(SvIOK(val)) {
				self->type = CHART;
				self->img.chart = SvIV(val);
			}
		} else if(! strcmp("image_type", key)) {
			if(SvIOK(val)) 
				GDC_image_type = (GDC_image_type_t)SvIV(val);
		} else if(! strcmp("jpeg_quality", key)) {
			if(SvIOK(val))
				GDC_jpeg_quality = SvIV(val);

						/* Now Pie Chart Options */

		} else if(! strcmp("other_threshold", key)) {
			if(SvIOK(val))
				GDCPIE_other_threshold = (char)SvIV(val);
		} else if(! strcmp("edge_color", key) || !strcmp("edge_colour", key)) {
			if(SvIOK(val))
				GDCPIE_EdgeColor = (unsigned long)SvIV(val);
		} else if(! strcmp("label_size", key)) {
			if(SvIOK(val))
				GDCPIE_label_size=(enum GDC_font_size)SvIV(val);
#ifdef HAVE_LIBFREETYPE
		} else if(! strcmp("label_font", key)) {
			char *a;
			int len;

			if(SvPOK(val)) {
				a = SvPV(val, len);
				GDCPIE_label_font = malloc(len+1);
				strcpy(GDCPIE_label_font, a);
			}
		} else if(! strcmp("label_font_ptsize", key)) {
			if(svNOK(val))
				GDCPIE_label_ptsize = (double)SvNV(val);
#endif
		} else if(! strcmp("label_font", key)) {

		} else if(! strcmp("label_dist", key)) {
			if(SvIOK(val))
				GDCPIE_label_dist = SvIV(val);
		} else if(! strcmp("label_line", key)) {
			if(SvIOK(val))
				GDCPIE_label_line = (char)SvIV(val);
		} else if(! strcmp("explode", key)) {
			AV *tempav;
			I32 len,i;
			SV **tv;
			if(!SvROK(val))
			  croak("Need to pass ref to explode array");
			if(SvTYPE(SvRV(val)) != SVt_PVAV)
			  croak("Need to pass ref to explode array");
			tempav = (AV*)SvRV(val);
			len = av_len(tempav);
			GDCPIE_explode = malloc((len+2) * sizeof(int));
			for(i = 0; i <= len; i++) {
			  tv = av_fetch(tempav, i, 0);
			  GDCPIE_explode[i] = SvIV(*tv);
			}
			GDCPIE_explode[i] = 0;
		} else if(! strcmp("missing", key)) {
			AV *tempav;
			I32 len, i;
			SV **tv;

			if(!SvROK(val))
			  croak("Need to pass ref to missing array");
			if(SvTYPE(SvRV(val)) != SVt_PVAV)
			  croak("Need to pass ref to missing array");
			tempav = (AV*)SvRV(val);
			len = av_len(tempav);
			GDCPIE_missing = malloc((len+2) * sizeof(int));
			for(i = 0; i <= len; i++) {
			  tv = av_fetch(tempav, i, 0);
			  GDCPIE_missing[i] = SvIV(*tv);
			}
			GDCPIE_missing[i] = 0;
		} else if(! strcmp("percent_labels", key)) {
			if(SvIOK(val))
			   GDCPIE_percent_labels = (GDCPIE_PCT_TYPE)SvIV(val);
		} else if(! strcmp("percent_fmt", key)) {
			char *a;
			int len;
			if(SvPOK(val)) {
			   a = SvPV(val, len);
			   GDCPIE_percent_fmt = malloc(len+1);
			   strcpy(GDCPIE_percent_fmt, a);
			}
		} else if(! strcmp("volume", key))  {
		  AV *tempav;
		  I32 len, i;
		  SV **tv;
		  if(!SvROK(val)) {
		    croak("Need ref to array");
		  }
		  if(SvTYPE(SvRV(val)) != SVt_PVAV)
		    croak("Need ref to array");
		  tempav = (AV*)SvRV(val);
		  len = av_len(tempav);
		  self->vol = malloc((len+2) * sizeof(float));
		  for(i=0; i<= len; i++) {
		    tv = av_fetch(tempav, i, 0);
		    self->vol[i] = (float)SvNV(*tv);
		  }
		  self->vol[i] = 0;
		} else if(! strcmp("data", key)) {
		  SV **ref, **ref2;
		  AV *tempav, *temp2av;
		  I32 sets, points,sets2, i, j, total;
		  char seen_ref = 0, seen_val = 0;

		 /* The graph type may not be set yet, so we copy the
		    data and guess at what it might be. The real sorting
		    of the data takes place in the draw code which must
		    know the graph type 
		 */

		  sets = points = sets2 = total = 0;
		  seen_ref = seen_val  = 0;

		  if(SvTYPE(val) != SVt_RV) {
		      croak("Data must be a reference to array");
		  }

		  if(SvTYPE(SvRV(val)) != SVt_PVAV) {
		      croak("Data must be a reference to array");
		  }
		  tempav = (AV *)SvRV(val);

		  /* Determine number of sets (for multi-data graphs
		     or number of points for single data/pie charts
		  */

		  sets = av_len(tempav);

		  /* Now find number of points and check is same
		     for each set. Also find total number of
		     elements.
		  */

		  for(i=0;i<=sets;i++) {
		    
		    ref = av_fetch(tempav, i, 0);
		    if(SvTYPE(*ref) == SVt_RV) {	/* Got a ref */
		       if(seen_val)
		         croak("Mixed reference to array and data");

		       seen_ref = 1;

		       temp2av = (AV *)SvRV(*ref);

		       sets2 = av_len(temp2av);
		       if(! points) {
		       	   points = sets2 + 1;
		       } else if(points && (sets2+1) != points) {
		       	   croak("Different number of points in data sets");
		       }

		       total += sets2 + 1;

		    } else {
		       if(seen_ref)
		       	 croak("Mixed reference to array and data");

		       seen_val = 1;

		       total++;
		       points = 0;
		    }
		 }

		 self->data = malloc(total * sizeof(float));

		 /* Now copy data from perl memory to us */

		 for(i=0;i<=sets;i++) {

		   ref = av_fetch(tempav, i, 0);
		   if(SvTYPE(*ref) == SVt_RV)  {
		     temp2av = (AV *)SvRV(*ref);
		     sets2 = av_len(temp2av);
		     for(j=0;j<=sets2;j++) {
		        ref2 = av_fetch(temp2av, j, 0);
		    	self->data[i*(sets2+1) + j] = (float)SvNV(*ref2);
		     }
		   } else {
		     self->data[i] = (float)SvNV(*ref);
		   }
		 }

		 /* Now setup sets and points */

		 if(seen_val) {
			 self->s = 1;
			 self->p = sets+1;
		 } else {
		 	self->s = sets+1;
			self->p = points;
		 }

	     } else if(! strcmp("labels", key)) {
		   AV *tempav;
		   I32 len, i;
		   int strlen;
		   SV **tv;

		   if(!SvROK(val))
		     croak("Must pass reference to array of labels");
		   if(SvTYPE(SvRV(val)) != SVt_PVAV)
		     croak("Must pass reference to array of labels");
		   tempav = (AV*)SvRV(val);
	 	   len = av_len(tempav);
		   self->labels_num = len+1;
		   self->labels = malloc((len+2) * sizeof(char *));
		   for(i = 0; i <= len; i++) {
		     tv = av_fetch(tempav, i, 0);
		     self->labels[i] = SvPV(*tv, strlen);
		   }
		   self->labels[i] = 0;
	     } else if(! strcmp("note", key)) {
                /* Nothing to do really - the act of creating the
                   note takes care of it. However, it looks more
                   logical ifwe assign the note to the graph
                */
             } else if(! strcmp("scatter", key)) {
		/* Again nothing to do but looks better to link
		   it to the graph
		*/
	/* Some new options in gdchart 0.11/0.12 */
	     } else if(! strcmp("xaxis_angle", key)) {
		  if(SvNIOK(val)) {
			GDC_xaxis_angle = SvNV(val);
			if(GDC_xaxis_angle == 0)
				GDC_xaxis_angle = SvIV(val);
		  }
#ifdef HAVE_LIBFREETYPE
	     } else if(! strcmp("title_font", key)) {
		  char *a;
		  int len;

		  if(SvPOK(val)) {
		     a = SvPV(val, len);
		     GDC_title_font = malloc(len+1);
		     strcpy(GDC_title_font, a);
		  }
	     } else if(! strcmp("ytitle_font", key)) {
		  char *a;
		  int len;

		  if(SvPOK(val)) {
			a = SvPV(val, len);
			GDC_ytitle_font = malloc(len+1);
			strcpy(GDC_ytitle_font, a);
		  }
	     } else if(! strcmp("xtitle_font", key)) {
		  char *a;
		  int len;

		  if(SvPOK(val)) {
			a = SvPV(val, len);
			GDC_xtitle_font = malloc(len+1);
			strcpy(GDC_ytitle_font, a);
		  }
	     } else if(! strcmp("yaxis_font", key)) {
		   char *a;
		   int len;

		   if(SvPOK(val)) {
			a = SvPV(val, len);
			GDC_yaxis_font = malloc(len+1);
			strcpy(GDC_yaxis_font, a);
		   }
	     } else if(! strcmp("xaxis_font", key)) {
		   char *a;
		   STRLEN len;
			
		   if(SvPOK(val)) {
			a = SvPV(val, len);
			GDC_xaxis_font = malloc(len+1);
			strcpy(GDC_xaxis_font, a);
		   }
	     } else if(! strcmp("title_ptsize", key)) {
		   if(SvNIOK(val)) {
			GDC_title_ptsize = SvNV(val);
			if(GDC_title_ptsize == 0)
				GDC_title_ptsize = SvIV(val);
		   }
	     } else if(! strcmp("ytitle_ptsize", key)) {
		   if(SvNIOK(val)) {
			GDC_ytitle_ptsize = SvNV(val);
			if(GDC_ytitle_ptsize == 0)
				GDC_ytitle_ptsize = SvIV(val);
		   }
	     } else if(! strcmp("xtitle_ptsize", key)) {
		   if(SvNIOK(val)) {
			GDC_xtitle_ptsize = SvNV(val);
			if(GDC_xtitle_ptsize == 0)
				GDC_xtitle_ptsize = SvIV(val);
		   }
	     } else if(! strcmp("yaxis_ptsize", key)) {
		   if(SvNIOK(val)) {
			GDC_yaxis_ptsize = SvNV(val);
			if(GDC_yaxis_ptsize == 0)
				GDC_yaxis_ptsize = SvIV(val);
		   }
	     } else if(! strcmp("xaxis_ptsize", key)) {
		   if(SvNIOK(val)) {
			GDC_xaxis_ptsize = SvNV(val);
			if(GDC_xaxis_ptsize == 0) 
				GDC_xaxis_ptsize = SvIV(val);
		   }
#endif
	     } else {
	     	  warn("Unknown option %s, skipping", key);
	     }
	}
}
int gdchart_scatter(gdchart *self,scatter *s){

	/* Nothing to do! ( see above) */

	return 1;
}
int gdchart_note(gdchart *self,note *n){
        /* Nothing to do! ( see above) */

        return 1;       /* For a warm comforting glow =) */

}
void gdchart_ytitle(gdchart *self,char *t){

	GDC_ytitle = t;
}
void gdchart_xtitle(gdchart *self,char *t){
	
	GDC_xtitle = t;
}
void gdchart_ytitle2(gdchart *self,char *t){

	GDC_ytitle2 = t;
}
void gdchart_title(gdchart *self,char *t){

	if(self->type == CHART)
		GDC_title = t;
	else
		GDCPIE_title = t;
}
void gdchart_ytitle_size(gdchart *self,enum GDC_font_size fs){

	GDC_ytitle_size = fs;
}
void gdchart_xtitle_size(gdchart *self,enum GDC_font_size fs){

	GDC_xtitle_size = fs;
}
void gdchart_yaxisfont_size(gdchart *self,enum GDC_font_size fs){

	GDC_yaxisfont_size = fs;
}
void gdchart_xaxisfont_size(gdchart *self,enum GDC_font_size fs){

	GDC_xaxisfont_size = fs;
}
void gdchart_title_tt_font(gdchart *self,char *fontname){

#ifdef HAVE_LIBFREETYPE
	GDC_title_font = fontname;
#endif
}
void gdchart_ytitle_tt_font(gdchart *self,char *fontname){

#ifdef HAVE_LIBFREETYPE
	GDC_ytitle_font = fontname;
#endif
}
void gdchart_xtitle_tt_font(gdchart *self,char *fontname){

#ifdef HAVE_LIBFREETYPE
	GDC_xtitle_font = fontname;
#endif
}
void gdchart_yaxis_tt_font(gdchart *self,char *fontname){

#ifdef HAVE_LIBFREETYPE
	GDC_yaxis_font = fontname;
#endif
}
void gdchart_xaxis_tt_font(gdchart *self,char *fontname){

#ifdef HAVE_LIBFREETYPE
	GDC_xaxis_font = fontname;
#endif
}
void gdchart_title_ptsize(gdchart *self,double size){

#ifdef HAVE_LIBFREETYPE
	GDC_title_ptsize = size;
#endif
}
void gdchart_ytitle_ptsize(gdchart *self,double size){

#ifdef HAVE_LIBFREETYPE
	GDC_ytitle_ptsize = size;
#endif
}
void gdchart_xtitle_ptsize(gdchart *self,double size){

#ifdef HAVE_LIBFREETYPE
	GDC_xtitle_ptsize = size;
#endif
}
void gdchart_yaxis_ptsize(gdchart *self,double size){

#ifdef HAVE_LIBFREETYPE
	GDC_yaxis_ptsize = size;
#endif
}
void gdchart_xaxis_ptsize(gdchart *self,double size){

#ifdef HAVE_LIBFREETYPE
	GDC_xaxis_ptsize =size;
#endif
}
void gdchart_xaxis_angle(gdchart *self,double angle){

	GDC_xaxis_angle = angle;
}
void gdchart_ylabel_fmt(gdchart *self,char *fmt){

	GDC_ylabel_fmt = fmt;
}
void gdchart_ylabel2_fmt(gdchart *self,char *fmt){

	GDC_ylabel2_fmt = fmt;
}
void gdchart_xlabel_ctl(gdchart *self,char *ctl){

	GDC_xlabel_ctl = ctl;
}
void gdchart_xlabel_spacing(gdchart *self,short s){

	GDC_xlabel_spacing = s;
}
void gdchart_ylabel_density(gdchart *self,char d){

	GDC_ylabel_density = d;
}
void gdchart_interpolations(gdchart *self,char i){

	GDC_interpolations = i;
}
void gdchart_requested_ymin(gdchart *self,float min){

	GDC_requested_ymin = min;
}
void gdchart_requested_ymax(gdchart *self,float max){

	GDC_requested_ymax = max;
}
void gdchart_requested_yinterval(gdchart *self,float y){

	GDC_requested_yinterval = y;
}
void gdchart_shelf(gdchart *self,char s){

	GDC_0Shelf = s;
}
void gdchart_grid(gdchart *self,GDC_TICK_T t){

	GDC_grid = t;
}
void gdchart_ticks(gdchart *self,GDC_TICK_T t){

	GDC_ticks = t;
}
void gdchart_xaxis(gdchart *self,char x){

	GDC_xaxis = x;
}
void gdchart_yaxis(gdchart *self,char y){

	GDC_yaxis = y;
}
void gdchart_yaxis2(gdchart *self,char y){

	GDC_yaxis2 = y;
}
void gdchart_yval_style(gdchart *self,char t){

	GDC_yval_style = t;
}
void gdchart_stack_type(gdchart *self,GDC_STACK_T t){

	GDC_stack_type = t;
}
void gdchart_bar_width(gdchart *self,unsigned char w){

	GDC_bar_width = w;
}
void gdchart_hlc_style(gdchart *self,GDC_HLC_STYLE_T t){

	GDC_HLC_style = t;
}
void gdchart_hlc_cap_width(gdchart *self,unsigned char w){

	GDC_HLC_cap_width = w;
}
void gdchart_annotation_font_size(gdchart *self,enum GDC_font_size s){

	GDC_annotation_font_size = s;
}
void gdchart_annotation_font(gdchart *self,char *fontname){

#ifdef HAVE_LIBFREETYPE
	GDC_annotation_font = fontname;
#endif
}
void gdchart_annotation_font_ptsize(gdchart *self,double size){

#ifdef HAVE_LIBFREETYPE
	GDC_annotation_ptsize = size;
#endif
}
void gdchart_num_scatter_pts(gdchart *self,int p){

	GDC_num_scatter_pts = p;
}
void gdchart_thumbnail(gdchart *self,char t){

	GDC_thumbnail = t;
}
void gdchart_thumblabel(gdchart *self,char *t){

	GDC_thumblabel = t;
}
void gdchart_thumbval(gdchart *self,float t){

	GDC_thumbval = t;
}
void gdchart_border(gdchart *self,GDC_BORDER_T b){

	GDC_border = b;
}
void gdchart_linecolor(gdchart *self,unsigned long l){

	self->linecolour = l;
}
void gdchart_plotcolor(gdchart *self,unsigned long p){

	self->plotcolour = p;
}
void gdchart_edgecolor(gdchart *self,unsigned long e){

	GDCPIE_EdgeColor = e;
}
void gdchart_edgecolour(gdchart *self,unsigned long e){

	GDCPIE_EdgeColor = e;
}
void gdchart_other_threshold(gdchart *self,char o){

	GDCPIE_other_threshold = o;
}
void gdchart_volcolor(gdchart *self,unsigned long v){

	GDC_VolColor = v;
}
void gdchart_volcolour(gdchart *self,unsigned long v){

	GDC_VolColor = v;
}
void gdchart_titlecolor(gdchart *self,unsigned long t){

	GDC_TitleColor = t;
}
void gdchart_titlecolour(gdchart *self,unsigned long t){

	GDC_TitleColor = t;
}
void gdchart_xtitlecolor(gdchart *self,unsigned long x){

	GDC_XTitleColor = x;
}
void gdchart_xtitlecolour(gdchart *self,unsigned long x){

	GDC_XTitleColor = x;
}
void gdchart_ytitlecolor(gdchart *self,unsigned long y){

	GDC_YTitleColor = y;
}
void gdchart_ytitlecolour(gdchart *self,unsigned long y){

	GDC_YTitleColor = y;
}
void gdchart_ytitle2color(gdchart *self,unsigned long y){

	GDC_YTitle2Color = y;
}
void gdchart_ytitle2colour(gdchart *self,unsigned long y){

	GDC_YTitle2Color = y;
}
void gdchart_xlabelcolor(gdchart *self,unsigned long x){

	GDC_XLabelColor = x;
}
void gdchart_xlabelcolour(gdchart *self,unsigned long x){

	GDC_XLabelColor = x;
}
void gdchart_ylabelcolor(gdchart *self,unsigned long y){

	GDC_YLabelColor = y;
}
void gdchart_ylabelcolour(gdchart *self,unsigned long y){

	GDC_YLabelColor = y;
}
void gdchart_ylabel2color(gdchart *self,unsigned long y){

	GDC_YLabel2Color = y;
}
void gdchart_ylabel2colour(gdchart *self,unsigned long y){

	GDC_YLabel2Color = y;
}
void gdchart_extvolcolor(gdchart *self,unsigned long *c){

	GDC_ExtVolColor = c;
}
void gdchart_extvolcolour(gdchart *self,unsigned long *c){

	GDC_ExtVolColor = c;
}
void gdchart_setcolor(gdchart *self,unsigned long *c){

	self->cols = c;
}
void gdchart_setcolour(gdchart *self,unsigned long *c){

	self->cols = c;
}
void gdchart_color(gdchart *self,unsigned long *c){

	self->cols = c;
}
void gdchart_colors(gdchart *self,unsigned long *c){

	self->cols = c;
}
void gdchart_colour(gdchart *self,unsigned long *c){

	self->cols = c;
}
void gdchart_colours(gdchart *self,unsigned long *c){

	self->cols = c;
}
void gdchart_extcolor(gdchart *self,unsigned long *c){

	GDC_ExtColor = c;
}
void gdchart_extcolour(gdchart *self,unsigned long *c){

	GDC_ExtColor = c;
}
void gdchart_transparent_bg(gdchart *self,char t){

	GDC_transparent_bg = t;
}
void gdchart_bgimage(gdchart *self,char *b){

	GDC_BGImage = b;
}
void gdchart_label_size(gdchart *self,enum GDC_font_size fs){

	GDCPIE_label_size = fs;
}
void gdchart_label_font(gdchart *self,char *fontname){
#ifdef HAVE_LIBFREETYPE
	GDCPIE_label_font = fontname;
#endif
}
void gdchart_label_font_ptsize(gdchart *self,double size){
#ifdef HAVE_LIBFREETYPE
	GDCPIE_label_ptsize = size;
#endif
}
void gdchart_label_dist(gdchart *self,int l){

	GDCPIE_label_dist = l;
}
void gdchart_label_line(gdchart *self,unsigned char l){

	GDCPIE_label_line = l;
}
void gdchart_explode(gdchart *self,int *e){

	GDCPIE_explode = e;
}
void gdchart_missing(gdchart *self,unsigned char *m){

	GDCPIE_missing = m;
}
void gdchart_percent_labels(gdchart *self,GDCPIE_PCT_TYPE t){

	GDCPIE_percent_labels = t;
}
void gdchart_percent_fmt(gdchart *self,char *fmt){

	GDCPIE_percent_fmt = fmt;
}
void gdchart_height(gdchart *self,int h){

	self->h =h;
}
void gdchart_width(gdchart *self,int w){
	
	self->w = w;
}
void gdchart_chart_type(gdchart *self,int type){

	self->type = CHART;
	self->img.chart = (GDC_CHART_T)type;
}
void gdchart_pie_type(gdchart *self,int type){

	self->type = PIE;
	self->img.pie = (GDCPIE_TYPE)type;
}
void gdchart_imgtype(gdchart *self,int type){

	GDC_image_type = (GDC_image_type_t)type;
}
void gdchart_sets(gdchart *self,int n){
	self->s = n;
}
void gdchart_points(gdchart *self,int n){
	self->p = n;
}
void gdchart_bgcolor(gdchart *self,unsigned long col){

	self->bgcolour = col;
}
void gdchart_fd(gdchart *self,FILE *fd){
	
	if(fd == NULL) {
		croak("Invalid filehandle");
		return; 
	}
	self->output = fd;
}
void gdchart_filename(gdchart *self,char *file){
	FILE *fd;

	fd = fopen(file, "wb");
	if(fd == NULL) {
		croak("Cannot open file");
		return;
	}
	self->output = fd;
	self->flags |= CLOSE_FD;
}
int gdchart_draw(gdchart *self,char **labels,float *data){

	/* Sanity checks */

	if(! self->w || ! self->h ) { 
		croak("Width/Height not set");
	}
	
	if(self->output == NULL) { 
		croak("Output file not set");
	}

	if(self->type == CHART && ! self->s) {
		croak("Sets not set for type chart");
	}

	if(! self->p) { 
		croak("Points not set");
	}


	if(self->data && data) {
		warn("Set data twice, ignoring first data");
	} else if(!self->data && data) {
		self->data = data;
	} else if(!self->data && !data) {
		croak("No data set");
	}

	if(self->labels && labels) {
		warn("Set labels twice, ignoring first labels");
	} else if(!self->labels && labels) {
		self->labels = labels;
	} else if(!self->labels && !labels) {
		croak("No labels set");
	}

		
	if(self->vol) { 
                if(self->img.chart == GDC_COMBO_HLC_AREA ||
		   self->img.chart == GDC_COMBO_HLC_BAR  ||
		   self->img.chart == GDC_3DCOMBO_HLC_AREA ||
		   self->img.chart == GDC_3DCOMBO_HLC_BAR ||
		   self->img.chart == GDC_3DHILOCLOSE
		) {
			self->s = 1;
		} else if(self->img.chart == GDC_FLOATINGBAR) {
			self->s = 1;
		}
	} else if(self->img.chart == GDC_3DFLOATINGBAR ||
	          self->img.chart == GDC_FLOATINGBAR )
		{
		         self->s = 1;
	}

	if(self->type == CHART) {
		/* Setup options for charts */
		

		if(self->cols)
			GDC_SetColor = self->cols;
		if(self->bgcolour) 
			GDC_BGColor = self->bgcolour;
		if(self->plotcolour)
			GDC_PlotColor = self->plotcolour;
		if(self->linecolour)
			GDC_LineColor = self->linecolour;
		if(self->angle_3d)
			GDC_3d_angle = self->angle_3d;
		if(self->depth_3d)
			GDC_3d_depth = self->depth_3d;
		if(self->title)
			GDC_title = self->title;
		if(self->title_size) 
			GDC_title_size = self->title_size;

		/* Check labels and data sets match up */

		if(self->labels_num > self->p) {
			croak("Only got %d labels for %d data points", self->labels_num, self->p);
		} else if(self->labels_num < self->p) {
			croak("Got %d labels for only %d data points", self->labels_num, self->p);
		}

		GDC_out_graph(self->w, self->h, self->output, self->img.chart, 
			      self->p, self->labels, self->s,
		      	      self->data, self->vol);

	} else {
		/* Setup options for pie charts */

		if(self->cols)
			GDCPIE_Color = self->cols;
		if(self->bgcolour)
			GDCPIE_BGColor = self->bgcolour;
		if(self->plotcolour)
			GDCPIE_PlotColor = self->plotcolour;
		if(self->linecolour)
			GDCPIE_LineColor = self->linecolour;
		if(self->angle_3d)
			GDCPIE_3d_angle = self->angle_3d;
		if(self->depth_3d)
			GDCPIE_3d_depth = self->depth_3d;
		if(self->title)
			GDCPIE_title = self->title;
		if(self->title_size)
			GDCPIE_title_size = self->title_size;

		GDC_out_pie(self->w, self->h, self->output, self->img.pie,
			    self->p, self->labels, self->data);
	}

	return 1;
}
#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_GD::Chart_var::
class _wrap_GD::Chart_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    sv = sv; mg = mg;
    croak("Value is read-only.");
    return 0;
}
SWIGCLASS_STATIC int _wrap_set_GDC_ytitle(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDC_ytitle) free((char *) GDC_ytitle);
        GDC_ytitle = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDC_ytitle,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_ytitle(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDC_ytitle) {
        sv_setpv((SV*)sv, (char *) GDC_ytitle);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_xtitle(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDC_xtitle) free((char *) GDC_xtitle);
        GDC_xtitle = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDC_xtitle,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_xtitle(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDC_xtitle) {
        sv_setpv((SV*)sv, (char *) GDC_xtitle);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_ytitle2(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDC_ytitle2) free((char *) GDC_ytitle2);
        GDC_ytitle2 = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDC_ytitle2,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_ytitle2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDC_ytitle2) {
        sv_setpv((SV*)sv, (char *) GDC_ytitle2);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_title(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDC_title) free((char *) GDC_title);
        GDC_title = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDC_title,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_title(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDC_title) {
        sv_setpv((SV*)sv, (char *) GDC_title);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_title_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_title_size = (enum GDC_font_size) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_title_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_title_size);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_ytitle_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_ytitle_size = (enum GDC_font_size) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_ytitle_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_ytitle_size);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_xtitle_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_xtitle_size = (enum GDC_font_size) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_xtitle_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_xtitle_size);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_yaxisfont_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_yaxisfont_size = (enum GDC_font_size) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_yaxisfont_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_yaxisfont_size);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_xaxisfont_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_xaxisfont_size = (enum GDC_font_size) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_xaxisfont_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_xaxisfont_size);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_ylabel_fmt(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDC_ylabel_fmt) free((char *) GDC_ylabel_fmt);
        GDC_ylabel_fmt = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDC_ylabel_fmt,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_ylabel_fmt(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDC_ylabel_fmt) {
        sv_setpv((SV*)sv, (char *) GDC_ylabel_fmt);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_ylabel2_fmt(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDC_ylabel2_fmt) free((char *) GDC_ylabel2_fmt);
        GDC_ylabel2_fmt = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDC_ylabel2_fmt,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_ylabel2_fmt(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDC_ylabel2_fmt) {
        sv_setpv((SV*)sv, (char *) GDC_ylabel2_fmt);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_xlabel_ctl(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDC_xlabel_ctl) free((char *) GDC_xlabel_ctl);
        GDC_xlabel_ctl = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDC_xlabel_ctl,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_xlabel_ctl(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDC_xlabel_ctl) {
        sv_setpv((SV*)sv, (char *) GDC_xlabel_ctl);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_xlabel_spacing(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDC_xlabel_spacing, SWIGTYPE_p_short,0) < 0) {
            croak("Type error in argument $argnum of GDC_xlabel_spacing. Expected _p_short");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_xlabel_spacing(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) GDC_xlabel_spacing);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_ylabel_density(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_ylabel_density = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_ylabel_density(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_ylabel_density, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_interpolations(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_interpolations = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_interpolations(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_interpolations, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_requested_ymin(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_requested_ymin = (float) SvNV(sv);
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_requested_ymin(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setnv(sv, (double) GDC_requested_ymin);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_requested_ymax(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_requested_ymax = (float) SvNV(sv);
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_requested_ymax(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setnv(sv, (double) GDC_requested_ymax);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_requested_yinterval(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_requested_yinterval = (float) SvNV(sv);
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_requested_yinterval(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setnv(sv, (double) GDC_requested_yinterval);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_0Shelf(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_0Shelf = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_0Shelf(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_0Shelf, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_grid(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_grid = (GDC_TICK_T) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_grid(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_grid);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_ticks(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_ticks = (GDC_TICK_T) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_ticks(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_ticks);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_xaxis(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_xaxis = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_xaxis(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_xaxis, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_yaxis(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_yaxis = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_yaxis(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_yaxis, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_yaxis2(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_yaxis2 = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_yaxis2(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_yaxis2, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_yval_style(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_yval_style = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_yval_style(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_yval_style, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_stack_type(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_stack_type = (GDC_STACK_T) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_stack_type(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_stack_type);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_3d_depth(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_3d_depth = (float) SvNV(sv);
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_3d_depth(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setnv(sv, (double) GDC_3d_depth);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_3d_angle(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_3d_angle = (unsigned char) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_3d_angle(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_3d_angle);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_bar_width(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_bar_width = (unsigned char) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_bar_width(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_bar_width);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_HLC_style(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_HLC_style = (GDC_HLC_STYLE_T) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_HLC_style(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_HLC_style);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_HLC_cap_width(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_HLC_cap_width = (unsigned char) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_HLC_cap_width(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_HLC_cap_width);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_annotation(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDC_annotation, SWIGTYPE_p_GDC_ANNOTATION_T,0) < 0) {
            croak("Type error in argument $argnum of GDC_annotation. Expected _p_GDC_ANNOTATION_T");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_annotation(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) GDC_annotation);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_num_scatter_pts(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_num_scatter_pts = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_num_scatter_pts(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_num_scatter_pts);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_scatter(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDC_scatter, SWIGTYPE_p_GDC_SCATTER_T,0) < 0) {
            croak("Type error in argument $argnum of GDC_scatter. Expected _p_GDC_SCATTER_T");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_scatter(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) GDC_scatter);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_thumbnail(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_thumbnail = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_thumbnail(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_thumbnail, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_thumblabel(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDC_thumblabel) free((char *) GDC_thumblabel);
        GDC_thumblabel = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDC_thumblabel,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_thumblabel(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDC_thumblabel) {
        sv_setpv((SV*)sv, (char *) GDC_thumblabel);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_thumbval(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_thumbval = (float) SvNV(sv);
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_thumbval(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setnv(sv, (double) GDC_thumbval);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_border(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_border = (GDC_BORDER_T) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_border(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_border);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_BGColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_BGColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_BGColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_BGColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_GridColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_GridColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_GridColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_GridColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_LineColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_LineColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_LineColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_LineColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_PlotColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_PlotColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_PlotColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_PlotColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_VolColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_VolColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_VolColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_VolColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_TitleColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_TitleColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_TitleColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_TitleColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_XTitleColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_XTitleColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_XTitleColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_XTitleColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_YTitleColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_YTitleColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_YTitleColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_YTitleColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_YTitle2Color(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_YTitle2Color = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_YTitle2Color(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_YTitle2Color);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_XLabelColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_XLabelColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_XLabelColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_XLabelColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_YLabelColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_YLabelColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_YLabelColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_YLabelColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_YLabel2Color(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_YLabel2Color = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_YLabel2Color(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDC_YLabel2Color);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_ExtVolColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDC_ExtVolColor, SWIGTYPE_p_unsigned_long,0) < 0) {
            croak("Type error in argument $argnum of GDC_ExtVolColor. Expected _p_unsigned_long");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_ExtVolColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        AV *tempav;
        SV **svs;
        int i = 0, len =0;
        
        while(GDC_ExtVolColor[len])
        len++;
        
        svs = malloc(len*sizeof(SV *));
        
        for(i = 0; i < len; i++) {
            svs[i] = sv_newmortal();
            sv_setiv(svs[i], GDC_ExtVolColor[i]);
        };
        
        tempav = av_make(len, svs);
        free(svs);
        sv = newRV((SV*)tempav);
        sv_2mortal(sv);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_SetColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDC_SetColor, SWIGTYPE_p_unsigned_long,0) < 0) {
            croak("Type error in argument $argnum of GDC_SetColor. Expected _p_unsigned_long");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_SetColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        AV *tempav;
        SV **svs;
        int i = 0, len =0;
        
        while(GDC_SetColor[len])
        len++;
        
        svs = malloc(len*sizeof(SV *));
        
        for(i = 0; i < len; i++) {
            svs[i] = sv_newmortal();
            sv_setiv(svs[i], GDC_SetColor[i]);
        };
        
        tempav = av_make(len, svs);
        free(svs);
        sv = newRV((SV*)tempav);
        sv_2mortal(sv);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_ExtColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDC_ExtColor, SWIGTYPE_p_unsigned_long,0) < 0) {
            croak("Type error in argument $argnum of GDC_ExtColor. Expected _p_unsigned_long");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_ExtColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        AV *tempav;
        SV **svs;
        int i = 0, len =0;
        
        while(GDC_ExtColor[len])
        len++;
        
        svs = malloc(len*sizeof(SV *));
        
        for(i = 0; i < len; i++) {
            svs[i] = sv_newmortal();
            sv_setiv(svs[i], GDC_ExtColor[i]);
        };
        
        tempav = av_make(len, svs);
        free(svs);
        sv = newRV((SV*)tempav);
        sv_2mortal(sv);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_transparent_bg(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_transparent_bg = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_transparent_bg(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_transparent_bg, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_BGImage(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDC_BGImage) free((char *) GDC_BGImage);
        GDC_BGImage = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDC_BGImage,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_BGImage(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDC_BGImage) {
        sv_setpv((SV*)sv, (char *) GDC_BGImage);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_hard_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_hard_size = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_hard_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_hard_size, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_hard_xorig(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_hard_xorig = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_hard_xorig(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_hard_xorig);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_hard_graphwidth(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_hard_graphwidth = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_hard_graphwidth(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_hard_graphwidth);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_hard_yorig(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_hard_yorig = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_hard_yorig(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_hard_yorig);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_hard_grapheight(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_hard_grapheight = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_hard_grapheight(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_hard_grapheight);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_image_type(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_image_type = (GDC_image_type_t) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_image_type(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_image_type);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_generate_img(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_generate_img = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_generate_img(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDC_generate_img, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_hold_img(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        GDC_HOLD_IMAGE_T * argp;
        if (SWIG_ConvertPtr(sv,(void **) &argp, SWIGTYPE_p_GDC_HOLD_IMAGE_T,0) < 0) {
            croak("Type error in argument $argnum of GDC_hold_img. Expected _p_GDC_HOLD_IMAGE_T");
        }
        GDC_hold_img = *argp;
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_hold_img(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv), (IV) &GDC_hold_img);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_image(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDC_image, 0,0) < 0) {
            croak("Type error in argument $argnum of GDC_image. Expected _p_void");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_image(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) GDC_image);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_BGColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_BGColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_BGColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDCPIE_BGColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_PlotColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_PlotColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_PlotColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDCPIE_PlotColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_LineColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_LineColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_LineColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDCPIE_LineColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_EdgeColor(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_EdgeColor = (unsigned long) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_EdgeColor(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDCPIE_EdgeColor);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_other_threshold(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_other_threshold = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_other_threshold(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &GDCPIE_other_threshold, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_3d_angle(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_3d_angle = (unsigned short) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_3d_angle(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDCPIE_3d_angle);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_3d_depth(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_3d_depth = (unsigned short) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_3d_depth(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDCPIE_3d_depth);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_title(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDCPIE_title) free((char *) GDCPIE_title);
        GDCPIE_title = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDCPIE_title,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_title(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDCPIE_title) {
        sv_setpv((SV*)sv, (char *) GDCPIE_title);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_title_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_title_size = (enum GDC_font_size) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_title_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDCPIE_title_size);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_label_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_label_size = (enum GDC_font_size) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_label_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDCPIE_label_size);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_label_dist(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_label_dist = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_label_dist(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDCPIE_label_dist);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_label_line(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_label_line = (unsigned char) SvUV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_label_line(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setuv(sv, (UV) GDCPIE_label_line);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_explode(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDCPIE_explode, SWIGTYPE_p_unsigned_int,0) < 0) {
            croak("Type error in argument $argnum of GDCPIE_explode. Expected _p_unsigned_int");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_explode(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) GDCPIE_explode);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_Color(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDCPIE_Color, SWIGTYPE_p_unsigned_long,0) < 0) {
            croak("Type error in argument $argnum of GDCPIE_Color. Expected _p_unsigned_long");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_Color(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        AV *tempav;
        SV **svs;
        int i = 0, len =0;
        
        while(GDCPIE_Color[len])
        len++;
        
        svs = malloc(len*sizeof(SV *));
        
        for(i = 0; i < len; i++) {
            svs[i] = sv_newmortal();
            sv_setiv(svs[i], GDCPIE_Color[i]);
        };
        
        tempav = av_make(len, svs);
        free(svs);
        sv = newRV((SV*)tempav);
        sv_2mortal(sv);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_missing(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &GDCPIE_missing, SWIGTYPE_p_unsigned_char,0) < 0) {
            croak("Type error in argument $argnum of GDCPIE_missing. Expected _p_unsigned_char");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_missing(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) GDCPIE_missing);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_percent_labels(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDCPIE_percent_labels = (GDCPIE_PCT_TYPE) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_percent_labels(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDCPIE_percent_labels);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDCPIE_percent_fmt(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (GDCPIE_percent_fmt) free((char *) GDCPIE_percent_fmt);
        GDCPIE_percent_fmt = (char *) malloc(strlen(_a)+1);
        strcpy((char *)GDCPIE_percent_fmt,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDCPIE_percent_fmt(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (GDCPIE_percent_fmt) {
        sv_setpv((SV*)sv, (char *) GDCPIE_percent_fmt);
    } else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_xaxis_angle(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_xaxis_angle = (double) SvNV(sv);
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_xaxis_angle(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setnv(sv, (double) GDC_xaxis_angle);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_GDC_annotation_font_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    GDC_annotation_font_size = (enum GDC_font_size) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_GDC_annotation_font_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) GDC_annotation_font_size);
    return 1;
}




#ifdef PERL_OBJECT
};
#endif

#ifdef __cplusplus
extern "C" {
#endif
XS(_wrap_new_note) {
    {
        char *arg1 = (char *) NULL ;
        unsigned long arg2 = (unsigned long) 0 ;
        int arg3 = (int) 0 ;
        int arg4 = (int) 3 ;
        char *arg5 = (char *) NULL ;
        double arg6 = (double) 0.0 ;
        note *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 6)) {
            SWIG_croak("Usage: new_note(msg,col,point,font_size,tt_font,tt_size);");
        }
        if (items > 0) {
            if (!SvOK((SV*) ST(0))) arg1 = 0;
            else arg1 = (char *) SvPV(ST(0), PL_na);
        }
        if (items > 1) {
            arg2 = (unsigned long) SvUV(ST(1));
        }
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        if (items > 3) {
            arg4 = (int) SvIV(ST(3));
        }
        if (items > 4) {
            if (!SvOK((SV*) ST(4))) arg5 = 0;
            else arg5 = (char *) SvPV(ST(4), PL_na);
        }
        if (items > 5) {
            {
                arg6 = SvNV(ST(5));
                if(arg6 == 0) {
                    arg6 = SvIV(ST(5)); 
                }
            }
        }
        result = (note *)new_note(arg1,arg2,arg3,(enum GDC_font_size)arg4,arg5,arg6);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_note, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_note) {
    {
        note *arg1 = (note *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_note(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_note,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_note. Expected _p_note");
            }
        }
        delete_note(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_note_setnote) {
    {
        note *arg1 = (note *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: note_setnote(self,msg);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_note,0) < 0) {
                SWIG_croak("Type error in argument 1 of note_setnote. Expected _p_note");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        note_setnote(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_note_col) {
    {
        note *arg1 = (note *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: note_col(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_note,0) < 0) {
                SWIG_croak("Type error in argument 1 of note_col. Expected _p_note");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        note_col(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_note_point) {
    {
        note *arg1 = (note *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: note_point(self,p);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_note,0) < 0) {
                SWIG_croak("Type error in argument 1 of note_point. Expected _p_note");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        note_point(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_note_font) {
    {
        note *arg1 = (note *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: note_font(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_note,0) < 0) {
                SWIG_croak("Type error in argument 1 of note_font. Expected _p_note");
            }
        }
        arg2 = (int) SvIV(ST(1));
        note_font(arg1,(enum GDC_font_size)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_note_tt_font) {
    {
        note *arg1 = (note *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: note_tt_font(self,fontname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_note,0) < 0) {
                SWIG_croak("Type error in argument 1 of note_tt_font. Expected _p_note");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        note_tt_font(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_note_tt_font_size) {
    {
        note *arg1 = (note *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: note_tt_font_size(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_note,0) < 0) {
                SWIG_croak("Type error in argument 1 of note_tt_font_size. Expected _p_note");
            }
        }
        {
            arg2 = SvNV(ST(1));
            if(arg2 == 0) {
                arg2 = SvIV(ST(1)); 
            }
        }
        note_tt_font_size(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scatter_s_set) {
    {
        scatter *arg1 = (scatter *) 0 ;
        GDC_SCATTER_T *arg2 = (GDC_SCATTER_T *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scatter_s_set(self,s);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scatter,0) < 0) {
                SWIG_croak("Type error in argument 1 of scatter_s_set. Expected _p_scatter");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_GDC_SCATTER_T,0) < 0) {
                SWIG_croak("Type error in argument 2 of scatter_s_set. Expected _p_GDC_SCATTER_T");
            }
        }
        if (arg1) (arg1)->s = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scatter_s_get) {
    {
        scatter *arg1 = (scatter *) 0 ;
        GDC_SCATTER_T *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scatter_s_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scatter,0) < 0) {
                SWIG_croak("Type error in argument 1 of scatter_s_get. Expected _p_scatter");
            }
        }
        result = (GDC_SCATTER_T *) ((arg1)->s);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_GDC_SCATTER_T, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scatter_num_set) {
    {
        scatter *arg1 = (scatter *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scatter_num_set(self,num);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scatter,0) < 0) {
                SWIG_croak("Type error in argument 1 of scatter_num_set. Expected _p_scatter");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->num = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scatter_num_get) {
    {
        scatter *arg1 = (scatter *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scatter_num_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scatter,0) < 0) {
                SWIG_croak("Type error in argument 1 of scatter_num_get. Expected _p_scatter");
            }
        }
        result = (int) ((arg1)->num);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scatter_set_set) {
    {
        scatter *arg1 = (scatter *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scatter_set_set(self,set);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scatter,0) < 0) {
                SWIG_croak("Type error in argument 1 of scatter_set_set. Expected _p_scatter");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->set = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scatter_set_get) {
    {
        scatter *arg1 = (scatter *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scatter_set_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scatter,0) < 0) {
                SWIG_croak("Type error in argument 1 of scatter_set_get. Expected _p_scatter");
            }
        }
        result = (int) ((arg1)->set);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_scatter) {
    {
        int arg1 = (int) 0 ;
        scatter *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: new_scatter(num);");
        }
        if (items > 0) {
            arg1 = (int) SvIV(ST(0));
        }
        result = (scatter *)new_scatter(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_scatter, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_scatter) {
    {
        scatter *arg1 = (scatter *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_scatter(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scatter,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_scatter. Expected _p_scatter");
            }
        }
        delete_scatter(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scatter_add) {
    {
        scatter *arg1 = (scatter *) 0 ;
        float arg2 ;
        float arg3 ;
        unsigned short arg4 ;
        unsigned long arg5 ;
        int arg6 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: scatter_add(self,p,v,w,c,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scatter,0) < 0) {
                SWIG_croak("Type error in argument 1 of scatter_add. Expected _p_scatter");
            }
        }
        arg2 = (float) SvNV(ST(1));
        
        arg3 = (float) SvNV(ST(2));
        
        arg4 = (unsigned short) SvUV(ST(3));
        arg5 = (unsigned long) SvUV(ST(4));
        arg6 = (int) SvIV(ST(5));
        result = (int)scatter_add(arg1,arg2,arg3,arg4,arg5,(GDC_SCATTER_IND_T )arg6);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_w_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_w_set(self,w);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_w_set. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->w = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_w_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_w_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_w_get. Expected _p_gdchart");
            }
        }
        result = (int) ((arg1)->w);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_h_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_h_set(self,h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_h_set. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->h = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_h_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_h_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_h_get. Expected _p_gdchart");
            }
        }
        result = (int) ((arg1)->h);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_s_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_s_set(self,s);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_s_set. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->s = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_s_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_s_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_s_get. Expected _p_gdchart");
            }
        }
        result = (int) ((arg1)->s);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_p_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_p_set(self,p);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_p_set. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->p = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_p_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_p_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_p_get. Expected _p_gdchart");
            }
        }
        result = (int) ((arg1)->p);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_flags_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_flags_set(self,flags);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_flags_set. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        if (arg1) (arg1)->flags = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_flags_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_flags_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_flags_get. Expected _p_gdchart");
            }
        }
        result = (char) ((arg1)->flags);
        
        ST(argvi) = sv_newmortal();
        sv_setpvn((SV*)ST(argvi++), &result, 1);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_cols_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_cols_set(self,cols);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_cols_set. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        if (arg1) (arg1)->cols = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_cols_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_cols_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_cols_get. Expected _p_gdchart");
            }
        }
        result = (unsigned long *) ((arg1)->cols);
        
        {
            AV *tempav;
            SV **svs;
            int i = 0, len =0;
            
            while(result[len])
            len++;
            
            svs = malloc(len*sizeof(SV *));
            
            for(i = 0; i < len; i++) {
                svs[i] = sv_newmortal();
                sv_setiv(svs[i], result[i]);
            };
            
            tempav = av_make(len, svs);
            free(svs);
            ST(argvi) = newRV((SV*)tempav);
            sv_2mortal(ST(argvi));
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_labels_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char **arg2 = (char **) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_labels_set(self,labels);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_labels_set. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (char **) malloc((len+2)*sizeof(char *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (char *) SvPV(*tv,PL_na);
            }
            arg2[i] = 0;
        }
        if (arg1) (arg1)->labels = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_labels_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char **result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_labels_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_labels_get. Expected _p_gdchart");
            }
        }
        result = (char **) ((arg1)->labels);
        
        {
            AV *myav;
            SV **svs;
            int i = 0,len = 0;
            /* Figure out how many elements we have */
            while (result[len])
            len++;
            svs = (SV **) malloc(len*sizeof(SV *));
            for (i = 0; i < len ; i++) {
                svs[i] = sv_newmortal();
                sv_setpv((SV*)svs[i],result[i]);
            };
            myav =  av_make(len,svs);
            free(svs);
            ST(argvi) = newRV((SV*)myav);
            sv_2mortal(ST(argvi));
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_labels_num_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_labels_num_set(self,labels_num);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_labels_num_set. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->labels_num = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_labels_num_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_labels_num_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_labels_num_get. Expected _p_gdchart");
            }
        }
        result = (int) ((arg1)->labels_num);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_plotcolour_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_plotcolour_set(self,plotcolour);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_plotcolour_set. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        if (arg1) (arg1)->plotcolour = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_plotcolour_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_plotcolour_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_plotcolour_get. Expected _p_gdchart");
            }
        }
        result = (unsigned long) ((arg1)->plotcolour);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_linecolour_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_linecolour_set(self,linecolour);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_linecolour_set. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        if (arg1) (arg1)->linecolour = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_linecolour_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_linecolour_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_linecolour_get. Expected _p_gdchart");
            }
        }
        result = (unsigned long) ((arg1)->linecolour);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_angle_3d_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned short arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_angle_3d_set(self,angle_3d);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_angle_3d_set. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned short) SvUV(ST(1));
        if (arg1) (arg1)->angle_3d = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_angle_3d_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned short result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_angle_3d_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_angle_3d_get. Expected _p_gdchart");
            }
        }
        result = (unsigned short) ((arg1)->angle_3d);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_depth_3d_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned short arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_depth_3d_set(self,depth_3d);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_depth_3d_set. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned short) SvUV(ST(1));
        if (arg1) (arg1)->depth_3d = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_depth_3d_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned short result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_depth_3d_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_depth_3d_get. Expected _p_gdchart");
            }
        }
        result = (unsigned short) ((arg1)->depth_3d);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_title_size_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_title_size_set(self,title_size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_title_size_set. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->title_size = (enum GDC_font_size)arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_title_size_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_title_size_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_title_size_get. Expected _p_gdchart");
            }
        }
        result = (int) ((arg1)->title_size);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_data_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        float *arg2 = (float *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_data_set(self,data);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_data_set. Expected _p_gdchart");
            }
        }
        {
            AV *tempav, *temp2av;
            I32 len,i,j, sets, points, sets2, total;
            SV **tv, **tv2;
            float *d;
            char seen_ref = 0, seen_val = 0;
            
            if(!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            
            if(SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            
            tempav =(AV*)SvRV(ST(1));
            sets = av_len(tempav);
            
            for(i=0;i<=sets;i++) {
                tv = av_fetch(tempav, i, 0);
                if(SvTYPE(*tv) == SVt_RV) {
                    /* Got a ref */
                    if(seen_val)
                    croak("Mixed reference to array and data");
                    
                    seen_ref = 1;
                    
                    temp2av = (AV *)SvRV(*tv);
                    sets2 = av_len(temp2av);
                    
                    if(! points) {
                        points = sets2 + 1;
                    } else if(points && (sets2+1) != points) {
                        croak("Different number of points in data sets");
                    }
                    
                    total += sets2 + 1;
                } else {
                    if(seen_ref)
                    croak("Mixed reference to array and data");
                    
                    seen_val = 1;
                    
                    total++;
                    points = 0;
                }
            }
            
            arg2 = malloc(total * sizeof(float));
            
            for(i=0;i<=sets;i++) {
                tv = av_fetch(tempav, i, 0);
                if(SvTYPE(*tv) == SVt_RV)  {
                    temp2av = (AV *)SvRV(*tv);
                    sets2 = av_len(temp2av);
                    for(j=0;j<=sets2;j++) {
                        tv2 = av_fetch(temp2av, j, 0);
                        arg2[i*(sets2+1) + j] = (float)SvNV(*tv2);
                    }
                } else {
                    arg2[i] = (float)SvNV(*tv);
                }
            }
            
        }
        if (arg1) (arg1)->data = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_data_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        float *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_data_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_data_get. Expected _p_gdchart");
            }
        }
        result = (float *) ((arg1)->data);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_float, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_vol_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        float *arg2 = (float *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_vol_set(self,vol);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_vol_set. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV **tv;
            if(!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if(SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav =(AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (float *)malloc((len+2)*sizeof(float));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);
                arg2[i] = (float) SvNV(*tv);
            }
            arg2[i] = 0;
        }
        if (arg1) (arg1)->vol = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_vol_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        float *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_vol_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_vol_get. Expected _p_gdchart");
            }
        }
        result = (float *) ((arg1)->vol);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_float, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_output_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        FILE *arg2 = (FILE *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_output_set(self,output);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_output_set. Expected _p_gdchart");
            }
        }
        {
            arg2 = PerlIO_findFILE(IoIFP(sv_2io(ST(1))));
            
        }
        if (arg1) (arg1)->output = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_output_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        FILE *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_output_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_output_get. Expected _p_gdchart");
            }
        }
        result = (FILE *) ((arg1)->output);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_FILE, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_bgcolour_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_bgcolour_set(self,bgcolour);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_bgcolour_set. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        if (arg1) (arg1)->bgcolour = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_bgcolour_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_bgcolour_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_bgcolour_get. Expected _p_gdchart");
            }
        }
        result = (unsigned long) ((arg1)->bgcolour);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_type_set) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_type_set(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_type_set. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->type = (CHART_TYPE )arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_type_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_type_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_type_get. Expected _p_gdchart");
            }
        }
        result = (int) ((arg1)->type);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_img_get) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        gdchart_img *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_img_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_img_get. Expected _p_gdchart");
            }
        }
        result = (gdchart_img *)& ((arg1)->img);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_gdchart_img, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_gdchart) {
    {
        int arg1 = (int) 0 ;
        int arg2 = (int) 0 ;
        gdchart *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 2)) {
            SWIG_croak("Usage: new_gdchart(w,h);");
        }
        if (items > 0) {
            arg1 = (int) SvIV(ST(0));
        }
        if (items > 1) {
            arg2 = (int) SvIV(ST(1));
        }
        result = (gdchart *)new_gdchart(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_gdchart, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_gdchart) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_gdchart(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_gdchart. Expected _p_gdchart");
            }
        }
        delete_gdchart(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_options) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        HV *arg2 = (HV *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_options(self,h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_options. Expected _p_gdchart");
            }
        }
        {
            if(!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if(SvTYPE(SvRV(ST(1))) != SVt_PVHV)
            croak("ST(1) is not a hash.");
            arg2 = (HV*)SvRV(ST(1));
        }
        gdchart_options(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_scatter) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        scatter *arg2 = (scatter *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_scatter(self,s);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_scatter. Expected _p_gdchart");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_scatter,0) < 0) {
                SWIG_croak("Type error in argument 2 of gdchart_scatter. Expected _p_scatter");
            }
        }
        result = (int)gdchart_scatter(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_note) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        note *arg2 = (note *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_note(self,n);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_note. Expected _p_gdchart");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_note,0) < 0) {
                SWIG_croak("Type error in argument 2 of gdchart_note. Expected _p_note");
            }
        }
        result = (int)gdchart_note(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ytitle) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ytitle(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ytitle. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_ytitle(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xtitle) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xtitle(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xtitle. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_xtitle(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ytitle2) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ytitle2(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ytitle2. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_ytitle2(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_title) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_title(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_title. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_title(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ytitle_size) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ytitle_size(self,fs);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ytitle_size. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_ytitle_size(arg1,(enum GDC_font_size)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xtitle_size) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xtitle_size(self,fs);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xtitle_size. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_xtitle_size(arg1,(enum GDC_font_size)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_yaxisfont_size) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_yaxisfont_size(self,fs);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_yaxisfont_size. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_yaxisfont_size(arg1,(enum GDC_font_size)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xaxisfont_size) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xaxisfont_size(self,fs);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xaxisfont_size. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_xaxisfont_size(arg1,(enum GDC_font_size)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_title_tt_font) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_title_tt_font(self,fontname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_title_tt_font. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_title_tt_font(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ytitle_tt_font) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ytitle_tt_font(self,fontname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ytitle_tt_font. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_ytitle_tt_font(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xtitle_tt_font) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xtitle_tt_font(self,fontname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xtitle_tt_font. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_xtitle_tt_font(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_yaxis_tt_font) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_yaxis_tt_font(self,fontname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_yaxis_tt_font. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_yaxis_tt_font(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xaxis_tt_font) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xaxis_tt_font(self,fontname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xaxis_tt_font. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_xaxis_tt_font(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_title_ptsize) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_title_ptsize(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_title_ptsize. Expected _p_gdchart");
            }
        }
        {
            arg2 = SvNV(ST(1));
            if(arg2 == 0) {
                arg2 = SvIV(ST(1)); 
            }
        }
        gdchart_title_ptsize(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ytitle_ptsize) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ytitle_ptsize(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ytitle_ptsize. Expected _p_gdchart");
            }
        }
        {
            arg2 = SvNV(ST(1));
            if(arg2 == 0) {
                arg2 = SvIV(ST(1)); 
            }
        }
        gdchart_ytitle_ptsize(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xtitle_ptsize) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xtitle_ptsize(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xtitle_ptsize. Expected _p_gdchart");
            }
        }
        {
            arg2 = SvNV(ST(1));
            if(arg2 == 0) {
                arg2 = SvIV(ST(1)); 
            }
        }
        gdchart_xtitle_ptsize(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_yaxis_ptsize) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_yaxis_ptsize(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_yaxis_ptsize. Expected _p_gdchart");
            }
        }
        {
            arg2 = SvNV(ST(1));
            if(arg2 == 0) {
                arg2 = SvIV(ST(1)); 
            }
        }
        gdchart_yaxis_ptsize(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xaxis_ptsize) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xaxis_ptsize(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xaxis_ptsize. Expected _p_gdchart");
            }
        }
        {
            arg2 = SvNV(ST(1));
            if(arg2 == 0) {
                arg2 = SvIV(ST(1)); 
            }
        }
        gdchart_xaxis_ptsize(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xaxis_angle) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xaxis_angle(self,angle);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xaxis_angle. Expected _p_gdchart");
            }
        }
        {
            arg2 = SvNV(ST(1));
            if(arg2 == 0) {
                arg2 = SvIV(ST(1)); 
            }
        }
        gdchart_xaxis_angle(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ylabel_fmt) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ylabel_fmt(self,fmt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ylabel_fmt. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_ylabel_fmt(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ylabel2_fmt) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ylabel2_fmt(self,fmt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ylabel2_fmt. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_ylabel2_fmt(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xlabel_ctl) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xlabel_ctl(self,ctl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xlabel_ctl. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_xlabel_ctl(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xlabel_spacing) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        short arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xlabel_spacing(self,s);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xlabel_spacing. Expected _p_gdchart");
            }
        }
        arg2 = (short) SvIV(ST(1));
        gdchart_xlabel_spacing(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ylabel_density) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ylabel_density(self,d);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ylabel_density. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_ylabel_density(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_interpolations) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_interpolations(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_interpolations. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_interpolations(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_requested_ymin) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        float arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_requested_ymin(self,min);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_requested_ymin. Expected _p_gdchart");
            }
        }
        arg2 = (float) SvNV(ST(1));
        
        gdchart_requested_ymin(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_requested_ymax) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        float arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_requested_ymax(self,max);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_requested_ymax. Expected _p_gdchart");
            }
        }
        arg2 = (float) SvNV(ST(1));
        
        gdchart_requested_ymax(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_requested_yinterval) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        float arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_requested_yinterval(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_requested_yinterval. Expected _p_gdchart");
            }
        }
        arg2 = (float) SvNV(ST(1));
        
        gdchart_requested_yinterval(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_shelf) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_shelf(self,s);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_shelf. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_shelf(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_grid) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_grid(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_grid. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_grid(arg1,(GDC_TICK_T )arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ticks) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ticks(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ticks. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_ticks(arg1,(GDC_TICK_T )arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xaxis) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xaxis(self,x);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xaxis. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_xaxis(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_yaxis) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_yaxis(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_yaxis. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_yaxis(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_yaxis2) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_yaxis2(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_yaxis2. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_yaxis2(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_yval_style) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_yval_style(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_yval_style. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_yval_style(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_stack_type) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_stack_type(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_stack_type. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_stack_type(arg1,(GDC_STACK_T )arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_bar_width) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_bar_width(self,w);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_bar_width. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned char) SvUV(ST(1));
        gdchart_bar_width(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_hlc_style) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_hlc_style(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_hlc_style. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_hlc_style(arg1,(GDC_HLC_STYLE_T )arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_hlc_cap_width) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_hlc_cap_width(self,w);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_hlc_cap_width. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned char) SvUV(ST(1));
        gdchart_hlc_cap_width(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_annotation_font_size) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_annotation_font_size(self,s);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_annotation_font_size. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_annotation_font_size(arg1,(enum GDC_font_size)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_annotation_font) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_annotation_font(self,fontname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_annotation_font. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_annotation_font(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_annotation_font_ptsize) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_annotation_font_ptsize(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_annotation_font_ptsize. Expected _p_gdchart");
            }
        }
        {
            arg2 = SvNV(ST(1));
            if(arg2 == 0) {
                arg2 = SvIV(ST(1)); 
            }
        }
        gdchart_annotation_font_ptsize(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_num_scatter_pts) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_num_scatter_pts(self,p);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_num_scatter_pts. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_num_scatter_pts(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_thumbnail) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_thumbnail(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_thumbnail. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_thumbnail(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_thumblabel) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_thumblabel(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_thumblabel. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_thumblabel(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_thumbval) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        float arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_thumbval(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_thumbval. Expected _p_gdchart");
            }
        }
        arg2 = (float) SvNV(ST(1));
        
        gdchart_thumbval(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_border) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_border(self,b);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_border. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_border(arg1,(GDC_BORDER_T )arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_linecolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_linecolor(self,l);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_linecolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_linecolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_plotcolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_plotcolor(self,p);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_plotcolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_plotcolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_edgecolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_edgecolor(self,e);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_edgecolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_edgecolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_edgecolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_edgecolour(self,e);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_edgecolour. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_edgecolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_other_threshold) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_other_threshold(self,o);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_other_threshold. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_other_threshold(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_volcolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_volcolor(self,v);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_volcolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_volcolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_volcolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_volcolour(self,v);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_volcolour. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_volcolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_titlecolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_titlecolor(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_titlecolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_titlecolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_titlecolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_titlecolour(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_titlecolour. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_titlecolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xtitlecolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xtitlecolor(self,x);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xtitlecolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_xtitlecolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xtitlecolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xtitlecolour(self,x);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xtitlecolour. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_xtitlecolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ytitlecolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ytitlecolor(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ytitlecolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_ytitlecolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ytitlecolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ytitlecolour(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ytitlecolour. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_ytitlecolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ytitle2color) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ytitle2color(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ytitle2color. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_ytitle2color(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ytitle2colour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ytitle2colour(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ytitle2colour. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_ytitle2colour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xlabelcolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xlabelcolor(self,x);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xlabelcolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_xlabelcolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_xlabelcolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_xlabelcolour(self,x);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_xlabelcolour. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_xlabelcolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ylabelcolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ylabelcolor(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ylabelcolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_ylabelcolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ylabelcolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ylabelcolour(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ylabelcolour. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_ylabelcolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ylabel2color) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ylabel2color(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ylabel2color. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_ylabel2color(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_ylabel2colour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_ylabel2colour(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_ylabel2colour. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_ylabel2colour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_extvolcolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_extvolcolor(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_extvolcolor. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_extvolcolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_extvolcolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_extvolcolour(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_extvolcolour. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_extvolcolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_setcolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_setcolor(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_setcolor. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_setcolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_setcolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_setcolour(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_setcolour. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_setcolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_color) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_color(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_color. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_color(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_colors) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_colors(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_colors. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_colors(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_colour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_colour(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_colour. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_colour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_colours) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_colours(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_colours. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_colours(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_extcolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_extcolor(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_extcolor. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_extcolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_extcolour) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long *arg2 = (unsigned long *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_extcolour(self,c);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_extcolour. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = (unsigned long *) malloc((len+2)*sizeof(unsigned long *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (unsigned long) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_extcolour(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_transparent_bg) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_transparent_bg(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_transparent_bg. Expected _p_gdchart");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        gdchart_transparent_bg(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_bgimage) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_bgimage(self,b);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_bgimage. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_bgimage(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_label_size) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_label_size(self,fs);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_label_size. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_label_size(arg1,(enum GDC_font_size)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_label_font) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_label_font(self,fontname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_label_font. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_label_font(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_label_font_ptsize) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_label_font_ptsize(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_label_font_ptsize. Expected _p_gdchart");
            }
        }
        {
            arg2 = SvNV(ST(1));
            if(arg2 == 0) {
                arg2 = SvIV(ST(1)); 
            }
        }
        gdchart_label_font_ptsize(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_label_dist) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_label_dist(self,l);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_label_dist. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_label_dist(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_label_line) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_label_line(self,l);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_label_line. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned char) SvUV(ST(1));
        gdchart_label_line(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_explode) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int *arg2 = (int *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_explode(self,e);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_explode. Expected _p_gdchart");
            }
        }
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(1)))
            croak("ST(1) is not a reference.");
            if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
            croak("ST(1) is not an array.");
            tempav = (AV*)SvRV(ST(1));
            len = av_len(tempav);
            arg2 = malloc((len+2)*sizeof(int));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg2[i] = (int) SvIV(*tv);
            }
            arg2[i] = 0;
        }
        gdchart_explode(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_missing) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned char *arg2 = (unsigned char *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_missing(self,m);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_missing. Expected _p_gdchart");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_unsigned_char,0) < 0) {
                SWIG_croak("Type error in argument 2 of gdchart_missing. Expected _p_unsigned_char");
            }
        }
        gdchart_missing(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_percent_labels) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_percent_labels(self,t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_percent_labels. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_percent_labels(arg1,(GDCPIE_PCT_TYPE )arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_percent_fmt) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_percent_fmt(self,fmt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_percent_fmt. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_percent_fmt(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_height) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_height(self,h);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_height. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_height(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_width) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_width(self,w);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_width. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_width(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_chart_type) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_chart_type(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_chart_type. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_chart_type(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_pie_type) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_pie_type(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_pie_type. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_pie_type(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_imgtype) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_imgtype(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_imgtype. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_imgtype(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_sets) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_sets(self,n);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_sets. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_sets(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_points) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_points(self,n);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_points. Expected _p_gdchart");
            }
        }
        arg2 = (int) SvIV(ST(1));
        gdchart_points(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_bgcolor) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        unsigned long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_bgcolor(self,col);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_bgcolor. Expected _p_gdchart");
            }
        }
        arg2 = (unsigned long) SvUV(ST(1));
        gdchart_bgcolor(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_fd) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        FILE *arg2 = (FILE *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_fd(self,fd);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_fd. Expected _p_gdchart");
            }
        }
        {
            arg2 = PerlIO_findFILE(IoIFP(sv_2io(ST(1))));
            
        }
        gdchart_fd(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_filename) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_filename(self,file);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_filename. Expected _p_gdchart");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        gdchart_filename(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_draw) {
    {
        gdchart *arg1 = (gdchart *) 0 ;
        char **arg2 = (char **) NULL ;
        float *arg3 = (float *) NULL ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 3)) {
            SWIG_croak("Usage: gdchart_draw(self,labels,data);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_draw. Expected _p_gdchart");
            }
        }
        if (items > 1) {
            {
                AV *tempav;
                I32 len;
                int i;
                SV  **tv;
                if (!SvROK(ST(1)))
                croak("ST(1) is not a reference.");
                if (SvTYPE(SvRV(ST(1))) != SVt_PVAV)
                croak("ST(1) is not an array.");
                tempav = (AV*)SvRV(ST(1));
                len = av_len(tempav);
                arg2 = (char **) malloc((len+2)*sizeof(char *));
                for (i = 0; i <= len; i++) {
                    tv = av_fetch(tempav, i, 0);        
                    arg2[i] = (char *) SvPV(*tv,PL_na);
                }
                arg2[i] = 0;
            }
        }
        if (items > 2) {
            {
                AV *tempav, *temp2av;
                I32 len,i,j, sets, points, sets2, total;
                SV **tv, **tv2;
                float *d;
                char seen_ref = 0, seen_val = 0;
                
                if(!SvROK(ST(2)))
                croak("ST(2) is not a reference.");
                
                if(SvTYPE(SvRV(ST(2))) != SVt_PVAV)
                croak("ST(2) is not an array.");
                
                tempav =(AV*)SvRV(ST(2));
                sets = av_len(tempav);
                
                for(i=0;i<=sets;i++) {
                    tv = av_fetch(tempav, i, 0);
                    if(SvTYPE(*tv) == SVt_RV) {
                        /* Got a ref */
                        if(seen_val)
                        croak("Mixed reference to array and data");
                        
                        seen_ref = 1;
                        
                        temp2av = (AV *)SvRV(*tv);
                        sets2 = av_len(temp2av);
                        
                        if(! points) {
                            points = sets2 + 1;
                        } else if(points && (sets2+1) != points) {
                            croak("Different number of points in data sets");
                        }
                        
                        total += sets2 + 1;
                    } else {
                        if(seen_ref)
                        croak("Mixed reference to array and data");
                        
                        seen_val = 1;
                        
                        total++;
                        points = 0;
                    }
                }
                
                arg3 = malloc(total * sizeof(float));
                
                for(i=0;i<=sets;i++) {
                    tv = av_fetch(tempav, i, 0);
                    if(SvTYPE(*tv) == SVt_RV)  {
                        temp2av = (AV *)SvRV(*tv);
                        sets2 = av_len(temp2av);
                        for(j=0;j<=sets2;j++) {
                            tv2 = av_fetch(temp2av, j, 0);
                            arg3[i*(sets2+1) + j] = (float)SvNV(*tv2);
                        }
                    } else {
                        arg3[i] = (float)SvNV(*tv);
                    }
                }
                
            }
        }
        result = (int)gdchart_draw(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_img_chart_set) {
    {
        gdchart_img *arg1 = (gdchart_img *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_img_chart_set(self,chart);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart_img,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_img_chart_set. Expected _p_gdchart_img");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->chart = (GDC_CHART_T )arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_img_chart_get) {
    {
        gdchart_img *arg1 = (gdchart_img *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_img_chart_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart_img,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_img_chart_get. Expected _p_gdchart_img");
            }
        }
        result = (int) ((arg1)->chart);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_img_pie_set) {
    {
        gdchart_img *arg1 = (gdchart_img *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: gdchart_img_pie_set(self,pie);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart_img,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_img_pie_set. Expected _p_gdchart_img");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->pie = (GDCPIE_TYPE )arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_gdchart_img_pie_get) {
    {
        gdchart_img *arg1 = (gdchart_img *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: gdchart_img_pie_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart_img,0) < 0) {
                SWIG_croak("Type error in argument 1 of gdchart_img_pie_get. Expected _p_gdchart_img");
            }
        }
        result = (int) ((arg1)->pie);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_gdchart_img) {
    {
        gdchart_img *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_gdchart_img();");
        }
        result = (gdchart_img *)(gdchart_img *) calloc(1, sizeof(gdchart_img));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_gdchart_img, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_gdchart_img) {
    {
        gdchart_img *arg1 = (gdchart_img *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_gdchart_img(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_gdchart_img,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_gdchart_img. Expected _p_gdchart_img");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDC_out_graph) {
    {
        short arg1 ;
        short arg2 ;
        FILE *arg3 = (FILE *) 0 ;
        int arg4 ;
        int arg5 ;
        char **arg6 = (char **) 0 ;
        int arg7 ;
        float *arg8 = (float *) 0 ;
        float *arg9 = (float *) NULL ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 8) || (items > 9)) {
            SWIG_croak("Usage: GDC_out_graph(IMGWIDTH,IMGHEIGHT,img_fptr,type,num_points,xlbl,num_sets,data,combo_data);");
        }
        arg1 = (short) SvIV(ST(0));
        arg2 = (short) SvIV(ST(1));
        {
            arg3 = PerlIO_findFILE(IoIFP(sv_2io(ST(2))));
        }
        arg4 = (int) SvIV(ST(3));
        arg5 = (int) SvIV(ST(4));
        {
            AV *tempav;
            I32 len;
            int i;
            SV  **tv;
            if (!SvROK(ST(5)))
            croak("ST(5) is not a reference.");
            if (SvTYPE(SvRV(ST(5))) != SVt_PVAV)
            croak("ST(5) is not an array.");
            tempav = (AV*)SvRV(ST(5));
            len = av_len(tempav);
            arg6 = (char **) malloc((len+2)*sizeof(char *));
            for (i = 0; i <= len; i++) {
                tv = av_fetch(tempav, i, 0);        
                arg6[i] = (char *) SvPV(*tv,PL_na);
            }
            arg6[i] = 0;
        }
        arg7 = (int) SvIV(ST(6));
        {
            AV *tempav, *temp2av;
            I32 len,i,j, sets, points, sets2, total;
            SV **tv, **tv2;
            float *d;
            char seen_ref = 0, seen_val = 0;
            
            if(!SvROK(ST(7)))
            croak("ST(7) is not a reference.");
            
            if(SvTYPE(SvRV(ST(7))) != SVt_PVAV)
            croak("ST(7) is not an array.");
            
            tempav =(AV*)SvRV(ST(7));
            sets = av_len(tempav);
            
            for(i=0;i<=sets;i++) {
                tv = av_fetch(tempav, i, 0);
                if(SvTYPE(*tv) == SVt_RV) {
                    /* Got a ref */
                    if(seen_val)
                    croak("Mixed reference to array and data");
                    
                    seen_ref = 1;
                    
                    temp2av = (AV *)SvRV(*tv);
                    sets2 = av_len(temp2av);
                    
                    if(! points) {
                        points = sets2 + 1;
                    } else if(points && (sets2+1) != points) {
                        croak("Different number of points in data sets");
                    }
                    
                    total += sets2 + 1;
                } else {
                    if(seen_ref)
                    croak("Mixed reference to array and data");
                    
                    seen_val = 1;
                    
                    total++;
                    points = 0;
                }
            }
            
            arg8 = malloc(total * sizeof(float));
            
            for(i=0;i<=sets;i++) {
                tv = av_fetch(tempav, i, 0);
                if(SvTYPE(*tv) == SVt_RV)  {
                    temp2av = (AV *)SvRV(*tv);
                    sets2 = av_len(temp2av);
                    for(j=0;j<=sets2;j++) {
                        tv2 = av_fetch(temp2av, j, 0);
                        arg8[i*(sets2+1) + j] = (float)SvNV(*tv2);
                    }
                } else {
                    arg8[i] = (float)SvNV(*tv);
                }
            }
            
        }
        if (items > 8) {
            {
                AV *tempav;
                I32 len;
                int i;
                SV **tv;
                if(!SvROK(ST(8)))
                croak("ST(8) is not a reference.");
                if(SvTYPE(SvRV(ST(8))) != SVt_PVAV)
                croak("ST(8) is not an array.");
                tempav =(AV*)SvRV(ST(8));
                len = av_len(tempav);
                arg9 = (float *)malloc((len+2)*sizeof(float));
                for (i = 0; i <= len; i++) {
                    tv = av_fetch(tempav, i, 0);
                    arg9[i] = (float) SvNV(*tv);
                }
                arg9[i] = 0;
            }
        }
        result = (int)GDC_out_graph(arg1,arg2,arg3,(GDC_CHART_T )arg4,arg5,arg6,arg7,arg8,arg9);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_GDC_destroy_image) {
    {
        void *arg1 = (void *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: GDC_destroy_image(void *);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, 0,0) < 0) {
                SWIG_croak("Type error in argument 1 of GDC_destroy_image. Expected _p_void");
            }
        }
        GDC_destroy_image(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_out_err) {
    {
        int arg1 ;
        int arg2 ;
        FILE *arg3 = (FILE *) 0 ;
        unsigned long arg4 ;
        unsigned long arg5 ;
        char *arg6 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: out_err(IMGWIDTH,IMGHEIGHT,fptr,BGColor,LineColor,err_str);");
        }
        arg1 = (int) SvIV(ST(0));
        arg2 = (int) SvIV(ST(1));
        {
            arg3 = PerlIO_findFILE(IoIFP(sv_2io(ST(2))));
        }
        arg4 = (unsigned long) SvUV(ST(3));
        arg5 = (unsigned long) SvUV(ST(4));
        if (!SvOK((SV*) ST(5))) arg6 = 0;
        else arg6 = (char *) SvPV(ST(5), PL_na);
        out_err(arg1,arg2,arg3,arg4,arg5,arg6);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_unsigned_char[] = {{"_p_unsigned_char", 0, "unsigned char *", 0},{"_p_unsigned_char"},{0}};
static swig_type_info _swigt__p_GDC_HOLD_IMAGE_T[] = {{"_p_GDC_HOLD_IMAGE_T", 0, "GDC_HOLD_IMAGE_T *", 0},{"_p_GDC_HOLD_IMAGE_T"},{0}};
static swig_type_info _swigt__p_scatter[] = {{"GD::Chart::scatter", 0, "scatter *", 0},{"GD::Chart::scatter"},{0}};
static swig_type_info _swigt__p_unsigned_long[] = {{"_p_unsigned_long", 0, "unsigned long *", 0},{"_p_unsigned_long"},{0}};
static swig_type_info _swigt__p_float[] = {{"_p_float", 0, "float *", 0},{"_p_float"},{0}};
static swig_type_info _swigt__p_unsigned_int[] = {{"_p_unsigned_int", 0, "unsigned int *", 0},{"_p_unsigned_int"},{0}};
static swig_type_info _swigt__p_void[] = {{"_p_void", 0, "void *", 0},{"_p_void"},{0}};
static swig_type_info _swigt__p_short[] = {{"_p_short", 0, "short *", 0},{"_p_short"},{0}};
static swig_type_info _swigt__p_p_char[] = {{"_p_p_char", 0, "char **", 0},{"_p_p_char"},{0}};
static swig_type_info _swigt__p_gdchart_img[] = {{"GD::Chart::gdchart_img", 0, "gdchart_img *", 0},{"GD::Chart::gdchart_img"},{0}};
static swig_type_info _swigt__p_HV[] = {{"_p_HV", 0, "HV *", 0},{"_p_HV"},{0}};
static swig_type_info _swigt__p_FILE[] = {{"_p_FILE", 0, "FILE *", 0},{"_p_FILE"},{0}};
static swig_type_info _swigt__p_GDC_ANNOTATION_T[] = {{"_p_GDC_ANNOTATION_T", 0, "GDC_ANNOTATION_T *", 0},{"_p_GDC_ANNOTATION_T"},{0}};
static swig_type_info _swigt__p_GDC_SCATTER_T[] = {{"_p_GDC_SCATTER_T", 0, "GDC_SCATTER_T *", 0},{"_p_GDC_SCATTER_T"},{0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *", 0},{"_p_int"},{0}};
static swig_type_info _swigt__p_gdchart[] = {{"GD::Chart::gdchart", 0, "gdchart *", 0},{"GD::Chart::gdchart"},{0}};
static swig_type_info _swigt__p_note[] = {{"GD::Chart::note", 0, "note *", 0},{"GD::Chart::note"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_unsigned_char, 
_swigt__p_GDC_HOLD_IMAGE_T, 
_swigt__p_scatter, 
_swigt__p_unsigned_long, 
_swigt__p_float, 
_swigt__p_unsigned_int, 
_swigt__p_void, 
_swigt__p_short, 
_swigt__p_p_char, 
_swigt__p_gdchart_img, 
_swigt__p_HV, 
_swigt__p_FILE, 
_swigt__p_GDC_ANNOTATION_T, 
_swigt__p_GDC_SCATTER_T, 
_swigt__p_int, 
_swigt__p_gdchart, 
_swigt__p_note, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_constant_info swig_constants[] = {
{ SWIG_INT,     (char *) SWIG_prefix "FALSE", (long) 0, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "TRUE", (long) 1, 0, 0, 0},
{ SWIG_FLOAT,   (char *) SWIG_prefix "GDC_NOVALUE", 0, (double) -3.40282347e+38F, 0, 0},
{ SWIG_FLOAT,   (char *) SWIG_prefix "GDC_NULL", 0, (double) -3.40282347e+38F, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_NOCOLOR", (long) 0x1000000L, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_DFLTCOLOR", (long) 0x2000000L, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "PVRED", (long) 0x00FF0000, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "PVGRN", (long) 0x0000FF00, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "PVBLU", (long) 0x000000FF, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CHART", (long) CHART, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "PIE", (long) PIE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_pad", (long) GDC_pad, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_TINY", (long) GDC_TINY, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_SMALL", (long) GDC_SMALL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_MEDBOLD", (long) GDC_MEDBOLD, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_LARGE", (long) GDC_LARGE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_GIANT", (long) GDC_GIANT, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_numfonts", (long) GDC_numfonts, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_STACK_DEPTH", (long) GDC_STACK_DEPTH, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_STACK_SUM", (long) GDC_STACK_SUM, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_STACK_BESIDE", (long) GDC_STACK_BESIDE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_STACK_LAYER", (long) GDC_STACK_LAYER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_HLC_DIAMOND", (long) GDC_HLC_DIAMOND, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_HLC_CLOSE_CONNECTED", (long) GDC_HLC_CLOSE_CONNECTED, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_HLC_CONNECTING", (long) GDC_HLC_CONNECTING, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_HLC_I_CAP", (long) GDC_HLC_I_CAP, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_SCATTER_TRIANGLE_DOWN", (long) GDC_SCATTER_TRIANGLE_DOWN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_SCATTER_TRIANGLE_UP", (long) GDC_SCATTER_TRIANGLE_UP, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_SCATTER_CIRCLE", (long) GDC_SCATTER_CIRCLE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_TICK_LABELS", (long) GDC_TICK_LABELS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_TICK_POINTS", (long) GDC_TICK_POINTS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_TICK_NONE", (long) GDC_TICK_NONE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_BORDER_NONE", (long) GDC_BORDER_NONE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_BORDER_ALL", (long) GDC_BORDER_ALL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_BORDER_X", (long) GDC_BORDER_X, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_BORDER_Y", (long) GDC_BORDER_Y, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_BORDER_Y2", (long) GDC_BORDER_Y2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_BORDER_TOP", (long) GDC_BORDER_TOP, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DPIE", (long) GDC_3DPIE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_2DPIE", (long) GDC_2DPIE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDCPIE_PCT_NONE", (long) GDCPIE_PCT_NONE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDCPIE_PCT_ABOVE", (long) GDCPIE_PCT_ABOVE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDCPIE_PCT_BELOW", (long) GDCPIE_PCT_BELOW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDCPIE_PCT_RIGHT", (long) GDCPIE_PCT_RIGHT, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDCPIE_PCT_LEFT", (long) GDCPIE_PCT_LEFT, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_GIF", (long) GDC_GIF, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_PNG", (long) GDC_PNG, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_WBMP", (long) GDC_WBMP, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_LINE", (long) GDC_LINE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_AREA", (long) GDC_AREA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_BAR", (long) GDC_BAR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_FLOATINGBAR", (long) GDC_FLOATINGBAR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_HILOCLOSE", (long) GDC_HILOCLOSE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_COMBO_LINE_BAR", (long) GDC_COMBO_LINE_BAR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_COMBO_HLC_BAR", (long) GDC_COMBO_HLC_BAR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_COMBO_LINE_AREA", (long) GDC_COMBO_LINE_AREA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_COMBO_LINE_LINE", (long) GDC_COMBO_LINE_LINE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_COMBO_HLC_AREA", (long) GDC_COMBO_HLC_AREA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DHILOCLOSE", (long) GDC_3DHILOCLOSE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DCOMBO_LINE_BAR", (long) GDC_3DCOMBO_LINE_BAR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DCOMBO_LINE_AREA", (long) GDC_3DCOMBO_LINE_AREA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DCOMBO_LINE_LINE", (long) GDC_3DCOMBO_LINE_LINE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DCOMBO_HLC_BAR", (long) GDC_3DCOMBO_HLC_BAR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DCOMBO_HLC_AREA", (long) GDC_3DCOMBO_HLC_AREA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DBAR", (long) GDC_3DBAR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DFLOATINGBAR", (long) GDC_3DFLOATINGBAR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DAREA", (long) GDC_3DAREA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "GDC_3DLINE", (long) GDC_3DLINE, 0, 0, 0},
{0}
};
#ifdef __cplusplus
}
#endif
static swig_variable_info swig_variables[] = {
    { "GD::Chartc::GDC_ytitle", MAGIC_CLASS _wrap_set_GDC_ytitle, MAGIC_CLASS _wrap_val_GDC_ytitle,0 },
    { "GD::Chartc::GDC_xtitle", MAGIC_CLASS _wrap_set_GDC_xtitle, MAGIC_CLASS _wrap_val_GDC_xtitle,0 },
    { "GD::Chartc::GDC_ytitle2", MAGIC_CLASS _wrap_set_GDC_ytitle2, MAGIC_CLASS _wrap_val_GDC_ytitle2,0 },
    { "GD::Chartc::GDC_title", MAGIC_CLASS _wrap_set_GDC_title, MAGIC_CLASS _wrap_val_GDC_title,0 },
    { "GD::Chartc::GDC_title_size", MAGIC_CLASS _wrap_set_GDC_title_size, MAGIC_CLASS _wrap_val_GDC_title_size,0 },
    { "GD::Chartc::GDC_ytitle_size", MAGIC_CLASS _wrap_set_GDC_ytitle_size, MAGIC_CLASS _wrap_val_GDC_ytitle_size,0 },
    { "GD::Chartc::GDC_xtitle_size", MAGIC_CLASS _wrap_set_GDC_xtitle_size, MAGIC_CLASS _wrap_val_GDC_xtitle_size,0 },
    { "GD::Chartc::GDC_yaxisfont_size", MAGIC_CLASS _wrap_set_GDC_yaxisfont_size, MAGIC_CLASS _wrap_val_GDC_yaxisfont_size,0 },
    { "GD::Chartc::GDC_xaxisfont_size", MAGIC_CLASS _wrap_set_GDC_xaxisfont_size, MAGIC_CLASS _wrap_val_GDC_xaxisfont_size,0 },
    { "GD::Chartc::GDC_ylabel_fmt", MAGIC_CLASS _wrap_set_GDC_ylabel_fmt, MAGIC_CLASS _wrap_val_GDC_ylabel_fmt,0 },
    { "GD::Chartc::GDC_ylabel2_fmt", MAGIC_CLASS _wrap_set_GDC_ylabel2_fmt, MAGIC_CLASS _wrap_val_GDC_ylabel2_fmt,0 },
    { "GD::Chartc::GDC_xlabel_ctl", MAGIC_CLASS _wrap_set_GDC_xlabel_ctl, MAGIC_CLASS _wrap_val_GDC_xlabel_ctl,0 },
    { "GD::Chartc::GDC_xlabel_spacing", MAGIC_CLASS _wrap_set_GDC_xlabel_spacing, MAGIC_CLASS _wrap_val_GDC_xlabel_spacing,&SWIGTYPE_p_short },
    { "GD::Chartc::GDC_ylabel_density", MAGIC_CLASS _wrap_set_GDC_ylabel_density, MAGIC_CLASS _wrap_val_GDC_ylabel_density,0 },
    { "GD::Chartc::GDC_interpolations", MAGIC_CLASS _wrap_set_GDC_interpolations, MAGIC_CLASS _wrap_val_GDC_interpolations,0 },
    { "GD::Chartc::GDC_requested_ymin", MAGIC_CLASS _wrap_set_GDC_requested_ymin, MAGIC_CLASS _wrap_val_GDC_requested_ymin,0 },
    { "GD::Chartc::GDC_requested_ymax", MAGIC_CLASS _wrap_set_GDC_requested_ymax, MAGIC_CLASS _wrap_val_GDC_requested_ymax,0 },
    { "GD::Chartc::GDC_requested_yinterval", MAGIC_CLASS _wrap_set_GDC_requested_yinterval, MAGIC_CLASS _wrap_val_GDC_requested_yinterval,0 },
    { "GD::Chartc::GDC_0Shelf", MAGIC_CLASS _wrap_set_GDC_0Shelf, MAGIC_CLASS _wrap_val_GDC_0Shelf,0 },
    { "GD::Chartc::GDC_grid", MAGIC_CLASS _wrap_set_GDC_grid, MAGIC_CLASS _wrap_val_GDC_grid,0 },
    { "GD::Chartc::GDC_ticks", MAGIC_CLASS _wrap_set_GDC_ticks, MAGIC_CLASS _wrap_val_GDC_ticks,0 },
    { "GD::Chartc::GDC_xaxis", MAGIC_CLASS _wrap_set_GDC_xaxis, MAGIC_CLASS _wrap_val_GDC_xaxis,0 },
    { "GD::Chartc::GDC_yaxis", MAGIC_CLASS _wrap_set_GDC_yaxis, MAGIC_CLASS _wrap_val_GDC_yaxis,0 },
    { "GD::Chartc::GDC_yaxis2", MAGIC_CLASS _wrap_set_GDC_yaxis2, MAGIC_CLASS _wrap_val_GDC_yaxis2,0 },
    { "GD::Chartc::GDC_yval_style", MAGIC_CLASS _wrap_set_GDC_yval_style, MAGIC_CLASS _wrap_val_GDC_yval_style,0 },
    { "GD::Chartc::GDC_stack_type", MAGIC_CLASS _wrap_set_GDC_stack_type, MAGIC_CLASS _wrap_val_GDC_stack_type,0 },
    { "GD::Chartc::GDC_3d_depth", MAGIC_CLASS _wrap_set_GDC_3d_depth, MAGIC_CLASS _wrap_val_GDC_3d_depth,0 },
    { "GD::Chartc::GDC_3d_angle", MAGIC_CLASS _wrap_set_GDC_3d_angle, MAGIC_CLASS _wrap_val_GDC_3d_angle,0 },
    { "GD::Chartc::GDC_bar_width", MAGIC_CLASS _wrap_set_GDC_bar_width, MAGIC_CLASS _wrap_val_GDC_bar_width,0 },
    { "GD::Chartc::GDC_HLC_style", MAGIC_CLASS _wrap_set_GDC_HLC_style, MAGIC_CLASS _wrap_val_GDC_HLC_style,0 },
    { "GD::Chartc::GDC_HLC_cap_width", MAGIC_CLASS _wrap_set_GDC_HLC_cap_width, MAGIC_CLASS _wrap_val_GDC_HLC_cap_width,0 },
    { "GD::Chartc::GDC_annotation", MAGIC_CLASS _wrap_set_GDC_annotation, MAGIC_CLASS _wrap_val_GDC_annotation,&SWIGTYPE_p_GDC_ANNOTATION_T },
    { "GD::Chartc::GDC_num_scatter_pts", MAGIC_CLASS _wrap_set_GDC_num_scatter_pts, MAGIC_CLASS _wrap_val_GDC_num_scatter_pts,0 },
    { "GD::Chartc::GDC_scatter", MAGIC_CLASS _wrap_set_GDC_scatter, MAGIC_CLASS _wrap_val_GDC_scatter,&SWIGTYPE_p_GDC_SCATTER_T },
    { "GD::Chartc::GDC_thumbnail", MAGIC_CLASS _wrap_set_GDC_thumbnail, MAGIC_CLASS _wrap_val_GDC_thumbnail,0 },
    { "GD::Chartc::GDC_thumblabel", MAGIC_CLASS _wrap_set_GDC_thumblabel, MAGIC_CLASS _wrap_val_GDC_thumblabel,0 },
    { "GD::Chartc::GDC_thumbval", MAGIC_CLASS _wrap_set_GDC_thumbval, MAGIC_CLASS _wrap_val_GDC_thumbval,0 },
    { "GD::Chartc::GDC_border", MAGIC_CLASS _wrap_set_GDC_border, MAGIC_CLASS _wrap_val_GDC_border,0 },
    { "GD::Chartc::GDC_BGColor", MAGIC_CLASS _wrap_set_GDC_BGColor, MAGIC_CLASS _wrap_val_GDC_BGColor,0 },
    { "GD::Chartc::GDC_GridColor", MAGIC_CLASS _wrap_set_GDC_GridColor, MAGIC_CLASS _wrap_val_GDC_GridColor,0 },
    { "GD::Chartc::GDC_LineColor", MAGIC_CLASS _wrap_set_GDC_LineColor, MAGIC_CLASS _wrap_val_GDC_LineColor,0 },
    { "GD::Chartc::GDC_PlotColor", MAGIC_CLASS _wrap_set_GDC_PlotColor, MAGIC_CLASS _wrap_val_GDC_PlotColor,0 },
    { "GD::Chartc::GDC_VolColor", MAGIC_CLASS _wrap_set_GDC_VolColor, MAGIC_CLASS _wrap_val_GDC_VolColor,0 },
    { "GD::Chartc::GDC_TitleColor", MAGIC_CLASS _wrap_set_GDC_TitleColor, MAGIC_CLASS _wrap_val_GDC_TitleColor,0 },
    { "GD::Chartc::GDC_XTitleColor", MAGIC_CLASS _wrap_set_GDC_XTitleColor, MAGIC_CLASS _wrap_val_GDC_XTitleColor,0 },
    { "GD::Chartc::GDC_YTitleColor", MAGIC_CLASS _wrap_set_GDC_YTitleColor, MAGIC_CLASS _wrap_val_GDC_YTitleColor,0 },
    { "GD::Chartc::GDC_YTitle2Color", MAGIC_CLASS _wrap_set_GDC_YTitle2Color, MAGIC_CLASS _wrap_val_GDC_YTitle2Color,0 },
    { "GD::Chartc::GDC_XLabelColor", MAGIC_CLASS _wrap_set_GDC_XLabelColor, MAGIC_CLASS _wrap_val_GDC_XLabelColor,0 },
    { "GD::Chartc::GDC_YLabelColor", MAGIC_CLASS _wrap_set_GDC_YLabelColor, MAGIC_CLASS _wrap_val_GDC_YLabelColor,0 },
    { "GD::Chartc::GDC_YLabel2Color", MAGIC_CLASS _wrap_set_GDC_YLabel2Color, MAGIC_CLASS _wrap_val_GDC_YLabel2Color,0 },
    { "GD::Chartc::GDC_ExtVolColor", MAGIC_CLASS _wrap_set_GDC_ExtVolColor, MAGIC_CLASS _wrap_val_GDC_ExtVolColor,0 },
    { "GD::Chartc::GDC_SetColor", MAGIC_CLASS _wrap_set_GDC_SetColor, MAGIC_CLASS _wrap_val_GDC_SetColor,0 },
    { "GD::Chartc::GDC_ExtColor", MAGIC_CLASS _wrap_set_GDC_ExtColor, MAGIC_CLASS _wrap_val_GDC_ExtColor,0 },
    { "GD::Chartc::GDC_transparent_bg", MAGIC_CLASS _wrap_set_GDC_transparent_bg, MAGIC_CLASS _wrap_val_GDC_transparent_bg,0 },
    { "GD::Chartc::GDC_BGImage", MAGIC_CLASS _wrap_set_GDC_BGImage, MAGIC_CLASS _wrap_val_GDC_BGImage,0 },
    { "GD::Chartc::GDC_hard_size", MAGIC_CLASS _wrap_set_GDC_hard_size, MAGIC_CLASS _wrap_val_GDC_hard_size,0 },
    { "GD::Chartc::GDC_hard_xorig", MAGIC_CLASS _wrap_set_GDC_hard_xorig, MAGIC_CLASS _wrap_val_GDC_hard_xorig,0 },
    { "GD::Chartc::GDC_hard_graphwidth", MAGIC_CLASS _wrap_set_GDC_hard_graphwidth, MAGIC_CLASS _wrap_val_GDC_hard_graphwidth,0 },
    { "GD::Chartc::GDC_hard_yorig", MAGIC_CLASS _wrap_set_GDC_hard_yorig, MAGIC_CLASS _wrap_val_GDC_hard_yorig,0 },
    { "GD::Chartc::GDC_hard_grapheight", MAGIC_CLASS _wrap_set_GDC_hard_grapheight, MAGIC_CLASS _wrap_val_GDC_hard_grapheight,0 },
    { "GD::Chartc::GDC_image_type", MAGIC_CLASS _wrap_set_GDC_image_type, MAGIC_CLASS _wrap_val_GDC_image_type,0 },
    { "GD::Chartc::GDC_generate_img", MAGIC_CLASS _wrap_set_GDC_generate_img, MAGIC_CLASS _wrap_val_GDC_generate_img,0 },
    { "GD::Chartc::GDC_hold_img", MAGIC_CLASS _wrap_set_GDC_hold_img, MAGIC_CLASS _wrap_val_GDC_hold_img,&SWIGTYPE_p_GDC_HOLD_IMAGE_T },
    { "GD::Chartc::GDC_image", MAGIC_CLASS _wrap_set_GDC_image, MAGIC_CLASS _wrap_val_GDC_image,&SWIGTYPE_p_void },
    { "GD::Chartc::GDCPIE_BGColor", MAGIC_CLASS _wrap_set_GDCPIE_BGColor, MAGIC_CLASS _wrap_val_GDCPIE_BGColor,0 },
    { "GD::Chartc::GDCPIE_PlotColor", MAGIC_CLASS _wrap_set_GDCPIE_PlotColor, MAGIC_CLASS _wrap_val_GDCPIE_PlotColor,0 },
    { "GD::Chartc::GDCPIE_LineColor", MAGIC_CLASS _wrap_set_GDCPIE_LineColor, MAGIC_CLASS _wrap_val_GDCPIE_LineColor,0 },
    { "GD::Chartc::GDCPIE_EdgeColor", MAGIC_CLASS _wrap_set_GDCPIE_EdgeColor, MAGIC_CLASS _wrap_val_GDCPIE_EdgeColor,0 },
    { "GD::Chartc::GDCPIE_other_threshold", MAGIC_CLASS _wrap_set_GDCPIE_other_threshold, MAGIC_CLASS _wrap_val_GDCPIE_other_threshold,0 },
    { "GD::Chartc::GDCPIE_3d_angle", MAGIC_CLASS _wrap_set_GDCPIE_3d_angle, MAGIC_CLASS _wrap_val_GDCPIE_3d_angle,0 },
    { "GD::Chartc::GDCPIE_3d_depth", MAGIC_CLASS _wrap_set_GDCPIE_3d_depth, MAGIC_CLASS _wrap_val_GDCPIE_3d_depth,0 },
    { "GD::Chartc::GDCPIE_title", MAGIC_CLASS _wrap_set_GDCPIE_title, MAGIC_CLASS _wrap_val_GDCPIE_title,0 },
    { "GD::Chartc::GDCPIE_title_size", MAGIC_CLASS _wrap_set_GDCPIE_title_size, MAGIC_CLASS _wrap_val_GDCPIE_title_size,0 },
    { "GD::Chartc::GDCPIE_label_size", MAGIC_CLASS _wrap_set_GDCPIE_label_size, MAGIC_CLASS _wrap_val_GDCPIE_label_size,0 },
    { "GD::Chartc::GDCPIE_label_dist", MAGIC_CLASS _wrap_set_GDCPIE_label_dist, MAGIC_CLASS _wrap_val_GDCPIE_label_dist,0 },
    { "GD::Chartc::GDCPIE_label_line", MAGIC_CLASS _wrap_set_GDCPIE_label_line, MAGIC_CLASS _wrap_val_GDCPIE_label_line,0 },
    { "GD::Chartc::GDCPIE_explode", MAGIC_CLASS _wrap_set_GDCPIE_explode, MAGIC_CLASS _wrap_val_GDCPIE_explode,&SWIGTYPE_p_unsigned_int },
    { "GD::Chartc::GDCPIE_Color", MAGIC_CLASS _wrap_set_GDCPIE_Color, MAGIC_CLASS _wrap_val_GDCPIE_Color,0 },
    { "GD::Chartc::GDCPIE_missing", MAGIC_CLASS _wrap_set_GDCPIE_missing, MAGIC_CLASS _wrap_val_GDCPIE_missing,&SWIGTYPE_p_unsigned_char },
    { "GD::Chartc::GDCPIE_percent_labels", MAGIC_CLASS _wrap_set_GDCPIE_percent_labels, MAGIC_CLASS _wrap_val_GDCPIE_percent_labels,0 },
    { "GD::Chartc::GDCPIE_percent_fmt", MAGIC_CLASS _wrap_set_GDCPIE_percent_fmt, MAGIC_CLASS _wrap_val_GDCPIE_percent_fmt,0 },
    { "GD::Chartc::GDC_xaxis_angle", MAGIC_CLASS _wrap_set_GDC_xaxis_angle, MAGIC_CLASS _wrap_val_GDC_xaxis_angle,0 },
    { "GD::Chartc::GDC_annotation_font_size", MAGIC_CLASS _wrap_set_GDC_annotation_font_size, MAGIC_CLASS _wrap_val_GDC_annotation_font_size,0 },
{0}
};
static swig_command_info swig_commands[] = {
{"GD::Chartc::new_note", _wrap_new_note},
{"GD::Chartc::delete_note", _wrap_delete_note},
{"GD::Chartc::note_setnote", _wrap_note_setnote},
{"GD::Chartc::note_col", _wrap_note_col},
{"GD::Chartc::note_point", _wrap_note_point},
{"GD::Chartc::note_font", _wrap_note_font},
{"GD::Chartc::note_tt_font", _wrap_note_tt_font},
{"GD::Chartc::note_tt_font_size", _wrap_note_tt_font_size},
{"GD::Chartc::scatter_s_set", _wrap_scatter_s_set},
{"GD::Chartc::scatter_s_get", _wrap_scatter_s_get},
{"GD::Chartc::scatter_num_set", _wrap_scatter_num_set},
{"GD::Chartc::scatter_num_get", _wrap_scatter_num_get},
{"GD::Chartc::scatter_set_set", _wrap_scatter_set_set},
{"GD::Chartc::scatter_set_get", _wrap_scatter_set_get},
{"GD::Chartc::new_scatter", _wrap_new_scatter},
{"GD::Chartc::delete_scatter", _wrap_delete_scatter},
{"GD::Chartc::scatter_add", _wrap_scatter_add},
{"GD::Chartc::gdchart_w_set", _wrap_gdchart_w_set},
{"GD::Chartc::gdchart_w_get", _wrap_gdchart_w_get},
{"GD::Chartc::gdchart_h_set", _wrap_gdchart_h_set},
{"GD::Chartc::gdchart_h_get", _wrap_gdchart_h_get},
{"GD::Chartc::gdchart_s_set", _wrap_gdchart_s_set},
{"GD::Chartc::gdchart_s_get", _wrap_gdchart_s_get},
{"GD::Chartc::gdchart_p_set", _wrap_gdchart_p_set},
{"GD::Chartc::gdchart_p_get", _wrap_gdchart_p_get},
{"GD::Chartc::gdchart_flags_set", _wrap_gdchart_flags_set},
{"GD::Chartc::gdchart_flags_get", _wrap_gdchart_flags_get},
{"GD::Chartc::gdchart_cols_set", _wrap_gdchart_cols_set},
{"GD::Chartc::gdchart_cols_get", _wrap_gdchart_cols_get},
{"GD::Chartc::gdchart_labels_set", _wrap_gdchart_labels_set},
{"GD::Chartc::gdchart_labels_get", _wrap_gdchart_labels_get},
{"GD::Chartc::gdchart_labels_num_set", _wrap_gdchart_labels_num_set},
{"GD::Chartc::gdchart_labels_num_get", _wrap_gdchart_labels_num_get},
{"GD::Chartc::gdchart_plotcolour_set", _wrap_gdchart_plotcolour_set},
{"GD::Chartc::gdchart_plotcolour_get", _wrap_gdchart_plotcolour_get},
{"GD::Chartc::gdchart_linecolour_set", _wrap_gdchart_linecolour_set},
{"GD::Chartc::gdchart_linecolour_get", _wrap_gdchart_linecolour_get},
{"GD::Chartc::gdchart_angle_3d_set", _wrap_gdchart_angle_3d_set},
{"GD::Chartc::gdchart_angle_3d_get", _wrap_gdchart_angle_3d_get},
{"GD::Chartc::gdchart_depth_3d_set", _wrap_gdchart_depth_3d_set},
{"GD::Chartc::gdchart_depth_3d_get", _wrap_gdchart_depth_3d_get},
{"GD::Chartc::gdchart_title_size_set", _wrap_gdchart_title_size_set},
{"GD::Chartc::gdchart_title_size_get", _wrap_gdchart_title_size_get},
{"GD::Chartc::gdchart_data_set", _wrap_gdchart_data_set},
{"GD::Chartc::gdchart_data_get", _wrap_gdchart_data_get},
{"GD::Chartc::gdchart_vol_set", _wrap_gdchart_vol_set},
{"GD::Chartc::gdchart_vol_get", _wrap_gdchart_vol_get},
{"GD::Chartc::gdchart_output_set", _wrap_gdchart_output_set},
{"GD::Chartc::gdchart_output_get", _wrap_gdchart_output_get},
{"GD::Chartc::gdchart_bgcolour_set", _wrap_gdchart_bgcolour_set},
{"GD::Chartc::gdchart_bgcolour_get", _wrap_gdchart_bgcolour_get},
{"GD::Chartc::gdchart_type_set", _wrap_gdchart_type_set},
{"GD::Chartc::gdchart_type_get", _wrap_gdchart_type_get},
{"GD::Chartc::gdchart_img_get", _wrap_gdchart_img_get},
{"GD::Chartc::new_gdchart", _wrap_new_gdchart},
{"GD::Chartc::delete_gdchart", _wrap_delete_gdchart},
{"GD::Chartc::gdchart_options", _wrap_gdchart_options},
{"GD::Chartc::gdchart_scatter", _wrap_gdchart_scatter},
{"GD::Chartc::gdchart_note", _wrap_gdchart_note},
{"GD::Chartc::gdchart_ytitle", _wrap_gdchart_ytitle},
{"GD::Chartc::gdchart_xtitle", _wrap_gdchart_xtitle},
{"GD::Chartc::gdchart_ytitle2", _wrap_gdchart_ytitle2},
{"GD::Chartc::gdchart_title", _wrap_gdchart_title},
{"GD::Chartc::gdchart_ytitle_size", _wrap_gdchart_ytitle_size},
{"GD::Chartc::gdchart_xtitle_size", _wrap_gdchart_xtitle_size},
{"GD::Chartc::gdchart_yaxisfont_size", _wrap_gdchart_yaxisfont_size},
{"GD::Chartc::gdchart_xaxisfont_size", _wrap_gdchart_xaxisfont_size},
{"GD::Chartc::gdchart_title_tt_font", _wrap_gdchart_title_tt_font},
{"GD::Chartc::gdchart_ytitle_tt_font", _wrap_gdchart_ytitle_tt_font},
{"GD::Chartc::gdchart_xtitle_tt_font", _wrap_gdchart_xtitle_tt_font},
{"GD::Chartc::gdchart_yaxis_tt_font", _wrap_gdchart_yaxis_tt_font},
{"GD::Chartc::gdchart_xaxis_tt_font", _wrap_gdchart_xaxis_tt_font},
{"GD::Chartc::gdchart_title_ptsize", _wrap_gdchart_title_ptsize},
{"GD::Chartc::gdchart_ytitle_ptsize", _wrap_gdchart_ytitle_ptsize},
{"GD::Chartc::gdchart_xtitle_ptsize", _wrap_gdchart_xtitle_ptsize},
{"GD::Chartc::gdchart_yaxis_ptsize", _wrap_gdchart_yaxis_ptsize},
{"GD::Chartc::gdchart_xaxis_ptsize", _wrap_gdchart_xaxis_ptsize},
{"GD::Chartc::gdchart_xaxis_angle", _wrap_gdchart_xaxis_angle},
{"GD::Chartc::gdchart_ylabel_fmt", _wrap_gdchart_ylabel_fmt},
{"GD::Chartc::gdchart_ylabel2_fmt", _wrap_gdchart_ylabel2_fmt},
{"GD::Chartc::gdchart_xlabel_ctl", _wrap_gdchart_xlabel_ctl},
{"GD::Chartc::gdchart_xlabel_spacing", _wrap_gdchart_xlabel_spacing},
{"GD::Chartc::gdchart_ylabel_density", _wrap_gdchart_ylabel_density},
{"GD::Chartc::gdchart_interpolations", _wrap_gdchart_interpolations},
{"GD::Chartc::gdchart_requested_ymin", _wrap_gdchart_requested_ymin},
{"GD::Chartc::gdchart_requested_ymax", _wrap_gdchart_requested_ymax},
{"GD::Chartc::gdchart_requested_yinterval", _wrap_gdchart_requested_yinterval},
{"GD::Chartc::gdchart_shelf", _wrap_gdchart_shelf},
{"GD::Chartc::gdchart_grid", _wrap_gdchart_grid},
{"GD::Chartc::gdchart_ticks", _wrap_gdchart_ticks},
{"GD::Chartc::gdchart_xaxis", _wrap_gdchart_xaxis},
{"GD::Chartc::gdchart_yaxis", _wrap_gdchart_yaxis},
{"GD::Chartc::gdchart_yaxis2", _wrap_gdchart_yaxis2},
{"GD::Chartc::gdchart_yval_style", _wrap_gdchart_yval_style},
{"GD::Chartc::gdchart_stack_type", _wrap_gdchart_stack_type},
{"GD::Chartc::gdchart_bar_width", _wrap_gdchart_bar_width},
{"GD::Chartc::gdchart_hlc_style", _wrap_gdchart_hlc_style},
{"GD::Chartc::gdchart_hlc_cap_width", _wrap_gdchart_hlc_cap_width},
{"GD::Chartc::gdchart_annotation_font_size", _wrap_gdchart_annotation_font_size},
{"GD::Chartc::gdchart_annotation_font", _wrap_gdchart_annotation_font},
{"GD::Chartc::gdchart_annotation_font_ptsize", _wrap_gdchart_annotation_font_ptsize},
{"GD::Chartc::gdchart_num_scatter_pts", _wrap_gdchart_num_scatter_pts},
{"GD::Chartc::gdchart_thumbnail", _wrap_gdchart_thumbnail},
{"GD::Chartc::gdchart_thumblabel", _wrap_gdchart_thumblabel},
{"GD::Chartc::gdchart_thumbval", _wrap_gdchart_thumbval},
{"GD::Chartc::gdchart_border", _wrap_gdchart_border},
{"GD::Chartc::gdchart_linecolor", _wrap_gdchart_linecolor},
{"GD::Chartc::gdchart_plotcolor", _wrap_gdchart_plotcolor},
{"GD::Chartc::gdchart_edgecolor", _wrap_gdchart_edgecolor},
{"GD::Chartc::gdchart_edgecolour", _wrap_gdchart_edgecolour},
{"GD::Chartc::gdchart_other_threshold", _wrap_gdchart_other_threshold},
{"GD::Chartc::gdchart_volcolor", _wrap_gdchart_volcolor},
{"GD::Chartc::gdchart_volcolour", _wrap_gdchart_volcolour},
{"GD::Chartc::gdchart_titlecolor", _wrap_gdchart_titlecolor},
{"GD::Chartc::gdchart_titlecolour", _wrap_gdchart_titlecolour},
{"GD::Chartc::gdchart_xtitlecolor", _wrap_gdchart_xtitlecolor},
{"GD::Chartc::gdchart_xtitlecolour", _wrap_gdchart_xtitlecolour},
{"GD::Chartc::gdchart_ytitlecolor", _wrap_gdchart_ytitlecolor},
{"GD::Chartc::gdchart_ytitlecolour", _wrap_gdchart_ytitlecolour},
{"GD::Chartc::gdchart_ytitle2color", _wrap_gdchart_ytitle2color},
{"GD::Chartc::gdchart_ytitle2colour", _wrap_gdchart_ytitle2colour},
{"GD::Chartc::gdchart_xlabelcolor", _wrap_gdchart_xlabelcolor},
{"GD::Chartc::gdchart_xlabelcolour", _wrap_gdchart_xlabelcolour},
{"GD::Chartc::gdchart_ylabelcolor", _wrap_gdchart_ylabelcolor},
{"GD::Chartc::gdchart_ylabelcolour", _wrap_gdchart_ylabelcolour},
{"GD::Chartc::gdchart_ylabel2color", _wrap_gdchart_ylabel2color},
{"GD::Chartc::gdchart_ylabel2colour", _wrap_gdchart_ylabel2colour},
{"GD::Chartc::gdchart_extvolcolor", _wrap_gdchart_extvolcolor},
{"GD::Chartc::gdchart_extvolcolour", _wrap_gdchart_extvolcolour},
{"GD::Chartc::gdchart_setcolor", _wrap_gdchart_setcolor},
{"GD::Chartc::gdchart_setcolour", _wrap_gdchart_setcolour},
{"GD::Chartc::gdchart_color", _wrap_gdchart_color},
{"GD::Chartc::gdchart_colors", _wrap_gdchart_colors},
{"GD::Chartc::gdchart_colour", _wrap_gdchart_colour},
{"GD::Chartc::gdchart_colours", _wrap_gdchart_colours},
{"GD::Chartc::gdchart_extcolor", _wrap_gdchart_extcolor},
{"GD::Chartc::gdchart_extcolour", _wrap_gdchart_extcolour},
{"GD::Chartc::gdchart_transparent_bg", _wrap_gdchart_transparent_bg},
{"GD::Chartc::gdchart_bgimage", _wrap_gdchart_bgimage},
{"GD::Chartc::gdchart_label_size", _wrap_gdchart_label_size},
{"GD::Chartc::gdchart_label_font", _wrap_gdchart_label_font},
{"GD::Chartc::gdchart_label_font_ptsize", _wrap_gdchart_label_font_ptsize},
{"GD::Chartc::gdchart_label_dist", _wrap_gdchart_label_dist},
{"GD::Chartc::gdchart_label_line", _wrap_gdchart_label_line},
{"GD::Chartc::gdchart_explode", _wrap_gdchart_explode},
{"GD::Chartc::gdchart_missing", _wrap_gdchart_missing},
{"GD::Chartc::gdchart_percent_labels", _wrap_gdchart_percent_labels},
{"GD::Chartc::gdchart_percent_fmt", _wrap_gdchart_percent_fmt},
{"GD::Chartc::gdchart_height", _wrap_gdchart_height},
{"GD::Chartc::gdchart_width", _wrap_gdchart_width},
{"GD::Chartc::gdchart_chart_type", _wrap_gdchart_chart_type},
{"GD::Chartc::gdchart_pie_type", _wrap_gdchart_pie_type},
{"GD::Chartc::gdchart_imgtype", _wrap_gdchart_imgtype},
{"GD::Chartc::gdchart_sets", _wrap_gdchart_sets},
{"GD::Chartc::gdchart_points", _wrap_gdchart_points},
{"GD::Chartc::gdchart_bgcolor", _wrap_gdchart_bgcolor},
{"GD::Chartc::gdchart_fd", _wrap_gdchart_fd},
{"GD::Chartc::gdchart_filename", _wrap_gdchart_filename},
{"GD::Chartc::gdchart_draw", _wrap_gdchart_draw},
{"GD::Chartc::gdchart_img_chart_set", _wrap_gdchart_img_chart_set},
{"GD::Chartc::gdchart_img_chart_get", _wrap_gdchart_img_chart_get},
{"GD::Chartc::gdchart_img_pie_set", _wrap_gdchart_img_pie_set},
{"GD::Chartc::gdchart_img_pie_get", _wrap_gdchart_img_pie_get},
{"GD::Chartc::new_gdchart_img", _wrap_new_gdchart_img},
{"GD::Chartc::delete_gdchart_img", _wrap_delete_gdchart_img},
{"GD::Chartc::GDC_out_graph", _wrap_GDC_out_graph},
{"GD::Chartc::GDC_destroy_image", _wrap_GDC_destroy_image},
{"GD::Chartc::out_err", _wrap_out_err},
{0,0}
};

#ifdef __cplusplus
extern "C"
#endif

XS(SWIG_init) {
    dXSARGS;
    int i;
    static int _init = 0;
    if (!_init) {
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }	
        _init = 1;
    }
    
    /* Install commands */
    for (i = 0; swig_commands[i].name; i++) {
        newXS((char*) swig_commands[i].name,swig_commands[i].wrapper, (char*)__FILE__);
    }
    
    /* Install variables */
    for (i = 0; swig_variables[i].name; i++) {
        SV *sv;
        sv = perl_get_sv((char*) swig_variables[i].name, TRUE | 0x2);
        if (swig_variables[i].type) {
            SWIG_MakePtr(sv,(void *)1, *swig_variables[i].type,0);
        } else {
            sv_setiv(sv,(IV) 0);
        }
        swig_create_magic(sv, (char *) swig_variables[i].name, swig_variables[i].set, swig_variables[i].get); 
    }
    
    /* Install constant */
    for (i = 0; swig_constants[i].type; i++) {
        SV *sv;
        sv = perl_get_sv((char*)swig_constants[i].name, TRUE | 0x2);
        switch(swig_constants[i].type) {
            case SWIG_INT:
            sv_setiv(sv, (IV) swig_constants[i].lvalue);
            break;
            case SWIG_FLOAT:
            sv_setnv(sv, (double) swig_constants[i].dvalue);
            break;
            case SWIG_STRING:
            sv_setpv(sv, (char *) swig_constants[i].pvalue);
            break;
            case SWIG_POINTER:
            SWIG_MakePtr(sv, swig_constants[i].pvalue, *(swig_constants[i].ptype),0);
            break;
            case SWIG_BINARY:
            SWIG_MakePackedObj(sv, swig_constants[i].pvalue, swig_constants[i].lvalue, *(swig_constants[i].ptype));
            break;
            default:
            break;
        }
        SvREADONLY_on(sv);
    }
    
    SWIG_TypeClientData(SWIGTYPE_p_note, (void*) "GD::Chart::note");
    SWIG_TypeClientData(SWIGTYPE_p_scatter, (void*) "GD::Chart::scatter");
    SWIG_TypeClientData(SWIGTYPE_p_gdchart, (void*) "GD::Chart::gdchart");
    SWIG_TypeClientData(SWIGTYPE_p_gdchart_img, (void*) "GD::Chart::gdchart_img");
    ST(0) = &PL_sv_yes;
    XSRETURN(1);
}

