% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqpac_S4classes.R
\name{as.PAC}
\alias{as.PAC}
\title{Converts an S3 PAC into a S4 PAC}
\usage{
as.PAC(from)
}
\arguments{
\item{from}{S3 PAC-object containing at least a Pheno table with samples as
row names, Anno table with sequences as row names and a Count table with
raw counts (columns=samples, rows=sequences).}
}
\value{
An S4 PAC object.
}
\description{
\code{as.PAC} Converts an S3 PAC object (list) to an S4 PAC object
}
\details{
Seqpac comes with two versions of the PAC object, either S4 or S3. The S3 PAC
is simply a list where each object can be received using the $-sign. The S4
version is a newer type of R object with predefined slots, that is received
using the @-sign. This function converts an S3 PAC object (list) to an S4 PAC
object. You can also use the S4 coercion method "as" to turn an S4 PAC into
an S3. See examples below.
}
\examples{
load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))
                  
# check type
class(pac)
isS4(pac)
 
 
# Turns S4 PAC object into a S3
pac_s3 <- as(pac, "list")

# Turns S3 PAC object into a S4
pac_s4 <- as.PAC(pac_s3)


}
\seealso{
\url{https://github.com/Danis102} for updates on the current
  package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filter}()},
\code{\link{PAC_filtsep}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_jitter}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_norm}()},
\code{\link{PAC_pca}()},
\code{\link{PAC_pie}()},
\code{\link{PAC_saturation}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_stackbar}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()},
\code{\link{tRNA_class}()}
}
\concept{PAC analysis}
