test_that("Multienricher gsea gives same results as running packets separately", {

  set_genes <-  c("104099", "104110", "104111", "109700", "110891", "110893", 
"11461", "11464", "11465", "11512", "11513", "11514", "11515", 
"11554", "11606", "11937", "11938", "12288", "12289", "12292")

  universe <- c("26396", "271844", "16402", "16419", "16370", "110074", "11461", 
"23797", "16157", "71932", "11637", "667277", "258277", "17392", 
"11740", "11771", "18459", "71908", "13867", "12043", "22325", 
"26408", "13869", "99371", "15461", "321021", "14681", "394436", 
"109880", "19094", "67653", "23961", "19179", "328572", "64337", 
"13195", "16476", "14682", "22335", "18747", "240028", "29857", 
"12330", "258404", "16524", "81897", "319173", "26413", "19047", 
"252870", "17710", "14257", "26416", "12550", "104111", "387211", 
"20662", "16160", "14706", "18710", "227231", "51792", "258185", 
"26399", "16476", "51810", "11432", "14377", "12322", "13043", 
"76947", "18747", "13198", "15040", "258470", "103988", "20638", 
"18033", "14800", "66724", "20750", "110323", "53332", "22147", 
"20847", "17709", "15978", "258464", "20511", "637776", "19188", 
"13983", "18176", "15015", "26395", "15251", "14404", "13197", 
"613123", "230558", "258595", "20662", "20360", "68401", "19159", 
"12317", "17716", "12534", "142980", "12322", "20466", "72900", 
"11798", "29857", "22417", "12778", "13857", "18710", "116903", 
"14678", "60505", "16542", "16797", "16136", "102465198", "102098", 
"319734", "225326", "11931", "100041688", "212398", "26878", 
"74205", "11450", "100039830", "244058", "67819", "12985", "74256", 
"242517", "667250", "72930", "20148", "230398", "16449", "15200", 
"14869", "230718", "11957", "22353", "16168", "22423", "245026", 
"12487", "26414", "56012", "20416", "27371", "14175", "12445", 
"66945", "68563", "21808", "216148", "53859", "14960", "17389", 
"15234", "19082", "110157", "723963", "13033", "14174", "18710", 
"12167", "269951", "19057", "404335", "223827", "19056", "15200", 
"26441", "212032", "64654", "23957", "20541", "20677", "100727", 
"79235", "14812", "19139", "14182", "216238", "12314", "15051", 
"14827", "18795", "17535", "27409", "12367", "16534", "18781", 
"17927", "18102", "385328", "16480", "16439", "19730", "20310", 
"105980076", "68776", "641340", "71609", "58988", "16653", "12125", 
"14219", "243996", "258608", "18176", "12703", "20463", "67653", 
"14997", "17311", "15968", "74481", "74769", "26420", "72674", 
"65246", "11651", "625018", "12660", "331374", "100756", "20312", 
"112415", "23797", "74412", "74180", "14164", "18749", "241452", 
"16194", "13643", "21812", "52187", "70767", "394435", "16897", 
"216453", "110558", "14131", "18627", "14708", "14864", "14869", 
"12334", "74094", "18708", "20339", "12443", "208727", "67073", 
"21956", "76522", "18717", "12313", "13712", "15926", "102436", 
"16440", "112417", "100861474", "19211", "75483", "16773", "17745", 
"15429", "15275", "110877", "232807", "100041273", "239845", 
"235674", "12445", "99571", "26395", "328845", "317677", "69961", 
"16337", "19303", "56378", "19059", "28080", "100042295", "22171", 
"14688", "109828", "71745", "12443", "17246", "387247", "18596", 
"71770", "26427", "12443", "16163", "19058", "110355", "57296", 
"14960", "50721", "22142", "13088", "12796", "54123", "69080", 
"66454", "269966", "22035", "12675", "12144", "19106", "58194", 
"74729", "53313", "56438", "13039", "234852", "15969", "259162", 
"15564", "72094", "71679", "17706", "14775", "224129", "404336", 
"11652", "54393", "20683", "22143", "19883", "72094", "26413", 
"14751", "14800", "16176", "19766", "17705", "52466", "20441", 
"16774", "15894", "11688", "241656", "13430", "26363", "224129", 
"18606", "29857", "12443", "15107", "170442", "14683", "242705", 
"74343", "19045", "14417", "16415", "67443", "21894", "108760", 
"14120", "258495", "16401", "74205", "12566", "66694", "15108", 
"22238", "14980", "18189", "17319", "13101", "12322", "100040233", 
"104625", "13067", "67184", "18607", "210044", "78134", "394430", 
"14366", "64436", "14811")

  all_genes <- unique(c(set_genes, universe))

  ranked_genes <- rev(seq_along(all_genes))

  ranked_genes <- c(rnorm(length(set_genes), 5, 3), rnorm(length(all_genes)-length(set_genes), 0, 2))
  ranked_genes <- sort(ranked_genes, decreasing=TRUE)

  names(ranked_genes) <- all_genes
  genes <- ranked_genes

  library("org.Mm.eg.db")

  packet_res_GO <- clusterProfiler::gseGO(geneList=genes, 
    OrgDb= org.Mm.eg.db, ont = "MF",
    pvalueCutoff  = 0.05, scoreType="pos", seed=TRUE)

  packet_res_reactome <- ReactomePA::gsePathway(geneList=genes, 
    organism      = "mouse",
    pvalueCutoff  = 0.05,
    pAdjustMethod = "BH",
    scoreType = "pos",
    seed=TRUE)

  organisms_table <- get_organism_table()
  current_organism_info <- subset(organisms_table, 
                          rownames(organisms_table) == "Mouse")

  new_res_all <- ExpHunterSuite::multienricher_gsea(all_funsys=c("MF", "Reactome"),
    genes_list=list(genes,genes), 
    organism_info = current_organism_info,
    kegg_file=kegg_file_mouse,
    pvalueCutoff = 0.05, scoreType="pos", seed=TRUE
  )

  testthat::expect_identical(object=packet_res_GO, expected=new_res_all[["MF"]][[1]])
})
