% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_report.R
\name{write_functional_report}
\alias{write_functional_report}
\title{Write Main DEgenes Hunter functional report
This function allows you to report the Functional analysis.}
\usage{
write_functional_report(
  hunter_results,
  func_results,
  output_files = getwd(),
  fc_colname = "mean_logFCs",
  organisms_table = NULL,
  template_folder = file.path(find.package("ExpHunterSuite"), "templates"),
  cores = 2,
  task_size = 1,
  report = "fc",
  showCategories = 30,
  group_results = FALSE,
  max_genes = 200,
  corr_threshold = 0.8,
  pvalcutoff = 0.05
)
}
\arguments{
\item{hunter_results}{DEG analysis results}

\item{func_results}{functional results}

\item{output_files}{output folder.}

\item{fc_colname}{(OPTIONAL) main logFC colname (into hunter_results
dataframe)}

\item{organisms_table}{(OPTIONAL) configuration table for given organism.
Use see get_organism_table()}

\item{template_folder}{(OPTIONAL) RMD templates folder}

\item{cores}{(OPTIONAL) cores for parallel features}

\item{task_size}{number of elements per packages used}

\item{report}{string with reports to be written. Allowed: clusters (c)}

\item{showCategories}{number of categories in the figures (per cluster)}

\item{group_results}{experimental - whether to group results in the emap plot
and functional (f). Default = "fc"}

\item{max_genes}{maximum number of genes to plot in cnet plot}

\item{corr_threshold}{minimun module eigengene-trait vector absolute Pearson R value}

\item{pvalcutoff}{maximum module eigengene-trait vector correlation P value}
}
\value{
void
}
\description{
Write Main DEgenes Hunter functional report
This function allows you to report the Functional analysis.
}
\examples{
# Load func and DE results
data(degh_output)
func_results <- list() 
func_results <- main_functional_hunter(degh_output, "Mouse")
write_functional_report(degh_output, func_results)
}
