% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_analysis_library.R
\name{multienricher_ora}
\alias{multienricher_ora}
\title{Perform ORA enrichment analysis of a list of genes}
\usage{
multienricher_ora(
  all_funsys = NULL,
  genes_list,
  universe = NULL,
  organism_info,
  org_db = NULL,
  task_size = 1,
  workers = 1,
  pvalueCutoff = 0.05,
  qvalueCutoff = 0.2,
  pAdjustMethod = "BH",
  kegg_file = NULL,
  custom_sets = NULL,
  readable = TRUE,
  return_all = FALSE,
  ...
)
}
\arguments{
\item{all_funsys}{vector of funsys to use (e.g. MF, Reatcome)}

\item{genes_list}{vector of genes or list of vectors, to be enriched}

\item{universe}{background of genes to use as universe}

\item{organism_info}{from the annotation table: infor on db names etc}

\item{org_db}{org db file (optional) - normally obtained from organism_info}

\item{task_size}{for parallelization}

\item{workers}{for parallelization}

\item{pvalueCutoff}{p-value finding enriched categories}

\item{qvalueCutoff}{q-value finding enriched categories}

\item{pAdjustMethod}{adjustment method for p-values}

\item{kegg_file}{must be provided if kegg annotation required}

\item{custom_sets}{custom set object (processed by load_and_parse_gmt)}

\item{readable}{Whether output should include gene symbols}

\item{return_all}{Whether to remove list items with no enrichment}

\item{...}{other arguments passed to the enrichment function}
}
\description{
Perform ORA enrichment analysis of a list of genes
}
