% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/down2quan.R
\name{down2quan}
\alias{down2quan}
\title{Download the RNA-seq samples from the NCBI and produce the quantifications of gene expression.}
\usage{
down2quan(
  accession,
  dir = getwd(),
  taxa,
  novel_transcript = FALSE,
  threads = 4,
  scRNA = FALSE,
  protocol
)
}
\arguments{
\item{accession}{the bioproject accession code for the RNA-seq samples deposited in the NCBI.}

\item{dir}{the working directory. Default is the current working directory.}

\item{taxa}{the scientific or common name of the organism.}

\item{novel_transcript}{logic, whether identifying novel transcripts is expected or not. Default is FALSE.}

\item{threads}{the number of threads to be used. Default is 4.}

\item{scRNA}{logic, whether single-cell RNA-seq is quantified or not. Default is FALSE.}

\item{protocol}{the single-cell RNA sequencing protocol: dropseq, chromium, or chromiumV3.}
}
\value{
None
}
\description{
Download the RNA-seq samples from the NCBI and produce the quantifications of gene expression with alignment-based and alignment-free workflows.
}
\examples{

down2quan(
accession = 'SRR11427582', dir = getwd(), 
taxa = 'Drosophila melanogaster', novel_transcript = FALSE, scRNA = FALSE
)

}
