% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeCel.R
\name{normalizeCel}
\alias{normalizeCel}
\title{Normalize CEL Files}
\usage{
normalizeCel(chiptype_list, batchsize = 300, rerun = TRUE)
}
\arguments{
\item{chiptype_list}{list, storing CEL files in each chiptype}

\item{batchsize}{number of CEL files to import and to normalize at once}

\item{rerun}{TRUE or FALSE, whether to run the function}
}
\value{
Files storing normalized expression values in matrix, here one matrix file 
per chip type
}
\description{
Function processes the CEL files from each chip type (three for CMap2 data)
separately using the MAS5 normalization algorithm. The results will be written
to subdirectores (under a data parent directory) that are named after the chip
type names. To reduce the memory consumption of this step, the CEL files are
processed in user definable batch sizes. For details on the overall workflow,
please consult the vignette of this package. The normalization takes about 10
hours without parallelization. To save time, this process can be easily
accelerated on a computer cluster.
}
\examples{
# chiptype_list <- split(names(chiptype), as.character(chiptype))
normalizeCel(chiptype_list, rerun=FALSE)
}
