% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hematopoiesis.R
\name{hematopoiesis}
\alias{hematopoiesis}
\title{scATAC-seq and unpaired scRNA-seq of hematopoetic cells}
\format{
\code{MultiAssayExperiment} obtained from an \code{ArchR} project.
Annotated with the hg19 genome build.
Contains the following experiments:
\itemize{
\item{\strong{GeneIntegrationMatrix}: SingleCellExperiment with 17889 rows and 10250 columns}
\item{\strong{GeneScoreMatrix}: SingleCellExperiment with 22217 rows and 10250 columns}
\item{\strong{PeakMatrix}: SingleCellExperiment with 150046 rows and 10250 columns}
\item{\strong{TileMatrix500}: SingleCellExperiment with 5762078 rows and 10250 columns}
}
}
\usage{
hematopoiesis(
  metadata = FALSE,
  experiments = c("TileMatrix500", "GeneScoreMatrix", "GeneIntegrationMatrix",
    "PeakMatrix")
)
}
\arguments{
\item{metadata}{logical flag specifying whether to return data or metadata only}

\item{experiments}{character vector of matrices to return; see \code{Format}}
}
\value{
\code{MultiAssayExperiment} made up of \code{SingleCellExperiment}s
with assays stored as \code{DelayedMatrix} objects.
If \code{metadata = TRUE}, an \code{ExperimentHub} object listing this data set's metadata.
}
\description{
Example scATAC-seq data of hematopoietic cells included in ArchR package was integrated with scRNAseq. ScATAC-seq data was obtained from GSE139369 and scRNA-seq obtained from https://jeffgranja.s3.amazonaws.com/ArchR/TestData/scRNA-Hematopoiesis-Granja-2019.rds
}
\section{Data preparation}{


Example scATAC-seq data of hematopoietic cells included in ArchR package was integrated with scRNA-seq. ScATAC-seq data was obtained from GSE139369 and scRNA-seq data was obtained from https://jeffgranja.s3.amazonaws.com/ArchR/TestData/scRNA-Hematopoiesis-Granja-2019.rds"
}

\section{Data storage and access}{

The \code{MultiAssayExperiments} is split into separate \code{SingleCellExperiment}
objects and they in turn are split into components, all of which are stored in a
single hdf5 file. Data and can be accessed with a special function that extracts
elements of the requested experiment(s), reassembles them, and builds an MAE.
}

\examples{
# check metada of dataset
hematopoiesis(metadata = TRUE)
# download data
\dontrun{
hematopoiesis()
}
}
\references{
Single-cell multiomic analysis identifies regulatory programs in mixed-phenotype acute leukemia
associated with prostate cancer relapse.
Granja \emph{et al.}, \emph{Nature Biotechnology} 2019 Dec;37(12):1458-1465.
\href{https://www.nature.com/articles/s41587-019-0332-7}{doi: 10.1038/s41587-019-0332-7}
}
