## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(scATAC.Explorer)

## -----------------------------------------------------------------------------
res = queryATAC(metadata_only = TRUE)

## ----echo=FALSE---------------------------------------------------------------
knitr::kable(head(res[[1]][,1:5]))

## -----------------------------------------------------------------------------
res = queryATAC(disease = 'leukemia', metadata_only = TRUE)[[1]]

## ----echo=FALSE---------------------------------------------------------------
knitr::kable(head(res[,1:5]))

## -----------------------------------------------------------------------------
res = queryATAC(accession = "GSE89362")

## ----eval=FALSE---------------------------------------------------------------
# View(counts(res[[1]]))

## ----echo=FALSE---------------------------------------------------------------
knitr::kable(data.frame(as.matrix(counts(res[[1]][1:10,1:8]))))

## -----------------------------------------------------------------------------
metadata(res[[1]])$pmid

## ----eval=FALSE---------------------------------------------------------------
# res = queryATAC(has_cell_type = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# View(colData(res[[1]]))

## ----echo=FALSE---------------------------------------------------------------
knitr::kable(head(colData(res[[1]])))

## ----eval=FALSE---------------------------------------------------------------
# res = queryATAC(accession = "GSE89362")[[1]]
# saveATAC(res, '~/Downloads/GSE89362')

## -----------------------------------------------------------------------------
sessionInfo()

