% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raerdata.R
\name{pbmc_10x}
\alias{pbmc_10x}
\title{single cell RNA sequencing data from human PBMCs}
\usage{
pbmc_10x()
}
\value{
A list containing:
\itemize{
\item \code{bam} a \link{BamFile} object indicating the BAM and BAI file paths.
Contains alignments from only chr16 (hg38).
\item \code{sites} a GRanges object containing known RNA editing sites from
the REDIportal database (hg38).
\item \code{sce} a \link{SingleCellExperiment} object containing gene expression
data, a UMAP projection and cell type annotations.
}
}
\description{
A 10x Genomics 3' single cell RNA-seq library from 10k PBMCs. The BAM file
contains alignments from chr16. A \link{SingleCellExperiment} is also provided
with pre-processed gene expression data, a UMAP projection and cell type
annotations.
}
\details{
\code{pbmc_10x()} will download a BAM, BAM index file, REDIportal RNA editing
sites, and a SingleCellExperiment object from the \link{ExperimentHub}.
}
\examples{
pbmc_10x()

}
\seealso{
\url{https://www.10xgenomics.com/resources/datasets/10k-human-pbmcs-3-v3-1-chromium-x-with-intronic-reads-3-1-high}
}
