% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readEH.R
\name{readEH}
\alias{readEH}
\title{A wrapper function for efficiently reading in user-specified random forest
models generated by \code{preciseTAD::TADrandomForest}, built on cell-line
specific CTCF, RAD21, SMC3, and ZNF143 ChIP-seq peak regions.}
\usage{
readEH(chr, cl, gt, source)
}
\arguments{
\item{chr}{Which chromosome was used as the holdout during the training
process. That is, all other chromosomes were combined when building the
random forest.}

\item{cl}{The cell line that was used (either "GM12878" or "K562")}

\item{gt}{The ground-truth TAD or chromatin loop boundaries used to construct
the binary response vector (either "Arrowhead" or "Peakachu".}

\item{source}{The source of the files stored on ExperimentHub using
query(hub, "package_name").}
}
\value{
A trained model object from \code{caret}
}
\description{
A wrapper function for efficiently reading in user-specified random forest
models generated by \code{preciseTAD::TADrandomForest}, built on cell-line
specific CTCF, RAD21, SMC3, and ZNF143 ChIP-seq peak regions.
}
\examples{
# Suppose we want to read in the model that was built using CHR1-CHR21,
# on GM12878, using Arrowhead defined TAD boundaries at 5kb resolution.

#Initialize ExperimentHub
library(ExperimentHub)
hub <- ExperimentHub()
query(hub, "preciseTADhub")
myfiles <- query(hub, "preciseTADhub")

CHR22_GM12878_5kb_Arrowhead <- readEH(chr = "CHR22",
                                      cl = "GM12878",
                                      gt = "Arrowhead",
                                      source = myfiles)
}
