% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessMSigDB.R
\name{getMsigdbIDF}
\alias{getMsigdbIDF}
\title{Retrieve MSigDB data hosted on the hub}
\usage{
getMsigdbIDF(org = c("hs", "mm"), version = getMsigdbVersions())
}
\arguments{
\item{org}{a character, representing the organism whose signature database
needs to be retrieved ("hs" for human and "mm" for mouse).}

\item{version}{a character, stating the version of MSigDB to be retrieved
(should be >= 7.2). See \code{getMsigdbVersions()}.}
}
\value{
a list of named numeric vectors, containing inverse document frequency (IDF) weights. Names represent terms that the IDF is computed for. IDFs are computed using gene-set names ("Name") and short descriptions ("Short").
}
\description{
Download molecular signatures database (MSigDB) hosted on the ExperimentHub
or retrieve pre-downloaded version from cache. This package currently hosts
versions greater than 7.2 for human and mouse with both symbol and Entrez
identifiers.
}
\examples{
gsc = getMsigdbIDF("hs")

}
