% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addKEGG.R
\name{getMsigIdType}
\alias{getMsigIdType}
\title{Infer gene identifier type for the gene set collection}
\usage{
getMsigIdType(gsc)
}
\arguments{
\item{gsc}{a GeneSetCollection object, containing MSigDB genesets in the form
of GeneSet objects.}
}
\value{
a GSEABase::SymbolIdentifier or GSEABASE::EntrezIdentifier object,
specifying the gene identifier type (gene symbols or Entrez IDs
respectively).
}
\description{
The gene identifier (Symbol or Entrez ID) of a gene set collection is
inferred from the IDs present in the data. A collection should ideally store
gene sets using a single identifier type. This function returns the
identifier type (either SymbolIdentifier or EntrezIdentifier) of the
collection. It returns an error if the identifier is neither of these.
}
\examples{
gsc <- getMsigdb()
id <- getMsigIdType(gsc)

}
