#' Obtain the Song quality assurance dataset
#'
#' Obtain the microbiome data from Song et al. (2016).
#'
#' @details
#' The SongQA dataset contains microbiome data from a study comparing different
#' sample preparation methods focusing on temperature and DNA extraction methods
#' mainly.
#'
#' The dataset was generated by sequencing the variable region 4 of 16S rRNA
#' genes via Illumina HiSeq or MiSeq. 
#'
#' Column metadata was reconstructed from sample names and includes information
#' on the source, timepoint, extraction method, temperature conditions and 
#' other optional data.
#'
#' Row metadata contains taxonomic information on the Phylum, Family and Genus
#' level.
#'
#' All data are downloaded from ExperimentHub and cached for local re-use.
#'
#' @return a \linkS4class{TreeSummarizedExperiment}
#'
#' @author Felix G.M. Ernst
#'
#' @references
#' Preservation Methods Differ in Fecal Microbiome Stability, Affecting 
#' Suitability for Field Studies. Se Jin Song, Amnon Amir, Jessica L. Metcalf, 
#' Katherine R. Amato, Zhenjiang Zech Xu, Greg Humphrey, Rob Knight.
#' mSystems May 2016, 1 (3) e00021-16; DOI: 10.1128/mSystems.00021-16
#' 
#' @source 
#' https://qiita.ucsd.edu/study/description/10394
#'
#' @name SongQAData
#' @export
#'
#' @examples
#' tse <- SongQAData()
SongQAData <- function() {
    dataset <- "3.13/song-qa"
    tse <- .create_tse(dataset,
                    assays = c("counts"),
                    has.rowdata = TRUE,
                    has.coldata = TRUE,
                    has.rowtree = TRUE)
    tse
}

#' @rdname SongQAData
#' @export
qa10934 <- SongQAData
