### =======================
###  methylclock metadata
### =======================

meta <- data.frame(
   Title = c( "Datasets to estimate cell counts for EEAA method",
              "CpGs BNN clock",
              "Coefficients Bohlin's clock",
              "Coefficients Hannum's clock",
              "Coefficients Hobarth's clock",
              "Coefficients Knight's clock",
              "Coefficients Lee's clock",
              "Coefficients Levine clock",
              "Coefficients Mayne's clock",
              "Coefficients PedBE clock",
              "Coefficients Horvath’s skin+blood clock",
              "Coefficients Telomere Length’s clock",
              "Coefficients Wu's clock",
              "Methylation Data Example",
              "probe Annotation 21k",
              "Test Dataset",
              "References",
              "Coefficients Best Linear Unbiased Prediction (BLUP) clock",
              "Coefficients Elastic Net (EN) clock",
              "Coefficients EPIC clock" ) ,
   Description = c( paste0("Predefined datasets included in this package are ",
                           "andrews and bakulski cord blood, ",
                           "blood gse35069, ",
                           "blood gse35069 chen, ",
                           "blood gse35069 complete, ",
                           "combined cord blood, ",
                           "cord blood gse68456, ",
                           "gervin and lyle cord blood, ",
                           "guintivano dlpfc and ",
                           "saliva gse48472 "),
                    paste0("Horvath’s CpGs to train a Bayesian Neural Network (BNN)",
                           "Alfonso and Gonzalez (2020)"),
                    "96 CpGs described in Bohlin et al. (2016)",
                    "71 CpGs described in Hannum et al. (2013)",
                    "353 CpGs described in Horvath (2013)",
                    "148 CpGs described in Knight et al. (2016)",
                    paste0("Three different biological clocks described",
                           " in Lee et al. (2019) : RPC clock, CPC clock,",
                           " Refined RPC clock"),
                    paste0("Also know as PhenoAge: 513 CpGs described",
                           "in Levine et al. (2018)"),
                    "62 CpGs described in Mayne et al. (2017)",
                    "84 CpGs described in McEwen et al. (2019).",
                    "391 CpGs described in Horvath et al. (2018)",
                    "140 CpGs described in Lu et al. (2019)",
                    "111 CpGs described in Wu et al. (2019)",
                    "Methylation data example",
                    "probe Annotation 21k",
                    "Test dataset",
                    "References",
                    "319607 CpGs described in Zhang et al. (2019)",
                    "514 CpGs described in Zhang et al. (2019)",
                    "176 CpGs described in Haftorn et al. (2021)"
                   ) ,
   BiocVersion = c( rep("3.15", 20)) ,
   Genome = c(rep("hg19",20)) ,
   SourceType = c(rep("RDA",20) ) ,
   SourceUrl =  "https://github.com/isglobal-brge/methylclock/blob/master/data",
   SourceVersion = c("June 2020", rep( "May 2021", 16), rep( "March 2022", 3)) ,
   Species = "Homo sapiens" ,
   TaxonomyId = 9606 ,
   Coordinate_1_based = FALSE ,
   DataProvider = NA ,
   Maintainer = "Juan R Gonzalez <juanr.gonzalez@isglobal.org>" ,
   RDataClass = c("List", "character", rep("data.frame",13), "Lists", rep("data.frame",4)  ) ,
   RDataPath = c( 'methylclockData/v2022_04/methylclock_references.rda',
                  'methylclockData/v2022_04/cpgs.bn.rda',
                  'methylclockData/v2022_04/coefBohlin.rda',
                  'methylclockData/v2022_04/coefHannum.rda',
                  'methylclockData/v2022_04/coefHorvath.rda',
                  'methylclockData/v2022_04/coefKnightGA.rda',
                  'methylclockData/v2022_04/coefLeeGA.rda',
                  'methylclockData/v2022_04/coefLevine.rda',
                  'methylclockData/v2022_04/coefMayneGA.rda',
                  'methylclockData/v2022_04/coefPedBE.rda',
                  'methylclockData/v2022_04/coefSkin.rda',
                  'methylclockData/v2022_04/coefTL.rda',
                  'methylclockData/v2022_04/coefWu.rda',
                  'methylclockData/v2022_04/MethylationDataExample55.rda',
                  'methylclockData/v2022_04/probeAnnotation21kdatMethUsed.rda',
                  'methylclockData/v2022_04/TestDataset.rda',
                  'methylclockData/v2022_04/references.rda',
                  'methylclockData/v2022_04/coefBlup.rda',
                  'methylclockData/v2022_04/coefEN.rda',
                  'methylclockData/v2022_04/coefEPIC.rda'
                 ) ,
   DispatchClass = c(rep("Rda", 20) ) ,
   Tags = "",
   Notes = ""
)

write.csv(meta, file="inst/extdata/metadata_v2022_04.csv", row.names=FALSE)
