% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildAll.R
\name{writeOutSEZip}
\alias{writeOutSEZip}
\title{writeOutSEZip writes out a SummarizedExperiment into a zip file}
\usage{
writeOutSEZip(
  the_summarized_experiment,
  filename_base = "SE_out",
  filename_ext = ".csv",
  filenames = list(metadata = paste(filename_base, "_metadata", filename_ext, sep = ""),
    assay_counts = paste(filename_base, "_assay_counts", filename_ext, sep = ""),
    assay_calls = paste(filename_base, "_assay_calls", filename_ext, sep = ""), colData =
    paste(filename_base, "_colData", filename_ext, sep = ""), rowData =
    paste(filename_base, "_rowData", filename_ext, sep = "")),
  zip_name = paste(filename_base, ".zip", sep = "")
)
}
\arguments{
\item{the_summarized_experiment}{A SummarizedExperiment}

\item{filename_base}{The default base name to use for each of the generated files within the zip file}

\item{filename_ext}{The default extension to use for each of the generated files within the zip file}

\item{filenames}{A tagged list of filenames for the files inside the zip file: `metadata`, `assay_counts`, `assay_calls`, `colData`, `rowData`.}

\item{zip_name}{The name of the generated zip file.}
}
\value{
The status value returned by the external command invoked to create the zip file, invisibly.
}
\description{
This function writes out a SummarizedExperiment into a group of zipped csvs, with a manifest.csv
It is designed for use in persisting the SummarizedExperiments generated by this data package, for upload
to ExperimentHub, so it is not built robustly.
}
\examples{
# First, we download a few accessions of interest into a SummarizedExperiment
accessions_of_interest <- buildData(
  accessions=as.list(unique(cols$SRR_accession)[c(1,3)]), write_files=FALSE,
  build_raw=TRUE, build_deseq2=FALSE, build_tsne=FALSE, build_rank=FALSE,
  generate_qc_pass=FALSE)$qc_warn_raw
# Then we write them out to a zip file for later
writeOutSEZip(accessions_of_interest, filename_base="InterestingAccessionsForLater")
}
