% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildAll.R
\name{srx_agg_se}
\alias{srx_agg_se}
\title{srx_agg_se is a version of srx_agg that works on SummarizedExperiments}
\usage{
srx_agg_se(x, counts = "GeneCounts")
}
\arguments{
\item{x}{A SummarizedExperiment.}

\item{counts}{What kind of count; "GeneCounts" for STAR based gene counts, "TxCounts" for kallisto transcript level counts or "Tx2Gene" for transcript counts aggregated to gene level. Default is "GeneCounts"}
}
\value{
A SummarizedExperiment object, with runs representing the same SRA experiment aggregated, and with coldata grouped by SRA experiment.
}
\description{
This function aggregates runs that represent the same SRA experiment, and reorganises
the coldata in the SummarizedExperiment to to be grouped by SRA experiment in order to
preserve necessary SummarizedExperiment internal invariants.
}
\examples{
# This is a small SummarizedExperiment containing some un-aggregated data
small_data <- readInSEZip(
  system.file("ASmallSummarizedExperiment.zip", package="homosapienDEE2CellScore"))
# We can aggregate it like so:
aggregated_small_data <- srx_agg_se(small_data)
}
