## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----install bioconductor, eval = FALSE---------------------------------------
# if (!requireNamespace("BiocManager", quietly=TRUE))
#     install.packages("BiocManager")
# BiocManager::install()

## ----install packages from bioconductor, eval = FALSE-------------------------
# BiocManager::install(c("CellScore", "homosapienDEE2CellScore", "devtools", "getDEE2", "SummarizedExperiment"))

## ----setup--------------------------------------------------------------------
library(DESeq2)
library(S4Vectors)
library(Biobase)
library(SummarizedExperiment)
library(getDEE2)
library(devtools)
library(CellScore)
library(homosapienDEE2CellScore)

## -----------------------------------------------------------------------------
the_data<-downloadAllTheData()

## -----------------------------------------------------------------------------
sm <- the_data$HomosapienDEE2_QC_WARN_Raw
## We could have just run `sm <- homosapienDEE2CellScore::readInSEZip(homosapienDEE2CellScore::HomosapienDEE2_QC_PASS_Raw())`
## instead of downloading all the data.

# Here we want to analyse all of the raw data to calculate the
# on/off score for cell transitions from fibroblast to embryonic stem cells
test1 <- sm[, sm$category == 'test']
standard <- sm[, sm$category == 'standard']
sm1 <- cbind(test1, standard)
cell.change <- data.frame(start=c("FIB"), test=c("nESC"), target=c("ESC"))
group.OnOff <- OnOff(sm1, cell.change, out.put="marker.list")

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

