% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildAll.R
\name{buildRaw}
\alias{buildRaw}
\title{buildRaw gets the raw data in SummarizedExperiment format}
\usage{
buildRaw(
  species = "hsapiens",
  accessions = unique(cols$SRR_accession),
  quiet = TRUE,
  metadata = getDEE2Metadata(species, quiet = quiet)
)
}
\arguments{
\item{species}{The species to fetch data for; default is "hsapiens".}

\item{accessions}{Which sample ids to download from DEE2 (we refer to these as accessions); default is derived from `hsapiens_colData.csv` in this package. For subsets, you can see the internal `cols` objects `SRR_accession` member.}

\item{quiet}{Whether to suppress notification output where possible; default TRUE.}

\item{metadata}{If you have already downloaded metadata for the species, you can pass it in here. Otherwise the metadata will be downloaded.}
}
\value{
Returns a SummarizedExperiment object containing raw data downloaded from dee2.
}
\description{
This function gets the raw Data from dee2 and packages it in a SummarizedExperiment
}
\examples{
# To get a few accessions and package them into a SummarizedExperiment
accessions_of_interest <- buildRaw(accessions=as.list(unique(cols$SRR_accession)[c(1,3)]))
}
