% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gDNAinRNAseqData.R
\docType{package}
\name{gDNAinRNAseqData-package}
\alias{gDNAinRNAseqData-package}
\alias{gDNAinRNAseqData}
\alias{LiYu22subsetBAMfiles}
\alias{LiYu22phenoData}
\title{RNA-seq data with different levels of gDNA contamination}
\usage{
LiYu22subsetBAMfiles(path = tempdir(), offline = FALSE)

LiYu22phenoData(bamfiles)
}
\arguments{
\item{path}{(Default=`tempdir()`) Filesystem path where to store the
BAM files.}

\item{offline}{(Default=`FALSE`) If there is no internet connection, but
the data has been previously downloaded, setting `offline=TRUE` allows one
to retrive the data from the ExperimentHub cache.}

\item{bamfiles}{full filesystem paths to where the BAM files were downloaded
with `LiYu22subsetBAMfiles()`.}
}
\value{
`LiYu22subsetBAMfiles()` returns a string character vector of
filesystem paths to the downloaded BAM files.

`LiYu22phenoData()` returns a `data.frame` object with the gDNA
contamination levels for the BAM files specified in the `bamfiles` parameter,
according to the publication by Li et al. (2022).
}
\description{
This package provides access to RNA-seq BAM files containing different
levels of genomic DNA (gDNA) contamination.\cr\cr
}
\details{
Currently, this package allows one to download a subset of the data
published in:

Li, X., Zhang, P., and Yu. Y. Gene expressed at low levels raise false
discovery rates in RNA samples contaminated with genomic DNA. BMC Genomics,
23:554, 2022.

The subset of the data acccessible through this package corresponds to
BAM files containing about 100,000 alignments sampled uniformly at random
for the RNA-seq experiments produced from total RNA libraries mixed with
different concentrations of gDNA, concretely 0\% (no contamination), 1\% and
10\%; see Fig. 2 from Li et al. (2022).
}
\section{Functions}{
\itemize{
\item \code{LiYu22subsetBAMfiles()}: downloads the BAM files from the
RNA-seq data through the ExperimentHub, and returns the path in the
filesystem where the BAM files are stored.

\item \code{LiYu22phenoData()}: retrieves phenotypic data from the
BAM files downloaded with `LiYu22subsetBAMfiles()`.

}}
\examples{

## for LiYu2subsetBAMfiles()
bamfiles <- LiYu22subsetBAMfiles()
bamfiles


## for LiYu22phenoData()
bamfiles <- LiYu22subsetBAMfiles()
LiYu22phenoData(bamfiles)

}
\references{
Li, X., Zhang, P., and Yu. Y. Gene expressed at low levels raise false
discovery rates in RNA samples contaminated with genomic DNA. BMC Genomics,
23:554, 2022.
}
\keyword{package}
