\name{identifyTimeMinArea}
\alias{identifyTimeMinArea}
\title{Identify Time Point of Tissue Invagination}
\description{
Identifies time point where the cell areas attain a minimum.
}
\usage{
identifyTimeMinArea(x, h=2, px=0.293, plot=FALSE, myCex=1.4)
}
\arguments{
    \item{x}{Feature table.}
    \item{h}{Smoothing bandwidth, passed to locfit.}
    \item{px}{Pixel dimensions in microns (assumed isotropic).}
    \item{plot}{Logical specifying whether or not to plot data and fit.}
    \item{myCex}{Size of axis labels.}
}
\value{
Returns the time at which the tissue invaginates ('tstar') and the index of the
corresponding time point ('tindex').
}
\examples{
if (interactive()) vignette(topic="genPaperFigures", package="furrowSeg")
}
\author{Joseph Barry, 2014}
\keyword{furrow}
