\name{identifyFurrowPosition}
\alias{identifyFurrowPosition}
\title{Identify Furrow Position}
\description{
Identifies furrowing line by identifying DV position of minimum area.
}
\usage{
identifyFurrowPosition(x, nbinsExclude=3, h=100, plot=FALSE, myCex=1.4, w=512, 
    px=0.293)
}
\arguments{
    \item{x}{Feature table.}
    \item{nbinsExclude}{Number of pixel columns to exclude at the DV edges of 
        the image.}
    \item{h}{Smoothing bandwidth, passed to locfit.}
    \item{plot}{Logical specifying whether or not to plot data and fit.}
    \item{myCex}{Size of axis labels.}
    \item{w}{Width of image in number of pixels.}
    \item{px}{Pixel dimensions in microns (assumed isotropic).}
}
\value{The pixel index along DV indicating the furrowing position.}
\examples{
if (interactive()) vignette(topic="genPaperFigures", package="furrowSeg")
}
\author{Joseph Barry, 2014}
\keyword{furrow}
