\name{constructBox}
\alias{constructBox}
\title{Construct Box}
\description{
Calculates dimensions of box for at a given DV position. Ensures that box does 
not exceed dimensions of image.
}
\usage{constructBox(dvPos, Lx=100, Ly=50, w=512, mid=NA)}
\arguments{
    \item{dvPos}{Pixel location along DV of box center.}
    \item{Lx}{Half of box width in pixels.}
    \item{Ly}{Half of box height in pixels.}
    \item{w}{Image width in pixels.}
    \item{mid}{Location of midpoint along AP in pixels. If not specified 
        defaults to half of the image width.}
}
\value{
A vector with locations of box corners. Nonclemature is 'xleft', 'ybottom', 
'xright' and 'ytop'.
}
\examples{
if (interactive()) vignette(topic="genPaperFigures", package="furrowSeg")
}
\author{Joseph Barry, 2014}
\keyword{furrow}
